<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_ss7_ccspans
{
	
	private $error= "";						//Contains validation errors
	public $error_counter="";				//Contains the number of errors in the form
	public $edit="";						//Contains database returned values for editing
	public $profile_name = array();			//Contains the profile names within the database
	public $profile_counter = "";			//Contains the number of profiles in the database
	private $pick="";						//Contains the data for what was returned to the form
	public $channels="";					//Contains the value of the Channel Map
	public $cic;							//Contains the value of cic
	public $isup="";						//Contains the value of the ISUP Interface
	private $db_location="";				//Contains the database location
	private $table_name="";					//Contains the database table name
	public $profile="";						//Contains the profile name
	public $data="";						//Contains the database class
	private $VL = "";						//Contains value whether link is a voice link or not
	public $media = "";						//Contains the media type
	public $min_digits = "";				//Contains the value of min_digits
	public $clg_nadi = "";					//Contains the value of clg_nadi
	public $cld_nadi = "";					//Contains the value of cld_nadi
	public $rdnis_nadi = "";				//Contains the value of rdnis_nadi
	public $lpa = "";						//Contains the value of lpa_on_cot
	public $obci_bita = "";					//Contains the value of obci_bita
	public $typeCntrl = "";					//Contains the value of typeCntrl
	public $group_num = "";					//Contains the SS7 Span Group Number
	public $card_num = "";					//Contains the card number used
	public $num_ports = "";					//Contains the total number of ports on the card used
	public $first_port = "";				//Identifies that this is the first port being worked on. Unset after the first entry in the loop
	public $relay_type = "";				//Contains the relay type
	public $transparent_iam = "";			//Contains the value for transparent iam
	public $itx="";							//Contains the value for itx txa messages
	public $transparent_iam_timeout = "";	//Contains the transparent IAM timeout
	public $cpg_on_progress="";				//Contains the cpg on progress value
	public $cpg_on_progress_media="";		//Contains the cpg on progress media value
	public $t10="";							//Contains the T.10 timer value
	public $t35="";							//Contains the T.35 timer value
	public $span_number="";					//Contains the SS7 Span Number
	
	//Display function
	function display()
	{	
		if ($this->proc_id == 1)
			$this->db_location = "sqlite:../sqlite/cardinfo.db";
		elseif ($this->proc_id > 1)
			$this->db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id  . ".db";

		if ($_SESSION['id_num'] == "") 
			echo "<h3>SS7 Channel Configuration</h3>";		
		
		//echo $_SESSION['cic'];
		
		$this->check_submit();
		
		$this->table_name = "ss7_isup_profile";
		$this->get_profiles();

		//Figures out the group number
		if ($this->group_num == "")
		{	
			$this->group_num = 1 + $_SESSION['group'];
			$_SESSION['group'] = $this->group_num;
		}
		$_SESSION['group'] = $this->group_num;
		
		?>
	
	<form name="create_profile" method="post">
		<p width='700px'>
        	The final step in the SS7 configuration is the Channel Mapping.<br />
            You must enter the appropriate channel mapping as well as the CiC value for that span. You must also select the ISUP Interface that this span will be using.<br />
        </p>

		<br />  		   
        <input type="hidden" name="id_number" value="<?php echo $a; ?>" />
			<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Standard Options</th>
			<tr>
				<td class="mytablesubheader" width='30%'>Profile Name</td>
                <td></td>
                <?php
				if ($this->edit['profile_name'] == "") {
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" /></td>
                <?php
				}
				else
				{
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" disabled="disabled" /></td>
                <?php
				}
				?>
				<td width='30%'><?php echo $this->error['profile_name']; ?></td>
			</tr>   
            <tr>
            	<td class="mytablesubheader" width='30%'>ISUP Interface</td>
                <td></td>
                <td width='40%'>
                <?php
				if ($this->relay_type == "SLAVE")
				{
					echo $this->isup . "\n";
				}
				else
				{
				?>
					<select name="isup">
				<?php
					for ($a = 0; $a < $this->profile_counter; $a++)
					{ 
							$hash = "route-" . $this->profile_name[$a]['profile_name'];
							echo "<option value=\"" . $this->profile_name[$a]['profile_name'] . "\""; if ($this->pick[$hash] == "yes") { ?> selected="selected" <?php } echo " style=\"text-align:left\" >" . $this->profile_name[$a]['profile_name'] . "</option>\n";
					}
				?>
				   </select>
                </td>
                <?php
				}
				?>
                <td width='30%'></td>
            </tr>                       
            <tr>
            	<td class="mytablesubheader" width='30%'>CiC Base</td>
                <td></td>
            	<td width='40%'><input type="text" name="cic" value="<?php echo $this->cic; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['cic']; ?></td>
            </tr>  
		<?php
		//Figures out your channel map
		if ($this->VL == "yes" && $this->channels == "")
		{
			if ($this->media == "T1")
				$this->channels = "1-24";
			elseif ($this->media == "E1")
				$this->channels = "1-31";
		}

		
		?>
        	<tr>
            	<td class="mytablesubheader" width='30%'>Call Control</td>
                <td></td>
                <td width='40%'>
                	<select name="typeCntrl" style="text-align:left">
                        <option value="controlled" <?php if ($this->pick['typeCntrl_controlled'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Controlled</option>
                        <option value="controlling" <?php if ($this->pick['typeCntrl_controlling'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Controlling</option>
                        <option value="bothway" <?php if ($this->pick['typeCntrl_bothway'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Bothway</option>
                        <option value="incoming" <?php if ($this->pick['typeCntrl_incoming'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Incoming</option>
                        <option value="outgoing" <?php if ($this->pick['typeCntrl_outgoing'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Outgoing</option>                  
                    </select>
                </td>
                <td width='30%'></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>Channel Map</td>
                <td></td>                
            	<td width='40%'><input type="text" name="channels" value="<?php echo $this->channels; ?>" style="text-align:left; width:140px" /></td>
                <td width='30%'><?php echo $this->error['channels']; ?></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>Span Group Number</td>
                <td></td>
            	<td width='40%'><input type="text" name="group_num" value="<?php echo $this->group_num; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['group_num']; ?></td>
            </tr>
       </table>
       <br />
		<div class="fakelink"
			id="show_e"
			onclick="this.style.display='none';
			document.getElementById('hide_e').style.display='block';
			document.getElementById('options').style.display='inline';
            ResizeFrame();
			">&raquo; Show Advanced Options</div>
		<div class="fakelink"
			id="hide_e"
			onclick="this.style.display='none';
			document.getElementById('show_e').style.display='block';
			document.getElementById('options').style.display='none';
            ResizeFrame();
			">&raquo; Hide Advanced Options</div>
		<div id="options">
        <br />
       <font color="red">NOTE: The following parameters are optional. You are not required to fill in any of the options below.</font><br /><br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Overlap Dialing Options</th>
            <tr>
            	<td class="mytablesubheader" width='30%'>Minimum Incoming Digits for Overlap Dialing</td>
                <td></td>
            	<td width='40%'><input type="text" name="min_digits" value="<?php echo $this->min_digits; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['min_digits']; ?></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>ISUP T.10 Timer (in seconds)</td>
                <td><a href="http://wiki.sangoma.com/nsg-isup-timers" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'><input type="text" name="t10" value="<?php echo $this->t10; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['t10']; ?></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>ISUP T.35 Timer (in seconds)</td>
                <td><a href="http://wiki.sangoma.com/nsg-isup-timers" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'><input type="text" name="t35" value="<?php echo $this->t35; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['t35']; ?></td>
            </tr>
		</table>
       	<br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Nature of Address Indicator Options</th>
            <tr>
            	<td class="mytablesubheader" width='30%'>Calling NADI Value</td>
                <td><a href="http://wiki.sangoma.com/ftmod-sangoma-ss7-nadi" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'>
                	<select name="clg_nadi" style="text-align:left">
                    	<option value="" style="text-align:left">Not Specified</option>
                        <option value="0" <?php if ($this->pick['clg_nadi_0'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Spare</option>
                        <option value="1" <?php if ($this->pick['clg_nadi_1'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Subscriber Number</option>
                        <option value="2" <?php if ($this->pick['clg_nadi_2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Unknown</option>
                        <option value="3" <?php if ($this->pick['clg_nadi_3'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">National</option>
                        <option value="4" <?php if ($this->pick['clg_nadi_4'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">International</option>                  
                    </select>
                </td>
                <td width='30%'></td>
            </tr>
			<tr>
            	<td class="mytablesubheader" width='30%'>Called NADI Value</td>
                <td><a href="http://wiki.sangoma.com/ftmod-sangoma-ss7-nadi" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'>
                	<select name="cld_nadi" style="text-align:left">
                    	<option value="" style="text-align:left">Not Specified</option>
                        <option value="0" <?php if ($this->pick['cld_nadi_0'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Spare</option>
                        <option value="1" <?php if ($this->pick['cld_nadi_1'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Subscriber Number</option>
                        <option value="2" <?php if ($this->pick['cld_nadi_2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Unknown</option>
                        <option value="3" <?php if ($this->pick['cld_nadi_3'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">National</option>
                        <option value="4" <?php if ($this->pick['cld_nadi_4'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">International</option>                  
                    </select>
                </td>
                <td width='30%'></td>
            </tr>
			<tr>
            	<td class="mytablesubheader" width='30%'>rDNIS NADI Value</td>
                <td><a href="http://wiki.sangoma.com/ftmod-sangoma-ss7-nadi" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'>
                	<select name="rdnis_nadi" style="text-align:left">
                   		<option value="" style="text-align:left">Not Specified</option>
                        <option value="0" <?php if ($this->pick['rdnis_nadi_0'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Spare</option>
                        <option value="1" <?php if ($this->pick['rdnis_nadi_1'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Subscriber Number</option>
                        <option value="2" <?php if ($this->pick['rdnis_nadi_2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Unknown</option>
                        <option value="3" <?php if ($this->pick['rdnis_nadi_3'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">National</option>
                        <option value="4" <?php if ($this->pick['rdnis_nadi_4'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">International</option>                  
                    </select>
                </td>
                <td width='30%'></td>
            </tr> 
		</table>
		<br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">SPIROU Options</th>
            <tr>
            	<td class="mytablesubheader" width='30%'>Transparent IAM</td>
                <td></td>
                <td width='40%'>
                	<select name="transparent_iam">
	                    <option value="enable" <?php if ($this->pick['transparent_iam_enable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enable</option>
                    	<option value="disable" <?php if ($this->pick['transparent_iam_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disable</option>
                    </select>
                </td>
                <td width='30%'></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>Maximum Size for Transparent IAM</td>
                <td></td>
            	<td width='40%'><input type="text" name="transparent_iam_timeout" value="<?php echo $this->transparent_iam_timeout; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['transparent_iam_timeout']; ?></td>            
            </tr>
			<tr>
            	<td class="mytablesubheader" width='30%'>ITX/TXA Auto Reply</td>
                <td></td>
                <td width='40%'>
                	<select name="itx">
	                    <option value="enable" <?php if ($this->pick['itx_enable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enable</option>
                    	<option value="disable" <?php if ($this->pick['itx_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disable</option>
                    </select>
                </td>
                <td width='30%'></td>
            </tr>        
        </table>
        <br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Additional Options</th>   
            <tr>
            	<td class="mytablesubheader" width='30%'>Loop Back Acknowledge COT/CCR Request</td>
                <td></td>
                <td width='40%'>
                	<select name="lpa">
	                    <option value="1" <?php if ($this->pick['lpa_enable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enable</option>
                    	<option value="0" <?php if ($this->pick['lpa_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disable</option>
                    </select>
                </td>
                <td width='30%'></td>
            </tr>                            
            <tr>
            	<td class="mytablesubheader" width='30%'>Optional Backwards Indicators <br />- In-Band Information</td>
                <td><a href="http://wiki.sangoma.com/ftmod-sangoma-ss7-acm-obci-bita" target="_blank"><font color="blue"><b>?</b></font></a></td>
            	<td width='40%'>
                	<select name="obci_bita" style="text-align:left">
                        <option value="" style="text-align:left">Not Specified</option>
                        <option value="1" <?php if ($this->pick['obci_bita_1'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enable</option>                  
                        <option value="0" <?php if ($this->pick['obci_bita_0'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disable</option>
                    </select>
                </td>
                <?php /*<input type="text" name="obci_bita" value="<?php echo $this->obci_bita; ?>" style="text-align:left; width:40px" /></td>*/ ?>
                <td width='30%'><?php echo $this->error['obci_bita']; ?></td>
            </tr>  

            <tr>
            	<td class="mytablesubheader" width='30%'>CPG on Progress</td>
                <td></td>
                <td width='40%'>
                	<select name="cpg_on_progress">
	                    <option value="enable" <?php if ($this->pick['cpg_on_progress_enable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enable</option>
                    	<option value="disable" <?php if ($this->pick['cpg_on_progress_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disable</option>
                    </select>
                </td>
                <td width='30%'></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>CPG on Progress Media</td>
                <td></td>
                <td width='40%'>
                	<select name="cpg_on_progress_media">
	                    <option value="enable" <?php if ($this->pick['cpg_on_progress_media_enable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Enable</option>
                    	<option value="disable" <?php if ($this->pick['cpg_on_progress_media_disable'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Disable</option>
                    </select>
                </td>
                <td width='30%'></td>
            </tr>                        
                                                       
       </table>
        </div>
		<br />
        <table width="100%">
        <tr>
        <?php
        if ($this->relay_type == "SLAVE")
		{
		?>
		<td width="1%"><input type="submit" name="create" disabled="disabled" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Channel Map"; } ?>" <?php echo $_SESSION['disabled_button_class']; ?>/></td>
        <?php
		
			//Find number of ports on card
			$this->find_total_ports($this->data);
			
			//Check how many configured ports there are for the card
			$result = $this->find_configured_ports();
	
			$ports_left = $this->num_ports - $result["count(port_id)"];
		
			if ($this->VL == "yes" && $ports_left >= 2 )
			{
			?>
        <td width="1%"><input type="submit" name="create-all-voice" value="Set all Unconfigured ports as Voice Spans" disabled='disabled' <?php echo $_SESSION['disabled_button_class']; ?> /></td>
        <?php
			}
			elseif ($this->VL == "yes" && $ports_left < 2)
			{
			?>
        <td width="1%"><input type="submit" name="create-all-voice" value="Set all Unconfigured ports as Voice Spans" disabled="disabled" <?php echo $_SESSION['disabled_button_class']; ?> disabled="disabled"/></td>
        <?php
			}			
		}
		else
		{
		?>
		<td width="1%"><input type="submit" name="create" value="Create Channel Map" <?php echo $_SESSION['button_class']; ?>/></td>
        <?php
		
			//Find number of ports on card
			$this->find_total_ports($this->data);
			
			//Check how many configured ports there are for the card
			$result = $this->find_configured_ports();
	
			//echo $result;
	
			$ports_left = $this->num_ports - $result;		
				//echo "number of ports = " . $this->num_ports . " ports left = " . $ports_left . ", result portid count = " . $result . "<br />";
			if ($this->VL == "yes" && $ports_left >= 2 )
			{
			?>
        <td width="1%"><input type="submit" name="create-all-voice" value="Set all Unconfigured ports as Voice Spans" <?php echo $_SESSION['button_class']; ?> /></td>
        <?php
			}
			elseif ($this->VL == "yes" && $ports_left <= 2)
			{
			?>
        <td width="1%"><input type="submit" name="create-all-voice" value="Set all Unconfigured ports as Voice Spans" <?php echo $_SESSION['disabled_button_class']; ?> disabled="disabled"/></td>
        <?php
			}
		}
		?>
		<td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>         
	<?php
	}	
	
	//Check number of ports configured on card
	function find_configured_ports()
	{
		//Check if the line exists
		if ($this->proc_id == 1)
			$db_location = "sqlite:../sqlite/cardinfo.db";
		elseif ($this->proc_id > 1)
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id  . ".db";

		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_ccspans";
						
		//Check if the link is being used for m2ua of mg
		$mg_chan = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_channels";
		$m2ua = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";
			
		if ($this->data->check_for_table($db_location,$m2ua) > 1) {
			$m2ua_link = $this->data->select_statement($db_location,$m2ua,'count(link_name)','');
			
			if ($m2ua_link['count(link_name)'] != "")
				$link_count = $m2ua_link['count(link_name)']; 
		}
		
		if ($this->data->check_for_table($db_location,$mg_chan) > 1) {
			$chans = $this->data->select_statement($db_location,$mg_chan, 'count(profile_name)','');

			if ($chans['count(profile_name)'] != "")
				$chan_count = $chans['count(profile_name)']; 						
		}
		
		$check = $this->data->check_for_table($db_location,$table_name);
		if ($check > 1)
		{
			$param = "count(port_id)";
			$where_param = "";
			$result = $this->data->select_statement ($db_location, $table_name, $param, $where_param);
		}
		
		/*echo "Total ccspans = " . $result['count(port_id)'] . "<br />
				Total m2ua chans = $chan_count<br />
				Total m2ua links = $link_count<br />";
		*/
		
		$total = $result['count(port_id)'] + $chan_count + $link_count;
		
		return $total;
	}
	
	
	//Validates the Form
	public function validation($update=false)
	{
		
		//Grab the profile name and make sure there isn't a profile already in the database
		//Only to occur if you are making a new profile
		if ($_SESSION['id_num'] == 0 && !$update)
		{	
			$this->table_name = "ss7_route_profile";
			$this->get_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}			
			$this->table_name = "ss7_linkset_profile";
			$this->get_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}	
			$this->table_name = "ss7_isup_profile";
			$this->get_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}							
		}
		
		//Makes sure the user enters a profile name
		if (!$update) {
			if ($_REQUEST['profile_name'] == "")
			{
				$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
				$this->error_counter++;
			}		
		}
		if ($_REQUEST['channels'] == "")
		{
			$this->error['channels'] = "<font color=\"red\">Please Enter a <b>Channel Map</b></font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['group_num'] == "")
		{
			$this->error['group_num'] = "<font color=\"red\">Please Enter a <b>Group Number</b></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['group_num']))
		{
			$this->error['group_num'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Group Number</b></font>";
			$this->error_counter++;
		}
				
				
		if ($_REQUEST['cic'] == "")
		{
			$this->error['cic'] = "<font color=\"red\">Please Enter a <b>CiC Base</b></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['cic']))
		{
			$this->error['cic'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>CiC Base</b></font>";
			$this->error_counter++;
		}
		
		if (!is_numeric($_REQUEST['min_digits']) && $_REQUEST['min_digits'] != "")
		{
			$this->error['min_digits'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Minimum Digits</b></font>";
			$this->error_counter++;
		}
		
		if (!is_numeric($_REQUEST['transparent_iam_timeout']))
		{
			$this->error['transparent_iam_timeout'] = "<font color='red'>Please Enter a <b>NUMERIC</b> value for the <b>Transparent IAM Timeout</b></font>";
			$this->error_counter++;
		}
		
		//T.10 timer validation
		if (!is_numeric($_REQUEST['t10']))
		{
			$this->error['t10'] = "<font color='red'>Please Enter a <b>NUMERIC</b> value for the <b>T.10 timer</b></font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['t10'] < 4 || $_REQUEST['t10'] > 6)
		{
			$this->error['t10'] = "<font color='red'>The <b>T.10 timer</b> must be between 4 and 6 seconds</font>";
			$this->error_counter++;
		}
		
		//T.35 timer validation
		if (!is_numeric($_REQUEST['t35']))
		{
			$this->error['t35'] = "<font color='red'>Please Enter a <b>NUMERIC</b> value for the <b>T.35 timer</b></font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['t35'] < 15 || $_REQUEST['t35'] > 20)
		{
			$this->error['t35'] = "<font color='red'>The <b>T.35 timer</b> must be between 15 and 20 seconds</font>";
			$this->error_counter++;
		}
		
	}	
	
	
	//Retrieves all the SS7 route/linkset Profile Names
	function get_profiles()
	{
		$a = 0;
		$relay_type =$this->data->select_statement('sqlite:../sqlite/relay_info.db', 'ss7_relay', "machine_type, relay_type", $where);
		
		//GET ALL PROFILES FROM ALL DATABASES
		if ($relay_type['machine_type'] == "standalone" || $relay_type['relay_type'] == "SLAVE")
			$count_hosts['count(id)'] = 1;
		else
			$count_hosts = $this->data->select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)',"");
		
		for ($b = 1; $b <= $count_hosts['count(id)']; $b++)
		{
			if ($b == 1)
				$this->db_location = "sqlite:../sqlite/cardinfo.db";	
			elseif ($b > 1)
				$this->db_location = "sqlite:../sqlite/cardinfo" . $b . ".db";

			$select = "SELECT profile_name FROM " . $this->table_name . ";";
			$data = new database_class;
			
			$table = $data->check_for_table($this->db_location,$this->table_name);
			if ($table >1 )
			{
				try
				{
					//open the database
					$db = new PDO($this->db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						$this->profile_name[$a] = $row;
						$a++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					print 'Exception : '.$e->getMessage();
				}
			}
		}
		
		$link = $this->data->select_statement($this->db_location,$_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . '_SS7_link','span','port_id = ' . $_SESSION['port_num_clicked']);
		
		$this->span_number = $link['span'];
		$this->profile_counter = $a;
	}	

	function get_link_info()
	{
		if ($this->proc_id == 1)
			$db_location = "sqlite:../sqlite/cardinfo.db";
		elseif ($this->proc_id > 1)
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id  . ".db";

		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
		
		$param = "voice, line_type, sig_channel, span";
		$where_param = "port_id = " . $_SESSION['port_num_clicked'];
		
		//Grab the information for that port
		$value = $this->data->select_statement ($db_location, $table_name, $param, $where_param);
		
		if ($value['voice'] != "")
			$this->VL = "yes";

		$this->media = $value['line_type'];
		$this->sig_channel = $value['sig_channel'];
	}

	//Function to return the proper values when entering the page
	function check_submit()
	{

		$this->table_name = "ss7_isup_profile";
		$this->get_profiles();

		for ($a = 0; $a < $this->profile_counter; $a++)
		{
			$hash = "route-" . $this->profile_name[$a]['profile_name'];
			//echo $_REQUEST['route'] . " AND " . $this->profile_name[$a]['profile_name'] . "<br />";
			//echo "hash = $hash<br />";
			
			if ($_REQUEST['isup'] == $this->profile_name[$a]['profile_name'])
				$this->pick[$hash] = "yes";
			elseif ($this->edit['isup'] == $this->profile_name[$a]['profile_name'])
				$this->pick[$hash] = "yes";
		}
		
		if ($_REQUEST['typeCntrl'] == "controlled")
			$this->pick['typeCntrl_controlled'] = "yes";
		elseif ($_REQUEST['typeCntrl'] == "controlling")
			$this->pick['typeCntrl_controlling'] = "yes";
		elseif ($_REQUEST['typeCntrl'] == "bothway")
			$this->pick['typeCntrl_bothway'] = "yes";
		elseif ($_REQUEST['typeCntrl'] == "incoming")
			$this->pick['typeCntrl_incoming'] = "yes";
		elseif ($_REQUEST['typeCntrl'] == "outgoing")
			$this->pick['typeCntrl_outgoing'] = "yes";
		elseif ($this->edit['typeCntrl'] == "controlled")
			$this->pick['typeCntrl_controlled'] = "yes";
		elseif ($this->edit['typeCntrl'] == "controlling")
			$this->pick['typeCntrl_controlling'] = "yes";
		elseif ($this->edit['typeCntrl'] == "bothway")
			$this->pick['typeCntrl_bothway'] = "yes";
		elseif ($this->edit['typeCntrl'] == "incoming")
			$this->pick['typeCntrl_incoming'] = "yes";
		elseif ($this->edit['typeCntrl'] == "outgoing")
			$this->pick['typeCntrl_outgoing'] = "yes";	
	
		if ($_REQUEST['obci_bita'] == "disable")
			$this->pick['obci_bita_0'] = "yes";
		elseif ($_REQUEST['obci_bita'] == "enable")
			$this->pick['obci_bita_1'] = "yes";
		elseif ($this->edit['obci_bita'] == "disable")
			$this->pick['obci_bita_0'] = "yes";
		elseif ($this->edit['obci_bita'] == "enable")
			$this->pick['obci_bita_1'] = "yes";
	
		if ($_REQUEST['clg_nadi'] == "0")
			$this->pick['clg_nadi_0'] = "yes";
		elseif ($_REQUEST['clg_nadi'] == "1")
			$this->pick['clg_nadi_1'] = "yes";
		elseif ($_REQUEST['clg_nadi'] == "2")
			$this->pick['clg_nadi_2'] = "yes";
		elseif ($_REQUEST['clg_nadi'] == "3")
			$this->pick['clg_nadi_3'] = "yes";
		elseif ($_REQUEST['clg_nadi'] == "4")
			$this->pick['clg_nadi_4'] = "yes";
		elseif ($this->edit['clg_nadi'] == "0")
			$this->pick['clg_nadi_0'] = "yes";
		elseif ($this->edit['clg_nadi'] == "1")
			$this->pick['clg_nadi_1'] = "yes";
		elseif ($this->edit['clg_nadi'] == "2")
			$this->pick['clg_nadi_2'] = "yes";
		elseif ($this->edit['clg_nadi'] == "3")
			$this->pick['clg_nadi_3'] = "yes";
		elseif ($this->edit['clg_nadi'] == "4")
			$this->pick['clg_nadi_4'] = "yes";
		
		if ($_REQUEST['cld_nadi'] == "0")
			$this->pick['cld_nadi_0'] = "yes";
		elseif ($_REQUEST['cld_nadi'] == "1")
			$this->pick['cld_nadi_1'] = "yes";
		elseif ($_REQUEST['cld_nadi'] == "2")
			$this->pick['cld_nadi_2'] = "yes";
		elseif ($_REQUEST['cld_nadi'] == "3")
			$this->pick['cld_nadi_3'] = "yes";
		elseif ($_REQUEST['cld_nadi'] == "4")
			$this->pick['cld_nadi_4'] = "yes";
		elseif ($this->edit['cld_nadi'] == "0")
			$this->pick['cld_nadi_0'] = "yes";
		elseif ($this->edit['cld_nadi'] == "1")
			$this->pick['cld_nadi_1'] = "yes";
		elseif ($this->edit['cld_nadi'] == "2")
			$this->pick['cld_nadi_2'] = "yes";
		elseif ($this->edit['cld_nadi'] == "3")
			$this->pick['cld_nadi_3'] = "yes";
		elseif ($this->edit['cld_nadi'] == "4")
			$this->pick['cld_nadi_4'] = "yes";
		
		if ($_REQUEST['rdnis_nadi'] == "0")
			$this->pick['rdnis_nadi_0'] = "yes";
		elseif ($_REQUEST['rdnis_nadi'] == "1")
			$this->pick['rdnis_nadi_1'] = "yes";
		elseif ($_REQUEST['rdnis_nadi'] == "2")
			$this->pick['rdnis_nadi_2'] = "yes";
		elseif ($_REQUEST['rdnis_nadi'] == "3")
			$this->pick['rdnis_nadi_3'] = "yes";
		elseif ($_REQUEST['rdnis_nadi'] == "4")
			$this->pick['rdnis_nadi_4'] = "yes";
		elseif ($this->edit['rdnis_nadi'] == "0")
			$this->pick['rdnis_nadi_0'] = "yes";
		elseif ($this->edit['rdnis_nadi'] == "1")
			$this->pick['rdnis_nadi_1'] = "yes";

		elseif ($this->edit['rdnis_nadi'] == "2")
			$this->pick['rdnis_nadi_2'] = "yes";
		elseif ($this->edit['rdnis_nadi'] == "3")
			$this->pick['rdnis_nadi_3'] = "yes";
		elseif ($this->edit['rdnis_nadi'] == "4")
			$this->pick['rdnis_nadi_4'] = "yes";	
	
		if ($_REQUEST['lpa'] == "" && $this->edit['lpa'] == "")
			$this->pick['lpa_disable'] = "yes";
		elseif ($_REQUEST['lpa'] == "1")
			$this->pick['lpa_enable'] = "yes";
		elseif ($_REQUEST['lpa'] == "0")
			$this->pick['lpa_disable'] = "yes";
		elseif ($this->edit['lpa'] == "1")
			$this->pick['lpa_enable'] = "yes";
		elseif ($this->edit['lpa'] == "0")
			$this->pick['lpa_disable'] = "yes";		

		if ($_REQUEST['itx'] == "" && $this->edit['itx'] == "")
			$this->pick['itx_disable'] = "yes";
		elseif ($_REQUEST['itx'] == "enable")
			$this->pick['itx_enable'] = "yes";
		elseif ($_REQUEST['itx'] == "disable")
			$this->pick['itx_disable'] = "yes";
		elseif ($this->edit['itx'] == "enable")
			$this->pick['itx_enable'] = "yes";
		elseif ($this->edit['itx'] == "disable")
			$this->pick['itx_disable'] = "yes";
		
		if ($_REQUEST['transparent_iam'] == "" && $this->edit['transparent_iam'] == "")
			$this->pick['transparent_iam_disable'] = "yes";
		elseif ($_REQUEST['transparent_iam'] == "enable")
			$this->pick['transparent_iam_enable'] = "yes";
		elseif ($_REQUEST['transparent_iam'] == "disable")
			$this->pick['transparent_iam_disable'] = "yes";
		elseif ($this->edit['transparent_iam'] == "enable")
			$this->pick['transparent_iam_enable'] = "yes";
		elseif ($this->edit['transparent_iam'] == "disable")
			$this->pick['transparent_iam_disable'] = "yes";

		if ($_REQUEST['cpg_on_progress'] == "" && $this->edit['cpg_on_progress'] == "")
			$this->pick['cpg_on_progress_disable'] = "yes";
		elseif ($_REQUEST['cpg_on_progress'] == "enable")
			$this->pick['cpg_on_progress_enable'] = "yes";
		elseif ($_REQUEST['cpg_on_progress'] == "disable")
			$this->pick['cpg_on_progress_disable'] = "yes";
		elseif ($this->edit['cpg_on_progress'] == "enable")
			$this->pick['cpg_on_progress_enable'] = "yes";
		elseif ($this->edit['cpg_on_progress'] == "disable")
			$this->pick['cpg_on_progress_disable'] = "yes";
		
		if ($_REQUEST['cpg_on_progress_media'] == "" && $this->edit['cpg_on_progress_media'] == "")
			$this->pick['cpg_on_progress_media_enable'] = "yes";
		elseif ($_REQUEST['cpg_on_progress_media'] == "enable")
			$this->pick['cpg_on_progress_media_enable'] = "yes";
		elseif ($_REQUEST['cpg_on_progress_media'] == "disable")
			$this->pick['cpg_on_progress_media_disable'] = "yes";
		elseif ($this->edit['cpg_on_progress_media'] == "enable")
			$this->pick['cpg_on_progress_media_enable'] = "yes";
		elseif ($this->edit['cpg_on_progress_media'] == "disable")
			$this->pick['cpg_on_progress_media_disable'] = "yes";
		
		if ($_REQUEST['transparent_iam_timeout'] == "" && $this->edit['transparent_iam_timeout'] == "")
			$this->transparent_iam_timeout = 800;

		if ($_REQUEST['t10'] == "" && $this->edit['t10'] == "")
			$this->t10 = 5;
		
		if ($_REQUEST['t35'] == "" && $this->edit['t35'] == "")
			$this->t35 = 17;
		
		
		//$this->pick['profile_name'] = "CC" . $_SESSION['card_num'] . '-' . $_SESSION['port_num_clicked'];
		if ($_REQUEST['profile_name'] != "")
			$this->pick['profile_name'] = $_REQUEST['profile_name'];
		elseif ($this->edit['profile_name'] != "")
			$this->pick['profile_name'] = $this->edit['profile_name'];
		else	
			$this->pick['profile_name'] = "CC" . $this->span_number;
	}
	
	//Creates the channel map
	function channel_map_create()
	{
		if ($this->media == "T1")
			$last_chan = "24";
		elseif ($this->media == "E1")
			$last_chan = "31";
		
		if ($this->sig_channel == 1)
			$this->channels = "s1,2-" . $last_chan;
		elseif ($this->sig_channel == 2)
			$this->channels = "1,s2,3-" . $last_chan;
		elseif ($this->media == "T1" && $this->sig_channel == 24) {
			$previous_chan = $last_chan -1;
			$this->channels = "1-" . $previous_chan . ",s" . $last_chan;
		}
		elseif ($this->media == "T1" && $this->sig_channel == 23){
			$previous_chan = $this->sig_channel -1;
			$this->channels = "1-" . $previous_chan . ",s" . $this->sig_channel . ",24";
		}
		elseif ($this->media == "E1" && $this->sig_channel == 31){
			$previous_chan = $last_chan -1;
			$this->channels = "1-" . $previous_chan . ",s" . $last_chan;
		}
		elseif ($this->media == "E1" && $this->sig_channel == 30){
			$previous_chan = $this->sig_channel -1;
			$this->channels = "1-" . $previous_chan . ",s" . $this->sig_channel . ",31";			
		}
		elseif ($this->sig_channel == "")
			$this->channels = "1-" . $last_chan;
		else
		{
			$previous_chan = $this->sig_channel -1;
			$next_chan = $this->sig_channel + 1;
			
			$this->channels = "1-" . $previous_chan . ",s" . $this->sig_channel . "," . $next_chan . "-" . $last_chan;
		}
	}
	
	function find_total_ports($data)
	{
		if ($this->proc_id == 1)
			$db_location = "sqlite:../sqlite/cardinfo.db";
		elseif ($this->proc_id > 1)
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id  . ".db";

		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "card_present";
		$param = "num_ports";
		$where_param = "id = ". $this->card_num;
		$return = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->num_ports = $return['num_ports'];		
	}
	
	function database_insert($data, $port, $span = 1)
	{
		//Check if the line exists
		if ($this->proc_id == 1)
			$db_location = "sqlite:../sqlite/cardinfo.db";
		elseif ($this->proc_id > 1)
			$db_location = "sqlite:../sqlite/cardinfo" . $this->proc_id  . ".db";

		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_ccspans";
		
		$check = $this->data->check_for_table($db_location,$table_name);
		if ($check > 1)
		{
			$param = "port_id";
			$where_param = "port_id = " . $port;
			$result = $data->select_statement ($db_location, $table_name, $param, $where_param);
						
			if ($result['port_id'] == "")
			{
				//echo "First time = " . $this->first_port . " ccspan cic = " . $ss7_ccspans->cic . "<br />";
				//Do not increment the CiC when on the first port
				if ($this->first_port == "yes")
					$cic = $_REQUEST['cic'];
				else
				{
					//echo "$port = yes<br />CIC = " . $_SESSION['cic'] . "<br />";
					//echo $this->media . "<br />";
					if ($this->media == "E1")
						$cic = $_SESSION['cic'] + 32;
					elseif ($this->media == "T1")
						$cic = $_SESSION['cic'] + 24;
				}			
				//Line doesn't exist, insert it
				$insert_param = "port_id, profile_name, isup, cic, channels, min_digits, clg_nadi, cld_nadi, rdnis_nadi, obci_bita, typeCntrl, group_num, lpa, transparent_iam, itx, transparent_iam_timeout, cpg_on_progress, cpg_on_progress_media, t10, t35";
				$insert_values = $port . ", \"CC" . $span  . "\", \"" . $_REQUEST['isup'] . "\", \"" . $cic . "\", \"" . $_REQUEST['channels'] . "\", \"" . $_REQUEST['min_digits'] . "\", \"" . $_REQUEST['clg_nadi'] . "\", \"" . $_REQUEST['cld_nadi'] . "\", \"" . $_REQUEST['rdnis_nadi'] . "\", \"" . $_REQUEST['obci_bita'] . "\", \"" . $_REQUEST['typeCntrl'] . "\", \"" . $_REQUEST['group_num'] . "\", \"" . $_REQUEST['lpa'] . "\", \"" . $_REQUEST['transparent_iam'] . "\", \"" . $_REQUEST['itx'] . "\", \"" . $_REQUEST['transparent_iam_timeout'] . "\", \"" . $_REQUEST['cpg_on_progress'] . "\", \"" . $_REQUEST['cpg_on_progress_media'] . "\", " . $_REQUEST['t10'] . ", " . $_REQUEST['t35'];
			
				$data->insert_statement($db_location, $table_name, $insert_param, $insert_values);	
				$_SESSION['cic'] = $cic;
				$this->first_port = "no";
			}
		}
	}
	
	function span_calc($a)
	{
		if ($_SESSION['port_num_clicked'] == $a)
			$span = $_SESSION['ss7_span'];
		elseif ($a == 1)
			$span = $_SESSION['new_ss7_span'] - ($_SESSION['port_num_clicked'] -$a);
		elseif ($_SESSION['port_num_clicked'] > $a)
		{
			//Span number needs to be adjusted
			$span = $_SESSION['ss7_span'] - ($_SESSION['port_num_clicked'] -$a);
		}
		elseif ($_SESSION['port_num_clicked'] < $a)
			$span = $_SESSION['new_ss7_span'] +1 ;
		
		$_SESSION['new_ss7_span'] = $span;
		
		return $span;
	}
}
