<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Class Includes
	include "ss7_link_config_class.php";
	include "../database_classes.php";
	
	//Class Constructors
	$ss7_link= new ss7_link_class;
	$ss7_link->data = new database_class;
	
	//SQLite information
	$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
	$ss7_link->untoken_card_name = $_SESSION['card_clicked'];
	$ss7_link->proc_id = $_SESSION['proc_id'];
	
	//echo $ss7_link->proc_id . "<br />";
	
	//Database related variables
	if ($ss7_link->proc_id == 1)
	{
		$ss7_link->db_location = "sqlite:../sqlite/cardinfo.db";	
	}
	elseif ($ss7_link->proc_id > 1)
	{
		$ss7_link->db_location = "sqlite:../sqlite/cardinfo" . $ss7_link->proc_id . ".db";
	}	
	$table_exist = $ss7_link->data->check_for_table('sqlite:../sqlite/relay_info.db',"ss7_relay");
	if ($table_exist > 1)
	{
		$relay = $ss7_link->data->select_statement('sqlite:../sqlite/relay_info.db',"ss7_relay","relay_type","id = 1");
		$ss7_link->relay_type = $relay['relay_type'];
	}
		
	//$ss7_link->db_location = "sqlite:../sqlite/cardinfo.db";
	
	//echo $ss7_link->db_location . "<br />";
	
	//Gets the number of ports for this card from the card_present table
	$where_param = "id = " . $_SESSION['card_num'];
	$return = $ss7_link->data->select_statement ($ss7_link->db_location, "card_present", "num_ports", $where_param);
	$ss7_link->total_ports = $return[0];
	$ss7_link->span = $_SESSION['ss7_span'];
	
	$cardtable = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
	$where = "port_id = " . $_SESSION['port_num_clicked'];
	$cardlinetype = $ss7_link->data->select_statement ($ss7_link->db_location, $cardtable, "line_type", $where);	
	$ss7_link->line_type = $cardlinetype['line_type'];
	//$ss7_link->line_type = $_SESSION['ss7_line'];
	
	//Check the database. If the database exists, use that information to display
	$table_exists = $ss7_link->data->check_for_table ($ss7_link->db_location, $table_name);
	
	if ($table_exists > 1)
	{
			//Check if the table needs to be upgraded
			$parameters = "port_id int primary key, link_name varchar(60), span int, sig_channel int, error_type varchar(30), lssu int, priority int, switchtype varchar(30), SSF varchar(30), SLC int, link_type varchar(30), line_type varchar(10), linkset varchar(60), voice varchar(10)";
			$insert_parameters = "port_id, link_name, span, sig_channel, error_type, lssu, priority, switchtype, SSF, SLC, link_type, line_type";
			//$ss7_link->data->check_schema($ss7_link->db_location, $table_name, $parameters, "12", $insert_parameters);	
		
		
		$param = "port_id, link_name, span, sig_channel, error_type, lssu, priority, switchtype, SSF, SLC, link_type, line_type";
		$where_param = "port_id = " . $_SESSION['port_num_clicked'];
		
		//Grab the information for that port
		$ss7_link->database = $ss7_link->data->select_statement ($ss7_link->db_location, $table_name, $param, $where_param);
		
		if ($_SESSION['isup_term_sig_link']) {
			$_REQUEST['sigandvoice'] = "YES";
			$_SESSION['isup_term_sig_link'] = false;
		}
		if ($_SESSION['isup_term_voice_link']) {
			$_REQUEST['voice'] = "NO";
			$_SESSION['isup_term_voice_link'] = false;
		}
			
		if ($ss7_link->database['link_name'] != "" && $_REQUEST['sigandvoice'] == "")
		{
			//Place them within the class
			$ss7_link->link_name = $ss7_link->database['link_name'];
			$ss7_link->span = $ss7_link->database['span'];
			$ss7_link->sig_channel = $ss7_link->database['sig_channel'];
			$ss7_link->error_type = $ss7_link->database['sig_channel'];
			$ss7_link->lssu = $ss7_link->database['lssu'];
			$ss7_link->priority = $ss7_link->database['priority'];
			$ss7_link->switchtype = $ss7_link->database['switchtype'];
			$ss7_link->SSF = $ss7_link->database['SSF'];
			$ss7_link->SLC = $ss7_link->database['SLC'];
			$ss7_link->link_type = $ss7_link->database['link_type'];
		}

		if ($ss7_link->database['sig_channel'] != "")
		{
			$ss7_link->skip = "yes";
		}
	}
	
	//if the form is submitted, populate the values of the form in the class
	if ($_REQUEST['apply'] == "Apply to Port" || $_REQUEST['voice'] == "NO" || 	$_SESSION['isup_term_voice_link'])
	{
		//Populate class variables
		$ss7_link->link_name = $_REQUEST['link_name'];
		//$ss7_link->span = $_REQUEST['span'];
		$ss7_link->sig_channel = $_REQUEST['sig_channel'];
		$ss7_link->error_type = $_REQUEST['error_type'];
		$ss7_link->lssu = $_REQUEST['lssu'];
		$ss7_link->priority = $_REQUEST['priority'];
		$ss7_link->switchtype = $_REQUEST['switchtype'];
		$ss7_link->SSF = $_REQUEST['ssf'];
		$ss7_link->SLC = $_REQUEST['slc'];
		$ss7_link->link_type = $_REQUEST['link_type'];
		
		if ($_REQUEST['apply'] == "Apply to Port")
		{
		}
		elseif ($_REQUEST['voice'] == "NO" || $_SESSION['isup_term_voice_link'])
		{
			$voice="yes";
			$ss7_link->link_name = "";
			//$ss7_link->span = $_REQUEST['span'];
			$ss7_link->sig_channel = "";
			$ss7_link->error_type = "";
			$ss7_link->lssu = "";
			$ss7_link->priority = "";
			$ss7_link->switchtype = "";
			$ss7_link->SSF = "";
			$ss7_link->SLC = "";
			$ss7_link->link_type = "";		
		}
		
		//Validate Information from the form
		$ss7_link->validate();
		
		if ($ss7_link->error_count != 0)
		{
			$_SESSION['skip'] = "yes";
		}
		if ($ss7_link->error_count == 0 || $_REQUEST['voice'] == "NO" || $_SESSION['isup_term_voice_link'])
		{
			unset($_SESSION['skip']);
			//Check if the database needs to be created		
			if ($table_exists < 2)
			{
	
				$param = "port_id int primary key, link_name varchar(60), span int, sig_channel int, error_type varchar(30), lssu int, priority int, switchtype varchar(30), SSF varchar(30), SLC int, link_type varchar(30), line_type varchar(10), linkset varchar(60), voice varchar(10)";
				$ss7_link->data->create_table($ss7_link->db_location, $table_name, $param);
			}
			//echo "table = $table_exists voice = $voice<br />";
			//Place in database
			if ($table_exists > 1)
			{
				//Check if the line exists
				$param = "port_id, voice";
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				$result = $ss7_link->data->select_statement ($ss7_link->db_location, $table_name, $param, $where_param);
				
				if ($result['port_id'] != "")
				{
					//update
					if ($voice == "yes")
					{
						//User changed to a voice link from a signalling link, or they just re-chose to use a voice link
						$ss7_link->data->delete_generic($ss7_link->db_location, $table_name, $where_param);
						//$parameters = "port_id = \"" .  $_SESSION['port_num_clicked'] . "\", link_name = \"" . $ss7_link->link_name . "\", span = " . $ss7_link->span . ", line_type = \"" . $ss7_link->line_type . "\", voice = \"" . $voice . "\"";
						$parameters = "port_id, link_name, span, line_type, voice";
						$values = $_SESSION['port_num_clicked'] . ", \"VL" . $ss7_link->span . "\", " . $ss7_link->span . ", \"" . $ss7_link->line_type . "\", \"" . $voice . "\"";		
						$ss7_link->data->insert_statement($ss7_link->db_location, $table_name, $parameters, $values);	
						
						//drop ccspans entry for this link
						$ccspan_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_ccspans";
						$ccspan_where = "port_id = " . $_SESSION['port_num_clicked'];
						$ss7_link->data->delete_generic($ss7_link->db_location, $ccspan_table, $ccspan_where);		
					}
					else
					{
						if ($result['voice'] == "" && $voice == "")
						{	
							///echo "wrong place <br />";
							//User is sticking with a signalling link
							$parameters = "span = " . $ss7_link->span . ", sig_channel = " . $ss7_link->sig_channel . ", error_type = \"" . $ss7_link->error_type . "\", lssu = " . $ss7_link->lssu . ", priority = " . $ss7_link->priority . ", switchtype = \"" . $ss7_link->switchtype . "\", SSF = \"" . $ss7_link->SSF . "\", SLC = " . $ss7_link->SLC . ", link_type = \"" . $ss7_link->link_type . "\", line_type = \"" . $ss7_link->line_type . "\", voice = \"" . $voice . "\"";
							$where_param = "port_id = " . $_SESSION['port_num_clicked'];
							$ss7_link->data->update_table ($ss7_link->db_location, $table_name, $parameters, $where_param);						
						}
						elseif ($result['voice'] != "" && $voice == "")
						{
							//echo "i am here<br />";
							//User is switching to a signalling link to a voice link
							$parameters = "span = " . $ss7_link->span . ", sig_channel = " . $ss7_link->sig_channel . ", error_type = \"" . $ss7_link->error_type . "\", lssu = " . $ss7_link->lssu . ", priority = " . $ss7_link->priority . ", switchtype = \"" . $ss7_link->switchtype . "\", SSF = \"" . $ss7_link->SSF . "\", SLC = " . $ss7_link->SLC . ", link_type = \"" . $ss7_link->link_type . "\", line_type = \"" . $ss7_link->line_type . "\", voice = \"" . $voice . "\"";
							$where_param = "port_id = " . $_SESSION['port_num_clicked'];
							$ss7_link->data->update_table ($ss7_link->db_location, $table_name, $parameters, $where_param);	
													
							//drop ccspans entry for this link
							$ccspan_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_ccspans";
							$ccspan_where = "port_id = " . $_SESSION['port_num_clicked'];
							$ss7_link->data->delete_generic($ss7_link->db_location, $ccspan_table, $ccspan_where);										

						}
						elseif ($voice == "yes")
						{
							//User chose a voice link
							$ss7_link->data->delete_generic($ss7_link->db_location, $table_name, $where_param);
							//$parameters = "port_id = \"" .  $_SESSION['port_num_clicked'] . "\", link_name = \"" . $ss7_link->link_name . "\", span = " . $ss7_link->span . ", line_type = \"" . $ss7_link->line_type . "\", voice = \"" . $voice . "\"";
							$parameters = "port_id, link_name, span, line_type, voice";
							$values = $_SESSION['port_num_clicked'] . ", \"VL" . $ss7_link->span . "\", " . $ss7_link->span . ", \"" . $ss7_link->line_type . "\", \"" . $voice . "\"";		
							$ss7_link->data->insert_statement($ss7_link->db_location, $table_name, $parameters, $values);	
						}
					}
				}
				else
				{
					if ($voice == "yes")
					{
						$ss7_link->data->delete_generic($ss7_link->db_location, $table_name, $where_param);
						$parameters = "port_id, link_name, span, line_type, voice";
						$values = $_SESSION['port_num_clicked'] . ", \"VL" . $ss7_link->span . "\", " . $ss7_link->span . ", \"" . $ss7_link->line_type . "\", \"" . $voice . "\"";
					}
					else
					{
						$parameters = "port_id, link_name, span, sig_channel, error_type, lssu, priority, switchtype, SSF, SLC, link_type, line_type, voice";
						$values = $_SESSION['port_num_clicked'] . ", \"" . $ss7_link->link_name . "\", " . $ss7_link->span . ", " . $ss7_link->sig_channel . ", \"" . $ss7_link->error_type . "\", " . $ss7_link->lssu . ", " . $ss7_link->priority . ", \"" . $ss7_link->switchtype . "\", \"" . $ss7_link->SSF . "\", " . $ss7_link->SLC . ", \"" . $ss7_link->link_type . "\", \"" . $ss7_link->line_type . "\", \"" . $voice . "\"";			
					}
					$ss7_link->data->insert_statement($ss7_link->db_location, $table_name, $parameters, $values);
				}
			}
			//Table does not exist
			elseif ($table_exists < 2)
			{
				//insert
				if ($voice == "yes")
				{
					$ss7_link->data->delete_generic($ss7_link->db_location, $table_name, $where_param);
					$parameters = "port_id, link_name, span, line_type, voice";
					$values = $_SESSION['port_num_clicked'] . ", \"VL" . $ss7_link->span . "\", " . $ss7_link->span . ", \"" . $ss7_link->line_type . "\", \"" . $voice . "\"";
				}
				else
				{
					$parameters = "port_id, link_name, span, sig_channel, error_type, lssu, priority, switchtype, SSF, SLC, link_type, line_type, voice";
					$values = $_SESSION['port_num_clicked'] . ", \"" . $ss7_link->link_name . "\", " . $ss7_link->span . ", " . $ss7_link->sig_channel . ", \"" . $ss7_link->error_type . "\", " . $ss7_link->lssu . ", " . $ss7_link->priority . ", \"" . $ss7_link->switchtype . "\", \"" . $ss7_link->SSF . "\", " . $ss7_link->SLC . ", \"" . $ss7_link->link_type . "\", \"" . $ss7_link->line_type . "\", \"" . $voice . "\"";			
				}
							
				if ($voice == "yes")
					unset ($_REQUEST['sigandvoice']);
					
				$ss7_link->data->insert_statement($ss7_link->db_location, $table_name, $parameters, $values);
				
			}
			
			//Check if a PRI Signalling table exists
			//If it exists, drop the table so that it will not conflict with SS7 configuration
			$pri_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_signalling";
			$table_exists = $ss7_link->data->check_for_table ($ss7_link->db_location, $pri_table);
			
			if ($table_exists > 1)
			{
				//remove the line out of the table
				//$ss7_link->data->drop_table($ss7_link->db_location, $pri_table);
				$parameters = "port_id = " . $_SESSION['port_num_clicked'];
				
				$ss7_link->data->delete_generic($ss7_link->db_location,$pri_table, $parameters);
			}
	
			if ($voice == "yes")
			{
				$hash = "voice_link" . $_SESSION['card_clicked'] . "-SH-" .  $_SESSION['card_num'];
				$var = $_SESSION[$hash];
				$a = $_SESSION['port_num_clicked'];
				$var[$a] = $_SESSION['card_clicked'] . "-SH-" .  $_SESSION['port_num_clicked'] . "-" . $_SESSION['card_num'];
				$_SESSION[$hash] = $var;
				
				//echo $_SESSION['voice_link'][1];
			}
	
			//Return to wanrouterhwprobe.php
			if ($voice == "yes")
			{
				header( 'Location:create_ss7_ccspans.php#top' ) ;
			}
			else
			{
				header( 'Location:view_ss7_linkset.php#top' ) ;
			}
		}	
	}
	
	//If the user clicks cancel
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		unset($_SESSION['skip']);
		unset ($_REQUEST['sigandvoice']);
		header( 'Location:../wanrouterhwprobe.php#top' ) ;
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("SS7 Link Configuration", "../../../style.css","");		
	}	

	//SS7 Link configuration page
	$ss7_link->main();
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>
