<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();
//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include '../check_referer.php';

$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		//include '../sqlite/database_creation.php';
		include '../database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("PBX Integration", "../../../style.css","");		
	}

	$ip_addr =  shell_exec ("/sbin/ifconfig eth0 | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'");
	$ip = preg_replace ("/\s*/m", "", $ip_addr);

	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
?>
<h3>PBX Integration</h3>
<?php
	}
?>
<p>
In order to configure your PBX with <?php echo $_SESSION['shortname']; ?>, please use the instructions below.<br />
For more information, you can access the wiki by clicking on the following Links:<br />
		<a href="http://wiki.sangoma.com/NSG-Asterisk-Integration" target="_blank">Asterisk & <?php echo $_SESSION['shortname']; ?> Wiki Page</a><br />
        <a href="http://wiki.sangoma.com/NSG-FreeSWITCH-Integration" target="_blank">FreeSWITCH & <?php echo $_SESSION['shortname']; ?> Wiki Page</a>
</p>

    <p>In order for <?php echo $_SESSION['name']; ?> to speak to an Asterisk based PBX, you would need to follow the instructions below.<br />
    <font color="red">NOTE: This is a sample configuration. You can adjust the extensions.conf as you require for your PBX</font></p>
    <?php
    if ($ip == "")
    {
        $ip = "IP ADDRESS";
    }
    else
    {
        ?>	
        IP Address of eth0 = <?php echo $ip; ?>
        <?php
    }
    ?>
    
    <h4>Asterisk sip.conf</h4>
    <pre>
    [general]
    register=> <b>sangoma</b>:<b>sangoma</b>@<i><?php echo $ip; ?></i>:5062
    
    [authentication]
    
    [<?php echo $_SESSION['shortname']; ?>]
    context=from-<?php echo $_SESSION['shortname'] . "<br />"; ?>
    port=5062
    host=<i>IP ADDRESS</i>
    type=peer
    </pre>
    
    
    <h4>Asterisk extensions.conf</h4>
    <u>Incoming Calls:</u>
    <pre>
    [<?php echo $_SESSION['shortname']; ?>]
    exten => s, 1, goto(_X., 1)
    exten => _X.,1, set(span=${SIP_HEADER(X-freetdm-SpanName)})
    exten => _X.,n,noop(<?php echo $_SESSION['shortname']; ?> -> incoming call on span=${span})
    exten => _X.,n,answer()
    exten => _X.,n,playback(demo-congrats)
    exten => _X.,n,hangup()
    </pre>
    
    <u>Outgoing Calls:</u>
    <pre>
    exten => _X.,1, dial(sip/${EXTEN}-g=g1-h=a@<?php echo $_SESSION['shortname']; ?>)
    ;dial to <?php echo $_SESSION['shortname']; ?> trunk group named "g1" and use ascending hunting to find a free channel
    </pre>

<br />

<p>In order for <?php echo $_SESSION['name']; ?> to speak to an FreeSWITCH based PBX, you would need to follow the instructions below.<br />
<font color="red">NOTE: This is a sample configuration. You can adjust your dialplan as you require for your PBX</font></p>

<h4>FreeSWITCH SIP Registration</h4>
<p>Within the file &quot;/usr/local/freeswitch/conf/sip_profiles/internal.xml&quot;, add the following within the &lt;gateways&gt; tag:</p>
<pre>
&lt;gateway name=&quot;sangoma&quot;&gt;
    	&lt;param name=&quot;username&quot; value=&quot;sangoma&quot;/&gt;
        &lt;param name=&quot;password&quot; value=&quot;sangoma&quot;/&gt;
        &lt;param name=&quot;realm&quot; value=&quot;&lt;<?php echo $ip; ?>:5062&quot;/&gt;
        &lt;param name=&quot;dialplan&quot; value=&quot;xml&quot;/&gt;
        &lt;param name=&quot;context&quot; value=&quot;from-<?php echo $_SESSION['shortname']; ?>&quot;/&gt;
&lt;/gateway&gt;
</pre>

<h4>FreeSWITCH Dialplan</h4>
<p>Within the file "/usr/local/freeswitch/conf/dialplan/default.xml":</p>
<p>Incoming Calls</p>
<pre> 
&lt;context name=&quot;from-<?php echo $_SESSION['shortname']; ?>&quot;&gt;
	&lt;extension name=&quot;incoming&quot;&gt;
		&lt;condition field=&quot;destination number&quot; expression=&quot;<i>Regular Expression</i>&quot; /&gt;
		&lt;action application=&quot;bridge&quot; data=&quot;sofia/internal/EXTENSION@<i><?php echo $ip; ?></i>:5062&quot; /&gt;
		&lt;/condition&gt;
	&lt;/extension&gt;
&lt;/context&gt;<br />
</pre>

<p>Outgoing Calls</p>
<pre> 
&lt;context name=&quot;from-<?php echo $_SESSION['shortname']; ?>&quot;&gt;
	&lt;extension name=&quot;outgoing&quot;&gt;
		&lt;condition field=&quot;destination number&quot; expression=&quot;<i>Regular Expression</i>&quot; /&gt;
		&lt;action application=&quot;bridge&quot; data=&quot;sofia/external/EXTENSION@<i><?php echo $ip; ?></i>:5062&quot; /&gt;
		&lt;/condition&gt;
	&lt;/extension&gt;
&lt;/context&gt;<br />
</pre>

<?php
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>
