<?php
/*
  FusionPBX
  Version: MPL 1.1

  The contents of this file are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  Software distributed under the License is distributed on an "AS IS" basis,
  WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
  for the specific language governing rights and limitations under the
  License.

  The Original Code is FusionPBX

  The Initial Developer of the Original Code is
  Mark J Crane <markjcrane@fusionpbx.com>
  Portions created by the Initial Developer are Copyright (C) 2008-2010
  the Initial Developer. All Rights Reserved.

  Contributor(s):
  Mark J Crane <markjcrane@fusionpbx.com>
  Shaunt Libarian <shaunt@sangoma.com>
 */
session_start();

include 'sangoma/display_class.php';
$display_common = new Display_common;

//Checks to make sure the user is logged into the WebUI
if ( $display_common->IsRenderingNonDynamicDiv( ) ) {
	if (empty($_POST))
		include 'sangoma/check_referer.php';
}

$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

include "root.php";
if (!file_exists($_SERVER['DOCUMENT_ROOT'].PROJECT_PATH."/includes/config.php")){
  header("Location: ".PROJECT_PATH."/install.php");
  exit;
}
require_once "includes/config.php";
require_once "includes/checkauth.php";
include "sangoma/database_classes.php";

// ************************************************************************************
// HEADER 
// ************************************************************************************
//print_r( $_SERVER );
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
  unset($_SESSION['embedded']);

  //FusionPBX Integration
  require_once "includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
  //Includes required for ClearOS Integration
  include 'sangoma/sqlite/database_creation.php';

  $_SESSION['embedded'] = "true";

  //ClearOS Integration
  $display_common->session_vars("sqlite:sangoma/sqlite/cardinfo.db");
  $display_common->html_header();
  $display_common->html_title("Overview", "../style.css","");		

  // ************************************************************************************
  // BODY 
  // ************************************************************************************

  // Enable dynamic Div 
  $display_common->DynamicDivEnable();
}
?><div id='top' style='display:none;'></div><?php
// Auto refresh dynamic Div 
$display_common->DynamicDivAutoRefresh();

// ************************************************************************************
// Port status Dynamic Div
// ************************************************************************************
$display_common->DynamicDivBegin( "PortStatusDiv" );

if (!$display_common->IsGatewayRunning())
{
  $display_common->WarningBox( $_SESSION['name'] . " not started\n" );
}
else
{
  // Gateway is running, display status
  // Open the data base
  $data = new database_class;
  $cli = $_SESSION['smg_location'] . "/bin/" . $_SESSION['cli'] . " -x "; 
  $db_location = "sqlite:sangoma/sqlite/cardinfo.db";
  $db = new PDO($db_location);

  // ************************************************************************************
  // Constants and defines 
  // ************************************************************************************
  define( "COLOR_OK" , 		"#8BB381"); // Kind of Dark Sea Green
  define( "COLOR_WARNING" , 	"#FBB117"); // Kind of orange
  define( "COLOR_ERROR" , 	"#E42217"); // Kind of Firebrick
  define( "COLOR_SIG" , 		"#151B54"); // Kind of Midnight Blue
  define( "COLOR_NA" , 		"#6D7B8D"); // Kind of Light Slate Gray 

  // ------------------------------------------------------------------------------------
  //  WARNING - Following arrays must be accessed using $GLOBALS['array name'] 
  //  from any functions
  // ------------------------------------------------------------------------------------
  //
  // Physical status (wanrouter) mapping
  $PhysicalStatusMap = array(
    'Connected'		=> array( 'label' => "UP", 	'bkcolor' => COLOR_OK ),
    'Disconnected'		=> array( 'label' => "DOWN", 	'bkcolor' => COLOR_ERROR ),
    'Inactive'	=> array( 'label' => "ERROR", 'bkcolor' => COLOR_WARNING )
  );
  // MTP-2/PRI/R2 status mapping
  $dataLinkStatusMap = array(
    'bnd-enabled'		=> array( 'label' => "UP", 	'bkcolor' => COLOR_OK ),
    'bnd-disabled'		=> array( 'label' => "DOWN", 	'bkcolor' => COLOR_ERROR ),
    'configured'		=> array( 'label' => "TRYING", 'bkcolor' => COLOR_WARNING ),
	'DOWN'				=> array( 'label' => "DOWN", 'bkcolor' => COLOR_ERROR ),
	'UP'				=> array( 'label' => "UP", 'bkcolor' => COLOR_OK ),
    'N/A'				=> array( 'label' => "N/A", 	'bkcolor' => COLOR_NA ),
    'UNKNOWN'			=> array( 'label' => "UNKNOWN", 	'bkcolor' => COLOR_ERROR ),
  );
  // Network status mapping
  $networkStatusMap = array(
    // MTP-3 status mapping
    'Aligned' 		=> array( 'label' => "UP", 	'bkcolor' => COLOR_OK ),
    'Connecting' 		=> array( 'label' => "TRYING", 	'bkcolor' => COLOR_WARNING ),
    'Out of Alignment' 	=> array( 'label' => "DOWN", 	'bkcolor' => COLOR_ERROR ),
    'Failed' 		=> array( 'label' => "FAIL", 	'bkcolor' => COLOR_ERROR ),
    // M2UA status mapping
    'M2UA_CLUSTER_STATE_ACTIVE' 		=> array( 'label' => "ACTIVE", 	'bkcolor' => COLOR_OK ),
    'M2UA_CLUSTER_STATE_ACTIVE_PEERS' 		=> array( 'label' => "ACTIVE", 	'bkcolor' => COLOR_WARNING ),
    'M2UA_CLUSTER_STATE_DOWN' 		=> array( 'label' => "DOWN", 	'bkcolor' => COLOR_ERROR ),
    'M2UA_CLUSTER_STATE_INACTIVE' 		=> array( 'label' => "INACTIVE", 	'bkcolor' => COLOR_WARNING ),
    'M2UA_CLUSTER_STATE_PENDING' 		=> array( 'label' => "PENDING", 	'bkcolor' => COLOR_WARNING ),
    // common status mapping
    'N/A'	=> array( 'label' => "N/A", 	'bkcolor' => COLOR_NA ),
    'UNKNOWN'	=> array( 'label' => "UNKNOWN", 	'bkcolor' => COLOR_ERROR ),
  );
  // remote status mapping
  $remoteStatusMap = array(
    'N/A'	=> array( 'label' => "N/A", 	'bkcolor' => COLOR_NA ),
    'ACTIVE'	=> array( 'label' => "ACTIVE", 	'bkcolor' => COLOR_OK ),
    'INACTIVE'	=> array( 'label' => "INACTIVE", 	'bkcolor' => COLOR_WARNING ),
    'UNKNOWN'	=> array( 'label' => "UNKNOWN", 	'bkcolor' => COLOR_ERROR ),
  );
  // Channel sig-status mapping
  $SigChannelStatusMap = array(
    'UP'			=> array( 'label' => "U", 	'bkcolor' => COLOR_OK ),
    'DOWN'			=> array( 'label' => "D", 	'bkcolor' => COLOR_ERROR ),
    'SIGNALING LINK'	=> array( 'label' => "S", 	'bkcolor' => COLOR_SIG ),
    'NOT USED'	=> array( 'label' => "X", 	'bkcolor' => COLOR_NA ),
  );
  // Channel status mapping
  define( "CHANNEL_COLOR_IDLE" , 		"#2B60DE"); // Kind of Royal Blue4 
  define( "CHANNEL_COLOR_CONNECTED" ,	"#348017"); // Kind of Medium Spring Green 
  define( "CHANNEL_COLOR_CONNECTING" , 	"#8BB381"); // Kind of Dark Sea Green
  define( "CHANNEL_COLOR_DROPPING" , 	"#95B9C7"); // Kind of Light Blue3
  define( "CHANNEL_COLOR_ERROR" , 	"#E42217"); // Kind of Firebrick
  define( "CHANNEL_COLOR_SIG" , 		"#151B54"); // Kind of Midnight Blue 
  define( "CHANNEL_COLOR_NA" , 		"#6D7B8D"); // Kind of Light Slate Gray 
  $ChannelStatusMap = array(
    'SIGNALING LINK'	=> array( 'label' => "S", 	'bkcolor' => CHANNEL_COLOR_SIG ),
    'NOT USED'	=> array( 'label' => "X", 	'bkcolor' => CHANNEL_COLOR_NA ),
    'DOWN'			=> array( 'label' => "i", 	'bkcolor' => CHANNEL_COLOR_IDLE ), 
    'DISCONNECTED'		=> array( 'label' => "D", 	'bkcolor' => CHANNEL_COLOR_ERROR ),
    'RINGING'		=> array( 'label' => "r", 	'bkcolor' => CHANNEL_COLOR_CONNECTING ), 
    'RING'		=> array( 'label' => "r", 	'bkcolor' => CHANNEL_COLOR_CONNECTING ), 
    'DIALING'		=> array( 'label' => "d", 	'bkcolor' => CHANNEL_COLOR_CONNECTING ), 
    'PROGRESS'		=> array( 'label' => "p", 	'bkcolor' => CHANNEL_COLOR_CONNECTING ), 
    'PROGRESS_MEDIA'	=> array( 'label' => "m", 	'bkcolor' => CHANNEL_COLOR_CONNECTING ), 
    'UP'			=> array( 'label' => "u", 	'bkcolor' => CHANNEL_COLOR_CONNECTED ), 
    'TERMINATING'		=> array( 'label' => "t", 	'bkcolor' => CHANNEL_COLOR_DROPPING ), 
    'HANGUP'		=> array( 'label' => "h", 	'bkcolor' => CHANNEL_COLOR_DROPPING ), 
    'HANGUP_COMPLETE'	=> array( 'label' => "h", 	'bkcolor' => CHANNEL_COLOR_DROPPING ), 
    'CANCEL'		=> array( 'label' => "c", 	'bkcolor' => CHANNEL_COLOR_ERROR ), 
    'RESTART'		=> array( 'label' => "r", 	'bkcolor' => CHANNEL_COLOR_ERROR ), 
    'SUSPENDED'		=> array( 'label' => "s", 	'bkcolor' => CHANNEL_COLOR_ERROR ),
    'COLLECT'		=> array( 'label' => "C", 	'bkcolor' => CHANNEL_COLOR_CONNECTING ),
    'LOOP'		=> array( 'label' => "L", 	'bkcolor' => CHANNEL_COLOR_ERROR ),
	'UNKNOWN'	=> array( 'label' => "?", 	'bkcolor' => COLOR_ERROR )	
  );

  function ResolveStatusLabel( $in_aStatusMap, $in_szStatus )
  {
    //return ( isset( $in_aStatusMap[$in_szStatus] ) ) ? $in_aStatusMap[$in_szStatus]['label']:($in_szStatus);
    // WADAM: display ? if status unknown as tooltip displays all channel info
    return ( isset( $in_aStatusMap[$in_szStatus] ) ) ? $in_aStatusMap[$in_szStatus]['label']:"?";
  }
  function ResolveStatusBkColor( $in_aStatusMap, $in_szStatus )
  {
    return ( isset( $in_aStatusMap[$in_szStatus]['bkcolor'] ) ) ? $in_aStatusMap[$in_szStatus]['bkcolor']:COLOR_NA;
  }
  function ResolveStatusFontColor( $in_aStatusMap, $in_szStatus )
  {
    // For now just white
    return "white";
    //return ( isset( $in_aStatusMap[$in_szStatus]['bkcolor'] ) ) ? $in_aStatusMap[$in_szStatus]['bkcolor']:"#FFFFFF";
  }
  /* 
   * Data link request functions
   */
  function query_pri_link($cli,$port,&$status,&$fullStatus) {
      exec( $cli . "\"ftdm sangoma_isdn show_spans_xml wp".trim(substr($port['wanpipe'],7))."\"", $execRc);
      //simplxml the return to take the signalling info
		/*$tmpStatus1 = '<span name="wp1">
        	<status type="physical" value="ALARMED"/>
        	<status type="signalling" value="DOWN"/>
		</span>';
		$tmpStatus2 = '<span name="wp2">
        	<status type="physical" value="ALARMED"/>
        	<status type="signalling" value="DOWN"/>
		</span>		';
	   */

      try {
		$a = 0;
		foreach ($execRc as $rc) {
			if ($rc == "")
				unset($execRc[$a]);
				
			if ($rc == "Command executed OK")
				unset ($execRc[$a]);
			$a++;
		}
	   	
	   	$tmpStatus = implode($execRc);
        $xmlStatus = new SimpleXMLElement( $tmpStatus );
        $xmlPRIStatus = $xmlStatus->xpath( '/span[@name="wp'.trim(substr($port['wanpipe'],7)).'"]');
		$a = 0;
		foreach ($xmlPRIStatus[0] as $PRIStatus) {
			if ($PRIStatus[$a]->attributes()->type == "signalling")
				$status = trim($PRIStatus->attributes()->value);
			$a++;	
		}
      }catch(Exception $e) {
        $status = "UNKNOWN";
        $fullStatus = array( "Fatal parsing error", $e->getMessage(), implode($execRc));
      }	  
  } 
  function query_ss7_data_link($cli, $port, &$status, &$fullStatus) {
      exec( $cli . "\"ftdm ss7 show status mtp2 " . $port['mtp2_name'] . "\"", $execRc);
      $fullStatus= explode( "|", $execRc[0]);
      $status = trim( substr( $fullStatus[4], strpos( $fullStatus[4], "=" )+1 ));
  }
  function query_ss7_network($cli, $port, &$status, &$fullStatus) {
      exec( $cli . "\"ftdm ss7 show status mtp3 " . $port['mtp3_name'] . "\"", $execRc);
      $fullStatus= explode( "|", $execRc[0]);
      $status = trim( substr( $fullStatus[4], strpos( $fullStatus[4], "=" )+1 ) );
  }
  function query_mg_remote($cli, $port, &$status, &$fullStatus) {
    /* output
    <mg_peer>
      <name>peer-1</name>
      <ipv4_address>192.168.1.102</ipv4_address>
      <peer_state>MG_PEER_STATE_REGISTER</peer_state>
      </mg_peer>
     */
      exec( $cli . "\"mg profile " . $port['mg_name'] . " peerxmlstatus\"", $execRc);
      $active = false;
      try {
        $tmpStatus= implode($execRc);
        // wadam -test
        /*
        $tmpStatus = "
          <mg_peers>
          <mg_peer>
          <name>peer-1</name>
          <ipv4_address>192.168.1.102</ipv4_address>
          <peer_state>MG_PEER_STATE_REGISTER</peer_state>
          </mg_peer>
          <mg_peer>
          <name>peer-1</name>
          <ipv4_address>192.168.1.102</ipv4_address>
          <peer_state>MG_PEER_STATE_ACTIVE</peer_state>
          </mg_peer>
          </mg_peers>
          ";
         */
        $xmlStatus = new SimpleXMLElement( $tmpStatus );
        $fullStatus=array();
        $fullStatus[] = "remote=MG";
        $fullStatus[] = "name=".$port['mg_name'];
        $xmlPeerStatus = $xmlStatus->xpath( "//mg_peer" );
        foreach ( $xmlPeerStatus as $xmlPeer )
        {
          $jsonPeer = json_decode(json_encode($xmlPeer),true);
          $fullStatus[] = "peer=".$jsonPeer['name']."/".$jsonPeer['peer_state'];
          if("PEER_STATE_ACTIVE" == trim($jsonPeer['peer_state']))
            $active = true;
        }
        $xmlStatus = null;

        $status = ($active)?"ACTIVE":"INACTIVE";
      }catch(Exception $e) {
        $status = "UNKNOWN";
        $fullStatus = array( "Fatal parsing error", $e->getMessage(), implode($execRc));
      }
  }
  function query_m2ua_network($cli, $port, &$status, &$fullStatus) {
    /*
      # nsg_cli -x "ftdm ss7 xmlshow m2ua SGM2UA1 clusterstatus"
      
       <?xml version="1.0" encoding="ISO-8859-1"?>
       <m2ua_cluster>
       <name> CL1 </name>
        <state> M2UA_CLUSTER_STATE_DOWN </state>
        <num_of_peers> 1 </num_of_peers>
        <m2ua_cluster_peer>
         <peer_name> CL1_Peer1 </peer_name>
          <peer_id> 1 </peer_id>
           <peer_state> M2UA_PEER_STATE_DOWN </peer_state>
           </m2ua_cluster_peer>
           <num_active_peer> 0 </num_active_peer>
           </m2ua_cluster>
    */
      $inactive_peers = false;
      exec( $cli . "\"ftdm ss7 xmlshow m2ua " . $port['m2ua_link_name'] . " clusterstatus\"", $execRc);
      try {
        $tmpStatus= implode($execRc);
        $xmlStatus = new SimpleXMLElement( $tmpStatus );

        // Rebuild similiar format than show status mtp2
        //Get only the registration elements
        $xmlClusterStatus = $xmlStatus->xpath( "//m2ua_cluster" );
        $fullStatus=array();
        foreach ( $xmlClusterStatus as $xmlCluster )
        {
          $jsonCluster = json_decode(json_encode($xmlCluster),true);

          $fullStatus[] = "name=".$port['m2ua_link_name'];
          $fullStatus[] = "cluster=".trim($jsonCluster['name']);
          $fullStatus[] = "status=".trim($jsonCluster['state']);
          // Check for peers
          $xmlClusterPeers = $xmlCluster->xpath("//m2ua_cluster_peer");
          foreach ( $xmlClusterPeers as $xmlPeer )
          {
            $jsonPeer = json_decode(json_encode($xmlPeer),true);
            $fullStatus[] = "peer=".trim($jsonPeer['peer_name']). "/".trim($jsonPeer['peer_state']);
            if("M2UA_PEER_STATE_ACTIVE"!=trim($jsonPeer['peer_state']))
              $inactive_peers = true;
          }
        }
        $xmlStatus = null;
        // Adjust status in case of active but inactive peers
        $status = trim( substr( $fullStatus[2], strpos( $fullStatus[2], "=" )+1 ) );
        if ("M2UA_CLUSTER_STATE_ACTIVE"==$status && $inactive_peers)
          $status .= "_PEERS";
      }catch(Exception $e) {
        $status = "UNKNOWN";
        $fullStatus = array( "Fatal parsing error", $e->getMessage(), implode($execRc));
      }
  }

  /*
   * Channel display functions
   */
  // Dummy one to avoid errors
  function display_dummy_channels( $cli, $port , $data_link_status='down') {
    echo "Not supported channel type";
  }
  
  function display_r2_channels($cli,$port, $data_link_status='down') { 
	exec( $cli . "\"ftdm r2 show_calls_xml wp" . trim(substr($port['wanpipe'],7)) . "\"", $execRc);
	/*$tmpStatus = '
	<span name="wp2">
			<chan number="1" call="no"/>
			<chan number="2" call="no"/>
			<chan number="3" call="yes"/>
			<chan number="4" call="no"/>
			<chan number="5" call="no"/>
			<chan number="6" call="no"/>
			<chan number="7" call="no"/>
			<chan number="8" call="no"/>
			<chan number="9" call="no"/>
			<chan number="10" call="no"/>
			<chan number="11" call="no"/>
			<chan number="12" call="no"/>
			<chan number="13" call="no"/>
			<chan number="14" call="no"/>
			<chan number="15" call="no"/>
			<chan number="17" call="no"/>
			<chan number="18" call="no"/>
			<chan number="19" call="no"/>
			<chan number="20" call="no"/>
			<chan number="21" call="no"/>
			<chan number="22" call="no"/>
			<chan number="23" call="no"/>
			<chan number="24" call="no"/>
			<chan number="25" call="yes"/>
			<chan number="26" call="no"/>
			<chan number="27" call="no"/>
			<chan number="28" call="no"/>
			<chan number="29" call="no"/>
			<chan number="30" call="no"/>
			<chan number="31" call="no"/>
	</span> ';*/
	
	$a = 0;
	foreach ($execRc as $rc) {
		if ($rc == "")
			unset($execRc[$a]);
		$a++;
	}
	$tmpStatus = implode($execRc);
	echo "		<table width='100%'>\n";
	echo "			<tr>\n";
	try {
		$StatusMap = $GLOBALS['ChannelStatusMap'];
		$xmlStatus = new SimpleXMLElement( $tmpStatus );
		$xmlr2Status = $xmlStatus->xpath( '/span[@name="wp'.trim(substr($port['wanpipe'],7)).'"]');
		$a = 1;
		if (strtolower($data_link_status) == "down") {
			foreach ($xmlr2Status[0] as $r2Status) {
				$status = "DISCONNECTED";
				
				if ($a == 16) {
					echo "          <td align='center' width='10px' height='14px' style='background-color:";
					echo  ResolveStatusBkColor( $StatusMap,'NOT USED' );
					echo "'>\n";		  
					echo "          <font color='white'>";
					echo  ResolveStatusLabel( $StatusMap,'NOT USED' );
					echo "          </font>";
					echo "          </td>\n";	
					echo "          <td align='center' width='10px' height='14px' style='background-color:";
					echo  ResolveStatusBkColor( $StatusMap,$status );
					echo "'>\n";
					echo "          <font color='white'>";
					echo  ResolveStatusLabel( $StatusMap,$status );
					echo "          </font>";
					echo "          </td>\n";			  
				}	  
				else {
					echo "          <td align='center' width='10px' height='14px' style='background-color:";
					echo  ResolveStatusBkColor( $StatusMap,$status );
					echo "'>\n";
					echo "          <font color='white'>";
					echo  ResolveStatusLabel( $StatusMap,$status );
					echo "          </font>";
					echo "          </td>\n";
				}
				$a++;
			}		
		}
		else {
			foreach ($xmlr2Status[0] as $r2Status) {
				if ( trim($r2Status->attributes()->call) == "yes")
					$status = "UP";
				elseif ( trim($r2Status->attributes()->call) == "no")
					$status = "DOWN";
				
				if ($a == 16) {
					echo "          <td align='center' width='10px' height='14px' style='background-color:";
					echo  ResolveStatusBkColor( $StatusMap,'NOT USED' );
					echo "'>\n";		  
					echo "          <font color='white'>";
					echo  ResolveStatusLabel( $StatusMap,'NOT USED' );
					echo "          </font>";
					echo "          </td>\n";	
					echo "          <td align='center' width='10px' height='14px' style='background-color:";
					echo  ResolveStatusBkColor( $StatusMap,$status );
					echo "'>\n";
					echo "          <font color='white'>";
					echo  ResolveStatusLabel( $StatusMap,$status );
					echo "          </font>";
					echo "          </td>\n";			  
				}	  
				else {
					echo "          <td align='center' width='10px' height='14px' style='background-color:";
					echo  ResolveStatusBkColor( $StatusMap,$status );
					echo "'>\n";
					echo "          <font color='white'>";
					echo  ResolveStatusLabel( $StatusMap,$status );
					echo "          </font>";
					echo "          </td>\n";
				}
				$a++;
			}
		}
		echo "			</tr>\n";
	} catch (exception $e) {
		echo "          <td align='center' width='10px' height='14px' style='background-color:";
		echo  ResolveStatusBkColor( $StatusMap,'UNKNOWN' );
		echo "'>\n";
		echo "          <font color='white'>";
		echo  ResolveStatusLabel( $StatusMap,"UNKNOWN" );
		echo "          </font>";
		echo "          </td>\n";
	}
	echo "		</table>\n";
	unset( $execRc );	  
  }  
  
  function display_pri_channels($cli,$port, $data_link_status='down') {
	exec( $cli . "\"ftdm sangoma_isdn show_calls_xml wp" . trim(substr($port['wanpipe'],7)) . "\"", $execRc);
	
	/*$tmpStatus = '
	<span name="wp1">
	  <chan number="1" call="no"/>
	  <chan number="2" call="no"/>
	  <chan number="3" call="yes"/>
	  <chan number="4" call="no"/>
	  <chan number="5" call="no"/>
	  <chan number="6" call="no"/>
	  <chan number="7" call="no"/>
	  <chan number="8" call="no"/>
	  <chan number="9" call="no"/>
	  <chan number="10" call="no"/>
	  <chan number="11" call="no"/>
	  <chan number="12" call="no"/>
	  <chan number="13" call="no"/>
	  <chan number="14" call="no"/>
	  <chan number="15" call="no"/>
	  <chan number="16"/>		
	  <chan number="17" call="no"/>
	  <chan number="18" call="no"/>
	  <chan number="19" call="no"/>
	  <chan number="20" call="no"/>
	  <chan number="21" call="no"/>
	  <chan number="22" call="no"/>
	  <chan number="23" call="no"/>
	  <chan number="24" call="no"/>
	  <chan number="25" call="no"/>
	  <chan number="26" call="no"/>
	  <chan number="27" call="no"/>
	  <chan number="28" call="no"/>
	  <chan number="29" call="no"/>
	  <chan number="30" call="no"/>
	  <chan number="31" call="no"/>
	</span> ';*/
	
	$a = 0;
	foreach ($execRc as $rc) {
		if ($rc == "")
			unset($execRc[$a]);
		if ($rc == "Command executed OK")
			unset ($execRc[$a]);			
		$a++;
	}
	
	$tmpStatus = implode($execRc);
	
	
	echo "		<table width='100%'>\n";
	echo "			<tr>\n";
	$StatusMap = $GLOBALS['ChannelStatusMap'];
	try {
		$xmlStatus = new SimpleXMLElement( $tmpStatus );
		$xmlPRIStatus = $xmlStatus->xpath( '/span[@name="wp'.trim(substr($port['wanpipe'],7)).'"]');
		$a = 1;
		
		if (strtolower($data_link_status) == "down") {
			foreach ($xmlPRIStatus[0] as $PRIStatus) {
				if ( trim($PRIStatus->attributes()->call) == "")
					$status = 'SIGNALING LINK';
				else
					$status = "DISCONNECTED";
				
				echo "          <td align='center' width='10px' height='14px' style='background-color:";
				echo  ResolveStatusBkColor( $StatusMap,$status );
				echo "'>\n";
				//echo "<span title='"; 
				//foreach ($tmpArray as $tmpLine ) if(strlen(trim($tmpLine)))echo $tmpLine . "\n";
				//echo "'>\n";
				echo "          <font color='white'>";
				echo  ResolveStatusLabel( $StatusMap,$status );
				echo "          </font>";
				echo " </span>\n";
				echo "          </td>\n";
				$a++;
	
			}
		} else {
			foreach ($xmlPRIStatus[0] as $PRIStatus) {
				if ( trim($PRIStatus->attributes()->call) == "")
				  $status = 'SIGNALING LINK';
				elseif ( trim($PRIStatus->attributes()->call) == "yes")
				  $status = "UP";
				elseif ( trim($PRIStatus->attributes()->call) == "no")
				  $status = "DOWN";
				
				echo "          <td align='center' width='10px' height='14px' style='background-color:";
				echo  ResolveStatusBkColor( $StatusMap,$status );
				echo "'>\n";
				//echo "<span title='"; 
				//foreach ($tmpArray as $tmpLine ) if(strlen(trim($tmpLine)))echo $tmpLine . "\n";
				//echo "'>\n";
				echo "          <font color='white'>";
				echo  ResolveStatusLabel( $StatusMap,$status );
				echo "          </font>";
				echo " </span>\n";
				echo "          </td>\n";
				$a++;
			}
		}
	} catch (exception $e) {
		echo "          <td align='center' width='10px' height='14px' style='background-color:";
		echo  ResolveStatusBkColor( $StatusMap,'UNKNOWN' );
		echo "'>\n";
		echo "          <font color='white'>";
		echo  ResolveStatusLabel( $StatusMap,"UNKNOWN" );
		echo "          </font>";
		echo "          </td>\n";
	}	
	echo "			</tr>\n";
	echo "		</table>\n";
	unset( $execRc );	  
  }
  
  // SS7 channels
  function display_ss7_channels( $cli, $port, $data_link_status='down' ) {
    // Channels map
    exec( $cli . "\"ftdm ss7 show status span " . trim(substr($port['wanpipe'],7)) . " chan 0\"", $execRc);
    /* Result looks like:
    span= 1|chan= 1|cic=   1|SIGNALING LINK
    span= 1|chan= 2|cic=   2|ckt=1002|sig_status=DOWN|state=RESTART|l_mn=N|r_mn=N|l_hw=N|r_hw=N|relay=N
    span= 1|chan= 3|cic=   3|ckt=1003|sig_status=DOWN|state=RESTART|l_mn=N|r_mn=N|l_hw=N|r_hw=N|relay=N
    span= 1|chan= 4|cic=   4|ckt=1004|sig_status=DOWN|state=RESTART|l_mn=N|r_mn=N|l_hw=N|r_hw=N|relay=N
    span= 1|chan= 5|cic=   5|ckt=1005|sig_status=DOWN|state=RESTART|l_mn=N|r_mn=N|l_hw=N|r_hw=N|relay=N
    ...	
    */
    echo "		<table width='100%'>\n";
    echo "			<tr>\n";
    // Loop around all channels
    for ( $i=0; $i< count($execRc); $i=$i+1 )
    {
      // Default is signalling status map
      $StatusMap = $GLOBALS['SigChannelStatusMap'];
      if ( 0 == count($execRc[$i]) || 0 == strlen($execRc[$i][0]) )
      {
        continue;
      }
      $tmpArray = explode( "|", $execRc[$i] );
      // Handle special signalling channel case
      if ( sizeof($tmpArray) == 4 )
      {
        $status = trim($tmpArray[3]);
      }
      else
      {
        // Get the sig status
        $status = trim( substr( $tmpArray[4], strpos( $tmpArray[4], "=" )+1 ) );
        if ( $status == "UP" )
        {
          // Change to channel status because CiC is UP
          unset( $status );
          $status = trim( substr( $tmpArray[5], strpos( $tmpArray[5], "=" )+1 ) );
          unset( $StatusMap );
          $StatusMap = $GLOBALS['ChannelStatusMap'];
        }
      }
      echo "          <td align='center' width='10px' height='14px' style='background-color:";
      echo  ResolveStatusBkColor( $StatusMap,$status );
      echo "'>\n";
      echo "<span title='"; 
      foreach ($tmpArray as $tmpLine ) if(strlen(trim($tmpLine)))echo $tmpLine . "\n";
      echo "'>\n";
      echo "          <font color='white'>";
      echo  ResolveStatusLabel( $StatusMap,$status );
      echo "          </font>";
      echo " </span>\n";
      echo "          </td>\n";
      unset( $tmpArray );
    }

    echo "			</tr>\n";
    echo "		</table>\n";
    unset( $execRc );
  }
  function display_m2ua_channels( $cli, $port, $data_link_status='down' ) {
    return display_m2ua_mg_channels($cli, $port, false); 
  }
  function display_m2ua_mg_channels( $cli, $port, $check_voice=true ) {
    // Default sig_chan is none 
    $sig_chan = '';
    // WADAM - fake the chan 1
    //$sig_chan = '[s'.$port['id'].'c1]';
    // Get M2UA signalling channel
    exec( $cli . "\"ftdm ss7 show status span " . trim(substr($port['wanpipe'],7)) . " chan 0\"", $execRc);
    // Loop around all channels
    for ( $i=0; $i< count($execRc); $i=$i+1 )
    {
      // Default is signalling status map
      if ( 0 == count($execRc[$i]) || 0 == strlen($execRc[$i][0]) )
      {
        continue;
      }
      $tmpArray = explode( "|", $execRc[$i] );
      // Handle special signalling channel case
      if ( sizeof($tmpArray) == 4 )
      {
        // Extract span and chan
        $span = trim( substr( $tmpArray[0], strpos( $tmpArray[0], "=" )+1 ) );
        $chan = trim( substr( $tmpArray[1], strpos( $tmpArray[1], "=" )+1 ) );
        $sig_chan = '[s'.$span.'c'.$chan.']';
        break;
      }
    } 
    return display_mg_channels( $cli, $port, true, $sig_chan, $check_voice);
  }
  function display_mg_channels( $cli, $port, $has_m2ua=false, $sig_chan='', $check_voice=true ) {
    
    // Channels map
    exec( $cli . "\"ftdm core flag open wp" . trim(substr($port['wanpipe'],7)) . "\"", $execRc);
    /* Result looks like:
      # nsg_cli -x "ftdm core flag open 2"
      # [s2c1][2:1] flag 4(open) OFF
      # [s2c2][2:2] flag 4(open) OFF
      # [s2c3][2:3] flag 4(open) OFF
      # [s2c4][2:4] flag 4(open) OFF
      # [s2c5][2:5] flag 4(open) OFF
      # [s2c6][2:6] flag 4(open) OFF
      # [s2c7][2:7] flag 4(open) OFF
      # [s2c8][2:8] flag 4(open) OFF
      # [s2c9][2:9] flag 4(open) OFF
    ...	

    Total channels with flag 4: 0
    */
    exec( $cli . "\"mg profile " . $port['mg_name'] . " show spantermstatus wp".trim(substr($port['wanpipe'],7))."\"", $tmp_mgtermstatus);
    /* Result looks like:
      [root@mtt2 bin]# nsg_cli -x "mg profile MG_profile1 show alltermstatus"

      Termination Name  Termination State          Call State               Termination Type         Span-Id            Channel-Id
       
      A1                      IN-SERVICE                   IN-CALL                  MG_TERM_TDM             wp1             1
       
      A100                    IN-SERVICE                   IDLE                     MG_TERM_TDM             wp4             5
       
      A119                    IN-SERVICE                   IDLE                     MG_TERM_TDM             wp4             24 
    */

    $num_chans = 0;
    $mg_term_status = array();
    $mg_call_state = array();
    $mg_channel_name = array();

    if (strlen($sig_chan) > 0) {
    	$num_chans++;
    }

    foreach($tmp_mgtermstatus as $term_status) {
      // Is this a TERM
      if (strpos($term_status,"MG_TERM_TDM")){
        $num_chans++;
        $term_status = preg_replace( "{[ \t]+}", ' ', $term_status );
        $tmp = explode(" ", $term_status);

        $mg_channel_name[$tmp[6]] = trim($tmp[5])."-".trim($tmp[6])."(".trim($tmp[1]).")";
        $mg_term_status[$tmp[6]] = trim($tmp[2]);
        $mg_call_state[$tmp[6]] = trim($tmp[3]);
      }
    }

    echo "		<table width='100%'>\n";
    echo "			<tr>\n";

	$first_chan = 0 ;
    for ( $i=0; $i <= count($mg_channel_name); $i=$i+1 )
	{
		if (strlen($mg_channel_name[$i]) > 0) {
			$first_chan = $i;
			break;
		}
	}
    // Loop around all channels
    for ( $i=0; $i < $num_chans; $i=$i+1 )
    {
      // Default is signalling status map
      $StatusMap = $GLOBALS['ChannelStatusMap'];

      if ($has_m2ua && FALSE !== strpos($execRc[$i], $sig_chan) ) {
        // Got the sig channel
        $StatusMap=$GLOBALS['SigChannelStatusMap'];
        $status="SIGNALING LINK";
	if ($i == 0 && $first_chan > 1) {
		$first_chan=$first_chan-1;
	}

      } else if ($check_voice) {
        // Build array used for tooltip
		$tmpArray[] = $mg_channel_name[$i + $first_chan];
		$tmpArray[] = $mg_term_status[$i + $first_chan];
		$tmpArray[] = $mg_call_state[$i + $first_chan];
        // Is channel in service ?
        if($mg_term_status[$i + $first_chan] == "IN-SERVICE") {
          // Check FS open flag
          switch($mg_call_state[$i + $first_chan]){
          case 'IN-CALL':
            $status='UP';
            break;
          case 'IDLE':
            $status='DOWN';
            break;
          default:
            $status='?';
            break;
          }
        }else{
          $status = "DISCONNECTED";
        }
      } else {
        // M2UA without voice, mark all as not used
        $status = "NOT USED";
      }

      echo "          <td align='center' width='10px' height='14px' style='background-color:";
      echo  ResolveStatusBkColor( $StatusMap,$status );
      echo "'>\n";
      echo "<span title='"; 
      foreach ($tmpArray as $tmpLine ) if(strlen(trim($tmpLine)))echo $tmpLine . "\n";
      echo "'>\n";
      echo "          <font color='white'>";
      echo  ResolveStatusLabel( $StatusMap,$status );
      echo "          </font>";
      echo " </span>\n";
      echo "          </td>\n";
      unset( $tmpArray );
    }
    echo "			</tr>\n";
    echo "		</table>\n";
    unset( $execRc );
  }

  // ************************************************************************************
  // Display TDM port table
  // ************************************************************************************
  echo "	</br>\n";
  echo "<table class='mytable' width='100%'>\n";
  echo "	<th class='widget-content-header ui-state-active ui-corner-top' colspan='8' align='left'>\n";
  echo "		TDM Status\n";
  echo "	</th>\n";
  echo "	<tr>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='60px'>\n";
  echo "		Port\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='10px'>\n";
  echo "		Span\n";
  echo "	</td>\n";  
  echo "	<td align='center' class='ui-state-active mytableheader' width='60px'>\n";
  echo "		Type\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='50px'>\n";
  echo "		Physical\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='50px'>\n";
  echo "		Data Link\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='50px'>\n";
  echo "		Network\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='50px'>\n";
  echo "		Remote\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='440px'>\n";
  echo "		Channels\n";
  echo "	</td>\n";
  echo "	<tr>\n";
  // Query all ports
  $select = "SELECT * from generated_ports WHERE completed = 'yes' order by id";
  $result = $db->query($select);

  $results = $data->array_select_statement('sqlite:sangoma/sqlite/cardinfo.db','generated_ports','*');

  foreach ($results as $result) {
    if (preg_match("/A116/",$result['card']))
        $query_result[] = $result;
  }
  foreach ($results as $result) {
    if (preg_match("/A108/",$result['card']))
        $query_result[] = $result;
  }
  foreach ($results as $result) {
    if (preg_match("/A104/",$result['card']))
        $query_result[] = $result;
  }
  foreach ($results as $result) {
    if (preg_match("/A102/",$result['card']))
        $query_result[] = $result;
  }
 foreach ($results as $result) {
    if (preg_match("/A101/",$result['card']))
        $query_result[] = $result;
  }

  // Iterate all ports
  foreach ($query_result as $port) {
    // Prepare default values
    unset($physicalFullStatus);
    unset($dataLinkFullStatus);
    unset($networkFullStatus);
    unset($remoteFullStatus);
    $dataLinkStatus = "N/A";
    $networkStatus = "N/A";
    $remoteStatus = "N/A";
    $display_channel = "display_dummy_channels";
    $type_label = $port['type'];

    // Figure out the link type
    switch( $port['type'] ) {
	case 'PRI' :
		$type_label = "PRI";
		//Signalling status
		query_pri_link($cli,$port,$dataLinkStatus,$dataLinkFullStatus);
		$display_channels = "display_pri_channels";
		$profile = $port['pri_profile'];
		break;
	case 'MFC/R2' :
		$type_label = "MFC/R2";
		//Signalling status
		query_pri_link($cli,$port,$dataLinkStatus,$dataLinkFullStatus);
		$display_channels = "display_r2_channels";
		$profile = $port['r2_profile'];
		break;
    case 'SS7 Signalling Link' : 
      $type_label = "SS7";
      $type = "SS7";
      query_ss7_data_link($cli, $port, $dataLinkStatus, $dataLinkFullStatus);
      // MTP3 status
      query_ss7_network($cli, $port, $networkStatus, $networkFullStatus);
      // Set resolve maps
      $display_channels = "display_ss7_channels";
      break;
    case 'SS7 Voice Link' : 
      $type_label = "Voice";
      // Set resolve maps
      $display_channels = "display_ss7_channels";
      break;
    case 'M2UA Signalling Gateway':
      $type_label = "M2UA";
      $display_channels = "display_m2ua_channels";
	  $profile=$port['mg_name'];
      // Check if some voice channels assigned (through MG profile)
      if(strlen($port['mg_name'])){
        $display_channels = "display_m2ua_mg_channels";
        $type = "M2UA_MG";
        // remote status
        query_mg_remote($cli, $port, $remoteStatus, $remoteFullStatus);
      }
      // MTP2 status
      query_ss7_data_link($cli, $port, $dataLinkStatus, $dataLinkFullStatus);
      // network M2UA status (cluster status)
      query_m2ua_network($cli, $port, $networkStatus, $networkFullStatus);
      break;
    case 'Media Gateway':
      $type_label = "MG";
      $type = "MG"; 
	  $profile=$port['mg_name'];
      $display_channels = "display_mg_channels";
      // remote status
      query_mg_remote($cli, $port, $remoteStatus, $remoteFullStatus);
      break;
    default:
      echo "WADAM - !!! WARNING !!! Unknown port type = ".$port['type']."</br>";
      $type = "Voice"; 
      break;
    }
    // Display span name/ref 
	$BoardSpan = substr($port['wanpipe'],7);
    echo "<tr>\n";
    echo "	<td align='left' class='ui-state-active'>\n";
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	    echo "  <a href='sangoma/wanrouterhwprobe.php#" . $port['card'] . "'>\n"; 
	else
		echo "  <a href='/admin/ss7_tdm_config.php' target='_parent'>\n";
    echo 		$port['card'] . "\n";
    echo "  </a>";
    echo "	</td>\n";

	// Display Span Number
	echo "<td align='center' class='ui-state-active'>";
	echo  $BoardSpan;
	echo "</td>";

    // Display port type
    echo "	<td align='center' class='ui-state-active' title='" . $profile . "' >\n";
    echo      $type_label;
    echo "	</td>\n";

    // Query physical status
    $rc = "";
    $execRc = array();
    $rc = exec("cat /proc/net/wanrouter/status | grep " . $port['wanpipe'] );
    $physicalFullStatus = explode( "|", $rc );
    $physicalStatus = trim( $physicalFullStatus [3]) ;
	
    // Add output of wanpipemon -i wXg1 -c Ta to full physical status
    $rc = exec("wanpipemon -i w" . substr($port['wanpipe'],7) . "g1 -c Ta", $execRc );
    foreach($execRc as $wan_stat){
      if(strlen(trim($wan_stat)))
        $physicalFullStatus[] = $wan_stat;
    }

    // Display Physical status
    echo "		<td align='center' style='background-color:";
    echo ResolveStatusBkColor( $PhysicalStatusMap, $physicalStatus ); 
    echo "' title='";
    foreach ($physicalFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
    echo "    <span title='";
    foreach ($physicalFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
    echo "	<font color='" .  ResolveStatusFontColor( $PhysicalStatusMap, $physicalStatus ) . "'>";
    echo ResolveStatusLabel( $PhysicalStatusMap, $physicalStatus ); 
    echo "	</font>";
    echo "  </span>\n";
    echo "	</td>\n";

    // Display data link status
    echo "	<td align='center' style='background-color:";
    echo ResolveStatusBkColor( $dataLinkStatusMap, $dataLinkStatus ); 
    echo "' title='";
    foreach ($dataLinkFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
	if (!empty ($dataLinkFullStatus)) {
    	echo "    <span title='";
    	foreach ($dataLinkFullStatus as $line ) echo $line . "\n";
    	echo "'>\n";
	}
    echo "	<font color='" .  ResolveStatusFontColor( $dataLinkStatusMap, $dataLinkStatus) . "'>";
    echo ResolveStatusLabel( $dataLinkStatusMap, $dataLinkStatus ); 
    echo "	</font>";
    echo "  </span>\n";
    echo "</td>\n";

    // Display network status
    echo "	<td align='center' style='background-color:";
    echo ResolveStatusBkColor( $networkStatusMap, $networkStatus ); 
    echo "' title='";
    foreach ($networkFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
    echo "    <span title='";
    foreach ($networkFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
    echo "	<font color='" .  ResolveStatusFontColor( $networkStatusMap, $networkStatus) . "'>";
    echo ResolveStatusLabel( $networkStatusMap, $networkStatus ); 
    echo "	</font>";
    echo "  </span>\n";
    echo "</td>\n";

    // Display remote status (M2UA GW or Relay...)
    echo "	<td align='center' style='background-color:";
    echo ResolveStatusBkColor( $remoteStatusMap, $remoteStatus ); 
    echo "' title='";
    foreach ($remoteFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
    echo "    <span title='";
    foreach ($remoteFullStatus as $line ) echo $line . "\n";
    echo "'>\n";
    echo "	<font color='" .  ResolveStatusFontColor( $remoteStatusMap, $remoteStatus) . "'>";
    echo ResolveStatusLabel( $remoteStatusMap, $remoteStatus ); 
    echo "	</font>";
    echo "  </span>\n";
    echo "</td>\n";

    // Now display channel map in that cell
    echo "		<td>\n";
    $display_channels( $cli, $port, $dataLinkStatus ); 
    echo "		</td>\n";
    echo "	</tr>\n";

  }

  // End port table
  echo "<th i align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'>\n";
  echo "</th>\n";
  echo "</table>\n";

  //echo time();
  echo "</br>\n";
  $display_common->DynamicDivEnd( "PortStatusDiv" );
  // close the db
  $db = NULL;
  // Display legend
  if ( $display_common->IsRenderingNonDynamicDiv( ) )
  {
    echo "<hr/>\n";
    echo "<table width='100%'>\n";
    echo " <th align='left' colspan='14'>\n";
    echo " Channel status legend\n";
    echo " </th>\n";

    $i = 0; 
    foreach( $ChannelStatusMap as $status => $statusMap )
    {
      $i++;
      if ( ($i)%7 == 1 )
        echo "<tr>\n";
      echo "<td width='10px' height='14px'align='center' style='background-color:";
      echo $statusMap['bkcolor'] . "' >\n";
      echo "<font color='white'>";
      echo $statusMap['label'];
      echo "</font>";
      echo "</td>\n";
      echo "<td>\n";
      echo $status;
      echo "</td>\n";
      if ( ($i)%7 == 0 )
        echo "</tr>\n";
    }

    echo "</table>\n";
  }
}

if ( $display_common->IsRenderingNonDynamicDiv( ) )
{
  // ************************************************************************************
  // FOOTER
  // ************************************************************************************
  //Check to see which UI we are running in
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    //FusionPBX Integration
    require_once "includes/footer.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {

    //ClearOS Integration
    $display_common->html_footer();

  }
}
?>
