<?php
/*
	FusionPBX
	Version: MPL 1.1

	The contents of this file are subject to the Mozilla Public License Version
	1.1 (the "License"); you may not use this file except in compliance with
	the License. You may obtain a copy of the License at
	http://www.mozilla.org/MPL/

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.

	The Original Code is FusionPBX

	The Initial Developer of the Original Code is
	Mark J Crane <markjcrane@fusionpbx.com>
	Portions created by the Initial Developer are Copyright (C) 2008-2010
	the Initial Developer. All Rights Reserved.

	Contributor(s):
	Mark J Crane <markjcrane@fusionpbx.com>
*/

//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include '../../sangoma/check_referer.php';

include "root.php";
require_once "includes/config.php";
require_once "includes/checkauth.php";
$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

//if (ifgroup("admin")) {
	//access granted
//}
//else {
//	echo "access denied";
//	exit;
//}

// !+! jpboily : added user authentication + session initialization for 
// complete support of the file editor in ClearOS
if ( ifgroup("superadmin") || ifgroup("admin") || $_SERVER['REMOTE_ADDR'] == "127.0.0.1" ) {
  //access granted
} else {
  echo "access denied";
  exit;
}

if ( !isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']) ) 
{
  unset($_SESSION['embedded']);

  //FusionPBX Integration
  require_once "includes/header.php";
} 
elseif ( isset($_REQUEST['embedded']) || isset($_SESSION['embedded']) ) 
{
	//Includes required for ClearOS Integration
	include '../../sangoma/database_classes.php';	
	include '../../sangoma/display_class.php';
	
	$display_common = new Display_common;
	$display_common->session_vars("sqlite:../../sangoma/sqlite/cardinfo.db");
	$_SESSION['embedded'] = "true";
}



echo "<html>\n";
echo "<head>\n";
echo "	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n";
echo "	<title></title>";


	echo "<script type=\"text/javascript\" language=\"javascript\">\n";
	echo "// Replaces all instances of the given substring.\n";
	echo "String.prototype.replaceall = function(\n";
	echo "strTarget, \n"; // The substring you want to replace
	echo "strSubString \n"; // The string you want to replace in
	echo ")\n";
	echo "{\n";
	echo "  var strText = this;\n";
	echo "  var intIndexOfMatch = strText.indexOf( strTarget );\n";
	echo "  \n";
	echo "  // Keep looping while an instance of the target string\n";
	echo "  // still exists in the string.\n";
	echo "  while (intIndexOfMatch != -1){\n";
	echo "  // Relace out the current instance.\n";
	echo "  strText = strText.replace( strTarget, strSubString )\n";
	echo "  \n";
	echo "  // Get the index of any next matching substring.\n";
	echo "  intIndexOfMatch = strText.indexOf( strTarget );\n";
	echo "}\n";
	//echo "// Return the updated string with ALL the target strings\n";
	//echo "// replaced out with the new substring.\n";
	echo "return( strText );\n";
	echo "}\n";

	echo "function urlencode(str) {\n";
	echo "  str=escape(str); \n"; //Escape does not encode '/' and '+' character
	echo "  str=str.replaceall(\"+\", \"%2B\");\n";
	echo "  str=str.replaceall(\"/\", \"%2F\");\n";
	echo "  return str;\n";
	echo "}";
	echo "</script>\n";

	echo "<script type=\"text/javascript\" language=\"javascript\">\n";
	echo "    function makeRequest(url, strpost) {\n";
	//echo "        alert(url); \n";
	echo "        var http_request = false;\n";
	echo "\n";
	echo "        if (window.XMLHttpRequest) { // Mozilla, Safari, ...\n";
	echo "            http_request = new XMLHttpRequest();\n";
	echo "            if (http_request.overrideMimeType) {\n";
	echo "                http_request.overrideMimeType('text/xml');\n";
	echo "                // See note below about this line\n";
	echo "            }\n";
	echo "        } else if (window.ActiveXObject) { // IE\n";
	echo "            try {\n";
	echo "                http_request = new ActiveXObject(\"Msxml2.XMLHTTP\");\n";
	echo "            } catch (e) {\n";
	echo "                try {\n";
	echo "                    http_request = new ActiveXObject(\"Microsoft.XMLHTTP\");\n";
	echo "                } catch (e) {}\n";
	echo "            }\n";
	echo "        }\n";
	echo "\n";
	echo "        if (!http_request) {\n";
	echo "            alert('Giving up :( Cannot create an XMLHTTP instance');\n";
	echo "            return false;\n";
	echo "        }\n";
	//echo "        http_request.onreadystatechange = function() { returnContent(http_request); };\n";
	echo "        if (http_request.overrideMimeType) {\n";
	echo "              http_request.overrideMimeType('text/html');\n";
	echo "        }\n";
	//echo "        http_request.open('POST', url, true);\n";
	echo "        http_request.open('POST', url, false);\n";
	echo "\n";
	echo "\n";
	echo "        if (strpost.length == 0) {\n";
	echo "            alert('none');\n";
	echo "            //http_request.send(null);\n";
	echo "            http_request.send('name=value&foo=bar');\n";
	echo "        }\n";
	echo "        else {\n";
	//echo "            alert(strpost);\n";
	echo "            http_request.setRequestHeader('Content-Type','application/x-www-form-urlencoded');\n";
	//echo "            http_request.send('name=value&foo=bar');\n";
	echo "            http_request.send(strpost);\n";
	echo "        }\n";
	echo "\n";
	echo "    }\n";
	echo "\n";
	echo "    function returnContent(http_request) {\n";
	echo "\n";
	echo "        if (http_request.readyState == 4) {\n";
	echo "            if (http_request.status == 200) {\n";

	//echo "                  parent.editAreaLoader.setValue('edit1', http_request.responseText); \n";
	//echo "                alert(http_request.responseText);\n";
	echo "\n";
	//echo "                //var xmldoc = http_request.responseXML;\n";
	//echo "                //var root_node = xmldoc.getElementsByTagName('doc').item(0);\n";
	//echo "                //alert(xmldoc.getElementByID('fr1').value);\n";
	//echo "                //alert(root_node.firstChild.data);\n";
	//echo "\n";
	echo "            }\n";
	echo "            else {\n";
	echo "                alert('There was a problem with the request.');\n";
	echo "            }\n";
	echo "        }\n";
	echo "\n";
	echo "    }\n";
	echo "</script>";

  if(isset($_REQUEST) && isset($_REQUEST['file'])){
    $key = 'file';
    $value= $_REQUEST['file'];
  }else{
    $key = 'none';
    $value= 'none';
  }
			?>
<script language="Javascript" type="text/javascript">            
function getXMLHTTPRequest()
{
    var req = false;
    
    try
    {
        req = new XMLHttpRequest();		//Firefox, Chrome, IE7, Safari
    }
    catch(err1)
    {
        try
        {
            req = new ActiveXObject("Msxml2.XMLHTTP"); //IE5 and IE6
        }
        catch (err2)
        {
            try 
            {
                req = new ActiveXObject("Microsoft.XMLHTTP"); //Other versions of IE
            }
            catch(err3)
            {
                req=false;
            }
        }
    }
    
    return req;
}    
        
function before_save()
{ 
	//Creates an HTTP Request Object
	xmlhttp = getXMLHTTPRequest(); 
    
    <?php
  if ($key == "file" && $value == "sng-route-start") {
	?>
		//Sends an AJAX request to start a PHP script
		var url = "../../sangoma/route-stop.php";
		xmlhttp.open("GET",url,false);
		xmlhttp.send(null); 
		//var serverResponse = xmlhttp.responseText;
	  //  alert(serverResponse); // Shows "15"
    <?php
	}
?>
}
function confirm_save()
{ 
	//Creates an HTTP Request Object
	xmlhttp = getXMLHTTPRequest(); 
    
    <?php
	if ($key == "file" && $value == "dialplan/default.xml") {
	?>
			
    xmlhttp.onreadystatechange=function()
    {
 		if (xmlhttp.readyState==4 && xmlhttp.status==200)
        {
    		//document.getElementById("txtHint").innerHTML=xmlhttp.responseText;
            if (xmlhttp.responseText == 'good')
            {
        	   	alert('There was an ERROR reloading the dialplan!');
            }
        }
    }
     
	if (confirm("To reload dialplan, click OK [will not effect current calls]."))
	{
		//Sends an AJAX request to start a PHP script
		var url = "/fusionpbx/sangoma/cli_reload.php";
		xmlhttp.open("GET",url,true);
		xmlhttp.send(null);	        
	}
	else
	{
		alert("Changes will take effect on gateway restart.");
	}
    <?php
	}
	elseif ($key == "file" && $value == "autoload_configs/opal.conf.xml") {
	?>
		//Sends an AJAX request to start a PHP script
		var url = "../../sangoma/db_h323_update.php";
		xmlhttp.open("GET",url,true);
		xmlhttp.send(null);	
		
		alert ("H.323 Configuration Updated. Please restart the Gateway for the settings to come into effect.");
            
	<?php
	}
	elseif ($key == "file" && $value == "internal.xml") {
	?>
		//Sends an AJAX request to start a PHP script
		var url = "../../sangoma/db_sip.php";
		xmlhttp.open("GET",url,true);
		xmlhttp.send(null);	
		
		alert ("SIP Configuration Updated. Please restart the Gateway for the settings to come into effect.");
            
	<?php
	}	
	elseif ($key == "file" && $value == "sng-vlan-start") {
	?>
		var url = "../../sangoma/vlan-reload.php";
		xmlhttp.open("GET",url,false);
		xmlhttp.setRequestHeader('Content-Type',  "text/xml");
		xmlhttp.send(null); 
		var serverResponse = xmlhttp.responseText;
	    alert(serverResponse); // Shows "15"
	<?php
	}	
	elseif ($key == "file" && $value == "sng-route-start") {
	?>
		var url = "../../sangoma/route-reload.php";
		xmlhttp.open("GET",url,false);
		xmlhttp.setRequestHeader('Content-Type',  "text/xml");
		xmlhttp.send(null); 
		var serverResponse = xmlhttp.responseText;
	    alert(serverResponse); // Shows "15"
	<?php
	}	
	?>
}
</script>
    <?php

  if ( isset( $_REQUEST['full_screen'] ) )
    $full_screen = $_REQUEST['full_screen'];
  else
    $full_screen = "false";
  if ( isset( $_REQUEST['readonly'] ) )
    $readonly = $_REQUEST['readonly'];
  else
    $readonly = "false";

	?>
  <script language="javascript" type="text/javascript" src="<?php echo PROJECT_PATH; ?>/includes/edit_area/edit_area_compressor.php"></script>
	<script language="Javascript" type="text/javascript">

	// initialisation
		editAreaLoader.init({
			id: "edit1" // id of the textarea to transform
			,start_highlight: true
			,allow_toggle: false
			,language: "en"
      ,syntax: "xml"
      ,browsers: "all"
      ,word_wrap: true
      , font_size: "8"
<?php if ( "true" == $full_screen ) {
      //echo ", fullscreen: true";
      if ("true" == $readonly)
        echo ",toolbar: 'search, go_to_line,|, undo, redo, |, syntax_selection, |, change_smooth_selection, highlight, reset_highlight, word_wrap '";
      else
        echo ",toolbar: 'save, |, search, go_to_line,|, undo, redo, |, syntax_selection, |, change_smooth_selection, highlight, reset_highlight, word_wrap '";
      } else {
      if ("true" == $readonly)
        echo ",toolbar: 'search, go_to_line,|, fullscreen, |, undo, redo, |, select_font, |, syntax_selection, |, change_smooth_selection, highlight, reset_highlight, word_wrap, |, help'";
      else
        echo ",toolbar: 'save, |, search, go_to_line,|, fullscreen, |, undo, redo, |, select_font, |, syntax_selection, |, change_smooth_selection, highlight, reset_highlight, word_wrap, |, help'";
      } ?> 
			,syntax_selection_allow: "css,html,js,php,xml,c,cpp,sql"
			,show_line_colors: true
			,load_callback: "my_load"
			,save_callback: "my_save"
    });
		// callback functions
		function my_save(id, content){
				before_save();
		        //alert(content);
            	makeRequest('filesave.php','file='+document.getElementById('file').value+'&content='+urlencode(content));

		        parent.document.title=''+unescape(document.getElementById('file').value)+' :: Saved';
		        //setTimeout("parent.document.title='<?=$applicationname?> - '+unescape(document.getElementById('file').value);", 5);
		        //setTimeout("alert('test')", 5);
				confirm_save();
		}

		function my_load(elem){
			elem.value="The content is loaded from the load_callback function into EditArea";
		}


		function my_setSelectionRange(id){
			editAreaLoader.setSelectionRange(id, 0, 0);
		}

		function test_setSelectionRange(id){
			editAreaLoader.setSelectionRange(id, 0, 0);
		}

		function test_getSelectionRange(id){
			var sel =editAreaLoader.getSelectionRange(id);
			alert("start: "+sel["start"]+"\nend: "+sel["end"]);
		}

		function test_setSelectedText(id){
			text= "[REPLACED SELECTION]";
			editAreaLoader.setSelectedText(id, text);
		}

		function test_getSelectedText(id){
			alert(editAreaLoader.getSelectedText(id));
		}

  	</script>

</head>
<?php
//<body marginwidth="0" marginheight="0" style="margin: 0" onresize="elem = document.getElementById('edit1'); elem.style.height='100%';  elem.style.width='100%'; document.getElementById('toolbar').style.width='200px';">
?>

<table border='0' style="height: 100%; width: 100%;">
<tr>
<!-- File List: Requires IFRAME support -->
<?php 
  if ( "false" == $full_screen ) {
  // Show the file list only when not in full screen mode
    echo "<td id='toolbar' valign='top' width='200' style='width: 200;' height='100%' nowrap>";
    echo "<IFRAME SRC='filelist.php' style='border: solid 1px #CCCCCC; height: 100%; width: 100%;' TITLE=''>";
    echo "</IFRAME>";
    echo "</td>";
  }
?>
<td valign='top' width="100%" height='100%' style="height: 100%;">
<?php
  $filename = "";
      
  if ( isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false) ) {
		//IE doesn't work with the 100% width with the IFRAME
    echo "<textarea id='edit1' style='height: 100%; width: 800px;' name=''>\n";
	} else {
		echo "<textarea id='edit1' style='height: 100%; width: 100%;' name=''>\n";
  }

  // If the parameter file=filename is set in the request, load its content in 
  // the file editor
  if ( isset( $_REQUEST['file'] ) ) {
	  if (trim($_REQUEST['file']) == "sng-vlan-start")
		$filename = "/usr/local/sng/bin" . '/'. $_REQUEST['file'];
    elseif (trim($_REQUEST['file']) == "sng-route-start")
		$filename = "/usr/local/sng/bin" . '/'. $_REQUEST['file'];
	  elseif ($_REQUEST['file'] == "internal.xml")
	  	$filename = "/usr/local/nsg/conf/sip_profiles/" . $_REQUEST['file'];
	  else
    	$filename = $_SESSION['smg_path'] . '/' . $_REQUEST['file'];
    echo file_get_contents($filename);
  }
  
  echo "</textarea>\n";

  // Set the hidden file input value to $filename for the save method
  echo "<input type='hidden' id='file' name='file' value='" . $filename . "' />";
?>
</td>
</tr>
</table>

<?php
/*
echo "    <p>Custom controls:<br />\n";
echo "    	<input type='button' onclick='alert(editAreaLoader.getValue(\"edit1\"));' value='get value' />\n";
echo "    	<input type='button' onclick='editAreaLoader.setValue(\"edit1\", \"new_value\");' value='set value' />\n";
echo "    	<input type='button' onclick='test_getSelectionRange(\"edit1\");' value='getSelectionRange' />\n";
echo "    	<input type='button' onclick='test_setSelectionRange(\"edit1\");' value='setSelectionRange' />\n";
echo "    	<input type='button' onclick='test_getSelectedText(\"edit1\");' value='getSelectedText' />\n";
echo "    	<input type='button' onclick='test_setSelectedText(\"edit1\");' value='setSelectedText' />\n";
echo "    	<input type='button' onclick='editAreaLoader.insertTags(\"edit1\", \"[OPEN]\", \"[CLOSE]\");' value='insertTags' />\n";
echo "    </p>";
*/
?>

</body>
</html>
