<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();

include 'sangoma/display_class.php';
$display_common = new Display_common;
//Checks to make sure the user is logged into the WebUI
if ( $display_common->IsRenderingNonDynamicDiv( ) ) {
	if (empty($_POST))
		include 'sangoma/check_referer.php';
}

$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

include "root.php";
if (!file_exists($_SERVER['DOCUMENT_ROOT'].PROJECT_PATH."/includes/config.php")){
	header("Location: ".PROJECT_PATH."/install.php");
	exit;
}
require_once "includes/config.php";
require_once "includes/checkauth.php";
include "sangoma/database_classes.php";

$data = new database_class;

// ************************************************************************************
// HEADER 
// ************************************************************************************
//print_r( $_SERVER );
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
	unset($_SESSION['embedded']);
	
	//FusionPBX Integration
	require_once "includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
	//Includes required for ClearOS Integration
	include 'sangoma/sqlite/database_creation.php';

	
	$_SESSION['embedded'] = "true";
	
	//ClearOS Integration
	$display_common->session_vars("sqlite:sangoma/sqlite/cardinfo.db");
	$display_common->html_header();
	$display_common->html_title("MG Status", "../style.css","");		

}	

// Enable dynamic Div 
$display_common->DynamicDivEnable();

// Auto refresh dynamic Div 
$display_common->DynamicDivAutoRefresh();

$display_common->DynamicDivBegin( "MgStatusDiv" );

if ($display_common->IsRenderingNonDynamicDiv() || $display_common->IsDynamicDivRefreshRequest('MgStatusDiv')) {

  if (!$display_common->IsGatewayRunning())
  {
    $display_common->WarningBox( $_SESSION['name'] . " not started\n" );
  }
  else
  {
	  display_mg_table($data);
  }
}
$display_common->DynamicDivEnd( "MgStatusDiv" );


if ( $display_common->IsRenderingNonDynamicDiv( ) )
{
	// ************************************************************************************
	// FOOTER
	// ************************************************************************************
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}


function display_mg_table($data) {
	//pull all profile names
	$profile_array = pull_data('mg_profiles','name',$data);
	?>
    <br />
    <?php
		$a = 0;
      	foreach ($profile_array as $profile) {
			//run nsg_cli command
			$cmd = $_SESSION['cli'] . ' -x "mg profile ' . $profile['name'] . ' show stats"';
			echo "<table class='mytable' width='700px'>";
			echo "<th colspan='5' class='widget-content-header ui-state-active ui-corner-top' align='left'>" . $profile['name'] . " Status</th>";
			unset($output);
			exec ($cmd,$output);
			foreach ($output as $out) {
				$exploded_out = explode ('=',$out);
				foreach ($exploded_out as $values) {
					if (trim($values[0]) != "") {
						echo "<tr>\n";
						echo "<td class='mytablesubheader' width='50%'>".$exploded_out[0]."</td>";
						if (($a % 2) == 0)
							echo "<td bgcolor=" . COLOR_ROW_EVEN . " >";
						else
							echo "<td bgcolor=" . COLOR_ROW_ODD . " >";

						echo $exploded_out[1] . "<br />";
						echo "</td>\n";
						echo "</tr>\n";
					}
				}
				$a++;
			}
			echo "<th class='widget-content-header ui-state-active ui-corner-bottom' colspan='2'/>";
			echo "</table>";

		}
	?>
    <?php
}

/**
*	Pulls data out of the database and returns it in an array
*	@param table
*			database table name
*	@param param
*			sql select parameter
*	@param $data
*			database object
*	@return array
*/
function pull_data($table,$param,$data) {
	$c = 0;
	$profile_array = array();
	
	//Table exists
	if ($data->check_for_table ('sqlite:sangoma/sqlite/cardinfo.db', $table) > 1)
	{
		$select = "SELECT " . $param . " FROM " . $table . ";";

		try
		{
			//open the database
			$db = new PDO('sqlite:sangoma/sqlite/cardinfo.db');

			$result = $db->query($select);
		
			foreach($result as $row)
			{
				$profile_array[$c] = $row;
				$c++;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}
	}	
	
	return $profile_array;
	
}
?>