<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/
session_start();
include 'sangoma/display_class.php';
$display_common = new Display_common;
//Checks to make sure the user is logged into the WebUI
if ( $display_common->IsRenderingNonDynamicDiv( ) ) {
	if (empty($_POST))
		include 'sangoma/check_referer.php';
}
$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

include "root.php";
if (!file_exists($_SERVER['DOCUMENT_ROOT'].PROJECT_PATH."/includes/config.php")){
	header("Location: ".PROJECT_PATH."/install.php");
	exit;
}
require_once "includes/config.php";
require_once "includes/checkauth.php";
include "sangoma/database_classes.php";
include "sangoma/production-test/prod-test-class.php";


if ($_REQUEST['logs'] == "Download")
{
	//Download the logs
	$prod = new prod_test;
	$prod->main_smg_path = $_SESSION['smg_root_path'];
	
	$prod->files_to_send();
      $filename = $_REQUEST['file'];
     $properFilename = $_REQUEST['properFilename'] . '.tgz';

    header("Content-Disposition: attachment; filename=\"".basename($properFilename)."\";" );
     header("Content-Transfer-Encoding: binary");
    header("Content-Length: ".filesize($filename));
    readfile("$filename");
    //exit();  
}

// ************************************************************************************
// HEADER 
// ************************************************************************************
//print_r( $_SERVER );
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
	unset($_SESSION['embedded']);
	
	//FusionPBX Integration
	require_once "includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
	//Includes required for ClearOS Integration
	include 'sangoma/sqlite/database_creation.php';
	
	$_SESSION['embedded'] = "true";
	
	//ClearOS Integration
	$display_common->session_vars("sqlite:sangoma/sqlite/cardinfo.db");
	$display_common->html_header();
	$display_common->html_title("Overview", "../style.css","");		

// ************************************************************************************
// BODY 
// ************************************************************************************

	// Enable dynamic Div 
	$display_common->DynamicDivEnable();
}

define( "COLOR_OK" , 		"#8BB381"); // Kind of Dark Sea Green
define( "COLOR_ERROR" , 	"#E42217"); // Kind of Firebrick
define( "COLOR_WARN" , 	"#FE642E"); // Kind of Firebrick

// Auto refresh dynamic Div 
$display_common->DynamicDivAutoRefresh("style='width:700px'");

if ( $display_common->IsRenderingNonDynamicDiv( )) 
{
	$display_common->Download_log("style='width:700px'");
}
if ( $display_common->IsRenderingNonDynamicDiv( )) 
{
  echo "
    <script type='text/javascript'>
      function displayLogTab( logType )
      {
        // Retrieve all div elements
        var aDivList = document.getElementsByTagName('div');
        for (var i = 0; i < aDivList.length; i++) {
          // check if div is a log div
          if ( -1 != aDivList[i].id.indexOf( '_log' ) )
          {
            // Check if it's the one we want to display
            if ( aDivList[i].id == logType + '_log' )
            {
              // change style to block
              aDivList[i].style.display = 'block'; 
            }
            else
            {
              // change style to none
              aDivList[i].style.display = 'none'; 
            }
          }
        }
        // Retrieve all div elements
        var aDivList = document.getElementsByTagName('th');
        for (var i = 0; i < aDivList.length; i++) {
          // check if div is a tab div
          if ( -1 != aDivList[i].id.indexOf( '_tab' ) )
          {
            // Check if it's the one we want to modify
            if ( aDivList[i].id == logType + '_tab' )
            {
              // change style to block
              aDivList[i].setAttribute( 'class', 'widget-content-header ui-state-active ui-corner-top');
            }
            else
            {
              // change style to none
              aDivList[i].setAttribute( 'class', 'widget-content-header ui-corner-top');
            }
          } 
        }
        ResizeFrame();
      };
      window.onload = function() {displayLogTab( 'Gateway' );}; 
    </script>\n";
  // Use a tab to create tabbed selection
  echo "<table width='700px'>\n";
  echo " 	<th width='10%' id='Gateway_tab' class='widget-content-header ui-corner-top'>\n";
  echo "   <a href='javascript:displayLogTab(\"Gateway\")'>Gateway</a></th>\n";
  echo " 	<th width='10%' id='Driver_tab' class='widget-content-header ui-corner-top'>\n";
  echo "   <a href='javascript:displayLogTab(\"Driver\")'>Driver</a></th>\n";
  echo " 	<th width='10%' id='Media_tab' class='widget-content-header ui-corner-top'>\n";
  echo "   <a href='javascript:displayLogTab(\"Media\")'>Media</a></th>\n";
  echo " 	<th style=\"background-color:white;\">\n";
  echo "  <tr>\n";
  echo "    <td colspan='4' border='1'>\n";
}

// Log messages
  if ( $display_common->IsRenderingNonDynamicDiv( ) 
  || $display_common->IsDynamicDivRefreshRequest("Driver_log") ) 
{
  $display_common->DynamicDivBegin( "Driver_log", "display:none" );
  // Driver log
  logTable( "Driver", "grep /var/log/messages -e 'wanpipe' | tail -n 500 ");
  $display_common->DynamicDivEnd( "Driver_log", "display:none" );
}
// Log messages
  if ( $display_common->IsRenderingNonDynamicDiv( ) 
  || $display_common->IsDynamicDivRefreshRequest("Gateway_log") ) 
{
  $display_common->DynamicDivBegin( "Gateway_log", "display:none" );
  // Driver log
  logTable( "Gateway", "tail -n 10000 " . $_SESSION['smg_location'] . "/log/sangomagw.log | grep -v DEBUG | sed '/STACK_LOG_BEGIN/,/STACK_LOG_END/d' | tail -n 500 ");
  $display_common->DynamicDivEnd( "Gateway_log" );
}
// Log messages
  if ( $display_common->IsRenderingNonDynamicDiv( ) 
  || $display_common->IsDynamicDivRefreshRequest("Media_log") ) 
{
  $display_common->DynamicDivBegin( "Media_log", "display:none" );
  // Driver log
  logTable( "Media", "grep -v 'DEBUG' /var/log/sngtc_server.log | tail -n 500 ");
  $display_common->DynamicDivEnd( "Media_log" );
}

if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
{
  echo "    </td>\n";
  echo "  </tr>\n";
  echo "</table>\n";
	// ************************************************************************************
	// FOOTER
	// ************************************************************************************
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}

function LogTable( $in_title, $in_execCmd, $in_maxEntry = 500 )
{
  // Display table with log lines
  echo "   	<table border='0' style='border: 1px solid lightgrey;' width='100%'>\n";

  // Execute niced command
  exec( "nice " . $in_execCmd, $execRc );

  for ($logIndex=0; $logIndex<$in_maxEntry; $logIndex++)
  {
    $logLine = $execRc[$logIndex];
    if (strlen($logLine) == 0)
      $logLine = "&nbsp;";
    echo "		  	<tr class='ui-state-active' style='background-color:" . ((($i++)%2)?"#E8E8E8":"#FFFFFFFF") ."'>\n";
    echo "						<td colspan='2'>\n";
    if ( preg_match( "/WARN/", $logLine ) > 0 )
      echo "<font color='". COLOR_WARN . "'><strong>".  $logLine . "</strong></font>\n";
    elseif ( preg_match( "/ERROR/i", $logLine ) > 0 || preg_match( "/ERR/", $logLine ) > 0 )
      echo "<font color='". COLOR_ERROR . "'><strong>".  $logLine . "</strong></font>\n";
    else
      echo                $logLine . "\n";
    echo "            </td>\n";
    echo "	   		</tr>\n";
    unset($logLine);
  }
  unset( $execRc );
  // Close table
  echo "    </table>\n";
}
?>
