#!/bin/bash

DESTDIR=${1:-/usr/local/nsg}
CURRENT_DIR=`pwd`
err=0;

#Check that ldd exists
eval "type ldd > /dev/null 2> /dev/null"
if [ $? -ne 0 ]; then
	echo "Error: ldd utility cannot be found"
	#Do not return non zero as Make install will fail
	exit 0
fi	

if [ ! -e $DESTDIR ]; then
	echo "Directory $DESTDIR does not exist"
	exit 1
fi

cd $DESTDIR

#find all regular files
FILES=`find .  -type f | xargs`

# If there is no Files in side $DESTDIR nsg folder that means its first time installation ,
# use current directory(NSG Installer) libs/bin to check dependencies
if [ -e $FILES ]; then
	cd $CURRENT_DIR

	# Changing LD_LIBRARY_PATH to pick libs from this current directory libraries
	if test `uname -m` = x86_64; then
		export LD_LIBRARY_PATH=$CURRENT_DIR/nsg/usr/lib64
	else
		export LD_LIBRARY_PATH=$CURRENT_DIR/nsg/usr/lib
	fi

	export LD_LIBRARY_PATH=$CURRENT_DIR/nsg/lib:$LD_LIBRARY_PATH
	FILES=`find .  -type f | xargs`
fi

echo
echo "NSG Checking for dependencies"
echo "------------------------------"
for app in $FILES
do
	if [ -e $app ]; then

		#Check that file type is ELF
		bin_file=`file $app | grep ELF`
		if [ "$bin_file" = "" ]; then
			continue
		fi 
	
		#Check for missing dependencies	
		dep=`ldd $app 2> /dev/null | grep "not found"`
		if [ "$dep" != "" ]; then
			echo "Error: $app missing dependecy: $dep"
			err=$((err+1))
		fi 	

	fi
done

if [ -f /etc/debian_version ] || [ -f /etc/debian_release ]; then
  if [ ! -e /sbin/insserv ]; then
    echo "Error: insserv not installed"
    err=$((err+1))
  fi
fi

echo "------------------------------"
if [ $err -eq 0 ]; then
	echo "NSG dependency check: OK"
else
	echo "NSG dependency check: Failed!"
fi
echo

exit $err
