/*
 * libsngtc-node
 * Sangoma Transcoder Node Library
 *
 * Copyright (C) 2010 Sangoma Technologies
 * Nenad Corbic <ncorbic@sangoma.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *
 * Moises Silva <moy@sangoma.com>
 *
 */

#ifndef __LIB_SNGTC_NODE_UTILS_H__
#define __LIB_SNGTC_NODE_UTILS_H__


#define MAX_SNGTC_SESSIONS 5000

typedef struct sngtc_rtp_session
{
	uint32_t init;
	uint32_t index;
	uint32_t server_rtp_index;
	uint32_t server_mod_index;
	struct sngtc_codec_request codec_req;
	struct sngtc_codec_reply codec_reply;
}sngtc_rtp_session_t;


typedef struct iana_to_profile
{
	int init;
	unsigned int codec_id;
	unsigned int iana_code;
}iana_to_profile_t;

extern sngtc_rtp_session_t sngtc_rtp_session_table[];

extern sngtc_init_cfg_t g_init;

int sngtc_verify_init_cfg(sngtc_init_cfg_t *cfg);
int sngtc_set_iana_code_based_on_codec_id(uint32_t codec_id, uint32_t iana);
int sngtc_set_soap_server_url(const char *url);
int sngtc_get_soap_server_url(char *url, size_t len);


#endif

