/*
 * OS Abstraction for Sangoma Transcoder Library
 *
 * Author(s): David Rokhvarg <davidr@sangoma.com>
 *
 * Copyright (C) 2010 Sangoma Technologies
 */

#ifndef _SNG_TC_OS_H
#define _SNG_TC_OS_H
#ifdef WIN32
//#include <winsock2.h>
#define _WINSOCKAPI_
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <time.h>
#include <conio.h>

#if defined(LIBSNGTC_EXPORTS) || defined(LIBSNGTC_NODE_EXPORTS)
# define _SNGTC_API __declspec(dllexport)
#else
# define _SNGTC_API __declspec(dllimport)
#endif

#define _SNGTC_CALL __cdecl
#define SNG_INLINE __inline

#define sngtc_snprintf		_snprintf
#define sngtc_strncasecmp	_strnicmp
#define sngtc_vsnprintf		vsnprintf

/* signed */
#define int8_t	INT8
#define int16_t INT16
#define int32_t INT32
#define int64_t INT64
/* unsigned */
#define uint8_t	 UINT8
#define uint16_t UINT16
#define uint32_t UINT32
#define uint64_t UINT64

#define uint	UINT

/*#define IF_NAMESIZE 128*/

#define sngtc_thread_t			DWORD
#define sngtc_mutex_t			CRITICAL_SECTION
#define sngtc_mutex_init(a,b)	InitializeCriticalSection(a)
#define sngtc_mutex_destroy(a)	/* no-op */
#define sngtc_lock(lock)		EnterCriticalSection(lock)
#define sngtc_unlock(lock)		LeaveCriticalSection(lock)
#define sngtc_getpid			GetCurrentThreadId
#define sngtc_strtok_r(a,b,c)	strtok(a,b)
#define sngtc_thread_exit(a)	ExitThread((DWORD)a)
#define sngtc_thread_id			GetCurrentThreadId

/* translate microseconds into milliseconds and call Sleep() */
#define sngtc_mircoseconds_sleep(microseconds) Sleep(microseconds / 1000)

/* translate seconds into milliseconds and call Sleep() */
#define sngtc_seconds_sleep(seconds)	Sleep(seconds * 1000)

#else /* WIN32 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdint.h>
#include <stdarg.h>
#include <pthread.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/netlink.h>
#include <sys/types.h>
#include <netinet/ether.h>
#include <unistd.h>
#include <sys/socket.h>
#include <net/if.h>
#include <errno.h>
#include <string.h>
#include <time.h>


#define _SNGTC_CALL
#define _SNGTC_VAR
#define _SNGTC_API

#define SNG_INLINE inline
#define _SNGTC_CALL

#define sngtc_snprintf		snprintf
#define sngtc_strncasecmp	strncasecmp
#define sngtc_vsnprintf		vsnprintf

#define sngtc_thread_t			pthread_t
#define sngtc_mutex_t			pthread_mutex_t
#define sngtc_mutex_init(a,b)	pthread_mutex_init(a,b)
#define sngtc_mutex_destroy(a)	pthread_mutex_destroy(a)
#define sngtc_lock(lock)		pthread_mutex_lock(lock)
#define sngtc_unlock(lock)		pthread_mutex_unlock(lock)
#define sngtc_getpid			getpid
#define sngtc_strtok_r(a,b,c)	strtok_r(a,b,c)
#define sngtc_thread_exit		pthread_exit
#define sngtc_thread_id			pthread_self
#define IN
#define OUT

#define sngtc_mircoseconds_sleep(microseconds)	usleep(microseconds) 
#define sngtc_seconds_sleep(seconds)			sleep(seconds)

#endif /* !WIN32 */

_SNGTC_API struct tm * _SNGTC_CALL sngtc_localtime_r(IN time_t *system_time, OUT struct tm * now);
_SNGTC_API void _SNGTC_CALL sngtc_date_and_time_format(char *date_buffer, int date_buffer_size);

#endif /* _SNG_TC_OS_H */
