/*******************************************************************************
*
* Title: sangoma_isup.h
*
* Description: Sangoma_Isup library header file
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 02-12-2010
*
*******************************************************************************/

/******************************************************************************/
#ifndef __SNG_ISUP_H__
# define __SNG_IUSP_H__
/******************************************************************************/

#ifdef __linux__
#include <linux/limits.h>
#endif

/* defines ********************************************************************/
#define S_PROC                  1                   /*this is the global PROC value to use*/
#define S_INST                  0                   /*global INSTantous value*/
#define S_REG                   0                   /*memory region value*/
#define S_POOL                  0x01                /*memory pool value*/
#define POOL_LW_TR              1
#define POOL_UP_TR              6
/******************************************************************************/

/* Limits *********************************************************************/
#define MAX_ISAPS			2
#define MAX_NSAPS			2
#define MAX_ISUP_CKTS		8192                /* max number of Circuits */
#define MAX_ISUP_INFS		12                  /* max number of SSPs */
#define MAX_MTP_ROUTES		100                 /* max number of routes configurable*/
#define MAX_MTP_LINKSETS	16                  /* max number of link sets configurable*/
#define MAX_MTP_LINKS		200                  /* max number of links configurable*/
#define MAX_RELAY_CHANNELS	16					/* max number of relay channels */
/******************************************************************************/

/* Relay Defines **************************************************************/
#define RY_PERIOD				10					/* relay timer period */
#define RY_TX_KP_ALIVE_TMR		10					/* TX TCP keep alive timer */
#define RY_RX_KP_ALIVE_TMR		50					/* RX TCP keep alive timer */
#define RY_BT_TMR				10					/* Boot Timer */
#define MAX_RELAY_CONGTHRSH		2					/* Congestion Threshold */
#define MAX_RELAY_NMBSCAN		5					/* Number of times to scan queue on read */

/* SI Defines *****************************************************************/
#define MAX_SI_VARIANTS         2                   /* max number of ISUP variants running at once */
#define MAX_SI_CIR              MAX_CC_CIRCUITS     /* same as CC */
#define MAX_SI_INTERFACES       12                  /* max number of SSPs */
#define MAX_SI_CIR_GRP          99                  /* max number of circuit groups */
#define MAX_SI_CALL_REF         4092                /* max number of active calls */
#define MAX_SI_USER_2_USER_LEN  255                 /* max size of user to user messages */
#define SI_PERIOD               10                   /* period used for timers...10,000 = 0.1s */
#define SI_LINK_SELECTION       LSI_LNKSEL_CIC      /* link is selected by cic */
/******************************************************************************/

/* SN Defines *****************************************************************/
#define MAX_SN_VARIANTS         2					/* max number of mtp3 upper saps...1 per variant */
#define MAX_LINKS_IN_LINKSET    16					/* max numbber of links in a linkset configurable*/
#define MAX_SLTM_RETRIES        2					/* number of times to send SLTM without SLTA before dropping link*/
#define SN_CB_PERIOD            10					/* 0.1ms timer resolution for CB timers in SN */
#define SN_SP_PERIOD            10					/* 0.1ms timer resolution for SP timers in SN */
#define SN_RTE_PERIOD           10					/* 0.1ms timer resolution for RTE timers in SN */
#define MAX_SN_MSG_SIZE         272
#define MAX_SN_CREDIT           128
/******************************************************************************/

/* SD Defines *****************************************************************/
#define MAX_SD_OUTSTANDING      8                  /* max number of outstanding frames */
#define MAX_SD_FRAME_LEN        273                 /* max frame length */
#define MAX_SD_SUERM            100                  /* SUERM threshold */
#define MAX_SD_AERM_EMERGENCY   10                  /* AERM threshold emergency */
#define MAX_SD_AERM_NORMAL      10                  /* AERM threshold normal */
#define MAX_SD_MSU_RETRANS      30                  /* max number of MSU to queue for retrans */
#define MAX_SD_OCTETS_RETRANS   4096                /* max number of octets to queue for retrans */
#define MAX_SD_ALIGN_ATTEMPTS   100                 /* max number of alignment attempts */
/******************************************************************************/


/* TUCL Defines *****************************************************************/
#define HI_MAX_SAPS 			1000 		/* max number of TUCL SAPs*/
#define HI_MAX_NUM_OF_CON 		100 		/* max number of TUCL connection*/
#define HI_MAX_NUM_OF_FD_PER_SET 	1024 	 	/* maximum num of fds to use per set */	
#define HI_MAX_NUM_OF_FD_HASH_BINS 	16 	  	/*for fd hash lists*/	
#define HI_MAX_NUM_OF_CLIENT_TO_ACCEPT 	5 	  	/* clients to accept simultaneously */	
#define HI_MAX_SELECT_TIMEOUT_VALUE 	20 	  	/* select() timeout */	
#define HI_MAX_SCHED_TMR_VALUE 		2 	        /* Schedule Timer value */	
#define HI_MAX_RAW_MSG_TO_READ 		10 	        /* number of raw messages to read in one iteration */ 
#define HI_MAX_UDP_MSG_TO_READ 		20 	        /* number of UDP messages to read in one iteration */ 
#define HI_MEM_POOL_START_THRESHOLD 	4 	        /* thresholds for congestion on the memory pool */ 
#define HI_MEM_POOL_DROP_THRESHOLD 	2 	        /* thresholds for congestion on the memory pool */ 
#define HI_MEM_POOL_STOP_THRESHOLD 	5 	        /* thresholds for congestion on the memory pool */ 
#define HI_SAP_TXN_QUEUE_CONG_START_LIMIT 10000 	/* Transaction Queue congestion start limit */ 
#define HI_SAP_TXN_QUEUE_CONG_DROP_LIMIT  20000 	/* Transaction Queue congestion drop limit */ 
#define HI_SAP_TXN_QUEUE_CONG_STOP_LIMIT  8000 		/* Transaction Queue congestion STOP limit */ 

/******************************************************************************/


/* SCTP Defines *****************************************************************/
#define SB_MAX_SCT_SAPS 	      1000 		/* max no. SCT SAPS */
#define SB_MAX_T_SAPS 	              1000 		/* max no. Transport SAPS */
#define SB_MAX_NUM_OF_ENDPOINTS       1000 		/* max no. endpoints */	
#define SB_MAX_NUM_OF_ASSOC           1000 		/* max no. association */	
#define SB_MAX_NUM_OF_DST_ADDR        25 		/* max no. dest. addresses */	
#define SB_MAX_NUM_OF_SRC_ADDR        25 		/* max no. source addresses */	
#define SB_MAX_NUM_OF_TX_CHUNKS       95000 		/* max no. transmitting chunks */	
#define SB_MAX_NUM_OF_RX_CHUNKS       95000 		/* max no. receiving chunks */	
#define SB_MAX_INC_STREAMS            10 		/* max no. incoming streams */	
#define SB_MAX_OUT_STREAMS            10 		/* max no. outgoing streams */	
#define SB_MAX_RWND_SIZE              64000 		/* size of RWND in init and init-ack*/
#define SB_MTU_INITIAL                1500 		/* size of MTU */
#define SB_MTU_MIN_INITIAL            1500 		/* MTU MIN */
#define SB_MTU_MAX_INITIAL            1500 		/* MTU MAX */
/******************************************************************************/


/* M2UA Defines *****************************************************************/

#define MW_MAX_NUM_OF_INTF 	      LMW_MAX_INTF 	/* max no. Interface */
#define MW_MAX_NUM_OF_CLUSTER 	      6 		/* max no. Cluster  */
#define MW_MAX_NUM_OF_PEER 	      6 		/* max no. Peer     */
#define MW_MAX_NUM_OF_SCT_SAPS 	      SB_MAX_SCT_SAPS   /* max no. SCT SAPs  */
#define MW_MAX_CLUSTER_Q_SIZE 	      100   		/* max no. Cluster Queue Size */
#define MW_MAX_INTF_Q_SIZE 	      30   		/* max no. Interface Queue Size */

/******************************************************************************/


/* NIF Defines *****************************************************************/
#define NW_MAX_NUM_OF_DLSAPS 	      1000 		/* max no. of DLSAPs */
#define NW_MAX_NUM_OF_RETRY 	      5 		/* max no. of Retry */
#define NW_RETRY_TMR_VALUE 	      10 		/* Retry Timer Value */



/* ****************************************************************************/
#define LIBSNG_SS7_WAIT_SLEEP		1
#define LIBSNG_SS7_TIMEOUT		2000					/* cfg/sta/cntrl/sts request */ 
										/* timeout ( LIBSNG_SS7_WAIT_SLEEP * LIBSNG_SS7_TIMEOUT = Timeout  sec ) */
#ifndef sng_msleep
#define sng_msleep(x) usleep(x*1000)
#endif

#define LIBSNG_WAIT_FOR_CMD_RESULT(tid) do { \
	int timer = 0; \
	while (sng_state[tid].ret == SNG_INVALID_TRANSID) { \
		sng_msleep(LIBSNG_SS7_WAIT_SLEEP); \
		timer++; \
                if (timer > LIBSNG_SS7_TIMEOUT) { \
                        SNG_LOG(SNG_LOGLEVEL_CRIT, "%s():%d SS7 Command timed out for transid=%i\n", __FUNCTION__,__LINE__, tid); \
                        sng_state[tid].ret = -1; \
                        SS7D_ASSERT; \
			break; \
		} \
	} \
	if (timer < LIBSNG_SS7_TIMEOUT) { \
		if (timer*LIBSNG_SS7_WAIT_SLEEP > 500) { \
			SNG_LOG(SNG_LOGLEVEL_WARN, "%s():%d SS7 Command delayed %i ms transid=%i\n", __FUNCTION__,__LINE__,timer*LIBSNG_SS7_WAIT_SLEEP, tid); \
		} else if (timer*LIBSNG_SS7_WAIT_SLEEP > 100) { \
			SNG_LOG(SNG_LOGLEVEL_WARN, "%s():%d SS7 Command delayed %i ms transid=%i\n", __FUNCTION__,__LINE__, timer*LIBSNG_SS7_WAIT_SLEEP, tid); \
		} else if (timer*LIBSNG_SS7_WAIT_SLEEP > 10) { \
			SNG_LOG(SNG_LOGLEVEL_DEBUG, "%s():%d SS7 Command delayed %i ms transid=%i\n", __FUNCTION__,__LINE__, timer*LIBSNG_SS7_WAIT_SLEEP, tid); \
		} \
	} \
	} while (0);


/* General includes/defines ***************************************************/
#ifdef __LINUX__
#include <stdint.h>
#endif

#ifdef __WINDOWS__
#endif

#include "envopt.h"        /* environment options */
#include "envdep.h"        /* environment dependent */
#include "envind.h"        /* environment independent */

#include "gen.h"           /* general layer */
#include "ssi.h"           /* system services */
#include "cm_ss7.h"

#include "cm_tpt.h"
#include "cm_inet.h"
#include "cm_dns.h"
#include "sct.h"

#include "lcc.h"           /* Call Contrl layer management */
#include "lsi.h"           /* ISUP layer management */
#include "lsn.h"           /* MTP3 layer management */
#include "lap.h"           /* MTP3 layer management */
#include "lsd.h"           /* MTP2 layer management */
#include "ll1.h"           /* Layer 1 layer management */
#include "lry.h"
#include "lhi.h"	   /* Convergence layer management */
#include "lsb.h"	   /* SCTP layer management */
#include "hit.h"
#include "lmw.h"           /* M2UA */
#include "lnw.h"           /* M2UA NIF */

#include "sit.h"           /* ISUP */
#include "mac.h"
#include "sdt.h"		   /* SD disconnect reasons */

#include "gen.x"           /* general layer */
#include "ssi.x"           /* system services */
#include "cm_ss7.x"
#include "cm_tpt.x"
#include "cm_inet.x"
#include "sct.x"

#include "lcc.x"           /* Call Control layer managament */
#include "lsi.x"           /* ISUP layer management */
#include "lsn.x"           /* MTP3 layer management */
#include "lap.x"           /* MTP3 layer management */
#include "lsd.x"           /* MTP2 layer management */
#include "ll1.x"           /* layer1 layer management*/
#include "lry.x"
#include "lhi.x"           /* Convergence layer management */
#include "lsb.x"	   /* SCTP layer management */

#include "hit.x"	   /* TUCL */
#include "sit.x"           /* ISUP */
#include "mac.x"           /* Layer1 */
#include "lmw.x"           /* M2UA */
#include "lnw.x"           /* M2UA NIF */

#include "sng_ss7_error.h"

/******************************************************************************/

/* Limits *********************************************************************/
#define MAX_CC_INTERFACE        5                   /* max number of CC interfaces */
#define MAX_SI_CIRCUITS         4096                /* max number of Circuits */
#define MAX_SI_INTERFACES       12                  /* max number of SSPs */
#define MAX_SN_INTERFACE        5                   /* max number of MTP3/ISUP type combinations...limited to 5 for now */
#define MAX_SN_ROUTES           100                 /* max number of routes configurable*/
#define MAX_SN_LINKSETS         16                  /* max number of link sets configurable*/
#define MAX_SN_LINKS            200                  /* max number of links configurable*/
#define MAX_SD_LINKS            MAX_SN_LINKS        /* max number of links configurable */
#define MAX_L1_LINKS            MAX_SD_LINKS        /* max number of sig links configurable */
#ifdef PATH_MAX
#define MAX_SNGSS7_PATH			PATH_MAX				/* max path name */
#else
#define MAX_SNGSS7_PATH			4096                                    /* max path name */
#endif
#define MAX_SNGSS7_PC			12					/* max length of a point code */
#define MAX_MAC_SIZE 			18					/* max length of a mac address */
#define MAX_LIC_NAME			256					/* max length of names in license file */
#define MAX_MSU_SIZE 			272 	    /* max size of a MSU frame (Q.703 section 2.3.8) */
/******************************************************************************/

/* Logging ********************************************************************/
enum
{
    SNG_LOGLEVEL_DEBUG=1,
    SNG_LOGLEVEL_WARN,
    SNG_LOGLEVEL_INFO,
    SNG_LOGLEVEL_NOTICE,
    SNG_LOGLEVEL_ERROR,
    SNG_LOGLEVEL_CRIT,
    SNG_LOGLEVEL_PUBLIC=100,
};
/******************************************************************************/

/* Event Call-backs structure**************************************************/
typedef struct sng_isup_event_interface
{
    struct
    {
        void (*sng_con_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiConEvnt *siConEvnt);
        void (*sng_con_cfm)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiConEvnt *siConEvnt);
        void (*sng_con_sta)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiCnStEvnt *siCnStEvnt, uint8_t evntType);
        void (*sng_rel_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiRelEvnt *siRelEvnt);
        void (*sng_rel_cfm)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiRelEvnt *siRelEvnt);
        void (*sng_dat_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiInfoEvnt *siInfoEvnt);
        void (*sng_fac_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t evntType, SiFacEvnt *siFacEvnt);
        void (*sng_fac_cfm)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t evntType, SiFacEvnt *siFacEvnt);
        void (*sng_sta_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t globalFlg, uint8_t evntType, SiStaEvnt *siStaEvnt);
        void (*sng_umsg_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit);
        void (*sng_susp_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiSuspEvnt *siSuspEvnt);
        void (*sng_resm_ind)(uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiResmEvnt *siResmEvnt);
    }cc;
    struct
    {
        void (*sng_log)(uint8_t level, char *fmt, ...);
        void (*sng_mtp1_alarm)(Pst *pst, L1Mngmt *sta);
        void (*sng_mtp2_alarm)(Pst *pst, SdMngmt *sta);
        void (*sng_mtp3_alarm)(Pst *pst, SnMngmt *sta);
        void (*sng_sctp_alarm)(Pst *pst, SbMgmt *sta);		
        void (*sng_tucl_alarm)(Pst *pst, HiMngmt *sta);
        void (*sng_mtp3_li_alarm)(Pst *pst, ApMngmt *sta);
        void (*sng_isup_alarm)(Pst *pst, SiMngmt *sta);
        void (*sng_cc_alarm)(Pst *pst, CcMngmt *sta);
        void (*sng_relay_alarm)(Pst *pst, RyMngmt *sta);
        void (*sng_m2ua_alarm)(Pst *pst, MwMgmt *sta);
        void (*sng_nif_alarm)(Pst *pst,  NwMgmt *sta);
    }sm;
    /*  AP call backs are only used in MTP2 API mode */
    struct
    {
	    uint8_t (*is_mtp2api_enable)(void);
	    void (*sng_ap_dat_ind)(int16_t suId, void *data, int16_t len);
	    void (*sng_ap_dat_cfm)(int16_t suId, void *data, int16_t len, MtpStatus status, SeqU24 credit);
	    void (*sng_ap_con_cfm)(int16_t suId);
	    void (*sng_ap_disc_ind)(uint16_t suId, Reason reason);
	    void (*sng_ap_sta_ind)(uint16_t suId, MtpStatus status);
	    void (*sng_ap_sta_cfm)(uint16_t suId, Action action, SeqU24 status);
	    void (*sng_ap_flc_ind)(uint16_t suId, Action action);
    }ap;
}sng_isup_event_interface_t;
/******************************************************************************/

/* General functions **********************************************************/
extern int32_t sng_isup_init_gen(sng_isup_event_interface_t *u_sng_event_inf);
extern int32_t sng_set_procId(uint16_t procId);
extern int32_t sng_get_procId(void);
extern int32_t sng_isup_init_cc(void);
extern int32_t sng_isup_init_isup(void);
extern int32_t sng_isup_init_mtp3(void);
extern int32_t sng_isup_init_mtp3_li(void);
extern int32_t sng_isup_init_mtp2(void);
extern int32_t sng_isup_init_mtp1(void);
extern int32_t sng_isup_init_sm(void);
extern int32_t sng_isup_init_relay(void);
extern int32_t sng_isup_init_tucl(void);
extern int32_t sng_isup_init_sctp(void);
extern int32_t sng_isup_init_m2ua(void);
extern int32_t sng_isup_init_nif(void);


extern int32_t sng_isup_free_gen(void);
extern int32_t sng_isup_free_cc(void);
extern int32_t sng_isup_free_isup(void);
extern int32_t sng_isup_free_mtp3(void);
extern int32_t sng_isup_free_mtp3_li(void);
extern int32_t sng_isup_free_mtp2(void);
extern int32_t sng_isup_free_mtp1(void);
extern int32_t sng_isup_free_sm(void);
extern int32_t sng_isup_free_relay(void);
extern int32_t sng_isup_free_tucl(void);
extern int32_t sng_isup_free_sctp(void);
extern int32_t sng_isup_free_m2ua(void);
extern int32_t sng_isup_free_nif(void);
extern int32_t sng_isup_free_license_variables(void);

extern int32_t sng_isup_version(uint32_t *major, uint32_t *minor, uint32_t *build);
extern int32_t sng_isup_reg_info_show(void);
/******************************************************************************/

/* License Validaton **********************************************************/
int32_t sng_validate_license(char *license, char *signature);
extern int32_t sng_cc_resource_check(void);
int32_t sng_cc_check_time_license(void);
/******************************************************************************/

/* Outgoing Call Functions ****************************************************/
extern int32_t sng_cc_con_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiConEvnt *siConEvnt, uint8_t xchgType);
extern int32_t sng_cc_con_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiConEvnt *siConEvnt, uint8_t xchgType);
extern int32_t sng_cc_con_status(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiCnStEvnt *siCnStEvnt, uint8_t evntType);
extern int32_t sng_cc_rel_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiRelEvnt *siRelEvnt);
extern int32_t sng_cc_rel_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiRelEvnt *siRelEvnt);
extern int32_t sng_cc_dat_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiInfoEvnt *siInfoEvnt);
extern int32_t sng_cc_susp_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiSuspEvnt *siSuspEvnt);
extern int32_t sng_cc_resm_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiResmEvnt *siResmEvnt);
extern int32_t sng_cc_sta_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t globalFlg, uint8_t evntType, SiStaEvnt *siStaEvnt);
extern int32_t sng_cc_fac_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t evntType, SiFacEvnt *siFacEvnt);
extern int32_t sng_cc_fac_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t evntType, SiFacEvnt *siFacEvnt);
extern int32_t sng_cc_umsg_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit);
/******************************************************************************/

/* Configuration Functions ****************************************************/
extern int32_t sng_cfg_cc(Pst *pst, CcMngmt *cfg);
extern int32_t sng_cfg_isup(Pst *pst, SiMngmt *cfg);
extern int32_t sng_cfg_mtp3(Pst *pst, SnMngmt *cfg);
extern int32_t sng_cfg_mtp3_li(Pst *pst, ApMngmt *cfg);
extern int32_t sng_isup_free_mtp3_li(void);
extern int32_t sng_cfg_mtp2(Pst *pst, SdMngmt *cfg);
extern int32_t sng_cfg_mtp1(Pst *pst, L1Mngmt *cfg);
extern int32_t sng_cfg_relay(Pst *pst, RyMngmt *cfg);
extern int32_t sng_cfg_tucl(Pst *pst, HiMngmt *cfg);
extern int32_t sng_cfg_sctp(Pst *pst, SbMgmt *cfg);
extern int32_t sng_cfg_m2ua(Pst *pst, MwMgmt *cfg);
extern int32_t sng_cfg_nif(Pst *pst,  NwMgmt *cfg);
/******************************************************************************/

/* Control Functions **********************************************************/
extern int32_t sng_cntrl_cc(Pst *pst, CcMngmt *cntrl);

#define sng_cntrl_isup(_pst, _cntrl) __sng_cntrl_isup((_pst),(_cntrl),TRUE) 
#define sng_cntrl_isup_nowait(_pst, _cntrl) __sng_cntrl_isup((_pst),(_cntrl),FALSE) 
extern int32_t __sng_cntrl_isup(Pst *pst, SiMngmt *cntrl, uint8_t wait);

#define sng_cntrl_mtp3(_pst, _cntrl) __sng_cntrl_mtp3((_pst),(_cntrl),TRUE) 
#define sng_cntrl_mtp3_nowait(_pst, _cntrl) __sng_cntrl_mtp3((_pst),(_cntrl),FALSE) 
extern int32_t __sng_cntrl_mtp3(Pst *pst, SnMngmt *cntrl, uint8_t wait);

extern int32_t sng_cntrl_mtp3_li(Pst *pst, ApMngmt *cntrl);

extern int32_t sng_cntrl_mtp2(Pst *pst, SdMngmt *cntrl);
extern int32_t sng_cntrl_mtp1(Pst *pst, L1Mngmt *cntrl);
extern int32_t sng_cntrl_relay(Pst *pst, RyMngmt *cntrl);

#define sng_cntrl_sctp(_pst, _cntrl) __sng_cntrl_sctp((_pst),(_cntrl),TRUE) 
#define sng_cntrl_sctp_nowait(_pst, _cntrl) __sng_cntrl_sctp((_pst),(_cntrl),FALSE) 
extern int32_t __sng_cntrl_sctp(Pst *pst, SbMgmt *cntrl, uint8_t wait);

#define sng_cntrl_tucl(_pst, _cntrl) __sng_cntrl_tucl((_pst),(_cntrl),TRUE) 
#define sng_cntrl_tucl_nowait(_pst, _cntrl) __sng_cntrl_tucl((_pst),(_cntrl),FALSE)
extern int32_t __sng_cntrl_tucl(Pst *pst, HiMngmt *cntrl, uint8_t wait);

#define sng_cntrl_m2ua(_pst, _cntrl) __sng_cntrl_m2ua((_pst),(_cntrl),TRUE) 
#define sng_cntrl_m2ua_nowait(_pst, _cntrl) __sng_cntrl_m2ua((_pst),(_cntrl),FALSE)
extern int32_t __sng_cntrl_m2ua(Pst *pst, MwMgmt *cntrl, uint8_t wait);

#define sng_cntrl_nif(_pst, _cntrl) __sng_cntrl_nif((_pst),(_cntrl),TRUE) 
#define sng_cntrl_nif_nowait(_pst, _cntrl) __sng_cntrl_nif((_pst),(_cntrl),FALSE)
extern int32_t __sng_cntrl_nif(Pst *pst, NwMgmt *cntrl, uint8_t wait);

/******************************************************************************/

/* Status Requests ************************************************************/
extern int32_t sng_sta_cc(Pst *pst, CcMngmt *sta, CcMngmt *cfm);
extern int32_t sng_sta_isup(Pst *pst, SiMngmt *sta, SiMngmt *cfm);
extern int32_t sng_sta_mtp3(Pst *pst, SnMngmt *sta, SnMngmt *cfm);
extern int32_t sng_sta_mtp3_li(Pst *pst, ApMngmt *sta, ApMngmt *cfm);
extern int32_t sng_sta_mtp2(Pst *pst, SdMngmt *sta, SdMngmt *cfm);
extern int32_t sng_sta_mtp1(Pst *pst, L1Mngmt *sta, L1Mngmt *cfm);
extern int32_t sng_sta_relay(Pst *pst, RyMngmt *sta, RyMngmt *cfm);
extern int32_t sng_sta_tucl(Pst *pst, HiMngmt *sta, HiMngmt *cfm);
extern int32_t sng_sta_sctp(Pst *pst, SbMgmt *sta, SbMgmt *cfm);
extern int32_t sng_sta_m2ua(Pst *pst, MwMgmt *sta, MwMgmt *cfm);
extern int32_t sng_sta_nif(Pst *pst,  NwMgmt *sta, NwMgmt *cfm);
/******************************************************************************/

/* Statistics Requests ********************************************************/
extern int32_t sng_sts_cc(Pst *pst, int32_t action, CcMngmt *sts, CcMngmt *cfm);
extern int32_t sng_sts_isup(Pst *pst, int32_t action, SiMngmt *sts, SiMngmt *cfm);
extern int32_t sng_sts_mtp3(Pst *pst, int32_t action, SnMngmt *sts, SnMngmt *cfm);
extern int32_t sng_sts_mtp3_li(Pst *pst, int32_t action, ApMngmt *sts, ApMngmt *cfm);
extern int32_t sng_sts_mtp2(Pst *pst, int32_t action, SdMngmt *sts, SdMngmt *cfm);
extern int32_t sng_sts_mtp1(Pst *pst, int32_t action, L1Mngmt *sts, L1Mngmt *cfm);
extern int32_t sng_sts_relay(Pst *pst, int32_t action, RyMngmt *sts, RyMngmt *cfm);
extern int32_t sng_sts_tucl(Pst *pst, HiMngmt *cntrl, HiMngmt *cfm);
extern int32_t sng_sts_sctp(Pst *pst, SbMgmt *cntrl, SbMgmt *cfm);
extern int32_t sng_sts_m2ua(Pst *pst, int32_t action,MwMgmt *sts, MwMgmt *cfm);
extern int32_t sng_sts_nif(Pst *pst, int32_t action, NwMgmt *sts, NwMgmt *cfm);
/******************************************************************************/

/* MTP2 API Functions *************************************************************/
extern S16 sng_ss7_ap_dat_req(SuId suId, void* data, uint32_t len);
extern S16 sng_ss7_ap_sta_req(SpId spId, Action action, MtpStatus status);

/* Util Functions *************************************************************/
extern void smHdrInit(Header *hdr);
extern void smPstInit(Pst *pst);
/******************************************************************************/


/* Call control Requests (SPIROU)***************************************************/
#define ISUP_T6i		0x06			/* timer index to be controled - t6 for incoming call */
#define ISUP_T6o		ISUP_T6i			/* timer index to be controled - t6 for outgoing call */

extern int32_t sng_cancel_isup_tmr(uint32_t SuInstId, uint32_t tmr_idx);
int32_t sng_cc_inr(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiCnStEvnt* siCnStEvnt, uint8_t evntType);
int32_t sng_cc_inf(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiCnStEvnt* siCnStEvnt, uint8_t evntType);
/******************************************************************************/

/******************************************************************************/
#endif  /* __SNG_ISUP_H__ */
/******************************************************************************/
