/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
    Name:   isup layer
  
    Type:   C include file
  
    Desc:   Structures, variables and typedefs required by the isup
            layer service user
  
    File:   sit.x
  
    Sid:      sit.x@@/main/66 - Tue Jul 13 16:54:14 2010

    Prg:    na
  
*********************************************************************21*/

#ifndef __SITX__
#define __SITX__
 

/*
*     The structures and variables declared in this file
*     correspond to structures and variables used by
*     the following TRILLIUM software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000029      SS7 - ISUP
*
*/

/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.             description
*     --------     ----------------------------------------------
*
*/


/*
 * Message definitions based on:
 *
 * CCITT Blue Book
 * ---------------
 * Specifications of Signalling System No. 7
 * Recommendations Q.721-Q.766
 * ISBN 92-61-03521-3
 *
 */


/* sit_x_001.main_52 */

/* typedefs */
  
/* BndCfg structure defined in gen.x */

/* Post and buffer structure defined in ss_ms.x */

/* addrs structure defined in gen.x */

/* token structures defined in gen.x */

/* header structures defined in gen.x */

/* Message Element Structures */
  
typedef struct accDelInfo        /* Access delivery information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   delInd;               /* delivery indicator */
} SiAccDelInfo;
  
/* sit_x_001.main_54: Modified PCI parameter to add control flag for Kazakhstan variant */
typedef struct parmCompInfo           /* parameter compatibility information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   upgrPar1;             /* upgraded parm 1 */
   TknU8   tranXInd1;            /* transit exchange indicator */
   TknU8   relCllInd1;           /* release call indicator */
   TknU8   sndNotInd1;           /* send notification indicator */
   TknU8   dcrdMsgInd1;          /* discard message indicator */
   TknU8   dcrdParInd1;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss1;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI1;         /* broadband network interworking indicator */
   TknStr  addInstInd1;          /* additional instruction indicator */
   TknU8   upgrPar2;             /* upgraded parm 2 */
   TknU8   tranXInd2;            /* transit exchange indicator */
   TknU8   relCllInd2;           /* release call indicator */
   TknU8   sndNotInd2;           /* send notification indicator */
   TknU8   dcrdMsgInd2;          /* discard message indicator */
   TknU8   dcrdParInd2;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss2;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI2;         /* broadband n/w interworking indicator */
   TknStr  addInstInd2;          /* additional instruction indicator */
   TknU8   upgrPar3;             /* upgraded parm 3 */
   TknU8   tranXInd3;            /* transit exchange indicator */
   TknU8   relCllInd3;           /* release call indicator */
   TknU8   sndNotInd3;           /* send notification indicator */
   TknU8   dcrdMsgInd3;          /* discard message indicator */
   TknU8   dcrdParInd3;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss3;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI3;         /* broadband network interworking indicator */
   TknStr  addInstInd3;          /* additional instruction indicator */
   TknU8   upgrPar4;             /* upgraded parm 4 */
   TknU8   tranXInd4;            /* transit exchange indicator */
   TknU8   relCllInd4;           /* release call indicator */
   TknU8   sndNotInd4;           /* send notification indicator */
   TknU8   dcrdMsgInd4;          /* discard message indicator */
   TknU8   dcrdParInd4;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss4;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI4;         /* broadband network interworking indicator */
   TknStr  addInstInd4;          /* additional instruction indicator */
   TknU8   upgrPar5;             /* upgraded parm 5 */
   TknU8   tranXInd5;            /* transit exchange indicator */
   TknU8   relCllInd5;           /* release call indicator */
   TknU8   sndNotInd5;           /* send notification indicator */
   TknU8   dcrdMsgInd5;          /* discard message indicator */
   TknU8   dcrdParInd5;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss5;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI5;         /* broadband network interworking indicator */
   TknStr  addInstInd5;          /* additional instruction indicator */
   TknU8   upgrPar6;             /* upgraded parm 5 */
   TknU8   tranXInd6;            /* transit exchange indicator */
   TknU8   relCllInd6;           /* release call indicator */
   TknU8   sndNotInd6;           /* send notification indicator */
   TknU8   dcrdMsgInd6;          /* discard message indicator */
   TknU8   dcrdParInd6;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss6;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI6;         /* broadband network interworking indicator */
   TknStr  addInstInd6;          /* additional instruction indicator */
   TknU8   upgrPar7;             /* upgraded parm 5 */
   TknU8   tranXInd7;            /* transit exchange indicator */
   TknU8   relCllInd7;           /* release call indicator */
   TknU8   sndNotInd7;           /* send notification indicator */
   TknU8   dcrdMsgInd7;          /* discard message indicator */
   TknU8   dcrdParInd7;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss7;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI7;         /* broadband network interworking indicator */
   TknStr  addInstInd7;          /* additional instruction indicator */
   TknU8   upgrPar8;             /* upgraded parm 5 */
   TknU8   tranXInd8;            /* transit exchange indicator */
   TknU8   relCllInd8;           /* release call indicator */
   TknU8   sndNotInd8;           /* send notification indicator */
   TknU8   dcrdMsgInd8;          /* discard message indicator */
   TknU8   dcrdParInd8;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss8;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI8;         /* broadband network interworking indicator */
   TknStr  addInstInd8;          /* additional instruction indicator */
   TknU8   upgrPar9;             /* upgraded parm 5 */
   TknU8   tranXInd9;            /* transit exchange indicator */
   TknU8   relCllInd9;           /* release call indicator */
   TknU8   sndNotInd9;           /* send notification indicator */
   TknU8   dcrdMsgInd9;          /* discard message indicator */
   TknU8   dcrdParInd9;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss9;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI9;         /* broadband network interworking indicator */
   TknStr  addInstInd9;          /* additional instruction indicator */
   TknU8   upgrPar10;            /* upgraded parm 5 */
   TknU8   tranXInd10;           /* transit exchange indicator */
   TknU8   relCllInd10;          /* release call indicator */
   TknU8   sndNotInd10;          /* send notification indicator */
   TknU8   dcrdMsgInd10;         /* discard message indicator */
   TknU8   dcrdParInd10;         /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || \
     SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss10;         /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI10;        /* broadband network interworking indicator */
   TknStr  addInstInd10;         /* additional instruction indicator */

#ifdef PCI32_SUPPORT
   TknU8   upgrPar11;             /* upgraded parm 1 */
   TknU8   tranXInd11;            /* transit exchange indicator */
   TknU8   relCllInd11;           /* release call indicator */
   TknU8   sndNotInd11;           /* send notification indicator */
   TknU8   dcrdMsgInd11;          /* discard message indicator */
   TknU8   dcrdParInd11;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss11;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI11;         /* broadband network interworking indicator */
   TknStr  addInstInd11;          /* additional instruction indicator */
   TknU8   upgrPar12;             /* upgraded parm 1 */
   TknU8   tranXInd12;            /* transit exchange indicator */
   TknU8   relCllInd12;           /* release call indicator */
   TknU8   sndNotInd12;           /* send notification indicator */
   TknU8   dcrdMsgInd12;          /* discard message indicator */
   TknU8   dcrdParInd12;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss12;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI12;         /* broadband network interworking indicator */
   TknStr  addInstInd12;          /* additional instruction indicator */
   TknU8   upgrPar13;             /* upgraded parm 1 */
   TknU8   tranXInd13;            /* transit exchange indicator */
   TknU8   relCllInd13;           /* release call indicator */
   TknU8   sndNotInd13;           /* send notification indicator */
   TknU8   dcrdMsgInd13;          /* discard message indicator */
   TknU8   dcrdParInd13;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss13;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI13;         /* broadband network interworking indicator */
   TknStr  addInstInd13;          /* additional instruction indicator */
   TknU8   upgrPar14;             /* upgraded parm 1 */
   TknU8   tranXInd14;            /* transit exchange indicator */
   TknU8   relCllInd14;           /* release call indicator */
   TknU8   sndNotInd14;           /* send notification indicator */
   TknU8   dcrdMsgInd14;          /* discard message indicator */
   TknU8   dcrdParInd14;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss14;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI14;         /* broadband network interworking indicator */
   TknStr  addInstInd14;          /* additional instruction indicator */
   TknU8   upgrPar15;             /* upgraded parm 1 */
   TknU8   tranXInd15;            /* transit exchange indicator */
   TknU8   relCllInd15;           /* release call indicator */
   TknU8   sndNotInd15;           /* send notification indicator */
   TknU8   dcrdMsgInd15;          /* discard message indicator */
   TknU8   dcrdParInd15;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss15;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI15;         /* broadband network interworking indicator */
   TknStr  addInstInd15;          /* additional instruction indicator */
  TknU8   upgrPar16;             /* upgraded parm 1 */
   TknU8   tranXInd16;            /* transit exchange indicator */
   TknU8   relCllInd16;           /* release call indicator */
   TknU8   sndNotInd16;           /* send notification indicator */
   TknU8   dcrdMsgInd16;          /* discard message indicator */
   TknU8   dcrdParInd16;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss16;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI16;         /* broadband network interworking indicator */
   TknStr  addInstInd16;          /* additional instruction indicator */
   TknU8   upgrPar17;             /* upgraded parm 1 */
   TknU8   tranXInd17;            /* transit exchange indicator */
   TknU8   relCllInd17;           /* release call indicator */
   TknU8   sndNotInd17;           /* send notification indicator */
   TknU8   dcrdMsgInd17;          /* discard message indicator */
   TknU8   dcrdParInd17;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss17;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI17;         /* broadband network interworking indicator */
   TknStr  addInstInd17;          /* additional instruction indicator */
   TknU8   upgrPar18;             /* upgraded parm 1 */
   TknU8   tranXInd18;            /* transit exchange indicator */
   TknU8   relCllInd18;           /* release call indicator */
   TknU8   sndNotInd18;           /* send notification indicator */
   TknU8   dcrdMsgInd18;          /* discard message indicator */
   TknU8   dcrdParInd18;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss18;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI18;         /* broadband network interworking indicator */
   TknStr  addInstInd18;          /* additional instruction indicator */
   TknU8   upgrPar19;             /* upgraded parm 1 */
   TknU8   tranXInd19;            /* transit exchange indicator */
   TknU8   relCllInd19;           /* release call indicator */
   TknU8   sndNotInd19;           /* send notification indicator */
   TknU8   dcrdMsgInd19;          /* discard message indicator */
   TknU8   dcrdParInd19;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss19;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI19;         /* broadband network interworking indicator */
   TknStr  addInstInd19;          /* additional instruction indicator */
   TknU8   upgrPar20;             /* upgraded parm 1 */
   TknU8   tranXInd20;            /* transit exchange indicator */
   TknU8   relCllInd20;           /* release call indicator */
   TknU8   sndNotInd20;           /* send notification indicator */
   TknU8   dcrdMsgInd20;          /* discard message indicator */
   TknU8   dcrdParInd20;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss20;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI20;         /* broadband network interworking indicator */
   TknStr  addInstInd20;          /* additional instruction indicator */
   TknU8   upgrPar21;             /* upgraded parm 1 */
   TknU8   tranXInd21;            /* transit exchange indicator */
   TknU8   relCllInd21;           /* release call indicator */
   TknU8   sndNotInd21;           /* send notification indicator */
   TknU8   dcrdMsgInd21;          /* discard message indicator */
   TknU8   dcrdParInd21;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss21;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI21;         /* broadband network interworking indicator */
   TknStr  addInstInd21;          /* additional instruction indicator */
   TknU8   upgrPar22;             /* upgraded parm 1 */
   TknU8   tranXInd22;            /* transit exchange indicator */
   TknU8   relCllInd22;           /* release call indicator */
   TknU8   sndNotInd22;           /* send notification indicator */
   TknU8   dcrdMsgInd22;          /* discard message indicator */
   TknU8   dcrdParInd22;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss22;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI22;         /* broadband network interworking indicator */
   TknStr  addInstInd22;          /* additional instruction indicator */
   TknU8   upgrPar23;             /* upgraded parm 1 */
   TknU8   tranXInd23;            /* transit exchange indicator */
   TknU8   relCllInd23;           /* release call indicator */
   TknU8   sndNotInd23;           /* send notification indicator */
   TknU8   dcrdMsgInd23;          /* discard message indicator */
   TknU8   dcrdParInd23;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss23;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI23;         /* broadband network interworking indicator */
   TknStr  addInstInd23;          /* additional instruction indicator */
   TknU8   upgrPar24;             /* upgraded parm 1 */
   TknU8   tranXInd24;            /* transit exchange indicator */
   TknU8   relCllInd24;           /* release call indicator */
   TknU8   sndNotInd24;           /* send notification indicator */
   TknU8   dcrdMsgInd24;          /* discard message indicator */
   TknU8   dcrdParInd24;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss24;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI24;         /* broadband network interworking indicator */
   TknStr  addInstInd24;          /* additional instruction indicator */
   TknU8   upgrPar25;             /* upgraded parm 1 */
   TknU8   tranXInd25;            /* transit exchange indicator */
   TknU8   relCllInd25;           /* release call indicator */
   TknU8   sndNotInd25;           /* send notification indicator */
   TknU8   dcrdMsgInd25;          /* discard message indicator */
   TknU8   dcrdParInd25;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss25;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI25;         /* broadband network interworking indicator */
   TknStr  addInstInd25;          /* additional instruction indicator */
   TknU8   upgrPar26;             /* upgraded parm 1 */
   TknU8   tranXInd26;            /* transit exchange indicator */
   TknU8   relCllInd26;           /* release call indicator */
   TknU8   sndNotInd26;           /* send notification indicator */
   TknU8   dcrdMsgInd26;          /* discard message indicator */
   TknU8   dcrdParInd26;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss26;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI26;         /* broadband network interworking indicator */
   TknStr  addInstInd26;          /* additional instruction indicator */
   TknU8   upgrPar27;             /* upgraded parm 1 */
   TknU8   tranXInd27;            /* transit exchange indicator */
   TknU8   relCllInd27;           /* release call indicator */
   TknU8   sndNotInd27;           /* send notification indicator */
   TknU8   dcrdMsgInd27;          /* discard message indicator */
   TknU8   dcrdParInd27;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss27;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI27;         /* broadband network interworking indicator */
   TknStr  addInstInd27;          /* additional instruction indicator */
   TknU8   upgrPar28;             /* upgraded parm 1 */
   TknU8   tranXInd28;            /* transit exchange indicator */
   TknU8   relCllInd28;           /* release call indicator */
   TknU8   sndNotInd28;           /* send notification indicator */
   TknU8   dcrdMsgInd28;          /* discard message indicator */
   TknU8   dcrdParInd28;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss28;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI28;         /* broadband network interworking indicator */
   TknStr  addInstInd28;          /* additional instruction indicator */
   TknU8   upgrPar29;             /* upgraded parm 1 */
   TknU8   tranXInd29;            /* transit exchange indicator */
   TknU8   relCllInd29;           /* release call indicator */
   TknU8   sndNotInd29;           /* send notification indicator */
   TknU8   dcrdMsgInd29;          /* discard message indicator */
   TknU8   dcrdParInd29;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss29;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI29;         /* broadband network interworking indicator */
   TknStr  addInstInd29;          /* additional instruction indicator */
   TknU8   upgrPar30;             /* upgraded parm 1 */
   TknU8   tranXInd30;            /* transit exchange indicator */
   TknU8   relCllInd30;           /* release call indicator */
   TknU8   sndNotInd30;           /* send notification indicator */
   TknU8   dcrdMsgInd30;          /* discard message indicator */
   TknU8   dcrdParInd30;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss30;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI30;         /* broadband network interworking indicator */
   TknStr  addInstInd30;          /* additional instruction indicator */
   TknU8   upgrPar31;             /* upgraded parm 1 */
   TknU8   tranXInd31;            /* transit exchange indicator */
   TknU8   relCllInd31;           /* release call indicator */
   TknU8   sndNotInd31;           /* send notification indicator */
   TknU8   dcrdMsgInd31;          /* discard message indicator */
   TknU8   dcrdParInd31;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss31;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI31;         /* broadband network interworking indicator */
   TknStr  addInstInd31;          /* additional instruction indicator */
   TknU8   upgrPar32;             /* upgraded parm 1 */
   TknU8   tranXInd32;            /* transit exchange indicator */
   TknU8   relCllInd32;           /* release call indicator */
   TknU8   sndNotInd32;           /* send notification indicator */
   TknU8   dcrdMsgInd32;          /* discard message indicator */
   TknU8   dcrdParInd32;          /* discard parameter indicator */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_FTZ || SS7_INDIA || SS7_UK || SS7_ITU || SS7_NZL || SS7_KZ || SS7_UR)
   TknU8   passNtPoss32;          /* pass not possible indicator */
#endif
   TknU8   pBbNbIntwkI32;         /* broadband network interworking indicator */
   TknStr  addInstInd32;          /* additional instruction indicator */
#endif   /* End of PCI32_SUPPORT */
} SiParmCompInfo;
  
typedef struct msgCompInfo        /* message compatibility information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   tranXInd;             /* transit exchange indicator */
   TknU8   relCllInd;            /* release call indicator */
   TknU8   sndNotInd;            /* send notification indicator */
   TknU8   dcrdMsgInd;           /* discard message indicator */
   TknU8   passNotPoss;          /* pass on not possible indicator */
   TknU8   bbNbIntwkI;           /* broadband n/w interworking indicator */
   TknU8   tranXInd1;            /* transit exchange indicator */
   TknU8   relCllInd1;           /* release call indicator */
   TknU8   sndNotInd1;           /* send notification indicator */
   TknU8   dcrdMsgInd1;          /* discard message indicator */
   TknU8   passNotPoss1;         /* pass on not possible indicator */
   TknU8   bbNbIntwkI1;          /* broadband n/w interworking indicator */
} SiMsgCompInfo;
  
typedef struct cllDiverInfo      /* call Diversion information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   notSuscr;             /* Notification subscribtion */
   TknU8   redirRsn;             /* redirection reason */
} SiCllDiverInfo;

typedef struct propDly           /* propagation delay */
{
   ElmtHdr eh;                   /* element header */
   TknU16  delayVal;             /* delay value */
} SiPropDly;
  
typedef struct redirRstr         /* redirection restriction */
{
   ElmtHdr eh;                   /* element header */
   TknU8   presRest;             /* presentation restriction */
} SiRedirRestr;
  
typedef struct remotOper         /* remote operations */
{
   ElmtHdr eh;                   /* element header */
   TknU8   protProf;             /* protocol profile */
   TknStr  compon;               /* components */
} SiRemotOper;

typedef struct netFacSpecFacil   /* network specific facility */
{
   ElmtHdr eh;                   /* element header */
   TknStr  netFac;               /* network facility1 */
} SiNetSpecFacil;
  
typedef struct mcidRspInd        /* MCID response indicators  */
{
   ElmtHdr eh;                   /* element header */
   TknU8   rspInd;               /* mcid response indicators */
   TknU8   hldInd;               /* hold indicators */
} SiMcidRspInd;
  
typedef struct mcidReqInd           /* MCID request indicators  */
{
   ElmtHdr eh;                   /* element header */
   TknU8   reqInd;               /* mcid request indicators */
   TknU8   hldInd;               /* hold indicators */
} SiMcidReqInd;
  
typedef struct mlppPrec          /* MLPP precedence  */
{
   ElmtHdr eh;                   /* element header */
   TknU8   precdLvl;             /* precedence level */
   TknU8   lfb;                  /* LFB */
   /* sit_x_001.main_62: Corrected the order */
   TknU8   scndDig;              /* second digit */
   TknU8   frstDig;              /* first digit */
   TknU8   frthDig;              /* fourth digit */
   TknU8   thrdDig;              /* third digit */
   TknU32  servDomain;           /* service domain */
} SiMlppPrec;

typedef struct accTrnspt         /* Access transport */
{
   ElmtHdr eh;                   /* element header */
   TknStr  infoElmts;            /* Information elements */
} SiAccTrnspt;

#if SS7_SINGTEL
typedef struct cllChrgeInfo         /* Charge Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   typeCalls;            /* type of calls */
   TknU8   chgeMeth;             /* charging method */
   TknU8   chgePrty;             /* chargeable party */
   TknU8   chgePoint;            /* charge point */
   TknU16  pntCde;               /* point code */
} SiCllChrgeInfo;
  
typedef struct chrgeRateInfo          /* Charge rate Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   pktChrgng;            /* packet chagring */
   TknU8   tariffCat;            /* tariff category */
   TknU8   tariffUnit;           /* tariff unit */
   TknU8   tariffFact;           /* tariff factor chagring */
   TknU16  nominalTime;          /* nominal time */
} SiChrgeRateInfo;
  
typedef struct trnkOff           /* trunk offering Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   trnkOffInfo;          /* trunk offering Information */
} TrnkOff;
#endif  
#if SS7_NTT
typedef struct simsgAreaInfo      /* Message area information */
{
   ElmtHdr  eh;                   /* element header */
   TknStr   msgAreaInfo;          /* Message Area information */
} SiMsgAreaInfo;

typedef struct chrgInf           /* Charge Information */
{
   ElmtHdr eh;                   /* element header */
   union {
      /* if charge info type is 0000 0001 */
      struct 
      {
         TknU8    chrgInfoIdctr;      /* Charge information idctr */
         TknStr   chrgData;           /* Charge Data */
      } chrg1;

      /* if charge info type is 0000 0010 */
      struct 
      {
         TknU8    signalElemType;     /* Signal element type */
         TknU8    activationId;       /* Activation id */
         TknU8    operClass;          /* Operation class */
         TknU8    operType;           /* Operation Type */
         TknU8    chrgdUType;         /* Charged user type */
         TknU8    billCollMthd;       /* Bill collection method */
         TknU8    billRateIdctr;      /* Bill Rate information  */
         TknStr   billRateInfo;       /* Bill Rate information */
      } chrg2;

      /* if charge info type is 0000 0011 */
      struct 
      {
         TknU8    signalElemType;     /* Signal element type */
         TknU8    activationId;       /* Activation id */
         TknU8    operClass;          /* Operation class */
         TknU8    operType;           /* Operation Type */
         TknU8    chrgdUType;         /* Charged user type */
         TknU8    billCollMthd;       /* Bill collection method */
         TknU8    billRateIdctr;      /* Bill Rate information  */
         TknStr   billRateInfo;       /* Bill Rate information */
      } chrg3;

      /* if charge info type is 0000 0100 */
      struct 
      {
         TknU8    signalElemType;     /* Signal element type */
         TknU8    oddEvenIdctr;       /* Odd Event indicator */
         TknStr   calledAreaInf;      /* Called Area Information */
      } chrg4;
      /* for rest of the values for the charge information type */
      struct 
      {
         TknStrE chrgInfo;             /* Charge information token */ 
      } data;
   } p;
} SiChrgInfo;

typedef struct chrgInfoTyp        /* Charge information type */
{
   ElmtHdr  eh;                   /* element header */
   TknU8    chrgInfoType;         /* Charge information type */
} SiChrgInfoType;

typedef struct sichrgInfoDelay    /* Charge information delay */
{
   ElmtHdr  eh;                   /* element header */
   TknStr   chrgInfoDelay;        /* Charge information Delay */
} SiChrgInfoDelay;

typedef struct sisubsNumber       /* Subscriber number */
{
   ElmtHdr  eh;                   /* element header */
   TknStr   subsNumber;           /* Subscriber Number */
} SiSubsNumber;

typedef struct reasProhibCllngNo  /* Reason for prohibiting cllng no */
{
   ElmtHdr  eh;                   /* element header */
   TknU8    rpCllngNo;            /* Reas for prohibng callng number */
} SiReasProhibCllngNo;

typedef struct sisupplUserType    /* Supplementary user type */
{
   ElmtHdr  eh;                   /* element header */
   TknStr   supplUserType;        /* Supplementary user type */
} SiSupplUserType;

typedef struct sicarrierInfoTrans /* Carrier Information transfer */
{
   ElmtHdr  eh;                   /* element header */
   TknStr   carrierInfoTrans;     /* Carrier Information transfer */
} SiCarrierInfoTrans;

typedef struct sinwFuncType       /* Network function type */
{
   ElmtHdr  eh;                   /* element header */
   TknU8    nwFuncType;           /* Network function type value */
}  SiNwFuncType;
#endif

typedef struct autoCongLvl       /* Autonatic Congestion Level */
{
   ElmtHdr eh;                   /* element header */
   TknU8   auCongLvl;            /* auto congestion level */
} SiAutoCongLvl;
  
typedef struct bckCalInd         /* Backward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   chrgInd;              /* Charge Indicator */
   TknU8   cadPtyStatInd;        /* called party status indicator */
   TknU8   cadPtyCatInd;         /* called party category indicator */
   TknU8   end2EndMethInd;       /* end to end method indicator */
   TknU8   intInd;               /* interworking indicator */
   TknU8   end2EndInfoInd;       /* end to end information indicator */
   TknU8   isdnUsrPrtInd;        /* ISDN User Part indicator */
   TknU8   holdInd;              /* holding indicator */
   TknU8   isdnAccInd;           /* ISDN access indicator */
   TknU8   echoCtrlDevInd;       /* echo control device indicator */
   TknU8   sccpMethInd;          /* SCCP method indicator */
} SiBckCalInd;
  
typedef struct calModInd         /* Call Modification Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   modInd;               /* call modification indicators */
} SiCalModInd;
  
typedef struct callRef           /* Call Reference */
{
   ElmtHdr eh;                   /* element header */
   TknU32  callId;               /* call identity */
   TknU16  pntCde;               /* point code */
} SiCallRef;
  
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL \
     || SS7_CHINA || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct callRefA          /* Call Reference */
{
   ElmtHdr eh;                   /* element header */
   TknU32 callId;                /* call identity */
   TknU32 pntCde;                /* point code */
} SiCallRefA;
#endif

#if (SS7_BELL || SS7_ANS95 || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct genName           /* Generaric name */
{
   ElmtHdr eh;                   /* element header */
   TknU8 present;                /* presentation */
   TknU8 avail;                  /* availability */
   TknU8 typeName;               /* type of name */
   TknStr character;             /* Character */
} SiGenName;
#endif

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_BELL || SS7_ANS95 || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_INDIA || SS7_UK || SS7_ETSIV3 || \
     SS7_NZL || SS7_KZ || SS7_UR || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct sihopCounter      /* Hop counter */
{
   ElmtHdr eh;                   /* element header */
   TknU8 hopCounter;             /* presentation */
} SiHopCounter;
#endif

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_BELL || SS7_ITU2000 || SS7_KZ || SS7_UR || \
      defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct siredirCap        /* Redirect capability */
{
   ElmtHdr eh;                   /* element header */
   TknU8 redirCap;               /* capability */
} SiRedirCap;

typedef struct siredirCntr      /* Redirect counter */
{
   ElmtHdr eh;                   /* element header */
   TknU8 redirCntr;              /* counter */
} SiRedirCntr;
#endif

typedef struct cdPtyNum          /* Called Party Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8   natAddrInd;           /* nature of addresss indicator */
   TknU8   oddEven;              /* odd or even */
   TknU8   numPlan;              /* numbering plan */
   TknU8   innInd;               /* internal network number indicator */
   TknStr  addrSig;              /* Address Signal */
} SiCdPtyNum;

typedef struct cgPtyNum          /* Calling Party Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddrInd;             /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrnInd;                /* screen indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknU8 niInd;                  /* number incomplete indicator */
   TknStr addrSig;               /* Address Signal */
} SiCgPtyNum;
  
/* sit_x_001.main_54: Added TDS_ROLL_UPGRADE_SUPPORT flag */
/* sit_x_001.main_55: Removed flag to solve compilation isuue */
#if SS7_BELL
typedef struct cgPtyNum1          /* Calling Party Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddrInd;             /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrnInd;                /* screen indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiCgPtyNum1;
#endif

typedef struct genNum           /* Generic Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 nmbQual;                /* number qualifier */
   TknU8 natAddrInd;             /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrnInd;                /* screen indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknU8 niInd;                  /* number incomplete indicator */
   TknStr addrSig;               /* Address Signal */
} SiGenNum;
  
typedef struct usrTSrvInfo       /* User Teleservice Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8 presMeth;               /* presentation method */
   TknU8 interp;                 /* interpretation indicator */
   TknU8 codeStd;                /* coding standard */
   TknU8 highLyr;                /* high layer characteristics id */
   TknU8 extHighLyr;             /* extended high layer chars id */
/* sit_x_001.main_60 : added extended video telephony chars id */
   TknU8 extVideoTel;            /* extended video telephony chars id */
} SiUsrTSrvInfo;

typedef struct sicgPtyCat        /* Calling Party Category */
{
   ElmtHdr eh;                   /* element header */
   TknU8 cgPtyCat;               /* calling party category */
} SiCgPtyCat;
  
typedef struct siCauseDgn        /* Cause Indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8 location;               /* location */
   TknU8 cdeStand;               /* coding standard */
   TknU8 recommend;              /* recommendation */
   TknU8 causeVal;               /* cause value */
   TknStr dgnVal;                /* diagnostics */
} SiCauseDgn;
  
typedef struct cirGrpSupMTypInd  /* Circuit Group Supervision Msg. Type Ind. */
{
   ElmtHdr eh;                   /* element header */
   TknU8 typeInd;                /* circuit group supervision msg. type ind. */
} SiCirGrpSupMTypInd;
  
typedef struct sicirStateInd     /* Circuit State Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknStr cirSteInd;             /* circuit state indicator. */
} SiCirStateInd;
  
typedef struct cugIntCode        /* Closed User Group Interlock Code */
{
   ElmtHdr eh;                   /* element header */
   TknU8 dig2;                   /* Digit 2 */
   TknU8 dig1;                   /* Digit 1 */
   TknU8 dig4;                   /* Digit 4 */
   TknU8 dig3;                   /* Digit 3 */
   TknU16 binCde;                /* binary Code */
} SiCugIntCode;
  
#if (defined(SS7_ANS88) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct cugIntCodeA       /* Closed User Group Interlock Code */
{
   ElmtHdr eh;                   /* element header */
   TknU16 binCde;                /* Binary Code */
   TknU16 ISDNIdent;             /* ISDN identifier */
} SiCugIntCodeA;
  
#endif
typedef struct connectedNum      /* Connected number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrnInd;                /* screen indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiConnectedNum;

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
typedef struct connectedNum3     /* Connected number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrnInd;                /* screen indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiConnectedNum3;
#endif
  
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct connectedNum2     /* Connected number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiConnectedNum2;
#endif


typedef struct connReq           /* Connection Request */
{
   ElmtHdr eh;                   /* element header */
   TknU32  locRef;               /* local reference(really a 24bit quantity) */
   TknU16  pntCde;               /* point code */
   TknU8   protClass;            /* protocol classs */
   TknU8   credit;               /* credit */
} SiConnReq;

#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
typedef struct connReqA          /* Connection Request */
{
   ElmtHdr eh;                   /* element header */
   TknU32  locRef;               /* local reference (really a 24bit quantity)*/
   TknU32  pntCde;               /* point code */
   TknU8   protClass;            /* protocol classs */
   TknU8   credit;               /* credit */
} SiConnReqA;
#endif

typedef struct sicontInd         /* Continuity indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 contInd;                /* continuity indicator */
} SiContInd;
  
typedef struct evntInfo          /* Event Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8 evntInd;                /* event indicators */
   TknU8 evntPresResInd;         /* event presentation restriction indicators*/
} SiEvntInfo;
  
typedef struct sifacInd          /* Facility Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 facInd;                 /* facility indicator */
} SiFacInd;
  
typedef struct fwdCallInd        /* Forward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   natIntCallInd;        /* National/International Call Indicator */
   TknU8   end2EndMethInd;       /* end to end method indicator */
   TknU8   intInd;               /* interworking indicator */
   TknU8   end2EndInfoInd;       /* end to end information indicator */
   TknU8   isdnUsrPrtInd;        /* ISDN User Part indicator */
   TknU8   isdnUsrPrtPrfInd;     /* ISDN User Part preference indicator */
   TknU8   isdnAccInd;           /* ISDN access indicator */
   TknU8   sccpMethInd;          /* SCCP method indicator */
/* sit_x_001.main_53 : The element "transCallNInd" reprsent
 * 'M' bit which is also used for reverse charge indicator
 * for New Zealand variant
 */
/* sit_x_001.main_56 : Corrected SI_ANSILNP flag usage */
/* making following field also available for BRZL */
#if ( SS7_NZL || SS7_BRZL || defined(SI_ANSILNP))
   TknU8   transCallNInd;        /* Translated called number indicator  or */
                                 /* Reverse Charge Indicator */
#endif
#ifdef SS7_NZL
   TknU8   Spare1;               /* Reserved for national use */
   TknU8   inCallInd;            /* IN Call Indicator */
   TknU8   Spare2;               /* Reserved for national use */
#endif
} SiFwdCallInd;
  
typedef struct infoInd           /* Information Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cgPtyAddrRespInd;     /* calling party address response ind. */
   TknU8   holdProvInd;          /* hold provided indicator */
   TknU8   cgPtyCatRespInd;      /* calling party category response ind. */
   TknU8   chrgInfoRespInd;      /* charge information response indicator */
   TknU8   solInfoInd;           /* solicitation information indicator */
   TknU8   spare;                /* spare (insure we get second octet) */
} SiInfoInd;
  
#if (defined(SS7_ANS88) || defined(TDS_ROLL_UPGRADE_SUPPORT))

typedef struct infoIndA          /* Information Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cgPtyAddrRespInd;     /* calling party address response ind. */
   TknU8   connAddrRspInd;       /* connected address response indicator */
   TknU8   cgPtyCatRespInd;      /* calling party category response ind. */
   TknU8   chrgInfoRespInd;      /* charge information response indicator */
   TknU8   redirAddrRspInda;     /* redirection address response indicator*/
   TknU8   redirAddrRspIndb;     /* redirection address response indicator*/
   TknU8   indexRspInd;          /* index response indicator */
} SiInfoIndA;
  
#endif

#ifdef SS7_UR
/* sit_x_001.main_64 : Added Information Indicator for ukraine */ 
typedef struct infoIndU           /* Information Indicators for Ukraine */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cgPtyAddrRespInd;     /* calling party address response ind. */
   TknU8   holdProvInd;          /* hold provided indicator */
   TknU8   cgPtyCatRespInd;      /* calling party category response ind. */
   TknU8   chrgInfoRespInd;      /* charge information response indicator */
   TknU8   solInfoInd;           /* solicitation information indicator */
   TknU8   geoLocRspInd;         /* geodetic location response indicator */
   TknU8   locNumRspInd;         /* location number response indicator */
   TknU8   locInfoRspInd;        /* location information response indicator */
   TknU8   bitPRspInd;           /* bit P */
} SiInfoIndU;
#endif
 
typedef struct infoReqInd        /* Information Request Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cgPtyAdReqInd;        /* calling party address request ind. */
   TknU8   holdingInd;           /* holding indicator */
   TknU8   cgPtyCatReqInd;       /* calling party category request ind. */
   TknU8   chrgInfoReqInd;       /* charge information request indicator */
   TknU8   malCaIdReqInd;        /* malicious call id request indicator */
   TknU8   spare;                /* spare (insure second octet...) */
} SiInfoReqInd;
  
#if (defined(SS7_ANS88) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct infoReqIndA       /* Information Request Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cgPtyAdReqInd;        /* calling party address request ind. */
   TknU8   connAddrReqInd;       /* connected address request indicator */
   TknU8   cgPtyCatReqInd;       /* calling party category request ind. */
   TknU8   chrgInfoReqInd;       /* charge information request indicator */
   TknU8   redirAddrReqInd;      /* redirection address request indicator */
   TknU8   indexReqInd;          /* index request indicator */
   TknU8   malCaIdReqInd;        /* malicious call id request indicator */
   TknU8   holdingInd;           /* holding id request indicator */
} SiInfoReqIndA;
  
#endif

#ifdef SS7_UR
/* sit_x_001.main_64 : Added Information Request Indicator for ukraine */
typedef struct infoReqIndU       /* Information Request Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cgPtyAdReqInd;        /* calling party address request ind. */
   TknU8   holdingInd;           /* holding indicator */
   TknU8   cgPtyCatReqInd;       /* calling party category request ind. */
   TknU8   chrgInfoReqInd;       /* charge information request indicator */
   TknU8   malCaIdReqInd;        /* malicious call id request indicator */
   TknU8   geoLocReqInd;         /* geodetic location request indicator */
   TknU8   locNumReqInd;         /* location number request indicator */
   TknU8   locInfoReqInd;        /* location information request indicator */
   TknU8   bitPReqInd;           /* Bit P */
} SiInfoReqIndU;
#endif
 
typedef struct natConInd         /* Nature of Connection Indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8   satInd;               /* Satellite Indicator */
   TknU8   contChkInd;           /* continuity check indicator */
   TknU8   echoCntrlDevInd;      /* echo control device indicator */
} SiNatConInd;
  
typedef struct optBckCalInd      /* Optional Backward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   inbndInfoInd;         /* in-band information indicator */
   TknU8   caFwdMayOcc;          /* call forwarding may occur indicator */
   TknU8   simpleSegmInd;        /* Simple segmentation indicator */
   TknU8   mlppUserInd;          /* MLPP User indicator */
   TknU8   netExcDelInd;         /* Network excessive delay indicator */
   TknU8   usrNetIneractInd;     /* user-network interaction indicator */
} SiOptBckCalInd;

/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
typedef struct optBckCalIndQ     /* Optional Backward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 inbndInfoInd;           /* in-band information indicator */
   TknU8 caFwdMayOcc;            /* call forwarding may occur indicator */
} SiOptBckCalIndQ;
#endif  

typedef struct opFwdCalInd       /* Optional Forward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 clsdUGrpCaInd;          /* closed user group call indicator */
   TknU8 simpleSegmInd;          /* Simple segmentation indicator */
   TknU8 conLineIdReqInd;        /* Connected line identity request ind */
} SiOpFwdCalInd;
  
  
#if (defined(SS7_ANS88) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct opFwdCalIndA      /* Optional Forward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 clsdUGrpCaInd;          /* closed user group call indicator */
   TknU8 ccbsCallInd;            /* CCBS call indicator */
   TknU8 callgPtyNumIncomInd;    /* calling party number incomplete ind. */
   TknU8 connAddrReqInd1;        /* connected address request indicator */
} SiOpFwdCalIndA;
#endif
  
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
typedef struct opFwdCalIndQ      /* Optional Forward Call Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 clsdUGrpCaInd;          /* closed user group call indicator */
   TknU8 connAddrReqInd1;        /* connected address request indicator */
} SiOpFwdCalIndQ;
#endif
  
#if SS7_Q767IT
typedef struct fwdVadInd         /* Forward Vad Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 srvSteInd;              /* service state indicator */
   TknU8 procInd;                /* procedure indicator */
} SiFwdVadInd;

typedef struct backVadInd         /* Backward Vad Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 snInd;                  /* sn indicator */
   TknU8 oddEven;                /* odd or even */
   TknStr addrSig;               /* Address Signal */
} SiBackVadInd;
#endif
  
typedef struct origCdNum         /* Original Called Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrInd;                 /* screening indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiOrigCdNum;
  
typedef struct rangStat          /* Range and Status */
{
   ElmtHdr eh;                   /* element header */
   TknU8 range;                  /* range */
   TknStr status;                /* status */
} SiRangStat;
  
typedef struct rangNoStat        /* Range and Status */
{
   ElmtHdr eh;                   /* element header */
   TknU8 range;                  /* range */
} SiRangNoStat;

typedef struct redirNum          /* Redirecting Number */
{                          
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrInd;                 /* screening indicator */
   TknU8 presRest;               /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiRedirNum;
  
typedef struct redirInfo         /* Redirection Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8 redirInd;               /* redirection indicator */
   TknU8 origRedirReas;          /* original redirection reason */
   TknU8 redirCnt;               /* redirection count */
   TknU8 redirReas;              /* redirection reason */
} SiRedirInfo;
  
typedef struct sisigPointCode    /* Signalling Point Code */
{
   ElmtHdr eh;                   /* element header */
   TknU16 sigPointCode;          /* signalling point code */
} SiSigPointCode;
  
#if (defined(SS7_ANS88) || defined(SS7_CHINA) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct sigPointCodeA     /* Signalling Point Code */
{
   ElmtHdr eh;                   /* element header */
   TknU32 sigPointCode;          /* signalling point code */
} SiSigPointCodeA;
  
#endif
typedef struct subNum            /* Subsequent Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 oddEven;                /* odd or even */
   TknStr addrSig;               /* Address Signal */
} SiSubNum;
  
typedef struct sisusResInd       /* Suspend/Resume indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 susResInd;              /* suspend/resume indicators */
} SiSusResInd;
  
typedef struct echoCtl       /* echo control indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 outEchoRsp;             /* outgoing echo control device response */
   TknU8 incEchoRsp;             /* incoming echo control device response */
   TknU8 outEchoReq;             /* outgoing echo control device request */
   TknU8 incEchoReq;             /* incoming echo control device request */
} SiEchoCtl;
  
typedef struct tranNetSel        /* Transit Network Selection */
{
   ElmtHdr eh;                   /* element header */
   TknU8 netIdPln;               /* network id plan */
   TknU8 typNetId;               /* type of network identification */
   TknU8 oddEven;                /* odd/even */
   TknStr netId;                 /* network identification */
} SiTranNetSel;
  
#if TNS_ANSI
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
typedef struct tranNetSel1       /* Transit Network Selection */
{
   ElmtHdr eh;                   /* element header */
   TknU8 netIdPln;               /* network id plan */
   TknU8 typNetId;               /* type of network identification */
   TknU8 oddEven;                /* odd/even */
   TknU8  dig1;                  /* Digit 1 */
   TknU8  dig2;                  /* Digit 2 */
   TknU8  dig3;                  /* Digit 3 */
   TknU8  CirCd;                 /* Circuit Code */
} SiTranNetSel1;
#endif	 
#endif	 
  
typedef struct txMedReq          /* Transmission Medium Requirement */
{
   ElmtHdr eh;                   /* element header */
   TknU8 trMedReq;               /* tranmission medium requirement */
} SiTxMedReq;
  
typedef struct usrServInfo       /* User Service Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8   infoTranCap;          /* information transfer capability */
   TknU8   cdeStand;             /* coding standard */
   TknU8   infoTranRate0;        /* information transfer rate */
   TknU8   tranMode;             /* transfer mode */
   TknU8   establish;            /* establishment */
   TknU8   config;               /* configuration */
   TknU8   chanStruct;           /* structure */
   TknU8   infoTranRate1;        /* information transfer rate */
   TknU8   symmetry;             /* symmetry */
   TknU8   rateMultiplier;       /* rate multiplier */
   TknU8   usrInfLyr1Prot;       /* usr information layer 1 protocol */
   TknU8   lyr1Ident;            /* layer 1 identity */
   TknU8   usrRate;              /* user rate */
   TknU8   negot;                /* negotiation */
   TknU8   syncAsync;            /* synchronous/asynchronous */
   TknU8   flcOnRx;              /* flow control on reception */
   TknU8   flcOnTx;              /* flow control on transmission */
   TknU8   niClkOnRx;            /* network independent clock on reception */
   TknU8   niClkOnTx;            /* network independent clock on transmission*/
   TknU8   interRate;            /* intermediate rate */
   TknU8   inOutBandNeg;         /* inband/outband negotiation */
   TknU8   asgnrAsgne;           /* assignor/assignee */
   TknU8   logLnkNegot;          /* logical link identifier negotiation */
   TknU8   mode;                 /* mode of operation */
   TknU8   multiFrm;             /* multiple frame establishment support */
   TknU8   hdrNohdr;             /* rate adaption header/no header */
   TknU8   parity;               /* parity information */
   TknU8   nmbDatBits;           /* number of data bits excluding parity bit */
   TknU8   nmbStpBits;           /* number of stop bits */
   TknU8   modemType;            /* modem type */
   TknU8   duplexMode;           /* duplex mode */
   TknU8   usrInfLyr2Prot;       /* user information layer 2 protocol */
   TknU8   lyr2Ident;            /* layer 2 identity */
   TknU8   usrInfLyr3Prot;       /* user information layer 3 protocol */
   TknU8   lyr3Ident;            /* layer 3 identity */
   /*sit_x_001.main_63: Added the elements */
   TknU8   addInfLyr3ProtA;      /* user information layer 3 protocol */
   TknU8   addInfLyr3ProtB;      /* user information layer 3 protocol */
} SiUsrServInfo;
  
typedef struct usr2UsrInd        /* User to User indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 type;                   /* type */
   TknU8 serv1;                  /* service 1 */
   TknU8 serv2;                  /* service 2 */
   TknU8 serv3;                  /* service 3 */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   TknU8 spare;                  /* bit H  (to be filled in both cases) */
#endif
} SiUsr2UsrInd;
  
typedef struct usr2UsrInfo       /* User to user information */
{
   ElmtHdr eh;                   /* element header */
   TknStr  info;                 /* user to user information */
} SiUsr2UsrInfo;
  
typedef struct sipassAlng        /* Pass Along */
{
   ElmtHdr eh;                   /* element header */
   TknStr  passAlng;             /* pass along */
} SiPassAlng;
  
typedef struct siEndOp           /* End of Optional Parameters */
{
   ElmtHdr eh;                   /* element header */
   TknU8 nullVal;                /* null value, if present */
} SiEndOp;
  
typedef struct siPduHdr          /* pdu header */
{
   ElmtHdr eh;                   /* element header */
   TknU8 msgType;                /* Message Type */
} SiPduHdr;
  
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_ITU2000  || SS7_UK|| \
     SS7_KZ || SS7_UR || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct chargeNum         /* Charge Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiChargeNum;
#endif

#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
typedef struct cirGrpCharInd     /* Circuit group characteristic indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 cirGrpCarInd;           /* circuit group carrier indicator */
   TknU8 dblSzCtrlInd;           /* double seizing control indicator */
   TknU8 alarmCarInd;            /* alarm carrier indicator */
   TknU8 contChkReqInd;          /* continuity check requirements indicator */
} SiCirGrpCharInd;
  
typedef struct cirIdName         /* Circuit ID Name */
{
   ElmtHdr eh;                   /* element header */
   TknStr trunkNumClli;          /* trunk number and clli code */
} SiCirIdName;
  
typedef struct sicirValRspInd    /* Circuit validation response indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8 cirValRspInd;           /* user to user info */
} SiCirValRspInd;
#endif

#if (defined(SS7_ANS88) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct cugChkRspInd      /* CUG check */
{
   ElmtHdr eh;                   /* element header */
   TknU8 accessInd;              /* access indicator */
   TknU8 divergInd;              /* divergence indicator */
   TknU8 chkSuccInd;             /* check successful indicator */
   TknU8 normCallInd;            /* normal call indicator */
   TknU8 cugCallInd;             /* closed user group call indicator */
} SiCugChkRspInd;
  
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
typedef struct clli              /* Common Language Location Idenification */
{
   ElmtHdr eh;                   /* element header */
   TknStr clliCode;              /* clli codes */
} SiCLLI;
#endif

#if (defined(SS7_ANS88) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct facInfInd         /* Facility Information Indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8 calldPtyFreeInd;        /* called party free indicator */
   TknU8 callgPtyAnsInd;         /* callg party answer indicator */
   TknU8 facReqEnqInd;           /* facility request enquiry indicator */
   TknU8 facReqActInd;           /* facility request active indicator */
} SiFacInfInd;

typedef struct siindex           /* Index  */
{
   ElmtHdr eh;                   /* element header */
   TknU32 index;                 /* index */
} SiIndex;
#endif

#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL) 
typedef struct origLineInf       /* Orignating Line Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8 lineInfo;               /* originating line information */
} SiOrigLineInf;

typedef struct outgTrkGrpNum     /* Outgoing Trunk Group Number */
{
   ElmtHdr eh;                   /* element header */
   TknStr digits;                /* digits */
} SiOutgTrkGrpNum;
#endif

typedef struct sinotifInd        /* Notification Indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8 notifInd;               /* Notification Indicator */
} SiNotifInd;

typedef struct siserviceAct      /* Service Activation */
{
   ElmtHdr eh;                   /* element header */
   TknStr serviceAct;            /* service activation */
} SiServiceAct;

typedef struct genAddr           /* Generic Address */
{
   ElmtHdr eh;                   /* element header */
   TknU8 typeOfAddr;             /* type of address */
   TknU8 natAddr;                /* nature of address indicator */
   TknU8 oddEven;                /* odd or even address signal */
   TknU8 presRest;               /* presentation restriction */
   TknU8 numPlan1;               /* numbering plan */
#ifdef SI_ANSILNP
   TknU8 testInd;                /* test indicator */
#endif /* SI_ANSILNP */
   TknStr addrSig;               /* addressing signal */
} SiGenAddr;

typedef struct genDigits         /* Generic Digits */
{
   ElmtHdr eh;                   /* element header */
   TknU8 typeOfDigits;           /* type of digits */
   TknU8 encodeScheme;           /* encoding scheme */
   TknStr digits;                /* digits */
} SiGenDigits;

#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct serviceCode       /* Service code */
{
   ElmtHdr eh;                   /* element header */
   TknU8 sCode;                  /* service code */
} SiServiceCode;

typedef struct businessGrp       /* Business Group */
{
   ElmtHdr eh;                   /* element header */
   TknU8   partySel;             /* party selector */
   TknU8   linePrivInfInd;       /* line privileges info. ident. */
   TknU8   BGIDident;            /* BGID identifier  */
   TknU8   attendStat;           /* attendant status */
   TknU32  busiGrpIdent;         /* business group identifier */
   TknU16  subGrpIdent;          /* sub-group identifier */
   TknU8   linePriv;             /* line privileges */
} SiBusinessGrp;

typedef struct carrierId         /* Carrier ID */
{   
   ElmtHdr eh;                   /* element header */
   TknU8 netIdPln1;              /* network id plan */
   TknU8 typNetId2;              /* type of network identification */
   TknU8 CIDigit1;               /* Network Identity Digit 1 */
   TknU8 CIDigit2;               /* Network Identity Digit 2 */
   TknU8 CIDigit3;               /* Network Identity Digit 3 */
   TknU8 CIDigit4;               /* Network Identity Digit 4 */
} SiCarrierId;

typedef struct sicarrierSelInf   /* Carrier Selection Information  */
{
   ElmtHdr eh;                   /* element header */
   TknU8   carrierSelInf;        /* carrier selection information */
} SiCarrierSelInf;

typedef struct siegress          /* Egress Service */
{
   ElmtHdr eh;                   /* element header */
   TknStr  egress;               /* egress */
} SiEgress;

typedef struct jurisInf          /* Jurisdiction Information */
{
   ElmtHdr eh;                   /* element header */
   TknU8 addrSig1;               /* address signal 1 */
   TknU8 addrSig2;               /* address signal 2 */
   TknU8 addrSig3;               /* address signal 3 */
   TknU8 addrSig4;               /* address signal 4 */
   TknU8 addrSig5;               /* address signal 5 */
   TknU8 addrSig6;               /* address signal 6 */
} SiJurisInf;

typedef struct sinetTransport    /* Network Transport */
{
   ElmtHdr eh;                   /* element header */
   TknStr  netTransport;         /* network transport */
} SiNetTransport;

typedef struct sispecProcReq     /* Special Processing Request */
{
   ElmtHdr eh;                   /* element header */
   TknU8   specProcReq;          /* special processing request */
} SiSpecProcReq;

typedef struct transReq          /* Transaction Request */
{
   ElmtHdr eh;                   /* element header */
   TknU32  transId;              /* transaction id */
   TknStr SCCPAddr;              /* SCCP address */
} SiTransReq;
#endif

#if (SS7_ETSI || SS7_FTZ || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct ccbsParam          /* CCBS Parmeter */
{
   ElmtHdr eh;                   /* element header */
   TknU8   ccbsCallInd;          /* CCBS call indicator */
} SiCcbsParam;

typedef struct sifreePhInd    /* Freephone Indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8   freePhInd;            /* free phone indicator */
} SiFreePhInd;
#endif /* SS7_ETSI */

typedef struct callTRef    /* Call Transfer Reference */
{
   ElmtHdr eh;                   /* element header */
   TknU8   callTrnsfr;           /* call transfer reference */
} SiCallTRef;

typedef struct loopPrvntInd      /* loop prevention indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8   loopPrvntType;        /* loop prevention type */
   TknU8   loopPrvntRspInd;      /* loop prevention response indicator */
} SiLoopPrvntInd;

#if SS7_FTZ
typedef struct naPaFF          /* National Parameter FF */
{
   ElmtHdr eh;                   /* element header */
   union 
   {
      struct
      {
         TknStr  data;           /* undecoded data */
      } inNANA;

      struct
      {
         TknU8   natClgPtyCat;   /* national calling party category */
         TknU8   catphInd;       /* catastrophe indicator */
         TknU8   zoneInd;        /* zoning indicator */
         TknU8   srvIndOct;      /* service indicator octet */
         TknU8   srvIndAddOct;   /* service indicator additional info octet */
      } inIAM;

      struct
      {
         TknU8   SINMeanInd;     /* SIN meaning indicator */
         TknU8   srvIndOct;      /* service indicator octet */
         TknU8   srvIndAddOct;   /* service indicator addtitional info octet */
      } inANM;

      struct
      {
         TknU8   facCode;        /* facility code */
         TknU8   srvIndOct;      /* service indicator octet */
         TknU8   srvIndAddOct;   /* service indicator addtitional info octet */
         TknU8   trmSelCode;     /* terminal selection code */ 
         TknU8   cugCallInd;     /* closed user group call indicator */
         TknU32  cugIntCode;     /* closed user group interlock code */
      } inFRQ;

      struct
      {
         TknU8   multPurp;       /* multipurpouse code */
      } inMultMsg;

   } messg;
} SiNaPaFF;

typedef struct naPaSSP         /* National Parameter SSP */
{
   ElmtHdr eh;                   /* element header */
   TknU8   stopSignMon;          /* indic. for stopping signalling monitoring */
   TknU8   nmbFiveProt;          /* indic. for number 5 protection function */
   TknU8   callDiver;            /* indic. for call diversion */
   TknU8   naPaTrnstInd;         /* transit indicator */
   TknU8   servTypRec;           /* service type recognition  */
} SiNaPaSSP;
 
typedef struct naPaExTID       /* National Parameter ExT-ID */
{
   ElmtHdr eh;                   /* element header */
   TknU16  sigPntCde;            /* signalling point code */
   TknStr  incTrkId;             /* incoming trunk Id */
} SiNaPaExTID;
 
typedef struct sinaPaTTZ       /* National Parameter for Tln-2-Tln sign. */
{
   ElmtHdr eh;                   /* element header */
   TknStr  naPaTTZ;              /* national paramemeter for Tln-2-Tln sign. */
} SiNaPaTTZ;

typedef struct naPaFE          /* National Parameter FE */
{
   ElmtHdr eh;                   /* element header */
   TknU8   disastrPriv;          /* Disaster Privilege */
} SiNaPaFE;

typedef struct naPaSPV         /* National Parameter SPV */
{
   ElmtHdr eh;                   /* element header */
   TknU8   naPaSPVInd;           /* SPV indicator */
   TknU8   naPaSPVSrvInd;        /* SPV service indicator */
   TknU8   naPaKDEInd;           /* KDE indicator */
} SiNaPaSPV;

typedef struct naPaUKK         /* National Parameter UKK */
{
   ElmtHdr eh;                   /* element header */
   TknU8   intSpRoutInd;         /* international special routing indicator */
   TknU8   intSpZonInd;          /* international special zoning indicator */
   TknU8   intCarRoutInd;        /* international carrier routing indicator */
   TknU8   natCarRoutInd;        /* national carrier routing indicator */
   TknU8   rstrRteAccCds;        /* restriction on route access codes */
   TknU8   clientRecognIndA;     /* client recognition Indicator 1st octet */
   TknU8   clientRecognIndB;     /* client recognition Indicator 2nd octet */
   TknU8   servTypeRecogn;       /* service type recognition */
} SiNaPaUKK;

typedef struct naPaCdPNO       /* National Parameter CdPNO */
{
   ElmtHdr eh;                   /* element header */
   TknU8   natAddrInd;           /* nature of address indicator */
   TknU8   oddEven;              /* odd or even */
   TknU8   screenInd;            /* screening indicator */
   TknU8   presRest;             /* presentation restriction */
   TknU8   numPlan;              /* numbering plan */
   TknU8   innInd;               /* international network number indicator */
   TknStr  addrSig;              /* Address Signal */
} SiNaPaCdPNO;

typedef struct naPaCHGI        /* National Parameter CHGI */
{
   ElmtHdr eh;                   /* element header */
   TknU8   naPaSeqNmb;           /* sequence number */
   TknU8   naPaRcptInf;          /* receipt information */
} SiNaPaCHGI;

typedef struct facIndInfor       /* Facility Information Indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8   cldPtyFreeInd;        /* called party free indicator */
} SiFacIndInfor;

#endif

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_UK || SS7_ETSIV3 || defined(TDS_ROLL_UPGRADE_SUPPORT) || \
     SS7_NZL || SS7_KZ || SS7_UR)
typedef struct naPaChgPID      /* National Parameter ChgPID */
{
   ElmtHdr eh;                   /* element header */
   TknStr  naPaChgPtyId;         /* charged party identification */
} SiNaPaChgPID;
#endif

/* sit_x_001.main_54: Modified to add control flag for ISUP Kazakhstan
   billZoneNum also represent tariff zone number */
/* sit_x_001.main_57 : deleted SS7_KZ flag */
#if SS7_RUSSIA
typedef struct sibillZoneNum     /* Billing Zone Number */
{
   ElmtHdr eh;                   /* element header */
   TknU32   billZoneNum;         /* Billing Zone Number */
} SiBillZoneNum;
#endif

/* sit_x_001.main_57 : added Tariff zone number structure to support Charge 
   Information message for Kazakhatan */
#if SS7_KZ
typedef struct sitariffZoneNum   /* Tariff Zone Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8   tariffZoneNum;       /* Tariff Zone Number */
} SiTariffZoneNum;
#endif

typedef struct cirAsgnMap        /* circuit assignment map */
{
   ElmtHdr eh;                   /* element header */
   TknU8   mapType;              /* map type */
   TknU32  mapFormat;            /* map format */
} SiCirAsgnMap;

#if (defined(SS7_ANS95) || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct optrServicesInfo  /* operator services information */
{
   ElmtHdr eh;                   /* element header */
   /* sit_x_001.main_54 : Corrected the order of token element */
   TknU8  infoVal;              /* infomation value */
   TknU8  infoType;             /* information type */
} SiOptrServicesInfo;
#endif

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if ((SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000)  || SS7_UK || \
      SS7_NZL || SS7_KZ || SS7_UR || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct backGVNS          /* backward GVNS */
{
   ElmtHdr eh;                   /* element header */
   TknU8   termAccessInd;        /* terminating access indicator */
   TknStr  extInfo;              /* Extension Info */
} SiBackGVNS;

typedef struct forwardGVNS       /* forward GVNS */
{
   ElmtHdr eh;                   /* element header */
   TknU8   lenInd1;              /* length indicator */
   TknU8   oddEven1;             /* odd or even address signal */
   TknStr  digits1;              /* digits */
   TknU8   lenInd2;              /* length indicator */
   TknU8   oddEven2;             /* odd or even address signal */
   TknStr  digits2;              /* digits */
   TknU8   lenInd3;              /* length indicator */
   TknU8   numPlan;              /* numbering plan */
   /* sit_x_001.main_66 : corrected order of numplan and oddEven3 */
   TknU8   oddEven3;             /* odd or even address signal */
   TknU8   natOfAddr;            /* nature of address */
   TknStr  digits3;              /* digits */
} SiForwardGVNS;

#endif

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_INDIA  || \
     SS7_UK || SS7_ETSIV3 || SS7_NZL || \
     SS7_KZ || SS7_UR || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct callDivTrtInd     /* call diversion treatment indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   callDivInd;           /* call to be diverted indicator */
   TknStr  extInfo;              /* Extension Info */
} SiCallDivTrtInd;

typedef struct callOfferTrtInd   /* call offering treatment indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   callOfferInd;         /* call to be offered indicator */
   TknStr  extInfo;              /* Extension Info */
} SiCallOfferTrtInd;

typedef struct callInNmb         /* call IN number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddr;                /* nature of addresss indicator */
   TknU8 oddEven;                /* odd or even */
   TknU8 scrInd;                 /* screening indicator */
   TknU8 presRest;              /* Address presentation restricted ind. */
   TknU8 numPlan;                /* numbering plan */
   TknStr addrSig;               /* Address Signal */
} SiCallInNmb;

typedef struct ccss              /* CCSS */
{
   ElmtHdr eh;                   /* element header */
   TknU8   ccssCallInd;          /* CCSS call indicator */
} SiCcss;

typedef struct collCallReq       /* collect call request */
{
   ElmtHdr eh;                   /* element header */
   TknU8   collCallReqInd;       /* collect call req. indicator */ 
} SiCollCallReq;
typedef struct confTrtInd        /* conference treatment indicators */
{
   ElmtHdr eh;                   /* element header */
   TknU8   confAcceptInd;        /* conference acceptance indicators */
   TknStr  extInfo;              /* Extension Info */
} SiConfTrtInd;

typedef struct sicorrelationId   /* correlation Id */
{
   ElmtHdr eh;                   /* element header */
   TknStr  correlationId;        /* correlation Id */
} SiCorrelationId;

typedef struct sidisplayInfo     /* display information */
{
   ElmtHdr eh;                   /* element header */
   TknStr  displayInfo;          /* display information */
} SiDisplayInfo;

typedef struct netMgmtControls   /* network management controls */
{
   ElmtHdr eh;                   /* element header */
   TknU8  tmpAltRoutInd;        /* tmp alternative routing Ind. */
   TknStr  extInfo;              /* Extension Info */
} SiNetMgmtControls;

typedef struct siScfId           /* SCF Id */
{
   ElmtHdr eh;                   /* element header */
   TknStr  scfId;                /* SCF Id */
} SiScfId;

typedef struct uidActionInd      /* UID action indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8   throughConnInstInd;   /* Through connection instruction ind. */
   TknU8   t9InstInd;            /* T9 instruction ind. */
} SiUidActionInd;

typedef struct uidCapInd         /* UID capability indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8   throughConnInd;       /* Through connection instruction ind. */
   TknU8   t9Ind;                /* T9 instruction ind. */
} SiUidCapInd;
#endif
   
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR || \
     defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct appTransParam /* application transport parameter */
{
   ElmtHdr eh;                   /* element header */
   TknU8   appContextId;         /* application context identifier */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ || SS7_UR)
   TknU8   appContextId1;        /* application context identifier */
#endif
   TknU8   atii;                 /* application transport inst. ind. */
   TknU8   apmSegInd;            /* APM segmentation indicator */
   TknU8   seqInd;               /* sequence indicator */
   TknU8   slr;                  /* segmentation local reference */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ || SS7_UR)
   TknU8   origAddrLen;          /* Originating Address length */
   TknU8   origNatAddr;          /* Originating Nature Of Address Ind */
   TknU8   origOddEven;          /* Originating odd or even address signal */
   TknU8   origNumPlan;          /* Originating numbering plan */
   TknU8   origINNInd;           /* internal network number indicator */
   TknStr  origAddrSig;          /* Originating addressing signal */
   TknU8   destAddrLen;          /* Destination Address length */
   TknU8   destNatAddr;          /* Destination Nature Of Address Ind */
   TknU8   destOddEven;          /* Destination odd or even address signal*/
   TknU8   destNumPlan;          /* Destination numbering plan */
   TknU8   destINNInd;           /* internal network number indicator */
   TknStr  destAddrSig;          /* Destination addressing signal */
#endif 
	/* sit_x_001.main_63 :: Modified the datatype, from TknStr to TknStrE */
   TknStrE  encapAppInfo;        /* encapsulated application info */
} SiAppTransParam;
#endif

#if (SS7_INDIA || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct chargeBand /* charge band parameter */
{
   ElmtHdr eh;                   /* element header */
   TknU8   chrgeBandNum;         /* charge band number */
} SiChargeBand;
#endif

#ifdef SS7_CHINA 
typedef struct chargeInform /* charge information */
{
   ElmtHdr eh;                   /* element header */
   TknU16  chargeInformation;    /* charge information */
} SiChargeInform;
#endif

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000  || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR || \
      defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct calgGeoLoc        /* Calling geodetic location */
{
   ElmtHdr eh;                   /* element header */
   TknU8 scrnInd;                /* screen indicator */
   TknU8 presRest;               /* location presentation restricted ind. */
   TknU8 typeShape;              /* type of shape */
   TknStr  shapeDescr;           /* shape descpiption */
} SiCalgGeoLoc;


typedef struct ccnrPosInd        /* CCNR Possible indicator */
{
   ElmtHdr eh;                   /* element header */
   TknU8  ccnrPosInd;            /* CCNR Possible indicator */
} SiCCNRPosInd;

typedef struct netRoutNum        /* Network Routing Number */
{
   ElmtHdr eh;                   /* element header */
   TknU8 natAddrInd;             /* nature of addresss indicator */
   TknU8 numPlan;                /* numbering plan */
   TknU8 oddEven;                /* odd or even */
   TknStr addrSig;               /* Address Signal */
} SiNetRoutNum;

typedef struct pivotCap          /* Pivot Capability */
{
   ElmtHdr eh;                   /* element header */
   TknU8  pivotPossInd;          /* Pivot possible indicator */
   TknU8  iwToRedirInd;          /* Interworking to redirection ndicator */
} SiPivotCap;

typedef struct pivotCntr         /* Pivot Counter */
{
   ElmtHdr eh;                   /* element header */
   TknU8  pivotCntr;             /* Pivot Counter */
} SiPivotCntr;

typedef struct pivotRtgInd       /* Pivot Routing Info */
{
   ElmtHdr eh;                   /* element header */
   TknU8  pivotRtg;              /* Pivot routing info */
} SiPivotRtgInd;

typedef struct pivotRtgBkInfo    /* Pivot Routing Backward/Fwd Info */
{
   ElmtHdr eh;                   /* element header */
   TknStr  pivotRtgInfo;         /* pivot routing info */
} SiPivotRtgBkInfo;
typedef struct numPortFwdInfo    /* Number Portability Forward Info */
{
   ElmtHdr eh;                   /* element header */
   TknU8  numPortStatus;         /* number portability status */
 /*sit_x_001.main_65: Added extension info */
   TknStr  extInfo;              /* Extension Info */
} SiNumPortFwdInfo;

typedef struct qOnRelCap         /* Query on Release Capability */
{
   ElmtHdr eh;                   /* element header */
   TknU8  qorCap;                /* QOR capability information */
} SiQOnRelCap;
typedef struct pivotStat         /* Pivot Status */
{
   ElmtHdr eh;                   /* element header */
   TknU8  status;                /* status */
} SiPivotStat;

typedef struct redirStat         /* Redirect Status Info */
{
   ElmtHdr eh;                   /* element header */
   TknU8  status;                /* status */
} SiRedirStat;
#endif

  /* UK specific Signalling Parameters */
#if (SS7_UK || defined(TDS_ROLL_UPGRADE_SUPPORT))

typedef struct siNatFwdCalInd			/* National Forward Call Indicators */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    cliBlkInd;						/* Call Indicator */
    TknU8    nwTransAddrInd;				/* Network Translated Address Indicator */
    TknU8    priorAccessInd;				/* Priority Access Indicator */
    TknU8    protectionInd;					/* Protection Indicator */
    TknU8    spare; 
}SiNatFwdCalInd;

typedef struct siNatFwdCalIndLnk  		/* National Forward Call Indicators(Link By Link) */
{
   ElmtHdr    eh;							/* Element Header */
   TknU8      rci;							/* Routing Control Indicator */
   TknU8      isi;							/* Interconnect Specific Information */
}SiNatFwdCalIndLnk;

typedef struct siPresentNum			/* Presentation Number */
{
    ElmtHdr eh;							/* Element Header */
    TknU8   NatAddrInd;					/* Nature of Address Indicator */
    TknU8   oddEven;						/* Odd or Even */
    TknU8   scrInd;							/* Screening Indicator */
    TknU8   presRest;						/* Address Presentation Restricted Indicator */
    TknU8   numPlanInd;					/* Numbering Plan Indicator */
    TknU8   presNumPrefPlan;				/* PNP - Presentation Number Preference Plan */
    TknStr   addrSig;  						/* Address Signal */
}SiPresentNum;

typedef struct siLstDvrtLineID			/* Last Diverting Line Identity */
{
    ElmtHdr eh;							/* Element Header */
    TknU8   NatAddrInd;					/* Nature of Address Indicator */
    TknU8   oddEven;						/* Odd or Even */
    TknU8   scrInd;							/* Screening Indicator */
    TknU8   presRest;						/* Address Presentation Restricted Indicator */
    TknU8   numPlanInd;					/* Numbering Plan Indicator */
    TknU8   numIncompInd;				/* Number Incomplete Indicator  */
    TknStr   addrSig;  						/* Address Signal */
}SiLstDvrtLineID;

typedef struct siPartialCgLineId			/* Partial Calling Line Identity */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    typeOfSwitch1; 				/* Type of Switch (BCD) D1(tens unit) */
    TknU8    typeOfSwitch2;					/* Type of Switch (BCD) D2(units digit) */
    TknU8    pnoId1; 						/* PNO Identity (BCD) D1(Hundreds digit) */
    TknU8    pnoId2;						/* PNO Identity (BCD) D2(tens digit) */
    TknU8    pnoId3;						/* PNO Identity (BCD) D3(units digit) */
    TknU8    switchNum1; 					/* Switch Number(BCD) D1(hundreds digit) */
    TknU8    switchNum2; 					/* Switch Number (BCD) D2(tens digit) */
    TknU8    switchNum3;					/* Switch Number (BCD) D3(units digit) */
    TknU8    bilateralAgrmnt1;				/* For Bilateral Agreement */
    TknU8    bilateralAgrmnt2;				/* For Bilateral Agreement */
    TknU8    bilateralAgrmnt3;				/* For Bilateral Agreement */
    TknU8    bilateralAgrmnt4;				/* For Bilateral Agreement */
    TknU8    bilateralAgrmnt5;				/* For Bilateral Agreement */
}SiPartialCgLineId;



typedef struct siCdBasicSrvcMarks		/* called Subscribers Basic Service Marks  */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    admMntCallBarInd;				/* Admin./Maintenance Call Barring Indicator */
    TknU8    subCtrldICBInd;				/* Subscriber Controlled Incoming Calls Barred Indicator */
    TknU8    preArngdICBInd;				/* Pre-arranged ICB indicator */
    TknU8    permICBInd;					/* Permanent ICB indicator */
    TknU8    tosInd;						/* Temporary Out Of Service Indicator */
    TknU8    icbExcptOpInd;					/* ICB Except for operator Indicator */
    TknU8    cdFacInfoInd;					/* Called Subscriber Facility Information Indicator */
    TknU8    cgFacInfoInd;					/* Calling Subscriber Facility Information Indicator */
    TknU8    permOCBInd;					/* Permanent Outgoing Calls Barred (OCB) Indicator */
    TknU8    outLocCallBarInd;				/* Outgoing Local Calls Barred Indicator */
    TknU8    outNatCallBarInd;				/* Outgoing National Calls Barred Indicator */
    TknU8    outIntCallBarInd;				/* Outgoing International Calls Barred Indicator  */
    TknU8    operCallBarInd;				/* Operator Calls Barred Indicator */
    TknU8    suppFacCallBarInd;				/* Supplementary Facility Calls Barred Indicator */
    TknU8    digitMaskInd;					/* Digit Masking Indicator */
    TknU8    callPremPhBarInd;				/* Calls to Premium-phones Barred Indicator */
    TknU8    cdSubTariffGrp;				/* Called Subscriber's Tariff Group */
    TknU8    operInd;						/* Operator Indicator */
}SiCdBasicSrvcMarks;


typedef struct siCgBasicSrvcMarks		/* calling Subscribers Basic Service Marks  */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    admMntCallBarInd;				/* Admin./Maintenance Call Barring Indicator */
    TknU8    subCtrldICBInd;				/* Subscriber Controlled Incoming Calls Barred Indicator */
    TknU8    preArngdICBInd;				/* Pre-arranged ICB indicator */
    TknU8    permICBInd;					/* Permanent ICB indicator */
    TknU8    tosInd;						/* Temporary Out Of Service Indicator */
    TknU8    icbExcptOpInd;					/* ICB Except for operator Indicator */
    TknU8    cdFacInfoInd;					/* Called Subscriber Facility Information Indicator */
    TknU8    cgFacInfoInd;					/* Calling Subscriber Facility Information Indicator */
    TknU8    permOCBInd;					/* Permanent Outgoing Calls Barred (OCB) Indicator */
    TknU8    outLocCallBarInd;				/* Outgoing Local Calls Barred Indicator */
    TknU8    outNatCallBarInd;				/* Outgoing National Calls Barred Indicator */
    TknU8    outIntCallBarInd;				/* Outgoing International Calls Barred Indicator  */
    TknU8    operCallBarInd;				/* Operator Calls Barred Indicator */
    TknU8    suppFacCallBarInd;				/* Supplementary Facility Calls Barred Indicator */
    TknU8    digitMaskInd;					/* Digit Masking Indicator */
    TknU8    callPremPhBarInd;				/* Calls to Premium-phones Barred Indicator */
    TknU8    cgSubTariffGrp;				/* Calling Subscriber's Tariff Group */
    TknU8    operInd;						/* Operator Indicator */
}SiCgBasicSrvcMarks;

typedef struct siCgOrigFacMarks		/* Calling Subscriber's Originating Facility Marks */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    disSubInd;						/* Disabled Subscriber Indicator */
    TknU8    atndCallOffInd;					/* Attended Call Office Indicator */
    TknU8    adcInd;						/* Advise Duration and Charge (AD&C) Indicator */
    TknU8    pbxSubInd;					/* PBX Subscriber Indicator */
    TknU8    spare; 
}SiCgOrigFacMarks;


typedef struct siCdTermFacMarks		/* Called Subscriber's Terminating Facility Marks */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    sviInd;						/* SVI Indicator */
    TknU8    cniInd;						/* CNI Indicator */
    TknU8    pbxNightIntercepInd;			/* PBX Night Interception Indicator */
    TknU8    callWaitInd;					/* Call Waiting Indicator */
    TknU8    fixDestInd;					/* Fixed Destination Service Indicator */
    TknU8    spare; 
	
}SiCdTermFacMarks;


typedef struct siNatInfoReqInd			/* National Information Request Indicators */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    cgBasSrvcMrkReqInd;			/* Calling Subscriber's Basic Service Marks request indicator */
    TknU8    cdBasSrvcMrkReqInd;			/* Called Subscriber�s Basic Service Marks request indicator */
    TknU8    cgOrigFacMrkReqInd;			/* Calling Subscriber's Originating Facility Marks request indicator */
    TknU8    cdTermFacMrksReqInd;			/* Called Subscriber's Terminating Facility Marks request indicator */
    TknU8    lineIdReqInd;					/* Intercepted Line Identity request indicator */
    TknU8    lineIdnCdBasSrvcMrkReqInd;	/* Intercepted Line Identity and Called Subscriber's Basic Service Marks request indicator*/
    TknU8    spare;
}SiNatInfoReqInd;


typedef struct siNatInfoInd				/* National Information Indicators */
{
    ElmtHdr  eh;							/* Element Header */
    TknU8    cgBasSrvcMrkRspInd;			/* Calling Subscriber's Basic Service Marks response indicator */
    TknU8    cdBasSrvcMrkRspInd;			/* Called Subscriber�s Basic Service Marks response indicator */
    TknU8    cgOrigFacMrkRspInd;			/* Calling Subscriber's Originating Facility Marks response indicator */
    TknU8    cdTermFacMrkRspInd;			/* Called Subscriber's Terminating Facility Marks response indicator */
    TknU8    lineIdRspInd;					/* Intercepted Line Identity response indicator */
    TknU8    lineIdnCdBasSrvcMrkRspInd;	/* Intercepted Line Identity and Called Subscriber's Basic Service Marks response indicator */
    TknU8    spare; 
}SiNatInfoInd;

#endif /* SS7_UK */

#ifdef SANGOMA_SPIROU
typedef struct siMsgNum		/* message  Number */
{
    ElmtHdr  eh;		/* Element Header */
    TknU8    msgNum;	        /* message  Number */	
}SiMsgNum;


typedef struct siChargUnitNum		/* Chage Unit Number */
{
    ElmtHdr  eh;	        	/* Element Header */
    TknU8    chargUnitNum;	        /* Chage Unit Number */	
}SiChargUnitNum;
#endif /* SANGOMA_SPIROU */

/* Message Structures */
  
typedef struct siPduACM          /* Address Complete  message */
{
   SiBckCalInd     bckCalInd;    /* backward call indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA      callRefA;     /* call reference */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiConnReqA      connReqA;     /* connection request */
#endif
   SiOptBckCalInd  optBckCalInd; /* optional backward call indicators */
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
   SiOptBckCalIndQ optBckCalIndQ;/* Q767 optional backward call indicators */
#endif  
   SiCauseDgn      causeDgn;     /* cause indicators */
   SiConnectedNum  connNum;      /* connected number */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   SiConnectedNum2 connNum2;     /* connected number */
#endif
   SiCallRef       callRef;      /* call reference */
   SiUsr2UsrInd    usr2UsrInd;   /* user to user indicators */
   SiUsr2UsrInfo   usr2UsrInfo;  /* user to user information */
#if SS7_ANS88
   SiRedirInfo     redirInfo;    /* redirection information */
#endif
   SiAccTrnspt     accTrans;     /* access transport */
   SiNotifInd      notifInd1;    /* notification indicator */
   SiNotifInd      notifIndR;    /* notification ind (repeated - ITU97/92) */
   SiTxMedReq      txMedUsed;    /* transmission medium used */
   SiEchoCtl       echoControl;  /* echo control */
   SiAccDelInfo    accDelInfo;   /* access delivery information */
   SiCdPtyNum      redirNum;     /* redirection number */
   SiParmCompInfo  parmCom;      /* parameter compatibility information */
   SiCllDiverInfo  cllDivr;      /* call Diversion information */
   SiNetSpecFacil  netFac;       /* network specific facility */
/* sit_x_001.main_53 : Removed remotOper1, serviceAct2 for china variant */
   SiRemotOper     remotOper;    /* remote operations */
   SiServiceAct    serviceAct;   /* service activation */
   SiRedirRestr    redirRstr;    /* redirection restriction */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp   businessGrp;  /* business group */
   SiInfoInd       infoInd;      /* information indicators */
   SiNetTransport  netTransport; /* network transport */
   SiNotifInd      notifInd;     /* notification indicator */
   SiRedirInfo     redirInf;     /* redirection information */
#endif
#if SS7_Q767IT
   SiBackVadInd    backVad;      /* backward vad indicators */
#endif
#if SS7_SINGTEL
   TrnkOff         trnkOff;      /* trunk offering information */
#endif
#if SS7_NTT
   SiMsgAreaInfo        msgAreaInfo;        /* Message Area Information */
   SiChrgInfo           chrgInfo;           /* Charge information */
   SiChrgInfoType       chrgInfoType;       /* Charge information type */
   SiChrgInfoDelay      chrgInfoDelay;      /* Charge information delay */
   SiCarrierInfoTrans   carrierInfoTrans;   /* Carrier Info Transfer */ 
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
      SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiConfTrtInd    confTrtInd;   /* confrence treatment indicators */
   SiUidActionInd  uidActionInd; /* UID action indicator */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 ||  SS7_UK || SS7_KZ || SS7_UR)
   SiCCNRPosInd  ccnrPosInd;     /* CCNR Possible indicator */
   SiChargeNum htrInfo;          /* HTR Information */
   SiPivotRtgBkInfo pivotRtgBkInfo;  /*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
#endif
#ifdef SS7_UK
   SiCdBasicSrvcMarks cdBasicSrvcMrk;	/* Called Subscriber's Basic Service Marks */
#endif /* SS7_UK */
   SiEndOp         endOp;        /* end of optional parameters */
} SiPduACM;
  
typedef struct siPduANM          /* Answer */
{
   SiBckCalInd    bckCalInd;     /* backward call indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiConnReqA     connReqA;      /* connection request */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA     callRefA;      /* call reference */
#endif
   SiOptBckCalInd optBckCalInd;  /* optional backward call indicators */
   SiCallRef      callRef;       /* call reference */
   SiUsr2UsrInd   usr2UsrInd;    /* user to user indicators */
   SiUsr2UsrInfo  usr2UsrInfo;   /* user to user information */
   SiConnectedNum connNum;       /* connected number */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   SiConnectedNum2 connNum2;      /* connected number */
#endif
   SiAccTrnspt    accTrans;      /* access transport */
   SiAccDelInfo   accDelInfo;    /* access delivery information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiNotifInd     notifInd1;     /* notification indicator */
   SiNotifInd     notifIndR1;    /* notification ind (repeated - ITU97/92) */
   SiPropDly      cllHstry;      /* call history information */
   SiGenNum       genNmb;        /* generic number */
   SiGenNum       genNmbR;       /* generic number (repeated - ITU97/92) */
   SiTxMedReq     txMedUsed;     /* transmission medium used */
   SiNetSpecFacil netFac;        /* network specific facility */
/* sit_x_001.main_53 : Removed remotOper1 serviceAct2 for china variant */
   SiRemotOper    remotOper;     /* remote operations */
   SiServiceAct   serviceAct;    /* service activation */
   SiCdPtyNum      redirNum;     /* redirection number */
   SiRedirRestr   redirRstr;     /* redirection restriction */
   SiEchoCtl       echoControl;  /* echo control */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp  businessGrp;   /* business group */
   SiInfoInd      infoInd;       /* information indicators */
#endif
/* sit_x_001.main_53 : Added flag for BELL */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL) 
   SiNetTransport netTransport;  /* network transport */
   SiNotifInd     notifInd;      /* notification indicator */
   SiNotifInd     notifIndR;     /* notification ind (repeated - ANSI 95) */
#endif
#if SS7_Q767IT
   SiBackVadInd   backVad;       /* backward vad indicators */
#endif
#if SS7_SINGTEL
   SiCgPtyNum     cgPtyNum;      /* calling party number */
#endif
#if SS7_FTZ
   SiNaPaFF       naPaFF;        /* national parameter */
   SiNaPaSPV      naPaSpv;       /* national parameter for SPV */
#endif
#if SS7_NTT
   SiMsgAreaInfo  msgAreaInfo;   /* Message Area Information */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiDisplayInfo  displayInfo;   /* display information */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_UK || SS7_NZL || \
      SS7_KZ || SS7_UR)
   SiBackGVNS     backGVNS;      /* backward GVNS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_UK || SS7_KZ || SS7_UR)
   SiConfTrtInd  confTrtInd;     /* conference treatment indicators */
   SiPivotRtgBkInfo pivotRtgBkInfo;  /*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
#endif
#ifdef SS7_UK
   SiCdBasicSrvcMarks  cdBasicSrvcMrk;	/* Called Subscriber's Basic Service Marks */
#endif /* SS7_UK */
   SiEndOp        endOp;       /* end of optional parameters */
} SiPduANM;
  
typedef struct siPduCMC          /* Call Modification Complete */
{
   SiCalModInd    caModInd;      /* call modification indicators */
#if SS7_ANS88
   SiCallRefA     callRefA;      /* call reference */
#endif
   SiCallRef      callRef;       /* call reference */
   SiUsr2UsrInfo  usr2UsrInfo;   /* user to user information */
   SiEndOp        endOp;         /* end of optional parameters */
} SiPduCMC;
  
typedef struct siPduCMR          /* Call Modification Request */
{
   SiCalModInd   caModInd;       /* call modification indicators */
#if SS7_ANS88
   SiCallRefA    callRefA;       /* call reference */
#endif
   SiCallRef     callRef;        /* call reference */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduCMR;
  
typedef struct siPduCMRJ         /* Call Modification Rejected */
{
   SiCalModInd   caModInd;       /* call modification indicators */
#if SS7_ANS88
   SiCallRefA    callRefA;       /* call reference */
#endif
   SiCallRef     callRef;        /* call reference */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduCMRJ;
  
typedef struct siPduCPG          /* Call Progress */
{
   SiEvntInfo      evntInfo;     /* event information */
   SiCauseDgn      causeDgn;     /* cause indicators */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA      callRefA;     /* call reference */
#endif
   SiCallRef       callRef;      /* call reference */
   SiBckCalInd     bckCalInd;    /* backward call indicators */
   SiOptBckCalInd  optBckCalInd; /* optional backward call indicators */
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_BRZL) 
   SiOptBckCalIndQ optBckCalIndQ;/* Q767 and Russia optional backward */
                                 /* call indicators */
#endif  
   SiAccTrnspt     accTrans;     /* access transport */
   SiUsr2UsrInd    usr2UsrInd;   /* user to user indicators */
   SiUsr2UsrInfo   usr2UsrInfo;  /* user to user information */
   SiNotifInd      notifInd1;    /* notification indicator */
   SiNotifInd      notifIndR1;   /* notification ind (repeated - ITU97/92) */
   SiTxMedReq      txMedUsed;    /* transmission medium used */
   SiAccDelInfo    accDelInfo;   /* access delivery information */
   SiCdPtyNum      redirNum;     /* redirection number */
   SiParmCompInfo  parmCom;      /* parameter compatibility information */
   SiCllDiverInfo  cllDivr;      /* call Diversion information */
   SiNetSpecFacil  netFac;       /* network specific facility */
/* sit_x_001.main_53 : Removed remotOper1 serviceAct2 for china variant */
   SiRemotOper     remotOper;    /* remote operations */
   SiServiceAct    serviceAct;   /* service activation */
   SiRedirRestr    redirRstr;    /* redirection restriction */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp   businessGrp;  /* business group */
/* sit_x_001.main_53 : Added call reference to match with si_db.c */
   SiCallRefA      callRef1;     /* Call Reference */
   SiInfoInd       infoInd;      /* information indicators */
   SiNetTransport  netTransport; /* network transport */
   SiNotifInd      notifInd;     /* notification indicator */
   SiNotifInd      notifIndR;    /* notification ind (repeated - ANSI 95) */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || \
     SS7_UR)
   SiCgPtyNum      calTrnsNmb;   /* Call Transfer Number */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiBackGVNS     backGVNS;      /* backward GVNS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiEchoCtl       echoControl;  /* echo control */
   SiConnectedNum connNum;       /* connected number */
   SiGenNum       genNmb;        /* generic number */
   SiGenNum       genNmbR;      /* generic number (repeated - ITU97/92) */
   SiPropDly      cllHstry;      /* call history information */
   SiConfTrtInd    confTrtInd;   /* confrence treatment indicators */
   SiUidActionInd  uidActionInd; /* UID action indicator */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_UK || SS7_KZ || SS7_UR)
   SiCCNRPosInd  ccnrPosInd;     /* CCNR Possible indicator */
   SiPivotRtgBkInfo pivotRtgBkInfo;  /*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
 #endif
 #ifdef SS7_UK
    SiCdBasicSrvcMarks  cdBasicSrvcMrk; /* Called Subscriber's Basic Servicve Marks */
 #endif /* SS7_UK */
   SiEndOp         endOp;       /* end of optional parameters */
} SiPduCPG;
  
typedef struct siPduCGB          /* Circuit Group Blocking */
{
   SiCirGrpSupMTypInd cgsmti;    /* circuit grp. Supervision Msg. Type Ind. */
   SiRangStat         rangStat;  /* range and status */
} SiPduCGB;
  
typedef struct siPduCGBA         /* Circuit Group Blocking Ack. */
{
   SiCirGrpSupMTypInd cgsmti;    /* circuit grp. Supervision Msg. Type Ind. */
   SiRangStat         rangStat;  /* range and status */
} SiPduCGBA;
  
typedef struct siPduCQM          /* Circuit Group Query */
{
   SiRangNoStat rangStat;        /* range and status */
#if (SS7_NTT || SS7_ANS95)
   SiEndOp endOp;                /* end of optional parameters */
#endif
} SiPduCQM;
  
typedef struct siPduCQR          /* Circuit Group Query Response */
{
   SiRangStat    rangStat;       /* range and status */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiCirStateInd cirSteIndA;     /* Circuit State Indicators */
#endif
   SiCirStateInd cirSteInd;      /* Circuit State Indicators */
} SiPduCQR;
  
typedef struct siPduGRS          /* Circuit Group Reset */
{
   SiRangStat   rangStat;        /* range and status */
#if SS7_ANS95
   SiCirAsgnMap cirAsgnMap;      /* circuit assignment map */
#endif
#if (SS7_NTT || SS7_ANS95)
   SiEndOp      endOp;                /* end of optional parameters */
#endif
} SiPduGRS;
  
typedef struct siPduGRA          /* Circuit Group Reset Acknowledgement */
{
   SiRangStat rangStat;          /* range and status */
#if SS7_ANS95
   SiCirAsgnMap cirAsgnMap;      /* circuit assignment map */
#endif
#if SS7_ANS95
   SiEndOp      endOp;                /* end of optional parameters */
#endif
} SiPduGRA;
  
typedef struct siPduCGU          /* Circuit Group Unblocking */
{
   SiCirGrpSupMTypInd cgsmti;    /* circuit grp. supervision msg. type ind. */
   SiRangStat         rangStat;  /* range and status */
} SiPduCGU;
  
typedef struct siPduCGUA         /* Circuit Group Unblocking Acknowledgement */
{
   SiCirGrpSupMTypInd cgsmti;    /* circuit grp. supervision msg. type ind. */
   SiRangStat         rangStat;  /* range and status */
} SiPduCGUA;
  
typedef struct siPduCRM          /* Circuit Reservation Message*/
{
   SiNatConInd natConInd;        /* Nature of Connection indicators */
} SiPduCRM;

typedef struct siPduCSVR         /* Closed User Group Selection and Validation
                                    Request */
{
#if SS7_ANS88
   SiCdPtyNum cdPtyNum;          /* called party number */
   SiCgPtyNum cgPtyNum1;         /* calling party number */
   SiIndex    index;             /* index */
   SiCallRefA callRefA;          /* call reference */
#endif
   SiEndOp    endOp;             /* end of optional parameters */
} SiPduCSVR;

typedef struct siPduCSVS         /* Closed User Group Selection and Validation
                                    Response */
{
#if SS7_ANS88
   SiCugChkRspInd cugInd;        /* cug check response indicator */
   SiCdPtyNum     cdPtyNum;      /* called party number */
   SiCgPtyNum     cgPtyNum;      /* calling party number */
   SiIndex        index;         /* index */
   SiCugIntCodeA  cugIntCodeA;   /* closed group interlock code */
   SiCallRefA     callRefA;      /* call reference */
#endif
   SiEndOp        endOp;         /* end of optional parameters */
} SiPduCSVS;

typedef struct siPduCVR          /* Circuit validation response */
{
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiCirValRspInd  valRspInd;    /* circuit validation response indicator */
   SiCirGrpCharInd grpCharInd;   /* circuit group characteristic indicators */
   SiCLLI          clli;         /* common language location identification */
   SiCirIdName     cirIdName;    /* circuit id name */
#endif
   SiEndOp         endOp;        /* end of optional parameters */
} SiPduCVR;

typedef struct siPduCFN          /* Confusion */
{
   SiCauseDgn causeDgn;          /* cause indicators */
   SiEndOp    endOp;             /* end of optional parameters */
} SiPduCFN;
  
typedef struct siPduCON          /* Connect */
{
   SiBckCalInd    bckCalInd;     /* backward call indicators */
   SiOptBckCalInd optBckCalInd;  /* optional backward call indicators */
   SiConnectedNum connNum;       /* connected number */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   SiConnectedNum2 connNum2;      /* connected number */
#endif
#if (SS7_CHINA)
   SiCallRefA      callRefA;     /* call reference */
#endif   
   SiCallRef      callRef;       /* call reference */
   SiUsr2UsrInd   usr2UsrInd;    /* user to user indicators */
   SiUsr2UsrInfo  usr2UsrInfo;   /* user to user information */
   SiAccTrnspt    accTrans;      /* access transport */
   SiNotifInd     notifInd;      /* notification indicator */
   SiNotifInd     notifIndR;    /* notification ind (repeated - ITU97/92) */
   SiPropDly      cllHstry;      /* call history information */
   SiGenNum       genNmb;        /* generic number */
   SiGenNum       genNmbR;      /* generic number (repeated - ITU97/92) */
   SiTxMedReq     txMedUsed;     /* transmission medium used */
   SiEchoCtl      echoControl;   /* echo control */
   SiAccDelInfo   accDelInfo;    /* access delivery information */
   SiCdPtyNum      redirNum;     /* redirection number */
   SiNetSpecFacil netFac;        /* network specific facility */
/* sit_x_001.main_53 : Removed remotOper1 serviceAct2 for china variant */
   SiRemotOper    remotOper;     /* remote operations */
   SiServiceAct   serviceAct;    /* service activation */
   SiRedirRestr   redirRstr;     /* redirection restriction */
   SiParmCompInfo  parmCom;      /* parameter compatibility information */
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiBackGVNS     backGVNS;      /* backward GVNS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiConfTrtInd    confTrtInd;   /* confrence treatment indicators */
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ || SS7_UR)
   SiChargeNum htrInfo;          /* HTR Information */
   SiPivotRtgBkInfo pivotRtgBkInfo;  /*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
#endif
 #ifdef SS7_UK
    SiCdBasicSrvcMarks  cdBasicSrvcMrk; /* Called Subscriber's Basic Servicve Marks */
 #endif /* SS7_UK */
   SiEndOp        endOp;        /* end of optional parameters */
} SiPduCON;
typedef struct siPduCOT          /* Continuity */
{
   SiContInd contInd;            /* continuity indicator */
} SiPduCOT;

/* sit_x_001.main_53 : Deleted unused "siPduDRS" Delayed Release */
typedef struct siPduDRS          /* Delayed Release */
{
#if SS7_ANS88
   SiCauseDgn causeDgn;          /* cause indicator */
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
#if SS7_ANS88
   SiUsr2UsrInfo usr2UsrInfo;        /* user to user information */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduDRS;

typedef struct siPduEXM          /* Exit */
{
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiOutgTrkGrpNum grpNum;       /* outgoing trunk group number */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduEXM;
  
typedef struct siPduFAA          /* Facility Accepted */
{
   SiFacInd       facInd;        /* facility indicator */
#if SS7_ANS88
   SiCdPtyNum     cdPtyNum;      /* called party number */
   SiCgPtyNum     cgPtyNum;      /* calling party number */
#endif
#if (SS7_ANS88 || SS7_CHINA)
   SiCallRefA     callRefA;      /* call reference */
#endif
   SiUsr2UsrInd   usr2UsrInd;    /* user to user indicator */
#if (SS7_CHINA)
   SiConnReqA      connReqA;     /* connection request */
#endif /* if SS7_CHINA */
   SiCallRef      callRef;       /* call reference */
   SiConnReq      connReq;       /* connection request */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
#ifdef SS7_FTZ
   SiNaPaFF       naPaFF;        /* national parameter */
#endif
   SiEndOp        endOp;         /* end of optional parameters */
} SiPduFAA;
  
typedef struct siPduFAD          /* Facility Deactivated */
{
#if SS7_ANS88
   SiFacInd   facInd;            /* facility indicator */
   SiCdPtyNum cdPtyNum;          /* called party number */
   SiCgPtyNum cgPtyNum;          /* calling party number */
   SiCallRefA callRefA;          /* call reference */
#endif
   SiEndOp    endOp;             /* end of optional parameters */
} SiPduFAD;
  
typedef struct siPduFAI          /* Facility Information */
{
#if SS7_ANS88
   SiFacInd    facInd;           /* facility indicator */
   SiFacInfInd facInfInd;        /* facility information indicator */
   SiCdPtyNum  cdPtyNum;         /* called party number */
   SiCgPtyNum  cgPtyNum;         /* calling party number */
   SiCallRefA  callRefA;         /* call reference */
#endif
   SiEndOp     endOp;            /* end of optional parameters */
} SiPduFAI;
  
typedef struct siPduFRJ          /* Facility Rejected */
{
   SiFacInd     facInd;          /* facility indicator */
   SiCauseDgn   causeDgn;        /* cause indicator */
#if SS7_ANS88
   SiCdPtyNum   cdPtyNum;        /* called party number */
   SiCgPtyNum   cgPtyNum;        /* calling party number */
   SiCallRefA   callRefA;        /* call reference */
#endif
   SiUsr2UsrInd usr2UsrInd;      /* user to user indicator */
   SiCallRef    callRef;         /* call reference */
#if SS7_FTZ
   SiNaPaFF     naPaFF;          /* national parameter */
#endif
   SiEndOp      endOp;           /* end of optional parameters */
} SiPduFRJ;
  
typedef struct siPduFAR          /* Facility Request */
{
   SiFacInd       facInd;        /* facility indicator */
#if SS7_ANS88
   SiCdPtyNum     cdPtyNum;      /* called party number */
   SiCgPtyNum     cgPtyNum;      /* calling party number */
#endif
#if (SS7_ANS88 || SS7_CHINA)
   SiCallRefA     callRefA;      /* call reference */
#endif
   SiUsr2UsrInd   usr2UsrInd;    /* user to user indicator */
#if SS7_CHINA
   SiConnReqA      connReqA;     /* connection request */
#endif /* if SS7_CHINA */
   SiCallRef      callRef;       /* call reference */
   SiConnReq      connReq;       /* connection request */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
#ifdef SS7_FTZ
   SiNaPaFF       naPaFF;        /* national parameter */
#endif
   SiEndOp        endOp;         /* end of optional parameters */
} SiPduFAR;
  
typedef struct siPduFOT          /* Forward Transfer */
{
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef  callRef;           /* call reference */
   SiEndOp    endOp;             /* end of optional parameters */
} SiPduFOT;

typedef struct siPduINF          /* Information */
{
   SiInfoInd      infoInd;       /* information indicators */
#if SS7_ANS88
   SiInfoIndA     infoIndA;      /* information indicators */
#endif
/* sit_x_001.main_64 : Added for ukraine */
#ifdef SS7_UR
   SiInfoIndU      infoIndU;     /* information indicators for Ukraine*/
#endif
/* sit_x_001.main_62: Removed duplication of parameters */
   SiCgPtyCat     cgPtyCat;      /* calling party category */
   SiCgPtyNum     cgPtyNum;      /* calling party number */
#if SS7_ANS88
   SiConnectedNum connNum;       /* connected number */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiChargeNum    chargeNum;     /* connected number */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA     callRefA;      /* call reference */
   SiConnReqA     connReqA;      /* connection request */
#endif
#if (SS7_ANS88 || SS7_ANS95)
   SiUsr2UsrInfo  usr2UsrInfo;   /* user to user information */
#endif
#if SS7_ANS88
   SiIndex        index;         /* index */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiRedirNum     redirgNum;     /* redirecting number */
#endif
   SiCallRef      callRef;       /* call reference */

   /* sit_x_001.main_63: deleted connReqUK to sync with db */
   SiConnReq      connReq;       /* connection request */
   SiAccTrnspt    accTrans;      /* access transport */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiNetSpecFacil netFac;        /* network specific facility */
#if SS7_ANS88
   SiRedirInfo    redirInfo;     /* redirection information */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiOrigLineInf  origLineInf;   /* originating line information */
#endif
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp  businessGrp;   /* business group */
   SiRedirInfo    redirInf;      /* redirection information */
#endif
#ifdef SS7_UK
   SiNatInfoInd  natInfInd;	/* National Information Indicators */
   SiCgBasicSrvcMarks  cgBascSrvcMrk;	/* Calling Subscriber's Basic Service Marks */
   SiCdBasicSrvcMarks  cdBascSrvcMrk;	/* Called Subscriber's Basic Service Marks */
   SiCgOrigFacMarks  cgOrigFacMrk;		/* Calling Subscriber's Origination Facility Marks */
   SiCdTermFacMarks  cdTermFacMrk;	/* Called Subscriber's Terminating Facility Marks */
   SiGenNum  genNum;	 /* Generic Number(with Number qualifier set as 'intercepted line identity') */
#endif /* SS7_UK */
   SiEndOp        endOp;         /* end of optional parameters */
} SiPduINF;
  
typedef struct siPduINR          /* Information Request */
{
   SiInfoReqInd infoReqInd;      /* information request indicators */
#if SS7_ANS88
   SiInfoReqIndA infoReqIndA;    /* information request indicators */
#endif
/* sit_x_001.main_64 : Added for ukraine */
#ifdef SS7_UR
   SiInfoReqIndU infoReqIndU;    /* information request indicators */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiConnReqA connReqA;          /* connection request */
#endif
   SiCallRef callRef;            /* call reference */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiNetSpecFacil netFac;        /* network specific facility */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiNetTransport netTransport;  /* network transport */
#endif
#ifdef SS7_UK
   SiNatInfoReqInd  natInfReqInd;	/* National Information Request Indicators */
#endif /* SS7_UK */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduINR;
  
typedef struct siPduIAM          /* Initial Address */
{
   SiNatConInd natConInd;        /* Nature of connection indicators */
   SiFwdCallInd fwdCallInd;      /* forward call indicators */
   SiCgPtyCat cgPtyCat;          /* calling party category */
   SiTxMedReq txMedReq;          /* transmission medium requirement */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiUsrServInfo usrServInfoA;   /* user service info */
#endif
   SiCdPtyNum cdPtyNum;          /* called party number */
#if TNS_ANSI
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiTranNetSel1 tranNetSel1;   /* transit network selection */
#endif	 	 
#endif	 	 
   SiTranNetSel tranNetSel;      /* transit network selection */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
   SiCgPtyNum cgPtyNum;          /* calling party number */
#if SS7_BELL
   SiCgPtyNum1 cgPtyNumB;        /* calling party number for Bell*/
#endif
   SiOpFwdCalInd opFwdCalInd;    /* optional forward call indicators */
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
   SiOpFwdCalIndQ opFwdCalIndQ;  /* optional forward call indicators */
#endif
#if SS7_Q767IT
   SiFwdVadInd fwdVad;           /* forward vad indicators */
#endif
#if SS7_ANS88
   SiOpFwdCalIndA opFwdCalIndA;  /* optional forward call indicators */
#endif
   SiRedirNum redirgNum;         /* redirecting number */
   SiRedirInfo redirInfo;        /* redirection information */
   SiCugIntCode cugIntCode;      /* closed group interlock code */
#if SS7_ANS88
   SiCugIntCodeA cugIntCodeA;    /* closed group interlock code */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiConnReqA connReqA;          /* connection request */
#endif
#if SS7_ANS88
   SiUsr2UsrInfo usr2UsrInfoA;   /* user to user information */
#endif
   SiConnReq connReq;            /* connection request */
   SiOrigCdNum origCdNum;        /* original called number */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiAccTrnspt accTrans;         /* access transport */
#if SS7_ANS88
   SiRedirInfo redirInfoA;       /* redirection information */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiChargeNum chargeNum;        /* connected number */
   SiOrigLineInf origLineInf;    /* originating line information */
#endif
   SiUsrServInfo usrServInfo;    /* user service info */
   SiUsr2UsrInd usr2UsrInd;      /* user to user indicators */
   SiPropDly propDly;            /* propagation delay counter */
   SiUsrServInfo usrServInfo1;   /* user service info prime */
   SiNetSpecFacil netFac;        /* network specific facility */
#if SS7_CHINA
   SiSigPointCodeA orgPteCdeA;    /* originating ISC point code */
#endif /* if SS7_CHINA */   
   SiSigPointCode orgPteCde;     /* originating ISC point code */
   SiGenDigits genDigits;        /* generic digits */
   SiGenDigits genDigitsR;       /* generic digits (repeated -ANSI95,ITU97/92) */
   SiGenNum genNmb;              /* generic number */
   SiGenNum genNmbR;             /* generic number (repeated - ITU97/92) */
   SiNotifInd notifInd;          /* notification indicator */
   SiNotifInd notifIndR;         /* notification ind (repeated - ITU97/92) */
   SiUsrTSrvInfo usrTSrvInfo;    /* user tele service info */
/* sit_x_001.main_53 : Removed remotOper1 for china variant */
   SiRemotOper remotOper;        /* remote operations */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
#if (SS7_ANS92 || SS7_ANS95)
   SiServiceCode servCode;       /* service code */
#endif
#if SS7_ANS92
   SiServiceAct serviceAct1;     /* service activation */
#endif
#if SS7_CHINA
   SiServiceAct serviceAct2;     /* service activation */
#endif
   SiServiceAct serviceAct;      /* service activation */
   SiMlppPrec mlppPrec;          /* MLPP precedence */
   SiTxMedReq txMedUsPr;         /* transmission medium used */
   SiCgPtyNum cgPtyNum1;         /* Location Number */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp businessGrp;    /* business group */
   SiCarrierId carrierId;        /* carrier identification */
   SiCarrierSelInf carSelInf;    /* carrier selection information */
   SiEgress egress;              /* ergress service */
   SiGenAddr genAddr;            /* generic address */
   SiGenAddr genAddrR;          /* generic address (repeated - ANSI 95) */
   SiInfoReqInd infoReqInd;      /* information request indicators */
   SiJurisInf jurisInf;          /* jurisdiction information */
   SiNetTransport netTransport;  /* network transport */
   SiSpecProcReq specProcReq;    /* special processing request */
   SiTransReq transReq;          /* transaction request */
#endif
#if (SS7_BELL || SS7_ANS95)
   SiGenName       genName;      /* generic name */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_BELL || SS7_ANS95 || SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiHopCounter hopCounter;      /* hop counter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_BELL || SS7_ITU2000 || SS7_KZ || SS7_UR)
   SiRedirCap redirCap;          /* Redirect capability */
   SiRedirCntr redirCntr;        /* Redirect counter */
#endif
#if (SS7_ETSI || SS7_FTZ)
   SiCcbsParam ccbsParam;        /* CCBS parameter */
   SiFreePhInd freePhParam;      /* Freephone Indicators */
#endif
#if SS7_FTZ
   SiNaPaFF naPaFF;              /* national parameter FF */
   SiNaPaFE naPaFE;              /* national parameter FE */
   SiNaPaSSP naPaSSP;            /* national parameter for SSP */
   SiNaPaCdPNO naPaCdPNO;        /* national parameter for CdPNO */
   SiNaPaSPV naPaSPV;            /* national parameter for SPV */
   SiNaPaUKK naPaUKK;            /* National Parameter for UKK */
#endif
#if SS7_NTT
   SiMsgAreaInfo msgAreaInfo;       /* Message Area Information */
   SiSubsNumber  subsNumber;        /* Subscriber Number */
   SiReasProhibCllngNo  rpCllngNo;  /* Reason for prohibiting calling no */
   SiSupplUserType   supplUserType; /* Supplementary user type */
   SiCarrierInfoTrans   carrierInfoTrans;   /* Carrier Info Transfer */ 
   SiNwFuncType      nwFuncType;    /*  Network function type */
#endif
#if SS7_ANS95
   SiOptrServicesInfo optrServicesInfo; /* Operator services info */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ANS95 || SS7_ITU97  || SS7_RUSS2000|| SS7_ITU2000 || \
      SS7_NZL || SS7_KZ || SS7_UR)
   SiCirAsgnMap cirAsgnMap;      /* circuit assignment map */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiDisplayInfo  displayInfo;   /* display information */
   SiConfTrtInd confTrtInd;      /* confrence treatment indicators */
   SiNetMgmtControls netMgmtControls;  /* network management controls */
   SiCorrelationId correlationId;/* correlation Id */
   SiCallDivTrtInd callDivTrtInd;/* call diversion treatment indicators */
   SiCallInNmb  callInNmb;       /* call IN number */
   SiCallOfferTrtInd callOfferTrtInd;/* call offering treatment ind */
   SiScfId      scfId;           /* SCF Id */
   SiUidCapInd  uidCapInd;       /* UID capability indicator */
   SiEchoCtl       echoControl;  /* echo control */
   SiCollCallReq collCallReq;    /* collect call request */
   SiCcss         ccss;          /* CCSS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_UK || SS7_NZL || \
      SS7_KZ || SS7_UR)
   SiBackGVNS     backGVNS;      /* backward GVNS */
   SiForwardGVNS  forwardGVNS;   /* forward GVNS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiPivotCap pivotCap;             /* Pivot Capability */   
   SiCdPtyNum cadDirNmb;            /* Called Directory Number */
   SiOrigCdNum origCallInNum;       /* Original Called IN Number */
   SiCalgGeoLoc calgGeoLoc;         /* Calling geodetic location */
   SiNetRoutNum netRoutNum;         /* Network Routing Number */
   SiQOnRelCap qonRelCap;           /* Query on Release Capability */
   SiPivotCntr pivotCntr;           /* Pivot Counter */
   SiPivotRtgBkInfo pivotRtgFwInfo; /* Pivot Routing Forward Info*/
   SiRedirStat redirStat;           /* Redirect Status */
   SiPivotRtgBkInfo redirFwInfo;    /* Redirect Forward Info */
   SiNumPortFwdInfo numPortFwdInfo; /* Number Portability Forward Info */
#endif
#ifdef SS7_UK
   SiNatFwdCalInd natFwdCalInd;	/* National Forward Call Indicator */
   SiPresentNum  presntNum;		/* Presentation Number */
   SiLstDvrtLineID  lstDvrtLineId;	/* Last Diverting Line ID */
   SiPartialCgLineId  pcgLineId;		/* Partial Calling Line ID */
   SiNatFwdCalIndLnk  natFwdCalIndLnk;	/* national Forward Call Indicator (Link by Link) */
#endif /* SS7_UK */
   SiEndOp endOp;               /* end of optional parameters */
} SiPduIAM;
  
typedef struct siPduPAM          /* Pass Along */
{
   SiPassAlng passAlng;          /* pass along */
} SiPduPAM;
  
typedef struct siPduREL          /* Release */
{
   SiCauseDgn causeDgn;          /* cause indicators */
#if SS7_ANS88
   SiRedirInfo redirInfoA;       /* redirection information */
#endif
/* sit_x_001.main_54: Added TDS_ROLL_UPGRADE_SUPPORT flag */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#if SS7_BELL
   SiChargeNum redirgNumB;         /* redirection number for Bell */
#endif
#endif
   SiRedirInfo redirInfo;        /* redirection information */
   SiCdPtyNum      redirNum;     /* redirection number */
#if SS7_ANS88
   SiRedirNum redirgNum;         /* redirection number */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiCallRefA callRefA;          /* call reference */
#endif
#if (SS7_ANS88 || SS7_CHINA)
   SiSigPointCodeA sigPointCodeA;/* Signalling point code */
#endif /* if SS7_CHINA */
#if SS7_ANS88
   SiCugIntCodeA cugIntCodeA;    /* closed group interlock code */
#endif
   SiSigPointCode sigPointCode;  /* Signalling point code */
   SiAccTrnspt accTrans;         /* access transport */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiAutoCongLvl auCongLvl;      /* automatic congestion level */
   SiAccDelInfo accDelInfo;      /* access delivery information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiNetSpecFacil netFac;        /* network specific facility */
   SiRedirRestr redirRstr;       /* redirection restriction */
   SiUsr2UsrInd usr2UsrInd;      /* user to user indicators */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiChargeNum chargeNum;        /* charge number */
   SiGenAddr genAddr;            /* generic address */
   SiGenAddr genAddrR;            /* generic address (repeated - ANSI 95) */
#endif
#if SS7_Q767IT
   SiBackVadInd backVad;         /* backward vad indicators */
#endif
#if SS7_SINGTEL
   TrnkOff trnkOff;              /* trunk offering information */
#endif
#if SS7_NTT
   SiCdPtyNum cdPtyNum;          /* called party number */
#endif
#if (SS7_NTT || SS7_ANS95)
   SiServiceAct    serviceAct;   /* service activation */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_NZL || SS7_KZ || SS7_UR)
   SiDisplayInfo  displayInfo;   /* display information */
   SiRemotOper     remotOper;    /* remote operations */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ || SS7_UR)
   SiChargeNum htrInfo;          /* HTR Information */
   SiRedirCntr redirCntr;        /* Redirect counter */
   SiPivotRtgBkInfo redirBkInfo; /* Redirect Backward Info */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduREL;
  
typedef struct siPduRLC          /* Release Complete */
{
   SiCauseDgn causeDgn;          /* cause indicators */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduRLC;
  
typedef struct siPduRES          /* Resume */
{
   SiSusResInd suspResInd;       /* Suspend/Resume indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduRES;
  
typedef struct siPduSAM          /* Subsequent Address */
{
   SiSubNum subNum;              /* subsequent number */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduSAM;

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_UK || SS7_KZ || SS7_UR)
typedef struct siPduSDN          /* Subsequent directory number */
{
   SiSubNum subNum;              /* subsequent number */
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduSDN;
#endif  

/* sit_x_001.main_64: Added for CCL message */ 
typedef struct siPduCCL          /* Ringing Send Message */
{
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduCCL;

typedef struct siPduSUS          /* Suspend */
{
   SiSusResInd suspResInd;       /* Suspend/Resume indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduSUS;
  
typedef struct siPduUSR          /* User to User */
{
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiAccTrnspt accTrans;         /* access transport */
#if SS7_CHINA
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduUSR;
  
typedef struct siPduFAC           /* Facility  Message */
{
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   /* sit_x_001.main_58 : Deleted RemotOper1 and ServiceAct2 as not required at
   present for CHINA variant */
   SiRemotOper remotOper;        /* remote operations */
   SiServiceAct serviceAct;      /* service activation */
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_NZL || \
      SS7_KZ || SS7_UR)
   SiCgPtyNum calTrnsNmb;        /* Call Transfer Number */
   SiAccTrnspt accTrans;         /* access transport */
   SiNotifInd notifInd;          /* notification indicator */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ || SS7_UR)
   SiCdPtyNum redirNum;          /* redirection number */
   SiPivotRtgInd pivotRtgInd;    /* Pivot Routing Indicators */   
   SiPivotStat pivotStat;        /* Pivot Status */
   SiPivotCntr pivotCntr;        /* Pivot Counter */
   SiPivotRtgBkInfo pivotRtgBkInfo;/*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduFAC;
  
typedef struct siPduUPAT         /* User Part Test/Available  */
{
   SiParmCompInfo parmCom;       /* parameter compatibility information */
#if SS7_ETSI 
   SiMsgCompInfo  msgCom;        /* message compatibility information */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduUPAT;

typedef struct siPduNRM          /* Network Resource Mgt  */
{
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiTxMedReq txMedUsed;         /* transmission medium used */
   SiEchoCtl echoControl;        /* echo control */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduNRM;

typedef struct siPduIDR          /* Identification Request  */
{
   SiMcidReqInd mcidReq;         /* MCID request indicators */
   SiTxMedReq txMedUsed;         /* transmission medium used */
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduIDR;

typedef struct siPduIRS          /* Identification Response  */
{
   SiMcidRspInd mcidRsp;         /* MCID response indicators */
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiCgPtyNum cgPtyNum;          /* calling party number */
   SiAccTrnspt accTrans;         /* access transport */
   SiGenNum genNmb;              /* generic number */
   SiGenNum       genNmbR;        /* generic number (repeated - ITU97/92) */
#if SS7_FTZ
   SiNaPaExTID naPaExTID;        /* national parameter for ExTID */
#endif 
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_ETSIV3 || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiNaPaChgPID naPaChgPID;      /* National Parameter for charged party ID*/
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduIRS;

typedef struct siPduCRG          /* Charge Information  */
{
#if SS7_SINGTEL
   SiCllChrgeInfo chrgeInfo;       /* call charge info */
   SiChrgeRateInfo rateInfo;       /* charge rate information */
#endif
/* sit_x_001.main_54: Modified to add control flag for ISUP Kazakhstan
   billZoneNum also represent tariff zone number */
#if (SS7_RUSSIA)
   SiBillZoneNum billZoneNum;    /* Billing Zone Number */
#endif
#if (SS7_KZ)
   SiTariffZoneNum tariffZoneNum;  /* Tariff Zone Number */
#endif
#ifdef SS7_INDIA
   SiChargeBand chrgeBnd;        /* charge band parameter */
   SiMsgCompInfo msgComp;        /* message compatibility information */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduCRG;

typedef struct siPduTCM          /* Tariff Change Message  */
{
#if SS7_SINGTEL
   SiChrgeRateInfo rateInfo;       /* charge rate information */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduTCM;

#if SS7_NTT
typedef struct siPduCHGNTT       /* Charge message for NTT */
{
   SiChrgInfoType       chrgInfoType;       /* Charge information type */
   SiChrgInfo           chrgInfo;           /* Charge information */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduCHGNTT;
#endif

typedef struct siPduLOP          /* loop prevention mesg. */
{
   SiLoopPrvntInd loopPrvntInd;  /* loop prevention indicator */
   SiCallTRef calTrnsfrRef;      /* Call Transfer reference */
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility info */
   SiEndOp endOp;                /* end of optional parameters */
} SiPduLOP;

typedef struct siPduCHG          /* Charging Message */
{
#ifdef SS7_FTZ
   SiNaPaFF naPaFF;              /* National Parameter FF */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduCHG;

typedef struct siPduCHGE         /* Charging Extended Message */
{
#ifdef SS7_FTZ
   SiMsgCompInfo msgComp;        /* message compatibility information */
   SiParmCompInfo parmComp;      /* parameter compatibility information */
   SiNaPaCHGI naPaCHGI;          /* National Parameter for charging infor. */
   SiNaPaFF naPaFF;              /* National Parameter FF */
#endif
   SiEndOp endOp;                /* end of optional parameters */
} SiPduCHGE;

typedef struct siPduCHGEA        /* Charging Extended Ack. Msg*/
{
#ifdef SS7_FTZ
   SiMsgCompInfo  msgComp;       /* message compatibility information */
   SiParmCompInfo parmComp;      /* parameter compatibility information */
   SiNaPaCHGI     naPaCHGI;      /* National Parameter for charging infor. */
   SiNaPaFF       naPaFF;        /* National Parameter FF */
#endif
   SiEndOp        endOp;         /* end of optional parameters */
} SiPduCHGEA;


typedef struct siPduEHZA         /*Caller Hangup Ind. Msg. */
{
#ifdef SS7_FTZ
   SiCauseDgn    causeDgn;       /* cause indicators */
   SiMsgCompInfo msgComp;        /* message compatibility information */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
#endif
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduEHZA;

typedef struct siPduFIN          /* Facility Inform. Msg. */
{
#ifdef SS7_FTZ
   SiFacInd      facInd;         /* facility indicator */
   SiFacIndInfor facInfInd;      /* facility information indicator */
   SiNaPaFF      naPaFF;         /* National Parameter FF */
#endif
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduFIN;

#ifdef SS7_FTZ
typedef struct siPduUIN          /* User Information Msg. */
{
   SiNaPaTTZ naPaTTZ;            /* National Parameter for Tln-2-Tln sign. */
} SiPduUIN;
#endif

#ifdef SS7_FTZ
typedef struct siPduNANA         /* National Message Msg. */
{
   SiNaPaFF naPaFF;              /* National Parameter FF */
} SiPduNANA;
#endif

typedef struct siPduSGM          /* segmentation Msg. */
{
   SiAccTrnspt   accTrans;       /* access transport */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiMsgCompInfo msgComp;        /* message compatibility information */
   SiGenDigits   genDigits;      /* generic digits */
   SiGenDigits   genDigitsR;     /* generic digits (repeated - ITU97/92) */
   SiNotifInd    notifInd;       /* notification indicator */
   SiNotifInd    notifIndR;      /* notification ind (repeated - ITU97/92) */
   SiGenNum      genNmb;         /* generic number */
   SiGenNum      genNmbR;        /* generic number (repeated - ITU97/92) */
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduSGM;

typedef struct siPduRNG          /* Ringing Send Message */
{
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduRNG;

/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
typedef struct siPduAPM          /* application transport mesg */
{
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiAppTransParam appTransParam;/* application transport parameter */
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduAPM;   

typedef struct siPduPRI          /* Pre-release information mesg */
{
   SiOptBckCalInd  optBckCalInd; /* optional backward call indicators */
   SiOpFwdCalInd opFwdCalInd;    /* optional forward call indicators */
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiAppTransParam appTransParam;/* application transport parameter */
   SiEndOp       endOp;          /* end of optional parameters */
} SiPduPRI;
#endif

#ifdef SS7_CHINA
typedef struct siPduMPM          /* metering pulse Message */
{
   SiChargeInform  chrgeInform;  /* Charge Information */ 
} SiPduMPM;
#endif /* if SS7_CHINA */

#ifdef SANGOMA_SPIROU
typedef struct siPduCHU          /* Charge Unit */
{
   SiChargUnitNum      chargUnitNum;  /* Chage Unit Number */
   SiMsgNum            msgNum;       /* message  Number */
   SiEndOp				endOp; /* end of optional parameters */
} SiPduCHU;

typedef struct siPduCHA          /* Subsequent Address */
{
   SiEndOp endOp;                /* end of optional parameters */
} SiPduCHA;
#endif /* SANGOMA_SPIROU */

/* All Messages... */
typedef struct siAllPdus         /* All PDU Messages */
{
   union
   {
      SiPduACM   addrComp;       /* Address Complete */
      SiPduANM   answer;         /* Answer */
      SiPduCMC   caModComp;      /* Call Modification Complete */
      SiPduCMR   caModReq;       /* Call Modification Request */
      SiPduCMRJ  caModRej;       /* Call Modification Rejected */
      SiPduCPG   caProg;         /* Call Progress */
      SiPduCFN   confusion;      /* Confusion */
      SiPduCON   connect;        /* Connect */
      SiPduCOT   continuity;     /* Continuity */
      SiPduFAA   facAccept;      /* Facility Accepted */
      SiPduFRJ   facReject;      /* Facility Rejected */
      SiPduFAR   facRequest;     /* Facility Request */
      SiPduFOT   fwdTrans;       /* Forward Transfer */
      SiPduINF   info;           /* Information */
      SiPduINR   infoReq;        /* Information Request */
      SiPduIAM   initAddr;       /* Initial Address */
      SiPduREL   release;        /* Release */
      SiPduRLC   relComplete;    /* Release Complete */
      SiPduRES   resume;         /* Resume */
      SiPduSAM   subAddr;        /* Subsequent Address */
      SiPduSUS   suspend;        /* Suspend */
      SiPduUSR   usr2Usr;        /* User to User */
      SiPduCRM   cirReserve;     /* Circuit Reservation Message*/
      SiPduPAM   passAlng;       /* Pass Along */
      SiPduCQM   cirGrpQry;      /* Circuit Group Query */
      SiPduCQR   cirGrpQryRes;   /* Circuit Group Query Response */
      SiPduCGB   cirGrpBlk;      /* Circuit Group Blocking */
      SiPduCGBA  cirGrpBlkAck;   /* Circuit Group Blocking Ack. */
      SiPduCGU   cirGrpUnblk;    /* Circuit Group Unblocking */
      SiPduCGUA  cirGrpUblkAck;  /* Circuit Group Unblocking Ack. */
      SiPduGRS   cirGrpRes;      /* Circuit Group Reset */
      SiPduGRA   cirGrpResAck;   /* Circuit Group Reset Ack. */
      SiPduFAC   facility;       /* Facility  Message. */
      SiPduIDR   identReq;       /* Identification Request Message. */
      SiPduIRS   identRsp;       /* Identification Response Message. */
      SiPduNRM   netResMgt;      /* Network Resource Management  Message. */
      SiPduUPAT  usrPrtAvTst;    /* User Part Available/Test  Message. */
      SiPduCSVR  cugSelValReq;   /* CUG Selection and Validation Request */
      SiPduCSVS  cugSelValRsp;   /* CUG Selection and Validation Response */
      SiPduCVR   cirValRsp;      /* Circuit Validation Response */
      SiPduEXM   exit;           /* Exit */
      SiPduFAD   facilDeact;     /* Facility Deactivation */
      SiPduFAI   facilInf;       /* Facility Information */
      SiPduCRG   siCharge;       /* Charge Information */
      SiPduTCM   trffChange;     /* Tariff Change Message */
      SiPduLOP   loopPrvnt;      /* Loop Prevention Message */
      SiPduCHG   charging;       /* GT_FTZ Charging Message */
      SiPduCHGE  charngExt;      /* GT_FTZ Charging Extended Message */
      SiPduCHGEA chrgExtAck;     /* GT_FTZ Charging Extended Ack. Message */
      SiPduEHZA  clrHangUpInd;   /* GT_FTZ Caller Hangup Ind. Message */
      SiPduFIN   facilInfor;     /* GT_FTZ facility information */
#if SS7_FTZ
      SiPduUIN   userInform;     /* GT_FTZ user information */
      SiPduNANA  naNa;           /* GT_FTZ national message */
#endif
      SiPduSGM   segment;        /* Simple Segmentation Message */
      SiPduRNG   ringSend;       /* Ringing Send Message */
#if SS7_NTT
      SiPduCHGNTT sipduCHG;      /* Charge message for NTT */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
      SiPduAPM    siPduAPM;      /* application transport mesg */
      SiPduPRI    siPduPRI;      /* Pre-release information mesg */
#endif
#if SS7_CHINA
      SiPduMPM    siPduMPM;      /* metering pulse msg */
#endif /* if SS7_CHINA */      
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
#if (SS7_ITU2000 || SS7_UK || SS7_KZ)
      SiPduSDN   siPduSDN;       /* Subsequent directory number */
#endif
#ifdef SANGOMA_SPIROU
	SiPduCHU   siPduCHU;       /* Charge Unit  */
	SiPduCHA   siPduCHA;       /* Charge Ack  */
#endif /* SANGOMA_SPIROU */
   } m;
} SiAllPdus;
  
typedef struct siConEvnt         /* ISUP Connect Event */
{
   SiNatConInd     natConInd;    /* Nature of connection indicators */
   SiFwdCallInd    fwdCallInd;   /* forward call indicators */
   SiCgPtyCat      cgPtyCat;     /* calling party category */
   SiTxMedReq      txMedReq;     /* transmission medium requirement */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiUsrServInfo   usrServInfoA; /* user service info */
#endif
   SiCdPtyNum      cdPtyNum;     /* called party number */
#if TNS_ANSI
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiTranNetSel1 tranNetSel1;   /* transit network selection */
#endif	 	 
#endif
   SiTranNetSel    tranNetSel;   /* transit network selection */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA      callRefA;     /* call reference */
#endif
   SiCallRef       callRef;      /* call reference */
   SiCgPtyNum      cgPtyNum;     /* calling party number */
#if SS7_BELL
   SiCgPtyNum1      cgPtyNumB;     /* calling party number */
#endif
   SiOpFwdCalInd   opFwdCalInd;  /* optional forward call indicators */
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
   SiOpFwdCalIndQ  opFwdCalIndQ; /* optional forward call indicators */
#endif
#if SS7_Q767IT
   SiFwdVadInd     fwdVad;       /* forward vad indicators */
#endif
#if SS7_ANS88
   SiOpFwdCalIndA opFwdCalIndA;  /* optional forward call indicators */
#endif
   SiRedirNum      redirgNum;    /* redirecting number */
   SiRedirInfo     redirInfo;    /* redirection information */
   SiCugIntCode    cugIntCode;   /* closed group interlock code */
#if SS7_ANS88
   SiCugIntCodeA   cugIntCodeA;  /* closed group interlock code */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiConnReqA      connReqA;     /* connection request */
#endif
#if SS7_ANS88
   SiUsr2UsrInfo   usr2UsrInfoA; /* user to user information */
#endif
   SiConnReq       connReq;      /* connection request */
   SiOrigCdNum     origCdNum;    /* original called number */
   SiUsr2UsrInfo   usr2UsrInfo;  /* user to user information */
   SiAccTrnspt     accTrnspt;    /* access transport */
   SiEchoCtl       echoControl;  /* echo control */
#if SS7_ANS88
   SiRedirInfo     redirInfoA;   /* redirection information */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiChargeNum     chargeNum;    /* connected number */
   SiOrigLineInf   origLineInf;  /* originating line information */
#endif
   SiUsrServInfo   usrServInfo;  /* user service info */
   SiUsr2UsrInd    usr2UsrInd;   /* user to user indicators */
   SiPropDly       propDly;      /* propagation delay counter */
   SiUsrServInfo   usrServInfo1; /* user service info prime */
   SiNetSpecFacil  netFac;       /* network specific facility */
#ifdef SS7_CHINA
   SiSigPointCodeA orgPteCdeA;    /* originating ISC point code */
#endif /* if SS7_CHINA */   
   SiSigPointCode  orgPteCde;    /* originating ISC point code */
   SiGenDigits     genDigits;    /* generic digits */
   SiGenDigits genDigitsR;        /* generic digits (repeated) */

   SiUsrTSrvInfo   usrTSrvInfo;  /* user tele service info */
/* sit_x_001.main_53 : Removed remotOper1 for china variant */
   SiRemotOper     remotOper;    /* remote operations */
   SiParmCompInfo  parmCom;      /* parameter compatibility information */
#if (SS7_ANS92 || SS7_ANS95)
   SiServiceCode   servCode;     /* service code */
#endif
#if SS7_ANS92
   SiServiceAct    serviceAct1;  /* service activation */
#endif
#if SS7_CHINA
   SiServiceAct    serviceAct2;  /* service activation */
#endif   
   SiServiceAct    serviceAct;   /* service activation */
   SiMlppPrec      mlppPrec;     /* MLPP precedence */
   SiTxMedReq      txMedUsPr;    /* transmission medium used */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   SiTxMedReq      txMedUsed;    /* transmission medium used */
#endif
   SiBckCalInd     bckCallInd;   /* backward call indicators */
/* sit_x_001.main_58 : Corrected the comment Location number */
   SiCgPtyNum      cgPtyNum1;    /* Location Number */
   SiOptBckCalInd  optBckCalInd; /* optional backward call indicators */
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
   SiOptBckCalIndQ optBckCalIndQ;/* Q767 and Russia optional backward */
                                 /* call indicators */
#endif  
   SiConnectedNum  connNum;      /* connected number */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   SiConnectedNum2 connNum2;     /* connected number */
#endif
   SiAccDelInfo    accDelInfo;   /* access delivery information */
   SiNotifInd      notifInd;     /* notification indicator */
   SiNotifInd      notifIndR2;    /* notification ind (repeated) */
   SiPropDly       cllHstry;     /* call history information */
   SiGenNum        genNmb;       /* generic number */
   SiGenNum        genNmbR;        /* generic number (repeated - ITU97/92) */
   SiCdPtyNum      redirNum;     /* redirection number */
   SiRedirRestr    redirRstr;    /* redirection restriction */
#if SS7_Q767IT
   SiBackVadInd    backVad;      /* backward vad indicators */
#endif 
#if SS7_SINGTEL
   SiCgPtyNum     cgPtyNumS;      /* calling party number */
#endif
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp   businessGrp;  /* business group */
   SiInfoInd       infoInd;      /* information indicators */
   SiCarrierId     carrierId;    /* carrier identification */
   SiCarrierSelInf carSelInf;    /* carrier selection information */
   SiEgress        egress;       /* egress service */
   SiGenAddr       genAddr;      /* generic address */
   SiGenAddr genAddrR;            /* generic address (repeated) */
   SiInfoReqInd    infoReqInd;   /* information request indicators */
   SiJurisInf      jurisInf;     /* jurisdiction information */
   SiNetTransport  netTransport; /* network transport */
   SiSpecProcReq   specProcReq;  /* special processing request */
   SiTransReq      transReq;     /* transaction request */
#endif
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#if (SS7_ANS92 || SS7_ANS95)
   SiNotifInd      notifInd1;    /* notification indicator */
   SiNotifInd      notifIndR1;    /* notification ind (repeated) */
#endif /* SS7_ANS92 */
#endif /* SIT_PARAMETER || TDS_ROLL_UPGRADE_SUPPORT */
#if (SS7_BELL || SS7_ANS95)
   SiGenName       genName;      /* generic name */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_BELL || SS7_ANS95 || SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR) 
   SiHopCounter hopCounter;      /* hop counter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_BELL || SS7_ITU2000 || SS7_KZ || SS7_UR)
   SiRedirCap redirCap;          /* Redirect capability */
   SiRedirCntr redirCntr;        /* Redirect counter */
#endif
#if (SS7_ETSI || SS7_FTZ)
   SiCcbsParam     ccbsParam;    /* CCBS parameter */
   SiFreePhInd     freePhParam;  /* Freephone Indicators */
#endif
#ifdef SS7_FTZ
   SiNaPaFF        naPaFF;       /* National Parameter FF */
   SiNaPaFE        naPaFE;       /* National Parameter FE */
   SiNaPaSSP       naPaSSP;      /* National Parameter for SSP */
   SiNaPaCdPNO     naPaCdPNO;    /* National Parameter for called pty nmb */
   SiNaPaSPV       naPaSPV;      /* National Parameter for SPV */
   SiNaPaUKK       naPaUKK;      /* National Parameter for UKK */
#endif
#if SS7_NTT
   SiMsgAreaInfo  msgAreaInfo;   /* Message Area Information */
   SiSubsNumber  subsNumber;        /* Subscriber Number */
   SiReasProhibCllngNo  rpCllngNo;  /* Reason for prohibiting calling no */
   SiSupplUserType   supplUserType; /* Supplementary user type */
   SiCarrierInfoTrans   carrierInfoTrans;   /* Carrier Info Transfer */ 
   SiNwFuncType      nwFuncType;    /*  Network function type */
#endif
#if SS7_ANS95
   SiOptrServicesInfo optrServicesInfo; /* Operator services info */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ANS95 || SS7_ITU97  || SS7_RUSS2000|| SS7_ITU2000 || SS7_NZL || \
      SS7_KZ || SS7_UR)
   SiCirAsgnMap cirAsgnMap;      /* circuit assignment map */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiDisplayInfo  displayInfo;   /* display information */
   SiConfTrtInd    confTrtInd;   /* confrence treatment indicators */
   SiNetMgmtControls netMgmtControls;  /* network management controls */
   SiCorrelationId correlationId;/* correlation Id */
   SiCallDivTrtInd callDivTrtInd;/* call diversion treatment indicators */
   SiCallInNmb  callInNmb;       /* call IN number */
   SiCallOfferTrtInd callOfferTrtInd;/* call offering treatment ind */
   SiScfId      scfId;           /* SCF Id */
   SiUidCapInd  uidCapInd;       /* UID capability indicator */
   SiCollCallReq collCallReq;    /* collect call request */
   SiCcss         ccss;          /* CCSS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_UK || SS7_NZL || SS7_KZ || \
     SS7_UR)
   SiBackGVNS     backGVNS;      /* backward GVNS */
   SiForwardGVNS  forwardGVNS;   /* forward GVNS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiChargeNum htrInfo;             /* HTR Information */
   SiPivotCap pivotCap;             /* Pivot Capability */   
   SiCdPtyNum cadDirNmb;            /* Called Directory Number */
   SiOrigCdNum origCallInNum;       /* Original Called IN Number */
   SiCalgGeoLoc calgGeoLoc;         /* Calling geodetic location */
   SiNetRoutNum netRoutNum;         /* Network Routing Number */
   SiQOnRelCap qonRelCap;           /* Query on Release Capability */
   SiPivotCntr pivotCntr;           /* Pivot Counter */
   SiPivotRtgBkInfo pivotRtgFwInfo; /* Pivot Routing Forward Info*/
   SiPivotRtgBkInfo pivotRtgBkInfo; /*Pivot Routing Backward Info*/
   SiRedirStat redirStat;           /* Redirect Status */
   SiNumPortFwdInfo numPortFwdInfo; /* Number Portability Forward Info */
#endif
#ifdef SS7_UK
   SiNatFwdCalInd natFwdCalInd;	/* National Forward Call Indicator */
   SiPresentNum  presntNum;		/* Presentation Number */
   SiLstDvrtLineID  lstDvrtLineId;	/* Last Diverting Line ID */
   SiPartialCgLineId  pcgLineId;		/* Partial Calling Line ID */
   SiNatFwdCalIndLnk  natFwdCalIndLnk;	/* national Forward Call Indicator (Link by Link) */
   SiCdBasicSrvcMarks cdBascSrvcMrk;	/* Called Subscriber's Basic Service Marks */
#endif /* SS7_UK */
/* sit_x_001.main_59 : added new cause diagnostic parameter to support calling party number 
                check enum feature */
#if (defined(CGPN_CHK))
   SiCauseDgn  causeDgnCgPnChk;         /* cause indicators specific to calling party
                                           number check*/
#endif


} SiConEvnt;

  
typedef struct  siCnStEvnt       /* Connect Status Event */
{
   SiSubNum        subNum;       /* subsequent number */
   SiBckCalInd     bckCallInd;   /* backward call indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiChargeNum     chargeNum;    /* connected number */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA      callRefA;     /* call reference */
   SiConnReqA      connReqA;     /* connection request */
#endif
   SiOptBckCalInd  optBckCalInd; /* optional backward call indicators */
/* sit_x_001.main_63: Added flag for Brazil variant */
#if (SS7_Q767 || SS7_RUSSIA || SS7_NTT || SS7_BRZL)
   SiOptBckCalIndQ optBckCalIndQ;/* Q767 and Russia optional backward
                                  * call indicators */
#endif  
   SiCauseDgn      causeDgn;     /* cause indicators */
/* sit_x_001.main_61:  moved causeDgnCgPnChk here */
/* sit_x_001.main_59 : added new cause diagnostic parameter to support calling party number 
                check enum feature */
#if (defined(CGPN_CHK))
   SiCauseDgn      causeDgnCgPnChk;  /* cause indicators specific to calling party
                                      number check*/
#endif
   SiConnectedNum  connNum;      /* connected number */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   SiConnectedNum2 connNum2;    /* connected number */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiConnectedNum3 connNum3;                    /* connected number */
#endif
   SiUsr2UsrInd    usr2UsrInd;   /* user to user indicators */
   SiUsr2UsrInfo   usr2UsrInfo;  /* user to user information */
#if SS7_ANS88
   SiRedirInfo     redirInfo;    /* redirection information */
#endif
   SiAccTrnspt     accTrnspt;    /* access transport */
   SiCalModInd     calModInd;    /* call modification indicators */
   SiEvntInfo      evntInfo;     /* event information */
   SiCdPtyNum      redirNum;     /* redirection number */
   SiInfoInd       infoInd;      /* information indicators */
   SiInfoReqInd    infoReqInd;   /* information request indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiRedirNum      redirgNum;    /* redirecting number */
#endif
#if SS7_ANS88
   SiInfoIndA      infoIndA;     /* information indicators */
   SiInfoReqIndA   infoReqIndA;  /* information request indicators */
#endif
/* sit_x_001.main_64 : Added for ukraine */
#if SS7_UR
   SiInfoIndU      infoIndU;     /* information indicators */
   SiInfoReqIndU   infoReqIndU;  /* information request indicators */
#endif
   SiCgPtyCat      cgPtyCat;     /* calling party category */
   SiCgPtyNum      cgPtyNum;     /* calling party number */
#if SS7_ANS88
   SiIndex         index;        /* index */
#endif
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiOutgTrkGrpNum grpNum;       /* outgoing trunk group number */
#endif
#endif
/* sit_x_001.main_59 : deleted connection request not required by
   UK variant */
   SiConnReq       connReq1;      /* connection request */
   SiCallRef       callRef;      /* call reference */
   SiNotifInd      notifInd;     /* notification indicator */
   SiNotifInd     notifIndR1;    /* notification indicator (repeated ITU97/92) */
   SiTxMedReq      txMedUsed;    /* transmission medium used */
   SiEchoCtl       echoControl;  /* echo control */
   SiAccDelInfo    accDelInfo;   /* access delivery information */
   SiGenNum        genNmb;       /* generic number */
   SiGenNum       genNmbR;       /* generic number (repeated) */
   SiParmCompInfo  parmCom;      /* parameter compatibility information */
   SiCllDiverInfo  cllDivr;      /* call Diversion information */
   SiNetSpecFacil  netFac;       /* network specific facility */
/* sit_x_001.main_53 : Removed remotOper1, serviceAct2 for china variant */
   SiRemotOper     remotOper;    /* remote operations */
   SiServiceAct    serviceAct;   /* service activation */
   SiRedirRestr    redirRstr;    /* redirection restriction */
   SiMcidReqInd    mcidReq;      /* MCID request indicators */
   SiMcidRspInd    mcidRsp;      /* MCID response indicators */
   SiMsgCompInfo   msgCom;       /* message compatibility information */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiOrigLineInf   origLineInf;  /* originating line information */
#endif
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiBusinessGrp   businessGrp;  /* business group */
/* sit_x_001.main_53 : Added Call Reference */
/* sit_x_001.main_57 : Deleted Call Reference */
   SiInfoInd       infoInd2;     /* information indicators */
   SiNetTransport  netTransport; /* network transport */
   SiNotifInd      notifInd1;    /* notification indicator */
   SiNotifInd     notifIndR2;    /* notification indicator (repeated ANSI 95) */
   SiRedirInfo     redirInf;     /* redirection information */
#endif
#if SS7_Q767IT
   SiBackVadInd    backVad;      /* backward vad indicators */
#endif
#if SS7_SINGTEL
   SiCllChrgeInfo    chrgeInfo;    /* call charge info */
   SiChrgeRateInfo   rateInfo;     /* charge rate information */
#endif
#if SS7_NTT
   SiChrgInfoType  chrgInfoType; /* Charge information type */
   SiChrgInfo      chrgInfo;     /* Charge information */ 
#endif
#if SS7_SINGTEL
   TrnkOff         trnkOff;      /* trunk offering information */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || \
     SS7_UR)
   SiCgPtyNum      calTrnsNmb;   /* Call Transfer Number */
   SiCallTRef      calTrnsfrRef; /* Call Transfer reference */
   SiLoopPrvntInd     loopPrvntInd; /* loop prevention indicator */
#endif
#ifdef SS7_FTZ
   SiNaPaExTID     naPaExTID;    /* National Parameter for exch & trunk ID */
   SiNaPaCHGI      naPaCHGI;     /* National Parameter for charging infor. */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_ETSIV3 || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiNaPaChgPID    naPaChgPID;   /* National Parameter for charged party ID*/
#endif
#ifdef SS7_FTZ
   SiNaPaFF        naPaFF;       /* National Parameter FF */
#endif
/* sit_x_001.main_54: Modified to add control flag for ISUP Kazakhstan
   billZoneNum also represent tariff zone number */
/* sit_x_001.main_57 : deleted SS7_KZ flag */
#if SS7_RUSSIA
   SiBillZoneNum   billZoneNum;  /* Billing Zone Number */
#endif
/* sit_x_001.main_57 : added Tariff zone number for Kazakhatan */
#if SS7_KZ
   SiTariffZoneNum   tariffZoneNum;  /* Tariff Zone Number */
#endif
#if SS7_NTT
   SiMsgAreaInfo        msgAreaInfo;        /* Message Area Information */
   SiChrgInfoDelay      chrgInfoDelay;      /* Charge information delay */
   SiCarrierInfoTrans   carrierInfoTrans;   /* Carrier Info Transfer */ 
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiOpFwdCalInd opFwdCalInd;    /* optional forward call indicators */
   SiAppTransParam appTransParam;/* application transport parameter */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_UK || SS7_NZL || SS7_KZ \
      || SS7_UR) 
   SiBackGVNS     backGVNS;      /* backward GVNS */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiConfTrtInd    confTrtInd;   /* confrence treatment indicators */
   SiPropDly      cllHstry;      /* call history information */
   SiUidActionInd  uidActionInd; /* UID action indicator */
#endif
#ifdef SS7_INDIA
   SiChargeBand   chrgeBnd;      /* charge band parameter */
#endif
#ifdef SS7_CHINA
   SiChargeInform chrgeInform;   /* charge information parameter */
#endif /* if SS7_CHINA */
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_UK || SS7_KZ || SS7_UR)
   SiCCNRPosInd  ccnrPosInd;     /* CCNR Possible indicator */
   SiChargeNum htrInfo;          /* HTR Information */
   SiPivotRtgBkInfo pivotRtgBkInfo;  /*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
#endif
#ifdef SS7_UK
SiCdBasicSrvcMarks  cdBasicSrvcMarks; /* called Subscribers Basic Service Marks  */
SiNatInfoReqInd     natInfoReqInd;   /* National Information Request Indicators */
SiCgBasicSrvcMarks  cgBasicSrvcMarks; /* calling Subscribers Basic Service Marks  */
SiCgOrigFacMarks    cgOrigFacMarks;  /* Calling Subscriber's Originating Facility Marks */
SiCdTermFacMarks    cdTermFacMarks;  /* Called Subscriber's Terminating Facility Marks */
SiNatInfoInd        natInfoInd;   /* National Information Indicators */
SiGenNum            genNumber;    /* Generic Number (With NQ set as Intercepted Line ID */
#endif /* SS7_UK */
#ifdef SANGOMA_SPIROU
	SiChargUnitNum      chargUnitNum;  /* Chage Unit Number */
	SiMsgNum            msgNum;       /* message  Number */
#endif /* SANGOMA_SPIROU */
} SiCnStEvnt;
  
typedef struct siInfoEvnt        /* Information Event */
{
   SiCallRef callRef;            /* call reference */
#if (SS7_CHINA)
   SiCallRefA      callRefA;     /* call reference */
#endif /* if SS7_CHINA */
   SiPassAlng passAlng;          /* pass along */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiAccTrnspt accTrnspt;        /* access transport */
} SiInfoEvnt;
  
typedef struct siResmEvnt        /* resume event */
{
   SiSusResInd susResInd;        /* Suspend/Resume indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
} SiResmEvnt;
  
typedef struct siStaEvnt         /* Status Event */
{
   SiRangStat rangStat;          /* range and status */
   SiCirGrpSupMTypInd cgsmti;    /* circuit grp. supervision msg. type ind. */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiCirStateInd cirSteIndA;     /* Circuit State Indicators */
#endif
   SiCirStateInd cirStateInd;    /* circuit state indicators */
   SiContInd contInd;            /* continuity indicator */
   SiCauseDgn causeDgn;          /* cause indicators */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiNatConInd natConInd;        /* Nature of connection indicators */
#endif
#if SS7_ANS95
   SiCirAsgnMap cirAsgnMap;      /* circuit assignment map */
#endif
} SiStaEvnt;
  
typedef struct siRelEvnt         /* Release Event */
{
   SiCauseDgn causeDgn;          /* cause indicators */
#if SS7_ANS88
   SiRedirInfo redirInfoA;       /* redirection information */
#endif
#if SS7_BELL
   SiChargeNum  redirgNumB;       /* redirection number for Bell */
#endif
   SiRedirInfo redirInfo;        /* redirection information */
   SiCdPtyNum      redirNum;     /* redirection number */
#if SS7_ANS88
   SiRedirNum redirgNum;         /* redirection number */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiCallRefA callRefA;          /* call reference */
#endif
#if (SS7_ANS88 || SS7_CHINA)
   SiSigPointCodeA sigPointCodeA;/* Signalling point code */
#endif
#if SS7_ANS88
   SiCugIntCodeA cugIntCodeA;    /* closed group interlock code */
#endif
   SiSigPointCode sigPointCode;  /* signalling point code */
   SiAccTrnspt accTrnspt;        /* access transport */
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
   SiAutoCongLvl autoCongLvl;    /* automatic congestion level */
   SiAccDelInfo accDelInfo;      /* access delivery information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
   SiNetSpecFacil netFac;        /* network specific facility */
   SiRedirRestr redirRstr;       /* redirection restriction */
   SiUsr2UsrInd usr2UsrInd;      /* user to user indicators */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   SiChargeNum chargeNum;        /* charge number */
   SiGenAddr genAddr;            /* generic address */
   SiGenAddr genAddrR;            /* generic address (repeated) */
#endif
#if SS7_Q767IT
   SiBackVadInd backVad;         /* backward vad indicators */
#endif
#if SS7_SINGTEL
   TrnkOff trnkOff;              /* trunk offering information */
#endif
#if SS7_NTT
   SiCdPtyNum cdPtyNum;          /* called party number */
#endif
#if (SS7_NTT || SS7_ANS95)
   SiServiceAct    serviceAct;   /* service activation */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_RUSS2000 || SS7_ITU2000 || SS7_ETSIV3 || \
     SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ || SS7_UR)
   SiDisplayInfo  displayInfo;   /* display information */
   SiRemotOper     remotOper;    /* remote operations */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ  || SS7_UR)
   SiChargeNum htrInfo;          /* HTR Information */
   SiRedirCntr redirCntr;        /* Redirect counter */
   SiPivotRtgBkInfo redirBkInfo; /* Redirect Backward Info */
#endif
} SiRelEvnt;
  
typedef struct siSuspEvnt        /* suspend event */
{
   SiSusResInd susResInd;        /* suspend/resume indicators */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiCallRef callRef;            /* call reference */
} SiSuspEvnt;
  
typedef struct siFacEvnt         /* facility event */
{
   SiFacInd facInd;              /* facility indicator */
#if SS7_ANS88
   SiFacInfInd facInfInd;        /* facility information indicator */
   SiCdPtyNum cdPtyNum;          /* called party number */
   SiCgPtyNum cgPtyNum;          /* calling party number */
#endif
#if (SS7_ANS88 || SS7_CHINA)
   SiCallRefA callRefA;          /* call reference */
#endif
   SiUsr2UsrInd usr2UsrInd;      /* user to user indicator */
   SiCallRef callRef;            /* call reference */
   SiCauseDgn causeDgn;          /* cause indicator */
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmCom;       /* parameter compatibility information */
/* sit_x_001.main_58 : Deleted RemotOper1 and ServiceAct2 as not required at
   present for CHINA variant */
#if SS7_CHINA
   SiConnReqA  connReqA;            /* connection request */
#endif   
   SiRemotOper remotOper;        /* remote operations */
   SiServiceAct serviceAct;      /* service activation */
   SiConnReq connReq;            /* connection request */
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_FTZ || SS7_ITU97 || SS7_RUSS2000 || \
     SS7_ITU2000 || SS7_ETSIV3 || SS7_INDIA || SS7_UK || SS7_NZL || SS7_KZ \
      || SS7_UR)
   SiCgPtyNum calTrnsNmb;        /* Call Transfer Number */
   SiAccTrnspt accTrans;         /* access transport */
   SiNotifInd notifInd;          /* notification indicator */
#endif
/* sit_x_001.main_54: Added control flag for Kazakhstan variant */
/* sit_x_001.main_64 : Added Control flag for ukraine */ 
#if (SS7_ITU2000 || SS7_KZ || SS7_UR)
   SiCdPtyNum redirNum;          /* redirection number */
   SiPivotRtgInd pivotRtgInd;    /* Pivot Routing Indicators */   
   SiPivotStat pivotStat;        /* Pivot Status */
   SiPivotCntr pivotCntr;        /* Pivot Counter */
   SiPivotRtgBkInfo pivotRtgBkInfo;/*Pivot Routing Backward Info*/
   SiRedirStat redirStat;        /* Redirect Status */
#endif
#if SS7_FTZ
   SiNaPaFF naPaFF;              /* National Parameter FF */
#endif
} SiFacEvnt;
  
typedef struct siFtzEvnt  /* GT_FTZ event */
{
#ifdef SS7_FTZ
   SiMsgCompInfo msgCom;         /* message compatibility information */
   SiParmCompInfo parmComp;      /* parameter compatibility information */
   SiAccDelInfo accDelInfo;      /* access delivery information */
   SiAccTrnspt accTrnspt;        /* access transport */
   SiAutoCongLvl auCongLvl;      /* automatic congestion level */
   SiCauseDgn causeDgn;          /* cause indicator */
   SiFacInd facInd;              /* facility indicator */
   SiFacIndInfor facIndInf;      /* Facility Information Indicator */
   SiNaPaFF naPaFF;              /* National Parameter FF */
   SiNaPaCHGI naPaCHGI;          /* National Parameter for charging infor. */
   SiNaPaTTZ naPaTTZ;            /* National Parameter for Tln-2-Tln sign. */
   SiSigPointCode sigPointCode;  /* signalling point code */
   SiUsr2UsrInd usr2UsrInd;      /* user to user indicator */
#endif
   SiUsr2UsrInfo usr2UsrInfo;    /* user to user information */
} SiFtzEvnt;

#ifdef LSIV5
typedef struct siOlmEvnt  /* Overload event */
{
} SiOlmEvnt;
#endif
 
typedef struct siAllSdus         /* all sdu messages */
{
   union
   {
      SiConEvnt   siConEvnt;      /* ISUP Connect Event */
      SiCnStEvnt  siCnStEvnt;     /* Connect Status Event */
      SiFacEvnt   siFacEvnt;      /* facility event */
      SiInfoEvnt  siInfoEvnt;     /* Information Event */
      SiResmEvnt  siResmEvnt;     /* resume event */
      SiStaEvnt   siStaEvnt;      /* Status Event */
      SiRelEvnt   siRelEvnt;      /* Release Event */
      SiSuspEvnt  siSuspEvnt;     /* suspend event */
      SiFtzEvnt   siFtzEvnt;      /* FTZ utilities event */
#ifdef LSIV5 
      SiOlmEvnt   siOlmEvnt;      /* OLM event */ 
#endif
   } m;
} SiAllSdus;
  
/* typedefs of primitives */
  
/* depending on the specific selector in the pst structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */
  
typedef S16 (*SitBndReq) ARGS ((Pst *pst, SuId suId, SpId spId));

#ifdef SIT2
typedef S16 (*SitBndCfm) ARGS ((Pst *pst, SuId suId, U8 status));
#endif

typedef S16 (*SitCnStInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiCnStEvnt *siCnStEvnt, U8 evntType, 
       Buffer *uBuf));

typedef S16 (*SitCnStReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiCnStEvnt *siCnStEvnt, U8 evntType,
       U8 xchgType, Buffer *uBuf));

typedef S16 (*SitConCfm) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiConEvnt *siConEvnt, Buffer *uBuf));

typedef S16 (*SitConInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiConEvnt *siConEvnt, Buffer *uBuf));

typedef S16 (*SitConReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, Bool cirSelFlg, CirId circuit,SiConEvnt *siConEvnt,
       U8 xchgType, Buffer *uBuf));

typedef S16 (*SitConRsp) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiConEvnt *siConEvnt, U8 xchgType, 
       Buffer *uBuf));

typedef S16 (*SitDatInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

typedef S16 (*SitDatReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

typedef S16 (*SitFacCfm) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, U8 evntType, SiFacEvnt *siFacEvnt,
       Buffer *uBuf));

typedef S16 (*SitFacInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, U8 evntType, SiFacEvnt *siFacEvnt, 
       Buffer *uBuf));

typedef S16 (*SitFacReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, U8 evntType, SiFacEvnt *siFacEvnt, 
       Buffer *uBuf));

typedef S16 (*SitFacRsp) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, U8 evntType, SiFacEvnt *siFacEvnt,
       Buffer *uBuf));

typedef S16 (*SitRelCfm) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiRelEvnt *siRelEvnt, Buffer *uBuf));

typedef S16 (*SitRelInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiRelEvnt *siRelEvnt, Buffer *uBuf));

typedef S16 (*SitRelReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiRelEvnt *siRelEvnt, Buffer *uBuf));

typedef S16 (*SitRelRsp) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiRelEvnt *siRelEvnt, Buffer *uBuf));

typedef S16 (*SitResmInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiResmEvnt *siResmEvnt, Buffer *uBuf));

typedef S16 (*SitResmReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiResmEvnt *siResmEvnt, Buffer *uBuf));

typedef S16 (*SitStaInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, Bool globalFlag, U8 eventType, 
       SiStaEvnt *siStaEvnt, Buffer *uBuf));

typedef S16 (*SitStaReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, Bool globalFlg, CirId circuit, U8 evntType, 
       SiStaEvnt *siStaEvnt, Buffer *uBuf));

typedef S16 (*SitSuspInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

typedef S16 (*SitSuspReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

#if SS7_FTZ
typedef S16 (*SitFtzInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, U8 evntType, SiFtzEvnt *siFtzEvnt, 
       Buffer *uBuf));

typedef S16 (*SitFtzReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
       SiInstId spInstId, CirId circuit, U8 evntType, SiFtzEvnt *siFtzEvnt,
       Buffer *uBuf ));

#endif /* SS7_FTZ */

typedef S16 (*SitUMsgReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
        SiInstId spInstId, CirId circuit, Buffer *uBuf));
typedef S16 (*SitUMsgInd) ARGS ((Pst *pst, SuId suId, SiInstId suInstId,
        SiInstId spInstId, CirId circuit, Buffer *uBuf));
typedef S16 (*SitPtCdeStaReq) ARGS ((Pst *pst, SpId spId, SiInstId intfId));
typedef S16 (*SitPtCdeStaCfm) ARGS ((Pst *pst, SuId suId, SiInstId intfId,
                                     U8 status, U8 congLevel));
#ifdef LSIV5
typedef S16 (*SitOlmReq) ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                SiOlmEvnt *siOlmEvnt, Buffer *uBuf));
#endif

 /*sit_x_001.main_62-removed extern"C"-removing warnings*/

/* define packing/unpacking if loosely coupled SIT i/f is specified */
#ifdef LCSIT

PUBLIC S16 siPkCdPtyNum     ARGS((SiCdPtyNum *pCdPtyNum,Buffer *mBuf));
PUBLIC S16 siPkCgPtyNum     ARGS((SiCgPtyNum *pCgPtyNum,Buffer *mBuf));
#if SS7_BELL
PUBLIC S16 siPkCgPtyNum1     ARGS((SiCgPtyNum1 *pCgPtyNum,Buffer *mBuf));
PUBLIC S16 siUnpkCgPtyNum1    ARGS((SiCgPtyNum1 *pCgPtyNum,Buffer *mBuf));
#endif
PUBLIC S16 siUnpkCdPtyNum    ARGS((SiCdPtyNum *pCdPtyNum,Buffer *mBuf));
PUBLIC S16 siUnpkCgPtyNum    ARGS((SiCgPtyNum *pCgPtyNum,Buffer *mBuf));

PUBLIC S16 cmPkSitBndReq ARGS((Pst *pst, SuId suId, SpId spId));

PUBLIC S16 cmUnpkSitBndReq ARGS((SitBndReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitBndCfm ARGS((Pst *pst, SuId suId, U8 status));

#ifdef SIT2
PUBLIC S16 cmUnpkSitBndCfm ARGS((SitBndCfm func, Pst *pst, Buffer *mBuf));
#endif

PUBLIC S16 cmPkSitConReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, Bool cirSelFlg,
                               CirId circuit, SiConEvnt *siConEvnt,
                               U8 xchgType, Buffer *uBuf)); 

PUBLIC S16 cmUnpkSitConReq ARGS((SitConReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitConInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiConEvnt *siConEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitConInd ARGS((SitConInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitConRsp ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiConEvnt *siConEvnt, U8 xchgType, 
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitConRsp ARGS((SitConRsp func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitConCfm ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiConEvnt *siConEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitConCfm ARGS((SitConCfm func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitCnStReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiCnStEvnt *siCnStEvnt, U8 evntType,
                                U8 xchgType, Buffer *uBuf));

PUBLIC S16 cmUnpkSitCnStReq ARGS((SitCnStReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitCnStInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiCnStEvnt *siCnStEvnt, U8 evntType,
                                Buffer *uBuf));

PUBLIC S16 cmUnpkSitCnStInd ARGS((SitCnStInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitDatReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitDatReq ARGS((SitDatReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitDatInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitDatInd ARGS((SitDatInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitFacReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               U8 evntType, SiFacEvnt *siFacEvnt,
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitFacReq ARGS((SitFacReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitFacInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               U8 evntType, SiFacEvnt *siFacEvnt,
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitFacInd ARGS((SitFacInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitFacRsp ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               U8 evntType, SiFacEvnt *siFacEvnt,
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitFacRsp ARGS((SitFacRsp func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitFacCfm ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               U8 evntType, SiFacEvnt *siFacEvnt,
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitFacCfm ARGS((SitFacCfm func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitSuspReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitSuspReq ARGS((SitSuspReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitSuspInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitSuspInd ARGS((SitSuspInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitResmReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiResmEvnt *siResmEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitResmReq ARGS((SitResmReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitResmInd ARGS((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit,
                                SiResmEvnt *siResmEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitResmInd ARGS((SitResmInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitStaReq ARGS((Pst *pst, SpId spId, SiInstId suInstId, 
                               SiInstId spInstId, Bool globalFlag,
                               CirId circuit, U8 eventType,
                               SiStaEvnt *siStaEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitStaReq ARGS((SitStaReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitStaInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               Bool globalFlag, U8 eventType, 
                               SiStaEvnt *siStaEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitStaInd ARGS((SitStaInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitRelReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiRelEvnt *siRelEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitRelReq ARGS((SitRelReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitRelInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiRelEvnt *siRelEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitRelInd ARGS((SitRelInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitRelRsp ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiRelEvnt *siRelEvnt, Buffer *uBuf));
 
PUBLIC S16 cmUnpkSitRelRsp ARGS((SitRelRsp func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitRelCfm ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiRelEvnt *siRelEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitRelCfm ARGS((SitRelCfm func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitUMsgReq ARGS((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                Buffer *uBuf));

PUBLIC S16 cmUnpkSitUMsgReq ARGS((SitUMsgReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitUMsgInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                Buffer *uBuf));

PUBLIC S16 cmUnpkSitUMsgInd ARGS((SitUMsgInd func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitPtCdeStaReq ARGS((Pst *pst, SpId spId, SiInstId intfId));

PUBLIC S16 cmUnpkSitPtCdeStaReq ARGS((SitPtCdeStaReq func, Pst *pst, 
                                      Buffer *mBuf));

PUBLIC S16 cmPkSitPtCdeStaCfm ARGS((Pst *pst, SpId spId, SiInstId intfId, U8 status,
                                    U8 congLevel));

PUBLIC S16 cmUnpkSitPtCdeStaCfm ARGS((SitPtCdeStaCfm func, Pst *pst,
                                      Buffer *mBuf));

#ifdef SS7_FTZ
PUBLIC S16 cmPkSitFtzReq ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               U8 evntType, SiFtzEvnt *siFtzEvnt,
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitFtzReq ARGS((SitFtzReq func, Pst *pst, Buffer *mBuf));

PUBLIC S16 cmPkSitFtzInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               U8 evntType, SiFtzEvnt *siFtzEvnt, 
                               Buffer *uBuf));

PUBLIC S16 cmUnpkSitFtzInd ARGS((SitFtzInd func, Pst *pst, Buffer *mBuf));

#endif /* SS7_FTZ */

#ifdef LSIV5
PUBLIC S16 cmPkSitOlmReq ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit,
                               SiOlmEvnt *siOlmEvnt, Buffer *uBuf));

PUBLIC S16 cmUnpkSitOlmReq ARGS((SitOlmReq func, Pst *pst, Buffer *mBuf));

#endif

#endif /* LCSIT */
  
#ifdef SI
/* isup upper interface, isup discriminator */
extern S16 SiUiSitBndReq ARGS ((Pst *pst, SuId suId, SpId spId));

#ifdef SIT2
extern S16 SiUiSitBndCfm ARGS ((Pst *pst, SuId suId, U8 status));
#endif

extern S16 SiUiSitCnStInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiCnStEvnt *siCnStEvnt, U8 evntType,
                                 Buffer *uBuf));

extern S16 SiUiSitCnStReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiCnStEvnt *siCnStEvnt, U8 evntType,
                                 U8 xchgType, Buffer *uBuf));

extern S16 SiUiSitConCfm ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiConEvnt *siConEvnt, Buffer *uBuf));

extern S16 SiUiSitConInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiConEvnt *siConEvnt, Buffer *uBuf));

extern S16 SiUiSitConReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, Bool cirSelFlg, 
                                CirId circuit,SiConEvnt *siConEvnt,
                                U8 xchgType, Buffer *uBuf));

extern S16 SiUiSitConRsp ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiConEvnt *siConEvnt, U8 xchgType, 
                                Buffer *uBuf));

extern S16 SiUiSitDatInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

extern S16 SiUiSitDatReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

extern S16 SiUiSitFacCfm ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 SiUiSitFacInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 SiUiSitFacReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 SiUiSitFacRsp ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 SiUiSitRelCfm ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 SiUiSitRelInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 SiUiSitRelReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 SiUiSitRelRsp ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 SiUiSitResmInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiResmEvnt *siResmEvnt, Buffer *uBuf));

extern S16 SiUiSitResmReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiResmEvnt *siResmEvnt, Buffer *uBuf));

extern S16 SiUiSitStaInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                Bool globalFlag, U8 eventType, 
                                SiStaEvnt *siStaEvnt, Buffer *uBuf));

extern S16 SiUiSitStaReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, Bool globalFlg, 
                                CirId circuit, U8 evntType, 
                                SiStaEvnt *siStaEvnt, Buffer *uBuf));

extern S16 SiUiSitSuspInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

extern S16 SiUiSitSuspReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

#if SS7_FTZ
extern S16 SiUiSitFtzInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFtzEvnt *siFtzEvnt,
                                Buffer *uBuf));

extern S16 SiUiSitFtzReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFtzEvnt *siFtzEvnt,
                                Buffer *uBuf));
#endif /* SS7_FTZ */

EXTERN S16 SiUiSitUMsgReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                 SiInstId spInstId, CirId circuit, 
                                 Buffer *uBuf));

EXTERN S16 SiUiSitUMsgInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId,
                                 SiInstId spInstId, CirId circuit, 
                                 Buffer *uBuf));

EXTERN S16 SiUiSitPtCdeStaReq ARGS((Pst *pst, SpId spId, SiInstId intfId));

EXTERN S16 SiUiSitPtCdeStaCfm ARGS ((Pst *pst, SuId suId, SiInstId intfId,
                                     U8 status, U8 congLevel));

#ifdef LSIV5
extern S16 SiUiSitOlmReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiOlmEvnt *siOlmEvnt, Buffer *uBuf));
#endif

#endif

#ifdef IW /* ISUP Wrapper */
#ifdef SIT2
EXTERN S16 IwLiSitBndCfm ARGS((Pst *pst, SuId suId, U8 status));
#endif
EXTERN S16 IwLiSitConInd ARGS((Pst *pst, SpId suId, UConnId suConnId, 
                               UConnId spConnId, CirId circuit, 
                               SiConEvnt *siConEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitConCfm ARGS((Pst *pst, SuId suId, UConnId suConnId, 
                               UConnId spConnId, CirId circuit, 
                               SiConEvnt *siConEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitCnStInd ARGS((Pst *pst, SuId suId, UConnId suConnId, 
                                UConnId spConnId, CirId circuit, 
                                SiCnStEvnt *siCnStEvnt, U8 evntType, 
                                Buffer *uBuf));

EXTERN S16 IwLiSitRelInd ARGS((Pst *pst, SuId suId, UConnId suConnId, 
                               UConnId spConnId, CirId circuit, 
                               SiRelEvnt *siRelEvnt, Buffer *uBuf));
EXTERN S16 IwLiSitRelCfm ARGS((Pst *pst, SuId suId, UConnId suConnId,
                               UConnId spConnId, CirId circuit,
                               SiRelEvnt *siRelEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitDatInd ARGS((Pst *pst, SuId suId, UConnId suConnId, 
                               UConnId spConnId, CirId circuit, 
                               SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitSuspInd ARGS((Pst *pst, SuId suId, UConnId suConnId, 
                                UConnId spConnId, CirId circuit, 
                                SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitResmInd ARGS((Pst *pst, SuId suId, UConnId suConnId,
                                UConnId spConnId, CirId circuit, 
                                SiResmEvnt *siResmEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitFacInd ARGS((Pst *pst, SuId suId, SiInstId suInstId,
                               SiInstId spInstId, CirId circuit, U8 evntType, 
                               SiFacEvnt *siFacEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitFacCfm ARGS((Pst *pst, SuId suId, UConnId suConnId,
                               UConnId spConnId, CirId circuit, U8 evntType,
                               SiFacEvnt *siFacEvnt, Buffer *uBuf));

EXTERN S16 IwLiSitStaInd ARGS((Pst *pst, SuId suId, UConnId suConnId,
                               UConnId spConnId, CirId circuit, Bool globalFlag,
                               U8 eventType, SiStaEvnt *siStaEvnt, 
                               Buffer *uBuf));
EXTERN S16 IwLiSitUMsgInd ARGS((Pst *pst, SuId suId, UConnId suConnId,
                                UConnId spConnId, CirId circuit, 
                                Buffer *uBuf));

EXTERN S16 IwLiSitPtCdeStaCfm ARGS ((Pst *pst, SuId suId, SiInstId intfId,
                                     U8 status, U8 congLevel));

EXTERN S16 IwLiSitFtzInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFtzEvnt *siFtzEvnt,
                                Buffer *uBuf));
#endif
  
#ifdef CC
EXTERN S16 CcLiSitBndReq ARGS ((Pst *pst, SuId suId, SpId spId));

#ifdef SIT2
EXTERN S16 CcLiSitBndCfm ARGS ((Pst *pst, SuId suId, U8 status));
EXTERN S16 CcLiSitPtCdeStaReq ARGS((Pst *pst, SpId spId, SiInstId intfId));
#endif

EXTERN S16 CcLiSitCnStInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiCnStEvnt *siCnStEvnt, U8 evntType,
                                 Buffer *uBuf));

extern S16 CcLiSitCnStReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit,
                                 SiCnStEvnt *siCnStEvnt, U8 evntType,
                                 U8 xchgType, Buffer *uBuf));

extern S16 CcLiSitConCfm ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiConEvnt *siConEvnt, Buffer *uBuf));

extern S16 CcLiSitConInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiConEvnt *siConEvnt, Buffer *uBuf));

extern S16 CcLiSitConReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, Bool cirSelFlg, 
                                CirId circuit,SiConEvnt *siConEvnt, 
                                U8 xchgType, Buffer *uBuf));

extern S16 CcLiSitConRsp ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiConEvnt *siConEvnt, U8 xchgType, 
                                Buffer *uBuf));

extern S16 CcLiSitDatInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

extern S16 CcLiSitDatReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiInfoEvnt *siInfoEvnt, Buffer *uBuf));

extern S16 CcLiSitFacCfm ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 CcLiSitFacInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 CcLiSitFacReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 CcLiSitFacRsp ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFacEvnt *siFacEvnt,
                                Buffer *uBuf));

extern S16 CcLiSitRelCfm ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 CcLiSitRelInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 CcLiSitRelReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 CcLiSitRelRsp ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                SiRelEvnt *siRelEvnt, Buffer *uBuf));

extern S16 CcLiSitResmInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiResmEvnt *siResmEvnt, Buffer *uBuf));

extern S16 CcLiSitResmReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiResmEvnt *siResmEvnt, Buffer *uBuf));

extern S16 CcLiSitStaInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                SiInstId spInstId, CirId circuit, 
                                Bool globalFlag, U8 eventType, 
                                SiStaEvnt *siStaEvnt, Buffer *uBuf));

extern S16 CcLiSitStaReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                SiInstId spInstId, Bool globalFlg, 
                                CirId circuit, U8 evntType, 
                                SiStaEvnt *siStaEvnt, Buffer *uBuf));

extern S16 CcLiSitSuspInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

extern S16 CcLiSitSuspReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId, 
                                 SiInstId spInstId, CirId circuit, 
                                 SiSuspEvnt *siSuspEvnt, Buffer *uBuf));

#if SS7_FTZ
extern S16 CcLiSitFtzInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFtzEvnt *siFtzEvnt,
                                Buffer *uBuf));

extern S16 CcLiSitFtzReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit, 
                                U8 evntType, SiFtzEvnt *siFtzEvnt,
                                Buffer *uBuf));

#endif /* SS7_FTZ */

EXTERN S16 CcLiSitUMsgReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                 SiInstId spInstId, CirId circuit, 
                                 Buffer *uBuf));

EXTERN S16 CcLiSitUMsgInd ARGS ((Pst *pst, SuId suId, SiInstId suInstId,
                                 SiInstId spInstId, CirId circuit, 
                                 Buffer *uBuf));

EXTERN S16 CcLiSitPtCdeStaCfm ARGS ((Pst *pst, SuId suId, SiInstId intfId,
                                       U8 status, U8 congLevel));

#ifdef LSIV5
extern S16 CcLiSitOlmReq ARGS ((Pst *pst, SpId spId, SiInstId suInstId,
                                SiInstId spInstId, CirId circuit,
                                SiOlmEvnt *siOlmEvnt, Buffer *uBuf));
#endif


#endif

#ifdef LCSIT
extern S16 siUnpkSiCnStEvnt ARGS((SiCnStEvnt *pSiCnStEvnt, Buffer *mBuf,
                                  Pst *pst));
extern S16 siUnpkSiConEvnt  ARGS((SiConEvnt *pSiConEvnt, Buffer *mBuf, 
                                  Pst *pst, U8 evntType));
extern S16 siUnpkSiFacEvnt  ARGS((SiFacEvnt *pSiFacEvnt, Buffer *mBuf,
                                  Pst *pst, U8 evntType));
extern S16 siUnpkSiInfoEvnt ARGS((SiInfoEvnt *pSiInfoEvnt, Buffer *mBuf, 
                                  Pst *pst));
extern S16 siUnpkSiRelEvnt  ARGS((SiRelEvnt *pSiRelEvnt, Buffer *mBuf, 
                                  Pst *pst));
extern S16 siUnpkSiResmEvnt ARGS((SiResmEvnt *pSiResmEvnt, Buffer *mBuf, 
                                  Pst *pst));
extern S16 siUnpkSiStaEvnt  ARGS((SiStaEvnt *pSiStaEvnt, Buffer *mBuf, 
                                  Pst *pst));
extern S16 siUnpkSiSuspEvnt ARGS((SiSuspEvnt *pSiSuspEvnt, Buffer *mBuf, 
                                  Pst *pst));

#if SS7_FTZ
extern S16 siUnpkSiFtzEvnt  ARGS((SiFtzEvnt *pSiFtzEvnt, Buffer *mBuf,
                                  Pst *pst, U8 evntType));
#endif /* SS7_FTZ */

#ifdef LSIV5
extern S16 siUnpkSiOlmEvnt  ARGS((SiOlmEvnt *pSiOlmEvnt, Buffer *mBuf,
                                  Pst *pst));
#endif
extern S16 siPkCnStEvnt ARGS((SiCnStEvnt *pSiCnStEvnt, Buffer *mBuf, 
                              Pst *pst));
extern S16 siPkConEvnt  ARGS((SiConEvnt *pSiConEvnt, Buffer *mBuf,
                              Pst *pst, U8 evntType));
extern S16 siPkFacEvnt  ARGS((SiFacEvnt *pSiFacEvnt, Buffer *mBuf,
                              Pst *pst, U8 evntType));
extern S16 siPkInfoEvnt ARGS((SiInfoEvnt *pSiInfoEvnt, Buffer *mBuf, 
                              Pst *pst));
extern S16 siPkRelEvnt  ARGS((SiRelEvnt *pSiRelEvnt, Buffer *mBuf, 
                              Pst *pst));
extern S16 siPkResmEvnt ARGS((SiResmEvnt *pSiResmEvnt, Buffer *mBuf, 
                              Pst *pst));
extern S16 siPkStaEvnt  ARGS((SiStaEvnt *pSiStaEvnt, Buffer *mBuf, 
                              Pst *pst));
extern S16 siPkSuspEvnt ARGS((SiSuspEvnt *pSiSuspEvnt,  Buffer *mBuf, 
                              Pst *pst));

#if SS7_FTZ
extern S16 siPkSiFtzEvnt ARGS((SiFtzEvnt *pSiFtzEvnt, Buffer *mBuf,
                               Pst *pst, U8 evntType));
#endif /* SS7_FTZ */

#ifdef LSIV5
extern S16 siPkOlmEvnt  ARGS((SiOlmEvnt *pSiOlmEvnt, Buffer *mBuf,
                              Pst *pst ));
#endif
#endif /* LCSIT */
 /*sit_x_001.main_62-removed extern"C"-removing warnings*/

#endif /* __SITX__ */

  
/********************************************************************30**
  
         End of file:     sit.x@@/main/66 - Tue Jul 13 16:54:14 2010
    
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  bn    1. initial release
             ---  jrl   2. trillium development system checkpoint (dvs)
                           at version: 1.0.0.0

1.2          ---  rk    1. add support of ANSI

1.3          ---  jrl   1. text changes

1.4          ---  lc    1. change ANS to SS7_ANS88

1.5          ---  rhk   1. remove ifdef SS7_ANS88 that were ANS

1.6          ---  rhk   1. Added #ifdef (SS7_ANS88 || SS7_ANS92) where necessary

1.7          ---  bn    1. added support for ansi 92.

1.8          ---  bn    1. change ANS88 to SS7_ANS88, ANS92 to
                           SS7_ANS92

1.9          ---  bn    1. add definition of SiOpFwdCalIndA for ansi 88.

1.10         ---  bn    1. added endOp to definition of confusion message.
 
1.11         ---  bn    1. changed tag endOp to siEndOp.
 
1.12         ---  bn    1. changes to support new interface

1.13         ---  bn    1. move endif

1.14         ---  bn    1. added support for SW_Q767 and SW_SINGTEL.

1.15         ---  bn    1. changed charge to SiCharge in the typedef for
                           charge message.

1.16         ---  bn    1. corrections for Italian Q767.

1.17         ---  bn    1. added backward vad to siConEvnt structure for
                           Italian Q767.

1.18         ---  bn    1. moved usr2UsrInd and callRef in FacilAccpt message
                           outside of #if SS7_ANS88.

1.19         ---  bn    1. corrected siAllPdus union.

1.20         ---  pc    1. added support for ETSI SI

1.21         ---  dm    1. added support for GT_FTZ SI
             ---  dm    2. added externs of packing/unpacking funcs. 
                           for events
             ---  dm    3. added service code parameter for ANSI92
             ---  dm    4. added event type in the Facility primitives.

*********************************************************************81*/

/********************************************************************90**
 
    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
1.22         ---      bn   1. removed CCVER2 and BndCfg.
             ---      bn   2. added cirSteIndA in siStaEvnt.

1.23         ---      ao   1. Fixed typo for SS7_Q767IT

1.24         ---      ao   1. Added support for local number portability
             ---      rs   1. Added Parameter Compatibility in Connect
                              message structure.
             ---      ao   1. Added echo control info to the answer message
                              and ConEvnt. Changed definition of 
                              redirection number.
1.25         ---      rs   1. Added prototypes  for unrecognized primitives.
                      rh   2. Added prototypes for ISUP Wrapper
                      rh   3. PDU structure name changes
                      ao   4. Added Russian variant

1.26         ---      rh   1. Added Common packing/unpacking functions.
             ---      rs   1. Removed compiler warnings. 
             ---      ym   1. Changes in SiParmCompInfo to take care of 
                              extension bit in parameter compatibility 
                              information element.These changes are 
                              under SIT_PARAMETER flag.
                           2. Tx. medium used parameter is added in the
                              connection event under SIT_PARAMETER flag. 
                           3. Outgoing trunk group number is added in 
                              siCnStEvnt under SIT_PARAMETER flag.
             ---      ym   1. pduCon, pduACM and pduANM are corrected for
                              connected number under SIT_PARAMETER flag.
             ---      ym   1. Entire file is covered under __SITX__ and
                              ____SITX__ flags.

1.27         ---      bn   1. Added bellcore variant

1.28         ---      ym   1. Bit H field is added in user to user indctr.
                              This field is under SIT_PARAMETER flag.
             ---      bn   2. added new bellcore parameters.

1.29         ---      ym   1. Added NTT variant.
1.30         ---      ym   1. Bit H field is added in user to user indctr.
                              This field is under SIT_PARAMETER flag.
             ---      ym   1. siPduCQM is corrected by removing status field.
             ---      ym   1. Functions made public for feature
                              transparency in ICC.
             ---      tz   1. Added screening indicators in the
                              redirecting number and original called
                              number parameter.
1.31         ---      rrb  1. Upgraded parmater compatibility to support
                              two more unrecognized parameters. Also, changed
                              the structure to handle additional instruction
                              indicator in TknStr.
/main/33     ---      sk   1. Added notification indicator in ConEvnt 
                      bsp  1. Added parameter definitions and added them 
                              in various messages as specified by
                              ANS95, ITU97 and ETSIv3 specifications
                           2. Added 5 more instructions indicators to 
                              parameter compability information.
                           3. Enabled APM and PRI messages for ITU97
                           4. Renamed names structure tags because the 
                              name of one of their fields was the same 
                              as their name
                           5. Enabled passNtPoss for ETSI ver 3 in parameter
                              compatibility structure.
/main/34     ---      hy   1. Support of redirection number for Bell
                              in Rel msg and calling party number in
                              IAM for Bell variant
/main/35     ---      hy   1. Add screening indicator in calling party
                              number in structure SiCgPtyNum1.
    sit_x_001.main_35 hy   1. Changes to support of rolling upgrade:
                              . OR'ing TDS_ROLL_UPGRADE_SUPPORT with flag
                                SIT_PARAMETER
                              . Some structure defines are made visibled 
                                when TDS_ROLL_UPGRADE_SUPPORT flag is enabled.
    sit_x_002.main_35 mm   1. Modified service activation parameter for 
                              Bellcore variant.
    sit_x_003.maim_35 tz   1. Added charge band parameter structure for
                              Indian variant.
                           2. Added SS7_INDIA flags.  
    sit_x_004.maim_35 rk   1. Added CHINA flag and switch where applicable.
			   2. Added Charge information parameter structure for 
			      China variant
    sit_x_005.main_35 rk   1.  Modification : Removed #else to support 
    			       every variant 
    sit_x_005.main_35 rk   1. Transit network parameter for ansi specs defined.
                              This parameter is under TNS_ANSI compile time flag as
                              it is a particular customer requirement. We assume
                              that encoding/decoding of the TNS parameter will be
                              done by user.
    sit_x_006.main_35 bn   1. Added ITU2000 and Russian 2000 ISUP variants.
    sit_x_007.main_35 bn   1. corrected TDS_ROLL_UPGRADE_SUPPORT flag.
    sit_x_008.main_35 vp   1. corrected comment to "Location Number" in
    sit_x_009.main_35 vp   1. Modifications as required for UK variant of ISUP
    sit_x_010.main_35 vp   1. Removed #ifndef SS7_UK protection from strucutres
/main/41     ---      vp   1. Updating SID for clearcase migration
/main/42     ---      vp   1. Updating latest file to clearcase
    sit_x_001.main_42 vp   1. Removed UK flag for appContextId1
    sit_x_001.main_43 vp   1. Removed accDelInfo1
                           2. Added SS7_UK flag for backGVNS,confTrtInd
    sit_x_001.main_44 vp   1. Moved cdBasicSrvcMrk in ACM to the end of struct
                           2. Added SS7_CHINA flag in connReqA
    sit_x_001.main_45 skv  1.Modified PCI structure to add ITU flag to support 
                             correct processing of pass on not possible indicator.
                           2.Connection State event structure modified to hold 
                             meConnNumb3 structure to enable processing of 
                             Connected Number parameter in CPG Message.
    sit_x_001.main_46 rks  1. Added Flag in siCnStEvnt for SS7_UK and renamed 
                              connReq to connReq1 ( Patch si068.220 )
    sit_x_001.main_47 rks  1. Added New Zealand variant
    sit_x_001.main_48 rks  1. Added UK flag for CPC, CgPn and Connection
                              request in "SiPduINF" (Information Message)
    sit_x_001.main_49 rks  1. Created new OLM event structure "siOlmEvnt"
    (dependent si072.220)  2. Added overload event in "siAllSdus"
                           3. Added function declaration for packing and unpacking
                              of Overload event and request
*************************************************************************

Version    Patch            Initials     Description
-------- -----------------  --------  ---------------------------------
2.21     sit_x_001.main_52  rkumar    1. Initial release.
2.21     sit_x_001.main_53  rkumar    1. Removed remotOper1, serviceAct2 for
                                         china variant where applicable
                                      2. Added BELL flag in ANM
                                      3. Deleted unused "siPduDRS" and added
                                         call reference in siCnStEvnt
2.21     sit_x_001.main_54  rkumar    1. Added control flag for ISUP Kazakhstan
2.21     sit_x_001.main_55  rkumar    1. Removed SIT_PARAMETER flag for calling
                                         party number
2.21     sit_x_001.main_56  rkumar    1. Corrected SI_ANSILNP flag usage
2.21     sit_x_001.main_57  ckumar    1. Added Tariff Zone number structure member
                                         in connection status event and deleted 
                                         SS7_KZ flag in Billing Zone number.
                                      2. Deleted Call reference in connection 
                                         status event structure.
2.21     sit_x_001.main_58  ckumar    1. Deleted RemotOper1 and ServiceAct2 for
                                         China variant.
                                      3. Corrected Comments to Location number
                                         in ISUP Connect Event Structure.
2.21     sit_x_001.main_59  ckumar    1. Added new cause diagnostic parameter to 
                                         support calling party number check feature
                                         in Connection event, connection status
                                         event. 
                                      2. Deleted connection request not required by
                                         UK variant in connection status event
2.21     sit_x_001.main_60  ckumar    1. Added extended video telephony characteristics
                                         id token in User teleservice information.
2.21     sit_x_001.main_61  kchaitanya 1. Moved causeDgnCgPnChk in siCnStEvnt, to make 
                                          the Calling party number check enum feature 
                                          work properly.
2.21     sit_x_001.main_62 rkumar      1. Modified to fix "CC" compilation warns
                                       2. Correct the order of tokens as per spec for 
                                          MLPP Precedence parameter
                                       3. Deleted the second occurrence of calling party
                                          number and calling party category from siPduINF
                                          to prevent duplication in outgoing message
2.21     sit_x_001.main_63 kchaitanya 1. Modified structures and added control 
                                         flag for Brazilian ISUP
                                      2. Modified the datatype for encapAppInfo in 
                                         SiAppTransParam
                                      3. Deleted connReqUK from siPduINF to sync with db
                                      4. Added addInfLyr3ProtA, addInfLyr3ProtB in 
                                         SiUsrServInfo
2.21     sit_x_001.main_64 kchaitanya 1. Modified structures and added control 
                                         flag for Ukraine ISUP
2.21     sit_x_001.main_65 kchaitanya 1. Added extension info in SiNumPortFwdInfo.
2.21     sit_x_001.main_66 rk         1. corrected order of numplan and oddEven3 in 
                                         forwardGVNS. 
*********************************************************************91*/
