/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     isup layer
  
     Type:     C include file
  
     Desc:     Defines required by the isup layer service user.
  
     File:     sit.h
  
     Sid:      sit.h@@/main/50 - Thu Jun  3 13:54:16 2010
     
     Prg:      na
  
*********************************************************************21*/

#ifndef __SITH__
#define __SITH__


/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000029      SS7 - ISUP
*
*/

/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.             description
*     --------     ----------------------------------------------
*
*/


/* sit_h_001.main_43 */

/* defines */

/*  ADDED: introduce the interface version number */
#ifdef SITV1
#ifdef SITIFVER
#undef SITIFVER
#endif
#define SITIFVER 0x0100
#endif /* SITV1 */

/*  ADDED: introduce the interface version number */
#ifdef SITV2
#ifdef SITIFVER
#undef SITIFVER
#endif
#define SITIFVER 0x0200
#endif /* SITV2 */

/* if SITV1 or SITV2 is not enabled, defined SITIFVER as base version
 * 0x0100.
 */
#ifndef SITIFVER
#define SITIFVER 0x0100
#endif

#define SIT_MF_MAX_REPELMT    2

/* messages */

#define SI_CONREQ         (NMB_IMSG + 0)   /*  */
#define SI_CONRSP         (NMB_IMSG + 1)   /*  */
#define SI_CNSTREQ        (NMB_IMSG + 2)   /*  */
#define SI_RELREQ         (NMB_IMSG + 3)   /*  */
#define SI_RELRSP         (NMB_IMSG + 4)   /*  */
#define SI_INFREQ         (NMB_IMSG + 5)   /*  */
#define SI_SUSPREQ        (NMB_IMSG + 6)   /*  */
#define SI_RESREQ         (NMB_IMSG + 7)   /*  */
#define SI_FACREQ         (NMB_IMSG + 8)   /*  */
#define SI_FACRSP         (NMB_IMSG + 9)   /*  */
#define SI_STAREQ         (NMB_IMSG + 10)  /*  */
#define SI_FTZREQ         (NMB_IMSG + 11)  /*  */

#define SI_OLMREQ         (NMB_IMSG + 12)  /*  */

/* events for Connect Status Indication */

#define ADDRCMPLT         0     /* address complete */
#define MODIFY            1     /* modify */
#define MODCMPLT          2     /* modify complete */
#define MODREJ            3     /* modify reject */
#define PROGRESS          4     /* progress */
#define FRWDTRSFR         5     /* forward transfer */
#define INFORMATION       6     /* information */
#define INFORMATREQ       7     /* information request */
#define SUBSADDR          8     /* subsequent address */
#define EXIT              9     /* exit */
#define NETRESMGT         10    /* network resource management  */
#define IDENTREQ          11    /* identification request  */
#define IDENTRSP          12    /* identification response  */
#define MALCLLPRNT        13    /* Malicious call print  */
#define CHARGE            14    /* Charge Info  */
#define TRFFCHGE          15    /* Tariff Change  */
#define CHARGEACK         16    /* Charge Acknowledge  */
#define CALLOFFMSG        17    /* Call Offering  */
#define LOOPPRVNT         18    /* Loop Prevention  */
#define TECT_TIMEOUT      19    /* ECT timer has timed out */
#define GT_CHARGING       20    /* GT_FTZ charging message */
#define GT_CHAREXTD       21    /* GT_FTZ charging extended message */
#define GT_CHAREXTDA      22    /* GT_FTZ charging extended acknowledge msg */
#define RINGSEND          23    /* Ringing send */
#define CALLCLEAR         24    /* Call line clear */
#define CHGNTT            26    /* Charge message for NTT */
#define PRERELEASE        27    /* pre release information */
#define APPTRANSPORT      28    /* application transport message */
#define OPERATOR          29    /* operator message */
#define METPULSE          30    /* metering pulse message */
#define CLGPTCLR          31    /* calling party clear message */
#define SUBDIRNUM         32    /* subsequent directory number */
#ifdef SANGOMA_SPIROU
#define CHARGE_UNIT       33    /* charge unit */
#define CHARGE_ACK        34    /* charge ack */
#endif

/* events for FTZ utilities Indication */

#define GT_FACINF         0     /* Facility information message */
#define GT_EHZA           1     /* Hang up indication of A-Tln message */
#define GT_USRINF         2     /* User information message */
#define GT_NANA           3     /* National  message */

/* selector values for GT_FTZ national parameter FF */

#define EVTGTNANA         0     /* national parameter FF in NANA */
#define EVTGTIAM          1     /* national parameter FF in IAM  */
#define EVTGTANM          2     /* national parameter FF in ANM  */
#define EVTGTFRQ          3     /* national parameter FF in FRQ  */
#define EVTGTMLTP         4     /* national parameter FF in FACD/FRJ/CHG/FIN */
#define EVTGTFACD         5     /* national parameter FF in FACD */
#define EVTGTFRJ          6     /* national parameter FF in FRJ  */
#define EVTGTCHG          7     /* national parameter FF in CHG  */
#define EVTGTFIN          8     /* national parameter FF in FIN  */

/* events for upper interface primitives */

#define EVTSITBNDREQ      0x04  /* Bind request */

#define EVTSITCONREQ      0x0C  /* Connct request */      
#define EVTSITCONCFM      0x0D  /* Connct confirm */      
#define EVTSITCONRSP      0x0F  /* Connect response */      
#define EVTSITCONIND      0x0E  /* Connect indication */
      
#define EVTSITCNSTREQ     0x58  /* Connection progress status request */      
#define EVTSITCNSTIND     0x5A  /* Connection progress status indication */
      
#define EVTSITDATREQ      0x14  /* Data request */     
#define EVTSITDATIND      0x16  /* Data indication */  
   
#define EVTSITFACREQ      0x68  /* Call facility request */     
#define EVTSITFACIND      0x6A  /* Call facility indication */     
#define EVTSITFACRSP      0x6B  /* Call facility response */   
#define EVTSITFACCFM      0x69  /* Call facility confirm */
     
#define EVTSITRELREQ      0x5C  /* Connection release request */    
#define EVTSITRELRSP      0x5F  /* Connection release response */   
#define EVTSITRELIND      0x5E  /* Connection release indication */ 
#define EVTSITRELCFM      0x5D  /* Connection release confirmation */      

#define EVTSITSUSPREQ     0x38  /* Call suspend request */      
#define EVTSITSUSPIND     0x3A  /* Call suspend indication */      

#define EVTSITRESMREQ     0x34  /* Call resume request */      
#define EVTSITRESMIND     0x36  /* Call resume indication */    
  
#define EVTSITSTAREQ      0x78  /* Status request */     
#define EVTSITSTAIND      0x7A  /* Status indication */      

#define EVTSITFTZREQ      0x7B  /* FTZ utilities request */     
#define EVTSITFTZIND      0x7C  /* FTZ utilities indication */      
#define EVTSITUMSGREQ     0x7D  /* Unrecognized event */
#define EVTSITUMSGIND     0x7E  /* Unrecognized event */

#define EVTSITBNDCFM      0x7F  /* Bind confirmation */
#define EVTSITPTCDESTAREQ 0x80  /* Point code status request */
#define EVTSITPTCDESTACFM 0x81  /* Point code status confirmation */

#define EVTSITOLMREQ      0x82  /* OVERLOAD Message Request */

/* Automatic Congestion Level Defines */

#define ACLVL_LVL1         0x01
#define ACLVL_LVL2         0x02
#define ACLVL_LVL3         0x03

/* Charge Indicator Defines */

#define CHRG_NOIND         0x00
#define CHRG_NOCHRG        0x01
#define CHRG_CHRG          0x02
#define CHRG_SPARE         0x03

/* Type of exchanges */
#define TOXUNKNOWN         0x00    /* unknown type of exchange */
#define TOXA               0x01    /* exchange type - A */
#define TOXB               0x02    /* exchange type - B */
#define TOXA_BRNBAND       0x05    /* exchange type A with braod-narrowband
                                    * interworking */
/* Type of calls */

#define TOC_LOCAL          0x01
#define TOC_SPECSRV        0x02
#define TOC_OPASSTTRK      0x03
#define TOC_OPASSTINT      0x04
#define TOC_STD            0x05
#define TOC_ITD            0x06
#define TOC_SUPSRVCL       0x07

/* charging method */

#define CM_FLATRTE         0x00
#define CM_MSGRTE          0x01
#define CM_MSRDRTE         0x02
#define CM_VOLRTE          0x03

/* chargeable party */

#define CP_CLLGPTY         0x01
#define CP_CLLDPTY         0x02
#define CP_THRDPTY         0x03

/* charge point */

#define CPT_INTLGWYEX      0x01
#define CPT_TRNKEX         0x02
#define CPT_TNDMEX         0x03
#define CPT_LOCLEX         0x04
#define CPT_PSDN           0x05
#define CPT_CSDN           0x06
#define CPT_CTRLDBSE       0x07

/* tariff category */

#define TCAT_STDTIME       0x01
#define TCAT_DSCTTIME      0x02
#define TCAT_ECONTIME      0x03
#define TCAT_WKDTIME       0x04
#define TCAT_HLDYTIME      0x05

/* tariff Unit */

#define TU_10C             0x01
#define TU_20C             0x02
#define TU_30C             0x03
#define TU_40C             0x04
#define TU_50C             0x05
#define TU_150C            0x0f

/* tariff factor */

#define TF_001             0x01
#define TF_01              0x02
#define TF_02              0x03
#define TF_05              0x04
#define TF_1               0x05
#define TF_10              0x0f

/* trunk offering information */

#define TOFF_SUCCESS       0x00
#define TOFF_NOTALLWD      0x01

/* Called Party's Status Defines  */

#define CADSTAT_NOIND      0x00
#define CADSTAT_SUBFREE    0x01
#define CADSTAT_CONNFREE   0x02
#define CADSTAT_DELAY      0x03

/* Called Party's Category Defines */

#define CADCAT_NOIND       0x00
#define CADCAT_ORDSUBS     0x01
#define CADCAT_PAYPHONE    0x02

/* End to end method indicator defines */

#define E2EMTH_NOMETH      0x00
#define E2EMTH_PASSALNG    0x01
#define E2EMTH_SCCPMTH     0x02
#define E2EMTH_BOTH        0x03

/* Interworking Indicator */

#define INTIND_NOINTW      0x00
#define INTIND_INTW        0x01

/* Precedence level */

#define PL_FLASHORD        0x00
#define PL_FLASH           0x01
#define PL_IMMDT           0x02
#define PL_PRIOR           0x03
#define PL_ROUTINE         0x04

/* LFB */

#define LFB_ALLWD          0x00
#define LFB_PTHRSRVD       0x01
#define LFB_NOTALLWD       0x02
/* End to end Information Indicator */

#define E2EINF_NOINFO      0x00
#define E2EINF_INFO        0x01

/* ISDN User Part Indicator */

#define ISUP_NOTUSED       0x00
#define ISUP_USED          0x01

/* Reverse Charge Indicator */
#define NOTREVCHRG         0x00
#define REVCHRGCALL        0x01

#define RESV_NAT_ZERO      0x00
#define RESV_NAT_ONE       0x01

/* IN Call Indicator */
#define NOTINCALL          0x00
#define INCALL             0x01

/* Holding Indicator */

#define HOLD_NOTREQD       0x00
#define HOLD_REQD          0x01

/* MCID request Indicator */

#define MCID_NOTREQD       0x00
#define MCID_REQD          0x01

/* MCID response Indicator */

#define MCID_NOTINCLDD     0x00
#define MCID_INCLDD        0x01

/* ISDN Access Indicator */

#define ISDNACC_NONISDN    0x00
#define ISDNACC_ISDN       0x01

/* Protocol profile  */

#define PP_REMOPPROT       0x11

/* Echo Control device indicator */

#define ECHOCDEV_NOTINCL   0x00
#define ECHOCDEV_INCL      0x01

/* Number qualifier indicator */
/*  Addition. Added reserved value according to ITU92.
 */
#define NQ_RESERVZERO      0x00
#define NQ_RESERVTWO       0x02
#define NQ_RESERVTHREE     0x03
#define NQ_RESERVFOUR      0x04

#define NQ_ADDCDMNB        0x01
#define NQ_ADDCONMNB       0x05
#define NQ_ADDCGNMB        0x06
#define NQ_ORIGCDNMB       0x07
#define NQ_ORIGRGDNMB      0x08
#define NQ_ORIGRDNMB       0x09
#define NQ_FREEPHNMB       0x0a
#define NQ_INSRVCNMB	   0xfe

/*  Added UK Specific defines */
#define NQ_UKSPCFNMB  0xfe
#define NQ_INTRCPLINEID 0xfd
/* Address Presentation Restricted indicator */
#define PRSNT_ALLOW     0       
#define PRSNT_RESTRIC   1       

/* CLI Blocking INdicator */

#define NUMB_NOTDISC	0
#define NUMB_MAYDISC	1

/* Network translated address indicator */

#define NO_INF	0
#define NWTRANS_CDADDR	1

/* Priority access indicator (IUP) */
#define PRIORACCSCALL_IUP 	1

/* Protection indicator (IUP) */
#define PROTCALL_IUP 	1

/* RCI � Routing Control Indicator */
#define ALTROUTE_CONTRETRY	 		0x0
#define NOALTROUTE_CONTRETRY    		0x1
#define ALTROUTE_NOCONTRETRY			0x2
#define NOALTROUTE_NOCONTRETRY		0x3
#define ALTROUTEONCE_CONTRETRY		0x4
#define  ALTROUTEONCE_NOCONTRETRY	0x5

/* Presentation Number Preference indicator (PNP) */

#define RSVD_PREVVERSION	0
#define PN_PREFMAP_ISDN      1

/* Admin./Maintenance Call Barring Indicator */
#define INC_ADMNMAINTCALLS_BAR 	1

/* Subscriber Controlled Incoming Calls Barred (ICB) Indicator */
#define SUBCTRLD_ICBACTIVE		1

/* Pre-arranged ICB Indicator */
#define PREARNGD_ICBACTIVE		1

/* Permanent ICB Indicator */
#define PERM_ICBACTIVE		1

/* Temporary Out of Service (TOS) Indicator */
#define TOS_ACTIVE	1

/* ICB Except for Operator Indicator */
#define ICB_EXCPOPER_ACTIVE 	1

/* Called Subscriber Facility Information Indicator */
#define CDFACINF_AVAIL	1

/* Calling Subscriber Facility Information Indicator */
#define CGFACINF_AVAIL  1

/* Permanent Outgoing Calls Barred (OCB) Indicator */
#define PERM_OCBACTIVE 	1

/* Outgoing Local Calls Barred Indicator */
#define OUT_LOCALCALLS_BARRED		1

/* Outgoing National Calls Barred Indicator */
#define OUT_NATCALLS_BARRED	1

/* Outgoing International Calls Barred Indicator */
#define OUT_INTCALLS_BARRED	1

/* Operator Calls Barred Indicator */
#define CALLSTO_OPR_BARRED	1

/* Supplementary Facility Calls Barred Indicator */
#define SUPPFAC_CALLS_BARRED	1

/* Digit Masking Indicator */
#define DIGMASK_REQD	1

/* Calls to Premium-phones Barred Indicator */
#define CALLSTO_PREMPH_BARRED	1

/* Operator Indicator */
#define OPRINV_CALLSETUP	1

/* Disabled Subscriber Indicator */
#define DIALLED_SUB 	1

/* Attended Call Office Indicator */
#define RSVD_ATNDCALLOFC	1

/* Advise Duration and Charge (AD&C) Indicator */
#define ADC_REQD 	1

/* PBX Subscriber Indicator */
#define PBX_SUBCTRLD 	1

/* SVI Indicator */
#define SVI_ACTIVE 	1

/* CNI Indicator */
#define CNI_ACTIVE 	1

/* PBX Night Interception Indicator */
#define PBX_INTCPT_ACTIVE	1

/* Call Waiting Indicator */
#define CALL_WAITING_ACTIVE 	1

/* Fixed Destination Service Indicator */
#define FIXD_DSTSRVC_ACTIVE 	1


/*Calling Subscriber's Basic Service Marks request indicator */

#define CGMRKS_NTREQ		0
#define CGMRKS_REQ			1

/* Called Subscriber�s Basic Service Marks request indicator */ 

#define CDMRKS_NTREQ		0
#define CDMRKS_REQ			1

/* Calling Subscriber's Originating Facility Marks request indicator */

#define CSOFMRKS_NTREQ		0
#define CSOFMRKS_REQ		1

/* Called Subscriber's Terminating Facility Marks request indicator */

#define CSTFMRKS_NTREQ		0
#define CSTFMRKS_REQ		1

/* Intercepted Line Identity request indicator */

#define INTLINEID_NTREQ		0
#define INTLINEID_REQ		1

/* Intercepted Line Identity and Called Subscriber's Basic Service Marks 
    request indicator */

#define LINEID_CSBS_NTREQ	0
#define LINEID_CSBS_REQ		1

/* Calling Subscriber's Basic Service Marks response indicator */
#define CGMRKS_NTINCLD		0
#define CGMRS_INCLD			1

/* Called Subscriber�s Basic Service Marks response indicator */
#define CDMRKS_NTINCLD		0
#define CDMRKS_INCLD		1

/* Calling Subscriber's Originating Facility Marks response indicator */
#define CDORIG_NTINCLD		0
#define CDORIG_INCLD		1

/* Called Subscriber's Terminating Facility Marks response indicator */
#define CDTERMFAC_NTINCLD 	0
#define CDTERMFAC_INCLD	1

/*  Intercepted Line Identity response indicator */
#define LINEID_NTINCLD	0
#define LINEID_INCLD	1

/* Intercepted Line Identity and Called Subscriber's Basic Service Marks response indicator */
#define LINEID_CSBS_NTINCLD 	0
#define LINEID_CSBS_INCLD		1
    
/* Echo Control device 1 indicator */

#define ECHCDEV_NOINFOINCL  0x00
#define ECHCDEV_NOTINCL     0x01
#define ECHCDEV_INCL        0x02
#define ECHDEV_AVAILNOTINCL 0x03

/* SCCP Method Indicator */

#define SCCPMTH_NOIND      0x00
#define SCCPMTH_CONLESS    0x01
#define SCCPMTH_CONORNTD   0x02
#define SCCPMTH_BOTH       0x03

/* Modification Indicator */

#define MOD_SERV1          0x01
#define MOD_SERV2          0x02

/* Notification Subscribtion Option */

#define PRES_UNKNOWN       0x00
#define PRES_NOTALLOW      0x01
#define PRES_ALLOWWREDNUM  0x02
#define PRES_ALLOW         0x03

/* Nature of Address indicator */
#define NA_NONE            0x00 /* spare - no interpretation */
#define NA_SUBSNUM         0x01 /* subscriber number */
#define NA_UNKNOWN         0x02 /* unknown */
#define NA_NATNUM          0x03 /* national (significant) number */
#define NA_INTNATNUM       0x04 /* international number */
/*** ITU97 and ETSIV3 defines ***/
#define NA_NETSPNUM        0x05 /* network-specific number (national use) */
/**** ANSI specific defines ******/
#define NA_ABBREVNUM       0x06 /* abbreviated number - ANSI92 */
#define NA_NETNUMNAT       0x07 /* net routing number national format */
#define NA_NETNUMINT       0x08 /* net routing number international format */
#define NA_SUBSNUMOPRREQ   0x71 /* subscriber number, operator requested */
#define NA_NATNUMOPRREQ    0x72 /* national number, operator requested */
#define NA_INTNATNUMOPRREQ 0x73 /* international number, operator requested */
#define NA_NONUMOPRREQ     0x74 /* no number present, operator requested */
#define NA_NONUMCUTTHRU    0x75 /* no num. prsnt, cut-thru' call to carrier */
#define NA_CALL950         0x76 /* 950+ call */
#define NA_TSTLINETSTCODE  0x77 /* test line test code */

#define NA_NONUNIQSUBSNUM  0x71 /* non-unique subscriber number */
#define NA_NONUNIQNATNUM   0x73 /* non-unique national (significant) number */
#define NA_NONUNIQINTLNUM  0x74 /* non-unique international number */

/* Added UK Specific defines */
#define NA_UKSPCFCADDR 0x7e


/* sit_h_001.main_49:Added Ukraine Specific defines */
#define INTCALSUBADDRNOPRSNT 0x06   /* international call, 
                                       calling subscriber address not present */

#define NATNUMALTNW       0x73      /* national number with service of a choice
                                       of an alternative network */
#define INTNATNUMALTNW    0x74      /* international number with service of a
                                       choice of an alternative network */

#define BCDMA             0x7a      /* B-CDMA */
#define IMT2000           0x7b      /* IMT-2000 */
#define NMT450            0x7c      /* IMT-2000 */
#define CDMAIS95          0x7d      /* CDMA IS-95 */
#define GSM               0x7e      /* GSM */

/* Nature of address indicators for charge number (ANSI) */
#define ANI_CGPTYSUBNUM    0x01  /* ANI of the calling party; subsciber num. */
#define ANI_NOTAVAIL       0x02  /* ANI not available or not provided        */
#define ANI_CGPTYNATNUM    0x03  /* ANI of the calling party; national num.  */
#define ANI_CDPTYSUBNUM    0x05  /* ANI of the called party; subscriber num  */
#define ANI_CDPTYNONUM     0x06  /* ANI of the called party; no num. present */
#define ANI_NATNUM         0x07  /* ANI of the called party; national number */

/* OLD HASHDEFS - PROVIDED FOR SMOOTH MIGRATION. WILL BE OBSOLETED IN FUTURE */
#define UNKNOWN            0x02  /* unknown */
/* Nature of Address indicator defines for ANSI */
#define SUBSNUMOPREQ       0x71  /* subscriber number, operator requested */
#define NATNUMOPREQ        0x72  /* national number, operator requested */
#define INTNATNUMOPREQ     0x73  /* international number, operator requested */
#define NONUMPRESOPREQ     0x74  /* no number present, operator requested */
#define NONUMPRESCUTTHRU   0x75  /* no num. prsnt, cut-thru' call to carrier */
#define TSTLINETSTCODE     0x77  /* test line test code */
/* defines for ANSI 92 */
#define CALL950            0x76  /* 950+ call */
#define ABBREVNUM          0x06  /* abbreviated number */

/* Numbering Plan Defines */

#define SIT_NP_UNK             0x00  /* number not present - np set to zero */
#define ISDNNUM            0x01  /* ISDN numbering plan (CCITT E.164) */
#define DATANUM            0x03
#define TELEXNUM           0x04

/* defines for ANSI */

#define UNKNOWNPLAN        0x00  /* unknown plan */
#define TELEPNUMPLAN       0x02  /* telephony numbering plan (CCITT E.163) */

/* defines for ANSI 92 */
#define PRIVATENUMPLAN     0x05  /* private numbering pan */

/* sit_h_001.main_49: Added defines for Ukraine */
/* defines for Ukraine */
#define PUBLNDMBILENET     0x06  /* public land mobile network*/
/* Internal Network Number */

#define INN_ALLOW          0x00
#define INN_NOTALLOW       0x01

#define ADDRDIGTS0         0x00
#define ADDRDIGTS1         0x01
#define ADDRDIGTS2         0x02
#define ADDRDIGTS3         0x03
#define ADDRDIGTS4         0x04
#define ADDRDIGTS5         0x05
#define ADDRDIGTS6         0x06
#define ADDRDIGTS7         0x07
#define ADDRDIGTS8         0x08
#define ADDRDIGTS9         0x09
#define ADDRDIGTSST        0x0f

/*** ETSIV3 defines ***/
/* CCNR possible indicators */
#define CCNRNOTPOSS        0x00
#define CCNRPOSS           0x01

/* Application context identifier */
#define UCEH                 0x00
#define PSS1ASE_VPN          0x01
#define CHARGE_ASE           0x03
#define GAT                  0x04
#define BAT_ASE              0x05
#define EUCEH_ASE            0x06
/*  Added UK Specific defines */
/* Legacy Operator Services*/
#define ACI_OPR_SERVICES	0x7d 

/* Reserved for intra network use (BT)*/
#define ACI_INTRA_USE           0x7e

/* Reserved for Manufacturer Specific Applications (Nortel)*/
#define ACI_RSVD_NORTEL       0x7c
/* Reserved for Manufacturer Specific Applications (Ericsson) */
#define ACI_RSVD_ERICSSON   0x7b

/* spare value used by APM 98 application */
#define ACI_SPARE_APM98     0x02

/* ATII - release/notify call ind */
#define ATII_NOREL_NONOTIF  0x00
#define ATII_REL_NONOTIF    0x01
#define ATII_NOREL_NOTIF    0x02
#define ATII_REL_NOTIF      0x03
/* sequence indicator */
#define SUBSEGTOFIRSTSEG    0x00
#define NEWSEQUENCE         0x01

/* Odd - Even Indicator */
#define NMB_EVEN           0
#define NMB_ODD            1

/* Calling party number incomplete indicator */
 
#define NMB_COMPLTE        0
#define NMB_INCOMPLTE      1

/* Screen Indicator Defines */

#define USRPROVNOTVER      0x00
#define USRPROV            0x01
#define USRPROVVERFAIL     0x02
#define NETPROV            0x03

/* Presentation Restriction Defines */
#define ADDRNOAVAIL        0x02
#define PRESNEWRES         0x03

/* number incomplete indicator */

#define NBMCMLTE           0x00
#define NBMINCMLTE         0x01

/* Calling Party Categories */

#define CAT_UNKNOWN        0x00
#define CAT_OPLANGFR       0x01
#define CAT_OPLANGENG      0x02
#define CAT_OPLANGGER      0x03
#define CAT_OPLANGRUS      0x04
#define CAT_OPLANGSP       0x05
#define CAT_ADMIN1         0x06
#define CAT_ADMIN2         0x07
#define CAT_ADMIN3         0x08
#define CAT_ORD            0x0a
#define CAT_PRIOR          0x0b
#define CAT_DATA           0x0c
#define CAT_TEST           0x0d
#define CAT_PAYPHONE       0x0f
#define CAT_ONI            0xfa /* operator number identification */

/* Added UK Specific defines */
/* SS7_UK : Calling party category */

#define CAT_NATOPER		0x09	/* National Operator */
#define CAT_PAYPHPRIORITY 	0xfa  	/* Admin. Diversion - Payphone with priority*/
#define CAT_ORDPRIORITY 	0xfb     	/* Admin. Diversion - Ordinary with priority */
#define CAT_OPOSS			0xfc 	/* OSS Operator */
#define CAT_PAYPH			0xfd 	/*Admin. Diversion - Payphone*/
#define CAT_ORDINARY		0xfe 	/* Admin. Diversion - Ordinary */

/* sit_h_001.main_48: Added values for Brazilian variant */

#define CAT_SUBSPECBILLG   0xe0      /* subscriber with special billing */
#define CAT_LDPAYPHONE     0xe2      /* long distance pay-phone */

/* sit_h_001.main_48: Adding values for Brazilian variant */
#define TEL_NETW_SERV1     0xf7      /* Used for telecom network service */
#define TEL_NETW_SERV2     0xf8      /* Used for telecom network service */
#define TEL_NETW_SERV3     0xf9      /* Used for telecom network service */
#define TEL_NETW_SERV4     0xfb      /* Used for telecom network service */
#define TEL_NETW_SERV5     0xfd      /* Used for telecom network service */
#define TEL_NETW_SERV6     0xfe      /* Used for telecom network service */

/* defines for ANSI */

#define CAT_PRECLVL2       0xfa
#define CAT_PRECLVL3       0xfb
#define CAT_PRECLVL4       0xfc
#define CAT_PRECLVL5       0xfd

#define CAT_OPNATL         0x09
#define CAT_EMERGCY        0xe0
#define CAT_HIPRIEMRCY     0xe1
#define CAT_NSEP           0xe2

/* defines for Sing Tel */

#define CAT_OPTRKOFF       0x09
#define CAT_OPNOTRKOFF     0xe0
#define CAT_COINAFON       0xe1
#define CAT_LNTSTDSK       0xe2
#define CAT_OPINTRCPT      0xe3
#define CAT_SUBPRVMTR      0xe4
#define CAT_PBX            0xe5
#define CAT_PRIORPBX       0xe6
#define CAT_CTYCNTRX       0xe7
#define CAT_BBGSUB         0xe8

/* Addition - added defines for Indian variant. */ 
/* defines for India variant */

#define CAT_CCBSUB         0xe1
#define CAT_INTRCPTOP      0xe2
#define CAT_SUBWTHMMTR     0xe3
#define CAT_PABX           0xe4
#define CAT_PABXPRIOR      0xe5
#define CAT_LNTSTDESK      0xe6

/* sit_h_001.main_49: Added defines for Ukraine variant */
#define CAT_NATOP          0x09
#define CAT_IEPSQ763       0x0e
#define CAT_MOBTERHOMEPLMN 0x10
#define CAT_MOBTERVISITPLMN 0x11
#define CAT_ANI0           0xe0
#define CAT_HTLSUB         0xe1
#define CAT_ANI5           0xe2
#define CAT_ANI7           0xe3
#define CAT_LCLSUB         0xe4
#define CAT_RESERVE        0xe5
#define CAT_AUTOCALL1      0xf0 
#define CAT_SEMIAUTOCALL1  0xf1
#define CAT_AUTOCALL2      0xf2
#define CAT_SEMIAUTOCALL2  0xf3
#define CAT_AUTOCALL3      0xf4
#define CAT_SEMIAUTOCALL3  0xf5
#define CAT_AUTOCALL4      0xf6
#define CAT_SEMIAUTOCALL4  0xf7

/* Addition - added defines for ITU2000 variant. */ 
/* defines for number portability status  */

#define NP_NOIND           0x00     /* no indication */ 
#define NP_QRYNOTDONE      0x01     /* query not done for called number */
#define NP_QRYDONENONPRD   0x02     /* query done, non-ported subscriber */
#define NP_QRYDONEPRD      0x03     /* query done, ported called subscriber */

/* Pivot possible indicator  */

#define PP_NOIND           0x00     /* no indication */ 
#define PP_BEFOREACM       0x01     /* Routing possible before ACM */
#define PP_BEFOREANM       0x02     /* Routing possible before ANM */
#define PP_ANYTIME         0x03     /* Routing possible any time during call */

/* Pivot possible indicator  */

#define PR_NOIND           0x00     /* no indication */ 
#define PR_PIVOTREQ        0x01     /* pivot request */
#define PR_CANPIVOTREQ     0x02     /* cancel pivot request*/
#define PR_PIVOTREQFAIL    0x03     /* cancel pivot cancel */
#define PR_IWREDIRPROH     0x04     /*Interworking to redirection prohibited */

/* Pivot Status indicator  */

#define PS_NOTUSED         0x00     /* not used */ 
#define PS_ACKPIVOTRRG     0x01     /* acknowledge pivot routing */
#define PS_PIVOTRTGNOTINV  0x02     /* pivot routing not invoked */

/* Redirect Status indicator  */

#define RS_NOTUSED         0x00     /* not used */ 
#define RS_ACKREDIR        0x01     /* acknowledge redirect */
#define RS_REDIRNOTINV     0x02     /* redirect not invoked */

/* type of shape indicator  */

#define TS_ELLPT           0x00     /* ellipsoid point */ 
#define TS_ELLPTUNCRT      0x01     /* ellipsoid point with uncertainty */
#define TS_PTALTUNCRT      0x02     /* point with altitude and uncertainty */
#define TS_ELLONELLPS      0x00     /* allipse on ellipsoid */ 
#define TS_ELLCIRCLE       0x01     /* ellipsoid circuit selector */
#define TS_POLYGON         0x02     /* poligon */

/* defines for GT_FTZ */

#define CAT_NATOPSWTOFF    0x09     /* National operator with switching off 
                                       authorization */

/* defines for Russian */

#define CAT_NATOP       0x09    /* National Operator */
#define CAT_SUBCAT0     0xe0    /* Subscriber Category 0 */
#define CAT_HOTSUB      0xe1    /* Hotel Subscriber */
#define CAT_FREESUB     0xe2    /* Subscriber free of charge */
#define CAT_SPECSUB     0xe3    /* Subscriber with access to special services */
#define CAT_NETSUB      0xe4    /* Local network subscriber */
#define CAT_LOCPAYPHONE 0xe5    /* Local pay phone */
#define CAT_AUTOCALL1   0xf0    /* Automatic call, category I */
#define CAT_SEMIAUTO1   0xf1    /* Semiautomatic call, category I */
#define CAT_AUTOCALL2   0xf2    /* Automatic call, category II */
#define CAT_SEMIAUTO2   0xf3    /* Semiautomatic call, category II */
#define CAT_AUTOCALL3   0xf4    /* Automatic call, category III */
#define CAT_SEMIAUTO3   0xf5    /* Semiautomatic call, category III */
#define CAT_AUTOCALL4   0xf6    /* Automatic call, category IV */
#define CAT_SEMIAUTO4   0xf7    /* Semiautomatic call, category IV */

/* defines for China */
#define CAT_NATOPR	0x09	/* National Operator */
#define CAT_ORDFREE	0xf0	/* Ordinary & Free, used for LS-TS(INTS) */
#define CAT_ORDPERD	0xf1	/* Ordinary & Periodic, used for LS-TS(INTS)  */
#define CAT_ORDMETIMD	0xf2	/* Ordinary & metering immediately, used for LS-TS(INTS) */
#define CAT_ORDPRNIMD	0xf3	/* Ordinary & printer immediately, used for LS-TS(INTS) */
#define CAT_PRIOFREE	0xf4	/* Priority, Free, used for LS-TS(INTS)  */
#define CAT_PRIOUSED	0xf5	/* Priority, periodic, used for LS-TS(INTS) */
#define CAT_ORDSUBS	0xf8	/* Ordinary subscriber, used for LS-LS */
#define CAT_VMINBOX	0xf9	/* Message in Mail box */
#define CAT_VMREM	0xfa	/* Remote voice mail */

#define SIT_NATNUMPLAN     0x06     /* Location number numbering plan */

#define SIT_GSM            0x7e     /* Cell global ID GSM */
#define SIT_NMT900         0x7d     /* Cell global ID NMT900 */
#define SIT_MMT450         0x7c     /* Cell global ID MMT450 */
#define SIT_AUTONET        0x7b     /* Cell global ID AUTONET */

/* recommendation */

#define REC_Q763           0x00     /* CCITT Recommendation Q.763 */
#define SIT_REC_X21            0x03     /* CCITT Recommendation X.21 */
#define SIT_REC_X25            0x04     /* CCITT Recommendation X.25 */
#define REC_Q1000          0x05     /* CCITT Recommendation Q.1000 */

/* coding standards */

#define SIT_CSTD_CCITT         0x00  /* CCITT standards */
#define SIT_CSTD_INT           0x01  /* Reserved for other international 
                                      * standards */
#define SIT_CSTD_NAT           0x02  /* National Standard */
#define CSTD_SPECLOC           0x03  /* Standard Specific to Identified 
                                      *  Location */
#define SIT_CSTD_NET           0x03  /* Standard Specific Network */

/* location */

#define ILOC_USER           0x00  /* user */
#define ILOC_PRIVNETLU      0x01  /* private network serving local user */
#define ILOC_PUBNETLU       0x02  /* public network serving local user */
#define ILOC_TRANNET        0x03  /* transit network */
#define ILOC_PUBNETRU       0x04  /* public network serving the remote user */
#define ILOC_PRIVNETRU      0x05  /* private network serving the remote user */
#define ILOC_LOCALIF        0x06  /* local interface controlled by this link */
#define ILOC_INTNET         0x07  /* international network */
#define ILOC_NETINTER       0x0a  /* network beyond internetworking point */
#define ILOC_NOINFOAV       0x0f  /* no info concerning origin location */

/* Q.850 location values updated */
#define ILOC_PUBNETRUS       0x04  /* public network serving the remote user */
#define ILOC_PRIVNETRUS      0x05  /* private network serving the remote user */

/* cause value */

/* Class 000 and 001 */

#define SIT_CCUNALLOC          1     /* unassigned number */
#define SIT_CCNORTTOTSFNET     2     /* no route to transit network */
#define SIT_CCNORTTODEST       3     /* no route to destination */
#define CCSENDSPCLTONE     4     /* send special infomation tone */
#define CCMISDIALDTRNK     5     /* misdialed trunk prefix */

#define SIT_CCCHUNACC          6     /* Channel Unaccptable */ 
#define SIT_CCCLAWDDELV        7     /* Call Awarded and being delivered in an
                                        established channel */ 
#define SIT_CCCALLCLR          16    /* normal call clearing */
#define SIT_CCUSRBSY           17    /* user busy */
#define SIT_CCNOUSRRSP         18    /* no user response */
#define SIT_CCNOANSWR          19    /* no answer (user alerted ) */
#define SIT_CCCALLRJT          21    /* call rejected */
#define SIT_CCNMBRCHG          22    /* number changed */

/* defines for ANSI92 */
#define CCUNALLDSTNMB      23    /* unallocated destination number */
#define CCUNKNBSNSGRP      24    /* unknown business group */
/* defines for BELLCORE */
#define CCEXCHRTGERR       25    /* exchange routing error */
#define CCMISRTTOPN        26    /*  Misrouted call to a Ported Number */
/* */

#define SIT_CCDESTOUTORD       27    /* destination out of order */
#define CCADDRINCOMP       28    /* Address incomplete */
#define SIT_CCFACREJ           29    /* facility rejected */
#define SIT_CCNORMUNSPEC       31    /* normal unspecified */

/* Class 010 */

#define SIT_CCNOCIRCUIT        34    /* no circuit/channel available */
#define SIT_CCNETAOL           38    /* network out of order */
#define SIT_CCTMPFAIL          41    /* Temporary failure */
#define SIT_CCSWTCHCONG        42    /* Switch equipment congestion */
#define SIT_CCREQUNAVAIL       44    /* requested circuit/channel unavailable */
#define SIT_CCRESCUNAVAIL      47    /* resources unavailable, unspecified */

/* defines for ANSI */

#define CCUSRINFDISCARD    43    /* user information discarded */

/* defines for ANSI92 */
#define CCPREEMPT92        45    /* preemption */
#define CCPRECCALBLKD      46    /* precedence call bloked */
/* */

#define CCPREEMPT          47    /* preemption */

/* Class 011 */

#define SIT_CCFACNOTSUB        50    /* requested facility not subscribed */

/* defines for ANSI92 */
#define CCCALTYPINCSR      51    /* call type incompatible with service 
                                    request */
#define CCCLBKDGRPRST      54    /* call blocked due to group restrictions */
/* */

#define CCINCBARRDCUG      55    /* incoming calls barred within CUG */
#define SIT_CCNOTAUTHBCAP      57    /* bearer capability not authorized */
#define SIT_CCBCAPUNAVAIL      58    /* bearer capability not available */
#define SIT_CCSERVUNAVAIL      63    /* Service or option unavailable */

/* Class 101 */

#define SIT_CCBCAPNOTIMP       65    /* bearer capability not implemented */
#define SIT_CCFACNOTIMP        69    /* requested facility not implemented */
#define SIT_CCRESTDIG          70    /* only restricted digital bear cap is avail*/
#define SIT_CCSERVNOTIMP       79    /* service or option not implemented */

#define CCCUNOTMEMBR       87    /* Called User Not member of CUG */
#define SIT_CCINCOMPDEST       88    /* incompatible destination */
#define SIT_CCINVTRNSTNET      91    /* invalid transit network selection */
#define SIT_CCINVMSG           95    /* invalid message, unspecified */

#define SIT_NOMANDINFO         96   /* Mandatory info element is missing */
#define SIT_NOMSGTYPE          98   /* Message not compatible with call state or
                                     * msg type not existent or not implemented */

/* defines for ANSI */

#define CCINVALCALLREF     81    /* invalid call reference value */

/* Class 110 */

#define SIT_CCNOMSGTYP         97    /* msg type is non-existent or not 
                                    implemented */
#define CCNOPARAMDISC      99    /* Param. non-existant, or not impl., 
                                    discard */
#define CCNOPARAMDISCMSG   110   /* Param. non-existant, or not impl.,
                                    discard message */
#define CCTMRRECOV         102   /* timeout recovery */
#define CCNOPARAMPASS      103   /* Param. non-existant, or not impl. pass 
                                    along */
#define SIT_CCPROTERR          111   /* protocol error, unspecified */

/* defines for ANSI */

#define CCINVALPARAMCONT   100   /* invalid parameter contents */

/* sit_h_001.main_46 : Added cause value defines for result of calling party number
   check feature */
#define CAUSE_CGPN_SUCCESS  104    /* calling party number check result success */
#define CAUSE_CGPN_FAILURE  105    /* calling party number check result failure */

/* Class 111 */

#define SIT_CCINTRWRK          127   /* interworking unspecified */

/* Q.850 cause values */

#define CCQ850PREEMT         8     /* preemption */
#define CCQ850PREECIRVD      9     /* preemption - circuit reserved for 
                                    * reuse */
#define CCSUBSCRABSENT       20    /* subscriber absent */
#define SIT_CCACCINFDISC         43    /* access information discarded */
#define CCPRECCALLBLKD       46    /* precedence call blocked */
#define CCOGBARRDCUG         53    /* outgoing calls barred within CUG */
#define CCINCOGACCSUBCLS     62    /* inconsistency in designated 
                                    * outgoing access information and 
                                    * subscriber class */
#define CCNOTEXISTCUG        90    /* not existent CUG */
#define CCUNRECPARAM         110   /* message with unrecognized parameter,
                                    * discarded */
/* Type Indicator Defines */

#define MAINT              0x00
#define HARDFAIL           0x01

/* defines for ANSI */

#define SOFTWAREGEN        0x02  /* software generated */

/* defines for ANSI 92 */
#define BLOCK_WO_REL       0x00
#define BLOCK_REL          0x01

/* Continuity indicators */

#define CONT_CHKFAIL       0x00
#define CONT_CHKSUCC       0x01

/* Event Indicator Defines */

#define EV_ALERT           0x01
#define EV_PROGRESS        0x02
#define EV_INBAND          0x03
#define EV_FWDONBUSY       0x04
#define EV_FWDONNOREP      0x05
#define EV_FWDUNCONDIT     0x06

#define EV_PRESRESIND      0x00

/* defines for ANSI 92 */
#define EV_NOTSUPPSERV     0x08   /* notification of suppl. services */
#define EV_SRVINFINC       0x6f   /* service information included */


/* Event Presentation Restriction Indicators */

#define EVPR_NOIND         0x00
#define EVPR_PRESRES       0x01

/* Facility Indicators  */

#define FI_USR2USRSERV     0x02

/* defines for GT_FTZ */

#define FI_NOSIGNF         0x00  /* facility indicator has no significance */

/* defines for ANSI */

#define FI_COMPCALLBUSY    0x01  /* completion of calls to busy subscriber */
#define FI_CCBSCONT        0xfd  /* CCBS continue */
#define FI_BUSYFREE        0xfe  /* busy/free status information */

/* national/international call indicators  */

#define CALL_NAT           0x00
#define CALL_INTERNAT      0x01

/* ISDN User Part Preference Indicator Defines */

#define PREF_PREFAW        0x00
#define PREF_NOTREQAW      0x01
#define PREF_REQAW         0x02

/* Calling Party Address Response Indicator defines */

#define CGPRTYADDRESP_NOTINCL    0x00
#define CGPRTYADDRESP_NOTAVAIL   0x01
#define CGPRTYADDRESP_INCL       0x03

/* defines for ANSI */

#define CGPTYADDRSPINCLNOHOLD    0x03
#define CGPTYADDRSPINCLHOLD      0x04

/* Hold provided indicator */

#define HOLD_NOTPROV       0x00
#define HOLD_PROV          0x01

/* Calling Party Category Response Indicator */

#define CGPRTYCATRESP_NOTINCL 0x00
#define CGPRTYCATRESP_INCL    0x01

/* Charge Information reponse Indicator */

#define CHRGINFO_NOTINCL   0x00
#define CHRGINFO_INCL      0x01

/* Soliciated Information  Indicator */

#define SOLINFO_SOLICIT    0x00
#define SOLINFO_UNSOLICIT  0x01

/*** ITU97 defines ***/
/* service activation */
#define CALLTRANSFER       0x01

/* Multi Location Business Group Information Response Indicator */
#define  MLBG_INFOINCL     0x00 
#define  MLBG_INFONOTINCL  0x01

/* Calling Party Address Request Indicator */

#define CGPRTYADDREQ_NOTREQ   0x00 
#define CGPRTYADDREQ_REQ      0x01

/* defines for ANSI */

#define CGPRTYADDREQREQNOHOLD    0x01
#define CGPRTYADDREQREQHOLD      0x03

/* Holding Indicators */

#define HOLD_NOTREQ        0x00 
#define HOLD_REQ           0x01

/* Calling Party Category Request Indicators */

#define CGPRTYCATREQ_NOTREQ  0x00 
#define CGPRTYCATREQ_REQ     0x01

/* Charge Information request Indicator */

#define CHRGINFO_NOTREQ    0x00
#define CHRGINFO_REQ       0x01

/* Charge Information Type for NTT */

#define CHRGINFTYP_NWSPECIFIC  0x00  /* Network specific information */
#define CHRGINFTYP_INTAUTO     0x01  /* International automatic dialling */
#define CHRGINFTYP_FLEXCHRG    0x02  /* Flexible charging */
#define CHRGINFTYP_FLEXINTER   0x03  /* Flexible chrg for intercarrier */
#define CHRGINFTYP_NTTPHS      0x04  /* NTT PHS connection type */
#define CHRGINFTYP_CHRGRATETF  0xfe  /* Charging rate transfer */

/* Charge information indicator */

#define CHRGINFOIDCTR_CHRGPULSE  0x2 /* Charging pulse */

/* Signal Element indicator */

#define  SIGNALELEM_ACTIV        0x2 /* Activation */
#define  SIGNALELEM_SUCCREP      0x3 /* Successful report */

/* Operation class */

#define  OPERCLASS_CLSONE        0x0 /* class 1 */
#define  OPERCLASS_CLSFOUR       0x3 /* class 4 */

/* Operation Type */

#define OPERTYPE_NOTIF     0x4      /* notif of estimated amt  */
#define OPERTYPE_IMMCHRG   0x6      /*  immediate charging */
#define OPERTYPE_WITHALERT 0x7      /* with alert tone  */
#define OPERTYPE_NOALERT   0x8      /* with no alert tone  */
#define OPERTYPE_CHRGPERM  0x1f     /* charging permission  */

/* charged user type */

#define CHRGUSRTYPE_CLLNG  0x00     /* calling party charging */

/* bill collection method type */

#define BILLCOLL_SUBSCHRG  0x0    /* subscriber charge */

/* bill rate indicator */

#define BILLRTE_ENBLOC     0x1    /* enblock + sec/10 yen */
#define BILLRTE_NOMET      0x2    /* no bill / rate info */
#define BILLRTE_SEC10YEN   0x3    /* MBI+ info free rate + nonchrg time */
#define BILLRTE_INFFEEMET  0x4    /* MBI + info fee + non chrg time */
#define BILLRTE_MBI        0x5    /* communication fee MBI */
#define BILLRTE_ENBLOCGENPUB  0x6 /*  enbloc + general and public sec/10yen  */

/* Malicious Call Indentification Request Indicator */

#define MALCAID_NOTREQ     0x00
#define MALCAID_REQ        0x01

/* Multi Location Business Group Information Indicator */
#define MLBG_INFONOTREQ    0x00
#define MLBG_INFOREQ       0x01

/* Continuity Check Indicator */

#define CONTCHK_NOTREQ     0x00
#define CONTCHK_REQ        0x01
#define CONTCHK_PREV       0x02
#define CONTCHK_SPARE      0x03

/* In-band Information Indicator */

#define INBND_NOIND        0x00
#define INBND_AVAIL        0x01

/* Call Forwarding May Occur Indicator */

#define CAFWD_NOIND        0x00
#define CAFWD_MAYOCC       0x01

/* ANS95 define - network excessive delay indicator */
#define NETDEL_NOTIND          0x00
#define NETDEL_ENCOUNTERED     0x01

/* ANS95 define - operator services info - info type */
#define ORIGACCESSPREFIX       0x01
#define BILLTOINFOENTRYTYPE    0x02
#define BILLTOTYPE             0x03
#define BILLTOSPECINFO         0x04
#define SPECIALHAND            0x05
#define ACCESSSIG              0x07

/* ANS95 define - operator services info - information value */
/* for info type 0x01 */
#define VALUNKWN               0x00
#define VAL1OR011              0x01
#define VAL0OR01               0x02
#define VAL0                   0x03
/* for info type 0x02 */
#define ENTRYUNKWN_UNKWN       0x00
#define ENTRYMAN_STATION       0x01
#define ENTRYMAN_PERSON        0x02
#define ENTRYAUTOTONE_STATION  0x03
#define ENTRYUNKWN_STATION     0x04
#define ENTRYUNKWN_PERSON      0x05
#define ENTRYMAN_UNKNWN        0x06
#define ENTRYAUTOTONE_UNKWN    0x07
#define ENTRYAUTOTONE_PERSON   0x08
#define ENTRYAUTOSPO_UNKWN     0x09
#define ENTRYAUTOSPO_STATION   0x0a
#define ENTRYAUDOSPO_PERSON    0x0b
/* for info type 0x03 */
#define BILLTOTYPEUNKWN        0x00
#define CARD_14DIGIT           0x01
#define CARD_89C               0x02
#define CARD_OTHER             0x03
#define BILLTOTYPE_COLLECT     0x04
#define BILLTOTYPE_THIRDPARTY  0x05
#define BILLTOTYPE_SENTPAID    0x06
/* for info type 0x04 */
#define NIDBAUTH               0x01
#define NIDBREP_VERIFYAUTO     0x02
#define NIDBREP_VERIFYOP       0x03
#define NONIDBQUERY            0x04
#define NONIDBRESPONSE         0x05
#define NIDBREP_UNAVAIL        0x06
#define NONIDBRESP_TIMEOUT     0x07
#define NONIDBRESP_REJECTCOMP  0x08
#define NONIDBRESP_ACGEFF      0x09
#define NONIDBRESP_SCCPFAIL    0x0a
/* for info type 0x05 */
#define SPECIAL_UNKWN          0x00
#define CALLCOMP               0x01
#define RATEINFO               0x02
#define TROUBLEREP             0x03
#define TIMEANDCHARGE          0x04
#define CREDITREPORT           0x05
#define GENASSISTANCE          0x06
/* for info type 0x07 */
#define ACCESSSIG_UNKWN        0x00
#define DIAL_PULSE             0x01
#define DUALTONE_MULTIFREQ     0x02

/* Network excessive delay indicator */
#define NETDEL_NOIND           0x00
#define NETDEL_ENCOUNT         0x01

/* User-Network Interaction Indicator */
#define USERNET_NOIND          0x00
#define USERNET_INTERACTOCCUR  0x01

/* Closed User Group Call Indicator */

#define CUG_NONCUG         0x00
#define CUG_ACCALLOW       0x02
#define CUG_ACCNOTALLOW    0x03

/* defines for ANSI */

#define CUG_GRPCALL        0x00
#define CUG_ORDCALL        0x01

/* redirecting indicators */

#define RI_NOREDIR               0x00
#define RI_CALLRERTE             0x01
#define RI_CALLRERTEALLRIPRESRES 0x02
#define RI_CALLFWD               0x03
#define RI_CALLFWDALLRIPRESRES   0x04
#define RI_CARERTEPRESRES        0x05
#define RI_CALLFWDPRESRES        0x06

/* original redirecting reason  */

#define REAS_UNKNWN           0x00
#define REAS_USRBUSY          0x01
#define REAS_NOREPLY          0x02
#define REAS_UNCOND           0x03
#define REAS_DFLCDURALRT      0x04
#define REAS_DFLCIMMDRSP      0x05
#define REAS_MBLSUBNOTRCHBL   0x06

/* defines for ANSI */

#define REAS_FIXED         0x03
#define REAS_VARIABLE      0x04

/* maximum number of redirections */

#define MAX_REDIR          5

/* Suspend/Resume Indicators */

#define SR_ISDNSUBINIT     0x00
#define SR_NETINIT         0x01

/*  MODIFIED: Put the TDS_ROLL_UPGRADE_SUPPORT flag */
#if (defined(SIT_PARAMETER) || defined(TDS_ROLL_UPGRADE_SUPPORT))

#define CALL_IS_WAITING    0x60
#define TRANSF_IN_PROG     0x61
#define CALL_ISL_CONF      0x62
#define CALL_SPLT_CONF     0x63
#define CALL_REATT_CONF    0x64
#define CALL_ADD_CONF      0x65
#define RMT_HOLD           0x79
#define RMT_HLD_RLSD       0x7a
#define CALL_FWD           0x7b

#define USER_SUSP          0x00
#define USER_RESM          0x01
#define BEAR_SEV_CHNG      0x02
#define EXT_ASN1_ENC       0x03
#define CALL_CMPT_DLY      0x04
#define CONF_EST           0x42
#define CONF_DISCON        0x43
#define OTH_PARTY_ADD      0x44
#define ISOLATED           0x45
#define REATTACH           0x46
#define OTH_PARTY_ISL      0x47
#define OTH_PARTY_RATTCH   0x48
#define OTH_PARTY_SPLT     0x49
#define OTH_PARTY_DISCON   0x4a
#define CONF_FLT           0x4b
#define DIVERSION_ACT      0x68
#define CALL_TRSF_ALRT     0x69
#define CALL_TRSF_ACT      0x6a

#endif /* SIT_PARAMETER */

/* Network Identification Plan */

#define NI_UNKNWN          0x00
#define NI_DNIC_X21        0x03
#define NI_MNIC_E212       0x06

/* defines for ANSI92 */
#define NI_3DIGCIC          0x01
#define NI_4DIGCIC          0x02

#if TNS_ANSI
#define CIRCD_UNKNWN        0x00 /* Unspecified Circuit Code */
#define CIRCD_INT_NOOPRREQ  0x01 /* International Call, No operator requested */
#define CIRCD_INT_OPRREQ    0x02 /* International Call, operator requested */
#endif

/* defines for GT_FTZ */

#define NI_DTISNDNET       0x01

/* Network Identification Plan */

#define TNI_CCITT          0x00
#define TNI_NATNET         0x02

/* user information layer 1 */

#define UIL1_CCITTV110     0x01  /* CCITT Stand. Rate Adaptation V.110/X.30. */
#define UIL1_G711ULAW      0x02  /* Reccomendation G.711 u-Law */
#define UIL1_G711ALAW      0x03  /* Recommendation G.711 A-Law */
#define UIL1_G721ADCPM     0x04  /* Recommendation G.721 32 kbit/s ADCPM and */
                                 /* Recommendation I.460 */
#define UIL1_G722G725      0x05  /* Recommendation G.722 and G.725 - 7kHz Audio */
#define UIL1_H261          0x06  /* Recommendation H.261 - 384 kbit/s Video */
#define UIL1_NONCCITT      0x07  /* Non-CCITT  standardized Rate adaptation */
#define UIL1_CCITTV120     0x08  /* CCITT Standardized Rate Adaptation V.120 */
#define UIL1_CCITTX31      0x09  /* CCITT Standardized Rate Adaptation X.31 HDLC */

/* defines for ANSI */

#define UIL1_CCITTI412     0x00  /* CCITT Recommendation I.412 */
#define UIL1_RATEADAPT     0x01  /* Rate Adaptation */

/* layer 1 identity */

#define SIT_L1_IDENT           0x01  /* layer 1 identity */

/* defines for ANSI */

#define L_BEARCAP          0x00  /* bearer capability */
#define L_LAYER1PROT       0x01  /* layer 1 protocol */
#define L_LAYER2PROT       0x02  /* layer 1 protocol */
#define L_LAYER3PROT       0x03  /* layer 1 protocol */


/* user rate */

#define SIT_UR_EINI460         0x00  /* determined by E bits in I.460 */
#define SIT_UR_600             0x01  /* 0.6 kbits, V.6 and X.1 */
#define SIT_UR_1200            0x02  /* 1.2 kbits, V.6 */
#define SIT_UR_2400            0x03  /* 2.4 kbits, V.6 and X.1 */
#define SIT_UR_3600            0x04  /* 3.6 kbits, V.6 */
#define SIT_UR_4800            0x05  /* 4.8 kbits, V.6 and X.1 */
#define SIT_UR_7200            0x06  /* 7.2 kbits, V.6 */
#define SIT_UR_8000            0x07  /* 8.0 kbits, I.460 */
#define SIT_UR_9600            0x08  /* 9.6 kbits, V.6 and X.1 */
#define SIT_UR_14400           0x09  /* 14.4 kbits, V.6 */
#define SIT_UR_16000           0x0a  /* 16 kbits, I.460 */
#define SIT_UR_19200           0x0b  /* 19.2 kbits, V.6 */
#define SIT_UR_32000           0x0c  /* 32 kbits, I.460 */
/* sit_h_001.main_44 : Added define for 38.4 kbits/s */
#define SIT_UR_38400           0x0d  /* 38.4 kbits/s Recommendation V.110 */
#define SIT_UR_48000           0x0e  /* 48 kbits, V.6 and X.1 */
#define SIT_UR_56000           0x0f  /* 56 kbits, V.6 */
#define SIT_UR_64000           0x10  /* 56 kbits, V.6 */
#define SIT_UR_57600           0x12  /* 57.6 kbits, V.14 Extended*/
#define SIT_UR_28800           0x13  /* 28.8 kbits, V.110 */
#define SIT_UR_24000           0x14  /* 24 kbits, V.110*/
#define SIT_UR_134             0x15  /* .1345 kbits, X.1 */
#define SIT_UR_100             0x16  /* .100 kbits, X.1 */
#define SIT_UR_75_1200         0x17  /* .075/1200 kbits, V.6 and X.1 */
#define SIT_UR_1200_75         0x18  /* 1200/.075 kbits, V.6 and X.1 */
#define SIT_UR_50              0x19  /* .050 kbits, V.6 and X.1 */
#define SIT_UR_75              0x1a  /* .075 kbits, V.6 and X.1 */
#define SIT_UR_110             0x1b  /* .110 kbits, V.6 and X.1 */
#define SIT_UR_150             0x1c  /* .150 kbits, V.6 and X.1 */
#define SIT_UR_200             0x1d  /* .200 kbits, V.6 and X.1 */
#define SIT_UR_300             0x1e  /* .300 kbits, V.6 and X.1 */
#define SIT_UR_12000           0x1f  /* 12 kbits, V.6 */

/* flow control on reception */

#define SIT_FLCRX_NOTACC       0x00  /* cannot accept data with flow control */
#define SIT_FLCRX_ACC          0x01  /* can accept data with flow control */

/* flow control on transmission */

#define SIT_FLCTX_NOTREQ       0x00  /* not required to send with flow control */
#define SIT_FLCTX_REQ          0x01  /* required to send with flow control */

/* network independent clock on reception */

#define SIT_NICRX_NOTACC       0x00  /* cannot accept data with nic */
#define SIT_NICRX_ACC          0x01  /* can accept data with nic */

/* network independent clock on transmission */

#define SIT_NICTX_NOTREQ       0x00  /* not required to send with nic */
#define SIT_NICTX_REQ          0x01  /* required to send with nic */

/* rate adaption header/not header */

#define IRAH_INC            0x00  /* included */
#define IRAH_NOTINC         0x01  /* not included */

/* layer 2 identity */

#define SIT_L2_IDENT           0x02  /* layer 2 identity */

/* layer 3 identity */

#define SIT_L3_IDENT           0x03  /* layer 3 identity */

/* defines for ANS95 and ITU97 */
/* circuit assignment map - type */
#define MAPTYPE_DS1      0x01  /* DS1/1544 kbit/s */
#define MAPTYPE_2048     0x02  /* 2048 kbit/s */

/* defines for ANSI */

/* circuit group carrier indicator */

#define CG_UNKNOWN         0x00  /* unknown */
#define CG_ANALOG          0x01  /* analog */
#define CG_DIGITAL         0x02  /* digital */
#define CG_ANALDIG         0x03  /* digital and analog */

/* double seizing control indicator */

#define DS_UNKNOWN         0x00  /* unknown */
#define DS_ODDCIC          0x01  /* odd cic control */
#define DS_EVENCIC         0x02  /* even cic control */

/* defines for ANSI92 */
#define DS_ALLCIC          0x03  /* all cic control */

/* alarm carrier indicator */

#define AC_UNKNOWN         0x00  /* unknown */
#define AC_SOFTCARHAND     0x01  /* software carrier handling */
#define AC_HARDCARHAND     0x02  /* hardware carrier handling */

/* continuity check requirements indicator */

#define CO_UNKNOWN         0x00  /* unknown */
#define CO_NONE            0x01  /* none */
#define CO_STATIS          0x02  /* statistical */
#define CO_PERCALL         0x03  /* per call */

/* circuit validation response indicator */

#define CV_SUCCESS         0x00  /* successful */
#define CV_FAILURE         0x01  /* failure */

/* access indicator */

#define ACCESS_BARRED      0x00  /* access barred */
#define ACCESS_ALLOW       0x01  /* access allowed */

/* divergence indicator */

#define DIVERGENCE         0x00  /* divergence */
#define NO_DIVERGENCE      0x01  /* no divergence */

/* check successful indicator */

#define CHK_UNSUCCESS      0x00  /* check unsuccessful */
#define CHK_SUCCESS        0x01  /* check successful */

/* normal call indicator */

#define NOT_NORMAL_CALL    0x00  /* not a normal call */
#define NORMAL_CALL        0x01  /* normal (non-CUG) call */

/* closed user group call indicator */

#define CUG_CALL              0x01  /* closed user group call */
#define CUG_CALLOUTACCALL     0x02  /* closed user group call - 
                                       outgoing access allowed */
#define CUG_CALLOUTACCNOTALL  0x03  /* closed user group call - outgoing access not allowed */

/* connected address response indicator */

#define CONNADDRNOTINCL    0x00  /* connected address not included */
#define CONNADDRNOTAVAIL   0x01  /* connected address not available */
#define CONNADDRINCL       0x03  /* connected address included */

/* redirecting address response indicator */

#define REDIRGADDRNOTINCL  0x00  /* redirecting address not included */
#define REDIRGADDRNOTAVAIL 0x01  /* redirecting address not available */
#define REDIRGADDRINCL     0x03  /* redirecting address included */

/* index response indicator */

#define INDEXNOTINCL       0x00  /* index not included */
#define INDEXINCL          0x01  /* index included */

/* connected address request indicator */

#define CONNADDRNOTREQ     0x00  /* connected address not requested */
#define CONNADDRREQ        0x01  /* connected address requested */

/* redirecting address request indicator */

#define REDIRADDRNOTREQ     0x00  /* redirecting address not requested */
#define REDIRADDRREQ        0x01  /* redirecting address requested */

/* index request indicator */

#define INDEXNOTREQ         0x00  /* index not requested */
#define INDEXREQ            0x01  /* index requested */

/* CCBS call indicator */

#define NOTCCBSCALL         0x00  /* not a CCBS call */
#define CCBSCALL            0x01  /* CCBS call */

/* calling party number incomplete indicator */

#define CALLGPTYNUMCOMPL    0x00  /* calling party number complete */
#define CALLGPTYNUMINCOMPL  0x01  /* calling party number incomplete */

/* called party free indicator */

#define CDPTY_FREE          0x00  /* called party free */
#define CDPTY_BUSY          0x01  /* called party busy */

/* calling party answer indicator */

#define NOCGPTYANS          0x00  /* no calling party answer */
#define CGPTYANS            0x01  /* calling party answer  */

/* facility request enquiry indicator */

#define NOENQUIRY           0x00  /* no enquiry */
#define FACREQACTENQ        0x01  /* facility request active enquiry */

/* facility request active indicator */

#define FACREQNOTACTIVE     0x00  /* facility request not active */
#define FACREQACTIVE        0x01  /* facility request active */

/* originating line information */

#define OL_IDENTLINE             0x00  /* identified line - no special treatment */
#define OL_ONI                   0x01  /* ONI (multiparty) */
#define OL_ANIFAIL               0x02  /* ANI failure (unavailable) */
#define OL_HOTEL                 0x06  /* hotle (without room identification) */
#define OL_COINLESS              0x07  /* coinless, hospital, inmate, and the like */
#define OL_INTERLATA             0x08  /* interLATA restricted */
#define OL_AIOD                  0x14  /* AIOD - listed DN sent */
#define OL_COINELINE             0x1b  /* coin line */
#define OL_INTERLATA_HOTEL       0x44  /* interLATA restricted - hotel */
#define OL_INTERLATA_COINLESS    0x4e  /* interLATA restricted - coinless, and the like */

#define OL_TEST                  0x0a  /* Test call */
#define OL_NONCOIN               0x17  /* coin or non-coin */
#define OL_800NO                 0x18  /* 800 Call */
/* ADDED: Added new define for Orig Line Info parameter */
#define OL_800FROMPAYSTATION     0x19  /* 800 Call made from paystation */
#define OL_PRISONINMATE    29  /*  prison/inmate service */
#define OL_INTCPT_BLANK    30  /*  intercept blank */
#define OL_INTCPT_TRBLE    31  /*  intercept trouble */
#define OL_INTCPT_REGLR    32  /*  intercept regular */
#define OL_TELCO_OPR       34  /*  telco operator handled call */
#define OL_OUTWATS         52  /*   OUTWATS services */
#define OL_TRS_1           60  /*  TRS */
#define OL_CELULLAR_TYPE1  61  /*  cellular type 1 */
#define OL_CELULLAR_TYPE2  62  /*  cellular type 2 */
#define OL_CELULLAR_ROAM   63  /*  cellular roaming  */
#define OL_TRS_2           66  /*  TRS */
#define OL_TRS_3           67  /*  TRS */
#define OL_PRIV_PAYSTN     70  /*  private paystations */
#define OL_PRIV_VNET       93  /*  access for private virtual n/w serv */

/* symmetry (user service information) */

#define S_BIASM             0x01    /* bidirectional asymetric */
#define S_UNI_ORIGDEST      0x02    /* unidirectional orig -> dest */
#define S_UNI_DESTORIG      0x03    /* unidirectional dest -> orig */

/* layer 2 protocol */

#define UIL2_Q710           0x04

/* Party Selection */

#define PRTY_NOIND          0x00
#define PRTY_CGPTYNUM       0x01
#define PRTY_CDPTYNUM       0x02
#define PRTY_CONNDPTYNUM    0x03
#define PRTY_REDIRGNUM      0x04
#define PRTY_ORIGCALLNUM    0x05

/* Line Priviledges Information Indicator */

#define PRIV_FIXED          0x00
#define PRIV_CUSTDEF        0x01

/* BGID identification indicator */

#define BGID_MULTILOC       0x00
#define BGID_INTERNET       0x01

/* Attendant Status */

#define ATTEN_NOIND         0x00
#define ATTEN_ATTENDLINE    0x01

/* Line Priviledges */

#define LP_RESTRICT              0x00
#define LP_SEMIRESTRICT          0x01
#define LP_FULLRESTRICT          0x02
#define LP_FULLRESTRICT_INSWTCH  0x03
#define LP_DENIED                0x04

/* Carrier Selection Information */

#define CARSEL_NOIND              0x00
#define CARSEL_PRESUB_NOINPUT     0x01
#define CARSEL_PRESUB_INPUT       0x02
#define CARSEL_PRESUB_INPUTUNDET  0x03
#define CARSEL_NOTPRESUB_INPUT    0x04

/* Type Of Address */

#define DIALNUM            0x00
#define DESTNUM            0x01
#define SUPADDR_FAIL       0x02
#define SUPADDR_NOTSCREEN  0x03
#define COMPLNUM           0x04 
#define PORTNUM            0xc0
/* ANS95 define */
#define TRNSFRNUM6         0xf8
#define TRNSFRNUM5         0xf9
#define TRNSFRNUM4         0xfa
#define TRNSFRNUM3         0xfb
#define TRNSFRNUM2         0xfc
#define TRNSFRNUM1         0xfd
#define CESID              0xfe
#define SUPNWADDR_B317     0x05
#define PORTNUM_B317       0xf0

/* Type of Digits */

#define ACCTCODE           0x00
#define AUTHCODE           0x01
#define PRIVNETMARK        0x02
#define BUSCOMMGRID        0x03

/* Bellcore define */
/* ANS95 define - generic digits param */
#define BILLTONUMBER       0x0f

/* Encoding Scheme */

#define ENC_BCD_EVEN       0x00
#define ENC_BCD_ODD        0x01
#define ENC_IA5            0x02
#define ENC_BIN            0x03

#if SS7_Q767IT
#define SEL_VOC            0x01
#define AGG_ARCH           0x02

#define SN_DISP            0x01
#define SN_CIFRE           0x02
#endif

/* Loop Prevention Indicator Response */

#define LPRSP_INSUFFINFO   0x00
#define LPRSP_NOLOOP       0x01
#define LPRSP_SIMTRNSFR    0x02


/* high layer characteristics */

#define SIT_HLCI_TEL       0x01  /* Telephony - Recommendation G.711 */
#define SIT_HLCI_FAXG4     0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define SIT_HLCI_DAPFAXG4  0x21  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.503 */
#define SIT_HLCI_DAPMIXED  0x24  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.501 */
#define SIT_HLCI_DAPPROC   0x28  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.502 */
#define SIT_HLCI_TELETEX   0x31  /* Teletex - Recommendation T.62/T.70 */
#define SIT_HLCI_DAPVIDEO  0x32  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.503 */
#define SIT_HLCI_TELEX     0x35  /* Telex */
#define SIT_HLCI_MHS       0x38  /* Message Handling System */
                             /* Recommendation X.400 */
#define SIT_HLCI_AUDSCR    0x40  /* VN-3 National Audiosritp */
#define SIT_HLCI_OSIAPP    0x41  /* OSI Application - Recommendation X.200 */
#define SIT_HLCI_AUDVID    0x48  /* VN-3 National Audiovideotex */
#define SIT_HLCI_MAINT     0x5e  /* Maintenance */
#define SIT_HLCI_MNGMT     0x5f  /* Management */
#define SIT_HLCI_VIDTEL    0x60  /* Videotelephony F.xyz and AV.242 */
#define SIT_HLCI_RESERVE   0xff  /* Reserved */

/* sit_h_001.main_47 : added defines for video conferencing and 
   Audiographic conferencing recommendations ,multimedia and audio 
   visual services */

#define SIT_HLCI_VIDCONF      0x61  /* Video conferencing recommendation */
#define SIT_HLCI_AUDGRAPH     0x62  /* Audiographic conferencing recommendations */

#define SIT_HLCI_AUDVIDSRV0   0x63  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV1   0x64  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV2   0x65  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV3   0x66  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV4   0x67  /* Audiovisual services F.700 -series */

#define SIT_HLCI_MULMEDSRV    0x68  /* Audiographic conferencing recommendations */

#define SIT_HLCI_AUDVIDSRV5   0x69  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV6   0x6a  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV7   0x6b  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV8   0x6c  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV9   0x6d  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV10  0x6e  /* Audiovisual services F.700 -series */
#define SIT_HLCI_AUDVIDSRV11  0x6f  /* Audiovisual services F.700 -series */

/* extended high layer characteristics */

#define SIT_XHLCI_TEL      0x01  /* Telephony - Recommendation G.711 */
#define SIT_XHLCI_FAXG4    0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define SIT_XHLCI_DAPFAXG4 0x21  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.503 */
#define SIT_XHLCI_DAPMIXED 0x24  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.501 */
#define SIT_XHLCI_DAPPROC  0x28  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.502 */
#define SIT_XHLCI_TELETEX  0x31  /* Teletex - Recommendation T.62/T.70 */
#define SIT_XHLCI_DAPVIDEO 0x32  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.503 */
#define SIT_XHLCI_TELEX    0x35  /* Telex */
#define SIT_XHLCI_MHS      0x38  /* Message Handling System */
                             /* Recommendation X.400 */
#define SIT_XHLCI_OSIAPP   0x41  /* OSI Application - Recommendation X.200 */
#define SIT_XHLCI_MAINT    0x5e  /* Maintenance */
#define SIT_XHLCI_MNGMT    0x5f  /* Management */
#define SIT_XHLCI_VIDTEL   0x60  /* Videotelephony (F.xyz and AV.242) */
#define SIT_XHLCI_RESERVE  0xff  /* Reserved */

/* sit_h_001.main_47 : added defines for video conferencing and
   Audiographic conferencing recommendations ,multimedia and audio
   visual services */

#define SIT_XHLCI_VIDCONF      0x61  /* Video conferencing recommendation */
#define SIT_XHLCI_AUDGRAPH     0x62  /* Audiographic conferencing recommendations */

#define SIT_XHLCI_AUDVIDSRV0   0x63  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV1   0x64  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV2   0x65  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV3   0x66  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV4   0x67  /* Audiovisual services F.700 -series */

#define SIT_XHLCI_MULMEDSRV    0x68  /* Audiographic conferencing recommendations */

#define SIT_XHLCI_AUDVIDSRV5   0x69  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV6   0x6a  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV7   0x6b  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV8   0x6c  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV9   0x6d  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV10  0x6e  /* Audiovisual services F.700 -series */
#define SIT_XHLCI_AUDVIDSRV11  0x6f  /* Audiovisual services F.700 -series */

/* sit_h_001.main_47 : added new defines for extended video telephony
   characteristics identification */

/* extended video telephony characteristics identification */

#define SIT_XVTCI_INITCHANL  0x01  /* Capability set of initial channel of H.221 */
#define SIT_XVTCI_SUBSCHANL  0x02  /* Capability set of subsequent channel 
                                      of H.221 */
#define SIT_XVTCI_INITAUD    0x21  /* Capability set of initial channel with
                                      active 3.1 Khz audio or speech call */

/* presentation method of protocol profile */

#define SIT_PM_VAL1        0x01  /* value 1 */

/* interpretation */ 

#define SIT_INT_FIRST      0x04  /* first high layer characteristics */

/* Pass On Not Possible Indicator */

#define RELCALL        0x00  /* release call */
#define DISCRDMSG      0x01  /* discard message */
#define DISCRDPARAM    0x02  /* discard parameter */

/* Simple segmentation indicator */

#define SSI_NOADDINFO  0x00  /* no additional information will be sent */
#define SSI_ADDSEGM    0x01  /* additional information will be sent in a 
                                segmentation message */

/* MLPP User indicator */

#define MUI_NOIND      0x00  /* no indication */
#define MUI_MLPPUSR    0x01  /* MLPP user */

/* GT_FTZ National parameter for charging information: 
   repetition inf. */

#define GT_NPR_NODATA     0x00  /* no data */
#define GT_NPR_ZONECHGC   0x01  /* zone change conducted */
#define GT_NPR_ZONECHGNC  0x02  /* zone change not conducted */

/* GT_FTZ National Calling Party Category */

#define GT_NCPC_NULL       0x00 /* statement of Nat Clng Party Cat applies */
#define GT_NCPC_ANIS       0x01 /* analog subscriber to ISDN (ANIS) */
#define GT_NCPC_CONIKZ50   0x02 /* connection from IKZ 50 */
#define GT_NCPC_FVSTHAND   0x04 /* conn from remote exch with switching auth.*/
#define GT_NCPC_FEAFD      0x05 /* connection with FEAFD */
#define GT_NCPC_COINTRM    0x07 /* coin terminal */
#define GT_NCPC_IDN        0x08 /* connection from IDN */
#define GT_NCPC_MESSYS80   0x09 /* connection from measuring system 80 */
#define GT_NCPC_ISDNS1TR6  0x0a /* ISDN subscriber 1 TR 6 */
#define GT_NCPC_ISDNSDSS1  0x0b /* ISDN subscriber E-DSS1 */
#define GT_NCPC_EMRGCT80   0x0c /* Emergency Call Telephone 80 */
#define GT_NCPC_FUNDTLN    0x0d /* fuND-Tln */
#define GT_NCPC_FUNDTPR    0x0e /* fuND-Tln with priority */


/* GT_FTZ Service Indicator Octet and Service Indicator 
   Additional Octet(s) */

#define GT_SI_TELEPH       0x01 /* telephony */

/* Additional for Telephony */

#define GT_SIATL_ISDN3K1   0x01 /* ISDN telephony 3.1 kHz */
#define GT_SIATL_ANLG      0x02 /* analog telephony */
#define GT_SIATL_ISDN7K    0x03 /* ISDN telephony 7 kHz */

#define GT_SI_ABSERV       0x02 /* a/b services */

/* Additional for a/b services */
 
#define GT_SIAAB_GR2FAX    0x01 /* group 2 fax */
#define GT_SIAAB_GR3FAX    0x02 /* group 3 fax */
#define GT_SIAAB_MODEM     0x03 /* data via modem */
#define GT_SIAAB_INTVTXTM  0x04 /* interactive videotex via modem */

#define GT_SI_X21SERV      0x03 /* X.21 services */

/* Additional for X.21 services */
 
#define GT_SIAX21_UC4      0x04 /* UC4 */
#define GT_SIAX21_UC5      0x05 /* UC5 */
#define GT_SIAX21_UC6SO    0x06 /* UC6 Service Octet */
#define GT_SIAX21_U19      0x0c /* UC19 (fromerly UC30) */
 
#define GT_SI_GR4FAX       0x04 /* Group 4 telefax */
#define GT_SI_INTRVTXT     0x05 /* Interactive videotex (64 kbit/s) */
#define GT_SI_DATA64K      0x07 /* Data transmission (64 kbit/s) */
#define GT_SI_X25SERV      0x08 /* X.25 services */

/* Additional for X.25 services */
 
#define GT_SIAX25_UC8      0x01 /* UC8 */
#define GT_SIAX25_UC9      0x02 /* UC9 */
#define GT_SIAX25_UC10     0x03 /* UC10 */
#define GT_SIAX25_UC11     0x04 /* UC11 */
#define GT_SIAX25_UC13     0x05 /* UC13 (formerly UC30) */
#define GT_SIAX25_19K2     0x06 /* 19.2 kbit/s */
 
#define GT_SI_TELTX64      0x09 /* teletex 64 */
#define GT_SI_MIXMODE      0x0a /* mixed mode */
#define GT_SI_TELCNTRL     0x0d /* telecontrol */
#define GT_SI_GRAPHTEL     0x0e /* graphic telephone services */
#define GT_SI_INTRVTXTNEW  0x0f /* interactive videotex (new) */
#define GT_SI_VIDPHONE     0x10 /* videophone */

/* Additional for videophone */
 
#define GT_SIAVPH_SND3K1   0x01 /* sound 3.1 kHz */
#define GT_SIAVPH_SND7K    0x02 /* sound 7 kHz */
#define GT_SIAVPH_IMAGE    0x03 /* image */
 

/* GT_FTZ additional cause indicator */

#define GT_ACI_NULL        0x00 /* statement of UBM Cause Indicator applies */
#define GT_ACI_NEGCMPCUG   0x01 /* negative comparison of the CUG */
#define GT_ACI_SBSNMBCHD   0x02 /* subscriber call number changed */
#define GT_ACI_DIRNAVL     0x03 /* direction is not available */
#define GT_ACI_COMPLBLK    0x04 /* complete block */
#define GT_ACI_OVLDZZK     0x06 /* overload in the ZZK-network */
#define GT_ACI_NOUSRRSP    0x09 /* no user responding */
#define GT_ACI_CALLREJ     0x0a /* call rejected */
#define GT_ACI_NOISDNPS    0x0b /* no ISDN-able conn poss in this direction */
#define GT_ACI_INCBLK      0x0c /* incoming block with subscriber called */
#define GT_ACI_USRACCBSY   0x0d /* user access busy */
#define GT_ACI_CMSPVNOPOS  0x0e /* comm relationship as SPV not permitted */

/* GT_FTZ location indicator */

#define GT_LOC_PUBLNETW    0x04 /* public network */
#define GT_LOC_PRIVNETW    0x05 /* private network */
#define GT_LOC_NODTAORGLC  0x0f /* no data on origin location */

/* GT_FTZ coding standard */

#define GT_CS_NATCODST    0x02 /* national coding standard */

/* GT_FTZ facility code */

#define GT_FC_SRVCHG      0x04 /* service change */
#define GT_FC_RETCHG      0x05 /* return change */
#define GT_FC_CLNMBID     0x07 /* call number identification */
#define GT_FC_SPVACT      0x0a /* SPV activate */
#define GT_FC_SPVDEACT    0x0b /* SPV deactivate */

/* GT_FTZ closed user group indicator */

#define GT_CCI_NORMLCON    0x00  /* normal connection */
#define GT_CCI_FWDOUTACC   0x02  /* fwd dir: CUG-conn with outgoing access */
#define GT_CCI_FWDNOTBTLN  0x03  /* fwd dir: outg access not used with B-tln */
#define GT_CCI_BWDUSDBTLN  0x02  /* bwd dir: outg access is used with B-tln */
#define GT_CCI_BWDNOOUTACC 0x03  /* bwd dir: CUG-conn without outgoing access */

/* GT_FTZ closed user group indicator */
 
#define GT_CSFI_DMPOSS      0x01 /* req techn charact possible in principle */
#define GT_CSFI_CONBLTDST   0x02 /* connis built up to destination exchange */
#define GT_CSFI_ATLNCLD     0x03 /* subscriber A called */
#define GT_CSFI_CONFRWD     0x04 /* connection is forwarded */
#define GT_CSFI_CONFWDAWSII 0x05 /* conn will event be forwd corr to AWSII */
#define GT_CSFI_ACMCTLN     0x06 /* received ACM from subs C with AWS II */
#define GT_CSFI_SRVCHNNAL   0x07 /* service channel not allocatable */
#define GT_CSFI_CONBLTINT   0x08 /* conn is built up to the inter exchange */
#define GT_CSFI_TERMCHD     0x09 /* terminal was changed */
#define GT_CSFI_CONFWDNODSY 0x0a /* conn was fwd no display stat at A-Tln=FZE*/

#define GT_CTPH_NPFEVALD    0x00 /* NP FE is valid */
#define GT_CTPH_NORIGHTCTPH 0x01 /* no right to catastrophe */
#define GT_CTPH_RIGHTCTPH   0x02 /* right to catastrophe */
#define GT_CTPH_URIKZVALD   0x03 /* valid IKZ originating */

/* GT_FTZ zoning indicator */

#define GT_UNZONED          0x00 /* IAM unzoned */
#define GT_ZONED            0x01 /* IAM zoned */

/* Broadband-Narrowband interworking indicator for message compatibility */

#define BBNB_PASSON         0x00 /* pass on */
#define BBNB_DSCRDMSG       0x01 /* discard message */
#define BBNB_RLSCALL        0x02 /* release call */

/* Broadband-Narrowband interworking indicator for parameter compatibility */

#define PBBNB_PASSON        0x00 /* pass on */
#define PBBNB_DSCRDMSG      0x01 /* discard message */
#define PBBNB_RLSCALL       0x02 /* release call */
#define PBBNB_DSCRDPAR      0x03 /* discard parameter */

#define PASNTPOSS_DSCRDPAR  0x02

/* defines for Presentation */
/* define for ANS95 */
#define PRESENTALLOW        0x00 /* presentation allowed */
#define PRESENTRESTRIC      0x01 /* presentation restricted */
#define BLKTOGGLE           0x02 /* blocking toggle */
#define NOINDICATION        0x03 /* no indication */

/* defines for Type of name*/
/* define for ANS95 */
#define CALLINGNAME         0x01 /* Calling name */
#define ORIGCALLGNAME       0x02 /* original calling name */
#define REDIRNAME           0x03 /* redirecting name */
#define CONNNAME            0x04 /* connected name */

#define RDRNOTPSBLE         0x00 /* Redirection not possible */
#define RDRPSBLEBFRACM      0x01 /* Redirection possible before ACM */
#define RDRPSBLEBFRANM      0x02 /* Redirection possible before ANM */
#define RDRPSBLEANYTIME     0x03 /* Redirection possible any time */

/* defines for ITU97 */
/* defines for backward GVNS */
#define TERMACCESS_NOINFO     0x00
#define DEDICATEDTERMACCESS 0x01
#define SWITCHEDTERMACCESS  0x02

/* defines for call diversion treatment ind */
#define CALLDIV_NOIND       0x00
#define CALLDIV_ALLOWED     0x01
#define CALLDIV_NOTALLOWED  0x02

/* define for call offering treatment ind */
#define CALLOFF_NOIND       0x00
#define CALLOFF_NOTALLOWED  0x01
#define CALLOFF_ALLOWED     0x02

/* defines for CCSS */
#define CCSS_NOIND          0x00
#define CCSS_CALL           0x01

/* defines for collect call request */
#define COLLECT_NOIND       0x00
#define COLLECT_REQ         0x01

/* defines for conference treatment indicators */
#define CONF_NOIND          0x00
#define ACCEPT_CONFREQ      0x01
#define REJECT_CONFREQ      0x02

/* defines for network management controls - TAR */
#define TAR_NOIND           0x01
#define TAR_CONTROLEDCELL   0x02

/* defines for UID action indicators */
#define THRUCONNINST_NOIND  0x00
#define THRUCONN_BOTHDIR    0x01
/* defines for T9 timer instruction indicator */
#define T9_NOIND            0x00
#define T9_STOP_DONOTSTART  0x01

/* defines for UID capability indicators */
#define THRUCONNINST_NOIND  0x00
#define THRUCONN_MODPOSS    0x01
/* defines for T9 timer instruction indicator */
#define T9_NOIND            0x00
#define T9_STOPPOSS         0x01

/* defines for status primitives */

#define SIT_STA_REATTEMPT   0x01  /* reattempt indication */
#define SIT_STA_ERRORIND    0x02  /* error indication */
#define SIT_STA_CONTCHK     0x03  /* continuity check */
#define SIT_STA_CONTREP     0x04  /* continuity report */
#define SIT_STA_STPCONTIN   0x05  /* stop continuity */
#define SIT_STA_CGQRYRSP    0x06  /* circuit grp query response from far end 
                                     forwarded to upper layer by ISUP */
#define SIT_STA_CONFUSION   0x07  /* confusion */
#define SIT_STA_LOOPBACKACK 0x08  /* loop-back acknowledge */
#define SIT_STA_CIRRSRVREQ  0x09  /* circuit reservation request */
#define SIT_STA_CIRRSRVACK  0x0A  /* circuit reservation acknowledgement */
#define SIT_STA_CIRBLOREQ   0x14  /* circuit blocking request */
#define SIT_STA_CIRBLORSP   0x15  /* circuit blocking response   */
#define SIT_STA_CIRUBLREQ   0x16  /* circuit unblocking request */
#define SIT_STA_CIRUBLRSP   0x17  /* circuit unblocking response */
#define SIT_STA_CIRRESREQ   0x18  /* circuit reset request */
#define SIT_STA_CIRRESRSP   0x19  /* circuit reset response */
#define SIT_STA_CGBREQ      0x1C  /* CGB request */
#define SIT_STA_CGUREQ      0x1D  /* CGU request */
#define SIT_STA_CGQRYREQ    0x1E  /* circuit group query request */
#define SIT_STA_CGBRSP      0x1F  /* mntc. oriented CGB response */
#define SIT_STA_CGURSP      0x20  /* mntc. oriented CGU response */
#define SIT_STA_GRSREQ      0x21  /* circuit group reset request */
#define SIT_STA_CIRUNEQPD   0x22  /* circuit unequipped indication */
#define SIT_STA_GRSRSP      0x23  /* circuit group reset response */
#define SIT_STA_CIRLOCRES   0x24  /* reset initiated locally by the software */
#define SIT_STA_PAUSEIND    0x25   /* pause indication */
#define SIT_STA_RESUMEIND   0x26   /* resume indication */
#define SIT_STA_USRPARTA    0x27   /* user part available */
#define SIT_STA_RMTUSRUNAV  0x28   /* remote user not available */
#define SIT_STA_MTPCONG0    0x29   /* congestion indication level 0 */
#define SIT_STA_MTPCONG1    0x3a   /* congestion indication level 1 */
#define SIT_STA_MTPCONG2    0x3b   /* congestion indication level 2 */
#define SIT_STA_MTPCONG3    0x3c   /* congestion indication level 3 */
#define SIT_STA_MTPSTPCONG  0x3d   /* stop congestion indication level 0 */
#define SIT_STA_CIRBLOIND   SIT_STA_CIRBLOREQ /* circuit blocking indication */
#define SIT_STA_CIRBLOCFM   SIT_STA_CIRBLORSP /* circuit blocking confirm */
#define SIT_STA_CIRUBLIND   SIT_STA_CIRUBLREQ /* circuit unblocking ind. */
#define SIT_STA_CIRUBLCFM   SIT_STA_CIRUBLRSP /* circuit unblocking confirm */
#define SIT_STA_CIRRESIND   SIT_STA_CIRRESREQ /* circuit reset indication */
#define SIT_STA_CIRRESCFM   SIT_STA_CIRRESRSP /* circuit reset response */
#define SIT_STA_CGBIND      SIT_STA_CGBREQ    /* mntc oriented CGB ind. */
#define SIT_STA_CGBCFM      SIT_STA_CGBRSP    /* mntc oriented CGB confirm */
#define SIT_STA_CGUIND      SIT_STA_CGUREQ    /* mntc oriented CGU ind. */
#define SIT_STA_CGUCFM      SIT_STA_CGURSP    /* mntc oriented CGU confirm */
#define SIT_STA_GRSIND      SIT_STA_GRSREQ    /* circuit group reset ind. */
#define SIT_STA_GRSCFM      SIT_STA_GRSRSP    /* circuit group reset confirm */
#define SIT_STA_CIRLOCALBLOIND 0x3e  /* Mngmt local blocking */
#define SIT_STA_CIRLOCALUBLIND 0x3f  /* Mngmt local unblocking */
#define SIT_STA_OVERLOAD    0x40     /* Overload */
#define SIT_STA_LMCGBREQ    0x41     /* when LM requests ckt grp blocking */
#define SIT_STA_LMCGUREQ    0x42     /* when LM requests ckt grp unblocking */
#define SIT_STA_LMGRSREQ    0x43     /* when LM requests ckt grp reset */
#define SIT_STA_CGBINFOIND   0x44    /* circuit grp blking ind , no resp req */
#define SIT_STA_LMCQMINFOREQ 0x45    /* when LM requests ckt grp query */
#define SIT_STA_CIRLOCGRS    0x46    /* group reset initiated locally by the 
                                        software */
#define SIT_STA_GRSRSPIND   0x47     /* indication to IW to idle the RM */
#define SIT_STA_RLCIND      0x48     /* RLC indicattion to IW to idle the RM */
/*  New event type for timer expiry added */
#ifdef SIT_TMREXP
#define SIT_STA_TMREXP      0x49     /* Timer expiry */
#endif
#define SIT_STA_MEM_EXHAUSTED  0x50  /* No Memory */
/**** old hash defines redefined for backward compatibility ****/
/* WARNING: THESE DEFINES WILL BE OBSOLETED SUBSEQUENTLY */
#define   REATTMEMP        SIT_STA_REATTEMPT 
#define   ERRORIND         SIT_STA_ERRORIND 
#define   CONTCHK          SIT_STA_CONTCHK
#define   CONTREP          SIT_STA_CONTREP
#define   STPCONTIN        SIT_STA_STPCONTIN
#define   CIRGRPQRYRSP     SIT_STA_CGQRYRSP
#define   CONFUSION        SIT_STA_CONFUSION
#define   LOOPBCKACK       SIT_STA_LOOPBACKACK
#define   CIRRESERVE       SIT_STA_CIRRSRVREQ
#define   CIRRESERVEACK    SIT_STA_CIRRSRVACK
#define   CIRBLKREQ        SIT_STA_CIRBLOREQ
#define   CIRBLKRSP        SIT_STA_CIRBLORSP
#define   CIRUNBLKREQ      SIT_STA_CIRUBLREQ
#define   CIRUNBLKRSP      SIT_STA_CIRUBLRSP
#define   CIRRESREQ        SIT_STA_CIRRESREQ
#define   CIRGRPBLKREQ     SIT_STA_CGBREQ
#define   CIRGRPUNBLKREQ   SIT_STA_CGUREQ
#define   CIRGRPQRYREQ     SIT_STA_CGQRYREQ
#define   CIRGRPBLKRSP     SIT_STA_CGBRSP
#define   CIRGRPUNBLKRSP   SIT_STA_CGURSP
#define   CIRGRPRESREQ     SIT_STA_GRSREQ
#define   CIRUNEQPD        SIT_STA_CIRUNEQPD
#define   CIRGRPRESACK     SIT_STA_GRSCFM
#define   CIRRESREQLOC     SIT_STA_CIRLOCRES
#define   PAUSEIND         SIT_STA_PAUSEIND
#define   RESUMEIND        SIT_STA_RESUMEIND
#define   USRPARTA         SIT_STA_USRPARTA
#define   RMTUSRUNAV       SIT_STA_RMTUSRUNAV
#define   SI_MTPCONG0      SIT_STA_MTPCONG0
#define   SI_MTPCONG1      SIT_STA_MTPCONG1
#define   SI_MTPCONG2      SIT_STA_MTPCONG2
#define   SI_MTPCONG3      SIT_STA_MTPCONG3
#define   SI_MTPSTPCONG    SIT_STA_MTPSTPCONG

/* defines for facility primitive */

#define   SIT_FACIL         0x00   /* facility message */
#define   SIT_FACREQ        0x01   /* facility request message */
#define   SIT_FACACC        0x02   /* facility accepted message */
#define   SIT_FACREJ        0x03   /* facility rejected message */

#define  ESITBASE    0            /* reserved */
#define  ESITXXX     ESITBASE     /* reserved */

/* Defines for reason for not giving calling party number */
#define  NOTIFDIS_USERREQ   0x1  /* Notif disable due to user req */
#define  NOTIFDIS_SRVCCOMP  0x2  /* Notif disable due to srv comp */
#define  NOTIFDIS_FROMPUBLIC 0x3 /* Notif disable due to call from 
                                    public n/w */

/* Service Info of user to user indicator */
#define  SRV_NO_INF              0x00    /* service no information */
#define  SRV_REQ_NOT_ESSENTIAL   0x02    /* service required, not essential */
#define  SRV_REQ_ESSENTIAL       0x03    /* service required , essential */

#define SRV_RSP_NOT_PROVIDED     0x01    /* service not provided */

#define SRV_RSP_SPARE            0x03    /* spare value for Response type */
#define SRV_REQ_SPARE            0x01    /* spare value for Request type */

/* info req indicators */
#define MALCALL_IDEN_NOT_REQ     0x00    /* malicious call ident not req */
#define MALCALL_IDEN_REQ         0x01    /* malicious call ident req */

/* Following defines have been obsoluted due to their conflict with the 
 * ISDN file int.h. These defines have been added again with a prefix 
 * of SIT_. e.g. CCACCINFDISC is now replaced with SIT_CCACCINFDISC
 */
#if SIT_OLD_DEFINES
#define CCACCINFDISC         43    /* access information discarded */
#define CCBCAPNOTIMP       65    /* bearer capability not implemented */
#define CCBCAPUNAVAIL      58    /* bearer capability not available */
#define CCCALLCLR          16    /* normal call clearing */
#define CCCALLRJT          21    /* call rejected */
#define CCDESTOUTORD       27    /* destination out of order */
#define CCFACNOTIMP        69    /* requested facility not implemented */
#define CCFACNOTSUB        50    /* requested facility not subscribed */
#define CCFACREJ           29    /* facility rejected */
#define CCINCOMPDEST       88    /* incompatible destination */
#define CCINTRWRK          127   /* interworking unspecified */
#define CCINVMSG           95    /* invalid message, unspecified */
#define CCINVTRNSTNET      91    /* invalid transit network selection */
#define CCNETAOL           38    /* network out of order */
#define CCNMBRCHG          22    /* number changed */
#define CCNOANSWR          19    /* no answer (user alerted ) */
#define CCNOCIRCUIT        34    /* no circuit/channel available */
#define CCNOMSGTYP         97    /* msg type is non-existent or not */
#define CCNORMUNSPEC       31    /* normal unspecified */
#define CCNORTTODEST       3     /* no route to destination */
#define CCNORTTOTSFNET     2     /* no route to transit network */
#define CCNOTAUTHBCAP      57    /* bearer capability not authorized */
#define CCNOUSRRSP         18    /* no user response */
#define CCPROTERR          111   /* protocol error, unspecified */
#define CCREQUNAVAIL       44    /* requested circuit/channel unavailable */
#define CCRESCUNAVAIL      47    /* resources unavailable, unspecified */
#define CCRESTDIG          70    /* only restricted digital bear cap is avail*/
#define CCSERVNOTIMP       79    /* service or option not implemented */
#define CCSERVUNAVAIL      63    /* Service or option unavailable */
#define CCSWTCHCONG        42    /* Switch equipment congestion */
#define CCTMPFAIL          41    /* Temporary failure */
#define CCUNALLOC          1     /* unassigned number */
#define CCUSRBSY           17    /* user busy */
#define CSTD_CCITT         0x00  /* CCITT standards */
#define CSTD_INT           0x01  /* Reserved for other international standards */
#define CSTD_NAT           0x02  /* National Standard */
#define CSTD_NET           0x03  /* Standard Specific Network */
#define FLCRX_ACC          0x01  /* can accept data with flow control */
#define FLCRX_NOTACC       0x00  /* cannot accept data with flow control */
#define FLCTX_NOTREQ       0x00  /* not required to send with flow control */
#define FLCTX_REQ          0x01  /* required to send with flow control */
#define HLCI_AUDSCR    0x40  /* VN-3 National Audiosritp */
#define HLCI_AUDVID    0x48  /* VN-3 National Audiovideotex */
#define HLCI_DAPFAXG4  0x21  /* Doc App Profile for Facsimile Group 4 */
#define HLCI_DAPMIXED  0x24  /* Doc App Profile for Facsimile Group 4 */
#define HLCI_DAPPROC   0x28  /* Doc App Profile for Facsimile Group 4 */
#define HLCI_DAPVIDEO  0x32  /* Doc App Profile for Facsimile Group 4 */
#define HLCI_FAXG4     0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define HLCI_MAINT     0x5e  /* Maintenance */
#define HLCI_MHS       0x38  /* Message Handling System */
#define HLCI_MNGMT     0x5f  /* Management */
#define HLCI_OSIAPP    0x41  /* OSI Application - Recommendation X.200 */
#define HLCI_RESERVE   0xff  /* Reserved */
#define HLCI_TEL       0x01  /* Telephony - Recommendation G.711 */
#define HLCI_TELETEX   0x31  /* Teletex - Recommendation T.62/T.70 */
#define HLCI_TELEX     0x35  /* Telex */
#define HLCI_VIDTEL    0x60  /* Videotelephony F.xyz and AV.242 */
#define INT_FIRST      0x04  /* first high layer characteristics */
#define L1_IDENT           0x01  /* layer 1 identity */
#define L2_IDENT           0x02  /* layer 2 identity */
#define L3_IDENT           0x03  /* layer 3 identity */
#define MF_MAX_REPELMT    2
#define NICRX_ACC          0x01  /* can accept data with nic */
#define NICRX_NOTACC       0x00  /* cannot accept data with nic */
#define NICTX_NOTREQ       0x00  /* not required to send with nic */
#define NICTX_REQ          0x01  /* required to send with nic */
#define NP_UNK             0x00  /* number not present - np set to zero */
#define PM_VAL1        0x01  /* value 1 */
#define REC_X21            0x03     /* CCITT Recommendation X.21 */
#define REC_X25            0x04     /* CCITT Recommendation X.25 */
#define UR_100             0x16  /* .100 kbits, X.1 */
#define UR_110             0x1b  /* .110 kbits, V.6 and X.1 */
#define UR_1200            0x02  /* 1.2 kbits, V.6 */
#define UR_12000           0x1f  /* 12 kbits, V.6 */
#define UR_1200_75         0x18  /* 1200/.075 kbits, V.6 and X.1 */
#define UR_134             0x15  /* .1345 kbits, X.1 */
#define UR_14400           0x09  /* 14.4 kbits, V.6 */
#define UR_150             0x1c  /* .150 kbits, V.6 and X.1 */
#define UR_16000           0x0a  /* 16 kbits, I.460 */
#define UR_19200           0x0b  /* 19.2 kbits, V.6 */
#define UR_200             0x1d  /* .200 kbits, V.6 and X.1 */
#define UR_2400            0x03  /* 2.4 kbits, V.6 and X.1 */
#define UR_300             0x1e  /* .300 kbits, V.6 and X.1 */
#define UR_32000           0x0c  /* 32 kbits, I.460 */
#define UR_3600            0x04  /* 3.6 kbits, V.6 */
#define UR_4800            0x05  /* 4.8 kbits, V.6 and X.1 */
#define UR_48000           0x0e  /* 48 kbits, V.6 and X.1 */
#define UR_50              0x19  /* .050 kbits, V.6 and X.1 */
#define UR_56000           0x0f  /* 56 kbits, V.6 */
#define UR_600             0x01  /* 0.6 kbits, V.6 and X.1 */
#define UR_64000           0x10  /* 56 kbits, V.6 */
#define UR_7200            0x06  /* 7.2 kbits, V.6 */
#define UR_75              0x1a  /* .075 kbits, V.6 and X.1 */
#define UR_75_1200         0x17  /* .075/1200 kbits, V.6 and X.1 */
#define UR_8000            0x07  /* 8.0 kbits, I.460 */
#define UR_9600            0x08  /* 9.6 kbits, V.6 and X.1 */
#define UR_EINI460         0x00  /* determined by E bits in I.460 */
#define XHLCI_DAPFAXG4 0x21  /* Doc App Profile for Facsimile Group 4 */
#define XHLCI_DAPMIXED 0x24  /* Doc App Profile for Facsimile Group 4 */
#define XHLCI_DAPPROC  0x28  /* Doc App Profile for Facsimile Group 4 */
#define XHLCI_DAPVIDEO 0x32  /* Doc App Profile for Facsimile Group 4 */
#define XHLCI_FAXG4    0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define XHLCI_MAINT    0x5e  /* Maintenance */
#define XHLCI_MHS      0x38  /* Message Handling System */
#define XHLCI_MNGMT    0x5f  /* Management */
#define XHLCI_OSIAPP   0x41  /* OSI Application - Recommendation X.200 */
#define XHLCI_RESERVE  0xff  /* Reserved */
#define XHLCI_TEL      0x01  /* Telephony - Recommendation G.711 */
#define XHLCI_TELETEX  0x31  /* Teletex - Recommendation T.62/T.70 */
#define XHLCI_TELEX    0x35  /* Telex */
#define XHLCI_VIDTEL   0x60  /* Videotelephony (F.xyz and AV.242) */
#endif

/*  ADDED: added the bit vector and default value for base release 
 * in rolling upgrade 
 */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
/*  MODIFIED: removed the SITV1 flag for bit vector related 
 * defines */
#define SIT_SS7_ANS88_BIT 0x01    /* bit corresponding to flag SS7_ANS88 */
#define SIT_SS7_ANS92_BIT 0x02    /* bit corresponding to flag SS7_ANS92 */
#define SIT_SS7_ANS95_BIT 0x04    /* bit corresponding to flag SS7_ANS95 */
#define SIT_SS7_ITU97_BIT 0x08    /* bit corresponding to flag SS7_ITU97 */
#define SIT_SS7_ETSI_BIT  0x10    /* bit corresponding to flag SS7_ETSI */
#define SIT_SS7_ETSIV3_BIT  0x20  /* bit corresponding to flag SS7_ETSIV3 */
/*  Addition - added new define for Indian variant */
#define SIT_SS7_INDIA_BIT 0x80    /* bit corresponding to flag SS7_INDIA */
#define SIT_SS7_CHINA_BIT 0x100   /* bit corresponding to flag SS7_CHINA */
#define SIT_SS7_ITU2000_BIT 0x200   /* bit corresponding to flag SS7_ITU2000 */
#define SIT_SS7_RUSS2000_BIT 0x400   /* bit corresponding to flag SS7_RUSS2000 */

/*  Added UK Specific defines */
/* SS7_UK */
#define SIT_SS7_UK_BIT 0x800  /* bit corresponding to flag SS7_UK */

#define SIT_SS7_NZL_BIT 0x900  /* bit corresponding to flag SS7_NZL */
#define SIT_SS7_KZ_BIT  0x1000 /* sit_h_001.main_45 : bit corresponding to flag SS7_KZ */

/*sit_h_001.main_49 Added bit vector for Ukraine*/
#define SIT_SS7_UR_BIT  0x8000   /* bit corresponding to flag SS7_UR */

#define SIT_ANSILNP_BIT   0x40    /* bit corresponding to flag SI_ANSILNP */

#define SITIF_VER1_CONREQ_DEF_TRANSID_VAL 0x00 
                                  /* default value for transCallNInd */
#define SITIF_VER1_CONREQ_DEF_TESTIND_VAL 0x00  
                                  /* default value for testInd */      

#endif

/* sit_h_001.main_47 : added defines for Calling party number check result */
#define CGPN_CHK_PASS    1     /* Calling party number check passed */  
#define CGPN_CHK_FAILURE 0     /* Calling party number check failed */

/*  MODIFIED: moved the ESIT defines within the __SITH__ defines */ 
#define   ESIT001      (ESITBASE +    1)    /*        sit.c: 624 */
#define   ESIT002      (ESITBASE +    2)    /*        sit.c: 626 */
#define   ESIT003      (ESITBASE +    3)    /*        sit.c: 628 */
#define   ESIT004      (ESITBASE +    4)    /*        sit.c: 632 */
#define   ESIT005      (ESITBASE +    5)    /*        sit.c: 637 */
#define   ESIT006      (ESITBASE +    6)    /*        sit.c: 638 */
#define   ESIT007      (ESITBASE +    7)    /*        sit.c: 644 */
#define   ESIT008      (ESITBASE +    8)    /*        sit.c: 646 */
#define   ESIT009      (ESITBASE +    9)    /*        sit.c: 648 */
#define   ESIT010      (ESITBASE +   10)    /*        sit.c: 651 */
#define   ESIT011      (ESITBASE +   11)    /*        sit.c: 661 */
#define   ESIT012      (ESITBASE +   12)    /*        sit.c: 669 */
#define   ESIT013      (ESITBASE +   13)    /*        sit.c: 673 */
#define   ESIT014      (ESITBASE +   14)    /*        sit.c: 675 */
#define   ESIT015      (ESITBASE +   15)    /*        sit.c: 679 */
#define   ESIT016      (ESITBASE +   16)    /*        sit.c: 682 */
#define   ESIT017      (ESITBASE +   17)    /*        sit.c: 684 */
#define   ESIT018      (ESITBASE +   18)    /*        sit.c: 688 */
#define   ESIT019      (ESITBASE +   19)    /*        sit.c: 700 */
#define   ESIT020      (ESITBASE +   20)    /*        sit.c: 706 */
#define   ESIT021      (ESITBASE +   21)    /*        sit.c: 709 */
#define   ESIT022      (ESITBASE +   22)    /*        sit.c: 711 */
#define   ESIT023      (ESITBASE +   23)    /*        sit.c: 715 */
#define   ESIT024      (ESITBASE +   24)    /*        sit.c: 719 */
#define   ESIT025      (ESITBASE +   25)    /*        sit.c: 721 */
#define   ESIT026      (ESITBASE +   26)    /*        sit.c: 723 */
#define   ESIT027      (ESITBASE +   27)    /*        sit.c: 725 */
#define   ESIT028      (ESITBASE +   28)    /*        sit.c: 727 */
#define   ESIT029      (ESITBASE +   29)    /*        sit.c: 729 */
#define   ESIT030      (ESITBASE +   30)    /*        sit.c: 733 */
#define   ESIT031      (ESITBASE +   31)    /*        sit.c: 736 */
#define   ESIT032      (ESITBASE +   32)    /*        sit.c: 738 */
#define   ESIT033      (ESITBASE +   33)    /*        sit.c: 740 */
#define   ESIT034      (ESITBASE +   34)    /*        sit.c: 742 */
#define   ESIT035      (ESITBASE +   35)    /*        sit.c: 744 */
#define   ESIT036      (ESITBASE +   36)    /*        sit.c: 746 */
#define   ESIT037      (ESITBASE +   37)    /*        sit.c: 748 */
#define   ESIT038      (ESITBASE +   38)    /*        sit.c: 750 */
#define   ESIT039      (ESITBASE +   39)    /*        sit.c: 752 */
#define   ESIT040      (ESITBASE +   40)    /*        sit.c: 754 */
#define   ESIT041      (ESITBASE +   41)    /*        sit.c: 756 */
#define   ESIT042      (ESITBASE +   42)    /*        sit.c: 758 */
#define   ESIT043      (ESITBASE +   43)    /*        sit.c: 760 */
#define   ESIT044      (ESITBASE +   44)    /*        sit.c: 762 */
#define   ESIT045      (ESITBASE +   45)    /*        sit.c: 764 */
#define   ESIT046      (ESITBASE +   46)    /*        sit.c: 766 */
#define   ESIT047      (ESITBASE +   47)    /*        sit.c: 768 */
#define   ESIT048      (ESITBASE +   48)    /*        sit.c: 770 */
#define   ESIT049      (ESITBASE +   49)    /*        sit.c: 775 */
#define   ESIT050      (ESITBASE +   50)    /*        sit.c: 779 */
#define   ESIT051      (ESITBASE +   51)    /*        sit.c: 782 */
#define   ESIT052      (ESITBASE +   52)    /*        sit.c: 784 */
#define   ESIT053      (ESITBASE +   53)    /*        sit.c: 787 */
#define   ESIT054      (ESITBASE +   54)    /*        sit.c: 789 */
#define   ESIT055      (ESITBASE +   55)    /*        sit.c: 793 */
#define   ESIT056      (ESITBASE +   56)    /*        sit.c: 796 */
#define   ESIT057      (ESITBASE +   57)    /*        sit.c: 798 */
#define   ESIT058      (ESITBASE +   58)    /*        sit.c: 800 */
#define   ESIT059      (ESITBASE +   59)    /*        sit.c: 802 */
#define   ESIT060      (ESITBASE +   60)    /*        sit.c: 804 */
#define   ESIT061      (ESITBASE +   61)    /*        sit.c: 806 */
#define   ESIT062      (ESITBASE +   62)    /*        sit.c: 809 */
#define   ESIT063      (ESITBASE +   63)    /*        sit.c: 812 */
#define   ESIT064      (ESITBASE +   64)    /*        sit.c: 814 */
#define   ESIT065      (ESITBASE +   65)    /*        sit.c: 817 */
#define   ESIT066      (ESITBASE +   66)    /*        sit.c: 819 */
#define   ESIT067      (ESITBASE +   67)    /*        sit.c: 821 */
#define   ESIT068      (ESITBASE +   68)    /*        sit.c: 824 */
#define   ESIT069      (ESITBASE +   69)    /*        sit.c: 828 */
#define   ESIT070      (ESITBASE +   70)    /*        sit.c: 832 */
#define   ESIT071      (ESITBASE +   71)    /*        sit.c: 834 */
#define   ESIT072      (ESITBASE +   72)    /*        sit.c: 836 */
#define   ESIT073      (ESITBASE +   73)    /*        sit.c: 839 */
#define   ESIT074      (ESITBASE +   74)    /*        sit.c: 841 */
#define   ESIT075      (ESITBASE +   75)    /*        sit.c: 882 */
#define   ESIT076      (ESITBASE +   76)    /*        sit.c: 886 */
#define   ESIT077      (ESITBASE +   77)    /*        sit.c: 888 */
#define   ESIT078      (ESITBASE +   78)    /*        sit.c: 892 */
#define   ESIT079      (ESITBASE +   79)    /*        sit.c: 894 */
#define   ESIT080      (ESITBASE +   80)    /*        sit.c: 896 */
#define   ESIT081      (ESITBASE +   81)    /*        sit.c: 898 */
#define   ESIT082      (ESITBASE +   82)    /*        sit.c: 901 */
#define   ESIT083      (ESITBASE +   83)    /*        sit.c: 903 */
#define   ESIT084      (ESITBASE +   84)    /*        sit.c: 906 */
#define   ESIT085      (ESITBASE +   85)    /*        sit.c: 909 */
#define   ESIT086      (ESITBASE +   86)    /*        sit.c: 912 */
#define   ESIT087      (ESITBASE +   87)    /*        sit.c: 914 */
#define   ESIT088      (ESITBASE +   88)    /*        sit.c: 916 */
#define   ESIT089      (ESITBASE +   89)    /*        sit.c: 919 */
#define   ESIT090      (ESITBASE +   90)    /*        sit.c: 925 */
#define   ESIT091      (ESITBASE +   91)    /*        sit.c: 929 */
#define   ESIT092      (ESITBASE +   92)    /*        sit.c: 931 */
#define   ESIT093      (ESITBASE +   93)    /*        sit.c: 933 */
#define   ESIT094      (ESITBASE +   94)    /*        sit.c: 935 */
#define   ESIT095      (ESITBASE +   95)    /*        sit.c: 937 */
#define   ESIT096      (ESITBASE +   96)    /*        sit.c: 939 */
#define   ESIT097      (ESITBASE +   97)    /*        sit.c: 942 */
#define   ESIT098      (ESITBASE +   98)    /*        sit.c: 944 */
#define   ESIT099      (ESITBASE +   99)    /*        sit.c: 946 */
#define   ESIT100      (ESITBASE +  100)    /*        sit.c: 948 */
#define   ESIT101      (ESITBASE +  101)    /*        sit.c: 950 */
#define   ESIT102      (ESITBASE +  102)    /*        sit.c: 958 */
#define   ESIT103      (ESITBASE +  103)    /*        sit.c: 966 */
#define   ESIT104      (ESITBASE +  104)    /*        sit.c: 968 */
#define   ESIT105      (ESITBASE +  105)    /*        sit.c: 973 */
#define   ESIT106      (ESITBASE +  106)    /*        sit.c: 975 */
#define   ESIT107      (ESITBASE +  107)    /*        sit.c: 979 */
#define   ESIT108      (ESITBASE +  108)    /*        sit.c: 983 */
#define   ESIT109      (ESITBASE +  109)    /*        sit.c: 987 */
#define   ESIT110      (ESITBASE +  110)    /*        sit.c: 989 */
#define   ESIT111      (ESITBASE +  111)    /*        sit.c: 994 */
#define   ESIT112      (ESITBASE +  112)    /*        sit.c: 996 */
#define   ESIT113      (ESITBASE +  113)    /*        sit.c: 998 */
#define   ESIT114      (ESITBASE +  114)    /*        sit.c:1000 */
#define   ESIT115      (ESITBASE +  115)    /*        sit.c:1002 */
#define   ESIT116      (ESITBASE +  116)    /*        sit.c:1004 */
#define   ESIT117      (ESITBASE +  117)    /*        sit.c:1006 */
#define   ESIT118      (ESITBASE +  118)    /*        sit.c:1008 */
#define   ESIT119      (ESITBASE +  119)    /*        sit.c:1010 */
#define   ESIT120      (ESITBASE +  120)    /*        sit.c:1012 */
#define   ESIT121      (ESITBASE +  121)    /*        sit.c:1014 */
#define   ESIT122      (ESITBASE +  122)    /*        sit.c:1016 */
#define   ESIT123      (ESITBASE +  123)    /*        sit.c:1020 */
#define   ESIT124      (ESITBASE +  124)    /*        sit.c:1024 */
#define   ESIT125      (ESITBASE +  125)    /*        sit.c:1027 */
#define   ESIT126      (ESITBASE +  126)    /*        sit.c:1029 */
#define   ESIT127      (ESITBASE +  127)    /*        sit.c:1031 */
#define   ESIT128      (ESITBASE +  128)    /*        sit.c:1033 */
#define   ESIT129      (ESITBASE +  129)    /*        sit.c:1035 */
#define   ESIT130      (ESITBASE +  130)    /*        sit.c:1037 */
#define   ESIT131      (ESITBASE +  131)    /*        sit.c:1039 */
#define   ESIT132      (ESITBASE +  132)    /*        sit.c:1041 */
#define   ESIT133      (ESITBASE +  133)    /*        sit.c:1044 */
#define   ESIT134      (ESITBASE +  134)    /*        sit.c:1046 */
#define   ESIT135      (ESITBASE +  135)    /*        sit.c:1049 */
#define   ESIT136      (ESITBASE +  136)    /*        sit.c:1052 */
#define   ESIT137      (ESITBASE +  137)    /*        sit.c:1054 */
#define   ESIT138      (ESITBASE +  138)    /*        sit.c:1056 */
#define   ESIT139      (ESITBASE +  139)    /*        sit.c:1059 */
#define   ESIT140      (ESITBASE +  140)    /*        sit.c:1062 */
#define   ESIT141      (ESITBASE +  141)    /*        sit.c:1064 */
#define   ESIT142      (ESITBASE +  142)    /*        sit.c:1066 */
#define   ESIT143      (ESITBASE +  143)    /*        sit.c:1069 */
#define   ESIT144      (ESITBASE +  144)    /*        sit.c:1073 */
#define   ESIT145      (ESITBASE +  145)    /*        sit.c:1076 */
#define   ESIT146      (ESITBASE +  146)    /*        sit.c:1078 */
#define   ESIT147      (ESITBASE +  147)    /*        sit.c:1080 */
#define   ESIT148      (ESITBASE +  148)    /*        sit.c:1082 */
#define   ESIT149      (ESITBASE +  149)    /*        sit.c:1084 */
#define   ESIT150      (ESITBASE +  150)    /*        sit.c:1086 */
#define   ESIT151      (ESITBASE +  151)    /*        sit.c:1088 */
#define   ESIT152      (ESITBASE +  152)    /*        sit.c:1090 */
#define   ESIT153      (ESITBASE +  153)    /*        sit.c:1092 */
#define   ESIT154      (ESITBASE +  154)    /*        sit.c:1094 */
#define   ESIT155      (ESITBASE +  155)    /*        sit.c:1096 */
#define   ESIT156      (ESITBASE +  156)    /*        sit.c:1099 */
#define   ESIT157      (ESITBASE +  157)    /*        sit.c:1101 */
#define   ESIT158      (ESITBASE +  158)    /*        sit.c:1105 */
#define   ESIT159      (ESITBASE +  159)    /*        sit.c:1108 */
#define   ESIT160      (ESITBASE +  160)    /*        sit.c:1110 */
#define   ESIT161      (ESITBASE +  161)    /*        sit.c:1112 */
#define   ESIT162      (ESITBASE +  162)    /*        sit.c:1114 */
#define   ESIT163      (ESITBASE +  163)    /*        sit.c:1116 */
#define   ESIT164      (ESITBASE +  164)    /*        sit.c:1119 */
#define   ESIT165      (ESITBASE +  165)    /*        sit.c:1123 */
#define   ESIT166      (ESITBASE +  166)    /*        sit.c:1127 */
#define   ESIT167      (ESITBASE +  167)    /*        sit.c:1130 */
#define   ESIT168      (ESITBASE +  168)    /*        sit.c:1132 */
#define   ESIT169      (ESITBASE +  169)    /*        sit.c:1134 */
#define   ESIT170      (ESITBASE +  170)    /*        sit.c:1137 */
#define   ESIT171      (ESITBASE +  171)    /*        sit.c:1141 */
#define   ESIT172      (ESITBASE +  172)    /*        sit.c:1145 */
#define   ESIT173      (ESITBASE +  173)    /*        sit.c:1148 */
#define   ESIT174      (ESITBASE +  174)    /*        sit.c:1150 */
#define   ESIT175      (ESITBASE +  175)    /*        sit.c:1152 */
#define   ESIT176      (ESITBASE +  176)    /*        sit.c:1155 */
#define   ESIT177      (ESITBASE +  177)    /*        sit.c:1158 */
#define   ESIT178      (ESITBASE +  178)    /*        sit.c:1160 */
#define   ESIT179      (ESITBASE +  179)    /*        sit.c:1163 */
#define   ESIT180      (ESITBASE +  180)    /*        sit.c:1166 */
#define   ESIT181      (ESITBASE +  181)    /*        sit.c:1168 */
#define   ESIT182      (ESITBASE +  182)    /*        sit.c:1170 */
#define   ESIT183      (ESITBASE +  183)    /*        sit.c:1172 */
#define   ESIT184      (ESITBASE +  184)    /*        sit.c:1217 */
#define   ESIT185      (ESITBASE +  185)    /*        sit.c:1225 */
#define   ESIT186      (ESITBASE +  186)    /*        sit.c:1227 */
#define   ESIT187      (ESITBASE +  187)    /*        sit.c:1229 */
#define   ESIT188      (ESITBASE +  188)    /*        sit.c:1232 */
#define   ESIT189      (ESITBASE +  189)    /*        sit.c:1234 */
#define   ESIT190      (ESITBASE +  190)    /*        sit.c:1236 */
#define   ESIT191      (ESITBASE +  191)    /*        sit.c:1238 */
#define   ESIT192      (ESITBASE +  192)    /*        sit.c:1240 */
#define   ESIT193      (ESITBASE +  193)    /*        sit.c:1242 */
#define   ESIT194      (ESITBASE +  194)    /*        sit.c:1244 */
#define   ESIT195      (ESITBASE +  195)    /*        sit.c:1246 */
#define   ESIT196      (ESITBASE +  196)    /*        sit.c:1249 */
#define   ESIT197      (ESITBASE +  197)    /*        sit.c:1251 */
#define   ESIT198      (ESITBASE +  198)    /*        sit.c:1253 */
#define   ESIT199      (ESITBASE +  199)    /*        sit.c:1255 */
#define   ESIT200      (ESITBASE +  200)    /*        sit.c:1258 */
#define   ESIT201      (ESITBASE +  201)    /*        sit.c:1297 */
#define   ESIT202      (ESITBASE +  202)    /*        sit.c:1299 */
#define   ESIT203      (ESITBASE +  203)    /*        sit.c:1301 */
#define   ESIT204      (ESITBASE +  204)    /*        sit.c:1303 */
#define   ESIT205      (ESITBASE +  205)    /*        sit.c:1344 */
#define   ESIT206      (ESITBASE +  206)    /*        sit.c:1346 */
#define   ESIT207      (ESITBASE +  207)    /*        sit.c:1350 */
#define   ESIT208      (ESITBASE +  208)    /*        sit.c:1354 */
#define   ESIT209      (ESITBASE +  209)    /*        sit.c:1357 */
#define   ESIT210      (ESITBASE +  210)    /*        sit.c:1361 */
#define   ESIT211      (ESITBASE +  211)    /*        sit.c:1365 */
#define   ESIT212      (ESITBASE +  212)    /*        sit.c:1367 */
#define   ESIT213      (ESITBASE +  213)    /*        sit.c:1369 */
#define   ESIT214      (ESITBASE +  214)    /*        sit.c:1372 */
#define   ESIT215      (ESITBASE +  215)    /*        sit.c:1374 */
#define   ESIT216      (ESITBASE +  216)    /*        sit.c:1376 */
#define   ESIT217      (ESITBASE +  217)    /*        sit.c:1378 */
#define   ESIT218      (ESITBASE +  218)    /*        sit.c:1380 */
#define   ESIT219      (ESITBASE +  219)    /*        sit.c:1382 */
#define   ESIT220      (ESITBASE +  220)    /*        sit.c:1384 */
#define   ESIT221      (ESITBASE +  221)    /*        sit.c:1386 */
#define   ESIT222      (ESITBASE +  222)    /*        sit.c:1388 */
#define   ESIT223      (ESITBASE +  223)    /*        sit.c:1391 */
#define   ESIT224      (ESITBASE +  224)    /*        sit.c:1393 */
#define   ESIT225      (ESITBASE +  225)    /*        sit.c:1397 */
#define   ESIT226      (ESITBASE +  226)    /*        sit.c:1401 */
#define   ESIT227      (ESITBASE +  227)    /*        sit.c:1404 */
#define   ESIT228      (ESITBASE +  228)    /*        sit.c:1406 */
#define   ESIT229      (ESITBASE +  229)    /*        sit.c:1409 */
#define   ESIT230      (ESITBASE +  230)    /*        sit.c:1412 */
#define   ESIT231      (ESITBASE +  231)    /*        sit.c:1451 */
#define   ESIT232      (ESITBASE +  232)    /*        sit.c:1454 */
#define   ESIT233      (ESITBASE +  233)    /*        sit.c:1457 */
#define   ESIT234      (ESITBASE +  234)    /*        sit.c:1497 */
#define   ESIT235      (ESITBASE +  235)    /*        sit.c:1501 */
#define   ESIT236      (ESITBASE +  236)    /*        sit.c:1504 */
#define   ESIT237      (ESITBASE +  237)    /*        sit.c:1506 */
#define   ESIT238      (ESITBASE +  238)    /*        sit.c:1508 */
#define   ESIT239      (ESITBASE +  239)    /*        sit.c:1510 */
#define   ESIT240      (ESITBASE +  240)    /*        sit.c:1513 */
#define   ESIT241      (ESITBASE +  241)    /*        sit.c:1515 */
#define   ESIT242      (ESITBASE +  242)    /*        sit.c:1517 */
#define   ESIT243      (ESITBASE +  243)    /*        sit.c:1556 */
#define   ESIT244      (ESITBASE +  244)    /*        sit.c:1559 */
#define   ESIT245      (ESITBASE +  245)    /*        sit.c:1562 */
#define   ESIT246      (ESITBASE +  246)    /*        sit.c:1601 */
#define   ESIT247      (ESITBASE +  247)    /*        sit.c:1603 */
#define   ESIT248      (ESITBASE +  248)    /*        sit.c:1605 */
#define   ESIT249      (ESITBASE +  249)    /*        sit.c:1607 */
#define   ESIT250      (ESITBASE +  250)    /*        sit.c:1609 */
#define   ESIT251      (ESITBASE +  251)    /*        sit.c:1617 */
#define   ESIT252      (ESITBASE +  252)    /*        sit.c:1623 */
#define   ESIT253      (ESITBASE +  253)    /*        sit.c:1625 */
#define   ESIT254      (ESITBASE +  254)    /*        sit.c:1627 */
#define   ESIT255      (ESITBASE +  255)    /*        sit.c:1629 */
#define   ESIT256      (ESITBASE +  256)    /*        sit.c:1631 */
#define   ESIT257      (ESITBASE +  257)    /*        sit.c:1633 */
#define   ESIT258      (ESITBASE +  258)    /*        sit.c:1635 */
#define   ESIT259      (ESITBASE +  259)    /*        sit.c:1637 */
#define   ESIT260      (ESITBASE +  260)    /*        sit.c:7662 */
#define   ESIT261      (ESITBASE +  261)    /*        sit.c:7664 */
#define   ESIT262      (ESITBASE +  262)    /*        sit.c:7667 */
#define   ESIT263      (ESITBASE +  263)    /*        sit.c:7669 */
#define   ESIT264      (ESITBASE +  264)    /*        sit.c:7671 */
#define   ESIT265      (ESITBASE +  265)    /*        sit.c:7674 */
#define   ESIT266      (ESITBASE +  266)    /*        sit.c:7678 */
#define   ESIT267      (ESITBASE +  267)    /*        sit.c:7682 */
#define   ESIT268      (ESITBASE +  268)    /*        sit.c:7684 */
#define   ESIT269      (ESITBASE +  269)    /*        sit.c:7687 */
#define   ESIT270      (ESITBASE +  270)    /*        sit.c:7689 */
#define   ESIT271      (ESITBASE +  271)    /*        sit.c:7691 */
#define   ESIT272      (ESITBASE +  272)    /*        sit.c:7695 */
#define   ESIT273      (ESITBASE +  273)    /*        sit.c:7698 */
#define   ESIT274      (ESITBASE +  274)    /*        sit.c:7700 */
#define   ESIT275      (ESITBASE +  275)    /*        sit.c:7702 */
#define   ESIT276      (ESITBASE +  276)    /*        sit.c:7704 */
#define   ESIT277      (ESITBASE +  277)    /*        sit.c:7706 */
#define   ESIT278      (ESITBASE +  278)    /*        sit.c:7708 */
#define   ESIT279      (ESITBASE +  279)    /*        sit.c:7711 */
#define   ESIT280      (ESITBASE +  280)    /*        sit.c:7715 */
#define   ESIT281      (ESITBASE +  281)    /*        sit.c:7717 */
#define   ESIT282      (ESITBASE +  282)    /*        sit.c:7721 */
#define   ESIT283      (ESITBASE +  283)    /*        sit.c:7723 */
#define   ESIT284      (ESITBASE +  284)    /*        sit.c:7726 */
#define   ESIT285      (ESITBASE +  285)    /*        sit.c:7731 */
#define   ESIT286      (ESITBASE +  286)    /*        sit.c:7734 */
#define   ESIT287      (ESITBASE +  287)    /*        sit.c:7736 */
#define   ESIT288      (ESITBASE +  288)    /*        sit.c:7738 */
#define   ESIT289      (ESITBASE +  289)    /*        sit.c:7740 */
#define   ESIT290      (ESITBASE +  290)    /*        sit.c:7742 */
#define   ESIT291      (ESITBASE +  291)    /*        sit.c:7744 */
#define   ESIT292      (ESITBASE +  292)    /*        sit.c:7746 */
#define   ESIT293      (ESITBASE +  293)    /*        sit.c:7749 */
#define   ESIT294      (ESITBASE +  294)    /*        sit.c:7751 */
#define   ESIT295      (ESITBASE +  295)    /*        sit.c:7753 */
#define   ESIT296      (ESITBASE +  296)    /*        sit.c:7755 */
#define   ESIT297      (ESITBASE +  297)    /*        sit.c:7757 */
#define   ESIT298      (ESITBASE +  298)    /*        sit.c:7759 */
#define   ESIT299      (ESITBASE +  299)    /*        sit.c:7761 */
#define   ESIT300      (ESITBASE +  300)    /*        sit.c:7763 */
#define   ESIT301      (ESITBASE +  301)    /*        sit.c:7765 */
#define   ESIT302      (ESITBASE +  302)    /*        sit.c:7767 */
#define   ESIT303      (ESITBASE +  303)    /*        sit.c:7769 */
#define   ESIT304      (ESITBASE +  304)    /*        sit.c:7772 */
#define   ESIT305      (ESITBASE +  305)    /*        sit.c:7777 */
#define   ESIT306      (ESITBASE +  306)    /*        sit.c:7780 */
#define   ESIT307      (ESITBASE +  307)    /*        sit.c:7782 */
#define   ESIT308      (ESITBASE +  308)    /*        sit.c:7785 */
#define   ESIT309      (ESITBASE +  309)    /*        sit.c:7787 */
#define   ESIT310      (ESITBASE +  310)    /*        sit.c:7789 */
#define   ESIT311      (ESITBASE +  311)    /*        sit.c:7793 */
#define   ESIT312      (ESITBASE +  312)    /*        sit.c:7797 */
#define   ESIT313      (ESITBASE +  313)    /*        sit.c:7799 */
#define   ESIT314      (ESITBASE +  314)    /*        sit.c:7804 */
#define   ESIT315      (ESITBASE +  315)    /*        sit.c:7813 */
#define   ESIT316      (ESITBASE +  316)    /*        sit.c:7820 */
#define   ESIT317      (ESITBASE +  317)    /*        sit.c:7824 */
#define   ESIT318      (ESITBASE +  318)    /*        sit.c:7827 */
#define   ESIT319      (ESITBASE +  319)    /*        sit.c:7830 */
#define   ESIT320      (ESITBASE +  320)    /*        sit.c:7835 */
#define   ESIT321      (ESITBASE +  321)    /*        sit.c:7837 */
#define   ESIT322      (ESITBASE +  322)    /*        sit.c:7841 */
#define   ESIT323      (ESITBASE +  323)    /*        sit.c:7851 */
#define   ESIT324      (ESITBASE +  324)    /*        sit.c:7858 */
#define   ESIT325      (ESITBASE +  325)    /*        sit.c:7862 */
#define   ESIT326      (ESITBASE +  326)    /*        sit.c:7864 */
#define   ESIT327      (ESITBASE +  327)    /*        sit.c:7867 */
#define   ESIT328      (ESITBASE +  328)    /*        sit.c:7872 */
#define   ESIT329      (ESITBASE +  329)    /*        sit.c:7875 */
#define   ESIT330      (ESITBASE +  330)    /*        sit.c:7879 */
#define   ESIT331      (ESITBASE +  331)    /*        sit.c:7884 */
#define   ESIT332      (ESITBASE +  332)    /*        sit.c:7886 */
#define   ESIT333      (ESITBASE +  333)    /*        sit.c:7889 */
#define   ESIT334      (ESITBASE +  334)    /*        sit.c:7926 */
#define   ESIT335      (ESITBASE +  335)    /*        sit.c:7928 */
#define   ESIT336      (ESITBASE +  336)    /*        sit.c:7930 */
#define   ESIT337      (ESITBASE +  337)    /*        sit.c:7932 */
#define   ESIT338      (ESITBASE +  338)    /*        sit.c:7935 */
#define   ESIT339      (ESITBASE +  339)    /*        sit.c:7939 */
#define   ESIT340      (ESITBASE +  340)    /*        sit.c:7941 */
#define   ESIT341      (ESITBASE +  341)    /*        sit.c:7944 */
#define   ESIT342      (ESITBASE +  342)    /*        sit.c:7947 */
#define   ESIT343      (ESITBASE +  343)    /*        sit.c:7949 */
#define   ESIT344      (ESITBASE +  344)    /*        sit.c:7952 */
#define   ESIT345      (ESITBASE +  345)    /*        sit.c:7956 */
#define   ESIT346      (ESITBASE +  346)    /*        sit.c:7960 */
#define   ESIT347      (ESITBASE +  347)    /*        sit.c:7965 */
#define   ESIT348      (ESITBASE +  348)    /*        sit.c:7968 */
#define   ESIT349      (ESITBASE +  349)    /*        sit.c:7970 */
#define   ESIT350      (ESITBASE +  350)    /*        sit.c:7972 */
#define   ESIT351      (ESITBASE +  351)    /*        sit.c:7975 */
#define   ESIT352      (ESITBASE +  352)    /*        sit.c:7979 */
#define   ESIT353      (ESITBASE +  353)    /*        sit.c:7983 */
#define   ESIT354      (ESITBASE +  354)    /*        sit.c:7986 */
#define   ESIT355      (ESITBASE +  355)    /*        sit.c:7988 */
#define   ESIT356      (ESITBASE +  356)    /*        sit.c:7990 */
#define   ESIT357      (ESITBASE +  357)    /*        sit.c:7992 */
#define   ESIT358      (ESITBASE +  358)    /*        sit.c:7994 */
#define   ESIT359      (ESITBASE +  359)    /*        sit.c:7997 */
#define   ESIT360      (ESITBASE +  360)    /*        sit.c:8001 */
#define   ESIT361      (ESITBASE +  361)    /*        sit.c:8003 */
#define   ESIT362      (ESITBASE +  362)    /*        sit.c:8006 */
#define   ESIT363      (ESITBASE +  363)    /*        sit.c:8009 */
#define   ESIT364      (ESITBASE +  364)    /*        sit.c:8011 */
#define   ESIT365      (ESITBASE +  365)    /*        sit.c:8013 */
#define   ESIT366      (ESITBASE +  366)    /*        sit.c:8016 */
#define   ESIT367      (ESITBASE +  367)    /*        sit.c:8018 */
#define   ESIT368      (ESITBASE +  368)    /*        sit.c:8020 */
#define   ESIT369      (ESITBASE +  369)    /*        sit.c:8022 */
#define   ESIT370      (ESITBASE +  370)    /*        sit.c:8024 */
#define   ESIT371      (ESITBASE +  371)    /*        sit.c:8027 */
#define   ESIT372      (ESITBASE +  372)    /*        sit.c:8029 */
#define   ESIT373      (ESITBASE +  373)    /*        sit.c:8032 */
#define   ESIT374      (ESITBASE +  374)    /*        sit.c:8036 */
#define   ESIT375      (ESITBASE +  375)    /*        sit.c:8039 */
#define   ESIT376      (ESITBASE +  376)    /*        sit.c:8041 */
#define   ESIT377      (ESITBASE +  377)    /*        sit.c:8043 */
#define   ESIT378      (ESITBASE +  378)    /*        sit.c:8046 */
#define   ESIT379      (ESITBASE +  379)    /*        sit.c:8049 */
#define   ESIT380      (ESITBASE +  380)    /*        sit.c:8051 */
#define   ESIT381      (ESITBASE +  381)    /*        sit.c:8053 */
#define   ESIT382      (ESITBASE +  382)    /*        sit.c:8057 */
#define   ESIT383      (ESITBASE +  383)    /*        sit.c:8061 */
#define   ESIT384      (ESITBASE +  384)    /*        sit.c:8064 */
#define   ESIT385      (ESITBASE +  385)    /*        sit.c:8067 */
#define   ESIT386      (ESITBASE +  386)    /*        sit.c:8069 */
#define   ESIT387      (ESITBASE +  387)    /*        sit.c:8071 */
#define   ESIT388      (ESITBASE +  388)    /*        sit.c:8073 */
#define   ESIT389      (ESITBASE +  389)    /*        sit.c:8075 */
#define   ESIT390      (ESITBASE +  390)    /*        sit.c:8077 */
#define   ESIT391      (ESITBASE +  391)    /*        sit.c:8079 */
#define   ESIT392      (ESITBASE +  392)    /*        sit.c:8081 */
#define   ESIT393      (ESITBASE +  393)    /*        sit.c:8084 */
#define   ESIT394      (ESITBASE +  394)    /*        sit.c:8088 */
#define   ESIT395      (ESITBASE +  395)    /*        sit.c:8092 */
#define   ESIT396      (ESITBASE +  396)    /*        sit.c:8094 */
#define   ESIT397      (ESITBASE +  397)    /*        sit.c:8096 */
#define   ESIT398      (ESITBASE +  398)    /*        sit.c:8098 */
#define   ESIT399      (ESITBASE +  399)    /*        sit.c:8100 */
#define   ESIT400      (ESITBASE +  400)    /*        sit.c:8102 */
#define   ESIT401      (ESITBASE +  401)    /*        sit.c:8104 */
#define   ESIT402      (ESITBASE +  402)    /*        sit.c:8106 */
#define   ESIT403      (ESITBASE +  403)    /*        sit.c:8108 */
#define   ESIT404      (ESITBASE +  404)    /*        sit.c:8110 */
#define   ESIT405      (ESITBASE +  405)    /*        sit.c:8112 */
#define   ESIT406      (ESITBASE +  406)    /*        sit.c:8114 */
#define   ESIT407      (ESITBASE +  407)    /*        sit.c:8119 */
#define   ESIT408      (ESITBASE +  408)    /*        sit.c:8121 */
#define   ESIT409      (ESITBASE +  409)    /*        sit.c:8126 */
#define   ESIT410      (ESITBASE +  410)    /*        sit.c:8130 */
#define   ESIT411      (ESITBASE +  411)    /*        sit.c:8134 */
#define   ESIT412      (ESITBASE +  412)    /*        sit.c:8136 */
#define   ESIT413      (ESITBASE +  413)    /*        sit.c:8140 */
#define   ESIT414      (ESITBASE +  414)    /*        sit.c:8142 */
#define   ESIT415      (ESITBASE +  415)    /*        sit.c:8152 */
#define   ESIT416      (ESITBASE +  416)    /*        sit.c:8158 */
#define   ESIT417      (ESITBASE +  417)    /*        sit.c:8160 */
#define   ESIT418      (ESITBASE +  418)    /*        sit.c:8162 */
#define   ESIT419      (ESITBASE +  419)    /*        sit.c:8164 */
#define   ESIT420      (ESITBASE +  420)    /*        sit.c:8166 */
#define   ESIT421      (ESITBASE +  421)    /*        sit.c:8171 */
#define   ESIT422      (ESITBASE +  422)    /*        sit.c:8173 */
#define   ESIT423      (ESITBASE +  423)    /*        sit.c:8176 */
#define   ESIT424      (ESITBASE +  424)    /*        sit.c:8179 */
#define   ESIT425      (ESITBASE +  425)    /*        sit.c:8182 */
#define   ESIT426      (ESITBASE +  426)    /*        sit.c:8184 */
#define   ESIT427      (ESITBASE +  427)    /*        sit.c:8189 */
#define   ESIT428      (ESITBASE +  428)    /*        sit.c:8192 */
#define   ESIT429      (ESITBASE +  429)    /*        sit.c:8197 */
#define   ESIT430      (ESITBASE +  430)    /*        sit.c:8199 */
#define   ESIT431      (ESITBASE +  431)    /*        sit.c:8202 */
#define   ESIT432      (ESITBASE +  432)    /*        sit.c:8205 */
#define   ESIT433      (ESITBASE +  433)    /*        sit.c:8208 */
#define   ESIT434      (ESITBASE +  434)    /*        sit.c:8210 */
#define   ESIT435      (ESITBASE +  435)    /*        sit.c:8213 */
#define   ESIT436      (ESITBASE +  436)    /*        sit.c:8215 */
#define   ESIT437      (ESITBASE +  437)    /*        sit.c:8217 */
#define   ESIT438      (ESITBASE +  438)    /*        sit.c:8219 */
#define   ESIT439      (ESITBASE +  439)    /*        sit.c:8221 */
#define   ESIT440      (ESITBASE +  440)    /*        sit.c:8225 */
#define   ESIT441      (ESITBASE +  441)    /*        sit.c:8227 */
#define   ESIT442      (ESITBASE +  442)    /*        sit.c:8232 */
#define   ESIT443      (ESITBASE +  443)    /*        sit.c:8270 */
#define   ESIT444      (ESITBASE +  444)    /*        sit.c:8273 */
#define   ESIT445      (ESITBASE +  445)    /*        sit.c:8275 */
#define   ESIT446      (ESITBASE +  446)    /*        sit.c:8277 */
#define   ESIT447      (ESITBASE +  447)    /*        sit.c:8279 */
#define   ESIT448      (ESITBASE +  448)    /*        sit.c:8282 */
#define   ESIT449      (ESITBASE +  449)    /*        sit.c:8284 */
#define   ESIT450      (ESITBASE +  450)    /*        sit.c:8286 */
#define   ESIT451      (ESITBASE +  451)    /*        sit.c:8288 */
#define   ESIT452      (ESITBASE +  452)    /*        sit.c:8290 */
#define   ESIT453      (ESITBASE +  453)    /*        sit.c:8292 */
#define   ESIT454      (ESITBASE +  454)    /*        sit.c:8294 */
#define   ESIT455      (ESITBASE +  455)    /*        sit.c:8296 */
#define   ESIT456      (ESITBASE +  456)    /*        sit.c:8299 */
#define   ESIT457      (ESITBASE +  457)    /*        sit.c:8301 */
#define   ESIT458      (ESITBASE +  458)    /*        sit.c:8303 */
#define   ESIT459      (ESITBASE +  459)    /*        sit.c:8313 */
#define   ESIT460      (ESITBASE +  460)    /*        sit.c:8358 */
#define   ESIT461      (ESITBASE +  461)    /*        sit.c:8360 */
#define   ESIT462      (ESITBASE +  462)    /*        sit.c:8362 */
#define   ESIT463      (ESITBASE +  463)    /*        sit.c:8364 */
#define   ESIT464      (ESITBASE +  464)    /*        sit.c:8403 */
#define   ESIT465      (ESITBASE +  465)    /*        sit.c:8406 */
#define   ESIT466      (ESITBASE +  466)    /*        sit.c:8409 */
#define   ESIT467      (ESITBASE +  467)    /*        sit.c:8411 */
#define   ESIT468      (ESITBASE +  468)    /*        sit.c:8414 */
#define   ESIT469      (ESITBASE +  469)    /*        sit.c:8418 */
#define   ESIT470      (ESITBASE +  470)    /*        sit.c:8422 */
#define   ESIT471      (ESITBASE +  471)    /*        sit.c:8425 */
#define   ESIT472      (ESITBASE +  472)    /*        sit.c:8428 */
#define   ESIT473      (ESITBASE +  473)    /*        sit.c:8430 */
#define   ESIT474      (ESITBASE +  474)    /*        sit.c:8432 */
#define   ESIT475      (ESITBASE +  475)    /*        sit.c:8434 */
#define   ESIT476      (ESITBASE +  476)    /*        sit.c:8436 */
#define   ESIT477      (ESITBASE +  477)    /*        sit.c:8438 */
#define   ESIT478      (ESITBASE +  478)    /*        sit.c:8440 */
#define   ESIT479      (ESITBASE +  479)    /*        sit.c:8442 */
#define   ESIT480      (ESITBASE +  480)    /*        sit.c:8444 */
#define   ESIT481      (ESITBASE +  481)    /*        sit.c:8447 */
#define   ESIT482      (ESITBASE +  482)    /*        sit.c:8449 */
#define   ESIT483      (ESITBASE +  483)    /*        sit.c:8451 */
#define   ESIT484      (ESITBASE +  484)    /*        sit.c:8455 */
#define   ESIT485      (ESITBASE +  485)    /*        sit.c:8459 */
#define   ESIT486      (ESITBASE +  486)    /*        sit.c:8464 */
#define   ESIT487      (ESITBASE +  487)    /*        sit.c:8468 */
#define   ESIT488      (ESITBASE +  488)    /*        sit.c:8472 */
#define   ESIT489      (ESITBASE +  489)    /*        sit.c:8474 */
#define   ESIT490      (ESITBASE +  490)    /*        sit.c:8513 */
#define   ESIT491      (ESITBASE +  491)    /*        sit.c:8516 */
#define   ESIT492      (ESITBASE +  492)    /*        sit.c:8519 */
#define   ESIT493      (ESITBASE +  493)    /*        sit.c:8558 */
#define   ESIT494      (ESITBASE +  494)    /*        sit.c:8560 */
#define   ESIT495      (ESITBASE +  495)    /*        sit.c:8563 */
#define   ESIT496      (ESITBASE +  496)    /*        sit.c:8566 */
#define   ESIT497      (ESITBASE +  497)    /*        sit.c:8568 */
#define   ESIT498      (ESITBASE +  498)    /*        sit.c:8570 */
#define   ESIT499      (ESITBASE +  499)    /*        sit.c:8572 */
#define   ESIT500      (ESITBASE +  500)    /*        sit.c:8575 */
#define   ESIT501      (ESITBASE +  501)    /*        sit.c:8579 */
#define   ESIT502      (ESITBASE +  502)    /*        sit.c:8620 */
#define   ESIT503      (ESITBASE +  503)    /*        sit.c:8623 */
#define   ESIT504      (ESITBASE +  504)    /*        sit.c:8626 */
#define   ESIT505      (ESITBASE +  505)    /*        sit.c:8665 */
#define   ESIT506      (ESITBASE +  506)    /*        sit.c:8667 */
#define   ESIT507      (ESITBASE +  507)    /*        sit.c:8669 */
#define   ESIT508      (ESITBASE +  508)    /*        sit.c:8671 */
#define   ESIT509      (ESITBASE +  509)    /*        sit.c:8673 */
#define   ESIT510      (ESITBASE +  510)    /*        sit.c:8675 */
#define   ESIT511      (ESITBASE +  511)    /*        sit.c:8677 */
#define   ESIT512      (ESITBASE +  512)    /*        sit.c:8679 */
#define   ESIT513      (ESITBASE +  513)    /*        sit.c:8687 */
#define   ESIT514      (ESITBASE +  514)    /*        sit.c:8693 */
#define   ESIT515      (ESITBASE +  515)    /*        sit.c:8695 */
#define   ESIT516      (ESITBASE +  516)    /*        sit.c:8697 */
#define   ESIT517      (ESITBASE +  517)    /*        sit.c:8699 */
#define   ESIT518      (ESITBASE +  518)    /*        sit.c:8701 */
#define   ESIT519      (ESITBASE +  519)    /*        sit.c:14740 */
#define   ESIT520      (ESITBASE +  520)    /*        sit.c:14741 */
#define   ESIT521      (ESITBASE +  521)    /*        sit.c:14782 */
#define   ESIT522      (ESITBASE +  522)    /*        sit.c:14783 */
#define   ESIT523      (ESITBASE +  523)    /*        sit.c:14827 */
#define   ESIT524      (ESITBASE +  524)    /*        sit.c:14828 */
#define   ESIT525      (ESITBASE +  525)    /*        sit.c:14869 */
#define   ESIT526      (ESITBASE +  526)    /*        sit.c:14870 */
#define   ESIT527      (ESITBASE +  527)    /*        sit.c:14931 */
#define   ESIT528      (ESITBASE +  528)    /*        sit.c:14938 */
#define   ESIT529      (ESITBASE +  529)    /*        sit.c:14939 */
#define   ESIT530      (ESITBASE +  530)    /*        sit.c:14940 */
#define   ESIT531      (ESITBASE +  531)    /*        sit.c:14941 */
#define   ESIT532      (ESITBASE +  532)    /*        sit.c:14942 */
#define   ESIT533      (ESITBASE +  533)    /*        sit.c:14988 */
#define   ESIT534      (ESITBASE +  534)    /*        sit.c:14989 */
#define   ESIT535      (ESITBASE +  535)    /*        sit.c:14990 */
#define   ESIT536      (ESITBASE +  536)    /*        sit.c:14991 */
#define   ESIT537      (ESITBASE +  537)    /*        sit.c:14992 */
#define   ESIT538      (ESITBASE +  538)    /*        sit.c:14998 */
#define   ESIT539      (ESITBASE +  539)    /*        sit.c:15066 */
#define   ESIT540      (ESITBASE +  540)    /*        sit.c:15067 */
#define   ESIT541      (ESITBASE +  541)    /*        sit.c:15068 */
#define   ESIT542      (ESITBASE +  542)    /*        sit.c:15069 */
#define   ESIT543      (ESITBASE +  543)    /*        sit.c:15114 */
#define   ESIT544      (ESITBASE +  544)    /*        sit.c:15115 */
#define   ESIT545      (ESITBASE +  545)    /*        sit.c:15116 */
#define   ESIT546      (ESITBASE +  546)    /*        sit.c:15117 */
#define   ESIT547      (ESITBASE +  547)    /*        sit.c:15186 */
#define   ESIT548      (ESITBASE +  548)    /*        sit.c:15194 */
#define   ESIT549      (ESITBASE +  549)    /*        sit.c:15195 */
#define   ESIT550      (ESITBASE +  550)    /*        sit.c:15196 */
#define   ESIT551      (ESITBASE +  551)    /*        sit.c:15197 */
#define   ESIT552      (ESITBASE +  552)    /*        sit.c:15243 */
#define   ESIT553      (ESITBASE +  553)    /*        sit.c:15244 */
#define   ESIT554      (ESITBASE +  554)    /*        sit.c:15245 */
#define   ESIT555      (ESITBASE +  555)    /*        sit.c:15246 */
#define   ESIT556      (ESITBASE +  556)    /*        sit.c:15254 */
#define   ESIT557      (ESITBASE +  557)    /*        sit.c:15323 */
#define   ESIT558      (ESITBASE +  558)    /*        sit.c:15324 */
#define   ESIT559      (ESITBASE +  559)    /*        sit.c:15325 */
#define   ESIT560      (ESITBASE +  560)    /*        sit.c:15326 */
#define   ESIT561      (ESITBASE +  561)    /*        sit.c:15371 */
#define   ESIT562      (ESITBASE +  562)    /*        sit.c:15372 */
#define   ESIT563      (ESITBASE +  563)    /*        sit.c:15373 */
#define   ESIT564      (ESITBASE +  564)    /*        sit.c:15374 */
#define   ESIT565      (ESITBASE +  565)    /*        sit.c:15445 */
#define   ESIT566      (ESITBASE +  566)    /*        sit.c:15446 */
#define   ESIT567      (ESITBASE +  567)    /*        sit.c:15454 */
#define   ESIT568      (ESITBASE +  568)    /*        sit.c:15455 */
#define   ESIT569      (ESITBASE +  569)    /*        sit.c:15456 */
#define   ESIT570      (ESITBASE +  570)    /*        sit.c:15457 */
#define   ESIT571      (ESITBASE +  571)    /*        sit.c:15505 */
#define   ESIT572      (ESITBASE +  572)    /*        sit.c:15506 */
#define   ESIT573      (ESITBASE +  573)    /*        sit.c:15507 */
#define   ESIT574      (ESITBASE +  574)    /*        sit.c:15508 */
#define   ESIT575      (ESITBASE +  575)    /*        sit.c:15516 */
#define   ESIT576      (ESITBASE +  576)    /*        sit.c:15517 */
#define   ESIT577      (ESITBASE +  577)    /*        sit.c:15582 */
#define   ESIT578      (ESITBASE +  578)    /*        sit.c:15589 */
#define   ESIT579      (ESITBASE +  579)    /*        sit.c:15590 */
#define   ESIT580      (ESITBASE +  580)    /*        sit.c:15591 */
#define   ESIT581      (ESITBASE +  581)    /*        sit.c:15592 */
#define   ESIT582      (ESITBASE +  582)    /*        sit.c:15639 */
#define   ESIT583      (ESITBASE +  583)    /*        sit.c:15640 */
#define   ESIT584      (ESITBASE +  584)    /*        sit.c:15641 */
#define   ESIT585      (ESITBASE +  585)    /*        sit.c:15642 */
#define   ESIT586      (ESITBASE +  586)    /*        sit.c:15648 */
#define   ESIT587      (ESITBASE +  587)    /*        sit.c:15716 */
#define   ESIT588      (ESITBASE +  588)    /*        sit.c:15717 */
#define   ESIT589      (ESITBASE +  589)    /*        sit.c:15718 */
#define   ESIT590      (ESITBASE +  590)    /*        sit.c:15719 */
#define   ESIT591      (ESITBASE +  591)    /*        sit.c:15764 */
#define   ESIT592      (ESITBASE +  592)    /*        sit.c:15765 */
#define   ESIT593      (ESITBASE +  593)    /*        sit.c:15766 */
#define   ESIT594      (ESITBASE +  594)    /*        sit.c:15767 */
#define   ESIT595      (ESITBASE +  595)    /*        sit.c:15839 */
#define   ESIT596      (ESITBASE +  596)    /*        sit.c:15840 */
#define   ESIT597      (ESITBASE +  597)    /*        sit.c:15841 */
#define   ESIT598      (ESITBASE +  598)    /*        sit.c:15842 */
#define   ESIT599      (ESITBASE +  599)    /*        sit.c:15887 */
#define   ESIT600      (ESITBASE +  600)    /*        sit.c:15888 */
#define   ESIT601      (ESITBASE +  601)    /*        sit.c:15889 */
#define   ESIT602      (ESITBASE +  602)    /*        sit.c:15890 */
#define   ESIT603      (ESITBASE +  603)    /*        sit.c:15966 */
#define   ESIT604      (ESITBASE +  604)    /*        sit.c:15967 */
#define   ESIT605      (ESITBASE +  605)    /*        sit.c:15968 */
#define   ESIT606      (ESITBASE +  606)    /*        sit.c:15969 */
#define   ESIT607      (ESITBASE +  607)    /*        sit.c:15970 */
#define   ESIT608      (ESITBASE +  608)    /*        sit.c:16016 */
#define   ESIT609      (ESITBASE +  609)    /*        sit.c:16017 */
#define   ESIT610      (ESITBASE +  610)    /*        sit.c:16018 */
#define   ESIT611      (ESITBASE +  611)    /*        sit.c:16019 */
#define   ESIT612      (ESITBASE +  612)    /*        sit.c:16020 */
#define   ESIT613      (ESITBASE +  613)    /*        sit.c:16096 */
#define   ESIT614      (ESITBASE +  614)    /*        sit.c:16097 */
#define   ESIT615      (ESITBASE +  615)    /*        sit.c:16098 */
#define   ESIT616      (ESITBASE +  616)    /*        sit.c:16099 */
#define   ESIT617      (ESITBASE +  617)    /*        sit.c:16100 */
#define   ESIT618      (ESITBASE +  618)    /*        sit.c:16146 */
#define   ESIT619      (ESITBASE +  619)    /*        sit.c:16147 */
#define   ESIT620      (ESITBASE +  620)    /*        sit.c:16148 */
#define   ESIT621      (ESITBASE +  621)    /*        sit.c:16149 */
#define   ESIT622      (ESITBASE +  622)    /*        sit.c:16150 */
#define   ESIT623      (ESITBASE +  623)    /*        sit.c:16226 */
#define   ESIT624      (ESITBASE +  624)    /*        sit.c:16227 */
#define   ESIT625      (ESITBASE +  625)    /*        sit.c:16228 */
#define   ESIT626      (ESITBASE +  626)    /*        sit.c:16229 */
#define   ESIT627      (ESITBASE +  627)    /*        sit.c:16230 */
#define   ESIT628      (ESITBASE +  628)    /*        sit.c:16276 */
#define   ESIT629      (ESITBASE +  629)    /*        sit.c:16277 */
#define   ESIT630      (ESITBASE +  630)    /*        sit.c:16278 */
#define   ESIT631      (ESITBASE +  631)    /*        sit.c:16279 */
#define   ESIT632      (ESITBASE +  632)    /*        sit.c:16280 */
#define   ESIT633      (ESITBASE +  633)    /*        sit.c:16356 */
#define   ESIT634      (ESITBASE +  634)    /*        sit.c:16357 */
#define   ESIT635      (ESITBASE +  635)    /*        sit.c:16358 */
#define   ESIT636      (ESITBASE +  636)    /*        sit.c:16359 */
#define   ESIT637      (ESITBASE +  637)    /*        sit.c:16360 */
#define   ESIT638      (ESITBASE +  638)    /*        sit.c:16406 */
#define   ESIT639      (ESITBASE +  639)    /*        sit.c:16407 */
#define   ESIT640      (ESITBASE +  640)    /*        sit.c:16408 */
#define   ESIT641      (ESITBASE +  641)    /*        sit.c:16409 */
#define   ESIT642      (ESITBASE +  642)    /*        sit.c:16410 */
#define   ESIT643      (ESITBASE +  643)    /*        sit.c:16482 */
#define   ESIT644      (ESITBASE +  644)    /*        sit.c:16483 */
#define   ESIT645      (ESITBASE +  645)    /*        sit.c:16484 */
#define   ESIT646      (ESITBASE +  646)    /*        sit.c:16485 */
#define   ESIT647      (ESITBASE +  647)    /*        sit.c:16530 */
#define   ESIT648      (ESITBASE +  648)    /*        sit.c:16531 */
#define   ESIT649      (ESITBASE +  649)    /*        sit.c:16532 */
#define   ESIT650      (ESITBASE +  650)    /*        sit.c:16533 */
#define   ESIT651      (ESITBASE +  651)    /*        sit.c:16607 */
#define   ESIT652      (ESITBASE +  652)    /*        sit.c:16608 */
#define   ESIT653      (ESITBASE +  653)    /*        sit.c:16609 */
#define   ESIT654      (ESITBASE +  654)    /*        sit.c:16610 */
#define   ESIT655      (ESITBASE +  655)    /*        sit.c:16655 */
#define   ESIT656      (ESITBASE +  656)    /*        sit.c:16656 */
#define   ESIT657      (ESITBASE +  657)    /*        sit.c:16657 */
#define   ESIT658      (ESITBASE +  658)    /*        sit.c:16658 */
#define   ESIT659      (ESITBASE +  659)    /*        sit.c:16731 */
#define   ESIT660      (ESITBASE +  660)    /*        sit.c:16732 */
#define   ESIT661      (ESITBASE +  661)    /*        sit.c:16733 */
#define   ESIT662      (ESITBASE +  662)    /*        sit.c:16734 */
#define   ESIT663      (ESITBASE +  663)    /*        sit.c:16779 */
#define   ESIT664      (ESITBASE +  664)    /*        sit.c:16780 */
#define   ESIT665      (ESITBASE +  665)    /*        sit.c:16781 */
#define   ESIT666      (ESITBASE +  666)    /*        sit.c:16782 */
#define   ESIT667      (ESITBASE +  667)    /*        sit.c:16853 */
#define   ESIT668      (ESITBASE +  668)    /*        sit.c:16854 */
#define   ESIT669      (ESITBASE +  669)    /*        sit.c:16855 */
#define   ESIT670      (ESITBASE +  670)    /*        sit.c:16856 */
#define   ESIT671      (ESITBASE +  671)    /*        sit.c:16901 */
#define   ESIT672      (ESITBASE +  672)    /*        sit.c:16902 */
#define   ESIT673      (ESITBASE +  673)    /*        sit.c:16903 */
#define   ESIT674      (ESITBASE +  674)    /*        sit.c:16904 */
#define   ESIT675      (ESITBASE +  675)    /*        sit.c:16987 */
#define   ESIT676      (ESITBASE +  676)    /*        sit.c:16988 */
#define   ESIT677      (ESITBASE +  677)    /*        sit.c:16989 */
#define   ESIT678      (ESITBASE +  678)    /*        sit.c:16990 */
#define   ESIT679      (ESITBASE +  679)    /*        sit.c:16991 */
#define   ESIT680      (ESITBASE +  680)    /*        sit.c:16992 */
#define   ESIT681      (ESITBASE +  681)    /*        sit.c:16993 */
#define   ESIT682      (ESITBASE +  682)    /*        sit.c:17041 */
#define   ESIT683      (ESITBASE +  683)    /*        sit.c:17042 */
#define   ESIT684      (ESITBASE +  684)    /*        sit.c:17043 */
#define   ESIT685      (ESITBASE +  685)    /*        sit.c:17044 */
#define   ESIT686      (ESITBASE +  686)    /*        sit.c:17045 */
#define   ESIT687      (ESITBASE +  687)    /*        sit.c:17046 */
#define   ESIT688      (ESITBASE +  688)    /*        sit.c:17047 */
#define   ESIT689      (ESITBASE +  689)    /*        sit.c:17134 */
#define   ESIT690      (ESITBASE +  690)    /*        sit.c:17135 */
#define   ESIT691      (ESITBASE +  691)    /*        sit.c:17136 */
#define   ESIT692      (ESITBASE +  692)    /*        sit.c:17137 */
#define   ESIT693      (ESITBASE +  693)    /*        sit.c:17138 */
#define   ESIT694      (ESITBASE +  694)    /*        sit.c:17139 */
#define   ESIT695      (ESITBASE +  695)    /*        sit.c:17140 */
#define   ESIT696      (ESITBASE +  696)    /*        sit.c:17188 */
#define   ESIT697      (ESITBASE +  697)    /*        sit.c:17189 */
#define   ESIT698      (ESITBASE +  698)    /*        sit.c:17190 */
#define   ESIT699      (ESITBASE +  699)    /*        sit.c:17191 */
#define   ESIT700      (ESITBASE +  700)    /*        sit.c:17192 */
#define   ESIT701      (ESITBASE +  701)    /*        sit.c:17193 */
#define   ESIT702      (ESITBASE +  702)    /*        sit.c:17194 */
#define   ESIT703      (ESITBASE +  703)    /*        sit.c:17270 */
#define   ESIT704      (ESITBASE +  704)    /*        sit.c:17271 */
#define   ESIT705      (ESITBASE +  705)    /*        sit.c:17272 */
#define   ESIT706      (ESITBASE +  706)    /*        sit.c:17273 */
#define   ESIT707      (ESITBASE +  707)    /*        sit.c:17318 */
#define   ESIT708      (ESITBASE +  708)    /*        sit.c:17319 */
#define   ESIT709      (ESITBASE +  709)    /*        sit.c:17320 */
#define   ESIT710      (ESITBASE +  710)    /*        sit.c:17321 */
#define   ESIT711      (ESITBASE +  711)    /*        sit.c:17395 */
#define   ESIT712      (ESITBASE +  712)    /*        sit.c:17396 */
#define   ESIT713      (ESITBASE +  713)    /*        sit.c:17397 */
#define   ESIT714      (ESITBASE +  714)    /*        sit.c:17398 */
#define   ESIT715      (ESITBASE +  715)    /*        sit.c:17443 */
#define   ESIT716      (ESITBASE +  716)    /*        sit.c:17444 */
#define   ESIT717      (ESITBASE +  717)    /*        sit.c:17445 */
#define   ESIT718      (ESITBASE +  718)    /*        sit.c:17446 */
#define   ESIT719      (ESITBASE +  719)    /*        sit.c:17520 */
#define   ESIT720      (ESITBASE +  720)    /*        sit.c:17521 */
#define   ESIT721      (ESITBASE +  721)    /*        sit.c:17522 */
#define   ESIT722      (ESITBASE +  722)    /*        sit.c:17523 */
#define   ESIT723      (ESITBASE +  723)    /*        sit.c:17568 */
#define   ESIT724      (ESITBASE +  724)    /*        sit.c:17569 */
#define   ESIT725      (ESITBASE +  725)    /*        sit.c:17570 */
#define   ESIT726      (ESITBASE +  726)    /*        sit.c:17571 */
#define   ESIT727      (ESITBASE +  727)    /*        sit.c:17645 */
#define   ESIT728      (ESITBASE +  728)    /*        sit.c:17646 */
#define   ESIT729      (ESITBASE +  729)    /*        sit.c:17647 */
#define   ESIT730      (ESITBASE +  730)    /*        sit.c:17648 */
#define   ESIT731      (ESITBASE +  731)    /*        sit.c:17693 */
#define   ESIT732      (ESITBASE +  732)    /*        sit.c:17694 */
#define   ESIT733      (ESITBASE +  733)    /*        sit.c:17695 */
#define   ESIT734      (ESITBASE +  734)    /*        sit.c:17696 */
#define   ESIT735      (ESITBASE +  735)    /*        sit.c:17761 */
#define   ESIT736      (ESITBASE +  736)    /*        sit.c:17762 */
#define   ESIT737      (ESITBASE +  737)    /*        sit.c:17763 */
#define   ESIT738      (ESITBASE +  738)    /*        sit.c:17764 */
#define   ESIT739      (ESITBASE +  739)    /*        sit.c:17808 */
#define   ESIT740      (ESITBASE +  740)    /*        sit.c:17809 */
#define   ESIT741      (ESITBASE +  741)    /*        sit.c:17810 */
#define   ESIT742      (ESITBASE +  742)    /*        sit.c:17811 */
#define   ESIT743      (ESITBASE +  743)    /*        sit.c:17869 */
#define   ESIT744      (ESITBASE +  744)    /*        sit.c:17870 */
#define   ESIT745      (ESITBASE +  745)    /*        sit.c:17871 */
#define   ESIT746      (ESITBASE +  746)    /*        sit.c:17872 */
#define   ESIT747      (ESITBASE +  747)    /*        sit.c:17916 */
#define   ESIT748      (ESITBASE +  748)    /*        sit.c:17917 */
#define   ESIT749      (ESITBASE +  749)    /*        sit.c:17918 */
#define   ESIT750      (ESITBASE +  750)    /*        sit.c:17919 */
#define   ESIT751      (ESITBASE +  751)    /*        sit.c:17966 */
#define   ESIT752      (ESITBASE +  752)    /*        sit.c:17967 */
#define   ESIT753      (ESITBASE +  753)    /*        sit.c:18008 */
#define   ESIT754      (ESITBASE +  754)    /*        sit.c:18009 */
#define   ESIT755      (ESITBASE +  755)    /*        sit.c:18054 */
#define   ESIT756      (ESITBASE +  756)    /*        sit.c:18055 */
#define   ESIT757      (ESITBASE +  757)    /*        sit.c:18056 */
#define   ESIT758      (ESITBASE +  758)    /*        sit.c:18057 */
#define   ESIT759      (ESITBASE +  759)    /*        sit.c:18100 */
#define   ESIT760      (ESITBASE +  760)    /*        sit.c:18101 */
#define   ESIT761      (ESITBASE +  761)    /*        sit.c:18102 */
#define   ESIT762      (ESITBASE +  762)    /*        sit.c:18103 */
#define   ESIT763      (ESITBASE +  763)    /*        sit.c:18182 */
#define   ESIT764      (ESITBASE +  764)    /*        sit.c:18183 */
#define   ESIT765      (ESITBASE +  765)    /*        sit.c:18184 */
#define   ESIT766      (ESITBASE +  766)    /*        sit.c:18185 */
#define   ESIT767      (ESITBASE +  767)    /*        sit.c:18186 */
#define   ESIT768      (ESITBASE +  768)    /*        sit.c:18233 */
#define   ESIT769      (ESITBASE +  769)    /*        sit.c:18234 */
#define   ESIT770      (ESITBASE +  770)    /*        sit.c:18235 */
#define   ESIT771      (ESITBASE +  771)    /*        sit.c:18236 */
#define   ESIT772      (ESITBASE +  772)    /*        sit.c:18237 */
#define   ESIT773      (ESITBASE +  773)    /*        sit.c:18339 */
#define   ESIT774      (ESITBASE +  774)    /*        sit.c:18340 */
#define   ESIT775      (ESITBASE +  775)    /*        sit.c:18341 */
#define   ESIT776      (ESITBASE +  776)    /*        sit.c:18342 */
#define   ESIT777      (ESITBASE +  777)    /*        sit.c:18343 */
#define   ESIT778      (ESITBASE +  778)    /*        sit.c:18390 */
#define   ESIT779      (ESITBASE +  779)    /*        sit.c:18391 */
#define   ESIT780      (ESITBASE +  780)    /*        sit.c:18392 */
#define   ESIT781      (ESITBASE +  781)    /*        sit.c:18393 */
#define   ESIT782      (ESITBASE +  782)    /*        sit.c:18394 */
/* sit_h_001.main_49: Added Error codes */
#define   ESIT783      (ESITBASE +  783)    /*        sit.c:18394 */
#define   ESIT784      (ESITBASE +  784)    /*        sit.c:18394 */
#define   ESIT785      (ESITBASE +  785)    /*        sit.c:18394 */
#define   ESIT786      (ESITBASE +  786)    /*        sit.c:18394 */

#endif /* __SITH__ */
  
/********************************************************************30**
  
         End of file:     sit.h@@/main/50 - Thu Jun  3 13:54:16 2010

*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  bn    1. initial release
             ---  jrl   2. trillium development system checkpoint (dvs)
                           at version: 1.0.0.0

1.2          ---  rk    1. add support of ANSI

1.3          ---  jrl   1. text changes

1.4          ---  rhk   1. added support for ansi 92.

1.5          ---  bn    1. change CIRGRP values

1.6          ---  bn    1. move nature of circuit and nature of address
                           to lm_pt.h

1.7          ---  bn    1. changes to support new interface

1.8          ---  bn    1. added CIRGRPRESACK
             ---  bn    2. changed defines for LOC_ to ILOC_ and for RAH_
                           to IRAH_ to avoid redefinition when linked with
                           other products.

1.9          ---  bn    1. added defines required by new elements for 
                           SW_Q767 and SW_SINGTEL.
             ---  bn    2. added defines for new events for CnSt primitives.

1.10         ---  bn    1. added define for Call Offering event for CnStEvnt
                           for Italian Q767

1.11         ---  bn    1. corrections for Italian Q767.
             ---  bn    2. corrected defines for ANSI92

1.12         ---  bn    1. moved defines for PRESALLOW, PRESREST to gen.h

1.13         ---  bn    1. moved define for SS_ISUP to gen.x.

1.14         ---  dm    1. added defines for ANSI92 Cause Indicators Parameter
             ---  bn    2. moved define for CIRRESREQLOC from si.h

1.15         ---  pc    1. added ETSI variant for SI

1.16         ---  dm    1. added GT_FTZ variant for SI
             ---  dm    2. added defines for PAUSE and RESUME status 
                           indications to call control
             ---  dm    3. added defines for Facility primitive

*********************************************************************81*/

/********************************************************************90**
 
    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
1.17         ---      dm   1. removed "#if 0" (si00x.210)
             ---      ao   2. added new defines for status primitives
             ---      dm   3. added new defines for status primitives
                              for congestion 

1.18         ---      ao   1. added ILOC_LOCALIF define
             ---      rh   1. Added exchange type definitions for Type A,
                              Type B.
 
1.19         ---      fl   1. miscellaneous text changes.
1.20         ---      ao   1. added release cause define for local 
                              number portability
1.21         ---      rs   1. Added CCNOPARAMDISCMSG for parameter 
                              compatibility
             ---      rs   1. Added defines for unrecognized event.
                      rs   2. Added defines for Mngmt local blocking.
                      rs   3. Added define SIT_STA_OVERLOAD
                      ym   1. Added defines SIT_STA_LM*REQ where * is
                              CGB,CGU and GRS
1.22         ---      ao   1. Added Russian variant

1.23         ---      bn   1. Added bellcore variant

1.24         ---      bn   1. Added new defines for bellcore variant.
1.24+        ---      ym   1. More defines are added for the originating
                              line information parameter.
                           2. Added define for CGB info ind event type.

1.25         ---      ym   1. Added new defines for NTT variant.
1.26         ---      ym   1. Values of ILOC_PUBNETRU & ILOC_PRIVNETRU
                              are corrected.
/main/28     ---      sk   1. New hash defines for notification indicator 
                      bsp  1. Added hash defines needed by parameters,
                              which were added for ANS95, ITU97 and ETSIv3
                              specifications.
                      hy   1. Added hash define for exchange type on
                              broadband/narrowband interworking.
                           2. Added define SIT_STA_CIRLOCGRS.
                      bsp  1. Changed hash define names which were changed
                           2. New hash defines for Calling Party Number
                           3. Removed "#if 1", "#if 0" and patch comments.
                           4. Removed duplicate CSTD_CCITT, CSTD_INT,
                              CSTD_NAT, CSTD_NET
                      hy   1. Added error code for 2.19 release.
/main/29     ---      hy   1. Added a new status event type SIT_STA_GRSRSPIND
/main/30     ---      hy   1. Added a new defines for user to service indicator
                              and info request indicators. 
/main/31     ---      hy   1.Added a new status event type SIT_STA_RLCIND
/main/32     ---      hy   1. Added interface version number, bit vectors and 
                              default value in base release for rolling upgrade 
                           2. Moved the defines for ESIT's (errors) within the
                              __SITH__ defines
                           3. Modified the #if SIT_PARAMETER to 
                              #if (defined(SIT_PARAMETER) || 
                                   defined(TDS_ROLL_UPGRADE_SUPPORT))
/main/33     ---      mm   1. Added reserved values according to ITU92.
                           2. Incremented interface version number.
                           3. Removed the SITV1 flags for bit vector defines.
/main/34     ---      tz   1. Added defines for Indian variant.
                           2. Added defines for OLI parameter. 
/main/35     ---      rk   1. Transit network parameter for ansi specs 
                              defined. This parameter is under TNS_ANSI 
                              compile time flag as it is a particular 
                              customer requirement. We assume that 
                              encoding/decoding of the TNS parameter 
                              will be done by user.
                           2. Following defines added for user rate info as per Q.931.
                               SIT_UR_64000 - 0x10 Unrestricted 64 kbit/s
                               SIT_UR_57600 - 0x12 57.6 kbit/s reco v.14 extended
                               SIT_UR_28800 - 0x13 28.8 kbit/s reco v.110
                               SIT_UR_24000 - 0x14 24 kbit/s v.110
                           3. New status event for Timer expiry (SIT_STA_TMREXP) 
                              added (under compile time flag : SIT_TMREXP)
/main/36     ---       bn   1. Added ITU2000 and Russian 2000 ISUP variants.
/main/37     ---       vp   1. Added UK variant
sit_h_001.main_37      vp   1. Added new define SRV_RSP_NOT_PROVIDED
sit_h_001.main_38      rks  1. Added new define "PRESNEWRES" for presentation
                               restriction in CgPn for UK variant
sit_h_001.main_39     rks   1. Added defines specific to New Zealand variant
sit_h_001.main_40     rks   1. Added defines for spare values for User to 
                               user indicator
                            2. Added define for pass on not possible for PCI
sit_h_001.main_41     rks   1. Added defines for OLM event( si072.220 )
*************************************************************************

Version    Patch            Initials     Description
-------- -----------------  --------  ---------------------------------
2.21     sit_h_001.main_43  rkumar    1. Initial release.
2.21     sit_h_001.main_44  rkumar    1. Added define for 38.4 kbits/s
                                         Recommendation V.110
2.21     sit_h_001.main_45  rkumar    1. Added define for bit vector for ISUP Kazakhstan 
2.21     sit_h_001.main_46  ckumar    1. Added define for cause value for CGPN SUCCESS/
                                         FAILURE
2.21     sit_h_001.main_47  ckumar    1. Added define for Calling party number check
                                         results.
                                      2. Added defines for video conferencing and
                                         Audiographic conferencing recommendations,
                                         multimedia and audio visual services.
2.21     sit_h_001.main_48  kchaitanya  1. Added defines for Brazilian ISUP
2.21     sit_h_001.main_49  kchaitanya  1. Added defines for Ukraine ISUP
*********************************************************************91*/
