/********************************************************************16**

        (c) COPYRIGHT 1989-1998 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     ss7 data link layer
  
     Type:     C include file
  
     Desc:     Defines required by the data link layer service user for MTP.
   
     File:     sdt.h
  
     Sid:      sdt.h@@/main/17 - Wed Mar 22 05:34:52 2006
  
     Prg:      na
  
*********************************************************************21*/

#ifndef __SDTH__
#define __SDTH__

  
/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000027     SS7 - MTP Level 2
*     1000028     SS7 - MTP Level 3
*     1000063     Service Specific Coordination Function - Q.2140
*
*/
  
/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*
*/


/* defines */

/* defines for DLConReq */

#define DL_CON_L1           0     /* connect Level 1 */
#define DL_CON_L2_EMRG      1     /* connect Level 2 in emergency state */
#define DL_CON_L2_NORM      2     /* connect Level 2 in normal state */
#define DL_CON_L1L2_EMRG    3     /* connect Level 1 and 2 in emergency state */
#define DL_CON_L1L2_NORM    4     /* connect Level 1 and 2 in normal state */
#define DL_POWER_ON         5     /* send the power on start */
#define DL_START            6     /* send the LSC start */
                            
/* defines for DLUbndReq */

#define DL_UBNDREQ     1     /* Requested */

/* defines for DLFlcReq and DLFlcInd */

#define DL_STARTFLC    0     /* Start Flow Control */
#define DL_ENDFLC      1     /* End Flow Control */

/* defines for DLDiscInd & DLDiscReq */
  
#define DL_DISC_SM               0     /* stack manager */
#define DL_DISC_SUERM            1     /* signal unit error rate monitor */
#define DL_DISC_ALIGN            2     /* realignment */
#define DL_DISC_ACK              3     /* delay of acknowledgement */
#define DL_DISC_TE               4     /* failure of TE equipment */
#define DL_DISC_BSN              5     /* 2 out 3 BSN */
#define DL_DISC_FIB              6     /* 2 out 3 FIB */
#define DL_DISC_LSSU             7     /* LSSU condition */
#define DL_DISC_CONG             8     /* too much congestion */
#define DL_CLROORD               9     /* clear - out of order */
#define DL_DISC_L1              10     /* disconnect and bring down L1 */
#define DL_DISC_TYPE            11     /* pdu type INS or NM (q.2140) */
#define DL_DISC_SYNC            12     /* resync indication (q.2140) */
#define DL_DISC_LSSU_SIOS       13     /* SIOS recieved in LSC  */
#define DL_DISC_TMR2_EXP        14     /* TMR2 expired waiting for SIO */
#define DL_DISC_TMR3_EXP        15     /* TMR3 expired waiting for SIN/SIE */
#define DL_DISC_LSSU_SIOS_IAC   16     /* SIOS recieved in IAC */
#define DL_DISC_PROV_FAIL       17     /* proving failure   */
#define DL_DISC_TMR1_EXP        18     /* timer 1 expired waiting for FISU */
#define DL_DISC_LSSU_SIN        19     /* SIN when inservice or proc out */
#define DL_DISC_CTS_LOST        20     /* CTS lost from MAC  */

#ifdef SDT2
#define DL_DISC_DAT_IN_OOS      21     /* data request in OOS state  */
#define DL_DISC_DAT_IN_LOCPRCOUT       22     
                             /* data request while in local processor outage */
#define DL_DISC_DAT_IN_WAITFLUSHCONT   23     
                             /* data request while waiting for flush/continue */
#define DL_DISC_RETRV_IN_INS           24     
                             /* retrieve request in inservice state*/
#define DL_DISC_DROP_IN_INS            25     
                             /* drop msg request in inservice state*/
#define DL_DISC_CON_IN_INS             26     
                             /* connect request in inservice state*/
#endif /* SDT2 */

#define DL_DISC_UPPER_SAP_DIS          27     
                             /* upper sap disable request from management */
#define DL_DISC_L2                     28     /* disconnect layer 2 only */

#ifdef SD_HSL
#define DL_DISC_EIM                    29     /* errored interval monitor */
#endif  /* HIGH_SPEED_SIGNALING_SUPPORT */

/* defines for DLDatCfm */

#define DL_TX_NACK_MORE    0    /* buffer transmitted, not acknowledged, more */
#define DL_TX_NACK_NO_MORE 1    /* buffer transmitted, not ack, no more */
#define DL_TX_CREDIT       2    /* credit reference only */

/* defines for DLStaReq actions */

#define DL_NO_ACTION       0    /* no action */
#define DL_RETRV_BSN       1    /* retrieve backward sequence number */
#define DL_RETRV_MSG       2    /* retrieve messages */
#define DL_DROP_MSGQ       3    /* drop message queue */
#ifdef SDT2
#define DL_FLC_STAT        4    /* flow control status */
#endif
/* defines for DLStaReq status */

#define DL_LOC_PROC_DN     0    /* local processor down */
#define DL_LOC_PROC_UP     1    /* local processor up */
#define DL_EMERGENCY       2    /* signal emergency */
#define DL_EMRGCY_CEASES   3    /* signal emergency ceases */
#define DL_FLUSH_BUF       4    /* flush buffers */
#define DL_CONTINUE        5    /* continue */

/* defines for DLStaCfm actions */

#define DL_RETRV_EMPTY     3    /* transmit Q empty */

/* defines for DLStaInd */

#define DL_REM_PROC_DN 0      /* remote processor down */
#define DL_REM_PROC_UP 1      /* remote processor up */

/* event code for task to task header */
 
#define EVTSDTBNDREQ       0x04             /* Bind request */
#define EVTSDTBNDCFM       0x05             /* Bind confirm */
 
#define EVTSDTUBNDREQ      0x08             /* Unbind request */
  
#define EVTSDTCONREQ       0x0C             /* Connect request */
#define EVTSDTCONCFM       0x0D             /* Connect confirm */
  
#define EVTSDTDISCREQ      0x10             /* Disconnect request */
#define EVTSDTDISCIND      0x12             /* Disconnect indication */
 
#define EVTSDTDATREQ       0x14             /* Data request */
#define EVTSDTDATCFM       0x15             /* Data confirm */
#define EVTSDTDATIND       0x16             /* Data indication */
  
#define EVTSDTFLCREQ       0x28             /* Flow control request */
#define EVTSDTFLCIND       0x2A             /* Flow control indication */
                     
#define EVTSDTSTAREQ       0x78             /* Status request */
#define EVTSDTSTACFM       0x79             /* Status confirm */
#define EVTSDTSTAIND       0x7A             /* Status indication */

/* define for SLogError */
 
#define SDTLOGERROR(errCls, errCode, errVal, errDesc) \
        SLogError(pst->srcEnt, pst->srcInst, pst->srcProcId, __FILE__, __LINE__, \
                  errCls, errCode, errVal, errDesc)
 
           

/* Error codes for packing/unpacking functions */

#define ESDTBASE  0           /* reserved */
#define ESDTXXX   (ESDTBASE)  /* reserved */


#define   ESDT001      (ESDTBASE +    1)    /*        sdt.c: 154 */
#define   ESDT002      (ESDTBASE +    2)    /*        sdt.c: 155 */
#define   ESDT003      (ESDTBASE +    3)    /*        sdt.c: 196 */
#define   ESDT004      (ESDTBASE +    4)    /*        sdt.c: 237 */
#define   ESDT005      (ESDTBASE +    5)    /*        sdt.c: 238 */
#define   ESDT006      (ESDTBASE +    6)    /*        sdt.c: 239 */
#define   ESDT007      (ESDTBASE +    7)    /*        sdt.c: 275 */
#define   ESDT008      (ESDTBASE +    8)    /*        sdt.c: 318 */
#define   ESDT009      (ESDTBASE +    9)    /*        sdt.c: 319 */
#define   ESDT010      (ESDTBASE +   10)    /*        sdt.c: 361 */
#define   ESDT011      (ESDTBASE +   11)    /*        sdt.c: 362 */
#define   ESDT012      (ESDTBASE +   12)    /*        sdt.c: 407 */
#define   ESDT013      (ESDTBASE +   13)    /*        sdt.c: 408 */
#define   ESDT014      (ESDTBASE +   14)    /*        sdt.c: 409 */
#define   ESDT015      (ESDTBASE +   15)    /*        sdt.c: 453 */
#define   ESDT016      (ESDTBASE +   16)    /*        sdt.c: 454 */
#define   ESDT017      (ESDTBASE +   17)    /*        sdt.c: 493 */
#define   ESDT018      (ESDTBASE +   18)    /*        sdt.c: 531 */
#define   ESDT019      (ESDTBASE +   19)    /*        sdt.c: 532 */
#define   ESDT020      (ESDTBASE +   20)    /*        sdt.c: 573 */
#define   ESDT021      (ESDTBASE +   21)    /*        sdt.c: 574 */
#define   ESDT022      (ESDTBASE +   22)    /*        sdt.c: 614 */
#define   ESDT023      (ESDTBASE +   23)    /*        sdt.c: 615 */
#define   ESDT024      (ESDTBASE +   24)    /*        sdt.c: 654 */
#define   ESDT025      (ESDTBASE +   25)    /*        sdt.c: 655 */
#define   ESDT026      (ESDTBASE +   26)    /*        sdt.c: 694 */
#define   ESDT027      (ESDTBASE +   27)    /*        sdt.c: 695 */
#define   ESDT028      (ESDTBASE +   28)    /*        sdt.c: 734 */
#define   ESDT029      (ESDTBASE +   29)    /*        sdt.c: 735 */
#define   ESDT030      (ESDTBASE +   30)    /*        sdt.c: 736 */
#define   ESDT031      (ESDTBASE +   31)    /*        sdt.c: 779 */
#define   ESDT032      (ESDTBASE +   32)    /*        sdt.c: 782 */
#define   ESDT033      (ESDTBASE +   33)    /*        sdt.c: 783 */
#define   ESDT034      (ESDTBASE +   34)    /*        sdt.c: 828 */
#define   ESDT035      (ESDTBASE +   35)    /*        sdt.c: 831 */
#define   ESDT036      (ESDTBASE +   36)    /*        sdt.c: 832 */
#define   ESDT037      (ESDTBASE +   37)    /*        sdt.c: 869 */
#define   ESDT038      (ESDTBASE +   38)    /*        sdt.c: 913 */
#define   ESDT039      (ESDTBASE +   39)    /*        sdt.c: 916 */
#define   ESDT040      (ESDTBASE +   40)    /*        sdt.c: 917 */
#define   ESDT041      (ESDTBASE +   41)    /*        sdt.c: 961 */
#define   ESDT042      (ESDTBASE +   42)    /*        sdt.c: 964 */
#define   ESDT043      (ESDTBASE +   43)    /*        sdt.c: 965 */
#define   ESDT044      (ESDTBASE +   44)    /*        sdt.c:1009 */
#define   ESDT045      (ESDTBASE +   45)    /*        sdt.c:1012 */
#define   ESDT046      (ESDTBASE +   46)    /*        sdt.c:1013 */
#define   ESDT047      (ESDTBASE +   47)    /*        sdt.c:1014 */
#define   ESDT048      (ESDTBASE +   48)    /*        sdt.c:1058 */
#define   ESDT049      (ESDTBASE +   49)    /*        sdt.c:1061 */
#define   ESDT050      (ESDTBASE +   50)    /*        sdt.c:1062 */
#define   ESDT051      (ESDTBASE +   51)    /*        sdt.c:1098 */
#define   ESDT052      (ESDTBASE +   52)    /*        sdt.c:1135 */
#define   ESDT053      (ESDTBASE +   53)    /*        sdt.c:1176 */
#define   ESDT054      (ESDTBASE +   54)    /*        sdt.c:1177 */
#define   ESDT055      (ESDTBASE +   55)    /*        sdt.c:1178 */
#define   ESDT056      (ESDTBASE +   56)    /*        sdt.c:1216 */
#define   ESDT057      (ESDTBASE +   57)    /*        sdt.c:1217 */
#define   ESDT058      (ESDTBASE +   58)    /*        sdt.c:1257 */
#define   ESDT059      (ESDTBASE +   59)    /*        sdt.c:1258 */
#define   ESDT060      (ESDTBASE +   60)    /*        sdt.c:1297 */
#define   ESDT061      (ESDTBASE +   61)    /*        sdt.c:1298 */
#define   ESDT062      (ESDTBASE +   62)    /*        sdt.c:1339 */
#define   ESDT063      (ESDTBASE +   63)    /*        sdt.c:1340 */
#define   ESDT064      (ESDTBASE +   64)    /*        sdt.c:1380 */
#define   ESDT065      (ESDTBASE +   65)    /*        sdt.c:1381 */
#define   ESDT066      (ESDTBASE +   66)    /*        sdt.c:1382 */


#endif

#ifdef SDTV1
#ifdef SDTIFVER
#undef SDTIFVER
#endif
#define SDTIFVER            0x0100 
#endif

  
/********************************************************************30**
  
         End of file:     sdt.h@@/main/17 - Wed Mar 22 05:34:52 2006
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
1.1              mma    1. initial release.

1.2              lc     1. added an action DL_DROP_MSGQ to Status Request 
                 mma    2. added DL_TX_CREDIT to Data Confirm

1.3              jrl    1. text changes

*********************************************************************71*/

/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.4          ---  jrl   1. text changes

1.5          ---  mc    1. move MAXSNLI from sn.h

1.6          ---  lc    1. move MAXSDUI from sd.h


1.7          ---  lc    1. added DL_POWER_ON
                           added DL_START

1.8          ---  mma   1. add DL_FLUSH_BUF and DL_CONTINUE for
                           CCITT 92

1.9          ---  mc    1. move MAXSNLI to sn.h. remove MAXSDUI.
               
2.1          ---  mc    1. new interface
             ---  mc    2. define event codes for sdt interface.

2.2          ---  mc    1. text changes
             ---  mc    2. add DL_DISC_TYPE and DL_DISC_SYNC defines.

2.3          ---  ash   1. DL_DISC_FSN changed to DL_DISC_FIB

2.4          ---  pm    1. added define for DL_FLC_STAT.
             ---  pm    2. added EVTSDTBNDCFM define.
             ---  pm    3. added SDT_BNDOK and SDT_BNDNOK defines.
*********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
2.5          sd003.28 ash  1. More reasons for discInd added in MTP2 
                           2. changes for fault tolerance
              ---     sr   3. Error codes for common packing/unpacking
                              functions.
              ---     pm   4. removed SDT_BNDOK and SDTBNDNOK.
              ---     pm   5. added DL_DISC_L2 define.
              ---     ash  6. DL_DISC_L2 value is corrected
                           7. added error codes
/main/16     ---     yz   1. Update for rolling upgrade release.
/main/17     ---     rr   1. addition DL_DISC_EIM define
*********************************************************************91*/
