/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     layer management interface - mtp level 3
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               layer management service user.
 
     File:     lsn.x
  
     Sid:      lsn.x@@/main/30 - Mon May 12 11:06:44 2008
    
     Prg:      mc
 
*********************************************************************21*/
  
#ifndef __LSNX__
#define __LSNX__


/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000028     SS7 - MTP Level 3
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000028     SS7 - MTP Level 3
*
*/
 /* lsn_x_001.main_28    Release 3.3*/
#ifdef __cplusplus
extern "C" {
#endif
 

/* typedefs */

#if (defined(LSNV3) || defined(SN_MULTIPLE_NETWORK_RESTART))
#else
/* snGenTmrCfg structure */
 
typedef struct snGenTmrCfg      /* general timer configuration */
{
   TmrCfg t15;                  /* t15 - waiting to start route set congestion test */
   TmrCfg t16;                  /* t16 - waiting for route set congestion status update */
   TmrCfg t18;                  /* t18 - waiting for links to become available */
   TmrCfg t19;                  /* t19 - waiting to receive all traffic restart allowed */
   TmrCfg t21;                  /* t21 - waiting to restart traffic routed through adjacent SP */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
   TmrCfg t26;                  /* t26 - waiting to repeat traffic restart waiting message for ANSI */
#endif
#ifdef SNZN_AUDIT_ENABLED
   TmrCfg tlnkrec;                 /* recovery link timer */
   TmrCfg tlsetrec;                /* recovery linkset timer */
   TmrCfg trterec;                 /* recovery route timer */
#endif
} SnGenTmrCfg;
 
#endif 
/* snGenCfg structure */
 
typedef struct snGenCfg         /* MTP Level 3 general configuration */
{
#if (defined(LSNV4) || defined(SNZN_AUDIT_ENABLED))
   U16 audLnkBlkSize;          /* maximum number of lnk audit blocks is 
                                * is considered in audit request for lnk
                                */
   U16 audLnkSetBlkSize;       /* maximum number of lnk audit blocks is 
                                * is considered in audit request for lnk
                                */
   U16 audRteBlkSize;          /* maximum number of lnk audit blocks is 
                                * is considered in audit request for lnk
                                */
   TmrCfg audLnkBrkTmr;            /* audLnkBrkTmr - default audit link break timer */
   TmrCfg audLnkSetBrkTmr;         /* audLnkSetBrkTmr - default audit linkset break timer */
   TmrCfg audRteBrkTmr;            /* audRteBrkTmr - default audit route break timer */
   TmrCfg audLnkTmr;       /* audLnkTmr - default link audit timer */
   TmrCfg audLnkSetTmr;    /* audLnkSetTmr - default linkset audit timer */
   TmrCfg audRteTmr;       /* audRteTmr - default route audit timer */
#endif /* LSNV4 || SNZN_AUDIT_ENABLED */
   U8 typeSP;                   /* type of signalling point */
   Dpc spCode1;                 /* our DPC for CCITT version */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || SS7_CHINA || defined(TDS_ROLL_UPGRADE_SUPPORT))
   Dpc spCode2;                 /* our DPC for ANSI or CHINA version */
#endif
   Bool ssfValid;               /* ssf validation required */
#if (defined(LSNV3) || defined(SN_MULTIPLE_NETWORK_RESTART))
#else
   U8 rstReq;                   /* restarting procedure required */
   Bool tfrReq;                 /* TFR procedure required or not */
   SnGenTmrCfg tmr;             /* general timer configuration */
#endif
   U16 nmbDLSap;                /* number of MTP Data Link SAPs */
   U16 nmbNSap;                 /* number of Upper Layer Saps */
   U16 nmbRouts;                /* maximum number of routing entries */
   U16 nmbLnkSets;              /* number of link sets */
   U32 nmbRteInst;              /* number of simultaneous Rte instances */
   S16 cbTimeRes;               /* link time resolution */
   S16 spTimeRes;               /* general time resolution */
   S16 rteTimeRes;              /* route time resolution */
/*********REEMA start************/
   Bool extCmbndLnkst;
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS96)
   Bool mopc;
#endif
/*********REEMA end**************/
   Pst sm;                      /* stack manager */
} SnGenCfg;
 
/* snNSAPCfg structure */
   
typedef struct snNSAPCfg        /* MTP Level 3 Network SAP configuration */
{
   U8 ssf;                      /* sub service field */
   U8 lnkType;                  /* link type -ANSI, ITU, CHINA or BICI */
   U8 upSwtch;                  /* user part switch type */
   Selector selector;           /* upper layer selector */
   MemoryId mem;                /* memory region and pool id */
   U8 dpcLen;                   /* dpc or opc length */
   Priority prior;              /* priority */
   Route route;                 /* route */
#if (defined(SN_SG) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   U32 usrParts;                /* user parts configured on self point code on IP side */ 
#endif
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool remIntfValid;           /* remote interface version is valid */
   CmIntfVer remIntfVer;        /* remote interface version */
#endif
} SnNSAPCfg;
 
/* snRteTmrCfg structure */
 
typedef struct snRteTmrCfg      /* route timer configuration */
{
   TmrCfg t6;
   TmrCfg t8;                   /* t8 - transfer prohibited inhibition timer */
   TmrCfg t10;                  /* t10 - waiting to repeat route set test */
   TmrCfg t11;                  /* t11 - transfer restrict timer */
#if (defined(LSNV3) || defined(SN_MULTIPLE_NETWORK_RESTART))
   TmrCfg t18;                  /* t18 - transfer prohibited inhibition timer */
#endif
   TmrCfg t19;                  /* t19 - TRA sent timer */
   TmrCfg t21;                  /* t21 - waiting to restart traffic routed through adjacent SP */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
#if (defined(LSNV3) || defined(SN_MULTIPLE_NETWORK_RESTART))
#else
   TmrCfg t18;                  /* t18 - transfer prohibited inhibition timer */
#endif
   TmrCfg t25;                  /* t25 - waiting to traffic resatrt allowed message for ANSI */
#endif
#if (SS7_TTC || SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
   TmrCfg tc;                   /* tc - Waiting for congestion abatement */
#endif
#if (defined(SN_SG) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   TmrCfg tQry;                 /* Periodic query timer over the NIF */
#endif
#if (defined(LSNV3) || defined(SN_MULTIPLE_NETWORK_RESTART))
   TmrCfg t15;                  /* t15 - waiting to start route set congestion test */
   TmrCfg t16;                  /* t16 - waiting for route set congestion status update */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
   TmrCfg t26;                  /* t26 - waiting to repeat traffic restart waiting message for ANSI */
#endif
#endif
} SnRteTmrCfg;
 
/* snDLSapCfg structure */
 
typedef struct snDLSapTmrCfg    /* signalling link timer configuration */
{
   TmrCfg t1;                   /* t1 - delay to avoid missequencing on changeover */
   TmrCfg t2;                   /* t2 - waiting for changeover ack */
   TmrCfg t3;                   /* t3 - delay to avoid missequencing on changeback */
   TmrCfg t4;                   /* t4 - waiting for first changeback ack */
   TmrCfg t5;                   /* t5 - waiting for second changeback ack */
   TmrCfg t7;                   /* t7 - waiting for link connection ack */
   TmrCfg t12;                  /* t12 - waiting for uninhibit ack */
   TmrCfg t13;                  /* t13 - waiting for forced uninhibit */
   TmrCfg t14;                  /* t14 - waiting for inhibition ack */
   TmrCfg t17;                  /* t17 - delay to avoid oscillation of initial alignment failure */
   TmrCfg t22;                  /* t22 - local inhibit test timer */
   TmrCfg t23;                  /* t23 - remote inhibit test timer */
   TmrCfg t24;                  /* t24 - stabilizing timer */
   TmrCfg t31;                  /* t31 - BSN requested timer */
   TmrCfg t32;                  /* t32 - SLT timer */
   TmrCfg t33;                  /* t33 - connecting timer */
   TmrCfg t34;                  /* t34 - periodic signalling link test timer */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
   TmrCfg t35;                  /* t35 - false link congestion timer, same as t31 of ANSI'96*/
   TmrCfg t36;                  /* t36 - false link congestion timer, same as t33 of ANSI'96*/
   TmrCfg t37;                  /* t37 - false link congestion timer, same as t34 of ANSI'96*/
   TmrCfg tCraft;               /* link referral craft timer - T19 in ANSI */
#endif
#ifdef SDT2
   TmrCfg tFlc;                 /* flow control timer */
   TmrCfg tBnd;                 /* bind request timer */
#endif /* SDT2 */
} SnDLSapTmrCfg;                        
 
/* snDLSapCfg structure */
 
typedef struct snDLSapCfg       /* MTP Level 3 data link configuration */
{
   LnkSetId lnkSetId;           /* link set ID */
   Dpc opc;                     /* Originating Point Code */
   Dpc adjDpc;                  /* Adlacent Destination Point Code */
   Priority lnkPrior;           /* link priority within the link set */
   MsgLen msgSize;              /* message length */
   Priority msgPrior;           /* management message priority */
   U8 lnkType;                  /* link type ANSI, ITU, BICI or CHINA */
   U8 upSwtch;                  /* user part switch type */
#if (defined(TTC_BBAND) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || SS7_TTC || SS7_CHINA || defined(TDS_ROLL_UPGRADE_SUPPORT))
   U8 l2Type;                   /* layer 2 type - 56kbps MTP2 link, 
                                                  1.536Mbps MTP2 link,
                                                  QSAAL link */
#endif   
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
   Bool isCLink;                /* identifies if the link is a C type link.
                                 * Required to check if sls has to be rotated.
                                 */
#endif
#else /* TTC_BBAND */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || SS7_CHINA)
   U8 l2Type;                   /* layer 2 type - 56kbps MTP2 link, 1.536Mbps MTP2 link */
                                /* or QSAAL link */
   Bool isCLink;                /* identifies if the link is a C type link.
                                 * Required to check if sls has to be rotated.
                                 */
#endif
#endif /* TTC_BBAND */
   U8 maxSLTtry;                /* maximun times to retry SLTM */
   QLen p0QLen;                 /* size of the priority 0 Q */
   QLen p1QLen;                 /* size of the priority 1 Q */
   QLen p2QLen;                 /* size of the priority 2 Q */
   QLen p3QLen;                 /* size of the priority 3 Q */
   Priority discPrior;          /* discard priority */
#ifndef SDT2
   SeqU24 maxCredit;            /* max credit */
#endif /* SDT2 */
   LnkSetId lnkId;              /* signalling link identity */
   LnkSel lnkTstSLC;            /* link selection code for link test */
   U8 tstLen;                   /* link test pattern length */
   U8 tst[LSN_LNKTSTMAX];         /* link test pattern */
   U8 ssf;                      /* sub service field */ 
   SnDLSapTmrCfg tmr;           /* timer configuration */
   ProcId dstProcId;            /* destination processor id */
   Ent dstEnt;                  /* entity */
   Inst dstInst;                /* instance */
   Priority prior;              /* priority */
   Route route;                 /* route */
   Selector selector;           /* lower layer selector */
   MemoryId mem;                /* memory region and pool id */
   U8 dpcLen;                   /* dpc or opc length */
   SpId spId;                   /* service provider id */
   Bool flushContFlag;          /* FLUSH BUFFER and CONTINUE requests are required to be
                                   sent to L2 on processor outage recovery or not */ 
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool remIntfValid;           /* remote interface version is valid */
   CmIntfVer remIntfVer;        /* remote interface version */
#endif
} SnDLSapCfg;
 
typedef struct snCmbLnkSet      /* MTP Level 3 combined link set cfg */
{
   LnkSetId cmbLnkSetId;        /* combined link set ID */
   Priority lnkSetPrior;        /* link set priority */
   U16 nmbPrefLinks;            /* Num of preferred links for this combined
                                   linkset*/
   U16 prefLnkId[LSN_MAX_PREFFERED_LINKS];  /* List of preferred links */
} SnCmbLnkSet;
 
typedef struct snLnkSetCfg      /* MTP Level 3 link set configuration */
{
   LnkSetId lnkSetId;           /* link set ID */
   U8 lnkSetType;               /* lnkset type ANSI, ITU, BICI or CHINA */
   Dpc adjDpc;                  /* adjacent Destination Point Code */
   U16 nmbActLnkReqd;           /* number of active links required in the linkset */
   U16 nmbCmbLnkSet;            /* number of combined link sets */
   SnCmbLnkSet cmbLnkSet[LSN_MAXCMBLNK];   /* combined link set */
} SnLnkSetCfg;
 
typedef struct snRoutCfg        /* MTP Level 3 routing configuration */
{
   Dpc dpc;                     /* destination point code */
   U8 spType;                   /* signalling point type */
   U8 swtchType;                /* switch type */
   U8 upSwtch;                  /* user part switch type */
   LnkSetId cmbLnkSetId;        /* combined link set ID */
   U8 dir;                      /* direction */
   SnRteTmrCfg tmr;             /* route timer configuration */
   Bool rteToAdjSp;             /* flag indicating this route to adjacent SP */  
   U8 ssf;                      /* sub service field */
   Bool brdcastFlg;             /* flag indicating to have TFP broadcast */
   U8 rstReq;                   /* Restart type supported by the node */
   U16 slsRange;                 /* max value of SLS for this DPC */
   U32 lsetSel;                  /* linkset selection bit in SLS for STP */
   Bool  multiMsgPrior;          /* TRUE if multiple cong priorities of messages */
   Bool rctReq;                 /* route set congestion test required or not */
#ifdef LSNV2
#if (SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
   Bool destSpec;               /* destination specfication A or B*/ 
#endif   
#endif   
#if (defined(LSNV3) || defined(SN_MULTIPLE_NETWORK_RESTART))
   Bool tfrReq;                /*  TFR procedure required or not */
#endif
/*lsn_x_001.main_29 - Flag for ITU sls map*/
   Bool slsLnk;
} SnRoutCfg;
 

typedef struct snGlbSts         /* MTP Level 3 singalling point statistics */
{
   Cntr usrUnavailRx;           /* user part unavailable received */
   Cntr usrUnavailTx;           /* user part unavailable transmitted */
   Cntr traTx;                  /* traffic restrt allowed transmitted */
   Cntr traRx;                  /* traffic restrt allowed received */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
   Cntr trwTx;                  /* traffic restrt waiting transmitted */
   Cntr trwRx;                  /* traffic restrt waiting received */
#endif
   Cntr msuDropRteErr;          /* MSU dropped due to a routing data error */
#if (defined(SNZN_AUDIT_ENABLED) || defined(LSNV4))
   Cntr lnkAudCycle;
   Cntr lnksetAudCycle;
   Cntr rteAudCycle;
   Cntr lnkAudNack;
   Cntr lnksetAudNack;
   Cntr rteAudNack;
   Ticks lnkAudStartTime;
   Ticks lnkAudEndTime;
   Ticks lnksetAudStartTime;
   Ticks lnksetAudEndTime;
   Ticks rteAudStartTime;
   Ticks rteAudEndTime;
#endif
} SnGlbSts;
 
typedef struct snDLSAPSts       /* MTP Level 3 link statistics */
{
   Cntr changeOverTx;           /* changeover, order transmitted */
   Cntr changeOverRx;           /* changeover, order received */       
   Cntr changeOverAckTx;        /* changeover, ack transmitted */
   Cntr changeOverAckRx;        /* changeover, ack transmitted */
   Cntr changeBackTx;           /* changeback, declaration transmitted */       
   Cntr changeBackRx;           /* changeback, declaration received */       
   Cntr changeBackAckTx;        /* changeback, ack transmitted */
   Cntr changeBackAckRx;        /* changeback, ack received */
   Cntr emChangeOverTx;         /* emergency changeover transmitted */       
   Cntr emChangeOverRx;         /* emergency changeover received */       
   Cntr emChangeOverAckTx;      /* emergency changeover ack transmitted */
   Cntr emChangeOverAckRx;      /* emergency changeover ack received */
   Cntr lnkInhTx;               /* link inhibit transmitted */
   Cntr lnkInhRx;               /* link inhibit received */
   Cntr lnkUninhTx;             /* link uninhibit transmitted */
   Cntr lnkUninhRx;             /* link uninhibit received */
   Cntr lnkInhAckTx;            /* link inhibited ack transmitted */
   Cntr lnkInhAckRx;            /* link inhibited ack received */
   Cntr lnkUninhAckTx;          /* link uninhibited ack transmitted */
   Cntr lnkUninhAckRx;          /* link uninhibited ack received */
   Cntr lnkInhDenTx;            /* link inhibit denied transmitted */
   Cntr lnkInhDenRx;            /* link inhibit denied received */
   Cntr lnkForceUninhTx;        /* force link uninhibit transmitted */
   Cntr lnkForceUninhRx;        /* force link uninhibit received */
   Cntr lnkLocInhTstTx;         /* local link inhibit test transmitted */
   Cntr lnkLocInhTstRx;         /* local link inhibit test received */
   Cntr lnkRmtInhTstTx;         /* remote link inhibit test transmitted */
   Cntr lnkRmtInhTstRx;         /* remote link inhibit test received */
   Cntr lnkConOrdTx;            /* link connection order transmitted */
   Cntr lnkConOrdRx;            /* link connection order received */
   Cntr lnkConAckTx;            /* link connection ack transmitted */
   Cntr lnkConAckRx;            /* link connection ack received */
   Cntr lnkTstRx;               /* link test received */
   Cntr lnkTstTx;               /* link test transmitted */
   Cntr lnkTstAckRx;            /* link test ack received */
   Cntr lnkTstAckTx;            /* link test ack transmitted */
   Cntr txDrop;                 /* transmit messages dropped */
   Cntr txCongDrop;             /* MSUs dropped due to link congestion */
   Cntr sifOctTx;               /* number of SIF octets transmitted */
   Cntr sifOctRx;               /* number of SIF octets received */
   Cntr sioOctTx;               /* number of SIO octets transmitted */
   Cntr sioOctRx;               /* number of SIO octets received */
   Cntr msuTx;                  /* number of MSU transmitted */
   Cntr msuRx;                  /* number of MSU received */
   Cntr cong1;                  /* link congestion at threshold 1 */
   Cntr cong2;                  /* link congestion at threshold 2 */
   Cntr cong3;                  /* link congestion at threshold 3 */
   Ticks durLnkUnav;            /* duration of link unavailability */
   Ticks durLnkCong;            /* duration of link congestion */
   Cntr lnkErrPduRx;            /* number of errored messages received */
} SnDLSAPSts;

typedef struct snNSAPSts
{
   Cntr msuTx;                  /* number of MSU transmitted */
   Cntr msuRx;                  /* number of MSU received */
} SnNSAPSts;
 
typedef struct snRoutSts        /* MTP Level 3 route statistics */
{
   Dpc  dpc;                    /* dpc */
   U8 upSwtch;                  /* user part switch */
   Cntr routeTstTx;             /* route set test transmitted */
   Cntr routeTstRx;             /* route set test received */
   Cntr congTstRx;              /* route set congestion test received */
   Cntr congTstTx;              /* route set congestion test transmitted */
   Cntr txProhibTx;             /* transfer prohibited transmitted */
   Cntr txProhibRx;             /* transfer prohibited received */
   Cntr txRestrictTx;           /* transfer restrict transmitted */
   Cntr txRestrictRx;           /* transfer restricted received */
   Cntr txAllowTx;              /* transfer allowed transmitted */
   Cntr txAllowRx;              /* transfer allowed received */
   Cntr txCntrlRx;              /* transfer controlled received */
   Cntr txCntrlTx;              /* transfer controlled transmitted */
   Cntr rteUnavCnt;             /* route unavailable */
   Cntr sifOctTx;               /* number of SIF octets transmitted */
   Cntr sioOctTx;               /* number of SIO octets transmitted */
   Ticks durRteUnav;            /* duration of route unavailability */
#if (SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
   Cntr usnRx;                  /* number of USN msgs rcvd*/
#endif /*NTT*/   
} SnRoutSts;
 
typedef struct snLnkSetSts      /* MTP Level 3 link set statistics */
{
   Cntr strtLnkSetFail;         /* start of linkset failure */
   Cntr stopLnkSetFail;         /* stop of linkset failure */
   Ticks durLnkSetUnav;         /* duration of linkset unavailability */
} SnLnkSetSts;
 

/* snSAPSta structure */
  
typedef struct snSAPSta         /* MTP Level 3 - SAP status */
{
   MtpStatus sapState;          /* sap state */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   CmIntfVer selfIntfVer;       /* self interface version */
   Bool      remIntfValid;      /* remote interface valid ? */
   CmIntfVer remIntfVer;        /* remote interface version */
#endif
} SnSAPSta;
 
/* snDLSAPSta structure */
  
typedef struct snDLSAPSta       /* MTP Level 3 - signalling link status */
{
   MtpStatus state;             /* link state */
   U8 bndState;                    /* link bind state */
   U8 flcSt;                    /* flow control state */
   Priority congPrior;          /* local link congestion priority */
   QLen tQSize;                 /* transmit queue size */
   QLen rTQSize;                /* retransmit queue size */
   Bool blkd;                   /* link is blocked */
   Bool locBlkd;                /* link is blocked locally */
   Bool remBlkd;                /* link is blocked remotely */
   Bool inhbt;                  /* link is inhibited */
   Bool locInhbt;               /* local inhibit indication */
   Bool rmtInhbt;               /* remote inhibit indication */
   Bool uninhbt;                /* uninhibit signalling indication */
   Bool emerg;                  /* emergency indication */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   CmIntfVer selfIntfVer;       /* self interface version */
   Bool      remIntfValid;      /* remote interface valid ? */
   CmIntfVer remIntfVer;        /* remote interface version */
#endif
} SnDLSAPSta;
 
/* snLnkSetSta structure */
  
typedef struct snLnkSetSta      /* MTP Level 3 - link set status */
{
   U16 nmbActLnks;              /* number of active links */
   MtpStatus state;             /* combined linkset state */
   Bool tfpFlg;                 /* TFP condition on the combined linkset */
   Bool tfrFlg;                 /* TFR condition on the combined linkset */
#if (SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
   U8 NTTState;
#endif
} SnLnkSetSta;
 
/* snRoutSta structure */
  
typedef struct snRoutSta        /* MTP Level 3 - route status */
{
   Dpc dpc;                     /* dpc */
   U8 upSwtch;                  /* user part switch type of the node */
   U16 nmbActvLnkSets;          /* number of active link sets */
   MtpStatus state;             /* route state */
   Priority congLvl;         /* Remote congestion status */
   Bool rstFlg;                 /* SP restarting flag */
   Bool rteRestrict;                 /* SP restarting flag */
} SnRoutSta;
 
/* snSPSta structure */
  
typedef struct snSPSta          /* MTP Level 3 - signalling point status */
{
   Bool spRst;                  /* SP restarting flag */
} SnSPSta;

/* debug control structure */
typedef struct snDbgCntrl
{
   U32 dbgMask;   /* debug mask */
}SnDbgCntrl;

/* Route Identity structure */
typedef struct snRouteId
{
   U32 dpc;
   U8 upSwtch;
}SnRouteId;


/* management message */
  
typedef struct snMngmt
{
   Header hdr;                  /* header */
#if (SN_LMINT3 || SMSN_LMINT3)
   CmStatus cfm;                /* confirm structure */
#endif /* SN_LMINT3 || SMSN_LMINT3 */
   union {
  
/* configuration */
  
      struct
      {
         union
         {
  
            SnGenCfg snGen;     /* MTP 3 - general */
 
            SnNSAPCfg snNSAP;   /* MTP 3 - transport SAP */
 
            SnDLSapCfg snDLSAP; /* MTP 3 - data link SAP */
 
            SnLnkSetCfg snLnkSet; /* MTP 3 - link set */
 
            SnRoutCfg snRout;   /* MTP 3 - Routing table Entry */
 
          } s;
      } cfg;                           /* configuration */
 

/* statistics */
  
      struct
      {
         DateTime dt;           /* date and time */
         Duration dura;         /* duration */
         union
         {
            SnGlbSts snGlb;     /* MTP level 3 - signalling point */

            SnNSAPSts snNSAP;   /* MTP level 3- NSAP */

            SnDLSAPSts snDLSAP; /* MTP level 3 - link SAP */
 
            SnRoutSts snRout;   /* MTP level 3 - route */
 
            SnLnkSetSts snLnkSet; /* MTP level 3 - linkset */
 
        } s;
      } sts;                    /* statistics */
  

/* solicited status */
 
      struct
      {
         DateTime dt;           /* date and time */
         union
         {
            SnSAPSta snSAP;     /* MTP Level 3 SAP status  */
 
            SnDLSAPSta snDLSAP; /* MTP Level 3 link status  */
 
            SnLnkSetSta snLnkSet;/* MTP Level 3 link set status  */
 
            SnRoutSta snRout;   /* MTP Level 3 route status  */
 
            SnSPSta snSP;       /* MTP Level 3 signalling point status  */
 
            SystemId sysId;     /* system id */
         } s;
      } ssta;                   /* solicited status */
  

/* unsolicited status */
  
      struct
      {
#if (SN_LMINT3 || SMSN_LMINT3)
         CmAlarm alarm;         /* common alarm structure */
#else
         DateTime dt;           /* date and time */
         U16 evnt;              /* event number */
#endif /* SN_LMINT3 || SMSN_LMINT3 */
         U8 evntParm[8];        /* event parameters */
      } usta;                   /* unsolicited status */
  
/* trace */
  
      struct
      {
         DateTime dt;           /* date and time */
         U16 evnt;              /* event */
         U8 evntParm[MAX_EVT_TRC_LENGTH];       /* event parameters */
      } trc;                    /* trace */
  
/* control */
  
      struct
      {
#if (defined(LSNV4) || defined(SNZN_AUDIT_ENABLED))
         U8 evntType;          /* timer event */
#endif /* LSNV4 || SNZN_AUDIT_ENABLED */
         DateTime dt;           /* date and time */
         U8 action;             /* action */
         U8 subAction;          /* sub action */
         union
         {
            SnDbgCntrl snDbg;   /* debug control */
            SnRouteId snRouteId; /* route identity for route control requests */
#if (SS7_TTC || SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
            Bool srtReqFlg; /* signal routing test required flag */
#endif
            union
            {
               ProcId dstProcId;      /* destination proc id */
            }groupKey;
         }ctlType;
      } cntrl;                  /* control */
  
   }t;
} SnMngmt;


/* depending on the specific selector in the post structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */
 
typedef S16 (*LsnStaInd) ARGS((Pst *pst, SnMngmt *sta));
typedef S16 (*LsnStaCfm) ARGS((Pst *pst, SnMngmt *sta));
typedef S16 (*LsnStsCfm) ARGS((Pst *pst, Action action, SnMngmt *sts));
typedef S16 (*LsnCfgReq) ARGS((Pst *pst,SnMngmt *cfg));
typedef S16 (*LsnStaReq) ARGS((Pst *pst,SnMngmt *sta));
typedef S16 (*LsnStsReq) ARGS((Pst *pst,Action action,SnMngmt *sts));
typedef S16 (*LsnTrcInd) ARGS((Pst *pst, SnMngmt *trc));
typedef S16 (*LsnCntrlReq) ARGS((Pst *pst,SnMngmt *cntrl));
typedef S16 (*LsnCfgCfm) ARGS((Pst *pst,SnMngmt *cfg));
typedef S16 (*LsnCntrlCfm) ARGS((Pst *pst,SnMngmt *cfg));


#ifdef SN       /* MTP level 3 */
extern  S16 SnMiLsnCfgReq ARGS((Pst *pst, SnMngmt *cfg));
extern  S16 SnMiLsnStaReq ARGS((Pst *pst, SnMngmt *sta));
extern  S16 SnMiLsnStsReq ARGS((Pst *pst, Action action,SnMngmt *sts));
extern  S16 SnMiLsnCntrlReq ARGS((Pst *pst, SnMngmt *cntrl));
extern  S16 SnMiLsnStaInd ARGS((Pst *pst, SnMngmt *sta));
extern  S16 SnMiLsnStaCfm ARGS((Pst *pst, SnMngmt *sta));
extern  S16 SnMiLsnStsCfm ARGS((Pst *pst, Action action, SnMngmt *sts));
extern  S16 SnMiLsnTrcInd ARGS((Pst *pst, SnMngmt *trc));
extern  S16 SnMiLsnCfgCfm ARGS((Pst *pst, SnMngmt *cfg));
extern  S16 SnMiLsnCntrlCfm ARGS((Pst *pst, SnMngmt *cntrl));
#endif
#ifdef SM
extern  S16 SmMiLsnStaInd ARGS((Pst *pst, SnMngmt *sta));
extern  S16 SmMiLsnStaCfm ARGS((Pst *pst, SnMngmt *sta));
extern  S16 SmMiLsnStsCfm ARGS((Pst *pst, Action action,SnMngmt *sts));
extern  S16 SmMiLsnCfgReq ARGS((Pst *pst, SnMngmt *cfg));
extern  S16 SmMiLsnStaReq ARGS((Pst *pst, SnMngmt *sta));
extern  S16 SmMiLsnStsReq ARGS((Pst *pst, Action action,SnMngmt *sts));
extern  S16 SmMiLsnCntrlReq ARGS((Pst *pst, SnMngmt *cntrl));
extern  S16 SmMiLsnTrcInd ARGS((Pst *pst, SnMngmt *trc));
extern  S16 SmMiLsnCfgCfm ARGS((Pst *pst, SnMngmt *cfg));
extern  S16 SmMiLsnCntrlCfm ARGS((Pst *pst, SnMngmt *cntrl));
#endif
 
/* stack manager initialization function */
#ifdef SS_MULTIPLE_PROCS
extern S16 snActvInit ARGS((ProcId procId, Ent entity, Inst inst, Region region, Reason reason, Void **xxCb));
extern  S16 smSnActvInit ARGS((ProcId procId, Ent entity, Inst inst, Region region, Reason reason, Void **xxCb));
#else
extern S16 snActvInit ARGS((Ent entity, Inst inst, Region region, Reason reason));
extern S16 smSnActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));
#endif

/* stack manager activation function */
extern S16 smSnActvTsk ARGS((Pst *pst, Buffer *mBuf));
extern S16 snActvTsk ARGS((Pst *pst, Buffer *mBuf));

#ifdef LCSNMILSN

extern S16 cmPkLsnStaInd ARGS((Pst *pst, SnMngmt *sta));
extern S16 cmPkLsnStaCfm ARGS((Pst *pst, SnMngmt *sta));
extern S16 cmPkLsnStsCfm ARGS((Pst *pst, Action action, SnMngmt *sts));
extern S16 cmPkLsnTrcInd ARGS((Pst *pst, SnMngmt *trc));

extern S16 cmPkLsnCfgCfm ARGS((Pst *pst, SnMngmt *cfm));
extern S16 cmPkLsnCntrlCfm ARGS((Pst *pst, SnMngmt *cfm));

extern S16 cmUnpkLsnCntrlReq ARGS((LsnCntrlReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnStsReq ARGS((LsnStsReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnStaReq ARGS((LsnStaReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnCfgReq ARGS((LsnCfgReq func, Pst *pst, Buffer *mBuf));

#endif /* LCSNMILSN */

#ifdef LCSMSNMILSN

extern S16 cmPkLsnCfgReq ARGS((Pst *pst, SnMngmt *cfg));
extern S16 cmPkLsnCntrlReq ARGS((Pst *pst, SnMngmt *cntrl));
extern S16 cmPkLsnStaReq ARGS((Pst *pst, SnMngmt *sta));
extern S16 cmPkLsnStsReq ARGS((Pst *pst, Action action, SnMngmt *sts));


extern S16 cmUnpkLsnStaCfm ARGS((LsnStaCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnStsCfm ARGS((LsnStsCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnStaInd ARGS((LsnStaInd func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnTrcInd ARGS((LsnTrcInd func, Pst *pst, Buffer *mBuf));

extern S16 cmUnpkLsnCfgCfm ARGS((LsnCfgCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLsnCntrlCfm ARGS((LsnCntrlCfm func, Pst *pst, Buffer *mBuf));

#endif /* LCSMSNMILSN */

#ifdef __cplusplus
}
#endif

#endif /* __LSNX__ */
 

/********************************************************************30**
  
         End of file:     lsn.x@@/main/30 - Mon May 12 11:06:44 2008
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/



/********************************************************************60**
  
        Revision history:
  
Version   Patch   Initials  Description
-------- -------  -------   ------------------------------------------------
  lsn_x_001.main_26      rs   1. Added support for NSAP statistics under flag SN_UPSTS
 3.3     -------  rsharon   1. initial release
  lsn_x_001.main_27      rs  1. Added changes for mtp3 audit feature under flag
                                SNZN_AUDIT_ENABLED.
                             2. Added TmrCfg audit parameters to structure
                                SnGenCfg.
                             3. Added new evnt parameter in Cntrl Structure
                                for MTP3 Audit feature.
  lsn_x_001.main_28      rs  1. Release 3.3
********************************************************************90**
        Revision history:
************************************************************************
  version     pat      init                   description
----------- ---------  ----    -----------------------------------------
/main/29     ---      rs   1. Initial for 3.3 Release.
  lsn_x_001.main_29   rs   1. Added flag for ITU sls Mapping in route cfg.
*********************************************************************91*/
