/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     layer management interface - mtp level 3
  
     Type:     C include file
  
     Desc:     Defines required by the layer management service user.
  
     File:     lsn.h
  
     Sid:      lsn.h@@/main/30 - Mon May 12 11:03:28 2008
     
     Prg:      mc
  
*********************************************************************21*/
  
#ifndef __LSNH_
#define __LSNH_
 

/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000028     SS7 - MTP Level 3
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000028     SS7 - MTP Level 3
*
*/
    
/*lsn_h_001.main_27    Release 3.3.*/

/* defines */
#define LSNIFVER 0x0100
#ifdef LSNV1
/* define or interface version number */
#ifdef LSNIFVER
#undef LSNIFVER
#endif
#define LSNIFVER 0x0100
#endif

#ifdef LSNV2
#ifdef LSNIFVER
#undef LSNIFVER
#endif
#define LSNIFVER 0x0200
#endif

#ifdef LSNV3
#ifdef LSNIFVER
#undef LSNIFVER
#endif
#define LSNIFVER 0x0300
#endif

#ifdef LSNV4
#ifdef LSNIFVER
#undef LSNIFVER
#endif
#define LSNIFVER 0x0400
#endif

#define LSN_MAXADJSP        16       /* maximum number of adjacent SPs */
#define LSN_MAXCMBLNK       16       /* maximum combined link sets */
#if (defined(SN_SG) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#define LSN_MAXIPSP         16       /* maximum number if IP SPs */
#endif /* SN_SG || TDS_ROLL_UPGRADE_SUPPORT  */
#define LSN_MAX_PREFFERED_LINKS 256 

/* link states */
 
#define LSN_LST_INACTIVE     0   /* link inactive state */
#define LSN_LST_CON          1   /* link is connecting */
#define LSN_LST_ACTIVE       2   /* link active state */
#define LSN_LST_FAILED       3   /* link failed state */
#define LSN_LST_WAITCON      4   /* waiting for connection */
#define LSN_LST_SUSPEND      5   /* link restoration suspended */
 
#define SN_LNKST             6   /* number of link states */

/* Sap bind states */

#define LSN_UNBND            1   /* sap is unbound */
#define LSN_BND              2   /* sap is bound */
#define LSN_WAIT_BNDCFM      3   /* bind procedure is going on */

/* link set states */
 
#define LSN_SET_ACTIVE        0       /* link set active state */
#define LSN_SET_INACTIVE      1       /* link set inactive state */
 
/* route states */
 
#define LSN_RTE_UNAVAIL       0       /* route is unavailable */
#define LSN_RTE_AVAIL         1       /* route is available */
 
/* routing directions */
 
#define LSN_RTE_DN            1       /* down / outbound route */
#define LSN_RTE_UP            2       /* up / inbound route  */
#if (defined(SN_SG) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#define LSN_RTE_IP            3       /* IP / route towards IP network  */
#endif
 
#define LSN_TYPE_SP           0       /* signalling point without transfer function */
#define LSN_TYPE_STP          1       /* signalling transfer point */
#define LSN_LNKTSTMAX         15       /* maximum length of link test pattern */
 
#define LSN_SW_ANS            1       /* link type ANSI */
#define LSN_SW_ITU            2       /* link type CCITT */
#define LSN_SW_CHINA          4       /* link type CHINA */
#define LSN_SW_BICI           5       /* link type BICI */
#define LSN_SW_ANS96          6       /* link type ANSI */
#define LSN_SW_TTC            7       /* link type Japan */
#define LSN_SW_NTT            8       /* link type Japan */

#define LNK_DEFAULT           0       /* link type for management message */
#define LNK_ANSI              1       /* link type ANSI */
#define LNK_CCITT             2       /* link type CCITT */
#define LNK_ANSI88            3       /* link type ANSI 88 */
#define LNK_CHINA             4       /* link type CHINA */
#define LNK_BICI              5       /* link type BICI */
#define LNK_SINGAPORE         6       /* link type SINGAPORE */

#define UP_DEFAULT            0       /* default user part */ 
#if (defined(TTC_BBAND) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || SS7_TTC || SS7_CHINA || defined(TDS_ROLL_UPGRADE_SUPPORT))
/* values of l2Type for ANSI/TTC version */
#define LSN_MTP2_56KBPS       0
#define LSN_MTP2_1536KBPS     1
#define LSN_QSAAL             2
#define LSN_MTP2_2MBPS        3
#endif
#else /* TTC_BBAND */
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || SS7_CHINA)
#define LSN_MTP2_56KBPS       0
#define LSN_MTP2_1536KBPS     1
#define LSN_QSAAL             2
#define LSN_MTP2_2MBPS        3
#endif
#endif /* TTC_BBAND */

/* message / congestion priorities */
 
#define LSN_MGMPRI            3       /* mtp 3 management priority highest */
#define LSN_PRIORITY3         3
#define LSN_PRIORITY2         2
#define LSN_PRIORITY1         1
#define LSN_PRIORITY0         0

#define LSN_INVALID_DPC 0xffffffff

/* SLS ranges */
#define LSN_ITU_SLS_RANGE        16
#define LSN_ANSI_5BIT_SLS_RANGE  32
#define LSN_ANSI_8BIT_SLS_RANGE 256
#define LSN_NTT_SLS_RANGE        32

/* Linkset selector */
#define LSN_LSET_SEL_BIT1     0x1
#define LSN_LSET_SEL_BIT2     0x2
#define LSN_LSET_SEL_BIT3     0x4
#define LSN_LSET_SEL_BIT4     0x8

/* Lsn interface events for all alarms LsnStaInd */
#define LSN_EVENT_PROT_ST_UP       LCM_EVENT_LYR_SPECIFIC + 0 /* event - link up */
#define LSN_EVENT_PROT_ST_DN       LCM_EVENT_LYR_SPECIFIC + 1 /* event - link down */
#define LSN_EVENT_INH_DEN          LCM_EVENT_LYR_SPECIFIC + 2 /* event - link inhibit denied */
#define LSN_EVENT_UNINH_DEN        LCM_EVENT_LYR_SPECIFIC + 3 /* event - link uninhibit denied */
#define LSN_EVENT_LOC_INH_ACK      LCM_EVENT_LYR_SPECIFIC + 4 /* event - link inhibited locally */
#define LSN_EVENT_REM_INH_ACK      LCM_EVENT_LYR_SPECIFIC + 5 /* event - link inhibited remotely */
#define LSN_EVENT_LOC_UNINHED      LCM_EVENT_LYR_SPECIFIC + 6 /* event - link uninhibited locally */
#define LSN_EVENT_REM_UNINHED      LCM_EVENT_LYR_SPECIFIC + 7 /* event - link uninhibited remotely */
#define LSN_EVENT_LOC_FORCE_UNINH_DEN    LCM_EVENT_LYR_SPECIFIC + 8  
#define LSN_EVENT_RMT_FORCE_UNINH_DEN    LCM_EVENT_LYR_SPECIFIC + 9 
#define LSN_EVENT_LOC_RTE_MGMT_UNINH_DEN LCM_EVENT_LYR_SPECIFIC + 10
#define LSN_EVENT_RMT_BLKD         LCM_EVENT_LYR_SPECIFIC + 11 /* event - link remotely blocked */
#define LSN_EVENT_RMT_UNBLKD       LCM_EVENT_LYR_SPECIFIC + 12 /* event - link remotely unblocked */
#define LSN_EVENT_LOC_BLKD         LCM_EVENT_LYR_SPECIFIC + 13 /* event - link locally blocked */
#define LSN_EVENT_LOC_UNBLKD       LCM_EVENT_LYR_SPECIFIC + 14 /* event - link locally unblocked */
#define LSN_EVENT_PAUSE            LCM_EVENT_LYR_SPECIFIC + 15 /* event - concerned dpc pause */
#define LSN_EVENT_RESUME           LCM_EVENT_LYR_SPECIFIC + 16 /* event - concerned dpc resume */
#define LSN_EVENT_CONG             LCM_EVENT_LYR_SPECIFIC + 17 /* event - concerned dpc network congested */
#define LSN_EVENT_STPCONG          LCM_EVENT_LYR_SPECIFIC + 18 /* event - concerned dpc stop network congestion */
#define LSN_EVENT_RMTUSRUNAV       LCM_EVENT_LYR_SPECIFIC + 19 /* event - concerned dpc remote user unavailable */
#define LSN_EVENT_SDT_INV_DATA_CFM LCM_EVENT_LYR_SPECIFIC + 20 /* event - Invalid data confirm from SDT */
#define LSN_EVENT_SDT_INV_DATA_DRP LCM_EVENT_LYR_SPECIFIC + 21 /* event - concerned dpc remote user unavailable */
#define LSN_EVENT_SNT_INV          LCM_EVENT_LYR_SPECIFIC + 22 /* event - event received from SNT interface */
#define LSN_EVENT_SDT_INV          LCM_EVENT_LYR_SPECIFIC + 23 /* event - event received from SDT interface */
#define LSN_EVENT_LSNCFGREQ_OK     LCM_EVENT_LYR_SPECIFIC + 24 /* event - config request OK */
#define LSN_EVENT_LSNCFGREQ_NOK    LCM_EVENT_LYR_SPECIFIC + 25 /* event - config request not OK */
#define LSN_EVENT_LSNSTAREQ_OK     LCM_EVENT_LYR_SPECIFIC + 26 /* event - status request OK */
#define LSN_EVENT_LSNSTAREQ_NOK    LCM_EVENT_LYR_SPECIFIC + 27 /* event - status request not OK */
#define LSN_EVENT_LSNSTSREQ_OK     LCM_EVENT_LYR_SPECIFIC + 28 /* event - statistics request OK */
#define LSN_EVENT_LSNSTSREQ_NOK    LCM_EVENT_LYR_SPECIFIC + 29 /* event - statistics request not OK */
#define LSN_EVENT_LSNCNTRLREQ_OK   LCM_EVENT_LYR_SPECIFIC + 30 /* event - control request OK */
#define LSN_EVENT_LSNCNTRLREQ_NOK  LCM_EVENT_LYR_SPECIFIC + 31 /* event - control request not OK */
#define LSN_EVENT_INV_SRCENT       LCM_EVENT_LYR_SPECIFIC + 32 /* event - invalid source entity */

#define LSN_EVENT_INV_OPC_OTHER_END      LCM_EVENT_LYR_SPECIFIC + 33 /* event - invalid OPC */
#define LSN_EVENT_INV_SLC_OTHER_END LCM_EVENT_LYR_SPECIFIC + 34 /* event - slc on the other end of the link is wrong */  
#define LSN_EVENT_CRE_HMAP_FLR           LCM_EVENT_LYR_SPECIFIC + 35
#define LSN_EVENT_SLT                    LCM_EVENT_LYR_SPECIFIC + 36
#define LSN_EVENT_PERIODIC_SLT           LCM_EVENT_LYR_SPECIFIC + 37
#define LSN_EVENT_SRTEST           LCM_EVENT_LYR_SPECIFIC + 38 /* event - SRT result */

#define LSN_EVENT_DATA_DRP       LCM_EVENT_LYR_SPECIFIC + 39 /* event - invalid dpc */
#define LSN_EVENT_LSET_ACTIVE           LCM_EVENT_LYR_SPECIFIC + 40
#define LSN_EVENT_LSET_INACTIVE         LCM_EVENT_LYR_SPECIFIC + 41
#define LSN_EVENT_RX_TRANSFER_MSG       LCM_EVENT_LYR_SPECIFIC + 42
#define  LSN_EVENT_EXCESS_LNKSET_IN_CMBLNKSET       LCM_EVENT_LYR_SPECIFIC + 43
#define  LSN_EVENT_DLSAP_DELETED       LCM_EVENT_LYR_SPECIFIC + 44
/*lsn_h_001.main_28 - incremented values */
#ifdef SNZN_AUDIT_ENABLED
#define LSN_EVENT_RTQ_FULL        LCM_EVENT_LYR_SPECIFIC + 45 
#define LSN_EVENT_TFPQ_FULL       LCM_EVENT_LYR_SPECIFIC + 46
#define LSN_EVENT_TQ_LCB_FULL     LCM_EVENT_LYR_SPECIFIC + 47
#define LSN_EVENT_TQ_RTCB_FULL    LCM_EVENT_LYR_SPECIFIC + 48

#define LSN_EVENT_RTQ_AMEND        LCM_EVENT_LYR_SPECIFIC + 49
#define LSN_EVENT_TFPQ_AMEND       LCM_EVENT_LYR_SPECIFIC + 50
#define LSN_EVENT_TQ_LCB_AMEND     LCM_EVENT_LYR_SPECIFIC + 51
#define LSN_EVENT_TQ_RTCB_AMEND    LCM_EVENT_LYR_SPECIFIC + 52
#define LSN_EVENT_RQ_LCB_FULL      LCM_EVENT_LYR_SPECIFIC + 53
#define LSN_EVENT_RQ_LCB_AMEND     LCM_EVENT_LYR_SPECIFIC + 54

#define LSN_EVENT_LNK_NACK_RCVD    LCM_EVENT_LYR_SPECIFIC + 55
#define LSN_EVENT_LNKSET_NACK_RCVD LCM_EVENT_LYR_SPECIFIC + 56
#define LSN_EVENT_RTE_NACK_RCVD    LCM_EVENT_LYR_SPECIFIC + 57
#endif /* SNZN_AUDIT_ENABLED */
/* Lsn interface events for trace indication LsnTrcInd */

#define LSN_MSG_RX           0        /* event - message received */
#define LSN_MSG_TX           1        /* event - message transmitted */

/* the rstReq field values for general config */
#define LSN_NO_RST           0        /* restart procedure disabled */
#define LSN_ITU88_RST        1        /* ITU'88 compliant restart procedure */
#define LSN_ITU92_RST        2        /* ITU'92 compliant restart procedure */
#define LSN_ANS_RST          3        /* ANSI compliant restart procedure */

/* Sn Management Events */

#define EVTLSNCFGREQ     0x3c         /* Configuration request */
#define EVTLSNSTAREQ     0x40         /* Status request */
#define EVTLSNSTACFM     0x41         /* Status confirm */
#define EVTLSNSTAIND     0x42         /* Status indication */
#define EVTLSNSTSREQ     0x44         /* Statistics request */
#define EVTLSNSTSCFM     0x45         /* Statistics confirm */
#define EVTLSNTRCIND     0x48         /* Trace indication */
#define EVTLSNCNTRLREQ   0x4c         /* Control request */

#define EVTLSNCFGCFM     0x4d         /* Configuration confirm */
#define EVTLSNCNTRLCFM   0x4e         /* Control confirm */

/* MTP3 specific reason in cfm structure */
#define LSN_REASON_NMBDLSAP_NOK    LCM_REASON_LYR_SPECIFIC + 0   
                                      /* number of DLSAP in gen cfg is more 
                                       * than NUMPHLNKS */
#define LSN_REASON_INV_LNKTYPE     LCM_REASON_LYR_SPECIFIC + 1
                                      /* Invalid link type */
#define LSN_REASON_INV_QLEN        LCM_REASON_LYR_SPECIFIC + 2
                                      /* Invalid queue length thresholds */
#define LSN_REASON_INV_LNKTSTSLC   LCM_REASON_LYR_SPECIFIC + 3
                                      /* Invalid lnkTstSLC in DLSAP cfg */
#define LSN_REASON_INV_CMBLNKSETID LCM_REASON_LYR_SPECIFIC + 4
                                      /* Invalid cmbLnkSetId in route cfg */
#define LSN_REASON_INV_DEL_PRIOR   LCM_REASON_LYR_SPECIFIC + 5
                                      /* Invalid prior of the element to 
                                       * be deleted */
#define LSN_REASON_INV_BNDSTATE    LCM_REASON_LYR_SPECIFIC + 6
                                      /* Invalid bndState of the link */
#define LSN_REASON_INV_LNKNUM      LCM_REASON_LYR_SPECIFIC + 7
#define LSN_REASON_EXCESS_RTECFG   LCM_REASON_LYR_SPECIFIC + 8
#define LSN_REASON_SRT_INPROG      LCM_REASON_LYR_SPECIFIC + 9 
#define LSN_REASON_INV_SPID        LCM_REASON_LYR_SPECIFIC + 10
#define LSN_REASON_EXCESS_LNK_IN_CMBLNKSET LCM_REASON_LYR_SPECIFIC + 11
#define LSN_REASON_EXCESS_LNKSET_IN_CMBLNKSET LCM_REASON_LYR_SPECIFIC + 12
#define LSN_REASON_PREFLINK_WITH_LOWPRI LCM_REASON_LYR_SPECIFIC + 13

/* MTP3 specific CAUSE defines in CmAlarm structure */  
#define LSN_CAUSE_T17_EXPIRED     LCM_CAUSE_LYR_SPECIFIC + 0  /* link deactivated */
#define LSN_CAUSE_LNK_DEACT       LCM_CAUSE_LYR_SPECIFIC + 1  /* link deactivated */
#define LSN_CAUSE_INV_OPC         LCM_CAUSE_LYR_SPECIFIC + 2  /* Invalid opc */
#define LSN_CAUSE_DPC_UNAVAIL     LCM_CAUSE_LYR_SPECIFIC + 3  /* DPC becomes unavailble */
#define LSN_CAUSE_RMT_NEG_ACK     LCM_CAUSE_LYR_SPECIFIC + 4  /* remote end nacked */
#define LSN_CAUSE_INV_TST_PTRN    LCM_CAUSE_LYR_SPECIFIC + 5 /* invalid test
                                                   pattern in SRT message. Only for TTC */
#define LSN_CAUSE_SELF_RST        LCM_CAUSE_LYR_SPECIFIC + 6  /* self restart */
#define LSN_CAUSE_ADJ_RST         LCM_CAUSE_LYR_SPECIFIC + 7  /* adlacent DPC restart */
#define LSN_CAUSE_INVALID_DPC        LCM_CAUSE_LYR_SPECIFIC + 8
#define LSN_CAUSE_DPC_CONG           LCM_CAUSE_LYR_SPECIFIC + 9
#define LSN_CAUSE_DPC_RMVD           LCM_CAUSE_LYR_SPECIFIC + 10
#define LSN_CAUSE_LNK_INACTV         LCM_CAUSE_LYR_SPECIFIC + 11
#define LSN_CAUSE_NO_LSETS_AVAIL     LCM_CAUSE_LYR_SPECIFIC + 12
#define LSN_CAUSE_LNK_RSTR_FAILED    LCM_CAUSE_LYR_SPECIFIC + 13 /* link
restoration failed */
#define LSN_CAUSE_INH_IN_PROG        LCM_CAUSE_LYR_SPECIFIC + 14
#define LSN_CAUSE_UNINH_IN_PROG      LCM_CAUSE_LYR_SPECIFIC + 15
#define LSN_CAUSE_PATH_UNAVAIL       LCM_CAUSE_LYR_SPECIFIC + 16
#define LSN_CAUSE_NO_RMT_ACK         LCM_CAUSE_LYR_SPECIFIC + 17
#define LSN_CAUSE_RMT_INIT           LCM_CAUSE_LYR_SPECIFIC + 18 
#define LSN_CAUSE_LOC_RTE_MGMT_INIT  LCM_CAUSE_LYR_SPECIFIC + 19 
#define LSN_CAUSE_DPC_FAILED         LCM_CAUSE_LYR_SPECIFIC + 20 
#define LSN_CAUSE_T32_EXPIRED        LCM_CAUSE_LYR_SPECIFIC + 21 
#define LSN_CAUSE_NULL_NIFOPC        LCM_CAUSE_LYR_SPECIFIC + 22
#define LSN_CAUSE_SP_ROUTING         LCM_CAUSE_LYR_SPECIFIC + 23
#define LSN_CAUSE_MTP2_DISC          LCM_CAUSE_LYR_SPECIFIC + 24
#define LSN_CAUSE_T7_EXPIRED         LCM_CAUSE_LYR_SPECIFIC + 25
#define LSN_CAUSE_FALSE_CONG         LCM_CAUSE_LYR_SPECIFIC + 26
#define LSN_CAUSE_LSET_DEACT         LCM_CAUSE_LYR_SPECIFIC + 27
#define LSN_CAUSE_NUMACT_EXC         LCM_CAUSE_LYR_SPECIFIC + 28
#define LSN_CAUSE_EXCESS_LNKSET      LCM_CAUSE_LYR_SPECIFIC + 29
#define LSN_CAUSE_DLSAP_DELETED      LCM_CAUSE_LYR_SPECIFIC + 30
/* lsn_h_001.main_28 - incremented values*/
#ifdef SNZN_AUDIT_ENABLED
#define LSN_CAUSE_QUEUE_FULL        LCM_CAUSE_LYR_SPECIFIC + 31
#define LSN_CAUSE_QUEUE_AMEND       LCM_CAUSE_LYR_SPECIFIC + 32
#define LSN_CAUSE_NACK_RCVD         LCM_CAUSE_LYR_SPECIFIC + 33
#endif /* SNZN_AUDIT_ENABLED */

#define LSN_LSET_FULL_NORMAL  0
#define LSN_LSET_NORMAL       1
#define LSN_LSET_HALF_NORMAL  2
#define LSN_LSET_ABNORMAL     3
#define MAX_LSET_STATES 4

#define MAX_EVT_TRC_LENGTH   16
/* layer specific actions */
/* Note, currently the actions in gen.h are defined upto 52 and there is no 
   provisioning for layer specific actions. In MTP-3 ASRTEST is introduced 
   as a layer specific action. It's value is choosen to be 101. However if the
   general action values are defined upto this value, this value has to be
   changed */
#define ASRTEST     101    /* Perform SRT */


#if (SS7_TTC || SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
/* New hash defines for SRT related alarms */
#define LSN_SRT_FAILED 0
#define LSN_SRT_PASSED 1
#define LSN_SRT_TIMEOUT 2
#define LSN_SRT_LNK_INACTIVE 3
#define LSN_SRT_LNKSET_INACTIVE 4
#define LSN_SRT_ROUT_UNAVAIL 5
#define LSN_SRT_INV_TST_PTRN 6
#define LSN_SRT_INV_SLC 7
#define LSN_SRT_FLC_ON 8
#if (SS7_NTT || defined(TDS_ROLL_UPGRADE_SUPPORT))
#define LSN_USN_MAIN_SIG_DOM 9
#define LSN_USN_SUB_SIG_DOM 10
#define LSN_USN_SIG_PT_NUM  11
#define A_TP_DEST 0    /*A type destination*/
#define B_TP_DEST 1    /*B type destination*/
#endif
#endif 

/* user part bits for Signalling Gateway NIF SAP */
#if (defined(SN_SG) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#define SI_SCCP_BIT  0x1
#define SI_TUP_BIT   0x2 
#define SI_ISUP_BIT  0x4 
#define SI_DUP_BIT   0x8 
#if (SS7_ANS92 || SS7_ANS88 || SS7_ANS96 || defined(TDS_ROLL_UPGRADE_SUPPORT))
#define SI_DUPF_BIT  0x10 
#endif
#define SI_MTUP_BIT  0x20
#define SI_BISUP_BIT 0x40 
#define SI_SISUP_BIT 0x80 
#define SI_AAL2_BIT  0x100
#define SI_DUMMY1_BIT   0x200
#define SI_BICC_BIT     0x400
#define SI_DUMMY2_BIT   0x800
#define SI_ALLUSERS_BIT 0xFFF
#endif

/* defines for error codes */

#define ERRLSN 0                  /* reserved */
#define ELSNXXX       (ERRLSN)    /* reserved */
#define   ELSN001      (ERRLSN +    1)    /*        lsn.c: 184 */
#define   ELSN002      (ERRLSN +    2)    /*        lsn.c: 189 */
#define   ELSN003      (ERRLSN +    3)    /*        lsn.c: 192 */
#define   ELSN004      (ERRLSN +    4)    /*        lsn.c: 236 */
#define   ELSN005      (ERRLSN +    5)    /*        lsn.c: 241 */
#define   ELSN006      (ERRLSN +    6)    /*        lsn.c: 244 */
#define   ELSN007      (ERRLSN +    7)    /*        lsn.c: 287 */
#define   ELSN008      (ERRLSN +    8)    /*        lsn.c: 293 */
#define   ELSN009      (ERRLSN +    9)    /*        lsn.c: 295 */
#define   ELSN010      (ERRLSN +   10)    /*        lsn.c: 296 */
#define   ELSN011      (ERRLSN +   11)    /*        lsn.c: 297 */
#define   ELSN012      (ERRLSN +   12)    /*        lsn.c: 301 */
#define   ELSN013      (ERRLSN +   13)    /*        lsn.c: 302 */
#define   ELSN014      (ERRLSN +   14)    /*        lsn.c: 303 */
#define   ELSN015      (ERRLSN +   15)    /*        lsn.c: 304 */
#define   ELSN016      (ERRLSN +   16)    /*        lsn.c: 305 */
#define   ELSN017      (ERRLSN +   17)    /*        lsn.c: 306 */
#define   ELSN018      (ERRLSN +   18)    /*        lsn.c: 307 */
#define   ELSN019      (ERRLSN +   19)    /*        lsn.c: 308 */
#define   ELSN020      (ERRLSN +   20)    /*        lsn.c: 309 */
#define   ELSN021      (ERRLSN +   21)    /*        lsn.c: 310 */
#define   ELSN022      (ERRLSN +   22)    /*        lsn.c: 311 */
#define   ELSN023      (ERRLSN +   23)    /*        lsn.c: 312 */
#define   ELSN024      (ERRLSN +   24)    /*        lsn.c: 313 */
#define   ELSN025      (ERRLSN +   25)    /*        lsn.c: 314 */
#define   ELSN026      (ERRLSN +   26)    /*        lsn.c: 316 */
#define   ELSN027      (ERRLSN +   27)    /*        lsn.c: 317 */
#define   ELSN028      (ERRLSN +   28)    /*        lsn.c: 318 */
#define   ELSN029      (ERRLSN +   29)    /*        lsn.c: 322 */
#define   ELSN030      (ERRLSN +   30)    /*        lsn.c: 323 */
#define   ELSN031      (ERRLSN +   31)    /*        lsn.c: 324 */
#define   ELSN032      (ERRLSN +   32)    /*        lsn.c: 325 */
#define   ELSN033      (ERRLSN +   33)    /*        lsn.c: 327 */
#define   ELSN034      (ERRLSN +   34)    /*        lsn.c: 331 */
#define   ELSN035      (ERRLSN +   35)    /*        lsn.c: 332 */
#define   ELSN036      (ERRLSN +   36)    /*        lsn.c: 333 */
#define   ELSN037      (ERRLSN +   37)    /*        lsn.c: 334 */
#define   ELSN038      (ERRLSN +   38)    /*        lsn.c: 335 */
#define   ELSN039      (ERRLSN +   39)    /*        lsn.c: 336 */
#define   ELSN040      (ERRLSN +   40)    /*        lsn.c: 337 */
#define   ELSN041      (ERRLSN +   41)    /*        lsn.c: 340 */
#define   ELSN042      (ERRLSN +   42)    /*        lsn.c: 344 */
#define   ELSN043      (ERRLSN +   43)    /*        lsn.c: 349 */
#define   ELSN044      (ERRLSN +   44)    /*        lsn.c: 351 */
#define   ELSN045      (ERRLSN +   45)    /*        lsn.c: 353 */
#define   ELSN046      (ERRLSN +   46)    /*        lsn.c: 396 */
#define   ELSN047      (ERRLSN +   47)    /*        lsn.c: 402 */
#define   ELSN048      (ERRLSN +   48)    /*        lsn.c: 404 */
#define   ELSN049      (ERRLSN +   49)    /*        lsn.c: 406 */
#define   ELSN050      (ERRLSN +   50)    /*        lsn.c: 409 */
#define   ELSN051      (ERRLSN +   51)    /*        lsn.c: 411 */
#define   ELSN052      (ERRLSN +   52)    /*        lsn.c: 414 */
#define   ELSN053      (ERRLSN +   53)    /*        lsn.c: 457 */
#define   ELSN054      (ERRLSN +   54)    /*        lsn.c: 460 */
#define   ELSN055      (ERRLSN +   55)    /*        lsn.c: 461 */
#define   ELSN056      (ERRLSN +   56)    /*        lsn.c: 462 */
#define   ELSN057      (ERRLSN +   57)    /*        lsn.c: 463 */
#define   ELSN058      (ERRLSN +   58)    /*        lsn.c: 464 */
#define   ELSN059      (ERRLSN +   59)    /*        lsn.c: 468 */
#define   ELSN060      (ERRLSN +   60)    /*        lsn.c: 469 */
#define   ELSN061      (ERRLSN +   61)    /*        lsn.c: 470 */
#define   ELSN062      (ERRLSN +   62)    /*        lsn.c: 471 */
#define   ELSN063      (ERRLSN +   63)    /*        lsn.c: 473 */
#define   ELSN064      (ERRLSN +   64)    /*        lsn.c: 474 */
#define   ELSN065      (ERRLSN +   65)    /*        lsn.c: 476 */
#define   ELSN066      (ERRLSN +   66)    /*        lsn.c: 478 */
#define   ELSN067      (ERRLSN +   67)    /*        lsn.c: 479 */
#define   ELSN068      (ERRLSN +   68)    /*        lsn.c: 480 */
#define   ELSN069      (ERRLSN +   69)    /*        lsn.c: 481 */
#define   ELSN070      (ERRLSN +   70)    /*        lsn.c: 482 */
#define   ELSN071      (ERRLSN +   71)    /*        lsn.c: 483 */
#define   ELSN072      (ERRLSN +   72)    /*        lsn.c: 484 */
#define   ELSN073      (ERRLSN +   73)    /*        lsn.c: 485 */
#define   ELSN074      (ERRLSN +   74)    /*        lsn.c: 486 */
#define   ELSN075      (ERRLSN +   75)    /*        lsn.c: 487 */
#define   ELSN076      (ERRLSN +   76)    /*        lsn.c: 488 */
#define   ELSN077      (ERRLSN +   77)    /*        lsn.c: 489 */
#define   ELSN078      (ERRLSN +   78)    /*        lsn.c: 493 */
#define   ELSN079      (ERRLSN +   79)    /*        lsn.c: 494 */
#define   ELSN080      (ERRLSN +   80)    /*        lsn.c: 495 */
#define   ELSN081      (ERRLSN +   81)    /*        lsn.c: 496 */
#define   ELSN082      (ERRLSN +   82)    /*        lsn.c: 497 */
#define   ELSN083      (ERRLSN +   83)    /*        lsn.c: 498 */
#define   ELSN084      (ERRLSN +   84)    /*        lsn.c: 499 */
#define   ELSN085      (ERRLSN +   85)    /*        lsn.c: 500 */
#define   ELSN086      (ERRLSN +   86)    /*        lsn.c: 501 */
#define   ELSN087      (ERRLSN +   87)    /*        lsn.c: 502 */
#define   ELSN088      (ERRLSN +   88)    /*        lsn.c: 503 */
#define   ELSN089      (ERRLSN +   89)    /*        lsn.c: 504 */
#define   ELSN090      (ERRLSN +   90)    /*        lsn.c: 505 */
#define   ELSN091      (ERRLSN +   91)    /*        lsn.c: 506 */
#define   ELSN092      (ERRLSN +   92)    /*        lsn.c: 507 */
#define   ELSN093      (ERRLSN +   93)    /*        lsn.c: 508 */
#define   ELSN094      (ERRLSN +   94)    /*        lsn.c: 509 */
#define   ELSN095      (ERRLSN +   95)    /*        lsn.c: 510 */
#define   ELSN096      (ERRLSN +   96)    /*        lsn.c: 511 */
#define   ELSN097      (ERRLSN +   97)    /*        lsn.c: 512 */
#define   ELSN098      (ERRLSN +   98)    /*        lsn.c: 513 */
#define   ELSN099      (ERRLSN +   99)    /*        lsn.c: 514 */
#define   ELSN100      (ERRLSN +  100)    /*        lsn.c: 515 */
#define   ELSN101      (ERRLSN +  101)    /*        lsn.c: 516 */
#define   ELSN102      (ERRLSN +  102)    /*        lsn.c: 517 */
#define   ELSN103      (ERRLSN +  103)    /*        lsn.c: 518 */
#define   ELSN104      (ERRLSN +  104)    /*        lsn.c: 519 */
#define   ELSN105      (ERRLSN +  105)    /*        lsn.c: 520 */
#define   ELSN106      (ERRLSN +  106)    /*        lsn.c: 521 */
#define   ELSN107      (ERRLSN +  107)    /*        lsn.c: 522 */
#define   ELSN108      (ERRLSN +  108)    /*        lsn.c: 523 */
#define   ELSN109      (ERRLSN +  109)    /*        lsn.c: 524 */
#define   ELSN110      (ERRLSN +  110)    /*        lsn.c: 525 */
#define   ELSN111      (ERRLSN +  111)    /*        lsn.c: 526 */
#define   ELSN112      (ERRLSN +  112)    /*        lsn.c: 527 */
#define   ELSN113      (ERRLSN +  113)    /*        lsn.c: 528 */
#define   ELSN114      (ERRLSN +  114)    /*        lsn.c: 529 */
#define   ELSN115      (ERRLSN +  115)    /*        lsn.c: 530 */
#define   ELSN116      (ERRLSN +  116)    /*        lsn.c: 531 */
#define   ELSN117      (ERRLSN +  117)    /*        lsn.c: 532 */
#define   ELSN118      (ERRLSN +  118)    /*        lsn.c: 533 */
#define   ELSN119      (ERRLSN +  119)    /*        lsn.c: 534 */
#define   ELSN120      (ERRLSN +  120)    /*        lsn.c: 535 */
#define   ELSN121      (ERRLSN +  121)    /*        lsn.c: 536 */
#define   ELSN122      (ERRLSN +  122)    /*        lsn.c: 537 */
#define   ELSN123      (ERRLSN +  123)    /*        lsn.c: 538 */
#define   ELSN124      (ERRLSN +  124)    /*        lsn.c: 539 */
#define   ELSN125      (ERRLSN +  125)    /*        lsn.c: 540 */
#define   ELSN126      (ERRLSN +  126)    /*        lsn.c: 541 */
#define   ELSN127      (ERRLSN +  127)    /*        lsn.c: 542 */
#define   ELSN128      (ERRLSN +  128)    /*        lsn.c: 545 */
#define   ELSN129      (ERRLSN +  129)    /*        lsn.c: 546 */
#define   ELSN130      (ERRLSN +  130)    /*        lsn.c: 549 */
#define   ELSN131      (ERRLSN +  131)    /*        lsn.c: 550 */
#define   ELSN132      (ERRLSN +  132)    /*        lsn.c: 551 */
#define   ELSN133      (ERRLSN +  133)    /*        lsn.c: 552 */
#define   ELSN134      (ERRLSN +  134)    /*        lsn.c: 553 */
#define   ELSN135      (ERRLSN +  135)    /*        lsn.c: 554 */
#define   ELSN136      (ERRLSN +  136)    /*        lsn.c: 555 */
#define   ELSN137      (ERRLSN +  137)    /*        lsn.c: 556 */
#define   ELSN138      (ERRLSN +  138)    /*        lsn.c: 557 */
#define   ELSN139      (ERRLSN +  139)    /*        lsn.c: 558 */
#define   ELSN140      (ERRLSN +  140)    /*        lsn.c: 559 */
#define   ELSN141      (ERRLSN +  141)    /*        lsn.c: 560 */
#define   ELSN142      (ERRLSN +  142)    /*        lsn.c: 561 */
#define   ELSN143      (ERRLSN +  143)    /*        lsn.c: 562 */
#define   ELSN144      (ERRLSN +  144)    /*        lsn.c: 563 */
#define   ELSN145      (ERRLSN +  145)    /*        lsn.c: 564 */
#define   ELSN146      (ERRLSN +  146)    /*        lsn.c: 565 */
#define   ELSN147      (ERRLSN +  147)    /*        lsn.c: 566 */
#define   ELSN148      (ERRLSN +  148)    /*        lsn.c: 568 */
#define   ELSN149      (ERRLSN +  149)    /*        lsn.c: 572 */
#define   ELSN150      (ERRLSN +  150)    /*        lsn.c: 573 */
#define   ELSN151      (ERRLSN +  151)    /*        lsn.c: 574 */
#define   ELSN152      (ERRLSN +  152)    /*        lsn.c: 579 */
#define   ELSN153      (ERRLSN +  153)    /*        lsn.c: 580 */
#define   ELSN154      (ERRLSN +  154)    /*        lsn.c: 582 */
#define   ELSN155      (ERRLSN +  155)    /*        lsn.c: 584 */
#define   ELSN156      (ERRLSN +  156)    /*        lsn.c: 626 */
#define   ELSN157      (ERRLSN +  157)    /*        lsn.c: 629 */
#define   ELSN158      (ERRLSN +  158)    /*        lsn.c: 632 */
#define   ELSN159      (ERRLSN +  159)    /*        lsn.c: 634 */
#define   ELSN160      (ERRLSN +  160)    /*        lsn.c: 635 */
#define   ELSN161      (ERRLSN +  161)    /*        lsn.c: 675 */
#define   ELSN162      (ERRLSN +  162)    /*        lsn.c: 680 */
#define   ELSN163      (ERRLSN +  163)    /*        lsn.c: 682 */
#define   ELSN164      (ERRLSN +  164)    /*        lsn.c: 683 */
#define   ELSN165      (ERRLSN +  165)    /*        lsn.c: 684 */
#define   ELSN166      (ERRLSN +  166)    /*        lsn.c: 688 */
#define   ELSN167      (ERRLSN +  167)    /*        lsn.c: 692 */
#define   ELSN168      (ERRLSN +  168)    /*        lsn.c: 693 */
#define   ELSN169      (ERRLSN +  169)    /*        lsn.c: 698 */
#define   ELSN170      (ERRLSN +  170)    /*        lsn.c: 704 */
#define   ELSN171      (ERRLSN +  171)    /*        lsn.c: 748 */
#define   ELSN172      (ERRLSN +  172)    /*        lsn.c: 749 */
#define   ELSN173      (ERRLSN +  173)    /*        lsn.c: 750 */
#define   ELSN174      (ERRLSN +  174)    /*        lsn.c: 760 */
#define   ELSN175      (ERRLSN +  175)    /*        lsn.c: 761 */
#define   ELSN176      (ERRLSN +  176)    /*        lsn.c: 802 */
#define   ELSN177      (ERRLSN +  177)    /*        lsn.c: 803 */
#define   ELSN178      (ERRLSN +  178)    /*        lsn.c: 813 */
#define   ELSN179      (ERRLSN +  179)    /*        lsn.c: 814 */
#define   ELSN180      (ERRLSN +  180)    /*        lsn.c: 883 */
#define   ELSN181      (ERRLSN +  181)    /*        lsn.c: 887 */
#define   ELSN182      (ERRLSN +  182)    /*        lsn.c: 888 */
#define   ELSN183      (ERRLSN +  183)    /*        lsn.c: 889 */
#define   ELSN184      (ERRLSN +  184)    /*        lsn.c: 890 */
#define   ELSN185      (ERRLSN +  185)    /*        lsn.c: 891 */
#define   ELSN186      (ERRLSN +  186)    /*        lsn.c: 892 */
#define   ELSN187      (ERRLSN +  187)    /*        lsn.c: 893 */
#define   ELSN188      (ERRLSN +  188)    /*        lsn.c: 894 */
#define   ELSN189      (ERRLSN +  189)    /*        lsn.c: 896 */
#define   ELSN190      (ERRLSN +  190)    /*        lsn.c: 904 */
#define   ELSN191      (ERRLSN +  191)    /*        lsn.c: 906 */
#define   ELSN192      (ERRLSN +  192)    /*        lsn.c: 907 */
#define   ELSN193      (ERRLSN +  193)    /*        lsn.c: 908 */
#define   ELSN194      (ERRLSN +  194)    /*        lsn.c: 909 */
#define   ELSN195      (ERRLSN +  195)    /*        lsn.c: 910 */
#define   ELSN196      (ERRLSN +  196)    /*        lsn.c: 913 */
#define   ELSN197      (ERRLSN +  197)    /*        lsn.c: 915 */
#define   ELSN198      (ERRLSN +  198)    /*        lsn.c: 916 */
#define   ELSN199      (ERRLSN +  199)    /*        lsn.c: 917 */
#define   ELSN200      (ERRLSN +  200)    /*        lsn.c: 918 */
#define   ELSN201      (ERRLSN +  201)    /*        lsn.c: 919 */
#define   ELSN202      (ERRLSN +  202)    /*        lsn.c: 930 */
#define   ELSN203      (ERRLSN +  203)    /*        lsn.c: 932 */
#define   ELSN204      (ERRLSN +  204)    /*        lsn.c: 934 */
#define   ELSN205      (ERRLSN +  205)    /*        lsn.c: 940 */
#define   ELSN206      (ERRLSN +  206)    /*        lsn.c: 943 */
#define   ELSN207      (ERRLSN +  207)    /*        lsn.c: 945 */
#define   ELSN208      (ERRLSN +  208)    /*        lsn.c: 947 */
#define   ELSN209      (ERRLSN +  209)    /*        lsn.c: 949 */
#define   ELSN210      (ERRLSN +  210)    /*        lsn.c: 951 */
#define   ELSN211      (ERRLSN +  211)    /*        lsn.c: 959 */
#define   ELSN212      (ERRLSN +  212)    /*        lsn.c: 961 */
#define   ELSN213      (ERRLSN +  213)    /*        lsn.c: 962 */
#define   ELSN214      (ERRLSN +  214)    /*        lsn.c: 963 */
#define   ELSN215      (ERRLSN +  215)    /*        lsn.c: 964 */
#define   ELSN216      (ERRLSN +  216)    /*        lsn.c: 965 */
#define   ELSN217      (ERRLSN +  217)    /*        lsn.c: 966 */
#define   ELSN218      (ERRLSN +  218)    /*        lsn.c: 967 */
#define   ELSN219      (ERRLSN +  219)    /*        lsn.c: 968 */
#define   ELSN220      (ERRLSN +  220)    /*        lsn.c: 969 */
#define   ELSN221      (ERRLSN +  221)    /*        lsn.c: 975 */
#define   ELSN222      (ERRLSN +  222)    /*        lsn.c: 976 */
#define   ELSN223      (ERRLSN +  223)    /*        lsn.c: 978 */
#define   ELSN224      (ERRLSN +  224)    /*        lsn.c: 979 */
#define   ELSN225      (ERRLSN +  225)    /*        lsn.c: 989 */
#define   ELSN226      (ERRLSN +  226)    /*        lsn.c: 990 */
#define   ELSN227      (ERRLSN +  227)    /*        lsn.c: 997 */
#define   ELSN228      (ERRLSN +  228)    /*        lsn.c: 999 */
#define   ELSN229      (ERRLSN +  229)    /*        lsn.c:1001 */
#define   ELSN230      (ERRLSN +  230)    /*        lsn.c:1002 */
#define   ELSN231      (ERRLSN +  231)    /*        lsn.c:1027 */
#define   ELSN232      (ERRLSN +  232)    /*        lsn.c:1029 */
#define   ELSN233      (ERRLSN +  233)    /*        lsn.c:1031 */
#define   ELSN234      (ERRLSN +  234)    /*        lsn.c:1033 */
#define   ELSN235      (ERRLSN +  235)    /*        lsn.c:1035 */
#define   ELSN236      (ERRLSN +  236)    /*        lsn.c:1037 */
#define   ELSN237      (ERRLSN +  237)    /*        lsn.c:1038 */
#define   ELSN238      (ERRLSN +  238)    /*        lsn.c:1039 */
#define   ELSN239      (ERRLSN +  239)    /*        lsn.c:1040 */
#define   ELSN240      (ERRLSN +  240)    /*        lsn.c:1051 */
#define   ELSN241      (ERRLSN +  241)    /*        lsn.c:1052 */
#define   ELSN242      (ERRLSN +  242)    /*        lsn.c:1055 */
#define   ELSN243      (ERRLSN +  243)    /*        lsn.c:1057 */
#define   ELSN244      (ERRLSN +  244)    /*        lsn.c:1058 */
#define   ELSN245      (ERRLSN +  245)    /*        lsn.c:1059 */
#define   ELSN246      (ERRLSN +  246)    /*        lsn.c:1060 */
#define   ELSN247      (ERRLSN +  247)    /*        lsn.c:1061 */
#define   ELSN248      (ERRLSN +  248)    /*        lsn.c:1062 */
#define   ELSN249      (ERRLSN +  249)    /*        lsn.c:1063 */
#define   ELSN250      (ERRLSN +  250)    /*        lsn.c:1064 */
#define   ELSN251      (ERRLSN +  251)    /*        lsn.c:1065 */
#define   ELSN252      (ERRLSN +  252)    /*        lsn.c:1070 */
#define   ELSN253      (ERRLSN +  253)    /*        lsn.c:1071 */
#define   ELSN254      (ERRLSN +  254)    /*        lsn.c:1073 */
#define   ELSN255      (ERRLSN +  255)    /*        lsn.c:1074 */
#define   ELSN256      (ERRLSN +  256)    /*        lsn.c:1075 */
#define   ELSN257      (ERRLSN +  257)    /*        lsn.c:1076 */
#define   ELSN258      (ERRLSN +  258)    /*        lsn.c:1077 */
#define   ELSN259      (ERRLSN +  259)    /*        lsn.c:1078 */
#define   ELSN260      (ERRLSN +  260)    /*        lsn.c:1079 */
#define   ELSN261      (ERRLSN +  261)    /*        lsn.c:1080 */
#define   ELSN262      (ERRLSN +  262)    /*        lsn.c:1081 */
#define   ELSN263      (ERRLSN +  263)    /*        lsn.c:1082 */
#define   ELSN264      (ERRLSN +  264)    /*        lsn.c:1083 */
#define   ELSN265      (ERRLSN +  265)    /*        lsn.c:1085 */
#define   ELSN266      (ERRLSN +  266)    /*        lsn.c:1086 */
#define   ELSN267      (ERRLSN +  267)    /*        lsn.c:1089 */
#define   ELSN268      (ERRLSN +  268)    /*        lsn.c:1090 */
#define   ELSN269      (ERRLSN +  269)    /*        lsn.c:1091 */
#define   ELSN270      (ERRLSN +  270)    /*        lsn.c:1092 */
#define   ELSN271      (ERRLSN +  271)    /*        lsn.c:1094 */
#define   ELSN272      (ERRLSN +  272)    /*        lsn.c:1095 */
#define   ELSN273      (ERRLSN +  273)    /*        lsn.c:1096 */
#define   ELSN274      (ERRLSN +  274)    /*        lsn.c:1097 */
#define   ELSN275      (ERRLSN +  275)    /*        lsn.c:1098 */
#define   ELSN276      (ERRLSN +  276)    /*        lsn.c:1099 */
#define   ELSN277      (ERRLSN +  277)    /*        lsn.c:1100 */
#define   ELSN278      (ERRLSN +  278)    /*        lsn.c:1101 */
#define   ELSN279      (ERRLSN +  279)    /*        lsn.c:1102 */
#define   ELSN280      (ERRLSN +  280)    /*        lsn.c:1103 */
#define   ELSN281      (ERRLSN +  281)    /*        lsn.c:1104 */
#define   ELSN282      (ERRLSN +  282)    /*        lsn.c:1105 */
#define   ELSN283      (ERRLSN +  283)    /*        lsn.c:1106 */
#define   ELSN284      (ERRLSN +  284)    /*        lsn.c:1107 */
#define   ELSN285      (ERRLSN +  285)    /*        lsn.c:1108 */
#define   ELSN286      (ERRLSN +  286)    /*        lsn.c:1109 */
#define   ELSN287      (ERRLSN +  287)    /*        lsn.c:1110 */
#define   ELSN288      (ERRLSN +  288)    /*        lsn.c:1111 */
#define   ELSN289      (ERRLSN +  289)    /*        lsn.c:1114 */
#define   ELSN290      (ERRLSN +  290)    /*        lsn.c:1116 */
#define   ELSN291      (ERRLSN +  291)    /*        lsn.c:1117 */
#define   ELSN292      (ERRLSN +  292)    /*        lsn.c:1118 */
#define   ELSN293      (ERRLSN +  293)    /*        lsn.c:1120 */
#define   ELSN294      (ERRLSN +  294)    /*        lsn.c:1122 */
#define   ELSN295      (ERRLSN +  295)    /*        lsn.c:1123 */
#define   ELSN296      (ERRLSN +  296)    /*        lsn.c:1124 */
#define   ELSN297      (ERRLSN +  297)    /*        lsn.c:1125 */
#define   ELSN298      (ERRLSN +  298)    /*        lsn.c:1126 */
#define   ELSN299      (ERRLSN +  299)    /*        lsn.c:1128 */
#define   ELSN300      (ERRLSN +  300)    /*        lsn.c:1132 */
#define   ELSN301      (ERRLSN +  301)    /*        lsn.c:1136 */
#define   ELSN302      (ERRLSN +  302)    /*        lsn.c:1139 */
#define   ELSN303      (ERRLSN +  303)    /*        lsn.c:1140 */
#define   ELSN304      (ERRLSN +  304)    /*        lsn.c:1141 */
#define   ELSN305      (ERRLSN +  305)    /*        lsn.c:1142 */
#define   ELSN306      (ERRLSN +  306)    /*        lsn.c:1143 */
#define   ELSN307      (ERRLSN +  307)    /*        lsn.c:1144 */
#define   ELSN308      (ERRLSN +  308)    /*        lsn.c:1145 */
#define   ELSN309      (ERRLSN +  309)    /*        lsn.c:1146 */
#define   ELSN310      (ERRLSN +  310)    /*        lsn.c:1163 */
#define   ELSN311      (ERRLSN +  311)    /*        lsn.c:1171 */
#define   ELSN312      (ERRLSN +  312)    /*        lsn.c:1172 */
#define   ELSN313      (ERRLSN +  313)    /*        lsn.c:1173 */
#define   ELSN314      (ERRLSN +  314)    /*        lsn.c:1174 */
#define   ELSN315      (ERRLSN +  315)    /*        lsn.c:1175 */
#define   ELSN316      (ERRLSN +  316)    /*        lsn.c:1176 */
#define   ELSN317      (ERRLSN +  317)    /*        lsn.c:1177 */
#define   ELSN318      (ERRLSN +  318)    /*        lsn.c:1178 */
#define   ELSN319      (ERRLSN +  319)    /*        lsn.c:1205 */
#define   ELSN320      (ERRLSN +  320)    /*        lsn.c:1207 */
#define   ELSN321      (ERRLSN +  321)    /*        lsn.c:1209 */
#define   ELSN322      (ERRLSN +  322)    /*        lsn.c:1210 */
#define   ELSN323      (ERRLSN +  323)    /*        lsn.c:1213 */
#define   ELSN324      (ERRLSN +  324)    /*        lsn.c:1216 */
#define   ELSN325      (ERRLSN +  325)    /*        lsn.c:1218 */
#define   ELSN326      (ERRLSN +  326)    /*        lsn.c:1220 */
#define   ELSN327      (ERRLSN +  327)    /*        lsn.c:1221 */
#define   ELSN328      (ERRLSN +  328)    /*        lsn.c:1224 */
#define   ELSN329      (ERRLSN +  329)    /*        lsn.c:1233 */
#define   ELSN330      (ERRLSN +  330)    /*        lsn.c:1234 */
#define   ELSN331      (ERRLSN +  331)    /*        lsn.c:1235 */
#define   ELSN332      (ERRLSN +  332)    /*        lsn.c:1236 */
#define   ELSN333      (ERRLSN +  333)    /*        lsn.c:1237 */
#define   ELSN334      (ERRLSN +  334)    /*        lsn.c:1238 */
#define   ELSN335      (ERRLSN +  335)    /*        lsn.c:1240 */
#define   ELSN336      (ERRLSN +  336)    /*        lsn.c:1241 */
#define   ELSN337      (ERRLSN +  337)    /*        lsn.c:1244 */
#define   ELSN338      (ERRLSN +  338)    /*        lsn.c:1247 */
#define   ELSN339      (ERRLSN +  339)    /*        lsn.c:1249 */
#define   ELSN340      (ERRLSN +  340)    /*        lsn.c:1250 */
#define   ELSN341      (ERRLSN +  341)    /*        lsn.c:1251 */
#define   ELSN342      (ERRLSN +  342)    /*        lsn.c:1252 */
#define   ELSN343      (ERRLSN +  343)    /*        lsn.c:1253 */
#define   ELSN344      (ERRLSN +  344)    /*        lsn.c:1254 */
#define   ELSN345      (ERRLSN +  345)    /*        lsn.c:1260 */
#define   ELSN346      (ERRLSN +  346)    /*        lsn.c:1261 */
#define   ELSN347      (ERRLSN +  347)    /*        lsn.c:1262 */
#define   ELSN348      (ERRLSN +  348)    /*        lsn.c:1263 */
#define   ELSN349      (ERRLSN +  349)    /*        lsn.c:1265 */
#define   ELSN350      (ERRLSN +  350)    /*        lsn.c:1266 */
#define   ELSN351      (ERRLSN +  351)    /*        lsn.c:1267 */
#define   ELSN352      (ERRLSN +  352)    /*        lsn.c:1268 */
#define   ELSN353      (ERRLSN +  353)    /*        lsn.c:1269 */
#define   ELSN354      (ERRLSN +  354)    /*        lsn.c:1781 */
#define   ELSN355      (ERRLSN +  355)    /*        lsn.c:1783 */
#define   ELSN356      (ERRLSN +  356)    /*        lsn.c:1785 */
#define   ELSN357      (ERRLSN +  357)    /*        lsn.c:1790 */
#define   ELSN358      (ERRLSN +  358)    /*        lsn.c:1791 */
#define   ELSN359      (ERRLSN +  359)    /*        lsn.c:1792 */
#define   ELSN360      (ERRLSN +  360)    /*        lsn.c:1794 */
#define   ELSN361      (ERRLSN +  361)    /*        lsn.c:1798 */
#define   ELSN362      (ERRLSN +  362)    /*        lsn.c:1799 */
#define   ELSN363      (ERRLSN +  363)    /*        lsn.c:1800 */
#define   ELSN364      (ERRLSN +  364)    /*        lsn.c:1802 */
#define   ELSN365      (ERRLSN +  365)    /*        lsn.c:1803 */
#define   ELSN366      (ERRLSN +  366)    /*        lsn.c:1804 */
#define   ELSN367      (ERRLSN +  367)    /*        lsn.c:1805 */
#define   ELSN368      (ERRLSN +  368)    /*        lsn.c:1806 */
#define   ELSN369      (ERRLSN +  369)    /*        lsn.c:1807 */
#define   ELSN370      (ERRLSN +  370)    /*        lsn.c:1808 */
#define   ELSN371      (ERRLSN +  371)    /*        lsn.c:1809 */
#define   ELSN372      (ERRLSN +  372)    /*        lsn.c:1810 */
#define   ELSN373      (ERRLSN +  373)    /*        lsn.c:1811 */
#define   ELSN374      (ERRLSN +  374)    /*        lsn.c:1812 */
#define   ELSN375      (ERRLSN +  375)    /*        lsn.c:1813 */
#define   ELSN376      (ERRLSN +  376)    /*        lsn.c:1814 */
#define   ELSN377      (ERRLSN +  377)    /*        lsn.c:1815 */
#define   ELSN378      (ERRLSN +  378)    /*        lsn.c:1819 */
#define   ELSN379      (ERRLSN +  379)    /*        lsn.c:1821 */
#define   ELSN380      (ERRLSN +  380)    /*        lsn.c:1822 */
#define   ELSN381      (ERRLSN +  381)    /*        lsn.c:1823 */
#define   ELSN382      (ERRLSN +  382)    /*        lsn.c:1824 */
#define   ELSN383      (ERRLSN +  383)    /*        lsn.c:1827 */
#define   ELSN384      (ERRLSN +  384)    /*        lsn.c:1828 */
#define   ELSN385      (ERRLSN +  385)    /*        lsn.c:1829 */
#define   ELSN386      (ERRLSN +  386)    /*        lsn.c:1830 */
#define   ELSN387      (ERRLSN +  387)    /*        lsn.c:1831 */
#define   ELSN388      (ERRLSN +  388)    /*        lsn.c:1832 */
#define   ELSN389      (ERRLSN +  389)    /*        lsn.c:1833 */
#define   ELSN390      (ERRLSN +  390)    /*        lsn.c:1836 */
#define   ELSN391      (ERRLSN +  391)    /*        lsn.c:1841 */
#define   ELSN392      (ERRLSN +  392)    /*        lsn.c:1884 */
#define   ELSN393      (ERRLSN +  393)    /*        lsn.c:1886 */
#define   ELSN394      (ERRLSN +  394)    /*        lsn.c:1888 */
#define   ELSN395      (ERRLSN +  395)    /*        lsn.c:1889 */
#define   ELSN396      (ERRLSN +  396)    /*        lsn.c:1894 */
#define   ELSN397      (ERRLSN +  397)    /*        lsn.c:1895 */
#define   ELSN398      (ERRLSN +  398)    /*        lsn.c:1896 */
#define   ELSN399      (ERRLSN +  399)    /*        lsn.c:1897 */
#define   ELSN400      (ERRLSN +  400)    /*        lsn.c:1898 */
#define   ELSN401      (ERRLSN +  401)    /*        lsn.c:1899 */
#define   ELSN402      (ERRLSN +  402)    /*        lsn.c:1900 */
#define   ELSN403      (ERRLSN +  403)    /*        lsn.c:1901 */
#define   ELSN404      (ERRLSN +  404)    /*        lsn.c:1902 */
#define   ELSN405      (ERRLSN +  405)    /*        lsn.c:1903 */
#define   ELSN406      (ERRLSN +  406)    /*        lsn.c:1904 */
#define   ELSN407      (ERRLSN +  407)    /*        lsn.c:1905 */
#define   ELSN408      (ERRLSN +  408)    /*        lsn.c:1907 */
#define   ELSN409      (ERRLSN +  409)    /*        lsn.c:1909 */
#define   ELSN410      (ERRLSN +  410)    /*        lsn.c:1910 */
#define   ELSN411      (ERRLSN +  411)    /*        lsn.c:1912 */
#define   ELSN412      (ERRLSN +  412)    /*        lsn.c:1913 */
#define   ELSN413      (ERRLSN +  413)    /*        lsn.c:1914 */
#define   ELSN414      (ERRLSN +  414)    /*        lsn.c:1915 */
#define   ELSN415      (ERRLSN +  415)    /*        lsn.c:1918 */
#define   ELSN416      (ERRLSN +  416)    /*        lsn.c:1919 */
#define   ELSN417      (ERRLSN +  417)    /*        lsn.c:1920 */
#define   ELSN418      (ERRLSN +  418)    /*        lsn.c:1921 */
#define   ELSN419      (ERRLSN +  419)    /*        lsn.c:1922 */
#define   ELSN420      (ERRLSN +  420)    /*        lsn.c:1923 */
#define   ELSN421      (ERRLSN +  421)    /*        lsn.c:1924 */
#define   ELSN422      (ERRLSN +  422)    /*        lsn.c:1925 */
#define   ELSN423      (ERRLSN +  423)    /*        lsn.c:1926 */
#define   ELSN424      (ERRLSN +  424)    /*        lsn.c:1927 */
#define   ELSN425      (ERRLSN +  425)    /*        lsn.c:1928 */
#define   ELSN426      (ERRLSN +  426)    /*        lsn.c:1929 */
#define   ELSN427      (ERRLSN +  427)    /*        lsn.c:1930 */
#define   ELSN428      (ERRLSN +  428)    /*        lsn.c:1931 */
#define   ELSN429      (ERRLSN +  429)    /*        lsn.c:1932 */
#define   ELSN430      (ERRLSN +  430)    /*        lsn.c:1933 */
#define   ELSN431      (ERRLSN +  431)    /*        lsn.c:1934 */
#define   ELSN432      (ERRLSN +  432)    /*        lsn.c:1935 */
#define   ELSN433      (ERRLSN +  433)    /*        lsn.c:1936 */
#define   ELSN434      (ERRLSN +  434)    /*        lsn.c:1937 */
#define   ELSN435      (ERRLSN +  435)    /*        lsn.c:1938 */
#define   ELSN436      (ERRLSN +  436)    /*        lsn.c:1939 */
#define   ELSN437      (ERRLSN +  437)    /*        lsn.c:1940 */
#define   ELSN438      (ERRLSN +  438)    /*        lsn.c:1941 */
#define   ELSN439      (ERRLSN +  439)    /*        lsn.c:1942 */
#define   ELSN440      (ERRLSN +  440)    /*        lsn.c:1943 */
#define   ELSN441      (ERRLSN +  441)    /*        lsn.c:1944 */
#define   ELSN442      (ERRLSN +  442)    /*        lsn.c:1945 */
#define   ELSN443      (ERRLSN +  443)    /*        lsn.c:1946 */
#define   ELSN444      (ERRLSN +  444)    /*        lsn.c:1947 */
#define   ELSN445      (ERRLSN +  445)    /*        lsn.c:1948 */
#define   ELSN446      (ERRLSN +  446)    /*        lsn.c:1949 */
#define   ELSN447      (ERRLSN +  447)    /*        lsn.c:1950 */
#define   ELSN448      (ERRLSN +  448)    /*        lsn.c:1951 */
#define   ELSN449      (ERRLSN +  449)    /*        lsn.c:1952 */
#define   ELSN450      (ERRLSN +  450)    /*        lsn.c:1953 */
#define   ELSN451      (ERRLSN +  451)    /*        lsn.c:1954 */
#define   ELSN452      (ERRLSN +  452)    /*        lsn.c:1955 */
#define   ELSN453      (ERRLSN +  453)    /*        lsn.c:1956 */
#define   ELSN454      (ERRLSN +  454)    /*        lsn.c:1957 */
#define   ELSN455      (ERRLSN +  455)    /*        lsn.c:1958 */
#define   ELSN456      (ERRLSN +  456)    /*        lsn.c:1959 */
#define   ELSN457      (ERRLSN +  457)    /*        lsn.c:1960 */
#define   ELSN458      (ERRLSN +  458)    /*        lsn.c:1961 */
#define   ELSN459      (ERRLSN +  459)    /*        lsn.c:1962 */
#define   ELSN460      (ERRLSN +  460)    /*        lsn.c:1963 */
#define   ELSN461      (ERRLSN +  461)    /*        lsn.c:1964 */
#define   ELSN462      (ERRLSN +  462)    /*        lsn.c:1965 */
#define   ELSN463      (ERRLSN +  463)    /*        lsn.c:1966 */
#define   ELSN464      (ERRLSN +  464)    /*        lsn.c:1967 */
#define   ELSN465      (ERRLSN +  465)    /*        lsn.c:1970 */
#define   ELSN466      (ERRLSN +  466)    /*        lsn.c:1971 */
#define   ELSN467      (ERRLSN +  467)    /*        lsn.c:1975 */
#define   ELSN468      (ERRLSN +  468)    /*        lsn.c:1977 */
#define   ELSN469      (ERRLSN +  469)    /*        lsn.c:1978 */
#define   ELSN470      (ERRLSN +  470)    /*        lsn.c:1979 */
#define   ELSN471      (ERRLSN +  471)    /*        lsn.c:1980 */
#define   ELSN472      (ERRLSN +  472)    /*        lsn.c:1981 */
#define   ELSN473      (ERRLSN +  473)    /*        lsn.c:1982 */
#define   ELSN474      (ERRLSN +  474)    /*        lsn.c:1983 */
#define   ELSN475      (ERRLSN +  475)    /*        lsn.c:1984 */
#define   ELSN476      (ERRLSN +  476)    /*        lsn.c:1985 */
#define   ELSN477      (ERRLSN +  477)    /*        lsn.c:1986 */
#define   ELSN478      (ERRLSN +  478)    /*        lsn.c:1987 */
#define   ELSN479      (ERRLSN +  479)    /*        lsn.c:1988 */
#define   ELSN480      (ERRLSN +  480)    /*        lsn.c:1989 */
#define   ELSN481      (ERRLSN +  481)    /*        lsn.c:1990 */
#define   ELSN482      (ERRLSN +  482)    /*        lsn.c:1991 */
#define   ELSN483      (ERRLSN +  483)    /*        lsn.c:1992 */
#define   ELSN484      (ERRLSN +  484)    /*        lsn.c:1993 */
#define   ELSN485      (ERRLSN +  485)    /*        lsn.c:1994 */
#define   ELSN486      (ERRLSN +  486)    /*        lsn.c:1997 */
#define   ELSN487      (ERRLSN +  487)    /*        lsn.c:1998 */
#define   ELSN488      (ERRLSN +  488)    /*        lsn.c:1999 */
#define   ELSN489      (ERRLSN +  489)    /*        lsn.c:2004 */
#define   ELSN490      (ERRLSN +  490)    /*        lsn.c:2005 */
#define   ELSN491      (ERRLSN +  491)    /*        lsn.c:2006 */
#define   ELSN492      (ERRLSN +  492)    /*        lsn.c:2007 */
#define   ELSN493      (ERRLSN +  493)    /*        lsn.c:2008 */
#define   ELSN494      (ERRLSN +  494)    /*        lsn.c:2048 */
#define   ELSN495      (ERRLSN +  495)    /*        lsn.c:2051 */
#define   ELSN496      (ERRLSN +  496)    /*        lsn.c:2054 */
#define   ELSN497      (ERRLSN +  497)    /*        lsn.c:2057 */
#define   ELSN498      (ERRLSN +  498)    /*        lsn.c:2060 */
#define   ELSN499      (ERRLSN +  499)    /*        lsn.c:2062 */
#define   ELSN500      (ERRLSN +  500)    /*        lsn.c:2105 */
#define   ELSN501      (ERRLSN +  501)    /*        lsn.c:2106 */
#define   ELSN502      (ERRLSN +  502)    /*        lsn.c:2109 */
#define   ELSN503      (ERRLSN +  503)    /*        lsn.c:2111 */
#define   ELSN504      (ERRLSN +  504)    /*        lsn.c:2154 */
#define   ELSN505      (ERRLSN +  505)    /*        lsn.c:2157 */
#define   ELSN506      (ERRLSN +  506)    /*        lsn.c:2201 */
#define   ELSN507      (ERRLSN +  507)    /*        lsn.c:2204 */
/*lsn_h_001.main_29 - Added new code*/
#define   ELSN508      (ERRLSN +  508)    /*        lsn.c:1146 */


#define LSNLOGERROR(errCls, errCode, errVal, errDesc) \
        SLogError(pst->srcEnt, pst->srcInst, pst->srcProcId, __FILE__, __LINE__, \
                  errCls, errCode, errVal, errDesc)
 
#endif /* __LSNH_ */
 

/********************************************************************30**
  
         End of file:     lsn.h@@/main/30 - Mon May 12 11:03:28 2008
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/


/********************************************************************60**
  
        Revision history:
  
Version   Patch  Initials   Description
-------- ------- ---------  ------------------------------------------------
lsn_h_001.main_25      rs   1. Added support for NSAP statistics under flag SN_UPSTS
lsn_h_001.main_26      rs  1. Added LSNV4 interface version.
                           2. Added new events, hash defines for circular
                              buffer support.
                           3. Added new defines for recovery queue                              
lsn_h_001.main_27      rs  1. Release 3.3.
********************************************************************90**
        Revision history:
************************************************************************
  version     pat      init                   description
----------- ---------  ----    -----------------------------------------
/main/28     ---      rs   1. Initial for 3.3 Release.
lsn_h_001.main_28      rs  1. Corrected value of Macros
lsn_h_001.main_29      rs  1. Added new error code.
*********************************************************************91*/
