 /********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     layer management - portable
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               Layer Management service user.

     File:     lsi.x
  
     Sid:      lsi.x@@/main/34 - Tue Jan  4 17:41:05 2011

     Prg:      bn
 
*********************************************************************21*/
  
#ifndef __LSIX__
#define __LSIX__

  
/*
*     The structures and variables declared in this file
*     correspond to structures and variables used by
*     the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000029     Signalling System 7 - ISUP
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000029     Signalling System 7 - ISUP
*
*/
   
  
/* lsi_x_001.main_25 */

/* public variable declarations */


/* ISUP */

typedef struct siCirGrTmrCfg    /* circuit group timer configuration        */
{
   TmrCfg t18;                  /* t18 timer - group blocking sent          */
   TmrCfg t19;                  /* t19 timer - initial group blocking sent  */
   TmrCfg t20;                  /* t20 timer - group unblocking sent        */
   TmrCfg t21;                  /* t21 timer - initial grp unblocking sent  */
   TmrCfg t22;                  /* t20 timer - group reset sent             */
   TmrCfg t23;                  /* t21 timer - initial group reset sent     */
   TmrCfg t28;                  /* t21 timer - circuit group query sent     */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   TmrCfg tFGR;                 /* first group received timer               */
#endif
#ifdef SI_218_COMP
   TmrCfg tGRES;                /* group reset timer                        */
#endif
} SiCirGrTmrCfg;

typedef struct siGenCfg         /* ISUP general configuration               */
{
   U16    nmbSaps;              /* Number of ISUP Saps                      */
   U16    nmbNSaps;             /* Number of Network Saps                   */
   U32    nmbCir;               /* Number of circuits                       */
   U16    nmbIntf;              /* Number of interfaces                     */
   U16    nmbCirGrp;            /* Max number of circuit groups             */
   U32    nmbCalRef;            /* Number of Call References                */
#ifdef SI_218_COMP
   U16    nmbRouts;             /* Number of routes                         */
#endif
   S16    timeRes;              /* time resolution                          */
   Bool   sccpSup;              /* SCCP support                             */
   Bool     handleTTBinCC;      /* Flag used for controlling TTB feature    */
   Bool     mapCPCandFCI;      /* Flag used for controlling TTB feature    */

#if (LSIV3 || LSIV4 || LSIV5)
   U8     lnkSelOpt;            /* link selector option                     */
#endif   
   Status poolTrUpper;          /* upper pool threshold                     */
   Status poolTrLower;          /* lower pool threshold                     */
   SiCirGrTmrCfg cirGrTmr;      /* circuit group timers                     */
   Pst sm;                      /* stack manager                            */

/* lsi_x_001.main_30 : Corrected order of cgPtyNumGenCfg variable */
/* lsi_x_001.main_29 : Added general configuration flag required for Calling 
   party number enum check feature */
#if CGPN_CHK
   Bool cgPtyNumGenCfg;         /* Calling party number general config flag */
#endif

/* lsi_x_001.main_30 : Added new variable */
#ifdef SI_SUPPRESS_CFN
   Bool suppressCfn;            /* Flag used for 'suppress CFN' feature */
#endif
/*lsi_x_001.main_33: Flag used for calling party NOA feature for Kazakhstan*/
#if (defined(SS7_KZ) && defined(KZ_ALLOW_ITU_NOA))
     Bool kzallownoa;              /* Flag used for calling party NOA feature for Kazakhstan */
#endif

} SiGenCfg;

typedef struct siTmrCfg         /* ISUP connection timer configuration      */
{
   TmrCfg t1;                   /* t1 timer - release sent                  */
   TmrCfg t2;                   /* t2 timer - suspend received              */
   TmrCfg t5;                   /* t5 timer - initial release sent          */
   TmrCfg t6;                   /* t6 timer - suspend received              */
   TmrCfg t7;                   /* t7 timer - latest address sent           */
   TmrCfg t8;                   /* t8 timer - initial address received      */
   TmrCfg t9;                   /* t9 timer - latest address sent after ACM */
   TmrCfg t31;                  /* t31 timer - call reference frozen period */
   TmrCfg t33;                  /* t33 timer - INR sent                     */
   TmrCfg tCCR;                 /* tCCR timer - continuity recheck timer    */
   TmrCfg t27;                  /* t27 timer - wait. for continuity recheck */
   TmrCfg t34;                  /* t34 timer - wait. for continuity after 
                                 * recheck                                  */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   TmrCfg tEx;                  /* tEx timer - Exit to be sent              */
#endif
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   TmrCfg tCRM;                 /* circuit reservation message timer        */
   TmrCfg tCRA;                 /* circuit reservation ack.  timer          */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   TmrCfg tCCRt;                /* tCCR timer (o/g side) - continuity recheck 
                                 * timer                                    */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
#if (SS7_ETSI || SS7_ITU97 || SS7_ETSIV3 || SS7_UK || SS7_NZL || SS7_KZ)
   TmrCfg tECT;                 /* Explicit Call Transfer - waiting for loop 
                                 * prvnt rsp                                */
#endif
#if SS7_FTZ
   TmrCfg tGTCHG;               /* waiting for CHGEA                        */
#endif
   TmrCfg t36;                  /* waiting SGM                              */
   TmrCfg tRELRSP;              /* waiting for release response             */
   TmrCfg tFNLRELRSP;           /* waiting for final release response       */
   /* lsi_x_001.main_32 : Added CCL timer for ukraine */
#if SS7_UR
   TmrCfg tCCL;                 /* CCL sent waiting for  release        */
#endif
} SiTmrCfg;

typedef struct siSAPCfg         /* ISUP Sap Configuration structure         */
{
#if (SI_LMINT3 || SMSI_LMINT3)
   SpId     sapId;              /* Id of the SAP being configured           */
#endif
   Swtch    swtch;              /* Protocol Switch                          */
   U8       ssf;                /* Sub service field                        */
#ifdef SI_218_COMP
   Bool     wcRout;             /* Wild Card Routing Flag                   */
   U8       wcMask[ADRLEN];     /* Wild Card Mask                           */
#endif
   Bool     sidIns;             /* SID insertion Flag                       */
   Bool     sidVer;             /* SID verification Flag                    */
   Addrs    sid;                /* SID                                      */
   U8       natAddrInd;         /* SID Nature of Addres Indicator           */
   U8       sidNPlan;           /* SID Numbering Plan                       */
   U8       sidPresInd;         /* default presentation indicator           */
   Bool     incSidPresRes;      /* Presentation Restriction of incoming SID */
   Bool     sidPresRes;         /* Presentation Restriction                 */
   Bool     reqOpt;             /* Request option                           */
   Bool     allCallMod;         /* call modification allowed flag           */
   U8       maxLenU2U;          /* Max length of user to user messages      */
   Bool     passOnFlag;         /* flag for passing unknown par/msg         */
   U8       relLocation;        /* release location indicator in cause val. */
   SiTmrCfg tmr;                /* connection timers                        */
   Priority prior;              /* priority                                 */
   Route    route;              /* route                                    */
   Selector selector;           /* selector                                 */
   MemoryId mem;                /* memory region & pool id                  */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool remIntfValid;           /* remote interface version is valid */
   CmIntfVer remIntfVer;        /* remote interface version */
#endif
} SiSAPCfg;

typedef struct siNSAPCfg        /* ISUP Network Sap Configuration structure */
{
#if (SI_LMINT3 || SMSI_LMINT3)
   SpId     nsapId;             /* Id of the NSAP being configured          */
#endif
#ifdef SI_218_COMP
   Swtch    swtch;              /* Variant of lower SAP                     */
#endif
   SiInstId nwId;               /* Network Id                               */
   SpId     spId;               /* service providor id                      */
   U8       ssf;                /* sub service field                        */
   Ent      dstEnt;             /* entity                                   */
   Inst     dstInst;            /* instance                                 */
   Priority prior;              /* priority                                 */
   Route    route;              /* route                                    */
   ProcId   dstProcId;          /* destination processor id                 */
   S16      sapType;            /* sap type                                 */
#ifdef SI_218_COMP
   U8       numResInd;          /* max simultaneous res ind to upper        */
   Dpc      dfltOpc;            /* Default OPC for the protocol swtch       */
#endif
   Selector selector;           /* selector                                 */
   TmrCfg   tINT;               /* interface (Bind Confirm) timer           */
   MemoryId mem;                /* memory region & pool id                  */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool remIntfValid;           /* remote interface version is valid */
   CmIntfVer remIntfVer;        /* remote interface version */
#endif
} SiNSAPCfg;

typedef struct siDpcCbTmrCfg    /* Interface timers configuration          */
{
   TmrCfg t4;                   /* t4 timer - user part test sent           */
   TmrCfg tPAUSE;               /* waiting for PAUSE to be effective        */
   TmrCfg tSTAENQ;              /* status enquiry timer                     */
} SiDpcCbTmrCfg;
        
typedef struct siIntfCbCfg       /* Interface control block configuration   */
{
   SiInstId      intfId;        /* Interface id                             */
   SiInstId      nwId;          /* Network Id                               */
   SpId          sapId;         /* Id of the Upper ISUP SAP                 */
   Dpc           opc;           /* physical originating point code          */
   Dpc           phyDpc;        /* physical destination point code          */
   Swtch         swtch;         /* Protocol Switch                          */
   U8            ssf;           /* subsystem service information            */
   SiDpcCbTmrCfg dpcCbTmr;      /* interface relates Timers                 */
   U8            pauseActn;     /* call clearing behavior upon rx. PAUSE    */
#if SS7_ANS95
   Bool          availTest;      /* circuit validation test                 */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ITU97 || SS7_ETSIV3 || SS7_UK || SS7_NZL || SS7_ITU2000 || SS7_KZ \
      || SS7_UR)
   U8            checkTable;     /* Validation flag for Table 3 p1/p2 Q.763 */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ANS95 || SS7_ITU97 || SS7_ETSIV3 || SS7_UK || SS7_NZL || SS7_ITU2000 \
      || SS7_KZ || SS7_UR)
   Bool          trunkType;      /* truck type E1(TRUE)/T1(FALSE) at intf   */
#endif
#if (LSIV4 || LSIV5)
   U8     lnkSelOpt;            /* link select option                       */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   U8     lnkSelBits;           /* number of bits for link selection        */
#endif
#endif
} SiIntfCbCfg;

typedef struct siCirTmrCfg      /* circuit timer configuration              */
{
   TmrCfg t3;                   /* t3  timer - overload received            */
   TmrCfg t12;                  /* t12 timer - blocking sent                */
   TmrCfg t13;                  /* t13 timer - initial blocking sent        */
   TmrCfg t14;                  /* t14 timer - unblocking sent              */
   TmrCfg t15;                  /* t15 timer - initial unblocking sent      */
   TmrCfg t16;                  /* t16 timer - reset sent                   */
   TmrCfg t17;                  /* t17 timer - initial reset sent           */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   TmrCfg tVal;                 /* circuit validation timer                 */
#endif
} SiCirTmrCfg;

typedef struct siCirCfg         /* Circuit Configuration                    */
{
   CirId       cirId;           /* circuit id code                          */
   Cic         cic;             /* cic                                      */
   SiInstId    intfId;          /* interface id                             */
   U8          typeCntrl;       /* type of control                          */
#ifdef SI_218_COMP
   U8          bearProf;        /* bearer profile                           */
#endif 
   U16         cirFlg;          /* Flag indicating diff cfg options for ckt */
   Bool        contReq;         /* continuity check required                */
#if (SI_218_COMP || SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cic         firstCic;        /* First cic in the circuit group           */
   U8          numCir;          /* Number of circuits in the circuit group  */
   Bool        nonSS7Con;       /* connecting to non SS7 network            */
   Addrs       outTrkGrpN;      /* outgoing trunk group number (For EXM)    */
   Addrs       cvrTrkClli;      /* Trunk Group number (For CVR validation)  */
   Addrs       clli;            /* common language location identifier      */
#endif
   SiCirTmrCfg cirTmr;          /* circuit timers                           */
#if (SS7_ANS95 || SS7_ITU97 || SS7_ETSIV3 || SS7_UK)
   U8          slotId;          /* physical slot id bit wise flag           */
   U8          ctrlMult;        /* Controller for multirate calls           */
#endif
} SiCirCfg;

#ifdef SI_218_COMP
typedef struct siRoutCfg        /* Route Configuration                      */
{
   Addrs addr;                  /* address                                  */
   Dpc   opc;                   /* originating point code                   */
   S16   nmbDpc;                /* number of Dpc leading to a specific rout */
   struct
   {
      Dpc      phyDpc;          /* destination point code                   */
      SiInstId nwId;            /* Network Id                               */
      Bool     isupAv;          /* ISUP available                           */
      Priority priority;        /* priority                                 */
   } dst[MAXNUMDPC];
   Bool  loadShar;              /* load sharing indication                  */
} SiRoutCfg;
#endif


typedef struct siCfg            /* ISUP configuration                       */
{
   union
   {
      SiGenCfg   siGen;         /* ISUP General Config                      */
      SiSAPCfg   siSap;         /* ISUP SAP Config                          */
      SiNSAPCfg  siNSap;        /* ISUP Network SAP Config                  */
      SiIntfCbCfg siIntfCb;     /* ISUP Interface control block             */
      SiCirCfg   siCir;         /* ISUP Circuit Config                      */
#ifdef SI_218_COMP
      SiRoutCfg  siRout;        /* ISUP Route Config                        */
#endif
   } s;
} SiCfg;

typedef struct siDbgCntrl       /* debugging control structure              */
{
   U32 dbgMask;                 /* debug mask                               */
} SiDbgCntrl;

typedef struct siTrcCntrl       /* trace control structure                  */
{
   SpId nsapId;                 /* NSAP id                                  */
   S16  nsapType;               /* type of NSAP - MTP-3/SCCP                */
} SiTrcCntrl;

typedef union siElmntId         /* element identifier                       */
{
   SpId      sapId;             /* upper SAP/network SAP id                 */
   CirId     circuit;           /* circuit id                               */
   SiInstId  spInstId;          /* conn. parameter - spInstId of conn block */
   SiInstId  intfId;            /* Destination point code                   */
   ProcId    dstProcId;         /* Destination Processor Id                 */
} SiElmntId;
    
typedef union siElmntParam
{
   struct                       /* circuit group control request parameters */
   {
      U8 swtch;                  /* protocol switch                         */
      U8 range;                  /* range value                             */
      U8 cgsmti;                 /* type of request : h/w or mntc oriented  */
      U8    status[MAX_SIZ_STATUS]; /* status octets                        */
#if (SS7_ANS95)
      U32  mapFormat;  /* Circuit bit map format */
      U8   mapType;                      /* Circuit map type */
      U8   mapPres;       /* inidicate the CAM is presented in GRS */
#endif
   } cirgr;

   struct
   {
      U8 swtch;                /* protocol switch                          */
      U8 flag;                 /* local/remote/forced delete flag          */
   } cir;

   struct
   {
      U8 nsapType; 
   } nsap;
#ifdef SI_218_COMP
   SiRoutCfg route;            /* ISUP route                               */
#endif
#if (LSIV2 || LSIV3 || LSIV4 || LSIV5)
   struct                       /* circuit group control request parameters */
   {
      U8 swtch;                  /* protocol switch                         */
      U8 range;                  /* range value                             */
      U8 cgsmti;                 /* type of request : h/w or mntc oriented  */
      U8 status[MAX_SIZ_STATUS]; /* status octets                           */
      Dpc  opc;                  /* physical originating point code         */
      Dpc  phyDpc;               /* physical destination point code         */
      Cic  cic;                  /* cic for sending CGB                     */
   } forblk;
#endif /* LSIV2 or LSIV3 or LSIV4 */
} SiElmntParam;

typedef struct siElmntCntrl     /* ISUP element control                     */
{
   SiElmntId    elmntId;
   SiElmntParam elmntParam;
} SiElmntCntrl;

typedef struct siCntrl          /* ISUP control structure                   */
{
   DateTime dt;                 /* date and time                            */
   U8       action;             /* action                                   */
   U8       subAction;          /* sub action                               */
#if (SI_LMINT3 || SMSI_LMINT3)
   union
   {
      SiDbgCntrl   siDbg;       /* debugging control                        */
      SiTrcCntrl   siTrc;       /* trace control                            */
      SiElmntCntrl siElmnt;     /* trace control                            */
   } s;
#else /* (SI_LMINT3 || SMSI_LMINT3) */
   union 
   {
      struct 
      {
         U8 range;        /* range value for the circuit group request */
         U8 cgsmti;       /* circuit group request type (h/w or mntc.) */
         U8 status[MAX_SIZ_STATUS]; 
                                /* status bits indicating affected circuits  */
#if (SS7_ANS95)
         U32  mapFormat;  /* Circuit bit map format */
         U8   mapType;                     /* Circuit map type */
         U8   pres;       /* inidicate the CAM is presented in GRS */
#endif
      } cirgrp;

      SiDbgCntrl siDbg;   /* for changing the value of dbgMask */

   } param;
   union
   {
      CirId cirId;       /* circuit id code */
      SiInstId intfId;   /* interface id */ 
   } sigpt; 
#endif /* (SILMINT3 || SMSI_LMINT3) */
} SiCntrl;

#if SI_ACNT
typedef struct acntgInfo        /* accounting information */
{
   Ticks calDura;               /* Call Duration */
   Addrs dstAdr;                /* Destination Address */
   Addrs srcAdr;                /* Source Address */
#if (SS7_ANS95 || SS7_ITU97 || SS7_ETSIV3)
   U8    numCirUsed;            /* # of circuits used in a call */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Addrs chrgNum;                /* Charge Number */
#endif /* (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL) */
} AcntgInfo;

typedef struct siAcnt             /* ISUP accounting info */
{
   DateTime dt;           /* date and time */
   AcntgInfo acntRec;     /* accounting record */
} SiAcnt;                 /* accounting */
#endif 

#if (LSIV2 || LSIV3 || LSIV4 || LSIV5 || defined(TDS_ROLL_UPGRADE_SUPPORT))
typedef struct siSAPSta         /* ISUP  - SAP status */
{  
#if (LSIV2 || LSIV3 || LSIV4 || LSIV5)
   SuId      suId;              /* service user Id */
   SpId      spId;              /* service provider Id */
   S16       state;             /* state */
#endif /* LSIV2 or LSIV3 or LSIV4 */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool      remIntfValid;      /* remote interface valid in cfg ?*/
   CmIntfVer selfIntfVer;       /* self interface version on this SAP */
   CmIntfVer remIntfVer;        /* remote interface version on this SAP */
#endif
} SiSAPSta;
#endif

#if (SI_LMINT3 || SMSI_LMINT3)

typedef struct siSstaCfm
{
   union
   {
      SystemId sid;
      struct 
      {
         U8    state[MAX_SIZ_STATUS]; /* state of the circuits */
      } cir;

      struct
      {
         U8 state;
      } intf;
#if (LSIV2 || LSIV3 || LSIV4 || LSIV5 || defined(TDS_ROLL_UPGRADE_SUPPORT))
      SiSAPSta    siSAPVer;     /* ISUP SAP version info  */
#endif      
   } s;
} SiSstaCfm;

#else /* LMINT2 */

/* siCirSta structure */
typedef struct siCirSta         /* ISUP Circuit status */
{
   U8 transState[NUMCIREVTGRP]; /* circuit transient states */
   U8 callState;                /* circuit call processing state */
} SiCirSta;


#endif /* (SI_LMINT3 || SMSI_LMINT3) */

typedef struct siSsta
{
   DateTime dt;           /* date and time */
#if (SI_LMINT3 || SMSI_LMINT3)

   SiElmntId    elmntId;
   SiElmntParam param;
   SiSstaCfm    cfm;

#else /* LMINT2 */
   union
   {
      SiCirSta    siCirSta;  /* ISUP Circuit status */
   } s;
#endif
} SiSsta;



#if (SI_LMINT3 || SMSI_LMINT3)

typedef struct siPduSts      /* PDU transmit/receive statistics              */
{
   Cntr acm;                 /* Address complete                             */
   Cntr anm;                 /* Answer                                       */
   Cntr bla;                 /* Blocking ack                                 */
   Cntr blo;                 /* Blocking                                     */
   Cntr ccr;                 /* Continuity check request                     */
   Cntr cfn;                 /* Confusion                                    */
   Cntr cgb;                 /* Circuit group blocking                       */
   Cntr cgba;                /* Circuit group blocking acknowledgement       */
   Cntr cgu;                 /* Circuit group unblocking                     */
   Cntr cgua;                /* Circuit group unblocking acknowledgement     */
   Cntr con;                 /* Connect                                      */
   Cntr cot;                 /* Continuity                                   */
   Cntr cpg;                 /* Call progress                                */
   Cntr cqm;                 /* Circuit query                                */
   Cntr cqr;                 /* Circuit query acknowledgement                */
   Cntr crg;                 /* Charging                                     */
   Cntr faa;                 /* Facility accepted                            */
   Cntr fac;                 /* Facility                                     */
   Cntr farMsg;              /* Facility request                             */
   Cntr fot;                 /* Forward transfer                             */
   Cntr frj;                 /* Facility rejected                            */
   Cntr gra;                 /* Circuit group reset acknowledgement          */
   Cntr grs;                 /* Circuit group reset                          */
   Cntr iam;                 /* Initial address                              */
   Cntr idr;                 /* Identification request                       */
   Cntr inf;                 /* Information                                  */
   Cntr inr;                 /* Information request                          */
   Cntr irs;                 /* Identification response                      */
   Cntr lop;                 /* Loop prevention                              */
   Cntr lpa;                 /* Loopback acknowledgement                     */
   Cntr nrm;                 /* Network resource management                  */
   Cntr olm;                 /* Overload                                     */
   Cntr pam;                 /* Pass-along                                   */
   Cntr rel;                 /* Release                                      */
   Cntr res;                 /* Resume                                       */
   Cntr rlc;                 /* Release complete                             */
   Cntr rsc;                 /* Reset                                        */
   Cntr sam;                 /* Subsequent address                           */
   Cntr sgm;                 /* Segmentation                                 */
   Cntr sus;                 /* Suspend                                      */
   Cntr uba;                 /* Unblocking ack                               */
   Cntr ubl;                 /* Unblocking                                   */
   Cntr ucic;                /* Unequipped CIC                               */
   Cntr upa;                 /* User part available                          */
   Cntr upt;                 /* User part test                               */
   Cntr usr;                 /* User to user                                 */
#if SS7_ANS88
   Cntr cmc;                 /* Call modification complete                   */
   Cntr cmr;                 /* Call modification request                    */
   Cntr cmrj;                /* Call modification reject                     */
   Cntr csvr;                /* CUG selection and validation request         */
   Cntr csvs;                /* CUG selection and validation response        */
   Cntr fad;                 /* Facility deactivation                        */
   Cntr fai;                 /* Facility information                         */
#endif /* SS7_ANS88 */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr cra;                 /* Circuit reservation acknowledgement          */
   Cntr crm;                 /* Circuit reservation                          */
#endif /* SS7_ANS92 || SS7_ANS95 || SS7_BELL */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr cvr;                 /* Circuit validation response                  */
   Cntr cvt;                 /* Circuit validation                           */
   Cntr exm;                 /* Exit                                         */
#endif /* (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL) */
#if SS7_SINGTEL
   Cntr cak;                 /* Charging acknowledgement                     */
   Cntr mcp;                 /* Malicious call printing                      */
   Cntr tcm;                 /* Tariff change                                */
#endif /* SS7_SINGTEL */
#if SS7_Q767IT
   Cntr com;                 /* Call offering                                */
#endif /* SS7_Q767IT */
#if SS7_FTZ
   Cntr chg;                 /* FTZ charging                                 */
   Cntr chge;                /* Charging extended                            */
   Cntr chgea;               /* Charging extended acknowledgement            */
   Cntr ehza;                /* Hanging up of A-tln                          */
   Cntr fin;                 /* Facility information                         */
   Cntr nana;                /* National (FTZ)                               */
   Cntr uin;                 /* User information                             */
#endif /* SS7_FTZ */
#if SS7_RUSSIA
   Cntr ccl;                 /* Including calling line clear */
   Cntr rng;                 /* Including riniging send message */
#endif
#if SS7_NTT
   Cntr chgntt;              /* Charge message for NTT variant */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_INDIA  || SS7_UK || SS7_ITU2000 || SS7_KZ \
      || SS7_UR)
   Cntr apn;                 /* Application transport message*/
   Cntr pri;                 /* Pre-release information message */
#endif
#if SS7_CHINA
   Cntr opr;                 /* Operator message*/
   Cntr mpm;                 /* Metering Pulse message */
   Cntr cpc;                 /* Calling Party Clearing message*/
#endif
} SiPduSts;

typedef struct siIntfSts      /* Interface statistics */
{
   struct
   {
      Cntr tx;               /* total transmitted messages                   */
      Cntr rx;               /* total received messages                      */
   } total;

   struct
   {
      SiPduSts tx;           /* total of each message type transmitted       */
      SiPduSts rx;           /* total of each message type received          */
   } pdu;
} SiIntfSts;

typedef struct siErrSts      /* Error statistics                             */
{
   Cntr t5Exp;               /* Timer T5 expiry - RLC not recieved           */
   Cntr t13Exp;              /* Timer T13 expiry - BLA not received for BLO  */
   Cntr t15Exp;              /* Timer T15 expiry - UBA not received for UBL  */
   Cntr t17Exp;              /* Timer T17 expiry - RLC not received for RSC  */
   Cntr t19Exp;              /* Timer T19 expiry - CGBA not received for CGB */
   Cntr t21Exp;              /* Timer T19 expiry - CGUA not received for CGU */
   Cntr t23Exp;              /* Timer T19 expiry - GRA not received for GRS  */
/* lsi_x_001.main_27 : added t33IExp structure member to maintain counter
    for T33I timer expiry */
#ifdef SI_CGPN_T33I_KZ
   Cntr t33IExp;             /* Timer T33I expiry - INF not received for INR  */
#endif
   Cntr abnrmlRel;           /* Release initiated due to abnormal conditions */
   Cntr blkReq;              /* Circuit blocking request                     */
   Cntr noAckCgba;           /* Missing status bit in CGBA for previous CGB  */
   Cntr noAckCgua;           /* Missing status bit in CGUA for previous CGU  */
   Cntr abnrmlAckCgba;       /* Addl. status bit set for the circuit not 
                              * expecting blocking ack in CGBA for prev. CGB */
   Cntr abnrmlAckCgua;       /* Addl. status bit set for the circuit not 
                              * expecting unblking ack in CGUA for prev. CGU */
   Cntr unxCgba;             /* Unexpected CGBA with status bit set for the
                              * circuit not expecting a blocking ack         */
   Cntr unxCgua;             /* Unexpected CGUA with status bit set for the 
                              * circuit not expecting an unblocking ack      */
   Cntr unxBla;              /* Unexpected BLA in an invalid state for a ckt */
   Cntr unxUba;              /* Unexpected UBA in an invalid state for a ckt */
   Cntr pduFmtErr;           /* Message format error                         */
   Cntr unxMsg;              /* Unexpected message received from network     */
   Cntr unxEvt;              /* Unexpected event received */
   Cntr relUnrecInfo;        /* Release due to unrecognised information      */
   Cntr relFail;             /* Inability to release a circuit               */
#if (SS7_ANS95 || SS7_ITU97 || SS7_ETSIV3)
   Cntr numNonCont;          /* a circuit participated as non contiguos calls*/
#endif
} SiErrSts;

typedef SiErrSts SiCirSts;   /* circuitwise error statistics counters        */

#else /* !(SI_LMINT3 || SMSI_LMINT3) */
typedef struct siNSAPSts        /* ISUP Network Sap statistics */
{
   Cntr adrCmpltTx;             /* Address complete transmitted */
   Cntr answerTx;               /* Answer transmitted */
   Cntr progressTx;             /* Progress transmitted */
   Cntr contiTx;                /* Continuity transmitted */
   Cntr conChkReqTx;            /* Continuity Check Request transmitted */
   Cntr loopBckAckTx;           /* Lookback Acknowledge transmitted */
   Cntr confusTx;               /* Confusion transmitted */
   Cntr callModReqTx;           /* Call Modification Request transmitted */
   Cntr callModRejTx;           /* Call Modification Reject transmitted */
   Cntr callModComTx;           /* Call Modification Complete transmitted */
   Cntr suspTx;                 /* Suspend transmitted */
   Cntr resmTx;                 /* Resume transmitted */
   Cntr forwTx;                 /* Forward transmitted */ 
   Cntr conTx;                  /* Connect transmitted */
   Cntr relTx;                  /* Release transmitted */
   Cntr overldTx;               /* Overload transmitted */
   Cntr relCmpltTx;             /* Release Complete transmitted */
   Cntr facTx;                  /* Facility Request transmitted */
   Cntr facAckTx;               /* Facility Ack transmitted */
   Cntr facRejTx;               /* Facility Reject transmitted */
   Cntr initAdrTx;              /* Initial Address transmitted */
   Cntr infoTx;                 /* Info transmitted */
   Cntr infoReqTx;              /* Info Request transmitted */
   Cntr passAlongTx;            /* Pass Along transmitted */
   Cntr subsAdrTx;              /* Subsequent Address transmitted */
   Cntr usrToUsrTx;             /* User to User transmitted */
   Cntr uneqCirIdTx;            /* Unequipped Circuit ID transmitted */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr cirReserveTx;           /* circuit reservation  transmitted */
   Cntr cirResAckTx;            /* circuit reservation ack transmitted */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr exitTx;                 /* exit transmitted */
#endif
   Cntr netResMgmtTx;           /* Network Resourse transmitted */
   Cntr netIdReqTx;             /* Network Id Request transmitted */
   Cntr netIdRspTx;             /* Network Id Request transmitted */
#if SS7_SINGTEL
   Cntr malCllPrntTx;           /* Malicious Call Print transmitted */
   Cntr trfChngeTx;             /* Tariff change transmitted */
   Cntr chargeAckTx;            /* Charge ack transmitted */
#endif
#if (SS7_SINGTEL || SS7_RUSSIA || SS7_INDIA)
   Cntr chargeTx;               /* Charge transmitted */
#endif
#if SS7_Q767IT
   Cntr comTx;                  /* Call Offering transmitted */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_ETSIV3  || SS7_UK || SS7_ITU2000 || SS7_KZ \
      || SS7_UR)
   Cntr loopPrvntTx;            /* Loop Prevention transmitted */
#endif
#if SS7_FTZ
   Cntr chargingTx;             /* Charging transmitted */
   Cntr chargExtdTx;            /* Charging extended transmitted */
   Cntr chargExtdATx;           /* Charging extended ack transmitted */
   Cntr facInfoTx;              /* Facility Information transmitted */
   Cntr ehzaTx;                 /* Hang up indication A-Tln transmitted */
   Cntr usrInfTx;               /* User Information transmitted */
   Cntr natMsgTx;               /* National message transmitted */
#endif
#if SS7_RUSSIA
   Cntr ringSendTx;             /* Ringing Send Transmitted */
   Cntr callClearTx;            /* Call Line Clear transmitted */
#endif
#if SS7_NTT
   Cntr  chgnttTx;              /* Charge message transmitted */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_INDIA || SS7_UK || SS7_ITU2000 || SS7_KZ \
      || SS7_UR)
   Cntr appTranTx;                 /* Application transport message*/
   Cntr preRelTx;                 /* Pre-release information message */
#endif
#if SS7_CHINA
   Cntr oprTx;                 /* Operator message*/
   Cntr mpmTx;                 /* Metering pulse message */
   Cntr cpcTx;                 /* calling party clearing message */
#endif

   Cntr adrCmpltRx;             /* Address complete received */
   Cntr answerRx;               /* Answer received */
   Cntr progressRx;             /* Progress received */
   Cntr contiRx;                /* Continuity received */
   Cntr conChkReqRx;            /* Continuity Check Request received */
   Cntr loopBckAckRx;           /* Lookback Acknowledge received */
   Cntr confusRx;               /* Confusion received */
   Cntr callModReqRx;           /* Call Modification Request received */
   Cntr callModRejRx;           /* Call Modification Reject received */
   Cntr callModComRx;           /* Call Modification Complete received */
   Cntr suspRx;                 /* Suspend received */
   Cntr resmRx;                 /* Resume received */
   Cntr forwRx;                 /* Forward received */ 
   Cntr conRx;                  /* Connect received */
   Cntr overldRx;               /* Overload received */
   Cntr relRx;                  /* Release received */
   Cntr relCmpltRx;             /* Release Complete received */
   Cntr facRx;                  /* Facility Request received */
   Cntr facAckRx;               /* Facility Ack received */
   Cntr facRejRx;               /* Facility Reject received */
   Cntr initAdrRx;              /* Initial Address received */
   Cntr infoReqRx;              /* Info Request received */
   Cntr infoRx;                 /* Info received */
   Cntr passAlongRx;            /* Pass Along received */
   Cntr subsAdrRx;              /* Subsequent Address received */
   Cntr usrToUsrRx;             /* User to User received */
   Cntr uneqCirIdRx;            /* Unequipped Circuit ID received */
#if (SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr cirReserveRx;           /* circuit reservation  received */
   Cntr cirResAckRx;            /* circuit reservation ack received */
#endif
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr exitRx;                 /* exit received */
#endif
   Cntr netResMgmtRx;           /* Network Resourse received */
   Cntr netIdReqRx;             /* Network Id Request received */
   Cntr netIdRspRx;             /* Network Id Request received */
#if SS7_SINGTEL
   Cntr malCllPrntRx;           /* Malicious Call Print received */
   Cntr trfChngeRx;             /* Tariff change received */
   Cntr chargeAckRx;            /* Charge ack received */
#endif
#if (SS7_SINGTEL || SS7_RUSSIA || SS7_INDIA)
   Cntr chargeRx;               /* Charge received */
#endif
#if SS7_Q767IT
   Cntr comRx;                  /* Call Offering received */
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ETSI || SS7_ITU97 || SS7_ETSIV3 || SS7_UK || SS7_ITU2000 || SS7_KZ \
      || SS7_UR)
   Cntr loopPrvntRx;            /* Loop Prevention received */
#endif
#if SS7_FTZ
   Cntr chargingRx;             /* Charging received */
   Cntr chargExtdRx;            /* Charging extended received */
   Cntr chargExtdARx;           /* Charging extended ack received */
   Cntr facInfoRx;              /* Facility Information received */
   Cntr ehzaRx;                 /* Hang up indication A-Tln received */
   Cntr usrInfRx;               /* User Information received */
   Cntr natMsgRx;               /* National message received */
#endif
#if SS7_RUSSIA
   Cntr ringSendRx;             /* Ringing Send received */
   Cntr callClearRx;            /* Call Line Clear received */
#endif
#if SS7_NTT
   Cntr  chgnttRx;              /* Charge message received */ 
#endif
/* lsi_x_001.main_26 : Added control flag for ISUP kazakhstan */
/* lsi_x_001.main_32 : Added Control flag for ukraine */ 
#if (SS7_ETSIV3 || SS7_ITU97 || SS7_INDIA || SS7_UK || SS7_ITU2000 || SS7_KZ \
      || SS7_UR)
   Cntr appTranRx;                 /* Application transport message*/
   Cntr preRelRx;                 /* Pre-release information message */
#endif
#if SS7_CHINA
   Cntr oprRx;                 /* Operator message*/
   Cntr mpmRx;                 /* Metering pulse message */
   Cntr cpcRx;                 /* calling party clearing message */
#endif

} SiNSAPSts;


typedef struct siCirSts         /* ISUP Circuit statistics */
{
   Cntr blockTx;                /* Circuit Blocking Transmitted */
   Cntr blockAckTx;             /* Circuit Blocking Ack Transmitted */
   Cntr unblockTx;              /* Circuit Unblocking Transmitted */
   Cntr unblockAckTx;           /* Circuit Unblocking Ack Transmitted */
   Cntr cirResTx;               /* Circuit Reset Transmitted */
   Cntr cirGrBlockTx;           /* Circuit Group Blocking Transmitted */
   Cntr cirGrBlockAckTx;        /* Circuit Group Blocking Ack Transmitted */
   Cntr cirGrUnBlockTx;         /* Circuit Group Unblocking Transmitted */
   Cntr cirGrUnBlockAckTx;      /* Circuit Group Unblocking Ack Transmitted */
   Cntr cirGrQTx;               /* Circuit Group Query Transmitted */
   Cntr cirGrQAckTx;            /* Circuit Group Query Acknowledge 
                                   Transmitted */
   Cntr cirGrResTx;             /* Circuit Group Reset Transmitted */
   Cntr cirGrResAckTx;          /* Circuit Group Reset Ack Transmitted */
   Cntr usrPrtTstTx;            /* User Part Test Transmitted */
   Cntr usrPrtAvTx;             /* User Part Available Transmitted */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr cirValTstTx;            /* Circuit Validation Test Transmitted */
   Cntr cirValRspTx;            /* Circuit Validation Response Transmitted */
#endif
   Cntr blockRx;                /* Circuit Blocking Received */
   Cntr blockAckRx;             /* Circuit Blocking Ack Received */
   Cntr unblockRx;              /* Circuit Unblocking Received */
   Cntr unblockAckRx;           /* Circuit Unblocking Ack Received */
   Cntr cirResRx;               /* Circuit Reset Received */
   Cntr cirGrBlockRx;           /* Circuit Group Blocking Received */
   Cntr cirGrBlockAckRx;        /* Circuit Group Blocking Ack Received */
   Cntr cirGrUnBlockRx;         /* Circuit Group Unblocking Received */
   Cntr cirGrUnBlockAckRx;      /* Circuit Group Unblocking Ack Received */
   Cntr cirGrQRx;               /* Circuit Group Query Received */
   Cntr cirGrQAckRx;            /* Circuit Group Query Acknowledge 
                                   Transmitted */
   Cntr cirGrResRx;             /* Circuit Group Reset Received */
   Cntr cirGrResAckRx;          /* Circuit Group Reset Ack Received */   
   Cntr usrPrtTstRx;            /* User Part Test Received */
   Cntr usrPrtAvRx;             /* User Part Available Received */
#if (SS7_ANS88 || SS7_ANS92 || SS7_ANS95 || SS7_BELL)
   Cntr cirValTstRx;            /* Circuit Validation Test received */
   Cntr cirValRspRx;            /* Circuit Validation Response received */
#endif
#if SS7_RUSSIA
   Cntr ringSendRx;             /* Ringing Send received */
   Cntr callClearRx;            /* Call Line Clear received */
#endif
} SiCirSts;
#endif /* !(SI_LMINT3 || SMSI_LMINT3) */

typedef struct siSts
{
   DateTime dt;           /* date and time */
   Duration dura;         /* duration */
#if (SI_LMINT3 || SMSI_LMINT3)
   SiElmntId elmntId;     /* element identifier */
   /* lsi_x_001.main_28 : moved out Layerwide statistics from union */
   SiErrSts  gen;         /* Layerwide statistics */
   union
   {
      SiIntfSts intf;         /* interface statistics */
      SiCirSts  cir;          /* Circuit statistics   */
   } s;
#else
   union
   {
      SiNSAPSts siSts;    /* ISUP Network SAP Statistics */
      SiCirSts siCirSts;  /* ISUP Circuit Statistics */
   } s;
#endif
} SiSts;                    /* statistics */

typedef struct siUstaDgnVal
{
   U8 type;
   
   union
   {
      Event    event;        /* event identifier */
      SpId     spId;         /* service provider id */
      SuId     suId;         /* service user id     */
      SiInstId spInstId;     /* service provider instance id */
      SiInstId suInstId;     /* service user instance id */
      CirId    cirId;        /* circuit id */
      Cic      cic;          /* circuit identification code */
      Dpc      dpc;          /* dpc */
      SiInstId intfId;       /* interface id */
      Addrs    addrStatus;   /* address/status octets */
      Swtch    swtch;        /* protocol switch */
      U8       range;        /* range of circuit group request */
#ifdef SI_RUG
      CmIntfVer intfVer;     /* interface version number */
#endif /* SI_RUG */
/* lsi_x_001.main_26 : Included structure element for timer and message type */
      U16      tmrInfo;      /* timer type */
      U8       msgType;      /* Message type */
      U8       state;        /* Connection state */ 
      
   } t;
} SiUstaDgnVal;

typedef struct siUstaDgn
{
   SiUstaDgnVal dgnVal[LSI_USTA_MAX_DGNVAL];
} SiUstaDgn;

typedef struct siUsta
{
#if (SI_LMINT3 || SMSI_LMINT3)
   CmAlarm        alarm;        /* alarm structure */
   SiUstaDgn      dgn;          /* alarm diagnostic values */
#else /* LMINT2 */
   DateTime       dt;           /* date and time */
   U16            evnt;         /* event number */
   CirId          circuit;      /* circuit id */
#endif
} SiUsta;

typedef struct siTrc
{
   DateTime dt;                   /* date and time */
   U16      evnt;                 /* event */
   U8       sapType;              /* sap */
   Dpc      phyDpc;               /* dpc */
   SiInstId intfId;               /* interface id */   
   S16      length;               /* event */
   U8       evntParm[MAX_LSI_TRC];/* event parameters */
} SiTrc;

typedef struct siUDat
{
   Buffer *mBuf;          /* message buffer */
} SiUDat;

typedef struct siMngmt
{
   Header hdr;                  /* header */
#if (SI_LMINT3 || SMSI_LMINT3)
   CmStatus cfm;
#endif
   union 
   {
      SiCfg   cfg;   /* configuration */
      SiSts   sts;   /* statistics */
      SiSsta  ssta;  /* solicited status */
      SiUsta  usta;  /* unsolicited status */
      SiTrc   trc;   /* trace */
      SiCntrl cntrl; /* control */
#ifdef SI_218_COMP
      SiUDat  udat;  /* unit data */
#endif
#ifdef SI_ACNT 
      SiAcnt  siAcnt;
#endif 
   }t;
} SiMngmt;


/* activation task for loose coupling */
EXTERN S16 lmActvTsk ARGS((Priority priority, Route route, Ent ent, Inst inst, 
                           Buffer  *mBuf));

/*
 * depending on the specific selector in the post structure,
 * a primitive originated from a service provider can be dispatched to
 * any service user. The assumption is that, even if every primitive has
 * a different name depending in which file it resides, every primitive
 * must have the same function prototype, i.e. the same identical set
 * of arguments. These arguments are defined here 
 */


typedef S16 (*LsiStaInd)   ARGS((Pst *pst, SiMngmt *sta));
typedef S16 (*LsiAcntInd)  ARGS((Pst *pst, SiMngmt *acnt));
typedef S16 (*LsiTrcInd)   ARGS((Pst *pst, SiMngmt *trc));
typedef S16 (*LsiStaCfm)   ARGS((Pst *pst, SiMngmt *sta));
typedef S16 (*LsiStsCfm)   ARGS((Pst *pst, Action action, SiMngmt *sts));
typedef S16 (*LsiCfgReq)   ARGS((Pst *pst, SiMngmt *cfg));
typedef S16 (*LsiStaReq)   ARGS((Pst *pst, SiMngmt *sta));
typedef S16 (*LsiStsReq)   ARGS((Pst *pst, Action action,SiMngmt *sts));
typedef S16 (*LsiCntrlReq) ARGS((Pst *pst, SiMngmt *cntrl));
typedef S16 (*LsiCfgCfm)   ARGS((Pst *pst, SiMngmt *cfm));
typedef S16 (*LsiCntrlCfm) ARGS((Pst *pst, SiMngmt *cfm));

 /*lsi_x_001.main_31-removed extern"C"-removing warnings*/
 
#ifdef SM
extern S16 SmMiLsiStsCfm     ARGS((Pst *pst, Action action,SiMngmt *sts));
extern S16 SmMiLsiStaInd     ARGS((Pst *pst, SiMngmt *sta));
extern S16 SmMiLsiAcntInd    ARGS((Pst *pst, SiMngmt *acnt));
extern S16 SmMiLsiTrcInd     ARGS((Pst *pst, SiMngmt *trc));
extern S16 SmMiLsiStaCfm     ARGS((Pst *pst, SiMngmt *sta));
extern S16 SmMiLsiStsReq     ARGS((Pst *pst, Action action,SiMngmt *sts));
extern S16 SmMiLsiStaReq     ARGS((Pst *pst, SiMngmt *sta));
extern S16 SmMiLsiCfgReq     ARGS((Pst *pst, SiMngmt *cfg));
extern S16 SmMiLsiCntrlReq   ARGS((Pst *pst, SiMngmt *cntrl));
extern S16 SmMiLsiCfgCfm   ARGS((Pst *pst, SiMngmt *cfm));
extern S16 SmMiLsiCntrlCfm ARGS((Pst *pst, SiMngmt *cfm));
#endif /* SM */

/* stack manager initialization function */
extern S16 smSiActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));

/* stack manager activation function */
extern S16 smSiActvTsk ARGS((Pst *pst, Buffer *mBuf));


#ifdef SI                          /* ISUP */

extern S16 SiMiLsiCfgReq     ARGS((Pst *pst, SiMngmt *cfg));
extern S16 SiMiLsiStaReq     ARGS((Pst *pst, SiMngmt *sta));
extern S16 SiMiLsiStsReq     ARGS((Pst *pst, Action action,SiMngmt *sts));
extern S16 SiMiLsiCntrlReq   ARGS((Pst *pst, SiMngmt *cntrl));
extern S16 SiMiLsiStaInd     ARGS((Pst *pst, SiMngmt *sta));
extern S16 SiMiLsiTrcInd     ARGS((Pst *pst, SiMngmt *trc));
extern S16 SiMiLsiAcntInd    ARGS((Pst *pst, SiMngmt *acnt));
extern S16 SiMiLsiStaCfm     ARGS((Pst *pst, SiMngmt *sta));
extern S16 SiMiLsiStsCfm     ARGS((Pst *pst, Action action, SiMngmt *sts));
extern S16 SiMiLsiCfgCfm   ARGS((Pst *pst, SiMngmt *cfm));
extern S16 SiMiLsiCntrlCfm ARGS((Pst *pst, SiMngmt *cfm));
#endif /* SI */

#ifdef LCLSI /* loosely coupled management interface */

/* PRIMITIVE PACKING/UNPACKING FUNCTIONS */
EXTERN S16 cmPkLsiCfgReq      ARGS((Pst *pst, SiMngmt *cfg));
EXTERN S16 cmPkLsiCntrlReq    ARGS((Pst *pst, SiMngmt *cntrl));
EXTERN S16 cmPkLsiStaReq    ARGS((Pst *pst, SiMngmt *sta));
EXTERN S16 cmPkLsiStaCfm    ARGS((Pst *pst, SiMngmt *sta));
EXTERN S16 cmPkLsiStsReq    ARGS((Pst *pst, Action action, SiMngmt *sts));
EXTERN S16 cmPkLsiStsCfm    ARGS((Pst *pst, Action action, SiMngmt *sts));
EXTERN S16 cmPkLsiStaInd    ARGS((Pst *pst, SiMngmt *usta));
EXTERN S16 cmPkLsiTrcInd    ARGS((Pst *pst, SiMngmt *trc));
EXTERN S16 cmPkLsiAcntInd   ARGS((Pst *pst, SiMngmt *acnt));
EXTERN S16 cmPkLsiCfgCfm     ARGS((Pst *pst, SiMngmt *cfm));
EXTERN S16 cmPkLsiCntrlCfm   ARGS((Pst *pst, SiMngmt *cfm));

EXTERN S16 cmUnpkLsiCfgReq   ARGS((LsiCfgReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiCntrlReq ARGS((LsiCntrlReq func, 
                                     Pst         *pst, 
                                     Buffer      *mBuf));
EXTERN S16 cmUnpkLsiCfgCfm   ARGS((LsiCfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiCntrlCfm ARGS((LsiCntrlCfm func, 
                                     Pst         *pst, 
                                     Buffer      *mBuf));
EXTERN S16 cmUnpkLsiStaReq   ARGS((LsiStaReq func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiStaCfm   ARGS((LsiStaCfm func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiStsReq   ARGS((LsiStsReq func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiStsCfm   ARGS((LsiStsCfm func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiStaInd   ARGS((LsiStaInd func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiTrcInd   ARGS((LsiTrcInd func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsiAcntInd  ARGS((LsiAcntInd func, Pst *pst, Buffer *mBuf));

EXTERN S16 cmPkSiSts         ARGS((SiMngmt *sts,   Buffer *mBuf));
EXTERN S16 cmUnpkSiSts       ARGS((SiMngmt *sts,   Buffer *mBuf));
EXTERN S16 cmPkSiSsta        ARGS((SiMngmt *ssta,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSiSsta      ARGS((SiMngmt *ssta,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmPkSiUsta        ARGS((SiMngmt *usta,  Buffer *mBuf));
EXTERN S16 cmUnpkSiUsta      ARGS((SiMngmt *usta,  Buffer *mBuf));
EXTERN S16 cmPkSiTrc         ARGS((SiMngmt *trc,   Buffer *mBuf));
EXTERN S16 cmUnpkSiTrc       ARGS((SiMngmt *trc,   Buffer *mBuf));
#ifdef SI_ACNT
EXTERN S16 cmPkSiAcnt        ARGS((SiMngmt *acnt,  Buffer *mBuf));
EXTERN S16 cmUnpkSiAcnt      ARGS((SiMngmt *acnt,  Buffer *mBuf));
#endif /* SI_ACNT */
EXTERN S16 cmPkSiCntrl       ARGS((SiMngmt *cntrl, Buffer *mBuf));
EXTERN S16 cmUnpkSiCntrl     ARGS((SiMngmt *cntrl, Buffer *mBuf));
#endif /* LCLSI */

/* Moved declaration of siActvTsk , siActvInit here from si.x to here */
EXTERN S16 siActvTsk ARGS((Priority prior, Route route, Ent ent, 
                           Inst inst, Buffer *mBuf));
EXTERN S16 siActvInit ARGS((Ent entity, Inst inst, Region region, 
                            Reason reason));
 /*lsi_x_001.main_31-removed extern"C"-removing warnings*/
#endif /* __LSIX__ */
  
  
/********************************************************************30**
  
         End of file:     lsi.x@@/main/34 - Tue Jan  4 17:41:05 2011

*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**
 
  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  bn    1. initial release

1.2          ---  bn    1. added looback ack transmitted and received 
                           counter to sap statistics structure.

1.3          ---  bn    1. added new statistic counters.
             ---  bn    2. moved t4 from sap configuration to circuit
                           configuration structure.
             ---  bn    3. added tCCR, t27 and t34 timers to sap cfg
                           structure.

1.4          ---  bn    1. added statistic counters for Call Offering Messages
                           in SiNSAPSts.
             ---  bn    2. added circuit to usta and removed evntParm[8] from 
                           it.
             ---  bn    3. changed trc structure.

1.5          ---  bn    1. changed nmbCir in siGen configuration to U32.

1.6          ---  bn    1. added ssf field in siNSAPCfg.

1.7          ---  pc    1. added ETSI variant for SI

1.8          ---  dm    1. added GT_FTZ variant for SI
             ---  dm    2. added segmentation
             ---  dm    3. added TCCRt for ANSI

*********************************************************************81*/

/********************************************************************90**
 
    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
1.9          ---      ao   1. changed opc configuration from general to lower
                              SAP config.

1.10         ---      rh   1. changes for PAUSE/RESUME              

1.11         ---      rs   1. Added dpc configuration strcutures.
                           2. Moved t4/tPAUSE from cir to dpc cfg
                           3. Moved accounting info under SI_ACNT compile 
                              option.
                           4. Added T3 timer to circuit configuration.
                      ym   1. Added param union in cntrl request 
                              structure.
1.12         ---      ao   1. Added Russian variant
             ---      ym   1. cirFlg is added in the circuit configuration. 
                              It tells whether 32 ckts or 24 ckts are the
                              max ckt for ansi92 variant.
                              This is enabled under LSI_PARAMETER flags.
1.13         ---      bn   1. Added bellcore variant

1.14         ---      bn   1. added firsCic and numCir to circuit 
                              configuration structure.

1.15         ---      ym   1. Added NTT variant.

/main/17     ---      bsp  1. Removed unused variables, clli from
                              SiGenCfg and tmr from SiUstaDgnVal
             ---      hy   1. Removed field dfltOpc in SiNSAPCfg
                           2. Removed field bearProf in SiCirCfg
                           3. Added availTest,trunkType and checkTable 
                              in interface configuration, Added slotId, 
                              ctrlMult in circuit configuration; Added 
                              mapFormat, mapType, mapPres in control structure; 
                              Added numCirUsed in accounting indication;
                              Added numNonCont counter in circuit 
                              statistics structure.
                           4. Removed the field siUDat in SiMngmt.
                      bsp  1. Added counters for ETSI ver 3 messages. 
                      bsp  1. Added ANSI 95 flags
                      hy   1. Added ITU97 and ETSI v3 flags.
                           2. Change flag SI_218_MSAP_COMP to SI_218_COMP
             ---      bsp  1. Put numResInd in NSAP cfg structure under
                              SI_218_COMP flag. 
                           2. Put route related structures under SI_218_COMP
                           3. Enabled APM and PRI statistics in siPduSts 
                              for ITU97.
                           4. Added EXTERN functions, as required by
                              the CTF environment.
                           5. Added SI_218_COMP flag for fields in circuit
                              configuration flag 
                           6. Added back udat in SiMngmt under SI_218_COMP
           si001.220  hy   1. Added fileds related to rolling upgrade
                              in SiNSAPCfg, SiSAPCfg and siSstaCfm
                           2. Added the structure define for siSAPSta
                           3. Added the interface version number field in
                              SiUstaDgnVal.
           si006.220  hy   1. Modified the structure SiSAPSta to include
                              more information of sap.
                           2. Added one structure in SiElmntParam to support
                              force blocking.
                           3. Modified the function prototype of cmPkSiSsta
                              and cmUnpkSiSsta to pass the pst structure.
           si007.220  mm   1. Added new dpc field for SiUstaDgnVal.
                           2. Added flags LSIV2 and TDS_ROLL_UPGRADE_SUPPORT
                              for data tructure SiSAPSta.
           si009.220  mm   1. Added link selector option in SiGenCfg.
                           2. Added flag LSIV3 for data structure SiSAPSta.
           si025.220  tz   1. Added link selection option and selction bits
                              in interface config.
                           2. Added LSIV4 flag for any LSIV3.
           si029.220  tz   1. Modified statistics counter structure.
           si034220  rk    1. Added CHINA flag and switch where applicable.
   lsi_x_001.main_17 bn    1. corrected TDS_ROLL_UPGRADE_SUPPORT flag.
   lsi_x_002.main_17 vp    1. Modified comment for unxEvt
   lsi_x_003.main_17 vp    1. Added UK Variant
   lsi_x_004.main_17 vp    1. Removed #ifndef SS7_UK protection from all places
/main/21     ---       vp  1. Updating SID for clearcase migration  
/main/22     ---       vp  1. Updating latest file to clearcase
   lsi_x_001.main_22 rks   1. Added a control flag for TTB and CPC/FCI mapping
  (dependent si072.220)       in "SiGenCfg"
                           2. Added control flag LSIV5 for new interface version
*************************************************************************
        Revision history:

Version    Patch            Initials     Description
-------- -----------------  --------  ---------------------------------
2.21     lsi_x_001.main_25  rkumar    1. Initial release.
2.21     lsi_x_001.main_26  rkumar    1. Added Kazakhstan variant 
                                      2. Modified siUstaDgnVal to add timer type,
                                         state and switch type 
2.21     lsi_x_001.main_27  ckumar    1. Added t33IExp structure member to maintain
                                         counter for T33I timer expiry
2.21     lsi_x_001.main_28  ckumar    1. Modified SiSts structure by moving out
                                         Layerwide statistics from union.
2.21     lsi_x_001.main_29  ckumar    1. Added general configuration flag to support 
                                         Calling party number enum check feature.
2.21     lsi_x_001.main_30  kc        1. Added "suppressCfn" flag to support
                                         suppress CFN feature in general configuration. 
2.21     lsi_x_001.main_31  rkumar    1. Modified to fix "CC" compilation warns. 
2.21     lsi_x_001.main_32  kchaitanya  1. Modified for Ukraine variant 
2.21     lsi_x_001.main_33  rk        1. Flag used for calling party NOA feature for 
                                         Kazakhstan in structure SiGenCfg.
*********************************************************************91*/
