/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     layer management - portable
  
     Type:     C include file
  
     Desc:     Defines required by the layer management service user.
  
     File:     lsi.h
  
     Sid:      lsi.h@@/main/35 - Thu Jun  3 14:04:59 2010

     Prg:      bn
  
*********************************************************************21*/
  
#ifndef __LSIH__
#define __LSIH__

  
/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000029     SS7 - ISUP
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000029     SS7 - ISUP
*
*/
    
  
/* lsi_h_001.main_28 */

/* defines */

#ifdef LSIV1
#ifdef LSIIFVER
#undef LSIIFVER
#endif
#define LSIIFVER 0x0100
#endif /* LSIV1 */

#ifdef LSIV2
#ifdef LSIIFVER
#undef LSIIFVER
#endif
#define LSIIFVER 0x0200
#endif /* LSIV2 */

#ifdef LSIV3
#ifdef LSIIFVER
#undef LSIIFVER
#endif
#define LSIIFVER 0x0300
#endif /* LSIV3 */

#ifdef LSIV4
#ifdef LSIIFVER
#undef LSIIFVER
#endif
#define LSIIFVER 0x0400
#endif /* LSIV4 */

#ifdef LSIV5
#ifdef LSIIFVER
#undef LSIIFVER
#endif
#define LSIIFVER 0x0500
#endif /* LSIV5 */

/* if LSIV1 or LSIV2 or LSIV3 is not enabled, define LSIIFVER as base version */
#ifndef LSIIFVER
#define LSIIFVER 0x0100
#endif

/* switches */

#define LSI_SW_TST           0           /* switch - test */
#define LSI_SW_ITU           1           /* switch - itu */
#define LSI_SW_ANS88         2           /* switch - ansi 88 */
#define LSI_SW_ANS92         3           /* switch - ansi 92*/
#define LSI_SW_SINGTEL       4           /* switch - singapore telecom */
#define LSI_SW_Q767          5           /* switch - int'l isup q.767 */
#define LSI_SW_ETSI          6           /* switch - ETSI */
#define LSI_SW_FTZ           7           /* switch - FTZ */
#define LSI_SW_RUSSIA        8           /* switch - Russia */
#define LSI_SW_BELL          9           /* switch - Bellcore */
#define LSI_SW_NTT           10          /* switch - NTT */
#define LSI_SW_ANS95         11          /* switch - ANS95 */
#define LSI_SW_ITU97         12          /* switch - ITU97 */
#define LSI_SW_ETSIV3        13          /* switch - ETSIV3 */
#define LSI_SW_INDIA         14          /* switch - India */
#define LSI_SW_CHINA         15          /* switch - China */
#define LSI_SW_ITU2000       16          /* switch - ITU2000 */
#define LSI_SW_RUSS2000      17          /* switch - Russia 2000 */
/* Added UK Switch LSI_SW_UK */
#define LSI_SW_UK 			18        /* switch - UK */

#define LSI_SW_NZL           19
#define LSI_SW_KZ            20          /* lsi_h_001.main_29 : switch - Kazakhstan */

#define LSI_SW_BRZL          21          /* lsi_h_001.main_33 : switch - Brazil */
/*lsi_h_001.main_34 Added Ukraine switch flag*/
#define LSI_SW_UR       22          /* lsi_h_001.main_34 : switch - Ukraine */

/* Network Sap types */

#define SAP_MTP           0          /* MTP Sap */
#define SAP_SCCP          1          /* SCCP Sap */
#define SAP_RM            2          /* RM Sap if PSIF enabled */
#define SAP_M3UA          3          /* M3UA Sap */

/* subsystem field */

#define SSF_INTER        0           /* international subsystem field */
#define SSF_NAT          2           /* national subsystem field */

/* Debugger flags */
#define SIDBGMASK_PROG  (DBGMASK_LYR << 0 ) /* progress of handling an Event */
#define SIDBGMASK_WARN  (DBGMASK_LYR << 1 ) /* warning , not critical for an event */
#define SIDBGMASK_CERR  (DBGMASK_LYR << 2 ) /* Event specific err*/
#define SIDBGMASK_ERR   (DBGMASK_LYR << 3 ) /* Global error */
#define SIDBGMASK_TMR   (DBGMASK_LYR << 4 ) /* Timer related */
#define SIDBGMASK_STATE (DBGMASK_LYR << 5 ) /* state transition */
#define SIDBGMASK_MF    (DBGMASK_LYR << 6 ) /* mf related prog/warn/error */

/* Type of alarm diagnostic values */

#define LSI_USTA_DGNVAL_NONE        0   /* event identifier */
#define LSI_USTA_DGNVAL_EVENT       1   /* event identifier */
#define LSI_USTA_DGNVAL_SPID        2   /* spId of a SAP */
#define LSI_USTA_DGNVAL_SUID        3   /* suId of a SAP */
#define LSI_USTA_DGNVAL_SPINSTID    4   /* suInstId of a connection */
#define LSI_USTA_DGNVAL_SUINSTID    5   /* spInstId of a connection */
#define LSI_USTA_DGNVAL_CIRCUIT     6   /* circuit id */
#define LSI_USTA_DGNVAL_CIC         7   /* CIC value of a circuit */
#define LSI_USTA_DGNVAL_INTF        8   /* Interface */
#define LSI_USTA_DGNVAL_DPC         9   /* DPC */
#define LSI_USTA_DGNVAL_ADDRS       10  /* address structure - (e.g: called 
                                           party number/ CLLI */
#define LSI_USTA_DGNVAL_SWTCH       11  /* protocol variant */
#define LSI_USTA_DGNVAL_RANGE       12  /* range value in a circuit group
                                         * event/message */
#define LSI_USTA_DGNVAL_STATUS_OCTS 13  /* status octets in a circuit group
                                         * event/message */
#define LSI_USTA_DGNVAL_VER         14  /* interface version number */

/* lsi_h_001.main_29 : Included diagnostic info for timer type, message type
   and connection state */
#define LSI_USTA_DGNVAL_TIMER       15  /* Timer type */
#define LSI_USTA_DGNVAL_MSGTYPE     16  /* Message type */
#define LSI_USTA_DGNVAL_STATE       17  /* Connection type */

#define LSI_USTA_MAX_DGNVAL  4 /* max. number of diagnostics values 
                                * in an ISUP unsolicited status indication */

/* PDU statistics type */
#define LSI_STS_RX           0x00      /* receive statistics */
#define LSI_STS_TX           0x01      /* transmit statistics */

/* circuit statistics counters type */
#define LSI_STS_T5EXP        0x02      /* T5 expiry counter                  */
#define LSI_STS_T13EXP       0x03      /* T13 expiry counter                 */
#define LSI_STS_T15EXP       0x04      /* T15 expiry counter                 */
#define LSI_STS_T17EXP       0x05      /* T17 expiry counter                 */
#define LSI_STS_T19EXP       0x06      /* T19 expiry counter                 */
#define LSI_STS_T21EXP       0x07      /* T21 expiry counter                 */
#define LSI_STS_T23EXP       0x08      /* T32 expiry counter                 */
#define LSI_STS_ABNRMLREL    0x09      /* Abnormal release counter           */
#define LSI_STS_BLOREQ       0x0A      /* Block request counter              */
#define LSI_STS_NOCGBA       0x0B      /* Missing status bits in CGBA counter*/
#define LSI_STS_NOCGUA       0x0C      /* Missing status bits in CGUA counter*/
#define LSI_STS_ABNRMLCGBA   0x0D      /* Addl. status bits in CGUA counter  */
#define LSI_STS_ABNRMLCGUA   0x0E      /* Addl. status bits in CGUA counter  */
#define LSI_STS_UNXCGBA      0x0F      /* Unexpected CGBA counter            */
#define LSI_STS_UNXCGUA      0x10      /* Unexpected CGUA counter            */
#define LSI_STS_UNXBLA       0x11      /* Unexpected BLA counter             */
#define LSI_STS_UNXUBA       0x12      /* Unexpected UBA counter             */
#define LSI_STS_PDUFMTERR    0x13      /* Message format error counter       */
#define LSI_STS_RELUNRECINFO 0x14      /* Rel. due to unrecognised info cntr */
#define LSI_STS_RELFAIL      0x15      /* Inability to release counter       */

/* Added New define */
#define LSI_STS_UNXEVT       0x16      /* Unexpected Event from upper layer  */
/* lsi_h_001.main_31 : added new define LSI_STS_T33IEXP to  maintain counter
   for T33I timer expiry */
#define LSI_STS_T33IEXP      0x17      /* T33I expiry counter                 */
/* Defines for cirFlg in circuit configuration */
#define LSI_CIRFLG_ANSI_INT  0x01      /* If SET then indicates whether ckt  */
                                       /* supports ANSI national or ANSI     */
                                       /* International.                     */
#define LSI_CIRFLG_CFN_ON    0x02      /* If SET then indicates that send    */
                                       /* confusion message option is        */
                                       /* turned on                          */

#define LSI_CFCI_UNKNOWN         0x00  /* unknown */
#define LSI_CFCI_ANALOG          0x04  /* analog */
#define LSI_CFCI_DIGITAL         0x08  /* digital */
#define LSI_CFCI_ANALDIG         0x0c  /* digital and analog */

#define LSI_CFAC_UNKNOWN         0x00  /* unknown */
#define LSI_CFAC_SOFTCARHAND     0x10  /* software carrier handling */
#define LSI_CFAC_HARDCARHAND     0x20  /* hardware carrier handling */

#define LSI_CFCO_UNKNOWN         0x00  /* unknown */
#define LSI_CFCO_NONE            0x40  /* none */
#define LSI_CFCO_STATIS          0x80  /* statistical */
#define LSI_CFCO_PERCALL         0xc0  /* per call */

/* Slot id defines      */
#define LSI_CIR_SLOTID_MASK      0x1f  /* Slot id bit 0 to bit 4 mask       */
/* Bit 5 */
#define LSI_CIR_SKIP_CONTIGOUS   0x20  /* not used for contig mrate calls  */
/* Bit 6 */
#define LSI_CIR_NON_CONTIGOUS    0x40  /* Supports non-contig mrate calls  */


/* ctrlMult field : Multirate controller field */
#define LSI_CIR_MRATE_CTRL       0x01  /* This node is controlling in case of 
                                        * of dual seizure for multirate calls
                                        */
/* trunk type defines */
#define LSI_TRUNKTYP_E1          TRUE   /* E1 trunk type supported */
#define LSI_TRUNKTYP_T1          FALSE  /* T1 trunk type supported */

/*      transfer mode    */

#define CIRCUIT          0           /* circuit */
#define PACKET           2           /* packet  */
#define CIRPKT           3           /* circuit and packet */

/*      transfer capability    */

#define SPEECH           1           /* speech */
#define UNDIGIT          2           /* unrestricted digital */
#define RESDIGIT         4           /* restricted digital */
#define AUDIO3           8           /* 3.1 audio */
#define AUDIO7           16          /* 7 audio */
#define VIDEO            32          /* video */
#define ANADIG           33          /* both voice and data */

/* coding standards */

#define CSTD_CCITT     0x00  /* CCITT standards */
#define CSTD_INT       0x01  /* Other International Standards */
#define CSTD_NAT       0x02  /* National Standard */
#define CSTD_NET       0x03  /* Network Standard */

/* information transfer capability */

#define ITC_SPEECH     0x00  /* speech */
#define ITC_UNRDIG     0x08  /* unrestricted digital information */
#define ITC_RESDIG     0x09  /* restricted digital information */
#define ITC_A31KHZ     0x10  /* 3.1kHz audio */
#define ITC_A7KHZ      0x11  /* 7 kHz audio */
#define ITC_A15KHZ     0x12  /* 15 kHz audio */
#define ITC_VIDEO      0x18  /* video */

/* information transfer mode */

#define TM_CIRCUIT     0x00  /* circuit mode */
#define TM_PACKET      0x02  /* packet mode */

/* information transfer rate */

#define ITR_PKT        0x00  /* packet mode */
#define ITR_64KBIT     0x10  /* circuit mode - 64 kbits */
#define ITR_2X64KBIT   0x11  /* circuit mode - 2 X 64 kbits */
#define ITR_384KBIT    0x13  /* circuit mode - 384 kbits */
#define ITR_1472KBIT   0x14  /* circuit mode - 1472 kbits */
#define ITR_1536KBIT   0x15  /* circuit mode - 1536 kbits */
#define ITR_1920KBIT   0x17  /* circuit mode - 1920 kbits */
#define ITR_MULIRATE   0x18  /* circuit mode - multi rate */

/* establishement */

#define E_DEMAND       0x00  /* demand */
#define E_PERM         0x01  /* permanent */

/* configuration */

#define POINT          0x00  /* point to point */
#define MULTIPOINT     0x01  /* multipoint */

/* structure */

#define S_DEF          0x00  /* default */
#define S_8KHZINTEG    0x01  /* 8 khz integrity */
#define S_SDUINTEG     0x04  /* service data unit integrity */
#define S_UNSTRUCT     0x07  /* unstructured */

/* symmetry */

#define S_BISYM        0x00  /* bidirectional symmetry */

/* negotiation */

#define N_IBNOTPOSS    0x00  /* inband not possible */
#define N_IBPOSS       0x01  /* inband possible */

/* negotiation indicator */

#define N_OBNOTPOSS    0x00  /* outband not possible */
#define N_OBPOSS       0x01  /* outband possible */

/* synchronous/asynchronous */

#define SA_SYNC        0x00  /* synchronous */
#define SA_ASYNC       0x01  /* asynchronous */

/* intermediate rate */

#define IR_NONE        0x00  /* none specified */
#define IR_8KBIT       0x01  /* 8 kbits */
#define IR_16KBIT      0x02  /* 16 kbits */
#define IR_32KBIT      0x03  /* 32 kbits */

/* assignor/assignee */

#define AA_ORGASGNEE   0x00  /* originator is assignee */
#define AA_ORGASGNOR   0x01  /* originator is assignor */

/* number of stop bits */

#define NSB_UNUSED     0x00  /* none specified */
#define NSB_1          0x01  /* 1 stop bit */
#define NSB_15         0x02  /* 1.5 stop bits */
#define NSB_2          0x03  /* 2 stop bits */

/* number of data bits */

#define NDB_UNUSED     0x00  /* none specified */
#define NDB_5          0x01  /* 5 bits */
#define NDB_7          0x02  /* 7 bits */
#define NDB_8          0x03  /* 8 bits */

/* parity information */

#define PARI_ODD       0x00  /* odd */
#define PARI_EVEN      0x02  /* even */
#define PARI_NONE      0x03  /* none */
#define PARI_0         0x04  /* force to 0 */
#define PARI_1         0x05  /* force to 1 */

/* duplex mode */

#define DUPMODE_HALF   0x00  /* half duplex */
#define DUPMODE_FULL   0x01  /* full duplex */

/* modem type */

#define MODEM_V21      0x01  /* V.21 */
#define MODEM_V22      0x02  /* V.21 */
#define MODEM_V22BIS   0x03  /* V.21 */
#define MODEM_V23      0x04  /* V.21 */
#define MODEM_V26      0x05  /* V.21 */
#define MODEM_V26BIS   0x06  /* V.21 */
#define MODEM_V26TER   0x07  /* V.21 */
#define MODEM_V27      0x08  /* V.21 */
#define MODEM_V27BIS   0x09  /* V.21 */
#define MODEM_V27TER   0x0a  /* V.21 */
#define MODEM_V29      0x0b  /* V.21 */
#define MODEM_V32      0x0c  /* V.21 */
#define MODEM_V35      0x0d  /* V.21 */

/* user information layer 1 */

#define UIL1_CCITTV110 0x01  /* CCITT Standardized Rate Adaptation V.110/X.30. */
#define UIL1_G711ULAW  0x02  /* Reccomendation G.711 u-Law */
#define UIL1_G711ALAW  0x03  /* Recommendation G.711 A-Law */
#define UIL1_G721ADCPM 0x04  /* Recommendation G.721 32 kbit/s ADCPM and */
                             /* Recommendation I.460 */
#define UIL1_G722G725  0x05  /* Recommendation G.722 and G.725 - 7kHz Audio */
#define UIL1_H261      0x06  /* Recommendation H.261 - 384 kbit/s Video */
#define UIL1_NONCCITT  0x07  /* Non-CCITT  standardized Rate adaptation */
#define UIL1_CCITTV120 0x08  /* CCITT Standardized Rate Adaptation V.120 */
#define UIL1_CCITTX31  0x09  /* CCITT Standardized Rate Adaptation X.31 HDLC */

/* user information layer 2 protocol */

#define UIL2_BASIC     0x01  /* basic mode - ISO 1745 */
#define UIL2_Q921      0x02  /* CCITT Recommendation Q.921 */
#define UIL2_X25SLP    0x06  /* CCITT Recommendation X.25, single link */
#define UIL2_X25MLP    0x07  /* CCITT Recommendation X.25, multi link */
#define UIL2_T71       0x08  /* extended LAPB for half duplex, */
                             /* CCITT Recommendation T.71 */
#define UIL2_HDLCARM   0x09  /* HDLC ARM - ISO 4335 */
#define UIL2_HDLCNRM   0x0a  /* HDLC NRM - ISO 4335 */
#define UIL2_HDLCABM   0x0b  /* HDLC ABM - ISO 4335 */
#define UIL2_LANLLC    0x0c  /* LAN LLC - ISO 8802/2 */
#define UIL2_X75SLP    0x0d  /* CCITT Recommendation X.75, single link */
#define UIL2_Q922      0x0e  /* CCITT Recommendation Q.922 */
#define UIL2_USRSPEC   0x10  /* CCITT User specified */
#define UIL2_T90       0x11  /* CCITT T.90 */

/* user information layer 3 protocol */

#define UIL3_Q931      0x02  /* CCITT Recommendation Q.931 */
#define UIL3_T90       0x05  /* CCITT T.90 */
#define UIL3_X25PLP    0x06  /* CCITT Recommendation X.25, packet layer */
#define UIL3_ISO8208   0x07  /* ISO 8208 */
#define UIL3_ISO8348   0x08  /* ISO 8348 */
#define UIL3_ISO8473   0x09  /* ISO 8473 */
#define UIL3_T70       0x0a  /* CCITT Recommendation T.70 */
#define UIL3_USRSPEC   0x10  /* CCITT User specified */

/*lsi_h_001.main_33: Added the marcos */
#define UIL3_NW        0x0b  /* Network Layer ISO/IEC TR 9577 */
#define UIL3_IP        0x0c  /* Internet Protocol ISO/IEC TR 9577 */
#define UIL3_PPP       0x0f  /* Point to Point protocol RFC 1548 */

/* type of number */

#define TON_UNK        0x00  /* unknown */
#define TON_INT        0x01  /* international number */
#define TON_NAT        0x02  /* national number */
#define TON_NETSPEC    0x03  /* network specific number */
#define TON_SUB        0x04  /* subscriber number */
#define TON_OLSND      0x05  /* overlap sending */
#define TON_ABB        0x06  /* abbreviated number */
#define TON_EXT        0x07  /* reserved for extension */

/* numbering plan */

#define NP_UNK         0x00  /* unknown */
#define NP_ISDN        0x01  /* ISDN/telephony numbering - E.164/E.163 */
#define NP_TEL         0x02  /* telephony numbering - E.163 */
#define NP_DATA        0x03  /* data numbering - X.121 */
#define NP_TELEX       0x04  /* telex numbering - Recommendation F.69 */
#define NP_NATIONAL    0x08  /* national standard numbering */
#define NP_PRIVATE     0x09  /* private numbering */
#define NP_EXT         0x0f  /* reserved for extension */

/* type of subaddress */

#define TOSAD_NSAP     0x00  /* nsap - X.213/ISO 8348 */
#define TOSAD_USER     0x02  /* user specified */

/* odd/even indicator */

#define OE_EVEN        0x00  /* even number of address signals */
#define OE_ODD         0x01  /* odd number of address signals */

/* interpretation */

#define INT_NAT         0x0  /* national */
#define INT_FIRST      0x04  /* first high layer characteristics */

/* presentation method of protocol profile */

#define PM_VAL1        0x01  /* value 1 */

/* high layer characteristics */

#define HLCI_TEL       0x01  /* Telephony - Recommendation G.711 */
#define HLCI_FAXG4     0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define HLCI_DAPFAXG4  0x21  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.503 */
#define HLCI_DAPMIXED  0x24  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.501 */
#define HLCI_DAPPROC   0x28  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.502 */
#define HLCI_TELETEX   0x31  /* Teletex - Recommendation T.62/T.70 */
#define HLCI_DAPVIDEO  0x32  /* Doc App Profile for Facsimile Group 4 */
                             /* Recommendation T.503 */
#define HLCI_TELEX     0x35  /* Telex */
#define HLCI_MHS       0x38  /* Message Handling System */
                             /* Recommendation X.400 */
#define HLCI_AUDSCR    0x40  /* VN-3 National Audiosritp */
#define HLCI_OSIAPP    0x41  /* OSI Application - Recommendation X.200 */
#define HLCI_AUDVID    0x48  /* VN-3 National Audiovideotex */
#define HLCI_MAINT     0x5e  /* Maintenance */
#define HLCI_MNGMT     0x5f  /* Management */
#define HLCI_VIDTEL    0x60  /* Videotelephony F.xyz and AV.242 */
#define HLCI_RESERVE   0xff  /* Reserved */

/* mode of operation */

#define MOO_BITTRANS   0x00  /* bit transparent */
#define MOO_PROTSEN    0x01  /* protocol sensitive */

/* multiple frame establishment */

#define MFE_NOTSUP     0x00  /* not supported */
#define MFE_SUP        0x01  /* supported */

/* logical link identifier */

#define LLI_DEF        0x00  /* default */
#define LLI_FULLNEG    0x01  /* full protocol negotiation */

/* inband/outband negotiation */

#define ION_USRINFO    0x00  /* negotiation with user info messages */
#define ION_LL0        0x01  /* negotiation in band using logical link 0 */

/* isup */

#define MAX_GRP_CIR     32           /* maximum number of circuits in tup */
 
#define CIR_ORD         0            /* ordinary circuit */
#define CIR_DIG_NOFLT   1            /* digital circuit without inherent fault
                                        indication*/
#define CIR_DIG         2            /* fully digital circuit */
 
#define CIR_NOSAT       0            /* not a satellite circuit */
#define CIR_SAT         1            /* satellite circuit */

#define MAX_SIZ_STATUS  32           /* no of bytes in circuit status for
                                        circuit group requests from LM */  
/* Nature of Address Defines ISUP */

#define ADDR_NOTPRSNT     0x00
#define SUBSNUM           0x01
#define NOTFIXED          0x02
#define NATNUM            0x03
#define INTNATNUM         0x04
#define SPCLNWNUMBER      0xFE      /* Special n/w number */
#define INSRVCNUM         0xFE      /* Special n/w number */

/* Nature of Address Defines TUP */

#define SUBNUM            0x00
#define NTLNUM            0x02
#define INTLNUM           0x03

/* Nature of Circuit Indicator */

#define SAT_NONE          0x00
#define SAT_ONE           0x01
#define SAT_TWO           0x02
#define SAT_THREE         0x03

/* defines for circuit control request flags */
#define LSI_CNTRL_CIR_REMOTE 0  /* modify the remote state of the circuit   */
#define LSI_CNTRL_CIR_LOCAL  1  /* modify the local state of the circuit    */
#define LSI_CNTRL_CIR_FORCE  2  /* force the control request on the circuit */

/* defines for management supervision type indicators 
 * (These should be the same as the defines in sit.h) */
#define LSI_CNTRL_CGSMTI_MNT 0x00 /* maintenance oriented request */
#define LSI_CNTRL_CGSMTI_HW  0x01 /* hardware oriented request    */

/* defines for blocking/unblocking event groups */
#define LOCMTEVT          0x00   /* local maintenance events  */
#define LOCHWEVT          0x01   /* local hardware events     */
#define REMMTEVT          0x02   /* remote maintenance events */
#define REMHWEVT          0x03   /* remote hardware events    */

#define NUMCIREVTGRP      4      /* number of event groups    */

#define SICIR_MTLOCST     LOCMTEVT /* local circuit states for mntc events */
#define SICIR_HWLOCST     LOCHWEVT /* local circuit states for h/w events */
#define SICIR_MTREMST     REMMTEVT /* remote circuit states for mntc events */
#define SICIR_HWREMST     REMHWEVT /* remote circuit states for h/w events */

/* circuit states */
#define SICIR_ST_UNEQPD   0x00     /* unequipped */
#define SICIR_ST_IDLE     0x01     /* idle */
#define SICIR_ST_WTBLKACK 0x02     /* waiting for BLA */
#define SICIR_ST_LOCBLKED 0x03     /* locally blocked */
#define SICIR_ST_WTUBLACK 0x04     /* waiting for UBA */
#define SICIR_ST_WTRESACK 0x05     /* waiting for RLC (as a response to RSC) */
#define SICIR_ST_WTBLKRSP 0x06     /* waiting for blocking response */
#define SICIR_ST_REMBLKED 0x07     /* remotely blocked */
#define SICIR_ST_WTUBLRSP 0x08     /* waiting for unblocking response */
#define SICIR_ST_WTRESRSP 0x09     /* waiting for reset response */
#define SICIR_ST_INVALID  0xFF     /* invalid state of ckt */

#define NMB_SICIR_ST      10       /* number of circuit states */

/* maintenance blocking states */

#define MNOBLK            0      /* not blocked */
#define MLOCBLKED         1      /* locally blocked */
#define MRMTBLKED         2      /* remotely blocked */
#define MLOCRMTBLKED      3      /* locally and remotely blocked */

/* hardware blocking states */

#define HNOBLK            0x00   /* not blocked */
#define HLOCBLKED         0x10   /* locally blocked */
#define HRMTBLKED         0x20   /* remotely blocked */
#define HLOCRMTBLKED      0x30   /* locally and remotely blocked */

/* call processing states */

#define CALL_IDLE         0x0c   /* idle */
#define INCBUSY           0x04   /* incoming busy */
#define OUTBUSY           0x08   /* outgoing busy */
#define TRANS             0x00   /* transient */
#define COTCHK            0x01   /* continuity check  */

/* Mngmt.t.wpInfo.info */
 
#define ST_NOERR         0           /* data request received, no error */
#define ST_INVTTYPE      1           /* invalid table type */
#define ST_CHKSUMERR     2           /* checksum is wrong */
#define ST_VERERR        3           /* software version error */
#define ST_LCBERR        4           /* link control block error */
#define ST_LSERR         5           /* linkset control block error */
#define ST_RCBERR        6           /* route control block error */
#define ST_RIERR         7           /* route instance control block error */
#define ST_NSAPERR       8           /* NSAP control block error */
#define ST_TQERR         9           /* timing queue error */
#define ST_SLTQERR       10          /* signalling link transmit queue error */
#define ST_SLRQERR       11          /* signalling link retrieval queue error */
#define ST_NSRQERR       12          /* NSAP receive queue error */
#define ST_ACKTMR        13          /* acknowledgement timer timed out */
#define ST_WRGLGI        14          /* request on wrong lgi card */
#define ST_COMPLETE      15          /* warm start procedure completed */

#define LSI_MAXBCHNL     31          /* maximum number of B channels */
#define MAXPREFDIG       4           /* maximum number of prefix digit */
#define ANYCHAN          255         /* any B channel */
#define DCHAN            2           /* D channel */
#define BCHAN            3           /* specific B channel */
#define BASICRATE        2           /* basic rate */


/* presentation indicator */

#define PI_ALLOW       0x00  /* presentation allowed */
#define PI_RESTRICT    0x01  /* presentation restricted */
#define PI_NOTAVAIL    0x02  /* number not available due to internetworking */

/* screening indicator */

#define SI_USRNOTSCRN  0x00  /* user provided - not screened */
#define SI_USRVERSCRN  0x01  /* user provided - verified and passed */
#define SI_USRVERFAIL  0x02  /* user provided - verified and failed */
#define SI_NET         0x03  /* network provided */

/* reason for redirection */

#define RR_UNKNOWN     0x00  /* reason unknown */
#define RR_BUSY        0x01  /* call forwarding busy or called dte busy */
#define RR_NOREPLY     0x02  /* call forwarding no reply */
#define RR_CXFR        0x04  /* call transfer dms 250 */
#define RR_CPCKUP      0x05  /* call pickup dms 250 */
#define RR_OUTORD      0x09  /* called dte out of order */
#define RR_CDDTE       0x0a  /* call forwarding by the called dte */
#define RR_CTRSF       0x0d  /* call transfer */
#define RR_PCKUP       0x0e  /* call pickup */
#define RR_SYSTM       0x0f  /* call fowarding unconditional or systematic */


/* defines for MLxCfgReq or MBDCfgReq */

/* Encoding Schemes */

#define ES_UNKN          0x00      /* Unknown */
#define ES_BCDODD        0x01      /* BCD Odd */
#define ES_BCDEVEN       0x02      /* BCD Even */

#define NAT_IND          0x01      /* National Indication */
#define INAT_IND         0x00      /* International Indication */

/* Defines used for SS7/ISUP Layer Management */

#define MAXCIRGR         256       /* Max circuit groups */
#define MAXNUMCIR        256       /* Max number of circuits */
#define MAXNUMDPC        10        /* Max number of circuits */

/* Transmission Mediuum Requirements */

#define TMR_SPEECH      0x00
#define TMR_64KBITS     0x02
#define TMR_31KHZ       0x03
#define TMR_ALTSPEECH   0x04
#define TMR_ALT64KBITS  0x05
#define TMR_64KBITSPREF 0x06
#define TMR_2X64KBITS   0x07
#define TMR_384KBITS    0x08
#define TMR_1536KBITS   0x09
#define TMR_1920KBITS   0x0a

#define TMR_3X64KBITS   0x10
#define TMR_4X64KBITS   0x11
#define TMR_5X64KBITS   0x12
#define TMR_7X64KBITS   0x14
#define TMR_8X64KBITS   0x15
#define TMR_9X64KBITS   0x16
#define TMR_10X64KBITS  0x17
#define TMR_11X64KBITS  0x18
#define TMR_12X64KBITS  0x19
#define TMR_13X64KBITS  0x1a
#define TMR_14X64KBITS  0x1b
#define TMR_15X64KBITS  0x1c
#define TMR_16X64KBITS  0x1d
#define TMR_17X64KBITS  0x1e
#define TMR_18X64KBITS  0x1f
#define TMR_19X64KBITS  0x20
#define TMR_20X64KBITS  0x21
#define TMR_21X64KBITS  0x22
#define TMR_22X64KBITS  0x23
#define TMR_23X64KBITS  0x24
#define TMR_25X64KBITS   0x26
#define TMR_26X64KBITS   0x27
#define TMR_27X64KBITS   0x28
#define TMR_28X64KBITS   0x29
#define TMR_29X64KBITS   0x2a

/* define for GT_FTZ */

#define TMR_64KBITSUP   0x06  /* 64kbit/s unrestricted preferred */

#define INCOMING        0     /* incoming */
#define OUTGOING        1     /* outgoing */
#define BOTHWAY         2     /* bothway circuit - controlling side and
                               * controlled side is decided based on the
                               * point code and odd/even circuit */
#define CONTROLLED      3     /* bothway circuit - acts as a controlled
                               * side in case of dual seizure */
#define CONTROLLING     4     /* bothway circuit - acts as a controlling
                               * side in case of dual seizure */


#define CIRIDTRNKNUMLEN 4     /* Trunk group length in trunkNumClli */

/* Sn Management Events */

#define EVTLSICFGREQ     0x3c             /* Configuration request */
#define EVTLSISTAREQ     0x40             /* Status request */
#define EVTLSISTACFM     0x41             /* Status confirm */
#define EVTLSISTAIND     0x42             /* Status indication */
#define EVTLSISTSREQ     0x44             /* Statistics request */
#define EVTLSISTSCFM     0x45             /* Statistics confirm */
#define EVTLSITRCIND     0x48             /* Trace indication */
#define EVTLSICNTRLREQ   0x4c             /* Control request */
#define EVTLSIACNTIND    0x56             /* Accounting indication */
#if (SI_LMINT3 || SMSI_LMINT3)
#define EVTLSICFGCFM     0xd0             /* Config confirm  */
#define EVTLSICNTRLCFM   0xd1             /* Control confirm */
#endif


/* ISUP unsolicited status indications */

/* ISUP specific categories */
#define LSI_CATEGORY_ROUTER   (LCM_CATEGORY_LYR_SPECIFIC + 1)

/* ISUP specific events */
#define LSI_EVENT_NO_ROUTE       (LCM_EVENT_LYR_SPECIFIC + 1)
#define LSI_EVENT_UI_INV_VARIANT (LCM_EVENT_LYR_SPECIFIC + 2)
#define LSI_EVENT_USERPART       (LCM_EVENT_LYR_SPECIFIC + 3)
#define LSI_EVENT_REMOTE         (LCM_EVENT_LYR_SPECIFIC + 4)
#define LSI_EVENT_LOCAL          (LCM_EVENT_LYR_SPECIFIC + 5)
#define LSI_EVENT_INV_RANGE      (LCM_EVENT_LYR_SPECIFIC + 6)
#define LSI_EVENT_INV_ACK        (LCM_EVENT_LYR_SPECIFIC + 7)
#define LSI_EVENT_CIC_VAL        (LCM_EVENT_LYR_SPECIFIC + 8)
#define LSI_EVENT_UI_FTZREQ      (LCM_EVENT_LYR_SPECIFIC + 9)

#define LSI_EVENT_MTP            (LCM_EVENT_LYR_SPECIFIC + 10)

/* ISUP specific causes values */
#define LSI_CAUSE_BLOCK              (LCM_CAUSE_LYR_SPECIFIC + 1)
#define LSI_CAUSE_CGUREQ             (LCM_CAUSE_LYR_SPECIFIC + 2)
#define LSI_CAUSE_CIR_MNTACK         (LCM_CAUSE_LYR_SPECIFIC + 3)
#define LSI_CAUSE_CIR_MNTREQ         (LCM_CAUSE_LYR_SPECIFIC + 4)
#define LSI_CAUSE_CONG_LVL1          (LCM_CAUSE_LYR_SPECIFIC + 5)
#define LSI_CAUSE_CONG_LVL2          (LCM_CAUSE_LYR_SPECIFIC + 6)
#define LSI_CAUSE_INV_ADDRS          (LCM_CAUSE_LYR_SPECIFIC + 7)
#define LSI_CAUSE_INV_CGU            (LCM_CAUSE_LYR_SPECIFIC + 8)
#define LSI_CAUSE_INV_CQM            (LCM_CAUSE_LYR_SPECIFIC + 9)
#define LSI_CAUSE_T12_INACTIVE       (LCM_CAUSE_LYR_SPECIFIC + 10)
#define LSI_CAUSE_T14_INACTIVE       (LCM_CAUSE_LYR_SPECIFIC + 11)
#define LSI_CAUSE_T16_INACTIVE       (LCM_CAUSE_LYR_SPECIFIC + 12)
#define LSI_CAUSE_UNEQP_CIR          (LCM_CAUSE_LYR_SPECIFIC + 13)
#define LSI_CAUSE_INV_CDPTY          (LCM_CAUSE_LYR_SPECIFIC + 14)
#define LSI_CAUSE_INV_TNS            (LCM_CAUSE_LYR_SPECIFIC + 15)
#define LSI_CAUSE_SUINSTID_MISMATCH  (LCM_CAUSE_LYR_SPECIFIC + 16)
#define LSI_CAUSE_UNBLOCK            (LCM_CAUSE_LYR_SPECIFIC + 17)
#define LSI_CAUSE_NO_CIRCUIT         (LCM_CAUSE_LYR_SPECIFIC + 18)
#define LSI_CAUSE_INV_CIRCUIT        (LCM_CAUSE_LYR_SPECIFIC + 19)

#define LSI_CAUSE_INV_NW_RESOURCE    (LCM_CAUSE_LYR_SPECIFIC + 21)
#define LSI_CAUSE_CIC_BUSY           (LCM_CAUSE_LYR_SPECIFIC + 22)
#define LSI_CAUSE_RMT_BLKED          (LCM_CAUSE_LYR_SPECIFIC + 23)
#define LSI_CAUSE_CAL_REF            (LCM_CAUSE_LYR_SPECIFIC + 24)
#define LSI_CAUSE_NO_MEMORY          (LCM_CAUSE_LYR_SPECIFIC + 25)
#define LSI_CAUSE_INV_MSAP           (LCM_CAUSE_LYR_SPECIFIC + 26)
#define LSI_CAUSE_CIC_IDLE           (LCM_CAUSE_LYR_SPECIFIC + 28)
#define LSI_CAUSE_INV_SUINSTID       (LCM_CAUSE_LYR_SPECIFIC + 29)
#define LSI_CAUSE_UNKNOWN_SUINSTID   (LCM_CAUSE_LYR_SPECIFIC + 30)
#define LSI_CAUSE_INV_EVNT           (LCM_CAUSE_LYR_SPECIFIC + 32)
#define LSI_CAUSE_AVAILABLE          (LCM_CAUSE_LYR_SPECIFIC + 33)
#define LSI_CAUSE_UNAVAILABLE        (LCM_CAUSE_LYR_SPECIFIC + 34)
#define LSI_CAUSE_UNEQUIPPED         (LCM_CAUSE_LYR_SPECIFIC + 35)
#define LSI_CAUSE_INV_SSAP           (LCM_CAUSE_LYR_SPECIFIC + 36)
#define LSI_CAUSE_INVCGBREQ          (LCM_CAUSE_LYR_SPECIFIC + 41)
#define LSI_CAUSE_CIC_STATE_MISMATCH (LCM_CAUSE_LYR_SPECIFIC + 43)
#define LSI_CAUSE_INV_CGB            (LCM_CAUSE_LYR_SPECIFIC + 46)
#define LSI_CAUSE_INV_CGBRSP         (LCM_CAUSE_LYR_SPECIFIC + 47)
#define LSI_CAUSE_INV_CGURSP         (LCM_CAUSE_LYR_SPECIFIC + 49)
#define LSI_CAUSE_INV_RANGE          (LCM_CAUSE_LYR_SPECIFIC + 51)
#define LSI_CAUSE_TMR_EXP            (LCM_CAUSE_LYR_SPECIFIC + 56)
#define LSI_CAUSE_INV_VARIANT        (LCM_CAUSE_LYR_SPECIFIC + 57)
#define LSI_CAUSE_FAILED             (LCM_CAUSE_LYR_SPECIFIC + 58)
#define LSI_CAUSE_SUCCESS            (LCM_CAUSE_LYR_SPECIFIC + 59)
#define LSI_CAUSE_WRONG_CLLI         (LCM_CAUSE_LYR_SPECIFIC + 60)
#define LSI_CAUSE_UBL_ON_IDLE_CIC    (LCM_CAUSE_LYR_SPECIFIC + 61)
#define LSI_CAUSE_INV_CGSMTI         (LCM_CAUSE_LYR_SPECIFIC + 62)
#define LSI_CAUSE_INV_RNGORSTATUS    (LCM_CAUSE_LYR_SPECIFIC + 63)
#define LSI_CAUSE_INV_CHRGINFO       (LCM_CAUSE_LYR_SPECIFIC + 64)
#define LSI_CAUSE_CONG_LVL3          (LCM_CAUSE_LYR_SPECIFIC + 65)
#define LSI_CAUSE_INV_INTF           (LCM_CAUSE_LYR_SPECIFIC + 66)

#define LSI_CAUSE_PAUSE              (LCM_CAUSE_LYR_SPECIFIC + 67)
#define LSI_CAUSE_RESUME             (LCM_CAUSE_LYR_SPECIFIC + 68)
#define LSI_CAUSE_STPCONG            (LCM_CAUSE_LYR_SPECIFIC + 69)
#define LSI_CAUSE_CONG_LVL0          (LCM_CAUSE_LYR_SPECIFIC + 70)

#define LSI_CAUSE_INV_START_CIC       (LCM_CAUSE_LYR_SPECIFIC + 71) 
            /*  wrong starting cic if checking Q763 table 3 is required*/
#define LSI_CAUSE_NON_CNTCIC_BUSY    (LCM_CAUSE_LYR_SPECIFIC + 72) 
            /* Connection initiation for multirate call with non-controlling 
             * cic busy */
#define LSI_CAUSE_CIC_CAM_MISMATCH   (LCM_CAUSE_LYR_SPECIFIC + 73) 
            /* Mismatch between CIC and CAM          */
#define LSI_CAUSE_UNEX_CAM           (LCM_CAUSE_LYR_SPECIFIC + 74) 
            /* Unexpected CAM for a ckt supporting only contiguous calls */
#define LSI_CAUSE_EVNT_ON_NON_CNTCIC (LCM_CAUSE_LYR_SPECIFIC + 75) 
            /* Recieved event on non-contiguous cic  */
#define LSI_CAUSE_CIR_SPINST_MISMATCH (LCM_CAUSE_LYR_SPECIFIC + 76) 
            /* Mismatch between spInstId with the controlling circuit */
#define LSI_CAUSE_N_CAM_MISMATCH    (LCM_CAUSE_LYR_SPECIFIC + 77) 
            /* Mismatch between N and CAM          */
#define LSI_CAUSE_RSCONBLK    (LCM_CAUSE_LYR_SPECIFIC + 78) 
            /* ISUP reset the ckt when ckt is locally blocked */
#define LSI_CAUSE_CGB         (LCM_CAUSE_LYR_SPECIFIC + 79) 

/***** additional events for StaInd - OLD (for backward compatibility) ****/
#define RLC_RCVD          26             /* Received RLC Message */
#define SIMTP_PAUSE       54             /* Status indication pause from MTP */
#define SIMTP_RMTUSRUNAV  55             /* Status indication remote user 
                                            unavalilable from MTP */
#define SIMTP_RESUME      56             /* Status indication resume from MTP*/
#define SIMTP_CONG        57             /* Status indication congestion from 
                                            MTP */
#define SIMTP_STPCONG     58             /* Status indication stop congestion
                                            from MTP */
 
#define SIMTP_RMTUSRAV    59             /* Status indication remote user 
                                            avalilable from MTP */


#define SIISAP_INV        60             /* invalid isup SAP */
#define SIMSAP_INV        61             /* invalid mtp3 SAP */
#define SISSAP_INV        62             /* invalid sccp SAP */
#define SIMTP_EVTINV      63             /* invalid mtp3 status event */
#define SIGEN_CFG_NOK     64             /* general configuration failed */
#define SIGEN_CFG_OK      65             /* general configuration succeded */
#define SIISAP_CFG_NOK    66             /* isup SAP configuration failed */
#define SIISAP_CFG_OK     67             /* isup SAP configuration succeded */
#define SINSAP_CFG_NOK    68             /* network SAP configuration failed */
#define SINSAP_CFG_OK     69             /* network SAP configuration succdd */
#define SICIR_CFG_NOK     70             /* circuit configuration failed */
#define SICIR_CFG_OK      71             /* circuit SAP configuration succdd */
#define SIROUT_CFG_NOK    72             /* route configuration failed */
#define SIROUT_CFG_OK     73             /* route SAP configuration succeded */
#define SIDELROUT_CFG_NOK 74             /* delete route cofnig failed */
#define SIDELROUT_CFG_OK  75             /* delete route SAP cofnig succeded */
#define SI_STA_NOK        76             /* status failed */
#define SI_STA_OK         77             /* status succdd */
#define SI_STS_NOK        78             /* statistic request failed */
#define SI_STS_OK         79             /* statistic request succeded */
#define SI_CNTRL_NOK      80             /* control request failed */
#define SI_STA_NODBUFF    81             /* no dynamic buffer available */
#define SICIC_INV         82             /* invalid CIC */
#define SI_CNTRL_OK       83             /* control request succeded */
#define SIMSAP_UBND       84             /* MTP-3 SAP unbound */

#define SI_CIR_STOUTSYNC  85          /* circuit states out of sync. */
#define SI_CIR_UNEQPD     86          /* circuit unequipped          */
#define SI_CIR_BLOCK      87          /* circuit blocked             */
#define SI_CIR_TMREXP     88          /* circuit timer expired       */
#define SI_CIR_INVCON     89          /* circuit state prohibits a conneciton */
#define SI_CIR_INVMSG     90          /* invalid msg. for this state of cir. */
#define SI_CG_INVACK      91          /* grp ack does not contain all status */
#define SI_ALM_NWSNDFAIL  92          /* can not send PDU to network */
#define SI_CIR_IDLE       93          /* circuit idled */

#define SI_CIRGRP_BLOCK   94          /* circuit group block */ 

#define SI_UPU_UNEQUIPPED          99  /* rmt USR part unavail - unqueped */ 
#define SI_ALRM_CIR_UNEQUPD        SI_CIR_UNEQPD
#define SI_ALRM_NOROUTE_DEST       100
#define SI_ALRM_NOCIRTO_ROUTE      101
#define SI_ALRM_RESOURCE_BUSY      102
#define SI_ALRM_RESOURCE_BLKD      103
#define SI_ALRM_MAXCALREF_EXCEEDED 106
#define SI_ALRM_ALOCCON_ERROR      107
#define SI_ALRM_ALOCSPINST_ERROR   108
#define SI_ALRM_NSAP_NOTBOUND      109
#define SI_ALRM_INV_SUINSTID       110
#define SI_ALRM_INV_SPINSTID       111
#define SI_ALRM_INV_CIRID          112 /* wrong cir passed */ 
#define SI_ALRM_INV_CALREF         113
#define SI_ALRM_INV_EVENT          114
#define SI_ALRM_INV_MSGLEN         115
#define SI_ALRM_FTZ_ENCODEFAIL     116

#define SI_ALRM_INVCGBA            117 /* CGBA can not be processed */
#define SI_ALRM_INVCGBREQ          118 /* CGB request can't be processed */
#define SI_ALRM_INVCGUREQ          119 /* CGU request can't be processed */
#define SI_ALRM_INVCGB             120 /* CGB can not be processed */
#define SI_ALRM_INVCGU             121 /* CGU can not be processed */
#define SI_ALRM_INVCQR             122 /* CQR can not be processed */
#define SI_ALRM_RNGSTATERR         123 /* range or status related error */
#define SI_ALRM_CGSMTIERR          124 /* Invalid cgsmti */
#define SI_ALRM_INTF_NOTCFGD       125
#define SI_STINTF_CFG_OK           126  /* isup INTF cfg succeded */
#define SI_STINTF_CFG_NOK          127  /* isup INTF cfg failed */ 
#define SI_ALRM_INTF_PAUSED         128


#define SI_STCIRGRP        5          /* elmnt for circuit group operations */
                                      /* Reset/Unblocking/Blocking          */
#define SI_STCONN          6          /* cntrl->hdr.elmId.elmnt for connections
                                         id in usta */
#define SI_STINTF           7          /* cntrl->hdr.elmId.elmnt for dpc cfg */

/* lsi_h_001.main_32 : added new define for layer wide error counter for a Dpc */
#define SI_STDPCGEN         8          /* cntrl->hdr.elmId.elmnt for dpc cfg */

#define STGRPUPSAP         STGRTSAP
#define STGRPNSAP          STGRNSAP

/* Interface states */
#define SI_INTF_AVAIL        0    /* DPC state: available for traffic */
#define SI_INTF_UNAVAIL      1    /* DPC state: unavailable for traffic */
#define SI_INTF_CONG1        2    /* DPC state: congestion level 1 */
#define SI_INTF_CONG2        3    /* DPC state: congestion level 2 */
#define SI_INTF_CONG3        4    /* DPC state: congestion level 3 */
/*  Addition */
#define SI_INTF_UNEQUIP      5    /* DPC state: unequipped         */
/*  Addition */

/* DPC pause action options */
#define SI_PAUSE_CLRDFLT    1    /* default: clear all calls upon rx. PAUSE */
#define SI_PAUSE_CLRTRAN    2    /* clear transient calls upon rx. PAUSE    */
#define SI_PAUSE_CLRTMOUT   3    /* clear calls only when tPAUSE expires    */

/* max num of type defined in trunk type */
#define LSI_MAX_TRUNKTYPE   2    /* support 2 kind of type */

/* checkTable : Validation cntrl flg for mrate and contiguous (fixed) calls */
#define LSI_CHKTBLE_MRATE   1    /* Validate the start cic for mrate calls  
                                  * as per Table 3 part 1 Q.763 
                                  */
#define LSI_CHKTBLE_FIXCNTG 2    /* Validate the start cic for fixed contigous
                                  * calls as per Table 3 part 2 Q.763
                                  */


#define MAX_LSI_TRC       16

#ifdef TDS_ROLL_UPGRADE_SUPPORT
#define LSI_COMMON_DEF_VAL 0x00    /* default value for the field won't used 
                                    * during soak time */
#define LSI_SS7_ANS88_BIT 0x01    /* bit corresponding to flag SS7_ANS88 */
#define LSI_SS7_ANS92_BIT 0x02    /* bit corresponding to flag SS7_ANS92 */
#define LSI_SS7_ANS95_BIT 0x04    /* bit corresponding to flag SS7_ANS95 */
#define LSI_SS7_ITU97_BIT 0x08    /* bit corresponding to flag SS7_ITU97 */
#define LSI_SS7_ETSIV3_BIT  0x10  /* bit corresponding to flag SS7_ETSIV3 */
#define LSI_SS7_ETSI_BIT  0x20  /* bit corresponding to flag SS7_ETSI */
#define LSI_SS7_INDIA_BIT  0x40  /* bit corresponding to flag SS7_INDIA */
#define LSI_SS7_CHINA_BIT  0x80  /* bit corresponding to flag SS7_CHINA */

#define LSI_SS7_NZL_BIT    0x900 /* bit corresponding to flag NZL */
#define LSI_SS7_KZ_BIT     0x100 /* lsi_h_001.main_29 : bit corresponding to flag KZ */
/* lsi_h_001.main_30 : Added bit vector */
#define LSI_SS7_ITU2000_BIT 0x60 /* bit corresponding to flag ITU 2000 */
/* lsi_h_001.main_34: Added bit vector for Ukraine */
#define LSI_SS7_UR_BIT      0x8000 /* bit corresponding to flag Ukraine */
#endif 

#define  SI_MAXTXTLEN   20        /* maximum length of char array */

#define LSI_LNKSEL_LD_DISTR      0x00  /* selected by load distribution */
#define LSI_LNKSEL_CIC           0x01  /* selected by cic               */

#define LSI_LNKSEL_5BITS         0x00  /* 5 bits link selection */
#define LSI_LNKSEL_8BITS         0x01  /* 8 bits link selection */

#define  ELSIBASE    0            /* reserved */
#define  ELSIXXX     ELSIBASE     /* reserved */

#define   ELSI001      (ELSIBASE +    1)    /*        lsi.c:3390 */
#define   ELSI002      (ELSIBASE +    2)    /*        lsi.c:3391 */
#define   ELSI003      (ELSIBASE +    3)    /*        lsi.c:3430 */
#define   ELSI004      (ELSIBASE +    4)    /*        lsi.c:3431 */
#define   ELSI005      (ELSIBASE +    5)    /*        lsi.c:3472 */
#define   ELSI006      (ELSIBASE +    6)    /*        lsi.c:3473 */
#define   ELSI007      (ELSIBASE +    7)    /*        lsi.c:3513 */
#define   ELSI008      (ELSIBASE +    8)    /*        lsi.c:3514 */
#define   ELSI009      (ELSIBASE +    9)    /*        lsi.c:3554 */
#define   ELSI010      (ELSIBASE +   10)    /*        lsi.c:3555 */
#define   ELSI011      (ELSIBASE +   11)    /*        lsi.c:3594 */
#define   ELSI012      (ELSIBASE +   12)    /*        lsi.c:3595 */
#define   ELSI013      (ELSIBASE +   13)    /*        lsi.c:3635 */
#define   ELSI014      (ELSIBASE +   14)    /*        lsi.c:3636 */
#define   ELSI015      (ELSIBASE +   15)    /*        lsi.c:3675 */
#define   ELSI016      (ELSIBASE +   16)    /*        lsi.c:3676 */
#define   ELSI017      (ELSIBASE +   17)    /*        lsi.c:3717 */
#define   ELSI018      (ELSIBASE +   18)    /*        lsi.c:3718 */
#define   ELSI019      (ELSIBASE +   19)    /*        lsi.c:3758 */
#define   ELSI020      (ELSIBASE +   20)    /*        lsi.c:3759 */
#define   ELSI021      (ELSIBASE +   21)    /*        lsi.c:3798 */
#define   ELSI022      (ELSIBASE +   22)    /*        lsi.c:3800 */
#define   ELSI023      (ELSIBASE +   23)    /*        lsi.c:3802 */
#define   ELSI024      (ELSIBASE +   24)    /*        lsi.c:3842 */
#define   ELSI025      (ELSIBASE +   25)    /*        lsi.c:3844 */
#define   ELSI026      (ELSIBASE +   26)    /*        lsi.c:3846 */
#define   ELSI027      (ELSIBASE +   27)    /*        lsi.c:3887 */
#define   ELSI028      (ELSIBASE +   28)    /*        lsi.c:3888 */
#define   ELSI029      (ELSIBASE +   29)    /*        lsi.c:3889 */
#define   ELSI030      (ELSIBASE +   30)    /*        lsi.c:3930 */
#define   ELSI031      (ELSIBASE +   31)    /*        lsi.c:3931 */
#define   ELSI032      (ELSIBASE +   32)    /*        lsi.c:3932 */
#define   ELSI033      (ELSIBASE +   33)    /*        lsi.c:3974 */
#define   ELSI034      (ELSIBASE +   34)    /*        lsi.c:3976 */
#define   ELSI035      (ELSIBASE +   35)    /*        lsi.c:3978 */
#define   ELSI036      (ELSIBASE +   36)    /*        lsi.c:3979 */
#define   ELSI037      (ELSIBASE +   37)    /*        lsi.c:4020 */
#define   ELSI038      (ELSIBASE +   38)    /*        lsi.c:4021 */
#define   ELSI039      (ELSIBASE +   39)    /*        lsi.c:4023 */
#define   ELSI040      (ELSIBASE +   40)    /*        lsi.c:4025 */
#define   ELSI041      (ELSIBASE +   41)    /*        lsi.c:4065 */
#define   ELSI042      (ELSIBASE +   42)    /*        lsi.c:4066 */
#define   ELSI043      (ELSIBASE +   43)    /*        lsi.c:4106 */
#define   ELSI044      (ELSIBASE +   44)    /*        lsi.c:4107 */
#define   ELSI045      (ELSIBASE +   45)    /*        lsi.c:4147 */
#define   ELSI046      (ELSIBASE +   46)    /*        lsi.c:4148 */
#define   ELSI047      (ELSIBASE +   47)    /*        lsi.c:4188 */
#define   ELSI048      (ELSIBASE +   48)    /*        lsi.c:4189 */
#define   ELSI049      (ELSIBASE +   49)    /*        lsi.c:4230 */
#define   ELSI050      (ELSIBASE +   50)    /*        lsi.c:4231 */
#define   ELSI051      (ELSIBASE +   51)    /*        lsi.c:4271 */
#define   ELSI052      (ELSIBASE +   52)    /*        lsi.c:4272 */
#endif
  
/********************************************************************30**
 
         End of file:     lsi.h@@/main/35 - Thu Jun  3 14:04:59 2010

*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  

*********************************************************************71*/

/********************************************************************80**
 
  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---   bn   1. initial release.

1.2          ---   bn   1. miscellaneous changes

1.3          ---   bn   1. added define for SIMTP_RMTUSRAV.

1.4          ---  bn    1. additions for Italian Q767.

1.5          ---  bn    1. added define for MAX_LSI_TRC.
             ---  bn    2. added defines for variant switches and changed
                           them from SW_... to LSI_SW_...

1.6          ---  bn    1. changed LSI_SW_CCITT to LSI_SW_ITU and LSI_SW_ANSI??
                           LSI_SW_ANS??.

1.7          ---  bn    1. added new events for alarms.

1.8          ---  pc    1. added ETSI variant for SI

1.9          ---  dm    1. added GT_FTZ variant for SI

*********************************************************************81*/

/********************************************************************90**
 
    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
1.10         ---      dm   1. added SICIC_INV define

1.10         ---      ao   1. Added SI_CNTRL_OK define
             ---      rh   2. Added SIMSAP_UBND define 

1.11         ---      rh   3. Added call clearing options upon PAUSE reception

1.12         ---      rh   1. changed changelog format.

1.13         ---      rs   1. Added defines for DPC control block.
                      rs   2. Added new defines for Alarms.
                      ym   1. added new define SI_STCIRGRP & 
                              MAX_SIZ_STATUS for ckt grp
                              control request.
                      ym   1. Additions for TCO3
1.14         ---      ao   1. Added Russian variant
             ---      ym   1. Value of SI_ALRM_INVCQR is corrected.
             ---      ym   1. Alarm type related to range/status is added. 
                           2. Value of SI_ALRM_RESOURCE_BLKD is corrected. 
                           3. Cause and Dgn corresponding to invalid cgsmti
                              and range are added.
             ---      ym   1. Defines for cirFlg in ckt config. are added.
                              These defines are defined if LSI_PARAMETER
                              flag is enabled.

1.15         ---      bn   1. Added bellcore variant

1.16         ---      bn   1. added define for LSI_CAUSE_CONG_LVL3.

1.17         ---      ym   1. Added NTT variant.
1.18         ---      bsp  1. Removed unused hash define LSI_USTA_DGNVAL_TMR
             ---      rrb  2. Added CONTROLLED and CONTROLLING circuit
                              definition for bothway circuits.
             ---      ym   1. SI_ALRM_RESOURCE_BLKD is uncommented as it is
                              used if LMINT3 is not defined.
/main/19     ---      hy   1. Added hash define for LSI_CAUSE_PAUSE, 
                              LSI_CAUSE_RESUME, LSI_CAUSE_STPCONG and
                              LSI_CAUSE)CONG_LVL0.
                           2. Added defines for slotId, cntrlMult, 
                              trunkType and checkTable. Added additional
                              cause values for alarms for non-single rate
                              call. They are:
                              LSI_CIR_SLOTID_MASK, LSI_CIR_SKIP_CONTIGOUS, 
                              LSI_CIR_NON_CONTIGOUS, LSI_MAX_TRUNKTYPE,
                              LSI_CHKTBLE_MRATE, LSI_CHKTBLE_FIXCNTG,
                              LSI_MAX_CKT_MAP, LSI_CAUSE_NON_CNTCIC_BUSY,
                              LSI_CAUSE_CIC_CAM_MISMATCH, LSI_CAUSE_UNEX_CAM,
                              LSI_CAUSE_EVNT_ON_NON_CNTCIC, 
                              LSI_CAUSE_CIR_SPINST_MISMATCH, 
                              LSI_CAUSE_N_CAM_MISMATCH,
                              LSI_CAUSE_RSCONBLK, LSI_CAUSE_INV_START_CIC
                              LSI_TRUNKTYP_E1, LSI_TRUNKTYP_T1
                           3. Removed defines LSI_MAX_CKT_MAP since it is no
                              longer used in the code.
                           4. Added a hash define for LSI_CAUSE_CGB
                       bsp 1. Changed MAX_SIZ_STATUS to 32 as required by
                              the CTF environment.
                       hy  1. Added the error code for 2.19 release.
                       km  1. Added SI_INTF_UNEQUIP flag to denote that point
                              code is unequipped
/main/22     ---       bsp 1. Added new event type define, LSI_EVENT_MTP

/main/23     ---       hy  1. Added interface version number, bit vectors in 
                              base release for rolling upgrade 
                           2. Added defines for LSI_USTA_DGNVAL_VER
                       mm  3. Removed the LSIV1 flags for bit vector defines.
                       hy  4. Increased LSI interface version number.
                           5. Added new define of SICIR_ST_INVALID.
                       mm  6. Added new define of LSI_USTA_DGNVAL_DPC.
                       mm  7. Added maximum length of char array.
                       mm  8. Added link selector option defines.
                           9. Increased LSI interface version number.
                       tz 10. Added link selection bits defines.
                       tz 11. Added Indian switch type.
                       rk 12. Added CHINA flag and switch where applicable.
                       bn 13. Added ITU2000 and Russian 2000 ISUP variants.
/main/24     ---       vp  1. Added New define LSI_STS_UNXEVT
   			               2. Added UK Switch LSI_SW_UK
lsi_h_001.main_24      vp  1. Adding define SI_CIRGRP_BLOCK
lsi_h_001.main_25      rks 1. Added define for New Zealand switch
                           2. Added define for Bit value for Rolling upgrade
                              for New Zealand variant
lsi_h_001.main_26      rks 1. Added define for new interface version "LSIV5"
                              for TTB feature(si072.220)
*************************************************************************
        Revision history:
 Version    Patch            Initials     Description
 -------- -----------------  --------  ---------------------------------
 2.21     lsi_h_001.main_28  rkumar    1. Initial release.
 2.21     lsi_h_001.main_29  rkumar    1. Modified to add diagnostic type for 
                                          timer, state and message type
                                       2. Added define for switch type and bit vector
                                          for kazakhstan variant
 2.21     lsi_h_001.main_30  rkumar    1. Modified to add define for bit vector
                                          for ITU 20000
 2.21     lsi_h_001.main_31  ckumar    1. Added new define LSI_STS_T33IEXP to 
                                          maintain counter for T33I timer expiry.
 2.21     lsi_h_001.main_32  ckumar    1. Added new define for layer wide error
                                          counter for a Dpc.
 2.21     lsi_h_001.main_33  kchaitanya 1. Addition of switch value for Brazil variant
                                        2. Added Marcos UIL3_NW, UIL3_IP and UIL3_PPP
 2.21     lsi_h_001.main_34  kchaitanya 1. Added switch type and bit vector for
                                           Ukraine
*********************************************************************91*/
