/********************************************************************16**

        (c) COPYRIGHT 1989-2002 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     layer management interface - mtp level 2
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               layer management service user.
 
     File:     lsd.x
  
     Sid:      lsd.x@@/main/12 - Tue Oct 30 12:58:18 2007
    
     Prg:      mc
 
*********************************************************************21*/
  
#ifndef __LSDX__
#define __LSDX__
#ifdef __cplusplus
extern "C" {
#endif

/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000027     SS7 - MTP Level 2
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000027     SS7 - MTP Level 2
*
*/
 

/* typedefs */

/* sdGenCfg structure */
 
typedef struct sdGenCfg         /* MTP level 2 general configuration */ 
{          
   S16 nmbLnks;                 /* number of Physical Links */
   Status poolTrLower;          /* lower pool threshold */
   Status poolTrUpper;          /* upper pool threshold */
   Pst sm;                      /* stack manager */
} SdGenCfg;
 
/* sdSAPCfg structure */
 
typedef struct sdSAPCfg         /* MTP level 2 data link SAP configuration */
{
   MemoryId mem;                /* memory region and pool id */
   Swtch swtch;                 /* protocol type */
   Priority priorDl;            /* priority for data link layer */
   Route routeDl;               /* route for data link layer */
   Selector selectorDl;         /* upper interface selector */
   Ent entMac;                  /* entity for MAC */
   Inst instMac;                /* instance for MAC */
   Priority priorMac;           /* priority for MAC layer */
   Route routeMac;              /* route for MAC layer */
   Selector selectorMac;        /* lower interface selector */
   MemoryId memMac;             /* memory region and pool id for MAC */
   U8 maxOutsFrms;              /* maximum outstanding frames */
   Bool errType;                /* cyclical or normal error checking */
#ifdef SD_HSL
   U8 sapType;                  /* Indcates whether link is HSL or LSL */
   U8 sapFormat;                /* The extened sequence no to be used or not */
#endif /* HIGH_SPEED_SIGNALING_SUPPORT */
   TmrCfg t1;                   /* timer 1 configuration structure */
   TmrCfg t2;                   /* timer 2 configuration structure */
   TmrCfg t3;                   /* timer 3 configuration structure */
   TmrCfg t5;                   /* timer 5 configuration structure */
   TmrCfg t6;                   /* timer 6 configuration structure */
   TmrCfg t7;                   /* timer 7 configuration structure */
#ifdef SD_HSL
   TmrCfg t8;                   /* timer 8 configuration structure */
   U32 sdTe;                    /* EIM threshold */
   U32 sdUe;                    /* increment constant */
   U32 sdDe;                    /* decrement constant */
#endif /* HIGH_SPEED_SIGNALING_SUPPORT */
   U16 provEmrgcy;              /* emergency proving period */
   U16 provNormal;              /* normal proving period */
   U8 lssuLen;                  /* one or two byte LSSU length */
   U16 maxFrmLen;               /* max frame length for MSU */
   Bool congDisc;               /* congestion discard TRUE or FALSE */
   U16 sdT;                     /* SUERM error rate threshold */
   U8 sdTie;                    /* AERM emergency error rate threshold */
   U8 sdTin;                    /* AERM normal error rate threshold */
   U8 sdN1;                     /* maximum number of MSUs for retransmission */
   U16 sdN2;                    /* maximum number of MSU octets for retrans */
   U8 sdCp;                     /* maximum number of alignment attempts */
   SpId spIdSE;                 /* service provider id */
   ProcId dstProcId;            /* processor id */
   U16 sdtFlcStartTr;           /* SDT interface flow control start thresh */
   U16 sdtFlcEndTr;             /* SDT interface flow control end thresh */
#if (SS7_TTC || SS7_NTT)  
   U16 numRtb;            /* outstanding number of messages in RTB */
   TmrCfg tf;             /* FISU transmission interval */
   TmrCfg tfv;            /* FISU transmission interval during verification */
   TmrCfg to;             /* SIO transmission interval */
   TmrCfg ta;             /* SIE transmission interval */
   TmrCfg ts;             /* SIOS transmission interval */
   TmrCfg tso;            /* SIOS transmission duration when out of service */
   TmrCfg te;             /* SU normalization time */
#endif /* (SS7_TTC || SS7_NTT) */
#if (SS7_NTT)             /* NTTT - Q.703 */
   Bool repMsuNack;       /* Nack on receipt of repeated MSU */
   Bool invFibIgnore;     /* invalid FIB ignore or bring the link down */
   Bool invBsnIgnore;     /* invalid BSN ignore or bring the link down */
   Bool congAbatOnNack;   /* congestion abatement on nack or only on acks */
#endif /* (SS7_NTT) */
#ifdef TDS_ROLL_UPGRADE_SUPPORT 
   Bool hlremIntfValid;          /* Upper Sap Version number valid ? */
   CmIntfVer   remIntfVer;       /* remote version info */
#endif /*RUG*/
} SdSAPCfg;


/* MTP level 2 */
/* Debug control structure */
typedef struct sdDbgCntrl
{ 
        U32 dbgMask; /* debug mask */
} SdDbgCntrl;
 
/* sdSAPSts structure */
  
typedef struct sdSAPSts         /* MTP level 2 statistics */
{
   Ticks inService;             /* start of in-service */
   Ticks lclBusy;               /* duration of local-busy */
   Cntr slFailAll;              /* all reasons for a signalling link failure */
   Cntr slFailAb;               /* Abnormal FIBR/BSNR link failure */
   Cntr slFailAck;              /* delay of acknowledgement link failure */
   Cntr slFailErr;              /* excessive error rate link failure */
   Cntr slFailCong;             /* excessive congestion link failure */
   Cntr slFailAlign;            /* alignment link failure */
   Cntr slNSUErr;               /* number of signal units in error */
   Cntr slNegAck;               /* number of negative acknowledgements */
   Cntr nSifSioTx;              /* number of SIF/SIO packets transmitted */
   Cntr nRetrans;               /* number of octets retransmitted */
   Cntr mTx;                    /* information frames transmitted */
   Cntr lTx;                    /* receive ready frames transmitted */
   Cntr fTx;                    /* receive not ready frames transmitted */
   Cntr nSifSioRx;              /* number of SIF/SIO packets received */
   Cntr mRx;                    /* information frames received */
   Cntr lRx;                    /* receive ready frames received */
   Cntr fRx;                    /* receive not ready frames received */
} SdSAPSts;
   

/* MTP level 2 */
 
/* sdSAPSta structure */
  
typedef struct sdSAPSta         /* MTP level 2 - SAP status */
{
   U8 hlSt;                     /* sap state */
   U16 psOutsFrm;                /* outstanding frames to MAC */
   S16 cntMaDrop;               /* frames dropped by MAC */
   Bool lclBsy;                   /* local busy */
   Bool remBsy;                 /* remote busy */
   U16 fsn;                      /* forward sequence number */
   U16 bsn;                      /* backward sequence number */
   U8 llSt;                     /* link level matrix state */
   U8 flcSt;                    /* flow control state */
   S16 rtxCnt;                  /* retransmission count */
   QLen qSize;                  /* queue size */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool remIntfValid;         /*remote version valid in cfm? */
   CmIntfVer selfIfVer;        /*self version on this SAP*/
   CmIntfVer remIfVer;        /*remote version on this SAP*/
#endif 
} SdSAPSta;


/* management message */
  
typedef struct sdMngmt
{
   Header hdr;                  /* header */
#if (SD_LMINT3 || SMSD_LMINT3)
   CmStatus cfm;                /* conformation */
#endif
   union {
  
/* configuration */
  
      struct
      {
         union
         {
            SdGenCfg sdGen;     /* MTP level 2 - general */
            SdSAPCfg sdDLSAP;   /* MTP level 2 - data link SAP */
         } s;
      } cfg;                           /* configuration */
 

/* statistics */
  
      struct
      {
         DateTime dt;           /* date and time */
         Duration dura;         /* duration */
         SdSAPSts sdDLSAP;      /* MTP level 2 - data link SAP */
      } sts;                    /* statistics */
  

/* solicited status */
 
      struct
      {
         DateTime dt;           /* date and time */
         union
         {
            SystemId sysId;     /* system id */
            SdSAPSta sdDLSAP;   /* MTP level 2 - data link SAP */
         } s;
      } ssta;                   /* solicited status */
  

/* unsolicited status */
  
      struct
      {
#if (SD_LMINT3 || SMSD_LMINT3)
         CmAlarm alarm;         /* common alarm structure */
#else
         DateTime dt;           /* date and time */
         U16 evnt;              /* event number */
#endif /* (SD_LMINT3 || SMSD_LMINT3 )*/
         U8 evntParm[8];        /* event parameters */
      } usta;                   /* unsolicited status */
  
/* trace */
  
      struct
      {
         DateTime dt;           /* date and time */
         U16 evnt;              /* event */
#ifdef SD_HSL
         U8  seqNumType;        /* sequence number type */
#endif  /* HIGH_SPEED_SIGNALING_SUPPORT */
         U8  len;               /* length of event parameters */
         U8 evntParm[272];      /* event parameters */
      } trc;                    /* trace */
  
/* control */
  
      struct
      {
         DateTime dt;           /* date and time */
         U8 action;             /* action */
         U8 subAction;          /* sub action */
#if 0
	 /*Kapil - Not sure whats the use of below variables , hence commenting them */
	 /* DAVIDY MTP2-API */
	 SuId suId;
	 SpId spId;
#endif
         union 
         {
            ProcId dstProcId;   /* destination processor Id */
            Route route;        /* route type */
            Priority prior;     /* priority value */
            U16 maxSize;        /* maximum union size */
         }par;                  /* group control request parameter */
#ifdef DEBUGP
         SdDbgCntrl sdDbg;   /* debug information */
#endif
      } cntrl;                  /* control */

   }t;
} SdMngmt;


/* depending on the specific selector in the post structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */
 
typedef S16 (*LsdStaInd) ARGS((Pst *pst, SdMngmt *sta));
typedef S16 (*LsdTrcInd) ARGS((Pst *pst, SdMngmt *trc));
typedef S16 (*LsdStaCfm) ARGS((Pst *pst, SdMngmt *sta));
typedef S16 (*LsdStsCfm) ARGS((Pst *pst, Action action, SdMngmt *sts));
typedef S16 (*LsdCfgReq) ARGS((Pst *pst,SdMngmt *cfg));
typedef S16 (*LsdStaReq) ARGS((Pst *pst,SdMngmt *sta));
typedef S16 (*LsdStsReq) ARGS((Pst *pst,Action action,SdMngmt *sts));
typedef S16 (*LsdCntrlReq) ARGS((Pst *pst,SdMngmt *cntrl));
typedef S16 (*LsdCfgCfm) ARGS((Pst *pst, SdMngmt *cfm));
typedef S16 (*LsdCntrlCfm) ARGS((Pst *pst, SdMngmt *cfm));

#ifdef SD       /* MTP level 2 */
EXTERN  S16 SdMiLsdCfgReq ARGS((Pst *pst, SdMngmt *cfg));
EXTERN  S16 SdMiLsdStaReq ARGS((Pst *pst, SdMngmt *sta));
EXTERN  S16 SdMiLsdStsReq ARGS((Pst *pst, Action action, SdMngmt *sts));
EXTERN  S16 SdMiLsdCntrlReq ARGS((Pst *pst, SdMngmt *cntrl));
EXTERN  S16 SdMiLsdStaInd ARGS((Pst *pst, SdMngmt *sta));
EXTERN  S16 SdMiLsdStaCfm ARGS((Pst *pst, SdMngmt *sta));
EXTERN  S16 SdMiLsdStsCfm ARGS((Pst *pst, Action action, SdMngmt *sts));
EXTERN  S16 SdMiLsdTrcInd ARGS((Pst *pst, SdMngmt *trc));
EXTERN  S16 SdMiLsdCfgCfm ARGS((Pst *pst, SdMngmt *cfm));
EXTERN  S16 SdMiLsdCntrlCfm ARGS((Pst *pst, SdMngmt *cfm));
#endif
#ifdef SM
EXTERN  S16 SmMiLsdStaInd ARGS((Pst *pst, SdMngmt *sta));
EXTERN  S16 SmMiLsdStaCfm ARGS((Pst *pst, SdMngmt *sta));
EXTERN  S16 SmMiLsdStsCfm ARGS((Pst *pst, Action action, SdMngmt *sts));
EXTERN  S16 SmMiLsdTrcInd ARGS((Pst *pst, SdMngmt *trc));
EXTERN  S16 SmMiLsdCfgReq ARGS((Pst *pst, SdMngmt *cfg));
EXTERN  S16 SmMiLsdStaReq ARGS((Pst *pst, SdMngmt *sta));
EXTERN  S16 SmMiLsdStsReq ARGS((Pst *pst, Action action, SdMngmt *sts));
EXTERN  S16 SmMiLsdCntrlReq ARGS((Pst *pst, SdMngmt *cntrl));
EXTERN  S16 SmMiLsdCfgCfm ARGS((Pst *pst, SdMngmt *cfm));
EXTERN  S16 SmMiLsdCntrlCfm ARGS((Pst *pst, SdMngmt *cfm));
#endif

/* stack manager initialization function */
/* lsd_x_001.main_10: Addtion: Protype definition for Multiproc */
#ifdef SS_MULTIPLE_PROCS
EXTERN S16 smSdActvInit ARGS((ProcId procId,Ent ent, Inst inst, Region region, Reason reason,Void **xxCb));
#else
EXTERN S16 smSdActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));
#endif

/* stack manager activation function */
EXTERN S16 smSdActvTsk ARGS((Pst *pst, Buffer *mBuf));

/* lsd_x_001.main_9 - Addition - Declarations of sdActvInit and sdActvTsk */
#ifdef SS_MULTIPLE_PROCS
EXTERN  S16 sdActvInit ARGS((ProcId procId, Ent entity,Inst inst,Region region,
                                                  Reason reason, Void  **xxCb));
#else /* SS_MULTIPLE_PROCS */
EXTERN  S16 sdActvInit ARGS((Ent entity,Inst inst,Region region,Reason reason));
#endif /* SS_MULTIPLE_PROCS */
EXTERN  S16 sdActvTsk ARGS((Pst *pst, Buffer *mBuf));

/* layer manager interface packing/unpacking functions - common to LSD */

EXTERN S16 cmPkLsdCfgCfm ARGS((Pst *pst, SdMngmt *cfm));
EXTERN S16 cmPkLsdCntrlCfm ARGS((Pst *pst, SdMngmt *cfm));
EXTERN S16 cmPkLsdStaCfm ARGS((Pst *pst, SdMngmt *sta));
EXTERN S16 cmPkLsdStaInd ARGS((Pst *pst, SdMngmt *sta));
EXTERN S16 cmPkLsdStsCfm ARGS((Pst *pst, Action action, SdMngmt *sts));
EXTERN S16 cmPkLsdTrcInd ARGS((Pst *pst, SdMngmt *trc));
EXTERN S16 cmUnpkLsdCfgReq ARGS((LsdCfgReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdStaReq ARGS((LsdStaReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdStsReq ARGS((LsdStsReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdCntrlReq ARGS((LsdCntrlReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmPkLsdStsReq ARGS((Pst *pst, Action action, SdMngmt *sts));
EXTERN S16 cmPkLsdCfgReq ARGS((Pst *pst, SdMngmt *cfg));
EXTERN S16 cmPkLsdStaReq ARGS((Pst *pst, SdMngmt *sta));
EXTERN S16 cmPkLsdCntrlReq ARGS((Pst *pst, SdMngmt *cntrl));
EXTERN S16 cmUnpkLsdStaCfm ARGS((LsdStaCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdStsCfm ARGS((LsdStsCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdStaInd ARGS((LsdStaInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdTrcInd ARGS((LsdTrcInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdCfgCfm ARGS((LsdCfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLsdCntrlCfm ARGS((LsdCntrlCfm func, Pst *pst, Buffer *mBuf));

#ifdef __cplusplus
}
#endif
#endif /* __LSDX__ */
 

/********************************************************************30**
  
         End of file:     lsd.x@@/main/12 - Tue Oct 30 12:58:18 2007
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  mc    1. initial release

1.2          ---  mc    1. add smSdActvTsk and smSdActvInit prototypes.

1.3          ---  shiv  1. removed actSaps field from SdSAPSta structure 
                        2. removed t4, congTmr, cfmType  field from
                           SdSAPCfg
                        3. added len field to trc structure in SdMngmt
*********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.4          ---      ash  1. changes to support fault tolerance
                           2. Change to support LMINT3
                           3. Replaced all extern with EXTERN
                      sr   4. prototypes for common packing/unpacking
                              functions.
                      sr   5. Naming convention of common pack/unpack
                              functions changed to comply with TCO
                      sr   6. The field sdDbg is relocated in the structure
                              SdMngmt
                      sr   7. changed copyright header
                      sr   8. c++ syntax added the beginning and end of file.

1.5          ---      ash  1. Changes to support TTC
             ---      cp   2. Replaced #ifdef TTC with #if (SS7_TTC || SS7_NTT)

1.6          ---      ash  1. Changes to support NTT
                           2. More parameters added in sdSAPCfg to support
                              NTT specs options
            sd017.211 yz   3. Support rolling upgrade.                  
/main/8      ---      ved  1. Update for ISM release 1.1
/main/9      ---      rr   1. Support For High speed signaling link
                           2. MSU data sent in Trace indication for Low speed 
                              signaling link
                           3. Stopping all timers during shutdown 
/main/9 lsd_x_001.main_9 dd 1. Moved sdActvInit and sdActvTsk from
                               sd.x to lsd.x
/main/9 lsd_x_001.main_10 skv 1.Modified the prototype of the function smSdActvInit 
                                with respect to the SS_MULTIPLE_PROCS.
*********************************************************************91*/
