/********************************************************************16**

        (c) COPYRIGHT 1989-1999 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     layer management interface - mtp level 2
  
     Type:     C include file
  
     Desc:     Defines required by the layer management service user.
  
     File:     lsd.h
  
     Sid:      lsd.h 1.10  -  03/01/99 09:58:14
     
     Prg:      mc
  
*********************************************************************21*/
  
#ifndef __LSDH_
#define __LSDH_
 

/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000027     SS7 - MTP Level 2
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000027     SS7 - MTP Level 2
*
*/
    

/* defines */
  
#define SD_ERR_NRM  0      /* normal error checking mode */
#define SD_ERR_CYC  1      /* preventative cyclical error checking mode */
 
#define LSD_SW_ITU88       1  /* switch - ITU 88 */
#define LSD_SW_ANSI88      2  /* switch - ANSI 88 */
#define LSD_SW_ANSI92      3  /* switch - ANSI 92 */
#define LSD_SW_ITU92       4  /* switch - ITU 92 */
#if (SS7_TTC || SS7_NTT)
#define LSD_SW_TTC         5  /* switch - TTC */
#define LSD_SW_NTT         6  /* switch - NTT */
#endif /* (SS7_TTC || SS7_NTT) */


#define SD_PRE_FISU 0      /* send connect confirm before FISU received */
#define SD_PST_FISU 1      /* send connect confirm after FISU received */

/* Sd Management Events */

#define EVTLSDCFGREQ     0x3c             /* Configuration request */
#define EVTLSDSTAREQ     0x40             /* Status request */
#define EVTLSDSTACFM     0x41             /* Status confirm */
#define EVTLSDSTAIND     0x42             /* Status indication */
#define EVTLSDSTSREQ     0x44             /* Statistics request */
#define EVTLSDSTSCFM     0x45             /* Statistics confirm */
#define EVTLSDTRCIND     0x48             /* Trace indication */
#define EVTLSDCNTRLREQ   0x4c             /* Control request */
#define EVTLSDCNTRLCFM   0x4d             /* Control confirm */
#define EVTLSDCFGCFM     0x4e             /* Config confirm */

/* for LMINT3 */
/* entering congestion */
#define LSD_EVENT_ENTR_CONG      (LCM_EVENT_LYR_SPECIFIC + 0)
/* exiting congestion */
#define LSD_EVENT_EXIT_CONG      (LCM_EVENT_LYR_SPECIFIC + 1)
/* link up  */
#define LSD_EVENT_PROT_ST_UP     (LCM_EVENT_LYR_SPECIFIC + 2)
/* link up  */
#define LSD_EVENT_PROT_ST_DN     (LCM_EVENT_LYR_SPECIFIC + 3)
/* protocol error */
#define LSD_EVENT_PROT_ERR       (LCM_EVENT_LYR_SPECIFIC + 4)
/* link aligned  */
#define LSD_EVENT_LINK_ALIGNED   (LCM_EVENT_LYR_SPECIFIC + 5)
/* alignment lost  */
#define LSD_EVENT_ALIGN_LOST     (LCM_EVENT_LYR_SPECIFIC + 6)
/* normal error correction RTB full */
#define LSD_EVENT_RTB_FULL       (LCM_EVENT_LYR_SPECIFIC + 7)
/* rtb full is over */
#define LSD_EVENT_RTB_FULL_OVER  (LCM_EVENT_LYR_SPECIFIC + 8)
/* negative acknowledgement */
#define LSD_EVENT_NEG_ACK        (LCM_EVENT_LYR_SPECIFIC + 9)
/* data confirm on upper interface */
#define LSD_EVENT_DAT_CFM_SDT    (LCM_EVENT_LYR_SPECIFIC + 10)
/* remote end congestion start */
#define LSD_EVENT_REMOTE_CONG_START  (LCM_EVENT_LYR_SPECIFIC + 11)
/* remote end congestion end */
#define LSD_EVENT_REMOTE_CONG_END    (LCM_EVENT_LYR_SPECIFIC + 12)
/* remote end processor outage start  */
#define LSD_EVENT_RX_REMOTE_SIPO     (LCM_EVENT_LYR_SPECIFIC + 13)
                     
/* causes */

/* SU with abnormal backward sequence num */
#define LSD_CAUSE_ABN_BSN          (LCM_CAUSE_LYR_SPECIFIC + 0)      
/* SU with abnormal forward indicator bit */
#define LSD_CAUSE_ABN_FIB          (LCM_CAUSE_LYR_SPECIFIC + 1)      
/* congestion discard */
#define LSD_CAUSE_CONG_DISC        (LCM_CAUSE_LYR_SPECIFIC + 2)      
  
/* defines for LsdStaInd */
#define SD_ENTR_CONG            LSD_EVENT_ENTR_CONG
#define SD_EXIT_CONG            LSD_EVENT_EXIT_CONG
#define SD_PROT_ST_UP           LSD_EVENT_PROT_ST_UP
#define SD_PROT_ST_DN           LSD_EVENT_PROT_ST_DN
#define SD_PROT_ERR             LSD_EVENT_PROT_ERR
#define SD_LINK_ALIGNED         LSD_EVENT_LINK_ALIGNED
#define SD_ALIGN_LOST           LSD_EVENT_ALIGN_LOST
#define SD_UIBNDREQ_NOK     9           /* event - Bind by upper layer failed */
#define SD_LIBNDREQ_NOK     10          /* event - Bind to MAC layer failed */
#define SD_UIUBNDREQ_NOK    11          /* event - Unbind by upper layer failed */
#define SD_LIUBNREQD_NOK    12          /* event - Unbind to MAC layer failed */
#define SD_LIDISCREQ_NOK    13          /* event - Disconnect with MAC layer failed */
#define SD_UICONREQ_NOK     14          /* event - Upper Connect failed */
#define SD_UIDATREQ_NOK     15          /* event - UiDatReq failed */
#define SD_UIDISCREQ_NOK    16          /* event - UiDiscReq failed */
#define SD_UIFLCREQ_NOK     17          /* event - UiFlcReq failed */
#define SD_UISTAREQ_NOK     18          /* event - UiStaReq failed */
#define SD_LICONCFM_NOK     19          /* event - LiConCfm failed */
#define SD_LIDISCIND_NOK    20          /* event - LiDiscInd failed */
#define SD_LIDATIND_NOK     21          /* event - LiDatInd failed */
#define SD_LISTACFM_NOK     22          /* event - LiStaCfm failed */
#define SD_LIDATCFM_NOK     23          /* event - LiDatCfm failed */
#define SD_LISTAIND_NOK     24          /* event - LiStaInd failed */
#define SD_MISTAREQ_NOK     25          /* event - MiStaReq failed */
#define SD_MISTSREQ_NOK     26          /* event - MiStsReq failed */
#define SD_MICNTRLREQ_NOK   27          /* event - MiCntrlReq failed */
#define SD_USTA_CFG_NOK     28          /* event - Configuration failed */
#define SD_USTA_CFG_OK      29          /* event - Configuration OK */
#define SD_MICNTRLREQ_OK    30          /* event - MiCntrlReq success */

#ifdef SDDEBUG
#define SD_RTB_FULL                LSD_EVENT_RTB_FULL
#define SD_RTB_FULL_OVER           LSD_EVENT_RTB_FULL_OVER
#define SD_NEG_ACK                 LSD_EVENT_NEG_ACK
#define SD_DAT_CFM_SDT             LSD_EVENT_DAT_CFM_SDT
#define SD_RX_REMOTE_CONG_START    LSD_EVENT_REMOTE_CONG_START
#define SD_RX_REMOTE_CONG_END      LSD_EVENT_REMOTE_CONG_END
#define SD_RX_REMOTE_SIPO          LSD_EVENT_RX_REMOTE_SIPO
#endif /* SDDEBUG */
 

 
/* defines for LsdTrcInd */

#define SD_FRAME_RCVD     1           /* event - frame received */
#define SD_FRAME_TXED     2           /* event - frame transmitted */

/*sd027.211-addition, HSL*/
#ifdef SD_HSL
#define NORMAL_HSL_FORMAT   0           /* normal sequence number in SU */
#define EXTENDED_HSL_FORMAT 1           /* normal sequence number in SU */

#define SD_HSL_LINK 	1
#define SD_LSL_LINK	0

#endif   /* HIGH_SPEED_SIGNALING_SUPPORT */

/* error codes for common packing/unpacking functions at layer manager
 * interface
 */

#define ELSDBASE       0            /* reserved */
#define ELSDXXX        (ELSDBASE)   /* reserved */


#define   ELSD001      (ELSDBASE +    1)    /*        lsd.c: 176 */
#define   ELSD002      (ELSDBASE +    2)    /*        lsd.c: 179 */
#define   ELSD003      (ELSDBASE +    3)    /*        lsd.c: 223 */
#define   ELSD004      (ELSDBASE +    4)    /*        lsd.c: 226 */
#define   ELSD005      (ELSDBASE +    5)    /*        lsd.c: 271 */
#define   ELSD006      (ELSDBASE +    6)    /*        lsd.c: 272 */
#define   ELSD007      (ELSDBASE +    7)    /*        lsd.c: 273 */
#define   ELSD008      (ELSDBASE +    8)    /*        lsd.c: 274 */
#define   ELSD009      (ELSDBASE +    9)    /*        lsd.c: 275 */
#define   ELSD010      (ELSDBASE +   10)    /*        lsd.c: 276 */
#define   ELSD011      (ELSDBASE +   11)    /*        lsd.c: 277 */
#define   ELSD012      (ELSDBASE +   12)    /*        lsd.c: 278 */
#define   ELSD013      (ELSDBASE +   13)    /*        lsd.c: 279 */
#define   ELSD014      (ELSDBASE +   14)    /*        lsd.c: 280 */
#define   ELSD015      (ELSDBASE +   15)    /*        lsd.c: 281 */
#define   ELSD016      (ELSDBASE +   16)    /*        lsd.c: 282 */
#define   ELSD017      (ELSDBASE +   17)    /*        lsd.c: 284 */
#define   ELSD018      (ELSDBASE +   18)    /*        lsd.c: 286 */
#define   ELSD019      (ELSDBASE +   19)    /*        lsd.c: 328 */
#define   ELSD020      (ELSDBASE +   20)    /*        lsd.c: 332 */
#define   ELSD021      (ELSDBASE +   21)    /*        lsd.c: 335 */
#define   ELSD022      (ELSDBASE +   22)    /*        lsd.c: 337 */
#define   ELSD023      (ELSDBASE +   23)    /*        lsd.c: 339 */
#define   ELSD024      (ELSDBASE +   24)    /*        lsd.c: 381 */
#define   ELSD025      (ELSDBASE +   25)    /*        lsd.c: 382 */
#define   ELSD026      (ELSDBASE +   26)    /*        lsd.c: 383 */
#define   ELSD027      (ELSDBASE +   27)    /*        lsd.c: 384 */
#define   ELSD028      (ELSDBASE +   28)    /*        lsd.c: 385 */
#define   ELSD029      (ELSDBASE +   29)    /*        lsd.c: 386 */
#define   ELSD030      (ELSDBASE +   30)    /*        lsd.c: 387 */
#define   ELSD031      (ELSDBASE +   31)    /*        lsd.c: 388 */
#define   ELSD032      (ELSDBASE +   32)    /*        lsd.c: 389 */
#define   ELSD033      (ELSDBASE +   33)    /*        lsd.c: 390 */
#define   ELSD034      (ELSDBASE +   34)    /*        lsd.c: 391 */
#define   ELSD035      (ELSDBASE +   35)    /*        lsd.c: 392 */
#define   ELSD036      (ELSDBASE +   36)    /*        lsd.c: 393 */
#define   ELSD037      (ELSDBASE +   37)    /*        lsd.c: 394 */
#define   ELSD038      (ELSDBASE +   38)    /*        lsd.c: 395 */
#define   ELSD039      (ELSDBASE +   39)    /*        lsd.c: 396 */
#define   ELSD040      (ELSDBASE +   40)    /*        lsd.c: 397 */
#define   ELSD041      (ELSDBASE +   41)    /*        lsd.c: 398 */
#define   ELSD042      (ELSDBASE +   42)    /*        lsd.c: 399 */
#define   ELSD043      (ELSDBASE +   43)    /*        lsd.c: 400 */
#define   ELSD044      (ELSDBASE +   44)    /*        lsd.c: 401 */
#define   ELSD045      (ELSDBASE +   45)    /*        lsd.c: 402 */
#define   ELSD046      (ELSDBASE +   46)    /*        lsd.c: 403 */
#define   ELSD047      (ELSDBASE +   47)    /*        lsd.c: 404 */
#define   ELSD048      (ELSDBASE +   48)    /*        lsd.c: 405 */
#define   ELSD049      (ELSDBASE +   49)    /*        lsd.c: 406 */
#define   ELSD050      (ELSDBASE +   50)    /*        lsd.c: 408 */
#define   ELSD051      (ELSDBASE +   51)    /*        lsd.c: 410 */
#define   ELSD052      (ELSDBASE +   52)    /*        lsd.c: 454 */
#define   ELSD053      (ELSDBASE +   53)    /*        lsd.c: 456 */
#define   ELSD054      (ELSDBASE +   54)    /*        lsd.c: 457 */
#define   ELSD055      (ELSDBASE +   55)    /*        lsd.c: 458 */
#define   ELSD056      (ELSDBASE +   56)    /*        lsd.c: 459 */
#define   ELSD057      (ELSDBASE +   57)    /*        lsd.c: 498 */
#define   ELSD058      (ELSDBASE +   58)    /*        lsd.c: 502 */
#define   ELSD059      (ELSDBASE +   59)    /*        lsd.c: 505 */
#define   ELSD060      (ELSDBASE +   60)    /*        lsd.c: 506 */
#define   ELSD061      (ELSDBASE +   61)    /*        lsd.c: 507 */
#define   ELSD062      (ELSDBASE +   62)    /*        lsd.c: 508 */
#define   ELSD063      (ELSDBASE +   63)    /*        lsd.c: 509 */
#define   ELSD064      (ELSDBASE +   64)    /*        lsd.c: 510 */
#define   ELSD065      (ELSDBASE +   65)    /*        lsd.c: 511 */
#define   ELSD066      (ELSDBASE +   66)    /*        lsd.c: 512 */
#define   ELSD067      (ELSDBASE +   67)    /*        lsd.c: 513 */
#define   ELSD068      (ELSDBASE +   68)    /*        lsd.c: 514 */
#define   ELSD069      (ELSDBASE +   69)    /*        lsd.c: 515 */
#define   ELSD070      (ELSDBASE +   70)    /*        lsd.c: 516 */
#define   ELSD071      (ELSDBASE +   71)    /*        lsd.c: 517 */
#define   ELSD072      (ELSDBASE +   72)    /*        lsd.c: 518 */
#define   ELSD073      (ELSDBASE +   73)    /*        lsd.c: 519 */
#define   ELSD074      (ELSDBASE +   74)    /*        lsd.c: 520 */
#define   ELSD075      (ELSDBASE +   75)    /*        lsd.c: 521 */
#define   ELSD076      (ELSDBASE +   76)    /*        lsd.c: 522 */
#define   ELSD077      (ELSDBASE +   77)    /*        lsd.c: 523 */
#define   ELSD078      (ELSDBASE +   78)    /*        lsd.c: 524 */
#define   ELSD079      (ELSDBASE +   79)    /*        lsd.c: 525 */
#define   ELSD080      (ELSDBASE +   80)    /*        lsd.c: 526 */
#define   ELSD081      (ELSDBASE +   81)    /*        lsd.c: 527 */
#define   ELSD082      (ELSDBASE +   82)    /*        lsd.c: 528 */
#define   ELSD083      (ELSDBASE +   83)    /*        lsd.c: 529 */
#define   ELSD084      (ELSDBASE +   84)    /*        lsd.c: 530 */
#define   ELSD085      (ELSDBASE +   85)    /*        lsd.c: 531 */
#define   ELSD086      (ELSDBASE +   86)    /*        lsd.c: 532 */
#define   ELSD087      (ELSDBASE +   87)    /*        lsd.c: 533 */
#define   ELSD088      (ELSDBASE +   88)    /*        lsd.c: 534 */
#define   ELSD089      (ELSDBASE +   89)    /*        lsd.c: 535 */
#define   ELSD090      (ELSDBASE +   90)    /*        lsd.c: 536 */
#define   ELSD091      (ELSDBASE +   91)    /*        lsd.c: 537 */
#define   ELSD092      (ELSDBASE +   92)    /*        lsd.c: 538 */
#define   ELSD093      (ELSDBASE +   93)    /*        lsd.c: 539 */
#define   ELSD094      (ELSDBASE +   94)    /*        lsd.c: 540 */
#define   ELSD095      (ELSDBASE +   95)    /*        lsd.c: 541 */
#define   ELSD096      (ELSDBASE +   96)    /*        lsd.c: 542 */
#define   ELSD097      (ELSDBASE +   97)    /*        lsd.c: 543 */
#define   ELSD098      (ELSDBASE +   98)    /*        lsd.c: 544 */
#define   ELSD099      (ELSDBASE +   99)    /*        lsd.c: 545 */
#define   ELSD100      (ELSDBASE +  100)    /*        lsd.c: 547 */
#define   ELSD101      (ELSDBASE +  101)    /*        lsd.c: 548 */
#define   ELSD102      (ELSDBASE +  102)    /*        lsd.c: 549 */
#define   ELSD103      (ELSDBASE +  103)    /*        lsd.c: 550 */
#define   ELSD104      (ELSDBASE +  104)    /*        lsd.c: 551 */
#define   ELSD105      (ELSDBASE +  105)    /*        lsd.c: 552 */
#define   ELSD106      (ELSDBASE +  106)    /*        lsd.c: 553 */
#define   ELSD107      (ELSDBASE +  107)    /*        lsd.c: 554 */
#define   ELSD108      (ELSDBASE +  108)    /*        lsd.c: 558 */
#define   ELSD109      (ELSDBASE +  109)    /*        lsd.c: 560 */
#define   ELSD110      (ELSDBASE +  110)    /*        lsd.c: 562 */
#define   ELSD111      (ELSDBASE +  111)    /*        lsd.c: 564 */
#define   ELSD112      (ELSDBASE +  112)    /*        lsd.c: 568 */
#define   ELSD113      (ELSDBASE +  113)    /*        lsd.c: 569 */
#define   ELSD114      (ELSDBASE +  114)    /*        lsd.c: 570 */
#define   ELSD115      (ELSDBASE +  115)    /*        lsd.c: 571 */
#define   ELSD116      (ELSDBASE +  116)    /*        lsd.c: 572 */
#define   ELSD117      (ELSDBASE +  117)    /*        lsd.c: 573 */
#define   ELSD118      (ELSDBASE +  118)    /*        lsd.c: 574 */
#define   ELSD119      (ELSDBASE +  119)    /*        lsd.c: 575 */
#define   ELSD120      (ELSDBASE +  120)    /*        lsd.c: 576 */
#define   ELSD121      (ELSDBASE +  121)    /*        lsd.c: 577 */
#define   ELSD122      (ELSDBASE +  122)    /*        lsd.c: 578 */
#define   ELSD123      (ELSDBASE +  123)    /*        lsd.c: 622 */
#define   ELSD124      (ELSDBASE +  124)    /*        lsd.c: 623 */
#define   ELSD125      (ELSDBASE +  125)    /*        lsd.c: 624 */
#define   ELSD126      (ELSDBASE +  126)    /*        lsd.c: 625 */
#define   ELSD127      (ELSDBASE +  127)    /*        lsd.c: 626 */
#define   ELSD128      (ELSDBASE +  128)    /*        lsd.c: 627 */
#define   ELSD129      (ELSDBASE +  129)    /*        lsd.c: 628 */
#define   ELSD130      (ELSDBASE +  130)    /*        lsd.c: 629 */
#define   ELSD131      (ELSDBASE +  131)    /*        lsd.c: 630 */
#define   ELSD132      (ELSDBASE +  132)    /*        lsd.c: 631 */
#define   ELSD133      (ELSDBASE +  133)    /*        lsd.c: 632 */
#define   ELSD134      (ELSDBASE +  134)    /*        lsd.c: 633 */
#define   ELSD135      (ELSDBASE +  135)    /*        lsd.c: 634 */
#define   ELSD136      (ELSDBASE +  136)    /*        lsd.c: 672 */
#define   ELSD137      (ELSDBASE +  137)    /*        lsd.c: 673 */
#define   ELSD138      (ELSDBASE +  138)    /*        lsd.c: 674 */
#define   ELSD139      (ELSDBASE +  139)    /*        lsd.c: 675 */
#define   ELSD140      (ELSDBASE +  140)    /*        lsd.c: 676 */
#define   ELSD141      (ELSDBASE +  141)    /*        lsd.c: 677 */
#define   ELSD142      (ELSDBASE +  142)    /*        lsd.c: 678 */
#define   ELSD143      (ELSDBASE +  143)    /*        lsd.c: 679 */
#define   ELSD144      (ELSDBASE +  144)    /*        lsd.c: 680 */
#define   ELSD145      (ELSDBASE +  145)    /*        lsd.c: 681 */
#define   ELSD146      (ELSDBASE +  146)    /*        lsd.c: 682 */
#define   ELSD147      (ELSDBASE +  147)    /*        lsd.c: 683 */
#define   ELSD148      (ELSDBASE +  148)    /*        lsd.c: 684 */
#define   ELSD149      (ELSDBASE +  149)    /*        lsd.c: 685 */
#define   ELSD150      (ELSDBASE +  150)    /*        lsd.c: 686 */
#define   ELSD151      (ELSDBASE +  151)    /*        lsd.c: 687 */
#define   ELSD152      (ELSDBASE +  152)    /*        lsd.c: 688 */
#define   ELSD153      (ELSDBASE +  153)    /*        lsd.c: 689 */
#define   ELSD154      (ELSDBASE +  154)    /*        lsd.c: 690 */
#define   ELSD155      (ELSDBASE +  155)    /*        lsd.c: 691 */
#define   ELSD156      (ELSDBASE +  156)    /*        lsd.c: 692 */
#define   ELSD157      (ELSDBASE +  157)    /*        lsd.c: 693 */
#define   ELSD158      (ELSDBASE +  158)    /*        lsd.c: 694 */
#define   ELSD159      (ELSDBASE +  159)    /*        lsd.c: 695 */
#define   ELSD160      (ELSDBASE +  160)    /*        lsd.c: 696 */
#define   ELSD161      (ELSDBASE +  161)    /*        lsd.c: 697 */
#define   ELSD162      (ELSDBASE +  162)    /*        lsd.c: 698 */
#define   ELSD163      (ELSDBASE +  163)    /*        lsd.c: 735 */
#define   ELSD164      (ELSDBASE +  164)    /*        lsd.c: 736 */
#define   ELSD165      (ELSDBASE +  165)    /*        lsd.c: 737 */
#define   ELSD166      (ELSDBASE +  166)    /*        lsd.c: 738 */
#define   ELSD167      (ELSDBASE +  167)    /*        lsd.c: 739 */
#define   ELSD168      (ELSDBASE +  168)    /*        lsd.c: 741 */
#define   ELSD169      (ELSDBASE +  169)    /*        lsd.c: 786 */
#define   ELSD170      (ELSDBASE +  170)    /*        lsd.c: 787 */
#define   ELSD171      (ELSDBASE +  171)    /*        lsd.c: 788 */
#define   ELSD172      (ELSDBASE +  172)    /*        lsd.c: 789 */
#define   ELSD173      (ELSDBASE +  173)    /*        lsd.c: 790 */
#define   ELSD174      (ELSDBASE +  174)    /*        lsd.c: 791 */
#define   ELSD175      (ELSDBASE +  175)    /*        lsd.c: 792 */
#define   ELSD176      (ELSDBASE +  176)    /*        lsd.c: 793 */
#define   ELSD177      (ELSDBASE +  177)    /*        lsd.c: 794 */
#define   ELSD178      (ELSDBASE +  178)    /*        lsd.c: 795 */
#define   ELSD179      (ELSDBASE +  179)    /*        lsd.c: 796 */
#define   ELSD180      (ELSDBASE +  180)    /*        lsd.c: 797 */
#define   ELSD181      (ELSDBASE +  181)    /*        lsd.c: 798 */
#define   ELSD182      (ELSDBASE +  182)    /*        lsd.c: 799 */
#define   ELSD183      (ELSDBASE +  183)    /*        lsd.c: 800 */
#define   ELSD184      (ELSDBASE +  184)    /*        lsd.c: 801 */
#define   ELSD185      (ELSDBASE +  185)    /*        lsd.c: 802 */
#define   ELSD186      (ELSDBASE +  186)    /*        lsd.c: 803 */
#define   ELSD187      (ELSDBASE +  187)    /*        lsd.c: 804 */
#define   ELSD188      (ELSDBASE +  188)    /*        lsd.c: 805 */
#define   ELSD189      (ELSDBASE +  189)    /*        lsd.c: 806 */
#define   ELSD190      (ELSDBASE +  190)    /*        lsd.c: 807 */
#define   ELSD191      (ELSDBASE +  191)    /*        lsd.c: 808 */
#define   ELSD192      (ELSDBASE +  192)    /*        lsd.c: 809 */
#define   ELSD193      (ELSDBASE +  193)    /*        lsd.c: 810 */
#define   ELSD194      (ELSDBASE +  194)    /*        lsd.c: 811 */
#define   ELSD195      (ELSDBASE +  195)    /*        lsd.c: 812 */
#define   ELSD196      (ELSDBASE +  196)    /*        lsd.c: 855 */
#define   ELSD197      (ELSDBASE +  197)    /*        lsd.c: 856 */
#define   ELSD198      (ELSDBASE +  198)    /*        lsd.c: 857 */
#define   ELSD199      (ELSDBASE +  199)    /*        lsd.c: 858 */
#define   ELSD200      (ELSDBASE +  200)    /*        lsd.c: 859 */
#define   ELSD201      (ELSDBASE +  201)    /*        lsd.c: 860 */
#define   ELSD202      (ELSDBASE +  202)    /*        lsd.c: 861 */
#define   ELSD203      (ELSDBASE +  203)    /*        lsd.c: 862 */
#define   ELSD204      (ELSDBASE +  204)    /*        lsd.c: 863 */
#define   ELSD205      (ELSDBASE +  205)    /*        lsd.c: 864 */
#define   ELSD206      (ELSDBASE +  206)    /*        lsd.c: 865 */
#define   ELSD207      (ELSDBASE +  207)    /*        lsd.c: 870 */
#define   ELSD208      (ELSDBASE +  208)    /*        lsd.c: 872 */
#define   ELSD209      (ELSDBASE +  209)    /*        lsd.c: 874 */
#define   ELSD210      (ELSDBASE +  210)    /*        lsd.c: 876 */
#define   ELSD211      (ELSDBASE +  211)    /*        lsd.c: 879 */
#define   ELSD212      (ELSDBASE +  212)    /*        lsd.c: 880 */
#define   ELSD213      (ELSDBASE +  213)    /*        lsd.c: 881 */
#define   ELSD214      (ELSDBASE +  214)    /*        lsd.c: 882 */
#define   ELSD215      (ELSDBASE +  215)    /*        lsd.c: 883 */
#define   ELSD216      (ELSDBASE +  216)    /*        lsd.c: 884 */
#define   ELSD217      (ELSDBASE +  217)    /*        lsd.c: 885 */
#define   ELSD218      (ELSDBASE +  218)    /*        lsd.c: 886 */
#define   ELSD219      (ELSDBASE +  219)    /*        lsd.c: 888 */
#define   ELSD220      (ELSDBASE +  220)    /*        lsd.c: 889 */
#define   ELSD221      (ELSDBASE +  221)    /*        lsd.c: 890 */
#define   ELSD222      (ELSDBASE +  222)    /*        lsd.c: 891 */
#define   ELSD223      (ELSDBASE +  223)    /*        lsd.c: 892 */
#define   ELSD224      (ELSDBASE +  224)    /*        lsd.c: 893 */
#define   ELSD225      (ELSDBASE +  225)    /*        lsd.c: 894 */
#define   ELSD226      (ELSDBASE +  226)    /*        lsd.c: 895 */
#define   ELSD227      (ELSDBASE +  227)    /*        lsd.c: 896 */
#define   ELSD228      (ELSDBASE +  228)    /*        lsd.c: 897 */
#define   ELSD229      (ELSDBASE +  229)    /*        lsd.c: 898 */
#define   ELSD230      (ELSDBASE +  230)    /*        lsd.c: 899 */
#define   ELSD231      (ELSDBASE +  231)    /*        lsd.c: 900 */
#define   ELSD232      (ELSDBASE +  232)    /*        lsd.c: 901 */
#define   ELSD233      (ELSDBASE +  233)    /*        lsd.c: 902 */
#define   ELSD234      (ELSDBASE +  234)    /*        lsd.c: 903 */
#define   ELSD235      (ELSDBASE +  235)    /*        lsd.c: 904 */
#define   ELSD236      (ELSDBASE +  236)    /*        lsd.c: 905 */
#define   ELSD237      (ELSDBASE +  237)    /*        lsd.c: 906 */
#define   ELSD238      (ELSDBASE +  238)    /*        lsd.c: 907 */
#define   ELSD239      (ELSDBASE +  239)    /*        lsd.c: 908 */
#define   ELSD240      (ELSDBASE +  240)    /*        lsd.c: 909 */
#define   ELSD241      (ELSDBASE +  241)    /*        lsd.c: 910 */
#define   ELSD242      (ELSDBASE +  242)    /*        lsd.c: 911 */
#define   ELSD243      (ELSDBASE +  243)    /*        lsd.c: 912 */
#define   ELSD244      (ELSDBASE +  244)    /*        lsd.c: 913 */
#define   ELSD245      (ELSDBASE +  245)    /*        lsd.c: 914 */
#define   ELSD246      (ELSDBASE +  246)    /*        lsd.c: 915 */
#define   ELSD247      (ELSDBASE +  247)    /*        lsd.c: 916 */
#define   ELSD248      (ELSDBASE +  248)    /*        lsd.c: 917 */
#define   ELSD249      (ELSDBASE +  249)    /*        lsd.c: 918 */
#define   ELSD250      (ELSDBASE +  250)    /*        lsd.c: 919 */
#define   ELSD251      (ELSDBASE +  251)    /*        lsd.c: 920 */
#define   ELSD252      (ELSDBASE +  252)    /*        lsd.c: 921 */
#define   ELSD253      (ELSDBASE +  253)    /*        lsd.c: 922 */
#define   ELSD254      (ELSDBASE +  254)    /*        lsd.c: 923 */
#define   ELSD255      (ELSDBASE +  255)    /*        lsd.c: 924 */
#define   ELSD256      (ELSDBASE +  256)    /*        lsd.c: 925 */
#define   ELSD257      (ELSDBASE +  257)    /*        lsd.c: 926 */
#define   ELSD258      (ELSDBASE +  258)    /*        lsd.c: 927 */
#define   ELSD259      (ELSDBASE +  259)    /*        lsd.c: 928 */
#define   ELSD260      (ELSDBASE +  260)    /*        lsd.c: 930 */
#define   ELSD261      (ELSDBASE +  261)    /*        lsd.c: 937 */
#define   ELSD262      (ELSDBASE +  262)    /*        lsd.c: 977 */
#define   ELSD263      (ELSDBASE +  263)    /*        lsd.c: 978 */
#define   ELSD264      (ELSDBASE +  264)    /*        lsd.c: 979 */
#define   ELSD265      (ELSDBASE +  265)    /*        lsd.c: 980 */
#define   ELSD266      (ELSDBASE +  266)    /*        lsd.c: 981 */
#define   ELSD267      (ELSDBASE +  267)    /*        lsd.c: 982 */
#define   ELSD268      (ELSDBASE +  268)    /*        lsd.c: 983 */
#define   ELSD269      (ELSDBASE +  269)    /*        lsd.c: 984 */
#define   ELSD270      (ELSDBASE +  270)    /*        lsd.c: 985 */
#define   ELSD271      (ELSDBASE +  271)    /*        lsd.c: 986 */
#define   ELSD272      (ELSDBASE +  272)    /*        lsd.c: 987 */
#define   ELSD273      (ELSDBASE +  273)    /*        lsd.c: 988 */
#define   ELSD274      (ELSDBASE +  274)    /*        lsd.c: 989 */
#define   ELSD275      (ELSDBASE +  275)    /*        lsd.c:1030 */
#define   ELSD276      (ELSDBASE +  276)    /*        lsd.c:1032 */
#define   ELSD277      (ELSDBASE +  277)    /*        lsd.c:1033 */
#define   ELSD278      (ELSDBASE +  278)    /*        lsd.c:1034 */
#define   ELSD279      (ELSDBASE +  279)    /*        lsd.c:1035 */
#define   ELSD280      (ELSDBASE +  280)    /*        lsd.c:1036 */
#define   ELSD281      (ELSDBASE +  281)    /*        lsd.c:1076 */
#define   ELSD282      (ELSDBASE +  282)    /*        lsd.c:1078 */
#define   ELSD283      (ELSDBASE +  283)    /*        lsd.c:1080 */
#define   ELSD284      (ELSDBASE +  284)    /*        lsd.c:1081 */
#define   ELSD285      (ELSDBASE +  285)    /*        lsd.c:1082 */
#define   ELSD286      (ELSDBASE +  286)    /*        lsd.c:1083 */
#define   ELSD287      (ELSDBASE +  287)    /*        lsd.c:1084 */
#define   ELSD288      (ELSDBASE +  288)    /*        lsd.c:1085 */
#define   ELSD289      (ELSDBASE +  289)    /*        lsd.c:1086 */
#define   ELSD290      (ELSDBASE +  290)    /*        lsd.c:1087 */
#define   ELSD291      (ELSDBASE +  291)    /*        lsd.c:1088 */
#define   ELSD292      (ELSDBASE +  292)    /*        lsd.c:1089 */
#define   ELSD293      (ELSDBASE +  293)    /*        lsd.c:1090 */
#define   ELSD294      (ELSDBASE +  294)    /*        lsd.c:1091 */
#define   ELSD295      (ELSDBASE +  295)    /*        lsd.c:1129 */
#define   ELSD296      (ELSDBASE +  296)    /*        lsd.c:1131 */
#define   ELSD297      (ELSDBASE +  297)    /*        lsd.c:1133 */
#define   ELSD298      (ELSDBASE +  298)    /*        lsd.c:1134 */
#define   ELSD299      (ELSDBASE +  299)    /*        lsd.c:1135 */
#define   ELSD300      (ELSDBASE +  300)    /*        lsd.c:1136 */
#define   ELSD301      (ELSDBASE +  301)    /*        lsd.c:1137 */
#define   ELSD302      (ELSDBASE +  302)    /*        lsd.c:1138 */
#define   ELSD303      (ELSDBASE +  303)    /*        lsd.c:1139 */
#define   ELSD304      (ELSDBASE +  304)    /*        lsd.c:1140 */
#define   ELSD305      (ELSDBASE +  305)    /*        lsd.c:1141 */
#define   ELSD306      (ELSDBASE +  306)    /*        lsd.c:1142 */
#define   ELSD307      (ELSDBASE +  307)    /*        lsd.c:1143 */
#define   ELSD308      (ELSDBASE +  308)    /*        lsd.c:1144 */
#define   ELSD309      (ELSDBASE +  309)    /*        lsd.c:1145 */
#define   ELSD310      (ELSDBASE +  310)    /*        lsd.c:1146 */
#define   ELSD311      (ELSDBASE +  311)    /*        lsd.c:1147 */
#define   ELSD312      (ELSDBASE +  312)    /*        lsd.c:1148 */
#define   ELSD313      (ELSDBASE +  313)    /*        lsd.c:1149 */
#define   ELSD314      (ELSDBASE +  314)    /*        lsd.c:1150 */
#define   ELSD315      (ELSDBASE +  315)    /*        lsd.c:1151 */
#define   ELSD316      (ELSDBASE +  316)    /*        lsd.c:1152 */
#define   ELSD317      (ELSDBASE +  317)    /*        lsd.c:1153 */
#define   ELSD318      (ELSDBASE +  318)    /*        lsd.c:1154 */
#define   ELSD319      (ELSDBASE +  319)    /*        lsd.c:1155 */
#define   ELSD320      (ELSDBASE +  320)    /*        lsd.c:1156 */
#define   ELSD321      (ELSDBASE +  321)    /*        lsd.c:1157 */
#define   ELSD322      (ELSDBASE +  322)    /*        lsd.c:1158 */
#define   ELSD323      (ELSDBASE +  323)    /*        lsd.c:1197 */
#define   ELSD324      (ELSDBASE +  324)    /*        lsd.c:1199 */
#define   ELSD325      (ELSDBASE +  325)    /*        lsd.c:1201 */
#define   ELSD326      (ELSDBASE +  326)    /*        lsd.c:1205 */
#define   ELSD327      (ELSDBASE +  327)    /*        lsd.c:1208 */
#define   ELSD328      (ELSDBASE +  328)    /*        lsd.c:1248 */
#define   ELSD329      (ELSDBASE +  329)    /*        lsd.c:1249 */
#define   ELSD330      (ELSDBASE +  330)    /*        lsd.c:1250 */
#define   ELSD331      (ELSDBASE +  331)    /*        lsd.c:1251 */
#define   ELSD332      (ELSDBASE +  332)    /*        lsd.c:1254 */
#define   ELSD333      (ELSDBASE +  333)    /*        lsd.c:1295 */
#define   ELSD334      (ELSDBASE +  334)    /*        lsd.c:1296 */
#define   ELSD335      (ELSDBASE +  335)    /*        lsd.c:1335 */
#define   ELSD336      (ELSDBASE +  336)    /*        lsd.c:1336 */

#endif /* __LSDH_ */
/*sd017.211-addition, RUG*/
#ifdef SD_RUG
#define LSDIFVER           0x0100             /*first version of RUG */
#endif /* SD_RUG*/
 

/********************************************************************30**
  
         End of file: lsd.h 1.10  -  03/01/99 09:58:14
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  mc    1. initial release

1.2          ---  mc    1. checkpoint

1.3          ---  ks    1. prefix added for events for LsdStaInd
                        2. added #def for LSD_SW_CCITT92

1.4          ---  ks    1. changed LSD_SW_CCITT92 to LSD_SW_ITU92

1.5          ---  ks    1. added codes for LsdStaInd primitive
             ---  ks    2. change copyright header

*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.6          ---      ash  1. generate management indications for success
                              /failure of control requests 
1.7          ---      ash  1. More status indications added for 
                              debugging 
                           2. Event defines EVTLSDCFGCFM and EVTLSDCNTRLCFM
                              are added for LMINT3
                           3. More changes for LMINT3
                           4. Added defines for LSD_SW_ANSI88 and 
                              LSD_SW_ANSI92
1.8          ---      sr   1. Error codes added.

1.9          ---      ash  1. Changes to support TTC
             ---      cp   2. Replaced #ifdef TTC with #if (SS7_TTC)  

1.10         ---      ash  1. Added LSD_SW_NTT
                           2. changed error codes 
             sd017.211 yz  3. Support rolling upgrade.              
             sd027.211 aks 1. Support For High speed signaling link
                           2. MSU data sent in Trace indication for Low speed 
                              signaling link
                           3. Stopping all timers during shutdown 
*********************************************************************91*/
