/********************************************************************16**

        (c) COPYRIGHT 1989-2002 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     layer management interface - driver (ry)
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               layer management service user.

     File:     lry.x

     Sid:      lry.x@@/main/4 - Fri Oct 29 17:19:24 2010
  
     Prg:      fmg
  
*********************************************************************21*/

#ifndef __LRYX__
#define __LRYX__

#ifdef __cplusplus
extern "C" {
#endif 

/* typedefs */


#ifdef LRY1
/* ry006.101 : 94792 Relay Patch Changes - Socket Options. */
typedef struct _rySockOpts
{
  U32 level;
  U32 option;
  U32 val;
}RySockOpts;

typedef struct _rySockParam
{
  U8           nmbOpts;
  RySockOpts   rySockOpts[LRY_MAX_SOCK_OPTS];
}RySockParam;

#endif /* LRY1 */


/* general configuration structure */
typedef struct ryGenCfg
{
   U32 nmbChan;                /* number of regions */
   S16 tmrRes;                 /* timer resolution */
   /* lry_x_001.main_2 */
   Bool usta;                  /* unsolicited status */
   Pst lmPst;                  /* Post structure for layer manager */
} RyGenCfg;
 
typedef struct ryChanCfg
{
   U16 id;                      /* channel id */
   U16 type;                    /* channel type */
   U16 msInd;                   /* master/slave indicator */
   U16 propErr;                 /* propogate errors? */
   ProcId low;                  /* low proc id for channel */
   ProcId high;                 /* high proc id for channel */
   PTR strtAddr;                /* start address */
   U32 memSize;                 /* memory size */
   S16 nmbScanQ;                /* number of times to scan the queue */
   U16 flags;                   /* flags */
   S16 congThrsh;               /* congestion threshold */
   S16 dropThrsh;               /* drop threshold */
   S16 contThrsh;               /* continue threshold */
   S16 poolSize;                /* size of pool (n bufs) */
   TmrCfg kaTxTmr;              /* keep alive transmit timer config */
   TmrCfg kaRxTmr;              /* keep alive receive timer config */
   TmrCfg btTmr;                /* boot timer */
   /* Addition for II generation relay */
#ifdef RY_ENBS5SHM
   U32 key;                     /* Shared Memory key*/
#endif /* RY_ENBS5SHM */
   U32 shMemBase;               /* shared memory base address */
   U32 shMemSize;               /* shared memory size */
   U32 shCcbOff;                /* shared memory CCB offset from base addr */
   U16 txTblSize;               /* Transmit table size */
   U16 rxTblSize;               /* Receive talble size */

#if (RY_ENBUDPSOCK || RY_ENBTCPSOCK) 
   /* foll 4 are Additions for UDP Socket implementation */
   U32 listenPortNo;            /* Listen Port of Rx Relay Channel*/
   /*lry_x_001.main_1 - Allow source address configuration for relay channels*/
#ifdef LRYV2
   S8  selfHostName[RY_REMHOSTNAME_SIZE];
#endif /* LRY2 */
   S8  transmittoHostName[RY_REMHOSTNAME_SIZE];
                            /* TransmitTo HostName for Tx Relay Channel */
   U32 transmittoPortNo;    /* TransmitTo PortId for Tx Relay Channel */
   ProcId targetProcId;     /* procId of the node present in the other */
                            /* end of this channel                     */
#ifdef LRY1
  /* Relay Patch Changes */
   RySockParam sockParam;   /* Socket Parameters */
#endif /* LRY1 */
   
#endif /* RY_ENBUDPSOCK || RY_ENBTCPSOCK */

#if (RY_ENBNTUK || RY_ENBNTKH)
   U8  deviceName[LRY_NT_DEVNAME_LEN]; /* device name for Windows NT 
                                        * User-Kernel and K-H relay */
#endif /* (RY_ENBNTUK || RY_ENBNTKH) */

#ifdef RY_ENBNTKH
   U8  boardId;                        /* board number */
#endif /* RY_ENBNTKH */
   Region region;               /* Relay region */
   Pool pool;                   /* Relay pool */

} RyChanCfg;

/* memory region statistics structure */
typedef struct ryChanSts
{
   Cntr txMsg;                  /* transmited messages */
   Cntr rxMsg;                  /* received messages */
   S16 minSize;                 /* minimum size */
   S16 maxSize;                 /* maximum size */
} RyChanSts;

/* queue statistics structure */
typedef struct ryQueSts
{
   Cntr rxEmptyCnt;            /* receive  empty count */
   Cntr rxNotEmptyCnt;         /* receive  not empty count */
   S16  rxSize;                /* receive  demand queue size */
   Cntr txEmptyCnt;            /* transmit empty count */
   Cntr txNotEmptyCnt;         /* transmit not empty count */
   S16  txSize;                /* transmit demand queue size */
} RyQueSts;


/* status structure */
typedef struct rySta
{
   U16 cStatus;                 /* channel status */
}RySta;

typedef struct ryErrUsta
{
   ProcId sendPid;              /* sending processor  */
   ProcId errPid;               /* error processor id */
   U16 id;                      /* channel id         */
   Seq sequence;                /* sequence           */
   Reason reason;               /* reason             */
}RyErrUsta;

typedef struct ryCongUsta
{
   ProcId sendPid;              /* sending processor id       */
   ProcId remPid;               /* remote processor id        */
   U16 id;                      /* channel id                 */
   Status status;               /* congestion status (ChkRes) */
   U16  flags;                  /* congestion flags           */
}RyCongUsta;

typedef struct ryUpUsta
{
   ProcId sendPid;              /* sending processor id       */
   U16 id;                      /* channel id                 */
}RyUpUsta;

/* lry_x_001.main_2 - 107162: Tcp connect failed usta */
typedef struct ryTcpConnUsta
{
   ProcId         sendPid;      /* sending processor  */
   ProcId         errPid;       /* error processor id */
   U16            id;           /* channel id         */
   U16            port;         /* remote port        */
   U32            address;      /* remote address     */
   Reason         reason;       /* reason             */
}RyTcpConnUsta;
/* management message structure */

typedef struct ryMngmt
{
   Header hdr;                     /* header */
   CmStatus cfm;                   /* primitive status/cfms */
   union 
   {
      struct                         /* configuration */
      {
         union
         {
            RyGenCfg  ryGenCfg;      /* relay general config */
            RyChanCfg ryChanCfg;     /* relay channel config */
         } s; 
      } cfg;                         /* end configuration */
      struct                         /* statistics */
      {
         DateTime dt;                /* date and time */
         Duration dura;              /* duration */
         union
         {
            RyChanSts ryChanSts;     /* Driver channel statistics */
            RyQueSts  ryQueSts;      /* Driver queue statistics */
        } s;
      } sts;                         /* end statistics */

      struct                         /* solicited status */
      {
         DateTime dt;                /* date and time */
         RySta rySta;                /* Status */
      } ssta;                        /* end solicited status */
      struct                         /* unsolicited status */
      {
         DateTime dt;                /* date and time */
         union
         {
            RyErrUsta ryErrUsta;     /* error alarm */
            RyCongUsta ryCongUsta;   /* congestion alarm */
            RyUpUsta ryUpUsta;       /* channel up alarm */
            /* 107162: Tcp connect failed usta */
            /* lry_x_001.main_2 */
            RyTcpConnUsta ryTcpConnUsta;
         }s;
      } usta;                        /* end unsolicited status */
      struct                         /* control */
      {
         DateTime dt;                /* date and time */
         U8 action;                  /* action */
         U8 subAction;               /* sub action */

         /* lry_x_001.main_3 - Debug print enhancements */
#ifdef DEBUGP
         U32 dbgMask;
#endif
      } cntrl;                       /* end control */
  
   }t;
} RyMngmt;


/*
 * depending on the specific selector in the post structure,
 * a primitive originated from a service provider can be diryatched to
 * any service user. The assumption is that, even if every primitive has
 * a different name depending in which file it resides, every primitive
 * must have the same function prototype, i.e. the same identical set
 * of arguments. These arguments are defined here 
 */
 
typedef S16 (*LryStaInd)   ARGS((Pst *pst, RyMngmt *sta));
typedef S16 (*LryStaCfm)   ARGS((Pst *pst, RyMngmt *sta));
typedef S16 (*LryStsCfm)   ARGS((Pst *pst, Action action, RyMngmt *sts));
typedef S16 (*LryCfgReq)   ARGS((Pst *pst, RyMngmt *cfg));
typedef S16 (*LryStaReq)   ARGS((Pst *pst, RyMngmt *sta));
typedef S16 (*LryStsReq)   ARGS((Pst *pst, Action action, RyMngmt *sts));
typedef S16 (*LryCntrlReq) ARGS((Pst *pst, RyMngmt *cntrl));
typedef S16 (*LryCfgCfm)   ARGS((Pst *pst, RyMngmt *cfg));
typedef S16 (*LryCntrlCfm)   ARGS((Pst *pst, RyMngmt *cntrl));
 
#ifdef SM
EXTERN S16 SmMiLryStsCfm     ARGS((Pst *pst, Action action, RyMngmt *sts));
EXTERN S16 SmMiLryStaInd     ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 SmMiLryStaCfm     ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 SmMiLryStsReq     ARGS((Pst *pst, Action action, RyMngmt *sts));
EXTERN S16 SmMiLryStaReq     ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 SmMiLryCfgReq     ARGS((Pst *pst, RyMngmt *cfg));
EXTERN S16 SmMiLryCntrlReq   ARGS((Pst *pst, RyMngmt *cntrl));
EXTERN S16 SmMiLryCfgCfm     ARGS((Pst *pst, RyMngmt *cfg));
EXTERN S16 SmMiLryCntrlCfm     ARGS((Pst *pst, RyMngmt *cntrl));
#endif

#ifdef RY                          /* SCCP */
EXTERN S16 RyMiLryCfgReq     ARGS((Pst *pst, RyMngmt *cfg));
EXTERN S16 RyMiLryStaReq     ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 RyMiLryStsReq     ARGS((Pst *pst, Action action, RyMngmt *sts));
EXTERN S16 RyMiLryCntrlReq   ARGS((Pst *pst, RyMngmt *cntrl));
EXTERN S16 RyMiLryStaInd     ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 RyMiLryStaCfm     ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 RyMiLryStsCfm     ARGS((Pst *pst, Action action, RyMngmt *sts));
EXTERN S16 RyMiLryCfgCfm     ARGS((Pst *pst, RyMngmt *cfg));
EXTERN S16 RyMiLryCntrlCfm     ARGS((Pst *pst, RyMngmt *cntrl));
#ifdef RY_ACC
EXTERN S16 ryAccCfgCfm       ARGS((Pst *pst, RyMngmt *usta));
EXTERN S16 accChanUpDn       ARGS((Pst *pst, RyMngmt *usta));
#endif
#endif

/* relay  initialization function */
EXTERN S16 ryActvInit ARGS((Ent entity, Inst inst, Region region,
        Reason reason));
/* relay actvivation function */
EXTERN S16 ryActvTsk           ARGS((Pst *pst, Buffer *mBuf));

/* stack manager initialization function */
EXTERN S16 smRyActvInit ARGS((Ent ent, Inst inst, 
                              Region region, Reason reason));

/* stack manager activation function */
EXTERN S16 smRyActvTsk ARGS((Pst *pst, Buffer *mBuf));

#ifdef LCLRY
EXTERN S16 cmPkMiLryStaInd ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 cmPkMiLryStaCfm ARGS((Pst *pst, RyMngmt *sta));
EXTERN S16 cmPkMiLryStsCfm ARGS((Pst *pst, Action action, RyMngmt *sts));
EXTERN S16 cmPkMiLryCfgCfm ARGS((Pst *pst, RyMngmt *cfg));
EXTERN S16 cmPkMiLryCntrlCfm ARGS((Pst *pst, RyMngmt *cntrl));
EXTERN S16 cmUnpkRyMiLryCntrlReq ARGS((LryCntrlReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkRyMiLryStsReq ARGS((LryStsReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkRyMiLryStaReq ARGS((LryStaReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkRyMiLryCfgReq ARGS((LryCfgReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkMiLryStaCfm ARGS((LryStaCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkMiLryCfgCfm ARGS((LryCfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkMiLryCntrlCfm ARGS((LryCntrlCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkMiLryStaInd ARGS((LryStaInd func,Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkMiLryStsCfm ARGS((LryStsCfm func, Pst *pst, Buffer *mBuf));
#endif

#ifdef LCSMRYMILRY
EXTERN S16 cmPkMiLryCfgReq   ARGS((Pst *pst, RyMngmt *cfg ));
EXTERN S16 cmPkMiLryStaReq   ARGS((Pst *pst, RyMngmt *sta ));
EXTERN S16 cmPkMiLryStsReq   ARGS((Pst *pst, Action action, RyMngmt *sts ));
EXTERN S16 cmPkMiLryCntrlReq ARGS((Pst *pst, RyMngmt *cntrl ));
#endif
 
#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LRYX__ */


/********************************************************************30**
  
         End of file:     lry.x@@/main/4 - Fri Oct 29 17:19:24 2010
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

*********************************************************************81*/

/********************************************************************90**
 
    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
/main/1      ---    vd   1. Initial Release of Block mode TCP and UDP.
           ry006.101  ps  1. Relay patch changes - Socket Options.
           lry_x_001.main_1  rsharon  1.Allow source address configuration for 
	                         relay channels.
/main/3  lry_x_001.main_2  rkumar      1. Added Tcp connect failed usta handling
/main/4  lry_x_001.main_3  gjahagirdar 1. Debug print enhancements - added TAPA standard
                                          debug mask levels and provided configurability 
                                          through layer manager.
*********************************************************************91*/

