/********************************************************************16**

        (c) COPYRIGHT 1989-2002 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     driver management header     
  
     Type:     C include file
  
     Desc:     defines for driver layerm management interface
 
     File:     lry.h

     Sid:      lry.h@@/main/5 - Wed Nov  3 12:40:14 2010
  
     Prg:      fmg
  
*********************************************************************21*/

#ifndef __LRYH__
#define __LRYH__

  
/* flags */
#define LRY_FLG_POLL 0
#define LRY_FLG_INTR 1

/* lry_h_001.main_3: Enahancement for relay debug prints techniques */
#ifdef DEBUGP
#define RY_DBG_INFO  (DBGMASK_LYR << 0)
#define RY_DBG_DEBUG (DBGMASK_LYR << 1)
/* #define RY_DBG_PARAM (DBGMASK_LYR << 2) Not used in relay */
#define RY_DBG_ERROR (DBGMASK_LYR << 3)
#define RY_DBG_FATAL (DBGMASK_LYR << 4)
#endif /* DEBUGP */
#ifdef LRY1
/* ry006.101 : 94792 Relay Patch Changes - Socket Options.  */
#define LRY_MAX_SOCK_OPTS          5
#define LRY_MAX_OPTVAL_ALLOWED     2
#define LRY_REASON_INVALID_OPT     LCM_REASON_LYR_SPECIFIC+1   /* Invalid option level in cfg */    
#endif /* LRY1 */

/* selectors... */
#define LRY_SEL_LC  0
#define LRY_SEL_TC  1


/* driver region types */
#define LRY_NMB_TYPES  13       /*number of types */

#define LRY_CT_RAW         0         /* raw shared memory */
#define LRY_CT_BIT3        1         /* bit3 shared memory */
#define LRY_CT_HST         1         /* hst shared memory */
#define LRY_CT_S5SHM       2         /* system 5 shared memory */
#define LRY_CT_S5MSG       3         /* system 5 message queue */
#define LRY_CT_IMP         4         /* imp shared memory */
#define LRY_CT_MMAP        5         /* shared memory (through mmap) */
#define LRY_CT_USOCK       6         /* udp sockets */
#define LRY_CT_TCP_LISTEN  7         /* udp sockets */
#define LRY_CT_TCP_SERVER  8         /* udp sockets */
#define LRY_CT_TCP_CLIENT  9         /* udp sockets */
#define LRY_CT_NTMMAP     10         /* Windows NT User-App mmap relay */
#define LRY_CT_NTUK       11         /* Windows NT User-Kernel relay */
#define LRY_CT_NTKH       12         /* NT kernel-hardware  relay */


/* maximum entities/channel */
#define LRY_MAXENT    8

#ifdef RY_ENBUDPSOCK
#undef RY_ENBUDPSOCK
#define RY_ENBUDPSOCK    1 
#endif /* RY_ENBUDPSOCK */ 

#ifdef RY_ENBTCPSOCK
#undef RY_ENBTCPSOCK
#define RY_ENBTCPSOCK    1 
#endif /* RY_ENBTCPSOCK */ 

/* driver master slave types */
#define LRY_MS_MASTER 0
#define LRY_MS_SLAVE  1

/* channel status */
#define LRY_CSTA_UP       0      /* channel up */
#define LRY_CSTA_BT       1      /* channel boot received */
#define LRY_CSTA_CG       2      /* channel congestion */
#define LRY_CSTA_DP       3      /* channel dropping */
#define LRY_CSTA_DN       4      /* channel down */
#define LRY_CSTA_CR       5      /* channel crashed */
#define LRY_CSTA_PV       6      /* channel proving stage */
#define LRY_CSTA_WT       7      /* channel waiting stage */
#define LRY_CSTA_RC       8      /* lry_h_001.main_1: 100178 channel recover stage */

/* filter status */
#define LRY_FSTA_OFF     0       /* filter is off */
#define LRY_FSTA_ACTIVE  1       /* filter is active */
#define LRY_FSTA_STANDBY 2       /* filter is standby */

/* filter flags */
#define LRY_FLG_NIL 0           /* do nothing */
#define LRY_FLG_DUP 1           /* duplicate message to peer */
#define LRY_FLG_HLD 2           /* hold messages */

/* congestion flags */
#define LRY_CONG_NONE 0
#define LRY_CONG_CONG 1
#define LRY_CONG_DROP 2

/* RUG Interface number */
#define LRYIFVER              0x0100 /* interface version 1.0 */

#if (defined(RY_ENBNTUK) || defined(RY_ENBNTKH))
#define LRY_NT_DEVNAME_LEN    255   /* device name of a windows NT driver */
#endif /* (RY_ENBNTUK || RY_ENBNTKH) */

/* error sequences */
#define LRYSEQXXX        0xff   /* rySendKeepAlive    */
#define LRYSEQ000        0      /* rySendKeepAlive    */
#define LRYSEQ001        1      /* ryChanCbTmrEvnt    */
#define LRYSEQ002        2      /* ryLock             */
#define LRYSEQ003        3      /* ryPstTskBit3       */
#define LRYSEQ004        4      /* ryPstTskBit3       */
#define LRYSEQ005        5      /* ryGetTskBit3       */
#define LRYSEQ006        6      /* ryGetTskBit3       */
#define LRYSEQ007        7      /* ryGetTskBit3       */
#define LRYSEQ008        8      /* ryGetDBufBit3      */
#define LRYSEQ009        9      /* ryGetDBufBit3      */
#define LRYSEQ010        10     /* ryPutDBufBit3      */
#define LRYSEQ011        11     /* ryPutDBufBit3      */
#define LRYSEQ012        12     /* ryGetMsgBit3       */
#define LRYSEQ013        13     /* ryGetMsgBit3       */
#define LRYSEQ014        14     /* ryPutMsgBit3       */
#define LRYSEQ015        15     /* ryPutMsgBit3       */
#define LRYSEQ016        16     /* ryChkResBit3       */
#define LRYSEQ017        17     /* ryChkResBit3       */
#define LRYSEQ018        18     /* ryCpyMsgInBit3     */
#define LRYSEQ019        19     /* ryCpyMsgInBit3     */
#define LRYSEQ020        20     /* ryCpyMsgOutBit3    */
#define LRYSEQ021        21     /* ryCpyMsgOutBit3    */
#define LRYSEQ022        22     /* ryCpyMsgBit3Bit3   */
#define LRYSEQ023        23     /* ryCpyMsgBit3Bit3   */
#define LRYSEQ024        24     /* ryCpyMsgBit3Bit3   */
#define LRYSEQ025        25     /* ryCpyMsgBit3Bit3   */
#define LRYSEQ026        26     /* ryQueTskBit3       */
#define LRYSEQ027        27     /* ryQueTskBit3       */
#define LRYSEQ028        28     /* ryCpyMsgBit3S5shm  */
#define LRYSEQ029        29     /* ryCpyMsgBit3S5shm  */
#define LRYSEQ030        30     /* ryCpyMsgS5shmBit3  */
#define LRYSEQ031        31     /* ryCpyMsgS5shmBit3  */
#define LRYSEQ032        32     /* ryInitChanBit3 */
#define LRYSEQ033        33     /* ryInitChanBit3 */
#define LRYSEQ034        34     /* ryInitChanBit3 */
#define LRYSEQ035        35     /* ryInitPstTskBit3 */
#define LRYSEQ036        36     /* ryActvDrvrTsk */
#define LRYSEQ037        37     /* ryPstTskRaw */
#define LRYSEQ038        38     /* ryPstTskBit3 */
#define LRYSEQ039        39     /* ryGetTskRaw */
#define LRYSEQ040        40     /* ryGetTskBit3 */
#define LRYSEQ041        41     /* ryGetTskS5Msg */
#define LRYSEQ042        42     /* ryryInitChanBit3SRII */
#define LRYSEQ043        43     /* ryInitChanRawSRII */
#define LRYSEQ044        44     /* ryCpyDmRmS */
#define LRYSEQ045        45     /* ryCpyDmRmS */
#define LRYSEQ046        46     /* ryCpyDmMmS */
#define LRYSEQ047        47     /* ryCpyDmMmS */
#define LRYSEQ048        48     /* ryDequeMmM */
#define LRYSEQ049        49     /* ryDequeMmM */
#define LRYSEQ050        50     /* ryGetTskRII */
#define LRYSEQ051        51     /* ryPstTskRII */
#define LRYSEQ052        52     /* ryDequeMmM */
#define LRYSEQ053        53     /* ryGetTskRII */
#define LRYSEQ054        54     /* ryCpyMsgS5msgBit3RII */
#define LRYSEQ055        55     /* ryCpyMsgS5msgBit3RII */

/* reason codes */
#define LRYRSNPF           0     /* reason: post failed */
#define LRYRSNKARX         1     /* reason: keep alive rx expired */
#define LRYRSNLCKFAIL      2     /* reason: lock failed */
#define LRYRSNB3LCKFAIL    3     /* reason: bit3 lock failed */
#define LRYRSNB3UNLCKFAIL  4     /* reason: bit3 unlock failed */
#define LRYRSNHSTLCKFAIL   5     /* reason: hst lock failed */
#define LRYRSNHSTUNLCKFAIL 6     /* reason: hst unlock failed */
#define LRYRSNNOROUTE      7     /* reason: no route */
#define LRYRSNREMDOWN      8     /* reason: remote down */
#define LRYRSNBRDFAIL      9     /* reason: board failure */
#define LRYRSNMGMTREQ      10    /* reason: management request */
#define LRYRSNHSTSHMEMFAIL 11    /* reason: hst shared memory init failed. */
#define LRYRSNRAWSHMEMFAIL 12    /* reason: raw shared memory init failed. */
#define LRYRSNNOTFIRSTBD   13    /* reason: not a first buffer descriptor */
#define LRYRSNEMPTYBD      14    /* reason: empty buffer descriptor */
#define LRYRSNWRONGSTATE   15    /* reason: wrong state */
#define LRYRSNB3SHMEMFAIL  16    /* reason: b3 shared memory init failed */
#define LRYRSNKHSHMEMFAIL  17    /* reason: KH shared memory init failed. */
#define LRYRSNS5SHMMEMFAIL 18    /* reason: Sys V shared memory init failed. */
/* lry_h_001.main_4: Adding new USTA reason */
#define LRYRSNNOSRVRCFG    19    /* reason: Server not configured (USTA). */


#define LRY_MAXRYMI 2           /* maximum mangement interfaces */

/* Stack Manger Interface Events */
#define EVTLRYCFGREQ 0x3c       /* configuration request */

#define EVTLRYSTAREQ   0x40     /* status request */
#define EVTLRYSTACFM   0x41     /* status confirm */
#define EVTLRYSTAIND   0x42     /* status indication */

#define EVTLRYSTSREQ   0x44     /* statistics request */
#define EVTLRYSTSCFM   0x45     /* statistics confirm */

#define EVTLRYSHUTREQ  0x4a     /* lry_h_001.main_1: 100178 shutdown request to main thread */
#define EVTLRYSHUTCFM  0x4b     /* lry_h_001.main_1: 100178 shutdown control confirm */

#define EVTLRYCNTRLREQ 0x4c     /* control request */
#define EVTLRYCFGCFM 0x4d       /* configuration confirm */
#define EVTLRYCNTRLCFM 0x4e       /* configuration confirm */

#define STCHSTS      0x30       /* channel statistics */
#define STQUSTS      0x31       /* queue statistics */
#define STFISTS      0x32       /* filter statistics */

#define STCHSTA      0x40       /* channel statistics */

#define STCHCFG      0x50       /* channel configuration */
#define STSMCFG      0x51       /* stack manager configuration */

#define LRY_USTA_ERR  0x10      /* unsolicited status - error */
#define LRY_USTA_CNG  0x20      /* unsolicited status - congestion */
#define LRY_USTA_UP   0x40      /* unsolicited status - up */
#define LRY_USTA_DN   0x50      /* unsolicited status - down */
/* lry_h_001.main_2 */
#define LRY_USTA_TCP_CONN_FAILED  0x60  /* 107162: unsolicited status - connect failed */

#define LRY_CHAN_ID0   0         /* channel id */
#define LRY_CHAN_ID1   1         /* channel id */
#define LRY_CHAN_ID2   2         /* channel id */
#define LRY_CHAN_ID3   3         /* channel id */
#define LRY_CHAN_ID4   4         /* channel id */
#define LRY_CHAN_ID5   5         /* channel id */

#define ACTVTHRD        2        /* receive thread activation */
#define RY_REMHOSTNAME_SIZE 32


#define LRYLOGSRCERROR(errCls, errCode, errVal, errDesc) \
        SLogError(pst->srcEnt, pst->srcInst, pst->srcProcId, \
                  __FILE__, __LINE__, errCls, errCode, errVal,\
                  errDesc)
#define LRYLOGDSTERROR(errCls, errCode, errVal, errDesc) \
        SLogError(pst->dstEnt, pst->dstEnt, pst->dstProcId, \
                  __FILE__, __LINE__, errCls, errCode, errVal,\
                  errDesc)
#define ELRYXXX         1
#endif /* __LRYH__ */

  
/********************************************************************30**
  
         End of file:     lry.h@@/main/5 - Wed Nov  3 12:40:14 2010
  
*********************************************************************31*/
  
  
/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/
  
  
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

*********************************************************************81*/

/********************************************************************90**
 
    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
/main/1      ---    vd   1. Initial Release of Block mode TCP and UDP.
           ry006.101  ps   1.Relay patch changes - Socket options.
/main/2      ---  lry_h_001.main_1  ve  1. channel recover stage.
                                        2. shutdown request to main thread
                                        3. shutdown control confirm
/main/3      lry_h_001.main_2  rkumar  1. Added MACRO for unsolicited status
                                           - connect failed, LRY_USTA_TCP_CONN_FAILED 
/main/4      lry_h_001.main_3  gjahagirdar 1. Debug print enhancements - added TAPA standard
                                                   debug mask levels and provided configurability 
                                                   layer manager.
/main/5      lry_h_001.main_4  gjahagirdar 1. Adding new USTA reason
*********************************************************************91*/
