/********************************************************************16**

                         (c) COPYRIGHT 1989-2003 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**

     Name:    M2UA-NIF Layer (M2UA)

     Type:    Header File 

     Desc:    Typedef's for NIF-LM Interface 

     File:    lnw.x

     Sid:      lnw.x@@/main/2 - Wed Aug 13 12:02:44 2003

     Prg:     

*********************************************************************21*/

#ifndef __LNWX__
#define __LNWX__

#ifdef __cplusplus
extern "C" {
#endif
 
/* M2UA-NIF  Statistics  Counter */
typedef U32 NwStsCntr;

/* Typedef for Data Statistics of M2UA-NIF  */
typedef struct _nwDataSts
{
    NwStsCntr     nmbPdus;        /* Number of Packets */
    NwStsCntr     nmbBytes;       /* Number of Bytes */
} NwDataSts;

/* nwGenCfg structure */
typedef struct _nwGenReCfg
{
   Pst    smPst;       /* stack manager post structure */
   U32    maxNmbRetry; /* max number of retry attemps  */
   TmrCfg tmrRetry;    /* Primitive retry timer        */
} NwGenReCfg;

typedef struct _nwGenCfg  /* M2UA-NIF general configuration*/
{
   U32  maxNmbDlSap;      /* number of lower SAPs         */
   S16  timeRes;          /* timer resolution             */
   NwGenReCfg reConfig;   /* reconfiguration parameters   */
} NwGenCfg;

/* DL Sap configuration */
typedef struct _nwDlSapReCfg
{
   Pst         m2uaPst;     /* Post structure to M2UA     */
   Pst         mtp2Pst;     /* Post structure to MTP2     */
} NwDlSapReCfg;

typedef struct _nwDlSapCfg      /* M2UA upper SAP configuration */
{
   SuId         suId;
   LnkNmb       m2uaLnkNmb;    /* spId for M2UA SAP  */
   LnkNmb       mtp2LnkNmb;    /* spId for MTP2 SAP  */
   NwDlSapReCfg reConfig;      /* reconfiguration structure */
} NwDlSapCfg;

typedef struct _nwCfg             /* Configuration */
{
   union
   {
      NwGenCfg         genCfg;    /* M2UA General config */
      NwDlSapCfg       dlSapCfg;  /* M2UA Upper SAP config */
   } s;
} NwCfg;

typedef struct _nwCntrl  /* Control */
{
   DateTime        dt;        /* date and time */
   Action          action;    /* action */
   Action          subAction; /* sub action */
   Ent             entity;    /* Entity of operation */
   SuId            suId;      /* Service user SAP ID */
#ifdef DEBUGP
   U32             dbgMask;   /* Debug Mask */
#endif
} NwCntrl;

typedef struct _nwGenSta
{
   U32          memSize;         /* Reserved memory size */
   U32          memAlloc;        /* Allocated memory size */
} NwGenSta;

typedef struct _nwDlSapSta
{
   U8           m2uaState;        /* SAP state towards M2UA */
   U8           mtp2State;        /* SAP state towards MTP2 */
   U32          nmbRetry;         /* Number of Bnd retries */
} NwDlSapSta;

typedef struct _nwSsta      /* Solicited status */
{
   DateTime   dt;           /* date and time */
   SuId       suId;         /* Service user SAP ID */
   struct
   {
     SystemId    sysId;     /* System Id */
     NwGenSta    genSta;    /* M2UA General status */
     NwDlSapSta  dlSapSta;  /* M2UA Upper SAP status */
   } s;
} NwSsta;

typedef struct _nwDlSapSts   /* M2UA Statistics for DLSAP */
{
   DateTime      dt;         /* date+time when statistical 
                                counters are initialized to 0 */
   NwDataSts     rxPduSts;   /* Total Number of PDU's - RX */
   NwDataSts     txPduSts;   /* Total Number of PDU's - TX */
   NwStsCntr     primGen;    /* Number of Primitive generated by NIF */
} NwDlSapSts;


typedef struct _nwGenSts     /* M2UA general statistics */
{
   DateTime      dt;         /* date and time when statistics    *
                              * counters are initialized to zero */
   NwDataSts     rxPduSts;   /* Total Number of PDU's - RX */
   NwDataSts     txPduSts;   /* Total Number of PDU's - TX */
   NwStsCntr     primGen;    /* Number of Primitive generated by NIF */
} NwGenSts;

typedef struct _nwSts           /* Statistics */
{
   DateTime     dt;             /* Current date and time */
   Duration     dura;           /* duration as date and time */
   SuId         suId;           /* Service user SAP ID */
   union
   {
      NwGenSts     genSts;      /* M2UA general statistics */
      NwDlSapSts   dlSapSts;    /* M2UA DLSAP statistics */
   } u;
} NwSts;

/* M2UA Alarm Structure */

typedef struct _nwUsta          /* Unsolicited status */
{
   CmAlarm       alarm;         /* Common Alarm Structure */
   SuId          suId;          /* SCT SAP ID */
} NwUsta;

/* M2UA Trace structure */

typedef struct _nwTrc           /* Trace */
{
   DateTime   dt;               /* date and time */
   SuId       suId;             /* DL SAP Id */
   U16        evnt;             /* event */
   U16        len;              /* trace length */
   U8         evntParm[LNW_MAX_TRC_LEN];  /* event parameters */
} NwTrc;

/* Management structure */

typedef struct _nwMgmt
{
   Header     hdr;              /* header */
   CmStatus   cfm;              /* Confirm */
   union
   {
      NwCfg   cfg;              /* configuration */
      NwCntrl cntrl;            /* control */
      NwSsta  ssta;             /* solicited status */
      NwSts   sts;              /* statistics */
      NwUsta  usta;             /* unsolicited status */
      NwTrc   trc;              /* trace */
   } t;
} NwMgmt;

/*
 * Depending on the specific selector in the post structure, a
 * primitive originated from a service provider can be dispatched
 * to any service user. The assumption is that, even if every
 * primitive has a different name depending in which file it
 * resides, every primitive must have the same function prototype,
 * i.e. the same identical set of arguments. These arguments are
 * defined here:
 */

typedef S16 (*LnwCfgReq)   ARGS((Pst *pst, NwMgmt *cfg));
typedef S16 (*LnwCntrlReq) ARGS((Pst *pst, NwMgmt *cntrl));
typedef S16 (*LnwStaReq)   ARGS((Pst *pst, NwMgmt *sta));
typedef S16 (*LnwStsReq)   ARGS((Pst *pst, Action action, NwMgmt *sts));

typedef S16 (*LnwCfgCfm)   ARGS((Pst *pst, NwMgmt *cfm));
typedef S16 (*LnwCntrlCfm) ARGS((Pst *pst, NwMgmt *cfm));
typedef S16 (*LnwStaCfm)   ARGS((Pst *pst, NwMgmt *sta));
typedef S16 (*LnwStsCfm)   ARGS((Pst *pst, NwMgmt *sts));

typedef S16 (*LnwStaInd)   ARGS((Pst *pst, NwMgmt *sta));
typedef S16 (*LnwTrcInd)   ARGS((Pst *pst, NwMgmt *trc));

/* Layer Management functions */


#ifdef NW

EXTERN  S16 NwMiLnwCfgReq   ARGS((Pst *pst, NwMgmt *cfg));
EXTERN  S16 NwMiLnwCntrlReq ARGS((Pst *pst, NwMgmt *cntrl));
EXTERN  S16 NwMiLnwStaReq   ARGS((Pst *pst, NwMgmt *sta));
EXTERN  S16 NwMiLnwStsReq   ARGS((Pst *pst, Action action, NwMgmt *sts));

EXTERN  S16 NwMiLnwCfgCfm   ARGS((Pst *pst, NwMgmt *cfm));
EXTERN  S16 NwMiLnwCntrlCfm ARGS((Pst *pst, NwMgmt *cfm));
EXTERN  S16 NwMiLnwStaCfm   ARGS((Pst *pst, NwMgmt *sta));
EXTERN  S16 NwMiLnwStsCfm   ARGS((Pst *pst, NwMgmt *sts));

EXTERN  S16 NwMiLnwStaInd   ARGS((Pst *pst, NwMgmt *sta));
EXTERN  S16 NwMiLnwTrcInd   ARGS((Pst *pst, NwMgmt *trc));

#endif /* NW */



#ifdef SM 

/* primitives implemented in the layer manager for LNW */

EXTERN S16 SmMiLnwCfgCfm   ARGS((Pst *pst, NwMgmt *cfg));
EXTERN S16 SmMiLnwStsCfm   ARGS((Pst *pst, NwMgmt *sts));
EXTERN S16 SmMiLnwStaCfm   ARGS((Pst *pst, NwMgmt *ssta));
EXTERN S16 SmMiLnwCntrlCfm ARGS((Pst *pst, NwMgmt *cntrl));
EXTERN S16 SmMiLnwStaInd   ARGS((Pst *pst, NwMgmt *usta));
EXTERN S16 SmMiLnwTrcInd   ARGS((Pst *pst, NwMgmt *trc));

/* primitives issued by the layer manager for LNW */

EXTERN S16 SmMiLnwCfgReq   ARGS((Pst *pst, NwMgmt *cfg));
EXTERN S16 SmMiLnwStsReq   ARGS((Pst *pst, Action action, NwMgmt *sts));
EXTERN S16 SmMiLnwStaReq   ARGS((Pst *pst, NwMgmt *ssta));
EXTERN S16 SmMiLnwCntrlReq ARGS((Pst *pst, NwMgmt *cntrl));


#endif


#ifdef LCLNW

EXTERN S16 cmPkLnwCfgReq    ARGS(( Pst  *pst, NwMgmt  *cfg ));   
EXTERN S16 cmPkLnwCntrlReq  ARGS(( Pst  *pst, NwMgmt  *cntrl ));   
EXTERN S16 cmPkLnwStaReq    ARGS(( Pst  *pst, NwMgmt  *sta ));   
EXTERN S16 cmPkLnwStaCfm    ARGS(( Pst  *pst, NwMgmt  *sta ));   
EXTERN S16 cmPkLnwStsReq    ARGS(( Pst  *pst, Action  action, NwMgmt  *sts ));   
EXTERN S16 cmPkLnwStsCfm    ARGS(( Pst  *pst, NwMgmt  *sts ));   
EXTERN S16 cmPkLnwCfgCfm    ARGS(( Pst  *pst, NwMgmt  *cfm ));   
EXTERN S16 cmPkLnwStaInd    ARGS(( Pst  *pst, NwMgmt  *usta ));   
EXTERN S16 cmPkLnwTrcInd    ARGS(( Pst  *pst, NwMgmt  *trc ));   
EXTERN S16 cmPkLnwCntrlCfm  ARGS(( Pst  *pst, NwMgmt  *cfm ));   

EXTERN S16 cmUnpkLnwCntrlReq ARGS(( LnwCntrlReq func, Pst  *pst, Buffer  *mBuf )); 
EXTERN S16 cmUnpkLnwCfgCfm   ARGS(( LnwCfgCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwStaReq   ARGS(( LnwStaReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwStaCfm   ARGS(( LnwStaCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwStsReq   ARGS(( LnwStsReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwStsCfm   ARGS(( LnwStsCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwCntrlCfm ARGS(( LnwCntrlCfm func, Pst  *pst, Buffer  *mBuf ));  
EXTERN S16 cmUnpkLnwStaInd   ARGS(( LnwStaInd  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwCfgReq   ARGS(( LnwCfgReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLnwTrcInd   ARGS(( LnwTrcInd  func, Pst  *pst, Buffer  *mBuf ));   


#endif

/* stack manager activation function */
EXTERN S16 smNwActvTsk       ARGS((Pst       *pst,
                                   Buffer    *mBuf));

EXTERN S16 smNwActvInit      ARGS((Ent        ent,
                                   Inst       inst,
                                   Region     region,
                                   Reason     reason));



#ifdef __cplusplus
}
#endif

#endif  /* __LNWX__ */

  
/********************************************************************30**

         End of file:     lnw.x@@/main/2 - Wed Aug 13 12:02:44 2003
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
$SID$          sb      1. initial release.
$SID$        ---     yz   1. Update for release 1.2.
*********************************************************************91*/


