/********************************************************************16**

                         (c) COPYRIGHT 1989-2003 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**

     Name:    M2UA Layer (M2UA)

     Type:    Header   File 

     Desc:    Typedef's for LM Interface 

     File:    lmw.x

     Sid:      lmw.x@@/main/4 - Fri Feb  8 11:50:46 2008

     Prg:     

*********************************************************************21*/


#ifndef __LMWX__
#define __LMWX__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Peer Id  */
typedef U16 MwPeerId;

/* Cluster Id  */
typedef U16 MwClusterId;

/* M2UA Statistics  Counter */
typedef U32 MwStsCntr;

/* Typedef for Data Statistics of M2UA */
typedef struct _mwDataSts
{
    MwStsCntr     nmbPdus;        /* Number of Packets */
    MwStsCntr     nmbBytes;       /* Number of Bytes */
} MwDataSts;

/* Text Interface ID */
typedef struct _mwTxtIntfId 
{
    U16    len;
    Txt    charId[LMW_MAX_LEN_INTFID];
} MwTxtIntfId; 

/* Range of Interface ID */
typedef struct _mwRangeIntfId
{
   U32   iidStart;
   U32   iidStop;
} MwRangeIntfId;

/* M2UA Interface ID */
typedef struct _mwIntfId
{
   U16   type;
   union
   {
      U32            intId;          /* Interger Interface ID */
      MwTxtIntfId    txtId;          /* Character Interface ID */
   } id;
} MwIntfId;

/* M2UA Management Interface ID */
typedef struct _mwMgmtIntfIdLst
{
   U16   type;
   union
   {
      U32            intId;          /* Interger Interface ID */
      MwTxtIntfId    txtId;          /* Character Interface ID */
      MwRangeIntfId  rangeId;        /* Range of Interface ID's */
   } id;
} MwMgmtIntfIdLst;

/* General Reconfiguration of M2UA    */
typedef struct _mwGenReCfg 
{
   Pst       smPst;           /* stack manager post structure */
   TmrCfg    tmrAsPend;       /* AS Pending Timer */
   TmrCfg    tmrFlcPoll;      /* SCTP  Flow control polling timer */
   TmrCfg    tmrAspm;         /* Ack Timer for ASPM messages */
   TmrCfg    tmrCongPoll;     /* Ss7 Congestion polling timer */ 
   TmrCfg    tmrHeartBeat;    /* Heartbeat timer */ 
   U8        aspmRetry;       /* Maximum Retries for ASPM messages */
} MwGenReCfg; 

/* General Configuration of M2UA    */
typedef struct _mwGenCfg
{
  U8           nodeType;        /* Type of node : SG/ASP */
  U16          maxNmbIntf;      /* Maximum number of Interfaces */
  U16          maxNmbCluster;   /* Maximum number of Peer Clusture */
  U16          maxNmbPeer;      /* Maximum number of Peers  */
  U16          maxNmbSctSap;    /* Maximum number of Sct Saps */
  U16          timeRes;         /* Timer resolution */
  U16          maxClusterQSize; /* Maximum number of messages Qed in Cluster */
  U16          maxIntfQSize;    /* Maximum number of messages Qed on Link */
  MwGenReCfg   reConfig;        /* general reconfig */
} MwGenCfg;  

/* M2UA lower SCT SAP reconfiguration   */
typedef  struct  _mwSctSapReCfg 
{
   TmrCfg     tmrPrim;         /* lower SAP primitive timer  */
   TmrCfg     tmrAssoc;        /* timer for assoc primitive */
   U8         nmbMaxPrimRetry; /* nmbMaxPrimRetry         */
   U16        lifeTime;        /* Life Time of Data messages */
   Selector   selector;        /* upper layer selector */
   MemoryId   mem;             /* memory region and pool id */
   Priority   prior;           /* priority */
   Route      route;           /* route */
   Ent        ent;             /* Lower SAP Entity */
   Inst       inst;            /* Lower SAP Instance */
   ProcId     procId;          /* ProcId */
} MwSctSapReCfg;

/* M2UA lower SCT SAP configuration   */
typedef struct _mwSctSapCfg 
{
   SuId           suId;        /* service user SAP ID      */
   SpId           spId;        /* service provider ID      */
   U16            srcPort;     /* Source port for EndpointReq */
/*lmw_x_001.main_4 Incoporating the support of multiple ip addresses*/
#ifdef SCT_ENDP_MULTI_IPADDR
   SctNetAddrLst srcAddrLst;  /* source address list */
#else
   CmNetAddr      intfAddr;    /* interface address for EndpOpenReq */
#endif
   MwSctSapReCfg  reConfig;    /* reconfiguration structure */
} MwSctSapCfg;

/* Association Configuration   */
typedef struct _mwAssocCfg    /* SCTP association config */
{
   SuId          suId;        /* SCTSAP ID */

#ifdef MW_CFG_DSTPORT
   U16           dstPort;     /* Destination port for Association*/
#endif
   SctNetAddrLst dstAddrLst;  /* destination address list*/
   SctNetAddrLst srcAddrLst;  /* source address list */
   SctStrmId     locOutStrms; /* number of streams */
   CmNetAddr     priDstAddr;  /* primary dest address */
  /* lmw_x_001.main_3 Added type of service parameter*/
#ifdef SCT3
   SctTos        tos;         /*type of service*/
#endif
} MwAssocCfg;

/* Peer Configuration   */
typedef struct _mwPeerCfg      /* Peer M2UA Cfg */
{
   MwPeerId    peerId;        /* peer id */
   Bool        aspIdFlag;     /* ASP Id flag */
#ifdef MWASP
   U32         selfAspId;     /* ASP Id of the node to be included in ASP UP */
#endif
   MwAssocCfg  assocCfg;      /* Association configuration */
} MwPeerCfg;

/* structrue of Cluster reconfiguration  */
typedef struct _mwClusterReCfg
{
  U16        nmbPeer;                   /* number of entries in peer list */
  MwPeerId   peer[LMW_MAX_PEERS];       /* list of peers */
} MwClusterReCfg;

/* structure of Cluster Configuration structure   */
typedef struct _mwClusterCfg
{
  MwClusterId     clusterId;             /* Cluster Id */
  U8              trfMode;               /* Cluster Traffic Mode */
  U8              loadshareMode;         /* Cluster Loadshare Mode */
  MwClusterReCfg  reConfig;              /* Cluster Reconfiguration */
} MwClusterCfg;

/* M2UA DL Sap Reconfiguration structure  */
typedef struct _mwDlSapReCfg
{
   MwClusterId  clusterId;    /* ClusterId (AS/SGC) for this interface Id */
   Selector     selector;     /* upper layer selector */
   MemoryId     mem;          /* memory region and pool id */
   Priority     prior;        /* priority */
   Route        route;        /* route */
} MwDlSapReCfg;

/* M2UA DL SAP Configuration    */
typedef struct _mwDlSapCfg 
{
  MwIntfId      intfId;    /* Interface ID */
  U16           lnkNmb;    /* Link Number associated with SAP */
  S16           swtch;     /* Configure of SAP as TTC/ITU*/
  MwDlSapReCfg  reConfig;  /* DL Sap Reconfiguration */
} MwDlSapCfg; 

/* M2UA configuration structure  */
typedef struct _mwCfg 
{
  union
  {
     MwGenCfg       genCfg;       /* M2UA General configuration */
     MwSctSapCfg    sctSapCfg;    /* M2UA Lower Sap Configuration */
     MwDlSapCfg     dlSapCfg;     /* M2UA upper Sap configuration */
     MwPeerCfg      peerCfg;      /* M2UA ASP/SG configuration */
     MwClusterCfg   clusterCfg;   /* M2UA SGC/AS configuration */
  } s;
} MwCfg;

/* M2UA control structure  */
typedef struct _mwCntrl  
{
   DateTime        dt;        /* date and time */
   Action          action;    /* action */
   Action          subAction; /* sub action */
   union
   {
      LnkNmb       lnkNmb;       /* link number or SpId */
      SuId         suId;         /* Service user SAP ID */
      MwPeerId     peerId;       /* peer Id */
      MwClusterId  clusterId;    /* clusture Id */
#ifdef DEBUGP
      U32          dbgMask;    /* Debug Mask */
#endif
   } s;
   /* This aspm structure is only valid for ASPM cntrl messages */
   struct
   {
      U8                type;     /* type of ASP */
      Bool              autoCtx;  /* automatic routing context */
      U16               nmbIntf;  /* number of interface IDs */
      MwMgmtIntfIdLst   intfLst[LMW_MAX_INTF]; /* interface Id list */
      Txt               info[LMW_MAX_INFO]; /* INFO field */
   } aspm;
} MwCntrl;

/* M2UA general status   */
typedef struct _mwGenSta
{
   U32          memSize;               /* Reserved memory size */
   U32          memAlloc;              /* Allocated memory size */
   U16          nmbClusters;           /* Number of clusters */
   U16          nmbPeers;              /* Number of Peers  */
   U16          nmbIntf;               /* Number of Interfaces */
} MwGenSta;

/* M2UA lower SCT SAP status  */
typedef struct _mwSctSapSta
{
   U8           state;     /* High level state */
   Bool         endpOpen;  /* Is endpoint opened? */
   UConnId      spEndpId;  /* SP ID of my endpoint */
   U8           nmbPrimRetry; /* Number of retry attempts */
} MwSctSapSta;

/* Association Status  */
typedef struct _mwAssocSta
{
   UConnId     spAssocId;     /* Association ID */
   Bool        connected;     /* connected  */
   Bool        flcInProg;     /* flow control in progress */
   U8          flcLevel;      /* Flow control level START/DROP */
   U16         opInProg;      /* operation in progress */
   Bool        sctpHBeatEnb;  /* SCTP HeartBeat Enabled flag */
   SctStrmId   locOutStrms;   /* number of negotiated streams */
} MwAssocSta;

/* status of the Peer ( SG/ASP )  */
typedef struct _mwPeerSta
{
   U8          state;              /* State of the connection, up or down */
   MwAssocSta  assocSta;           /* status of my association */
   U8          retryCount;         /* ASPM retry counter */
} MwPeerSta;

/* Peer State   */
typedef struct _mwPeerSt
{
   MwPeerId    peerId;     /* my index */
   U8          peerState;  /* state of peer */
} MwPeerSt;

/* Peer Cluster (AS/SGC) state information  - remove this  */
typedef struct _mwClusterSta
{
   U8       state;                         /* AS/SGC state */
   U16      nmbPeer;                       /* number of Peers */
   MwPeerSt peerSt[LMW_MAX_PEERS];         /* Array of peer states */
   U16      nmbActPeer;                    /* number of Active peers*/
} MwClusterSta;

/* M2UA DL Sap Status  */
typedef struct _mwDlSapSta 
{
  SuId        suId;        /* service user ID */
  U8          state;       /* High level state */
  U8          lnkState;    /* Link State */
  Bool        rpoEnable;   /* RPO Enable flag */
  Bool        lpoEnable;   /* LPO Enable flag */
  U16         congLevel;   /* Congestion Level */
} MwDlSapSta;

/* M2UA Solocited status information  */
typedef struct _mwSsta                 /* Solicited status */
{
   DateTime   dt;                      /* date and time */
   union
   {
      LnkNmb       lnkNmb;             /* link number or SpId */
      SuId         suId;               /* Service user SAP ID */
      MwClusterId  clusterId;          /* M2UA cluster ID */
      MwPeerId     peerId;             /* peer Id */
   } id;

   union 
   {
      SystemId     sysId;              /* System Id */
      MwGenSta     genSta;             /* M2UA General status */
      MwDlSapSta   dlSapSta;           /* M2UA upper SAP status */
      MwClusterSta clusterSta;         /* M2UA peer cluster status */
      MwPeerSta    peerSta;            /* M2UA peer status */
      MwSctSapSta  sctSapSta;          /* M2UA Lower SAP status */
   } s;
} MwSsta;

/* M2UA unsolicited status structure  */
typedef struct _mwUsta                 /* Unsolicited status */
{
   CmAlarm       alarm;                /* Common Alarm Structure */
   union
   {
      LnkNmb       lnkNmb;             /* link nmb */
      SuId         suId;               /* Service user SAP ID */
      MwClusterId  clusterId;          /* M2UA peer cluster ID */
      MwPeerId     peerId;             /* peer Id */
   }s;
   union
   {
      struct
      {
         U16       msgType;              /* ASPM message type */
         Txt       info[LMW_MAX_INFO];   /* INFO field */
         U32       aspId;                /* notify ASP ID */
      } aspm;

      /* possible values : AS-ACT, AS-UP, AS-INACT */
      struct
      {
         U8        state;                /* State of cluster  */
      } cluster;
      

      struct
      {
         U32              aspId;               /* notify ASP ID */
         U16              stType;              /* notify status type */
         U16              stId;                /* notify status identification */
         Txt              info[LMW_MAX_INFO];  /* INFO field */
         U16              nmbIntf;             /* No of interface ids */
         MwMgmtIntfIdLst  intfId[LMW_MAX_INTF];/* Interface ids */
      } ntfy;

      struct
      {
         MwMgmtIntfIdLst   intfLst[LMW_MAX_INTF]; /* interface Id list */
         U16       nmbIntf;                    /* No of interface ids */
         U32       errCode;                       /* Error Code */
         Txt       diag[LMW_MAX_INFO];            /* Diagnostic info */
      } error;
   } t;
} MwUsta;

/* ASPM Statistics structure */
typedef struct _mwAspmSts
{
   MwStsCntr    aspUp;         /* M2UA ASP-UP messages sts */
   MwStsCntr    aspUpAck;      /* M2UA ASPUP-ACK messages sts */
   MwStsCntr    aspDn;         /* M2UA ASP-DOWN messages sts */
   MwStsCntr    aspDnAck;      /* M2UA ASPDOWN-ACK messages sts */
   MwStsCntr    aspAc;         /* M2UA ASPACT messages sts */
   MwStsCntr    aspAcAck;      /* M2UA ASPACT-ACK messages sts */
   MwStsCntr    aspIa;         /* M2UA ASPINACT messages sts */
   MwStsCntr    aspIaAck;      /* M2UA ASPINACT-ACK messages sts */
   MwStsCntr    hBeat;         /* M2UA HEARTBEAT messages sts */
   MwStsCntr    hBeatAck;      /* M2UA HEARTBEAT-ACK messages sts */
   MwStsCntr    ntfySts;       /* Notify message statistics  */
   MwStsCntr    txErrSts;      /* Error message statistics - TX */
   MwStsCntr    rxErrSts;      /* Error message statistics - RX */
} MwAspmSts;

/* M2UA General Statistics */
typedef struct _mwGenSts
{
   DateTime       dt;             /* Date and time when statistics 
                                   * counters are initialized to zero */
   MwAspmSts      aspmSts;        /* ASPM statistics information */
   MwDataSts      rxDataSts;      /* PDU Data Statistics - Rx */
   MwDataSts      txDataSts;      /* PDU Data Statistics - Tx */
} MwGenSts;

/* M2UA Statistics for SCTSAP  */
typedef struct _mwSctSapSts
{
   DateTime     dt;            /* date and time when statistics
                                counters are initialized to zero */
   MwDataSts    txDataSts;     /* Transmit Data Statistics on Lower Sap  */
   MwDataSts    rxDataSts;     /* Receive Data Statistics from Lower Sap */
} MwSctSapSts;

/* M2UA Peer (SG/ASP) statistics information   */
typedef struct _mwPeerSts    
{
   DateTime    dt;            /* date and time when statistics
                                 counters are initialized to zero */
   MwAspmSts   aspmSts;       /* Aspm Statistics Information */
} MwPeerSts;

/* M2UA Statistics for Cluster */
typedef struct _mwClusterSts     
{
   DateTime    dt;              /* date and time when statistics
                                   counters are initialized to zero */
   MwDataSts   rxDataSts;       /* Received Data on Cluster  */
   MwDataSts   txDataSts;       /* Transmitted Data on Cluster */
} MwClusterSts;

/* M2UA DL Sap Statistics  */
typedef struct _mwDlSapSts 
{
   DateTime    dt;           /* date and time when statistics
                                counters are initialized to zero */
   MwDataSts   rxDataSts;    /* Received Data on Interface  */
   MwDataSts   txDataSts;    /* Transmitted Data on Interface */
} MwDlSapSts;

/* M2UA statistics structure   */
typedef struct _mwSts                /* Statistics */
{
   DateTime   dt;                    /* Current date and time */
   Duration   dura;                  /* duration as date and time */

   union
   {
      LnkNmb       lnkNmb;             /* link number or SpId */
      SuId         suId;               /* Service user SAP ID */
      MwPeerId     peerId;             /* Peer Id */
      MwClusterId  clusterId;          /* Cluster Id */
   }id;

   union
   {
      MwGenSts     genSts;           /* M2UA general statistics */
      MwDlSapSts   dlSapSts;         /* M2UA DL SAP statistics */
      MwSctSapSts  sctSapSts;        /* M2UA SCT SAP statistics */
      MwPeerSts    peerSts;          /* M2UA Peer statistics */
      MwClusterSts clusterSts;       /* M2UA Cluster statistics */
   } u;
} MwSts;

/* M2UA Trace structure  */
typedef struct _mwTrc                  /* Trace */
{
   DateTime   dt;                      /* date and time */
   SuId       suId;                    /* SCTSAP Id */
   U16        evnt;                    /* event */
   U16        len;                     /* trace length */
   U8         evntParm[LMW_MAX_TRC_LEN];  /* event parameters */
} MwTrc;

/* M2UA Management structure  */
typedef struct _mwMgmt
{
   Header     hdr;                     /* header */
   CmStatus   cfm;                     /* Confirm */
   union
   {
      MwCfg   cfg;                     /* configuration */
      MwCntrl cntrl;                   /* control */
      MwSsta  ssta;                     /* solicited status */
      MwSts   sts;                     /* statistics */
      MwUsta  usta;                    /* unsolicited status */
      MwTrc   trc;                     /* trace */
   } t;
} MwMgmt;


/*
 * Depending on the specific selector in the post structure, a
 * primitive originated from a service provider can be dispatched
 * to any service user. The assumption is that, even if every
 * primitive has a different name depending in which file it
 * resides, every primitive must have the same function prototype,
 * i.e. the same identical set of arguments. These arguments are
 * defined here:
 */

typedef S16 (*LmwCfgReq)   ARGS((Pst *pst, MwMgmt *cfg));
typedef S16 (*LmwCntrlReq) ARGS((Pst *pst, MwMgmt *cntrl));
typedef S16 (*LmwStaReq)   ARGS((Pst *pst, MwMgmt *sta));
typedef S16 (*LmwStsReq)   ARGS((Pst *pst, Action action, MwMgmt *sts));

typedef S16 (*LmwCfgCfm)   ARGS((Pst *pst, MwMgmt *cfm));
typedef S16 (*LmwCntrlCfm) ARGS((Pst *pst, MwMgmt *cfm));
typedef S16 (*LmwStaCfm)   ARGS((Pst *pst, MwMgmt *sta));
typedef S16 (*LmwStsCfm)   ARGS((Pst *pst, MwMgmt *sts));

typedef S16 (*LmwStaInd)   ARGS((Pst *pst, MwMgmt *sta));
typedef S16 (*LmwTrcInd)   ARGS((Pst *pst, MwMgmt *trc));

/* EXTERN Functions Declarations */

#ifdef SM 

EXTERN  S16 SmMiLmwCfgReq   ARGS((Pst *pst, MwMgmt *cfg));
EXTERN  S16 SmMiLmwCntrlReq ARGS((Pst *pst, MwMgmt *cntrl));
EXTERN  S16 SmMiLmwStaReq   ARGS((Pst *pst, MwMgmt *sta));
EXTERN  S16 SmMiLmwStsReq   ARGS((Pst *pst, Action action, MwMgmt *sts));

EXTERN  S16 SmMiLmwCfgCfm   ARGS((Pst *pst, MwMgmt *cfm));
EXTERN  S16 SmMiLmwCntrlCfm ARGS((Pst *pst, MwMgmt *cfm));
EXTERN  S16 SmMiLmwStaCfm   ARGS((Pst *pst, MwMgmt *sta));
EXTERN  S16 SmMiLmwStsCfm   ARGS((Pst *pst, MwMgmt *sts));

EXTERN  S16 SmMiLmwStaInd   ARGS((Pst *pst, MwMgmt *sta));
EXTERN  S16 SmMiLmwTrcInd   ARGS((Pst *pst, MwMgmt *trc));

#endif /* SM */

#ifdef MW

EXTERN  S16 MwMiLmwCfgReq   ARGS((Pst *pst, MwMgmt *cfg));
EXTERN  S16 MwMiLmwCntrlReq ARGS((Pst *pst, MwMgmt *cntrl));
EXTERN  S16 MwMiLmwStaReq   ARGS((Pst *pst, MwMgmt *sta));
EXTERN  S16 MwMiLmwStsReq   ARGS((Pst *pst, Action action, MwMgmt *sts));

EXTERN  S16 MwMiLmwCfgCfm   ARGS((Pst *pst, MwMgmt *cfm));
EXTERN  S16 MwMiLmwCntrlCfm ARGS((Pst *pst, MwMgmt *cfm));
EXTERN  S16 MwMiLmwStaCfm   ARGS((Pst *pst, MwMgmt *sta));
EXTERN  S16 MwMiLmwStsCfm   ARGS((Pst *pst, MwMgmt *sts));

EXTERN  S16 MwMiLmwStaInd   ARGS((Pst *pst, MwMgmt *sta));
EXTERN  S16 MwMiLmwTrcInd   ARGS((Pst *pst, MwMgmt *trc));

#endif /* MW */

/* PRIMITIVE PACKING/UNPACKING FUNCTIONS */


#ifdef LCLMW

/* Packing functions */
EXTERN S16 cmPkLmwCfgReq    ARGS((Pst *pst, MwMgmt *cfg));
EXTERN S16 cmPkLmwCntrlReq  ARGS((Pst *pst, MwMgmt *cntrl));
EXTERN S16 cmPkLmwStaReq    ARGS((Pst *pst, MwMgmt *sta));
EXTERN S16 cmPkLmwStsReq    ARGS((Pst *pst, Action action, MwMgmt *sts));

EXTERN S16 cmPkLmwCfgCfm    ARGS((Pst *pst, MwMgmt *cfg));
EXTERN S16 cmPkLmwCntrlCfm  ARGS((Pst *pst, MwMgmt *cntrl));
EXTERN S16 cmPkLmwStaCfm    ARGS((Pst *pst, MwMgmt *sta));
EXTERN S16 cmPkLmwStsCfm    ARGS((Pst *pst, MwMgmt *sts));

EXTERN S16 cmPkLmwStaInd    ARGS((Pst *pst, MwMgmt *usta));
EXTERN S16 cmPkLmwTrcInd    ARGS((Pst *pst, MwMgmt *trc));

/* Unpacking functions */
EXTERN S16 cmUnpkLmwCfgReq   ARGS((LmwCfgReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwCntrlReq ARGS((LmwCntrlReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwStaReq   ARGS((LmwStaReq func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwStsReq   ARGS((LmwStsReq func,  Pst *pst, Buffer *mBuf));

EXTERN S16 cmUnpkLmwCfgCfm   ARGS((LmwCfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwCntrlCfm ARGS((LmwCntrlCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwStaCfm   ARGS((LmwStaCfm func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwStsCfm   ARGS((LmwStsCfm func,  Pst *pst, Buffer *mBuf));

EXTERN S16 cmUnpkLmwStaInd   ARGS((LmwStaInd func,  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLmwTrcInd   ARGS((LmwTrcInd func,  Pst *pst, Buffer *mBuf));


/* Functions in file lmw.c to be checked */
EXTERN S16 cmPkMwTxtIntfId ARGS(( MwTxtIntfId  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwRangeIntfId ARGS(( MwRangeIntfId  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwIntfId ARGS(( MwIntfId  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwMgmtIntfIdLst ARGS(( MwMgmtIntfIdLst  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwDlSapReCfg ARGS(( MwDlSapReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwDlSapCfg ARGS(( MwDlSapCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwAssocCfg ARGS(( MwAssocCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwPeerCfg ARGS(( MwPeerCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwSctSapReCfg ARGS(( MwSctSapReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwSctSapCfg ARGS(( MwSctSapCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwClusterReCfg ARGS(( MwClusterReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwClusterCfg ARGS(( MwClusterCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwGenReCfg ARGS(( MwGenReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwGenCfg ARGS(( MwGenCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkLmwCfgReq ARGS(( Pst  *pst, MwMgmt  *cfg ));   
EXTERN S16 cmPkLmwCntrlReq ARGS(( Pst  *pst, MwMgmt  *cntrl ));   
EXTERN S16 cmPkMwGenSta ARGS(( MwGenSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwSctSapSta ARGS(( MwSctSapSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwAssocSta ARGS(( MwAssocSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwPeerSta ARGS(( MwPeerSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwPeerSt ARGS(( MwPeerSt  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwClusterSta ARGS(( MwClusterSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwDlSapSta ARGS(( MwDlSapSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkLmwStaReq ARGS(( Pst  *pst, MwMgmt  *sta ));   
EXTERN S16 cmPkMwDataSts ARGS(( MwDataSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwAspmSts ARGS(( MwAspmSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwGenSts ARGS(( MwGenSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwClusterSts ARGS(( MwClusterSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwDlSapSts ARGS(( MwDlSapSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwPeerSts ARGS(( MwPeerSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkMwSctSapSts ARGS(( MwSctSapSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmPkLmwStsReq ARGS(( Pst  *pst, Action  action, MwMgmt  *sts ));   
EXTERN S16 cmPkLmwTrcInd ARGS(( Pst  *pst, MwMgmt  *trc ));   
EXTERN S16 cmPkLmwCfgCfm ARGS(( Pst  *pst, MwMgmt  *cfm ));   
EXTERN S16 cmPkLmwCntrlCfm ARGS(( Pst  *pst, MwMgmt  *cfm ));   
EXTERN S16 cmPkLmwStaCfm ARGS(( Pst  *pst, MwMgmt  *sta ));   
EXTERN S16 cmPkLmwStaInd ARGS(( Pst  *pst, MwMgmt  *usta ));   
EXTERN S16 cmPkLmwStsCfm ARGS(( Pst  *pst, MwMgmt  *sts ));   
EXTERN S16 cmUnpkLmwTxtIntfId ARGS(( MwTxtIntfId  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwRangeIntfId ARGS(( MwRangeIntfId  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwIntfId ARGS(( MwIntfId  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwMgmtIntfIdLst ARGS(( MwMgmtIntfIdLst  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwDlSapReCfg ARGS(( MwDlSapReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwDlSapCfg ARGS(( MwDlSapCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwAssocCfg ARGS(( MwAssocCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwPeerCfg ARGS(( MwPeerCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwSctSapReCfg ARGS(( MwSctSapReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwSctSapCfg ARGS(( MwSctSapCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwClusterReCfg ARGS(( MwClusterReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwClusterCfg ARGS(( MwClusterCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwGenReCfg ARGS(( MwGenReCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwGenCfg ARGS(( MwGenCfg  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwCfgReq ARGS(( LmwCfgReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwCfgCfm ARGS(( LmwCfgCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwCntrlReq ARGS(( LmwCntrlReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwCntrlCfm ARGS(( LmwCntrlCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwAssocSta ARGS(( MwAssocSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwPeerSta ARGS(( MwPeerSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwPeerSt ARGS(( MwPeerSt  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwClusterSta ARGS(( MwClusterSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwDlSapSta ARGS(( MwDlSapSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwSctSapSta ARGS(( MwSctSapSta  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwStaReq ARGS(( LmwStaReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwStaCfm ARGS(( LmwStaCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwStaInd ARGS(( LmwStaInd  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwDataSts ARGS(( MwDataSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwAspmSts ARGS(( MwAspmSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwClusterSts ARGS(( MwClusterSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwDlSapSts ARGS(( MwDlSapSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwPeerSts ARGS(( MwPeerSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwSctSapSts ARGS(( MwSctSapSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwGenSts ARGS(( MwGenSts  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwStsReq ARGS(( LmwStsReq  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwStsCfm ARGS(( LmwStsCfm  func, Pst  *pst, Buffer  *mBuf ));   
EXTERN S16 cmUnpkMwTrcInd ARGS(( MwTrc  *param, Buffer  *mBuf ));   
EXTERN S16 cmUnpkLmwTrcInd ARGS(( LmwTrcInd  func, Pst  *pst, Buffer  *mBuf ));   


#endif

/* stack manager activation function */
EXTERN S16 smMwActvTsk       ARGS((Pst       *pst,
                                   Buffer    *mBuf));

EXTERN S16 smMwActvInit      ARGS((Ent        ent,
                                   Inst       inst,
                                   Region     region,
                                   Reason     reason));

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LMWX__ */


/********************************************************************30**

  End of file:     lmw.x@@/main/4 - Fri Feb  8 11:50:46 2008

**********************************************************************31*/

/********************************************************************40**

Notes:

**********************************************************************41*/

/********************************************************************50**

**********************************************************************51*/

/********************************************************************60**

  Revision history:

**********************************************************************61*/
/********************************************************************70**

  version    initials                   description
  -----------  ---------  ------------------------------------------------

**********************************************************************71*/

/********************************************************************80**

**********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
/main/1      ---     hl   1. initial release.
  
/main/2      ---       yz   1. Update for Release 1.2.

/main/2      ---      yz   1. New flag MW_CFG_DSTPORT for adding
                               dstPort cfg.
lmw_x_001.main_3      na   1. Added TOS parameter
/main/3      ---       na    1. Added type of service parameter
lmw_x_001.main_3       na    1. incoporating the support of multiple ip addresses
/main/4      ---        na    2.  incoporating the support of multiple ip 
                                 addresses
*********************************************************************91*/
