/********************************************************************16**

                         (c) COPYRIGHT 1989-2003 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**

     Name:    M2UA Layer (M2UA)

     Type:    Header File 

     Desc:    HashDefines for LM Interface 

     File:    lmw.h

     Sid:      lmw.h@@/main/4 - Fri Feb  8 11:50:03 2008

     Prg:     

*********************************************************************21*/


#ifndef __LMWH__
#define __LMWH__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Node type in general configuration */
#define LMW_TYPE_SGP          1      /* type SG */
#define LMW_TYPE_ASP          2      /* type ASP */

/* unsolicited status */
#define LMW_MAX_INFO          40    /* Maximum size of INFO string */
#define LMW_MAX_TRC_LEN       200   /* Maximum trace size */
#define LMW_MAX_LEN_INTFID    32    /* Maximum length of interface ID string */

/* the following hash defines provides the default values for different 
 * parameters needed for the product. The users could modify according to 
 * their own needs.  */
#ifndef LMW_MAX_PEERS
#define LMW_MAX_PEERS         10    /* Maximum number of peer */
#endif
#ifndef LMW_IID_PER_CLUSTER
#define LMW_IID_PER_CLUSTER   10    /* Interface ID's per clusters */
#endif
#ifndef LMW_CLUSTER_PER_PEER
#define LMW_CLUSTER_PER_PEER  10    /* Clusters per Peer */
#endif
#ifndef LMW_MAX_INTF
#define LMW_MAX_INTF          100    /* Maximum number of interfaces */
#endif
#ifndef LMW_MIN_OUT_STRMS
#define LMW_MIN_OUT_STRMS    2      /* Minimum number of out streams*/
#endif

/* defines for element management */
#define STMWSID               1     /* System ID */
#define STMWGEN               2     /* General */
#define STMWSCTSAP            3     /* Lower layer SAP */
#define STMWDLSAP             4     /* Upper layer SAP */
#define STMWPEER              5     /* Peer */
#define STMWCLUSTER           6     /* Cluster */

/* M2UA specific Mngmt.t.cntrl.action defines */
#define AMWESTABLISH          256   /* Establish Association  */
#define AMWTERMINATE          257   /* Terminate Association  */
#define AMWENDPOPEN           258   /* Open Endpoint */
#define AMWENDPCLOSE          259   /* Close Endpoint */
#define AMWASPAC              260   /* ASP Active */
#define AMWASPIA              261   /* ASP Inactive */
#define AMWASPUP              262   /* ASP Up */
#define AMWASPDN              263   /* ASP Down */
#define AMWABORT              264   /* Assoc Abort */

/* Management events */
#define EVTLMWCFGREQ                    1   /* Configuration request */
#define EVTLMWCFGCFM                    2   /* Configuration confirm */
#define EVTLMWSTAREQ                    3   /* Status request */
#define EVTLMWSTACFM                    4   /* Status confirm */
#define EVTLMWSTAIND                    5   /* Status indication */
#define EVTLMWSTSREQ                    6   /* Statistics request */
#define EVTLMWSTSCFM                    7   /* Statistics confirm */
#define EVTLMWTRCIND                    8   /* Trace indication */
#define EVTLMWCNTRLREQ                  9   /* Control request */
#define EVTLMWCNTRLCFM                  10  /* Control confirm */

/* status */
#define LMW_SAP_UNBOUND        1  /* SAP not bound */
#define LMW_SAP_BOUND          2  /* SAP has been bound */
#define LMW_SAP_ITU            1  /* DLSAP type for ITU/ANSI*/
#define LMW_SAP_TTC            2  /* DLSAP type for TTC/NTT */

/* State of the Cluster */
#define LMW_CLUSTER_DOWN            1   /* Cluster state is down */
#define LMW_CLUSTER_INACTIVE        2   /* Cluster state is up */
#define LMW_CLUSTER_ACTIVE          3   /* Cluster state is active */
#define LMW_CLUSTER_PENDING         4   /* Cluster state is pending */

/* State of the Peer */
#define LMW_PEER_DOWN            1      /* Peer state is down */
#define LMW_PEER_INACTIVE        2      /* Peer state is up */
#define LMW_PEER_ACTIVE          3      /* Peer state is active */

/* State of the Interfaces */
#define LMW_LINK_CONNECTED        1  /* Link Connected */
#define LMW_LINK_DISCONNECTED     2  /* Link Disconnected */

/* defines for lpoEnable flag */
#define LMW_LPO_ENABLED           1   /* LPO in progress */
#define LMW_LPO_DISABLED          0   /* LPO is clear  */

/* defines for lpoEnable flag */
#define LMW_RPO_ENABLED           1   /* RPO is entered */
#define LMW_RPO_DISABLED          0   /* RPO is clear  */

/* protocol defines for congestion levels */
#define LMW_CONG_NONE            0    /* Congestion level 0 */
#define LMW_CONG_LVL1            1    /* Congestion level 1 */
#define LMW_CONG_LVL2            2    /* Congestion level 2 */
#define LMW_CONG_LVL3            3    /* Congestion level 3 */

/* protocol defines for discard levels */
#define LMW_DSCRD_NONE           0    /* Discard level 0 */
#define LMW_DSCRD_LVL1           1    /* Discard level 1 */
#define LMW_DSCRD_LVL2           2    /* Discard level 2 */
#define LMW_DSCRD_LVL3           3    /* Discard level 3 */

/* Possible values of Traffic mode */
#define LMW_TRF_MODE_OVERRIDE   0x1     /* Override Mode */
#define LMW_TRF_MODE_LOADSHARE  0x2     /* Loadshare Mode */
#define LMW_TRF_MODE_BROADCAST  0x3     /* Broadcast Mode */
#define LMW_TRF_MODE_ANY        0x0     /* ANY       Mode */

/* Possible values of Loadshareing mode */
#define LMW_LOADSH_RR           0x1     /* Round Robin Mode*/
#define LMW_LOADSH_LS           0x2     /* Link Specified */
#define LMW_LOADSH_CS           0x3     /* Customer Specified */

/* defines for ASPM  protocol messages */
#define LMW_MSG_ASP_UP             0x0301  /* ASP Up message / state */
#define LMW_MSG_ASP_DOWN           0x0302  /* ASP Down message / state */
#define LMW_MSG_ASP_UP_ACK         0x0304  /* ASP Up Acknowlwdgement */
#define LMW_MSG_ASP_DOWN_ACK       0x0305  /* ASP Down Acknowledgement */
#define LMW_MSG_ASP_ACTIVE         0x0401  /* ASP Active message / state */
#define LMW_MSG_ASP_INACTIVE       0x0402  /* ASP Inactive message */
#define LMW_MSG_ASP_ACTIVE_ACK     0x0403  /* ASP Active Acknowledgement */
#define LMW_MSG_ASP_INACTIVE_ACK   0x0404  /* ASP Inactive Acknowledgement */
#define LMW_MSG_HBEAT              0x0303  /* HBeat message */
#define LMW_MSG_HBEAT_ACK          0x0306  /* HBeat Acknowledgement */

/* protocol Reason for ASP Down message */
#define LMW_INVALID_RSN_MGMT        0x0    /* Invalid Managment Reason */
#define LMW_ASPDN_RSN_MGMT          0x1    /* Managment Reason */ 

/* Layer specific events */
#define LMW_EVENT_ESTABLISH_FAIL        (LCM_EVENT_LYR_SPECIFIC + 1)
#define LMW_EVENT_ESTABLISH_OK          (LCM_EVENT_LYR_SPECIFIC + 2)
#define LMW_EVENT_ASPM                  (LCM_EVENT_LYR_SPECIFIC + 3)
#define LMW_EVENT_NOTIFY                (LCM_EVENT_LYR_SPECIFIC + 4)
#define LMW_EVENT_CLUSTER               (LCM_EVENT_LYR_SPECIFIC + 5)
#define LMW_EVENT_TERM_OK               (LCM_EVENT_LYR_SPECIFIC + 6)
#define LMW_EVENT_TERM_FAIL             (LCM_EVENT_LYR_SPECIFIC + 7)
#define LMW_EVENT_COMM_LOST             (LCM_EVENT_LYR_SPECIFIC + 8)
#define LMW_EVENT_M2UA_PROTO_ERROR      (LCM_EVENT_LYR_SPECIFIC + 9)
#define LMW_EVENT_FLC_DROP              (LCM_EVENT_LYR_SPECIFIC + 11)
#define LMW_EVENT_QUEUEING_FAIL         (LCM_EVENT_LYR_SPECIFIC + 12)
#define LMW_EVENT_UBND_OK               (LCM_EVENT_LYR_SPECIFIC + 13)
#define LMW_EVENT_UBND_FAIL             (LCM_EVENT_LYR_SPECIFIC + 14)
#define LMW_EVENT_ASPM_FAIL             (LCM_EVENT_LYR_SPECIFIC + 15)
#define LMW_EVENT_ENDPCLOSE_OK          (LCM_EVENT_LYR_SPECIFIC + 16)
#define LMW_EVENT_ENDPCLOSE_FAIL        (LCM_EVENT_LYR_SPECIFIC + 17)
#define LMW_EVENT_ENDPOPEN_OK           (LCM_EVENT_LYR_SPECIFIC + 18)
#define LMW_EVENT_ENDPOPEN_FAIL         (LCM_EVENT_LYR_SPECIFIC + 19)
#define LMW_EVENT_ASSOC_RESTART         (LCM_EVENT_LYR_SPECIFIC + 20)
#define LMW_EVENT_SEND_FAIL             (LCM_EVENT_LYR_SPECIFIC + 21)
#define LMW_EVENT_PARA_NOTSUPP          (LCM_EVENT_LYR_SPECIFIC + 22)
#define LMW_EVENT_STATUS                (LCM_EVENT_LYR_SPECIFIC + 23)
/*lmw_h_001.main_3 Layer specific event generated on recipt of heartbeat ack*/
#ifdef MW_ETSI
#define LMW_EVENT_HEARTBEAT             (LCM_EVENT_LYR_SPECIFIC + 24)
#endif /*MW_ETSI*/
/* M2UA protocol error cause codes */
#define LMW_PROTO_ERR_INV_VERSION       0x1     /* Invalid Version */
#define LMW_PROTO_ERR_INV_INTFID        0x2     /* Invalid Interface ID */
#define LMW_PROTO_ERR_UNSUP_MSGCLS      0x3     /* Unsupported message class */
#define LMW_PROTO_ERR_UNSUP_MSGTYPE     0x4     /* Unsupported message type */
#define LMW_PROTO_ERR_UNSUP_TRF_MODE    0x5     /* Unsupported traffic mode */
#define LMW_PROTO_ERR_UNEXPECTED_MSG    0x6     /* Unexpected message */
#define LMW_PROTO_ERR_PROTOCOL          0x7     /* Protocol Error */
#define LMW_PROTO_ERR_UNSUP_IID_TYPE    0x8     /* Unsupported IntfID type */
#define LMW_PROTO_ERR_INV_STREAM_ID     0x9     /* Invalid Stream ID */
#define LMW_PROTO_ERR_REF_MGMTBLK       0xd     /* Management Blocking*/
#define LMW_PROTO_ERR_ASPID_REQD        0xe     /* ASPID required */
#define LMW_PROTO_ERR_INV_ASPID         0xf     /* Invalid ASPID */
#define LMW_PROTO_ERR_ASPAC_4_IID       0x10    /* ASPAC for Intf ID*/
#define LMW_PROTO_ERR_INV_PARAM_VAL     0x11    /* Invalid Param Val */
#define LMW_PROTO_ERR_PARAM_FLD_ERR     0x12    /* Param Field Err. */
#define LMW_PROTO_ERR_UNEXPD_PARAM      0x13    /* Unexpd  Param */
#define LMW_PROTO_ERR_MISS_PARAM        0x16    /* Missing Param  */


/* M2UA protocol error cause codes */
#define LMW_CAUSE_M2UA_ERROR             (LCM_CAUSE_LYR_SPECIFIC + 1)
#define LMW_CAUSE_M2UA_INV_VERSION       (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_INV_VERSION )
#define LMW_CAUSE_M2UA_INV_INTFID        (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_INV_INTFID)
#define LMW_CAUSE_M2UA_UNSUP_MSGCLS      (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_UNSUP_MSGCLS)
#define LMW_CAUSE_M2UA_UNSUP_MSGTYPE     (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_UNSUP_MSGTYPE)
#define LMW_CAUSE_M2UA_UNSUP_TRF_MODE    (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_UNSUP_TRF_MODE)
#define LMW_CAUSE_M2UA_UNEXPECTED_MSG    (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_UNEXPECTED_MSG)
#define LMW_CAUSE_M2UA_PROTO_ERR          (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_PROTOCOL)         
#define LMW_CAUSE_M2UA_INV_STREAM_ID     (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_INV_STREAM_ID)    
#define LMW_CAUSE_M2UA_UNSUP_IID_TYPE    (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_UNSUP_IID_TYPE)    
#define LMW_CAUSE_M2UA_REF_MGMTBLK       (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_REF_MGMTBLK)
#define LMW_CAUSE_M2UA_ASPID_REQD        (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_ASPID_REQD)
#define LMW_CAUSE_M2UA_INV_ASPID         (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_INV_ASPID)
#define LMW_CAUSE_M2UA_ASPAC_4_IID       (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_ASPAC_4_IID)
#define LMW_CAUSE_M2UA_INV_PARAM_VAL     (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_INV_PARAM_VAL)
#define LMW_CAUSE_M2UA_PARAM_FLD_ERR     (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_PARAM_FLD_ERR)
#define LMW_CAUSE_M2UA_UNEXPD_PARAM      (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_UNEXPD_PARAM)
#define LMW_CAUSE_M2UA_MISS_PARAM        (LMW_CAUSE_M2UA_ERROR + LMW_PROTO_ERR_MISS_PARAM)

/* M2UA specific error cause codes */

#define LCM_CAUSE_M2UA_SPECIFIC         (LCM_CAUSE_LYR_SPECIFIC + 25)
#define LMW_CAUSE_MSG_RECEIVED          (LCM_CAUSE_M2UA_SPECIFIC + 1)
#define LMW_CAUSE_FLC_STAT              (LCM_CAUSE_M2UA_SPECIFIC + 2)
#define LMW_CAUSE_CLUSTER_IA            (LCM_CAUSE_M2UA_SPECIFIC + 3)
#define LMW_CAUSE_TERM_INPROGRESS       (LCM_CAUSE_M2UA_SPECIFIC + 4)
#define LMW_CAUSE_SAP_UNBOUND           (LCM_CAUSE_M2UA_SPECIFIC + 5)
#define LMW_CAUSE_ENDP_NOT_OPEN         (LCM_CAUSE_M2UA_SPECIFIC + 6)
#define LMW_CAUSE_CLUSTER_QFULL         (LCM_CAUSE_M2UA_SPECIFIC + 7)
#define LMW_CAUSE_INTF_QFULL            (LCM_CAUSE_M2UA_SPECIFIC + 8)
#define LMW_CAUSE_FLC_REQ               (LCM_CAUSE_M2UA_SPECIFIC + 9)
#define LMW_CAUSE_SCT_TMR_EXP_MAX_RETRY (LCM_CAUSE_M2UA_SPECIFIC + 10)
#define LMW_CAUSE_CONG_CLEAR            (LCM_CAUSE_M2UA_SPECIFIC + 11)
#define LMW_CAUSE_CONG_ACCEPT           (LCM_CAUSE_M2UA_SPECIFIC + 12)
#define LMW_CAUSE_CONG_DISCARD          (LCM_CAUSE_M2UA_SPECIFIC + 13)
#define LMW_CAUSE_LPO_ENTER             (LCM_CAUSE_M2UA_SPECIFIC + 14)
#define LMW_CAUSE_LPO_EXIT              (LCM_CAUSE_M2UA_SPECIFIC + 15)
/*lmw_h_001.main_3 M2UA specific error causes added*/
#ifdef MW_ETSI
#define LMW_CAUSE_HEARTBEAT_ACK         (LCM_CAUSE_M2UA_SPECIFIC + 16) /*HeartBeat Ack recieved*/
#endif /*MW_ETSI*/
#define MW_LOC_PROC_DN     2            /* local processor down */
#define MW_LOC_PROC_UP     3            /* local processor up */
/* Defines for status type in NOTIFY msg */
#define LMW_NTFY_TYPE_ASCHG       0x1  /* AS state change */
#define LMW_NTFY_TYPE_OTHER       0x2  /* other */

/* Defines for status ID in NOTIFY msg - for AS status change */
/* #define LMW_NTFY_AS_DOWN          0x1    AS State change to Down */
#define LMW_NTFY_AS_INACTIVE      0x2   /* AS State change to Inactive */
#define LMW_NTFY_AS_ACTIVE        0x3   /* AS State change to Active */
#define LMW_NTFY_AS_PENDING       0x4   /* AS State change to Pending */

/* Defines for status ID in NOTIFY msg - for Other type */
#define LMW_NTFY_INSUF_ASP_AC     0x1   /* Insufficient ASP resources active */
#define LMW_NTFY_ALT_ASP_AC       0x2   /* alternate ASP active */
#define LMW_NTFY_ASP_FAIL         0x3   /* ASP FAILURE*/

/* trace indication */
#define LMW_MSG_RX                 1     /* Message Received */
#define LMW_MSG_TX                 2     /* Message Transmitted */

/* reasons */
#define LMW_REASON_SERVICE_IN_USE   (LCM_REASON_LYR_SPECIFIC + 1) /* Service in Use */
#define LMW_REASON_RECONFIG_OK      (LCM_REASON_LYR_SPECIFIC + 2) /* Reconfiguration attempt */
#define LMW_REASON_ASPM_IN_PROG     (LCM_REASON_LYR_SPECIFIC + 3) /* Other ASPM operation in progress */
#define LMW_REASON_INVALID_CLUSTERID (LCM_REASON_LYR_SPECIFIC + 4) /* Cluster Not found  */
#define LMW_REASON_INVALID_TRFMODE   (LCM_REASON_LYR_SPECIFIC + 5) /* Cluster Not found  */
/*lmw_h_001.main_3 error reasons added*/
#ifdef MW_ETSI
#define LMW_REASON_UNSUPP_INTFID   (LCM_REASON_LYR_SPECIFIC + 6) /* Text IID not supported by ETSI  */
#define LMW_REASON_UNSUPP_SWITCH     (LCM_REASON_LYR_SPECIFIC + 7) /*TTC PDU parameters are not supported in ETSI*/
#endif

/* Interface ID type at LM Interface */
#define LMW_INTFID_INT       0x1      /* Integer Interface ID */
#define LMW_INTFID_CHAR      0x3      /* Character Interface ID */
#define LMW_INTFID_RANGE     0x8      /* Range of Interface ID */


/* Packing and unpacking */
#define cmPkMwPeerId(x, mBuf)           SPkU16(x, mBuf)
#define cmUnpkMwPeerId(x, mBuf)         SUnpkU16(x, mBuf)
#define cmPkMwClusterId(x, mBuf)        SPkU16(x, mBuf)
#define cmUnpkMwClusterId(x, mBuf)      SUnpkU16(x, mBuf)

/* Message and packing macros */
#define LMWLOGERROR(errCls, errCode, errDesc)         \
        SLogError(pst->srcEnt, pst->srcInst, pst->srcProcId,  \
                   __FILE__, __LINE__,                        \
                  (ErrCls)errCls, (ErrCode)errCode, (ErrVal)0, errDesc)

#define LMW_GETMSG(p, m, e) { \
    S16 ret; \
    ret = SGetMsg((p)->region, (p)->pool, &(m)); \
    if (ret != ROK) \
    { \
        LMWLOGERROR(ERRCLS_ADD_RES, e, "SGetMsg failed"); \
        RETVALUE(ret); \
    } \
}
#define LMW_PUTMSG(_msg) { \
    S16 ret; \
    ret = SPutMsg(_msg); \
    _msg = (Buffer *)NULLP; \
    if (ret != ROK) \
    { \
        LMWLOGERROR(ERRCLS_ADD_RES, _msg, "SPutMsg failed"); \
        RETVALUE(ret); \
    } \
}

/* Error codes for functions at the LMW Interface */
#define   ELMWBASE      000
#define   ELMWXXX      (ELMWBASE)         /* reserved */
#define   ERRLMW       (ELMWBASE)         /* reserved */
#define   ELMW001      (ERRLMW +    1)    /*        lmw.c: 670 */
#define   ELMW002      (ERRLMW +    2)    /*        lmw.c: 675 */
#define   ELMW003      (ERRLMW +    3)    /*        lmw.c: 678 */
#define   ELMW004      (ERRLMW +    4)    /*        lmw.c: 682 */
#define   ELMW005      (ERRLMW +    5)    /*        lmw.c: 685 */
#define   ELMW006      (ERRLMW +    6)    /*        lmw.c: 689 */
#define   ELMW007      (ERRLMW +    7)    /*        lmw.c: 693 */
#define   ELMW008      (ERRLMW +    8)    /*        lmw.c: 699 */
#define   ELMW009      (ERRLMW +    9)    /*        lmw.c: 741 */
#define   ELMW010      (ERRLMW +   10)    /*        lmw.c: 757 */
#define   ELMW011      (ERRLMW +   11)    /*        lmw.c: 764 */
#define   ELMW012      (ERRLMW +   12)    /*        lmw.c: 774 */
#define   ELMW013      (ERRLMW +   13)    /*        lmw.c: 781 */
#define   ELMW014      (ERRLMW +   14)    /*        lmw.c: 785 */
#define   ELMW015      (ERRLMW +   15)    /*        lmw.c: 791 */
#define   ELMW016      (ERRLMW +   16)    /*        lmw.c: 797 */
#define   ELMW017      (ERRLMW +   17)    /*        lmw.c: 806 */
#define   ELMW018      (ERRLMW +   18)    /*        lmw.c: 813 */
#define   ELMW019      (ERRLMW +   19)    /*        lmw.c: 816 */
#define   ELMW020      (ERRLMW +   20)    /*        lmw.c: 817 */
#define   ELMW021      (ERRLMW +   21)    /*        lmw.c: 818 */
#define   ELMW022      (ERRLMW +   22)    /*        lmw.c: 819 */
#define   ELMW023      (ERRLMW +   23)    /*        lmw.c: 825 */
#define   ELMW024      (ERRLMW +   24)    /*        lmw.c: 829 */
#define   ELMW025      (ERRLMW +   25)    /*        lmw.c: 834 */
#define   ELMW026      (ERRLMW +   26)    /*        lmw.c: 840 */
#define   ELMW027      (ERRLMW +   27)    /*        lmw.c: 845 */
#define   ELMW028      (ERRLMW +   28)    /*        lmw.c: 857 */
#define   ELMW029      (ERRLMW +   29)    /*        lmw.c: 863 */
#define   ELMW030      (ERRLMW +   30)    /*        lmw.c: 864 */
#define   ELMW031      (ERRLMW +   31)    /*        lmw.c: 865 */
#define   ELMW032      (ERRLMW +   32)    /*        lmw.c: 866 */
#define   ELMW033      (ERRLMW +   33)    /*        lmw.c:1150 */
#define   ELMW034      (ERRLMW +   34)    /*        lmw.c:1155 */
#define   ELMW035      (ERRLMW +   35)    /*        lmw.c:1159 */
#define   ELMW036      (ERRLMW +   36)    /*        lmw.c:1163 */
#define   ELMW037      (ERRLMW +   37)    /*        lmw.c:1167 */
#define   ELMW038      (ERRLMW +   38)    /*        lmw.c:1176 */
#define   ELMW039      (ERRLMW +   39)    /*        lmw.c:1182 */
#define   ELMW040      (ERRLMW +   40)    /*        lmw.c:1183 */
#define   ELMW041      (ERRLMW +   41)    /*        lmw.c:1463 */
#define   ELMW042      (ERRLMW +   42)    /*        lmw.c:1468 */
#define   ELMW043      (ERRLMW +   43)    /*        lmw.c:1472 */
#define   ELMW044      (ERRLMW +   44)    /*        lmw.c:1476 */
#define   ELMW045      (ERRLMW +   45)    /*        lmw.c:1480 */
#define   ELMW046      (ERRLMW +   46)    /*        lmw.c:1488 */
#define   ELMW047      (ERRLMW +   47)    /*        lmw.c:1495 */
#define   ELMW048      (ERRLMW +   48)    /*        lmw.c:1496 */
#define   ELMW049      (ERRLMW +   49)    /*        lmw.c:1497 */
#define   ELMW050      (ERRLMW +   50)    /*        lmw.c:1498 */
#define   ELMW051      (ERRLMW +   51)    /*        lmw.c:1536 */
#define   ELMW052      (ERRLMW +   52)    /*        lmw.c:1540 */
#define   ELMW053      (ERRLMW +   53)    /*        lmw.c:1542 */
#define   ELMW054      (ERRLMW +   54)    /*        lmw.c:1543 */
#define   ELMW055      (ERRLMW +   55)    /*        lmw.c:1544 */
#define   ELMW056      (ERRLMW +   56)    /*        lmw.c:1545 */
#define   ELMW057      (ERRLMW +   57)    /*        lmw.c:1546 */
#define   ELMW058      (ERRLMW +   58)    /*        lmw.c:1584 */
#define   ELMW059      (ERRLMW +   59)    /*        lmw.c:1586 */
#define   ELMW060      (ERRLMW +   60)    /*        lmw.c:1587 */
#define   ELMW061      (ERRLMW +   61)    /*        lmw.c:1625 */
#define   ELMW062      (ERRLMW +   62)    /*        lmw.c:1627 */
#define   ELMW063      (ERRLMW +   63)    /*        lmw.c:1628 */
#define   ELMW064      (ERRLMW +   64)    /*        lmw.c:1667 */
#define   ELMW065      (ERRLMW +   65)    /*        lmw.c:1673 */
#define   ELMW066      (ERRLMW +   66)    /*        lmw.c:1678 */
#define   ELMW067      (ERRLMW +   67)    /*        lmw.c:1683 */
#define   ELMW068      (ERRLMW +   68)    /*        lmw.c:1688 */
#define   ELMW069      (ERRLMW +   69)    /*        lmw.c:1692 */
#define   ELMW070      (ERRLMW +   70)    /*        lmw.c:1696 */
#define   ELMW071      (ERRLMW +   71)    /*        lmw.c:1702 */
#define   ELMW072      (ERRLMW +   72)    /*        lmw.c:1711 */
#define   ELMW073      (ERRLMW +   73)    /*        lmw.c:1715 */
#define   ELMW074      (ERRLMW +   74)    /*        lmw.c:1719 */
#define   ELMW075      (ERRLMW +   75)    /*        lmw.c:1723 */
#define   ELMW076      (ERRLMW +   76)    /*        lmw.c:1727 */
#define   ELMW077      (ERRLMW +   77)    /*        lmw.c:1728 */
#define   ELMW078      (ERRLMW +   78)    /*        lmw.c:1729 */
#define   ELMW079      (ERRLMW +   79)    /*        lmw.c:1769 */
#define   ELMW080      (ERRLMW +   80)    /*        lmw.c:1774 */
#define   ELMW081      (ERRLMW +   81)    /*        lmw.c:1777 */
#define   ELMW082      (ERRLMW +   82)    /*        lmw.c:1780 */
#define   ELMW083      (ERRLMW +   83)    /*        lmw.c:1784 */
#define   ELMW084      (ERRLMW +   84)    /*        lmw.c:1791 */
#define   ELMW085      (ERRLMW +   85)    /*        lmw.c:1793 */
#define   ELMW086      (ERRLMW +   86)    /*        lmw.c:1796 */
#define   ELMW087      (ERRLMW +   87)    /*        lmw.c:1799 */
#define   ELMW088      (ERRLMW +   88)    /*        lmw.c:1800 */
#define   ELMW089      (ERRLMW +   89)    /*        lmw.c:1801 */
#define   ELMW090      (ERRLMW +   90)    /*        lmw.c:1807 */
#define   ELMW091      (ERRLMW +   91)    /*        lmw.c:1810 */
#define   ELMW092      (ERRLMW +   92)    /*        lmw.c:1814 */
#define   ELMW093      (ERRLMW +   93)    /*        lmw.c:1816 */
#define   ELMW094      (ERRLMW +   94)    /*        lmw.c:1824 */
#define   ELMW095      (ERRLMW +   95)    /*        lmw.c:1828 */
#define   ELMW096      (ERRLMW +   96)    /*        lmw.c:1832 */
#define   ELMW097      (ERRLMW +   97)    /*        lmw.c:1836 */
#define   ELMW098      (ERRLMW +   98)    /*        lmw.c:1840 */
#define   ELMW099      (ERRLMW +   99)    /*        lmw.c:1841 */
#define   ELMW100      (ERRLMW +  100)    /*        lmw.c:1880 */
#define   ELMW101      (ERRLMW +  101)    /*        lmw.c:1885 */
#define   ELMW102      (ERRLMW +  102)    /*        lmw.c:1889 */
#define   ELMW103      (ERRLMW +  103)    /*        lmw.c:1894 */
#define   ELMW104      (ERRLMW +  104)    /*        lmw.c:1899 */
#define   ELMW105      (ERRLMW +  105)    /*        lmw.c:1903 */
#define   ELMW106      (ERRLMW +  106)    /*        lmw.c:1908 */
#define   ELMW107      (ERRLMW +  107)    /*        lmw.c:1917 */
#define   ELMW108      (ERRLMW +  108)    /*        lmw.c:1921 */
#define   ELMW109      (ERRLMW +  109)    /*        lmw.c:1925 */
#define   ELMW110      (ERRLMW +  110)    /*        lmw.c:1929 */
#define   ELMW111      (ERRLMW +  111)    /*        lmw.c:1933 */
#define   ELMW112      (ERRLMW +  112)    /*        lmw.c:1934 */
#define   ELMW113      (ERRLMW +  113)    /*        lmw.c:1935 */
#define   ELMW114      (ERRLMW +  114)    /*        lmw.c:1936 */
#define   ELMW115      (ERRLMW +  115)    /*        lmw.c:2557 */
#define   ELMW116      (ERRLMW +  116)    /*        lmw.c:2583 */
#define   ELMW117      (ERRLMW +  117)    /*        lmw.c:2627 */
#define   ELMW118      (ERRLMW +  118)    /*        lmw.c:2628 */
#define   ELMW119      (ERRLMW +  119)    /*        lmw.c:2673 */
#define   ELMW120      (ERRLMW +  120)    /*        lmw.c:2674 */
#define   ELMW121      (ERRLMW +  121)    /*        lmw.c:2675 */
#define   ELMW122      (ERRLMW +  122)    /*        lmw.c:2676 */
#define   ELMW123      (ERRLMW +  123)    /*        lmw.c:2695 */
#define   ELMW124      (ERRLMW +  124)    /*        lmw.c:2701 */
#define   ELMW125      (ERRLMW +  125)    /*        lmw.c:2710 */
#define   ELMW126      (ERRLMW +  126)    /*        lmw.c:2717 */
#define   ELMW127      (ERRLMW +  127)    /*        lmw.c:2721 */
#define   ELMW128      (ERRLMW +  128)    /*        lmw.c:2726 */
#define   ELMW129      (ERRLMW +  129)    /*        lmw.c:2733 */
#define   ELMW130      (ERRLMW +  130)    /*        lmw.c:2739 */
#define   ELMW131      (ERRLMW +  131)    /*        lmw.c:2746 */
#define   ELMW132      (ERRLMW +  132)    /*        lmw.c:2747 */
#define   ELMW133      (ERRLMW +  133)    /*        lmw.c:2748 */
#define   ELMW134      (ERRLMW +  134)    /*        lmw.c:2749 */
#define   ELMW135      (ERRLMW +  135)    /*        lmw.c:2754 */
#define   ELMW136      (ERRLMW +  136)    /*        lmw.c:2760 */
#define   ELMW137      (ERRLMW +  137)    /*        lmw.c:2769 */
#define   ELMW138      (ERRLMW +  138)    /*        lmw.c:2773 */
#define   ELMW139      (ERRLMW +  139)    /*        lmw.c:2777 */
#define   ELMW140      (ERRLMW +  140)    /*        lmw.c:2781 */
#define   ELMW141      (ERRLMW +  141)    /*        lmw.c:2786 */
#define   ELMW142      (ERRLMW +  142)    /*        lmw.c:2798 */
#define   ELMW143      (ERRLMW +  143)    /*        lmw.c:2842 */
#define   ELMW144      (ERRLMW +  144)    /*        lmw.c:2843 */
#define   ELMW145      (ERRLMW +  145)    /*        lmw.c:3146 */
#define   ELMW146      (ERRLMW +  146)    /*        lmw.c:3147 */
#define   ELMW147      (ERRLMW +  147)    /*        lmw.c:3152 */
#define   ELMW148      (ERRLMW +  148)    /*        lmw.c:3156 */
#define   ELMW149      (ERRLMW +  149)    /*        lmw.c:3160 */
#define   ELMW150      (ERRLMW +  150)    /*        lmw.c:3165 */
#define   ELMW151      (ERRLMW +  151)    /*        lmw.c:3174 */
#define   ELMW152      (ERRLMW +  152)    /*        lmw.c:3219 */
#define   ELMW153      (ERRLMW +  153)    /*        lmw.c:3220 */
#define   ELMW154      (ERRLMW +  154)    /*        lmw.c:3221 */
#define   ELMW155      (ERRLMW +  155)    /*        lmw.c:3226 */
#define   ELMW156      (ERRLMW +  156)    /*        lmw.c:3230 */
#define   ELMW157      (ERRLMW +  157)    /*        lmw.c:3234 */
#define   ELMW158      (ERRLMW +  158)    /*        lmw.c:3239 */
#define   ELMW159      (ERRLMW +  159)    /*        lmw.c:3247 */
#define   ELMW160      (ERRLMW +  160)    /*        lmw.c:3253 */
#define   ELMW161      (ERRLMW +  161)    /*        lmw.c:3258 */
#define   ELMW162      (ERRLMW +  162)    /*        lmw.c:3263 */
#define   ELMW163      (ERRLMW +  163)    /*        lmw.c:3268 */
#define   ELMW164      (ERRLMW +  164)    /*        lmw.c:3273 */
#define   ELMW165      (ERRLMW +  165)    /*        lmw.c:3279 */
#define   ELMW166      (ERRLMW +  166)    /*        lmw.c:3325 */
#define   ELMW167      (ERRLMW +  167)    /*        lmw.c:3326 */
#define   ELMW168      (ERRLMW +  168)    /*        lmw.c:3331 */
#define   ELMW169      (ERRLMW +  169)    /*        lmw.c:3335 */
#define   ELMW170      (ERRLMW +  170)    /*        lmw.c:3339 */
#define   ELMW171      (ERRLMW +  171)    /*        lmw.c:3343 */
#define   ELMW172      (ERRLMW +  172)    /*        lmw.c:3350 */
#define   ELMW173      (ERRLMW +  173)    /*        lmw.c:3354 */
#define   ELMW174      (ERRLMW +  174)    /*        lmw.c:3356 */
#define   ELMW175      (ERRLMW +  175)    /*        lmw.c:3360 */
#define   ELMW176      (ERRLMW +  176)    /*        lmw.c:3364 */
#define   ELMW177      (ERRLMW +  177)    /*        lmw.c:3365 */
#define   ELMW178      (ERRLMW +  178)    /*        lmw.c:3366 */
#define   ELMW179      (ERRLMW +  179)    /*        lmw.c:3369 */
#define   ELMW180      (ERRLMW +  180)    /*        lmw.c:3371 */
#define   ELMW181      (ERRLMW +  181)    /*        lmw.c:3375 */
#define   ELMW182      (ERRLMW +  182)    /*        lmw.c:3380 */
#define   ELMW183      (ERRLMW +  183)    /*        lmw.c:3385 */
#define   ELMW184      (ERRLMW +  184)    /*        lmw.c:3387 */
#define   ELMW185      (ERRLMW +  185)    /*        lmw.c:3390 */
#define   ELMW186      (ERRLMW +  186)    /*        lmw.c:3691 */
#define   ELMW187      (ERRLMW +  187)    /*        lmw.c:3692 */
#define   ELMW188      (ERRLMW +  188)    /*        lmw.c:3693 */
#define   ELMW189      (ERRLMW +  189)    /*        lmw.c:3694 */
#define   ELMW190      (ERRLMW +  190)    /*        lmw.c:3700 */
#define   ELMW191      (ERRLMW +  191)    /*        lmw.c:3704 */
#define   ELMW192      (ERRLMW +  192)    /*        lmw.c:3708 */
#define   ELMW193      (ERRLMW +  193)    /*        lmw.c:3712 */
#define   ELMW194      (ERRLMW +  194)    /*        lmw.c:3729 */
#define   ELMW195      (ERRLMW +  195)    /*        lmw.c:3773 */
#define   ELMW196      (ERRLMW +  196)    /*        lmw.c:3774 */
#define   ELMW197      (ERRLMW +  197)    /*        lmw.c:3775 */
#define   ELMW198      (ERRLMW +  198)    /*        lmw.c:3776 */
#define   ELMW199      (ERRLMW +  199)    /*        lmw.c:3781 */
#define   ELMW200      (ERRLMW +  200)    /*        lmw.c:3785 */
#define   ELMW201      (ERRLMW +  201)    /*        lmw.c:3789 */
#define   ELMW202      (ERRLMW +  202)    /*        lmw.c:3793 */
#define   ELMW203      (ERRLMW +  203)    /*        lmw.c:3801 */
#define   ELMW204      (ERRLMW +  204)    /*        lmw.c:3805 */
#define   ELMW205      (ERRLMW +  205)    /*        lmw.c:3809 */
#define   ELMW206      (ERRLMW +  206)    /*        lmw.c:3813 */
#define   ELMW207      (ERRLMW +  207)    /*        lmw.c:3817 */
#define   ELMW208      (ERRLMW +  208)    /*        lmw.c:3823 */
#define   ELMW209      (ERRLMW +  209)    /*        lmw.c:3906 */
#define   ELMW210      (ERRLMW +  210)    /*        lmw.c:3907 */
/*lmw_h_001.main_4 Error causes added*/
#define   ELMW211      (ERRLMW +  211)    /*        lmw.c:1796 */
#define   ELMW212      (ERRLMW +  212)    /*        lmw.c:3389 */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LMWH__ */


/********************************************************************30**

  End of file:     lmw.h@@/main/4 - Fri Feb  8 11:50:03 2008

**********************************************************************31*/

/********************************************************************40**

Notes:

**********************************************************************41*/

/********************************************************************50**

**********************************************************************51*/

/********************************************************************60**

  Revision history:

**********************************************************************61*/
/********************************************************************70**

  version    initials                   description
  -----------  ---------  ------------------------------------------------

**********************************************************************71*/

/********************************************************************80**

**********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
/main/1      ---       hl   1. initial release.
                       as   1. Added LMW_CAUSE_SCT_TMR_EXP_MAX_RETRY.
  
/main/2      ---       yz   1. Update for Release 1.2.

/main/2      ---       yz   1. Modify CAUSE codes to avoid duplicate.
                            2. Increase LMW_MAX_INTF value
lmw_h_001.main_3       na   1. Layer specific events added
/main/3      ---       na   1.  Layer specific events added
lmw_h_001.main_3       na   1. Error causes are added.
/main/4      ---       na   1. Error causes are added.
*********************************************************************91*/
