/*******************************************************************************
*
* Title: layer management interface layer1
*
* Description: external defines
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 03-02-2010
*
*******************************************************************************/

#ifndef __LL1X__
#define __LL1X__

typedef struct l1GenCfg
{
    S16     nmbLnks;
    Status  poolTrLower;          /* lower pool threshold */
    Status  poolTrUpper;          /* upper pool threshold */
    Pst     sm;                      /* stack manager */

} l1GenCfg;

typedef struct l1PSAPCfg
{
    SpId    spId;               /* service provider Id this is for */
    U32     span;               /* the TDMV_SPAN number */
    U32     chan;               /* the channel/time slot number */
    S32     sockfd;
    U8	    extSeqNum;
} l1PSAPCfg;

typedef struct L1Mngmt
{
    Header hdr;
    CmStatus cfm;

    union
    {

        /*configuration*/
        struct
        {
            union
            {
                l1GenCfg    l1Gen;
                l1PSAPCfg   l1PSAP;
            }s;
        }cfg;

        /*statistics*/

        /*solicited status*/

        /*unsolicited status*/
        struct
        {
            CmAlarm alarm;         /* common alarm structure */
            U8 evntParm[8];        /* event parameters */
        } usta;                   /* unsolicited status */

        /*trace*/

	/*control*/
	struct
	{
		U8 action;             /* action */
		U8 subAction;          /* sub action */
		U8 status;		       /* status */
        SpId spId;             /* service provider Id */
	} cntrl;


    }t;

} L1Mngmt;

EXTERN S16 smL1ActvTsk ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smL1ActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));

/* depending on the specific selector in the post structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */
 
typedef S16 (*Ll1StaInd) ARGS((Pst *pst,L1Mngmt *sta));
typedef S16 (*Ll1TrcInd) ARGS((Pst *pst,L1Mngmt *trc));
typedef S16 (*Ll1StaCfm) ARGS((Pst *pst,L1Mngmt *sta));
typedef S16 (*Ll1StsCfm) ARGS((Pst *pst, Action action,L1Mngmt *sts));
typedef S16 (*Ll1CfgReq) ARGS((Pst *pst,L1Mngmt *cfg));
typedef S16 (*Ll1StaReq) ARGS((Pst *pst,L1Mngmt *sta));
typedef S16 (*Ll1StsReq) ARGS((Pst *pst,Action action,L1Mngmt *sts));
typedef S16 (*Ll1CntrlReq) ARGS((Pst *pst,L1Mngmt *cntrl));
typedef S16 (*Ll1CfgCfm) ARGS((Pst *pst,L1Mngmt *cfm));
typedef S16 (*Ll1CntrlCfm) ARGS((Pst *pst,L1Mngmt *cfm));

#ifdef L1       /* layer1 */
EXTERN  S16 L1MiLl1CfgReq ARGS((Pst *pst, L1Mngmt *cfg));
/*EXTERN  S16 L1MiLl1StaReq ARGS((Pst *pst, L1Mngmt *sta));*/
/*EXTERN  S16 L1MiLl1StsReq ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
EXTERN  S16 L1MiLl1CntrlReq ARGS((Pst *pst, L1Mngmt *cntrl));
EXTERN  S16 L1MiLl1StaInd ARGS((Pst *pst, L1Mngmt *sta));
/*EXTERN  S16 L1MiLl1StaCfm ARGS((Pst *pst, L1Mngmt *sta));*/
/*EXTERN  S16 L1MiLl1StsCfm ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
/*EXTERN  S16 L1MiLl1TrcInd ARGS((Pst *pst, L1Mngmt *trc));*/
EXTERN  S16 L1MiLl1CfgCfm ARGS((Pst *pst, L1Mngmt *cfm));
EXTERN  S16 L1MiLl1CntrlCfm ARGS((Pst *pst, L1Mngmt *cfm));
#endif
#ifdef SM
EXTERN  S16 SmMiLl1StaInd ARGS((Pst *pst, L1Mngmt *sta));
/*EXTERN  S16 SmMiLl1StaCfm ARGS((Pst *pst, L1Mngmt *sta));*/
/*EXTERN  S16 SmMiLl1StsCfm ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
/*EXTERN  S16 SmMiLl1TrcInd ARGS((Pst *pst, L1Mngmt *trc));*/
EXTERN  S16 SmMiLl1CfgReq ARGS((Pst *pst, L1Mngmt *cfg));
/*EXTERN  S16 SmMiLl1StaReq ARGS((Pst *pst, L1Mngmt *sta));*/
/*EXTERN  S16 SmMiLl1StsReq ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
EXTERN  S16 SmMiLl1CntrlReq ARGS((Pst *pst, L1Mngmt *cntrl));
EXTERN  S16 SmMiLl1CfgCfm ARGS((Pst *pst, L1Mngmt *cfm));
EXTERN  S16 SmMiLl1CntrlCfm ARGS((Pst *pst, L1Mngmt *cfm));
#endif

/* layer manager interface packing/unpacking functions - common to LL1 */

EXTERN S16 cmPkLl1CfgCfm ARGS((Pst *pst, L1Mngmt *cfm));
EXTERN S16 cmPkLl1CntrlCfm ARGS((Pst *pst, L1Mngmt *cfm));
/*EXTERN S16 cmPkLl1StaCfm ARGS((Pst *pst, L1Mngmt *sta));*/
EXTERN S16 cmPkLl1StaInd ARGS((Pst *pst, L1Mngmt *sta));
/*EXTERN S16 cmPkLl1StsCfm ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
/*EXTERN S16 cmPkLl1TrcInd ARGS((Pst *pst, L1Mngmt *trc));*/
EXTERN S16 cmUnpkLl1CfgReq ARGS((Ll1CfgReq func, Pst *pst, Buffer *mBuf));
/*EXTERN S16 cmUnpkLl1StaReq ARGS((Ll1StaReq func, Pst *pst, Buffer *mBuf));*/
/*EXTERN S16 cmUnpkLl1StsReq ARGS((Ll1StsReq func, Pst *pst, Buffer *mBuf));*/
EXTERN S16 cmUnpkLl1CntrlReq ARGS((Ll1CntrlReq func, Pst *pst, Buffer *mBuf));
/*EXTERN S16 cmPkLl1StsReq ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
EXTERN S16 cmPkLl1CfgReq ARGS((Pst *pst, L1Mngmt *cfg));
/*EXTERN S16 cmPkLl1StaReq ARGS((Pst *pst, L1Mngmt *sta));*/
EXTERN S16 cmPkLl1CntrlReq ARGS((Pst *pst, L1Mngmt *cntrl));
/*EXTERN S16 cmUnpkLl1StaCfm ARGS((Ll1StaCfm func, Pst *pst, Buffer *mBuf));*/
/*EXTERN S16 cmUnpkLl1StsCfm ARGS((Ll1StsCfm func, Pst *pst, Buffer *mBuf));*/
EXTERN S16 cmUnpkLl1StaInd ARGS((Ll1StaInd func, Pst *pst, Buffer *mBuf));
/*EXTERN S16 cmUnpkLl1TrcInd ARGS((Ll1TrcInd func, Pst *pst, Buffer *mBuf));*/
EXTERN S16 cmUnpkLl1CfgCfm ARGS((Ll1CfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLl1CntrlCfm ARGS((Ll1CntrlCfm func, Pst *pst, Buffer *mBuf));

#endif
/******************************************************************************/
