/*******************************************************************************
*
* Title: layer management interface layer1
*
* Description: defines
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 03-02-2010
*
*******************************************************************************/

#ifndef __LL1H__
#define __LL1H__

#define MAXL1UI 3
#define MAXL1MI 3

#define LL1_EVENT_OOB           11
#define LL1_EVENT_CON_REQ       12
#define LL1_EVENT_DISCON_REQ    13
#define LL1_EVENT_RX_ERROR      14
#define LL1_EVENT_TX_ERROR      15

#define LL1_CAUSE_DISCONNECTED  31
#define LL1_CAUSE_CONNECTED     32
#define LL1_CAUSE_UPPER_INF     33
#define LL1_CAUSE_MNGMNT_INF    34
#define LL1_CAUSE_INVALID_SIZE  35

#define L1_SUCCESSFUL           1
#define L1_FAIL                 2
#define L1_ALREADY_CONNECTED    3
#define L1_ALREADY_ACTIVE       4

/* L1 Management Events */

#define EVTLL1CFGREQ     0x3c             /* Configuration request */
#define EVTLL1STAREQ     0x40             /* Status request */
#define EVTLL1STACFM     0x41             /* Status confirm */
#define EVTLL1STAIND     0x42             /* Status indication */
#define EVTLL1STSREQ     0x44             /* Statistics request */
#define EVTLL1STSCFM     0x45             /* Statistics confirm */
#define EVTLL1TRCIND     0x48             /* Trace indication */
#define EVTLL1CNTRLREQ   0x4c             /* Control request */
#define EVTLL1CNTRLCFM   0x4d             /* Control confirm */
#define EVTLL1CFGCFM     0x4e             /* Config confirm */


/* error codes for common packing/unpacking functions at layer manager
 * interface
 */

#define ELL1BASE       0            /* reserved */
#define ELL1XXX        (ELL1BASE)   /* reserved */

#endif

/******************************************************************************/
