/*******************************************************************************
*
* Title: lcc.x
*
* Description: inter=layer communications for CC 
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 03-15-2010
*
*******************************************************************************/

#ifndef __LCC_X__
#define __LCC_X__

/* INCLUDES *******************************************************************/

/* DEFINES ********************************************************************/

/* GLOBALS ********************************************************************/
typedef struct CcGenCfg
{
    Dpc     spc;
    Status  poolTrLower;          /* lower pool threshold */
    Status  poolTrUpper;          /* upper pool threshold */
    Pst     sm;                      /* stack manager */

} CcGenCfg_t;

typedef struct CcISAP
{
    SpId    suId;
    SpId    spId;
    Pst     pst;
}CcISAP_t;

typedef struct CcMngmt
{
    Header hdr;
    CmStatus cfm;

    union
    {

        /*configuration*/
        struct
        {
            union
            {
                CcGenCfg_t  ccGen;
                CcISAP_t    ccISAP;
            }s;
        }cfg;

        /*statistics*/

        /*solicited status*/

        /*unsolicited status*/
        struct
        {
            CmAlarm alarm;         /* common alarm structure */
            U8 evntParm[8];        /* event parameters */
        } usta;                   /* unsolicited status */

        /*trace*/

        /*control*/
        struct
        {
            DateTime dt;           /* date and time */
            U8 action;             /* action */
            U8 subAction;          /* sub action */
        } cntrl;                  /* control */
    }t;
} CcMngmt;


/* FUNCTION *******************************************************************/

EXTERN S16 ccActvInit ARGS((Ent entity,Inst inst,Region region,Reason reason));
EXTERN S16 smCcActvTsk ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smCcActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));

typedef S16 (*LccStaInd) ARGS((Pst *pst,CcMngmt *sta));
typedef S16 (*LccTrcInd) ARGS((Pst *pst,CcMngmt *trc));
typedef S16 (*LccStaCfm) ARGS((Pst *pst,CcMngmt *sta));
typedef S16 (*LccStsCfm) ARGS((Pst *pst, Action action, CcMngmt *sts));
typedef S16 (*LccCfgReq) ARGS((Pst *pst,CcMngmt *cfg));
typedef S16 (*LccStaReq) ARGS((Pst *pst,CcMngmt *sta));
typedef S16 (*LccStsReq) ARGS((Pst *pst,Action action,CcMngmt *sts));
typedef S16 (*LccCntrlReq) ARGS((Pst *pst,CcMngmt *cntrl));
typedef S16 (*LccCfgCfm) ARGS((Pst *pst,CcMngmt *cfm));
typedef S16 (*LccCntrlCfm) ARGS((Pst *pst,CcMngmt *cfm));

#ifdef CC       /* layer1 */
EXTERN  S16 CcMiLccCfgReq ARGS((Pst *pst, CcMngmt *cfg));
/*EXTERN  S16 CcMiLccStaReq ARGS((Pst *pst, CcMngmt *sta));*/
/*EXTERN  S16 CcMiLccStsReq ARGS((Pst *pst, Action action, CcMngmt *sts));*/
EXTERN  S16 CcMiLccCntrlReq ARGS((Pst *pst, CcMngmt *cntrl));
EXTERN  S16 CcMiLccStaInd ARGS((Pst *pst, CcMngmt *sta));
/*EXTERN  S16 CcMiLccStaCfm ARGS((Pst *pst, CcMngmt *sta));*/
/*EXTERN  S16 CcMiLccStsCfm ARGS((Pst *pst, Action action, CcMngmt *sts));*/
/*EXTERN  S16 CcMiLccTrcInd ARGS((Pst *pst, CcMngmt *trc));*/
EXTERN  S16 CcMiLccCfgCfm ARGS((Pst *pst, CcMngmt *cfm));
EXTERN  S16 CcMiLccCntrlCfm ARGS((Pst *pst, CcMngmt *cfm));
#endif /* CC */
#ifdef SM
EXTERN  S16 SmMiLccStaInd ARGS((Pst *pst, CcMngmt *sta));
/*EXTERN  S16 SmMiLccStaCfm ARGS((Pst *pst, CcMngmt *sta));*/
/*EXTERN  S16 SmMiLccStsCfm ARGS((Pst *pst, Action action, CcMngmt *sts));*/
/*EXTERN  S16 SmMiLccTrcInd ARGS((Pst *pst, CcMngmt *trc));*/
EXTERN  S16 SmMiLccCfgReq ARGS((Pst *pst, CcMngmt *cfg));
/*EXTERN  S16 SmMiLccStaReq ARGS((Pst *pst, CcMngmt *sta));*/
/*EXTERN  S16 SmMiLccStsReq ARGS((Pst *pst, Action action, CcMngmt *sts));*/
EXTERN  S16 SmMiLccCntrlReq ARGS((Pst *pst, CcMngmt *cntrl));
EXTERN  S16 SmMiLccCfgCfm ARGS((Pst *pst, CcMngmt *cfm));
EXTERN  S16 SmMiLccCntrlCfm ARGS((Pst *pst, CcMngmt *cfm));
#endif /* SM */

/* layer manager interface packing/unpacking functions - common to LCc */

EXTERN S16 cmPkLccCfgCfm ARGS((Pst *pst, CcMngmt *cfm));
EXTERN S16 cmPkLccCntrlCfm ARGS((Pst *pst, CcMngmt *cfm));
/*EXTERN S16 cmPkLccStaCfm ARGS((Pst *pst, CcMngmt *sta));*/
EXTERN S16 cmPkLccStaInd ARGS((Pst *pst, CcMngmt *sta));
/*EXTERN S16 cmPkLccStsCfm ARGS((Pst *pst, Action action, CcMngmt *sts));*/
/*EXTERN S16 cmPkLccTrcInd ARGS((Pst *pst, CcMngmt *trc));*/
EXTERN S16 cmUnpkLccCfgReq ARGS((LccCfgReq func, Pst *pst, Buffer *mBuf));
/*EXTERN S16 cmUnpkLccStaReq ARGS((LccStaReq func, Pst *pst, Buffer *mBuf));*/
/*EXTERN S16 cmUnpkLccStsReq ARGS((LccStsReq func, Pst *pst, Buffer *mBuf));*/
EXTERN S16 cmUnpkLccCntrlReq ARGS((LccCntrlReq func, Pst *pst, Buffer *mBuf));
/*EXTERN S16 cmPkLccStsReq ARGS((Pst *pst, Action action, CcMngmt *sts));*/
EXTERN S16 cmPkLccCfgReq ARGS((Pst *pst, CcMngmt *cfg));
/*EXTERN S16 cmPkLccStaReq ARGS((Pst *pst, CcMngmt *sta));*/
EXTERN S16 cmPkLccCntrlReq ARGS((Pst *pst, CcMngmt *cntrl));
/*EXTERN S16 cmUnpkLccStaCfm ARGS((LccStaCfm func, Pst *pst, Buffer *mBuf));*/
/*EXTERN S16 cmUnpkLccStsCfm ARGS((LccStsCfm func, Pst *pst, Buffer *mBuf));*/
EXTERN S16 cmUnpkLccStaInd ARGS((LccStaInd func, Pst *pst, Buffer *mBuf));
/*EXTERN S16 cmUnpkLccTrcInd ARGS((LccTrcInd func, Pst *pst, Buffer *mBuf));*/
EXTERN S16 cmUnpkLccCfgCfm ARGS((LccCfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLccCntrlCfm ARGS((LccCntrlCfm func, Pst *pst, Buffer *mBuf));


#endif /* __LCC_X__ */
/******************************************************************************/
