/*******************************************************************************
*
* Title: lcc.h
*
* Description: inter=layer communications for CC 
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 03-15-2010
*
*******************************************************************************/

#ifndef __LCC_H__
#define __LCC_H__

#define MAXCCLI 1
#define MAXCCMI 2


#define LCC_UNKNOWN_CAUSE   0x00        /* unknown cause/irrelvant */
#define LCC_REMOTE_REQUEST  0x01        /* Remote Request */

#define LCC_STA_CIRRESET    0x60        /* Circuit Reset Complete */



/* L1 Management Events */

#define EVTLCCCFGREQ     0x3c           /* Configuration request */
#define EVTLCCSTAREQ     0x40           /* Status request */
#define EVTLCCSTACFM     0x41           /* Status confirm */
#define EVTLCCSTAIND     0x42           /* Status indication */
#define EVTLCCSTSREQ     0x44           /* Statistics request */
#define EVTLCCSTSCFM     0x45           /* Statistics confirm */
#define EVTLCCTRCIND     0x48           /* Trace indication */
#define EVTLCCCNTRLREQ   0x4c           /* Control request */
#define EVTLCCCNTRLCFM   0x4d           /* Control confirm */
#define EVTLCCCFGCFM     0x4e           /* Config confirm */


/* error codes for common packing/unpacking functions at layer manager
 * interface
 */

#define ELCCBASE       0            /* reserved */
#define ELCCXXX        (ELCCBASE)   /* reserved */

#endif /* __LCC_H__ */
/******************************************************************************/
