

#ifndef __LAPX__
#define __LAPX__

typedef struct apGenCfg         /* MTP Level 3 Lower Inteface general configuration */
{
   U16 nmbDLSap;                /* number of MTP Data Link SAPs */
   Pst sm;                      /* stack manager */
} ApGenCfg;

typedef struct apDLSapCfg       /* MTP Level 3 data link configuration */
{	
	SpId		spId;			/* service provider id */
	SpId		suId;			/* service provider id */
	Pst			pst;
} ApDLSapCfg;

/* management message */

typedef struct apMngmt
{
   Header hdr;                  /* header */
   CmStatus cfm;                /* confirm structure */

	union {
		/* configuration */
		struct
		{
			union
			{
				ApGenCfg apGen;     /* MTP 3 Lower Interface - general */
				ApDLSapCfg apDLSAP; /* MTP 3 Lowe Interface - data link SAP */
			} s;
		} cfg; /* configuration */
		
		/* statistics */
#if 0		
		struct
		{
			DateTime dt;           /* date and time */
			Duration dura;         /* duration */
			union
			{
				SnGlbSts snGlb;     /* MTP level 3 - signalling point */
				SnNSAPSts snNSAP;   /* MTP level 3- NSAP */
				SnDLSAPSts snDLSAP; /* MTP level 3 - link SAP */
				SnRoutSts snRout;   /* MTP level 3 - route */
				SnLnkSetSts snLnkSet; /* MTP level 3 - linkset */
			} s;
		} sts; /* statistics */
#endif
  
#if 0
/* solicited status */ 
		struct
		{
			DateTime dt;           /* date and time */
			union
			{
				SnSAPSta snSAP;     /* MTP Level 3 SAP status  */
				SnDLSAPSta snDLSAP; /* MTP Level 3 link status  */	
				SnLnkSetSta snLnkSet;/* MTP Level 3 link set status  */
				SnRoutSta snRout;   /* MTP Level 3 route status  */	
				SnSPSta snSP;       /* MTP Level 3 signalling point status  */
				SystemId sysId;     /* system id */
			} s;
		} ssta;                   /* solicited status */
#endif 

		struct
		{
			DateTime dt;           /* date and time */
			U16 evnt;              /* event */
			U8 evntParm[MAX_EVT_TRC_LENGTH];       /* event parameters */
		} trc;                    /* trace */

/* unsolicited status */
		struct
		{
#if (SN_LMINT3 || SMSN_LMINT3)
         CmAlarm alarm;         /* common alarm structure */
#else
         DateTime dt;           /* date and time */
         U16 evnt;              /* event number */
#endif /* SN_LMINT3 || SMSN_LMINT3 */
         U8 evntParm[8];        /* event parameters */		
		} usta;                   /* unsolicited status */

/* control */
		struct
		{
			DateTime dt;           /* date and time */
			U8 action;             /* action */
			U8 subAction;          /* sub action */
			U8 status;		/* status */
		} cntrl;                  /* control */
	}t;
} ApMngmt;


typedef S16 (*LapStaInd) ARGS((Pst *pst, ApMngmt *sta));
typedef S16 (*LapStaCfm) ARGS((Pst *pst, ApMngmt *sta));
typedef S16 (*LapStsCfm) ARGS((Pst *pst, Action action, ApMngmt *sts));
typedef S16 (*LapCfgReq) ARGS((Pst *pst, ApMngmt *cfg));
typedef S16 (*LapStaReq) ARGS((Pst *pst, ApMngmt *sta));
typedef S16 (*LapStsReq) ARGS((Pst *pst, Action action, ApMngmt *sts));
typedef S16 (*LapTrcInd) ARGS((Pst *pst, ApMngmt *trc));
typedef S16 (*LapCntrlReq) ARGS((Pst *pst, ApMngmt *cntrl));
typedef S16 (*LapCfgCfm) ARGS((Pst *pst, ApMngmt *cfg));
typedef S16 (*LapCntrlCfm) ARGS((Pst *pst, ApMngmt *cfg));


EXTERN  S16 SmMiLapStaInd ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 SmMiLapStaCfm ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 SmMiLapStsCfm ARGS((Pst *pst, Action action, ApMngmt *sts));
EXTERN  S16 SmMiLapCfgReq ARGS((Pst *pst, ApMngmt *cfg));
EXTERN  S16 SmMiLapStaReq ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 SmMiLapStsReq ARGS((Pst *pst, Action action, ApMngmt *sts));
EXTERN  S16 SmMiLapCntrlReq ARGS((Pst *pst, ApMngmt *cntrl));
EXTERN  S16 SmMiLapTrcInd ARGS((Pst *pst, ApMngmt *trc));
EXTERN  S16 SmMiLapCfgCfm ARGS((Pst *pst, ApMngmt *cfg));
EXTERN  S16 SmMiLapCntrlCfm ARGS((Pst *pst, ApMngmt *cntrl));

EXTERN  S16 SmMiLapStaInd ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 SmMiLapStaCfm ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 SmMiLapStsCfm ARGS((Pst *pst, Action action, ApMngmt *sts));
EXTERN	S16 SmMiLapStaReq ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 SmMiLapStsReq ARGS((Pst *pst, Action action, ApMngmt *sts));
EXTERN  S16 SmMiLapCntrlReq ARGS((Pst *pst, ApMngmt *cntrl));
EXTERN  S16 SmMiLapTrcInd ARGS((Pst *pst, ApMngmt *trc));
EXTERN  S16 SmMiLapCfgCfm ARGS((Pst *pst, ApMngmt *cfg));
EXTERN  S16 SmMiLapCntrlCfm ARGS((Pst *pst, ApMngmt *cntrl));


EXTERN	S16 apActvInit ARGS((Ent entity, Inst inst, Region region, Reason reason));
EXTERN	S16 apActvTsk ARGS((Pst *pst, Buffer *mBuf));

EXTERN S16 smApActvTsk ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smApActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));

EXTERN	S16 ApMiLapCfgReq ARGS((Pst *pst, ApMngmt *cfg));
EXTERN	S16 ApMiLapCntrlReq ARGS((Pst *pst, ApMngmt *cntrl));
EXTERN	S16 ApLiSitBndCfm ARGS((Pst *pst, SuId suId, U8 status));
EXTERN	S16 ApMiLapCfgCfm ARGS((Pst *pst, ApMngmt *cfm));
EXTERN	S16 ApMiLapCntrlCfm ARGS((Pst *pst, ApMngmt *cfm));
EXTERN  S16 ApMiLapStaCfm ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 ApMiLapStsCfm ARGS((Pst *pst, Action action, ApMngmt *sts));
EXTERN  S16 ApMiLapTrcInd ARGS((Pst *pst, ApMngmt *trc));

EXTERN	S16 ApMiLapStaInd ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 ApMiLapStaReq ARGS((Pst *pst, ApMngmt *sta));
EXTERN  S16 ApMiLapStsReq ARGS((Pst *pst, Action action, ApMngmt *sts));

extern S16 cmPkLapStaInd ARGS((Pst *pst, ApMngmt *sta));
extern S16 cmPkLapStaCfm ARGS((Pst *pst, ApMngmt *sta));
extern S16 cmPkLapStsCfm ARGS((Pst *pst, Action action, ApMngmt *sts));
extern S16 cmPkLapTrcInd ARGS((Pst *pst, ApMngmt *trc));

extern S16 cmPkLapCfgCfm ARGS((Pst *pst, ApMngmt *cfm));
extern S16 cmPkLapCntrlCfm ARGS((Pst *pst, ApMngmt *cfm));

extern S16 cmUnpkLapCntrlReq ARGS((LapCntrlReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapStsReq ARGS((LapStsReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapStaReq ARGS((LapStaReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapCfgReq ARGS((LapCfgReq func, Pst *pst, Buffer *mBuf));

extern S16 cmPkLapCfgReq ARGS((Pst *pst, ApMngmt *cfg));
extern S16 cmPkLapCntrlReq ARGS((Pst *pst, ApMngmt *cntrl));
extern S16 cmPkLapStaReq ARGS((Pst *pst, ApMngmt *sta));
extern S16 cmPkLapStsReq ARGS((Pst *pst, Action action, ApMngmt *sts));


extern S16 cmUnpkLapStaCfm ARGS((LapStaCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapStsCfm ARGS((LapStsCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapStaInd ARGS((LapStaInd func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapTrcInd ARGS((LapTrcInd func, Pst *pst, Buffer *mBuf));

extern S16 cmUnpkLapCfgCfm ARGS((LapCfgCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLapCntrlCfm ARGS((LapCntrlCfm func, Pst *pst, Buffer *mBuf));

#endif /* __LAPX__ */
