
#ifndef __LAP_H__
#define __LAP_H__

/* Ap Management Events */

#define EVTLAPCFGREQ     0x3c         /* Configuration request */
#define EVTLAPSTAREQ     0x40         /* Status request */
#define EVTLAPSTACFM     0x41         /* Status confirm */
#define EVTLAPSTAIND     0x42         /* Status indication */
#define EVTLAPSTSREQ     0x44         /* Statistics request */
#define EVTLAPSTSCFM     0x45         /* Statistics confirm */
#define EVTLAPTRCIND     0x48         /* Trace indication */
#define EVTLAPCNTRLREQ   0x4c         /* Control request */

#define EVTLAPCFGCFM     0x4d         /* Configuration confirm */
#define EVTLAPCNTRLCFM   0x4e         /* Control confirm */


/* link states */

#define LAP_LST_INACTIVE     0   /* link inactive state */
#define LAP_LST_CON          1   /* link is connecting */
#define LAP_LST_ACTIVE       2   /* link active state */
#define LAP_LST_FAILED       3   /* link failed state */
#define LAP_LST_WAITCON      4   /* waiting for connection */
#define LAP_LST_SUSPEND      5   /* link restoration suspended */

/* Sap bind states */

#define LAP_UNBND            1   /* sap is unbound */
#define LAP_BND              2   /* sap is bound */
#define LAP_WAIT_BNDCFM      3   /* bind procedure is going on */

#define AP_CON_L1           0     /* connect Level 1 */
#define AP_CON_L2_EMRG      1     /* connect Level 2 in emergency state */
#define AP_CON_L2_NORM      2     /* connect Level 2 in normal state */
#define AP_CON_L1L2_EMRG    3     /* connect Level 1 and 2 in emergency state */
#define AP_CON_L1L2_NORM    4     /* connect Level 1 and 2 in normal state */

#define MAX_EVT_TRC_LENGTH 16

#define LAPLOGERROR(errCls, errCode, errVal, errDesc) \
		SLogError(pst->srcEnt, pst->srcInst, pst->srcProcId, __FILE__, __LINE__, \
					errCls, errCode, errVal, errDesc)


#endif /* __LAP_H__ */
