/********************************************************************16**

                         (c) COPYRIGHT 1989-2005 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     common ss7
  
     Type:     Common file for ss7 products
  
     Desc:     defines used by more than two layers in the ss7 stack
 
     File:     cm_ss7.x

     Sid:      cm_ss7.x@@/main/17 - Thu Jun  3 10:17:13 2010
  
     Prg:      fmg
  
*********************************************************************21*/
 
#ifndef __CMSS7X__
#define __CMSS7X__

#ifdef __cplusplus
EXTERN "C" {
#endif

/* Status Managemnet  structure */

/* SS7 typedefs */

#ifdef SUAP_IPOPT
typedef struct _suaAddr SuaAddr;
#endif /* SUAP_IPOPT */

typedef U32 Dpc;                  /* destination point code */

typedef U8 Ssn;                   /* subsystem number */

typedef U8 Timer;                 /* timer threshhold */

  
typedef U8 RCause;                /* return cause */

typedef U8 Smi;                   /* Subsystem Multiplicity Indicator */

typedef U8 UStat;                 /* User Status */

typedef U8 Sps;                   /* Signalling Point Status */

typedef U8 NIInd;                 /* National/International Indicator */

typedef U32 InstId;               /* instance id */

typedef U16 LnkSetId;             /* link set ID */

typedef U8 SrvInfo;               /* service information */

typedef U8 LnkSel;                /* link selection */

typedef struct cmSS7SteMgmt
{
   U8      evntType;
   union
   {
     struct
     {
       Ssn     aSsn;       /* affected sub system number */ 
     }cordReq;

     struct
     {
       Ssn     aSsn;       /* affected sub system number */
       Smi     smi;        /* Subsystem multiplicity Indicator */
     }cordInd;

     struct
     {
       Ssn     aSsn;       /* affected sub system number */ 
     }cordRsp;

     struct
     {
       Ssn     aSsn;       /* affected sub system number */
       Smi     smi;        /* Subsystem multiplicity Indicator */ 
     }cordCfm;

     struct
     {
       Ssn    aSsn;        /* affected sub system number */
       UStat  uStat;       /* Status of ssn */
     }steReq;

     struct
     {
       Dpc    aDpc;        /* Affected point code */
       Ssn    aSsn;        /* affected sub system number */
       UStat  uStat;       /* Status of ssn */
       Smi    smi;         /* Subsystem multiplicity Indicator */ 
     }steInd;

     struct
     {
       Dpc    dpc;         /* destination point code */
       Sps    sps;         /* Point Code Status */
     }PCSteInd;

     struct
     {
       U8     status;      /* Status of the SteReq */
       Dpc    dpc;         /* destination point code */
       Ssn    ssn;         /* Subsystem number */
     }staReq;

     struct
     {
       U8     status;      /* Status of the SteReq */
     }steCfm;

     struct
     {
       U8     status;      /* Type of Status requested */
       Dpc    dpc;         /* destination point code */
       Ssn    ssn;         /* Subsystem number */
       UStat  ustat;       /* Status of point code/subsystem */
       Smi    smi;         /* Subsystem multiplicity indicator */
     }staCfm;
   }mgmt;
   
}CmSS7SteMgmt;


typedef struct stOctet          /* single octet elements */
{
   Bool pres;                   /* present or not */
   U8 octet;                    /* contents */
} StOctet;




/* global title structure */

typedef struct glbTi
{
    U8 format;                  /* format */
    union
    {
        struct 
        {
            Bool oddEven;       /* odd/even indicator */
            U8 natAddr;         /* nature of address */
        }f1;
        struct 
        {
            U8 tType;           /* translation type */
        }f2;
        struct 
        {
            U8 tType;           /* translation type */
            U8 numPlan;         /* numbering plan */
            U8 encSch;          /* encoding scheme */
        }f3;
        struct 
        {
            U8 tType;           /* translation type */
            U8 numPlan;         /* numbering plan */
            U8 encSch;          /* encoding scheme */
            U8 natAddr;         /* nature of address */
        }f4;
        struct
        {
            U32 ipAddr;         /* IP address used by TCAP over TCP/IP */
        }f5;
    }gt;
    ShrtAddrs addr;             /* address digits (BCD) */
} GlbTi;

/* Sccp address structure */

#ifdef SUAP_IPOPT
struct _suaAddr
{
   Bool  hnInc;                  /* host name included */
   Bool  ipAddrInc;              /* IP address included */
   Txt   hostName[SU_MAX_HOSTNAME_CHAR]; /* host name string */
   U8    type;                   /* V4 or V6 address */
   union
   {
      /* modifying the structure */
      CmIpAddr  ipv4;        /* 4 byte IP address */
#ifdef IPV6_SUPPORTED
      CmIpAddr6 ipv6;        /* 16 byte IPV6 address */
#endif /* IPV6_SUPPORTED */
   }ipAddr;
};
#endif /* SUAP_IPOPT */

typedef struct spAddr
{
#ifdef CMSS7_SPHDROPT
   U8 spHdrOpt;                 /* SCCP header filling options */
#endif /* CMSS7_SPHDROPT */      
   Bool pres;                   /* address is present */
   Swtch sw;                    /* variant switch */
   Bool ssfPres;                /* Sub-Service Present */
   U8 ssf;                      /* Sub-Service field */
   Bool niInd;                  /* national/international indicator */
   U8 rtgInd;                   /* routing indicator */
   Bool ssnInd;                 /* subsystem number indicator */
   Bool pcInd;                  /* point code indicator */
   Ssn ssn;                     /* subsystem number */
   Dpc pc;                      /* point code */
#ifdef SUAP_IPOPT
   SuaAddr suaAddr;
#endif /* SUAP_IPOPT */
   GlbTi gt;                    /* global title */
} SpAddr;

typedef struct spIsni
{
   U8 isniPres;            /* Presence of ISNI */
   U8 isniMiInd;           /* ISNI Mark for identification indicator (MI) */
   U8 isniRteInd;          /* ISNI routing indicator (IRI) */
   U8 isniTypInd;          /* ISNI type indicator */
   U8 isniCounter;         /* ISNI imaginery pointer to NIDs */
   U8 isniRtCtrlExt;       /* ISNI routing control extension, for Type 1 ISNI */
   U8 noOfNids;            /* number of NIDs in the list */
   U16 nid[MAX_ISNI_NID];  /* NID list */
} SpIsni;

typedef struct spIns
{
   U8 insPres;             /* Presence of INS */
   U8 insInfTypInd;        /* INS information type indicator */
   U8 insRteInd;           /* INS routing indicator */
   U8 insCounter;          /* INS imaginery counter */
   U8 noOfNids;            /* number of NIDs in the list */
   U16 nid[MAX_INS_NID];   /* NID list */
} SpIns;

typedef struct stStr                      /* tcap arbitrary string */
{
   U16 len;                               /* length of string */
   U8 string[MAX_ST_STRING];              /* string */
} StStr;

/* cm_ss7_x_001.main_16 */
/* PerfPatch : The following token structure is used exclusively
   for Extension Container in the MAP-GSM protocol, MA_LIMIT_EXTCONT */
typedef struct tknStrExtCont      /* token string extended */
{
   U8   pres;                     /* present flag */
   U8   len;                      /* length */
   U16  spare1;                   /* for alignment */
#ifdef ALIGN_64BIT
   U32  spare2;                   /* for 64 bit alignment */
   U8   val[MA_MF_EXTCONT_SIZE];  /* string value */
#else
   U8   val[MA_MF_EXTCONT_SIZE];  /* string value */
#endif
} TknStrExtCont;

EXTERN S16  cmCmpStStr       ARGS((StStr *s1, StStr *s2));
EXTERN Void cmCopyStStr      ARGS((StStr *src, StStr *dst));
EXTERN Void cmBldStStr       ARGS((StStr *dst, S8 *text));
EXTERN Void cmCopy           ARGS((U8 *src, U8 *dst, U32 count));
EXTERN Void cmCopyGt         ARGS((Swtch sw, GlbTi *src, GlbTi *dst));
EXTERN Bool cmIsANumber      ARGS((S16 *p, Data c, S16 base));
EXTERN S16  cmAscHexAdrToBcd ARGS((LngAddrs *inpBuf, ShrtAddrs *bcdBuf));
EXTERN S16  cmAscDecAdrToBcd ARGS((LngAddrs *inpBuf, ShrtAddrs *bcdBuf));
EXTERN Void cmCopyLngAddrs   ARGS((LngAddrs *src, LngAddrs *dest));
EXTERN Void cmCopySpAddr     ARGS((SpAddr *src, SpAddr *dst));  
EXTERN Void cmZero           ARGS((U8 *pVal, U32 count));
EXTERN Void cmPrntShrtAddrs  ARGS((ShrtAddrs *add));
EXTERN S16  cmPkLngAddr      ARGS((LngAddrs *add, Buffer *mBuf, U8 *l));
EXTERN S16  cmUnpkLngAddr    ARGS((LngAddrs *add, Buffer *mBuf));
EXTERN S16  cmPkGlbTi        ARGS((GlbTi *param, Buffer *mBuf));
EXTERN S16  cmUnpkGlbTi      ARGS((GlbTi *param, Buffer *mBuf));
EXTERN S16  cmPkSpAddr       ARGS((SpAddr *addr, Buffer *mBuf, U8 *l));
EXTERN S16  cmUnpkSpAddr     ARGS((SpAddr *addr, Buffer *mBuf));
EXTERN S16  cmUnpkStStr      ARGS ((StStr *string, Buffer *mBuf));
EXTERN S16  cmPkStStr        ARGS((StStr *string, Buffer *mBuf));
EXTERN S16  cmPkStOctet      ARGS(( StOctet *octet, Buffer *mBuf));
EXTERN S16  cmUnpkStOctet    ARGS(( StOctet *octet, Buffer *mBuf));
EXTERN S16  cmUnpkSteMgmt    ARGS(( CmSS7SteMgmt *steMgmt, Buffer *mBuf));
EXTERN S16  cmPkSteMgmt      ARGS(( CmSS7SteMgmt *steMgmt, Buffer *mBuf));
EXTERN S16 cmPkSpIsni        ARGS((SpIsni *spIsni, Buffer *mBuf));
EXTERN S16 cmUnpkSpIsni      ARGS((SpIsni *spIsni, Buffer *mBuf));
EXTERN S16 cmPkSpIns         ARGS((SpIns *spIns, Buffer *mBuf));
EXTERN S16 cmUnpkSpIns       ARGS((SpIns *spIns, Buffer *mBuf));
#ifdef SUAP_IPOPT
EXTERN S16 cmPkSuaAddr       ARGS((SuaAddr *addr, Buffer *mBuf, U8 *l));
EXTERN S16 cmUnpkSuaAddr     ARGS((SuaAddr *addr,Buffer *mBuf));
#endif /* SUAP_IPOPT */

#ifdef __cplusplus
}
#endif

#endif /* __CMSS7X__ */


/********************************************************************30**
  
         End of file:     cm_ss7.x@@/main/17 - Thu Jun  3 10:17:13 2010
  
*********************************************************************31*/
  

/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/
  

/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  fmg   1. initial release.

1.2          ---  fmg   1. text changes

1.3          ---  aa    1. Added the structure for SubSystem and Point Code
                           state change

1.4          ---  aa    1. Moved the typedefs which are used only by ss7 from
                           gen.h 
             ---  mjp   2. changed rtgInd to U8 from Bool

1.5          ---  mjp   1. add Sub-Service field to spAddr structure
             ---  mc    2. moved MtpStatus and Credit back to gen.x

*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.6          ---      nj   1. Added aDpc parameter in CmSS7SteMgmt structure
                              for SteInd.
  
1.7          ---      nj   1. Added events staReq, staCfm and steCfm in
                              CmSS7SteMgmt structure for STU2.
                           2. Added protection for C++ compiler.

1.8          ---      hrg  1. Added IP address as fifth format for global 
                              title for TCAP over TCP/IP addressing.
                           2. Added prototype for cmPrntShrtAddrs.

1.9          ---      cp   1. Modified SpAddr for introducing spHdrOpt.
/main/11     ---      dw   1. Added pk/unpk for GlbTi
/main/12     ---      rc   1. Changes for sccp rel 3.2
                              - typedefs for ISNI and INS added.
                              - declaration of packing/unpacking functions
                                of ISNI and INS added.

/main/13     ---      cp   1. Removed STU2 flag
/main/14     ---      st   1. Update for MAP Release 2.3
/main/15     ---      sal  1. Created for Release of 2.1(RFC 3868 Support)
/main/16     ---      sal  1. Modifying the structure suAddr.
/main/17     --- cm_ss7_x_001.main_16  ssahniX  1. Changes for MA_LIMIT_EXTCONT  optimization
                                             New structure has been added.
*********************************************************************91*/
