/********************************************************************16**

                         (c) COPYRIGHT 1989-2005 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     common ss7
  
     Type:     Common file for ss7 products
  
     Desc:     defines used by more than two layers in the ss7 stack
 
     File:     cm_ss7.h

     Sid:      cm_ss7.h@@/main/22 - Mon May 12 17:22:02 2008
  
     Prg:      fmg
  
*********************************************************************21*/
 
#ifndef __CMSS7H__
#define __CMSS7H__

/* Subsystem Multiplicity Indicators */

#define SMI_UNK          0x00
#define SMI_SOL          0x01
#define SMI_DUP          0x02
#define UOR_DENIED       0x10  /* Indicate denial of coordinate state */
                               /* change through smi in N-COORD confirm */
                               /* (ANSI-92 only).  User should NOT assume */
                               /* their request to shut down has been */
                               /* granted unless they have checked the smi */

/* defines for SSN and Point Code Management events */

#define EVTPC_STE_IND         0x01
#define EVTSSN_STE_REQ        0x02
#define EVTSSN_STE_IND        0x03
#define EVTSSN_CORD_REQ       0x04
#define EVTSSN_CORD_IND       0x05
#define EVTSSN_CORD_RSP       0x06
#define EVTSSN_CORD_CFM       0x07

#define EVTSSN_STA_REQ        0x08
#define EVTSSN_STE_CFM        0x09
#define EVTSSN_STA_CFM        0x0A

/* subservice selection */

#define SSF_TTC               0       /* Japan */
#define SSF_INTL              0       /* international */
#define SSF_SPARE             1       /* spare */
#define SSF_NAT               2       /* national */
#define SSF_RES               3       /* reserved */

/* priority */

#define SN_PRI0                 0       /* priority 0 */
#define SN_PRI1                 1       /* priority 1 */
#define SN_PRI2                 2       /* priority 2 */
#define SN_PRI3                 3       /* priority 3 */

/* cm_ss7_h_001.main_21 - Removed MAX_ST_STRING. It is defined in gen.h */

/* Defines used for SS7/SCCP Class 0 & 1 (Layer Management) */

#define SP_ACC           0x00       /* Signalling Point Accessible */
#define SP_INACC         0x01       /* Signalling Point Inaccessible */
#define SP_CONG          0x02       /* Signalling Point Congested */
#define SS_UOS           0x03       /* Subsystem user out of service */
#define SS_UIS           0x04       /* Subsystem user in service */
#define SP_RST           0x05       /* Signalling Point Restricted */

/* defined for remote sccp status */
#define RMT_SCCP_AVAIL   0x00       /* remote sccp available */
#define RMT_SCCP_UNAVAIL 0x01       /* remote sccp unavailable */
#define RMT_SCCP_UNEQP   0x02       /* remote sccp unequipped */
#define RMT_SCCP_INACC   0x03       /* remote sccp inaccessible */
#define RMT_SCCP_CONG    0x04       /* remote sccp congested */

/* global title formats */

#define GTFRMT_0         0           /* global title format 0 */
#define GTFRMT_1         1           /* global title format 1 */
#define GTFRMT_2         2           /* global title format 2 */
#define GTFRMT_3         3           /* global title format 3 */
#define GTFRMT_4         4           /* global title format 4 */
#define GTFRMT_5         5           /* global title format 5 */

/* hostname length as per RFC 1035 section 3.1*/
#define SU_MAX_HOSTNAME_CHAR 100   /* max characters of hostname */

/* routing indicators for sua */
#define RTE_SUA_GT       0x01    /* route on global title */
#define RTE_SUA_SSN_PC   0x02    /* route on SSN+PC */
#define RTE_SUA_HNAME    0x03    /* route on host name */
#define RTE_SUA_SSN_IP   0x04    /* route on SSN+IP address */


/* routing indicators for sccp */

#define RTE_GT           0x00      /* route based on global title */
#define RTE_SSN          0x01      /* route based on ssn */


/* defines for ISNI based SCCP routing in ansi and bellcore networks */
/* ISNI routing indicator */
#define NEITH_ISNI_RT    0x00      /* Neither constrained nor suggested
                                      ISNI routing */
#define CONST_ISNI_RT    0x01      /* Constrained ISNI routing */
#define SUGGST_ISNI_RT   0x02      /* Suggested ISNI routing */

/* Mark for Identification indicator */
#define IDENT_NW         0x01      /* Identify Networks */
#define NIDENT_NW        0x00      /* Do not identify Networks */

/* ISNI type indicator */
#define ISNI_TI0         0         /* ISNI type zero indicator */
#define ISNI_TI1         1         /* ISNI type one indicator */


/* defines for INS based SCCP routing in bellcore networks */
/* INS routing indicator */
#define NEITH_INS_RT    0x00      /* Neither constrained nor suggested
                                     INS routing */
#define CONST_INS_RT    0x01      /* Constrained INS routing */
#define SUGGST_INS_RT   0x02      /* Suggested INS routing */

/* Information type indicator */
#define SS7_FRMT        0x00      /* SS7 format */
#define INS_NW1         0x02      /* Network-specific 1 */
#define INS_NW2         0x03      /* Network-specific 2 */

/* defines for Message type interworking (MTI) - SCCP Bellcore network */
/* Original message type */
#define MSG_UNQUAL   0x00         /* message unualified */
#define MSG_UDT      0x01         /* Original message UDT(S) */
#define MSG_XUDT     0x02         /* Original message XUDT(S) */
#define MSG_LUDT     0x03         /* Original message LUDT(S) */

/* parameter drop option */
#define PARAM_DROP   0x01         /* parameter can be dropped */
#define PARAM_NDROP  0x00         /* parameter can not be dropped */


/* SCCP Subsystems */

#define SS_UNKNOWN      0x00    /* subsystem - Unknown */
#define SS_SCCPMNGT     0x01    /* subsystem - SCCP Management */
#define SS_ISUP         0x03    /* subsystem - ISDN User Part */
#define SS_OMAP         0x04    /* subsystem - OMAP */
#define SS_MAP          0x05    /* subsystem - Mobile Application part */
#define SS_HLR          0x06    /* subsystem - Home Location Register */
#define SS_VLR          0x07    /* subsystem - Visiting Location Register */
#define SS_MSC          0x08    /* subsystem - Mobile Switching Center */
#define SS_EIR          0x09    /* subsystem - Equipment Ident Register */
#define SS_AC           0x0a    /* subsystem - Authentication Center */
#define SS_ISDNSUPP     0x0b    /* subsystem - ISDN supplementary services */
#define SS_BISDNE2EAPP  0x0d    /* subsystem - B-ISDN edge-to-edge appl */
#define SS_TCTR         0x0e    /* subsystem - TC Test Responder */

/* adding defines for PCAP subsystem and modifying
 * values of BSSAP subsystems as per 3GPP TS 23.003 V6.0.0 (2003-09)
 */
#define SS_PCAP         0xf9    /* subsystem - PCAP */
#define SS_BSC_BSSAP    0xfa    /* subsystem - BSC (BSSAP-LE) */
#define SS_MSC_BSSAP    0xfb    /* subsystem - MSC (BSSAP-LE) */
#define SS_SMLC         0xfc    /* subsystem - SMLC (BSSAP-LE) */
#define SS_BSSOM        0xfd    /* subsystem - BSS O & M (A-interface) */
#define SS_BSSAP        0xfe    /* subsystem - BSSAP (A-interface) */
#define SS_GMLC         0x91    /* subsystem - GMLC (MAP) */
#define SS_CAP          0x92    /* subsystem - CAP */
#define SS_GSMSCF       0x93    /* subsystem - gsmSCF (MAP) */
#define SS_SIWF         0x94    /* subsystem - SIWF (MAP) */
#define SS_SGSN         0x95    /* subsystem - SGSN (MAP) */
#define SS_GGSN         0x96    /* subsystem - GGSN (MAP) */
#define SS_RANAP        0x8e    /* subsystem - RANAP */
#define SS_RNSAP        0x8f    /* subsystem - RNSAP */

/* Nature of Address Indicator */
#define NA_UNKN          0x0      /* Unknown */
#define NA_SUBNUM        0x1      /* subscriber number */
#define NA_NATSIGNUM     0x3      /* national significant number */
#define NA_INTNUM        0x4      /* international number */

/* Numbering Plan */
#define NP_UNKN          0x00      /* Unknown */
#define NP_ISDN          0x01      /* ISDN Telephony numbering plan */
#define NP_TEL           0x02      /* Telephony numbering plan */
#define NP_GENERIC       0x02      /* Generic numbering plan (ITU96) */
#define NP_DATA          0x03      /* Data numbering plan */
#define NP_TELEX         0x04      /* Telex numbering plan */
#define NP_MARMOB        0x05      /* Maritime Mobile numbering plan */
#define NP_LANMOB        0x06      /* Land Mobile numbering plan */
#define NP_ISDNMOB       0x07      /* ISDN Mobile numbering plan */
#define NP_NWSPEC        0x0e      /* Private network or network specific
                                      numbering plan */

/* Encoding Schemes */

#define ES_UNKN          0x00      /* Unknown */
#define ES_BCDODD        0x01      /* BCD Odd */
#define ES_BCDEVEN       0x02      /* BCD Even */
#define ES_NWSPEC        0x03      /* National Specific */

/* odd/even indicator */

#define OE_EVEN        0x00  /* even number of address signals */
#define OE_ODD         0x01  /* odd number of address signals */


/* dpc lengths */

#define DPC14            0         /* ccitt blue book dpc length */
#define DPC24            1         /* ansi and other national variants */
#define DPC_DEFAULT      2         /* dpc length for management message */
#define DPC16            3         /* for TTC Japan */

/* ssn present flags */

#define SSN_PRES        0x01       /* subsystem number present */
#define SSN_NPRES       0x00       /* subsystem number not present */

/* national internation indicator */

#define NAT_IND         0x01       /* National Indication */
#define INAT_IND        0x00       /* International Indication */

/* SCCP Header filling option */

/* Do not enable any option - default. Cannot be used with any other option. */      
#define CMSS7_DEF_OPT 0x0   
/* Do not fill pointcode in SCCP hdr */             
#define CMSS7_NO_SP_PC 0x1

/* bit for common hdr option presence */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
#define CMSS7_SPHDROPT_BIT   0x01
#define CMSS7_SUA_RTGIND_BIT 0x02
#endif /* TDS_ROLL_UPGRADE_SUPPORT */

/* TCAP specific typedefs */
#define cmPkStDlgId(x, mBuf)    SPkU32(x, mBuf)      /* pack Dialog Id */
#define cmPkStCompType(x,mBuf)  SPkU8(x, mBuf)        /* component type */

/* SCCP specific typedefs */

#define cmPkTimer(x, mBuf)      SPkU8(x, mBuf)       /* pack Timer */
#define cmPkSsn(x, mBuf)        SPkU8(x, mBuf)       /* pack Ssn */
#define cmPkRCause(x, mBuf)     SPkU8(x, mBuf)       /* pack RCause */
#define cmPkSmi(x, mBuf)        SPkU8(x, mBuf)       /* pack Smi */
#define cmPkUStat(x, mBuf)      SPkU8(x, mBuf)       /* pack UStat */
#define cmPkSps(x, mBuf)        SPkU8(x, mBuf)       /* pack Sps */
#define cmPkNIInd(x, mBuf)      SPkU8(x, mBuf)       /* pack NIInd */

/* MTP Level 3 specific typedefs */

#define cmPkMtpStatus(x, mBuf)  SPkU8(x, mBuf)       /* pack MtpStatus */
#define cmPkLnkSetId(x, mBuf)   SPkU16(x, mBuf)      /* pack LnkSetId */
#define cmPkDpc(x, mBuf)        SPkU32(x, mBuf)      /* pack Dpc */
#define cmPkSrvInfo(x, mBuf)    SPkU8(x, mBuf)       /* pack SrvInfo */
#define cmPkLnkSel(x, mBuf)     SPkU8(x, mBuf)       /* pack LnkSel */
#define cmPkCredit(x, mBuf)     SPkU8(x, mBuf)       /* pack Credit */

/* MTP Level 3 specific typedefs */

#define cmUnpkMtpStatus(x, mBuf)  SUnpkU8(x, mBuf)       /* unpack MtpStatus */
#define cmUnpkLnkSetId(x, mBuf)   SUnpkU16(x, mBuf)      /* unpack LnkSetId */
#define cmUnpkDpc(x, mBuf)        SUnpkU32(x, mBuf)      /* unpack Dpc */
#define cmUnpkSrvInfo(x, mBuf)    SUnpkU8(x, mBuf)       /* unpack SrvInfo */
#define cmUnpkLnkSel(x, mBuf)     SUnpkU8(x, mBuf)       /* unpack LnkSel */
#define cmUnpkCredit(x, mBuf)     SUnpkU8(x, mBuf)       /* unpack Credit */

/* SCCP specific typedefs */

#define cmUnpkTimer(x, mBuf)      SUnpkU8(x, mBuf)       /* unpack Timer */
#define cmUnpkSsn(x, mBuf)        SUnpkU8(x, mBuf)       /* unpack Ssn */
#define cmUnpkRCause(x, mBuf)     SUnpkU8(x, mBuf)       /* unpack RCause */
#define cmUnpkSmi(x, mBuf)        SUnpkU8(x, mBuf)       /* unpack Smi */
#define cmUnpkUStat(x, mBuf)      SUnpkU8(x, mBuf)       /* unpack UStat */
#define cmUnpkSps(x, mBuf)        SUnpkU8(x, mBuf)       /* unpack Sps */
#define cmUnpkNIInd(x, mBuf)      SUnpkU8(x, mBuf)       /* unpack NIInd */

/* TCAP specific typedefs */
#define cmUnpkStDlgId(x, mBuf)    SUnpkU32(x, mBuf)    /* unpack Dialog Id */
#define cmUnpkStCompType(x,mBuf)  SUnpkU8(x, mBuf)      /* component type */

/* ISUP specific typedefs */

#define cmUnpkCirId(x, mBuf)      SUnpkU32(x, mBuf)      /* unpack CirId */
#define cmUnpkCic(x, mBuf)        SUnpkU16(x, mBuf)      /* unpack Cic */
#define cmUnpkSiInstId(x, mBuf)   SUnpkU32(x, mBuf)      /* unpack SiInstId */

#define cmPkCirId(x, mBuf)      SPkU32(x, mBuf)      /* pack CirId */
#define cmPkCic(x, mBuf)        SPkU16(x, mBuf)      /* pack Cic */
#define cmPkSiInstId(x, mBuf)   SPkU32(x, mBuf)      /* pack SiInstId */

#endif /* __CMSS7H__ */


/********************************************************************30**
  
         End of file:     cm_ss7.h@@/main/22 - Mon May 12 17:22:02 2008
  
*********************************************************************31*/
  

/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/
  

/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  fmg   1. initial release.

1.2          ---  fmg   1. text changes

1.3          ---  aa   1. Added new defines 
             ---  aa   2. Moved defines for SMI from spt.h

1.4          ---  aa   1. Moved the defines which are used only by ss7 from
                          gen.h 
             ---  mjp  2. Remove RTE_DPC

1.5          ---  mjp  1. Add priority and subservice selection defines

*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.6          ---      nj   1. Added new SSN events for STU2.

1.7          ---      hrg  1. Added GTFRMT_5 for TCAP over TCP/IP.

1.8          ---      sr   1. new hash defines SSF_TTC and DPC16 added for
                              Japan
1.9          ---      rs   1. Added packing/unpacking macros for ISUP.

1.10         ---      cp   1. Added defines for spHdrOpt field.  

/main/11         ---      vb   1. Added new defines for ITU96
/main/13     ---      dw   1. Added SS_RANAP
/main/14     ---      rc   1. Rolling upgrade changes as per tcr0020.txt
                               -  One bit is defined to indicate presence of 
                                  common ss7 hdr option.
/main/15     ---      rc   1. Changes for sccp rel 3.2:
                              - defines for ISNI, INS and MTI added.
                              - defines for new SSNs added.
                              - defines for remote sccp status added.
                              - define for NP_GENERIC added and value of
                                NP_NWSPEC is changed as per ITU 96 spec.
                              - compile flag SS7_ITU96 removed and defines under
                                this flag made avilable unconditionally.

/main/16     ---     ssk   1. Added RNSAP sub system 
/main/17     ---      rc   1. Added define for PCAP subsystem and modified
                              values of BSSAP subsystems as per 3GPP
                              TS 23.003 V6.0.0 (2003-09)

/main/18     ---      cp   1. Removed STU2 flag
/main/19     ---      st   1. Update for MAP Release 2.3
/main/20     ---      sal  1. Created for Release of 2.1(RFC 3868 Support)
/main/21     cm_ss7_h_001.main_20    ak   1. Redefined MAX_ST_STRING value to 256.
cm_ss7_h_001.main_21    rs   1. Removed MAX_ST_STRING .
*********************************************************************91*/
