/*******************************************************************************
*
* Title: sangoma_ss7d
*
* Description: 
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 02-12-2010
*
*******************************************************************************/

/* ERROR msg decode ***********************************************************/
#define DECODE_ENTITY(ent) \
((ent) == ENTSM)    ?"Stack Manager" : \
((ent) == ENTCC)    ?"Call Control" : \
((ent) == ENTSI)    ?"ISUP" : \
((ent) == ENTSN)    ?"MTP3" : \
((ent) == ENTSD)    ?"MTP2" : \
((ent) == ENTL1)    ?"MTP1" : \
((ent) == ENTRY)	?"Relay" :\
((ent) == ENTHI)        ?"TUCL Convergence" :\
((ent) == ENTMG)        ?"H.248 " :\
((ent) == ENTMU)        ?"H.248 User" :\
((ent) == ENTPRM)   ?"LibSangoma Monitor" : \
"Unknown Entity ID Code"

#define DECODE_CFG_TYPE(type) \
((type) == STGEN)       ?"General Config" : \
((type) == STISAP)      ?"Upper SAP" : \
((type) == STNSAP)      ?"Network SAP" : \
((type) == STDLSAP)     ?"Data Link SAP" : \
((type) == STDLSAPACT)  ?"Active Data Link SAP" : \
((type) == STLNKSET)    ?"Link Set" : \
((type) == STROUT)      ?"Route Config" : \
((type) == STICIR)      ?"Circuit Configuration" : \
((type) == SI_STINTF)   ?"Interface" : \
((type) == STDLC)       ?"Data Link Connection" : \
"Unknown Configuration Type Code"

#define DECODE_LCM_STATUS(status) \
((status) == LCM_PRIM_OK)   ?"OK" : \
((status) == LCM_PRIM_NOK)  ?"NOT OK" : \
"Unknown Status Code"

#define DECODE_LCM_REASON(reason) \
((reason) == LCM_REASON_NOT_APPL)           ?"Not Applicable...status=OK" : \
((reason) == LCM_REASON_INVALID_ENTITY)     ?"Invalid Entity ID" : \
((reason) == LCM_REASON_INVALID_INSTANCE)   ?"Invalid Instance ID" : \
((reason) == LCM_REASON_INVALID_MSGTYPE)    ?"Invalid message type" : \
((reason) == LCM_REASON_MEM_NOAVAIL)        ?"Memory not available" : \
((reason) == LCM_REASON_INVALID_ELMNT)      ?"Invalid Element" : \
((reason) == LCM_REASON_RECONFIG_FAIL)      ?"Reconfiguration failed" : \
((reason) == LCM_REASON_REGTMR_FAIL)        ?"Timer Registration Failed" : \
((reason) == LCM_REASON_GENCFG_NOT_DONE)    ?"General Configuration not done" : \
((reason) == LCM_REASON_INVALID_ACTION)     ?"Invalid action" : \
((reason) == LCM_REASON_INVALID_SUBACTION)  ?"Invalid sub-action" : \
((reason) == LCM_REASON_INVALID_STATE)      ?"Invalid state" : \
((reason) == LCM_REASON_INVALID_SAP)        ?"Invalid SAP id" : \
((reason) == LCM_REASON_INVALID_PAR_VAL)    ?"Invalid parameter value" : \
((reason) == LCM_REASON_QINIT_FAIL)         ?"Queue Initialzation failed" : \
((reason) == LCM_REASON_NEG_CFM)            ?"Negative Confirmation" : \
((reason) == LCM_REASON_UPDTMR_EXPIRED)     ?"Update Timer Expired" : \
((reason) == LCM_REASON_MISC_FAILURE)       ?"Miscellaneous Failure" : \
((reason) == LCM_REASON_EXCEED_CONF_VAL)    ?"Exceeds Configuration Value" : \
((reason) == LCM_REASON_HASHING_FAILED)     ?"Hashing Failed" : \
((reason) == LCM_REASON_PEERCFG_NOT_DONE)   ?"swft peer SAP not configured" : \
((reason) == LCM_REASON_PRTLYRCFG_NOT_DONE) ?"swft portable layer not configured" : \
((reason) == LCM_REASON_VERSION_MISMATCH)   ?"Interface Version Mismatch" : \
((reason) == LSN_REASON_NMBDLSAP_NOK)       ?"number of DLSAP in gen cfg is more then NUMPHLNKS" : \
((reason) == LSN_REASON_INV_LNKTYPE)        ?"Invalid Link Type" : \
((reason) == LSN_REASON_INV_QLEN)           ?"Invalid Queue length" : \
((reason) == LSN_REASON_INV_LNKTSTSLC)      ?"Invalid lnkTstSLC in DLSAP cfg" : \
((reason) == LSN_REASON_INV_CMBLNKSETID)    ?"Invalid cmbLnkSetId in route cfg" : \
((reason) == LSN_REASON_INV_DEL_PRIOR)      ?"Invalid prior of the element to be deleted" : \
((reason) == LSN_REASON_INV_BNDSTATE)       ?"Invalid bind state" : \
((reason) == LSN_REASON_INV_LNKNUM)         ?"Invalid link number" : \
((reason) == LSN_REASON_EXCESS_RTECFG)      ?"Excess Route configuration" : \
((reason) == LSN_REASON_SRT_INPROG)         ?"SRT in progress" : \
((reason) == LSN_REASON_INV_SPID)           ?"Invalid spId" : \
((reason) == LSN_REASON_EXCESS_LNK_IN_CMBLNKSET)        ?"Excesses links in Combined Linkset" : \
((reason) == LSN_REASON_EXCESS_LNKSET_IN_CMBLNKSET)    ?"Excesses link sets in Combined Linkset" : \
((reason) == LSN_REASON_PREFLINK_WITH_LOWPRI)            ?"Prefered link with low priority" : \
"Unknown Reason Code"
/*((reason) == )   ?"" : \*/

#define DECODE_LCM_CATEGORY(cat) \
((cat) == LCM_CATEGORY_RESOURCE)            ?"Resource" : \
((cat) == LCM_CATEGORY_INTERFACE)           ?"Interface" : \
((cat) == LCM_CATEGORY_PROTOCOL)            ?"Protocol" : \
((cat) == LCM_CATEGORY_INTERNAL)            ?"Internal" : \
"Unknown Category Code"

#define DECODE_LCM_EVENT(event) \
((event) == LCM_EVENT_INV_TMR_EVT)          ?"Invalid Timer Event" : \
((event) == LCM_EVENT_BND_OK)               ?"Bind OK" : \
((event) == LCM_EVENT_BND_FAIL)             ?"Bind FAIL" : \
"Unknown Event Code"

#define DECODE_LCM_CAUSE(cause) \
((cause) == LCM_CAUSE_UNKNOWN)					?"Unknown cause" : \
((cause) == LCM_CAUSE_OUT_OF_RANGE)				?"Out of Range" : \
((cause) == LCM_CAUSE_INV_SAP)					?"Null/unknown sap" : \
((cause) == LCM_CAUSE_INV_SPID)					?"Invalid service provider" : \
((cause) == LCM_CAUSE_INV_SUID)					?"Invalid service user" : \
((cause) == LCM_CAUSE_INV_NETWORK_MSG)			?"Invalid network message" : \
((cause) == LCM_CAUSE_DECODE_ERR)				?"Message decoding problem" : \
((cause) == LCM_CAUSE_USER_INITIATED)			?"User initiated" : \
((cause) == LCM_CAUSE_MGMT_INITIATED)			?"Mgmt initiated" : \
((cause) == LCM_CAUSE_INV_STATE)				?"Invalid state" : \
((cause) == LCM_CAUSE_TMR_EXPIRED)				?"Timer Expired" : \
((cause) == LCM_CAUSE_INV_MSG_LENGTH)			?"Invalid message length" : \
((cause) == LCM_CAUSE_PROT_NOT_ACTIVE)			?"Protocol layer not active" : \
((cause) == LCM_CAUSE_INV_PAR_VAL)				?"Invalid parameter value" : \
((cause) == LCM_CAUSE_NEG_CFM)					?"Negative confirmation" : \
((cause) == LCM_CAUSE_MEM_ALLOC_FAIL)			?"Memory allocation failure" : \
((cause) == LCM_CAUSE_HASH_FAIL)				?"Hashing failure" : \
((cause) == LCM_CAUSE_VERSION_MISMATCH)			?"Interface version mismatch" : \
((cause) == LCM_CAUSE_SWVER_NAVAIL)				?"Interface version not found" : \
((cause) == LCM_CAUSE_DLGFAIL_DUETO_RECOVERY)	?"Dialogue has failed due to recovery" : \
((cause) == LCM_CAUSE_INV_ACTION)				?"Invalid Control Action" : \
((cause) == LCM_CAUSE_NETWK_INITIATED)			?"User initiated" : \
((cause) == LCM_CAUSE_LYR_SPECIFIC)				?"Protocl specific causes" : \
												"Unknown Cause Code"

#define DECODE_LSI_EVENT(event) \
((event) == LCM_EVENT_UI_INV_EVT)           ?"Upper interface invalid event" : \
((event) == LCM_EVENT_LI_INV_EVT)           ?"Lower interface invalid event" : \
((event) == LCM_EVENT_INV_EVT)              ?"General invalid event" : \
((event) == LCM_EVENT_INV_STATE)            ?"Invalid internal state" : \
((event) == LCM_EVENT_INV_TMR_EVT)          ?"Invalid timer event" : \
((event) == LCM_EVENT_MI_INV_EVT)           ?"Invalid Management event" : \
((event) == LCM_EVENT_BND_OK)               ?"Bind ok" : \
((event) == LCM_EVENT_BND_FAIL)             ?"Bind failed" : \
((event) == LCM_EVENT_TIMEOUT)              ?"timeout waiting for reply" : \
((event) == LSI_EVENT_NO_ROUTE)             ?"No Route available" : \
((event) == LSI_EVENT_UI_INV_VARIANT)       ?"Upper interface invalid variant" : \
((event) == LSI_EVENT_USERPART)             ?"User-part" : \
((event) == LSI_EVENT_REMOTE)               ?"Remote" : \
((event) == LSI_EVENT_LOCAL)                ?"Local" : \
((event) == LSI_EVENT_INV_RANGE)            ?"Invalid range" : \
((event) == LSI_EVENT_INV_ACK)              ?"Invalid Ack" : \
((event) == LSI_EVENT_CIC_VAL)              ?"CIC value" : \
((event) == LSI_EVENT_UI_FTZREQ)            ?"Upper interface FTZ request" : \
((event) == LSI_EVENT_MTP)                  ?"MTP3" : \
"Unknown Event Code"

#define DECODE_LSI_CAUSE(cause) \
((cause) == LCM_CAUSE_UNKNOWN)              ?"Unknown cause" : \
((cause) == LCM_CAUSE_OUT_OF_RANGE)         ?"Out of Range" : \
((cause) == LCM_CAUSE_INV_SPID)             ?"Invalid spId" : \
((cause) == LCM_CAUSE_INV_SUID)             ?"Invalid suId" : \
((cause) == LCM_CAUSE_INV_SAP)              ?"Invalid SapId" : \
((cause) == LCM_CAUSE_INV_NETWORK_MSG)      ?"Invalid Network message" : \
((cause) == LCM_CAUSE_DECODE_ERR)           ?"Decode error" : \
((cause) == LCM_CAUSE_USER_INITIATED)       ?"User Initiated" : \
((cause) == LCM_CAUSE_MGMT_INITIATED)       ?"Management Initiated" : \
((cause) == LCM_CAUSE_INV_STATE)            ?"Invalid state" : \
((cause) == LCM_CAUSE_TMR_EXPIRED)          ?"Timer Expired" : \
((cause) == LCM_CAUSE_INV_MSG_LENGTH)       ?"Invalid message length" : \
((cause) == LCM_CAUSE_PROT_NOT_ACTIVE)      ?"Protocol layer not active" : \
((cause) == LCM_CAUSE_INV_PAR_VAL)          ?"Invalid parameter value" : \
((cause) == LCM_CAUSE_NEG_CFM)              ?"Negative confirmation" : \
((cause) == LCM_CAUSE_MEM_ALLOC_FAIL)       ?"Memory allocation fail" : \
((cause) == LCM_CAUSE_HASH_FAIL)            ?"HASH fail" : \
((cause) == LCM_CAUSE_VERSION_MISMATCH)     ?"Version mismatch" : \
((cause) == LCM_CAUSE_SWVER_NAVAIL)         ?"Interface version not found" : \
((cause) == LSI_CAUSE_BLOCK)                ?"Block" : \
((cause) == LSI_CAUSE_CGUREQ)               ?"CGU request" : \
((cause) == LSI_CAUSE_CIR_MNTACK)           ?"Cir maintenance ack" : \
((cause) == LSI_CAUSE_CIR_MNTREQ)           ?"Cir maintenance req" : \
((cause) == LSI_CAUSE_CONG_LVL1)            ?"Congestion level 1" : \
((cause) == LSI_CAUSE_CONG_LVL2)            ?"Congestion level 2" : \
((cause) == LSI_CAUSE_INV_ADDRS)            ?"Invalid address" : \
((cause) == LSI_CAUSE_INV_CGU)              ?"Invalid CGU" : \
((cause) == LSI_CAUSE_INV_CQM)              ?"Invalid CQM" : \
((cause) == LSI_CAUSE_T12_INACTIVE)         ?"Timer 12 inactive" : \
((cause) == LSI_CAUSE_T14_INACTIVE)         ?"Timer 14 inactive" : \
((cause) == LSI_CAUSE_T16_INACTIVE)         ?"Timer 16 inactive" : \
((cause) == LSI_CAUSE_UNEQP_CIR)            ?"Unequipped Cir" : \
((cause) == LSI_CAUSE_INV_CDPTY)            ?"Invalid CDPTY" : \
((cause) == LSI_CAUSE_INV_TNS)              ?"Invalid TNS" : \
((cause) == LSI_CAUSE_SUINSTID_MISMATCH)    ?"SuninstId mismatch" : \
((cause) == LSI_CAUSE_UNBLOCK)              ?"Unblock" : \
((cause) == LSI_CAUSE_NO_CIRCUIT)           ?"No Circuit" : \
((cause) == LSI_CAUSE_INV_CIRCUIT)          ?"Invalid Circuit" : \
((cause) == LSI_CAUSE_INV_NW_RESOURCE)      ?"Invalide Network Resource" : \
((cause) == LSI_CAUSE_CIC_BUSY)             ?"CIC busy" : \
((cause) == LSI_CAUSE_RMT_BLKED)            ?"Remote blocked" : \
((cause) == LSI_CAUSE_CAL_REF)              ?"Call Reference" : \
((cause) == LSI_CAUSE_NO_MEMORY)            ?"No Memory" : \
((cause) == LSI_CAUSE_INV_MSAP)             ?"Invalid MSAP" : \
((cause) == LSI_CAUSE_CIC_IDLE)             ?"CIC Idle" : \
((cause) == LSI_CAUSE_INV_SUINSTID)         ?"Invalid SuninstID" : \
((cause) == LSI_CAUSE_UNKNOWN_SUINSTID)     ?"Unknown SuninstID" : \
((cause) == LSI_CAUSE_INV_EVNT)             ?"Invalid Event" : \
((cause) == LSI_CAUSE_AVAILABLE)            ?"Available" : \
((cause) == LSI_CAUSE_UNAVAILABLE)          ?"Unavailable" : \
((cause) == LSI_CAUSE_UNEQUIPPED)           ?"Unequipped" : \
((cause) == LSI_CAUSE_INV_SSAP)             ?"Invalid SSAP" : \
((cause) == LSI_CAUSE_INVCGBREQ)            ?"Invalide CGB req" : \
((cause) == LSI_CAUSE_CIC_STATE_MISMATCH)   ?"CIC state mismatch" : \
((cause) == LSI_CAUSE_INV_CGB)              ?"Invalid CGB" : \
((cause) == LSI_CAUSE_INV_CGBRSP)           ?"Invalid CGB response" : \
((cause) == LSI_CAUSE_INV_CGURSP)           ?"Invalid CGU response" : \
((cause) == LSI_CAUSE_INV_RANGE)            ?"Invalid Range" : \
((cause) == LSI_CAUSE_TMR_EXP)              ?"Timer expired" : \
((cause) == LSI_CAUSE_INV_VARIANT)          ?"Invalid Variant" : \
((cause) == LSI_CAUSE_FAILED)               ?"Failed" : \
((cause) == LSI_CAUSE_SUCCESS)              ?"Success" : \
((cause) == LSI_CAUSE_WRONG_CLLI)           ?"Wrong CLLI" : \
((cause) == LSI_CAUSE_UBL_ON_IDLE_CIC)      ?"UBL on idle CIC" : \
((cause) == LSI_CAUSE_INV_CGSMTI)           ?"Invalid CGSMTI" : \
((cause) == LSI_CAUSE_INV_RNGORSTATUS)      ?"Invalid RNGORSTATUS" : \
((cause) == LSI_CAUSE_INV_CHRGINFO)         ?"Invalid Charge Info" : \
((cause) == LSI_CAUSE_CONG_LVL3)            ?"Congestion level 3" : \
((cause) == LSI_CAUSE_INV_INTF)             ?"Invalid Interface" : \
((cause) == LSI_CAUSE_PAUSE)                ?"Pause" : \
((cause) == LSI_CAUSE_RESUME)               ?"Resume" : \
((cause) == LSI_CAUSE_STPCONG)              ?"STP Congestion" : \
((cause) == LSI_CAUSE_CONG_LVL0)            ?"Congestion level 0" : \
((cause) == LSI_CAUSE_INV_START_CIC)        ?"Invalid Starting CIC" : \
((cause) == LSI_CAUSE_NON_CNTCIC_BUSY)      ?"Non Cnt CIC busy" : \
((cause) == LSI_CAUSE_CIC_CAM_MISMATCH)     ?"CIC CAM mismatch" : \
((cause) == LSI_CAUSE_UNEX_CAM)             ?"Unex CAM" : \
((cause) == LSI_CAUSE_EVNT_ON_NON_CNTCIC)   ?"Event on non CNT CIC" : \
((cause) == LSI_CAUSE_CIR_SPINST_MISMATCH)  ?"Cir SPINST mismatch" : \
((cause) == LSI_CAUSE_N_CAM_MISMATCH)       ?"N CAM mismatch" : \
((cause) == LSI_CAUSE_RSCONBLK)             ?"RSC on blocked CIC" : \
((cause) == LSI_CAUSE_CGB)                  ?"CGB" : \
"Unknown Cause Code"
/*((cause) == )   ?"" : \*/

#define DECODE_LSN_EVENT(event) \
((event) == LCM_EVENT_INV_TMR_EVT)          ?"Invalid Timer Event" : \
((event) == LCM_EVENT_BND_OK)               ?"Bind OK" : \
((event) == LCM_EVENT_BND_FAIL)             ?"Bind FAIL" : \
((event) == LSN_EVENT_PROT_ST_UP)           ?"Link UP" : \
((event) == LSN_EVENT_PROT_ST_DN)           ?"Link DOWN" : \
((event) == LSN_EVENT_INH_DEN)              ?"Link Inhibit DENIED" : \
((event) == LSN_EVENT_UNINH_DEN)            ?"Link un-inhibit DENIED" : \
((event) == LSN_EVENT_LOC_INH_ACK)          ?"Link Inhibited locally" : \
((event) == LSN_EVENT_REM_INH_ACK)          ?"Link Inhibited remotely" : \
((event) == LSN_EVENT_LOC_UNINHED)          ?"Link Un-inhibited locally" : \
((event) == LSN_EVENT_REM_UNINHED)          ?"Link Un-inhibited remotely" : \
((event) == LSN_EVENT_LOC_FORCE_UNINH_DEN)  ?"Un-inhibit denied" : \
((event) == LSN_EVENT_RMT_FORCE_UNINH_DEN)  ?"Un-inhibit denied locally for remote request" : \
((event) == LSN_EVENT_LOC_RTE_MGMT_UNINH_DEN) ?"Un-inhibit denied locally for local request" : \
((event) == LSN_EVENT_RMT_BLKD)             ?"Link Remotely Blocked" : \
((event) == LSN_EVENT_RMT_UNBLKD)           ?"Link Remotely Un-blocked" : \
((event) == LSN_EVENT_LOC_BLKD)             ?"Link locally blocked" : \
((event) == LSN_EVENT_LOC_UNBLKD)           ?"Link locally un-blocked" : \
((event) == LSN_EVENT_PAUSE)                ?"DPC Paused" : \
((event) == LSN_EVENT_RESUME)               ?"DPC Resumed" : \
((event) == LSN_EVENT_CONG)                 ?"DPC Congested" : \
((event) == LSN_EVENT_STPCONG)              ?"DPC Stop Network Congested" : \
((event) == LSN_EVENT_RMTUSRUNAV)           ?"DPC Remove User Unavailable" : \
((event) == LSN_EVENT_INV_SLC_OTHER_END)    ?"Invalid SLC configured on other end" : \
((event) == LSN_EVENT_SDT_INV_DATA_DRP)     ?"Invalid data dropped at SDT interface" : \
((event) == LSN_EVENT_SNT_INV)              ?"Invalid event at SNT interface" : \
((event) == LSN_EVENT_SDT_INV)              ?"Invalid event at SDT interface" : \
((event) == LSN_EVENT_INV_SRCENT)           ?"Invalid source entity" : \
((event) == LSN_EVENT_SRTEST)               ?"Signal Routing Test" : \
((event) == LSN_EVENT_INV_OPC_OTHER_END)    ?"Invalid OPC configured on remote end" : \
((event) == LSN_EVENT_CRE_HMAP_FLR)         ?"Creation of SLS link map failed" : \
((event) == LSN_EVENT_SLT)                  ?"Signalling link test timer event" : \
((event) == LSN_EVENT_PERIODIC_SLT)         ?"Periodic Signalling link test timer event" : \
((event) == LSN_EVENT_CRE_HMAP_FLR)         ?"MAP Creation failed" : \
((event) == LSN_EVENT_DATA_DRP)             ?"Data dropped-Invalid DPC" : \
((event) == LSN_EVENT_LSET_ACTIVE)          ?"Link Set Active" : \
((event) == LSN_EVENT_LSET_INACTIVE)        ?"Link Set Inactive" : \
((event) == LSN_EVENT_RX_TRANSFER_MSG)		?"SNM Transfer Message Receieved" : \
"Unknown Event Code"
/*((event) == LSN_EVENT_)            ?"" : \*/

#define DECODE_LSN_CAUSE(cause) \
((cause) == LCM_CAUSE_PROT_NOT_ACTIVE)		?"Protocol Not Active" : \
((cause) == LCM_CAUSE_INV_SPID)				?"Invalid spId" : \
((cause) == LCM_CAUSE_INV_SUID)				?"Invalid suId" : \
((cause) == LCM_CAUSE_OUT_OF_RANGE)			?"Out of Range" : \
((cause) == LCM_CAUSE_INV_STATE)			?"Invalid State" : \
((cause) == LCM_CAUSE_DECODE_ERR)			?"Decoding Error" : \
((cause) == LCM_CAUSE_MGMT_INITIATED)		?"Management Initiated" : \
((cause) == LCM_CAUSE_INV_MSG_LENGTH)		?"Invalid Message Length" : \
((cause) == LCM_CAUSE_INV_PAR_VAL)			?"Invalid Parameter Value" : \
((cause) == LCM_CAUSE_TMR_EXPIRED)			?"Timer Expired" : \
((cause) == LCM_CAUSE_INV_NETWORK_MSG)		?"Invalid network message" : \
((cause) == LCM_CAUSE_SWVER_NAVAIL)			?"Interface version unavailable" : \
((cause) == LCM_CAUSE_UNKNOWN)				?"Unknown cause" : \
((cause) == LSN_CAUSE_T17_EXPIRED)			?"link deactivated" : \
((cause) == LSN_CAUSE_LNK_DEACT)			?"link deactivated" : \
((cause) == LSN_CAUSE_INV_OPC)				?"Invalid opc" : \
((cause) == LSN_CAUSE_DPC_UNAVAIL)			?"DPC becomes unavailble" : \
((cause) == LSN_CAUSE_RMT_NEG_ACK)			?"remote end nacked" : \
((cause) == LSN_CAUSE_INV_TST_PTRN)			?"invalid test" : \
((cause) == LSN_CAUSE_SELF_RST)				?"self restart" : \
((cause) == LSN_CAUSE_ADJ_RST)				?"adlacent DPC restart" : \
((cause) == LSN_CAUSE_INVALID_DPC)			?"invalid DPC" : \
((cause) == LSN_CAUSE_DPC_CONG)				?"DPC congestion started" : \
((cause) == LSN_CAUSE_DPC_RMVD)				?"DPC congestion ended" : \
((cause) == LSN_CAUSE_LNK_INACTV)			?"link inactive" : \
((cause) == LSN_CAUSE_NO_LSETS_AVAIL)		?"no linksets available" : \
((cause) == LSN_CAUSE_LNK_RSTR_FAILED)		?"link restart failed" : \
((cause) == LSN_CAUSE_INH_IN_PROG)			?"inhibit in progress" : \
((cause) == LSN_CAUSE_UNINH_IN_PROG)		?"uninhibit in progress" : \
((cause) == LSN_CAUSE_PATH_UNAVAIL)			?"path unavailable" : \
((cause) == LSN_CAUSE_NO_RMT_ACK)			?"no remote acknowledgement" : \
((cause) == LSN_CAUSE_RMT_INIT)				?"remote management initiated" : \
((cause) == LSN_CAUSE_LOC_RTE_MGMT_INIT)	?"Local Remote management initiated" : \
((cause) == LSN_CAUSE_DPC_FAILED)			?"DPC failed" : \
((cause) == LSN_CAUSE_T32_EXPIRED)			?"T32 expired" : \
((cause) == LSN_CAUSE_NULL_NIFOPC)			?"No specified OPC" : \
((cause) == LSN_CAUSE_SP_ROUTING)			?"SP routing" : \
((cause) == LSN_CAUSE_MTP2_DISC)			?"MTP2 disconnected" : \
((cause) == LSN_CAUSE_T7_EXPIRED)			?"T7 expired" : \
((cause) == LSN_CAUSE_FALSE_CONG)			?"False link congestion" : \
((cause) == LSN_CAUSE_LSET_DEACT)			?"Linkset Deactivated" : \
((cause) == LSN_CAUSE_NUMACT_EXC)			?"Incorrect number of active links" : \
((cause) == LSN_CAUSE_EXCESS_LNKSET)		?"Excess linksets" : \
((cause) == LSN_CAUSE_DLSAP_DELETED)		?"DLSAP deleted" : \
"Unknown Cause Code"
/*((cause) == LCM_CAUSE_)            ?"" : \*/

#define DECODE_LSN_LINK_STATUS(status) \
((status) == LSN_LST_INACTIVE)              ?"Out of Alignment" : \
((status) == LSN_LST_CON)                   ?"Connecting" : \
((status) == LSN_LST_ACTIVE)                ?"Aligned" : \
((status) == LSN_LST_FAILED)                ?"Failed" : \
((status) == LSN_LST_WAITCON)               ?"Waiting for Connection" : \
((status) == LSN_LST_SUSPEND)               ?"Suspended" : \
"Unknown Link Status Code"

#define DECODE_LSN_LINKSET_STATUS(status) \
((status) == LSN_SET_ACTIVE)              ?"Active" : \
((status) == LSN_SET_INACTIVE)            ?"InActive" : \
"Unknown Linkset Status Code"

#define DECODE_LSN_ROUTE_STATUS(status) \
((status) == LSN_RTE_AVAIL)              ?"Available" : \
((status) == LSN_RTE_UNAVAIL)            ?"Unavailable" : \
"Unknown Route Status Code"

#define DECODE_DISC_REASON(reason) \
((reason) == DL_DISC_SM)                    ?"Stack Manager Request" : \
((reason) == DL_DISC_SUERM)                 ?"SUERM Threshold met" : \
((reason) == DL_DISC_ALIGN)                 ?"Realignment" : \
((reason) == DL_DISC_ACK)                   ?"delay of Acknowledgement" : \
((reason) == DL_DISC_BSN)                   ?"2 out of 3 BSN are incorrect" : \
((reason) == DL_DISC_FIB)                   ?"2 out of 3 FIB are incorrect" : \
((reason) == DL_DISC_LSSU)                  ?"LSSU condition" : \
((reason) == DL_DISC_CONG)                  ?"too much congestion" : \
((reason) == DL_CLROORD)                    ?"clear - out of order" : \
((reason) == DL_DISC_L1)                    ?"disconect and bring down layer 1" : \
((reason) == DL_DISC_TE)                    ?"TE equipment failure" : \
((reason) == DL_DISC_LSSU_SIOS)             ?"SIOS received in LSC" : \
((reason) == DL_DISC_TMR2_EXP)              ?"TMR2 expired waiting for SIO" : \
((reason) == DL_DISC_TMR3_EXP)              ?"TMR3 expired waiting for SIN/SIE" : \
((reason) == DL_DISC_LSSU_SIOS_IAC)         ?"SIOS recieved in IAC" : \
((reason) == DL_DISC_PROV_FAIL)             ?"proving failure" : \
((reason) == DL_DISC_TMR1_EXP)              ?"TMR1 expired waiting for FISU" : \
((reason) == DL_DISC_LSSU_SIN)              ?"SIN when inservice or proc out" : \
((reason) == DL_DISC_CTS_LOST)              ?"CTS lost from MAC" : \
"Unknown Disconnect Reason"

#define DECODE_LSD_EVENT(event) \
((event) == LSD_EVENT_ENTR_CONG)            ?"Entering Congrestion" : \
((event) == LSD_EVENT_EXIT_CONG)            ?"Exiting Congestion" : \
((event) == LSD_EVENT_PROT_ST_UP)           ?"Link is up" : \
((event) == LSD_EVENT_PROT_ST_DN)           ?"Link is down" : \
((event) == LSD_EVENT_PROT_ERR)             ?"Protocol Error" : \
((event) == LSD_EVENT_LINK_ALIGNED)         ?"Link Aligned" : \
((event) == LSD_EVENT_ALIGN_LOST)           ?"Link Alignment lost" : \
((event) == LSD_EVENT_RTB_FULL)             ?"RTB queue is full" : \
((event) == LSD_EVENT_RTB_FULL_OVER)        ?"RTB queue full condition is over" : \
((event) == LSD_EVENT_NEG_ACK)              ?"Negative acknowledgement received" : \
((event) == LSD_EVENT_DAT_CFM_SDT)          ?"Ack received with more then 0.5s delay" : \
((event) == LSD_EVENT_REMOTE_CONG_START)    ?"Remote end congestion started" : \
((event) == LSD_EVENT_REMOTE_CONG_END)      ?"Remote end congestion ended" : \
((event) == LSD_EVENT_RX_REMOTE_SIPO)       ?"Remote end processor outage started" : \
"Unknown Event Code"

#define DECODE_LSD_LINK_STATUS(status) \
((status) == 0)								?"unbound" : \
((status) == 1)								?"configured" : \
((status) == 2)								?"bnd-disabled" : \
((status) == 3)								?"bnd-enabled" : \
"Unknown Link Status Code"

#define DECODE_LSD_CAUSE(cause) \
((cause) == LSD_CAUSE_ABN_BSN)              ?"Abnormal BSN" : \
((cause) == LSD_CAUSE_ABN_FIB)              ?"Abnormal FIB" : \
((cause) == LSD_CAUSE_CONG_DISC)            ?"Congestion Discard" : \
((cause) == LCM_CAUSE_MGMT_INITIATED)       ?"Managment Initiated" : \
((cause) == LCM_CAUSE_UNKNOWN)              ?"Unknown Cause" : \
"Unknown Cause code"

#define DECODE_LL1_EVENT(event) \
((event) == LL1_EVENT_OOB)                  ?"OOB Event" : \
((event) == LL1_EVENT_CON_REQ)              ?"SAP Connection Request" : \
((event) == LL1_EVENT_DISCON_REQ)           ?"SAP Disconnection Request" : \
((event) == LL1_EVENT_TX_ERROR)             ?"Transmit Error" : \
((event) == LL1_EVENT_RX_ERROR)             ?"Receive Error" : \
"Unknown Event Code"

#define DECODE_LL1_CAUSE(cause) \
((cause) == LL1_CAUSE_CONNECTED)            ?"MTP1 Connected" : \
((cause) == LL1_CAUSE_DISCONNECTED)         ?"MTP1 Disconnected" : \
((cause) == LL1_CAUSE_UPPER_INF)            ?"MTP2 Request" :\
((cause) == LL1_CAUSE_MNGMNT_INF)           ?"SM Request" : \
((cause) == LL1_CAUSE_INVALID_SIZE)         ?"Invalid message size" : \
"Unknown Cause Code"

#define DECODE_LL1_PARM(parm) \
((parm) == L1_SUCCESSFUL)                   ?"Successful" :\
((parm) == L1_FAIL)                         ?"Failed" :\
((parm) == L1_ALREADY_CONNECTED)            ?"Already connected" : \
((parm) == L1_ALREADY_ACTIVE)               ?"Already active" : \
"Unknown Parameter Code"


#define DECODE_LCC_EVENT(event) \
((event) == LCM_EVENT_BND_OK)               ?"Bind OK" : \
((event) == LCM_EVENT_BND_FAIL)             ?"Bind FAIL" : \
((event) == SIT_STA_REATTEMPT)              ?"reattempt indication" : \
((event) == SIT_STA_ERRORIND)               ?"error indication" : \
((event) == SIT_STA_CONTCHK)                ?"continuity check" : \
((event) == SIT_STA_CONTREP)                ?"continuity report" : \
((event) == SIT_STA_STPCONTIN)              ?"stop continuity" : \
((event) == SIT_STA_CGQRYRSP)               ?"circuit grp query response from far end forwarded to upper layer by ISUP" : \
((event) == SIT_STA_CONFUSION)              ?"confusion" : \
((event) == SIT_STA_LOOPBACKACK)            ?"LPA" : \
((event) == SIT_STA_CIRRSRVREQ)             ?"circuit reservation request" : \
((event) == SIT_STA_CIRRSRVACK)             ?"circuit reservation acknowledgement" : \
((event) == SIT_STA_CIRBLOREQ)              ?"BLO" : \
((event) == SIT_STA_CIRBLORSP)              ?"BLA" : \
((event) == SIT_STA_CIRUBLREQ)              ?"UBL" : \
((event) == SIT_STA_CIRUBLRSP)              ?"UBA" : \
((event) == SIT_STA_CIRRESREQ)              ?"RSC" : \
((event) == SIT_STA_CIRRESRSP)              ?"RSC-RLC" : \
((event) == SIT_STA_CGBREQ)                 ?"CGB" : \
((event) == SIT_STA_CGUREQ)                 ?"CGU" : \
((event) == SIT_STA_CGQRYREQ)               ?"circuit group query request" : \
((event) == SIT_STA_CGBRSP)                 ?"mntc. oriented CGB response" : \
((event) == SIT_STA_CGURSP)                 ?"mntc. oriented CGU response" : \
((event) == SIT_STA_GRSREQ)                 ?"GRS" : \
((event) == SIT_STA_CIRUNEQPD)              ?"UCIC" : \
((event) == SIT_STA_GRSRSP)                 ?"GRA" : \
((event) == SIT_STA_CIRLOCRES)              ?"reset initiated locally by the software" : \
((event) == SIT_STA_PAUSEIND)               ?"Pause" : \
((event) == SIT_STA_RESUMEIND)              ?"Resume" : \
((event) == SIT_STA_USRPARTA)               ?"user part available" : \
((event) == SIT_STA_RMTUSRUNAV)             ?"remote user not available" : \
((event) == SIT_STA_MTPCONG0)               ?"congestion indication level 0" : \
((event) == SIT_STA_MTPCONG1)               ?"congestion indication level 1" : \
((event) == SIT_STA_MTPCONG2)               ?"congestion indication level 2" : \
((event) == SIT_STA_MTPCONG3)               ?"congestion indication level 3" : \
((event) == SIT_STA_MTPSTPCONG)             ?"stop congestion indication level 0" : \
((event) == SIT_STA_CIRLOCALBLOIND)         ?"Mngmt local blocking" : \
((event) == SIT_STA_CIRLOCALUBLIND)         ?"Mngmt local unblocking" : \
((event) == SIT_STA_OVERLOAD)               ?"Overload" : \
((event) == SIT_STA_LMCGBREQ)               ?"when LM requests ckt grp blocking" : \
((event) == SIT_STA_LMCGUREQ)               ?"when LM requests ckt grp unblocking" : \
((event) == SIT_STA_LMGRSREQ)               ?"when LM requests ckt grp reset" : \
((event) == SIT_STA_CGBINFOIND)             ?"circuit grp blking ind , no resp req" : \
((event) == SIT_STA_LMCQMINFOREQ)           ?"when LM requests ckt grp query" : \
((event) == SIT_STA_CIRLOCGRS)              ?"group reset initiated locally by the software" : \
((event) == SIT_STA_GRSRSPIND)              ?"indication to IW to idle the RM" : \
((event) == SIT_STA_RLCIND)                 ?"RLC indicattion to IW to idle the RM" : \
((event) == LCC_STA_CIRRESET)               ?"Circuit Reset Complete" : \
"Unknown Event Code"

#define DECODE_LCC_CAUSE(cause) \
((cause) == LCC_UNKNOWN_CAUSE)              ?"Unknown Cause" : \
((cause) == LCC_REMOTE_REQUEST)             ?"Remote Request" : \
"Unknown Cause Code"

#define DECODE_LCC_PARM(parm) \
"Unknown Parameter Code"

#define DECODE_LRY_SEQ(seq) \
((seq) == LRYSEQXXX)						?"rySendKeepAlive" : \
((seq)  == LRYSEQ000)						?"rySendKeepAlive" : \
((seq)  == LRYSEQ001)						?"ryChanCbTmrEvnt" : \
((seq)  == LRYSEQ002)						?"ryLock" : \
((seq)  == LRYSEQ003)						?"ryPstTskBit3" : \
((seq)  == LRYSEQ004)						?"ryPstTskBit3" : \
((seq)  == LRYSEQ005)						?"ryGetTskBit3" : \
((seq)  == LRYSEQ006)						?"ryGetTskBit3" : \
((seq)  == LRYSEQ007)						?"ryGetTskBit3" : \
((seq)  == LRYSEQ008)						?"ryGetDBufBit3" : \
((seq)  == LRYSEQ009)						?"ryGetDBufBit3" : \
((seq)  == LRYSEQ010)						?"ryPutDBufBit3" : \
((seq)  == LRYSEQ011)						?"ryPutDBufBit3" : \
((seq)  == LRYSEQ012)						?"ryGetMsgBit3" : \
((seq)  == LRYSEQ013)						?"ryGetMsgBit3" : \
((seq)  == LRYSEQ014)						?"ryPutMsgBit3" : \
((seq)  == LRYSEQ015)						?"ryPutMsgBit3" : \
((seq)  == LRYSEQ016)						?"ryChkResBit3" : \
((seq)  == LRYSEQ017)						?"ryChkResBit3" : \
((seq)  == LRYSEQ018)						?"ryCpyMsgInBit3" : \
((seq)  == LRYSEQ019)						?"ryCpyMsgInBit3" : \
((seq)  == LRYSEQ020)						?"ryCpyMsgOutBit3" : \
((seq)  == LRYSEQ021)						?"ryCpyMsgOutBit3" : \
((seq)  == LRYSEQ022)						?"ryCpyMsgBit3Bit3" : \
((seq)  == LRYSEQ023)						?"ryCpyMsgBit3Bit3" : \
((seq)  == LRYSEQ024)						?"ryCpyMsgBit3Bit3" : \
((seq)  == LRYSEQ025)						?"ryCpyMsgBit3Bit3" : \
((seq)  == LRYSEQ026)						?"ryQueTskBit3" : \
((seq)  == LRYSEQ027)						?"ryQueTskBit3" : \
((seq)  == LRYSEQ028)						?"ryCpyMsgBit3S5shm" : \
((seq)  == LRYSEQ029)						?"ryCpyMsgBit3S5shm" : \
((seq)  == LRYSEQ030)						?"ryCpyMsgS5shmBit3" : \
((seq)  == LRYSEQ031)						?"ryCpyMsgS5shmBit3" : \
((seq)  == LRYSEQ032)						?"ryInitChanBit3" : \
((seq)  == LRYSEQ033)						?"ryInitChanBit3" : \
((seq)  == LRYSEQ034)						?"ryInitChanBit3" : \
((seq)  == LRYSEQ035)						?"ryInitPstTskBit3" : \
((seq)  == LRYSEQ036)						?"ryActvDrvrTsk" : \
((seq)  == LRYSEQ037)						?"ryPstTskRaw" : \
((seq)  == LRYSEQ038)						?"ryPstTskBit3" : \
((seq)  == LRYSEQ039)						?"ryGetTskRaw" : \
((seq)  == LRYSEQ040)						?"ryGetTskBit3" : \
((seq)  == LRYSEQ041)						?"ryGetTskS5Msg" : \
((seq)  == LRYSEQ042)						?"ryryInitChanBit3SRII" : \
((seq)  == LRYSEQ043)						?"ryInitChanRawSRII" : \
((seq)  == LRYSEQ044)						?"ryCpyDmRmS" : \
((seq)  == LRYSEQ045)						?"ryCpyDmRmS" : \
((seq)  == LRYSEQ046)						?"ryCpyDmMmS" : \
((seq)  == LRYSEQ047)						?"ryCpyDmMmS" : \
((seq)  == LRYSEQ048)						?"ryDequeMmM" : \
((seq)  == LRYSEQ049)						?"ryDequeMmM" : \
((seq)  == LRYSEQ050)						?"ryGetTskRII" : \
((seq)  == LRYSEQ051)						?"ryPstTskRII" : \
((seq)  == LRYSEQ052)						?"ryDequeMmM" : \
((seq)  == LRYSEQ053)						?"ryGetTskRII" : \
((seq)  == LRYSEQ054)						?"ryCpyMsgS5msgBit3RII" : \
((seq)  == LRYSEQ055)						?"ryCpyMsgS5msgBit3RII" : \
"Unknown Sequence Code"

#define DECODE_LRY_REASON(reason) \
((reason) == LRYRSNPF)						?"post failed" : \
((reason) == LRYRSNKARX)					?"keep alive rx expired" : \
((reason) == LRYRSNLCKFAIL)					?"lock failed" : \
((reason) == LRYRSNB3LCKFAIL)				?"bit3 lock failed" : \
((reason) == LRYRSNB3UNLCKFAIL)				?"bit3 unlock failed" : \
((reason) == LRYRSNHSTLCKFAIL)				?"hst lock failed" : \
((reason) == LRYRSNHSTUNLCKFAIL)			?"hst unlock failed" : \
((reason) == LRYRSNNOROUTE)					?"no route" : \
((reason) == LRYRSNREMDOWN)					?"remote down" : \
((reason) == LRYRSNBRDFAIL)					?"board failure" : \
((reason) == LRYRSNMGMTREQ)					?"management request" : \
((reason) == LRYRSNHSTSHMEMFAIL)			?"hst shared memory init failed." : \
((reason) == LRYRSNRAWSHMEMFAIL)			?"raw shared memory init failed." : \
((reason) == LRYRSNNOTFIRSTBD)				?"not a first buffer descriptor" : \
((reason) == LRYRSNEMPTYBD)					?"empty buffer descriptor" : \
((reason) == LRYRSNWRONGSTATE)				?"wrong state" : \
((reason) == LRYRSNB3SHMEMFAIL)				?"b3 shared memory init failed" : \
((reason) == LRYRSNKHSHMEMFAIL)				?"KH shared memory init failed." : \
((reason) == LRYRSNS5SHMMEMFAIL)			?"Sys V shared memory init failed." : \
"Unknown Reason Code"

#define DECODE_LRY_CONG_FLAGS(flags) \
((flags) == LRY_CONG_NONE)					?"No Flags" :\
((flags) == LRY_CONG_CONG)					?"In Congestion" :\
((flags) == LRY_CONG_DROP)					?"Dropping" :\
"Unknown Congestion Flag"

#define DECODE_LRY_CHAN_STATUS(status) \
((status) == LRY_CSTA_UP)					?"up" :\
((status) == LRY_CSTA_BT)					?"boot received" :\
((status) == LRY_CSTA_CG)					?"congestion" :\
((status) == LRY_CSTA_DP)					?"dropping" :\
((status) == LRY_CSTA_DN)					?"down" :\
((status) == LRY_CSTA_CR)					?"crashed" :\
((status) == LRY_CSTA_PV)					?"proving stage" :\
((status) == LRY_CSTA_WT)					?"waiting stage" :\
((status) == LRY_CSTA_RC)					?"recover stage" :\
"Unkonwn Status Code"

#define PRNT_SAP_STATE(_state)\
(_state == LMG_SAP_UBND_DIS)					?"LMG_SAP_UBND_DIS":\
(_state == LMG_SAP_BND_ENB)					?"LMG_SAP_BND_ENB":\
(_state == LMG_SAP_BND_DIS)					?"LMG_SAP_BND_DIS":\
(_state == LMG_SAP_WAIT_BNDENB)					?"LMG_SAP_WAIT_BNDENB":\
(_state == LMG_SAP_WAIT_BNDDIS)					?"LMG_SAP_WAIT_BNDDIS":\
(_state == LMG_SAP_UBND_ENB)					?"LMG_SAP_UBND_ENB":\
(_state == LMG_SAP_WAIT_UBNDENB)				?"LMG_SAP_WAIT_UBNDENB":\
(_state == LMG_SAP_DELETED)					?"LMG_SAP_DELETED":\
"Unknown"


#define PRNT_MG_PEER_STATE(_state)\
(_state == LMG_PEER_STATE_NULL)					?"PEER_STATE_NULL":\
(_state == LMG_PEER_STATE_RESOLVING)				?"PEER_STATE_RESOLVING":\
(_state == LMG_PEER_STATE_AWAIT_REG)				?"PEER_STATE_AWAIT_REG":\
(_state == LMG_PEER_STATE_CONNECT)				?"PEER_STATE_CONNECT":\
(_state == LMG_PEER_STATE_REGISTER)				?"PEER_STATE_REGISTER":\
(_state == LMG_PEER_STATE_ACTIVE)				?"PEER_STATE_ACTIVE":\
(_state == LMG_PEER_STATE_DISCONNECTED)				?"PEER_STATE_DISCONNECTED":\
(_state == LMG_PEER_STATE_UNDR_HNDOFF)				?"PEER_STATE_UNDR_HNDOFF":\
(_state == LMG_PEER_STATE_FAILOVER)				?"PEER_STATE_FAILOVER":\
(_state == LMG_PEER_STATE_VER_UNSUPP)				?"PEER_STATE_VER_UNSUPP":\
(_state == LMG_PEER_STATE_UNDR_RESTART)				?"PEER_STATE_UNDR_RESTART":\
"Unknown State"

#define PRNT_MG_CMD(_cmd)\
(_cmd == MGT_ADD)                                               ?"ADD":\
(_cmd == MGT_MOVE)                                              ?"MOVE":\
(_cmd == MGT_MODIFY)                                            ?"MGT_MODIFY":\
(_cmd == MGT_SUB)                                               ?"MGT_SUB":\
(_cmd == MGT_AUDITCAP)                                          ?"MGT_AUDITCAP":\
(_cmd == MGT_AUDITVAL)                                          ?"MGT_AUDITVAL":\
(_cmd == MGT_NTFY)                                              ?"MGT_NTFY":\
(_cmd == MGT_SVCCHG)                                            ?"MGT_SVCCHG":\
"Unknown Command"

#define PRNT_MG_CMD_TYPE(_cmd)\
(_cmd == CM_CMD_TYPE_NONE)					?"CM_CMD_TYPE_NONE":\
(_cmd == CH_CMD_TYPE_REQ )					?"CH_CMD_TYPE_REQ":\
(_cmd == CH_CMD_TYPE_RSP )					?"CH_CMD_TYPE_RSP":\
(_cmd == CH_CMD_TYPE_IND )					?"CH_CMD_TYPE_IND":\
(_cmd == CH_CMD_TYPE_CFM )					?"CH_CMD_TYPE_CFM":\
"Unknown Command Type"


#define PRNT_MG_CTXT_TYPE(_type)\
(_type ==  MGT_CXTID_NULL        )				?"MGT_CXTID_NULL":\
(_type ==  MGT_CXTID_ALL         )				?"MGT_CXTID_ALL":\
(_type ==  MGT_CXTID_CHOOSE      )				?"MGT_CXTID_CHOOSE":\
(_type ==  MGT_CXTID_OTHER       )				?"MGT_CXTID_OTHER":\
"Unknown Context Type"


/******************************************************************************/
