/*******************************************************************************
*
* Title: sng_mg.h
*
* Description: Sangoma Media Gateway library header file
*
* Written By: Kapil Gupta (kgupta@sangoma.com)
*             David Yat Sin (dyatsin@sangoma.com)
*
* Date: 06-06-2012
*
*******************************************************************************/

/******************************************************************************/
#ifndef __SNG_MG_H__
# define __SNG_MG_H__
/******************************************************************************/

/* defines ********************************************************************/
#define S_PROC                  1                   /*this is the global PROC value to use*/
#define S_INST                  0                   /*global INSTantous value*/
#define S_REG                   0                   /*memory region value*/
#define S_POOL                  0x00                /*memory pool value*/ /*Kapil - changing to ZERO as MG stack has 0 (static)pool configured */
#define POOL_LW_TR              1
#define POOL_UP_TR              2
/******************************************************************************/

/* TUCL Defines *****************************************************************/
#define HI_PERIOD 			10 		/* Period used for timers ... 10,000 = 0.1s */
#define HI_MAX_SAPS                     10               /* max number of TUCL SAPs*/
#define HI_MAX_NUM_OF_CON               100             /* max number of TUCL connection*/
#define HI_MAX_NUM_OF_FD_PER_SET        1024            /* maximum num of fds to use per set */ 
#define HI_MAX_NUM_OF_FD_HASH_BINS      16              /*for fd hash lists*/   
#define HI_MAX_NUM_OF_CLIENT_TO_ACCEPT  5               /* clients to accept simultaneously */  
#define HI_MAX_SELECT_TIMEOUT_VALUE     20              /* select() timeout */  
#define HI_MAX_SCHED_TMR_VALUE          2               /* Schedule Timer value */      
#define HI_MAX_RAW_MSG_TO_READ          10              /* number of raw messages to read in one iteration */ 
#define HI_MAX_UDP_MSG_TO_READ          20              /* number of UDP messages to read in one iteration */ 
#define HI_MEM_POOL_START_THRESHOLD     4               /* thresholds for congestion on the memory pool */ 
#define HI_MEM_POOL_DROP_THRESHOLD      2               /* thresholds for congestion on the memory pool */ 
#define HI_MEM_POOL_STOP_THRESHOLD      5               /* thresholds for congestion on the memory pool */ 
#define HI_SAP_TXN_QUEUE_CONG_START_LIMIT 10000         /* Transaction Queue congestion start limit */ 
#define HI_SAP_TXN_QUEUE_CONG_DROP_LIMIT  20000         /* Transaction Queue congestion drop limit */ 
#define HI_SAP_TXN_QUEUE_CONG_STOP_LIMIT  8000          /* Transaction Queue congestion STOP limit */ 

/******************************************************************************/

/* MG Defines *****************************************************************/
#define MG_MAX_SSAPS 	 10 			   /* MAX SSAP */
#define MG_MAX_TSAPS 	 10 			   /* MAX TSAP */
#define MG_MAX_SERVERS   5 			   /* max servers */
#define MG_NUM_BLK       4 			   /* Number of Block */
#define MG_MAXBLKSIZE    2048 			   /* Block Size */
#define MG_MAX_PEER      20   			  /* MAX Peer */
#define MG_LMG_GET_RSPACK_MGCO      0    	  /* MAX Peer */
#define MG_DNS_IP       0xac1000f0 		 /* Dummy DNS IP...anyway we are not using DNS */
#define MG_INIT_RTT     100        
#define MG_MAX_OUTSTANDING_TRANSACTIONS    2000   /* MAX pending txn */
#define MG_MAX_MTU_SIZE 	1500       
#define MG_MAX_PEERS 	5 			 /*MAX supported peers */       

/* ****************************************************************************/
#define LIBSNG_MG_WAIT_SLEEP		1
#define LIBSNG_MG_TIMEOUT		2000					/* cfg/sta/cntrl/sts request */ 
										/* timeout ( LIBSNG_MG_WAIT_SLEEP * LIBSNG_SS7_TIMEOUT = Timeout  sec ) */
#ifndef sng_msleep
#define sng_msleep(x) usleep(x*1000)
#endif

#define LIBSNG_WAIT_FOR_CMD_RESULT(tid) do { \
	int timer = 0; \
	while (sng_state[tid].ret == SNG_INVALID_TRANSID) { \
		sng_msleep(LIBSNG_MG_WAIT_SLEEP); \
		timer++; \
                if (timer > LIBSNG_MG_TIMEOUT) { \
                        SNG_LOG(SNG_LOGLEVEL_CRIT, "%s():%d SS7 Command timed out for transid=%i\n", __FUNCTION__,__LINE__, tid); \
                        sng_state[tid].ret = -1; \
                        SS7D_ASSERT; \
			break; \
		} \
	} \
	if (timer < LIBSNG_MG_TIMEOUT) { \
		if (timer*LIBSNG_MG_WAIT_SLEEP > 500) { \
			SNG_LOG(SNG_LOGLEVEL_WARN, "%s():%d SS7 Command delayed %i ms transid=%i\n", __FUNCTION__,__LINE__,timer*LIBSNG_MG_WAIT_SLEEP, tid); \
		} else if (timer*LIBSNG_MG_WAIT_SLEEP > 100) { \
			SNG_LOG(SNG_LOGLEVEL_WARN, "%s():%d SS7 Command delayed %i ms transid=%i\n", __FUNCTION__,__LINE__, timer*LIBSNG_MG_WAIT_SLEEP, tid); \
		} else if (timer*LIBSNG_MG_WAIT_SLEEP > 10) { \
			SNG_LOG(SNG_LOGLEVEL_DEBUG, "%s():%d SS7 Command delayed %i ms transid=%i\n", __FUNCTION__,__LINE__, timer*LIBSNG_MG_WAIT_SLEEP, tid); \
		} \
	} \
	} while (0);


													/* timeout ( 50 * LIBSNG_SS7_TIMEOUT = 5 sec ) */

/* General includes/defines ***************************************************/
#ifdef __LINUX__
#include <stdint.h>
#endif

#ifdef __WINDOWS__
#endif

#include "envopt.h"        /* environment options */
#include "envdep.h"        /* environment dependent */
#include "envind.h"        /* environment independent */

#include "gen.h"           /* general layer */
#include "ssi.h"           /* system services */

#include "lhi.h"           /* TUCL layer management */

#include "cm_mblk.h"        /* memory management */
#include "cm_tkns.h"        /* common tokens */
#include "cm_inet.h"        /* common sockets */
#include "cm_tpt.h"         /* common transport */
#include "cm_dns.h"         /* common DNS libraru defines */
#include "cm_sdp.h"        /* Session Description Protocol Defines */
#include "mgt.h"            /* MGCP layer */
#include "lmg.h"            /* MGCP layer */
#include "lmu.h"           /* MEGACO Application layer */
#include "mgcopdb1.h"            /* MGCP layer */
#include "mgcopdb4.h"            /* MGCP layer */
#include "mgcopdb9.h"            /* MGCP layer */
#include "mgcopdb12.h"            /* MGCP layer */


#include "gen.x"           /* general layer */
#include "ssi.x"           /* system services */
/*
#include "cm_ss7.x"
*/
#include "cm_lib.x"

#include "lhi.x"           /* TUCL layer management */

#include "cm_mblk.x"        /* memory management */
#include "cm_tkns.x"        /* common tokens */
#include "cm_inet.x"        /* common sockets */
#include "cm_tpt.x"         /* common transport */
#include "cm_sdp.x"        /* Session Description Protocol Defines */
#include "mgt.x"            /* MGCP layer */
#include "lmg.x"           /* MGCP layer */
#include "lmu.x"           /* MEGACO Application layer */


#include "sng_mg_error.h"
#include "mu_debug_prints.x"
#include "mu_mg_utils.x"

/******************************************************************************/

#define MAX_SNGMG_PATH                 128                                     /* max path name */
#define MAX_SNGMG_PC                   12                                      /* max length of a point code */
#define MAX_MAC_SIZE                    18                                      /* max length of a mac address */
#define MAX_LIC_NAME                    256                                     /* max length of names in license file */



/* Logging ********************************************************************/
enum
{
    SNG_LOGLEVEL_DEBUG=1,
    SNG_LOGLEVEL_WARN,
    SNG_LOGLEVEL_INFO,
    SNG_LOGLEVEL_NOTICE,
    SNG_LOGLEVEL_ERROR,
    SNG_LOGLEVEL_CRIT,
    SNG_LOGLEVEL_PUBLIC=100,
};
/******************************************************************************/

/* Event Call-backs structure**************************************************/
typedef struct sng_mg_event_interface
{
    struct
    {
        void (*sng_log)(uint8_t level, char *fmt, ...);
	void (*sng_tucl_alarm)(Pst *pst, HiMngmt *sta);
	void (*sng_mg_alarm)(Pst *pst, MgMngmt *sta);
    }sm;
    struct
    {
#ifdef GCP_MGCP
	    void (*sng_mgcp_txn_ind)(Pst *pst, SuId suId, MgMgcpTxn* mgTxn);
#endif
#ifdef GCP_MGCO
	    void (*sng_mgco_txn_ind)(Pst *pst, SuId suId, MgMgcoMsg* msg);
	    void (*sng_mgco_cmd_ind)(Pst *pst, SuId suId, MgMgcoCommand* cmd);
	    void (*sng_mgco_txn_sta_ind)(Pst *pst, SuId suId, MgMgcoInd* chTxnStaInd);
#endif
	    void (*sng_mgco_sta_ind)(Pst *pst, SuId suId, MgMgtSta* status);
	    void (*sng_mgco_cntrl_cfm)(Pst *pst, SuId suId, MgMgtCntrl* cntrl, Reason reason);
	    void (*sng_mgco_audit_cfm)(Pst *pst, SuId suId, MgMgtAudit* audit, Reason reason);
    }mg;
}sng_mg_event_interface_t;
/******************************************************************************/

/* General functions **********************************************************/
extern int32_t sng_mg_init_gen(sng_mg_event_interface_t *u_sng_event_inf);
extern int32_t sng_set_procId(uint16_t procId);
extern int32_t sng_get_procId(void);
#if 0
extern int32_t sng_isup_init_cc(void);
extern int32_t sng_isup_init_isup(void);
extern int32_t sng_isup_init_mtp3(void);
extern int32_t sng_isup_init_mtp2(void);
extern int32_t sng_isup_init_mtp1(void);
extern int32_t sng_isup_init_relay(void);
#endif
extern int32_t sng_mg_init_sm(void);
extern int32_t sng_mg_init_tucl(void);
extern int32_t sng_mg_init_mg(void);
extern int32_t sng_mg_init_mu(void);

extern int32_t sng_mg_free_gen(void);
#if 0 /* DAVIDY Clean up later */
extern int32_t sng_isup_free_cc(void);
extern int32_t sng_isup_free_isup(void);
extern int32_t sng_isup_free_mtp3(void);
extern int32_t sng_isup_free_mtp2(void);
extern int32_t sng_isup_free_mtp1(void);
extern int32_t sng_isup_free_relay(void);
#endif
extern int32_t sng_mg_free_sm(void);
extern int32_t sng_mg_free_tucl(void);
extern int32_t sng_mg_free_mg(void);
extern int32_t sng_mg_free_mu(void);

extern int32_t sng_mg_version(uint32_t *major, uint32_t *minor, uint32_t *build);
extern int32_t sng_mg_reg_info_show(void);
/******************************************************************************/

/* License Validaton **********************************************************/
#define MG_CHECK_LICENSE(_total_term, _license_file, _license_sig_file, _ret){ \
	sng_set_total_term_cfg(_total_term);\
	_ret = sng_validate_license(_license_file, _license_sig_file);\
}
extern int32_t sng_validate_license(char *license, char *signature);
extern int32_t sng_check_license(int verbose);
extern void sng_set_total_term_cfg(int cfg_term);
/******************************************************************************/

#if 0 /* DAVIDY Clean up later */
/* Outgoing Call Functions ****************************************************/
extern int32_t sng_cc_con_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiConEvnt *siConEvnt, uint8_t xchgType);
extern int32_t sng_cc_con_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiConEvnt *siConEvnt, uint8_t xchgType);
extern int32_t sng_cc_con_status(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiCnStEvnt *siCnStEvnt, uint8_t evntType);
extern int32_t sng_cc_rel_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiRelEvnt *siRelEvnt);
extern int32_t sng_cc_rel_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiRelEvnt *siRelEvnt);
extern int32_t sng_cc_dat_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiInfoEvnt *siInfoEvnt);
extern int32_t sng_cc_susp_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiSuspEvnt *siSuspEvnt);
extern int32_t sng_cc_resm_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, SiResmEvnt *siResmEvnt);
extern int32_t sng_cc_sta_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t globalFlg, uint8_t evntType, SiStaEvnt *siStaEvnt);
extern int32_t sng_cc_fac_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t evntType, SiFacEvnt *siFacEvnt);
extern int32_t sng_cc_fac_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit, uint8_t evntType, SiFacEvnt *siFacEvnt);
extern int32_t sng_cc_umsg_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, uint32_t circuit);
/******************************************************************************/
#endif

#ifdef GCP_MGCO
/* MEGACO Call Functions ****************************************************/
/* API will be used to send complete megaco message */
extern S16 sng_mgco_send_msg(SuId suId, MgMgcoMsg *mgMsg);
/* API will be used to send single command or command response etc. */
extern S16 sng_mgco_send_cmd(SuId suId, MgMgcoCommand *mgCmd);
extern S16 sng_mgco_send_axn_req(SuId suId, MgMgcoCtxt *mgCtxt);
extern S16 sng_mgco_send_err(SuId suId, MgMgcoInd *mgInd);
extern S16 sng_mgco_send_cntrl_req(SuId suId, MgMgtCntrl *cntrl);
extern S16 sng_mgco_send_audit_req(SuId suId, MgMgtAudit *audit);
#endif
#ifdef GCP_MGCP
extern S16 sng_mgcp_send_msg(SuId suId, MgMgcpTxn *mgMsg);
#endif

/******************************************************************************/

/* Configuration Functions ****************************************************/
#if 0 /* DAVIDY Clean up later */
extern int32_t sng_cfg_cc(Pst *pst, CcMngmt *cfg);
extern int32_t sng_cfg_isup(Pst *pst, SiMngmt *cfg);
extern int32_t sng_cfg_mtp3(Pst *pst, SnMngmt *cfg);
extern int32_t sng_cfg_mtp2(Pst *pst, SdMngmt *cfg);
extern int32_t sng_cfg_mtp1(Pst *pst, L1Mngmt *cfg);
extern int32_t sng_cfg_relay(Pst *pst, RyMngmt *cfg);
#endif
extern int32_t sng_cfg_tucl(Pst *pst, HiMngmt *cfg);
extern int32_t sng_cfg_mg(Pst *pst, MgMngmt *cfg);
extern int32_t sng_cfg_mu(Pst *pst, MuMngmt *cfg);
/******************************************************************************/

/* Control Functions **********************************************************/
#if 0 /* DAVIDY Clean up later */
extern int32_t sng_cntrl_cc(Pst *pst, CcMngmt *cntrl);
extern int32_t sng_cntrl_isup(Pst *pst, SiMngmt *cntrl);
extern int32_t sng_cntrl_mtp3(Pst *pst, SnMngmt *cntrl);
extern int32_t sng_cntrl_mtp2(Pst *pst, SdMngmt *cntrl);
extern int32_t sng_cntrl_mtp1(Pst *pst, L1Mngmt *cntrl);
extern int32_t sng_cntrl_relay(Pst *pst, RyMngmt *cntrl);
#endif

#define sng_cntrl_tucl(_pst, _cntrl) __sng_cntrl_tucl((_pst),(_cntrl),TRUE) 
#define sng_cntrl_tucl_nowait(_pst, _cntrl) __sng_cntrl_tucl((_pst),(_cntrl),FALSE) 
extern int32_t __sng_cntrl_tucl(Pst *pst, HiMngmt *cntrl, uint8_t wait);

#define sng_cntrl_mg(_pst, _cntrl) __sng_cntrl_mg((_pst),(_cntrl),TRUE) 
#define sng_cntrl_mg_nowait(_pst, _cntrl) __sng_cntrl_mg((_pst),(_cntrl),FALSE) 
extern int32_t __sng_cntrl_mg(Pst *pst, MgMngmt *cntrl, uint8_t wait);

#define sng_cntrl_mu(_pst, _cntrl) __sng_cntrl_mu((_pst),(_cntrl),TRUE) 
#define sng_cntrl_mu_nowait(_pst, _cntrl) __sng_cntrl_mu((_pst),(_cntrl),FALSE) 
extern int32_t __sng_cntrl_mu(Pst *pst, MuMngmt *cntrl, uint8_t wait);

/******************************************************************************/

/* Status Requests ************************************************************/
#if 0 /* DAVIDY Clean up later */
extern int32_t sng_sta_cc(Pst *pst, CcMngmt *sta, CcMngmt *cfm);
extern int32_t sng_sta_isup(Pst *pst, SiMngmt *sta, SiMngmt *cfm);
extern int32_t sng_sta_mtp3(Pst *pst, SnMngmt *sta, SnMngmt *cfm);
extern int32_t sng_sta_mtp2(Pst *pst, SdMngmt *sta, SdMngmt *cfm);
extern int32_t sng_sta_mtp1(Pst *pst, L1Mngmt *sta, L1Mngmt *cfm);
extern int32_t sng_sta_relay(Pst *pst, RyMngmt *sta, RyMngmt *cfm);
#endif
extern int32_t sng_sta_tucl(Pst *pst, HiMngmt *sta, HiMngmt *cfm);
extern int32_t sng_sta_mg(Pst *pst, MgMngmt *sta, MgMngmt *cfm);
/******************************************************************************/

/* Statistics Requests ********************************************************/
#if 0 /* DAVIDY */
extern int32_t sng_sts_cc(Pst *pst, int32_t action, CcMngmt *sts, CcMngmt *cfm);
extern int32_t sng_sts_isup(Pst *pst, int32_t action, SiMngmt *sts, SiMngmt *cfm);
extern int32_t sng_sts_mtp3(Pst *pst, int32_t action, SnMngmt *sts, SnMngmt *cfm);
extern int32_t sng_sts_mtp2(Pst *pst, int32_t action, SdMngmt *sts, SdMngmt *cfm);
extern int32_t sng_sts_mtp1(Pst *pst, int32_t action, L1Mngmt *sts, L1Mngmt *cfm);
extern int32_t sng_sts_relay(Pst *pst, int32_t action, RyMngmt *sts, RyMngmt *cfm);
#endif
extern int32_t sng_sts_tucl(Pst *pst, HiMngmt *cntrl, HiMngmt *cfm);

/******************************************************************************/
/* MG Utils *************************************************************/
PUBLIC U16 smmgGetAlarmInfoField    ARGS((MgUsta *usta));
PUBLIC Void smmgPrntPeerInfo        ARGS((MgPeerInfo *peerInfo));
PUBLIC Void smmgPrntSrvSta          ARGS((MgTptSrvSta *sta));
PUBLIC Void smmgPrntPeerSta         ARGS((MgPeerSta *sta));
PUBLIC Void smmgPrntSsapSta         ARGS((MgSSAPSta *sta));

#define SMMG_UNKNOWNFIELD     0
#define SMMG_PEERINFO         1
#define SMMG_SAPID            2
#define SMMG_MEM              3
#define SMMG_SRVSTA           4
#define SMMG_PEERSTA          5
#define SMMG_SSAPSTA          6
#define SMMG_PARID            7
#define SMMG_NOT_APPL         8

/******************************************************************************/

/* Util Functions *************************************************************/
extern void smHdrInit(Header *hdr);
extern void smPstInit(Pst *pst);
extern void set_dest_sm_pst(Pst *pst);
#ifdef LEAK_TEST
extern S16 mgInitLeakTst(void);
extern void mgPrntLeakReport(void);
#endif
extern S16 SGetMemInfoBuffer ( Region region, U32 *availmem, char* buffer);
/******************************************************************************/

/******************************************************************************/
#endif  /* __SNG_MG_H__ */
/******************************************************************************/
