/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     data link layer
  
     Type:     C include file
  
     Desc:     Structure, variables and typedefs required by the
               data link layer service user for MTP.
   
     File:     sdt.x
  
     Sid:      sdt.x@@/main/18 - Mon Jul  3 23:45:22 2006
  
     Prg:      mc
  
*********************************************************************21*/

#ifndef __SDTX__
#define __SDTX__

#ifdef __cplusplus
extern "C" {
#endif
 
  
/*
*     The structures and variables declared in this file
*     correspond to structures and variables used by
*     the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000027     SS7 - MTP Level 2
*     1000028     SS7 - MTP Level 3
*     1000063     Service Specific Coordination Function - Q.2140
*
*/
  
/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1020035     SS7 - MTP Level 3 Simple Router
*
*/
  
  
/* Post and BndCfg structure defined in gen.x */

/* buffer structure defined in ssi.x */


/* typedefs of primitives */

/* depending on the specific selector in the post structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */

typedef S16 (*SdtBndReq) ARGS((Pst *pst,SuId suId,SpId spId));
typedef S16 (*SdtUBndReq) ARGS((Pst *pst,SuId nlId,Reason reason));
typedef S16 (*SdtConReq) ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
typedef S16 (*SdtDatReq) ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
typedef S16 (*SdtDiscReq) ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
typedef S16 (*SdtFlcReq) ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
typedef S16 (*SdtStaReq) ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

typedef S16 (*SdtStaInd) ARGS((Pst *pst,LnkNmb lnkNmb,MtpStatus status));
typedef S16 (*SdtStaCfm) ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));
typedef S16 (*SdtConCfm) ARGS((Pst *pst, SuId suId)); 
typedef S16 (*SdtDiscInd) ARGS((Pst *pst, SuId suId, Reason reason)); 
typedef S16 (*SdtDatInd) ARGS((Pst *pst, SuId suId, Buffer *mBuf)); 
typedef S16 (*SdtDatCfm) ARGS((Pst *pst, SuId suId, Buffer *mBuf, 
        MtpStatus status, SeqU24 credit)); 
typedef S16 (*SdtFlcInd) ARGS((Pst *pst, SuId suId, Action action));
#ifdef SDT2 
typedef S16 (*SdtBndCfm) ARGS((Pst *pst, SuId suId, U8 status));
#endif /* SDT2 */


#ifdef SD  /* mtp level 2 */
/* mtp 2, upper interface, data link discriminator */

extern  S16 SdUiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 SdUiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 SdUiSdtConReq ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
extern  S16 SdUiSdtDatReq ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
extern  S16 SdUiSdtDiscReq ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
extern  S16 SdUiSdtFlcReq ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
extern  S16 SdUiSdtStaReq ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

extern  S16 SdUiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 SdUiSdtDatInd ARGS((Pst *pst,SuId suId, Buffer *mBuf));
extern  S16 SdUiSdtDatCfm ARGS((Pst *pst,SuId suId, Buffer *mBuf,
        MtpStatus status, SeqU24 credit));
extern  S16 SdUiSdtDiscInd ARGS((Pst *pst,SuId suId, Reason reason));
extern  S16 SdUiSdtFlcInd ARGS((Pst *pst,SuId suId, Action action));
extern  S16 SdUiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 SdUiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));

#ifdef SDT2
extern  S16 SdUiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));
#endif /* SDT2 */
#endif


#ifdef SA  /* Q.2140 */
/* Q.2140, upper interface, data link discriminator */

extern  S16 SaUiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 SaUiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 SaUiSdtConReq ARGS((Pst *pst,SpId spId, MtpStatus status));
extern  S16 SaUiSdtDatReq ARGS((Pst *pst,SpId spId,Buffer *mBuf));
extern  S16 SaUiSdtDiscReq ARGS((Pst *pst,SpId spId, Reason reason));
extern  S16 SaUiSdtStaReq ARGS((Pst *pst,SpId spId, Action action, SeqU24 status));

extern  S16 SaUiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 SaUiSdtDatInd ARGS((Pst *pst,SuId suId, Buffer *mBuf));
extern  S16 SaUiSdtDatCfm ARGS((Pst *pst,SuId suId, Buffer *mBuf, 
        MtpStatus status, SeqU24 credit));
extern  S16 SaUiSdtDiscInd ARGS((Pst *pst,SuId suId, Reason reason));
/* SaUiSdtFlcInd primitive added */
extern  S16 SaUiSdtFlcInd ARGS((Pst *pst,SuId suId, Action action));
extern  S16 SaUiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 SaUiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));

#ifdef SDT2
extern  S16 SaUiSdtBndCfm ARGS((Pst *pst, SuId suId, U8 status));
#endif /* SDT2 */

#endif
/* Support  for DSML Added.*/
#ifdef DSML  /* mtp level 2 */
/* mtp 2, upper interface, data link discriminator */

extern  S16 DsmlUiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 DsmlUiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 DsmlUiSdtConReq ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
extern  S16 DsmlUiSdtDatReq ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
extern  S16 DsmlUiSdtDiscReq ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
extern  S16 DsmlUiSdtFlcReq ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
extern  S16 DsmlUiSdtStaReq ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

extern  S16 DsmlUiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 DsmlUiSdtDatInd ARGS((Pst *pst,SuId suId, Buffer *mBuf));
extern  S16 DsmlUiSdtDatCfm ARGS((Pst *pst,SuId suId, Buffer *mBuf,
        MtpStatus status, SeqU24 credit));
extern  S16 DsmlUiSdtDiscInd ARGS((Pst *pst,SuId suId, Reason reason));
extern  S16 DsmlUiSdtFlcInd ARGS((Pst *pst,SuId suId, Action action));
extern  S16 DsmlUiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 DsmlUiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));

#ifdef SDT2
extern  S16 DsmlUiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));
#endif /* SDT2 */
#endif


#ifdef SN  /* mtp level 3 */
/* mtp level 3, lower interface functions */

extern  S16 SnLiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 SnLiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 SnLiSdtConReq ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
extern  S16 SnLiSdtDatReq ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
extern  S16 SnLiSdtDiscReq ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
extern  S16 SnLiSdtFlcReq ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
extern  S16 SnLiSdtStaReq ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

extern  S16 SnLiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 SnLiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
extern  S16 SnLiSdtDatCfm ARGS((Pst *pst,SuId suId,Buffer *mBuf,
        MtpStatus status, SeqU24 credit));
extern  S16 SnLiSdtDiscInd ARGS((Pst *pst,SuId suId,Reason reason));
extern  S16 SnLiSdtFlcInd ARGS((Pst *pst,SuId suId,Action action));
extern  S16 SnLiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 SnLiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));

#ifdef SDT2
extern  S16 SnLiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));
#endif /* SDT2 */

#endif


#ifdef SR  /* mtp level 3 Simple Router */
/* mtp level 3 Simple Router, lower interface functions */

extern  S16 SrLiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
extern  S16 SrUiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
#endif

#ifdef MX  /* M2PA */
/* M2PA, Interface functions */

extern  S16 MxUiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 MxUiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 MxUiSdtConReq ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
extern  S16 MxUiSdtDatReq ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
extern  S16 MxUiSdtDiscReq ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
extern  S16 MxUiSdtFlcReq ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
extern  S16 MxUiSdtStaReq ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

extern  S16 MxUiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 MxUiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
extern  S16 MxUiSdtDatCfm ARGS((Pst *pst,SuId suId,Buffer *mBuf, \
                               MtpStatus status, SeqU24 credit));
extern  S16 MxUiSdtDiscInd ARGS((Pst *pst,SuId suId,Reason reason));
extern  S16 MxUiSdtFlcInd ARGS((Pst *pst,SuId suId,Action action));
extern  S16 MxUiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 MxUiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));
extern  S16 MxUiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));

#endif  /* MX - M2PA */



#ifdef MW  /* M2UA */
/* M2UA, Interface functions */

extern  S16 MwUiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 MwUiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 MwUiSdtConReq ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
extern  S16 MwUiSdtDatReq ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
extern  S16 MwUiSdtDiscReq ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
extern  S16 MwUiSdtFlcReq ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
extern  S16 MwUiSdtStaReq ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

extern  S16 MwUiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 MwUiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
extern  S16 MwUiSdtDatCfm ARGS((Pst *pst,SuId suId,Buffer *mBuf,
        MtpStatus status, SeqU24 credit));
extern  S16 MwUiSdtDiscInd ARGS((Pst *pst,SuId suId,Reason reason));
extern  S16 MwUiSdtFlcInd ARGS((Pst *pst,SuId suId,Action action));
extern  S16 MwUiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 MwUiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));
extern  S16 MwUiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));

#endif  /* MW - M2UA */


#ifdef NW  /* M2UA- NIF */
/* M2UA, Interface functions */

extern  S16 NwLiSdtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
extern  S16 NwLiSdtUBndReq ARGS((Pst *pst,SpId spId,Reason reason));
extern  S16 NwLiSdtConReq ARGS((Pst *pst,LnkNmb lnkNmb, MtpStatus status));
extern  S16 NwLiSdtDatReq ARGS((Pst *pst,LnkNmb lnkNmb,Buffer *mBuf));
extern  S16 NwLiSdtDiscReq ARGS((Pst *pst,LnkNmb lnkNmb, Reason reason));
extern  S16 NwLiSdtFlcReq ARGS((Pst *pst,LnkNmb lnkNmb,Action action));
extern  S16 NwLiSdtStaReq ARGS((Pst *pst,LnkNmb lnkNmb, Action action, SeqU24 status));

extern  S16 NwLiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 NwLiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
extern  S16 NwLiSdtDatCfm ARGS((Pst *pst,SuId suId,Buffer *mBuf,
        MtpStatus status, SeqU24 credit));
extern  S16 NwLiSdtDiscInd ARGS((Pst *pst,SuId suId,Reason reason));
extern  S16 NwLiSdtFlcInd ARGS((Pst *pst,SuId suId,Action action));
extern  S16 NwLiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 NwLiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, SeqU24 status));
extern  S16 NwLiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));

#endif  /* NW -M2UA-NIF */

/* Common upper interface packing functions */

#ifdef SDT2
EXTERN S16 cmPkSdtBndCfm ARGS((Pst *pst, SuId suId, U8 status));
#endif /* SDT2 */

EXTERN S16 cmPkSdtConCfm ARGS((Pst *pst, SuId suId));
EXTERN S16 cmPkSdtDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, MtpStatus status, SeqU24 credit));
EXTERN S16 cmPkSdtDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
EXTERN S16 cmPkSdtDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
EXTERN S16 cmPkSdtFlcInd ARGS(( Pst *pst, SuId suId, Action action));
EXTERN S16 cmPkSdtStaCfm ARGS((Pst *pst, SuId suId, Action action, SeqU24 status));
EXTERN S16 cmPkSdtStaInd ARGS((Pst *pst, SuId suId, MtpStatus status));

EXTERN S16 cmUnpkSdtDatReq ARGS((SdtDatReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtBndReq ARGS((SdtBndReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtUBndReq ARGS((SdtUBndReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtConReq ARGS((SdtConReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtDiscReq ARGS((SdtDiscReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtFlcReq ARGS((SdtFlcReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtStaReq ARGS((SdtStaReq func, Pst *pst, Buffer *mBuf));


EXTERN S16 cmPkSdtBndReq ARGS((Pst *pst, SuId suId, SpId spId));
EXTERN S16 cmPkSdtConReq ARGS((Pst *pst, SpId spId, MtpStatus status));
EXTERN S16 cmPkSdtDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
EXTERN S16 cmPkSdtDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
EXTERN S16 cmPkSdtFlcReq ARGS((Pst *pst, SpId spId, Action action));
EXTERN S16 cmPkSdtStaReq ARGS((Pst *pst, SpId spId, Action action, SeqU24 status));
EXTERN S16 cmPkSdtUBndReq ARGS((Pst *pst, SpId spId, Reason reason));

/* Common Upper interface unpacking functions */


EXTERN S16 cmUnpkSdtDatInd ARGS((SdtDatInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtConCfm ARGS((SdtConCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtDatCfm ARGS((SdtDatCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtDiscInd ARGS((SdtDiscInd func, Pst *pst, Buffer *mBuf));
#ifdef SDT2
EXTERN S16 cmUnpkSdtFlcInd ARGS((SdtFlcInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtBndCfm ARGS((SdtBndCfm func, Pst *pst, Buffer *mBuf));
#endif /* SDT2 */
EXTERN S16 cmUnpkSdtStaInd ARGS((SdtStaInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkSdtStaCfm ARGS((SdtStaCfm func, Pst *pst, Buffer *mBuf));


#ifdef DN  /* mtp level 3 LDF */
/* mtp level 3, LDF lower interface functions */


extern  S16 DnLiSdtConCfm ARGS((Pst *pst,SuId suId));
extern  S16 DnLiSdtDatInd ARGS((Pst *pst,SuId suId,Buffer *mBuf));
extern  S16 DnLiSdtDatCfm ARGS((Pst *pst,SuId suId,Buffer *mBuf,
        MtpStatus status, SeqU24 credit));
extern  S16 DnLiSdtDiscInd ARGS((Pst *pst,SuId suId,Reason reason));
extern  S16 DnLiSdtStaInd ARGS((Pst *pst,SuId suId, MtpStatus status));
extern  S16 DnLiSdtStaCfm ARGS((Pst *pst,SuId suId, Action action, 
                                SeqU24 status));
extern  S16 DnLiSdtFlcInd ARGS((Pst *pst,SuId suId,Action action));
extern  S16 DnLiSdtBndCfm ARGS((Pst *pst,SuId suId, U8 status));

#endif /* DN */

#ifdef __cplusplus
}
#endif
#endif

  
/********************************************************************30**

         End of file:     sdt.x@@/main/18 - Mon Jul  3 23:45:22 2006
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
1.1             ma      1. initial release.

1.2             lc      1. deleted DiscConf, RstReq and RstInd primitives
                        2. changed SdtBndReq type (no link number)
                        3. changed Status type to MtpStatus type
                        4. added credit parameter to DatCfm primitive         

1.3             jrl     1. text changes

*********************************************************************71*/

/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.4          ---  jrl   1. text changes

1.5          ---  jrl   1. text changes

1.6          ---  lc    1. removed #ifdef SD for matrix types

1.7          ---  lc    1. added Unbind Request

2.1          ---  mc    1. new interface

2.2          ---  mc    1. change SuPost to SuPst and SpPost to SpPst

2.3          ---  mc    1. added support for MTP Level 3 Simple Router.

2.4          ---  mc    1. changed MtpStatus type to SeqU24 type which is U32 to
                           support BCBI variant in StaReq and StaCfm primitives.

2.5          ---  mc    1. added a new service provider - Q.2140 SA.
             ---  mc    2. changed credit type from Credit to SeqU24 in SdtDatCfm
                           primitives.
*********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
2.6          ---      pm   1. added prototypes for SnLisdtBndCfm, SdUisdtBndCfm 
                              and SaUiSdtBndCfm primitives.
             ---      sr   2. prototypes for common packing/unpacking
                              functions.
             ---      pm   3. removed SNVER2 and SDVER2 flags. 
                              functions
             ---      sr   4. naming convention for common pack/unpack function
                              functions changed to comply with tco.
                           5. extern declarations modified.
                           6. c++ syntax added.
  
/main/14        ---      ssk  7. Added function prototypes for LDF functions in 
                              sdt interface within DN.         
/main/16     ---      hl   1. Added M2UA and its NIF portion.
/main/17     ---      hr   Added M2PA portion
/main/18     ---      uv   1. Added support for DSML.		      
                           2. Added extern decl for SaUiSdtFlcInd
*********************************************************************91*/

