/*******************************************************************************
*
* Title: mu_bdy1.c 
*
* Description: MEGACO User Layer confirms and indications 
*
* Written By: Kapil Gupta (kgupta@sangoma.com)
*
* Date: 05-08-2012
*
*******************************************************************************/
/* header include files (.h) */

#ifndef __MU_MG_UTILS_X__
#define __MU_MG_UTILS_X__

#ifdef __cplusplus
extern "C" {
#endif

/* MG Stack memory alloc/free APIs**********************************************/

EXTERN S16 mgUtlDelMgMgcoCmdReply ARGS((MgMgcoCmdReply *dst));
EXTERN S16 mgUtlDelMgMgcoCommandReq ARGS((MgMgcoCommandReq *dst));
EXTERN S16 mgUtlDelMgMgcoCommand ARGS((MgMgcoCommand *dst));
EXTERN S16 mgUtlDelMgMgcoInd ARGS((MgMgcoInd *dst));
EXTERN S16 mgUtlDelMgMgcoUpdateCntxt ARGS((MgMgcoUpdateCntxt *dst));
EXTERN S16 mgAllocEventMem ARGS((
       Ptr       *memPtr,
       Size      memSize
    ));

EXTERN S16 mgFreeEventMem ARGS((
       Ptr       memPtr
    ));




/* Function to allocate a Static Buffer */
EXTERN Data * mgMalloc ARGS((
       Size             size           /* Size of Static Buffer */
    ));
       
/* Function to deallocate a static buffer */
EXTERN Void mgDeAlloc ARGS((
       Data             *buf,          /* Static Buffer to be freed */
       Size             size           /* Size of Static Buffer */
    ));


extern S16 mgFreeEventMem ARGS(( Ptr       memPtr));
EXTERN S16 mgUtlAllocMgMgcoTermIdLst ARGS(( MgMgcoTermIdLst *dst, MgMgcoTermIdLst *src));
EXTERN S16 mgUtlDeAllocMgMgcoTermIdLst ARGS(( MgMgcoTermIdLst *dst));
EXTERN S16 mgUtlCpyMgMgcoTermId ARGS((MgMgcoTermId *dst, MgMgcoTermId *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermIdLst ARGS((MgMgcoTermIdLst *dst, MgMgcoTermIdLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlGrowList            ARGS((Void ***list, U16 typeSize, TknU16 *numComp, CmMemListCp *evnt));
EXTERN S16 mgUtlShrinkList            ARGS((Void ***list, U16 typeSize, TknU16 *numComp, CmMemListCp *evnt));
EXTERN S16 mgUtlCpyMgMgcoMediaDesc ARGS((MgMgcoMediaDesc *dst, MgMgcoMediaDesc *src, CmMemListCp *mem));
EXTERN S16 SGetRefDateTimeAdj ARGS((U32 refTime,U32 delaymsec,REG1 DateTime *dt,U32 *usec));




EXTERN S16 mgUtlCpyMgMgcoAuditItem ARGS((MgMgcoAuditItem *dst, MgMgcoAuditItem *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoName ARGS((MgMgcoName *dst, MgMgcoName *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPkgdName ARGS((MgMgcoPkgdName *dst, MgMgcoPkgdName *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigName ARGS((MgMgcoSigName *dst, MgMgcoSigName *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigLst ARGS((MgMgcoSigLst *dst, MgMgcoSigLst *src, CmMemListCp *mem));
#if(  defined(  GCP_PKG_MGCO_ADVAUSRVRBASE)  || defined(  GCP_PKG_MGCO_AASDIGCOLLECT)  || defined(  GCP_PKG_MGCO_AASRECODING)  || defined(  GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) ) 
EXTERN S16 mgUtlCpyMgMgcoFileUrl ARGS((MgMgcoFileUrl *dst, MgMgcoFileUrl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoHostPort ARGS((MgMgcoHostPort *dst, MgMgcoHostPort *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoUsrPw ARGS((MgMgcoUsrPw *dst, MgMgcoUsrPw *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLogin ARGS((MgMgcoLogin *dst, MgMgcoLogin *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPathType ARGS((MgMgcoPathType *dst, MgMgcoPathType *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoFtpUrl ARGS((MgMgcoFtpUrl *dst, MgMgcoFtpUrl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPathSearch ARGS((MgMgcoPathSearch *dst, MgMgcoPathSearch *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoHttpUrl ARGS((MgMgcoHttpUrl *dst, MgMgcoHttpUrl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoProvSegSpec ARGS((MgMgcoProvSegSpec *dst, MgMgcoProvSegSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoVvarSpec ARGS((MgMgcoVvarSpec *dst, MgMgcoVvarSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSelType ARGS((MgMgcoSelType *dst, MgMgcoSelType *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSelSpecLst ARGS((MgMgcoSelSpecLst *dst, MgMgcoSelSpecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSelList ARGS((MgMgcoSelList *dst, MgMgcoSelList *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoVarSegSpec ARGS((MgMgcoVarSegSpec *dst, MgMgcoVarSegSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSpec ARGS((MgMgcoSpec *dst, MgMgcoSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSegSpec ARGS((MgMgcoSegSpec *dst, MgMgcoSegSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAnncSpec ARGS((MgMgcoAnncSpec *dst, MgMgcoAnncSpec *src, CmMemListCp *mem));
#endif

EXTERN S16 mgUtlDelMgMgcoSvcChgPar ARGS((MgMgcoSvcChgPar *dst));
EXTERN S16 mgUtlCpyMgMgcoSvcChgPar ARGS((MgMgcoSvcChgPar *dst, MgMgcoSvcChgPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoValue ARGS((MgMgcoValue *dst, MgMgcoValue *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAuthHdr ARGS((MgMgcoAuthHdr *dst, MgMgcoAuthHdr *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDomAddrPort ARGS((MgMgcoDomAddrPort *dst, MgMgcoDomAddrPort *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDomNamePort ARGS((MgMgcoDomNamePort *dst, MgMgcoDomNamePort *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMid ARGS((MgMgcoMid *dst, MgMgcoMid *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoValLst ARGS((MgMgcoValLst *dst, MgMgcoValLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoValRng ARGS((MgMgcoValRng *dst, MgMgcoValRng *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoParmValue ARGS((MgMgcoParmValue *dst, MgMgcoParmValue *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPropParm ARGS((MgMgcoPropParm *dst, MgMgcoPropParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPropParmLst ARGS((MgMgcoPropParmLst *dst, MgMgcoPropParmLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLocalParm ARGS((MgMgcoLocalParm *dst, MgMgcoLocalParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLclCtlDesc ARGS((MgMgcoLclCtlDesc *dst, MgMgcoLclCtlDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPropGrpLst ARGS((MgMgcoPropGrpLst *dst, MgMgcoPropGrpLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLocalDesc ARGS((MgMgcoLocalDesc *dst, MgMgcoLocalDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermStateParm ARGS((MgMgcoTermStateParm *dst, MgMgcoTermStateParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermStateDesc ARGS((MgMgcoTermStateDesc *dst, MgMgcoTermStateDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoStreamParm ARGS((MgMgcoStreamParm *dst, MgMgcoStreamParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoStreamDesc ARGS((MgMgcoStreamDesc *dst, MgMgcoStreamDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMediaPar ARGS((MgMgcoMediaPar *dst, MgMgcoMediaPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMediaDesc ARGS((MgMgcoMediaDesc *dst, MgMgcoMediaDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNonStdId ARGS((MgMgcoNonStdId *dst, MgMgcoNonStdId *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoModemType ARGS((MgMgcoModemType *dst, MgMgcoModemType *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoModemTypeLst ARGS((MgMgcoModemTypeLst *dst, MgMgcoModemTypeLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNonStdExtn ARGS((MgMgcoNonStdExtn *dst, MgMgcoNonStdExtn *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoModemDesc ARGS((MgMgcoModemDesc *dst, MgMgcoModemDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMuxDesc ARGS((MgMgcoMuxDesc *dst, MgMgcoMuxDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtOther ARGS((MgMgcoEvtOther *dst, MgMgcoEvtOther *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNtfyCmpl ARGS((MgMgcoNtfyCmpl *dst, MgMgcoNtfyCmpl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigPar ARGS((MgMgcoSigPar *dst, MgMgcoSigPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigParLst ARGS((MgMgcoSigParLst *dst, MgMgcoSigParLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsReq ARGS((MgMgcoSignalsReq *dst, MgMgcoSignalsReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsReqLst ARGS((MgMgcoSignalsReqLst *dst, MgMgcoSignalsReqLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsLst ARGS((MgMgcoSignalsLst *dst, MgMgcoSignalsLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsParm ARGS((MgMgcoSignalsParm *dst, MgMgcoSignalsParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsDesc ARGS((MgMgcoSignalsDesc *dst, MgMgcoSignalsDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapLet ARGS((MgMgcoDigMapLet *dst, MgMgcoDigMapLet *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapRng ARGS((MgMgcoDigMapRng *dst, MgMgcoDigMapRng *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigStrElem ARGS((MgMgcoDigStrElem *dst, MgMgcoDigStrElem *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigStr ARGS((MgMgcoDigStr *dst, MgMgcoDigStr *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMap ARGS((MgMgcoDigMap *dst, MgMgcoDigMap *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapVal ARGS((MgMgcoDigMapVal *dst, MgMgcoDigMapVal *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtDM ARGS((MgMgcoEvtDM *dst, MgMgcoEvtDM *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtParSec ARGS((MgMgcoEvtParSec *dst, MgMgcoEvtParSec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtParSecLst ARGS((MgMgcoEvtParSecLst *dst, MgMgcoEvtParSecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtSec ARGS((MgMgcoEvtSec *dst, MgMgcoEvtSec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtSecLst ARGS((MgMgcoEvtSecLst *dst, MgMgcoEvtSecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbedFirst ARGS((MgMgcoEmbedFirst *dst, MgMgcoEmbedFirst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbWithSig ARGS((MgMgcoEmbWithSig *dst, MgMgcoEmbWithSig *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtPar ARGS((MgMgcoEvtPar *dst, MgMgcoEvtPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtParLst ARGS((MgMgcoEvtParLst *dst, MgMgcoEvtParLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoReqEvt ARGS((MgMgcoReqEvt *dst, MgMgcoReqEvt *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtLst ARGS((MgMgcoEvtLst *dst, MgMgcoEvtLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoReqEvtDesc ARGS((MgMgcoReqEvtDesc *dst, MgMgcoReqEvtDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAmmDescLst ARGS((MgMgcoAmmDescLst *dst, MgMgcoAmmDescLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAmmDesc ARGS((MgMgcoAmmDesc *dst, MgMgcoAmmDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoObsEvtDesc ARGS((MgMgcoObsEvtDesc *dst, MgMgcoObsEvtDesc *src, CmMemListCp *mem));

EXTERN S16 mgUtlDelMgMgcoReqEvtDesc ARGS((MgMgcoReqEvtDesc *dst));


#ifdef __cplusplus
}
#endif /* _cplusplus */

#endif   /* __MU_MG_UTILS_X__ */


