/*******************************************************************************
*
* Title: mu_bdy1.c 
*
* Description: MEGACO User Layer confirms and indications 
*
* Written By: Kapil Gupta (kgupta@sangoma.com)
*
* Date: 05-08-2012
*
*******************************************************************************/
/* header include files (.h) */

#ifndef __MU_DEBUG_PRINTS_X__
#define __MU_DEBUG_PRINTS_X__

#ifdef __cplusplus
extern "C" {
#endif

EXTERN S16 mgUtlDelMgMgcoCommand ARGS((MgMgcoCommand *dst));
EXTERN S16 mgUtlDelMgMgcoInd ARGS((MgMgcoInd *dst));
EXTERN S16 mgUtlDelMgMgcoUpdateCntxt ARGS((MgMgcoUpdateCntxt *dst));

/* mg004.105: Added for printing the event structures */
#ifdef MG_ACC_EVNT_PRNT
/* mg005.105: Support of Package Id U16 */
EXTERN  S16 mgAccEvntPrntTknPkgId ARGS((TknPkgId *tknPkgId, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntTknU8 ARGS((TknU8 *tknU8, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntTknU16 ARGS((TknU16 *tknU16, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntTknU32 ARGS((TknU32 *tknU32, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntTknS32 ARGS((TknS32 *tknS32, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntTknStr8 ARGS((TknStr8 *tknStr, FILE *prBuf));

EXTERN  S16 mgAccEvntPrntS8 ARGS((S8 *val, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntU8 ARGS((U8 *val, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntS16 ARGS((S16 *val, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntU16 ARGS((U16 *val, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntS32 ARGS((S32 *val, FILE *prBuf));
EXTERN  S16 mgAccEvntPrntU32 ARGS((U32 *val, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgLclErr ARGS((MgLclErr *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgPeerInfo   ARGS((MgPeerInfo *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgTransInfo  ARGS((MgTransInfo *param, FILE *prBuf));


EXTERN S16 mgAccEvntPrntMgMoveTransInfo ARGS((MgMoveTransInfo *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgtCntrl      ARGS((MgMgtCntrl *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgTransStatus   ARGS((MgTransStatus *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgAuditInfo     ARGS((MgAuditInfo *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgtAudit      ARGS((MgMgtAudit *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntTknStrBMPXL     ARGS((TknStrBMPXL *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntTknStrBMP4     ARGS((TknStrBMP4 *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntTknStrBSXL     ARGS((TknStrBSXL *tknStr, FILE *prBuf));
#ifdef GCP_MGCO
#ifdef MGT_MGCO_V2
EXTERN S16 mgAccEvntPrntMgMgcoIndAudPropParm ARGS((MgMgcoIndAudPropParm *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudStreamMode ARGS((MgMgcoIndAudStreamMode *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudLocalParm ARGS((MgMgcoIndAudLocalParm *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudLclCtlDesc ARGS((MgMgcoIndAudLclCtlDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudPropParmLst ARGS((MgMgcoIndAudPropParmLst *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudPropGrp ARGS((MgMgcoIndAudPropGrp *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudLocalDesc ARGS((MgMgcoIndAudLocalDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudSvcState ARGS((MgMgcoIndAudSvcState *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudTermStateParm ARGS((MgMgcoIndAudTermStateParm *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudTermStateDesc ARGS((MgMgcoIndAudTermStateDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudStreamParm ARGS((MgMgcoIndAudStreamParm *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudStreamDesc ARGS((MgMgcoIndAudStreamDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudMediaParm ARGS((MgMgcoIndAudMediaParm *param,
                                             FILE *prBuf));


EXTERN S16 mgAccEvntPrntMgMgcoIndAudMediaDesc ARGS((MgMgcoIndAudMediaDesc *param,
                                             FILE *prBuf));

#if ((defined(MGT_MGCO_V2) && defined(GCP_ASN)) || defined(GCP_VER_2_1))
EXTERN S16 mgAccEvntPrntMgMgcoIndAudSigPar    ARGS((MgMgcoIndAudSigPar *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudSigParLst ARGS((MgMgcoIndAudSigParLst *param,
                                             FILE *prBuf));
#endif /*  (GCP_VER_2_1 && GCP_ASN) || GCP_VER_2_1 */

EXTERN S16 mgAccEvntPrntMgMgcoIndAudSigReq ARGS((MgMgcoIndAudSigReq *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudSigLst ARGS((MgMgcoIndAudSigLst *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudSignalsDesc ARGS((MgMgcoIndAudSignalsDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudEvtsDesc ARGS((MgMgcoIndAudEvtsDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudEventSpecParm ARGS((MgMgcoIndAudEventSpecParm *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudEventSpecParmLst ARGS((MgMgcoIndAudEventSpecParmLst *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudEvtBufferDesc ARGS((MgMgcoIndAudEvtBufferDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudDigMapDesc ARGS((MgMgcoIndAudDigMapDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudStatsDesc ARGS((MgMgcoIndAudStatsDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudPkgsDesc ARGS((MgMgcoIndAudPkgsDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudAuditRetParm ARGS((MgMgcoIndAudAuditRetParm *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudTermAudit    ARGS((MgMgcoIndAudTermAudit *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoAuditItem          ARGS((MgMgcoAuditItem *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudEvtBufferDesc   ARGS((MgMgcoIndAudEvtBufferDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudEvtsDesc ARGS((MgMgcoIndAudEvtsDesc *param,
                                             FILE *prBuf));

EXTERN S16 mgAccEvntPrntMgMgcoIndAudStreamParm ARGS((MgMgcoIndAudStreamParm *param,
                                             FILE *prBuf));
#endif /* MGT_MGCO_V2 */
EXTERN S16 mgAccEvntPrntMgMgcoRequestId       ARGS((MgMgcoRequestId *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoContextId       ARGS((MgMgcoContextId *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPathName        ARGS((MgMgcoPathName *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTermId          ARGS((MgMgcoTermId *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTermIdLst       ARGS((MgMgcoTermIdLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTimeStamp       ARGS((MgMgcoTimeStamp *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoName            ARGS((MgMgcoName *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPkgdName        ARGS((MgMgcoPkgdName *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSigName         ARGS((MgMgcoSigName *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSigLst          ARGS((MgMgcoSigLst *param,
                                             FILE *prBuf));
#if(  defined(  GCP_PKG_MGCO_ADVAUSRVRBASE)  || defined(  GCP_PKG_MGCO_AASDIGCOLLECT)  || defined(  GCP_PKG_MGCO_AASRECODING)  || defined(  GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) ) 
EXTERN S16 mgAccEvntPrntMgMgcoFileUrl         ARGS((MgMgcoFileUrl *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoHostPort        ARGS((MgMgcoHostPort *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoUsrPw           ARGS((MgMgcoUsrPw *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoLogin           ARGS((MgMgcoLogin *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPathType        ARGS((MgMgcoPathType *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoFtpUrl          ARGS((MgMgcoFtpUrl *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPathSearch      ARGS((MgMgcoPathSearch *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoHttpUrl         ARGS((MgMgcoHttpUrl *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoProvSegSpec     ARGS((MgMgcoProvSegSpec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTodSpec         ARGS((MgMgcoTodSpec *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDateSpec        ARGS((MgMgcoDateSpec *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMoneySpec       ARGS((MgMgcoMoneySpec *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoIntSpec         ARGS((MgMgcoIntSpec *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoVvarSpec        ARGS((MgMgcoVvarSpec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSelType         ARGS((MgMgcoSelType *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSelSpecLst      ARGS((MgMgcoSelSpecLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSelList         ARGS((MgMgcoSelList *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoVarSegSpec      ARGS((MgMgcoVarSegSpec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSpec            ARGS((MgMgcoSpec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSegSpec         ARGS((MgMgcoSegSpec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAnncSpec        ARGS((MgMgcoAnncSpec *param, 
                                             FILE *prBuf));
#endif
EXTERN S16 mgAccEvntPrntMgMgcoValue           ARGS((MgMgcoValue *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAuthHdr         ARGS((MgMgcoAuthHdr *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDomAddrPort     ARGS((MgMgcoDomAddrPort *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDomNamePort     ARGS((MgMgcoDomNamePort *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMid             ARGS((MgMgcoMid *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoErrDesc         ARGS((MgMgcoErrDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTopoDesc        ARGS((MgMgcoTopoDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTopoDescLst     ARGS((MgMgcoTopoDescLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoContextProps    ARGS((MgMgcoContextProps *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoContextAudit    ARGS((MgMgcoContextAudit *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoValLst          ARGS((MgMgcoValLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoValRng          ARGS((MgMgcoValRng *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoParmValue       ARGS((MgMgcoParmValue *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPropParm        ARGS((MgMgcoPropParm *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPropParmLst     ARGS((MgMgcoPropParmLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoLocalParm       ARGS((MgMgcoLocalParm *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoLclCtlDesc      ARGS((MgMgcoLclCtlDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPropGrpLst      ARGS((MgMgcoPropGrpLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoLocalDesc       ARGS((MgMgcoLocalDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTermStateParm   ARGS((MgMgcoTermStateParm *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTermStateDesc   ARGS((MgMgcoTermStateDesc *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoStreamParm      ARGS((MgMgcoStreamParm *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoStreamDesc      ARGS((MgMgcoStreamDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMediaPar        ARGS((MgMgcoMediaPar *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMediaDesc       ARGS((MgMgcoMediaDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoH221NonStd      ARGS((MgMgcoH221NonStd *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoNonStdId        ARGS((MgMgcoNonStdId *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoModemType       ARGS((MgMgcoModemType *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoModemTypeLst    ARGS((MgMgcoModemTypeLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoNonStdExtn      ARGS((MgMgcoNonStdExtn *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoModemDesc       ARGS((MgMgcoModemDesc *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMuxDesc         ARGS((MgMgcoMuxDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtOther        ARGS((MgMgcoEvtOther *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoNtfyCmpl        ARGS((MgMgcoNtfyCmpl *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSigPar          ARGS((MgMgcoSigPar *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSigParLst       ARGS((MgMgcoSigParLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSignalsReq      ARGS((MgMgcoSignalsReq *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSignalsReqLst   ARGS((MgMgcoSignalsReqLst *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSignalsLst      ARGS((MgMgcoSignalsLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSignalsParm     ARGS((MgMgcoSignalsParm *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSignalsDesc     ARGS((MgMgcoSignalsDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigRng          ARGS((MgMgcoDigRng *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigMapLet       ARGS((MgMgcoDigMapLet *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigMapRng       ARGS((MgMgcoDigMapRng *param, FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigStrElem      ARGS((MgMgcoDigStrElem *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigStr          ARGS((MgMgcoDigStr *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigMap          ARGS((MgMgcoDigMap *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigMapVal       ARGS((MgMgcoDigMapVal *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtDM           ARGS((MgMgcoEvtDM *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtParSec       ARGS((MgMgcoEvtParSec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtParSecLst    ARGS((MgMgcoEvtParSecLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtSec          ARGS((MgMgcoEvtSec *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtSecLst       ARGS((MgMgcoEvtSecLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEmbedFirst      ARGS((MgMgcoEmbedFirst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEmbWithSig      ARGS((MgMgcoEmbWithSig *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtPar          ARGS((MgMgcoEvtPar *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtParLst       ARGS((MgMgcoEvtParLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoReqEvt          ARGS((MgMgcoReqEvt *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvtLst          ARGS((MgMgcoEvtLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoReqEvtDesc      ARGS((MgMgcoReqEvtDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoEvBufDesc       ARGS((MgMgcoEvBufDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoDigMapDesc      ARGS((MgMgcoDigMapDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAuditDesc       ARGS((MgMgcoAuditDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAmmDesc         ARGS((MgMgcoAmmDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAmmDescLst      ARGS((MgMgcoAmmDescLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAmmReq          ARGS((MgMgcoAmmReq *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSubAudReq       ARGS((MgMgcoSubAudReq *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoObsEvt          ARGS((MgMgcoObsEvt *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoObsEvtLst       ARGS((MgMgcoObsEvtLst *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoObsEvtDesc      ARGS((MgMgcoObsEvtDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoNtfyReq         ARGS((MgMgcoNtfyReq *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgMethod    ARGS((MgMgcoSvcChgMethod *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgProf      ARGS((MgMgcoSvcChgProf *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgPar       ARGS((MgMgcoSvcChgPar *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgReq       ARGS((MgMgcoSvcChgReq *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoCmd             ARGS((MgMgcoCmd *param, 
                                             FILE *prBuf));
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoCommandReq      ARGS((MgMgcoCommandReq *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoCommandReq      ARGS((MgMgcoCommandReq *param, 
                                             FILE *prBuf));
#endif
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoCmdReqLst       ARGS((MgMgcoCmdReqLst *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoCmdReqLst       ARGS((MgMgcoCmdReqLst *param, 
                                             FILE *prBuf));
#endif
EXTERN S16 mgAccEvntPrntMgMgcoActionReq       ARGS((MgMgcoActionReq *param, 
                                             FILE *prBuf));
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoActionLst       ARGS((MgMgcoActionLst *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoActionLst       ARGS((MgMgcoActionLst *param, 
                                             FILE *prBuf));
#endif
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoTxnReq          ARGS((MgMgcoTxnReq *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoTxnReq          ARGS((MgMgcoTxnReq *param, 
                                             FILE *prBuf));
#endif
EXTERN S16 mgAccEvntPrntMgMgcoStatsPar        ARGS((MgMgcoStatsPar *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoStatsDesc       ARGS((MgMgcoStatsDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPkgsItem        ARGS((MgMgcoPkgsItem *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoPkgsDesc        ARGS((MgMgcoPkgsDesc *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAudRetParm      ARGS((MgMgcoAudRetParm *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTermAuditRes    ARGS((MgMgcoTermAuditRes *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAmmsReply       ARGS((MgMgcoAmmsReply *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAuditOther      ARGS((MgMgcoAuditOther *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoAuditReply      ARGS((MgMgcoAuditReply *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoNtfyReply       ARGS((MgMgcoNtfyReply *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgResPar    ARGS((MgMgcoSvcChgResPar *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgRes       ARGS((MgMgcoSvcChgRes *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoSvcChgReply     ARGS((MgMgcoSvcChgReply *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoCmdReply        ARGS((MgMgcoCmdReply *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoCmdReplyLst     ARGS((MgMgcoCmdReplyLst *param, 
                                             FILE *prBuf));
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoCxtCmdReply     ARGS((MgMgcoCxtCmdReply *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoCxtCmdReply     ARGS((MgMgcoCxtCmdReply *param, 
                                             FILE *prBuf));
#endif
EXTERN S16 mgAccEvntPrntMgMgcoErrCmdRepSet    ARGS((MgMgcoErrCmdRepSet *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoActnReply       ARGS((MgMgcoActnReply *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoActnReplyLst    ARGS((MgMgcoActnReplyLst *param, 
                                             FILE *prBuf));
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoTxnReply        ARGS((MgMgcoTxnReply *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoTxnReply        ARGS((MgMgcoTxnReply *param, 
                                             FILE *prBuf));
#endif
EXTERN S16 mgAccEvntPrntMgMgcoTxnPend         ARGS((MgMgcoTxnPend *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTxnAck          ARGS((MgMgcoTxnAck *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoTxnRspAck       ARGS((MgMgcoTxnRspAck *param, 
                                             FILE *prBuf));
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoTxn             ARGS((MgMgcoTxn *param, 
                                             FILE *prBuf));
#else
EXTERN S16 mgAccEvntPrntMgMgcoTxn             ARGS((MgMgcoTxn *param, 
                                             FILE *prBuf));
#endif
EXTERN S16 mgAccEvntPrntMgMgcoTxnLst          ARGS((MgMgcoTxnLst *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMsgBody         ARGS((MgMgcoMsgBody *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoMsg             ARGS((MgMgcoMsg *param, FILE *prBuf));
#endif /* GCP_MGCO */
EXTERN S16 mgAccEvntPrntMgMgtSta              ARGS((MgMgtSta *param, FILE *prBuf));
#ifdef GCP_CH
EXTERN S16 mgAccEvntPrntMgMgcoCommand         ARGS((MgMgcoCommand *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoChCnFILE         ARGS((MgMgcoChCntxt *param, 
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoUpdateCnFILE     ARGS((MgMgcoUpdateCntxt *param,
                                             FILE *prBuf));
EXTERN S16 mgAccEvntPrntMgMgcoInd             ARGS((MgMgcoInd *param,
                                             FILE *prBuf));  
#endif /* GCP_CH */

 
/* Primitive packing functions */
PUBLIC S16 mgAccEvntPrntTknStrOSXL ARGS(( TknStrOSXL *tknStr, FILE *prBuf));

PUBLIC S16 mgAccEvntPrntMgtBndReq ARGS((MgtBndReq func, FILE *prBuf));
PUBLIC S16 mgAccEvntPrntMgtUbndReq ARGS((MgtUbndReq func, FILE *prBuf));
PUBLIC S16 mgAccEvntPrntMgtBndCfm ARGS((MgtBndCfm func, FILE *prBuf));
PUBLIC S16 mgAccEvntPrntMgtCntrlReq ARGS((MgtCntrlReq func, FILE *prBuf));
PUBLIC S16 mgAccEvntPrntMgtCntrlCfm ARGS((MgtCntrlCfm func, FILE *prBuf));
PUBLIC S16 mgAccEvntPrntMgtAuditReq ARGS((MgtAuditReq func, FILE *prBuf));
PUBLIC S16 mgAccEvntPrntMgtAuditCfm ARGS((MgtAuditCfm func, FILE *prBuf));

PUBLIC S16 mgAccEvntPrntMgtStaInd ARGS((MgtStaInd func, FILE *prBuf));

#ifdef GCP_MGCO
PUBLIC S16 mgAccEvntPrntMgtMgcoTxnReq ARGS((MgMgcoMsg *mgTxn));
/* PUBLIC S16 mgAccEvntPrntMgtMgcoTxnInd ARGS((MgtMgcoTxnInd  func,
                                     FILE *prBuf));*/
EXTERN S16 mgAccEvntPrntTknPres      ARGS((TknPres      *tknPres,       FILE *prBuf));
EXTERN S16 mgAccEvntPrntTknStr4   ARGS((TknStr4   *tknStr,   FILE *prBuf));
EXTERN  S16  mgAccEvntPrntTknBuf  ARGS((TknBuf *tknBuf, FILE *prBuf));
#endif /* GCP_MGCO */
#ifdef GCP_CH
PUBLIC  S16  mgAccEvntPrntMgMgcoChCntxt ARGS((MgMgcoChCntxt *param, FILE *prBuf));
PUBLIC  S16  mgAccEvntPrntMgMgcoUpdateCntxt ARGS((MgMgcoUpdateCntxt *param, FILE *prBuf));
#endif
#ifdef GCP_ASN
EXTERN S16 mgAccEvntPrntMgMgcoWildcard        ARGS((MgMgcoWildcard *param, 
                                             FILE *prBuf));
#endif /* GCP_ASN */

#endif   /* MG_ACC_EVNT_PRNT */

#ifdef __cplusplus
}
#endif /* _cplusplus */

#endif   /* __MU_DEBUG_PRINTS_X__ */

/********************************************************************30**

         End of file:     mg_act.x@@/main/5 - Wed Nov 14 22:38:44 2007

*********************************************************************31*/
/********************************************************************40**

        Notes:

*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

/********************************************************************60**

        Revision history:

*********************************************************************61*/

/********************************************************************80**

*********************************************************************81*/

/********************************************************************90**

    ver       pat    init                  description
----------- -------- ---- -----------------------------------------------
1.1          ---      nct  1.Initial version
1.2          ---      bbk  1. Added mgInetGetHostByName.
                           2. Removed C++ compilation warnings
1.3          ---      bbk  1. Fixed errors for loose coupling
1.3+       mg002.101   pk  2. Changed messages sent in
                              mgAccSendPiggyBackedCmd.
           mg008.101  bbk  1. Made changes to have test cases run
                              in IP Loopback mode
             /main/1
           mg011.102  VJ   1. Added declaration for new MGCP configuration
                              function mgAccMgcpGenCfg2.
/main/2      ---      ra   1. GCP 1.3 release
           mg010.103  rg   1. Added declarations for test case 62
           mg013.103  ra   1. Added declarations for test case 63
/main/3      ---      ka   1. Changes for Release v 1.4
/main/4      ---      pk   1. GCP 1.5 release
          mg002.105  ra   1. Added new test case to test sending immediate
                              rspAckRsp.
                          2. Added new function for MTP3 simulation testing    
                          3. Added new test cases for TCR 21
                          4. Added new test for PSF to test 
                             Command Handler funtionality 
                          5. Removed patch reference for 1.3 and 1.4   
                          6. Addition of new test case for testing exceed 
                               maximum PDU size
          mg004.105   gk  1. Added for binary decoding 
                          2. Added for printing the event structures
          mg005.105   gk  1. Support of Package Id U16
                          2. Removal of Warnings
          mg006.105   gk  1. Addition of new test case for testing all binary
                             messages through ethereal
          mg007.105   gk  1. 26 New Test cases added for ASN 1 encoding
          mg015.105   gk  1. Added new Test Cases for CH-Module Interface Redesign
/main/5      ---        sck  1. Updated for Release GCP 2.1
*********************************************************************91*/
