/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:    GCP
  
     Type:    C include file 
  
     Desc:    Structures, variables and typedefs required by GCP
 
     File:    mgt.x

     Sid:      mgt.x@@/main/17 - Thu Nov 15 14:19:19 2007
  
     Prg:     pk
  
*********************************************************************21*/
  
/*
*     The typedefs declared in this file correspond to those
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000XXX     GCP
*
*/

#ifndef __MGTX__
#define __MGTX__
#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************
                     Structures Common to MEGACO and MGCP
 ***********************************************************************/

/****  Local Error  ****/
typedef struct mgLclErr
{
   TknU8  errType;
   TknU32 trId;
} MgLclErr;


/****  Domain Name ****/
typedef struct mgDName
{
  CmNetAddr  netAddr;
  TknPres    namePres;
  U8         name[CM_DNS_DNAME_LEN];
} MgDName;
/* mgt_x_002.main_12: Support for packages to U16 under
 * the flag MGT_PROPR_PKG_SUPPORT */
/****  Local Error  ****/
typedef TknU8  TknPkgId;

#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))
/* 003.main_3: Added a structure for treating MID as string */
typedef struct mgMgcoMidStr
{
   U8         pres;
   U8         spare1;           /* spare */
   U16        len;
#ifdef ALIGN_64BIT
   U32        spare2;           /* for 64 bit alignment */
#endif
   U8         val[MGT_MID_STR_LEN];   
} MgMgcoMidStr;
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */


/****  Local Info ****/
typedef struct mgPeerInfo
{
   TknPres    pres;
   TknU32     id;                 /* Identifier of the peer */
   MgDName    dname;
   TknS32     port;               /* Port Number; -1 indicates absent */
#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))
   MgMgcoMidStr mid;              /* 003.main_3: Add a new field for MPID */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */

#ifdef   GCP_PROV_MTP3
   TknU32      selfPc;               /* Self  point Code of this SSAP  */
#endif   /* GCP_PROV_MTP3 */   

}MgPeerInfo; 


/**** Transaction Info ****/
typedef struct mgTransInfo
{
  U8 transType;
  U8 transDir;
  TknU32 firstTransId;
  TknU32 lastTransId;
}MgTransInfo;


/**** Information for Moving Transaction ****/
typedef struct mgMoveTransInfo
{
  MgPeerInfo newPeer;      /* Peer to whcih transactions are to be moved */
  MgTransInfo transInfo;   /* Information about transactions to be moved */
} MgMoveTransInfo;

/**** GCP Control Structure ****/
typedef struct mgMgtCntrl
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
  U8 bitVector;        /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */   
  U8 action;
  MgPeerInfo peerInfo;
  union
   {
     U16 dura;       /* Timer for peer removal */
     MgTransInfo transInfo; /* Transaction information */
     SpId  ssapId;          /* New SSAP id to move peer */
     MgMoveTransInfo moveTransInfo; /* Information Reqd for moving trans */
   }u;
} MgMgtCntrl;


/**** GCP Transaction Status Structure ****/
typedef struct mgTransStatus
{
  U32 transId;         /* Transaction Id */
  U8 transStatus;      /* Transaction Status */
  U8 transDir;         /* Originated/Received */
} MgTransStatus;


/**** GCP Audit Info Structure ****/
typedef struct mgAuditInfo
{
  U16  numTxn;                             /* Number of Tranactions */
  Bool moreTxn;                            /* More transactions */
  MgTransStatus transStatus[MGT_MAX_TXNS];  /* State of each transaction */
} MgAuditInfo;


/**** GCP Audit Structure ****/
typedef struct mgMgtAudit
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
  U8 bitVector;        /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */   
  MgPeerInfo peerInfo;          /* peer Info */
  MgAuditInfo auditInfo;       /* Audit related Info */
} MgMgtAudit;




/***********************************************************************
                      MGCP Specific Structures
 ***********************************************************************/
#ifdef GCP_MGCP

typedef TknStr32 MgCallId;
typedef TknStr32 MgConnId;
typedef TknStr32 MgRqstId;

typedef struct mgPkgName
{
   TknPkgId          pkgId;
   TknStrOSXL        name;
} MgPkgName;



#ifdef GCP_2705BIS

/*
   unKnownconnModVal has significance iff
          knownConnModVal == MGT_MGCP_CONN_MOD_EXTN_VAL_UNKNOWN_EXTN
*/
typedef struct mgConnModVal
{
   TknU8        knownConnModVal;     /* std val in the package */
   TknStrOSXL   unKnownconnModVal;   /* unknown value in the package */
} MgConnModVal;

typedef struct mgConnModeX
{
   MgPkgName      pkgName;        /* the package name */
   MgConnModVal   connModVal;     /* the connection mode in that package */
} MgConnModeX;

/*
   xMode has significance iff
       stdOrXion == MGT_SUPP_MODE_EXTENSION
*/
typedef struct mgConnMode
{
   TknU8   stdOrXion;
   MgConnModeX   xMode;    /* used for non std modes  */
} MgConnMode;
#else
typedef TknU8 MgConnMode;
#endif
typedef TknStr32 MgScndConnId;



#endif
/**** Event Parameter ****/
/****  ****/
typedef struct mgQuoteStr
{
   TknU16     numComp;
   TknStrOSXL **str;
} MgQuoteStr;

typedef struct mgEvntParamType
{
   TknU8 eventParamType;
   union
   {
      TknStrOSXL paramStr;
      MgQuoteStr quotedStr;
   } t;
} MgEvntParamType;
#ifdef GCP_MGCP
#ifdef GCP_2705BIS
typedef MgEvntParamType MgMgcpExtVal;

typedef struct mgMgcpExtValSet
{
   TknU16          num;
   MgMgcpExtVal  **val;
}MgMgcpExtValSet;
#endif

/****  MGCP Non Standard Extension  ****/
#ifdef GCP_2705BIS
typedef struct mgNonStdExtn
{
   TknPres       pres;
   TknU8         type;      /* mandatory adn optional */
   TknStrOSXL    extnName;
   MgMgcpExtValSet val;
} MgNonStdExtn;
#else
typedef struct mgNonStdExtn
{
   TknPres       pres;
   TknU8         type;      /* mandatory adn optional */
   TknStrOSXL    extnName;
   TknStrOSXL    extnVal;
} MgNonStdExtn;
#endif

/****  MGCP Command  ****/


/****  MGCP Command Line ****/

/**** End Point Name  ****/
typedef struct mgEPName
{
   TknPres    pres;        /* Present Flag */
   TknStrOSXL lclName;     /* local name part */
   TknStrOSXL domainName;  /* domain name part */
} MgEPName;



/**** MGCP version ****/
typedef struct mgMgcpVer
{
   TknPres    pres;
   TknU16     major;    /* major version */
   TknU16     minor;    /* minor version */
   TknStrOSXL profName; /* profile name */
} MgMgcpVer;

typedef struct mgMgcpVerSet
{
   TknU16     numComp;     /* Number of supported versions in VS: line */
   MgMgcpVer  **versions;
} MgMgcpVerSet;

typedef struct mgMgcpCmdLine
{
  TknPres           pres;      /* Present Flag */
  TknU32            trId;      /* 10 digit number */
  MgEPName          epName;    /* localName@domain-name*/
  MgMgcpVer         mgcpVer;   /* xxx.xxx format */
} MgMgcpCmdLine;


/**** Response acknowlegement ****/
typedef struct mgRspAck
{
   TknPres pres;
   TknU32  lowBnd;
   TknU32  upperBnd;
} MgRspAck;


/****  Response Ack Set  ****/
typedef struct mgRspAckSet
{
   TknU16        numComp;
   MgRspAck      **rspAck;
} MgRspAckSet;


#endif 
#ifdef GCP_2705BIS
typedef struct mgEvntOneParamType  MgEvntOneParamType;
#endif
/**** Event Parameter Set ****/
#ifdef GCP_2705BIS
typedef struct mgEvntParamTypeSet
{
   TknU16           numComp;
   MgEvntOneParamType  **evntParam;
} MgEvntParamTypeSet;
#else
typedef struct mgEvntParamTypeSet
{
   TknU16           numComp;
   MgEvntParamType  **evntParam;
} MgEvntParamTypeSet;
#endif
#ifdef GCP_MGCP
/**** Bearer Information ****/
#ifdef GCP_2705BIS


/*
 str has significance iff type == MGT_MGCP_CONN_OPT_PKG_EXTN_NAME_UNKNOWN_EXTN
*/
typedef struct mgMgcpName
{
   TknU8   type;  
   TknStrOSXL  str;
}MgMgcpName;

typedef struct mgEvntOneParamTypeVal
{
   TknStrOSXL  name;
   MgEvntParamType    val;
}MgEvntOneParamTypeVal;

typedef struct mgEvntParamTypeValSet
{
   TknStrOSXL  name;
   MgEvntParamTypeSet params;
}MgEvntParamTypeValSet;

/*
    the type field identifies the type of parameter
    val is significant iff type == MGT_EVNT_PARAM_ONLY_VAL
    oneParam is significant iff type == MGT_EVNT_PARAM_ONE_VAL
    paramSet is significant iff type == MGT_EVNT_PARAM_SET_VAL
*/
struct mgEvntOneParamType
{
   TknU8  type; /* Param value, One param or paramSet */
   union
   {
      MgEvntParamType        val;
      MgEvntOneParamTypeVal  oneParam;
      MgEvntParamTypeValSet  paramSet;
   }t;
};

typedef struct mgMgcpPkgSpcExtn
{
   MgPkgName   pkg;
   MgMgcpName  extnName;
   MgMgcpExtValSet val;
}MgMgcpPkgSpcExtn;

typedef struct mgMgcpOthExtn
{
   TknStr32         name;
   MgMgcpExtValSet  val;
} MgMgcpOthExtn;

/*
   type identifies the type of extension -
      type == MGT_MGCP_LCL_CONNOPT_VNDR_EXT     =>s  vndrX
      type == MGT_MGCP_LCL_CONNOPT_PKG_EXT      =>s  pkgX
      type == MGT_MGCP_LCL_CONNOPT_OTHR_EXT     =>s  othrX
*/
typedef struct mgMgcpExtn
{
   TknU8       type;  /*Package specific , Vendor specific or other extension*/
   union
   {
      MgNonStdExtn      vndrX;
      MgMgcpPkgSpcExtn  pkgX;
      MgMgcpOthExtn     othrX; 
   }t;
}MgMgcpExtn;


/* the following are for extensionParameter */
typedef struct mgMgcpPkgSpcExtnParam
{
   MgPkgName   pkg;
   MgMgcpName  extnName;
}MgMgcpPkgSpcExtnParam;

typedef struct mgNonStdExtnParam
{
   TknPres       pres;
   TknU8         type;      /* mandatory adn optional */
   TknStrOSXL    extnName;
} MgNonStdExtnParam;


/*
   type identifies the Extension Parameter type -
       type == MGT_MGCP_EXTN_PARAM_VNDR      =>s  vndrXParam
       type == MGT_MGCP_EXTN_PARAM_PKG       =>s  pkgXParam
       type == MGT_MGCP_EXTN_PARAM_OTHER     =>s  othrXParam
*/
typedef struct mgMgcpExtnParam
{
   TknU8       type;  /*Package specific , Vendor specific or other extension*/
   union
   {
      MgNonStdExtnParam      vndrXParam;
      MgMgcpPkgSpcExtnParam  pkgXParam;
      TknStr32               othrXParam; 
   }t;
}MgMgcpExtnParam;
/* end of extensionParameter */



/*
   type identifies the Bearer Attribute type -
       type == MGT_MGCP_BRR_ENCODING       =>s  brrEncd (std Val)
       type == MGT_MGCP_BRR_EXTN           =>s brrExtn (extension)
*/
typedef struct mgMgcpBrrAttr
{
   TknU8                  type;
   union
   {
      TknU8                  brrEncd;
      MgMgcpPkgSpcExtn       brrExtn;
   } t;
} MgMgcpBrrAttr;

typedef struct mgBearerInfo
{
   TknU16          numComp;
   MgMgcpBrrAttr   **bearerEnc;
} MgBearerInfo;

#else
typedef struct mgBearerInfo
{
   TknU16      numComp;
   TknU8       **bearerEnc;
} MgBearerInfo;
#endif



/****Connection Id Set ****/
typedef struct mgConnIdSet
{
   TknU16       numComp;
   MgConnId     **connId; 
} MgConnIdSet;


/****  Notified entity ****/
#ifdef GCP_2705BIS
typedef struct mgNtfiedEnt
{
   TknPres    pres;
   TknStrOSXL lclName;
   TknStrOSXL domainName;
   TknU16     port;
} MgNtfiedEnt;
#else
typedef struct mgNtfiedEnt
{
   TknPres    pres;
   TknStr32   lclName;
   TknStrOSXL domainName;
   TknU16     port;
} MgNtfiedEnt;
#endif


typedef struct mgSuppPkgs
{
   TknU16     numComp;
   MgPkgName  **pkgName;
} MgSuppPkgs;


#ifdef GCP_2705BIS
typedef struct mgSuppModes
{
   TknU16     numComp;
   MgConnMode    **mode;
} MgSuppModes;
#else
typedef struct mgSuppModes
{
   TknU16     numComp;
   TknU8      **mode;
} MgSuppModes;
#endif

typedef struct mgEncryptInfo
{
   TknPres    pres;
   TknU8      encryptMethod;
   TknStrOSXL encryptKey;
} MgEncryptInfo;


typedef struct mgGainCtrl
{
   TknU8   ctrlType;
   TknS16  gainVal;
}MgGainCtrl;


/* The range of algorithmName has been increased in RFC 3435 */
typedef struct mgAlgoNameSet
{
   TknU16         numComp;
   TknStrOSXL     **algoName;
} MgAlgoNameSet;


typedef struct mgBw
{
   TknPres pres;
   TknU16  lowBnd;
   TknU16  upperBnd;
} MgBw;

typedef struct mgPktzPeriod
{
   TknPres pres;
   TknU16  lowBnd;
   TknU16  upperBnd;
} MgPktzPeriod;

typedef struct mgRsvDest
{
   TknPres     pres;
   TknStrOSXL  domainName;
   TknU16      port;    /* optional */
} MgRsvDest;

typedef struct mgSecret 
{
   TknPres     pres;
   TknU8       method;
   TknStrOSXL  key;
} MgSecret;

typedef struct mgAuthEncAlgoSet
{
   TknU16            numComp;
   TknStrOSXL        **suites;
} MgAuthEncAlgoSet;

typedef struct mgCipherSuite
{
   TknPres           pres;
   MgAuthEncAlgoSet  authAlgoSet;
   MgAuthEncAlgoSet  encAlgoSet;
} MgCipherSuite;

typedef struct mgRsrcRsvSet
{
   TknU16            numComp;
   TknU8             **reservations;
} MgRsrcRsvSet;

/****  Local Connection Option ****/
#ifdef GCP_2705BIS

/*
   othrNwTyp is significant iff stdOrOthr == MGT_MGCP_LCL_CONNOPT_TON_OTHER
*/
typedef struct mgTypNwSupp
{
   TknU8         stdOrOthr;    /* either has std TON vals; or Other TON val */
   TknStrOSXL    othrNwTyp;    /* the other NW type supported */
} MgTypNwSupp;

typedef struct mgTypNwSuppSeq
{
   TknU16           numComp;
   MgTypNwSupp      **typeOfNetwork;
} MgTypNwSuppSeq;           /* optional sequence of */

/*
 oneOrmany identifies the Network Type - one or a set of Network Type
    oneOrmany == MGT_MGCP_TON            =>s typNwSupp (NW type supported)
    oneOrmany == MGT_MGCP_SUPP_TONS      =>s typNwSuppSeq (set of supp NW types)
*/
typedef struct mgNwTypeChc
{
   TknU8        oneOrmany;
   union
   {
      MgTypNwSupp          typNwSupp;
      MgTypNwSuppSeq       typNwSuppSeq;
   } u;
} MgNwTypeChc;          /* choice */
#endif


typedef struct mgMgcpLclFmtpVal
{
  TknPres                  pres;         /* param itself may be OPTIONAL */
  TknStrOSXL               codecName;
  TknU8                    codecInst;    /* codec instance; OPTIONAL */
  TknStrOSXL               formatName;
} MgMgcpLclFmtpVal;

typedef struct mgMgcpLclFmtpValSet
{
   TknU16                    numComp;   /* number of quoted strings */
   MgMgcpLclFmtpVal          **val;
} MgMgcpLclFmtpValSet;


/*
  type identifies the type of Connection ID
     type == MGT_MGCP_LCL_CONNOPT_RS_SH_THIS_CONN    =>s  $ (this connection)
     type == MGT_MGCP_LCL_CONNOPT_RS_SH_EMPTY_CONN   =>s  empty connection
     type == MGT_MGCP_LCL_CONNOPT_RS_SH_SPECFIC_CONN =>s  specific connection
     connId then identifies the specific connection ID & is valid only in the
     last case viz. type == MGT_MGCP_LCL_CONNOPT_RS_SH_SPECFIC_CONN
*/
typedef struct mgMgcpLclRsSh
{
   TknU8           type;    /* identifies type - $, empty, or ConnectionID */
   MgConnId        connId;  /* valid only for connection ID */
} MgMgcpLclRsSh;

/*
   valType == MGT_MGCP_LCL_CONNOPT_OPT_FMTP   =>s o-fmtp:  =>s fmtp field of t
   valType == MGT_MGCP_LCL_CONNOPT_FMTP       =>s fmtp:    =>s fmtp field of t
   valType == MGT_MGCP_LCL_CONNOPT_RES_DIR    =>s r-dir:   =>s rsDir field of t
   valType == MGT_MGCP_LCL_CONNOPT_RES_CNFM   =>s r-cnf:   =>s rsCnf field of t
   valType == MGT_MGCP_LCL_CONNOPT_RES_SHARE  =>s r-sh:    =>s rsSh field of t
*/
typedef struct mgLclConnOpts
{
   TknU8 valType;
   union
   {
      MgPktzPeriod          pktzPeriod;
      MgBw                  mgBw;
      MgAlgoNameSet         algoNameSet;
      TknU8                 ecancel;
      TknU8                 silSupp;
      MgGainCtrl            gainCtrl;
      TknU16                typeOfSrvc;
      TknU8                 rsrcResv;
#ifdef GCP_2705BIS
      MgNwTypeChc             typeOfNetwork;
#else
      TknU8                 typeOfNetwork;
#endif
      MgEncryptInfo         encryptInfo;
      MgSuppModes           suppModes;
      MgSuppPkgs            suppPkgs;
#ifdef GCP_2705BIS
      MgMgcpExtn            nonStdExtn;
#else
      MgNonStdExtn          nonStdExtn;
#endif
      TknU32                dqosGateId;         /* extra NCS DQOS parameter */
      MgRsrcRsvSet          dqosRsrcRsv;        /* extra NCS DQOS parameter */
      TknU32                dqosRsrcId;         /* extra NCS DQOS parameter */
      MgRsvDest             dqosRsvDest;        /* extra NCS DQOS parameter */
      MgSecret              secSecret;    /* extra NCS and TGCP parameter */
      MgCipherSuite         secRtpSuite;  /* extra NCS and TGCP parameter */
      MgCipherSuite         secRtcpSuite; /* extra NCS and TGCP parameter */
      MgMgcpLclFmtpValSet   fmtp;         /* for Media Format Package */
      TknU8                 rsDir;        /* for Resource Reservation pkg */
      TknU8                 rsCnf;        /* for Resource Reservation pkg */
      MgMgcpLclRsSh         rsSh;         /* for Resource Reservation pkg */
   } t;
} MgLclConnOpts;



/****  Local Connection Option Set ****/
typedef struct mgLclConnOptSet
{
   TknU16         numComp;
   MgLclConnOpts  **lclConnOpt;
} MgLclConnOptSet;



/**** Events Descriptor ****/

/*
   descType identifies the type of event descriptor
   In case the val of descType is MGT_DESC_EVENT_ALL, MGT_DESC_EVENT_DTMF_STAR
   or MGT_DESC_EVENT_DTMF_POUND, the rest of the fields are irrelevant.
      descType == MGT_DESC_EVENT_ID     =>s  eventId
      descType == MGT_DESC_EVENT_RANGE  =>s eventRange
      descType == MGT_DESC_EVENT_KNOWN  =>s eventKnown
*/
typedef struct mgEventDesc
{
   TknU8 descType;
   union
   {
      TknStrOSXL eventId;
      TknStrOSXL eventRange;
      TknU16      eventKnown; /* [TEL]: Changed to TknU16 from TknU8 */
   } t;
} MgEventDesc;


/**** Event Name ****/
/*
    The val of pkgPres determines if pkgName field is present or absent
       pkgPres == MGT_MGCP_EVNT_NAME_PKG_PRES  =>  pkgName has significance
       pkgPres == MGT_MGCP_EVNT_NAME_PKG_ABST  =>  pkgName should be skipped
*/
typedef struct mgEvntName
{
   TknPres     pres;
   TknU8       pkgPres;   /* this indicates whether PkgName is present(0) or absent(1) */
   MgPkgName   pkgName;
   MgEventDesc eventDesc;
   TknStr32    connId;
} MgEvntName;


/**** Signal Request ****/
typedef struct mgSignalRqst
{
   TknPres             pres;
   MgEvntName          evntName;
   MgEvntParamTypeSet  evntParamSet;   
} MgSignalRqst;


/**** Signal Request Set ****/
typedef struct mgSignalRqstSet
{
   TknU16              numComp;
   MgSignalRqst        **signalRqst;
} MgSignalRqstSet;


/**** Digit Map ****/
#ifdef GCP_MGCP_PARSE_DIG_MAP
typedef TknStrOSXL MgDgtMap;
#else
typedef struct mgDgtMap
{
   TknU16     numComp;
   TknStrOSXL **dgtStr;
} MgDgtMap;
#endif



typedef struct mgRqstdActn  MgRqstdActn;

/**** Requested Action Set ****/
typedef struct mgRqstdActnSet
{
  TknU16       numComp;
  MgRqstdActn  **rqstdActn;
} MgRqstdActnSet;

#ifdef GCP_2705BIS


typedef struct mgRqstdEvntSeq
{
  TknPres         pres;
  MgEvntName      evntName;
  MgRqstdActnSet  rqstdActnSet;
  MgEvntParamTypeSet  evntParamSet;
} MgRqstdEvntSeq;
#endif

typedef struct mgRqstdEvnt MgRqstdEvnt;

/**** Requested Event Set ****/
#ifdef GCP_2705BIS
typedef struct mgRqstdEvntSet
{
   TknU16        numComp;
   MgRqstdEvntSeq   **rqstdEvnt;
} MgRqstdEvntSet;
#else
typedef struct mgRqstdEvntSet
{
   TknU16        numComp;
   MgRqstdEvnt   **rqstdEvnt;
} MgRqstdEvntSet;
#endif


/**** Embedded Type ****/
typedef struct mgRqstEmbedType
{
   TknU8            embdRqstType;
   union 
   {
      MgRqstdEvntSet      rqstdEvntSet;
      MgSignalRqstSet     signalRqstSet;
      MgDgtMap            dgtMap;
   } t;
} MgRqstEmbedType;


/**** Embedded Action ****/
typedef struct mgEmbedActn
{
   TknU16              numComp;
   MgRqstEmbedType     **rqstdEmbed;
} MgEmbedActn;

typedef struct mgRqstEmbedMDCXMode
{
   TknPres             pres;
   TknU8               connMode;
   TknStr32            connId;
} MgRqstEmbedMDCXMode;

typedef struct mgEmbedMDCX
{
   TknU16              numComp;
   MgRqstEmbedMDCXMode **modes;
} MgEmbedMDCX;

/**** Requested Action ****/
typedef struct mgAction
{
     TknU8            knownAction;
     TknStrOSXL       unknownAction;
} MgAction;

typedef struct mgPkgXActn               /* Extension Action */
{
   MgPkgName           pkgName;
   MgAction            action;
   MgEvntParamTypeSet  actnparms;       /* optional */
} MgPkgXActn;          /* sequence */

#ifdef GCP_2705BIS

/*
     actionType == MGT_RQSTD_ACTN_EXTN  =>s  Xactn is significant
*/
struct mgRqstdActn
{
   TknU8         actionType;
   union
   {
      MgEmbedActn   embedActn;
      MgEmbedMDCX   mdcx;
      MgPkgXActn    Xactn;
   } u;
};
#else
struct mgRqstdActn
{
   TknU8         actionType;
   union
   {
      MgEmbedActn   embedActn;
      MgEmbedMDCX   mdcx;
   } u;
};
#endif



/**** Requested Event Set ****/
struct mgRqstdEvnt
{
  TknPres         pres;
  MgEvntName      evntName;
  MgRqstdActnSet  rqstdActnSet;
};

/**** Observed Event Set ****/
typedef MgSignalRqstSet MgObsEvntSet;

/**** Connection Parameters ****/
#ifdef GCP_2705BIS

/*
    knownCpName == MGT_MGCP_CONN_PAR_C_P_NAME_UNKNOWN_EXTN   =>s
        that cpName is significant
*/
typedef struct mgPkgCPName
{
   TknU8         knownCpName;
   TknStrOSXL    cpName;
} MgPkgCPName;

typedef struct mgPkgCPXNm
{
   MgPkgName     pkgName;
   MgPkgCPName   cpName;
} MgPkgCPXNm;

/*
    vndrOrPkg == MGT_MGCP_CONN_PAR_VNDR_EXTN  =>s  vndrXName
    vndrOrPkg == MGT_MGCP_CONN_PAR_PKG_EXTN   =>s  pkgXName
*/
typedef struct mgCPName
{
   TknPkgId         vndrOrPkg;
   union
   {
     TknStrOSXL     vndrXName;
     MgPkgCPXNm     pkgXName;
   } t;
} MgCPName;

typedef struct mgStdExtn
{
   TknPres       pres;
   MgCPName      paramName;
   TknStrOSXL    paramVal;
} MgConnParExtn;
#endif

#ifdef GCP_2705BIS
typedef struct mgConnParam
{
   TknU8            paramType;
   union
   {
      TknU32           octetsSent;
      TknU32           pktsSent;
      TknU32           pktsRcvd;
      TknU32           octetsRcvd;
      TknU32           pktsLost;
      TknU32           jitter;
      TknU32           avgLatency;
      MgConnParExtn        nonStdExtn;
   } t;
} MgConnParam;
#else
typedef struct mgConnParam
{
   TknU8            paramType;
   union
   {
      TknU32           octetsSent;
      TknU32           pktsSent;
      TknU32           pktsRcvd;
      TknU32           octetsRcvd;
      TknU32           pktsLost;
      TknU32           jitter;
      TknU32           avgLatency;
      MgNonStdExtn     nonStdExtn;
   } t;
} MgConnParam;
#endif


/**** Connection Parameter  Set ****/
typedef struct mgConnParamSet
{
   TknU16       numComp;
   MgConnParam  **connParam;
} MgConnParamSet;



/**** Reason  ****/
#ifdef GCP_2705BIS
typedef struct mgReasonCode
{
   TknPres    pres;
   TknU16     code;
   MgPkgName    pkgName;            /* optional - only for 8xx */
   TknStrOSXL param;
} MgReasonCode;
#else
typedef struct mgReasonCode
{
   TknPres    pres;
   TknU16     code;
   TknStrOSXL param;
} MgReasonCode;
#endif


#ifdef GCP_2705BIS

/*
    codeType == MGT_INFO_CODE_EXTN  =>s  xParam is significant
*/
typedef struct infoCode
{
   TknU8               codeType;      /* for std codes */
   MgMgcpExtnParam     xParam;        /* for extension codes */
} InfoCode;
#endif

/**** Requested infomation  ****/
#ifdef GCP_2705BIS
typedef struct mgRqstdInfo
{
   TknU16  numComp;
   InfoCode    **infoCode; /* MG_INFO_CODE_B,MG_INFO_CODE_X*/
} MgRqstdInfo;
#else
typedef struct mgRqstdInfo
{
   TknU16  numComp;
   TknU8   **infoCode; /* MG_INFO_CODE_B,MG_INFO_CODE_X*/
} MgRqstdInfo;
#endif



/****  Quarantine handling   ****/
typedef struct mgQrntHandling
{
   TknU16     numComp;
   TknU8      **ctrl;
} MgQrntHandling;

/****     ****/
typedef struct MgDetectEvent
{
  TknU16       numComp;
  MgEvntName   **evnt;
} MgDetectEvent;


#ifdef GCP_2705BIS

/*
   stdOrXten == MGT_PARAM_RSTRT_EXTN_METHOD  =>s  xRstrtMethod is significant
   stdOrXten == MGT_PARAM_RSTRT_CANCL_GRCFUL is the new standard rstrt method
*/
typedef struct mgRsrtMethod
{
   TknU8                     stdOrXten;
   MgMgcpPkgSpcExtnParam  xRstrtMethod;
} MgRsrtMethod;
#endif


/****  MGCP Parameter  ****/
#ifdef GCP_2705BIS
typedef struct mgMgcpParamExtn
{
   MgMgcpExtnParam    extnParam;
   TknStrOSXL         extnVal;
} MgMgcpParamExtn;
#endif

#ifdef GCP_2705BIS
typedef struct mgMgcpPkgNmVer
{
   MgPkgName    pkgName;        /* the package name */
   TknStrOSXL   pkgVer;            /* the package version */
} MgMgcpPkgNmVer;

typedef struct mgMgcpPkgList
{
   TknU16            numComp;
   MgMgcpPkgNmVer    **nameVer;
} MgMgcpPkgList;
#endif

#ifdef GCP_2705BIS

/*
    paramType == MGT_PARAM_PACKAGE_LIST  => pkgList  (new parameter)
*/
typedef struct mgMgcpParam
{
   TknU8 paramType;
   union
   {
      MgRspAckSet     rspAckSet;
      MgBearerInfo    bearerInfo;
      MgCallId        callId;
      MgConnIdSet     connIdSet;
      MgNtfiedEnt     ntfiedEnt;
      MgRqstId        rqstId;
      MgLclConnOptSet lclConnOptSet;
      MgConnMode      connMode;
      MgRqstdEvntSet  rqstdEvntSet;
      MgSignalRqstSet sigRqstSet;
      MgDgtMap        dgtMap;
      MgObsEvntSet    obsEvntSet;
      MgConnParamSet  connParamSet;
      MgReasonCode    reasonCode;
      MgEPName        specificEpId;
      MgEPName        scndEpId;
      MgConnIdSet     scndConnIdSet;
      MgRqstdInfo     rqstdInfo;
      MgQrntHandling  qrntHandling;
      MgRsrtMethod    rstrtMethod;
      TknU32          rstrtDelay;
      MgSignalRqstSet detectEvnt;
      MgLclConnOptSet capabilitySet;
      MgSignalRqstSet eventStates;
      MgMgcpParamExtn   nonStdExtn;
      TknU32          maxEndPtIds;  /* Max endpoint IDs - NCS and TGCP */
      TknU32          numEndPtIds;  /* Num endpoint IDs - NCS and TGCP */
      TknU32          resourceId;   /* Resource ID - NCS */
      MgMgcpVerSet    versionsSupp; /* Versions supported - NCS and TGCP */
      MgMgcpPkgList   pkgList;
      TknU32          maxDatGram;   /* Max MGCP DataGram */
   }t;
} MgMgcpParam;
#else
typedef struct mgMgcpParam
{
   TknU8 paramType;
   union
   {
      MgRspAckSet     rspAckSet;
      MgBearerInfo    bearerInfo;
      MgCallId        callId;
      MgConnIdSet     connIdSet;
      MgNtfiedEnt     ntfiedEnt;
      MgRqstId        rqstId;
      MgLclConnOptSet lclConnOptSet;
      MgConnMode      connMode;
      MgRqstdEvntSet  rqstdEvntSet;
      MgSignalRqstSet sigRqstSet;
      MgDgtMap        dgtMap;
      MgObsEvntSet    obsEvntSet;
      MgConnParamSet  connParamSet;
      MgReasonCode    reasonCode;
      MgEPName        specificEpId;
      MgEPName        scndEpId;
      MgConnIdSet     scndConnIdSet;
      MgRqstdInfo     rqstdInfo;
      MgQrntHandling  qrntHandling;
      TknU8           rstrtMethod;
      TknU32          rstrtDelay;
      MgDetectEvent   detectEvnt;
      MgLclConnOptSet capabilitySet;
      MgSignalRqstSet eventStates;
      MgNonStdExtn    nonStdExtn;
      TknU32          maxEndPtIds;  /* Max endpoint IDs - NCS and TGCP */
      TknU32          numEndPtIds;  /* Num endpoint IDs - NCS and TGCP */
      TknU32          resourceId;   /* Resource ID - NCS */
      MgMgcpVerSet    versionsSupp; /* Versions supported - NCS and TGCP */
   }t;
} MgMgcpParam;
#endif


/****  MGCP Parameter Set  ****/
typedef struct mgMgcpParamSet
{
   TknU16       numParam;     /* Number of parameters */
   MgMgcpParam  **param;      /* Parameter Set */
}MgMgcpParamSet;




typedef struct mgMgcpCmd
{
   TknPres        pres;
   MgMgcpCmdLine  cmdLine;     /* MGCP command line */
   MgMgcpParamSet params;      /* Zero or more parameters */
   TknBuf         sdpStr;      /* Opaque SDP string */
   CmSdpInfoSet   sdpInfo;     /* SDP information in MGCP message */
} MgMgcpCmd;


/****  MGCP Non Standard Command ****/
typedef struct mgMsgNonStd
{
   TknPres        pres;
   TknStr8        cmdName;
   MgMgcpCmd      cmd;
} MgMsgNonStd;


/****  MGCP Response  ****/
#ifdef GCP_2705BIS
typedef struct mgMgcpSdpInfo
{
   TknBuf         sdpStr;     /* Opaque SDP string */
   CmSdpInfoSet   sdpInfo;    /* for local connection descriptor */
} MgMgcpSdpInfo;

typedef struct mgMgcpSdpInfoSet
{
   TknU16         numComp;
   MgMgcpSdpInfo  **set;
} MgMgcpSdpInfoSet;

typedef struct mgMgcpRsp
{
   TknPres        pres;
   TknU32         rspCode;    /* response code */
   TknU32         trId;       /* transaction id */
   MgPkgName      pkgName;    /* package Name only for 8xx */
   TknStrOSXL     rspStr;     /* Response string */
   MgMgcpParamSet params;     /* Some responses return parameters like epId*/
   MgMgcpSdpInfoSet   sdpInfo;
} MgMgcpRsp;
#else
typedef struct mgMgcpRsp
{
   TknPres        pres;
   TknU32         rspCode;    /* response code */
   TknU32         trId;       /* transaction id */
   TknStrOSXL     rspStr;     /* Response string */
   MgMgcpParamSet params;     /* Some responses return parameters like epId*/
   TknBuf         sdpStr;     /* Opaque SDP string */
   CmSdpInfoSet   sdpInfo;    /* for local connection descriptor */
} MgMgcpRsp;
#endif





#ifdef GCP_PKG_MGCP_BASE

/****  MGCP Message ****/
typedef struct mgMgcpMsg
{
   CmMemListCp memCp;          /* Memory Control Point */
   TknU8       msgType;        /* message type */
   union
   {
      MgMgcpCmd    epcfCmd;    /* Endpoint configuration command */
      MgMgcpCmd    crcxCmd;    /* Create connection command */
      MgMgcpCmd    mdcxCmd;    /* Modify connection command */
      MgMgcpCmd    dlcxCmd;    /* Delete connection command */
      MgMgcpCmd    rqntCmd;    /* Request to notify command */
      MgMgcpCmd    ntfyCmd;    /* Notify command */
      MgMgcpCmd    auepCmd;    /* Audit endpoint command */
      MgMgcpCmd    aucxCmd;    /* Audit connection command */
      MgMgcpCmd    rsipCmd;    /* restart in progress command */
      MgMsgNonStd  nonStdCmd;  /* extension command */
      MgMgcpRsp    mgcpRsp;    /* mgcp response */
      MgMgcpCmd    mesgCmd;    /* MESG command */
   } t;
   MgLclErr    mgLclErr;       /* local errors */
   TknU8       dupInfo;        /* Duplicate Message Information */
#if (defined(ZG_DFTHA) || defined(DG))
   CmFthaRsetId    rsetId;
#endif
}MgMgcpMsg;


#else  /* GCP_PKG_MGCP_BASE */

/****  MGCP Message ****/
typedef struct mgMgcpMsg
{
   CmMemListCp memCp;          /* Memory Control Point */
   TknU8       msgType;        /* message type */
   union
   {
      MgMgcpCmd    epcfCmd;    /* Endpoint configuration command */
      MgMgcpCmd    crcxCmd;    /* Create connection command */
      MgMgcpCmd    mdcxCmd;    /* Modify connection command */
      MgMgcpCmd    dlcxCmd;    /* Delete connection command */
      MgMgcpCmd    rqntCmd;    /* Request to notify command */
      MgMgcpCmd    ntfyCmd;    /* Notify command */
      MgMgcpCmd    auepCmd;    /* Audit endpoint command */
      MgMgcpCmd    aucxCmd;    /* Audit connection command */
      MgMgcpCmd    rsipCmd;    /* restart in progress command */
      MgMsgNonStd  nonStdCmd;  /* extension command */
      MgMgcpRsp    mgcpRsp;    /* mgcp response */
   } t;
   MgLclErr    mgLclErr;       /* local errors */
   TknU8       dupInfo;        /* Duplicate Message Information */
#if (defined(ZG_DFTHA) || defined(DG))
   CmFthaRsetId    rsetId;
#endif
}MgMgcpMsg;

#endif /* GCP_PKG_MGCP_BASE */




/****  MGCP Transaction ****/

typedef struct mgMgcpTxn
{
   CmMemListCp memCp;                 /* memCp for top level */
   MgPeerInfo  mgLclInfo;             /* used to pass local handles */
   U16         numMsg;                /* number of msg(cmd/rsp) */
   MgMgcpMsg   *mgcpMsg[MGT_MAX_MSG]; /* message */
} MgMgcpTxn;







#endif /* GCP_MGCP */


/***********************************************************************
                      MEGACO Specific Structures
 ***********************************************************************/

#ifdef GCP_MGCO

/* Megaco version in header and service change messages */
typedef TknU8 MgMgcoVersion;

typedef TknU32 MgMgcoSecParmIndex;  /* Security param index */
typedef TknU32 MgMgcoSequenceNum;   /* Sequence number */
typedef TknStrOSXL MgMgcoAuthData;  /* Authorization data */

/* MTP Address */
typedef TknStr8 MgMgcoMtpAddr;

/* Event buffer control */
/* Possible values: FALSE for Off, TRUE for LockStep */
typedef TknU8 MgMgcoEvtBufCtl;

/* Service state */
/* Possible values: 
 * MGT_SVCST_TEST for test, 
 * MGT_SVCST_OUTOFSVC for out-of-service or
 * MGT_SVCST_INSVC for in-service
 */
typedef TknU8 MgMgcoSvcState;





/* Audit item */
/* Possible values:
 * MGT_MEDIADESC for media, MGT_MODEMDESC for modem, MGT_MUXDESC for mux,
 * MGT_REQEVTDESC for event, MGT_EVBUFDESC for event-buffer,
 * MGT_SIGNALSDESC for signals, MGT_DIGMAPDESC for digitmap,
 * MGT_OBSEVTDESC for observed-events, MGT_STATSDESC for statistics,
 * MGT_PKGSDESC for  packages,
 * MGT_INDAUD_TERMAUDDESC for indAudterminationAudit (MEGACO V2 only)
 */



/* Stream ID */
typedef TknU16 MgMgcoStreamId;

/* Request ID */
typedef struct mgMgcoRequestId
{
   TknU8         type;    /* MGT_REQID_ALL or MGT_REQID_OTHER */
   TknU32        id;      /* if type == MGT_REQID_OTHER */
} MgMgcoRequestId;
   

/* Transaction ID */
typedef TknU32 MgMgcoTransId;

/* Object ID */
typedef TknStrOSXL MgMgcoObjId;       


/* Service change reason */
typedef TknStrOSXL MgMgcoSvcChgReason;


/**** Context Id ****/
/* Possible values for type:
 * MGT_CXTID_NULL for "-", MGT_CXTID_ALL for "*", MGT_CXTID_CHOOSE for "$",
 * MGT_CXTID_OTHER for other. Val is ignored for -, * and $.
 */
typedef struct mgMgcoContextId
{
   TknU8          type;    /* "*", "-", "$" or other */
   TknU32         val;     /* if other */
} MgMgcoContextId;

/**** Path Name ****/
typedef struct mgMgcoPathName
{
   TknPres     pres;
   TknStrOSXL  lcl;        /* local name */
   TknStrOSXL  dom;        /* path domain name */
} MgMgcoPathName;

typedef MgMgcoPathName MgMgcoDevName;

/**** Termination ID ****/
/* Possible values for type:
 * MGT_TERMID_ROOT for "ROOT", MGT_TERMID_ALL for "*", MGT_TERMID_CHOOSE for
 * "$", MGT_TERMID_OTHER for other.
 * Name is ignored for ROOT, * or $.
 */
/* 001.main_12: Added wild card support for GCP_ASN */
#ifdef GCP_ASN
typedef TknStr4       MgMgcoWildcardField;

typedef struct mgMgcoWildcard
{
   TknU16      num;
   MgMgcoWildcardField  **wildcard;
}MgMgcoWildcard;
#endif

typedef struct mgMgcoTermId
{
   TknU8           type;       /* "ROOT", "*", "$" or other */
   MgMgcoPathName  name;       /* If other */
/* 001.main_12: Added wild card support for GCP_ASN */
#ifdef GCP_ASN
   MgMgcoWildcard  wildcard;
#endif
} MgMgcoTermId;



/**** Megaco Termination Id List  ****/
typedef struct mgMgcoTermIdLst
{
   TknU16            num;               /* Number of terminations */
   MgMgcoTermId      **terms;           /* list of terminations */
} MgMgcoTermIdLst;




/**** Time Stamp ****/
typedef struct mgMgcoTimeStamp
{
   TknPres           pres;               /* Present? */
   TknStr8           date;               /* Date yyyymmdd */
   TknStr8           time;               /* Time hhmmssss */
} MgMgcoTimeStamp;

/**** Package ****/
/* pkgType can be MGT_PKG_UNKNOWN, MGT_PKG_KNOWN or * MGT_PKG_ALL */
/* if(valType.val == value)
   call unpkval function
   else if(valType.val == string)
   call unpkstr function

pkgType.val tells unknown/known/all.

|-----------------------|-------------|---------------|--------------|-------|
|valType.val/pkgType.val|Value/known|String/unknown | Value/unknown|NA/all |
|-----------------------|-------------|---------------|--------------|-------|
|ABNF                   |   X (if)    |  X (else)     |  NA          | NA    |
|-----------------------|-------------|---------------|--------------|-------|
|ASN                    |   X (if)    |  NA         |  X (if)      | NA    |
|-----------------------|-------------|---------------|--------------|-------|
*/

typedef struct mgMgcoPkg
{
   TknU8                pkgType;         /* Unknown (0)/Known (1)/All (2) */
   TknU8                valType;         /* string or value */
   union
   {
      TknStrOSXL     str;                /* Uninterpreted string if not */
      TknU16         val;                /* Value if known */
   } u;
} MgMgcoPkg;

/**** Name ****/
/* Type can be MGT_GEN_TYPE_UNKNOWN, MGT_GEN_TYPE_KNOWN or
 * MGT_GEN_TYPE_ALL. If it is MGT_GEN_TYPE_UNKNOWN, u.str conatins the name as
 * a string. If it is MGT_GEN_TYPE_KNOWN, u.val contains a #define corresponding
 * to the name. If it is MGT_GEN_TYPE_ALL (for "*"), u is ignored.
 */
typedef struct mgMgcoName
{
   TknU8                type;              /* string or value */
   union
   {
      TknStrOSXL     str;                /* Uninterpreted string if not */
      TknU16         val;                /* Value if known */
   } u;
} MgMgcoName;

/**** Package Information ****/
typedef struct mgMgcoPkgdName
{
   TknStrOSXL           pkgName;            /* Package name if unknown */
   MgMgcoName           name;               /* Property or Event name */
} MgMgcoPkgdName;

/**** Packages Item ****/
typedef struct mgMgcoPkgsItem
{
   TknPres              pres;               /* Present? */
   MgMgcoName           name;
   TknU16               ver;
} MgMgcoPkgsItem;



/* pkg is one of MGT_PKG_UNKNOWN, MGT_PKG_GENERIC, ..., MGT_PKG_NAS_ROOT from
 * mgt.h. name.pkgName is valid only for MGT_PKG_UNKNOWN (unknown package)
 * and ignored for the rest of (known) packages.
 */
typedef struct mgMgcoSigName
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
} MgMgcoSigName;

typedef struct mgMgcoSigLst
{
   TknU16               id;         /* Signal list ID */
   TknU16               numSigs;
   MgMgcoSigName        **sigs;
} MgMgcoSigLst;

/**** IndAud Statistics Descriptor *****/
typedef MgMgcoSigName MgMgcoIndAudStatsDesc;

/*
********* Additions for syntactical packages of Annex M.1 ***********
********* START
*/

#if ( defined(GCP_PKG_MGCO_ADVAUSRVRBASE) || \
      defined(GCP_PKG_MGCO_AASDIGCOLLECT) || \
      defined(GCP_PKG_MGCO_AASRECODING)   || \
      defined(GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) )

typedef struct mgMgcoFileUrl
{
     TknStrOSXL          host;
     TknStrOSXL          fpath;
} MgMgcoFileUrl;

typedef struct mgMgcoHostPort
{
     TknStrOSXL          host;
     TknU32              port;
} MgMgcoHostPort;

typedef struct mgMgcoUsrPw
{
     TknPres             pres;    /* user and password seq is optional */
     TknStrOSXL          user;
     TknStrOSXL          pswd;    /* optional */
} MgMgcoUsrPw;

typedef struct mgMgcoLogin
{
    MgMgcoUsrPw          usrPw;   /* user and password seq is optional */
    MgMgcoHostPort       hp;
} MgMgcoLogin;

typedef struct mgMgcoPathType
{
     TknPres             pres;    /* fpath type seq is optional */
     TknStrOSXL          fpath;
     TknU8               ftpType; /* optional */
} MgMgcoPathType;

typedef struct mgMgcoFtpUrl
{
     MgMgcoLogin         login;
     MgMgcoPathType      patTyp;  /* fpath type seq is optional */
} MgMgcoFtpUrl;

typedef struct mgMgcoPathSearch
{
     TknPres             pres;
     TknStrOSXL          hpath;
     TknStrOSXL          search;  /* optional */
} MgMgcoPathSearch;

typedef struct mgMgcoHttpUrl
{
    MgMgcoHostPort       hp;
    MgMgcoPathSearch     ps;      /* hpath search seq is optional */
} MgMgcoHttpUrl;

typedef struct mgMgcoProvSegSpec
{
   TknU8             type;        /* identifies provSegSpec type */
   union
   {
       TknStrOSXL          simple;
       MgMgcoFileUrl       file;
       MgMgcoFtpUrl        ftp;
       MgMgcoHttpUrl       http;
   } u;
} MgMgcoProvSegSpec;

typedef struct mgMgcoTodSpec
{
     TknU8           subType;       /* 12- or 24- hour format : optional */
     TknU16          time;          /* the 4 DIGITS representing time */
} MgMgcoTodSpec;

typedef struct mgMgcoDateSpec
{
     TknU8           dateOrder;     /* "mdy" or "dmy" : optional */
     TknU32          date;          /* 8 DIGITS representing date */
} MgMgcoDateSpec;

typedef struct mgMgcoMoneySpec
{
     TknStr8         curType;      /* currency type eg USD : optional */
     TknS32          val;          /* value of the currency : signed */
} MgMgcoMoneySpec;

typedef struct mgMgcoIntSpec
{
     TknU8           type;         /* cardinal or ordinal */
     TknS32          val;
} MgMgcoIntSpec;

typedef struct mgMgcoVvarSpec
{
   TknU8             type;          /* identifies vvarSpec type */
   union
   {
      MgMgcoTodSpec        tod;     /* todSpec */
      TknU8                dow;     /* dowSpec */
      MgMgcoDateSpec       date;    /* dateSpec */
      TknU8                month;   /* monthSpec */
      TknU32               dur;     /* durSpec */
      TknStrOSXL           dig;     /* digSpec */
      TknStrOSXL           chr;     /* charSpec */
      MgMgcoMoneySpec      money;   /* monthSpec */
      MgMgcoIntSpec        integer; /* intSpec */
      TknU16               hush;    /* hushSpec */
      TknStrOSXL           phrase;  /* phraseSpec */
   } u;
} MgMgcoVvarSpec;

typedef struct mgMgcoSelType
{
   TknU8             type;          /* identifies selType type */
   TknStrOSXL        other;         /* NAME :- only for other sel type */
} MgMgcoSelType;


typedef struct mgMgcoSelSpecLst
{
    MgMgcoSelType          type;
    TknStrOSXL             val;
} MgMgcoSelSpecLst;

typedef struct mgMgcoSelList
{
    TknU16                 num;
    MgMgcoSelSpecLst       **selSpec;
} MgMgcoSelList;

typedef struct mgMgcoVarSegSpec
{
    MgMgcoVvarSpec         vvarSpec;
    MgMgcoSelList          selList;   /* selList - optional */
} MgMgcoVarSegSpec;

typedef struct mgMgcoSpec
{
   TknU8             type;          /* identifies spec type */
   union
   {
      MgMgcoProvSegSpec    provSs;  /* provisioned segment id */
      MgMgcoVarSegSpec     staSs;   /* standalone variable */
   } u;
} MgMgcoSpec;

typedef struct mgMgcoSegSpec
{
   TknU8             keyword;       /* identifies "sid" or "var" */
   MgMgcoSpec        spec;
} MgMgcoSegSpec;

typedef struct mgMgcoAnncSpec
{
   TknU16            num;
   MgMgcoSegSpec     **segSpec;
} MgMgcoAnncSpec;

#endif

/*
********* END
********* Additions for syntactical packages of Annex M.1 ***********
*/


/* Type can be one of MGT_VALTYPE_ENUM..MGT_VALTYPE_TERMIDLST from
 * mgt.h, and the corresponding u field is valid.
 */
typedef struct mgMgcoValue
{
   TknU8                type;       /* format of the value */
   union
   {
      /* mgt_x_003.main_12: Modified the enume to U32 under GCP_ENUM_U32 flag */
#ifdef GCP_ENUM_U32
      TknU32            enume;      /* enumerated */
#else
      TknU8             enume;      /* enumerated */
#endif
#ifdef GCP_ASN
      /* mgt_x_003.main_12: boolean field is added in MgMgcoValue union */
      TknU8             boole;      /* enumerated */
#endif
      TknU32            decInt;     /* decimal integer */
      TknU32            hexInt;     /* hex integer */
      TknStrOSXL        osxl;       /* octet string - any length */
      TknBuf            mBuf;       /* tokenized message buffer */
      MgMgcoSigName     sigName;    /* special - signal name */
      MgMgcoSigLst      sigLst;     /* special - signal list (ID + names) */
      MgMgcoTermId      termId;     /* special - termination ID (for NAS) */
      MgMgcoTermIdLst   termIdLst;  /* special - termination ID list */
      TknS32            decSint;     /* decimal signed integer */
      TknS32            hexSint;     /* hex signed integer */
#if ( defined(GCP_PKG_MGCO_ADVAUSRVRBASE) || \
      defined(GCP_PKG_MGCO_AASDIGCOLLECT) || \
      defined(GCP_PKG_MGCO_AASRECODING)   || \
      defined(GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) )
      MgMgcoAnncSpec       anSpec;     /* announcementSpec for Annex M.1 syntax packages */
      MgMgcoProvSegSpec    prSpec;     /* provSegSpec for Annex M.1 syntax packages */
#endif
   } u;
} MgMgcoValue;

/**** Authentication Header ****/
typedef struct mgMgcoAuthHdr
{
   TknPres              pres;               /* AH present? */
   MgMgcoSecParmIndex   spi;                /* Security param index */
   MgMgcoSequenceNum    sn;                 /* Sequence number */
   MgMgcoAuthData       aData;              /* Authorization data */
} MgMgcoAuthHdr;


/**** IP Address and Port ****/
typedef struct mgMgcoDomAddrPort
{
   TknPres              pres;               /* Domain address present? */
   TknU8                type;               /* IPv4 or IPv6 */
   union    
   {
      TknStrOSXL        ipv6;               /* IPv6 address in input format */
      TknStrOSXL        ipv4;               /* IPv4 address */
   } u;
   TknU16               port;               /* Port number (opt) */
} MgMgcoDomAddrPort;



/**** Domain Name and Port ****/
typedef struct mgMgcoDomNamePort
{
   TknPres              pres;               /* Domain name present? */
   TknStrOSXL           name;               /* Domain name */
   TknU16               port;               /* Port number (opt) */
} MgMgcoDomNamePort;



/**** Megaco MID Structure ****/
/* Type can be one of MGT_MID_DEVICE..MGT_MID_PORT from mgt.h. */
typedef struct mgMgcoMid 
{
   TknU8                type;               /* MID type */
   union
   {
      MgMgcoDomAddrPort dAddrPort;          /* Domain address incl port */
      MgMgcoDomNamePort dNamePort;          /* Domain name incl port */
      MgMgcoMtpAddr     mtpAddr;            /* MTP address */
      MgMgcoDevName     dev;                /* Pathname of the device */
      TknU16            port;               /* Not for MID, for svcChgAddr */
   } u;
} MgMgcoMid;

/* Service change address */
typedef MgMgcoMid MgMgcoSvcChgAddr;


/**** Error Descriptor ****/
typedef struct mgMgcoErrDesc
{
   TknPres              pres;               /* Present? */
   TknU16               code;               /* Error code */
   TknStrOSXL           text;               /* Error text (opt) */
} MgMgcoErrDesc;

/**** Topology Descriptor ****/
typedef struct mgMgcoTopoDesc
{
   TknPres              pres;                  /* Present? */
   MgMgcoTermId         from;                  /* Termination A */
   MgMgcoTermId         to;                    /* Termination B */
   TknU8                dir;                   /* Topology direction */
#ifdef MGT_MGCO_V2
   MgMgcoStreamId       streamId;              
#if ((defined(GCP_ASN)) && (defined(GCP_VER_2_1)))
   TknU8                dirExt;               /* Toplogy direction Extension*/
#endif /* GCP_ASN && GCP_VER_2_1 */
#endif /* MGT_MGCO_V2 */
} MgMgcoTopoDesc;


/**** Topology Descriptor List****/
typedef struct mgMgcoTopoDescLst
{
   TknU16               num;                  /* Number of descriptors */
   MgMgcoTopoDesc       **descs;              /* Topology descriptors */
} MgMgcoTopoDescLst;

#ifdef GCP_VER_2_1   
typedef struct mgMgcoContextLst 
{
   TknU16            num;                  /* present token */
   MgMgcoContextId   **cxtId;              /* Context ID */
} MgMgcoContextLst;
#endif /*  GCP_VER_2_1 */

/**** Value list in parmValue ****/
typedef struct mgMgcoValLst
{
   TknU16               num;                 /* Number of values */
   MgMgcoValue          **vals;              /* Values */
} MgMgcoValLst;

/**** Value Range in parmValue ****/
typedef struct mgMgcoValRng
{
   TknPres              pres;
   MgMgcoValue          low;
   MgMgcoValue          up;
} MgMgcoValRng;

/**** Parameter Values****/
/* Type can be one of MGT_VALUE_EQUAL..MGT_VALUE_RANGE from mgt.h. */
typedef struct mgMgcoParmValue
{
   TknU8                type;                /* ==/!=/</>/range/and/or */
   union
   {
      MgMgcoValue          eq;               /* = value */
      MgMgcoValue          gt;               /* > value */
      MgMgcoValue          lt;               /* < value */
      MgMgcoValue          ne;               /* != value */
      MgMgcoValLst         vAnd;              /* AND of a list of values */
      MgMgcoValLst         vOr;               /* OR of a list of values */
      MgMgcoValRng         rng;              /* range between 2 values */
   } u;
} MgMgcoParmValue;

/**** Property Paramater ****/
/* pkg is one of MGT_PKG_UNKNOWN, MGT_PKG_GENERIC, ..., MGT_PKG_NAS_ROOT from
 * mgt.h. name.pkgName is valid only for MGT_PKG_UNKNOWN (unknown package)
 * and ignored for the rest of (known) packages.
 */
typedef struct mgMgcoPropParm
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
   MgMgcoParmValue      val;                 /* parameter value */
} MgMgcoPropParm;

/**** Megaco Context Property Audit ****/
typedef struct mgMgcoIndAudPropParm
{
   TknPres              pres;                /* Present? */
#ifdef GCP_VER_2_1
   MgMgcoPropParm       parm;                /* Property parameter (opt) */
#endif /*  GCP_VER_2_1 */
   MgMgcoSigName        pkgName;
} MgMgcoIndAudPropParm;


/**** Property Paramater List****/
typedef struct mgMgcoPropParmLst
{
   TknU16               num;                 /* Number of property parms */
   MgMgcoPropParm       **parms;             /* Parameters */
} MgMgcoPropParmLst;

#ifdef GCP_VER_2_1   
typedef struct mgMgcoCntxtAttrDesc
{
   TknPres              pres;                /* Present? */
   MgMgcoContextLst     contextLst;       /* Context List */
   MgMgcoPropParmLst    contextProp;      /* Context Props seq of propParms */
} MgMgcoCntxtAttrDesc;
#endif /*  GCP_VER_2_1 */

/**** Context Properties ****/
typedef struct mgMgcoContextProps            /* Set */
{
   TknPres              pres;                /* Present? */
   TknU16               pri;                 /* Priority (opt) */
   TknPres              emerg;               /* Emergency? (opt) */
   MgMgcoTopoDescLst    tl;                  /* Topology descriptors (opt) */
#ifdef GCP_VER_2_1   
   TknU8                  iepsCallInd;      /* Ieps Call Indication */
   MgMgcoCntxtAttrDesc    contextattr;
#endif /*  GCP_VER_2_1 */
   TknPres              emergOff;           /* Emergency Off? (opt) */
} MgMgcoContextProps;

/**** Statistics Parameter ****/
typedef struct mgMgcoStatsPar
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
#ifdef GCP_VER_2_1   
   MgMgcoValLst         val;    /* Optional value */
#else
   MgMgcoValue          val;    /* Optional value */
#endif /* GCP_VER_2_1 */
} MgMgcoStatsPar;


/**** Statistics Descriptor ****/
typedef struct mgMgcoStatsDesc
{
   TknU16               num;
   MgMgcoStatsPar       **parms;
} MgMgcoStatsDesc;

#ifdef GCP_VER_2_1
typedef struct mgMgcoCntxtPropAud
{
   TknU16                  num;
   MgMgcoIndAudPropParm    **parms;
} MgMgcoCntxtPropAud;

typedef struct mgMgcoSelLogic
{
   TknU8       type;
   union
   {
      TknU8    AndAudit;
      TknU8    OrAudit;
   } u;
} MgMgcoSelLogic;
#endif /*  GCP_VER_2_1 */

/**** Megaco Context Audit ****/
/* mgt_x_003.main_12 : mgMgcoContextAudit sequence reshufled in correct manner */
typedef struct mgMgcoContextAudit            /* Set */
{
   TknPres              pres;                /* Present? */
   TknPres              pri;                 /* Priority (opt) */
   TknPres              emerg;               /* Emergency (opt) */
   TknPres              topo;                /* Topology (opt) */
#ifdef GCP_VER_2_1
   TknU8                   iepsCallInd;            /* Ieps Call Indication (opt) */
   MgMgcoCntxtPropAud   cntxtPropAud;           /* IndAudPropertyParm (opt) */
   TknU16               selPri;                 /* Priority (opt) */
   TknPres              selEmerg;               /* Emergency? (opt) */
   TknBool              selIepsVal;             /* Emergency? (opt) */
   MgMgcoSelLogic       selLogic;               /* Select Logic (opt) */
   MgMgcoIndAudPropParm    pkgName; 
#endif /*  GCP_VER_2_1 */
} MgMgcoContextAudit;

/* Type is one of MGT_LCLCTL_MODE..MGT_LCLCTL_PROPPARM from mgt.h.
 * For type == MGT_LCLCTL_MODE, u.mode can be one of
 * MGT_MODE_SENDONLY..MGT_MODE_LOOPBACK from mgt.h.
 * For type == MGT_LCLCTL_RESVAL or MGT_LCLCTL_RESGRP, u.resVal or
 * u.resGrp can be FALSE for off and TRUE for on.
 */
typedef struct mgMgcoLocalParm
{
   TknU8                type;                /* Stream/ResVal/ResGrp/Prop */
   union
   {
      TknU8             mode;                /* Stream mode */
      TknU8             resVal;              /* Reserve value? */
      TknU8             resGrp;              /* Reserve group? */
      MgMgcoPropParm    propParm;            /* Property parameter */
   } u;
} MgMgcoLocalParm;


typedef struct mgMgcoLclCtlDesc
{
   TknU16               num;                 /* Number of localParms */
   MgMgcoLocalParm      **parms;             /* list of local control parms */
} MgMgcoLclCtlDesc;

/**** List of Property Parameters ****/
typedef struct mgMgcoPropGrpLst
{
   TknU16               num;                 /* Number of property groups */
   MgMgcoPropParmLst    **grps;              /* Groups = lists of propParms */
} MgMgcoPropGrpLst;


/**** Local Descriptor ****/
/* If CM_SDP_OPAQUE is defined, sdpStr contains the SDP portion of the
 * message as a message buffer. If CM_SDP_OPAQUE is undefined, sdp 
 * contains the SDP portion of the message in the data structure
 * CmSdpInfoSet. 
 */

typedef struct mgMgcoLocalDesc
{
   TknPres           pres;                   /* Present? */
   TknBuf            sdpStr;                 /* Opaque SDP string */
   CmSdpInfoSet      sdp;                    /* SDP info set */
/* 001.main_12: Added Annex C support in GCP_ASN*/
#ifdef GCP_ASN
   MgMgcoPropGrpLst  annexCParmLst;              /* ANNEX C property parms */
#endif /* GCP_ASN */
} MgMgcoLocalDesc;


/**** Remote Descriptor ****/
typedef MgMgcoLocalDesc MgMgcoRemoteDesc;


/**** 001.main_7: Termination State Parameters ****/
typedef struct mgMgcoTermStateParm           /* choice */
{
   TknU8                type;                /* type */
   union
   {
      MgMgcoEvtBufCtl      evtBufCtl;           /* Event buffer control (opt) */
      MgMgcoSvcState       svcState;            /* Service state (opt) */
      MgMgcoPropParm       parm;                /* Property parameter (opt) */
   } u;
} MgMgcoTermStateParm;

typedef struct mgMgcoTermStateDesc
{
   TknU16               numComp;
   MgMgcoTermStateParm  **trmStPar;
} MgMgcoTermStateDesc;


/**** Stream Parameter ****/
typedef struct mgMgcoStreamParm           /* Set */
{
   TknPres           pres;                /* Present? */
   MgMgcoLclCtlDesc  locCtl;              /* Local control descriptor */
   MgMgcoLocalDesc   local;               /* Local descriptor */
   MgMgcoRemoteDesc  remote;              /* Remote descriptor */
#ifdef GCP_VER_2_1   
   MgMgcoStatsDesc   stats;
#endif /* GCP_VER_2_1 */
} MgMgcoStreamParm;


/**** Stream Descriptor ****/
typedef struct mgMgcoStreamDesc
{
   TknPres              pres;                /* Present? */
   MgMgcoStreamId       streamId;            /* Stream ID */
   MgMgcoStreamParm     sl;
} MgMgcoStreamDesc;



/**** Media Parameter ****/
/* Type can be one of MGT_MEDIAPAR_LOCCTL..MGT_MEDIAPAR_TERMST in mgt.h */
typedef struct mgMgcoMediaPar
{
   TknU8                type;
   union
   {
      MgMgcoLclCtlDesc  locCtl;            /* Local control descriptor */
      MgMgcoLocalDesc   local;             /* Local descriptor */
      MgMgcoRemoteDesc  remote;            /* Remote descriptor */
#ifdef GCP_VER_2_1   
      MgMgcoStatsDesc   stats;             /* Statistics Descriptor */
#endif /* GCP_VER_2_1 */
      MgMgcoTermStateDesc  tstate;         /* Termination state desc (opt) */
      MgMgcoStreamDesc     stream;         /* Stream descriptors (opt) */
   } u;
} MgMgcoMediaPar;



/**** Media Descriptor *****/
typedef struct mgMgcoMediaDesc
{
   TknU16               num;                 /* Number of descriptors */
   MgMgcoMediaPar       **parms;
} MgMgcoMediaDesc;


/* H.221 Non-standard extension for binary */
typedef struct mgMgcoH221NonStd
{
   TknPres                 pres;             /* Present? */
   TknU8                   t35cc1;           /* T.35 country code - 1 */ 
   TknU8                   t35cc2;           /* T.35 country code - 2 */ 
   TknU8                   t35ext;           /* T.35 extension */
   TknU16                  mfc;              /* Manufacturer's code */
} MgMgcoH221NonStd;



/**** Non Standard Id ****/
/* called "extension parameter" in text */
/* Type for ABNF will be either MGT_EXTNPARM_OPT or MGT_EXTNPARM_MAND */
typedef struct mgMgcoNonStdId 
{
   TknU8                   type;             /* Type of non-std */
   union
   {
      MgMgcoObjId             objId;         /* Object ID */
      MgMgcoH221NonStd        h221;          /* H.221 non-standard info */
      TknStr8                 extn;          /* Actual extension */
   } u;
} MgMgcoNonStdId;


/**** Modem Type ****/
/* Type can be MGT_MODEMTYPE_V32BIS..MGT_MODEMTYPE_SYNCHISDN from mgt.h,
 * in which case extnId is ignored, or MGT_EXTNPARM with a valid
 * extnId.
 */
typedef struct mgMgcoModemType
{
   TknU8                type;
   MgMgcoNonStdId       extnId;
} MgMgcoModemType;


/**** Modem Type List****/
typedef struct mgMgcoModemTypeLst
{
   TknU16               num;
   MgMgcoModemType      **modems;
} MgMgcoModemTypeLst;


/**** Non Standard Extension ****/
/* "extension"(text), "nonstdData"(binary) */
typedef struct mgMgcoNonStdExtn
{
   TknPres                    pres;           /* Present? */
   MgMgcoNonStdId             id;             /* Non-std identifier */
   MgMgcoParmValue            val;            /* Value */
} MgMgcoNonStdExtn;



/**** Modem Descriptor ****/
typedef struct mgMgcoModemDesc
{
   TknPres              pres;               /* Present? */
   MgMgcoModemTypeLst   mtl;
   MgMgcoPropParmLst    mpl;
   /* binary has nonstandard data here */
   MgMgcoNonStdExtn     extn;
} MgMgcoModemDesc;


/**** Mux Descriptor ****/
/* Type can be one of MGT_MUXTYPE_H221..MGT_MUXTYPE_V76 from mgt.h,
 * in which case "id" is ignored, or MGT_EXTNPARM with a valid "id" field.
 */
typedef struct mgMgcoMuxDesc
{
   TknPres              pres;                /* Present? */
   TknU8                type;                /* Mux type */
   MgMgcoNonStdId       id;                  /* (opt) nonstd - bin:"Extn"?? */
   MgMgcoTermIdLst      tl;                  /* Termination IDs */
} MgMgcoMuxDesc;


/**** Other Event structure ****/
typedef struct mgMgcoEvtOther
{
   MgMgcoName           name;                  /* Parameter name */
   MgMgcoParmValue      val;                   /* Parameter value */
} MgMgcoEvtOther;


/**** Other Signal structure ****/
typedef MgMgcoEvtOther MgMgcoSigOther;


/**** Notify Complete Structure ****/
/* Each entry in reasons array can be one of MGT_NTFYRES_TIMEOUT..
 * MGT_NTFYRES_OTHER from mgt.h.
 */
typedef struct mgMgcoNtfyCmpl
{
   TknU16               num;
   TknU8                **reasons;
} MgMgcoNtfyCmpl;


/**** Signal Parameter ****/
/* Type can be one of MGT_SIGPAR_OTHER..MGT_SIGPAR_KEEPACTIVE from mgt.h.
 * The union is ignored if type == MGT_SIGPAR_KEEPACTIVE.
 */
typedef struct mgMgcoSigPar
{
   TknU8                type;
   union
   {
      MgMgcoStreamId    streamId;         /* Signal Stream ID */
      TknU8             type;             /* On/Off/timeout/Brief */
      TknU16            dura;             /* Signal Duration */
      MgMgcoSigOther    other;            /* Other Signal */
      MgMgcoNtfyCmpl    nc;               /* Notify Completion - on/off */
      /* mgt_x_004.main_12: Added keepactive for ASN */
#ifdef GCP_ASN
      U8                ka;               /* Keepactive ture/false in case of
                                             GCP_ASN */
#endif /* GCP_ASN */
#ifdef GCP_VER_2_1
      TknU8             sigDir;           /* Signal Direction */
      MgMgcoRequestId   reqId;            /* Signal Request ID */
      TknU16            interSigDelay;    /* Inter Signal Delay */
#endif /* GCP_VER_2_1 */
   } u;
} MgMgcoSigPar;


/**** Signal Parameter List ****/
typedef struct mgMgcoSigParLst
{
   TknU16               num;
   MgMgcoSigPar         **parms;
} MgMgcoSigParLst;



/**** Signal Request  ****/
/* Package ID can be one of MGT_PKG_UNKNOWN..MGT_PKG_NAS_ROOT from mgt.h.
 * name.pkgName is ignored unless pkg is MGT_PKG_UNKNOWN.
 */
typedef struct mgMgcoSignalsReq
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
   MgMgcoSigParLst      pl;
} MgMgcoSignalsReq;

/**** Signal List Paramater List ****/
typedef struct mgMgcoSignalsReqLst
{
   TknU16               num;
   MgMgcoSignalsReq     **reqs;
} MgMgcoSignalsReqLst;


/**** Signal List ****/
typedef struct mgMgcoSignalsLst
{
   TknPres              pres;               /* Present? */
   TknU16               id;
   MgMgcoSignalsReqLst  pl;
} MgMgcoSignalsLst;


/**** Signals Parameters ****/
/* Type can be MGT_SIGSPAR_LST or MGT_SIGSPAR_REQ. */
typedef struct mgMgcoSignalsParm
{
   TknU8                type;
   union
   {
      MgMgcoSignalsReq  req;
      MgMgcoSignalsLst  lst;
   } u;
} MgMgcoSignalsParm;


/**** Signal Descriptor ****/
typedef struct mgMgcoSignalsDesc
{
   TknPres              pres; /* present? */
   TknU16               num;  /* number of signal requests or lists, maybe 0 */
   MgMgcoSignalsParm    **parms;
} MgMgcoSignalsDesc;

/**** Digit Map Range (DIGIT-DIGIT or digitMapLatter) ****/
/* low and up taken from MGT_DIGMAP_0..MGT_DIGMAP_Z in mgt.h. up may be
 * absent.
 */
typedef struct mgMgcoDigRng
{
   TknPres              pres;       /* Present? */
   TknU8                low;        /* must be present */
   TknU8                up;         /* Upper bound if range */
} MgMgcoDigRng;


/**** Digit Map Letter ****/
typedef struct mgMgcoDigMapLet      /* "digitLetter" */
{
   TknU16               num;
   MgMgcoDigRng         **mapLets;
} MgMgcoDigMapLet;


/**** Digit Map Range ****/
/* Type can be MGT_DIGMAP_X, in which case union is skipped, or
 * MGT_DIGMAP_LET, in which case u.let is valid.
 */
typedef struct mgMgcoDigMapRng
{
   TknU8                type;
   union
   {
      MgMgcoDigMapLet   let; 
   } u;
} MgMgcoDigMapRng;


/**** Megaco Digit String Element ****/
/* Type can be MGT_DIGSTR_RNG or MGT_DIGSTR_LET. Dot is optional. */
typedef struct mgMgcoDigStrElem
{
   TknU8                type;
   union
   {
      MgMgcoDigMapRng   range;
      TknU8             let;
   } u;
   TknPres              dot;
} MgMgcoDigStrElem;


/**** Megaco Digit String ****/
typedef struct mgMgcoDigStr
{
   TknU16               num;          /* Number of digit string elements */
   MgMgcoDigStrElem     **elems;      /* Elements */
} MgMgcoDigStr;


/**** Digit Map ****/
typedef struct mgMgcoDigMap
{
   TknU16               num;               /* Number of digit strings */
   MgMgcoDigStr         **ds;              /* Digit strings */
} MgMgcoDigMap;


/**** Digit Map Value ****/
/* T, S and L timers are optional. dmIn is ignored for ABNF. */
typedef struct mgMgcoDigMapVal
{
   TknPres              pres;               /* Present? */
   TknU8                t;                  /* "T" timer */
   TknU8                s;                  /* "S" timer */
   TknU8                l;                  /* "L" timer */
#ifdef MGT_MGCO_V2 /* milton-14 */
   TknU8                z;                  
#endif /* milton-14 */
#ifdef GCP_MGCO_PARSE_DIG_MAP
   TknStrOSXL           dm;                 /* Digit map */
#else
   MgMgcoDigMap         dm;                 /* Digit map */
#endif
   TknStrOSXL           dmIn;               /* For binary, parsed later */
} MgMgcoDigMapVal;


/****  Digit Map Event ****/
/* Type can be MGT_DIGMAP_NAME or MGT_DIGMAP_VAL. */
typedef struct mgMgcoEvtDM
{
   TknU8                type;               /* Name or value */
   union
   {
      MgMgcoName        name;                /* Digit map name */
      MgMgcoDigMapVal   val;                 /* Actual digit map */
   } u;
} MgMgcoEvtDM; 

/* Version 3: GCP_VER_2_1: Forward Definition of the below two structures */

/**** Second Embed List ****/
typedef struct mgMgcoEvtSecLst
{
   TknU16               num;                /* Number of events */
   struct mgMgcoEvtSec  **evts;
} MgMgcoEvtSecLst;


/**** Embed First Structure ****/
typedef struct mgMgcoEmbedFirst
{
   TknPres              pres;               /* Present? */
   MgMgcoRequestId      reqId;               /* Request ID */
   MgMgcoEvtSecLst      sl;                  /* List of req events */
} MgMgcoEmbedFirst;


/**** Embedded with Signal Structure ****/
typedef struct mgMgcoEmbWithSig
{
   TknPres              pres;               /* Present? */
   MgMgcoSignalsDesc    sig;
   MgMgcoEmbedFirst     emb;
} MgMgcoEmbWithSig;


/**** Embedded No Signal Structure ****/
typedef MgMgcoEmbedFirst MgMgcoEmbNoSig;

#ifdef GCP_VER_2_1
/**** Regulated Embedded Descriptor Structure ****/
typedef struct mgMgcoRegEmbDesc
{
   TknU8                type;                /* Param type */
   union
   {
      MgMgcoEmbWithSig     embWithSig;       /* Embedded With Signal - Signals
                                                and SecondsEvents Descriptor */
      MgMgcoEmbNoSig       embNoSig;         /* Embedded No Signal -
                                                SecondEventsDescriptor (ASN.1) */
   } u;
} MgMgcoRegEmbDesc;

/**** Notify Behaviour Structure ****/
/** type can be any of Notify Immediate, Never Notify or Notify regulated
 *  MGT_EVTPAR_NTFY_IMM or MGT_EVTPAR_NTFY_REG or MGT_EVTPAR_NEVER_NTFY */
typedef struct mgMgcoNtfyBehav
{
   TknU8                type;             /* Param type */
   union
   {
      TknU8             ntfyImm;          /* Notify Immediate */
      MgMgcoRegEmbDesc  regEmbDesc;       /* Regulated Embedded Descriptor */
      TknU8             neverNtfy;        /* Never Notify */
   } u; 
} MgMgcoNtfyBehav;
#endif /* GCP_VER_2_1 */

/**** Second Event Parameter ****/
/* Type can be MGT_EVTPAR_OTHER..MGT_EVTPAR_KEEPACTIVE from mgt.h.
 * Union is ignored if type == MGT_EVTPAR_KEEPACTIVE.
 */
typedef struct mgMgcoEvtParSec
{
   TknU8                type;               /* Param type */
   union
   {
      MgMgcoEvtOther       other;           /* Default/unknown */
      MgMgcoStreamId       streamId;        /* Stream ID */
      MgMgcoSignalsDesc    embSig;          /* Embedded signals descriptor */
      MgMgcoEvtDM          dm;              /* Digit map event */
      /* mgt_x_004.main_12: Added keepactive for ASN */
#ifdef GCP_ASN
      U8                ka;                 /* Keepactive ture/false
                                               in case of GCP_ASN */
#endif /* GCP_ASN */
#ifdef GCP_VER_2_1
      MgMgcoNtfyBehav   ntfyBehav;             /* Notify Behaviour */
      TknU8             rstEvtDesc;            /* Reset Evts Descriptor */
#endif /* GCP_VER_2_1 */
   } u;
} MgMgcoEvtParSec;

/**** Second Event Parameter List ****/
typedef struct mgMgcoEvtParSecLst
{
   TknU16               num;                /* Number of parameters */
   MgMgcoEvtParSec      **parms;            /* Parameters */
} MgMgcoEvtParSecLst;

/**** Second Requested Event ****/
/* Package ID is MGT_PKG_UNKNOWN..MGT_PKG_NAS_ROOT from mgt.h.
 * name.pkgName is ignored unless pkg is MGT_PKG_UNKNOWN.
 */
typedef struct mgMgcoEvtSec
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
   MgMgcoEvtParSecLst   pl;
} MgMgcoEvtSec;

/**** Event Parameter Structure ****/
/* Type can be one of MGT_EVTPAR_OTHER..MGT_EVTPAR_KEEPACTIVE.
 * Union is skipped if type == MGT_EVTPAR_KEEPACTIVE.
 */
typedef struct mgMgcoEvtPar
{
   TknU8                type;                  /* type of req/obs evt */
   union
   {
      MgMgcoEvtOther    other;                 /* Default/unknown */
      MgMgcoStreamId    streamId;              /* Stream ID */
      MgMgcoEmbWithSig  embWithSig;            /* Embed, with signals */
      MgMgcoEmbNoSig    embNoSig;              /* Embed, no signals */
      MgMgcoEvtDM       dm;                    /* Digit map event */
      /* mgt_x_004.main_12: Added keepactive for ASN */
#ifdef GCP_ASN
      U8                ka;                    /* Keepactive ture/false
                                                  in case of GCP_ASN */
#endif /* GCP_ASN */
#ifdef GCP_VER_2_1
      MgMgcoNtfyBehav   ntfyBehav;             /* Notify Behaviour */
      TknU8             rstEvtDesc;            /* Reset Evts Descriptor */
#endif /* GCP_VER_2_1 */
   } u;
} MgMgcoEvtPar;


typedef struct mgMgcoEvtParLst
{
   TknU16               num;                   /* Number of parameters */
   MgMgcoEvtPar         **parms;               /* Parameter list */
} MgMgcoEvtParLst;


/**** Requested Event ****/
/* pkg can be one of MGT_PKG_UNKNOWN..MGT_PKG_NAS_ROOT, and name.pkgName
 * is ignored unless pkg is MGT_PKG_UNKNOWN.
 */
typedef struct mgMgcoReqEvt
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
   MgMgcoEvtParLst      pl;                 /* Parameter list */
} MgMgcoReqEvt;



/**** Requested Event List ****/
typedef struct mgMgcoEvtLst
{
   TknU16               num;                 /* Number of events */
   MgMgcoReqEvt         **revts;             /* Requested events */
} MgMgcoEvtLst;


/**** (Requested) Events Descriptor ****/
typedef struct mgMgcoReqEvtDesc
{
   TknPres              pres;                /* Present? */
   MgMgcoRequestId      reqId;               /* Request ID */
   MgMgcoEvtLst         el;                  /* Events list */
} MgMgcoReqEvtDesc;


/**** Event Specified ****/
typedef MgMgcoReqEvt MgMgcoEvSpec;


/**** Event Buffer Descriptor ****/
typedef struct mgMgcoEvBufDesc
{
   TknU16               num;
   MgMgcoEvSpec         **evts;
} MgMgcoEvBufDesc;

/**** Digit Map descriptor ****/
/* Digit Map Name or Value or (Name and Value both) */
typedef struct mgMgcoDigMapDesc
{
   TknPres              pres;               /* Present? */
   MgMgcoName           name;               /* (opt) */
   MgMgcoDigMapVal      val;                /* (opt) */
} MgMgcoDigMapDesc;


/* Audit Descriptor */
/* Each entry in the al array can be one of MGT_MEDIADESC..MGT_PKGSDESC from
 * mgt.h.
 */
#ifdef MGT_MGCO_V2

/**** IndAud Local Control Descriptor Stream Mode ****/
/* [IMPORTANT]: Here we have to write utility function for encode and decode */
typedef struct mgMgcoIndAudStreamMode
{
   TknPres        pres;          /* Stream Mode NULL (opt) */
#ifdef GCP_VER_2_1
   TknU8          eqType;        /* (EQUAl/INEQUAL) This is only for ABNF */
   TknU8          val;           /* Stream Mode (opt) */
#endif /*  GCP_VER_2_1 */
} MgMgcoIndAudStreamMode;

/* Type is one of MGT_LCLCTL_MODE..MGT_LCLCTL_PROPPARM from mgt.h.
 * For type == MGT_LCLCTL_MODE, u.mode can be one of
 * MGT_MODE_SENDONLY..MGT_MODE_LOOPBACK from mgt.h.
 * For type == MGT_LCLCTL_RESVAL or MGT_LCLCTL_RESGRP, u.resVal or
 * u.resGrp can be FALSE for off and TRUE for on.
 */
typedef struct mgMgcoIndAudLocalParm
{
   TknU8                      type;                /* Stream/ResVal/ResGrp/Prop */
   union
   {
      MgMgcoIndAudStreamMode  mode;                /* Stream mode */
      TknU8                   resVal;              /* Reserve value? */
      TknU8                   resGrp;              /* Reserve group? */
      MgMgcoIndAudPropParm    propParm;            /* Property parameter */
   } u;
} MgMgcoIndAudLocalParm;

/**** IndAud Local Control Descriptor ****/
typedef struct mgMgcoIndAudLclCtlDesc
{
   TknU16                     num;                 /* Number of localParms */
   MgMgcoIndAudLocalParm      **parms;             /* list of local control parms */
} MgMgcoIndAudLclCtlDesc;

/**** List of IndAud Property Parameters ****/
typedef struct mgMgcoIndAudPropParmLst
{
   TknU16                     num;                 /* Number of localParms */
   MgMgcoIndAudPropParm       **parms;             /* list of local control parms */
} MgMgcoIndAudPropParmLst;

/**** List of IndAud Property Group ****/
typedef struct mgMgcoIndAudPropGrp
{
   TknPres                    pres;             /* Present? */
   TknU16                     propGrpId;        /* Property Group ID */
   MgMgcoIndAudPropParmLst    grp;              /* Groups = lists of propParms */
} MgMgcoIndAudPropGrp;

/**** IndAud Local Descriptor ****/
/* If CM_SDP_OPAQUE is defined, sdpStr contains the SDP portion of the
 * message as a message buffer. If CM_SDP_OPAQUE is undefined, sdp 
 * contains the SDP portion of the message in the data structure
 * CmSdpInfoSet. 
 */
typedef struct mgMgcoIndAudLocalDesc
{
   TknPres              pres;                   /* Present? */
   TknBuf               sdpStr;                 /* Opaque SDP string */
   CmSdpInfoSet         sdp;                    /* SDP info set */
/* Added Annex C support in GCP_ASN */
#ifdef GCP_ASN
   MgMgcoIndAudPropGrp  annexCParmLst;              /* ANNEX C property parms */
#endif /* GCP_ASN */
} MgMgcoIndAudLocalDesc;

/**** IndAud Remote Descriptor ****/
typedef MgMgcoIndAudLocalDesc MgMgcoIndAudRemoteDesc;

/**** IndAud Termination State Parameter Service State ****/
/* [IMPORTANT]: Here we have to write utility function for encode and decode */
typedef struct mgMgcoIndAudSvcState
{
   TknPres        pres;          /* ServiceState NULL (opt) */
#ifdef GCP_VER_2_1
   MgMgcoSvcState val;           /* ServiceStateSel (opt) */
#endif /*  GCP_VER_2_1 */
} MgMgcoIndAudSvcState;

/**** IndAud Termination State Parameters ****/
typedef struct mgMgcoIndAudTermStateParm           /* choice */
{
   TknU8                      type;                /* type */
   union
   {
      MgMgcoEvtBufCtl         evtBufCtl;           /* Event buffer control (NULL opt) */
      MgMgcoIndAudSvcState    svcState;            /* Service state (opt) */
      MgMgcoIndAudPropParm    parm;                /* Property parameter (opt) */
   } u;
} MgMgcoIndAudTermStateParm;

/**** IndAud Termination State Descriptor ****/
typedef struct mgMgcoIndAudTermStateDesc
{
   TknU16               numComp;
   MgMgcoIndAudTermStateParm  **trmStPar;
} MgMgcoIndAudTermStateDesc;


/**** IndAud Stream Parameter ****/
/*
 *   value in type can be -
 *      1) MGT_LCLCTL_MODE     - mode audit
 *      2) MGT_LCLCTL_RESVAL   - reserved value audit
 *      3) MGT_LCLCTL_RESGRP   - reserved group audit
 *      4) MGT_LCLCTL_PROPPARM - package property audit;
 *                               In this case, the fields pkg and
 *                               name are valid. pkg is valid for known pkgs.
 *                               name.pkgName is valid for unknown pkg.
 *                               name.name has the property name.
 */
typedef struct mgMgcoIndAudStreamParm
{
   TknPres                 pres;                /* Present? */
   MgMgcoIndAudLclCtlDesc  locCtl;              /* Local control descriptor */
   MgMgcoIndAudLocalDesc   local;               /* Local descriptor */
   MgMgcoIndAudRemoteDesc  remote;              /* Remote descriptor */
#ifdef GCP_VER_2_1   
   MgMgcoIndAudStatsDesc   stats;               /* Statistics Descriptor */
#endif /* GCP_VER_2_1 */
} MgMgcoIndAudStreamParm;

/**** IndAud Stream Descriptor ****/
typedef struct mgMgcoIndAudStreamDesc
{
   TknPres                 pres;                /* Present? */
   MgMgcoStreamId          streamId;            /* Stream ID */
   MgMgcoIndAudStreamParm  sl;                  /* Stream Parms */
} MgMgcoIndAudStreamDesc;

/**** IndAudMedia Parameter ****/
/* Type can be one of MGT_MEDIAPAR_LOCCTL..MGT_MEDIAPAR_TERMST in mgt.h */
typedef struct mgMgcoIndAudMediaParm
{
   TknU8                type;   /* specifies the type of media parameter */
   union
   {
      MgMgcoIndAudLclCtlDesc     locCtl;            /* Local control descriptor */
      MgMgcoIndAudLocalDesc      local;             /* Local descriptor */
      MgMgcoIndAudRemoteDesc     remote;            /* Remote descriptor */
#ifdef GCP_VER_2_1   
      MgMgcoIndAudStatsDesc      stats;             /* Statistics Descriptor */
#endif /* GCP_VER_2_1 */
      MgMgcoIndAudTermStateDesc  tstate;            /* Termination state desc (opt) */
      MgMgcoIndAudStreamDesc     stream;            /* Stream descriptors (opt) */
   } u;
} MgMgcoIndAudMediaParm;

/**** IndAud Media Descriptor *****/
typedef struct mgMgcoIndAudMediaDesc
{
   TknU16                  num;                 /* Number of descriptors */
   MgMgcoIndAudMediaParm   **parms;
} MgMgcoIndAudMediaDesc;

/*
 *   pkg is valid for known pkgs.
 *   name.pkgName is valid for unknown pkg.
 *   name.name has the event name.
 */
/**** IndAud Events Descriptor *****/
typedef struct mgMgcoIndAudEvtsDesc
{
   TknPres              pres;                /* Present? */
   MgMgcoRequestId      reqId;               /* Request ID */
   MgMgcoSigName        pkgdName;                  /* Events list */
   MgMgcoStreamId       streamId;            /* Stream ID */
} MgMgcoIndAudEvtsDesc;

/*
 *   value in type can be -
 *      1) MGT_SIGSPAR_LST - specifies sigList
 *      2) MGT_SIGSPAR_REQ - specifies sigName
 */
#if ((defined(MGT_MGCO_V2) && defined(GCP_ASN)) || defined(GCP_VER_2_1))
typedef struct mgMgcoIndAudSigPar
{
   TknU8                type;
   union
   {
      MgMgcoStreamId    streamId;         /* Signal Stream ID */
#ifdef GCP_VER_2_1
      MgMgcoRequestId   reqId;            /* Signal Request ID */
#endif /*  GCP_VER_2_1 */
   } u;
} MgMgcoIndAudSigPar;

typedef struct mgMgcoIndAudSigParLst
{
   TknU16                  num;            /* number of Individaual audit 
                                              Signal Parameters */
   MgMgcoIndAudSigPar      **spl;    /* Signal Parameter List */
} MgMgcoIndAudSigParLst;
#endif /*  (MGT_MGCO_V2 && GCP_ASN) || GCP_VER_2_1 */

typedef struct mgMgcoIndAudSigReq
{
   MgMgcoSigName           sigName;    /* signal name */
#if ((defined(MGT_MGCO_V2) && defined(GCP_ASN)) || defined(GCP_VER_2_1))
   MgMgcoIndAudSigParLst   sigParLst;
#endif /*  (MGT_MGCO_V2 && GCP_ASN) || GCP_VER_2_1 */
} MgMgcoIndAudSigReq;

typedef struct mgMgcoIndAudSigLst
{
   TknU16               sigLstId;   /* signal list Id */
   MgMgcoIndAudSigReq   sigReq;    /* signal name */
} MgMgcoIndAudSigLst;

typedef struct mgMgcoIndAudSignalsDesc
{
   TknU8                type;   /* specifies type - sigList or sigName */
   union
   {
      MgMgcoIndAudSigReq      sigReq;       /* signal Name */
      MgMgcoIndAudSigLst      sigList;      /* signal list */
   } u;
} MgMgcoIndAudSignalsDesc;

/**** IndAud Event Spec Parameter *****/
/*
 *   value in type can be -
 *      1) MGT_EVTPAR_OTHER    - specifies event parameter name
 *      2) MGT_EVTPAR_STREAMID - specifies stream Id
 */
typedef struct mgMgcoIndAudEventSpecParm
{
   TknU8                type;
   union
   {
      MgMgcoStreamId    evStream;      /* streamId */
      MgMgcoName        evParmName;    /* event parm name */
   } u;
} MgMgcoIndAudEventSpecParm;

typedef struct mgMgcoIndAudEventSpecParmLst
{
   TknU16                        num;       /* Number of Individaual audit 
                                               Signal Parameters */
   MgMgcoIndAudEventSpecParm     **espl;    /* Signal Parameter List */
} MgMgcoIndAudEventSpecParmLst;

/**** IndAud Event Buffer Descriptor *****/
typedef struct mgMgcoIndAudEvtBufferDesc
{
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
   MgMgcoIndAudEventSpecParmLst   evSpecParmLst;
} MgMgcoIndAudEvtBufferDesc;

typedef MgMgcoName    MgMgcoIndAudDigMapDesc;

typedef MgMgcoPkgsItem MgMgcoIndAudPkgsDesc;

typedef struct mgMgcoIndAudAuditRetParm
{
   TknU8                type;   /* specifies return audit parameter type */
   union
   {
      MgMgcoIndAudMediaDesc      audMedia;      /* Media Descriptor */
      MgMgcoIndAudEvtsDesc       audEvents;     /* Events Descriptor */
      MgMgcoIndAudEvtBufferDesc  audEvtBuf;     /* Event Buffer Descriptor */
      MgMgcoIndAudSignalsDesc    audSignals;    /* Signals Descriptor */
      MgMgcoIndAudDigMapDesc     audDigMap;     /* Digit Map Descriptor */
      MgMgcoIndAudStatsDesc      audStats;      /* Statistics Descriptor */
      MgMgcoIndAudPkgsDesc       audPkgs;       /* Packages Descriptor */
   } u;
} MgMgcoIndAudAuditRetParm;

typedef struct mgMgcoIndAudTermAudit
{
   TknU16                                  num;      /* number of audit Parms */
   MgMgcoIndAudAuditRetParm                **parm;   /* audit Parm's list */
} MgMgcoIndAudTermAudit;

#endif /* MGT_MGCO_V2 */



#ifdef MGT_MGCO_V2
typedef struct mgMgcoAuditItem
{
   TknU8                      auditItem;      /* auditItem tokens */
   MgMgcoIndAudTermAudit      termAudit;      /* termination audit */
} MgMgcoAuditItem;
#else  /* MGT_MGCO_V2 */
typedef TknU8 MgMgcoAuditItem;
#endif /* MGT_MGCO_V2 */


typedef struct mgMgcoAuditDesc
{
   TknPres              pres; /* present? */
   TknU16               num;             /* Number of descriptors */
   MgMgcoAuditItem      **al;            /* Audit tokens */
} MgMgcoAuditDesc;


/**** Add/Modify/Move Parameter ****/
/* Type is one of MGT_MEDIADESC, MGT_MODEMDESC, MGT_MUXDESC, MGT_REQEVTDESC,
 * MGT_EVBUFDESC, MGT_SIGNALSDESC, MGT_DIGMAPDESC, MGT_AUDITDESC or
 * MGT_STATSDESC (version 3)
 */
typedef struct mgMgcoAmmDesc
{
   TknU8                type;                /* descriptor type */
   union
   {
      MgMgcoMediaDesc   media;
      MgMgcoModemDesc   modem;
      MgMgcoMuxDesc     mux;
      MgMgcoReqEvtDesc  evts;
      MgMgcoEvBufDesc   evBuf;
      MgMgcoSignalsDesc sig;
      MgMgcoDigMapDesc  dm;
      MgMgcoAuditDesc   audit;
#ifdef GCP_VER_2_1 
      MgMgcoStatsDesc   stats;
#endif /* GCP_VER_2_1 */
   } u;
} MgMgcoAmmDesc;



/**** Add/Modify/Move List ****/
typedef struct mgMgcoAmmDescLst
{
   TknU16               num;                 /* Number of descriptors */
   MgMgcoAmmDesc        **descs;             /* AMM descriptors */
} MgMgcoAmmDescLst;



/**** Add/Modify/Move Request ****/
typedef struct mgMgcoAmmReq
{
   TknPres              pres;               /* Present? */
#ifdef GCP_VER_2_1
   MgMgcoTermIdLst      termIdLst;          /* special - termination ID list */
#else
   MgMgcoTermId         termId;             /* Termination ID - NOT list */
#endif /* GCP_VER_2_1 */
   MgMgcoAmmDescLst     dl;                 /* Add/Modify/Move descriptors */
} MgMgcoAmmReq;


/**** Subtract Or Audit Request ****/
typedef struct mgMgcoSubAudReq
{
   TknPres              pres;                 /* Present? */
#ifdef GCP_VER_2_1   
   MgMgcoTermIdLst      termIdLst;            /* special - termination ID list */
#else
   MgMgcoTermId         termId;               /* Termination ID */
#endif /* GCP_VER_2_1 */
   MgMgcoAuditDesc      audit;                /* Audit desc (opt) */
} MgMgcoSubAudReq;

/**** Observed Event ****/
/* Package ID (pkg) can be one of MGT_PKG_UNKNOWN..MGT_PKG_NAS_ROOT.
 * name.pkgName is skipped unless pkg is MGT_PKG_UNKNOWN.
 */
typedef struct mgMgcoObsEvt
{
   TknPres              pres;                  /* Present? */
   MgMgcoTimeStamp      time;                  /* timestamp (opt) */
   MgMgcoPkg            pkg;
   MgMgcoName           name;               /* Property or Event name */
   MgMgcoEvtParLst      pl;                    /* Parameter list */
} MgMgcoObsEvt;


/**** Observed Events List ****/
typedef struct mgMgcoObsEvtLst
{
   TknU16               num;                   /* Number of events */
   MgMgcoObsEvt         **evts;                /* Observed events */
} MgMgcoObsEvtLst;

/**** Observed Events Descriptor ****/
typedef struct mgMgcoObsEvtDesc
{
   TknPres              pres;                 /* Present? */
   MgMgcoRequestId      reqId;                 /* Request ID */
   MgMgcoObsEvtLst      el;                    /* Observed events list */
} MgMgcoObsEvtDesc;


/**** Notify Request*** */
typedef struct mgMgcoNtfyReq
{
   TknPres              pres;                 /* Present? */
#ifdef GCP_VER_2_1   
   MgMgcoTermIdLst      termIdLst;          /* special - termination ID list */
#else
   MgMgcoTermId         termId;             /* Termination ID */
#endif /* GCP_VER_2_1 */
   MgMgcoObsEvtDesc     obs;                  /* Observed events desc */
   MgMgcoErrDesc        err;                  /* Error descriptor (opt) */
} MgMgcoNtfyReq;


/**** Service change method ****/
/* Type is one of MGT_SVCCHGMETH_FAILOVER..MGT_SVCCHGMETH_HANDOFF in which
 * case extn is ignored, or MGT_EXTNPARM.
 */
typedef struct mgMgcoSvcChgMethod
{
   TknPres              pres;               /* Present? */
   TknU8                type;                /* Service change method type */
   MgMgcoNonStdId       extn;                /* Non-standard method if any */
} MgMgcoSvcChgMethod;

/**** Service change profile ****/
typedef struct mgMgcoSvcChgProf
{
   TknPres              pres;                /* Present? */
   MgMgcoName           name;                /* Profile name */
   TknU8                ver;                 /* Profile version */
} MgMgcoSvcChgProf;


/**** Service Change Parameter in Request ****/
typedef struct mgMgcoSvcChgPar            
{
   TknPres              pres;             /* Present? */
   MgMgcoNonStdExtn     extn;             /* Non-standard (extension) parm */
   MgMgcoSvcChgMethod   meth;             /* Service change method */
   MgMgcoSvcChgAddr     addr;             /* Service change address */
   TknU8                ver;              /* Service change version */
   MgMgcoSvcChgProf     prof;             /* Service change profile */
   MgMgcoSvcChgReason   reason;           /* Service change reason */
   TknU32               delay;            /* Service change delay */
   MgMgcoMid            mgcId;            /* Handoff MGC ID */
   MgMgcoTimeStamp      time;             /* Timestamp */
#ifdef MGT_MGCO_V2
   MgMgcoAuditItem      auditItem;        /* audit item */
#ifdef GCP_VER_2_1   
   TknU8                svcChgInComp;     /* Service Change Incomplete Token */
#endif /* GCP_VER_2_1 */
#endif /* MGT_MGCO_V2 */
}MgMgcoSvcChgPar;


/**** Service Change Request ****/
typedef struct mgMgcoSvcChgReq  
{
   TknPres              pres;               /* Present? */
#ifdef GCP_VER_2_1   
   MgMgcoTermIdLst      termIdLst;          /* special - termination ID list */
#else
   MgMgcoTermId         termId;              /* Termination ID */
#endif /* GCP_VER_2_1 */
   MgMgcoSvcChgPar      parm;                /* Parameter */
} MgMgcoSvcChgReq;


/**** Megaco Command ****/
/* Type is one of MGT_ADD..MGT_SVCCHG from mgt.h. */
typedef struct mgMgcoCmd
{
   TknU8                type;               /* Type of command */
   union
   {
      MgMgcoAmmReq      add;                /* Add */
      MgMgcoAmmReq      move;               /* Move */
      MgMgcoAmmReq      mod;                /* Modify */
      MgMgcoSubAudReq   sub;                /* Subtract */
      MgMgcoSubAudReq   acap;               /* Audit capabilities */
      MgMgcoSubAudReq   aval;               /* Audit value */
      MgMgcoNtfyReq     ntfy;               /* Notify */
      MgMgcoSvcChgReq   svc;                /* Service change */
   } u;
} MgMgcoCmd;

/***** Command Request *****/
#ifdef GCP_CH
typedef struct mgMgcoCommandReq 
{
    CmMemListCp          memCp;              /* Memory List Control Point */
   TknPres              pres;               /* Present? */
   TknPres              opt;                /* Is command optional "O-"? */
   TknPres              wild;               /* Wildcard return "W-"? */
   MgMgcoCmd            cmd;                /* Command */
} MgMgcoCommandReq;
#else
 
typedef struct mgMgcoCommandReq 
{
   TknPres              pres;               /* Present? */
   TknPres              opt;                /* Is command optional "O-"? */
   TknPres              wild;               /* Wildcard return "W-"? */
   MgMgcoCmd            cmd;                /* Command */
} MgMgcoCommandReq;
#endif

/**** Command Request List ****/
#ifdef GCP_CH
typedef struct mgMgcoCmdReqLst
{
   TknU16               num;                /* Number of command requests */
   MgMgcoCommandReq     *cmds[MGT_MAX_CMDS];/* Commands */
} MgMgcoCmdReqLst;

#else
typedef struct mgMgcoCmdReqLst
{
   TknU16               num;                /* Number of command requests */
   MgMgcoCommandReq     **cmds;             /* Commands */
} MgMgcoCmdReqLst;
#endif


/**** Action Request ****/
typedef struct mgMgcoActionReq
{
   MgMgcoContextId      cxtId;               /* Context ID */
   TknPres              pres;                /* Any of below present? */
   MgMgcoContextProps   cxtProps;            /* Context properties (opt) */
   MgMgcoContextAudit   cxtAud;              /* Context audit (opt) */
   MgMgcoCmdReqLst      cl;                  /* Command request list (opt) */
} MgMgcoActionReq;

/**** Action List ****/
typedef struct mgMgcoActionLst
{
   TknU16               num;                /* Number of action requests */
   MgMgcoActionReq      **actns;            /* Action requests */
} MgMgcoActionLst;

/**** Megaco Transaction Request ****/
typedef struct mgMgcoTxnReq
{
   TknPres              pres;               /* present? */
   MgMgcoTransId        transId;            /* Transaction ID */
   MgMgcoActionLst      al;                 /* Action list */
} MgMgcoTxnReq;


/**** Package Descriptor ****/
typedef struct mgMgcoPkgsDesc
{
   TknU16               num;
   MgMgcoPkgsItem       **items;
} MgMgcoPkgsDesc;


/**** Audit Return Parameters ****/
/* Type is one of MGT_ERRDESC..MGT_AUDITDESC from mgt.h. */
typedef struct mgMgcoAudRetParm
{
   TknU8                type;                  /* Param type */
   union
   {
      MgMgcoErrDesc     err;             /* Error descriptor */
      MgMgcoMediaDesc   media;
      MgMgcoModemDesc   modem;
      MgMgcoMuxDesc     mux;
      MgMgcoReqEvtDesc  evts;
      MgMgcoEvBufDesc   evBuf;
      MgMgcoSignalsDesc sig;
      MgMgcoDigMapDesc  dm;
      MgMgcoObsEvtDesc  obs;
      MgMgcoStatsDesc   stats;
      MgMgcoPkgsDesc    pkgs;
      MgMgcoAuditItem   item;
   } u;
} MgMgcoAudRetParm;
/**** Termination Audit Result ****/
typedef struct mgMgcoTermAuditRes 
{
   TknU16               num;                  /* Number of audits returned */
   MgMgcoAudRetParm     **parms;              /* Audit return params */
} MgMgcoTermAuditRes;


/**** Add/Move/Modify/Subtract Reply ****/
typedef struct mgMgcoAmmsReply
{
   TknPres              pres;                 /* Present? */
#ifdef GCP_VER_2_1   
   MgMgcoTermIdLst      termIdLst;          /* special - termination ID list */
#else
   MgMgcoTermId         termId;             /* Termination ID - NOT list */
#endif /* GCP_VER_2_1 */
   MgMgcoTermAuditRes   audit;                /* Termination audit (opt) */
} MgMgcoAmmsReply;


/**** Audit ****/
typedef struct mgMgcoAuditOther
{
   TknPres              pres;                /* Present? */
#ifdef GCP_VER_2_1
   MgMgcoTermIdLst      termIdLst;           /* special - termination ID list */
#else
   MgMgcoTermId         termId;              /* Termination ID (opt) */
#endif
   MgMgcoTermAuditRes   audit;               /* Termination audit (opt) */
} MgMgcoAuditOther;

/**** Audit Reply ****/
/* Type is one of MGT_ERRDESC, MGT_CXTAUDIT or MGT_TERMAUDIT. */
typedef struct mgMgcoAuditReply
{
   TknU8                type;            /* Context audit or term audit */
   union
   {
      MgMgcoErrDesc        err;          /* Error descriptor */
      MgMgcoTermIdLst      cxt;          /* Context audit */
      MgMgcoAuditOther     other;        /* Termination audit (other) */
#if (defined(GCP_ASN) && defined(GCP_VER_2_1))
      MgMgcoAuditOther     auditResultTermList;
#endif /* GCP_ASN && GCP_VER_2_1 */
   } u;
} MgMgcoAuditReply;


/**** Notify Reply ****/
typedef struct mgMgcoNtfyReply
{
   TknPres              pres;                 /* Present? */
#ifdef GCP_VER_2_1   
   MgMgcoTermIdLst      termIdLst;            /* special - termination ID list */
#else
   MgMgcoTermId         termId;               /* Termination ID (opt) */
#endif /* GCP_VER_2_1 */
   MgMgcoErrDesc        err;                  /* Error descriptor (opt) */
} MgMgcoNtfyReply;


/**** Service Change Parameters ****/
typedef struct mgMgcoSvcChgResPar         /* Set */
{
   TknPres              pres;             /* Present? */
   MgMgcoSvcChgAddr     addr;             /* Service change address */
   TknU8                ver;              /* Service change version */
   MgMgcoSvcChgProf     prof;             /* Service change profile */
   MgMgcoMid            mgcId;            /* Handoff MGC ID */
   MgMgcoTimeStamp      time;             /* Timestamp */
} MgMgcoSvcChgResPar;


/**** Service Change Result ****/
/* Type can be MGT_ERRDESC or MGT_SVCCHGDESC. */
typedef struct mgMgcoSvcChgRes
{
   TknU8                type;
   union
   {
      MgMgcoErrDesc        err;
      MgMgcoSvcChgResPar   parm;
   } u;
} MgMgcoSvcChgRes;


/**** Service Change Reply ****/
typedef struct mgMgcoSvcChgReply
{
   TknPres              pres;               /* Present? */
#ifdef GCP_VER_2_1   
   MgMgcoTermIdLst      termIdLst;          /* special - termination ID list */
#else
   MgMgcoTermId         termId;              /* Termination ID */
#endif /* GCP_VER_2_1 */
   MgMgcoSvcChgRes      res;                 /* Service change result */
} MgMgcoSvcChgReply;


/**** Command Reply ****/
#ifdef GCP_CH
/* Type is one of MGT_ADD..MGT_SVCCHG. */
typedef struct mgMgcoCmdReply
{
   CmMemListCp          memCp;              /* Memory List Control Point */
   TknPres              pres;               /* Present? */
   TknPres              wild;               /* Is it wildcarded? */
   TknU8                type;               /* Type */
   union
   {
      MgMgcoAmmsReply      add;             /* Add reply */
      MgMgcoAmmsReply      move;            /* Move reply */
      MgMgcoAmmsReply      mod;             /* Modify reply */
      MgMgcoAmmsReply      sub;             /* Subtract reply */
      MgMgcoAuditReply     acap;            /* Audit capabilities reply */
      MgMgcoAuditReply     aval;            /* Audit value reply */
      MgMgcoNtfyReply      ntfy;            /* Notify reply */
      MgMgcoSvcChgReply    svc;             /* Service change reply */
   } u;
} MgMgcoCmdReply;


#else
/* Type is one of MGT_ADD..MGT_SVCCHG. */
typedef struct mgMgcoCmdReply
{
   TknPres              pres;               /* Present? */
   TknPres              wild;               /* Is it wildcarded? */
   TknU8                type;               /* Type */
   union
   {
      MgMgcoAmmsReply      add;             /* Add reply */
      MgMgcoAmmsReply      move;            /* Move reply */
      MgMgcoAmmsReply      mod;             /* Modify reply */
      MgMgcoAmmsReply      sub;             /* Subtract reply */
      MgMgcoAuditReply     acap;            /* Audit capabilities reply */
      MgMgcoAuditReply     aval;            /* Audit value reply */
      MgMgcoNtfyReply      ntfy;            /* Notify reply */
      MgMgcoSvcChgReply    svc;             /* Service change reply */
   } u;
} MgMgcoCmdReply;

#endif 

/**** Command Reply List ****/
#ifdef GCP_CH
typedef struct mgMgcoCmdReplyLst
{
   TknU16               num;                /* Number of command replies */
   MgMgcoCmdReply       *repl[MGT_MAX_CMDS];/* Command replies */
} MgMgcoCmdReplyLst;

#else
typedef struct mgMgcoCmdReplyLst
{
   TknU16               num;                /* Number of command replies */
   MgMgcoCmdReply       **repl;             /* Command replies */
} MgMgcoCmdReplyLst;

#endif 

/**** Context Command Reply ****/
typedef struct mgMgcoCxtCmdReply
{
   TknPres              pres;               /* Present? */
   MgMgcoContextProps   cxt;                /* Context reply (opt) */
   MgMgcoCmdReplyLst    cl;                 /* Command reply list (opt) */
} MgMgcoCxtCmdReply;

/**** Action Reply ****/

/*
 *   The following changes in actionReply came from the IG. The motivation
 *   behind these changes was to have a place holder for error descriptor
 *   in an optional cmd in the commandReplys when the cmd token itself
 *   had syntax problems (unlikely case). Logically the error descriptor
 *   should be present within the commandReplys ABNF construct as an
 *   additional choice. However, Christian Groves did not want to change
 *   the ASN syntax. Therefore, the errorDescriptor is present in
 *   actionReply. This is counter-intuitive but this case is unlikely.
 */

/* mgt_x_006.main_12: Corection to err and reply for proper encoding */
typedef struct mgMgcoErrCmdRepSet
{
   TknPres              pres;            /* Present? */
   MgMgcoCxtCmdReply    reply;           /* Context reply + cmd replies */
   MgMgcoErrDesc        err;             /* Error descriptor */
} MgMgcoErrCmdRepSet;


/* Type can be either MGT_ERRDESC or MGT_CXTCMDREPLY OR
 * both of these */
typedef struct mgMgcoActnReply
{
   TknPres              pres;               /* Present? */
   MgMgcoContextId      cxtId;              /* Context ID */
   MgMgcoErrCmdRepSet   repErrSet;          /* set of errDesc , CmdReply */
} MgMgcoActnReply;


/**** Action Reply List ****/
typedef struct mgMgcoActnReplyLst
{
   TknU16               num;                /* Number of action replies */
   MgMgcoActnReply      **repl;             /* Action replies */
} MgMgcoActnReplyLst;


#ifdef GCP_VER_2_1   
typedef TknU16       MgMgcoSegNum;
typedef TknU8        MgMgcoSegCmpl; 
typedef struct mgMgcoSegReply  
{
   TknPres              pres;               /* present? */
   MgMgcoTransId        transId;            /* Transaction ID */
   MgMgcoSegNum         segNum;             /* Segmentation Number */
   MgMgcoSegCmpl        segCmpl;            /* Segmentation Complete */ 
} MgMgcoSegReply;
#endif /* GCP_VER_2_1 */

/**** Megaco Response Structure ****/

/* Type can be MGT_ERRDESC or MGT_ACTIONREPLY. */
typedef struct mgMgcoTxnReply
{
   TknPres              pres;               /* present? */
   MgMgcoTransId        transId;            /* Transaction ID */
#ifdef GCP_VER_2_1
   MgMgcoSegNum         segNum;             /* Segmentation Number */
   MgMgcoSegCmpl        segCmpl;            /* Segmentation Complete */ 
#endif /* GCP_VER_2_1 */
   TknPres              immAck;             /* Immediate ack required? */
   TknU8                type;               /* Error or action-replies? */
   union
   {
      MgMgcoErrDesc        err;             /* Error descriptor */
      MgMgcoActnReplyLst   arl;             /* Action reply list */
   } u;
} MgMgcoTxnReply;

/**** Transaction Pending structure ****/
typedef struct mgMgcoTxnPend
{
   TknPres              pres;               /* Present? */
   MgMgcoTransId        transId;            /* Transaction ID */
} MgMgcoTxnPend;


/**** Transaction ACK ****/
typedef struct mgMgcoTxnAck
{
   TknPres              pres;               /* Present? */
   MgMgcoTransId        first;              /* First Ack */
   MgMgcoTransId        last;               /* Last ack, if range first..last */
} MgMgcoTxnAck;

/**** Megaco Response Acknowledgement Structure ****/
typedef struct mgMgcoTxnRspAck
{
   TknU16               num;                /* Number of transaction acks */
   MgMgcoTxnAck         **acks;             /* Transaction acks */
} MgMgcoTxnRspAck;

/**** Megaco Transaction Structure ****/
/* Type is one of MGT_TXNREQ..MGT_TXNRSPACK in which case the corresponding
 * union field is valid, or MGT_TXNLOCAL_ERR in which case mgLclErr is valid.
 */
typedef struct mgMgcoTxn
{
   CmMemListCp          memCp;              /* Memory List Control Point */
   TknU8                type;               /* Transaction type */
   union
   {
      MgMgcoTxnReq      req;                /* Transaction request */
      MgMgcoTxnReply    reply;              /* Transaction reply */
      MgMgcoTxnPend     pend;               /* Transaction pending */
      MgMgcoTxnRspAck   rspAck;             /* Transaction response ack */
#ifdef GCP_VER_2_1 
      MgMgcoSegReply    segReply;           /* Segment Reply */
#endif /* GCP_VER_2_1 */
   } u;
   MgLclErr    mgLclErr;                    /* local errors */
   TknU8       dupInfo;                     /* Duplicate Txn flag */
#if (defined(ZG_DFTHA) || defined(DG))
   CmFthaRsetId    rsetId;
#endif
} MgMgcoTxn;


/**** Transaction List ****/
typedef struct mgMgcoTxnLst
{
   TknU16               num;                /* Number of transactions */
   MgMgcoTxn            *txns[MGT_MAX_TXNS];          /* Transactions array */
} MgMgcoTxnLst;


/**** Message Body ****/
/* Type can be MGT_ERRDESC or MGT_TXN. */
/* mgt_x_003.main_7 : support for errorDesc added */
typedef struct mgMgcoMsgBody
{
   TknU8                type;               /* Message type - txns */
   union
   {
      MgMgcoErrDesc     err;                /* Error dscriptor */
      MgMgcoTxnLst      tl;                 /* transaction list */
   } u;
} MgMgcoMsgBody;

/* mgt_x_007.main_12: Added LCN Feature */
#ifdef GCP_LCN_APP_USE
typedef struct mgMgtLcnInfo
{

   TknU8             lcnType;  /* MG_LCN_TYPE_MTP3, MG_LCN_TYPE_SCTP, 
                                  MG_LCN_TYPE_NONE */
   union 
   {
#ifdef GCP_PROV_MTP3
      LnkSel                lnkSel;       /* MTP3/M3UA Link Selector Id */
#endif /* GCP_PROV_MTP3 */
#ifdef GCP_PROV_SCTP
      SctStrmId             strmId;       /* SCTP Stream ID */
                                        /* Incomming Stream Id: If message
                                           received from GCP stack to APP */
                                        /* Outgoing Stream Id: If message
                                           received from APP  to GCP stack*/
#endif
    } u;
} MgMgtLcnInfo;
#endif /* GCP_LCN_APP_USE */

/**** Megaco Message ****/
typedef struct mgMgcoMsg
{
   CmMemListCp          memCp;              /* Memory List Control Point */
   TknPres              pres;               /* Present? */
   MgMgcoAuthHdr        ah;                 /* Authentication Header */
   MgMgcoVersion        ver;                /* Protocol version */
   TknStrOSXL           mid;                /* 003.main_3 Message identifier */ 
   MgMgcoMsgBody        body;               /* Message body */
   MgPeerInfo           lcl;                /* Local Information */

#ifdef   GCP_PROV_SCTP
   Bool                 unorder;
   /*
    * ordered OR un-ordered delivery. High priority msgs should be
    * sent using un-ordered delivery i.e. unorder should be set to TRUE.
    * This field is valid only for SCTP as transport.
    */
#endif /* GCP_PROV_SCTP */

/* mgt_x_007.main_12: Added LCN Feature */
#ifdef GCP_LCN_APP_USE
    MgMgtLcnInfo          lcnInfo;
#endif /* GCP_LCN_APP_USE */

} MgMgcoMsg;

#if ((defined GCP_VER_2_1) && (defined GCP_MG))
typedef struct mgMgcoProf
{
   U8       version;
   U16      len;
   U8       profStr[MGT_MAX_PROF_LEN];
}MgMgcoProf;
#endif /* GCP_VER_2_1 && GCP_MG */

#endif /* GCP_MGCO */

/**** Status  Structure ****/
typedef struct mgMgtSta
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
  U8 bitVector;        /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */   
  MgPeerInfo peerInfo;
  U8 type;   /* MGT_STATUS_FLOW, MGT_STATUS_HANDOFF_FAILED ,
                 MGT_STATUS_MGCO_VER, MGT_STATUS_MGCP_VER,
                 MGT_STATUS_PEER, MGT_STATUS_REDIRECTION_FAILED,
                 MGT_STATUS_SAP_RECVRY_FAILED, MGT_STATUS_SAP_RECVRY_SUCCESS,
                 MGT_STATUS_SRVC_PRVDR_FAILED, MGT_STATUS_LCN_INFO */
  union
  {
#ifdef GCP_MGCO
    TknU32     mgcoVersion;
#endif /* GCP_MGCO */
#ifdef GCP_MGCP
    TknU32     mgcpVersion;
#endif /* GCP_MGCP */

#ifdef GCP_MGCO
#if (defined(GCP_VER_2_1) && (defined GCP_MG))
    MgMgcoProf    mgcoProf;
#endif
#endif  /* GCP_MGCO */

    U8            action;
    U8            reason;
/* mgt_x_007.main_12: Added LCN Feature */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo          lcnInfo;        /* Logical Channel Number Info */
#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
  }u;
} MgMgtSta;

#ifdef GCP_CH

 
/* CH Command Structure used by all CH command Primitives */
typedef struct mgMgcoCommand
{
   MgMgcoTransId         transId;       /* Transaction Identifier generated */
#ifdef GCP_MGCO
#ifdef GCP_VER_2_1
   MgMgcoSegNum          segNum;
   MgMgcoSegCmpl         segCmpl;
#endif
#endif  /* GCP_MGCO */
   MgMgcoContextId       contextId;     /* Context Identifier for the       */
                                        /* command request                  */
   TknU32                peerId;        /* Peer Identifier                  */ 
/* mgt_x_007.main_12: Added LCN Feature */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo          lcnInfo;        /* Logical Channel Number Info */
#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
   TknU8                 cmdStatus;     /* command status                   */
   TknU8                 cmdType;       /* Command Type                     */
                                        /* CH_CMD_TYPE_REQ, CH_CMD_TYPE_RESP*/
                                        /* CH_CMD_TYPE_IND, CH_CMD_TYPE_CFM */
   union
   {                                    
      MgMgcoCommandReq      *mgCmdReq[MGT_ONE_CMD];     /* Command Request information     */
      MgMgcoCmdReply        *mgCmdRsp[MGT_ONE_CMD];     /* Command Response Information   */
      MgMgcoCommandReq      *mgCmdInd[MGT_ONE_CMD];     /* Command Indication Information */
      MgMgcoCmdReply        *mgCmdCfm[MGT_ONE_CMD];     /* Command Confirmation Information */
   }u;
}MgMgcoCommand;

/* CH Context Information Structure  */
typedef struct mgMgcoChCntxt
{
   TknPres                 pres;    /* whether below fields are present */
   MgMgcoContextProps      cxtProps;/* Context Properties               */
   MgMgcoContextAudit      cxtAudit;/* Context Audit Information.       */
} MgMgcoChCntxt; 
 
/* CH Update Context Structure used by Update Context Primitive */
typedef struct mgMgcoUpdateCntxt 
{
   CmMemListCp           memCp;         /* Memory Control Point             */
   MgMgcoTransId         transId;       /* Transaction Identifier generated */
                                        /* Service User                     */
#ifdef GCP_MGCO
#ifdef GCP_VER_2_1
   MgMgcoSegNum          segNum;
   MgMgcoSegCmpl         segCmpl;
#endif
#endif  /* GCP_MGCO */
   MgMgcoContextId       contextId;     /* Context Identifier fot the       */
                                        /* command request                  */
   TknU32                peerId;        /* Peer Identifier                  */ 
   MgMgcoChCntxt         contextProp;   /* Context Properties.              */
   TknU8                 status;        /* Can take any of the following    */
                                        /* CH_CMD_STATUS_PENDING            */
                                        /* CH_CMD_STATUS_END_OF_AXN         */
                                        /* CH_CMD_STATUS_END_OF_TXN         */
/* mgt_x_007.main_12: Added LCN Feature */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo          lcnInfo;        /* Logical Channel Number Info */
#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
}MgMgcoUpdateCntxt;
 
 
/* Error Indincation Primitive                          */
/* MG User: Axn and Txn Reply with error code           */
/* CH: Transaction pending and TimeOut error Indication */
typedef struct mgMgcoInd
{
   CmMemListCp          memCp;          /* Memory Control Point             */
   MgMgcoTransId        transId;        /* Transaction Identifier           */
   MgMgcoContextId      cntxtId;        /* Context Identifier (Opt)         */
   TknU32               peerId;         /* Peer Identifier                  */ 
   MgMgcoErrDesc        err;            /* Error Identifier(Opt)            */
                                        /* If errorId.pres is present below */
                                        /* field will not be present        */
                                        /* Possible values are              */
                                        /* CH_ERR_REQ_TMD_OUT               */
                                        /* CH_ERR_RSP_TMD_OUT               */
                                        /* Other H248 error codes           */
   TknPres              txnPending;     /* Incomming Txn Pending indication */
                                        /* Flag (Opt)                       */ 
   Bool                 isTxnRspAck;

#ifdef GCP_MGCO
#ifdef GCP_VER_2_1
   TknU16               segNum;      
#endif
#endif  /* GCP_MGCO */

/* mgt_x_007.main_12: Added LCN Feature */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo          lcnInfo;        /* Logical Channel Number Info */
#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
} MgMgcoInd;
 
/* mgt_x_006.main_12: CH-Module Redesign changes */
/* End of Action information structure */
typedef struct mgMgcoCtxt
{
   MgMgcoTransId        transId;        /* Transaction Identifier           */
   MgMgcoContextId      cntxtId;        /* Context Identifier (Opt)         */
   TknU32               peerId;         /* Peer Identifier                  */ 
   TknU8                cmdStatus;      /* command status                   */
   TknPres              immAck;
} MgMgcoCtxt;

/***********************************************************************
                      
 ***********************************************************************/

/* MGT Command Primitive */
typedef S16 (*MgtMgcoCmdReq)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoCommand *chCmdReq
               ));     

typedef S16 (*MgtMgcoCmdInd)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoCommand *chCmdInd
               ));     


/* MGT Update context primitive used by provider */
typedef S16 (*MgtMgcoUpdCtxtReq)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoUpdateCntxt *chCntxtReq
               ));     

/* MGT Update context primitive used by user */
typedef S16 (*MgtMgcoUpdCtxtInd)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoUpdateCntxt *chCntxtInd
               ));     

/* MGT Error primitive used by User to send error action and txn replies */
typedef S16 (*MgtMgcoErrReq)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoInd *errRsp 
               ));     
 
/* MGT Error primitive used by provider to send txn status */
typedef S16 (*MgtMgcoTxnStaInd)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoInd *chTxnStaInd
               ));     

/* mgt_x_006.main_12: CH-Module Redesign changes */
/* MGT End of Action primitive used by User to send End of Action replies */
typedef S16 (*MgtMgcoAxnReq)   ARGS((  
               Pst *pst,
               SpId spId,
               MgMgcoCtxt *chCtxt
               ));     

#endif /* GCP_CH */
 
/* typedefs for primitives */
typedef S16 (*MgtBndReq)       ARGS((
        Pst *pst, 
        SuId suId, 
        SpId spId
        ));

typedef S16 (*MgtUbndReq)      ARGS((
        Pst *pst, 
        SpId spId, 
        Reason reason
        ));
typedef S16 (*MgtBndCfm)       ARGS((
        Pst *pst, 
        SuId suId, 
        U8 status
        ));
typedef S16 (*MgtCntrlReq)     ARGS((
        Pst *pst,
        SpId spId, 
        MgMgtCntrl *cntrl
        ));
typedef S16 (*MgtCntrlCfm)     ARGS((
        Pst *pst,
        SpId spId, 
        MgMgtCntrl *cntrl, 
        Reason reason
        ));
typedef S16 (*MgtAuditReq)     ARGS((
        Pst *pst,
        SpId spId, 
        MgMgtAudit *audit
        ));
typedef S16 (*MgtAuditCfm)     ARGS((
        Pst *pst,
        SpId spId, 
        MgMgtAudit *audit, 
        Reason reason
        ));
typedef S16 (*MgtStaInd)       ARGS((
        Pst *pst, 
        SpId spId, 
        MgMgtSta *sta
        ));

#ifdef GCP_MGCP
typedef S16 (*MgtMgcpTxnReq)   ARGS((
        Pst *pst, 
        SpId spId, 
        MgMgcpTxn *mgTxn
        ));
typedef S16 (*MgtMgcpTxnInd)   ARGS((
        Pst *pst, 
        SuId suId, 
        MgMgcpTxn *mgTxn
        ));
#endif /* GCP_MGCP */

#ifdef GCP_MGCO
typedef S16 (*MgtMgcoTxnReq)   ARGS((
        Pst *pst, 
        SpId spId, 
        MgMgcoMsg *mgTxn
        ));
typedef S16 (*MgtMgcoTxnInd)   ARGS((
        Pst *pst, 
        SuId suId, 
        MgMgcoMsg *mgTxn
        ));
#endif /* GCP_MGCO */


PUBLIC S16 cmPkTknPkgId ARGS((TknPkgId *tknPkgId, Buffer *mBuf));
PUBLIC S16 cmUnpkTknPkgId ARGS((TknPkgId *tknPkgId, Buffer *mBuf));

EXTERN S16 cmPkMgLclErr ARGS((MgLclErr *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgLclErr ARGS((MgLclErr *param, Buffer *mBuf));
EXTERN S16 cmPkMgDName    ARGS((MgDName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgDName  ARGS((MgDName *param, Buffer *mBuf));
#if(  defined(  GCP_MGCO)  || defined(  TDS_ROLL_UPGRADE_SUPPORT) ) 

EXTERN S16 cmPkMgMgcoMidStr ARGS((MgMgcoMidStr *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoMidStr ARGS((MgMgcoMidStr *param, Buffer *mBuf));
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */
EXTERN S16 cmPkMgPeerInfo     ARGS((MgPeerInfo *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerInfo   ARGS((MgPeerInfo *param, Buffer *mBuf));
EXTERN S16 cmPkMgTransInfo    ARGS((MgTransInfo *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTransInfo  ARGS((MgTransInfo *param, Buffer *mBuf));

EXTERN S16 cmPkMgMoveTransInfo ARGS((MgMoveTransInfo *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgMoveTransInfo ARGS((MgMoveTransInfo *param, Buffer *mBuf));
EXTERN S16 cmPkMgMgtCntrl        ARGS((MgMgtCntrl *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgtCntrl      ARGS((MgMgtCntrl *param, Buffer *mBuf));
EXTERN S16 cmPkMgTransStatus     ARGS((MgTransStatus *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTransStatus   ARGS((MgTransStatus *param, Buffer *mBuf));
EXTERN S16 cmPkMgAuditInfo       ARGS((MgAuditInfo *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgAuditInfo     ARGS((MgAuditInfo *param, Buffer *mBuf));
EXTERN S16 cmPkMgMgtAudit        ARGS((MgMgtAudit *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgtAudit      ARGS((MgMgtAudit *param, Buffer *mBuf));
#ifdef GCP_MGCP
EXTERN S16 cmPkMgPkgName         ARGS((MgPkgName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPkgName       ARGS((MgPkgName *param, Ptr ptr,
                                       Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgConnModVal      ARGS((MgConnModVal *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgConnModVal    ARGS((MgConnModVal *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgConnModeX       ARGS((MgConnModeX *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgConnModeX     ARGS((MgConnModeX *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgConnMode        ARGS((MgConnMode *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgConnMode      ARGS((MgConnMode *param, Ptr ptr,
                                       Buffer *mBuf));
#else
#endif
EXTERN S16 cmPkMgQuoteStr        ARGS((MgQuoteStr *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgQuoteStr      ARGS((MgQuoteStr *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgEvntParamType   ARGS((MgEvntParamType *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgEvntParamType ARGS((MgEvntParamType *param, Ptr ptr,
                                       Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgMgcpExtValSet   ARGS((MgMgcpExtValSet *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpExtValSet ARGS((MgMgcpExtValSet *param, Ptr ptr,
                                       Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgNonStdExtn      ARGS((MgNonStdExtn *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgNonStdExtn    ARGS((MgNonStdExtn *param, Ptr ptr,
                                       Buffer *mBuf));
#else
EXTERN S16 cmPkMgNonStdExtn      ARGS((MgNonStdExtn *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgNonStdExtn    ARGS((MgNonStdExtn *param, Ptr ptr,
                                       Buffer *mBuf));
#endif
EXTERN S16 cmPkMgEPName          ARGS((MgEPName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgEPName        ARGS((MgEPName *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgMgcpVer         ARGS((MgMgcpVer *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpVer       ARGS((MgMgcpVer *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgMgcpVerSet      ARGS((MgMgcpVerSet *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpVerSet    ARGS((MgMgcpVerSet *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgMgcpCmdLine     ARGS((MgMgcpCmdLine *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpCmdLine   ARGS((MgMgcpCmdLine *param, Ptr ptr,
                                       Buffer *mBuf));
EXTERN S16 cmPkMgRspAck          ARGS((MgRspAck *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgRspAck        ARGS((MgRspAck *param, Buffer *mBuf));
EXTERN S16 cmPkMgRspAckSet       ARGS((MgRspAckSet *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgRspAckSet     ARGS((MgRspAckSet *param, Ptr ptr,
                                       Buffer *mBuf));
#ifdef GCP_2705BIS
#endif
#ifdef GCP_2705BIS

EXTERN S16 cmPkMgEvntParamTypeSet ARGS((MgEvntParamTypeSet *param,
                                        Buffer *mBuf));

EXTERN S16 cmUnpkMgEvntParamTypeSet ARGS((MgEvntParamTypeSet *param, Ptr ptr,
                                          Buffer *mBuf));
#else
EXTERN S16 cmPkMgEvntParamTypeSet   ARGS((MgEvntParamTypeSet *param,
                                          Buffer *mBuf));
EXTERN S16 cmUnpkMgEvntParamTypeSet ARGS((MgEvntParamTypeSet *param, Ptr ptr,
                                          Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgMgcpName           ARGS((MgMgcpName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpName         ARGS((MgMgcpName *param, Ptr ptr,
                                          Buffer *mBuf));

EXTERN S16 cmPkMgEvntOneParamTypeVal ARGS((MgEvntOneParamTypeVal *param,
                                           Buffer *mBuf));

EXTERN S16 cmUnpkMgEvntOneParamTypeVal ARGS((MgEvntOneParamTypeVal *param,
                                             Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkMgEvntParamTypeValSet   ARGS((MgEvntParamTypeValSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgEvntParamTypeValSet ARGS((MgEvntParamTypeValSet *param,
                                             Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkMgEvntOneParamType      ARGS((MgEvntOneParamType *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgEvntOneParamType    ARGS((MgEvntOneParamType *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpPkgSpcExtn        ARGS((MgMgcpPkgSpcExtn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpPkgSpcExtn      ARGS((MgMgcpPkgSpcExtn *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpOthExtn           ARGS((MgMgcpOthExtn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpOthExtn         ARGS((MgMgcpOthExtn *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpExtn              ARGS((MgMgcpExtn *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpExtn            ARGS((MgMgcpExtn *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpPkgSpcExtnParam   ARGS((MgMgcpPkgSpcExtnParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpPkgSpcExtnParam ARGS((MgMgcpPkgSpcExtnParam *param,
                                             Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkMgNonStdExtnParam       ARGS((MgNonStdExtnParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgNonStdExtnParam     ARGS((MgNonStdExtnParam *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpExtnParam         ARGS((MgMgcpExtnParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpExtnParam       ARGS((MgMgcpExtnParam *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpBrrAttr           ARGS((MgMgcpBrrAttr *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpBrrAttr         ARGS((MgMgcpBrrAttr *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgBearerInfo            ARGS((MgBearerInfo *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgBearerInfo          ARGS((MgBearerInfo *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgBearerInfo            ARGS((MgBearerInfo *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgBearerInfo          ARGS((MgBearerInfo *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgConnIdSet             ARGS((MgConnIdSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgConnIdSet           ARGS((MgConnIdSet *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgNtfiedEnt             ARGS((MgNtfiedEnt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgNtfiedEnt           ARGS((MgNtfiedEnt *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgNtfiedEnt             ARGS((MgNtfiedEnt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgNtfiedEnt           ARGS((MgNtfiedEnt *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgSuppPkgs              ARGS((MgSuppPkgs *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSuppPkgs            ARGS((MgSuppPkgs *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgSuppModes             ARGS((MgSuppModes *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgSuppModes           ARGS((MgSuppModes *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgSuppModes             ARGS((MgSuppModes *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgSuppModes           ARGS((MgSuppModes *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgEncryptInfo           ARGS((MgEncryptInfo *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgEncryptInfo         ARGS((MgEncryptInfo *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgGainCtrl              ARGS((MgGainCtrl *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgGainCtrl            ARGS((MgGainCtrl *param, Buffer *mBuf));
EXTERN S16 cmPkMgAlgoNameSet           ARGS((MgAlgoNameSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgAlgoNameSet         ARGS((MgAlgoNameSet *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgBw                    ARGS((MgBw *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgBw                  ARGS((MgBw *param, Buffer *mBuf));
EXTERN S16 cmPkMgPktzPeriod            ARGS((MgPktzPeriod *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgPktzPeriod          ARGS((MgPktzPeriod *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgRsvDest               ARGS((MgRsvDest *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgRsvDest             ARGS((MgRsvDest *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgSecret                ARGS((MgSecret *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSecret              ARGS((MgSecret *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgAuthEncAlgoSet        ARGS((MgAuthEncAlgoSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgAuthEncAlgoSet      ARGS((MgAuthEncAlgoSet *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgCipherSuite           ARGS((MgCipherSuite *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgCipherSuite         ARGS((MgCipherSuite *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgRsrcRsvSet            ARGS((MgRsrcRsvSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRsrcRsvSet          ARGS((MgRsrcRsvSet *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgTypNwSupp             ARGS((MgTypNwSupp *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgTypNwSupp           ARGS((MgTypNwSupp *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgTypNwSuppSeq          ARGS((MgTypNwSuppSeq *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgTypNwSuppSeq        ARGS((MgTypNwSuppSeq *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgNwTypeChc             ARGS((MgNwTypeChc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgNwTypeChc           ARGS((MgNwTypeChc *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgMgcpLclFmtpVal        ARGS((MgMgcpLclFmtpVal *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpLclFmtpVal      ARGS((MgMgcpLclFmtpVal *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpLclFmtpValSet     ARGS((MgMgcpLclFmtpValSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpLclFmtpValSet   ARGS((MgMgcpLclFmtpValSet *param,
                                             Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkMgMgcpLclRsSh           ARGS((MgMgcpLclRsSh *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpLclRsSh         ARGS((MgMgcpLclRsSh *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgLclConnOpts           ARGS((MgLclConnOpts *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgLclConnOpts         ARGS((MgLclConnOpts *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgLclConnOptSet         ARGS((MgLclConnOptSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgLclConnOptSet       ARGS((MgLclConnOptSet *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgEventDesc             ARGS((MgEventDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgEventDesc           ARGS((MgEventDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgEvntName              ARGS((MgEvntName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgEvntName            ARGS((MgEvntName *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgSignalRqst            ARGS((MgSignalRqst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgSignalRqst          ARGS((MgSignalRqst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgSignalRqstSet         ARGS((MgSignalRqstSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgSignalRqstSet       ARGS((MgSignalRqstSet *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_MGCP_PARSE_DIG_MAP
#else
EXTERN S16 cmPkMgDgtMap                ARGS((MgDgtMap *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgDgtMap              ARGS((MgDgtMap *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgRqstdActnSet          ARGS((MgRqstdActnSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdActnSet        ARGS((MgRqstdActnSet *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgRqstdEvntSeq          ARGS((MgRqstdEvntSeq *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdEvntSeq        ARGS((MgRqstdEvntSeq *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgRqstdEvntSet          ARGS((MgRqstdEvntSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdEvntSet        ARGS((MgRqstdEvntSet *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgRqstdEvntSet          ARGS((MgRqstdEvntSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdEvntSet        ARGS((MgRqstdEvntSet *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgRqstEmbedType         ARGS((MgRqstEmbedType *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstEmbedType       ARGS((MgRqstEmbedType *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgEmbedActn             ARGS((MgEmbedActn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgEmbedActn           ARGS((MgEmbedActn *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgRqstEmbedMDCXMode     ARGS((MgRqstEmbedMDCXMode *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstEmbedMDCXMode   ARGS((MgRqstEmbedMDCXMode *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgEmbedMDCX             ARGS((MgEmbedMDCX *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgEmbedMDCX           ARGS((MgEmbedMDCX *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgAction                ARGS((MgAction *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgAction              ARGS((MgAction *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgPkgXActn              ARGS((MgPkgXActn *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPkgXActn            ARGS((MgPkgXActn *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgRqstdActn             ARGS((MgRqstdActn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdActn           ARGS((MgRqstdActn *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgRqstdActn             ARGS((MgRqstdActn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdActn           ARGS((MgRqstdActn *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgRqstdEvnt             ARGS((MgRqstdEvnt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdEvnt           ARGS((MgRqstdEvnt *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgPkgCPName             ARGS((MgPkgCPName *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgPkgCPName           ARGS((MgPkgCPName *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgPkgCPXNm              ARGS((MgPkgCPXNm *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPkgCPXNm            ARGS((MgPkgCPXNm *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgCPName                ARGS((MgCPName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgCPName              ARGS((MgCPName *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgConnParExtn           ARGS((MgConnParExtn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgConnParExtn         ARGS((MgConnParExtn *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgConnParam             ARGS((MgConnParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgConnParam           ARGS((MgConnParam *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgConnParam             ARGS((MgConnParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgConnParam           ARGS((MgConnParam *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgConnParamSet          ARGS((MgConnParamSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgConnParamSet        ARGS((MgConnParamSet *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgReasonCode            ARGS((MgReasonCode *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgReasonCode          ARGS((MgReasonCode *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgReasonCode            ARGS((MgReasonCode *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgReasonCode          ARGS((MgReasonCode *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkInfoCode                ARGS((InfoCode *param, Buffer *mBuf));
EXTERN S16 cmUnpkInfoCode              ARGS((InfoCode *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgRqstdInfo             ARGS((MgRqstdInfo *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdInfo           ARGS((MgRqstdInfo *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgRqstdInfo             ARGS((MgRqstdInfo *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRqstdInfo           ARGS((MgRqstdInfo *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgQrntHandling          ARGS((MgQrntHandling *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgQrntHandling        ARGS((MgQrntHandling *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgDetectEvent           ARGS((MgDetectEvent *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgDetectEvent         ARGS((MgDetectEvent *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgRsrtMethod            ARGS((MgRsrtMethod *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgRsrtMethod          ARGS((MgRsrtMethod *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgMgcpParamExtn         ARGS((MgMgcpParamExtn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpParamExtn       ARGS((MgMgcpParamExtn *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgMgcpPkgNmVer          ARGS((MgMgcpPkgNmVer *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpPkgNmVer        ARGS((MgMgcpPkgNmVer *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpPkgList           ARGS((MgMgcpPkgList *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpPkgList         ARGS((MgMgcpPkgList *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgMgcpParam             ARGS((MgMgcpParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpParam           ARGS((MgMgcpParam *param, Ptr ptr,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcpParam             ARGS((MgMgcpParam *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpParam           ARGS((MgMgcpParam *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgMgcpParamSet          ARGS((MgMgcpParamSet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpParamSet        ARGS((MgMgcpParamSet *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpCmd               ARGS((MgMgcpCmd *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpCmd             ARGS((MgMgcpCmd *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMsgNonStd             ARGS((MgMsgNonStd *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMsgNonStd           ARGS((MgMsgNonStd *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#ifdef GCP_2705BIS
EXTERN S16 cmPkMgMgcpSdpInfo           ARGS((MgMgcpSdpInfo *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpSdpInfo         ARGS((MgMgcpSdpInfo *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpSdpInfoSet        ARGS((MgMgcpSdpInfoSet *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpSdpInfoSet      ARGS((MgMgcpSdpInfoSet *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcpRsp               ARGS((MgMgcpRsp *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpRsp             ARGS((MgMgcpRsp *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcpRsp               ARGS((MgMgcpRsp *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpRsp             ARGS((MgMgcpRsp *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_PKG_MGCP_BASE
EXTERN S16 cmPkMgMgcpMsg               ARGS((MgMgcpMsg *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpMsg             ARGS((MgMgcpMsg *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else /* GCP_PKG_MGCP_BASE */
EXTERN S16 cmPkMgMgcpMsg               ARGS((MgMgcpMsg *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpMsg             ARGS((MgMgcpMsg *param, Mem *sMem,
                                             Size maxBlkSize, 
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif /* GCP_PKG_MGCP_BASE */
EXTERN S16 cmPkMgMgcpTxn               ARGS((MgMgcpTxn *param, Pst *pst,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcpTxn             ARGS((MgMgcpTxn *param, Mem *sMem,
                                             Size maxBlkSize, Pst *pst,
                                             Buffer *mBuf));
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
#ifdef MGT_MGCO_V2
EXTERN S16 cmPkMgMgcoIndAudPropParm  ARGS((MgMgcoIndAudPropParm *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudPropParm ARGS((MgMgcoIndAudPropParm *param,
                                            Ptr ptr,  Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudStreamMode  ARGS((MgMgcoIndAudStreamMode *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudStreamMode ARGS((MgMgcoIndAudStreamMode *param,
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudLocalParm  ARGS((MgMgcoIndAudLocalParm *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudLocalParm ARGS((MgMgcoIndAudLocalParm *param,
                                             Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudLclCtlDesc  ARGS((MgMgcoIndAudLclCtlDesc *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudLclCtlDesc ARGS((MgMgcoIndAudLclCtlDesc *param,
                                             Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudPropParmLst  ARGS((MgMgcoIndAudPropParmLst *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudPropParmLst ARGS((MgMgcoIndAudPropParmLst *param,
                                             Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudPropGrp  ARGS((MgMgcoIndAudPropGrp *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudPropGrp ARGS((MgMgcoIndAudPropGrp *param,
                                             Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudLocalDesc  ARGS((MgMgcoIndAudLocalDesc *param,
                                            CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudLocalDesc ARGS((MgMgcoIndAudLocalDesc *param,
                                             Ptr ptr, CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudRemoteDesc  ARGS((MgMgcoIndAudRemoteDesc *param,
                                            CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudRemoteDesc ARGS((MgMgcoIndAudRemoteDesc *param,
                                             Ptr ptr, CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudSvcState  ARGS((MgMgcoIndAudSvcState *param,
                                           Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudSvcState ARGS((MgMgcoIndAudSvcState *param,
                                            Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudTermStateParm  ARGS((MgMgcoIndAudTermStateParm *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudTermStateParm ARGS((MgMgcoIndAudTermStateParm *param,
                                              Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudTermStateDesc  ARGS((MgMgcoIndAudTermStateDesc *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudTermStateDesc ARGS((MgMgcoIndAudTermStateDesc *param,
                                              Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudStreamParm  ARGS((MgMgcoIndAudStreamParm *param,
                                             CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudStreamParm ARGS((MgMgcoIndAudStreamParm *param,
                                              Ptr ptr, CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudStreamDesc  ARGS((MgMgcoIndAudStreamDesc *param,
                                             CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudStreamDesc ARGS((MgMgcoIndAudStreamDesc *param,
                                              Ptr ptr, CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudMediaParm  ARGS((MgMgcoIndAudMediaParm *param,
                                             CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudMediaParm ARGS((MgMgcoIndAudMediaParm *param,
                                              Ptr ptr, CmIntfVer intfVer, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudMediaDesc   ARGS((MgMgcoIndAudMediaDesc *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudMediaDesc ARGS((MgMgcoIndAudMediaDesc *param,
                                              Ptr ptr,
                                              CmIntfVer intfVer,
                                              Buffer *mBuf));

#if ((defined(MGT_MGCO_V2) && defined(GCP_ASN)) || defined(GCP_VER_2_1))
EXTERN S16 cmPkMgMgcoIndAudSigPar      ARGS((MgMgcoIndAudSigPar *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudSigPar    ARGS((MgMgcoIndAudSigPar *param,
                                             Ptr ptr,
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudSigParLst   ARGS((MgMgcoIndAudSigParLst *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudSigParLst ARGS((MgMgcoIndAudSigParLst *param,
                                            Ptr ptr, Buffer *mBuf));
#endif /*  (GCP_VER_2_1 && GCP_ASN) || GCP_VER_2_1 */

EXTERN S16 cmPkMgMgcoIndAudSigReq  ARGS((MgMgcoIndAudSigReq *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudSigReq ARGS((MgMgcoIndAudSigReq *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudSigLst  ARGS((MgMgcoIndAudSigLst *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudSigLst ARGS((MgMgcoIndAudSigLst *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudSignalsDesc  ARGS((MgMgcoIndAudSignalsDesc *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudSignalsDesc ARGS((MgMgcoIndAudSignalsDesc *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudEvtsDesc  ARGS((MgMgcoIndAudEvtsDesc *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudEvtsDesc ARGS((MgMgcoIndAudEvtsDesc *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudEventSpecParm  ARGS((MgMgcoIndAudEventSpecParm *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudEventSpecParm ARGS((MgMgcoIndAudEventSpecParm *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudEventSpecParmLst  ARGS((MgMgcoIndAudEventSpecParmLst *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudEventSpecParmLst ARGS((MgMgcoIndAudEventSpecParmLst *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudEvtBufferDesc  ARGS((MgMgcoIndAudEvtBufferDesc *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudEvtBufferDesc ARGS((MgMgcoIndAudEvtBufferDesc *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudDigMapDesc  ARGS((MgMgcoIndAudDigMapDesc *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudDigMapDesc ARGS((MgMgcoIndAudDigMapDesc *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudStatsDesc  ARGS((MgMgcoIndAudStatsDesc *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudStatsDesc ARGS((MgMgcoIndAudStatsDesc *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudPkgsDesc  ARGS((MgMgcoIndAudPkgsDesc *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudPkgsDesc ARGS((MgMgcoIndAudPkgsDesc *param,
                                          Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudAuditRetParm  ARGS((MgMgcoIndAudAuditRetParm *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudAuditRetParm ARGS((MgMgcoIndAudAuditRetParm *param,
                                                Ptr ptr,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));

EXTERN S16 cmPkMgMgcoIndAudTermAudit      ARGS((MgMgcoIndAudTermAudit *param,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoIndAudTermAudit    ARGS((MgMgcoIndAudTermAudit *param,
                                                Ptr ptr,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));

EXTERN S16 cmPkMgMgcoAuditItem            ARGS((MgMgcoAuditItem *param,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAuditItem          ARGS((MgMgcoAuditItem *param,
                                                Ptr ptr,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));

#endif /* MGT_MGCO_V2 */
EXTERN S16 cmPkMgMgcoRequestId         ARGS((MgMgcoRequestId *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoRequestId       ARGS((MgMgcoRequestId *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoContextId         ARGS((MgMgcoContextId *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoContextId       ARGS((MgMgcoContextId *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPathName          ARGS((MgMgcoPathName *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPathName        ARGS((MgMgcoPathName *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTermId            ARGS((MgMgcoTermId *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTermId          ARGS((MgMgcoTermId *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTermIdLst         ARGS((MgMgcoTermIdLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTermIdLst       ARGS((MgMgcoTermIdLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTimeStamp         ARGS((MgMgcoTimeStamp *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTimeStamp       ARGS((MgMgcoTimeStamp *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPkg               ARGS((MgMgcoPkg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPkg             ARGS((MgMgcoPkg *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoName              ARGS((MgMgcoName *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoName            ARGS((MgMgcoName *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPkgdName          ARGS((MgMgcoPkgdName *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPkgdName        ARGS((MgMgcoPkgdName *param, Ptr ptr,
                                             Buffer *mBuf));
/* mgt_x_005.main_12: Added extern definitions of propparm packing/unpacking 
 * functions for ASN */
#ifdef GCP_ASN
EXTERN S16 cmPkMgMgcoUnknPkgdName      ARGS((MgMgcoPkgdName *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoUnknPkgdName    ARGS((MgMgcoPkgdName *param, Ptr ptr,
                                             Buffer *mBuf));
#endif /* GCP_ASN */
EXTERN S16 cmPkMgMgcoSigName           ARGS((MgMgcoSigName *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSigName         ARGS((MgMgcoSigName *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSigLst            ARGS((MgMgcoSigLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSigLst          ARGS((MgMgcoSigLst *param, Ptr ptr,
                                             Buffer *mBuf));
#if(  defined(  GCP_PKG_MGCO_ADVAUSRVRBASE)  || defined(  GCP_PKG_MGCO_AASDIGCOLLECT)  || defined(  GCP_PKG_MGCO_AASRECODING)  || defined(  GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) ) 
EXTERN S16 cmPkMgMgcoFileUrl           ARGS((MgMgcoFileUrl *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoFileUrl         ARGS((MgMgcoFileUrl *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoHostPort          ARGS((MgMgcoHostPort *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoHostPort        ARGS((MgMgcoHostPort *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoUsrPw             ARGS((MgMgcoUsrPw *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoUsrPw           ARGS((MgMgcoUsrPw *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoLogin             ARGS((MgMgcoLogin *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoLogin           ARGS((MgMgcoLogin *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPathType          ARGS((MgMgcoPathType *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPathType        ARGS((MgMgcoPathType *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoFtpUrl            ARGS((MgMgcoFtpUrl *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoFtpUrl          ARGS((MgMgcoFtpUrl *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPathSearch        ARGS((MgMgcoPathSearch *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPathSearch      ARGS((MgMgcoPathSearch *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoHttpUrl           ARGS((MgMgcoHttpUrl *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoHttpUrl         ARGS((MgMgcoHttpUrl *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoProvSegSpec       ARGS((MgMgcoProvSegSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoProvSegSpec     ARGS((MgMgcoProvSegSpec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTodSpec           ARGS((MgMgcoTodSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTodSpec         ARGS((MgMgcoTodSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDateSpec          ARGS((MgMgcoDateSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDateSpec        ARGS((MgMgcoDateSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMoneySpec         ARGS((MgMgcoMoneySpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMoneySpec       ARGS((MgMgcoMoneySpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoIntSpec           ARGS((MgMgcoIntSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoIntSpec         ARGS((MgMgcoIntSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoVvarSpec          ARGS((MgMgcoVvarSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoVvarSpec        ARGS((MgMgcoVvarSpec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSelType           ARGS((MgMgcoSelType *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSelType         ARGS((MgMgcoSelType *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSelSpecLst        ARGS((MgMgcoSelSpecLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSelSpecLst      ARGS((MgMgcoSelSpecLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSelList           ARGS((MgMgcoSelList *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSelList         ARGS((MgMgcoSelList *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoVarSegSpec        ARGS((MgMgcoVarSegSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoVarSegSpec      ARGS((MgMgcoVarSegSpec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSpec              ARGS((MgMgcoSpec *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSpec            ARGS((MgMgcoSpec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSegSpec           ARGS((MgMgcoSegSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSegSpec         ARGS((MgMgcoSegSpec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAnncSpec          ARGS((MgMgcoAnncSpec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAnncSpec        ARGS((MgMgcoAnncSpec *param, Ptr ptr,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgMgcoValue             ARGS((MgMgcoValue *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoValue           ARGS((MgMgcoValue *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAuthHdr           ARGS((MgMgcoAuthHdr *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAuthHdr         ARGS((MgMgcoAuthHdr *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDomAddrPort       ARGS((MgMgcoDomAddrPort *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDomAddrPort     ARGS((MgMgcoDomAddrPort *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDomNamePort       ARGS((MgMgcoDomNamePort *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDomNamePort     ARGS((MgMgcoDomNamePort *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMid               ARGS((MgMgcoMid *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMid             ARGS((MgMgcoMid *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoErrDesc           ARGS((MgMgcoErrDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoErrDesc         ARGS((MgMgcoErrDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTopoDesc          ARGS((MgMgcoTopoDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTopoDesc        ARGS((MgMgcoTopoDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTopoDescLst       ARGS((MgMgcoTopoDescLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTopoDescLst     ARGS((MgMgcoTopoDescLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoContextProps      ARGS((MgMgcoContextProps *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoContextProps    ARGS((MgMgcoContextProps *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoContextAudit      ARGS((MgMgcoContextAudit *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoContextAudit    ARGS((MgMgcoContextAudit *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoValLst            ARGS((MgMgcoValLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoValLst          ARGS((MgMgcoValLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoValRng            ARGS((MgMgcoValRng *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoValRng          ARGS((MgMgcoValRng *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoParmValue         ARGS((MgMgcoParmValue *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoParmValue       ARGS((MgMgcoParmValue *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPropParm          ARGS((MgMgcoPropParm *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPropParm        ARGS((MgMgcoPropParm *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPropParmLst       ARGS((MgMgcoPropParmLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPropParmLst     ARGS((MgMgcoPropParmLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoLocalParm         ARGS((MgMgcoLocalParm *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoLocalParm       ARGS((MgMgcoLocalParm *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoLclCtlDesc        ARGS((MgMgcoLclCtlDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoLclCtlDesc      ARGS((MgMgcoLclCtlDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPropGrpLst        ARGS((MgMgcoPropGrpLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPropGrpLst      ARGS((MgMgcoPropGrpLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoLocalDesc         ARGS((MgMgcoLocalDesc *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoLocalDesc       ARGS((MgMgcoLocalDesc *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTermStateParm     ARGS((MgMgcoTermStateParm *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTermStateParm   ARGS((MgMgcoTermStateParm *param,
                                             Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTermStateDesc     ARGS((MgMgcoTermStateDesc *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTermStateDesc   ARGS((MgMgcoTermStateDesc *param,
                                             Ptr ptr, CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoStreamParm        ARGS((MgMgcoStreamParm *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoStreamParm      ARGS((MgMgcoStreamParm *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoStreamDesc        ARGS((MgMgcoStreamDesc *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoStreamDesc      ARGS((MgMgcoStreamDesc *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMediaPar          ARGS((MgMgcoMediaPar *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMediaPar        ARGS((MgMgcoMediaPar *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMediaDesc         ARGS((MgMgcoMediaDesc *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMediaDesc       ARGS((MgMgcoMediaDesc *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoH221NonStd        ARGS((MgMgcoH221NonStd *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoH221NonStd      ARGS((MgMgcoH221NonStd *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoNonStdId          ARGS((MgMgcoNonStdId *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoNonStdId        ARGS((MgMgcoNonStdId *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoModemType         ARGS((MgMgcoModemType *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoModemType       ARGS((MgMgcoModemType *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoModemTypeLst      ARGS((MgMgcoModemTypeLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoModemTypeLst    ARGS((MgMgcoModemTypeLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoNonStdExtn        ARGS((MgMgcoNonStdExtn *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoNonStdExtn      ARGS((MgMgcoNonStdExtn *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoModemDesc         ARGS((MgMgcoModemDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoModemDesc       ARGS((MgMgcoModemDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMuxDesc           ARGS((MgMgcoMuxDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMuxDesc         ARGS((MgMgcoMuxDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtOther          ARGS((MgMgcoEvtOther *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtOther        ARGS((MgMgcoEvtOther *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoNtfyCmpl          ARGS((MgMgcoNtfyCmpl *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoNtfyCmpl        ARGS((MgMgcoNtfyCmpl *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSigPar            ARGS((MgMgcoSigPar *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSigPar          ARGS((MgMgcoSigPar *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSigParLst         ARGS((MgMgcoSigParLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSigParLst       ARGS((MgMgcoSigParLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSignalsReq        ARGS((MgMgcoSignalsReq *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSignalsReq      ARGS((MgMgcoSignalsReq *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSignalsReqLst     ARGS((MgMgcoSignalsReqLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSignalsReqLst   ARGS((MgMgcoSignalsReqLst *param,
                                             Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSignalsLst        ARGS((MgMgcoSignalsLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSignalsLst      ARGS((MgMgcoSignalsLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSignalsParm       ARGS((MgMgcoSignalsParm *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSignalsParm     ARGS((MgMgcoSignalsParm *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSignalsDesc       ARGS((MgMgcoSignalsDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSignalsDesc     ARGS((MgMgcoSignalsDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigRng            ARGS((MgMgcoDigRng *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigRng          ARGS((MgMgcoDigRng *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigMapLet         ARGS((MgMgcoDigMapLet *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigMapLet       ARGS((MgMgcoDigMapLet *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigMapRng         ARGS((MgMgcoDigMapRng *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigMapRng       ARGS((MgMgcoDigMapRng *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigStrElem        ARGS((MgMgcoDigStrElem *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigStrElem      ARGS((MgMgcoDigStrElem *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigStr            ARGS((MgMgcoDigStr *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigStr          ARGS((MgMgcoDigStr *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigMap            ARGS((MgMgcoDigMap *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigMap          ARGS((MgMgcoDigMap *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigMapVal         ARGS((MgMgcoDigMapVal *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigMapVal       ARGS((MgMgcoDigMapVal *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtDM             ARGS((MgMgcoEvtDM *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtDM           ARGS((MgMgcoEvtDM *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtParSec         ARGS((MgMgcoEvtParSec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtParSec       ARGS((MgMgcoEvtParSec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtParSecLst      ARGS((MgMgcoEvtParSecLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtParSecLst    ARGS((MgMgcoEvtParSecLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtSec            ARGS((MgMgcoEvtSec *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtSec          ARGS((MgMgcoEvtSec *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtSecLst         ARGS((MgMgcoEvtSecLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtSecLst       ARGS((MgMgcoEvtSecLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEmbedFirst        ARGS((MgMgcoEmbedFirst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEmbedFirst      ARGS((MgMgcoEmbedFirst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEmbWithSig        ARGS((MgMgcoEmbWithSig *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEmbWithSig      ARGS((MgMgcoEmbWithSig *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtPar            ARGS((MgMgcoEvtPar *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtPar          ARGS((MgMgcoEvtPar *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtParLst         ARGS((MgMgcoEvtParLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtParLst       ARGS((MgMgcoEvtParLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoReqEvt            ARGS((MgMgcoReqEvt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoReqEvt          ARGS((MgMgcoReqEvt *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvtLst            ARGS((MgMgcoEvtLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvtLst          ARGS((MgMgcoEvtLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoReqEvtDesc        ARGS((MgMgcoReqEvtDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoReqEvtDesc      ARGS((MgMgcoReqEvtDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoEvBufDesc         ARGS((MgMgcoEvBufDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoEvBufDesc       ARGS((MgMgcoEvBufDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoDigMapDesc        ARGS((MgMgcoDigMapDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoDigMapDesc      ARGS((MgMgcoDigMapDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAuditDesc         ARGS((MgMgcoAuditDesc *param,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAuditDesc       ARGS((MgMgcoAuditDesc *param, Ptr ptr,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAmmDesc           ARGS((MgMgcoAmmDesc *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAmmDesc         ARGS((MgMgcoAmmDesc *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAmmDescLst        ARGS((MgMgcoAmmDescLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAmmDescLst      ARGS((MgMgcoAmmDescLst *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAmmReq            ARGS((MgMgcoAmmReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAmmReq          ARGS((MgMgcoAmmReq *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSubAudReq         ARGS((MgMgcoSubAudReq *param,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSubAudReq       ARGS((MgMgcoSubAudReq *param, Ptr ptr,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmPkMgMgcoObsEvt            ARGS((MgMgcoObsEvt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoObsEvt          ARGS((MgMgcoObsEvt *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoObsEvtLst         ARGS((MgMgcoObsEvtLst *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoObsEvtLst       ARGS((MgMgcoObsEvtLst *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoObsEvtDesc        ARGS((MgMgcoObsEvtDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoObsEvtDesc      ARGS((MgMgcoObsEvtDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoNtfyReq           ARGS((MgMgcoNtfyReq *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoNtfyReq         ARGS((MgMgcoNtfyReq *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgMethod      ARGS((MgMgcoSvcChgMethod *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgMethod    ARGS((MgMgcoSvcChgMethod *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgProf        ARGS((MgMgcoSvcChgProf *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgProf      ARGS((MgMgcoSvcChgProf *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgPar         ARGS((MgMgcoSvcChgPar *param,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgPar       ARGS((MgMgcoSvcChgPar *param, Ptr ptr,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgReq         ARGS((MgMgcoSvcChgReq *param,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgReq       ARGS((MgMgcoSvcChgReq *param, Ptr ptr,
                                             CmIntfVer intfVer, Buffer *mBuf));
EXTERN S16 cmPkMgMgcoCmd               ARGS((MgMgcoCmd *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmd             ARGS((MgMgcoCmd *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoCommandReq        ARGS((MgMgcoCommandReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCommandReq      ARGS((MgMgcoCommandReq *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoCommandReq        ARGS((MgMgcoCommandReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCommandReq      ARGS((MgMgcoCommandReq *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoCmdReqLst         ARGS((MgMgcoCmdReqLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmdReqLst       ARGS((MgMgcoCmdReqLst *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoCmdReqLst         ARGS((MgMgcoCmdReqLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmdReqLst       ARGS((MgMgcoCmdReqLst *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoActionReq         ARGS((MgMgcoActionReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActionReq       ARGS((MgMgcoActionReq *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoActionReq         ARGS((MgMgcoActionReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActionReq       ARGS((MgMgcoActionReq *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoActionLst         ARGS((MgMgcoActionLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActionLst       ARGS((MgMgcoActionLst *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoActionLst         ARGS((MgMgcoActionLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActionLst       ARGS((MgMgcoActionLst *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoTxnReq            ARGS((MgMgcoTxnReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnReq          ARGS((MgMgcoTxnReq *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoTxnReq            ARGS((MgMgcoTxnReq *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnReq          ARGS((MgMgcoTxnReq *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgMgcoStatsPar          ARGS((MgMgcoStatsPar *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoStatsPar        ARGS((MgMgcoStatsPar *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoStatsDesc         ARGS((MgMgcoStatsDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoStatsDesc       ARGS((MgMgcoStatsDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPkgsItem          ARGS((MgMgcoPkgsItem *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPkgsItem        ARGS((MgMgcoPkgsItem *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoPkgsDesc          ARGS((MgMgcoPkgsDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoPkgsDesc        ARGS((MgMgcoPkgsDesc *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAudRetParm        ARGS((MgMgcoAudRetParm *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAudRetParm      ARGS((MgMgcoAudRetParm *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTermAuditRes      ARGS((MgMgcoTermAuditRes *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTermAuditRes    ARGS((MgMgcoTermAuditRes *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAmmsReply         ARGS((MgMgcoAmmsReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAmmsReply       ARGS((MgMgcoAmmsReply *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAuditOther        ARGS((MgMgcoAuditOther *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAuditOther      ARGS((MgMgcoAuditOther *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoAuditReply        ARGS((MgMgcoAuditReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoAuditReply      ARGS((MgMgcoAuditReply *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoNtfyReply         ARGS((MgMgcoNtfyReply *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoNtfyReply       ARGS((MgMgcoNtfyReply *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgResPar      ARGS((MgMgcoSvcChgResPar *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgResPar    ARGS((MgMgcoSvcChgResPar *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgRes         ARGS((MgMgcoSvcChgRes *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgRes       ARGS((MgMgcoSvcChgRes *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoSvcChgReply       ARGS((MgMgcoSvcChgReply *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSvcChgReply     ARGS((MgMgcoSvcChgReply *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoCmdReply          ARGS((MgMgcoCmdReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmdReply        ARGS((MgMgcoCmdReply *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoCmdReply          ARGS((MgMgcoCmdReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmdReply        ARGS((MgMgcoCmdReply *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoCmdReplyLst       ARGS((MgMgcoCmdReplyLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmdReplyLst     ARGS((MgMgcoCmdReplyLst *param,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoCmdReplyLst       ARGS((MgMgcoCmdReplyLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCmdReplyLst     ARGS((MgMgcoCmdReplyLst *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoCxtCmdReply       ARGS((MgMgcoCxtCmdReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCxtCmdReply     ARGS((MgMgcoCxtCmdReply *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoCxtCmdReply       ARGS((MgMgcoCxtCmdReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCxtCmdReply     ARGS((MgMgcoCxtCmdReply *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoErrCmdRepSet      ARGS((MgMgcoErrCmdRepSet *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoErrCmdRepSet    ARGS((MgMgcoErrCmdRepSet *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoErrCmdRepSet      ARGS((MgMgcoErrCmdRepSet *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoErrCmdRepSet    ARGS((MgMgcoErrCmdRepSet *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoActnReply         ARGS((MgMgcoActnReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActnReply       ARGS((MgMgcoActnReply *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoActnReply         ARGS((MgMgcoActnReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActnReply       ARGS((MgMgcoActnReply *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoActnReplyLst      ARGS((MgMgcoActnReplyLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActnReplyLst    ARGS((MgMgcoActnReplyLst *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoActnReplyLst      ARGS((MgMgcoActnReplyLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoActnReplyLst    ARGS((MgMgcoActnReplyLst *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoTxnReply          ARGS((MgMgcoTxnReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnReply        ARGS((MgMgcoTxnReply *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoTxnReply          ARGS((MgMgcoTxnReply *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnReply        ARGS((MgMgcoTxnReply *param, Ptr ptr,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgMgcoTxnPend           ARGS((MgMgcoTxnPend *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnPend         ARGS((MgMgcoTxnPend *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTxnAck            ARGS((MgMgcoTxnAck *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnAck          ARGS((MgMgcoTxnAck *param,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoTxnRspAck         ARGS((MgMgcoTxnRspAck *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnRspAck       ARGS((MgMgcoTxnRspAck *param, Ptr ptr,
                                             Buffer *mBuf));
#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoTxn               ARGS((MgMgcoTxn *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxn             ARGS((MgMgcoTxn *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#else
EXTERN S16 cmPkMgMgcoTxn               ARGS((MgMgcoTxn *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxn             ARGS((MgMgcoTxn *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
#endif
EXTERN S16 cmPkMgMgcoTxnLst            ARGS((MgMgcoTxnLst *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoTxnLst          ARGS((MgMgcoTxnLst *param, Mem *sMem,
                                             Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMsgBody           ARGS((MgMgcoMsgBody *param,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMsgBody         ARGS((MgMgcoMsgBody *param, Ptr ptr,
                                             Mem *sMem, Size maxBlkSize,
                                             CmIntfVer intfVer,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoMsg               ARGS((MgMgcoMsg *param, Pst *pst,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoMsg             ARGS((MgMgcoMsg *param, Mem *sMem,
                                             Size maxBlkSize, Pst *pst,
                                             Buffer *mBuf));
#endif /* GCP_MGCO */
EXTERN S16 cmPkMgMgtSta                ARGS((MgMgtSta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgtSta              ARGS((MgMgtSta *param, Buffer *mBuf));

#ifdef GCP_MGCO
#if ((defined GCP_VER_2_1) && (defined GCP_MG))
EXTERN S16 cmPkMgMgcoProf              ARGS((MgMgcoProf *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoProf            ARGS((MgMgcoProf *param, Buffer *mBuf));
#endif
#endif  /* GCP_MGCO */

#ifdef GCP_CH
EXTERN S16 cmPkMgMgcoCommand           ARGS((MgMgcoCommand *param, Pst *pst,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCommand         ARGS((MgMgcoCommand *param, Mem *sMem,
                                             Size maxBlkSize, Pst *pst,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoChCntxt           ARGS((MgMgcoChCntxt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoChCntxt         ARGS((MgMgcoChCntxt *param, Ptr ptr,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoUpdateCntxt       ARGS((MgMgcoUpdateCntxt *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoUpdateCntxt     ARGS((MgMgcoUpdateCntxt *param,
                                             Mem *sMem, Size maxBlkSize,
                                             Buffer *mBuf));
EXTERN S16 cmPkMgMgcoInd               ARGS((MgMgcoInd *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoInd             ARGS((MgMgcoInd *param, Mem *sMem,
                                             Size maxBlkSize, Buffer *mBuf));  

/* mgt_x_006.main_12: CH-Module Redesign changes */
EXTERN S16 cmPkMgMgcoCtxt              ARGS((MgMgcoCtxt *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCtxt            ARGS((MgMgcoCtxt *param, Mem *sMem,
                                             Size maxBlkSize, Buffer *mBuf));  

#endif /* GCP_CH */
#ifdef GCP_MGCP
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
#endif /* GCP_MGCO */
 
/***********************************************************************
             MGT interface primitive definition
 ***********************************************************************/

#ifdef MG

EXTERN S16 MgUiMgtBndReq       ARGS((Pst *pst, SuId suId, SpId spId));
EXTERN S16 MgUiMgtUbndReq      ARGS((Pst *pst,SpId spId, Reason reason));
EXTERN S16 MgUiMgtBndCfm       ARGS((Pst *pst, SuId suId, U8 status));
EXTERN S16 MgUiMgtCntrlReq     ARGS((Pst *pst,SpId spId, MgMgtCntrl *cntrl));
EXTERN S16 MgUiMgtCntrlCfm     ARGS((Pst *pst,SuId suId, MgMgtCntrl *cntrl, 
                                     Reason reason));
EXTERN S16 MgUiMgtAuditReq     ARGS((Pst *pst,SpId spId, MgMgtAudit *audit));
EXTERN S16 MgUiMgtAuditCfm     ARGS((Pst *pst,SuId suId, MgMgtAudit *audit, 
                                     Reason reason));
EXTERN S16 MgUiMgtStaInd   ARGS((Pst *pst, SpId spId, MgMgtSta *sta));

#ifdef GCP_MGCP
EXTERN S16 MgUiMgtMgcpTxnReq   ARGS((Pst *pst, SpId spId, MgMgcpTxn *mgTxn));
EXTERN S16 MgUiMgtMgcpTxnInd   ARGS((Pst *pst, SpId spId, MgMgcpTxn *mgTxn));
#endif /* GCP_MGCP */

#ifdef GCP_MGCO
EXTERN S16 MgUiMgtMgcoTxnReq   ARGS((Pst *pst, SpId spId, MgMgcoMsg *mgTxn));
EXTERN S16 MgUiMgtMgcoTxnInd   ARGS((Pst *pst, SpId spId, MgMgcoMsg *mgTxn));
 
#ifdef GCP_CH
/* CH Primitives */ 
EXTERN S16 MgUiMgtMgcoCmdReq ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdReq));
EXTERN S16 MgUiMgtMgcoCmdInd ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdInd));
EXTERN S16 MgUiMgtMgcoUpdCtxtReq ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtReq));
EXTERN S16 MgUiMgtMgcoUpdCtxtInd ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtInd));
EXTERN S16 MgUiMgtMgcoTxnStaInd ARGS((Pst *pst, SpId spId, MgMgcoInd *chTxnStaInd));
EXTERN S16 MgUiMgtMgcoErrReq ARGS((Pst *pst, SpId spId, MgMgcoInd *errRsp));
/* mgt_x_006.main_12: CH-Module Redesign changes */
EXTERN S16 MgUiMgtMgcoAxnReq ARGS((Pst *pst, SpId spId, MgMgcoCtxt *chCtxt));
#endif /* GCP_CH */
 
#endif /* GCP_MGCO */
 
#endif /* ifdef MG */
 

/* for MGT user */
#ifdef MU
EXTERN S16 MuLiMgtBndCfm       ARGS((Pst *pst, SuId suId, U8 status));
EXTERN S16 MuLiMgtCntrlCfm     ARGS((Pst *pst,SuId suId, MgMgtCntrl *cntrl, 
                                     Reason reason));
EXTERN S16 MuLiMgtAuditCfm     ARGS((Pst *pst,SuId suId, MgMgtAudit *audit, 
                                     Reason reason));
EXTERN S16 MuLiMgtStaInd   ARGS((Pst *pst, SpId spId, MgMgtSta *sta));
#ifdef GCP_MGCP
EXTERN S16 MuLiMgtMgcpTxnInd   ARGS((Pst *pst, SpId spId, MgMgcpTxn *mgTxn));
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
EXTERN S16 MuLiMgtMgcoTxnInd   ARGS((Pst *pst, SpId spId, MgMgcoMsg *mgTxn));
#endif /* GCP_MGCO */
#ifdef GCP_CH
/* CH Primitives */ 
EXTERN S16 MuLiMgtMgcoCmdInd ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdInd));
EXTERN S16 MuLiMgtMgcoUpdCtxtInd ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtInd));
EXTERN S16 MuLiMgtMgcoTxnStaInd ARGS((Pst *pst, SpId spId, MgMgcoInd *chTxnStaInd));
#endif /* GCP_CH */
 
#endif /* MU */

#ifdef GCP_CH

PUBLIC S16 cmPkMgtMgcoCmdReq ARGS((Pst *pst,SpId spId,MgMgcoCommand *mgCmd));

PUBLIC S16 cmPkMgtMgcoCmdInd ARGS((Pst *pst,SuId suId,MgMgcoCommand *mgCmd));

 

PUBLIC S16 cmPkMgtMgcoUpdCtxtReq ARGS((Pst *pst,SpId spId,

                                          MgMgcoUpdateCntxt *mgCxt));

PUBLIC S16 cmPkMgtMgcoUpdCtxtInd ARGS((Pst *pst,SuId suId,

                                          MgMgcoUpdateCntxt *mgCxt));

PUBLIC S16 cmPkMgtMgcoErrReq ARGS((Pst *pst,SpId spId,

                                          MgMgcoInd *mgInd));

PUBLIC S16 cmPkMgtMgcoTxnStaInd ARGS((Pst *pst,SuId suId,

                                          MgMgcoInd *mgInd));

/* mgt_x_006.main_12: CH-Module Redesign changes */
PUBLIC S16 cmPkMgtMgcoAxnReq ARGS((Pst *pst,SpId spId,

                                          MgMgcoCtxt *mgCtxt));


PUBLIC S16 cmUnpkMgtMgcoCmdReq ARGS((MgtMgcoCmdReq  func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));


PUBLIC S16 cmUnpkMgtMgcoCmdInd ARGS((MgtMgcoCmdInd  func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));


PUBLIC S16 cmUnpkMgtMgcoUpdCtxtReq ARGS((MgtMgcoUpdCtxtReq func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));


PUBLIC S16 cmUnpkMgtMgcoUpdCtxtInd ARGS((MgtMgcoUpdCtxtInd func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));


PUBLIC S16 cmUnpkMgtMgcoErrReq ARGS((MgtMgcoErrReq func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));


PUBLIC S16 cmUnpkMgtMgcoTxnStaInd ARGS((MgtMgcoTxnStaInd func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));

/* mgt_x_006.main_12: CH-Module Redesign changes */
PUBLIC S16 cmUnpkMgtMgcoAxnReq ARGS((MgtMgcoAxnReq func,

                                     Pst *pst,

                                     Buffer *mBuf,

                                     Mem *sMem,

                                     Size maxBlkSize));

#endif /* GCP_CH */


/* Pack unpack functions for loose coupling*/
#if (defined (LCMGT) || defined (LWLCMGT))

/* Primitive packing functions */
PUBLIC S16 cmPkMgtBndReq ARGS((Pst *pst,SuId suId,SpId spId));
PUBLIC S16 cmPkMgtUbndReq ARGS((Pst *pst,SpId spId,Reason reason));
PUBLIC S16 cmPkMgtBndCfm ARGS((Pst *pst, SuId suId, U8 status));
PUBLIC S16 cmPkMgtCntrlReq ARGS((Pst *pst,SuId suId,MgMgtCntrl *cntrl));
PUBLIC S16 cmPkMgtCntrlCfm ARGS((Pst *pst,SpId spId, MgMgtCntrl *cntrl, 
                                     Reason reason));
EXTERN S16 cmPkMgtAuditReq ARGS((Pst *pst,SpId spId, MgMgtAudit *audit));
EXTERN S16 cmPkMgtAuditCfm ARGS((Pst *pst,SuId suId, MgMgtAudit *audit, 
                                     Reason reason));
PUBLIC S16 cmPkMgtStaInd ARGS((Pst *pst,SuId suId,MgMgtSta *sta));

#ifdef GCP_MGCP
PUBLIC S16 cmPkMgtMgcpTxnReq ARGS((Pst *pst,SpId spId,MgMgcpTxn *mgTxn));
PUBLIC S16 cmPkMgtMgcpTxnInd ARGS((Pst *pst,SuId suId,MgMgcpTxn *mgTxn));
#endif /* GCP_MGCP */

/* Mukesh: this is temporary - End */
#ifdef GCP_MGCO
PUBLIC S16 cmPkMgtMgcoTxnReq ARGS((Pst *pst,SpId spId,MgMgcoMsg *mgTxn));
PUBLIC S16 cmPkMgtMgcoTxnInd ARGS((Pst *pst,SuId suId,MgMgcoMsg *mgTxn));
#endif /* GCP_MGCO */



PUBLIC S16 cmUnpkMgtBndReq ARGS((MgtBndReq func,Pst *pst,Buffer *mBuf));
PUBLIC S16 cmUnpkMgtUbndReq ARGS((MgtUbndReq func,Pst *pst,Buffer *mBuf));
PUBLIC S16 cmUnpkMgtBndCfm ARGS((MgtBndCfm func,Pst *pst,Buffer *mBuf));
PUBLIC S16 cmUnpkMgtCntrlReq ARGS((MgtCntrlReq func,Pst *pst,Buffer *mBuf));
PUBLIC S16 cmUnpkMgtCntrlCfm ARGS((MgtCntrlCfm func,Pst *pst,Buffer *mBuf));
PUBLIC S16 cmUnpkMgtAuditReq ARGS((MgtAuditReq func,Pst *pst,Buffer *mBuf));
PUBLIC S16 cmUnpkMgtAuditCfm ARGS((MgtAuditCfm func,Pst *pst,Buffer *mBuf));

PUBLIC S16 cmUnpkMgtStaInd ARGS((MgtStaInd func,Pst *pst,Buffer *mBuf));

#ifdef GCP_MGCP
PUBLIC S16 cmUnpkMgtMgcpTxnReq ARGS((MgtMgcpTxnReq  func,
                                     Pst *pst,
                                     Buffer *mBuf,
                                     Mem *sMem, 
                                     Size maxBlkSize));
PUBLIC S16 cmUnpkMgtMgcpTxnInd ARGS((MgtMgcpTxnInd  func,Pst *pst,
                                     Buffer *mBuf,
                                     Mem *sMem, 
                                     Size maxBlkSize));
#endif /* GCP_MGCP */

#ifdef GCP_MGCO
PUBLIC S16 cmUnpkMgtMgcoTxnReq ARGS((MgtMgcoTxnReq  func,
                                     Pst *pst,
                                     Buffer *mBuf,
                                     Mem *sMem, 
                                     Size maxBlkSize));
PUBLIC S16 cmUnpkMgtMgcoTxnInd ARGS((MgtMgcoTxnInd  func,Pst *pst,
                                     Buffer *mBuf,
                                     Mem *sMem, 
                                     Size maxBlkSize));
#endif /* GCP_MGCO */

#endif /* (defined (LCMGT) || defined (LWLCMGT)) */


#ifdef DG

EXTERN S16 DgUiMgtBndReq       ARGS((Pst *post, SuId suId, SpId spId));
EXTERN S16 DgUiMgtUbndReq      ARGS((Pst *post,SpId spId, Reason reason));
EXTERN S16 DgUiMgtCntrlReq     ARGS((Pst *post,SpId spId, MgMgtCntrl *cntrl));
EXTERN S16 DgUiMgtAuditReq     ARGS((Pst *post,SpId spId, MgMgtAudit *audit));

#ifdef DG_MGCP
EXTERN S16 DgUiMgtMgcpTxnReq   ARGS((Pst *post, SpId spId, MgMgcpTxn *mgTxn));
#endif /* DG_MGCP */

#ifdef DG_MGCO
EXTERN S16 DgUiMgtMgcoTxnReq   ARGS((Pst *post, SpId spId, MgMgcoMsg *mgTxn));
#endif /* DG_MGCO */


EXTERN S16 DgLiMgtBndReq       ARGS((Pst *post, SuId suId, SpId spId));
EXTERN S16 DgLiMgtUbndReq      ARGS((Pst *post,SpId spId, Reason reason));
EXTERN S16 DgLiMgtCntrlReq     ARGS((Pst *post,SpId spId, MgMgtCntrl *cntrl));
EXTERN S16 DgLiMgtAuditReq     ARGS((Pst *post,SpId spId, MgMgtAudit *audit));

#ifdef DG_MGCP
EXTERN S16 DgLiMgtMgcpTxnReq   ARGS((Pst *post, SpId spId, MgMgcpTxn *mgTxn));
#endif /* DG_MGCP */

#ifdef DG_MGCO
EXTERN S16 DgLiMgtMgcoTxnReq   ARGS((Pst *post, SpId spId, MgMgcoMsg *mgTxn));
#endif /* DG_MGCO */

#endif /* ifdef DG */


#ifdef AG

EXTERN S16 AgLiMgtBndCfm       ARGS((Pst *pst, SuId suId, U8 status));

EXTERN S16 AgLiMgtCntrlCfm     ARGS((Pst *pst,SuId suId, MgMgtCntrl *cntrl,

                                     Reason reason));

EXTERN S16 AgLiMgtAuditCfm     ARGS((Pst *pst,SuId suId, MgMgtAudit *audit,

                                     Reason reason));

EXTERN S16 AgLiMgtStaInd   ARGS((Pst *pst, SpId spId, MgMgtSta *sta));

#ifdef GCP_MGCO

EXTERN S16 AgLiMgtMgcoTxnInd   ARGS((Pst *pst, SpId spId, MgMgcoMsg *mgTxn));

#endif /* GCP_MGCO */

#ifdef GCP_CH

/* CH Primitives */

EXTERN S16 AgLiMgtMgcoCmdInd ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdInd));

EXTERN S16 AgLiMgtMgcoUpdCtxtInd ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtInd));

EXTERN S16 AgLiMgtMgcoTxnStaInd ARGS((Pst *pst, SpId spId, MgMgcoInd *chTxnStaInd));

#endif /* GCP_CH */

 

EXTERN S16 AgLiMgtBndReq       ARGS((Pst *post, SuId suId, SpId spId));

EXTERN S16 AgLiMgtUbndReq      ARGS((Pst *post,SpId spId, Reason reason));

EXTERN S16 AgLiMgtCntrlReq     ARGS((Pst *post,SpId spId, MgMgtCntrl *cntrl));

EXTERN S16 AgLiMgtAuditReq     ARGS((Pst *post,SpId spId, MgMgtAudit *audit));

#ifdef GCP_CH

/* CH Primitives */

EXTERN S16 AgLiMgtMgcoCmdReq ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdInd));

EXTERN S16 AgLiMgtMgcoUpdCtxtReq ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtInd));

EXTERN S16 AgLiMgtMgcoErrReq ARGS((Pst *pst, SpId spId, MgMgcoInd *chTxnStaInd));

/* mgt_x_006.main_12: CH-Module Redesign changes */
EXTERN S16 AgLiMgtMgcoAxnReq ARGS((Pst *pst, SpId spId, MgMgcoCtxt *chCtxt));

#endif /* GCP_CH */

#endif /* AG */

 

/* for DM */

#ifdef DM

EXTERN S16 DmLiMgtBndCfm       ARGS((Pst *pst, SuId suId, U8 status));

EXTERN S16 DmLiMgtCntrlCfm     ARGS((Pst *pst,SuId suId, MgMgtCntrl *cntrl,

                                     Reason reason));

EXTERN S16 DmLiMgtAuditCfm     ARGS((Pst *pst,SuId suId, MgMgtAudit *audit,

                                     Reason reason));

EXTERN S16 DmLiMgtStaInd   ARGS((Pst *pst, SpId spId, MgMgtSta *sta));

#ifdef GCP_MGCO

EXTERN S16 DmLiMgtMgcoTxnInd   ARGS((Pst *pst, SpId spId, MgMgcoMsg *mgTxn));

#endif /* GCP_MGCO */

#ifdef GCP_CH

/* CH Primitives */

EXTERN S16 DmLiMgtMgcoCmdInd ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdInd));

EXTERN S16 DmLiMgtMgcoUpdCtxtInd ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtInd));

EXTERN S16 DmLiMgtMgcoTxnStaInd ARGS((Pst *pst, SpId spId, MgMgcoInd *chTxnStaInd));

#endif /* GCP_CH */

 

EXTERN S16 DmLiMgtBndReq       ARGS((Pst *post, SuId suId, SpId spId));

EXTERN S16 DmLiMgtUbndReq      ARGS((Pst *post,SpId spId, Reason reason));

EXTERN S16 DmLiMgtCntrlReq     ARGS((Pst *post,SpId spId, MgMgtCntrl *cntrl));

EXTERN S16 DmLiMgtAuditReq     ARGS((Pst *post,SpId spId, MgMgtAudit *audit));

#ifdef GCP_CH

/* CH Primitives */

EXTERN S16 DmLiMgtMgcoCmdReq ARGS((Pst *pst, SpId spId, MgMgcoCommand *chCmdInd));

EXTERN S16 DmLiMgtMgcoUpdCtxtReq ARGS((Pst *pst, SpId spId, MgMgcoUpdateCntxt *chCntxtInd));

EXTERN S16 DmLiMgtMgcoErrReq ARGS((Pst *pst, SpId spId, MgMgcoInd *chTxnStaInd));

/* mgt_x_006.main_12: CH-Module Redesign changes */
EXTERN S16 DmLiMgtMgcoAxnReq ARGS((Pst *pst, SpId spId, MgMgcoCtxt *chCtxt));

#endif /* GCP_CH */

#endif /* DM */

/* 001.main_12: Added wild card support for GCP_ASN */
#ifdef GCP_ASN
EXTERN S16 cmPkMgMgcoWildcard          ARGS((MgMgcoWildcard *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoWildcard        ARGS((MgMgcoWildcard *param, 
                                             Ptr ptr, 
                                             Buffer *mBuf));
#endif /* GCP_ASN */

/* mgt_x_007.main_12: Added LCN Feature Changes */
#ifdef GCP_LCN_APP_USE
EXTERN S16 cmUnpkMgLcnInfo        ARGS((MgMgtLcnInfo *param, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgLcnInfo          ARGS((MgMgtLcnInfo *param, 
                                             Buffer *mBuf));
#endif /* GCP_LCN_APP_USE */

#ifdef GCP_VER_2_1   

EXTERN S16 cmPkMgMgcoCntxtAttrDesc          ARGS((MgMgcoCntxtAttrDesc *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoCntxtAttrDesc        ARGS((MgMgcoCntxtAttrDesc *param, 
                                             Ptr ptr, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoContextLst          ARGS((MgMgcoContextLst *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkMgMgcoContextLst        ARGS((MgMgcoContextLst *param, 
                                             Ptr ptr, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoCntxtPropAud          ARGS((MgMgcoCntxtPropAud *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoCntxtPropAud        ARGS((MgMgcoCntxtPropAud *param, 
                                             Ptr ptr, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoSelLogic          ARGS((MgMgcoSelLogic *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSelLogic        ARGS((MgMgcoSelLogic *param, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoRegEmbDesc          ARGS((MgMgcoRegEmbDesc *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoRegEmbDesc        ARGS((MgMgcoRegEmbDesc *param, 
                                             Ptr ptr, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoNtfyBehav          ARGS((MgMgcoNtfyBehav *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoNtfyBehav        ARGS((MgMgcoNtfyBehav *param, 
                                             Ptr ptr, 
                                             Buffer *mBuf));

EXTERN S16 cmPkMgMgcoSegReply          ARGS((MgMgcoSegReply *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkMgMgcoSegReply        ARGS((MgMgcoSegReply *param, 
                                             Buffer *mBuf));

#endif /* GCP_VER_2_1 */ 

#ifdef __cplusplus
}
#endif

#endif /* not defined __MGTX__ */


/********************************************************************30**

         End of file:     mgt.x@@/main/17 - Thu Nov 15 14:19:19 2007

*********************************************************************31*/
/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      rrp  1. Initial release
1.1+         001.101  bbk  1. Changed data type for peerId in MgLclInfo
                              from U16 to U32. Change is under GCP_ENHNC_1_2
                              compile time flag
/main/3      ---       pk  1. Added MEGACO support.
/main/3+ 001.main_3    sk  1. Added Pres field in mgMgcoAuditDesc
/main/3+ 002.main_3    vj  1. Modified MgDName structure so that the generated
                              mgt.c packs/unpacks ipAddr irrespective of 
                              namePres field.
         003.main_3    vj  1. Modified MgPeerInfo structure for MEGACO, and
                              added mid as a new field.
                           2. Modified MgMgcoMsg structure for MEGACO by
                              changing the type of mid field to TknStrOSXL.
/main/2      ---      rg   1. GCP 1.3 release
/main/12     ---      pk   1. GCP release 1.5
/main/12 mgt_x_001.main_12  gk   1. Added wild card support for GCP_ASN 
                                 2. Added Annex C support in GCP_ASN
         mgt_x_002.main_12  gk   1. Support for packages to U16 under
                                    the flag MGT_PROPR_PKG_SUPPORT
         mgt_x_003.main_12  gk   1. boolean field is added in MgMgcoValue union
                                 2. MgMgcoContextAudit sequence reshufled in 
                                    correct manner
                                 3. Modified the enume to U32 under
                                    GCP_ENUM_U32 flag
/main/13     ---            gk   1. Added wild card support for GCP_ASN 
                                 2. Added Annex C support in GCP_ASN
                                 3. Support for packages to U16 under
                                    the flag MGT_PROPR_PKG_SUPPORT
                                 4.  boolean field is added in MgMgcoValue union
                                 5. MgMgcoContextAudit sequence reshufled in 
                                    correct manner
                                 6. Modified the enume to U32 under
                                    GCP_ENUM_U32 flag
/main/14     ---      gk   1. Releasing main/12 patches
/main/15     ---      gk   1. Added keepactive for ASN 
                           2. Added extern definitions of propparm
                              packing/unpacking functions for ASN
                           3. Corection to err and reply for
                              proper encoding
                           4. CH-Module Redesign changes added new
                              interface prmitives at mgt and dummy
                              and packing/unpacking functions
                           5. Added LCN Feature Related Changes
/main/16     ---      ac   1. Added stucture needed for profile Indication to SU
                           2. Packing/Unpacking function MgcoProf structure
/main/17     ----     sy   GCP 2.1 release                           
*********************************************************************91*/
