/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/
/********************************************************************20**
  
     Name:    GCP layer
  
     Type:    C include file 
  
     Desc:    constants required by MGCP layer
 
     File:    mgt.h

     Sid:      mgt.h@@/main/21 - Fri Dec 11 01:07:15 2009
  
     Prg:     pk
  
*********************************************************************21*/
 

/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000XXX      MGCP Layer
*
*/

/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.             description
*     --------     ----------------------------------------------
*
*
*/



#ifndef __MGTH__
#define __MGTH__





/* MGT Interface Coupling flags */
#define MGT_SEL_LC      0       /* Loosely coupled MGT interface */
#define MGT_SEL_TC      1       /* Tightly coupled MGT interface */
#define MGT_SEL_LWLC    2       /* Lightweight Loosely coupled MGT interface */

/******************************************************************************/
/*                         Defines for Rolling Upgrade                        */
/******************************************************************************/

/* Introduce the interface version number */
#ifdef MGT1
#ifdef MGTIFVER
#undef MGTIFVER
#endif
#define MGTIFVER 0x0100
#endif /* MGT1 */

/* 002.main_8 : New release of MGT interface */
#ifdef MGT2

#ifdef MGT1
#undef MGT1       /* either MGT1 OR MGT2 has to be defined */
#endif

#ifdef MGTIFVER
#undef MGTIFVER
#endif
#define MGTIFVER 0x0101
#endif /* MGT2 */


/******************************************************************************/
/*                         Common Defines                                     */
/******************************************************************************/
#define MGT_NONE                   0 

/* Miscllenuous */

#define MGT_DNAME_NONE 0

/* mgt_h_005.main_3: Added a new define for size of MID string array */
#define MGT_MID_STR_LEN           256  /* Max MID string length */

/* Events for MGT interface primitives */
#define  EVTMGTBNDREQ             1  /* Bind  Request */
#define  EVTMGTBNDCFM             2  /* Bind  Confirm */
#define  EVTMGTUBNDREQ            3  /* Unbind  Request */
#define  EVTMGTMGCPTXNREQ         4  /* transaction Request */
#define  EVTMGTMGCPTXNRSP         5  /* transaction Response */
#define  EVTMGTMGCPTXNIND         6  /* transaction Indication */
#define  EVTMGTMGCPTXNCFM         7  /* transaction Confirm */
#define  EVTMGTMGCOTXNREQ         8  /* transaction Request */
#define  EVTMGTMGCOTXNIND         9  /* transaction Indication */
#define  EVTMGTCNTRLREQ          10  /* Control Request */
#define  EVTMGTCNTRLCFM          11  /* Control Confirm */
#define  EVTMGTAUDREQ            12  /* Audit Request */
#define  EVTMGTAUDCFM            13  /* Audit Confirm */
#define  EVTMGTSTAIND            14  /* Status Indication */
 
#ifdef GCP_CH

#define  EVTMGTMGCOCMDREQ        15  /* Command REquest   */
#define  EVTMGTMGCOCMDIND        16  /* Command Indication*/
#define  EVTMGTMGCOUPDCNTXTREQ   17  /* Context Upd Req   */
#define  EVTMGTMGCOUPDCNTXTIND   18  /* Context Upd Ind   */
#define  EVTMGTMGCOERRREQ        19  /* Error Request     */
#define  EVTMGTMGCOTXNSTAIND     20  /* Txn Status Ind    */
/* mgt_h_010.main_15: CH-Module Redesign changes added new event */
#define  EVTMGTMGCOAXNREQ        21  /* Action Request   */

#endif /* GCP_CH */
 
/* Types for local info */
#define MGT_DNAME_NAME  1    /* pure name (alphanum)*/
#define MGT_DNAME_ADDR  2    /* address format */


/* Reason in MGTUbndReq */
#define MGT_UBND_REQ 1

/* Defines for Control Request Primitive */
#define MGT_RMV_ASSOC   1
#define MGT_RMV_TRANS   2
#define MGT_MOVE_PEER   3
#define MGT_MOVE_TRANS  4
#define MGT_CANCEL_RMV_ASSOC 5
#define MGT_RESET_RTO   6

/* Defines for Control Req Resource Types */
#define MGT_SSAP        1
#define MGT_PEER        2

/* Types of Transactions (single/range etc) */
#define MGT_SINGLE_TRANS 1
#define MGT_RANGE_TRANS  2
#define MGT_ALL_TRANS    3

/* Direction for Define */
#define MGT_INCOMING_TXN   1
#define MGT_OUTGOING_TXN   2

/* Types of Responses from service user */
#define MGT_RESPONSE      1
#define MGT_PROV_RESPONSE 2
#define MGT_RESPONSE_ACK  3


/* Types for Status Indication to service user */
#define MGT_STATUS_MGCO_VER           1
#define MGT_STATUS_MGCP_VER           2
#define MGT_STATUS_FLOW               3
#define MGT_STATUS_HANDOFF_FAILED     4
#define MGT_STATUS_REDIRECTION_FAILED 5
#define MGT_STATUS_PEER               6
#define MGT_STATUS_SRVC_PRVDR_FAILED  7
#define MGT_STATUS_SAP_RECVRY_SUCCESS 8
#define MGT_STATUS_SAP_RECVRY_FAILED  9
#define MGT_STATUS_VER_FOUND_FAILED   10
/* mgt_h_011.main_15: Added LCN Support */
#ifdef GCP_LCN_APP_USE
#define MGT_STATUS_LCN_INFO           11
#endif /* GCP_LCN_APP_USE */
#ifdef GCP_VER_2_1
/*3gpp req1-4 status ind id cmd per reply exceeds*/
#define MGT_STATUS_CMDPERREP_EXCEED   12
#endif

/* mgt_h_014.main_15: Including the provision of sending status indication to user when FO/HO
 * occurs*/
#ifdef GCP_HOFO_STAIND         
#define MGT_STATUS_FAILOVER_INITIATED 14
#define MGT_STATUS_HANDOFF_RECIEVED   13
#endif

#define MGT_STATUS_MGCO_PROF          15

#ifdef GCP_VER_2_1
#define MGT_MAX_PROF_LEN              64
#endif  /* GCP_VER_2_1 */


/* Types of Flow Control Actions */
#define MGT_FLC_STRT          1
#define MGT_FLC_STOP          2
#define MGT_FLC_DROP          3

/* Types of Peer status reasons */
#define MGT_RTO_CAP_REACHED   1
/*
 * mgt_h_003.main_3: Addition of Peer status reason. This reason is issued
 * when the GCP_USER_RETX_CNTRL is defined, and maximum retransmissions are
 * done for stack generated RSIP restart message.
 */
#define MGT_MAX_INIT_REG_DONE  2

/* Define for Audit Confirm*/
#define MGT_MAX_TXN          100

/* Transaction Control Block States passed as audit information to SU */

#define MGT_OUTTXN_TXN_SENT      1
#define MGT_OUTTXN_TXN_QUEUED    2
#define MGT_OUTTXN_PROVRSP_RCVD  3

#define MGT_INTXN_TXN_RCVD       4
#define MGT_INTXN_RSP_SENT       5
#define MGT_INTXN_RSP_QUEUED     6
#define MGT_INTXN_PROVRSP_SENT   7


/* Values for the errors passed in MgLclErr */
#define MGT_ERR_RSRC_UNAVAIL        1   /* resource not available */
#define MGT_ERR_INVALID_PEER        2   /* peer could not be located */
#define MGT_ERR_RMV_PEER_ID         3   /* remove prev id association if any */
#define MGT_ERR_INVALID_PARMS       4   /* Invalid Message Parameters */
#define MGT_ERR_INVALID_MSG         5   /* Invalid Message or message not 
                                         * consistent with state
                                         */
#define MGT_ERR_RESET_SSAP_TXN      6   /* reset SSAP transactions */
#define MGT_ERR_INVALID_HDR_PARMS   7   /* Invalid Message Header */
#define MGT_ERR_INVALID_ERR_DESC    8   /* Invalid Error Descriptor */
#define MGT_ERR_INVALID_TRANS       9   /* Invalid Transaction */
#define MGT_ERR_MSG_LENGTH          10  /* Message too long */
#define MGT_ERR_REGISTER_FAILED     11  /* Registration Failed */
#define MGT_ERR_PEER_NOT_RESPONDING 12  /* Peer not responding */
#define MGT_ERR_NOT_REGISTERED      13  /* Registration not Initiated Yet */
#define MGT_ERR_PEER_DISCONNECTED   14  /* Peer Disconnected */
#define MGT_ERR_TXN_RETX_FAILED     15  /* Retransmission of txn failed */
#define MGT_ERR_PROVRSP_NOT_ALLOWED 16  /* Provisional Response cannot 
                                         * be issued by service user 
                                         */
#define MGT_ERR_PEER_ASSOC_RMVD     17  /*Associatn with peer already removed */

#define MGT_ERR_TXNTMOUT            18  /* Txn timeout */

/* Adding CH Error types */
#ifdef GCP_CH

#define MGT_CH_ERR_NONE                       19 /* No error        */
#define MGT_CH_ERR_INV_MSG                    20 /* Invalid message */
#define MGT_CH_ERR_TL_NUM_NOTPRSNT            21 /* Txn List num not present */ 
#define MGT_CH_ERR_TXN_TYPE_NOTPRSNT          22 /* Txn Type not present */ 
#define MGT_CH_ERR_PEER_NOT_FOUND             23 /* Peer not found */
#define MGT_CH_ERR_TXNID_OR_CNTXTID_NOT_FOUND 24 /* TXN ID not found */
#define MGT_CH_ERR_AXN_LIST_EMPTY             25 /* AXN List empty */
#define MGT_CH_ERR_CMD_TYPE_NONE              26 /* No cmd type    */
#define MGT_CH_ERR_CMD_RSP_TMD_OUT            27 /* Command response timed out */
#define MGT_CH_ERR_CMD_REQ_TMD_OUT            28 /* Command rewuest  timed out */
#define MGT_CH_ERR_PEND_LIMIT_EXCEEDED        29 /* Pending Limit exceeded in the */
                                             /* receiving side */
/* [UG]: Adding error ids seperately for txn & context id not found */
#define MGT_CH_ERR_TXNID_NOT_FOUND            30
#define MGT_CH_ERR_TXNID_NOT_FOUND_IN_CMD     31 /* TXN ID not found */
#define MGT_CH_ERR_CNTXTID_NOT_FOUND_IN_CMD   32 /* Context ID not found */
#define MGT_CH_ERR_TXNID_NOT_FOUND_IN_CNTXT   33 /* TXN ID not found */
#define MGT_CH_ERR_CNTXTID_NOT_FOUND_IN_CNTXT 34 /* Context ID not found */
#define MGT_CH_ERR_CMD_STATUS_NONE            35 /* Command Status None */
#define MGT_CH_ERR_CMD_RSP_NOT_RCVD           36 /* Command Response not Recieved */

#endif /* GCP_CH */

/*  mgt_h_008.main_15: Pending Limit exceeded in the receiving side */ 
#define MGT_ERR_PEND_LIMIT_EXCEEDED 37

/* mgt_h_010.main_15: Invalid primitive invocation */
#define MGT_ERR_INCORRECT_PRMITIVE_INVOKED   38

/* mgt_h_013.main_15: Added Error Ind for blocking messages sent
 * before Ctrl Assoc is established*/
#ifdef GCP_VER_2_1

/*  3GPP req 1-4 : for mgMgcoMsg content verification */
#define MGT_ERR_SVCCMD_NOTTHEONLY_INMSG      40 /*When SVC(otherthan Gfl)is  
                                                 *not the only cmd in the msg*/
#define MGT_ERR_ROOTTERM_NOTIN_NULLCTX       41   /*When command on Root 
                                                   * term do not use NULL cxt*/
#define MGT_ERR_SVCCMD_NT_ON_ROOT            42  /*Service Change commands
                                                   Handoff, failover and Disconnected
                                                   are not allowed on non-ROOT
                                                   terminations F.4.2.1 in H.248v3*/
#define MGT_ERR_CMDPERTXNREQ_LIMIT_EXCEEDED  43   /*Num of Cmd/TxnReq xded */

/* for mgMgcoMsg content verification */
#endif /* GCP_VER_2_1 */

#define MGT_ERR_VERSION_UNSUPP               44

#define MGT_ERR_LOCK_STATE                   45  /* Stack is in lock state */

/* mgt_h_001.main_20: Added Error Ind for invalid MID */
#define MGT_ERR_INVALID_MID                  46   /* Invalid MID */

#ifdef GCP_CH

/* Null index txn */
#define CH_NULL_INDEX               0

/* CH Indications to user */
#define CH_IND_NONE                 0  /* No error                     */
#define CH_IND_TXN_PEND             1  /* TXN Pending                  */
 
/* Version Number Need to remove if it redundant */
#define CH_VERSION_NO               2  /* Current Version No */
 
#endif /* GCP_CH */

#define MG_PROV_RSP_ROOTTM_TMR           30                                               \

/****************************************************************************/
/*                        MGCP Specific Defines                             */
/****************************************************************************/

/* MGCP message types */
#define MGT_MSG_NONSTD    0
#define MGT_MSG_EPCF      1
#define MGT_MSG_CRCX      2
#define MGT_MSG_MDCX      3
#define MGT_MSG_DLCX      4 
#define MGT_MSG_RQNT      5
#define MGT_MSG_NTFY      6
#define MGT_MSG_AUEP      7
#define MGT_MSG_AUCX      8 
#define MGT_MSG_RSIP      9

/*
 *   The define for the MESG cmd -
 */

#ifdef GCP_PKG_MGCP_BASE
#define MGT_MSG_MESG      10
#endif /* GCP_PKG_MGCP_BASE */

#define MGT_MSG_RSP       11
#define MGT_MSG_NONE      12
#define MGT_MSG_RSP_ACK_RSP 13




/* response code :protocol defined */
#define MGT_MGCP_RSP_CODE_RSP_ACK_RSP           000
#define MGT_MGCP_RSP_CODE_PROVISIONAL           100
#define MGT_MGCP_RSP_CODE_OK                    200
#define MGT_MGCP_RSP_CODE_CONN_DEL              250
#define MGT_MGCP_RSP_CODE_OK_RANGE              299
#define MGT_MGCP_RSP_CODE_TXN_NOT_EXEC          400
#define MGT_MGCP_RSP_CODE_PH_OFF_HOOK           401
#define MGT_MGCP_RSP_CODE_PH_ON_HOOK            402

#define MGT_MGCP_RSP_CODE_UNKNOWN_EP            501
#define MGT_MGCP_RSP_CODE_NO_RSRC_ON_EP         502
#define MGT_MGCP_RSP_CODE_PROT_ERROR            510
#define MGT_MGCP_RSP_CODE_UNRECOG_EXTN          511
#define MGT_MGCP_RSP_CODE_EVNT_NOT_DETECTABLE   512
#define MGT_MGCP_RSP_CODE_CAN_NOT_GEN_SIG       513
#define MGT_MGCP_RSP_CODE_CAN_NOT_ANNOUNCE      514
#define MGT_MGCP_RSP_CODE_INVALID_CONNID        515
#define MGT_MGCP_RSP_CODE_INVALID_CALLID        516
#define MGT_MGCP_RSP_CODE_INVALID_MODE          517
#define MGT_MGCP_RSP_CODE_INVALID_PACKAGE       518
#define MGT_MGCP_RSP_CODE_NO_DGT_MAP            519
#define MGT_MGCP_RSP_CODE_RESTARTING            520
#define MGT_MGCP_RSP_CODE_REDIRECT_TO_NEW_CA    521
#define MGT_MGCP_RSP_CODE_UNKNOWN_EVENT_SIG     522
#define MGT_MGCP_RSP_CODE_UNKNOWN_ACTN          523
#define MGT_MGCP_RSP_CODE_INCONSISTENT_LCL_OPT  524
#define MGT_MGCP_RSP_CODE_UNKNOWN_LCL_CONN_OPT  525

#define MGT_MGCP_RSP_CODE_TXNTMOUT              406
/*
 * mgt_h_005.main_8: Addition of error code for incorrect version in MGCP.
 */
#define MGT_MGCP_RSP_CODE_PROT_VER_ERROR        528

/* error codes for MEGACO */
#define MGT_MGCO_RSP_CODE_BAD_REQ               400
#define MGT_MGCO_RSP_CODE_PROT_ERROR            401
#ifdef GCP_VER_2_1
/* replacing the err code 510 with 511 as per 3GPP req1-4:Cmd cannot be
 * executed due to temporary congestion /ongoing task. */
#define MGT_MGCO_RSP_CODE_RSRC_ERROR            511
#else
#define MGT_MGCO_RSP_CODE_RSRC_ERROR            510
#endif
/* mgt_h_005.main_8: Addition of error codes for Unauthorized entity */
#define MGT_MGCO_RSP_CODE_UNAUTHORIZED          402
#define MGT_MGCO_RSP_CODE_UNAUTH_ENTITY         504

#define MGT_MGCO_RSP_CODE_VERSION_UNSUPP        406
/* if we haven't sent out the SrvChg send err 502 Not Ready */
#define MGT_MGCO_RSP_CODE_NOT_READY             502

/*
 * if registration has not been completed yet with the MGC,
 * send err 505 Request received before service change
 * reply has been received
 */
#define MGT_MGCO_RSP_CODE_REQRCVD_BEFORE_REGCMPLT       505
/* Pending Limit need to replace with actual value - Karthik   */
#define    MGT_MGCO_RSP_CODE_TXNPENDING_EXCEEDED  506 

/* 001.main_15: Added new error code(533) to send to peer in case
         response size is greater then configured MTU size for the peer.*/
#define MGT_MGCO_RSP_CODE_PDU_SIZE_EXCEED             533
#ifdef GCP_VER_2_1
/*  3GPP req1-4 : for mgMgcoMsg content verification */
#define MGT_MGCO_RSP_CODE_MAXTXNPERMSG_EXCEED         413 
#define MGT_MGCO_RSP_CODE_NOT_DEFINED                 -1
#endif /* GCP_VER_2_1 */

#define MGT_MGCO_RSP_CODE_INVLD_IDENTIFIER           410
#define MGT_MGCO_RSP_CODE_UNKNOWN_CTXT               411

#define MGT_MGCO_RSP_CODE_UNKNOWN_TERM_ID            430
#define MGT_MGCO_RSP_CODE_NO_TERM_MATCH              431
#define MGT_MGCO_RSP_CODE_NO_TERM_AVAIL              432
#define MGT_MGCO_RSP_CODE_DUP_TERM_CTXT              433
#define MGT_MGCO_RSP_CODE_MAX_TERM_CTXT              434
#define MGT_MGCO_RSP_CODE_NO_TERM_CTXT               435
#define MGT_MGCO_RSP_CODE_UNSUPPORTED_CMD            443
#define MGT_MGCO_RSP_CODE_UNSUPPORTED_DESC           444

#define MGT_MGCO_RSP_CODE_NO_REM_LCL_DSCR            441
#define MGT_MGCO_RSP_CODE_UNKNOWN_DSCR               444
#define MGT_MGCO_RSP_CODE_MISSING_PARM_IN_SIG_EVNT   457
#define MGT_MGCO_RSP_CODE_MISSING_SEGMENTS           459
#define MGT_MGCO_RSP_CODE_TEMP_NETWORK_FAILURE       530


/* Defines for the param types */
#define MGT_PARAM_NON_STD         0 
#define MGT_PARAM_RSPACK          1
#define MGT_PARAM_BEAR_INFO       2
#define MGT_PARAM_CALLID          3
#define MGT_PARAM_CONNID          4
#define MGT_PARAM_NTFIED_ENT      5
#define MGT_PARAM_RQSTID          6
#define MGT_PARAM_LCL_CONNOPTS    7
#define MGT_PARAM_CONN_MODE       8
#define MGT_PARAM_RQSTD_EVENT     9
#define MGT_PARAM_SIG_RQST        10
#define MGT_PARAM_DGT_MAP         11
#define MGT_PARAM_OBS_EVENT       12
#define MGT_PARAM_CONN_PARAM      13
#define MGT_PARAM_REASON          14
#define MGT_PARAM_SPEC_EPID       15
#define MGT_PARAM_SECND_EPID      16
#define MGT_PARAM_SCND_CONNID     17
#define MGT_PARAM_RQSTD_INFO      18
#define MGT_PARAM_QRNT_HANDLING   19
#define MGT_PARAM_RSTRT_METHOD    20
#define MGT_PARAM_RSTRT_DELAY     21
#define MGT_PARAM_DETECT_EVENT    22
#define MGT_PARAM_CAPABILITIES    23
#define MGT_PARAM_EVNTSTATES      24
#define MGT_PARAM_MAX_ENDPT_IDS   25
#define MGT_PARAM_NUM_ENDPT_IDS   26
#define MGT_PARAM_RESOURCE_ID     27
#define MGT_PARAM_VERSN_SUPRTD    28

/* Event descriptor type */

#define MGT_DESC_EVENT_ID    1
#define MGT_DESC_EVENT_ALL   2
#define MGT_DESC_EVENT_RANGE 3
#define MGT_DESC_EVENT_KNOWN 4

/* qurantine handling */

#define MGT_QRNT_STEP    1
#define MGT_QRNT_LOOP    2
#define MGT_QRNT_PROCESS 3
#define MGT_QRNT_DISCARD 4

/* event param type */
#define MGT_TYPE_STR           1
#define MGT_TYPE_QUOTED_STR    2



/* local connection opt types */

#define MGT_LCL_CONNOPT_NON_STD       0 
#define MGT_LCL_CONNOPT_PKTZ_PERIOD   1
#define MGT_LCL_CONNOPT_BW            2
#define MGT_LCL_CONNOPT_ALGO_NAME     3
#define MGT_LCL_CONNOPT_ECHO_CAN      4
#define MGT_LCL_CONNOPT_SIL_SUPP      5
#define MGT_LCL_CONNOPT_GAIN_CTRL     6
#define MGT_LCL_CONNOPT_TYPE_SRVC     7
#define MGT_LCL_CONNOPT_RSRC_RESV     8
#define MGT_LCL_CONNOPT_TYPE_OF_NET   9
#define MGT_LCL_CONNOPT_ENCRYPT_INFO  10
#define MGT_LCL_CONNOPT_SUPP_MODES    11
#define MGT_LCL_CONNOPT_SUPP_PKGS     12
#define MGT_LCL_CONNOPT_DQOS_GATEID   13
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV  14
#define MGT_LCL_CONNOPT_DQOS_RSRCID   15
#define MGT_LCL_CONNOPT_DQOS_RSVDEST  16
#define MGT_LCL_CONNOPT_SEC_SECRET    17
#define MGT_LCL_CONNOPT_SEC_RTPSUITE  18
#define MGT_LCL_CONNOPT_SEC_RTCPSUITE 19


/* supported modes */
#define MGT_SUPP_MODE_SEND_ONLY        1
#define MGT_SUPP_MODE_RECV_ONLY        2
#define MGT_SUPP_MODE_SEND_RECV        3
#define MGT_SUPP_MODE_CONF             4
#define MGT_SUPP_MODE_INACTIVE         5
#define MGT_SUPP_MODE_LOOPBK           6
#define MGT_SUPP_MODE_CONT_TEST        7
#define MGT_SUPP_MODE_NET_WLOOP        8
#define MGT_SUPP_MODE_NET_WTEST        9
#define MGT_SUPP_MODE_DATA             10
#define MGT_SUPP_MODE_REPLCATE         11
/* mgt_h_001.main_3 - Addition */
#define MGT_SUPP_MODE_SENDRESV         12
#define MGT_SUPP_MODE_RECVRESV         13
#define MGT_SUPP_MODE_SNRCRESV         14
#define MGT_SUPP_MODE_SENDCOMT         15
#define MGT_SUPP_MODE_RECVCOMT         16
#define MGT_SUPP_MODE_SNRCCOMT         17

/* connection parameters */
#define MGT_PARAM_CONN_PARAM_NONSTD    0 
#define MGT_PARAM_CONN_PARAM_PS        1 
#define MGT_PARAM_CONN_PARAM_OS        2 
#define MGT_PARAM_CONN_PARAM_PR        3 
#define MGT_PARAM_CONN_PARAM_OR        4 
#define MGT_PARAM_CONN_PARAM_PL        5 
#define MGT_PARAM_CONN_PARAM_JI        6 
#define MGT_PARAM_CONN_PARAM_LA        7 

/* info codes - for Requested Info */
#define MGT_INFO_CODE_B     1
#define MGT_INFO_CODE_C     2
#define MGT_INFO_CODE_I     3
#define MGT_INFO_CODE_N     4
#define MGT_INFO_CODE_X     5
#define MGT_INFO_CODE_L     6
#define MGT_INFO_CODE_M     7
#define MGT_INFO_CODE_R     8
#define MGT_INFO_CODE_S     9
#define MGT_INFO_CODE_D     10
#define MGT_INFO_CODE_O     11
#define MGT_INFO_CODE_P     12
#define MGT_INFO_CODE_E     13
#define MGT_INFO_CODE_Z     14
#define MGT_INFO_CODE_Q     15
#define MGT_INFO_CODE_T     16
#define MGT_INFO_CODE_RC    17
#define MGT_INFO_CODE_LC    18
#define MGT_INFO_CODE_A     19
#define MGT_INFO_CODE_ES    20
#define MGT_INFO_CODE_RM    21
#define MGT_INFO_CODE_RD    22
#define MGT_INFO_CODE_PL    23
#define MGT_INFO_CODE_MD    24

/* encryption method types not well defined */
/*TBD*/

/* gain ontrol type */

#define MGT_GAIN_CTRL_AUTO  1
#define MGT_GAIN_CTRL_VAL   2

/* bearer encodings */
#define MGT_BEAR_ENC_ALAW  1
#define MGT_BEAR_ENC_MULAW 2

/* resource reservation type */
#define MGT_LCL_CONNOPT_RSRC_RESV_G       1
#define MGT_LCL_CONNOPT_RSRC_RESV_CL      2
#define MGT_LCL_CONNOPT_RSRC_RESV_BE      3

/* type of network */
#define  MGT_LCL_CONNOPT_TON_IN       1
#define  MGT_LCL_CONNOPT_TON_ATM      2
#define  MGT_LCL_CONNOPT_TON_LOCAL    3

/* DQOS - resource reservation methods */
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV_SENDRESV      1
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV_RECVRESV      2
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV_SNRCRESV      3
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV_SENDCOMT      4
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV_RECVCOMT      5
#define MGT_LCL_CONNOPT_DQOS_RSRCRSV_SNRCCOMT      6

/* Secret method */
#define MGT_LCL_CONNOPT_SEC_SECRET_CLEAR           1
#define MGT_LCL_CONNOPT_SEC_SECRET_BASE64          2

/* restart method */
#define MGT_PARAM_RSTRT_GRACE         1
#define MGT_PARAM_RSTRT_FORCE         2
#define MGT_PARAM_RSTRT_RSTRT         3
#define MGT_PARAM_RSTRT_DISC          4
#define MGT_PARAM_RSTRT_CANCL_GRCFUL  5

/*
*   Bis related new hash defines
*/
#define    MGT_MGCP_BRR_ENCODING    0
#define    MGT_MGCP_BRR_EXTN    1
#define     MGT_MGCP_LCL_OPT_EXTN_VAL_STR   1
#define    MGT_MGCP_LCL_OPT_EXTN_VAL_QUOTED    2
#define    MGT_MGCP_CONN_OPT_PKG_EXTN_NAME_UNKNOWN_EXTN    0

#define    MGT_MGCP_CONN_PAR_PKG_EXTN_NAME_UNKNOWN_EXTN    0
#define    MGT_MGCP_CONN_MODE_PKG_EXTN_NAME_UNKNOWN_EXTN   0

#define       MGT_MGCP_LCL_CONNOPT_VNDR_EXT    0
#define     MGT_MGCP_LCL_CONNOPT_PKG_EXT       1
#define     MGT_MGCP_LCL_CONNOPT_OTHR_EXT       2
#define    MGT_MGCP_PKG_EXTN_PARAM_NAME_UNKNOWN_EXTN    0
#define    MGT_MGCP_EXTN_PARAM_VNDR   0
#define    MGT_MGCP_EXTN_PARAM_PKG   1
#define     MGT_MGCP_EXTN_PARAM_OTHER   2
#define    MGT_MGCP_CONN_MOD_EXTN_VAL_UNKNOWN_EXTN    0
#define MGT_SUPP_MODE_EXTENSION  18
#define  MGT_MGCP_LCL_CONNOPT_TON_OTHER          4     /* entry for mgt.h */
#define    MGT_MGCP_TON    0
#define    MGT_MGCP_SUPP_TONS    1
#define  MGT_DESC_EVENT_DTMF_POUND  6
#define  MGT_DESC_EVENT_DTMF_STAR  5
#define    MGT_EVNT_PARAM_ONLY_VAL    0
#define    MGT_EVNT_PARAM_ONE_VAL    1
#define    MGT_EVNT_PARAM_SET_VAL    2
#define    MGT_MGCP_EXTN_ACTION_UNKNOWN_EXTN    0
#define  MGT_RQSTD_ACTN_EXTN            9
#define    MGT_MGCP_CONN_PAR_C_P_NAME_UNKNOWN_EXTN    0
#define    MGT_MGCP_CONN_PAR_VNDR_EXTN     0
#define    MGT_MGCP_CONN_PAR_PKG_EXTN   1
#define    MGT_INFO_CODE_EXTN   25
#define  MGT_PARAM_RSTRT_EXTN_METHOD   6
#define  MGT_PARAM_PACKAGE_LIST   29
#define  MGT_PARAM_MAX_DATAGRAM   30

#define  MGT_MGCP_LCL_CONNOPT_OPT_FMTP   20
#define  MGT_MGCP_LCL_CONNOPT_FMTP       21
#define  MGT_MGCP_LCL_CONNOPT_RES_DIR    22
#define  MGT_MGCP_LCL_CONNOPT_RES_CNFM   23
#define  MGT_MGCP_LCL_CONNOPT_RES_SHARE  24

#define  MGT_MGCP_LCL_CONNOPT_RS_SH_THIS_CONN      0
#define  MGT_MGCP_LCL_CONNOPT_RS_SH_EMPTY_CONN     1
#define  MGT_MGCP_LCL_CONNOPT_RS_SH_SPECFIC_CONN   2

#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_DIR_SND_ONLY     0
#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_DIR_RCV_ONLY     1
#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_DIR_SND_RCV      2

#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_CNF_SND_ONLY     0
#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_CNF_RCV_ONLY     1
#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_CNF_SND_RCV      2
#define  MGT_MGCP_CONNOPT_LCL_RS_RSV_CNF_NONE         3

#define  MGT_MGCP_EVNT_NAME_PKG_PRES    0
#define  MGT_MGCP_EVNT_NAME_PKG_ABST    1

/*
*   Following is basically a renaming
*/
#define   MGT_MGCP_LCL_CONNOPT_STD_EXT  MGT_PARAM_CONN_PARAM_NONSTD



/* requested actions */
#define MGT_RQSTD_ACTN_N    1
#define MGT_RQSTD_ACTN_A    2
#define MGT_RQSTD_ACTN_D    3
#define MGT_RQSTD_ACTN_S    4
#define MGT_RQSTD_ACTN_I    5
#define MGT_RQSTD_ACTN_K    6
#define MGT_RQSTD_ACTN_EMB  7
#define MGT_RQSTD_ACTN_MDCX 8

/* Non standard extension type */
#define MGT_NONSTD_TYPE_MANDATORY      1
#define MGT_NONSTD_TYPE_OPTIONAL       2


/* defines related to element constraints. Note: some will be converted to ptr */

#define MGT_MAX_MSG          5   /* max MGCP messages to be piggy-backed */
#define MGT_MAX_RSP_ACK      5   /* max ranges in response ack */
#define MGT_MAX_CONNID       5   /* max ranges in Connction id  */
#define MGT_MAX_CONN_PARAM   10  /* max connection parameters */
#define MGT_MAX_EVENT_PARAM  10  /* max event paramters */
#define MGT_MAX_DGT_MAP      10  /* maximum number of maps */
#define MGT_MAX_RQSTD_ACTION 5   /* max requested actions */
#define MGT_MAX_BEAR_ENC     5   /* max bearer enc param entries */
#define MGT_MAX_SUPP_MODE    5   /* max supported modes */
#define MGT_MAX_SUPP_PKG     5   /* max supported packages */
#define MGT_MAX_ALGO_NAMES   5   /* max encryption algorithms */
#define MGT_MAX_INFO_CODE    5   /* max information codes */
#define MGT_MAX_LCL_CONNOPTS 12  /* max local connection options */
#define MGT_MAX_ENCAP_CMDS   5   /* max encapsulated commands */
#define MGT_MAX_QRNT_CNTRL   2   /* max quarantine handling */
#define MGT_MAX_REQEMBD_TYPE 5   /* max embedded actions */
#define MGT_MAX_REQEMBD_MDCX_MODE 5 /* max size of modes list in emb MDCX */
#define MGT_MAX_DQOUTE_STR   5   /* quoted string list size */
#define MGT_MAX_VERS_SUPP    5   /* max size of versions supported list */
#define MGT_MAX_RSRC_RSV_COMP  5 /* max size of resource resv list */
#define MGT_MAX_CIPHER_SUITE 5   /* max size of ciphersuites list */
#define MGT_MAX_UNKNWON      255 
/* milton */
#define MGT_MAX_IND_AUDIT_RET_PARM      255 
/* milton */



/******************************************************************************/
/*                        MEGACO Specific Defines                             */
/******************************************************************************/

/* #defines for types to distinguish in unions */

/* IP address */
#define MGT_IPV4              0
#define MGT_IPV6              1

/* MID */
#define MGT_MID_DEVICE        0
#define MGT_MID_DADDRPORT     1
#define MGT_MID_DNAMEPORT     2
#define MGT_MID_MTPADDR       3
#define MGT_MID_PORT          4

/* Request ID */
#define MGT_REQID_ALL         0
#define MGT_REQID_OTHER       1

/* Termination ID */
#define MGT_TERMID_ROOT       0
#define MGT_TERMID_ALL        1
#define MGT_TERMID_CHOOSE     2
#define MGT_TERMID_OTHER      3 

/* Context ID */
#define MGT_CXTID_NULL        0
#define MGT_CXTID_ALL         1
#define MGT_CXTID_CHOOSE      2
#define MGT_CXTID_OTHER       3

/* Stream mode */
#define MGT_MODE_SENDONLY     0
#define MGT_MODE_RECVONLY     1
#define MGT_MODE_SENDRECV     2
#define MGT_MODE_INACTIVE     3
#define MGT_MODE_LOOPBACK     4

/* Parameter value */
#define MGT_VALUE_EQUAL       0
#define MGT_VALUE_GREATERTHAN 1
#define MGT_VALUE_LESSTHAN    2
#define MGT_VALUE_NOTEQUAL    3
#define MGT_VALUE_AND         4
#define MGT_VALUE_OR          5
#define MGT_VALUE_RANGE       6

/* Value */
/* we don't need all types defined in cm_abnf.h */
#define MGT_VALTYPE_ENUM            0
#define MGT_VALTYPE_UINT32          1
#define MGT_VALTYPE_HEX_UINT32      2
#define MGT_VALTYPE_OCTSTRXL        3
#define MGT_VALTYPE_TKNBUF          4
#define MGT_VALTYPE_SIGNAME         5
#define MGT_VALTYPE_SIGLST          6
#define MGT_VALTYPE_TERMID          7
#define MGT_VALTYPE_TERMIDLST       8
#define MGT_VALTYPE_SINT32          9
#define MGT_VALTYPE_HEX_SINT32      10
#define MGT_VALTYPE_ADV_AUD_SEGLST  11
#define MGT_VALTYPE_ADV_AUD_PROVSEGSPEC   12
/* mgt_h_004.main_15: Added Bool type to support in ASN */
#ifdef GCP_ASN
#define MGT_VALTYPE_BOOL            13
#define MGT_VALTYPE_IA5             14
#endif /* GCP_ASN */

/* Extension parameter Types */
#define MGT_EXTNPARM_OPT      0
#define MGT_EXTNPARM_MAND     1
#define MGT_NONSTD_OBJID      2
#define MGT_NONSTD_H221       3

/* Digit map letter (single letter) */

#define MGT_DIGMAP_0    0
#define MGT_DIGMAP_1    1
#define MGT_DIGMAP_2    2
#define MGT_DIGMAP_3    3
#define MGT_DIGMAP_4    4
#define MGT_DIGMAP_5    5
#define MGT_DIGMAP_6    6
#define MGT_DIGMAP_7    7
#define MGT_DIGMAP_8    8
#define MGT_DIGMAP_9    9
#define MGT_DIGMAP_A    10
#define MGT_DIGMAP_B    11
#define MGT_DIGMAP_C    12
#define MGT_DIGMAP_D    13
#define MGT_DIGMAP_E    14
#define MGT_DIGMAP_F    15
#define MGT_DIGMAP_G    16
#define MGT_DIGMAP_H    17
#define MGT_DIGMAP_I    18
#define MGT_DIGMAP_J    19
#define MGT_DIGMAP_K    20
#define MGT_DIGMAP_L    21
#define MGT_DIGMAP_S    22
#define MGT_DIGMAP_Z    23

/* Digit map range */
#define MGT_DIGMAP_X          0
#define MGT_DIGMAP_LET        1

/* Digit string element */
#define MGT_DIGSTR_RNG        0
#define MGT_DIGSTR_LET        1

/* Digit map, also use for DigMapDesc */
#define MGT_DIGMAP_NAME       0
#define MGT_DIGMAP_VAL        1

/* Signal parameter */
#define MGT_SIGPAR_OTHER      MGT_EVTPAR_OTHER
#define MGT_SIGPAR_STREAMID   MGT_EVTPAR_STREAMID
#define MGT_SIGPAR_TYPE       2
#define MGT_SIGPAR_DURATION   3
#define MGT_SIGPAR_NTFYCMPL   4
#define MGT_SIGPAR_KEEPACTIVE MGT_EVTPAR_KEEPACTIVE

#ifdef GCP_VER_2_1
#define MGT_SIGPAR_DIR        6
#define MGT_SIGPAR_REQID      7
#define MGT_SIGPAR_INTSIGDELAY 8
#endif /* GCP_VER_2_1 */

/* Signals parameter */
#define MGT_SIGSPAR_LST       0
#define MGT_SIGSPAR_REQ       1

/* (Second) Event parameter */
#define MGT_EVTPAR_OTHER         0
#define MGT_EVTPAR_STREAMID      1
#define MGT_EVTPAR_EMBEDWITHSIG  2
#define MGT_EVTPAR_EMBEDNOSIG    3
#define MGT_EVTPAR_DIGMAP        4
#define MGT_EVTPAR_KEEPACTIVE    5
#define MGT_EVTPAR_EMBEDSIG      MGT_EVTPAR_EMBEDWITHSIG
#define MGT_EVTPAR_NOTIFY_BEHV   6
#define MGT_EVTPAR_RST_EVT_DESC  7

/* Notify Behaviour */
#define MGT_EVTPAR_NTFY_IMM      0
#define MGT_EVTPAR_NTFY_REG      1
#define MGT_EVTPAR_NEVER_NTFY    2

/* Notify Behaviour */
#define MGT_NTFY_BEHAV_EMBEDWITHSIG  0
#define MGT_NTFY_BEHAV_EMBEDNOSIG    1

/* Context property and Context Audit - Commoan Hash Defines */
#define MGT_CXTPROP_PRI          0
#define MGT_CXTPROP_EMERG        1
#define MGT_CXTPROP_TOPO         2
#ifdef GCP_VER_2_1
#define MGT_CXTPROP_IEPS         3
/* Context Prop Specific Hash Defines */
#define MGT_CXTPROP_CXTATTRDESC  4
#define MGT_CXTPROP_EMERG_OFF    5
#else
#define MGT_CXTPROP_EMERG_OFF    3
#endif /* GCP_VER_2_1 */

#define MGT_CXTATTRDESC_PROPPARM  1
#define MGT_CXTATTRDESC_CXTIDLST  0

/* Context Audit Specific Hash Defines */

#define MGT_CXTAUDITSEL_CNTXTATTR    4
#define MGT_CXTAUDITSEL_PRI          5
#define MGT_CXTAUDITSEL_EMERG        6
#define MGT_CXTAUDITSEL_IEPS         7
#define MGT_CXTAUDITSEL_AUDSELLOGIC  8
#define MGT_CXTAUD_PKGDNAME          9

/* Select Logic */
#define MGT_SELLOGIC_OR_AUDIT    0
#define MGT_SELLOGIC_AND_AUDIT   1

/* Session descriptor */
#define MGT_SESDESC_SDP          0
#define MGT_SESDESC_BIN          1

/* Local control descriptor parameter */
#define MGT_LCLCTL_MODE          0
#define MGT_LCLCTL_RESVAL        1
#define MGT_LCLCTL_RESGRP        2
#define MGT_LCLCTL_PROPPARM      3

/* 002.main_15: Modify - Change maximum number of terminationStateParms from 30 */
#define MGT_MAX_TERM_STATE_PARMS 255

#define MGT_TERMST_PROPLST       2 /* mgt_h_001.main_3 - Change: was 0 */
#define MGT_TERMST_EVTBUFCTL     0 /* mgt_h_001.main_3 - Change: was 1 */
#define MGT_TERMST_SVCST         1 /* mgt_h_001.main_3 - Change: was 2 */

/* Signal type */
/* mgt_h_004.main_15: Order changed according to ASN values */
#define MGT_SIGTYPE_BRIEF        0
#define MGT_SIGTYPE_ONOFF        1
#define MGT_SIGTYPE_TIMEOUT      2

/* Signal Direction */
#ifdef GCP_VER_2_1
#define MGT_DIR_INTERNAL         0
#define MGT_DIR_EXTERNAL         1
#define MGT_DIR_BOTH             2
#endif /* GCP_VER_2_1 */

/* Notification reason */
#define MGT_NTFYRES_TIMEOUT      0
#define MGT_NTFYRES_IBYEVT       1
#define MGT_NTFYRES_IBYNEWSIG    2
#define MGT_NTFYRES_OTHER        3
#define MGT_NTFYRES_ITER         4

/* Service state */
#define MGT_SVCST_TEST           0
#define MGT_SVCST_OUTOFSVC       1
#define MGT_SVCST_INSVC          2

/* Topology direction */
#define MGT_TOPODIR_BOTHWAY      0
#define MGT_TOPODIR_ISOLATE      1
#define MGT_TOPODIR_ONEWAY       2
#ifdef GCP_VER_2_1
#define MGT_TOPODIR_ONEWAY_EXT   3
#define MGT_TOPODIR_ONEWAY_BOTH  4
#endif /* GCP_VER_2_1 */ 

/* Service change method */
#define MGT_EXTNPARM                    0
#define MGT_SVCCHGMETH_FAILOVER         1
#define MGT_SVCCHGMETH_FORCED           2
#define MGT_SVCCHGMETH_GRACEFUL         3
#define MGT_SVCCHGMETH_RESTART          4
#define MGT_SVCCHGMETH_DISCON           5
#define MGT_SVCCHGMETH_HANDOFF          6

/*******************Service Change Cancel Graceful Method*********************/
/*this is a adhoc service change method for Service Change cancel graceful
 *This method is not exposed to the user It is used to prevent Cancel
 *graceful response to be recognised as Restart response by the stack if
 *Cancel comes in states other than AWAIT_REG*/
/*#define MGT_SVCCHGMETH_RSTRT_CNCL_GRCFL   7*/
/*moved this to mg.h*/
/*****************************************************************************/

/* Modem type */
#define MGT_MODEMTYPE_V32BIS     1
#define MGT_MODEMTYPE_V22BIS     2
#define MGT_MODEMTYPE_V18        3
#define MGT_MODEMTYPE_V22        4
#define MGT_MODEMTYPE_V32        5
#define MGT_MODEMTYPE_V34        6
#define MGT_MODEMTYPE_V90        7
#define MGT_MODEMTYPE_V91        8
#define MGT_MODEMTYPE_SYNCHISDN  9

/* Mux type */
#define MGT_MUXTYPE_H221         1
#define MGT_MUXTYPE_H223         2
#define MGT_MUXTYPE_H226         3
#define MGT_MUXTYPE_V76          4
/* 003.main_15: Added definition for Nx64 */
#define MGT_MUXTYPE_N64          5

/* Stream descriptor parameter */
#define MGT_STRPAR_LOCCTL        0
#define MGT_STRPAR_LOCAL         1
#define MGT_STRPAR_REMOTE        2

/* Media descriptor parameter */
#define MGT_MEDIAPAR_LOCCTL      MGT_STRPAR_LOCCTL
#define MGT_MEDIAPAR_LOCAL       MGT_STRPAR_LOCAL
#define MGT_MEDIAPAR_REMOTE      MGT_STRPAR_REMOTE
#define MGT_MEDIAPAR_STRPAR      3
#define MGT_MEDIAPAR_TERMST      4
#ifdef GCP_VER_2_1
#define MGT_MEDIAPAR_STATSDESC   5
#endif /* GCP_VER_2_1 */

#ifdef MGT_MGCO_V2

/*mgMgcoIndAudMediaParm*/
#define MGT_INDAUD_LOCCTL          MGT_MEDIAPAR_LOCCTL
#define MGT_INDAUD_LOCAL           MGT_MEDIAPAR_LOCAL
#define MGT_INDAUD_REMOTE          MGT_MEDIAPAR_REMOTE
#define MGT_INDAUD_STPAR           MGT_MEDIAPAR_STRPAR
#define MGT_INDAUD_TERSTDESC       MGT_MEDIAPAR_TERMST 
#ifdef GCP_VER_2_1
#define MGT_INDAUD_STATS_DESC      MGT_MEDIAPAR_STATSDESC
#endif /* GCP_VER_2_1 */
/*mgMgcoIndAudMediaParm*/

/*mgMgcoIndAudSignals*/
#define MGT_INDAUD_SIGREQ     0
#define MGT_INDAUD_SIGLST     1
/*mgMgcoIndAudSignals*/

/*mgMgcoIndAudSignalParLst*/
#define MGT_INDAUD_SIGPAR_STREAMID    0
#define MGT_INDAUD_SIGPAR_REQID       1
/*mgMgcoIndAudSignalParLst*/

/*mgMgcoIndAudEventSpecParm*/
#define MGT_INDAUD_EVPRM       0
#define MGT_INDAUD_EVSTREAM    1
/*mgMgcoIndAudEventSpecParm*/

/*MgMgcoIndAudPackages*/

/* mgt_h_006.main_15: Changed the hash defines
 * for indaud parameters */
#define MGT_INDAUD_AUDMEDIA       MGT_MEDIADESC
#define MGT_INDAUD_AUDEVTS        MGT_REQEVTDESC
#define MGT_INDAUD_AUDEVTBUF      MGT_EVBUFDESC
#define MGT_INDAUD_AUDSIG         MGT_SIGNALSDESC
#define MGT_INDAUD_AUDDIGITMAP    MGT_DIGMAPDESC
#define MGT_INDAUD_AUDSTAT        MGT_STATSDESC
#define MGT_INDAUD_AUDPKG         MGT_PKGSDESC
/*MgMgcoIndAudPackages*/

#endif /* MGT_MGCO_V2  */

/* Service change descriptor parameter */
#define MGT_SVCCHGPAR_NONSTD     0
#define MGT_SVCCHGPAR_METHOD     1
#define MGT_SVCCHGPAR_ADDR       2
#define MGT_SVCCHGPAR_VERSION    3
#define MGT_SVCCHGPAR_PROF       4
#define MGT_SVCCHGPAR_REASON     5
#define MGT_SVCCHGPAR_DELAY      6
#define MGT_SVCCHGPAR_MGCID      7
#define MGT_SVCCHGPAR_TIME       8

#ifdef GCP_VER_2_1
#define MGT_SVCCHGPAR_SIC        10
#endif /* GCP_VER_2_1 */

/* Descriptors */
#define MGT_ERRDESC              0
#define MGT_MEDIADESC            1
#define MGT_MODEMDESC            2
#define MGT_MUXDESC              3
#define MGT_REQEVTDESC           4
#define MGT_EVBUFDESC            5
#define MGT_SIGNALSDESC          6
#define MGT_DIGMAPDESC           7
#define MGT_OBSEVTDESC           8
#define MGT_STATSDESC            9
#define MGT_PKGSDESC            10
#define MGT_AUDITDESC           11
#define MGT_INDAUD_TERMAUDDESC  12
#define MGT_IND_AUD_STAT_DESC   13

/* Audit result */
#define MGT_CXTAUDIT             1
#define MGT_TERMAUDIT            2
#define MGT_TERMLST_AUDIT        3

/* Service change result */
#define MGT_SVCCHGDESC           1

/* Command or Reply */
#define MGT_ADD                  0
#define MGT_MOVE                 1
#define MGT_MODIFY               2
#define MGT_SUB                  3
#define MGT_AUDITCAP             4
#define MGT_AUDITVAL             5
#define MGT_NTFY                 6
#define MGT_SVCCHG               7

/* Action reply parameter */
#define MGT_CXTCMDREPLY          1

/* Transaction reply parameter */
#define MGT_ACTIONREPLY          1

/* Transaction */
#define MGT_TXNLOCAL_ERR         0
#define MGT_TXNREQ               1
#define MGT_TXNREPLY             2
#define MGT_TXNPEND              3
#define MGT_TXNRSPACK            4
#ifdef GCP_VER_2_1
#define MGT_SEGREPLY             5
#endif /* GCP_VER_2_1 */

#ifdef GCP_VER_2_1
#define MGT_SEGCOMP              1
#endif /* GCP_VER_2_1 */

/* Message body parameter */
#define MGT_TXN                  1
#define MGT_TXNID_NULL           0

/* Package name */
/* mgt_h_004.main_15 : Changed Unknown Package Id from 0 to 254 
 * because ASN Annex C uses package id 0 
 * To support unknown package changed to 254*/
/* #define MGT_PKG_UNKNOWN                0x0000  */
#define MGT_PKG_ANNEXC                 0x0000   /*    0 */ 
#define MGT_PKG_GENERIC                0x0001   /*    1 */
#define MGT_PKG_ROOT                   0x0002   /*    2 */
#define MGT_PKG_TONEGEN                0x0003   /*    3 */
#define MGT_PKG_TONEDET                0x0004   /*    4 */
#define MGT_PKG_DTMFGEN                0x0005   /*    5 */
#define MGT_PKG_DTMFDET                0x0006   /*    6 */
#define MGT_PKG_CALLPROGGEN            0x0007   /*    7 */
#define MGT_PKG_CALLPROGDET            0x0008   /*    8 */
#define MGT_PKG_ANALOG                 0x0009   /*    9 */
#define MGT_PKG_CONTINUITY             0x000A   /*   10 */
#define MGT_PKG_NETWORK                0x000B   /*   11 */
#define MGT_PKG_RTP                    0x000C   /*   12 */
#define MGT_PKG_TDM_CKT                0x000D   /*   13 */

#define MGT_PKG_FAX_TONE_DET               14
#define MGT_PKG_TXT_CNVR                   15
#define MGT_PKG_TXT_TELPHONE               16
#define MGT_PKG_CALL_TYP_DISCR             17
#define MGT_PKG_FAX                        18
#define MGT_PKG_IP_FAX                     19
#define MGT_PKG_DISPLAY                    20
#define MGT_PKG_KEY                        21
#define MGT_PKG_KEY_PAD                    22
#define MGT_PKG_LABEL_KEY                  23
#define MGT_PKG_FUNC_KEY                   24
#define MGT_PKG_INDICATOR                  25
#define MGT_PKG_SOFT_KEY                   26
#define MGT_PKG_ANCI_INPUT                 27
#define MGT_PKG_DTD                        28  
#define MGT_PKG_GENERIC_ANNC               29  
#define MGT_PKG_BRR_CHAR                   30 
#define MGT_PKG_BNCT                       31 
#define MGT_PKG_RI                         32 
#define MGT_PKG_GEN_BRR_CON                33 
#define MGT_PKG_BRR_CTL_TN                 34 
#define MGT_PKG_BSC_CAL_TN                 35 
#define MGT_PKG_XD_CALPG_TNGN              36 
#define MGT_PKG_BSC_SRV_TN                 37 
#define MGT_PKG_XD_SRV_TNGN                38
#define MGT_PKG_INT_TNGN                   39 
#define MGT_PKG_BSNS_TNGN                  40 
#define MGT_PKG_CHP                        41  
#define MGT_PKG_H245                       42
#define MGT_PKG_H323BC                     43
#define MGT_PKG_H_324                      44   
#define MGT_PKG_H_245_COM                  45   
#define MGT_PKG_H_245_IND                  46   
#define MGT_PKG_TRI_GUP                    47  
#define MGT_PKG_TRI_GCSD                   48   
#define MGT_PKG_TRI_GTFO                   49   
#define MGT_PKG_TRIG_XD_CALPG_TNGN         50   
#define MGT_PKG_ADVAUSRVR_BASE             51
#define MGT_PKG_ADVAUSRVR_DIGCOLL          52
#define MGT_PKG_ADVAUSRVR_RECORD           53
#define MGT_PKG_ADVAUSRVR_SEG_MNGMT        54
#define MGT_PKG_QTY_ALT                    55   
#define MGT_PKG_CONF_TN                    56   
#define MGT_PKG_TEST                       57  
#define MGT_PKG_CARR_TN                    58 
#define MGT_PKG_EN_ALERT                   59  
#define MGT_PKG_AN_DISP                    60  
#define MGT_PKG_MFQ_TN_GEN                 61 
#define MGT_PKG_MFQ_TN_DET                 62 
#define MGT_PKG_BCAS                       63 
#define MGT_PKG_RBS                        64 
#define MGT_PKG_OSES                       65 
#define MGT_PKG_OSEXT                      66 
#define MGT_PKG_EXT_ALG                    67 
#define MGT_PKG_AUT_MET                    68 
#define MGT_PKG_INACTTIMER                 69 
#define MGT_PKG_TRI_GMLC                   70  
#define MGT_PKG_BANNSYX                    71
#define MGT_PKG_VVSYX                      72
#define MGT_PKG_SETSYX                     73
#define MGT_PKG_PHRSYX                     74
#define MGT_PKG_NAS                        75  
#define MGT_PKG_NAS_IN                     76 
#define MGT_PKG_NAS_OUT                    77 
#define MGT_PKG_NAS_CTL                    78 
#define MGT_PKG_NAS_ROOT                   79 
#define MGT_PKG_PROF                       80 
#define MGT_PKG_OCP                        81 
#define MGT_PKG_EXT_DTMF                   82 
#define MGT_PKG_QT_TM_LTC                  83 
#define MGT_PKG_LP_BK_LTR                  84 
#define MGT_PKG_ITU_LT_404                 85 
#define MGT_PKG_ITU_LT_816                 86 
#define MGT_PKG_ITU_LT_1020                87 
#define MGT_PKG_ITU_LT_DIST                88 
#define MGT_PKG_ITU_LT_DSEC                89 
#define MGT_PKG_ITU_LT_2804                90 
#define MGT_PKG_ITU_LT_NTT                 91 
#define MGT_PKG_ITU_LT_DPRT                92 
#define MGT_PKG_ITU_LT_ATME2               93 
#define MGT_PKG_ANSI_LT_1004               94 
#define MGT_PKG_ANSI_LT_TR                 95 
#define MGT_PKG_ANSI_LT_2225               96 
#define MGT_PKG_ANSI_LT_DTS                97 
#define MGT_PKG_ANSI_IN_LTR                98 
#define MGT_PKG_H324_EXT                   99 
#define MGT_PKG_H245_COM_EXT               100
#define MGT_PKG_H245_IND_EXT               101
#define MGT_PKG_ENH_DTMF                   102
#define MGT_PKG_CONNXN_GRP_ID              103
#define MGT_PKG_TRI_GCTM                   104
#define MGT_PKG_SPNE                       105
#define MGT_PKG_SEM_PER                    106
#define MGT_PKG_SH_RISK                    107
#define MGT_PKG_ISUPTN                     108
#define MGT_PKG_BCASADDR                   109
#define MGT_PKG_FLR_CTL                    110
#define MGT_PKG_IND_VIEW                   111
#define MGT_PKG_VOL_CTL                    112
/* Package ID 113 is Blank */
#define MGT_PKG_VOL_DET                    114
#define MGT_PKG_VOL_LEV_MIX                115
#define MGT_PKG_MIX_VOL_CTL                116
#define MGT_PKG_VOI_ACT_VID_SW             117
#define MGT_PKG_LEC_VID_MOD                118
#define MGT_PKG_CON_VID_SRC                119
#define MGT_PKG_VID_WIN                    120
#define MGT_PKG_TIL_WIN                    121
#define MGT_PKG_AD_JIT_BUFF                122
#define MGT_PKG_ICAS                       123
#define MGT_PKG_CAS_BLK                    124
#define MGT_PKG_ICASC                      125
#define MGT_PKG_ICASCO                     126
#define MGT_PKG_ICASCE                     127
#define MGT_PKG_RTCPXR                     128
#define MGT_PKG_XRBM                       129
#define MGT_PKG_TRI_GCSDEN                 130
#define MGT_PKG_TRI_GIPTRA                 131
#define MGT_PKG_TRIG_FLEX_TN               132
#define MGT_PKG_PCMSB                      133
#define MGT_PKG_MSF_UK_CG                  134 
#define MGT_PKG_MSF_UK_AN                  135 
#define MGT_PKG_MSF_UK_ALG                 136 
#define MGT_PKG_MSF_UK_AUTOMET             137  
#define MGT_PKG_EMB                        138
#define MGT_PKG_DS                         139
#define MGT_PKG_GM                         140
#define MGT_PKG_TMAN                       141
#define MGT_PKG_GRI                        142
#define MGT_PKG_NTR                        143
#define MGT_PKG_MPLS                       144
#define MGT_PKG_VLAN                       145
#define MGT_PKG_DCR                        146
#define MGT_PKG_STIMAL                     147  
#define MGT_PKG_ICASCGEN                   148
#define MGT_PKG_COIN                       149 
#define MGT_PKG_METD                       150
#define MGT_PKG_CALTRAC                    151 
#define MGT_PKG_HANG_TERM                  152
#define MGT_PKG_IPNAPT                     153
#define MGT_PKG_NB                         154
#define MGT_PKG_BC                         155
#define MGT_PKG_ADID                       156
#define MGT_PKG_IPDOMAIN                   157
#define MGT_PKG_DCME                       158
#define MGT_PKG_PRECTN                     159
#define MGT_PKG_MGCINFO                    160
#define MGT_PKG_TOP                        161
#define MGT_PKG_BBP                        162
#define MGT_PKG_SEGMENTATION               163
#define MGT_PKG_ETSI_NB                    164
#define MGT_PKG_ETSI_NR                    165
#define MGT_PKG_ASR                        166
#define MGT_PKG_TTSSYX                     167
#define MGT_PKG_AASTTS                     168
#define MGT_PKG_MPP                        169
#define MGT_PKG_FSDP                       170
#define MGT_PKG_FCPOLI                     171
#define MGT_PKG_ADR                        172
#define MGT_PKG_CCC                        173
#define MGT_PKG_SCR                        174
#define MGT_PKG_QHR                        175
#define MGT_PKG_RECRTCPXR                  176
#define MGT_PKG_RECXRBM                    177
#define MGT_PKG_THREEGASCI                 178

/* mgt_h_012.main_15 : Added  Call Trace Pkg Support */
#define MGT_PKG_TRACE                      151
/* Defined new values to pacakge unknown/knonw/all */
#define MGT_PKG_UNKNOWN                      0     /* Type and StringType */
#define MGT_PKG_KNOWN                        1     /* Type and ValType */
#define MGT_PKG_ALL                          2

#define MGT_PKG_MAX                        255

/* Constants for package support */
#define MGT_PKG_ON                           1
#define MGT_PKG_OFF                          0

/* Types of package components (events/signals/properties/stats/params) */
#define MGT_GEN_TYPE_UNKNOWN                 0
#define MGT_GEN_TYPE_ALL                     1
#define MGT_GEN_TYPE_KNOWN                   2

/* Tone IDs */
#define MGT_PKG_TONEID_ALL              0x0000
#define MGT_PKG_TONEID_D0               0x0010
#define MGT_PKG_TONEID_D1               0x0011
#define MGT_PKG_TONEID_D2               0x0012
#define MGT_PKG_TONEID_D3               0x0013
#define MGT_PKG_TONEID_D4               0x0014
#define MGT_PKG_TONEID_D5               0x0015
#define MGT_PKG_TONEID_D6               0x0016
#define MGT_PKG_TONEID_D7               0x0017
#define MGT_PKG_TONEID_D8               0x0018
#define MGT_PKG_TONEID_D9               0x0019
#define MGT_PKG_TONEID_DA               0x001A
#define MGT_PKG_TONEID_DB               0x001B
#define MGT_PKG_TONEID_DC               0x001C
#define MGT_PKG_TONEID_DD               0x001D
#define MGT_PKG_TONEID_DS               0x0020
#define MGT_PKG_TONEID_DO               0x0021
#define MGT_PKG_TONEID_DT               0x0030
#define MGT_PKG_TONEID_RT               0x0031
#define MGT_PKG_TONEID_BT               0x0032
#define MGT_PKG_TONEID_CT               0x0033
#define MGT_PKG_TONEID_SIT              0x0034
#define MGT_PKG_TONEID_WT               0x0035
#define MGT_PKG_TONEID_PT               0x0036
#define MGT_PKG_TONEID_CW               0x0037
#define MGT_PKG_TONEID_CR               0x0038
#define MGT_PKG_TONEID_BDT              0x0040  /* [TEL]: */
#define MGT_PKG_TONEID_BRT              0x0041  /* [TEL]: */
#define MGT_PKG_TONEID_BBT              0x0042  /* [TEL]: */
#define MGT_PKG_TONEID_BCT              0x0043  /* [TEL]: */
#define MGT_PKG_TONEID_BSIT             0x0044  /* [TEL]: */
#define MGT_PKG_TONEID_BWT              0x0045  /* [TEL]: */
#define MGT_PKG_TONEID_BPT              0x0046  /* [TEL]: */
#define MGT_PKG_TONEID_BCW              0x0047  /* [TEL]: */
#define MGT_PKG_TONEID_BCR              0x0048  /* [TEL]: */
#define MGT_PKG_TONEID_BPY              0x0049  /* [TEL]: */

/* [TEL2]: New Tone IDs added */
#define MGT_PKG_TONEID_ENTER            0x0061  /* [TEL2]: */
#define MGT_PKG_TONEID_EXIT             0x0062  /* [TEL2]: */
#define MGT_PKG_TONEID_LOCK             0x0063  /* [TEL2]: */
#define MGT_PKG_TONEID_UNLOCK           0x0064  /* [TEL2]: */
#define MGT_PKG_TONEID_TIMELIM          0x0065  /* [TEL2]: */
#define MGT_PKG_TONEID_LOW              0x0066  /* [TEL2]: */
#define MGT_PKG_TONEID_HIGH             0x0067  /* [TEL2]: */
#define MGT_PKG_TONEID_LOUD             0x0068  /* [TEL2]: */
#define MGT_PKG_TONEID_FAINT            0x0069  /* [TEL2]: */
#define MGT_PKG_TONEID_SLOW             0x006A  /* [TEL2]: */
#define MGT_PKG_TONEID_FAST             0x006B  /* [TEL2]: */
#define MGT_PKG_TONEID_CDT              0x006C  /* [TEL2]: */
#define MGT_PKG_TONEID_ANS              0x006D  /* [TEL2]: */
#define MGT_PKG_TONEID_CHG              0x006E  /* [TEL2]: */
#define MGT_PKG_TONEID_LDI              0x006F  /* [TEL2]: */

/* [TEL2]: New Tone IDs added for Multi-Frequency Tone Generator Package */
#define MGT_PKG_TONEID_MF0              0x0050  /* [TEL2]: */
#define MGT_PKG_TONEID_MF1              0x0051  /* [TEL2]: */
#define MGT_PKG_TONEID_MF2              0x0052  /* [TEL2]: */
#define MGT_PKG_TONEID_MF3              0x0053  /* [TEL2]: */
#define MGT_PKG_TONEID_MF4              0x0054  /* [TEL2]: */
#define MGT_PKG_TONEID_MF5              0x0055  /* [TEL2]: */
#define MGT_PKG_TONEID_MF6              0x0056  /* [TEL2]: */
#define MGT_PKG_TONEID_MF7              0x0057  /* [TEL2]: */
#define MGT_PKG_TONEID_MF8              0x0058  /* [TEL2]: */
#define MGT_PKG_TONEID_MF9              0x0059  /* [TEL2]: */
#define MGT_PKG_TONEID_MFA              0x005a  /* [TEL2]: */
#define MGT_PKG_TONEID_MFB              0x005b  /* [TEL2]: */
#define MGT_PKG_TONEID_MFC              0x005c  /* [TEL2]: */
#define MGT_PKG_TONEID_MFD              0x005d  /* [TEL2]: */
#define MGT_PKG_TONEID_MFE              0x005e  /* [TEL2]: */
#define MGT_PKG_TONEID_MFF              0x005f  /* [TEL2]: */
#define MGT_PKG_TONEID_MFG              0x0060  /* [TEL2]: */
#define MGT_PKG_TONEID_MFH              0x004F  /* [TEL2]: */ /* Value TBD */

/* Generic package - event IDs */
#define MGT_PKG_ENUM_REQEVTGENERICCAUSE      1
#define MGT_PKG_ENUM_REQEVTGENERICSIGCOMPL   2

/* Generic package - event parameter IDs */
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERAL      1
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEFAILURE      2
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLSIGID     1
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLTERMMETH  2
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLSIGLSTID  3
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLREQID     4

/* Generic package - event parameter values */
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERALNR 1
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERALUR 2
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERALFT 3
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERALFP 4
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERALIW 5
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICCAUSEGENERALUN 6

#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLTERMMETHTO 1
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLTERMMETHEV 2
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLTERMMETHSD 3
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLTERMMETHNC 4
#define MGT_PKG_ENUM_OBSEVTOTHERGENERICSIGCOMPLTERMMETHPI 5

/* Root package - property IDs */
#define MGT_PKG_ENUM_PROPPARM_BASEROOTMAXNUMBEROFCONTEXTS 1
#define MGT_PKG_ENUM_PROPPARM_BASEROOTMAXTERMINATIONSPERCONTEXT 2
#define MGT_PKG_ENUM_PROPPARM_BASEROOTNORMALMGEXECUTIONTIME 3
#define MGT_PKG_ENUM_PROPPARM_BASEROOTNORMALMGCEXECUTIONTIME 4
#define MGT_PKG_ENUM_PROPPARM_BASEROOTMGPROVISIONALRESPONSETIMERVALUE 5
#define MGT_PKG_ENUM_PROPPARM_BASEROOTMGCPROVISIONALRESPONSETIMERVALUE 6
#define MGT_PKG_ENUM_PROPPARM_BASEROOTMGCORIGINATEDPENDINGLIMIT 7
#define MGT_PKG_ENUM_PROPPARM_BASEROOTMGORIGINATEDPENDINGLIMIT 8


/* ToneGen package - signal IDs */
#define MGT_PKG_TONEGEN_SIG_PT                     1

/* ToneGen package - signal parameter IDs */
#define MGT_PKG_TONEGEN_SIG_PT_TONEIDLST           1
#define MGT_PKG_TONEGEN_SIG_PT_INTERSIGDURATION    2
#define MGT_PKG_TONEGEN_SIG_PT_TONEDIR             3
#define MGT_PKG_ENUM_SIGOTHERTONEGENPTTONEDIR_EXT  1
#define MGT_PKG_ENUM_SIGOTHERTONEGENPTTONEDIR_INT  2
#define MGT_PKG_ENUM_SIGOTHERTONEGENPTTONEDIR_BOTH 3

/* ToneDet package - event IDs */
#define MGT_PKG_TONEDET_EVT_STD                    0x0001
#define MGT_PKG_TONEDET_EVT_ETD                    0x0002
#define MGT_PKG_TONEDET_EVT_LTD                    0x0003

/* ToneDet package - event parameter IDs */
#define MGT_PKG_TONEDET_EVT_STD_TID                0x0003 /* NOTE */
#define MGT_PKG_TONEDET_EVT_LTD_DUR                0x0002

/* DtmfDet package - event IDs */
#define MGT_PKG_DTMFDET_EVT_CE                     0x0004 /* 0x0001!! */

/* DtmfDet package - event parameter IDs */
#define MGT_PKG_DTMFDET_EVT_CE_DS                  0x0001
#define MGT_PKG_DTMFDET_EVT_CE_METH                0x0003

/* DtmfDet package - event parameter values */
#define MGT_PKG_DTMFDET_EVT_CE_METH_UM             0x0001
#define MGT_PKG_DTMFDET_EVT_CE_METH_PM             0x0002
#define MGT_PKG_DTMFDET_EVT_CE_METH_FM             0x0003

/* Analog package - event IDs */
#define MGT_PKG_ANALOG_EVT_ON                      0x0004
#define MGT_PKG_ANALOG_EVT_OF                      0x0005
#define MGT_PKG_ANALOG_EVT_FL                      0x0006

/* Analog package - event parameter IDs */
#define MGT_PKG_ANALOG_EVT_ONHOOK_STRICT           0x0001
#define MGT_PKG_ANALOG_EVT_ONHOOK_INIT             0x0002
#define MGT_PKG_ANALOG_EVT_FLASHHOOK_MINDUR        0x0004
#define MGT_PKG_ANALOG_EVT_FLASHHOOK_MAXDUR        0x0005

/* Analog package - event parameter values */
#define MGT_PKG_ANALOG_EVT_ONHOOK_STRICT_EXACT     0x0000
#define MGT_PKG_ANALOG_EVT_ONHOOK_STRICT_STATE     0x0001
#define MGT_PKG_ANALOG_EVT_ONHOOK_STRICT_FAILWRONG 0x0002

/* Analog package - signal IDs */
#define MGT_PKG_ANALOG_SIG_RI                      0x0002

/* Analog package - signal parameter IDs */
#define MGT_PKG_ANALOG_SIG_RI_CAD                  0x0006
#define MGT_PKG_ANALOG_SIG_RI_FREQ                 0x0007

#ifdef GCP_PKG_MGCO_CONT

#define MGT_PKG_CONT_EVT_CMP_RES_FAILURE 0
#define MGT_PKG_CONT_EVT_CMP_RES_SUCCESS 1

#define MGT_PKG_ENUM_OBSEVTOTHERCONTCMPRES 8
#define MGT_PKG_ENUM_REQEVTCONTCMP 5

#define MGT_PKG_ENUM_SIGNALCONTCT 3
#define MGT_PKG_ENUM_SIGNALCONTRSP 4

#endif /* GCP_PKG_MGCO_CONT */
/* Network package - property IDs */
#define MGT_PKG_NETWORK_PROP_JIT                   0x0007

/* Network package - event IDs */
#define MGT_PKG_NETWORK_EVT_NETFAIL                0x0005
#define MGT_PKG_NETWORK_EVT_QUALERT                0x0006

/* Network package - event parameter IDs */
#define MGT_PKG_NETWORK_EVT_QUALERT_TH             0x0001
#define MGT_PKG_NETWORK_EVT_NETFAIL_CAUSE          0x0001

/* Network package - statistics IDs */
#define MGT_PKG_NETWORK_STATS_DUR                  0x0001
#define MGT_PKG_NETWORK_STATS_OS                   0x0002
#define MGT_PKG_NETWORK_STATS_OR                   0x0003

/* Rtp package - event IDs */
#define MGT_PKG_RTP_EVT_PLTRANS                    0x0001

/* Rtp package - event parameter IDs */
#define MGT_PKG_RTP_EVT_PLTRANS_PAYLOAD            0x0001

/* Rtp package - statistics IDs */
#define MGT_PKG_RTP_STATS_PS                       0x0004
#define MGT_PKG_RTP_STATS_PR                       0x0005
#define MGT_PKG_RTP_STATS_PL                       0x0006
#define MGT_PKG_RTP_STATS_JIT                      0x0007
#define MGT_PKG_RTP_STATS_DELAY                    0x0008

/* Tdmc package - property IDs */
#define MGT_PKG_TDMC_PROP_EC                       0x0008
#define MGT_PKG_TDMC_PROP_GAIN                     0x000a
#define MGT_PKG_ENUM_PROPPARMTDMCEC_OFF                 0
#define MGT_PKG_ENUM_PROPPARMTDMCEC_ON                  1

/*
******* Additions for Annex M.1 syntactical packages ******BEG**********
*/

#define    MGT_MGCO_FTP_TYP_A    0
#define    MGT_MGCO_FTP_TYP_I    1
#define    MGT_MGCO_FTP_TYP_D    2
#define    MGT_MGCO_SIMPLE    0
#define    MGT_MGCO_FILE_URL    1
#define    MGT_MGCO_FTP_URL    2
#define    MGT_MGCO_HTTP_URL    3
#define    MGT_MGCO_TOD12_HR_FRMT    0
#define    MGT_MGCO_TOD24_HR_FRMT    1
#define    MGT_MGCO_DATE_ORDER_MDY    0
#define    MGT_MGCO_DATE_ORDER_DMY    1
#define    MGT_MGCO_INT_TYPE_CARD    0
#define    MGT_MGCO_INT_TYPE_ORD    1
#define    MGT_MGCO_TOD_SPEC    0
#define    MGT_MGCO_DOW_SPEC    1
#define    MGT_MGCO_DATE_SPEC    2
#define    MGT_MGCO_MONTH_SPEC    3
#define    MGT_MGCO_DUR_SPEC    4
#define    MGT_MGCO_DIG_SPEC    5
#define    MGT_MGCO_CHAR_SPEC    6
#define    MGT_MGCO_MONEY_SPEC    7
#define    MGT_MGCO_INT_SPEC    8
#define    MGT_MGCO_HUSH_SPEC    9
#define    MGT_MGCO_PHRASE_SPEC    10
#define    MGT_MGCO_SEL_TYPE_LANG    0
#define    MGT_MGCO_SEL_TYPE_OTHER_SEL    1
#define    MGT_MGCO_PROV_SEG_SPEC    0
#define    MGT_MGCO_VAR_SEG_SPEC    1
#define    MGT_MGCO_PROV_SID    0
#define    MGT_MGCO_STA_VAR     1
#define    MGT_MGCO_CHOOSE_URI  2


/*
******* Additions for Annex M.1 syntactical packages ******END**********
*/



/* Package support in MGCP */
#define MGT_MGCP_PKG_UNKNOWN                       0
#define MGT_MGCP_PKG_GENERIC                       1
#define MGT_MGCP_PKG_DTMF                          2
#define MGT_MGCP_PKG_MF                            3
#define MGT_MGCP_PKG_TRUNK                         4
#define MGT_MGCP_PKG_LINE                          5
#define MGT_MGCP_PKG_HANDSET                       6
#define MGT_MGCP_PKG_RTP                           7
#define MGT_MGCP_PKG_NAS                           8
#define MGT_MGCP_PKG_ANN                           9
#define MGT_MGCP_PKG_SCRIPT                       10
#define MGT_MGCP_PKG_ADSI                         11
#define MGT_MGCP_PKG_ISUP_TRUNK                   12
#define MGT_MGCP_PKG_MF_FGD                       13
#define MGT_MGCP_PKG_MF_TERM                      14
#define MGT_MGCP_PKG_SUPP_SRV                     15
#define MGT_MGCP_PKG_COUN_SPC_TONE                16
#define MGT_MGCP_PKG_DGT_MAP_EXT                  17
#define MGT_MGCP_PKG_SIG_LIST                     18
#define MGT_MGCP_PKG_ATM                          19
#define MGT_MGCP_PKG_DTMF_BAS_PBX                 20
#define MGT_MGCP_PKG_GRD_ANALOG                   21
#define MGT_MGCP_PKG_DTMF_DIAL_PULSE              22
#define MGT_MGCP_PKG_NRAM_MF_GRPD                 23
#define MGT_MGCP_PKG_MF_WINK_STRT                 24
#define MGT_MGCP_PKG_RES_RESERV                   25

#define MGT_MGCP_PKG_NAO                          26
#define MGT_MGCP_PKG_FAX                          27
#define MGT_MGCP_PKG_ALL                          28

/* 001.main_8:- BAU & AAU Audio server packages added */
#define MGT_MGCP_PKG_AU_SRVR_BAU                  29
#define MGT_MGCP_PKG_AU_SRVR_AAU                  30

/*
 * [TEL]: Added for 4 MGCP Packages
 */
#define MGT_MGCP_PKG_DISPLAY_XML                  31 
#define MGT_MGCP_PKG_FEATURE_KEY                  32 
#define MGT_MGCP_PKG_BUS_PHONE                    33 
#define MGT_MGCP_PKG_BASE                         34 

/* Change below if we support more MGCP packages */
/* 001.main_8:- BAU & AAU Audio server packages added */
/*
 * [TEL]: Incremented from 31 for 4 additional MGCP Packages
 */ 
#define MGT_MGCP_PKG_MAX                          35

/* Event/signal names for MGCP packages */
#define MGT_MGCP_PKG_SYM_MODEM_DET                 1
#define MGT_MGCP_PKG_SYM_FAX_DET                   2
#define MGT_MGCP_PKG_SYM_LONG_DUR_DET              3
#define MGT_MGCP_PKG_SYM_PAT                       4
#define MGT_MGCP_PKG_SYM_RINGBACK_TONE             5
#define MGT_MGCP_PKG_SYM_RINGBACK                  6
#define MGT_MGCP_PKG_SYM_CONFIRM_TONE              7
#define MGT_MGCP_PKG_SYM_NETWORK_CONGESTION_TONE   8
#define MGT_MGCP_PKG_SYM_INTERCEPT_TONE            9
#define MGT_MGCP_PKG_SYM_PREEMPT_TONE             10
#define MGT_MGCP_PKG_SYM_REPORT_FAIL              11
#define MGT_MGCP_PKG_SYM_X                        12
#define MGT_MGCP_PKG_SYM_T                        13
#define MGT_MGCP_PKG_SYM_DTMF_A                   14
#define MGT_MGCP_PKG_SYM_DTMF_B                   15
#define MGT_MGCP_PKG_SYM_DTMF_C                   16
#define MGT_MGCP_PKG_SYM_DTMF_D                   17
#define MGT_MGCP_PKG_SYM_DTMF_OCTOTHORPE          18
#define MGT_MGCP_PKG_SYM_DTMF_STAR                19
#define MGT_MGCP_PKG_SYM_DTMF_L                   20
#define MGT_MGCP_PKG_SYM_MF_K0KP                  21
#define MGT_MGCP_PKG_SYM_MF_K1                    22
#define MGT_MGCP_PKG_SYM_MF_K2                    23
#define MGT_MGCP_PKG_SYM_MF_S0ST                  24
#define MGT_MGCP_PKG_SYM_MF_S1                    25
#define MGT_MGCP_PKG_SYM_MF_S2                    26
#define MGT_MGCP_PKG_SYM_MF_S3                    27
#define MGT_MGCP_PKG_SYM_MF_WINK                  28
#define MGT_MGCP_PKG_SYM_MF_WINK_OFF              29
#define MGT_MGCP_PKG_SYM_MF_IN_SEIZURE            30
#define MGT_MGCP_PKG_SYM_MF_RS_OR_LINE_RS         31
#define MGT_MGCP_PKG_SYM_MF_UNSEIZURE             32
#define MGT_MGCP_PKG_SYM_TRUNK_CO1                33
#define MGT_MGCP_PKG_SYM_TRUNK_CO2                34
#define MGT_MGCP_PKG_SYM_TRUNK_LPBK               35
#define MGT_MGCP_PKG_SYM_TRUNK_OLD_MW_TONE        36
#define MGT_MGCP_PKG_SYM_TRUNK_NEW_MW_TONE        37
#define MGT_MGCP_PKG_SYM_TRUNK_TEST_LINE          38
#define MGT_MGCP_PKG_SYM_TRUNK_ZZ                 39
#define MGT_MGCP_PKG_SYM_TRUNK_ANS_SUPER          40
#define MGT_MGCP_PKG_SYM_REORDER_TONE             41
#define MGT_MGCP_PKG_SYM_TRUNK_BLOCKING           42
#define MGT_MGCP_PKG_SYM_RTP_QA                   43
#define MGT_MGCP_PKG_SYM_RTP_UC                   44
#define MGT_MGCP_PKG_SYM_RTP_SR                   45
#define MGT_MGCP_PKG_SYM_RTP_JI                   46
#define MGT_MGCP_PKG_SYM_RTP_PL                   47
#define MGT_MGCP_PKG_SYM_0                        48
#define MGT_MGCP_PKG_SYM_1                        49
#define MGT_MGCP_PKG_SYM_2                        50
#define MGT_MGCP_PKG_SYM_3                        51
#define MGT_MGCP_PKG_SYM_4                        52
#define MGT_MGCP_PKG_SYM_5                        53
#define MGT_MGCP_PKG_SYM_6                        54
#define MGT_MGCP_PKG_SYM_7                        55
#define MGT_MGCP_PKG_SYM_8                        56
#define MGT_MGCP_PKG_SYM_9                        57
#define MGT_MGCP_PKG_SYM_LINE_ADSI                58
#define MGT_MGCP_PKG_SYM_LINE_VMWI                59
#define MGT_MGCP_PKG_SYM_LINE_OFFHOOK             60
#define MGT_MGCP_PKG_SYM_LINE_ONHOOK              61
#define MGT_MGCP_PKG_SYM_LINE_FLASHHOOK           62
#define MGT_MGCP_PKG_SYM_LINE_ANSWER_TONE         63
#define MGT_MGCP_PKG_SYM_LINE_BUSY_TONE           64
#define MGT_MGCP_PKG_SYM_LINE_CALLER_ID           65
#define MGT_MGCP_PKG_SYM_LINE_CALL_WAITING_TONE   66
#define MGT_MGCP_PKG_SYM_LINE_CALL_WAITING_TONE1  67
#define MGT_MGCP_PKG_SYM_LINE_CALL_WAITING_TONE2  68
#define MGT_MGCP_PKG_SYM_LINE_CALL_WAITING_TONE3  69
#define MGT_MGCP_PKG_SYM_LINE_CALL_WAITING_TONE4  70
#define MGT_MGCP_PKG_SYM_LINE_DIAL_TONE           71
#define MGT_MGCP_PKG_SYM_LINE_MWI                 72
#define MGT_MGCP_PKG_SYM_LINE_NETWORK_BUSY_TONE   73
#define MGT_MGCP_PKG_SYM_LINE_RING                74
#define MGT_MGCP_PKG_SYM_LINE_RING0               75
#define MGT_MGCP_PKG_SYM_LINE_RING1               76
#define MGT_MGCP_PKG_SYM_LINE_RING2               77
#define MGT_MGCP_PKG_SYM_LINE_RING3               78
#define MGT_MGCP_PKG_SYM_LINE_RING4               79
#define MGT_MGCP_PKG_SYM_LINE_RING5               80
#define MGT_MGCP_PKG_SYM_LINE_RING6               81
#define MGT_MGCP_PKG_SYM_LINE_RING7               82
#define MGT_MGCP_PKG_SYM_LINE_MEDIA_START         83
#define MGT_MGCP_PKG_SYM_LINE_PROMPT_TONE         84
#define MGT_MGCP_PKG_SYM_LINE_ERROR_TONE          85
#define MGT_MGCP_PKG_SYM_LINE_STUTTER_TONE        86
#define MGT_MGCP_PKG_SYM_LINE_ALERT_TONE          87
#define MGT_MGCP_PKG_SYM_LINE_REORDER_WARN_TONE   88
#define MGT_MGCP_PKG_SYM_LINE_SIT_TONE            89
#define MGT_MGCP_PKG_SYM_LINE_Z_TONE              90
#define MGT_MGCP_PKG_SYM_REPORT_COMPLETION        91
#define MGT_MGCP_PKG_SYM_LINE_OFFHOOK_WARN_TONE   92
#define MGT_MGCP_PKG_SYM_LINE_TONE_PATTERN        93
#define MGT_MGCP_PKG_SYM_TDD                      94
#define MGT_MGCP_PKG_SYM_NAS_PACKET_ARRIVAL       95
#define MGT_MGCP_PKG_SYM_NAS_CALLBACK_REQUEST     96
#define MGT_MGCP_PKG_SYM_NAS_CARRIER_LOST         97
#define MGT_MGCP_PKG_SYM_NAS_AUTH_SUCCESS         98
#define MGT_MGCP_PKG_SYM_NAS_AUTH_DENIED          99
#define MGT_MGCP_PKG_SYM_ANN_ANN                 100
#define MGT_MGCP_PKG_SYM_SCRIPT_JAVA             101
#define MGT_MGCP_PKG_SYM_SCRIPT_PERL             102
#define MGT_MGCP_PKG_SYM_SCRIPT_TCL              103
#define MGT_MGCP_PKG_SYM_SCRIPT_XML              104
#define MGT_MGCP_PKG_SYM_MF_CALL_ANSWER          105
#define MGT_MGCP_PKG_SYM_MF_OPER_RINGBACK        106
#define MGT_MGCP_PKG_SYM_MF_REV_BUSY             107
#define MGT_MGCP_PKG_SYM_MF_OPER_RECALL          108
#define MGT_MGCP_PKG_SYM_MF_RELEASE_CALL         109
#define MGT_MGCP_PKG_SYM_MF_RESUME_CALL          110
#define MGT_MGCP_PKG_SYM_MF_RELEASE_COMPLETE     111
#define MGT_MGCP_PKG_SYM_MF_CALL_SETUP           112
#define MGT_MGCP_PKG_SYM_MF_SUSPEND_CALL         113
#define MGT_MGCP_PKG_SYM_MF_PERM_SIGNAL_TONE     114
#define MGT_MGCP_PKG_SYM_MF_OPER_INTR            115

#define MGT_MGCP_PKG_SYM_BRR_PATH_SETUP1                 116
#define MGT_MGCP_PKG_SYM_BRR_PATH_SETUP2                 117
#define MGT_MGCP_PKG_SYM_PCKTZN_PERIOD                   118
#define MGT_MGCP_PKG_SYM_PROF_ELMNT                      119
#define MGT_MGCP_PKG_SYM_CELL_LOSS                       120
#define MGT_MGCP_PKG_SYM_ENABLE_C_A_S                    121
#define MGT_MGCP_PKG_SYM_ENABLE_D_T_M_F_TONE             122
#define MGT_MGCP_PKG_SYM_ENABLE_M_F_TONE                 123
#define MGT_MGCP_PKG_SYM_ENABLE_M_F_R1_TONE              124
#define MGT_MGCP_PKG_SYM_ENABLE_M_F_R2_TONE              125
#define MGT_MGCP_PKG_SYM_ACCEPTANCE_TONE                 126
#define MGT_MGCP_PKG_SYM_OTHER_BUSY_TONES2               127
#define MGT_MGCP_PKG_SYM_OTHER_BUSY_TONES3               128
#define MGT_MGCP_PKG_SYM_CNFRMN_TONE_I_I                 129
#define MGT_MGCP_PKG_SYM_OTHER_CONGES_TONES2             130
#define MGT_MGCP_PKG_SYM_OTHER_CONGES_TONES3             131
#define MGT_MGCP_PKG_SYM_OTHER_DIAL_TONES2               132
#define MGT_MGCP_PKG_SYM_OTHER_DIAL_TONES3               133
#define MGT_MGCP_PKG_SYM_SECOND_DIAL_TONES1              134
#define MGT_MGCP_PKG_SYM_SECOND_DIAL_TONES2              135
#define MGT_MGCP_PKG_SYM_SECOND_DIAL_TONES3              136
#define MGT_MGCP_PKG_SYM_EXEC_OVER_RIDE_TONE             137
#define MGT_MGCP_PKG_SYM_END_OF3_PARTY_SERV              138
#define MGT_MGCP_PKG_SYM_FACILITIES_TONE                 139
#define MGT_MGCP_PKG_SYM_LINE_LOCKOUT                    140
#define MGT_MGCP_PKG_SYM_NUM_UNOBTAINABLE_I_I            141
#define MGT_MGCP_PKG_SYM_OFFERING_TONE                   142
#define MGT_MGCP_PKG_SYM_PAYPHONE_RECOG2                 143
#define MGT_MGCP_PKG_SYM_PAYPHONE_RECOG3                 144
#define MGT_MGCP_PKG_SYM_PAYPHONE_RECOG4                 145
#define MGT_MGCP_PKG_SYM_QUEUE_TONE                      146
#define MGT_MGCP_PKG_SYM_REFUSAL_TONE                    147
#define MGT_MGCP_PKG_SYM_ROUTE_TONE1                     148
#define MGT_MGCP_PKG_SYM_ROUTE_TONE2                     149
#define MGT_MGCP_PKG_SYM_RINGING_TONE2                   150
#define MGT_MGCP_PKG_SYM_RINGING_TONE3                   151
#define MGT_MGCP_PKG_SYM_RINGING_TONE4                   152
#define MGT_MGCP_PKG_SYM_SRVC_ACTIVTD_TONE               153
#define MGT_MGCP_PKG_SYM_VALID_TONE                      154
#define MGT_MGCP_PKG_SYM_WAITING_TONE1                   155
#define MGT_MGCP_PKG_SYM_WAITING_TONE2                   156
#define MGT_MGCP_PKG_SYM_WAITING_TONE3                   157
#define MGT_MGCP_PKG_SYM_WARNING_END_OR_PERIOD           158
#define MGT_MGCP_PKG_SYM_WARNING_P_I_P_TONE              159
#define MGT_MGCP_PKG_SYM_WARNING_TONE_OPER1              160
#define MGT_MGCP_PKG_SYM_WARNING_TONE_OPER2              161
#define MGT_MGCP_PKG_SYM_DTMF_TONE_DUR                   162
#define MGT_MGCP_PKG_SYM_DTMF_OO_SIG                     163
#define MGT_MGCP_PKG_SYM_GW_CNTRLD_FAX                   164
#define MGT_MGCP_PKG_SYM_NO_SP_FAX_HNDLNG                165
#define MGT_MGCP_PKG_SYM_T38_FAX_RELAY                   166
#define MGT_MGCP_PKG_SYM_TONE_ON_HOLD                    167
#define MGT_MGCP_PKG_SYM_RECORDER_WARNING_TONE           168
#define MGT_MGCP_PKG_SYM_LINE_SIDE_ANSWER_SUP            169
#define MGT_MGCP_PKG_SYM_NETWORK_DIS_CONN                170
#define MGT_MGCP_PKG_SYM_PRECEDENCE_RINGING              171
#define MGT_MGCP_PKG_SYM_PRECEDENCE_RINGBACK             172
#define MGT_MGCP_PKG_SYM_INTERMEDIATE_RES                173
#define MGT_MGCP_PKG_SYM_ACK_WINK                        174
#define MGT_MGCP_PKG_SYM_INFO_DGTS                       175
#define MGT_MGCP_PKG_SYM_START_WINK                      176
#define MGT_MGCP_PKG_SYM_CONTINUE_WINK                   177
#define MGT_MGCP_PKG_SYM_OUT_CALL_REQ                    178
#define MGT_MGCP_PKG_SYM_CALL_REQ                        179
#define MGT_MGCP_PKG_SYM_ICMP_UNREACHABLE                180
#define MGT_MGCP_PKG_SYM_RTP_OR_RTCP_TIMEOUT             181
#define MGT_MGCP_PKG_SYM_RESOURCE_LOST                   182
#define MGT_MGCP_PKG_SYM_LOAD_AND_RUN_V_X_M_L_DOC        183
#define MGT_MGCP_PKG_SYM_CONFERENCE_DEPART               184
#define MGT_MGCP_PKG_SYM_CONFERENCE_JOIN                 185
#define MGT_MGCP_PKG_SYM_COMFORT_TONE                    186
#define MGT_MGCP_PKG_SYM_CALLER_WAITING_TONE             187
#define MGT_MGCP_PKG_SYM_NEGATIVE_IND                    188
#define MGT_MGCP_PKG_SYM_PAYPHONE_RECOG                  189
#define MGT_MGCP_PKG_SYM_NEWEST_MILLIWATT_TONE           190
#define MGT_MGCP_PKG_SYM_TEST_PATTERN                    191
#define MGT_MGCP_PKG_SYM_QUIET_TERMINATION               192

#define MGT_MGCP_PKG_SYM_LINE_CALLER_ID1                 193
#define MGT_MGCP_PKG_SYM_LINE_CALLER_ID2                 194
#define MGT_MGCP_PKG_SYM_LINE_CALLER_ID3                 195

/*
 * [TEL]: New hash defines for 4 MGCP Packages 
 */
#define MGT_MGCP_PKG_SYM_FEATURE_KEY1          196
#define MGT_MGCP_PKG_SYM_FEATURE_KEY2          197
#define MGT_MGCP_PKG_SYM_FEATURE_KEY3          198
#define MGT_MGCP_PKG_SYM_FEATURE_KEY4          199
#define MGT_MGCP_PKG_SYM_FEATURE_KEY5          200
#define MGT_MGCP_PKG_SYM_FEATURE_KEY6          201       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY7          202
#define MGT_MGCP_PKG_SYM_FEATURE_KEY8          203   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY9          204
#define MGT_MGCP_PKG_SYM_FEATURE_KEY10          205
#define MGT_MGCP_PKG_SYM_FEATURE_KEY11          206
#define MGT_MGCP_PKG_SYM_FEATURE_KEY12          207
#define MGT_MGCP_PKG_SYM_FEATURE_KEY13          208
#define MGT_MGCP_PKG_SYM_FEATURE_KEY14          209
#define MGT_MGCP_PKG_SYM_FEATURE_KEY15          210 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY16          211       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY17          212
#define MGT_MGCP_PKG_SYM_FEATURE_KEY18          213   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY19          214
#define MGT_MGCP_PKG_SYM_FEATURE_KEY20          215
#define MGT_MGCP_PKG_SYM_FEATURE_KEY21          216
#define MGT_MGCP_PKG_SYM_FEATURE_KEY22          217
#define MGT_MGCP_PKG_SYM_FEATURE_KEY23          218
#define MGT_MGCP_PKG_SYM_FEATURE_KEY24          219
#define MGT_MGCP_PKG_SYM_FEATURE_KEY25          220 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY26          221       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY27          222
#define MGT_MGCP_PKG_SYM_FEATURE_KEY28          223   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY29          224
#define MGT_MGCP_PKG_SYM_FEATURE_KEY30          225
#define MGT_MGCP_PKG_SYM_FEATURE_KEY31          226
#define MGT_MGCP_PKG_SYM_FEATURE_KEY32          227
#define MGT_MGCP_PKG_SYM_FEATURE_KEY33          228
#define MGT_MGCP_PKG_SYM_FEATURE_KEY34          229
#define MGT_MGCP_PKG_SYM_FEATURE_KEY35          230 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY36          231       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY37          232
#define MGT_MGCP_PKG_SYM_FEATURE_KEY38          233   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY39          234
#define MGT_MGCP_PKG_SYM_FEATURE_KEY40          235
#define MGT_MGCP_PKG_SYM_FEATURE_KEY41          236
#define MGT_MGCP_PKG_SYM_FEATURE_KEY42          237
#define MGT_MGCP_PKG_SYM_FEATURE_KEY43          238
#define MGT_MGCP_PKG_SYM_FEATURE_KEY44          239
#define MGT_MGCP_PKG_SYM_FEATURE_KEY45          240 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY46          241       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY47          242
#define MGT_MGCP_PKG_SYM_FEATURE_KEY48          243   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY49          244
#define MGT_MGCP_PKG_SYM_FEATURE_KEY50          245
#define MGT_MGCP_PKG_SYM_FEATURE_KEY51          246
#define MGT_MGCP_PKG_SYM_FEATURE_KEY52          247
#define MGT_MGCP_PKG_SYM_FEATURE_KEY53          248
#define MGT_MGCP_PKG_SYM_FEATURE_KEY54          249
#define MGT_MGCP_PKG_SYM_FEATURE_KEY55          250 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY56          251       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY57          252
#define MGT_MGCP_PKG_SYM_FEATURE_KEY58          253   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY59          254
#define MGT_MGCP_PKG_SYM_FEATURE_KEY60          255
#define MGT_MGCP_PKG_SYM_FEATURE_KEY61          256
#define MGT_MGCP_PKG_SYM_FEATURE_KEY62          257
#define MGT_MGCP_PKG_SYM_FEATURE_KEY63          258
#define MGT_MGCP_PKG_SYM_FEATURE_KEY64          259
#define MGT_MGCP_PKG_SYM_FEATURE_KEY65          260 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY66          261       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY67          262
#define MGT_MGCP_PKG_SYM_FEATURE_KEY68          263   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY69          264
#define MGT_MGCP_PKG_SYM_FEATURE_KEY70          265
#define MGT_MGCP_PKG_SYM_FEATURE_KEY71          266
#define MGT_MGCP_PKG_SYM_FEATURE_KEY72          267
#define MGT_MGCP_PKG_SYM_FEATURE_KEY73          268
#define MGT_MGCP_PKG_SYM_FEATURE_KEY74          269
#define MGT_MGCP_PKG_SYM_FEATURE_KEY75          270 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY76          271       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY77          272
#define MGT_MGCP_PKG_SYM_FEATURE_KEY78          273   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY79          274
#define MGT_MGCP_PKG_SYM_FEATURE_KEY80          275
#define MGT_MGCP_PKG_SYM_FEATURE_KEY81          276
#define MGT_MGCP_PKG_SYM_FEATURE_KEY82          277
#define MGT_MGCP_PKG_SYM_FEATURE_KEY83          278
#define MGT_MGCP_PKG_SYM_FEATURE_KEY84          279
#define MGT_MGCP_PKG_SYM_FEATURE_KEY85          280 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY86          281       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY87          282
#define MGT_MGCP_PKG_SYM_FEATURE_KEY88          283   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY89          284
#define MGT_MGCP_PKG_SYM_FEATURE_KEY90          285
#define MGT_MGCP_PKG_SYM_FEATURE_KEY91          286
#define MGT_MGCP_PKG_SYM_FEATURE_KEY92          287
#define MGT_MGCP_PKG_SYM_FEATURE_KEY93          288
#define MGT_MGCP_PKG_SYM_FEATURE_KEY94          289
#define MGT_MGCP_PKG_SYM_FEATURE_KEY95          290 
#define MGT_MGCP_PKG_SYM_FEATURE_KEY96          291       
#define MGT_MGCP_PKG_SYM_FEATURE_KEY97          292
#define MGT_MGCP_PKG_SYM_FEATURE_KEY98          293   
#define MGT_MGCP_PKG_SYM_FEATURE_KEY99          294
#define MGT_MGCP_PKG_SYM_KEY_STATE              295
#define MGT_MGCP_PKG_SYM_SET_LABEL              296
#define MGT_MGCP_PKG_SYM_BEEP                   297
#define MGT_MGCP_PKG_SYM_EM_RQNT_FAIL           298
#define MGT_MGCP_PKG_SYM_OBS_EVTS_FUL           299
#define MGT_MGCP_PKG_SYM_QRTIN_BUF_OF           300

#define MGT_MGCP_PKG_SYM_CONTINUITY_TRSPDR      301
#define MGT_MGCP_PKG_SYM_RESOURCE_ERROR         302

/* [TEL]: New Hash define for Extn Param */
#define MGT_MGCP_PKG_EP_UNKNOWN_EXTN            0   

#define MGT_MGCP_PKG_SYM_MAX                     303

/* Constants for NAS packages */

/* Property IDs - nas */
#define MGT_PKG_NAS_PROP_SESSID                    1
#define MGT_PKG_NAS_PROP_CONNTYP                   2

/* Event IDs - nas */
#define MGT_PKG_NAS_EVT_NASFAIL                    1
#define MGT_PKG_NAS_EVT_NASREL                     2

/* Event parameter IDs - nas */
#define MGT_PKG_NAS_EVT_NASFAIL_EC                 1
#define MGT_PKG_NAS_EVT_NASREL_REASON              1

/* Property IDs - nasin */
#define MGT_PKG_NASIN_PROP_CLGSTAT                 3
#define MGT_PKG_NASIN_PROP_CLGNUM                  4
#define MGT_PKG_NASIN_PROP_CLDNUM                  5

/* Event IDs - nasin */ 
#define MGT_PKG_NASIN_EVT_AUTHRES                  3

/* Event parameter IDs - nasin */
#define MGT_PKG_NASIN_EVT_AUTHRES_RES              1
#define MGT_PKG_NASIN_EVT_AUTHRES_DIALNUM          2

/* Property IDs - nasout */
#define MGT_PKG_NASOUT_PROP_DIALNUM                3
#define MGT_PKG_NASOUT_PROP_HANDLE                 4

/* Event IDs - nasctl */
#define MGT_PKG_NASCTL_EVT_CALLREQ                 1

/* Event parameter IDs - nasctl */
#define MGT_PKG_NASCTL_EVT_CALLREQ_DIALNUM         1
#define MGT_PKG_NASCTL_EVT_CALLREQ_HANDLE          2

/* Property IDs - nasroot */
#define MGT_PKG_NASROOT_PROP_NAMPAT                1
#define MGT_PKG_NASROOT_PROP_CTLNAM                2
#define MGT_PKG_NASROOT_PROP_AVALMODEMS            3
#define MGT_PKG_NASROOT_PROP_NASADDTIME            4


/* Arbitrary maximum values for dynamically allocated memory */
/* Please tune to your requirements. */
/* Max block size in call to cmAllocEvnt() depends on these values. */

#define MGT_MAX_TERMS               100
#define MGT_MAX_VALUES              100
#define MGT_MAX_PROPPARMS           100
#define MGT_MAX_LCLPARMS            100
#define MGT_MAX_DIGRNGS             100
#define MGT_MAX_DIGSTRELEMS         100
/* 003.main_15: Changed value from 100 */
#define MGT_MAX_DIGSTRS             255
#define MGT_MAX_EVTSECPARMS         100
#define MGT_MAX_EVTSECS             100
#define MGT_MAX_EVTSPECPARMS        100
#define MGT_MAX_EVTPARMS            100
#define MGT_MAX_EVTS                100
#define MGT_MAX_NTFYREASONS         100
#define MGT_MAX_TOPODESCS           100
#define MGT_MAX_OBSEVTPARMS         100
#define MGT_MAX_OBSEVTS             100
#define MGT_MAX_SIGPARS             100
#define MGT_MAX_SIGREQS             100
#define MGT_MAX_SIGDESCPARMS        100
#define MGT_MAX_EVSPECS             100
#define MGT_MAX_AUDS                100
#define MGT_MAX_PKGSITEMS           100
#define MGT_MAX_STATSPARS           100
#define MGT_MAX_MODEMTYPES          100
#define MGT_MAX_MEDIAPARS           100
#define MGT_MAX_AUDRETPARMS         100
#define MGT_MAX_AMMPARMS            100
#define MGT_MAX_CMDREPLYS           100
#define MGT_MAX_ACTIONREPLYS        100
#define MGT_MAX_CMDREQS             100
#define MGT_MAX_ACTIONREQS          100
#define MGT_MAX_TXNACKS             100
#define MGT_MAX_TXNS                5
#ifdef GCP_CH
#define MGT_MAX_CMDS                50 
#define MGT_ONE_CMD                 1
#endif /* GCP_CH */

/* Maxima used for package support */
#define MGT_MAX_SIGNAMES            100

/*milton redefine package specific to unknown for v2*/
#ifdef MGT_MGCO_V2

#define  mgMgcoIndAudStatsParUnknownPkgDef mgMgcoPkgdNameDef /*special */

#define  mgMgcoIndAudReqEvtUnknownPkgDef  mgMgcoPkgdNameDef /* special */

#endif
/* end milton redefs */



/******************************************************************************/
/*                        Error Codes                                         */
/******************************************************************************/
/* error codes */
#define EMGTBASE 0
#define EMGTXXX EMGTBASE        
#define ERRMGT  EMGTBASE         

/* error codes will go here */
#define   EMGT001      (ERRMGT +    1)    /*        mgt.c:15659 */
#define   EMGT002      (ERRMGT +    2)    /*        mgt.c:15675 */
#define   EMGT003      (ERRMGT +    3)    /*        mgt.c:15724 */
#define   EMGT004      (ERRMGT +    4)    /*        mgt.c:15774 */
#define   EMGT005      (ERRMGT +    5)    /*        mgt.c:15790 */
#define   EMGT006      (ERRMGT +    6)    /*        mgt.c:15837 */
#define   EMGT007      (ERRMGT +    7)    /*        mgt.c:15881 */
#define   EMGT008      (ERRMGT +    8)    /*        mgt.c:15897 */
#define   EMGT009      (ERRMGT +    9)    /*        mgt.c:15906 */
#define   EMGT010      (ERRMGT +   10)    /*        mgt.c:15910 */
#define   EMGT011      (ERRMGT +   11)    /*        mgt.c:15957 */
#define   EMGT012      (ERRMGT +   12)    /*        mgt.c:15973 */
#define   EMGT013      (ERRMGT +   13)    /*        mgt.c:15982 */
#define   EMGT014      (ERRMGT +   14)    /*        mgt.c:15995 */
#define   EMGT015      (ERRMGT +   15)    /*        mgt.c:15999 */
#define   EMGT016      (ERRMGT +   16)    /*        mgt.c:16044 */
#define   EMGT017      (ERRMGT +   17)    /*        mgt.c:16060 */
#define   EMGT018      (ERRMGT +   18)    /*        mgt.c:16069 */
#define   EMGT019      (ERRMGT +   19)    /*        mgt.c:16073 */
#define   EMGT020      (ERRMGT +   20)    /*        mgt.c:16120 */
#define   EMGT021      (ERRMGT +   21)    /*        mgt.c:16136 */
#define   EMGT022      (ERRMGT +   22)    /*        mgt.c:16145 */
#define   EMGT023      (ERRMGT +   23)    /*        mgt.c:16149 */
#define   EMGT024      (ERRMGT +   24)    /*        mgt.c:16194 */
#define   EMGT025      (ERRMGT +   25)    /*        mgt.c:16211 */
#define   EMGT026      (ERRMGT +   26)    /*        mgt.c:16218 */
#define   EMGT027      (ERRMGT +   27)    /*        mgt.c:16267 */
#define   EMGT028      (ERRMGT +   28)    /*        mgt.c:16272 */
#define   EMGT029      (ERRMGT +   29)    /*        mgt.c:16273 */
#define   EMGT030      (ERRMGT +   30)    /*        mgt.c:16320 */
#define   EMGT031      (ERRMGT +   31)    /*        mgt.c:16325 */
#define   EMGT032      (ERRMGT +   32)    /*        mgt.c:16326 */
#define   EMGT033      (ERRMGT +   33)    /*        mgt.c:16373 */
#define   EMGT034      (ERRMGT +   34)    /*        mgt.c:16378 */
#define   EMGT035      (ERRMGT +   35)    /*        mgt.c:16379 */
#define   EMGT036      (ERRMGT +   36)    /*        mgt.c:16423 */
#define   EMGT037      (ERRMGT +   37)    /*        mgt.c:16428 */
#define   EMGT038      (ERRMGT +   38)    /*        mgt.c:16429 */
#define   EMGT039      (ERRMGT +   39)    /*        mgt.c:16478 */
#define   EMGT040      (ERRMGT +   40)    /*        mgt.c:16483 */
#define   EMGT041      (ERRMGT +   41)    /*        mgt.c:16484 */
#define   EMGT042      (ERRMGT +   42)    /*        mgt.c:16485 */
#define   EMGT043      (ERRMGT +   43)    /*        mgt.c:16529 */
#define   EMGT044      (ERRMGT +   44)    /*        mgt.c:16534 */
#define   EMGT045      (ERRMGT +   45)    /*        mgt.c:16535 */
#define   EMGT046      (ERRMGT +   46)    /*        mgt.c:16584 */
#define   EMGT047      (ERRMGT +   47)    /*        mgt.c:16589 */
#define   EMGT048      (ERRMGT +   48)    /*        mgt.c:16590 */
#define   EMGT049      (ERRMGT +   49)    /*        mgt.c:16591 */
#define   EMGT050      (ERRMGT +   50)    /*        mgt.c:16635 */
#define   EMGT051      (ERRMGT +   51)    /*        mgt.c:16640 */
#define   EMGT052      (ERRMGT +   52)    /*        mgt.c:16641 */
#define   EMGT053      (ERRMGT +   53)    /*        mgt.c:16686 */
#define   EMGT054      (ERRMGT +   54)    /*        mgt.c:16702 */
#define   EMGT055      (ERRMGT +   55)    /*        mgt.c:16711 */
#define   EMGT056      (ERRMGT +   56)    /*        mgt.c:16715 */
#define   EMGT057      (ERRMGT +   57)    /*        mgt.c:16762 */
#define   EMGT058      (ERRMGT +   58)    /*        mgt.c:16778 */
#define   EMGT059      (ERRMGT +   59)    /*        mgt.c:16787 */
#define   EMGT060      (ERRMGT +   60)    /*        mgt.c:16791 */
#define   EMGT061      (ERRMGT +   61)    /*        mgt.c:16837 */
#define   EMGT062      (ERRMGT +   62)    /*        mgt.c:16853 */
#define   EMGT063      (ERRMGT +   63)    /*        mgt.c:16862 */
#define   EMGT064      (ERRMGT +   64)    /*        mgt.c:16866 */
#define   EMGT065      (ERRMGT +   65)    /*        mgt.c:16913 */
#define   EMGT066      (ERRMGT +   66)    /*        mgt.c:16929 */
#define   EMGT067      (ERRMGT +   67)    /*        mgt.c:16938 */
#define   EMGT068      (ERRMGT +   68)    /*        mgt.c:16942 */
#define   EMGT069      (ERRMGT +   69)    /*        mgt.c:33001 */
#define   EMGT070      (ERRMGT +   70)    /*        mgt.c:33013 */
#define   EMGT071      (ERRMGT +   71)    /*        mgt.c:33108 */
#define   EMGT072      (ERRMGT +   72)    /*        mgt.c:33120 */
#define   EMGT073      (ERRMGT +   73)    /*        mgt.c:33209 */
#define   EMGT074      (ERRMGT +   74)    /*        mgt.c:33226 */
#define   EMGT075      (ERRMGT +   75)    /*        mgt.c:33234 */
#define   EMGT076      (ERRMGT +   76)    /*        mgt.c:33279 */
#define   EMGT077      (ERRMGT +   77)    /*        mgt.c:33296 */
#define   EMGT078      (ERRMGT +   78)    /*        mgt.c:33304 */
#define   EMGT079      (ERRMGT +   79)    /*        mgt.c:33349 */
#define   EMGT080      (ERRMGT +   80)    /*        mgt.c:33366 */
#define   EMGT081      (ERRMGT +   81)    /*        mgt.c:33374 */
#define   EMGT082      (ERRMGT +   82)    /*        mgt.c:33419 */
#define   EMGT083      (ERRMGT +   83)    /*        mgt.c:33436 */
#define   EMGT084      (ERRMGT +   84)    /*        mgt.c:33444 */
#define   EMGT085      (ERRMGT +   85)    /*        mgt.c:33491 */
#define   EMGT086      (ERRMGT +   86)    /*        mgt.c:33504 */
#define   EMGT087      (ERRMGT +   87)    /*        mgt.c:33549 */
#define   EMGT088      (ERRMGT +   88)    /*        mgt.c:33550 */
#define   EMGT089      (ERRMGT +   89)    /*        mgt.c:33587 */
#define   EMGT090      (ERRMGT +   90)    /*        mgt.c:33588 */
#define   EMGT091      (ERRMGT +   91)    /*        mgt.c:33625 */
#define   EMGT092      (ERRMGT +   92)    /*        mgt.c:33626 */
#define   EMGT093      (ERRMGT +   93)    /*        mgt.c:33663 */
#define   EMGT094      (ERRMGT +   94)    /*        mgt.c:33664 */
#define   EMGT095      (ERRMGT +   95)    /*        mgt.c:33702 */
#define   EMGT096      (ERRMGT +   96)    /*        mgt.c:33703 */
#define   EMGT097      (ERRMGT +   97)    /*        mgt.c:33704 */
#define   EMGT098      (ERRMGT +   98)    /*        mgt.c:33741 */
#define   EMGT099      (ERRMGT +   99)    /*        mgt.c:33742 */
#define   EMGT100      (ERRMGT +  100)    /*        mgt.c:33780 */
#define   EMGT101      (ERRMGT +  101)    /*        mgt.c:33781 */
#define   EMGT102      (ERRMGT +  102)    /*        mgt.c:33782 */
#define   EMGT103      (ERRMGT +  103)    /*        mgt.c:33819 */
#define   EMGT104      (ERRMGT +  104)    /*        mgt.c:33820 */
#define   EMGT105      (ERRMGT +  105)    /*        mgt.c:33863 */
#define   EMGT106      (ERRMGT +  106)    /*        mgt.c:33880 */
#define   EMGT107      (ERRMGT +  107)    /*        mgt.c:33888 */
#define   EMGT108      (ERRMGT +  108)    /*        mgt.c:33933 */
#define   EMGT109      (ERRMGT +  109)    /*        mgt.c:33950 */
#define   EMGT110      (ERRMGT +  110)    /*        mgt.c:33958 */
#define   EMGT111      (ERRMGT +  111)    /*        mgt.c:34005 */
#define   EMGT112      (ERRMGT +  112)    /*        mgt.c:34022 */
#define   EMGT113      (ERRMGT +  113)    /*        mgt.c:34030 */
#define   EMGT114      (ERRMGT +  114)    /*        mgt.c:34075 */
#define   EMGT115      (ERRMGT +  115)    /*        mgt.c:34092 */
#define   EMGT116      (ERRMGT +  116)    /*        mgt.c:34100 */

#define   EMGT117      (ERRMGT +  117)    /*    mgt_ref.c:8821 */
#define   EMGT118      (ERRMGT +  118)    /*    mgt_ref.c:8826 */
#define   EMGT119      (ERRMGT +  119)    /*    mgt_ref.c:8827 */
#define   EMGT120      (ERRMGT +  120)    /*    mgt_ref.c:8871 */
#define   EMGT121      (ERRMGT +  121)    /*    mgt_ref.c:8876 */
#define   EMGT122      (ERRMGT +  122)    /*    mgt_ref.c:8877 */
#define   EMGT123      (ERRMGT +  123)    /*    mgt_ref.c:8921 */
#define   EMGT124      (ERRMGT +  124)    /*    mgt_ref.c:8926 */
#define   EMGT125      (ERRMGT +  125)    /*    mgt_ref.c:8927 */
#define   EMGT126      (ERRMGT +  126)    /*    mgt_ref.c:8971 */
#define   EMGT127      (ERRMGT +  127)    /*    mgt_ref.c:8976 */
#define   EMGT128      (ERRMGT +  128)    /*    mgt_ref.c:8977 */
#define   EMGT129      (ERRMGT +  129)    /*    mgt_ref.c:9023 */
#define   EMGT130      (ERRMGT +  130)    /*    mgt_ref.c:9028 */
#define   EMGT131      (ERRMGT +  131)    /*    mgt_ref.c:9029 */
#define   EMGT132      (ERRMGT +  132)    /*    mgt_ref.c:9030 */
#define   EMGT133      (ERRMGT +  133)    /*    mgt_ref.c:9074 */
#define   EMGT134      (ERRMGT +  134)    /*    mgt_ref.c:9079 */
#define   EMGT135      (ERRMGT +  135)    /*    mgt_ref.c:9080 */
#define   EMGT136      (ERRMGT +  136)    /*    mgt_ref.c:9126 */
#define   EMGT137      (ERRMGT +  137)    /*    mgt_ref.c:9131 */
#define   EMGT138      (ERRMGT +  138)    /*    mgt_ref.c:9132 */
#define   EMGT139      (ERRMGT +  139)    /*    mgt_ref.c:9133 */
#define   EMGT140      (ERRMGT +  140)    /*    mgt_ref.c:9177 */
#define   EMGT141      (ERRMGT +  141)    /*    mgt_ref.c:9182 */
#define   EMGT142      (ERRMGT +  142)    /*    mgt_ref.c:9183 */
#define   EMGT143      (ERRMGT +  143)    /*    mgt_ref.c:9228 */
#define   EMGT144      (ERRMGT +  144)    /*    mgt_ref.c:9244 */
#define   EMGT145      (ERRMGT +  145)    /*    mgt_ref.c:9253 */
#define   EMGT146      (ERRMGT +  146)    /*    mgt_ref.c:9257 */
#define   EMGT147      (ERRMGT +  147)    /*    mgt_ref.c:9301 */
#define   EMGT148      (ERRMGT +  148)    /*    mgt_ref.c:9317 */
#define   EMGT149      (ERRMGT +  149)    /*    mgt_ref.c:9326 */
#define   EMGT150      (ERRMGT +  150)    /*    mgt_ref.c:9330 */
#define   EMGT151      (ERRMGT +  151)    /*    mgt_ref.c:9376 */
#define   EMGT152      (ERRMGT +  152)    /*    mgt_ref.c:9392 */
#define   EMGT153      (ERRMGT +  153)    /*    mgt_ref.c:9401 */
#define   EMGT154      (ERRMGT +  154)    /*    mgt_ref.c:9405 */
#define   EMGT155      (ERRMGT +  155)    /*    mgt_ref.c:9449 */
#define   EMGT156      (ERRMGT +  156)    /*    mgt_ref.c:9465 */
#define   EMGT157      (ERRMGT +  157)    /*    mgt_ref.c:9474 */
#define   EMGT158      (ERRMGT +  158)    /*    mgt_ref.c:9478 */
#define   EMGT159      (ERRMGT +  159)    /*    mgt_ref.c:18400 */
#define   EMGT160      (ERRMGT +  160)    /*    mgt_ref.c:18401 */
#define   EMGT161      (ERRMGT +  161)    /*    mgt_ref.c:18438 */
#define   EMGT162      (ERRMGT +  162)    /*    mgt_ref.c:18439 */
#define   EMGT163      (ERRMGT +  163)    /*    mgt_ref.c:18476 */
#define   EMGT164      (ERRMGT +  164)    /*    mgt_ref.c:18477 */
#define   EMGT165      (ERRMGT +  165)    /*    mgt_ref.c:18514 */
#define   EMGT166      (ERRMGT +  166)    /*    mgt_ref.c:18515 */
#define   EMGT167      (ERRMGT +  167)    /*    mgt_ref.c:18553 */
#define   EMGT168      (ERRMGT +  168)    /*    mgt_ref.c:18554 */
#define   EMGT169      (ERRMGT +  169)    /*    mgt_ref.c:18555 */
#define   EMGT170      (ERRMGT +  170)    /*    mgt_ref.c:18592 */
#define   EMGT171      (ERRMGT +  171)    /*    mgt_ref.c:18593 */
#define   EMGT172      (ERRMGT +  172)    /*    mgt_ref.c:18631 */
#define   EMGT173      (ERRMGT +  173)    /*    mgt_ref.c:18632 */
#define   EMGT174      (ERRMGT +  174)    /*    mgt_ref.c:18633 */
#define   EMGT175      (ERRMGT +  175)    /*    mgt_ref.c:18670 */
#define   EMGT176      (ERRMGT +  176)    /*    mgt_ref.c:18671 */
#define   EMGT177      (ERRMGT +  177)    /*    mgt_ref.c:18714 */
#define   EMGT178      (ERRMGT +  178)    /*    mgt_ref.c:18731 */
#define   EMGT179      (ERRMGT +  179)    /*    mgt_ref.c:18739 */
#define   EMGT180      (ERRMGT +  180)    /*    mgt_ref.c:18784 */
#define   EMGT181      (ERRMGT +  181)    /*    mgt_ref.c:18801 */
#define   EMGT182      (ERRMGT +  182)    /*    mgt_ref.c:18809 */
#define   EMGT183      (ERRMGT +  183)    /*    mgt_ref.c:18856 */
#define   EMGT184      (ERRMGT +  184)    /*    mgt_ref.c:18873 */
#define   EMGT185      (ERRMGT +  185)    /*    mgt_ref.c:18881 */
#define   EMGT186      (ERRMGT +  186)    /*    mgt_ref.c:18926 */
#define   EMGT187      (ERRMGT +  187)    /*    mgt_ref.c:18943 */
#define   EMGT188      (ERRMGT +  188)    /*    mgt_ref.c:18951 */

#ifdef GCP_CH
 
/* CH Command Types */
#define CM_CMD_TYPE_NONE  0       /* Command Type undefined   */
#define CH_CMD_TYPE_REQ   1       /* Command Request          */
#define CH_CMD_TYPE_RSP   2       /* Command Response         */
#define CH_CMD_TYPE_IND   3       /* Command Indication       */
#define CH_CMD_TYPE_CFM   4       /* Command Confirmation     */

#define MAX_CNTXT_MEM_SIZE    50   /* For Cntxt Update       */
#define MAX_ERR_MEM_SIZE      30   /* For error string       */
/* Axn Req type  */
#define CH_AXN_TYPE_NONE         0 /* None                             */
#define CH_AXN_TYPE_ONLY_CNTXT   1 /* Only context prop present in Axn */
#define CH_AXN_TYPE_ONLY_CMDS    2 /* Only commands present in Axn     */
#define CH_AXN_TYPE_BOTH         3 /* Commands and Context Property    */
                                   /* both present in Axn              */
#define CH_MIN_CMDS_IN_AXN       1 /* Min no. of commands in action    */
#define CH_MIN_AXNS_IN_TXN       1 /* Min no. of actions in txn        */
/* Command Status values */
#define CH_CMD_STATUS_NONE       0  /* Command Flag not set                  */
#define CH_CMD_STATUS_PENDING    1  /* More commands pending for this action */
#define CH_CMD_STATUS_END_OF_AXN 2  /* End of action but more cmds pending   */
                                    /* for this transaction                  */
#define CH_CMD_STATUS_END_OF_TXN 3  /* Last command for this transaction     */
#define CH_CMD_STATUS_END_OF_RSP 4  /* Last command resp for this indication */
/* mgt_h_010.main_15: CH-Module Redesign changes added new command Status */
#define CH_CMD_STATUS_END_OF_CMD 5  /* End of Command */
 
#define CH_PRIM_TYPE_CMD         1  /* CMD Primitive            */ 
#define CH_PRIM_TYPE_UPD_CNTXT   2  /* Update Context Primitive */
#define CH_PRIM_TYPE_IND         3  /* CH Indication            */

/* Axn index defines  */
#define CH_FIRST_AXN_ID          0  /* First AxnId              */ 
#define CH_FIRST_CMD_IND_ID      0  /* First command Id         */

/* Adding some more defines as per Rashim's changes             */
#define MG_CH_TXN_REQ            1  /* Transaction Request      */
#define MG_CH_TXN_INDRSP_USR     2  /* Transaction Response     */
#define MG_CH_TXN_INDRSP     2  /* Transaction Response     */
#define MG_CH_TXN_INDRSP_PEER    3  /* Transaction Response     */

#endif /* GCP_CH */

/* 003.main_15: Added Annex C support for GCP_ASN */
#ifdef GCP_ASN

/* Hashdef for annex C */
#define MGA_ANNEX_C_PKGID                       0
#define MGA_ANNEXC_MAXNUM                       133
#define MGA_PCMSB_MAXNUM                        13

/* PCMSB Package events/signals */
#define MGT_PKG_ENUM_PCMSBSB1_0 1
#define MGT_PKG_ENUM_PCMSBSB1_1 2
#define MGT_PKG_ENUM_PCMSBSB4_0 3
#define MGT_PKG_ENUM_PCMSBSB4_1 4
#define MGT_PKG_ENUM_PCMSBSB5_0 5
#define MGT_PKG_ENUM_PCMSBSB5_1 6
#define MGT_PKG_ENUM_PCMSBSB6_0 7
#define MGT_PKG_ENUM_PCMSBSB6_1 8
#define MGT_PKG_ENUM_PCMSBSB7_0 9
#define MGT_PKG_ENUM_PCMSBSB7_1 10
#define MGT_PKG_ENUM_PCMSBSB8_0 11
#define MGT_PKG_ENUM_PCMSBSB8_1 12

/* Enumerations of properties defined first */
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIA_AUDIO 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIA_VIDEO 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIA_DATA 2
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TRANSMISSIONMODE_SEND 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TRANSMISSIONMODE_RECEIVE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TRANSMISSIONMODE_SENDRECEIVE 2
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SILENCESUPP_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SILENCESUPP_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ECHOCANC_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ECHOCANC_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIATX_TDMCIRCUIT 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIATX_ATM 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIATX_FR 2
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIATX_IPV4 3
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MEDIATX_IPV6 4
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_CBR 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_NRTVBR1 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_NRTVBR2 2
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_NRTVBR3 3
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_RTVBR1 4
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_RTVBR2 5
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_RTVBR3 6
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_UBR1 7
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_UBR2 8
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SC_ABR 9
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_DBR 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_SBR1 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_SBR2 2
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_SBR3 3
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_ABTIT 4
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_ABTDT 5
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ATC_ABR 6
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_BEI_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_BEI_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TI_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TI_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_FD_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_FD_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_PORT_TYPE_TCP 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_PORT_TYPE_UDP 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_PORT_TYPE_SCTP 2
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TCI_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_TCI_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_CONTCHECK_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_CONTCHECK_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SYNCASYNC_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_SYNCASYNC_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_NEGOTIATION_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_NEGOTIATION_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_NICTX_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_NICTX_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_NICRX_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_NICRX_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_FLOWCONTTX_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_FLOWCONTTX_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_FLOWCONTRX_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_FLOWCONTRX_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_RATEADAPTHDR_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_RATEADAPTHDR_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MULTIFRAME_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_MULTIFRAME_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_OPMODE_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_OPMODE_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_LLIDNEGOT_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_LLIDNEGOT_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ASSIGN_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_ASSIGN_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_INBANDNEG_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_INBANDNEG_TRUE 1
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_DUPLEXMODE_FALSE 0
#define MGT_PKG_ENUM_PROPPARM_ANNEXC_DUPLEXMODE_TRUE 1

/* Definitions of the properties */
#define MGT_PKG_PROP_PARM_ANNEX_C1_MEDIA        1
#define MGT_PKG_PROP_PARM_ANNEX_C1_TRANS_MODE   2
#define MGT_PKG_PROP_PARM_ANNEX_C1_NO_CHAN      3
#define MGT_PKG_PROP_PARM_ANNEX_C1_SAMP_RATE    4
#define MGT_PKG_PROP_PARM_ANNEX_C1_BIT_RATE     5
#define MGT_PKG_PROP_PARM_ANNEX_C1_A_CODEC      6
#define MGT_PKG_PROP_PARM_ANNEX_C1_SAMP_PP      7
#define MGT_PKG_PROP_PARM_ANNEX_C1_SIL_SUP      8
#define MGT_PKG_PROP_PARM_ANNEX_C1_ENCR_TYP     9
#define MGT_PKG_PROP_PARM_ANNEX_C1_ENCR_KEY     10
#define MGT_PKG_PROP_PARM_ANNEX_C1_ECHO_CAN     11
#define MGT_PKG_PROP_PARM_ANNEX_C1_GAIN         12
#define MGT_PKG_PROP_PARM_ANNEX_C1_JIT_BUF      13
#define MGT_PKG_PROP_PARM_ANNEX_C1_PROP_DEL     14
#define MGT_PKG_PROP_PARM_ANNEX_C1_RTP_PAY_LOAD 15
#define MGT_PKG_PROP_PARM_ANNEX_C1_PTIME        16

#define MGT_PKG_PROP_PARM_ANNEX_C2_H222         17 
#define MGT_PKG_PROP_PARM_ANNEX_C2_H223         18 
#define MGT_PKG_PROP_PARM_ANNEX_C2_V76          19
#define MGT_PKG_PROP_PARM_ANNEX_C2_H2250        20

#define MGT_PKG_PROP_PARM_ANNEX_C3_MEDIA_TX     21
#define MGT_PKG_PROP_PARM_ANNEX_C3_BIR          22
#define MGT_PKG_PROP_PARM_ANNEX_C3_NSAP         23

#define MGT_PKG_PROP_PARM_ANNEX_C4_AESA         24
#define MGT_PKG_PROP_PARM_ANNEX_C4_VPVC         25
#define MGT_PKG_PROP_PARM_ANNEX_C4_SC           26   
#define MGT_PKG_PROP_PARM_ANNEX_C4_BCOB         27  
#define MGT_PKG_PROP_PARM_ANNEX_C4_BBTC         28
#define MGT_PKG_PROP_PARM_ANNEX_C4_ATC          29
#define MGT_PKG_PROP_PARM_ANNEX_C4_STC          30
#define MGT_PKG_PROP_PARM_ANNEX_C4_UPCC         31
#define MGT_PKG_PROP_PARM_ANNEX_C4_PCR0         32
#define MGT_PKG_PROP_PARM_ANNEX_C4_SCR0         33
#define MGT_PKG_PROP_PARM_ANNEX_C4_MBS0         34
#define MGT_PKG_PROP_PARM_ANNEX_C4_PCR1         35
#define MGT_PKG_PROP_PARM_ANNEX_C4_SCR1         36
#define MGT_PKG_PROP_PARM_ANNEX_C4_MBS1         37
#define MGT_PKG_PROP_PARM_ANNEX_C4_BEI          38
#define MGT_PKG_PROP_PARM_ANNEX_C4_TI           39
#define MGT_PKG_PROP_PARM_ANNEX_C4_FD           40
#define MGT_PKG_PROP_PARM_ANNEX_C4_A2PCDV       41
#define MGT_PKG_PROP_PARM_ANNEX_C4_C2PCDV       42
#define MGT_PKG_PROP_PARM_ANNEX_C4_APPCDV       43
#define MGT_PKG_PROP_PARM_ANNEX_C4_CPPCDV       44
#define MGT_PKG_PROP_PARM_ANNEX_C4_ACLR         45
#define MGT_PKG_PROP_PARM_ANNEX_C4_MEETD        46
#define MGT_PKG_PROP_PARM_ANNEX_C4_CEETD        47
#define MGT_PKG_PROP_PARM_ANNEX_C4_QOSClASS     48
#define MGT_PKG_PROP_PARM_ANNEX_C4_AALTYPE      49

#define MGT_PKG_PROP_PARM_ANNEX_C5_DLCI         50
#define MGT_PKG_PROP_PARM_ANNEX_C5_CID          51
#define MGT_PKG_PROP_PARM_ANNEX_C5_SID_NOIS     52
#define MGT_PKG_PROP_PARM_ANNEX_C5_PRI_PL_TYPE  53
  
#define MGT_PKG_PROP_PARM_ANNEX_C6_IPV4         54
#define MGT_PKG_PROP_PARM_ANNEX_C6_IPV6         55
#define MGT_PKG_PROP_PARM_ANNEX_C6_PORT         56
#define MGT_PKG_PROP_PARM_ANNEX_C6_PORT_TYPE    57
#define MGT_PKG_PROP_PARM_ANNEX_C6_RTCPBWRS     58
#define MGT_PKG_PROP_PARM_ANNEX_C6_RTCPBWRR     59

#define MGT_PKG_PROP_PARM_ANNEX_C7_AESA         60
#define MGT_PKG_PROP_PARM_ANNEX_C7_ALC          61
#define MGT_PKG_PROP_PARM_ANNEX_C7_SSCS         62
#define MGT_PKG_PROP_PARM_ANNEX_C7_SUT          63
#define MGT_PKG_PROP_PARM_ANNEX_C7_TCI          64
#define MGT_PKG_PROP_PARM_ANNEX_C7_TMR_CU       65
#define MGT_PKG_PROP_PARM_ANNEX_C7_MAX_CPSSDU   66
#define MGT_PKG_PROP_PARM_ANNEX_C7_CID          67

#define MGT_PKG_PROP_PARM_ANNEX_C8_AAL1ST       68
#define MGT_PKG_PROP_PARM_ANNEX_C8_CBRR         69
#define MGT_PKG_PROP_PARM_ANNEX_C8_SCRI         70
#define MGT_PKG_PROP_PARM_ANNEX_C8_ECM          71
#define MGT_PKG_PROP_PARM_ANNEX_C8_SDTB         72
#define MGT_PKG_PROP_PARM_ANNEX_C8_PFCI         73

#define MGT_PKG_PROP_PARM_ANNEX_C9_TMR          74
#define MGT_PKG_PROP_PARM_ANNEX_C9_TMR_SR       75
#define MGT_PKG_PROP_PARM_ANNEX_C9_CONT_CHK     76
#define MGT_PKG_PROP_PARM_ANNEX_C9_ITC          77
#define MGT_PKG_PROP_PARM_ANNEX_C9_TRANS_MODE   78
#define MGT_PKG_PROP_PARM_ANNEX_C9_TRANS_RATE   79
#define MGT_PKG_PROP_PARM_ANNEX_C9_MULT         80
#define MGT_PKG_PROP_PARM_ANNEX_C9_LAY1_PROT    81
#define MGT_PKG_PROP_PARM_ANNEX_C9_SYN_ASYN     82
#define MGT_PKG_PROP_PARM_ANNEX_C9_NEGOT        83
#define MGT_PKG_PROP_PARM_ANNEX_C9_USER_RATE    84
#define MGT_PKG_PROP_PARM_ANNEX_C9_INT_RATE     85
#define MGT_PKG_PROP_PARM_ANNEX_C9_NICTX        86
#define MGT_PKG_PROP_PARM_ANNEX_C9_NICRX        87
#define MGT_PKG_PROP_PARM_ANNEX_C9_FLOW_CNT_TX  88
#define MGT_PKG_PROP_PARM_ANNEX_C9_FLOW_CNT_RX  89
#define MGT_PKG_PROP_PARM_ANNEX_C9_RATE_ADP_HDR 90
#define MGT_PKG_PROP_PARM_ANNEX_C9_MUL_FRAME    91
#define MGT_PKG_PROP_PARM_ANNEX_C9_OP_MODE      92
#define MGT_PKG_PROP_PARM_ANNEX_C9_LL_ID_NEGOT  93
#define MGT_PKG_PROP_PARM_ANNEX_C9_ASSIGN       94
#define MGT_PKG_PROP_PARM_ANNEX_C9_IN_BAND_NEG  95
#define MGT_PKG_PROP_PARM_ANNEX_C9_STOP_BITS    96
#define MGT_PKG_PROP_PARM_ANNEX_C9_DATA_BITS    97 
#define MGT_PKG_PROP_PARM_ANNEX_C9_PARITY       98 
#define MGT_PKG_PROP_PARM_ANNEX_C9_DUP_MOD      99 
#define MGT_PKG_PROP_PARM_ANNEX_C9_MODEM        100
#define MGT_PKG_PROP_PARM_ANNEX_C9_LAY2_PROT    101
#define MGT_PKG_PROP_PARM_ANNEX_C9_LAY3_PROT    102
#define MGT_PKG_PROP_PARM_ANNEX_C9_ADD_LAY3_PROT 103
#define MGT_PKG_PROP_PARM_ANNEX_C9_DAIL_NUM     104
#define MGT_PKG_PROP_PARM_ANNEX_C9_DAILING_NUM  105
#define MGT_PKG_PROP_PARM_ANNEX_C9_ECHOCI       106
#define MGT_PKG_PROP_PARM_ANNEX_C9_NCI          107
/* mgt_h_013.main_15: Changed below macro from MGT_PKG_PROP_PARM_ANNEX_C9_UCI to 
 * MGT_PKG_PROP_PARM_ANNEX_C9_USI - a typo*/
#define MGT_PKG_PROP_PARM_ANNEX_C9_USI          108

#define MGT_PKG_PROP_PARM_ANNEX_C10_FMSDU       109
#define MGT_PKG_PROP_PARM_ANNEX_C10_BMSDU       110

#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_V       111 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_O       112 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_S       113 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_I       114 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_U       115 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_E       116 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_P       117 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_C       118 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_B       119 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_Z       120 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_K       121 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_A       122 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_T       123 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_R       124 
#define MGT_PKG_PROP_PARM_ANNEX_C11_SDP_M       125

#define MGT_PKG_PROP_PARM_ANNEX_C12_OLC         126        
#define MGT_PKG_PROP_PARM_ANNEX_C12_OLCACK      127
#define MGT_PKG_PROP_PARM_ANNEX_C12_OLCCNF      128
#define MGT_PKG_PROP_PARM_ANNEX_C12_OLCREJ      129
#define MGT_PKG_PROP_PARM_ANNEX_C12_CLC         130
#define MGT_PKG_PROP_PARM_ANNEX_C12_CLCACK      131
#define MGT_PKG_PROP_PARM_ANNEX_C12_LCN         132

#endif /* GCP_ASN */

/* mgt_h_011.main_15: Added New Defines to Support LCN */
#ifdef GCP_LCN_APP_USE
#define MGT_LCN_TYPE_NONE                       0
#define MGT_LCN_TYPE_SCTP                       1
#define MGT_LCN_TYPE_MTP3                       2
#endif /* GCP_LCN_APP_USE */


#endif /* not defined __MGTH__ */

/********************************************************************30**

         End of file:     mgt.h@@/main/21 - Fri Dec 11 01:07:15 2009

*********************************************************************31*/

/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      rrp  1. initial release.
1.1+         001.101  bbk  1. Added MGT_MGCP_RSP_CODE_PROVISIONAL
             002.101  bbk  1. The values for MGT_DESC_EVENT_RANGE and
                              MGT_DESC_EVENT_ALL were not in accordance
                              with database defintion. Changed that
                           2. Increased MGT_MAX_DGT_MAP to 10
             003.101  bbk  1. Added MGT_PARAM_RSTRT_CANCL_GRCFUL as one
                              of the methods that can be used in RSIP
/main/3      ---       pk  1. Modified for new release.
                           2. Added Support for MEGACO.
                           3. Added defines for user control request/
                              status.
/main/4      ---       sk  1. Changed order of #defines for MGT_TERMST_*.
                           2. Added #defines for more MGT_SUPP_MODEs.
                           3. Added #defines for MGT_PKG_ON and MGT_PKG_OFF
/main/5      ---       vj  1.  Addition of Peer status reason. 
/main/6      ---       vj  1. Addition of error code for incorrect version in 
                              MGCP
/main/7      ---       vj  1. Addition of a new define for size of MID string 
                              array.
                       ra  2. Addition of new hash defs for supporting signed
                              integers.
/main/8      ---      rg   1. GCP 1.3 release
/main/9  001.main_8   ra   1. New package identifiers added for MGCP Audio
                              server packages -
                              MGT_MGCP_PKG_AU_SRVR_BAU
                              MGT_MGCP_PKG_AU_SRVR_AAU
/main/10  002.main_8   ra   1. Added a new hash define -
                              MGT_MAX_TERM_STATE_PARMS
                              for the maximum number of termination state
                              parameters.
                           2. Changed the MGT interface version MGTIFVER.
                           3. Added a new hash define -
                              CM_TRANS_MAXBLKSIZE
                              which is used in cmAllocEvnt in RUG related
                              translation.
                           4. Added a new macro def -
                              CM_TRANSLATE_FUNC()
                              which can be used to easily write the RUG
                              related translation functions. The hash def
                              CM_TRANS_MAXBLKSIZE is used in this macro.
/main/11  003.main_8   ra   1. Moved the macro def CM_TRANSLATE_FUNC and
                              the hash def CM_TRANS_MAXBLKSIZE to cm_sdp.h
                              so that the other products like SIP can
                              use it. mgt.c includes cm_sdp.h
/main/12  004.main_8   ra   1. Added hash defines -
                              MGT_PKG_ROOT_PROP_MGPROVRSPTMRVAL
                              MGT_PKG_ROOT_PROP_MGCPROVRSPTMRVAL
                              for the changed package.
/main/13     ---   rg   1. Added hash defines for MEGACO error codes
                              MGT_MGCO_RSP_CODE_UNAUTHORIZED
                              MGT_MGCO_RSP_CODE_UNAUTH_ENTITY

/main/14     ---      TEL Constants included and updated for the following  
                          packages:
                          1. Bearer Characteristic Package
                          2. Bearer Network Connection Cut Through Package
                          3. Reuse Idle Package
                          4. Generic Bearer Connection Package
                          5. Bearer Control Tunneling Package 
                          6. Basic Call Progress Tones Generator with 
                             Directionality Package
                          7. Expanded Call Progress Tones Generator Package
                          8. Basic Services Tone Generator Package
                          9. Expanded Services Tone Generation Package
                          10. Intrusion Tone Generation Package
                          11. Business Tone Generation Package
                          12. 3GUP User Plane Package
                          13. Circuit Switched Data Package
                          14. TFO Package
                          15. 3G Expanded Call Progress Tones Generator 
                              Package
                          16. Modification of Link characteristics Bearer 
                              Capability Package
                          17. Cellular Text Telephone Modem Text Transport 
                              Package
                          18. IP Transport Package
                          19. Flexible Tone Generator Package
                          20. Media Gateway Resource Congestion Handling 
                              Package
                          21. Quiet Termination Line Test Component Package
                          22. Loop back Line Test Response Package
                          23. ITU-T 404Hz Line Test Package
                          24. ITU-T 816Hz Line Test Package
                          25. ITU-T 1020Hz Line Test Package
                          26. ITU-T 2100Hz Disable Tone Line Test Package
                          27. ITU-T 2100Hz Disable Echo Chancellor Tone Line 
                              Test Package
                          28. ITU-T 2804Hz Tone Line Test Package
                          29. ITU-T Noise Test Tone Line Test Package
                          30. ITU-T Digital Pseudo Random Test Tone Line Test 
                              Package
                          31. ITU-T ATME No.2 Test Line Response Package
                          32. ANSI 1004Hz Test Tone Line Test Package
                          33. ANSI Test Responder Line Test Package
                          34. ANSI 2225Hz Test Progress Tone Line Test Package
                          35. ANSI Digital Test Signal line Test Package
                          36. ANSI Inverting Loop Back Line Test Response 
                              Package
                          37. Basic CAS Package
                          38. Basic CAS Addressing Package
                          39. Robbed Bit Signaling Package
                          40. Operator Service and Emergency Services Package
                          41. Operator Service and Extension Package
                          42. Inactivity Timer Package
                          43. Feature Key Package
                          44. Business Phone Package
                          45. Display XML Package
                          46. Base Package  
/main/15     ---      TEL2 Constants included and updated for the following  
                          packages:
                          1. Media Gateway Overload Control package 
                          2. Floor Control package
                          3. Indication of being viewed package
                          4. Volume Control package
                          5. Volume Detection package
                          6. Volume Level Mixing package
                          7. Voice Activated Video Switch package
                          8. Lecture Video Mode package
                          9. Contributing Video Source package
                          10. Profile package
                          11. Semi-permanent connection package
                          12. Video Window package
                          13. Tiled Window package
                          14. Enhanced Alerting package
                          15. Shared Risk Group package
                          16. Mixing Volume Level Control package
                          17. CAS Blocking package
                          18. Conferencing Tones Generation package
                          19. Diagnostic Tones Generation package
                          20. Carrier Tones Generation package
                          21. Analog Display Signalling package
                          22. Extended Analog Line Supervision package
                          23. Automatic Metering package
                          24. H.324 package
                          25. H.245 Command package
                          26. H.245 Indication package
                          27. Extended H.245 Command package
                          28. Extended H.245 Indication package
                          29. Quality Alert Ceasing package
                          30. Extended H.324 package
                          31. Adaptive Jitter Buffer package
                          32. International CAS package
                          33. Multi-Frequency Tone Generation package
                          34. Multi-Frequency Tone Detection package
                          35. Extended DTMF Detection package
                          36. Enhanced DTMF Detection package
/main/16     ---      TEL3 Constants included and updated for the following  
                          packages:
                           1. MSF UK Call Progess Tones Generator package
                           2. MSF UK Announcement package
                           3. MSF UK Analogue Line package
                           4. MSF UK Automatic Metering package
/main/15     ---      pk   1. GCP 1.5 release
/main/15 001.main_15  ps   1. Added new error code(533) to send to peer in case
                              response size is greater then configured MTU size 
                              for the peer.
         002.main_15  ps   1. Modify maximum number of terminationStateParms 
                           2. Package Id for Enhanced Circuit Switched
                              Data Package Added
                           3. Package Id for Stimulus Lines Analogue 
                              Package added 
   mgt_h_003.main_15  gk   1. Added Annex C support for GCP_ASN
                           2. Changed value from 100
                           3. Added definition for Nx64
   mgt_h_004.main_15  gk   1. Order changed according to ASN values
                           2. Added Bool type to support in ASN
                           3. Changed Unknown Package Id from 0 to 254 
                              because ASN Annex C uses package id 0 
                              To support unknown package changed to 254
                           4. Addition of error code for Unsupported Package
   mgt_h_005.main_15  gk   1. Handling for wild card context
   mgt_h_006.main_15  gk   1. Changed the hash defines for indaud parameters
   mgt_h_007.main_15  gk   1. Hanging Term package introduced
   mgt_h_008.main_15  gk   1. Pending Limit exceeded in the receiving side
   mgt_h_009.main_15  gk   1. SPNE Package introduced 
   mgt_h_010.main_15  gk   1. CH-Module Redesign changes added 
                              new command Status and event
   mgt_h_011.main_15  rb   1. Added new defineds to support LCN Feature.
   mgt_h_012.main_15  rb   1. Added support for Call Trace Pkg
   mgt_h_013.main_15  ac   1. Added Status Ind for blocking messages sent
                              before Ctrl Assoc is established
                           2. Fix typo error MGT_PKG_PROP_PARM_ANNEX_C9_USI
   mgt_h_014.main_15  sm   1. Including the provision of sending status indication to user when 
                              FO/HO occurs.                        
/main/16     ---      gk   1. Added new error code(533) to send to peer in case
                              response size is greater then configured MTU size 
                              for the peer.
                           2. Modify maximum number of terminationStateParms 
                           3. Package Id for Enhanced Circuit Switched
                              Data Package Added
                           4. Package Id for Stimulus Lines Analogue 
                              Package added 
                           5. Added Annex C support for GCP_ASN
                           6. Changed value from 100
                           7. Added definition for Nx64
                           8. Order changed according to ASN values
                           9. Added Bool type to support in ASN
                           10. Changed Unknown Package Id from 0 to 254 
                              because ASN Annex C uses package id 0 
                              To support unknown package changed to 254
                           11. Addition of error code for Unsupported Package
                           12. Handling for wild card context
/main/17     ---      gk   1. Releasing main/15 patches
/main/18     ---      gk   1. Changed the hash defines for indaud parameters
                           2. Hanging Term package introduced
                           3. Pending Limit exceeded in the receiving side
                           4. SPNE Package introduced 
                           5. CH-Module Redesign changes added 
                              new command Status and event
                           6. Added new defineds to support LCN Feature.
                           7. Added support for Call Trace Pkg
                           8. Added Status Ind for blocking messages sent
                              before Ctrl Assoc is established
                           9. Fix typo error MGT_PKG_PROP_PARM_ANNEX_C9_USI
/main/19     ---      ac   1. Including the provision of sending status indication to
                              user when FO/HO occurs.
                           2. Including the provision of sending status indication
                              (profile) to user when profile received in SVC Reply
                           3. Added macro for length of profile   
/main/20     ----     sy   GCP 2.1 release                           
/main/21     ---      mgt_h_001.main_20  gk   1. Added Error Ind for invalid MID.
*********************************************************************91*/
