/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**
 
     Name:     GCP 
 
     Type:     C include file
  
     Desc:     GCP module structures and prototypes.
 
     File:     mg.x

     Sid:      mg.x@@/main/7 - Wed Nov 14 22:43:41 2007
  
     Prg:      bbk
  
*********************************************************************21*/
  
/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     
*
*/
 
/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     
*    
*   
*
*/


#ifndef __MGX__
#define __MGX__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Forward Declarations */
typedef struct _mgCb           MgCb;            /* Global Control Block */
typedef struct mgTSAPCb       MgTSAPCb;        /* TSAP Control Block */
typedef struct mgSSAPCb       MgSSAPCb;        /* SSAP Control Block */


typedef struct mgPeerLst      MgPeerLst;       /* List of GCP Peers */

typedef struct mgPeerCb       MgPeerCb;        /* Peer Control Block */
typedef struct mgTptSrvr      MgTptSrvr;       /* Transport Server */
typedef struct mgStoreList    MgStoreList;     /* List of Event Structure */
typedef struct mgRvUpdQNode   MgRvUpdQNode;    /* List of Queued messages */

#ifdef CM_ABNF_MT_LIB
typedef struct mgDfrCfm       MgDfrCfm;        /* Deffered Cfm Pst/Header */
#endif /* CM_ABNF_MT_LIB */

/*****************************************************************************/
/*                                                                           */
/*                  Global Variables and Data Structures                     */
/*                                                                           */
/*****************************************************************************/

#ifdef GCP_MGCP
/* Static Array for Checking Paramter validity in Commands/Response messages */
EXTERN   U8  mgCmdDb[MG_MAX_MGCP_PROFILES][MG_MAX_MGCP_MSGS][MG_MAX_MGCP_PARAMS];
EXTERN   U8  mgRspDb[MG_MAX_MGCP_PROFILES][MG_MAX_MGCP_MSGS][MG_MAX_MGCP_PARAMS];

/* Array for ensuring all mandatory parameters for a command are present */
EXTERN   U8  mgNmbMandPerCmd[MG_MAX_MGCP_PROFILES][MG_MAX_MGCP_MSGS]; 
#endif /* GCP_MGCP */

typedef   U32   MgTransId;             /* Transaction Identifier */


struct mgStoreList
{
   U16             nodeIndx;             /* node index */
   MgStoreList     *next;                /* next node */
   Ptr             info;                 /* information */
};

struct mgRvUpdQNode
{
   U8              qType;                /* Queue in which node is queued */
   U8              prot;                 /* protocol - MGCP/MEGACO */
   U16             rvSeqNum;             /* sequence num for reverse update */
   U32             peerId;               /* peerid of peer with node */
   Ptr             info;                 /* information */
   CmTimer         tRvUpd;               /* timer control block for rev update*/
   MgRvUpdQNode    *next;                /* next node */
   MgRvUpdQNode    *prev;                /* previous node */
};

/* DNS Information Structure */
typedef struct mgDnsInfo
{
   State           dnsState;           /* State of DNS */
   MgTptSrvr       *dnsLstnr;          /* DNS Listener */
#ifdef CM_DNS_LIB
   CmDnsCb         *dnsCb;             /* Common DNS Structure */
#endif /* CM_DNS_LIB */
#ifdef ZG
   CmPFthaRsetMap  mapCb;                /* mapping CB for PSF */
#endif /* ZG */
}MgDnsInfo;


/* List of Listeners */
typedef struct mgLstnrLst
{
   UConnId         index;              /* Index into Listener List */
   MgTptSrvr       *lstnrCb;           /* Listener Control Block */
}MgLstnrLst;

/* Transport Server Information */
typedef struct mgTptSrvrInfo
{
   CmLListCp       srvrLstCp;          /* Server List Information */
#ifdef GCP_MGCO
#ifdef GCP_MGC
   MgTptSrvr       *nxtSrvr2Use;       /* Next Server to Use for Redirection */
#endif /* GCP_MGC */
#endif /* GCP_MGCO */
}MgTptSrvrInfo;


/*
 *   Added end point control block and association
 *   control block to support SCTP
 */

#ifdef    GCP_PROV_SCTP

/*
 *   Encoding scheme is endpoint dependent since the spec says
 *   that cmds shd be sent to the 2944 port for text encoding
 *   and 2945 port for binary encoding. Thus at the other end
 *   2 different endpoints (servers) are required listening
 *   at these 2 ports.
 */

typedef struct mgEndpCb
{
   CmHashListCp    assocCp;            /* SU assoc Id based associations HL */
   UConnId         locSpEndpId;        /* SCTP allocated SP end point Id */
   UConnId         locSuEndpId;        /* GCP allocated SU end point Id */
   State           epState;            /* end point state */
   SctPort         port;               /* SCTP port for this end point */
   U8              encodingScheme;     /* text or binary */
   /* mg001.105: TOS support changes */
   U8              defaultTos;         /* default configured TOS */
#ifdef GCP_ENDP_SRCIPADDR_CFG
/* mg017.105: Added support for Multi IP addr Cfg */
#ifdef SCT_ENDP_MULTI_IPADDR
   SctNetAddrLst   srcAddrLst;    /* source address list */
#else
   /* mg016.105: Src IP Addres Cfg */
   CmNetAddr       srcNetAddr;                 /* Source Net IP Addr */
#endif
#endif /* GCP_ENDP_SRCIPADDR_CFG */
} MgEndpCb;


typedef struct mgAssocCb
{
   CmHashListEnt   hlEnt;              /* pointed to by the end point CB */
   UConnId         spAssocId;          /* SCTP assigned association Id */
   UConnId         suAssocId;          /* GCP assigned association Id */
   State           assocState;         /* association state */
   CmTimer         idleTmr;            /* idle timer */
   MgPeerCb        *peer;              /* pointer to peer CB */
   MgAssocCfg      *assocCfg;          /* pointer to assoc Cfg struct */
   SctStrmId       nxtOutStrmId;       /* next strm id for non int ctx Ids */
   MgTSAPCb        *tsap;              /* pointer to TSAP CB (endpoint) */
#ifdef ZG
   CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
#endif /* ZG */   
/* mg016.105: Added LCN Feature Information */
#ifdef GCP_LCN_APP_USE
   Bool            indReq;             /* Assoc Est Indication Required to 
                                          the application */
#endif /* GCP_LCN_APP_USE */
} MgAssocCb;


typedef struct mgSuAssocLl
{
   CmLList         lkEnt;              /* pointed to by the TSAP ll      */
   UConnId         suAssocId;          /* assoc Id to be added to the ll */
} MgSuAssocLl;


#endif    /* GCP_PROV_SCTP */



/* TSAP Control Block */
struct mgTSAPCb
{
   MgTSAPCfg       tsapCfg;            /* TSAP Configuration */
   CmTimer         bndTmr;             /* Timer for Bind Request */
   UConnId         nxtFreeIdx;         /* Next Free Socket Idx for servers */
   MgLstnrLst      **lstnrLst;         /* suConnId based list for servers */
   UConnId         nxtConnIdx;         /* Next Free TCP Conn. Idx for suConnId */
   Bool            connIdxWrapArnd;    /* nxtConnId has wrapped arnd ?  */
   CmHashListCp    tptSrvrLstCp;       /* suConnId based list for sockets */
   U8              bndRetxCnt;         /* Bind Retry Count */
   U8              contEnt;            /* Controlling Entity */
   U16             crntActvSsap;       /* Current Active SSAPs */
   State           state;              /* Sap State */
   Bool            cfgDone;            /* to detect reconfig */
   Bool            resCong;            /* resource congestion state */
   MgDnsInfo       dnsInfo;            /* DNS Information */
#ifdef GCP_MGCP
   U32             ttl;                /* TTL Value - For Status Purposes */
   MgTptSrvrInfo   mgcpUDPSrvrLst;     /* UDP Server Information */
   MgTptSrvr       *nxtUseMgcpSrvr;    /* Next UDP Socket to be used for TX */ 
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
   MgTptSrvrInfo   mgcoUDPSrvrLst;     /* UDP Server Information */
   MgTptSrvr       *nxtUseMgcoSrvr;
#if   (defined(GCP_VER_2_1) || defined(GCP_MGC))
   MgTptSrvrInfo   mgcoTCPSrvrLst;        /* Redirect TCP Server Information */
#endif /* GCP_MGC or GCP_VER_2_1 */
#endif /* GCP_MGCO */

   Pst             spPst;              /* Service Provider Post */
   MgTSAPSts       sts;                /* statistics related to TSAP */
   S16             trcLen;             /* Trace Length */
#ifdef ZG
#ifdef ZG_DFTHA
   /* This queue stores event structures received from peers which are 
    *  unknown. Once the state update for the peer information is
    * received from Master, these queued events will be processed.
    * Typically transactions which cannot be proccessed by shadow GCP copies
    * will be queued (e.g SrvcChng Cmd/response, RSIP Cmd/response) */
   MgRvUpdQNode    rvUpdQ;        
   MgRvUpdQNode   *rvNode;             /* node allocated for storing info */
#endif /* ZG_DFTHA */
   CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
#endif /* ZG */

   /* Rolling upgrade: added a flag to indicate if the remote version
    * number in the post structure is valid or not
    */
#ifdef MG_RUG
   Bool            remIntfValid;       /* Version number valid ? */
#endif /* MG_RUG */  


   /*
    *   added the following fields to support SCTP -
    *      1) ssap pointer on the MG side
    *      2) end point cfg done flag
    *      3) end point control block
    *      4) variables related to SU association Ids
    */

#ifdef    GCP_PROV_SCTP
#ifdef    GCP_MG
   MgSSAPCb        *ssap;              /* pointer to SSAP */
#endif    /* GCP_MG */

   Bool            endpCfgDone;        /* end point configuration done? */
   MgEndpCb        endpCb;             /* end point control block */
   UConnId         nxtSuAssocId;       /* GCP's SU association Id */
   Bool            assocIdWrpd;        /* has SU assoc Id wrapped around? */
   CmLListCp       termAssocsCp;       /* linked list of terminated assocs */
#endif    /* GCP_PROV_SCTP */

   /* 
    *  Following  field is added for MTP3 Transport .
    * mgco MTP  Hash List shall contain list of all peerCb hashed on DPC
    * SrvInfo field is derived through SSF in mgNwCfg Field + SI_MGCO
    */

#ifdef   GCP_PROV_MTP3
   SrvInfo         sInfo;              /* Service Info Field SubService + SI_MGCO (1110) */
   CmHashListCp    mgcoMtpHlCp;        /* Route Hash List Based on DPC */
   Bool            mtpRstStart;        /* Flag to indicate that MTP3 has restarted */
   CmTimer         rstEndTmr;       /* Timer to Monitor Restart End Procedure */
/* mg016.105: Added LCN Feature Information */
#ifdef GCP_LCN_APP_USE
   LnkSel          nextLnkSelId;       /* Link Selector Information */ 
#endif /* GCP_LCN_APP_USE */
#endif   /* GCP_PROV_MTP3 */
};

/* PeerId based Peer List */
struct mgPeerLst
{
   U32             index;              /* Index into List */
   MgPeerCb        *peer;              /* Peer Control Block */
};

#ifdef CM_ABNF_MT_LIB
struct mgDfrCfm 
{
   /* dfrdCfm: TRUE/FALSE, if true then deffered cfm will be sent afterwards
    * In case, CM_ABNF_MT_LIB flag is defined and shutdown req is rcvd, then cfm
    * is not sent immediately , if some Enc/Dec Cfms pending */
   Bool            dfrdCfm;
   Pst             dfrdPst;    /* Cmf Post structure */ 
   Header          dfrdHdr;    /* deffered header */
};
#endif /* CM_ABNF_MT_LIB */
#ifdef MG_RUG
typedef struct mgIntVerInfo
{
   U16          numIntfInfo;    /* Number of store intf ver info            */
   ShtVerInfo   *intfInfo;      /* Interface version info store             */
#ifdef ZG
   CmPFthaRsetMap  mapCb;                /* mapping CB for PSF */
#endif /* ZG */
} MgIntVerInfo;
#endif /* MG_RUG */

#ifdef GCP_CH
 
/* forward references */
typedef struct mgMgcoChTransIndRsp MgMgcoChTransIndRsp;
typedef struct mgMgcoChTransReq MgMgcoChTransReq;
typedef struct mgMgcoChAxnIndRsp MgMgcoChAxnIndRsp;
typedef struct mgMgcoChAxnReq MgMgcoChAxnReq;


/**** General Typedefs for CH Module ****/
typedef U32    MgMgcoChActionId;        /* Action Identifier  */
typedef U32    ActionId;        /* Action Identifier  */
typedef U32    CmdId;           /* Command Identifier */
 
/**** Context Property Structure  ****/
typedef struct mgMgcoChCntxtProp 
{

    TknPres                 pres;      /* Whether above fields are present  */  
    MgMgcoContextId         cxtId;     /* Context ID                        */
    CmLList                 node;      /* List node                         */
    MgMgcoChActionId        actionId;  /* Action Identifier                 */    
    S32                     wildActionId;    /* Current Action Identifier     */
    MgMgcoContextProps      cxtProps;  /* Context properties                */
    MgMgcoContextAudit      cxtAud;    /* Context audit                     */
    /* references to the transIndRsp or transReq parent struct */
    U8                      txnType;   /* values - MG_CH_TXN_INDRSP_PEER,
                                        *          MG_CH_TXN_INDRSP_USR,
                                        *          MG_CH_TXN_REQ       */
    union
    {
       MgMgcoChTransIndRsp  *txnIndRsp; /* ptr to parent txnIndRsp */
                                        /*     OR               */
       MgMgcoChTransReq     *txnReq;    /* ptr to parent txnReq */
    } u;

#ifdef ZG
    CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
#endif /* ZG */
} MgMgcoChCntxtProp;
 
/* CH Command Response structure */
typedef struct mgMgcoChCmdResp
{
   CmdId            cmdIndId;    /* command Indication Identifier */
   CmLList           node;       /* LinkedList Node               */
   MgMgcoCmdReply   *cmdResp;    /* Command Response              */ 
   /* references to the parent struct */
   MgMgcoChAxnIndRsp   *axnIndRsp;   /* ptr to the parent struct */

#ifdef ZG
   CmPFthaRsetMap  mapCb;            /* mapping CB for PSF */
#endif /* ZG */
} MgMgcoChCmdResp; 

/* Command Ind information used for filling  */
/* termId when response times out */
typedef struct mgMgcoCmdIndInfo
{
   U8             type;    /* Command Type   */
#ifdef GCP_VER_2_1
   MgMgcoTermIdLst      termIdLst;          /* special - termination ID list */
#else
   MgMgcoTermId         termId;             /* Termination ID - NOT list */
#endif /* GCP_VER_2_1 */
   /* [UG]: Adding a new field for wild */
   TknPres        wild;    /* Wildcard return "W-"? */
   /* [UG]: Adding a new field for opt */
   TknPres        opt;     /* Is command optional "O-"? */
   /* references to the parent struct */
   CmdId          cmdId;   /* command id */
   MgMgcoChAxnIndRsp   *axnIndRsp;   /* ptr to the parent struct */

#ifdef ZG
   CmPFthaRsetMap  mapCb;            /* mapping CB for PSF */
#endif /* ZG */
} MgMgcoCmdIndInfo; 
 
/**** Action Indication and Response Structure   ****/
struct mgMgcoChAxnIndRsp 
{
    CmdId            curCmdIndId;    /* Current working command Identifier */
    TknU8            type;           /* CH_AXN_TYPE_NONE .. CH_AXN_TYPE_BOTH */
    MgMgcoContextId  cntxtId;        /* Context Id                         */       
    U32              numOfCmdInds;   /* Number of Command Indications      */
    MgMgcoCommandReq **cmdInds;      /* Command Indication and Responses   */ 
    MgMgcoCmdIndInfo **cmdIndInfo;   /* Command Indication Info            */
    CmLListCp        respLst;        /* Command Response List contains node*/
                                     /* of type MgMgcoChCmdResp            */
    MgMgcoErrDesc    err;            /* Error descriptor                   */
    /* references to the parent struct */
    ActionId         actionId;       /* Action Identifier */    
    MgMgcoChTransIndRsp   *txnIndRsp;/* ptr to parent struct */

    /* mg008.105:ccpu00067069 Handling for wild card context */
   Bool                   wildCardPres; 
   U32                    numOfWildCardRspAxns;/* Number of IndRsp Axns         */
   S32                   curWildActionId;    /* Current Action Identifier     */
   MgMgcoChAxnIndRsp      **axnIndWildCardRsp;    /* Actions contains command      */
#ifdef ZG
    CmPFthaRsetMap  mapCb;           /* mapping CB for PSF */
#endif /* ZG */
/* mg016.105 : Added  LCN Feature Related Information */
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo   lcnInfoFromApp;    /* Lcn info coming from the application */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
};

/* mg008.105: Handling for wild card context */
/**** Action Indication and Response Structure   ****/
struct mgMgcoChAxnIndWildCardRsp 
{
    TknU8            type;           /* CH_AXN_TYPE_NONE .. CH_AXN_TYPE_BOTH */
    MgMgcoContextId  cntxtId;        /* Context Id                         */       
    CmLListCp        respLst;        /* Command Response List contains node*/
                                     /* of type MgMgcoChCmdResp            */
    MgMgcoErrDesc    err;            /* Error descriptor                   */
    /* references to the parent struct */
    ActionId         actionId;       /* Action Identifier */    
    MgMgcoChAxnIndRsp    *axnIndRsp;/* ptr to parent struct */

};


/**** CH Transaction Indication and Response Structure ****/
struct mgMgcoChTransIndRsp 
{
   MgMgcoTransId          transId;        /* Transaction Identifier        */
   U32                    peerId;         /* Peer Idendtifier              */ 
   TknU8                  type;           /* CH_AXN_TYPE_NONE ..           */
                                          /* CH_AXN_TYPE_BOTH              */
   CmHashListEnt          transEnt;       /* Hash List Entry               */
   U32                    numOfIndRspAxns;/* Number of IndRsp Axns         */
   MgMgcoChAxnIndRsp      **axnIndRsp;    /* Actions contains command      */
                                          /* indication and response       */  
   CmLListCp              userCntxtLst;   /* Context Property List contains*/ 
                                          /* node of type MgMgcoChCntxtProp*/
                                          /* received from user            */
   CmLListCp              chCntxtLst;     /* Context Property List contains*/ 
                                          /* node of type MgMgcoChCntxtProp*/
                                          /* received from peer            */
   MgMgcoChActionId       curActionId;    /* Current Action Identifier     */

#ifdef ZG
   CmPFthaRsetMap  mapCb;                 /* mapping CB for PSF */
#endif /* ZG */
/* mg016.105 : Added  LCN Feature Related Information */
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo   lcnInfo;                /* LCN Info to the  Appli*/
   MgMgtLcnInfo   lcnInfoFromApp;         /* LCN Info from the Appli */
#endif /* GCP_LCN_APP_USE */
};

/* CH Mgco Command Request */
typedef struct mgMgcoChCmdReq
{
   CmLList           node;      /* LinkedList Node */
   /* Should we make it a pointer */
   MgMgcoCommandReq  *cmdReq;   /* Command REq     */
   /* references to the parent struct */
   CmdId             cmdId;     /* Command Id */
   MgMgcoChAxnReq    *axnReq;   /* ptr to the parent struct */

#ifdef ZG
   CmPFthaRsetMap  mapCb;       /* mapping CB for PSF */
#endif /* ZG */
}MgMgcoChCmdReq;
 
/**** Action request Structure   ****/
struct mgMgcoChAxnReq
{
   MgMgcoChActionId  actionId;  /* Action Identifier                      */    
   CmLList           node;      /* LinkedList Node                        */
   MgMgcoContextId   cntxtId;   /* Context Id                             */       
   CmLListCp         cmdReqLst; /* Command Request List contains  node    */ 
                                /* of type MgMgcoChCmdReq                 */
   /* references to the parent struct */
   MgMgcoChTransReq  *txnReq;   /* pointer to the parent struct */

#ifdef ZG
   CmPFthaRsetMap  mapCb;       /* mapping CB for PSF */
#endif /* ZG */
};

 
/**** CH Transaction Request Structure ****/
struct mgMgcoChTransReq 
{
   MgMgcoTransId     transId;         /* Transaction Identifier               */
   U32               peerId;          /* Peer Idendtifier                     */ 
   CmHashListEnt     transReqEnt;     /* Hash List Entry                      */
   CmLListCp         axnReqLst;       /* Command Request group List contains  */ 
   TknU8             type;            /* CH_AXN_TYPE_NONE .. CH_AXN_TYPE_BOTH */
   MgMgcoChActionId  curActionId;     /* Current working  Action Identifier   */
                                      /* node of type MgMgcoChAxnReq          */
   CmLListCp         contextPropLst;  /* Context Property List contains  node */
                                      /* of type MgMgcoChCntxtProp            */
   CmTimer           tmr;             /* Timers for transaction req           */

#ifdef ZG
   CmPFthaRsetMap  mapCb;             /* mapping CB for PSF */
#endif /* ZG */
/* mg016.105: Added LCN Feature Information */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo   lcnInfoFromApp;
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
#endif /* GCP_LCN_APP_USE */
};
 
/**** CH Command Control Structure ****/
typedef struct mgMgcoChPeerCmdCtl 
{
   U32                 peerId;         /* Peer Idendtifier               */ 
   CmHashListEnt       peerEnt;        /* Hash List Entry                */ 
   CmHashListCp        transReqLst;    /* Txn Request List contains node */
                                       /* of type MgMgcoChTransReq       */        
   CmHashListCp        transIndRspLst; /* Txn Ind &Rsp List contains node*/
                                       /* of type MgMgcoChTransIndRsp    */        

#ifdef ZG
   CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
#endif /* ZG */
} MgMgcoChPeerCmdCtl;


 
/**** CH Structure present in mgCb  ****/
typedef struct mgMgcoChCb 
{
   CmHashListCp peerCmdCtlLst;  /* Peer Command Control Block contains*/ 
                                /* node of type MgMgcoChPeerCmdCtl    */
} MgMgcoChCb;

#endif /* GCP_CH */

/* GCP Global Control Block */
struct _mgCb
{
   MgSSAPCb        **sSAPLst;          /* SSAP List - See MgGenCfg for size */
#ifdef GCP_MGC
#ifdef GCP_MGCP
   SpId            nxtMgcpSsapId;      /* SSapId for RSIP from Unknown GW */
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
   SpId            nxtMgcoSsapId;      /* SSapId for ServiceChange from new GW */
#endif /* GCP_MGCO */
#endif /* GCP_MGC */
   MgPeerLst       **peerLst;          /* Peer Cb Lst */
   U32             freePeerIdx;        /* Next Free Index in the peerIdLst; head
                                          of peerLst */
   U32             lastFreePeerIdx;    /* Next Free Index in the peerIdLst; tail
                                          of peerLst */
   CmHashListCp    peerNameLst;        /* Peer Name based List */
   CmHashListCp    ipv4AddrLst;        /* Peer IPV4 Address based List */
#ifdef IPV6_SUPPORTED
   CmHashListCp    ipv6AddrLst;        /* Peer IPV6 Address based List */
#endif /* IPV6_SUPPORTED */


   /*
    *   Changed TSAPCb to a list of TSAPs to support SCTP;
    *   Each SCTP TSAP corresponds to an end point;
    *
    */

   SuId            dnsTsap;           /* TSAP Id of TUCL TSAP */
   MgTSAPCb        **tSAPLst;          /* TSAP List - See MgGenCfg for size */
   U32             curNumPeer;         /* current number of entities */
   TskInit         init;               /* Task init for this instance */
   MgGenCfg        genCfg;             /* general config */
   U16             suppVersion;        /* Supported Protocol Version */
   CmTqCp          mgTqCp;             /* timing queue control point */
   CmTqType        mgTq[MG_TQSIZE];    /* timing queue */
   CmTqCp          mgTTLTqCp;          /* timing queue control point */
   CmTqType        mgTTLTq[MG_TTLTQSZ];/* timing queue */
#ifdef CM_ABNF_MT_LIB
   Pst             edPst;              /* post structure for ED instances */
   Inst            nxtEDInst;          /* next ED instances for encode/decode */
   Inst            lastEDInst;         /* last ED instance */
   SSTskId         *tskIdAr;           /* encoder/decoder taskId */  
   U16             decCntr;            /* running counter for decList */
   U16             encCntr;            /* running counter for encList */
   /* This list stores information about message buffer rcved from TUCL. This
    * information is used to process txnInd when decode cfm is  rcved
    * from ED inst */
   MgStoreList     decList;
   /* This list stores info about txnReq rcved from SU which is used to
    * process TxnReq once enc Cfm is rcved from ED INst */
   MgStoreList     encList;
   /* If sometime we need to send delayed cfm to layer manager..then this will
    * store deffered post/Hdr information */
   MgDfrCfm        shutDwnCfm; 
   
#endif /* CM_ABNF_MT_LIB */
#ifdef ZG
   CmPFthaRsetMap  mapCb;                /* mapping CB for PSF */
#endif /* ZG */

   /* Rolling upgrade: added pointer to interface version storage buffer   */
#ifdef MG_RUG
   MgIntVerInfo verInfo;        /* Interface version info */
#endif /* MG_RUG */
/* CH Control Block  */
#ifdef GCP_CH
MgMgcoChCb      chCb;          /* CH Control Block Structure */
#endif /* GCP_CH */
#ifdef SS_MULTIPLE_PROCS
   U8            used;                  /* Control block usage */
#endif  /* SS_MULTIPLE_PROCS */
#ifdef DEBUGP
   Txt           prntBuf[510];
#endif  /* DEBUGP */
};

#ifdef SS_MULTIPLE_PROCS
EXTERN MgCb mgGlobalCbLst[MG_MAX_INSTANCES];
EXTERN MgCb *mgGlobalCbPtr;
#else
/* GCP Global Control Block */
EXTERN   MgCb      mgCb;               /* GCP Global Control Block */
#endif  /* SS_MULTIPLE_PROCS */
#ifdef GCP_VER_2_1
/*3gpp req1-4 : to maintain txn counts for a msg*/
PUBLIC typedef struct mgMgcoMsgTxnSts {
   U16 txnReqCnt;
   U16 txnRepCnt;
   U16 txnResAckCnt;
}mgMgcoMsgTxnCnt;
#endif

/*****************************************************************************/
/*                                                                           */
/*                        Internal Data Structures                           */
/*                                                                           */
/*****************************************************************************/


/* 3gpp prof-neg */
typedef struct mgProfLstNode
{
   CmHashListEnt   hlEnt;           /* Hash List Entry */
   MgProf          prof;           /* Hash List Entry */
}MgProfLstNode;

/* SSAP Control Block */
struct mgSSAPCb
{
   MgSSAPCfg       ssapCfg;            /* SSap Configuration */
   SuId            suId;               /* Service User Id */
   Pst             suPst;              /* Service User Post */
   State           state;              /* SAP State */
   Bool            enbIndSent;         /* SSAP enable has been sent ??*/
   U16             numPeerRslvd;       /* Number of Peers resolved */
   U32             nxtTransId;         /* Next Transaction Id */
   U16             numActvLstnrs;      /* Number of Active Listeners */
   CmLListCp       peerLst;            /* peers associated with SSAP */
   Bool            resCong;            /* resource congestion state */
#ifdef GCP_MGCP
#ifdef GCP_MG
   MgTptSrvrInfo   mgcpUDPSrvrLst;     /* UDP Server Information */
   MgTptSrvr       *nxtUseMgcpSrvr;    /* Next UDP Socket to be used for TX */  
#endif /* GCP_MG */
#endif /* GCP_MGCP */

#ifdef GCP_MGCO
#ifdef GCP_MG
   MgTptSrvrInfo   mgcoUDPSrvrLst;     /* UDP Server Information */
   MgTptSrvr       *nxtUseMgcoSrvr;    /* Next UDP Socket to be used for TX */  
   MgPeerCb        *crntMgc;           /* Current MGC: valid only on MG side */
   /* mg018.105: Added new pointer to maintain lastActivePeer information */
   MgPeerCb        *lastActivePeer;    /* Last Active Peer: valid on MG Side
                                          Only */   
   U8              mgType;             /* MG is active/standby */
   /* mg005.105: Added new state to support MG in lock/unlock state */
   Bool            lockUnlock;         /* MG is in lock/unlock state */
#endif /* GCP_MG */
   U16             numTcpLosses;
#endif /* GCP_MGCO */
#ifdef ZG
   CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
#endif /* ZG */

   /* Rolling upgrade: added a flag to indicate if the remote version
    * number in the post structure is valid or not
    */
#ifdef MG_RUG
   Bool            remIntfValid;       /* Version number valid ? */
   Ent             verContEnt;         /* version control entity */
#endif /* MG_RUG */  


   /*
    *   added TSAP pointer for the MG case to support SCTP;
    *   On the MG side, each SSAP is linked to an endpoint
    *   and since each end point is linked to a TSAP, we have
    *   linkages in SSAP as well as TSAP to each other on the
    *   MG side.
    */

#ifdef    GCP_MG
   MgTSAPCb        *tsap;              /* pointer to TSAP */
   /* 3gpp prof-neg */
   CmHashListCp    profHashLst;
   MgProfLstNode   *LastProfLstNode;
#endif    /* GCP_MG */

};

#ifdef   GCP_PROV_MTP3
typedef struct mgcoMtpCb
{
   Dpc             peerDpc;            /* Peer Destination Point Code */
   U8              status;             /* Status of Point Code online,offline or congested */
   Priority        congLvl;            /* Congestion Level of this Point Code */
   U8              stsRetxCnt;         /* Status Request Retry Count */
}MgcoMtpCb;
#endif   /* GCP_PROV_MTP3 */

/* IP Address based entry */
typedef struct mgIpAddrEnt
{
   CmHashListEnt   ipLstEnt;           /* Hash List Entry */
   CmNetAddr       ipAddr;             /* IP Address */
   MgPeerCb        *peer;              /* Peer Control Block */
}MgIpAddrEnt;

#ifdef GCP_PROV_MTP3
typedef struct mgMtpCommEntity
{
   CmHashListEnt mgcoMtpHlEnt;
   MgcoMtpCb     mgcoMtpCb;
}MgMtpCommEntity;
#endif /* GCP_PROV_SCTP */

#ifdef GCP_PROV_SCTP
typedef struct mgSctpCommEntity
{
   MgAssocCb  *assocCb; /* pointer to assoc CB */
   MgAssocCfg *assocCfg; /* pointer to assoc Cfg */
}MgSctpCommEntity;
#endif /* GCP_PROV_SCTP */

typedef struct mgTcpCommEntity
{
   CmLListCp tcpConnLst; /* TCP Connection List */
   MgTptSrvr *nxtUseConn; /* Next TCP Connection to use*/
}MgTcpCommEntity;

typedef struct mgUdpCommEntity
{
   SpId tSapId;
   SpId sSapId;
}MgUdpCommEntity;

typedef struct MgIpCommEntity
{
    Bool              namePres;
    U8                name[CM_DNS_DNAME_LEN];/* Peer Name */
    MgNetAddrTbl      peerAddrTbl; /* Peer Addresses */
    S32               remotePort;  /* Destination Port Number */
    union
    {
       MgTcpCommEntity tcpCommEntity;   
       MgUdpCommEntity udpCommEntity;
#ifdef GCP_PROV_SCTP
       MgSctpCommEntity sctpCommEntity;
#endif /* GCP_PROV_SCTP */
    }t;
}MgIpCommEntity;

typedef struct mgCommEntity
{
    U8              transportType;      /* Transport Type */
    union
    {
       MgIpCommEntity ipCommEntity;
#ifdef GCP_PROV_MTP3
       MgMtpCommEntity mtpCommEntity;
#endif /* GCP_PROV_MTP3 */
     }t;
}MgCommEntity;

/* Information for accessing peer */
typedef struct mgPeerAccess
{
   U32             peerId;             /* Peer Id in the SSAP */
   U8              peerflg;            
   MgCommEntity    commEnt;
   
   /* Added "mid" as a new variable */
#ifdef GCP_MGCO  
   MgMgcoMidStr    mid;
#endif
}MgPeerAccess;

/* Information Required for peer maintenance */
typedef struct mgPeerMntInfo
{
   U8              protocolType;       /* MEGACO or MGCP */
   Bool            byCfg;              /* Is Configured or not */
   Bool            usrKnows;           /* Whether Service User knows peerId */
   Bool            rtoCap;             /* RTO cap has been reached / not */
   U32             rto;                /* Round Trip Timeout Value */
   U32             aad;                /* Average Acknowledgement Delay */
   U32             adev;               /* Average Deviation Variance */
   U32             variant;            /* Protocol Variant */
   U16             mtuSize;            /* Peer MTU Size Supported */
   S16             trcLen;             /* Trace length */
   U8              resOrder;           /* Order of resolution */
   CmTimer         tmr[MG_MAXPEER_TMR];/* Timers for Peer */
}MgPeerMntInfo;

/* 
 * Timer required for peerCb are
 * TTL timer; MG_TTL_TMR
 * DNS Request Timer: MG_DNS_REQ_TMR
 * Restart Avalanche Timer; MG_RSTRT_TMR
 * Delete Peer Timer; MG_DEL_PEER_TMR
 */

typedef struct mgTxnAckList       MgTxnAckList;        /* SSAP Control Block */

typedef struct mgTxnAck
{
   MgTransId       trId;               /* transaction id to be Acked */
   MgPeerCb        *peer;              /* peer control block */
   CmTimer         tmr;                /* timer , to remove from list*/
}MgTxnAck;

struct mgTxnAckList
{
   MgTxnAck        info;               /* node information */
   MgTxnAckList    *next;              /* next node in the list */
};

#ifdef GCP_MGCP 
/* Transmitted buffer information  */
typedef struct mgTxBufInfo
{
   Buffer          *mBuf;              /* Message buffer  */
   U8              expctdRspCnt;       /* Number of response expected */
   U8              rcvdRspCnt;         /* Number of responses received */
   U8              retxCnt;            /* Retransmission count */
}MgTxBufInfo;

typedef struct mgMgcpPeerInfo
{
   U16             suspThold;          /* Suspicion Thresold */
   U16             disconThold;        /* Disconnect Thresold */
   U32             ttl;                /* TTL Value - For Status Purposes */
   /* Added a new variable, to distinguish a notified entity peer
    * from other peers in case of MGCP */
   Bool            ntfyEntPeer;
}MgMgcpPeerInfo;

#endif /* GCP_MGCP */

#ifdef GCP_MGCO
/* MEGACO Specific Information in  the MgPeerCb */
typedef struct mgMgcoPeerInfo
{
#ifdef GCP_MG
   Bool            dupPeerPrsnt;       /* Duplicate Peer Present */
   U16             mgcPriority;        /* Primary, Secondary */
   S32             cfgPort;            /* Configured MGC Port to contact */
   /* mg013.105: Added new filed in mgMgcoPeerInfo */
   MgMgcoSvcChgReason   reason;           /* Service change reason */
   /* mg021.105: Added new field in mgMgcoPeerInfo */
   /* 3gpp prof-neg */
   MgMgcoSvcChgMethod   meth;             /* Service change method */
#endif /* GCP_MG */
#ifdef    GCP_PROV_SCTP
   /* mg001.105: TOS support changes */
   U8              tos;                /* TOS towards this peer */
#endif /* GCP_PROV_SCTP */
   U8              encodingScheme;     /* Encoding Scheme */
   U8              negotiatedVersion;  /* Negotiated Version */
   U8              useAHScheme;        /* Interim AH Scheme to use ? */
   U8              numActvConn;        /* Number of Active TCP Connections */
   S32             origSrvcChngPort;   /* original service change port */
#ifdef GCP_MGC
   S32             lclSrvcChngPort;    /* Redirected Port */
   Bool            hndOffInProg;       /* HandOff in progress */
#endif /* GCP_MGC */
   U8              peerType;           /* Peer Type */
   union
   {
      MgPeerCb     *matedMG;           /* Mated MG; Valid only on MGC Side */
      MgPeerCb     *handOffMGC;        /* HandOff MGC - currently active */
      MgPeerCb     *undrHndOffMGC;     /* MGC Under Handoff - previous */
   }t;
}MgMgcoPeerInfo;
#endif /* GCP_MGCO */

#ifdef GCP_PKG_MGCO_ROOT
/* mg003.1.5: Moved defintion of mgMgcoPendingLimit to lmg.x */

/*New structure for holding values for storing prov rsp val*/
typedef struct mgMgcoProvRspTmrVal
{
   TknPres              pres;               /* Present? */
   U32                  mgProvRespTmrVal;
   U32                  mgcProvRspTmrVal;
}MgMgcoProvRspTmrVal;


#endif /* GCP_PKG_MGCO_ROOT */


#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
typedef struct _ntfyCb
{
   CmLListCp       notifyRQ;           /* Queued Notify Request for the Peer */
   U32             ntfyCnt;            /* Notify Count */
   CmTimer         ntfyAvlTmr;         /* Notify Avalanche timer */
   CmTimer         ntfyBpTmr;          /* Notify Breathing Period timer */
}NtfyCb;
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

#if  (defined(GCP_MGCO) && defined(GCP_VER_2_1))

typedef struct mgMgcoICSegRspCb
{
   CmLList list;
   U16     segBlkCnt;
   U32     segCnt;
}MgMgcoICSegRspCb;

typedef struct mgMgcoICSegRspInfo
{
   CmLListCp listCp;
   TmrCfg    segRspTmr;
   CmTimer   segTmr;
   Bool      finalSegRcvd;
   Bool      allSegRcvd;
   U16       finalSegNum;
   U16       numSegRcvd;
}MgMgcoICSegRspInfo;

typedef struct mgMgcoOGSegRspCb
{
    CmLList list;
    U16     segNum;
    Buffer  *mBuf;
}MgMgcoOGSegRspCb;

typedef struct mgMgcoOGSegRspInfo
{
   CmLListCp listCp;
   CmTimer   segAckTmr;
   TmrCfg    segRspAckTmr;
}MgMgcoOGSegRspInfo;

#endif /* defined(GCP_MGCO) && defined(GCP_VER_2_1) */
struct mgPeerCb
{
   CmHashListEnt   nameLstEnt;         /* Hash List Entry for peerNameLst */
   CmLList         ssapPeerLstNode;    /* LinkedList Node for peerLst in SSAP */
   MgPeerAccess    accessInfo;         /* Peer Access Information */
   MgPeerMntInfo   mntInfo;            /* Maintenance Information */
   State           state;              /* Resolved/Unresolved/Under RSIP */
   State           oldState;              /* Resolved/Unresolved/Under RSIP */
#ifdef GCP_MG
   U32             regReqTxnId;        /* Registration Request Transaction Id */
   /* mg009.105: Whether handoff to self mgcId */
   Bool            handOffSelfMgcId;              
   /* mg003.201: Made changes at MG to send SVC Disconnected first when MG loose
    * connection with MGC. */
   Bool            srvcChngToSamePeer; /* SVC Disc to previously associated
                                          Peer.  */
#endif /* GCP_MG */

   MgSSAPCb        *ssap;              /* Pointer to Associated SSAP */

#ifdef GCP_MGCP
   MgMgcpPeerInfo  mgcpInfo;           /* MGCP Protocol Information */
#endif /* GCP_MGCP */

   MgTxnAckList    txnAckQ;            /* Responses,to be acked will be queued*/

#ifdef GCP_MGCO
   MgMgcoPeerInfo  mgcoInfo;           /* Megaco Protocol Information */
#endif /* GCP_MGCO */

#ifdef CM_DNS_LIB
   U16             dnsRetxCnt;         /* DNS Resolve Retx. Count */
   U16             dnsReqId;           /* DNS Resolve Request Id */
   Buffer          *dnsReq;            /* DNS Request */
#endif /* CM_DNS_LIB */
   CmLListCp       transQ;             /* Queued Transaction for the Peer */
   MgPeerSts       peerSts;            /* Peer Statistics */
   CmHashListCp    inTransLst;         /* Txns Rcvd from Network List */
   CmHashListCp    outTransLst;        /* List of Outgoing Transactions */

#ifdef ZG
#ifdef ZG_DFTHA
   /* Event structure received from Peer will be queued here. These will 
    * processed after receiving state update from master */
   MgRvUpdQNode    peerTxnQ;           
   /* Event structure received from service user will be queued here */
   MgRvUpdQNode    usrTxnQ; 
#endif /* ZG_DFTHA */
   CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
   /* whether to remove all txn from in and out txnList; */
   Bool            removeAllTxns;      /* whether to remove all txn */
   Bool            removeOutTxns;      /* whether to remove all outgoing txn */
   Bool            bringToCfg;         /* bring peer to configuratio state at
                                          standby */
   Bool            delPeerTmr;         /* delete peer timer started ?? */
#endif /* ZG */
   MgTSAPCb        *tsap;              /* pointer to TSAP CB */

#ifdef GCP_PKG_MGCO_ROOT
   MgMgcoPendingLimit limit;           /* Pending Limit */
   MgMgcoProvRspTmrVal provTmr;
#endif /* GCP_PKG_MGCO_ROOT */

   /* mg009.105: Avoiding Switchover on Single Transaction
      timeout */   
   U16             numFailedTransactions; /* Configured number of
                                             failed transactions, on
                                             account of tMax timer expiry,
                                             before we attempt a Switchover 
                                             OR Delete the Peer */
#ifdef GCP_VER_2_1
/*dev_2.1 : This flag will be enabled when service change is recieved from a MG with
 * servicechangeincomplete flag. When TRUE, non root cmds directed to that MG will be
 * blocked by the MGC.*/                                             
   Bool           blockNonRootCmds;                                    
#ifdef GCP_NTFY_AVL
   NtfyCb       ntfyCb;             /* Queued Transaction for the Peer */
#endif /* GCP_NTFY_AVL */
   TmrCfg         segRspTmr;
   TmrCfg         segRspAckTmr;
#endif /* GCP_VER_2_1 */

   /* mg003.201: Made changes at MG to send SVC Disconnected first svcDCcount
    * times when MG loose connection with MGC. */
#ifdef GCP_MG_MGC_DISC_RECOVERY
   U8             failedSrvcDiscCount; /* MG will try SVC disconnect, to the 
                                          failed active peer, configured 
                                          number of times after which it will 
                                          try the next MGC in the pre-configured 
                                          list. If the peer MGC replies
                                          within the count specified then
                                          MG will maintain its association
                                          with the same MGC*/
#endif /*GCP_MG_MGC_DISC_RECOVERY*/

};

#ifdef   GCP_PROV_MTP3
typedef struct mgMtpInfo
{
   Dpc             clgAddr;            /* calling Address point Code i.e OPC */
   Dpc             cldAddr;            /* called Address Point Code i.e DPC */
   Bool            useTptInfo;
}MgMtpInfo;
#endif   /* GCP_PROV_MTP3 */



typedef struct mgPeerInitInfo
{
   U8              name[CM_DNS_DNAME_LEN];/* Peer Name */
   MgNetAddrTbl    addrTbl;            /* Peer Network Layer Addresses */
#ifdef GCP_MGCP
   MgMgcpPeerInfo  mgcpInfo;           /* MGCP Peer Information */
   U32             ttl;                /* TTL Value */
#endif /* GCP_MGCP */
   U8              transportType;      /* Transport Type */
   U8              protocolType;       /* Protocol Type */
   U32             variant;            /* Variant */
#ifdef GCP_MGCO
   U8              encodingScheme;     /* Encoding Scheme */
   U8              useAHScheme;        /* Use AH Header */
   U8              mgcoVersion;        /* MEGACO Version */
   /* Added "mid" as a new variable */
   MgMgcoMidStr    mid;                /* Mid */
#endif /* GCP_MGCO */
   Bool            byCfg;              /* LM configured? */
   S32             remotePort;         /* Destination Port */
   U32             initRtt;            /* Initial RTO */
   S16             trcLen;             /* Trace length */
   U16             mtuSize;            /* Peer MTU Size Supported */
   U16             priority;           /* Priority */
#ifdef ZG
   U32             peerId;             /* Peer Identifier */
   UConnId         suConnId;           /* connection identifier */
   U32             mtdPeerId;          /* mated peerid */
#endif /* ZG */
   /*
    *   added following fields to support SCTP
    */
#ifdef    GCP_PROV_SCTP
   Bool            allocAssocCfg;      /* allocate MgAssocCfg? */
   MgAssocCfg      assocCfg;           /* MgAssocCfg structure */
   /* mg001.105: TOS support changes */
   U8              tos;                /* TOS towards this peer */
#endif    /* GCP_PROV_SCTP */
#ifdef   GCP_PROV_MTP3
   Dpc             peerDpc;            /* Destination point Code of Peer */
   MgTSAPCb        *tsap;              /* TsapCb Required as our hash list 
                                          is in Tsap */
#endif   /* GCP_PROV_MTP3 */
}MgPeerInitInfo;




/* UDP Server */
struct mgTptSrvr
{
   U8              transportType;      /* TCP/UDP */
   CmLList         lstnrNode;          /* Link List Entry */
   CmHashListEnt   hlEnt;              /* Hash List Entry */
   UConnId         suConnId;           /* suConnId on HIT I/f */
   UConnId         spConnId;           /* Socket Index in TUCL */
   State           state;              /* State of socket */
   U8              protocol;           /* Protocol Type */
   U8              encodingScheme;     /* encoding scheme */
   U8              srvrType;           /* Attached to SSAP or TSAP */
   CmTptAddr       tptAddr;            /* IP Address and Port */
   CmTptAddr       cfgTptAddr;         /* Configured IP Address and port */
   CmTptParam      tptParam;           /* Configured Tpt Param */
   CmTimer         idleTmr;            /* Idle Timer */
   union
   {
      MgPeerCb     *peer;              /* Peer Control Block */
      MgSSAPCb     *ssap;              /* SSAP Ptr */
   }t;
#ifdef ZG
   CmPFthaRsetMap  mapCb;              /* mapping CB for PSF */
#ifdef ZG_DFTHA
   /* Some cases LLDF embeds rsetId in suConnId , which will be different from 
    * srvr->suConnId. So this is extra storage space. */
   U32             suRsetId;           /* resource set id + suConnId; */  
#endif /* ZG_DFTHA */
#endif /* ZG */

   MgTSAPCb        *tsap;              /* TSAP to which this srvr is linked */
};


/* Transport Server Initialisation Information */
typedef struct mgSrvrInitInfo
{
   U8              transportType;      /* Transport Type */
   U8              srvrType;           /* Server Type */
   U8              encodingScheme;     /* Encoding Scheme */   
#ifdef ZG
   U32             peerId;             /* peer identifier */
   UConnId         suConnId;           /* server conn identifier*/
#endif /* ZG */
}MgSrvrInitInfo;

/*
 * srvrType...possible value are
 * MG_MGCP_DEFLT_SRVR (MGCP Default Listener)
 * MG_MGCO_DEFLT_SRVR (MEGACO Default Listener)(*srvr is valid in this case too
 * as SSAP has list of TCP Servers and TptServer is what we insert in LL)
 * MG_ROUND_ROBIN_SRVR_MGCP  (SSAP/TSAP non-default Round Robin Server)
 * MG_ROUND_ROBIN_SRVR_MGCO  (SSAP/TSAP non-default Round Robin Server)
 * MG_TCP_CLIENT_CONNECTION (Client Connection; *peer is valid)
 *
 * tptAddr - In case of Servers it is local Transport address; in case of
 *           tcp connection it is remote Address
 *
 * Note: default servers can have have ssap as a valid pointer
 *       A tcp client connection will have peer and srvr as valid pointers
 */

/* Outgoing Transaction Control Block */
typedef struct mgTxTransIdEnt
{
   U8              trType;             /* Transaction Type */
   CmHashListEnt   outTransEnt;        /* Hash List Entry for outTransLst */
   CmLList         lnkLstNode;         /* LinkedList Node for lst in transQ */
   MgTransId       transId;            /* Transaction Identifier */
   State           state;              /* State of Transaction */
   U8              msgType;            /* Protocol Message Type */
   U8              msgInfo;            /* Indicates whether it is 
                                          self initiated, LM initiated */
   S32             remotePort;         /* Remote Port */
   Bool            retxOnIpAddr;       /* Use Only one IP address for Retx */
   UConnId         suConnId;           /* Listener on which transmitted */
   U16             retxCnt;            /* Retransmission Count */
   Ticks           timeStamp;          /* Time of first time transmission */
   CmTimer         retxTmr;            /* Retransmission Timer */
   MgNetAddrTbl    addrTbl;            /* IP Addresses used by transaction */
   MgPeerCb        *peer;              /* Peer Control Block */
#ifdef GCP_2705BIS
   CmTimer         discTmr;            /* Disconnected state timer */
#endif  /* GCP_2705BIS */
   union 
   {
#ifdef GCP_MGCP 
      MgTxBufInfo     *txBufInfo;      /* Transmitted buffer Information*/
#endif /* GCP_MGCP  */
      Buffer          *mBuf;           /* Buffer transmitted */
   }u;
   Bool            everRetxed;         /* If transmission was retransmitted */
   /* Added variables for calculating retx timer value in case of
    * retransmissions */ 
   U32             aad;                /* T-DELAY: AAD for retransmissions */
   U32             rto;                /* retransmission timeout value */
#ifdef ZG
   CmPFthaRsetMap  mapCb;                /* mapping CB for PSF */
#endif /* ZG */
#ifdef GCP_PKG_MGCO_ROOT 
   MgMgcoPendingLimit limit;           /* Pending Limit */
   CmTimer         provRspRtTmr;            /* Retransmission Timer */
#endif

/* mg016.105: Added LCN Feature Information */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo    lcnInfo;          /* To store the Application 
                                         LCN Information */
                                            

#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */

#if (defined(GCP_MGCO) && defined(GCP_VER_2_1))
   MgMgcoICSegRspInfo   segRspInfo;
   TmrCfg               segRspTmr;
#endif

 
}MgTxTransIdEnt;

/*
 * Timers needed are
 * rto -   Retransmission Time out; MG_RETX_TMR
 * Provisional Response Timer; MG_TX_PRVSNL_RSP_TMR = MG_RETX_TMR with a 
 *                             different time out.
 * Long Timer;This should be MG_RETX_TMR with time out configured as long
 */

/* Incoming Transaction Control Block */
typedef struct mgRxTransIdEnt
{
   U8              trType;             /* Transaction Type */
   U8              state;              /* State */
   CmHashListEnt   inTransEnt;         /* Hash List Entry for inTransLst */
   CmLList         lnkLstNode;         /* Link List Node for transQ */
   MgTransId       transId;            /* Transaction Id - key */
   U8              msgType;            /* Protocol Message Type */
   U8              rspStatus;          /* Status of response*/
   Bool            chkRspParam;        /* Check Response Parameter */
   U8              regCmdMethod;       /* Registration Command Method */
#ifdef GCP_2705BIS
   U32             aad;                /* average acknowledge delay */
   U32             adev;               /* average devaiation variance */
   U32             rto;                /* round trip timeout value */
   U16             retxCnt;            /* final response retx count */
   Ticks           timeStamp;          /* time stamp */
#endif  /* GCP_2705BIS */
   CmTimer         tmr[MG_INTXN_TMR];  /* 30 sec timer for queueing replies */
   UConnId         suConnId;           /* Socket where it was received */
   CmTptAddr       tptAddr;            /* destination transport address */
   MgPeerCb        *peer;              /* Associated Peer */
   Buffer          *mBuf;              /* Response Buffer */
#if ((defined GCP_MGCO) && (defined GCP_VER_2_1))
   MgMgcoOGSegRspInfo  segRspInfo;         /* out going seg response info */
#endif /* (defined GCP_MGCO) && (defined GCP_VER_2_1) */
#ifdef ZG
   CmPFthaRsetMap  mapCb;                /* mapping CB for PSF */
#endif /* ZG */
#ifdef GCP_PKG_MGCO_ROOT 
   MgMgcoPendingLimit limit;           /* Pending Limit */
   MgMgcoProvRspTmrVal provTmr;
#endif

/* mg016.105: Added LCN Feature Information */
#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
   MgMgtLcnInfo          lcnInfo;        /* Logical Channel Number Info */
#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
   U16              regCmdReason;        /* Registration command reason */             
}MgRxTransIdEnt;

#ifdef ZG_DFTHA
typedef struct mgRvrsQTxnInd
{
   U32             prot;                 /* protocol */
   UConnId         connId;               /* srvr cb */
   CmTptAddr       srcAddr;              /* source address */
   Ptr             msg;                  /* information; which could be megaco
                                            or MGCp events sructures */
}MgRvrsQTxnInd;

typedef struct mgRvrsQTxnReq
{
   U32             prot;                 /* protocol */
   SpId            spId;                 /* Ssap ID */
   Ptr             msg;                  /* information; which could be megaco
                                            or MGCp events sructures */
}MgRvrsQTxnReq;
#endif /* ZG_DFTHA */

#ifdef DEBUGP
EXTERN U8   *layerName;
EXTERN Txt  dnsPrntBuf[PRNTSZE];
#endif /* DEBUGP */

/* 
 * In TXN Timer are MG_30SEC_TMR and MG_PRVSNL_RSP timer
 * suConnId has significance in case of TCP Connections only, for UDP it
 * does not matter what socket we will use to transmit response
 */
 
#ifdef CM_DNS_LIB
typedef struct mgDnsTxFuncParam
{
   MgTptSrvr       *srvr;              /* Listener Control Block */
   MgPeerCb        *peer;              /* Peer Control Block */
}MgDnsTxFuncParam;
#endif /* CM_DNS_LIB */

/* Internal structure used for passing service change related information
   from one function to another */
#ifdef GCP_MGCO
typedef struct mgSvcChgInfo
{
   U8  srvcChgType;
   union
   {
      MgMgcoSvcChgReq   *svcChgReq;
      MgMgcoSvcChgReply *svcChgReply;
   } u;
} MgSvcChgInfo;
#endif /* GCP_MGCO */


#ifdef GCP_PROV_SCTP
typedef struct mgSctpInfo
{
   MgAssocCb *assocCb;
   CmTptAddr  *srcAddr;
   TknU32     ctxtId;
   Bool       unordered;
}MgSctpInfo;
#endif /* #ifdef GCP_PROV_SCTP */

typedef struct mgUTInfo
{
    MgTptSrvr *srvr;
    CmTptAddr *srcAddr;
}MgUTInfo;

typedef struct _mgcoTptInfo
{
   SpId tSapId;
   U8   tptType;
   union
   {
#ifdef GCP_PROV_SCTP
      MgSctpInfo sctpInfo; /* SCTP Information */
#endif /* GCP_PROV_SCTP */
#ifdef GCP_PROV_MTP3
      MgMtpInfo mtpInfo; /* MTP Information */
#endif /* GCP_PROV_MTP3 */
      MgUTInfo utInfo; /* TCP/UDP Information */
   }u;
   Bool     tryEncodingScheme;
   U8       encodingScheme;
   MgPeerCb *peer;
#ifdef GCP_LCN_APP_USE
  MgMgtLcnInfo   lcnInfo;
#endif /* GCP_LCN_APP_USE */
}MgcoTptInfo;

#ifdef GCP_MGCO
typedef struct _mgSrvcChngParam
{
   S16                *errAction;     /* Action to be taken on error */
   S16                *rspCode;       /* Response code */
   TknStrOSXL         *msgMid;        /* mid in MEGACO message*/
   MgMgcoVersion      *msgVer;        /* version in MEGACO message*/
   MgSvcChgInfo       *svcChg;        /* Service change or reply Information */
   MgTransId          transId;        /* Transaction Id */
   Bool               crtRxCb;        /* whether to create rxCb */
   Buffer             *mBuf;
   MgMgcoTxn          *mgcoTxn;       /* mgco transaction */
   U8                 msgInfo;
   Bool               updTxCb;
   MgTxTransIdEnt     **txCb;
   MgRxTransIdEnt     *rxCb;
   U8                 immAckPres;
   Bool               newPeer;        /*new peer allocated or not*/
}MgSrvcChngParam;

typedef struct _mgTransmitInfo
{
   MgTptSrvr      *srvr;
   CmTptAddr      *remAddr;
#ifdef GCP_PROV_SCTP
   MgAssocCb      *assocCb;
   Bool           unordered;
   SctStrmId      strmId;
#endif /* GCP_PROV_SCTP */

#ifdef GCP_PROV_MTP3
   LnkSel         lnkSel;
#endif /* GCP_PROV_MTP3 */
}MgTransmitInfo;

#endif /* GCP_MGCO */

typedef struct _mgOutTxnComnBool
{
   Bool               *txnSend;       /* Txn to be sent/ queued */
   Bool               isSvcReq; 
#ifdef GCP_VER_2_1
#ifdef GCP_MGC
   Bool               hasNonRootCmd;  /* True if Txn has a NON-ROOT cmd */
#endif /* GCP_MGC */
#ifdef GCP_NTFY_AVL   
   Bool               isNtfyReq;      /* transaction is notify request */
#endif /* GCP_NTFY_AVL */
#endif /* GCP_VER_2_1 */
}MgOutTxnComnBool;

#ifdef CM_ABNF_MT_LIB

typedef struct mgStoreDecReq
{
   U32             protoVar;             /* protocol variant */ 
   UConnId         suConnId;             /* connection identifier */
   CmTptAddr       srcAddr;              /* source Address */
   Buffer          *mBuf;                /* data buffer rcvd from TUCL */
   Ptr             event;                /* Event structure */
   CmTimer         mgEDTimer;            /* Timer */
   U8              tptType;
   U8              encodingScheme;
   MgTSAPCb        *tsap;                /* TSAP Control Block        */
#ifdef    GCP_PROV_SCTP
   MgAssocCb       *assoc;               /* Association Control Block */
   TknU32          ctxId;
#endif    /* GCP_PROV_SCTP */
#ifdef    GCP_PROV_MTP3
   MgMtpInfo       mgMtpInfo;            /* MTP Transport Information */ 
#endif   /* GCP_PROV_MTP3 */   
   MgPeerCb        *peer;
}MgStoreDecReq;

typedef struct mgEncBuffer
{
   /* status could be MG_ENCODE_OK, MG_ENCODE_NOK, or MG_ENCODE_NONE */
   U8              status;              
   Buffer          *buf;                 /* encoded buffer */
}MgEncBuffer;

typedef struct mgStoreEncReq
{
   U32             protoVar;             /* protocol variant */
   U8              source;               /* source of txn i.e.internal or usr */
   U32             peerId;               /* peer */
   Bool            delPeer;              /* Whether peer needs to deleted */
   SpId            spId;                 /* SSAP Identifier */
   CmTptAddr       srcAddr;              /* source address */
   Ptr             event;                /* event rcvd from SU */
   MgEncBuffer     **encBuf;             /* mBuf array */
   CmTimer         mgEDTimer;            /* encode timer */

   MgTSAPCb        *tsap;                /* TSAP Control Block        */
#ifdef    GCP_PROV_SCTP
   MgAssocCb       *assoc;               /* Association Control Block */
   TknU32          ctxId;                /* Context-Id */
#endif    /* GCP_PROV_SCTP */

}MgStoreEncReq;

typedef struct mgGcpCxtToED
{
   U16             indx;                 /* node index in list */
   U16             thisMsgNo;            /* message no in piggybacked txn */
}MgGcpCxtToED;

#endif /* CM_ABNF_MT_LIB */

/******************************************************************************/
/*                                                                            */
/*                     Co-ordinator Module                                    */
/*                        (mg_cord.c)                                         */
/******************************************************************************/

EXTERN Void mgRemovePeerAddrs ARGS((
        MgPeerCb        *peer          /* Peer Control Block */
      ));

EXTERN S16 mgUpdatePeerIpAddr ARGS((
        MgPeerCb        *peer,         /* Peer Control Block */
        MgNetAddrTbl    *newAddrTbl    /* New Address Table */
      ));

#ifdef GCP_MGCP

EXTERN S16 mgMgcpPrcCmdInTxnReq ARGS((
        MgPeerCb        *peer,         /* Peer Control Block */
        MgMgcpMsg       *msg,          /* MGCP Message */
        CmTptAddr       *remoteAddr,   /* Remote Address */
        MgTptSrvr       *srvr,         /* Transport Server */
        MgTxTransIdEnt  **txCb,        /* Transaction Control Block */
        U32             *mgtError,     /* MGT Interface Error Code */
        Void            *mBuf,         /* Message Buffer */
        Bool            *immTx,        /* Transmit Immediately */
        MgTSAPCb        *tsap          /* TSAP CB */
      ));

EXTERN S16 mgMgcpXmitTxnReq ARGS((
        Bool            immTx,         /* Transmit Immediately */
        U8              msgType,       /* Message Type */
        MsgLen          *crntPduLen,   /* Current PDU Length */
        MgPeerCb        *peer,         /* Peer Control Block */
        CmTptAddr       *xmitAddr,     /* Remote Address */
        Buffer          *mBuf,         /* Encoded Message Buffer */
        Buffer          **concatMbuf,  /* PiggyBacked Message Buffer */
        U32             *mgtError,     /* Error */
        MgTptSrvr       *srvr,         /* Local Socket for Tx */
        MgTxBufInfo     **txBufInfo,     /* Transmitted buffer information */
        Bool            xmit,          /* Whether to transmit message */
        MgTSAPCb        *tsap          /* TSAP CB */
      ));

EXTERN Void mgMgcpCopyNotifyEntityForTx ARGS((
        Bool            *ntfyIsIpAddr, /* Notified Entity is IP Address */
        MgMgcpMsg       *msg,          /* MGCP Message */
        MgPeerCb        *peer,         /* peer for this request */
        MgTptSrvr       *srvrCb,       /* Listener Control Block */
        CmTptAddr       *remAddr       /* destination address to send ntfy to */
      ));

/* Function to process Transaction Request Received from GCP Service User */
EXTERN S16 mgPrcMgcpTxnReq ARGS((
       MgSSAPCb         *ssapCb,       /* SSAP Control Block */
       MgMgcpTxn        *txn,           /* Transaction to be transmitted */
       MgPeerCb         *peerCb         /* peer control block */
    ));


/* Function to process Message received from the network */
EXTERN S16 mgPrcMgcpTxnInd ARGS((
       MgTSAPCb         *tsap,         /* TSAP CB */
       MgTptSrvr        *srvr,         /* Socket on which message was Rcvd */
       CmTptAddr        *srcAddr,      /* Source Transport Address */
       Buffer           *mBuf,         /* Data Buffer Received */
       MgMgcpTxn        *txn,          /* MGCP txn */    
       MgPeerCb         *peerCb        /* peer control block */
    ));


EXTERN S16 mgMgcpChkAndPrcNtfiedEntity ARGS((
       MgNtfiedEnt        *ntfiedEnt,         /* MGCP notified entity */
       MgPeerCb           *peer,              /* peer for this request */
       MgPeerCb           **newPeer,          /* New Peer */
       U32                variant             /* protocol variant */
    ));

/* Function to send RSIP message to peer */
EXTERN S16 mgSendRSIP ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       U16              method         /* RSIP method */
    ));

/* Function to process RSIP message received from peer */
EXTERN S16 mgProcessRSIP ARGS((
       S16                *errAction,         /* Action to be taken on Error */
       U32                *rspCode,           /* Response Code */
       U32                variant,            /* variant of protocol */
       U8                 method,             /* Restart Method */
       MgEPName           *endPt,             /* EndPoint Name */
       MgPeerCb           **peerCtlBlk,       /* Peer Control Block */     
       MgTptSrvr          *srvr,              /* Listener Control Block */
       CmTptAddr          *srcTptAddr,        /* Source Transport Address */
       Bool               *newPeer,           /* newPeer ?? */
       MgTSAPCb           *tsap               /* TSAP CB */
    ));

EXTERN S16 mgMgcpSendRSIP ARGS((
       MgPeerCb         *callAgent,    /* Peer Control Block */
       U8               mthd           /* restart method */
    ));

EXTERN S16 mgMgcpComposeRSIP ARGS((
       MgSSAPCb           *ssap,              /* SSAP control block */
       MgTransId          transId,            /* Transaction Id */
       U8                  mthd,              /* Method */
       U8                 *lclName,           /* Local Name */
       Buffer             *mBuf,              /* Message Buffer */
       MgPeerCb           *peer               /* peer control block */
    ));

EXTERN Void mgMgcpSendErrorResponse ARGS((
       CmTptAddr        *srcAddr,      /* Source Transport Address */
       MgTransId        trId,          /* MGCP TransAction ID */
       U32              rspCode,       /* Error Response Code */
       U8               *rspStr,       /* Response String */
       MgTSAPCb         *tsap          /* TSAP CB */
    ));

EXTERN Void mgMgcpSendPrvsnlResponse ARGS((
       MgRxTransIdEnt   *rxCb          /* Transaction Control Block */
    ));

EXTERN MgTptSrvr *mgMgcpGetSrvrForTx ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgTSAPCb         *tsap,         /* TSAP Control Block */
       Bool             *ssapSrvr      /* SSAP Server Chosen or not */
    ));

EXTERN Void mgMgcpUpdateNxtUseSrvrForTx ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgTSAPCb         *tsap,         /* TSAP Control Block */
       Bool             ssapSrvr       /* SSAP Server Chosen or not */
    ));


#endif /* GCP_MGCP */
       
#ifdef GCP_MGCO

EXTERN S16 mgMgcoDecodeTxnInd ARGS((
       MgMgcoMsg          *mgcoMsg,     /* Megaco Message */
       Buffer             **mBuf,       /* Message Buffer */
       Bool               *useAh,       /* Authentication header avialable ??*/
       MgTSAPCb           *tsap,        /* TSAP CB */
       MgcoTptInfo        *mgcoTptInfo  /* Megaco Transport Information */
      ));

#ifdef GCP_ASN
EXTERN S16 mgFillNewMgcoBuf  ARGS((
        Buffer           **mBufPtr,     /* Message buffer */            
        Buffer           *hdrMBuf,      /* Header Buffer */
        Buffer           *txnMBuf,      /* Transaction buffer pointer */
        U8              encodingScheme, /* encodingScheme */
        MsgLen           *crntPduLen,   /* current length of PDU */
        Bool             txnSend,       /* Transaction to be appended/ not */ 
        MgTSAPCb         *tsap          /* TSAP CB */
      ));
#else
EXTERN S16 mgFillNewMgcoBuf  ARGS((
        Buffer           **mBufPtr,     /* Message buffer */            
        Buffer           *hdrMBuf,      /* Header Buffer */
        Buffer           *txnMBuf,      /* Transaction buffer pointer */
        MsgLen           *crntPduLen,   /* current length of PDU */
        Bool             txnSend,       /* Transaction to be appended/ not */ 
        MgTSAPCb         *tsap          /* TSAP CB */
      ));
#endif /* GCP_ASN */

EXTERN S16 mgPrcMgcoTxnReq ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgcoMsg        *mgcoMsg,      /* Transaction */
       MgPeerCb         *peerCb,       /* Peer control block */
       U8               source         /* Initiated by user/ internal */
    ));


EXTERN S16 mgTransmitMgcoMsg ARGS ((
       MgcoTptInfo      *mgcoTptInfo,
       Buffer           *mBuf,         /* Message Buffer */
       MgMgcoMsg        *msg           /* Megaco message  */
    ));

#ifdef GCP_USE_AH
EXTERN S16 mgAttachAH ARGS ((
       MgcoTptInfo      *mgcoTptInfo,
       Buffer           *mBuf          /* Message Buffer */
    ));
#endif /* GCP_USE_AH */


#if    (defined(GCP_PROV_SCTP) || defined(GCP_PROV_MTP3))
EXTERN S16 mgPrcMgcoTxnInd ARGS((
       MgcoTptInfo      *mgcoTptInfo,  /* Megaco Transport Information */
       MgTSAPCb         *tsap,         /* TSAP CB */
       MgTptSrvr        *srvr,         /* Listener Control Block */
       CmTptAddr        *srcAddr,      /* Source Transport Address */
       Buffer           *mBuf,         /* Message Buffer */
       MgMgcoMsg        *mgcoMsg,      /* MEGACO Message */
       MgPeerCb         *peerCb        /* peer control block */ 
    ));
#else     /* GCP_PROV_SCTP || GCP_PROV_MTP3 */
EXTERN S16 mgPrcMgcoTxnInd ARGS((
       MgTSAPCb         *tsap,         /* TSAP CB */
       MgTptSrvr        *srvr,         /* Listener Control Block */
       CmTptAddr        *srcAddr,      /* Source Transport Address */
       Buffer           *mBuf,         /* Message Buffer */
       MgMgcoMsg        *mgcoMsg,      /* MEGACO Message */
       MgPeerCb         *peerCb        /* peer control block */ 
    ));
#endif    /* GCP_PROV_SCTP */


EXTERN S16 mgTransmitSrvcChng ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       Buffer           *mBuf,         /* Message buffer */            
       MgMgcoMsg        *msg,          /* Megaco Msg */
       Bool             txnSend        /* Send txn /not  */
    ));


/* Added check for Ver 1_5 and Binary support */
#ifdef GCP_ASN
/* Both are defined, hence encodingScheme param is added to choose which */
/* to use */
EXTERN S16 mgTransmitSrvcChngReply ARGS((
       Buffer    *mBuf,               /* Message buffer */            
       MgMgcoMsg *msg,                /* message to be sent */
       MgTSAPCb  *tsap,               /* TSAP CB */
       MgcoTptInfo *mgcoTptInfo,              /* Association Control Block */
       U8        encodingScheme      /* Encoding Scheme BIN/TEXT */
    ));
#else
EXTERN S16 mgTransmitSrvcChngReply ARGS((
       Buffer    *mBuf,               /* Message buffer */
       MgMgcoMsg *msg,                /* message to be sent */
       MgTSAPCb  *tsap,               /* TSAP CB */
       MgcoTptInfo *mgcoTptInfo       /* Transport Information */
    ));
#endif /* GCP_ASN */


/* Added check for Ver 1_5 and Binary support */
#ifdef GCP_ASN
/* Both are defined, hence encodingScheme param is added to choose which */
/* to use */
EXTERN U8  mgGetMgcoMsgBuf ARGS((
            Buffer          **mBufPtr,     /* Message buffer pointer */
            MgTSAPCb        *tsap,         /* TSAP CB */
            Buffer          **hdrMBufPtr,  /* Header Buffer pointer */
            MgMgcoMsg       *msg,          /* MEGACO message */
            U8               encodingScheme,
            U32              protVar              /* version support */
            ));
#else
/* Not Compiled with 1_5 use the existing proto */
EXTERN U8  mgGetMgcoMsgBuf ARGS((
            Buffer          **mBufPtr,     /* Message buffer pointer */
            MgTSAPCb        *tsap,         /* TSAP CB */
            Buffer          **hdrMBufPtr,  /* Header Buffer pointer */
            MgMgcoMsg       *msg   ,       /* MEGACO message */
            U32              protVar              /* version support */
            ));
#endif /* GCP_ASN */

#ifdef GCP_VER_2_1
#ifdef GCP_ASN
EXTERN S16 mgFillMgcoMsgBuf ARGS((
        Buffer          *mBuf,         /* Message buffer */            
        Buffer          *hdrMBuf,      /* Header Buffer */
        Buffer          *txnMBuf,      /* Transaction buffer pointer */
        MgMgcoMsg       *mgcoMsg,      /* MEGACO Transaction */
        U32             txnIdx,
        Bool            *txnSend,      /* Txn to be sent /not */
        MsgLen          *crntPduLen,   /* crnt length of pdu */
        MgTSAPCb        *tsap,         /* TSAP CB */
        U8              encodingScheme,/* encodingScheme */
        Bool            *isFirstTxn,   /* First Txn to encode */
        MgPeerCb        *peer,         /* peer control block */
        mgMgcoMsgTxnCnt *mgcoTxnNum    /*3GPP req1-4 New param added
                                        * for txn count in Msg*/
      ));
#else
EXTERN S16 mgFillMgcoMsgBuf ARGS((
        Buffer          *mBuf,         /* Message buffer */            
        Buffer          *hdrMBuf,      /* Header Buffer */
        Buffer          *txnMBuf,      /* Transaction buffer pointer */
        MgMgcoMsg       *mgcoMsg,      /* MEGACO Transaction */
        U32             txnIdx,
        Bool            *txnSend,      /* Txn to be sent /not */
        MsgLen          *crntPduLen,   /* crnt length of pdu */
        MgTSAPCb        *tsap,         /* TSAP CB */
        MgPeerCb        *peer,         /* peer control block */
        mgMgcoMsgTxnCnt *mgcoTxnNum    /*3GPP req1-4 New param added
                                           * for txn count in Msg*/
      ));
#endif
#else
#ifdef GCP_ASN
EXTERN S16 mgFillMgcoMsgBuf ARGS((
        Buffer          *mBuf,         /* Message buffer */            
        Buffer          *hdrMBuf,      /* Header Buffer */
        Buffer          *txnMBuf,      /* Transaction buffer pointer */
        MgMgcoMsg       *mgcoMsg,      /* MEGACO Transaction */
        U32             txnIdx,
        Bool            *txnSend,      /* Txn to be sent /not */
        MsgLen          *crntPduLen,   /* crnt length of pdu */
        MgTSAPCb        *tsap,         /* TSAP CB */
        U8              encodingScheme,/* encodingScheme */
        Bool            *isFirstTxn,   /* First Txn to encode */
        MgPeerCb        *peer          /* peer control block */
      ));
#else
EXTERN S16 mgFillMgcoMsgBuf ARGS((
        Buffer          *mBuf,         /* Message buffer */            
        Buffer          *hdrMBuf,      /* Header Buffer */
        Buffer          *txnMBuf,      /* Transaction buffer pointer */
        MgMgcoMsg       *mgcoMsg,      /* MEGACO Transaction */
        U32             txnIdx,
        Bool            *txnSend,      /* Txn to be sent /not */
        MsgLen          *crntPduLen,   /* crnt length of pdu */
        MgTSAPCb        *tsap,         /* TSAP CB */
        MgPeerCb        *peer          /* peer control block */
      ));
#endif
#endif

EXTERN Void mgFillMgcoErrMsg ARGS((
        MgMgcoMsg          **errMsg,   /* Error Message */
        U8                 reason,     /* Reason for error */
        Buffer             *mBuf,      /* mBuf to be freed */
        MgRxTransIdEnt     *rxCb,      /* rxCb to be freed */
        MgTxTransIdEnt     *txCb,      /* txCb to be freed */
        MgTransId          transId     /* Transaction Id */
      ));

#ifdef GCP_CH

EXTERN S8 mgChAllocatePeerCb ARGS((
      U32                    peerId,            /* CH peer Id */
      MgMgcoChPeerCmdCtl     **peerCmdCtl       /* CH peer CB */
      ));

EXTERN S8 mgChAllocateTxnIndRspCb ARGS((
      MgMgcoChPeerCmdCtl     *peerCmdCtl,       /* Peer Command Control */
      MgMgcoTransId          transId,           /* Transaction Id       */
      MgMgcoChTransIndRsp    **trIndRsp,        /* CH Trans IndRsp      */
      U32                    numAxn             /* number of actions    */
      ));

EXTERN S8 mgChAllocateTxnReqCb ARGS((
      MgMgcoChPeerCmdCtl     *peerCmdCtl,       /* Peer Command Control */
      MgMgcoTransId          transId,           /* Transaction Id       */
      MgMgcoChTransReq       **transReq         /* CH Trans Req         */
      ));

EXTERN S8 mgChAllocateAxnReqCb ARGS((
      MgMgcoChTransReq       *transReq,         /* CH Trans Req         */
      U32                    axnId,             /* action Id            */
      MgMgcoChAxnReq         **axnReq,          /* CH Axn Req           */
      MgMgcoContextId        cntxtId            /* Context Id           */
      ));

EXTERN S8 mgChAllocateAxnIndRspCb ARGS((
      MgMgcoChTransIndRsp       *trIndRsp,         /* CH Trans IndRsp      */
      MgMgcoChAxnIndRsp         **axnIndRsp,       /* CH Axn IndRsp        */
      MgMgcoContextId           cntxtId,           /* Context Id           */
      U8                        axnType,           /* type - CH_AXN_TYPE_BOTH ...   */
      U8                        txnType,           /* type - CH_AXN_TYPE_BOTH ...   */
      U32                       crntAxnIdx,        /* current axn index (0 based)   */
      U32                       numCmds            /* number of commands in Txn ind */
      ));

EXTERN S8 mgChAllocateWildCardAxnIndRspCb ARGS((
      MgMgcoChTransIndRsp       *trIndRsp,         /* CH Trans IndRsp      */
      MgMgcoChAxnIndRsp         **axnIndRsp,       /* CH Axn IndRsp        */
      MgMgcoContextId           cntxtId,           /* Context Id           */
      U8                        axnType,           /* type - CH_AXN_TYPE_BOTH ...   */
      U8                        txnType,           /* type - CH_AXN_TYPE_BOTH ...   */
      U32                       crntAxnIdx,        /* current axn index (0 based)   */
      U32                       numCmds            /* number of commands in Txn ind */
      ));

EXTERN S8 mgChAllocateCntxtProp ARGS((
      U32                       crntAxnIdx,        /* current axn index (0 based) */
      MgMgcoContextId           cxtId,             /* Context Id                  */
      MgMgcoChCntxtProp         **chCntxt,         /* CH cxt prop to be allocated */
      MgMgcoContextProps        *cxtProps          /* source Context properties   */
      ));

EXTERN S8 mgChAllocateCntxtReqCb ARGS((
      U8                        txnType,           /*                             */
      MgMgcoChTransIndRsp       *trIndRsp,         /* CH Trans IndRsp             */
      MgMgcoChTransReq          *transReq,         /* CH Trans Req                */
      U32                       crntAxnIdx,        /* current axn index (0 based) */
      MgMgcoContextId           cxtId,             /* Context Id                  */
      MgMgcoChCntxtProp         **chCntxt,         /* CH cxt prop to be allocated */
      MgMgcoContextProps        *cxtProps,         /* source Context properties   */
      MgMgcoContextAudit        *cxtAud            /* source Context audit        */
      ));

EXTERN S8 mgChAllocateCntxtRspCb ARGS((
      MgMgcoChTransIndRsp       *trIndRsp,         /* CH Trans IndRsp             */
      U32                       crntAxnIdx,        /* current axn index (0 based) */
      MgMgcoContextId           cxtId,             /* Context Id                  */
      MgMgcoChCntxtProp         **chCntxt,         /* CH cxt prop to be allocated */
      MgMgcoContextProps        *cxtProps,         /* source Context properties   */
      MgMgcoContextAudit        *cxtAud            /* source Context audit        */
      ));

#ifdef GCP_VER_2_1
EXTERN S8 mgChAllocateIncCmdReqCb ARGS((
      MgMgcoChAxnIndRsp         *axnIndRsp,        /* axn ind rsp block           */
      U32                       crntCmdIdx,        /* current cmd index (0 based) */
      MgMgcoTermIdLst           *termIdLst,         /* Termination Id List  */
      U8                        cmdType,           /* command type                */
      MgMgcoCommandReq          *peerCmdReq        /* cmdReq event struct from peer */
      ));
#else
EXTERN S8 mgChAllocateIncCmdReqCb ARGS((
      MgMgcoChAxnIndRsp         *axnIndRsp,        /* axn ind rsp block           */
      U32                       crntCmdIdx,        /* current cmd index (0 based) */
      MgMgcoTermId              *termId,            /* Termination Id       */
      U8                        cmdType,           /* command type                */
      MgMgcoCommandReq          *peerCmdReq        /* cmdReq event struct from peer */
      ));
#endif /* GCP_VER_2_1 */      


EXTERN S8 mgChAllocateOutCmdReqCb ARGS((
      MgMgcoChTransReq          *transReq,         /* trans Req block             */
      MgMgcoChAxnReq            *axnReq,           /* axn Req block               */
      MgMgcoChCmdReq            **cmdReqNode,      /* Cmd Req Node                */
      MgMgcoCommandReq          *usrCmdReq         /* Cmd Req event struct frm usr */
      ));

EXTERN S8 mgChAllocateCmdRspCb ARGS((
      MgMgcoChAxnIndRsp         *axnIndRsp,        /* axn ind rsp block           */
      MgMgcoChCmdResp           **cmdRsp,          /* cmd Resp to be allocated    */
      MgMgcoCmdReply            *usrCmdRsp         /* cmd rsp event struct frm usr */
      ));

EXTERN Void   mgChFreeTxnIndRspCb ARGS((
      MgMgcoChTransIndRsp         *txnIndRsp         /* txn ind rsp block           */
      ));

EXTERN Void   mgChFreeChCntxtLstInTransIndRspCb ARGS((
      MgMgcoChTransIndRsp         *txnIndRsp         /* txn ind rsp block           */
      ));

EXTERN Void   mgChFreeAxnIndRspCb ARGS((
      MgMgcoChAxnIndRsp         *axnIndRsp         /* axn ind rsp block           */
      ));

EXTERN Void   mgChFreeIncCmdReqCb ARGS((
      MgMgcoChAxnIndRsp         *axnIndRsp,        /* axn ind rsp block     */      
      U16                       cmdIdx             /* cmd index             */
      ));

EXTERN PUBLIC S16 mgChCleanupTransIndRsp ARGS((
      MgMgcoChTransIndRsp       **transIndRsp
)); 

/*mg002.105: add freeCmds paramter*/
EXTERN PUBLIC S16 mgChCleanupTransReq  ARGS((
      MgMgcoChTransReq          **transReq,
      U32                         freeCmds
));

EXTERN PUBLIC S16 mgChFreeCmds ARGS ((
      MgMgcoMsg *txn,
      U16        txnCnt
));

/* mg008.105: Added function to grow the memory size */
EXTERN PUBLIC S16 mgChGrowMem ARGS ((
      Ptr*         ptr,
      MsgLen       newSiz,
      MsgLen       oldSiz,
      MsgLen       siz
));

#ifdef ZG
EXTERN PUBLIC Void mgChDelMappingTxnIndRspAndChilds ARGS ((
      MgMgcoChTransIndRsp       *trIndRsp          /* txn ind rsp block */
));

EXTERN PUBLIC Void mgChDelMappingTxnReqAndChilds ARGS ((
      MgMgcoChTransReq          *trans             /* txn req block */
));
#endif /* ZG */

#endif /* GCP_CH */

#endif /* GCP_MGCO */


EXTERN S16 mgRmvPeerAssoc ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgtCntrl       *cntrl         /* cntrl block */
    ));


EXTERN S16 mgCancelRmvAssoc ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgtCntrl       *cntrl         /* cntrl block */
    ));

EXTERN S16 mgRmvPeerTrans ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgtCntrl       *cntrl         /* cntrl block */
    ));


EXTERN S16 mgMovePeer     ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgtCntrl       *cntrl         /* cntrl block */
    ));

EXTERN S16 mgMoveTrans ARGS((
       MgMgtCntrl         *cntrl,      /* cntrl block */
       MgSSAPCb           *ssap        /* SSAP of old peer */
    ));

EXTERN S16 mgFindAndMoveTrans ARGS((
       MgPeerCb          *peer,        /* Old peer cb */
       MgPeerCb          *newPeer,     /* Peer where txns are to be moved */
       MgTransId         transId,      /* Transaction id */
       U8                transDir      /* Trans dir - incoming/outgoing */
    ));

EXTERN S16 mgMoveInTxn ARGS((
       MgPeerCb        *oldPeer,       /* Old Peer */
       MgPeerCb        *newPeer,       /* destination Peer */
       MgRxTransIdEnt  *inTxnCb,       /* Incoming Txn Control Block */
       U8              transType       /* Single Transaction / All trans */
    ));

EXTERN S16 mgRecovrConn ARGS((
       MgTSAPCb           *tsapCb      /* TSAP Control Block */
       ));


EXTERN S16 mgMoveOutTxn ARGS((
       MgPeerCb        *oldPeer,       /* Old Peer */
       MgPeerCb        *newPeer,       /* destination Peer */
       MgTxTransIdEnt  *outTxnCb,      /* Outgoing Txn Control Block */
       U8              source,         /* Initiated by user/ internal */
       U8              transType      /* Single Transaction / All trans */
    ));

EXTERN S16 mgAuditPeerTxn ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgtAudit       *audit         /* audit block */
    ));


EXTERN S16 mgResetRTO ARGS((
       MgPeerInfo       *peerInfo,     /* Peer Information */
       MgSSAPCb         *ssap          /* SSAP Control Block */
    ));

EXTERN  MgTptSrvr * mgGetSendSrvr ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */       
       MgPeerCb         *peer          /* peer Control Block */
    ));

EXTERN Void mgRetransmitMessage ARGS((
       MgTptSrvr          *tptSrvr,    /* Transport Server to be used */
       MgTSAPCb           *tsap,       /* TSAP Control Block */
       MgPeerCb           *peer,       /* Pointer to Peer Control Block */
       MgTxTransIdEnt     *txCb        /* Transaction Control Block */
    ));

EXTERN S16 mgRemoveBytesTillSeparator ARGS((
        MsgLen          *numDecBytes, /* Number of decoded bytes */
        CmAbnfDecOff    *offset       /* Decoder offset in the buffer */
      ));

EXTERN S16 mgSendRegReq ARGS((
        MgTptSrvr          *srvr,           /* srvr*/
        MgTSAPCb           *tsap            /* TSAP Control block */
        ));

/* Function to initialize Common Library DNS Control Block */
#ifdef CM_DNS_LIB

EXTERN S16 mgInitDnsCb ARGS((
       CmDnsCb          *dnsCb,        /* Common DNS Control Block */
       U16              reqIdLstSz,    /* Request Id List Size */
       Mem              *sMem,         /* Static Memory Region and Pool */
       CmTptAddr        *dnsAddr,      /* DNS Transport Address Information */
       MgTSAPCb         *tsap          /* TSAP CB */
    ));

/* Function registered with DNS Library as Receive function..else not used */
EXTERN S16 mgRcvDnsResponse ARGS((
       Ptr              peer,          /* Pointer to Peer Control Block */
       CmDnsResponse    *rcrdTbl       /* Records Fetched from DNS */
    ));

#endif /* CM_DNS_LIB */

/* Function to Send DNS Resolution Request for a Peer to the DNS */
EXTERN S16 mgSendDnsRslvReq ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       U8               *hostName      /* Domain Name to be resolved */
    ));

#ifdef   GCP_PROV_SCTP
EXTERN S16 mgRecovrEndp ARGS((
       MgTSAPCb           *tsapCb      /* TSAP Control Block */
       ));
#endif   /* GCP_PROV_SCTP */
/*dev_2.1 : function that checks whether to block any non-root command txn */
#ifdef GCP_VER_2_1
EXTERN S16 mgChkBlockNonRootCmd ARGS((
        MgMgcoTxn          *mgcoTxn,       /* Megaco Transaction */
        Bool               *hasNonRootCmd  /* true if TXN has a non-root cmd */
      ));
EXTERN S16 mgChkMgcoTxnSIC ARGS((
MgMgcoTxn          *mgcoTxn,           /* Megaco Transaction */
MgPeerCb           *peer,              /* Service Change Method */
U8                 msgVersion          /* Message version, as 
                                        * present in header */
      ));
#endif

/******************************************************************************/
/*                                                                            */
/*                            Utility Functions                               */
/*                             (mg_util.c)                                    */
/******************************************************************************/

/*
 * added new functions -
 */
#ifdef CM_SDP_OPAQUE
#ifdef GCP_MGCO
EXTERN  S16 mgMgcoFreeMedDsTkBf ARGS((
        MgMgcoMediaDesc  *meDs
      ));

EXTERN  S16 mgMgcoFreeAllTkBfs ARGS((
        MgMgcoTxn  *mgTrn
      ));
#endif  /* GCP_MGCO */

#ifdef GCP_MGCP
EXTERN  S16 mgMgcpFreeAllTkBfs ARGS((
        MgMgcpMsg  *mgMsg
      ));
EXTERN  S16 mgMgcpFreeAllTxnTkBfs ARGS((
        MgMgcpTxn  *mgTrn
      ));
#endif  /* GCP_MGCP */
#endif  /* CM_SDP_OPAQUE */


/* Start Servers */
EXTERN S16 mgStartServers ARGS((
        MgTptSrvrInfo      *srvrInfo           /* Server Information */
      ));

/* Function to Locate Peer using local Info from service user */
EXTERN MgPeerCb * mgLocatePeer ARGS((
       MgPeerInfo        *peerInfo,     /* Peer Information */
       MgSSAPCb          *ssap          /* Associated SAP id */
    ));

#ifdef GCP_MG
EXTERN U16 mgRemSsapSrvrs   ARGS((
       MgSSAPCb          *ssap,         /* ssap cb */
       Bool              delSrvr        /* delete srvr cb  (yes/no) */
    ));

/* added extern decl for new function */
EXTERN U16 mgRemSsapSrvrsForThisTsap ARGS((
       MgSSAPCb *ssap,                  /* ssap cb */
       MgTSAPCb *tsap,                  /* tsap cb */
       Bool      delSrvr                /* delete srvr cb? */
));

EXTERN S16 mgStartSsapServers ARGS((
        MgSSAPCb        *ssap          /* SSAP Control Block */
      ));
#endif /* GCP_MG */

EXTERN S16 mgStartTsapServers ARGS((
       MgTSAPCb          *tsapCb        /* tsap cb */
    ));


EXTERN MgPeerCb * mgRslvDomainNameStr ARGS((
       U16              len,           /* Length of the String */
       U8               *val,          /* Domain Name String */
       MgDName          *dname         /* Domain Name */
    ));


EXTERN S16 mgGetIpAddrFromDomainNameStr ARGS((
       U16              len,           /* Length of the String */
       U8               *val,          /* Domain Name String */
       CmNetAddr        *address,      /* IP Address */
       U8               protocol       /* MEGACO/MGCP */
    ));

/* Function to allocate a Static Buffer */
EXTERN Data * mgMalloc ARGS((
       Size             size           /* Size of Static Buffer */
    ));
       
/* Function to deallocate a static buffer */
EXTERN Void mgDeAlloc ARGS((
       Data             *buf,          /* Static Buffer to be freed */
       Size             size           /* Size of Static Buffer */
    ));

#ifdef LEAK_TEST
EXTERN S16 mgGetMsg ARGS((
       Region    region,
       Pool      pool,
       Buffer    **mBuf
    ));

EXTERN S16 mgPutMsg ARGS((
       Buffer    *mBuf
    ));
#endif /* LEAK_TEST */

EXTERN S16 mgGetIpAddrForTx ARGS((
       MgTxTransIdEnt   *txCb,         /* Aborted Transaction */
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

EXTERN Void mgSendSsapEnbStaInd ARGS((
       MgSSAPCb         *ssap          /* SSAP Control Block */
    ));

EXTERN S16 mgAdmitTxn ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgTSAPCb         *tsap          /* TSAP Control Block */
    ));


EXTERN S16 mgCnvrtAddrTbl ARGS((
       CmInetIpAddrArr  *ipAddrTbl,    /* Common LIB IP Address Table */
       MgNetAddrTbl     *mgAddrTbl     /* GCP IP Address table */
    ));

EXTERN Void mgConvertIpAddrToAscii ARGS((
       CmNetAddr          *ipAddr,     /* IP Address */
       U8                 *buf,        /* Buffer to put ascii string into */
       U8                 bufLen,      /* Allocated Buffer Length */
       U16                *encodeLen,  /* Length of ASCII String */
       U8                 protocol     /* MGCP/MEGACO */
    ));

EXTERN S16 mgGenUserStaInd ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       U8               statusType,    /* StaInd Type: VersionInd/ flow control */
       Ptr      statusInfo             /* Status Information */
    ));


EXTERN MgTptSrvr * mgGetLstnrForTx ARGS((
       MgSSAPCb         *ssapCb,       /* SSAP Control Block */
       MgTSAPCb         *tsapCb,       /* TSAP Control Block */
       U8               protocol       /* protocol - MGCP/MEGACO */
    ));



#ifdef GCP_MGCO
#ifdef GCP_MGC
EXTERN MgTptSrvr * mgGetSrvrForRedirection ARGS((
       U8               transportType, /* Transport type - UDP/TCP */
       MgTSAPCb         *tsapCb        /* TSAP Control Block */
    ));
#endif /* GCP_MGC */

EXTERN MgTptSrvr * mgGetNxtUseConnForTx ARGS((
       MgPeerCb         *peer          /* peer for this request */
    ));

EXTERN U16 mgIssueMgcoTxnErr ARGS((
       MgSSAPCb         *sSAPCb,       /* SSAP Control Block */
       U16              errType,       /* Type of Error to be reported */
       MgPeerCb         *peer,         /* Peer Control Block */
       MgTransId        transId        /* Transaction Id */  
    ));

EXTERN Void mgHandleMgcoTxnReqErr ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgcoMsg        *msg,          /* MGCP Transaction */
       U8               mgtError,      /* Error to be reported */
       U8               source         /* Initiated by user/ internal */
    ));


#endif /* GCP_MGCO */

#ifdef GCP_MGCP
EXTERN U16 mgIssueMgcpTxnErr ARGS((
       MgSSAPCb         *sSAPCb,       /* SSAP Control Block */
       U16              errType,       /* Type of Error to be reported */
       MgPeerCb         *peer,         /* Peer Control Block */
       MgTransId        transId        /* Transaction Id */
    ));


EXTERN Void mgHandleMgcpTxnReqErr ARGS((
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgMgcpTxn        *txn,          /* MGCP Transaction */
       U8               mgtError       /* Error to be reported */
    ));

#ifdef GCP_MG
EXTERN S16 mgMgcpPrcRSIPResponse ARGS((
        S16                *errAction,         /* Action to be taken on Error */
        U32                *action,            /* Action Taken */
        MgPeerCb           *peer,              /* Peer Control Block */
        U32                rspCode,            /* Response Code */
        MgNtfiedEnt        *ntfiedEnt,         /* MGCP notified entity */
        U32                variant,            /* variant */ 
        MgTransId          trId                /* transaction id */
      ));
#endif /* GCP_MG */
#endif /* GCP_MGCP */


EXTERN Void mgCheckEnbSsap ARGS((
       MgSSAPCb           *ssap        /* SSAP Control Block */
    ));
#ifdef GCP_VER_2_1
/*dev_2.1 start:Reg exp for SIC Check */
EXTERN S16 mgMgcoRegexSIC ARGS((
       U8          *sicStr,     /* Input SIC string from 
                          * the message from peer N/W*/
       U16         sicStrLen    /* Length of the SIC string */
    ));
/*dev_2.1 start:Reg exp for SIC Check */
#endif

/******************************************************************************/
/*                                                                            */
/*                 Transaction Control Block Module                           */
/*                         (mg_trans.c)                                       */
/******************************************************************************/
/* Function to process Transaction generated by GCP Service User for a Peer */
EXTERN MgTxTransIdEnt * mgPrcOutGoingTxn ARGS((
       MgcoTptInfo      *mgcoTptInfo,
       MgTransId        transId,       /* Transaction Identifier */
       U8               msgType,       /* Protocol Message Type */
       U8               msgInfo,       /* txCb->msgInfo */
       Bool             retxOnIpAddr,  /* Retransmission on IP address only */
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       Void             *mBuf,         /* Message Buffer */
       MgOutTxnComnBool *comnBool       /* Common bool information */ 
    ));

/* Function to process an Ack. generated by GCP Service User for a Peer */
#if ((defined GCP_MGCO) && (defined GCP_VER_2_1))
EXTERN MgRxTransIdEnt * mgPrcOutGoingAck ARGS((
       U8               protocol,      /* MGCP/MEGACO */
       U8               rspType,       /* Response Type : Provisional/Normal etc*/
       MgTransId        transId,       /* Transaction Identifier */
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       Buffer           *mBuf,         /* Message Buffer */
       Bool             *immAck,       /* Fill in request for immAck ? */
       Bool             rsp2RegCmd,    /* Is response to registration command ?*/
       MgMgcoTxn          *mgcoTxn
    ));
#else
EXTERN MgRxTransIdEnt * mgPrcOutGoingAck ARGS((
       U8               protocol,      /* MGCP/MEGACO */
       U8               rspType,       /* Response Type : Provisional/Normal etc*/
       MgTransId        transId,       /* Transaction Identifier */
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       Buffer           *mBuf,         /* Message Buffer */
       Bool             *immAck,       /* Fill in request for immAck ? */
       Bool             rsp2RegCmd     /* Is response to registration command ?*/
    ));
#endif /* (defined GCP_MGCO) && (defined GCP_VER_2_1) */

/* Function to process Ack. received from the network from a Peer */
#if ((defined GCP_MGCO) && (defined GCP_VER_2_1))
EXTERN S16 mgPrcIncomingAck ARGS((
       MgTxTransIdEnt     **transCb,          /* transaction cb */
       U8                 *cmdType,           /* Command Type */
       MgcoTptInfo        *mgcoTptInfo,       /* Transport Information */
       MgTransId          transId,            /* Transaction Identifier */
       U8                 rspCode,            /* Response Code */
       MgMgcoTxn          *mgcoTxn
    ));
#else
EXTERN S16 mgPrcIncomingAck ARGS((
       MgTxTransIdEnt     **transCb,          /* transaction cb */
       U8                 *cmdType,           /* Command Type */
       MgcoTptInfo        *mgcoTptInfo,       /* Transport Information */
       MgTransId          transId,            /* Transaction Identifier */
       U8                 rspCode            /* Response Code */
    ));
#endif /* (defined GCP_MGCO) && (defined GCP_VER_2_1) */

/* Function to process ack. received for the ack sent out */
EXTERN S16 mgPrcRcvdResponseAck ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       MgTransId        transId        /* Transaction Identifier */
    ));


EXTERN MgRxTransIdEnt * mgPrcIncomingTxn ARGS((
       MgcoTptInfo      *mgcoTptInfo,
       MgTransId        transId,       /* Transaction Identifier */
       U8               *dupFlag,      /* Duplicate Transaction marker */
       Bool             chkRspParam,   /* Check Response Parameter */
       U8               msgType,       /* Message Type */
       U8               method         /* RSIP/ServiceChange Method */
    ));

EXTERN MgRxTransIdEnt * mgPrcIncomingNewTxn ARGS((
       MgcoTptInfo      *mgcoTptInfo,
       MgTransId        transId,       /* Transaction Identifier */
       Bool             chkRspParam,   /* Check Response Parameter */
       U8               msgType,       /* Message Type */
       U8               method,        /* RSIP/ServiceChange Method */
       U16              reasonBit      /* Service Change reason */
    ));

EXTERN MgRxTransIdEnt * mgPrcChckIncomingDupTxn ARGS((
MgcoTptInfo        *mgcoTptInfo,       /* Transport Information */
MgTransId          transId,            /* Transaction Identifier */
U8                 *dupFlag,           /* Duplicate Transaction marker */
Bool               *newTransaction     /* Informs if it is new request*/
    ));

EXTERN Void mgAbortTxTrans ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       MgTxTransIdEnt   *txCb,         /* Aborted Transaction */
       U8               mgtError       /* Error to report to Service User */
    ));

EXTERN Void mgAbortRxTrans ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       MgRxTransIdEnt   *rxCb,         /* Aborted Transaction */
       U8               mgtError       /* Error to report to Service User */
    ));

EXTERN Void mgDeAllocTxTransIdEnt ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       MgTxTransIdEnt   *txCb,         /* Aborted Transaction */
       Bool             freeMbuf       /* Free Message Buffer */
    ));

EXTERN Void mgDeAllocRxTransIdEnt ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       MgRxTransIdEnt   *rxCb,         /* Aborted Transaction */
       Bool             freeMbuf       /* Free Message Buffer */
    ));


EXTERN  Void mgIndicateAbortTxnToUsr ARGS((
        U8              mgtError,      /* Error to be indicated */
        MgTransId       transId,       /* Transaction Identifier */
        MgPeerCb        *peer          /* Peer Control Block */
      ));


EXTERN Void mgMoveAllTxn ARGS((
       MgPeerCb           *oldpeer,    /* Peer Control Block */
       MgPeerCb           *newpeer,    /* Peer Control Block */
       U8                 source       /* Initiated by user/ internal */
    ));


EXTERN S16 mgMoveTransFromQ ARGS((
        MgTransId         transId,     /* Transaction id */
        MgPeerCb          *oldPeer,    /* Old peer cb */
        MgPeerCb          *newPeer,    /* Peer where txns are to be moved */
        U8                transType    /* Single Transaction / All trans */
      ));

EXTERN Void mgRemoveAllTxn ARGS((
       U8               mgtError,      /* Error to report to Service User */
       MgPeerCb         *peer          /* Peer Control Block */
    ));

EXTERN Void mgRemoveOutGoingTxn ARGS((
       U8               mgtError,      /* Error to report to Service User */
       MgPeerCb         *peer          /* Peer Control Block */
    ));




/******************************************************************************/
/*                                                                            */
/*                  Peer Control Block Module                                 */
/*                         (mg_peer.c)                                        */
/******************************************************************************/

/* Function to allocate memory for a peer entity control block */
EXTERN MgPeerCb * mgAllocPeerCb ARGS((
       MgSSAPCb         *ssapCb,       /* SSAP Control Block */
       MgPeerInitInfo   *peerInfo      /* Peer Initialisation Information */
    ));

/* Function to Free memory associated with Peer Control Block */
EXTERN Void mgDeAllocPeerCb ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

/* Function to process peer association failure */
EXTERN Void mgProcessPeerMGCFailure ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

#ifdef GCP_MG_MGC_DISC_RECOVERY
EXTERN S16 mgPrcActivePeerMgcFailure ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));
#endif /*GCP_MG_MGC_DISC_RECOVERY*/

/* Function to process DNS Response Received for the Peer */
EXTERN Void mgRcvDnsRslvCfm ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       MgNetAddrTbl     *addrTbl,      /* List of Network Layer Addresses */
       U16              port,          /* Port Number */
       U32              ttl            /* Time to Live for DNS Record */
    ));

/* Function to Delete Peer Control Block */
EXTERN Void mgDeletePeer ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       U16              event,         /* Event to Indicate to Layer Manager */
       U16              cause,         /* Cause of the event */
       Bool             delReqd,       /* LM initiated Delete */
       U16              usrReason      /* Reason communicated to user*/
    ));

/* Function to remove all Peer related transactions */
EXTERN Void mgBringPeerToCfgStatus ARGS((
       MgPeerCb         *peer,         /* Pointer to Peer Control Block */
       Bool             stopTmrs,      /* Stop Timers */
       Bool             closeTpt       /* close transport  connections*/
    ));

/* Function to process registeration response from service user 
   rsp --> MgMgcoRsp : MGCP
   rsp --> MgSvcChgInfo : MEGACO */
EXTERN S16 mgPrcUserRegRsp ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       MgRxTransIdEnt   *rxCb,         /* Transaction Control Block */
       Ptr              rsp            /* MEGACO or MGCP Response */
    ));

#ifdef GCP_MGC
EXTERN S16 mgPrcMgcUserRegRsp ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       MgRxTransIdEnt   *rxCb,         /* Transaction Control Block */
       Ptr              rsp            /* MEGACO or MGCP Response */
    ));
#endif /* GCP_MGC */

#ifdef GCP_MG
EXTERN S16 mgPrcMgwUserRegRsp ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       MgRxTransIdEnt   *rxCb,         /* Transaction Control Block */
       Ptr              rsp            /* MEGACO or MGCP Response */
    ));
#endif /* GCP_MG */

#ifdef GCP_MGCO 

#ifdef GCP_MGC
EXTERN S16 mgMatchMId ARGS((
        MgPeerCb        *peer,         /* Peer Control Block */
        MgMgcoMid       *addr          /* address */
      ));
#endif /* GCP_MGC */


/* added extra argument trId to the function */
EXTERN S16 mgMgcoSendErrRsp ARGS((
        MgcoTptInfo     *mgcoTptInfo , /* Mgco Transport Information */
        S16             rspCode,       /* Error Response Code */
        MgMgcoMsg       *errMsg,       /* Error Message */
        U32             trId           /* TransactionId */
      ));


/* Function to process service change from service user */
EXTERN S16 mgPrcUserSrvcChng ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       MgSvcChgInfo     *svcChgInfo    /* Service change Info */
    ));

/* Function to find a peer based on MId */
/* Modified declaration */
EXTERN MgPeerCb *mgGetPeer ARGS((
       TknStrOSXL       *mId,          /* MId */   
       CmTptAddr        *remAddr,      /* Remote Transport Address */
       U8               *name,         /* domain name */
       MgSSAPCb         *ssap,          /* Pointer to MgSSAPCb */
       Bool             *sendUpd            /* send Update */
    )); 

/* Added a new function */
#ifdef GCP_MG
EXTERN MgPeerCb *mgGetAndAdjstPeerInLst ARGS((
       TknStrOSXL       *mId,          /* MId */   
       CmTptAddr        *remAddr,      /* Remote Transport Address */
       U8               *name,         /* domain name */
       MgSSAPCb         *ssap,         /* Pointer to MgSSAPCb */
       Bool             *sendUpd            /* send Update */
    )); 
#endif /* GCP_MG */


/* Function to send service change message to peer */
/* Modified function declaration, due to change in one the params
 * */
EXTERN S16 mgSendSrvcChng ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       U8               method,        /* Service Change method */
       U8*              reason,        /* Reason */
       MgTptSrvr        *srvr,         /* transport server used for 
                                          sending */
       S32              port,          /* Service Change Port */
       MgAddrInfo       *mgcInf,       /* Handoff MGC Info */
       /* 3gpp prof-neg */
       MgProfLstNode    *profLstNode   /* Profile need to send in SVC */
    ));


/* Function to send service change reply message to peer */
EXTERN S16 mgSendSrvcChngReply ARGS((
       U32              rspCode,       /* Response Code */
       MgcoTptInfo      *mgcoTptInfo,  /* Common Transport Information 
                                        * Strcture */
       MgMgcoMsg        *mgcoMsg,      /* Error Message */
       MgTransId        transId        /* Transaction Id */
    ));

/* Function to process TCP Connection Indication received from peer */
EXTERN S16 mgPrcPeerConInd ARGS((
       MgTptSrvr        *srvrCb,       /* Server control block */
       MgTSAPCb         *tsap,         /* Pointer to MgTSAPCb */
       MgTptSrvr        *lclSrvr       /* Local server on which 
                                          connection received */
    ));

/* Function to process TCP Connection Indication received from peer */
EXTERN S16 mgPrcPeerConCfm ARGS((
       MgPeerCb         *peer          /* Peer Control Block */
    ));

/* Function to process TCP server or connection disconnect indication */
EXTERN S16 mgPrcPeerDiscInd ARGS((
       MgPeerCb         *peer          /* Peer Control Block */
    ));



/* Function to process Service change message */
EXTERN S16 mgProcessSrvcChng ARGS((
      S16                *errAction,         /* Action to be taken on error */
      S16                *rspCode,           /* Response code */
      TknStrOSXL         *msgMid,            /* mid in MEGACO message*/
      MgMgcoVersion      *msgVer,            /* version in MEGACO message*/
      MgSvcChgInfo       *svcChg,            /* Service change or reply Information */
      MgcoTptInfo        *mgcoTptInfo,             /* Association Control Block */
      MgTransId          transId,            /* Transaction Id */
      Bool               crtRxCb,             /* whether to create rxCb */
      MgMgcoTxn          *mgcoTxn             /* Txn*/
    ));
 
/* Function to process Service change Reply message */
EXTERN S16 mgProcessSrvcChngReply ARGS((
      S16                *errAction,         /* Action to be taken on error */
      MgMgcoVersion      *msgVer,            /* Version in MEGACO message */
      MgSvcChgInfo       *svcChg,            /* Service change or reply Information */
      MgcoTptInfo        *mgcoTptInfo,
      U8                 msgInfo,            /* txCb->msgInfo ?*/
      MgTransId          transId,            /* transaction id */
      Bool               updTxCb,            /* whether update txCb */
      MgTxTransIdEnt     **txCb,             /* transaction control block */
      U8                 immAckPres,         /* Added immAckPres     
                                                flag in SC Reply Handler */
      MgMgcoTxn          *mgcoTxn
    ));

EXTERN S16 mgSendMgcoTxnPend ARGS((
       MgRxTransIdEnt   *rxCb          /* Queued Acknowledgement */
    ));

/* Modified function declaration */
EXTERN S16 mgCnvrtPeerInfoToMId ARGS((
       MgAddrInfo       *peerInfo,     /* Peer Address Information */
       MgMgcoMid        *mid,          /* MID to be filled */
       Ptr              memLstCp       /* Memory list Control point */
    ));

/* Function to process the incoming responses */
EXTERN S16 mgFindAndPrcAck ARGS((
       S16                *errAction,         /* Action to be taken on error */
       MgPeerCb           *peer,              /* Peer Control block */
       MgTptSrvr          *srvr,              /* Server Control Block */
       U8                 *msgInfo,           /* msgInfo */ 
       MgTransId          transId            /* Transaction Id */
       ));

#endif /* GCP_MGCO */

#ifdef GCP_MG
/* Function to select next peer in case of MG */
EXTERN Void mgSelectPeer ARGS((
       MgPeerCb         **peer,        /* Peer Control Block */
       MgSSAPCb         *ssap          /* SSAP Control Block */
    ));
#endif /* GCP_MG */


/* Function to send queued messages to peer */
EXTERN Void mgTxQueueMsg ARGS((
       MgPeerCb         *peer
    ));

#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
/* Function to send queued messages to peer */
EXTERN Void mgTxNtfyRQMsg ARGS((
       MgPeerCb         *peer
    ));
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

EXTERN Void mgTxQueueMsgOnCommEnt ARGS((
       MgPeerCb         *peer,
       MgTxTransIdEnt   *txCb
    ));

EXTERN Void mgAbortHandOff ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       U16              cause
    ));

EXTERN Void mgAbortRedirection ARGS((
       MgPeerCb         *peer,         /* Peer Control Block */
       U16              cause
    ));

EXTERN S16 mgSendTxnRspAck ARGS((
        MgcoTptInfo        *mgcoTptInfo,
        MgTransId          trId        /* Transaction ID for rspAck */
       ));


/******************************************************************************/
/*                                                                            */
/*                   Transport Layer Interface Module                         */
/*                          (mg_tpt.c)                                        */
/******************************************************************************/

/* Function to allocate a transport server control block */
EXTERN S16 mgAllocSrvrCb ARGS((
       MgSrvrInitInfo   *initInfo,     /* Initialisation Info */
       CmTptAddr        *tptAddr,      /* Transport Server Address */
       CmTptParam       *tptParam,     /* Transport Parameters */
       MgSSAPCb         *ssap,         /* SSAP Control Block */
       MgPeerCb         *peer,         /* Peer Control Block */
       Ptr              *srvr,         /* Allocated server */
       MgTSAPCb         *tsap          /* TSAP Control Block */
    ));

/* Function to release resources attached to a Server Control Block */
EXTERN Void mgDeAllocSrvrCb ARGS((
       MgTptSrvr        *srvrCb       /* Pointer to Server control block */
    ));

/* Function to bring server to configuration status */
EXTERN Void mgBringSrvrToCfgStatus ARGS((
       MgTptSrvr        *srvrCb       /* Pointer to Server control block */
    ));

/* Function to open a transport layer Server (TCP or UDP) */
EXTERN S16 mgSrvOpenReq ARGS((
       MgTptSrvr        *srvrCb,       /* Server */
       CmTptParam       *tptParam,     /* Transport Parameters */
       CmTptAddr        *srvrAddr      /* Server Address */
    ));

/* Function to process confirmation for opening of a Listener */
EXTERN S16 mgSrvConCfm ARGS((
       UConnId          spConnId,      /* Service Provider ConnId */
       MgTptSrvr        *srvrCb,       /* server */
       MgTSAPCb         *tsap,         /* TSAP CB */
       CmTptAddr        *locAddr       /* local Address */
    ));

/* Function to initiate closing of a Server or a TCP connection */
EXTERN Void mgSrvDiscReq ARGS((
       MgTptSrvr        *srvrCb,       /* Server */
       Bool             delReqd        /* Reason */
    ));

/* Function to process receipt of an indication for server or TCP 
   connection going down */
EXTERN Void mgSrvDiscInd ARGS((
       MgTptSrvr        *srvrCb        /* Server */
    ));

/* Function to initiate a TCP connection */
EXTERN S16 mgSrvConReq ARGS((
       MgTptSrvr        *srvrCb,       /* Server */
       CmTptParam       *tptParam,     /* Transport Parameters */
       MgTSAPCb         *tsap,         /* TSAP CB */
       CmTptAddr        *srvrAddr      /* Remote Server Address */
    ));

/* Function to process TCP connection from remote peer */
EXTERN S16 mgSrvConInd ARGS((
       MgTptSrvr        *srvrCb,       /* Server */
       CmTptAddr        *tptAddr,      /* Remote Transport Address */
       MgTSAPCb         *tsap,         /* TSAP CB */
       UConnId          spConnId       /* spConnId */
    ));
       
/* Function to transmit Data over a socket */
EXTERN S16 mgSrvDatReq ARGS((
       MgTptSrvr        *srvrCb,       /* Server */
       CmTptAddr        *remoteAddr,   /* Remote Transport Address */
       Buffer           *mBuf          /* Data buffer to transmit */
    ));

#ifdef CM_DNS_LIB
EXTERN S16 mgSndRslvReqToDns ARGS((
       Ptr              txFuncParam,   /* Pointer to Listener control block */
       CmTptAddr        *remoteAddr,   /* Remote Transport Address */
       Buffer           *mBuf          /* Data buffer to transmit */
    ));
#endif /* CM_DNS_LIB */

EXTERN S16 mgObtainSuConnId  ARGS((
       MgSrvrInitInfo  *initInfo,     /* Server Initialisation Info */
       MgTptSrvr       *srvr,         /* Server Control Block */
       MgTSAPCb        *tsap,         /* TSAP Control Block */
       UConnId         *suConnId,     /* Allocated SuConnId */
       U16             *event         /* Usta Event */
    ));

#ifdef CM_ABNF_MT_LIB
/******************************************************************************/
/*                                                                            */
/*                       Multithreading Module                                */
/*                           (mp_ed.c)                                        */
/******************************************************************************/

typedef S16 (* MedDecCfm )ARGS((U32 , Ptr, Buffer *, MsgLen, CmAbnfErr *, Ptr));

typedef S16 (* MedEncCfm )ARGS((U32, Ptr, Buffer *, CmAbnfErr *, Ptr));


EXTERN S16 mgSndEncPduMsgReq  ARGS((
       U8               encodingScheme,  /*MAH_TODO*/
       U32              prot,            /* protocol variant */
       U32              peerId,          /* peer identifier */
       U8               source,          /* source; Internal or User */
       SpId             spId,            /* SSap identifier */
       CmTptAddr        *srcAddr,        /* source address */
       Ptr              event,           /* event structure */
       Bool             delPeer,         /* Whether peer needs to be deleted */
       MgTSAPCb         *tsap,           /* TSAP Control Block */
       MgcoTptInfo      *mgcoTptInfo
));

EXTERN S16 cmUnpkMedDecCfm  ARGS((
       MedDecCfm  func,                    /* function */
       Pst        *pst,                    /* post structure */
       Buffer     *mBuf                    /* message buffer */
));

EXTERN S16 cmUnpkMedEncCfm  ARGS((
       MedEncCfm  func,                    /* function */
       Pst        *pst,                    /* post structure */
       Buffer     *mBuf                    /* message buffer */
));


EXTERN S16 mgSndDecPduMsgReq  ARGS((
       U8               encodingScheme,    
       U32              prot,              /* protocol variant */
       Buffer           *mBuf,             /* buffer to be decoded */
       Ptr              event,             /* event structure */
       MgTSAPCb         *tsap,             /* TSAP control block */
       MgcoTptInfo      *mgcoTptInfo       /* Transport Information */
));


EXTERN S16 mgRcvEncPduMsgCfm ARGS((
      U32              prot,              /* protocol variant */
      Ptr              event,              /* event structure */
      Buffer           *mBuf,             /* buffer to be decoded */
      CmAbnfErr        *err,              /* error */
      Ptr              usrCxt                /* user context */
));

EXTERN S16 mgRcvDecPduMsgCfm ARGS((
      U32              prot,              /* protocol variant */
      Ptr              event,             /* event structure */
      Buffer           *mBuf,             /* buffer to be decoded */
      MsgLen           numDecBytes,       /* no of decoded bytes */
      CmAbnfErr        *err,              /* error */
      Ptr              usrCxt             /* user context */
));

EXTERN S16 mgCreatEDInst ARGS((
      Inst      noEDInst,               /* number of ED instances */
      Inst      firstEDInst,            /* first ED instance */
      Ent       ent                     /* Entity */
));

EXTERN Void mgFreeEncDecRsrc ARGS((Void));

EXTERN Void mgPrcEncTmrExpiry ARGS((
       U32                 nodeIndx           /* node Index */
));
EXTERN Void mgPrcDecTmrExpiry ARGS((
       U32                 nodeIndx           /* node Index */
));

EXTERN Void mgFreeEncRsrc ARGS((
MgStoreList    **node,               /* node in store list */
MgStoreEncReq  **txnBuf,             /* stored encode req */
Ptr            *usrCxt,             /* user cxt */
U16            cnt,                 /* no of txn in mgco message */
U32            prot,                /* protocol */
Bool           freeTxn              /* whether to free MGCO txn */
));

EXTERN Void mgDfrdShutDwn ARGS(( void ));

#endif /* CM_ABNF_MT_LIB */

/******************************************************************************/
/*                                                                            */
/*                     Timer Processing Module                                */
/*                          (mg_tmr.c)                                        */
/******************************************************************************/

/* Function to activate a timer */
EXTERN Void mgStartTmr ARGS((
       S16              tmrEvnt,       /* Timer to be started */
       U32              tmrVal,        /* Timeout period */
       PTR              cb,            /* Entry to be timed out */
       CmTimer          *timers        /* Timer Block */
    ));

/* Function to stop an active timer */
EXTERN Void mgStopTmr ARGS((
       S16              tmrEvnt,       /* Timer to be started */
       PTR              cb,            /* Entry being timed out */
       CmTimer          *timers        /* Timer Block */
    ));

/* Function to Process Timer Expiries */
EXTERN Void mgPrcTmrExpiry ARGS((
       PTR              cb,             /* Entry being timed out */
       S16              tmrEvnt         /* Timer to be started */
    ));

/* Function to fill in the arguments for placing/removing 
                                        timer from Timing Q */
EXTERN S16 mgFillTmrArg ARGS((
       S16              tmrEvnt,        /* Timer Event */
       CmTmrArg         *tmrArg         /* Timer Function Argument */
    ));

/* free all stored txn node..stop timers if started */
EXTERN Void mgStopPeerTmrs ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));


/* Process TTL Timer Expiry for a Peer */
EXTERN Void mgPrcTTLTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

/* Function to process DNS Resolution Request Timeout */
EXTERN Void mgPrcDnsReqTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

/* Function to process Retransmission timeout for a Transaction */
EXTERN Void mgPrcRetxTmrExpiry ARGS((
       MgTxTransIdEnt   *txCb          /* Transaction Control Block */
    ));

EXTERN Void mgHdlRetxTmrExpiry ARGS((
       MgTxTransIdEnt   *txCb          /* Transaction Control Block */
    ));


#ifdef GCP_MGCP
#ifdef GCP_2705BIS
/* Function to process Retransmission timeout for final response */
EXTERN Void mgPrcRetxRspTmrExpiry ARGS((
       MgRxTransIdEnt   *rxCb          /* Transaction Control Block */
    ));

/* Function to process Disc Timer Expiry  timer */
EXTERN Void mgPrcDiscTmrExpiry ARGS((
       MgTxTransIdEnt   *txCb          /* Transaction Control Block */
    ));
/* function to process txnTmOut timer expiry */
EXTERN Void mgPrcTxnTmoutTmrExpiry ARGS((
       MgRxTransIdEnt     *rxCb               /* Queued Acknowledgement */
));
#endif /* GCP_2705BIS */
/* Function to process Response Timer Expiry (30 second) timer */
EXTERN Void mgPrcTxnRspAckTmrExpiry ARGS((
       MgTxnAckList     *cb          /* Transaction Control Block */
    ));
#endif /* GCP_MGCP */

/* Function to process Response Timer Expiry (30 second) timer */
EXTERN Void mgPrcTxnRspTmrExpiry ARGS((
       MgRxTransIdEnt   *txCb          /* Transaction Control Block */
    ));

/* Function to process Bind Request Timeout */
EXTERN Void mgPrcBndReqTmrExpiry ARGS((
       MgTSAPCb         *tsap          /* TSAP Control Block */
    ));

/* Function to process TCP Idle connection timer expiry */
EXTERN Void mgPrcIdleConnTmrExpiry ARGS((
       MgTptSrvr        *srvr          /* TCP Connection */
    ));

#ifdef GCP_MG  
/* Process Restart Avalanche Timer Expiry for a Peer */
EXTERN Void mgPrcRstrtTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));
#endif /* GCP_MG */


#ifdef GCP_MGCO
#ifdef GCP_MGC  
/* Process Handoff Timer Expiry for a Peer */
EXTERN Void mgPrcHndOffTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));
#endif /* GCP_MGC */
#endif /* GCP_MGCO */
#ifdef GCP_PKG_MGCO_ROOT

EXTERN Void mgPrcProvRspRootTmrExpiry ARGS((
       MgTxTransIdEnt   *txCb          /* Transaction Control Block */
    ));
#endif /* GCP_PKG_MGCO_ROOT */
/* Process Service Change Timer Expiry for a Peer */
EXTERN Void mgPrcSrvcChngTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

/* Process Delete Peer Timer Expiry for a Peer */
EXTERN Void mgPrcDelPeerTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

/*Process Config Peer Timer Expiry for a Peer */
EXTERN Void mgPrcConfigPeerTmrExpiry ARGS((
       MgPeerCb         *peer          /* Pointer to Peer Control Block */
    ));

/* Process provisional Response Timer Expiry */
EXTERN Void mgPrcProvRspTmrExpiry ARGS((
       MgRxTransIdEnt     *rxCb               /* Queued Acknowledgement */
    ));

#ifdef GCP_MGCP
EXTERN Void mgMgcpExecRetxAlgo ARGS((
       MgTSAPCb           *tsap,              /* TSAP Control Block */
       MgPeerCb           *peer,              /* Pointer to Peer Control Block */
       MgTxTransIdEnt     *txCb,              /* Transaction Control Block */
       Bool               *retx               /* Retransmit or not ? */
    ));

EXTERN MgPeerCb * mgFindPeerFrmDmn ARGS((
       U8           *val,              /* endpoint name */
       U16          len                /* length */
       ));
#endif /* GCP_MGCP */

/******************************************************************************/
/*                                                                            */
/*                     Function exported by LMI  Module                       */
/*                     (mg_mi.c)                                              */
/******************************************************************************/

EXTERN Void mgGenStaInd ARGS((
       Elmnt            elmnt,         /* ALARM element */
       U16              category,      /* ALARM category */
       U16              event,         /* ALARM event */
       U16              cause,         /* ALARM cause */
       U8               alarmType,     /* ALARM type */
       Ptr              alarmInfo,     /* additional alarm info */
       Size             alarmInfoSize, /* size of alarm information */
       SuId             sapId          /* suId */
    ));

EXTERN Void mgGenTrcInd ARGS((
       MgTSAPCb         *tsap,         /* TSAP control block */
       SpId             sapId,         /* SAP ID */
       U16              evnt,          /* trace event */
       MgPeerCb         *peerCb,       /* Peer Control Block */
       Buffer           *mBuf          /* message being traced */
    ));


EXTERN U16 mgIssueTxnErr ARGS((
       MgSSAPCb         *sSAPCb,       /* SSAP Control Block */
       U16              errType        /* Error Type */
   ));

EXTERN  Void mgChkRes ARGS((
       Region           region,        /* Region identifier */
       Pool             pool,          /* Pool identifier */
       Bool             *resCong       /* Resouce congestion flag */
    ));
EXTERN S16 mgCmpTptAddr ARGS((
       CmTptAddr        *addr1,        /* First transport address */
       CmTptAddr        *addr2         /* First transport address */
    ));

#ifdef DEBUGP

EXTERN Void mgGetPortAndAscAddr ARGS((
       CmTptAddr        *addr,         /* transport address */
       U16              *port,         /* port */
       Txt              *str           /* address string */
   ));

EXTERN Void mgBcdToAsc ARGS((
       U8               *str,          /* input address string to be converted */
       U8               len,           /* length of input string in octets */
       Txt              *ascStr        /* output ASCII string */
));

#endif /* DEBUGP */

/******************************************************************************/
/*                                                                            */
/*                     System Services entry points                           */
/******************************************************************************/

#ifdef SS_MULTIPLE_PROCS
EXTERN S16 mgActvInit ARGS ((
       ProcId           proc,
       Ent              entity,        /* Entity */
       Inst             inst,          /* Instance */
       Region           region,        /* Region */
       Reason           reason,        /* Reason */
       Void             **xxCb
    ));
#else
EXTERN S16 mgActvInit ARGS ((
       Ent              entity,        /* Entity */
       Inst             inst,          /* Instance */
       Region           region,        /* Region */
       Reason           reason         /* Reason */
    ));
#endif /* SS_MULTIPLE_PROCS */

EXTERN S16 mgActvTsk ARGS ((
       Pst              *pst,          /* Post Structure */
       Buffer           *mBuf          /* Message Buffer */
    ));

#ifdef SS_MULTIPLE_PROCS
EXTERN S16 mgActvTmr ARGS ((ProcId proc, Ent ent, Inst inst));
EXTERN S16 mgActvTmrTTL ARGS ((ProcId proc, Ent ent, Inst inst));
#else
EXTERN S16 mgActvTmr ARGS ((void));
EXTERN S16 mgActvTmrTTL ARGS ((void));
#endif /* SS_MULTIPLE_PROCS */

EXTERN S16 mgInitExt ARGS((void ));

#ifdef ZG
EXTERN U16 mgZgShutDown ARGS((void ));
#else
EXTERN U16 mgShutdown ARGS((void ));
#endif /* ZG */

PUBLIC Void mgSendLmCfm ARGS ((
        U8              cfmType,       /* Confirm Primitive Type */
        U16             status,        /* Status of Primitive */
        U16             reason,        /* Reason for Failure */
        Pst             *srcPst,       /* Source Post Structure */
        MgMngmt         *cfm           /* Confirmation Structure */
      ));

#ifdef GCP_USE_AH
EXTERN S16 mgCreateAH ARGS((
        MgMgcoAuthHdr *ah,         /* Authentication Header */
        Buffer        *mBuf,       /* Outgoing Buffer */
        CmTptAddr     *remAddr,    /* Remote Address */
        CmTptAddr     *srcAddr     /* Source Address */
    ));


EXTERN S16 mgValidateAH ARGS((
        MgMgcoAuthHdr *ah,         /* Authentication Header */
        Buffer        *mBuf        /* Incoming Buffer */
    ));

#endif /* GCP_USE_AH */

/******************************************************************************/
/*                     Function in mp_pldf.c                                  */
/******************************************************************************/

#ifdef ZG_DFTHA
#ifdef GCP_MGCO

EXTERN S16 mgSndRvUpdSvcRspP ARGS ((
       UConnId            suConnId,           /* Listener Control Block */
       CmTptAddr          *srcAddr,           /* Source Transport Address */
       MgPeerCb           *peer,              /* Peer Id */
       MgMgcoVersion      ver,                /* MEGACO version */
       MgSvcChgInfo       *svcChg,            /* Service change or reply Information */
       U8                 msgInfo,            /* txCb->msgInfo ?*/
       U8                 qType               /* queue type */
));
EXTERN S16 mgPrcPldfMgcoMsg ARGS((
       UConnId            suConnId,           /* Listener Control Block */
       UConnId            suRsetId,           /* suConnId with rsetId embed */
       CmTptAddr          *srcAddr,           /* Source Transport Address */
       U32                peerId,             /* Peer Id */
       MgMgcoMsg          *mgcoMsg,           /* megaco message */
       MgTSAPCb           *tsap               /* TSAP Control block */
));
#endif /* GCP_MGCO */
#ifdef GCP_MGCP
EXTERN S16 mgPrcPldfMgcpMsg ARGS((
       UConnId            suConnId,           /* Listener Control Block */
       UConnId            suRsetId,           /* suConnId with rsetId embed */
       CmTptAddr          *srcAddr,           /* Source Transport Address */
       U32                peerId,             /* Peer Id */
       MgMgcpTxn          *txn,               /* mgcp message */
       MgTSAPCb           *tsap               /* TSAP Control block */
));
EXTERN S16 mgPrcPldfPiggyBkdMsg ARGS((
       SpId               spId,               /* SSap Id */
       U32                peerId,             /* PeerId */
       MgMgcpTxn          *txn,               /* MGCP txn from user */
       U8                 msgIdx              /* msg to be processed */
));
EXTERN S16  mgPrcEachPiggyBkdTxn ARGS((
       MgPeerCb        *peer,          /* peer control block */
       MgSSAPCb        *ssap,          /* SSAp control block */
       MgMgcpTxn       *txn,           /* MGCP txn */
       CmTptAddr       *tptAddr,       /* Destination address */
       U8              msgIdx,         /* message to be processed */
       Bool            ssapSrvr,       /* Is Ssap srvr */
       MgTptSrvr       *srvr           /* srver control block */
));
#endif /* GCP_MGCP */
EXTERN S16 mgPrcPldfRspAck ARGS((
       MgTransId          trId,        /* transaction Id */
       U32                peerId,      /* peer identifier */
       U32                protocol     /* protocol */
));
EXTERN Ptr mgFindRvUpdNode ARGS((
        U32              peerId,       /* PeerId */
        U16              seqNo,        /* Sequence no. */
        U8               qType,        /* Queue Type */
        MgTSAPCb         **tsap        /* TSAP */
));
EXTERN S16 mgPrcRvUpdTmrExpiry ARGS((
        MgRvUpdQNode    *rvNode         /* Node for which timer has expired */
));
EXTERN S16 mgPrcRvUpdAck ARGS((
        MgRvUpdQNode    *rvNode         /* Node to be processed for rvUpd */
));
EXTERN S16 mgQueueRvUpdTxnInd ARGS((
        Ptr                 msg,        /* msg buffer to be processed later */
        MgRvUpdQNode       *queue,      /* list in which node is queued */
        MgRvUpdQNode       *node,       /* allocated for storing queued info */
        U8                  prot,       /* protocol - MGCP/MEGACO */
        CmTptAddr          *srcAddr,    /* Source transport address */
        MgTptSrvr          *srvr        /* listener control block */
));
EXTERN S16 mgQueueRvUpdTxnReq ARGS((
        Ptr                 msg,        /* msg buffer to be processed later */
        MgRvUpdQNode       *queue,      /* list in which node is queued */
        MgRvUpdQNode       *node,       /* allocated for storing queued info */
        U8                  prot,       /* protocol - MGCP/MEGACO */
        SpId                spId        /* SSAP Id */
));
EXTERN S16 mgFreeRvUpdRsrc ARGS((
        MgRvUpdQNode       *queue,      /* list in which node is queued */
        U8                  qType       /* type of queue to be deallocated */
));
#endif /* ZG_DFTHA */


#ifdef MG_FTHA 
/******************************************************************************/
/*                        System Agent  Interface Primitives                  */
/******************************************************************************/
EXTERN S16 MgMiShtCntrlReq ARGS((
       Pst     *pst,                 /* post structure */
       ShtCntrlReqEvnt *reqInfo      /* system agent control request event */
    ));

EXTERN S16 MgMiShtCntrlCfm ARGS((
       Pst     *pst,                 /* post structure */
       ShtCntrlCfmEvnt *cfmInfo      /* system agent control confirm event */
    ));

#endif /* MG_FTHA */


/* IPV4/IPV4 support functions */
EXTERN S16 mgInitIpAddrLst ARGS((
       Bool            dupFlag       /* Isduplicate allowed in Hsh list/not*/
    ));

EXTERN Void mgDeinitIpAddrLst ARGS((
       Void
    ));

EXTERN S16 mgFindIpAddrLst ARGS((
       U8                 type,      /* address type IPV4 or IPV6 */
       CmIpv4NetAddr      *ipv4Addr, /* Ipv4 address */
       CmIpv6NetAddr      *ipv6Addr, /* Ipv6 address */
       U16                seqNmb,    /* sequence number for dup keys */
       MgIpAddrEnt        **addrEnt  /* entry to be returned */
    ));

EXTERN S16 mgInsertIpAddrLst ARGS((
       MgIpAddrEnt        *addrEnt   /* entry to be inserted */
    ));

EXTERN S16 mgDeleteIpAddrLst ARGS((
      MgIpAddrEnt        *addrEnt    /* entry to be inserted */
    ));

#ifdef MG_RUG
PUBLIC S16 mgGetVer ARGS((
       ShtGetVerCfm *getVerCfmInfo   /* to return interface version information */
       ));

PUBLIC Void mgSetVer ARGS((
       ShtVerInfo *setVerInfo,        /* version information to set */
       CmStatus   *status             /* status to return */
       ));
#endif /* MG_RUG */


#ifdef    GCP_PROV_SCTP

PUBLIC S16  mgEndpOpenReq ARGS((
       MgTSAPCb   *tsap,              /* TSAP Control Block */
       MgEndpCfg  *cfg                /* endpoint configuration pointer */
       ));

PUBLIC S16 mgCloseEndp ARGS((
       MgEndpCb   *endpCb,             /* endpoint CB pointer */
       MgTSAPCb   *tsap,               /* TSAP Control Block */
       Bool       sendFlag             /* Whether to send EndpCloseReq */
       ));

PUBLIC S16 mgDeAllocEndpCb ARGS((
       MgEndpCb   *endpCb             /* endpoint CB pointer */
       ));

PUBLIC S16 mgPrcAssocCfm ARGS((
       MgAssocCb  *assocCb,           /* association CB pointer */
       UConnId    spAssocId,          /* SCTP assoc identifier */
       SctStrmId  inStrms,            /* outgoing streams */
       SctStrmId  outStrms,           /* outgoing streams */
       SctNetAddrLst   *dstAddrLst    /* destination net address list */
       ));

PUBLIC S16 mgPrcAssocInd ARGS((
       SuId       suId,               /* GCP assigned TSAP identifier */
       MgEndpCb   *endpCb,            /* endpoint Control Block */
       SctAssocIndParams *assocParams /* prmt to the association indication */
       ));

PUBLIC S16 mgAssocReq ARGS((
       MgSSAPCb   *ssap,              /* SSAP Control Block */
       MgPeerCb   *peer,              /* Peer Control Block */
       MgAssocCb  *assocCb            /* Allocated association CB */
       ));

PUBLIC S16 mgAllocAssocCb ARGS((
       MgSSAPCb   *ssap,              /* SSAP Control Block */
       MgPeerCb   *peer,              /* Peer Control Block */
       MgAssocCb  **assocCb           /* Allocated association CB */
       ));

PUBLIC S16 mgDeAllocAssocCb ARGS((
       MgAssocCb  *assocCb            /* association CB pointer */
       ));

PUBLIC Void mgExtractCtxIdFrmMsg ARGS((
       MgMgcoMsg          *msg,       /* pointer to MEGACO msg */
       TknU32             *ctxId      /* pointer to Context-Id */
       ));
#endif    /* GCP_PROV_SCTP */


#ifdef   GCP_PROV_MTP3
PUBLIC Void mgHndlPause ARGS((
       MgPeerCb           *peerCb      /* Peer Control Block */   
          ));  

PUBLIC Void mgHndlCong  ARGS((
       MgPeerCb           *peerCb,                 /* affected peer Control Block */
       Priority            prior                     /* affected priority */
         ));         

PUBLIC Void mgHndlResume  ARGS((
       MgPeerCb *peerCb         /* Peer Control Block */
         ));

PUBLIC Void mgHndlRstBeg  ARGS((
      MgTSAPCb *tSap       /* transport sap */
         ));

PUBLIC Void mgHndlRstEnd   ARGS((
      MgTSAPCb *tSap       /* transport sap */
         ));

PUBLIC Void mgMtpStsSync   ARGS((
      MgTSAPCb *tSap       /* Transport sap */
         ));

/* mg016.105: Added LCN Feature Information */
#if (defined(GCP_PROV_MTP3) && defined(GCP_LCN_APP_USE))
PUBLIC S16 mgMtpDatReq     ARGS((
MgPeerCb           *peer,              /* Pointer to Peer control block */
Dpc                 peerDpc,            /* Peer Dpc to whom msg is to be sent */
Dpc                 opc,                /* Self POint Code */  
MgTSAPCb            *tsap,              /* Tsap Cb Pointer */
LnkSel              lnkSel,
Buffer             *mBuf               /* Data buffer to transmit */
         ));
#else
PUBLIC S16 mgMtpDatReq     ARGS((
MgPeerCb           *peer,              /* Pointer to Peer control block */
Dpc                 peerDpc,            /* Peer Dpc to whom msg is to be sent */
Dpc                 opc,                /* Self POint Code */  
MgTSAPCb            *tsap,              /* Tsap Cb Pointer */
Buffer             *mBuf               /* Data buffer to transmit */
         ));
#endif /* (defined(GCP_PROV_MTP3) && defined(GCP_LCN_APP_USE) */
/* Process MTP Restart End Timer Expiry Timer Expiry for a Peer */
/*
PUBLIC Void mgPrcRstEndTmrExpiry ARGS((
       MgPeerCb         *peer          
    ));
*/

/* Process MTP Status Enquiry Timer Expiry for a Peer */
        
PUBLIC Void mgPrcStsEnqTmrExpiry  ARGS((
      MgPeerCb                 *peerCb           /* peer control Block */
    ));  

EXTERN PUBLIC S16 mgDownMtpPointCode ARGS((
      MgTSAPCb           *tsap               /* TSAP Control Block */
));

/* mg011.105: Changes for lock/unlock in MTP3 case */
#ifdef   GCP_MG
EXTERN PUBLIC S16 mgMarkPointCodeOffline ARGS((
      MgTSAPCb           *tsap               /* TSAP Control Block */
));
#endif   /* GCP_MG */

#endif   /* GCP_PROV_MTP3 */


#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
PUBLIC Void mgPrcNtfyAvlTmrExpiry  ARGS((
      MgPeerCb                 *peerCb           /* peer control Block */
    ));  
PUBLIC Void mgPrcNtfyBPTmrExpiry  ARGS((
      MgPeerCb                 *peerCb           /* peer control Block */
    ));  
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

#ifdef GCP_MGCO
#ifdef GCP_PKG_MGCO_ROOT
EXTERN S16 mgGetPendingLimit ARGS((
      MgMgcoTxn          *mgcoTxn,               /* Transaction */
      MgPeerCb           *peer                   /* Peer Control Block */
));
#endif /* GCP_PKG_MGCO_ROOT */


PUBLIC S16 mgVerifySvcChg ARGS((
        MgMgcoTxn       *mgcoTxn,      /* Megaco Transaction */
        U8              *method,         /* Service Change Method */
        U16             *reason
      ));



EXTERN PUBLIC S16 mgEncPduMsg ARGS((
         U32           protVar,    /* protocol and variant */
         U8            *event,     /* pointer to the event structure */
         U32           txnIndx,    /* transaction index to encode or 0 for all*/
         Buffer        *mBuf,      /* Message buffer */
         S32           elmDef,     /* message defintion */
         Mem           *memReg,    /* Memory: region/pool */
         CmAbnfErr     *err        /* error to be returned back to the caller */ 
));

EXTERN PUBLIC S16 mgDecPduMsg ARGS((
         U32           protVar,      /* protocol and variant */
         U8            *event,       /* pointer to the event structure */
         U32           txnIndx,      /* transaction index */
         Buffer        *mBuf,        /* Message buffer */
         S32           elmDef,       /* message defintion */
         MsgLen        *numDecBytes, /* Number of message bytes decoded */
         CmAbnfDecOff  *offset,      /* Decode buffer offset info */
         CmAbnfErr     *err          /* error to be returned back to the caller */ 
));




PUBLIC S16 mgVerifyVersion ARGS ((MgMgcoTxn *mgcoTxn ,MgSSAPCb   *ssap));

#ifdef GCP_CH


PUBLIC S16 mgChCmdFillDefPeerId ARGS((
      MgMgcoCommand *chCmd, 
      MgSSAPCb  *sSap
));

PUBLIC S16 mgChCxtFillDefPeerId ARGS((
      MgMgcoUpdateCntxt *chCxt, 
      MgSSAPCb  *sSap
));

PUBLIC S16 mgChErrReqFillDefPeerId ARGS((
      MgMgcoInd *chInd, 
      MgSSAPCb  *sSap
));

/* mg015.105: CH-Module Redesign changes */
PUBLIC S16 mgChAxnFillDefPeerId ARGS((
      MgMgcoCtxt  *chCtxt, 
      MgSSAPCb    *sSap
));

#endif /* GCP_CH */

#ifdef GCP_ASN
#ifdef MG_ASN_INDEF_LEN
#else
PUBLIC S16 mgPrepSend ARGS((
        U32           protVar,    /* protocol and variant */
        Buffer        *mBuf,      /* Message buffer */
        CmMemListCp   *memCp      /* memory list control block */
));
#endif /* MG_ASN_INDEF_LEN */
#endif/*GCP_ASN*/

#ifdef GCP_CH

PUBLIC S16 mgChPrcMgcoInd ARGS((
   MgMgcoInd          *chInd,         /* CH Command Response */
   MgSSAPCb           *sSap           /* session SAP cb */
));

EXTERN PUBLIC Void mgChHandleMgcoCntxtUpdErr ARGS((
         MgSSAPCb           *ssap,              /* SSAP Control Block */
         MgMgcoUpdateCntxt  *mgCntxt,             /* MGCO Command       */
         U8                 mgtError,           /* Error to be reported */
         U8                 source              /* Initiated by user/ internal */
));


PUBLIC S16 mgChPrcCmdReqTmrExpiry ARGS((
   MgMgcoChTransReq  *trReq
));
 
PUBLIC S16 mgChPrcCmdReq ARGS((
   MgMgcoCommand        *chCmdReq,      /* CH Command Request */
   MgSSAPCb           *sSap           /* session SAP cb */
));


PUBLIC S16 mgChPrcTxnCfm ARGS((
   MgMgcoTxn          *txnInd,       /* Megaco Message     */
   MgcoTptInfo        *mgcoTptInfo,  /* Peer Control Block */
   S16                *err           /* error code         */
));

PUBLIC S16 mgChSendPrim  ARGS((
   Ptr                ptr,          /* CH primitive struct*/
   MgPeerCb           *peer,         /* Peer Control Block */
   S16                *err,          /* error code         */
   U8                 primType       /* Primitive type     */
));

PUBLIC S16 mgChPrcTxnInd ARGS((
   MgMgcoTxn          *txnInd,       /* Megaco Message     */
   MgcoTptInfo        *mgcoTptInfo,         /* Peer Control Block */
   S16                *err           /* error code         */
));
 
PUBLIC S16 mgChPrcCntxtUpd ARGS((
   MgMgcoUpdateCntxt *chUpdCntxt,   /* CH Context Update  */
   MgSSAPCb            *sSap          /* session SAP cb     */
)); 
 

EXTERN PUBLIC Void mgChHandleMgcoPrcTxnIndErr ARGS((
         MgSSAPCb           *ssap,              /* SSAP Control Block */
         MgMgcoTxn          *mgtxn,             /* MGCO Transaction   */
         U8                 mgtError,           /* Error to be reported */
         U8                 source              /* Initiated by user/ internal */
));
 
EXTERN PUBLIC Void mgChHandleMgcoCmdReqErr ARGS((
         MgSSAPCb           *ssap,              /* SSAP Control Block */
         MgMgcoCommand      *chCmd,             /* MGCO Command       */
         U8                 mgtError,           /* Error to be reported */
         U8                 source              /* Initiated by user/ internal */
));

EXTERN PUBLIC Void mgChHandleMgcoPrcIndErr ARGS((
         MgSSAPCb           *ssap,              /* SSAP Control Block */
         MgMgcoInd      *mgInd,             /* MGCO Command       */
         U8                 mgtError,           /* Error to be reported */
         U8                 source              /* Initiated by user/ internal */
));

/* mg015.105: CH-Module Redesign changes */
EXTERN PUBLIC Void mgChHandleMgcoAxnReqErr ARGS((
         MgSSAPCb           *ssap,              /* SSAP Control Block */
         MgMgcoCtxt         *chCtxt,            /* MGCO Command       */
         U8                 mgtError,           /* Error to be reported */
         U8                 source              /* Initiated by user/ internal */
));

PUBLIC S16 mgChPrcAxnRsp ARGS((
   MgMgcoCtxt           *chCtxt,      /* CH Command Response */
   MgSSAPCb             *sSap           /* session SAP cb */
));

PUBLIC S16 mgChPrcCmdRsp ARGS((
   MgMgcoCommand        *chCmdRsp,      /* CH Command Response */
   MgSSAPCb             *sSap           /* session SAP cb */
));

#endif /*GCP_CH*/


#endif /* GCP_MGCO */
#ifdef GCP_MGCP
PUBLIC S16 mgDecodeMgcpTxn ARGS((
       MgMgcpTxn          *txn,            /* MGCP Txn */
       Buffer             *mBuf,           /* Message Buffer */
       CmTptAddr          *srcAddr,        /* source address */
       Bool               *genStaInd,      /* whether to generate status ind */
       MgTSAPCb           *tsap            /* TSAP CB */
));
 
PUBLIC S16 mgPrcRSIPCmd ARGS((
       S16                *errAction,         /* Action to be taken on Error */
       U32                *rspCode,           /* Response Code */
       U32                variant,            /* variant of protocol */
       MgMgcpMsg          *msg,               /* MGCP Msg */
       MgPeerCb           **peerCtlBlk,       /* Peer Control Block */     
       MgTptSrvr          *srvr,              /* Listener Control Block */
       CmTptAddr          *tptAddr,           /* Source Transport Address */
       MgTSAPCb           *tsap               /* TSAP CB */
));

#endif /*GCP_MGCP*/

#ifdef __cplusplus
}
#endif /* _cplusplus */

/* mg003.105: Added Utility function from AGSF product for copying differnt Descriptor and Command parameters from
 * one MemCp to another MemCp */
   
#ifdef GCP_MGCO

/* mg013.105: added utility function for filling timestamp */
EXTERN Void mgUtlGetTimeStamp ARGS(( MgMgcoTimeStamp *timeStamp));

EXTERN S16 mgUtlGrowList            ARGS((Void ***list, U16 typeSize,
                                        TknU16 *numComp, CmMemListCp *evnt));
EXTERN S16 mgUtlShrinkList          ARGS((Void ***list, U16 typeSize,
                                        TknU16 *numComp, CmMemListCp *evnt)); 
EXTERN S16 mgUtlResizeEvntList      ARGS((PTR *list, TknU16 *numComp,
                                        U16 newSize, CmMemListCp *evnt));
EXTERN S16 mgUtlResizeList          ARGS((PTR *list, U16 *numComp, U16 newSize));

#ifdef MGT_MGCO_V2
#ifdef AG
EXTERN S16 mgUtlCpyMgMgcoIndAudStreamParm ARGS((MgMgcoIndAudStreamParm *dst, MgMgcoIndAudStreamParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudStreamDesc ARGS((MgMgcoIndAudStreamDesc *dst, MgMgcoIndAudStreamDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudTermStateDesc ARGS((MgMgcoIndAudTermStateDesc *dst, MgMgcoIndAudTermStateDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudMediaParm ARGS((MgMgcoIndAudMediaParm *dst, MgMgcoIndAudMediaParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudEvents ARGS((MgMgcoIndAudEvents *dst, MgMgcoIndAudEvents *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudSigLst ARGS((MgMgcoIndAudSigLst *dst, MgMgcoIndAudSigLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudSignals ARGS((MgMgcoIndAudSignals *dst, MgMgcoIndAudSignals *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudEventSpecParm ARGS((MgMgcoIndAudEventSpecParm *dst, MgMgcoIndAudEventSpecParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudEventBuffer ARGS((MgMgcoIndAudEventBuffer *dst, MgMgcoIndAudEventBuffer *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudAuditRetParm ARGS((MgMgcoIndAudAuditRetParm *dst, MgMgcoIndAudAuditRetParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoIndAudTermAudit ARGS((MgMgcoIndAudTermAudit *dst, MgMgcoIndAudTermAudit *src, CmMemListCp *mem));
#endif
#endif /* MGT_MGCO_V2 */
#ifdef MGT_MGCO_V2
EXTERN S16 mgUtlCpyMgMgcoAuditItem ARGS((MgMgcoAuditItem *dst, MgMgcoAuditItem *src, CmMemListCp *mem));
#else /* MGT_MGCO_V2 */
#endif /* MGT_MGCO_V2 */
EXTERN S16 mgUtlCpyMgMgcoPathName ARGS((MgMgcoPathName *dst, MgMgcoPathName *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermId ARGS((MgMgcoTermId *dst, MgMgcoTermId *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermIdLst ARGS((MgMgcoTermIdLst *dst, MgMgcoTermIdLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoName ARGS((MgMgcoName *dst, MgMgcoName *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigName ARGS((MgMgcoSigName *dst, MgMgcoSigName *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigLst ARGS((MgMgcoSigLst *dst, MgMgcoSigLst *src, CmMemListCp *mem));
#if(  defined(  GCP_PKG_MGCO_ADVAUSRVRBASE)  || defined(  GCP_PKG_MGCO_AASDIGCOLLECT)  || defined(  GCP_PKG_MGCO_AASRECODING)  || defined(  GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) ) 
EXTERN S16 mgUtlCpyMgMgcoFileUrl ARGS((MgMgcoFileUrl *dst, MgMgcoFileUrl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoHostPort ARGS((MgMgcoHostPort *dst, MgMgcoHostPort *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoUsrPw ARGS((MgMgcoUsrPw *dst, MgMgcoUsrPw *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLogin ARGS((MgMgcoLogin *dst, MgMgcoLogin *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPathType ARGS((MgMgcoPathType *dst, MgMgcoPathType *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoFtpUrl ARGS((MgMgcoFtpUrl *dst, MgMgcoFtpUrl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPathSearch ARGS((MgMgcoPathSearch *dst, MgMgcoPathSearch *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoHttpUrl ARGS((MgMgcoHttpUrl *dst, MgMgcoHttpUrl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoProvSegSpec ARGS((MgMgcoProvSegSpec *dst, MgMgcoProvSegSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoVvarSpec ARGS((MgMgcoVvarSpec *dst, MgMgcoVvarSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSelType ARGS((MgMgcoSelType *dst, MgMgcoSelType *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSelSpecLst ARGS((MgMgcoSelSpecLst *dst, MgMgcoSelSpecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSelList ARGS((MgMgcoSelList *dst, MgMgcoSelList *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoVarSegSpec ARGS((MgMgcoVarSegSpec *dst, MgMgcoVarSegSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSpec ARGS((MgMgcoSpec *dst, MgMgcoSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSegSpec ARGS((MgMgcoSegSpec *dst, MgMgcoSegSpec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAnncSpec ARGS((MgMgcoAnncSpec *dst, MgMgcoAnncSpec *src, CmMemListCp *mem));
#endif
EXTERN S16 mgUtlCpyMgMgcoValue ARGS((MgMgcoValue *dst, MgMgcoValue *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAuthHdr ARGS((MgMgcoAuthHdr *dst, MgMgcoAuthHdr *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDomAddrPort ARGS((MgMgcoDomAddrPort *dst, MgMgcoDomAddrPort *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDomNamePort ARGS((MgMgcoDomNamePort *dst, MgMgcoDomNamePort *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMid ARGS((MgMgcoMid *dst, MgMgcoMid *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoErrDesc ARGS((MgMgcoErrDesc *dst, MgMgcoErrDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTopoDesc ARGS((MgMgcoTopoDesc *dst, MgMgcoTopoDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTopoDescLst ARGS((MgMgcoTopoDescLst *dst, MgMgcoTopoDescLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoContextProps ARGS((MgMgcoContextProps *dst, MgMgcoContextProps *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoValLst ARGS((MgMgcoValLst *dst, MgMgcoValLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoValRng ARGS((MgMgcoValRng *dst, MgMgcoValRng *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoParmValue ARGS((MgMgcoParmValue *dst, MgMgcoParmValue *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPropParm ARGS((MgMgcoPropParm *dst, MgMgcoPropParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPropParmLst ARGS((MgMgcoPropParmLst *dst, MgMgcoPropParmLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLocalParm ARGS((MgMgcoLocalParm *dst, MgMgcoLocalParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLclCtlDesc ARGS((MgMgcoLclCtlDesc *dst, MgMgcoLclCtlDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPropGrpLst ARGS((MgMgcoPropGrpLst *dst, MgMgcoPropGrpLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoLocalDesc ARGS((MgMgcoLocalDesc *dst, MgMgcoLocalDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermStateParm ARGS((MgMgcoTermStateParm *dst, MgMgcoTermStateParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermStateDesc ARGS((MgMgcoTermStateDesc *dst, MgMgcoTermStateDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoStreamParm ARGS((MgMgcoStreamParm *dst, MgMgcoStreamParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoStreamDesc ARGS((MgMgcoStreamDesc *dst, MgMgcoStreamDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMediaPar ARGS((MgMgcoMediaPar *dst, MgMgcoMediaPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMediaDesc ARGS((MgMgcoMediaDesc *dst, MgMgcoMediaDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNonStdId ARGS((MgMgcoNonStdId *dst, MgMgcoNonStdId *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoModemType ARGS((MgMgcoModemType *dst, MgMgcoModemType *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoModemTypeLst ARGS((MgMgcoModemTypeLst *dst, MgMgcoModemTypeLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNonStdExtn ARGS((MgMgcoNonStdExtn *dst, MgMgcoNonStdExtn *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoModemDesc ARGS((MgMgcoModemDesc *dst, MgMgcoModemDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMuxDesc ARGS((MgMgcoMuxDesc *dst, MgMgcoMuxDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtOther ARGS((MgMgcoEvtOther *dst, MgMgcoEvtOther *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNtfyCmpl ARGS((MgMgcoNtfyCmpl *dst, MgMgcoNtfyCmpl *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigPar ARGS((MgMgcoSigPar *dst, MgMgcoSigPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSigParLst ARGS((MgMgcoSigParLst *dst, MgMgcoSigParLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsReq ARGS((MgMgcoSignalsReq *dst, MgMgcoSignalsReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsReqLst ARGS((MgMgcoSignalsReqLst *dst, MgMgcoSignalsReqLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsLst ARGS((MgMgcoSignalsLst *dst, MgMgcoSignalsLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsParm ARGS((MgMgcoSignalsParm *dst, MgMgcoSignalsParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSignalsDesc ARGS((MgMgcoSignalsDesc *dst, MgMgcoSignalsDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapLet ARGS((MgMgcoDigMapLet *dst, MgMgcoDigMapLet *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapRng ARGS((MgMgcoDigMapRng *dst, MgMgcoDigMapRng *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigStrElem ARGS((MgMgcoDigStrElem *dst, MgMgcoDigStrElem *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigStr ARGS((MgMgcoDigStr *dst, MgMgcoDigStr *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMap ARGS((MgMgcoDigMap *dst, MgMgcoDigMap *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapVal ARGS((MgMgcoDigMapVal *dst, MgMgcoDigMapVal *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtDM ARGS((MgMgcoEvtDM *dst, MgMgcoEvtDM *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtParSec ARGS((MgMgcoEvtParSec *dst, MgMgcoEvtParSec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtParSecLst ARGS((MgMgcoEvtParSecLst *dst, MgMgcoEvtParSecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtSec ARGS((MgMgcoEvtSec *dst, MgMgcoEvtSec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtSecLst ARGS((MgMgcoEvtSecLst *dst, MgMgcoEvtSecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbedFirst ARGS((MgMgcoEmbedFirst *dst, MgMgcoEmbedFirst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbWithSig ARGS((MgMgcoEmbWithSig *dst, MgMgcoEmbWithSig *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtPar ARGS((MgMgcoEvtPar *dst, MgMgcoEvtPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtParLst ARGS((MgMgcoEvtParLst *dst, MgMgcoEvtParLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoReqEvt ARGS((MgMgcoReqEvt *dst, MgMgcoReqEvt *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvtLst ARGS((MgMgcoEvtLst *dst, MgMgcoEvtLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoReqEvtDesc ARGS((MgMgcoReqEvtDesc *dst, MgMgcoReqEvtDesc *src, CmMemListCp *mem));
/* MILESTONE_6: Functions for copying embedded events into active events */
EXTERN S16 mgUtlCpyMgMgcoEmbEvtPar ARGS((MgMgcoEvtPar *dst, MgMgcoEvtParSec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbEvtParLst ARGS((MgMgcoEvtParLst *dst, MgMgcoEvtParSecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbEvt ARGS((MgMgcoReqEvt *dst, MgMgcoEvtSec *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbEvtLst ARGS((MgMgcoEvtLst *dst, MgMgcoEvtSecLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEmbEvtDesc ARGS((MgMgcoReqEvtDesc *dst, MgMgcoEmbedFirst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoEvBufDesc ARGS((MgMgcoEvBufDesc *dst, MgMgcoEvBufDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoDigMapDesc ARGS((MgMgcoDigMapDesc *dst, MgMgcoDigMapDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAuditDesc ARGS((MgMgcoAuditDesc *dst, MgMgcoAuditDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAmmDesc ARGS((MgMgcoAmmDesc *dst, MgMgcoAmmDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAmmDescLst ARGS((MgMgcoAmmDescLst *dst, MgMgcoAmmDescLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAmmReq ARGS((MgMgcoAmmReq *dst, MgMgcoAmmReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSubAudReq ARGS((MgMgcoSubAudReq *dst, MgMgcoSubAudReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoObsEvt ARGS((MgMgcoObsEvt *dst, MgMgcoObsEvt *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoObsEvtLst ARGS((MgMgcoObsEvtLst *dst, MgMgcoObsEvtLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoObsEvtDesc ARGS((MgMgcoObsEvtDesc *dst, MgMgcoObsEvtDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNtfyReq ARGS((MgMgcoNtfyReq *dst, MgMgcoNtfyReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgMethod ARGS((MgMgcoSvcChgMethod *dst, MgMgcoSvcChgMethod *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgProf ARGS((MgMgcoSvcChgProf *dst, MgMgcoSvcChgProf *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgPar ARGS((MgMgcoSvcChgPar *dst, MgMgcoSvcChgPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgReq ARGS((MgMgcoSvcChgReq *dst, MgMgcoSvcChgReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoCmd ARGS((MgMgcoCmd *dst, MgMgcoCmd *src, CmMemListCp *mem));
#ifdef GCP_CH
EXTERN S16 mgUtlCpyMgMgcoCommandReq ARGS((MgMgcoCommandReq *dst, MgMgcoCommandReq *src));
#else
EXTERN S16 mgUtlCpyMgMgcoCommandReq ARGS((MgMgcoCommandReq *dst, MgMgcoCommandReq *src, CmMemListCp *mem));
#endif
EXTERN S16 mgUtlCpyMgMgcoCmdReqLst ARGS((MgMgcoCmdReqLst *dst, MgMgcoCmdReqLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoActionReq ARGS((MgMgcoActionReq *dst, MgMgcoActionReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoActionLst ARGS((MgMgcoActionLst *dst, MgMgcoActionLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTxnReq ARGS((MgMgcoTxnReq *dst, MgMgcoTxnReq *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoStatsPar ARGS((MgMgcoStatsPar *dst, MgMgcoStatsPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoStatsDesc ARGS((MgMgcoStatsDesc *dst, MgMgcoStatsDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPkgsItem ARGS((MgMgcoPkgsItem *dst, MgMgcoPkgsItem *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoPkgsDesc ARGS((MgMgcoPkgsDesc *dst, MgMgcoPkgsDesc *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAudRetParm ARGS((MgMgcoAudRetParm *dst, MgMgcoAudRetParm *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTermAuditRes ARGS((MgMgcoTermAuditRes *dst, MgMgcoTermAuditRes *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAmmsReply ARGS((MgMgcoAmmsReply *dst, MgMgcoAmmsReply *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAuditOther ARGS((MgMgcoAuditOther *dst, MgMgcoAuditOther *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoAuditReply ARGS((MgMgcoAuditReply *dst, MgMgcoAuditReply *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoNtfyReply ARGS((MgMgcoNtfyReply *dst, MgMgcoNtfyReply *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgResPar ARGS((MgMgcoSvcChgResPar *dst, MgMgcoSvcChgResPar *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgRes ARGS((MgMgcoSvcChgRes *dst, MgMgcoSvcChgRes *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoSvcChgReply ARGS((MgMgcoSvcChgReply *dst, MgMgcoSvcChgReply *src, CmMemListCp *mem));
#ifdef GCP_CH
EXTERN S16 mgUtlCpyMgMgcoCmdReply ARGS((MgMgcoCmdReply *dst, MgMgcoCmdReply *src));
#else
EXTERN S16 mgUtlCpyMgMgcoCmdReply ARGS((MgMgcoCmdReply *dst, MgMgcoCmdReply *src, CmMemListCp *mem));
#endif
EXTERN S16 mgUtlCpyMgMgcoCmdReplyLst ARGS((MgMgcoCmdReplyLst *dst, MgMgcoCmdReplyLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoCxtCmdReply ARGS((MgMgcoCxtCmdReply *dst, MgMgcoCxtCmdReply *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoErrCmdRepSet ARGS((MgMgcoErrCmdRepSet *dst, MgMgcoErrCmdRepSet *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoActnReply ARGS((MgMgcoActnReply *dst, MgMgcoActnReply *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoActnReplyLst ARGS((MgMgcoActnReplyLst *dst, MgMgcoActnReplyLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTxnReply ARGS((MgMgcoTxnReply *dst, MgMgcoTxnReply *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTxnRspAck ARGS((MgMgcoTxnRspAck *dst, MgMgcoTxnRspAck *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoTxn ARGS((MgMgcoTxn *dst, MgMgcoTxn *src));
EXTERN S16 mgUtlCpyMgMgcoTxnLst ARGS((MgMgcoTxnLst *dst, MgMgcoTxnLst *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMsgBody ARGS((MgMgcoMsgBody *dst, MgMgcoMsgBody *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoMsg ARGS((MgMgcoMsg *dst, MgMgcoMsg *src));
#ifdef GCP_CH
EXTERN S16 mgUtlCpyMgMgcoCommand ARGS((MgMgcoCommand *dst, MgMgcoCommand *src));
EXTERN S16 mgUtlCpyMgMgcoChCntxt ARGS((MgMgcoChCntxt *dst, MgMgcoChCntxt *src, CmMemListCp *mem));
EXTERN S16 mgUtlCpyMgMgcoUpdateCntxt ARGS((MgMgcoUpdateCntxt *dst, MgMgcoUpdateCntxt *src));
EXTERN S16 mgUtlCpyMgMgcoInd ARGS((MgMgcoInd *dst, MgMgcoInd *src));
#endif /* GCP_CH */
#endif /* GCP_MGCO */

/* mg002.201: Extern declaration for MID verification */
EXTERN S16 mgUtlVerifyMid ARGS (( TknStrOSXL*   mid ));

#ifdef GCP_CH
 
#define SO_LOWERCASE(_ch)\
((_ch >= 'A' && _ch <= 'Z')? _ch + ('a' - 'A') : _ch)
 
#endif /* GCP_CH */
 
#ifdef GCP_MGCO
EXTERN S16 mgUtlAllocTknStrOSXL ARGS((
TknStrOSXL  *dstTknStrOSXL,
TknStrOSXL  *srcTknStrOSXL));
EXTERN S16 mgUtlDeAllocTknStrOSXL ARGS(( TknStrOSXL  *dstTknStrOSXL));
EXTERN S16 mgUtlAllocMgMgcoPathName ARGS((
MgMgcoPathName *dst,
MgMgcoPathName *src));
EXTERN S16 mgUtlDeAllocMgMgcoPathName ARGS(( MgMgcoPathName *dst));
EXTERN S16 mgUtlAllocMgMgcoTermId ARGS((
MgMgcoTermId *dst,
MgMgcoTermId *src));
EXTERN S16 mgUtlDeAllocMgMgcoTermId ARGS(( MgMgcoTermId *dst));
EXTERN S16 mgUtlDeAllocMgMgcoTermIdP ARGS(( MgMgcoTermId *dst));
EXTERN S16 mgUtlAllocMgMgcoTermIdLst ARGS((
MgMgcoTermIdLst *dst,
MgMgcoTermIdLst *src));
EXTERN S16 mgUtlDeAllocMgMgcoTermIdLst ARGS(( MgMgcoTermIdLst *dst));

#ifdef MGT_MGCO_V2
#ifdef AG
EXTERN S16 mgUtlDelMgMgcoIndAudStreamParm ARGS((MgMgcoIndAudStreamParm *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudStreamDesc ARGS((MgMgcoIndAudStreamDesc *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudTermStateDesc ARGS((MgMgcoIndAudTermStateDesc *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudMediaParm ARGS((MgMgcoIndAudMediaParm *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudEvents ARGS((MgMgcoIndAudEvents *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudSigLst ARGS((MgMgcoIndAudSigLst *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudSignals ARGS((MgMgcoIndAudSignals *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudEventSpecParm ARGS((MgMgcoIndAudEventSpecParm *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudEventBuffer ARGS((MgMgcoIndAudEventBuffer *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudAuditRetParm ARGS((MgMgcoIndAudAuditRetParm *dst));
EXTERN S16 mgUtlDelMgMgcoIndAudTermAudit ARGS((MgMgcoIndAudTermAudit *dst));
#endif
EXTERN S16 mgUtlDelMgMgcoAuditItem ARGS((MgMgcoAuditItem *dst));
#endif /* MGT_MGCO_V2 */
EXTERN S16 mgUtlDelMgMgcoPathName ARGS((MgMgcoPathName *dst));
EXTERN S16 mgUtlDelMgMgcoTermId ARGS((MgMgcoTermId *dst));
EXTERN S16 mgUtlDelMgMgcoTermIdLst ARGS((MgMgcoTermIdLst *dst));
EXTERN S16 mgUtlDelMgMgcoName ARGS((MgMgcoName *dst));
EXTERN S16 mgUtlDelMgMgcoSigName ARGS((MgMgcoSigName *dst));
EXTERN S16 mgUtlDelMgMgcoSigLst ARGS((MgMgcoSigLst *dst));
#if(  defined(  GCP_PKG_MGCO_ADVAUSRVRBASE)  || defined(  GCP_PKG_MGCO_AASDIGCOLLECT)  || defined(  GCP_PKG_MGCO_AASRECODING)  || defined(  GCP_PKG_MGCO_ADVAUSRVRSEGMNGMT) ) 
EXTERN S16 mgUtlDelMgMgcoFileUrl ARGS((MgMgcoFileUrl *dst));
EXTERN S16 mgUtlDelMgMgcoHostPort ARGS((MgMgcoHostPort *dst));
EXTERN S16 mgUtlDelMgMgcoUsrPw ARGS((MgMgcoUsrPw *dst));
EXTERN S16 mgUtlDelMgMgcoLogin ARGS((MgMgcoLogin *dst));
EXTERN S16 mgUtlDelMgMgcoPathType ARGS((MgMgcoPathType *dst));
EXTERN S16 mgUtlDelMgMgcoFtpUrl ARGS((MgMgcoFtpUrl *dst));
EXTERN S16 mgUtlDelMgMgcoPathSearch ARGS((MgMgcoPathSearch *dst));
EXTERN S16 mgUtlDelMgMgcoHttpUrl ARGS((MgMgcoHttpUrl *dst));
EXTERN S16 mgUtlDelMgMgcoProvSegSpec ARGS((MgMgcoProvSegSpec *dst));
EXTERN S16 mgUtlDelMgMgcoVvarSpec ARGS((MgMgcoVvarSpec *dst));
EXTERN S16 mgUtlDelMgMgcoSelType ARGS((MgMgcoSelType *dst));
EXTERN S16 mgUtlDelMgMgcoSelSpecLst ARGS((MgMgcoSelSpecLst *dst));
EXTERN S16 mgUtlDelMgMgcoSelList ARGS((MgMgcoSelList *dst));
EXTERN S16 mgUtlDelMgMgcoVarSegSpec ARGS((MgMgcoVarSegSpec *dst));
EXTERN S16 mgUtlDelMgMgcoSpec ARGS((MgMgcoSpec *dst));
EXTERN S16 mgUtlDelMgMgcoSegSpec ARGS((MgMgcoSegSpec *dst));
EXTERN S16 mgUtlDelMgMgcoAnncSpec ARGS((MgMgcoAnncSpec *dst));
#endif
EXTERN S16 mgUtlDelMgMgcoValue ARGS((MgMgcoValue *dst));
EXTERN S16 mgUtlDelMgMgcoAuthHdr ARGS((MgMgcoAuthHdr *dst));
EXTERN S16 mgUtlDelMgMgcoDomAddrPort ARGS((MgMgcoDomAddrPort *dst));
EXTERN S16 mgUtlDelMgMgcoDomNamePort ARGS((MgMgcoDomNamePort *dst));
EXTERN S16 mgUtlDelMgMgcoMid ARGS((MgMgcoMid *dst));
EXTERN S16 mgUtlDelMgMgcoErrDesc ARGS((MgMgcoErrDesc *dst));
EXTERN S16 mgUtlDelMgMgcoTopoDesc ARGS((MgMgcoTopoDesc *dst));
EXTERN S16 mgUtlDelMgMgcoTopoDescLst ARGS((MgMgcoTopoDescLst *dst));
EXTERN S16 mgUtlDelMgMgcoContextProps ARGS((MgMgcoContextProps *dst));
EXTERN S16 mgUtlDelMgMgcoValLst ARGS((MgMgcoValLst *dst));
EXTERN S16 mgUtlDelMgMgcoValRng ARGS((MgMgcoValRng *dst));
EXTERN S16 mgUtlDelMgMgcoParmValue ARGS((MgMgcoParmValue *dst));
EXTERN S16 mgUtlDelMgMgcoPropParm ARGS((MgMgcoPropParm *dst));
EXTERN S16 mgUtlDelMgMgcoPropParmLst ARGS((MgMgcoPropParmLst *dst));
EXTERN S16 mgUtlDelMgMgcoLocalParm ARGS((MgMgcoLocalParm *dst));
EXTERN S16 mgUtlDelMgMgcoLclCtlDesc ARGS((MgMgcoLclCtlDesc *dst));
EXTERN S16 mgUtlDelMgMgcoPropGrpLst ARGS((MgMgcoPropGrpLst *dst));
EXTERN S16 mgUtlDelMgMgcoLocalDesc ARGS((MgMgcoLocalDesc *dst));
EXTERN S16 mgUtlDelMgMgcoTermStateParm ARGS((MgMgcoTermStateParm *dst));
EXTERN S16 mgUtlDelMgMgcoTermStateDesc ARGS((MgMgcoTermStateDesc *dst));
EXTERN S16 mgUtlDelMgMgcoStreamParm ARGS((MgMgcoStreamParm *dst));
EXTERN S16 mgUtlDelMgMgcoStreamDesc ARGS((MgMgcoStreamDesc *dst));
EXTERN S16 mgUtlDelMgMgcoMediaPar ARGS((MgMgcoMediaPar *dst));
EXTERN S16 mgUtlDelMgMgcoMediaDesc ARGS((MgMgcoMediaDesc *dst));
EXTERN S16 mgUtlDelMgMgcoNonStdId ARGS((MgMgcoNonStdId *dst));
EXTERN S16 mgUtlDelMgMgcoModemType ARGS((MgMgcoModemType *dst));
EXTERN S16 mgUtlDelMgMgcoModemTypeLst ARGS((MgMgcoModemTypeLst *dst));
EXTERN S16 mgUtlDelMgMgcoNonStdExtn ARGS((MgMgcoNonStdExtn *dst));
EXTERN S16 mgUtlDelMgMgcoModemDesc ARGS((MgMgcoModemDesc *dst));
EXTERN S16 mgUtlDelMgMgcoMuxDesc ARGS((MgMgcoMuxDesc *dst));
EXTERN S16 mgUtlDelMgMgcoEvtOther ARGS((MgMgcoEvtOther *dst));
EXTERN S16 mgUtlDelMgMgcoNtfyCmpl ARGS((MgMgcoNtfyCmpl *dst));
EXTERN S16 mgUtlDelMgMgcoSigPar ARGS((MgMgcoSigPar *dst));
EXTERN S16 mgUtlDelMgMgcoSigParLst ARGS((MgMgcoSigParLst *dst));
EXTERN S16 mgUtlDelMgMgcoSignalsReq ARGS((MgMgcoSignalsReq *dst));
EXTERN S16 mgUtlDelMgMgcoSignalsReqLst ARGS((MgMgcoSignalsReqLst *dst));
EXTERN S16 mgUtlDelMgMgcoSignalsLst ARGS((MgMgcoSignalsLst *dst));
EXTERN S16 mgUtlDelMgMgcoSignalsParm ARGS((MgMgcoSignalsParm *dst));
EXTERN S16 mgUtlDelMgMgcoSignalsDesc ARGS((MgMgcoSignalsDesc *dst));
EXTERN S16 mgUtlDelMgMgcoDigMapLet ARGS((MgMgcoDigMapLet *dst));
EXTERN S16 mgUtlDelMgMgcoDigMapRng ARGS((MgMgcoDigMapRng *dst));
EXTERN S16 mgUtlDelMgMgcoDigStrElem ARGS((MgMgcoDigStrElem *dst));
EXTERN S16 mgUtlDelMgMgcoDigStr ARGS((MgMgcoDigStr *dst));
EXTERN S16 mgUtlDelMgMgcoDigMap ARGS((MgMgcoDigMap *dst));
EXTERN S16 mgUtlDelMgMgcoDigMapVal ARGS((MgMgcoDigMapVal *dst));
EXTERN S16 mgUtlDelMgMgcoEvtDM ARGS((MgMgcoEvtDM *dst));
EXTERN S16 mgUtlDelMgMgcoEvtParSec ARGS((MgMgcoEvtParSec *dst));
EXTERN S16 mgUtlDelMgMgcoEvtParSecLst ARGS((MgMgcoEvtParSecLst *dst));
EXTERN S16 mgUtlDelMgMgcoEvtSec ARGS((MgMgcoEvtSec *dst));
EXTERN S16 mgUtlDelMgMgcoEvtSecLst ARGS((MgMgcoEvtSecLst *dst));
EXTERN S16 mgUtlDelMgMgcoEmbedFirst ARGS((MgMgcoEmbedFirst *dst));
EXTERN S16 mgUtlDelMgMgcoEmbWithSig ARGS((MgMgcoEmbWithSig *dst));
EXTERN S16 mgUtlDelMgMgcoEvtPar ARGS((MgMgcoEvtPar *dst));
EXTERN S16 mgUtlDelMgMgcoEvtParLst ARGS((MgMgcoEvtParLst *dst));
EXTERN S16 mgUtlDelMgMgcoReqEvt ARGS((MgMgcoReqEvt *dst));
EXTERN S16 mgUtlDelMgMgcoEvtLst ARGS((MgMgcoEvtLst *dst));
EXTERN S16 mgUtlDelMgMgcoReqEvtDesc ARGS((MgMgcoReqEvtDesc *dst));
EXTERN S16 mgUtlDelMgMgcoEvBufDesc ARGS((MgMgcoEvBufDesc *dst));
EXTERN S16 mgUtlDelMgMgcoDigMapDesc ARGS((MgMgcoDigMapDesc *dst));
EXTERN S16 mgUtlDelMgMgcoAuditDesc ARGS((MgMgcoAuditDesc *dst));
EXTERN S16 mgUtlDelMgMgcoAmmDesc ARGS((MgMgcoAmmDesc *dst));
EXTERN S16 mgUtlDelMgMgcoAmmDescLst ARGS((MgMgcoAmmDescLst *dst));
EXTERN S16 mgUtlDelMgMgcoAmmReq ARGS((MgMgcoAmmReq *dst));
EXTERN S16 mgUtlDelMgMgcoSubAudReq ARGS((MgMgcoSubAudReq *dst));
EXTERN S16 mgUtlDelMgMgcoObsEvt ARGS((MgMgcoObsEvt *dst));
EXTERN S16 mgUtlDelMgMgcoObsEvtLst ARGS((MgMgcoObsEvtLst *dst));
EXTERN S16 mgUtlDelMgMgcoObsEvtDesc ARGS((MgMgcoObsEvtDesc *dst));
EXTERN S16 mgUtlDelMgMgcoNtfyReq ARGS((MgMgcoNtfyReq *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgMethod ARGS((MgMgcoSvcChgMethod *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgProf ARGS((MgMgcoSvcChgProf *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgPar ARGS((MgMgcoSvcChgPar *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgReq ARGS((MgMgcoSvcChgReq *dst));
EXTERN S16 mgUtlDelMgMgcoCmd ARGS((MgMgcoCmd *dst));
EXTERN S16 mgUtlDelMgMgcoCommandReq ARGS((MgMgcoCommandReq *dst));
EXTERN S16 mgUtlDelMgMgcoCmdReqLst ARGS((MgMgcoCmdReqLst *dst));
EXTERN S16 mgUtlDelMgMgcoActionReq ARGS((MgMgcoActionReq *dst));
EXTERN S16 mgUtlDelMgMgcoActionLst ARGS((MgMgcoActionLst *dst));
EXTERN S16 mgUtlDelMgMgcoTxnReq ARGS((MgMgcoTxnReq *dst));
EXTERN S16 mgUtlDelMgMgcoStatsPar ARGS((MgMgcoStatsPar *dst));
EXTERN S16 mgUtlDelMgMgcoStatsDesc ARGS((MgMgcoStatsDesc *dst));
EXTERN S16 mgUtlDelMgMgcoPkgsItem ARGS((MgMgcoPkgsItem *dst));
EXTERN S16 mgUtlDelMgMgcoPkgsDesc ARGS((MgMgcoPkgsDesc *dst));
EXTERN S16 mgUtlDelMgMgcoAudRetParm ARGS((MgMgcoAudRetParm *dst));
EXTERN S16 mgUtlDelMgMgcoTermAuditRes ARGS((MgMgcoTermAuditRes *dst));
EXTERN S16 mgUtlDelMgMgcoAmmsReply ARGS((MgMgcoAmmsReply *dst));
EXTERN S16 mgUtlDelMgMgcoAuditOther ARGS((MgMgcoAuditOther *dst));
EXTERN S16 mgUtlDelMgMgcoAuditReply ARGS((MgMgcoAuditReply *dst));
EXTERN S16 mgUtlDelMgMgcoNtfyReply ARGS((MgMgcoNtfyReply *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgResPar ARGS((MgMgcoSvcChgResPar *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgRes ARGS((MgMgcoSvcChgRes *dst));
EXTERN S16 mgUtlDelMgMgcoSvcChgReply ARGS((MgMgcoSvcChgReply *dst));
EXTERN S16 mgUtlDelMgMgcoCmdReply ARGS((MgMgcoCmdReply *dst));
EXTERN S16 mgUtlDelMgMgcoCmdReplyLst ARGS((MgMgcoCmdReplyLst *dst));
EXTERN S16 mgUtlDelMgMgcoCxtCmdReply ARGS((MgMgcoCxtCmdReply *dst));
EXTERN S16 mgUtlDelMgMgcoErrCmdRepSet ARGS((MgMgcoErrCmdRepSet *dst));
EXTERN S16 mgUtlDelMgMgcoActnReply ARGS((MgMgcoActnReply *dst));
EXTERN S16 mgUtlDelMgMgcoActnReplyLst ARGS((MgMgcoActnReplyLst *dst));
EXTERN S16 mgUtlDelMgMgcoTxnReply ARGS((MgMgcoTxnReply *dst));
EXTERN S16 mgUtlDelMgMgcoTxnRspAck ARGS((MgMgcoTxnRspAck *dst));
EXTERN S16 mgUtlDelMgMgcoTxn ARGS((MgMgcoTxn *dst));
EXTERN S16 mgUtlDelMgMgcoTxnLst ARGS((MgMgcoTxnLst *dst));
EXTERN S16 mgUtlDelMgMgcoMsgBody ARGS((MgMgcoMsgBody *dst));
EXTERN S16 mgUtlDelMgMgcoMsg ARGS((MgMgcoMsg *dst));
#endif /* GCP_MGCO */
#ifdef GCP_CH
EXTERN S16 mgUtlDelMgMgcoCommand ARGS((MgMgcoCommand *dst));
EXTERN S16 mgUtlDelMgMgcoChCntxt ARGS((MgMgcoChCntxt *dst));
EXTERN S16 mgUtlDelMgMgcoUpdateCntxt ARGS((MgMgcoUpdateCntxt *dst));
EXTERN S16 mgUtlDelMgMgcoInd ARGS((MgMgcoInd *dst));
EXTERN Bool mgUtlCmpTknStrOSXL ARGS((TknStrOSXL *str1,  TknStrOSXL *str2,
                                  Bool       caseSensitive));
EXTERN S16 mgUtlDelTknStrOSXL ARGS((TknStrOSXL *str1)); 
EXTERN S16 mgUtlCpyTknStrOSXL ARGS((TknStrOSXL  *dstTknStrOSXL,
                                    TknStrOSXL  *srcTknStrOSXL,
                                    CmMemListCp *cpyMemCp
                                    ));
 
EXTERN  S16 mgUtlCmpTknStrOSXLCi ARGS(( TknStrOSXL    *tknStr,
                                        U8            *str,       
                                        U16           len   
                                     ));
 
EXTERN  S16 mgUtlPrntMsg   ARGS(( Buffer *mBuf,    
                                  Txt    *dbg, 
                                  U8     rxMsg, 
                                  MsgLen bytesDec 
                                )); 
 
 
EXTERN S16 mgUtlCpyGetMem     ARGS (( Ptr         *dstPtr,
                                     U16         memSize,
                                     CmMemListCp *cpyMemCp
                                   ));
 
EXTERN S16 agUtlSetCxtPropInUpdCxt ARGS(( MgMgcoUpdateCntxt *dst,
                                          MgMgcoContextProps *src,
                                          CmMemListCp        *memCp
                                        ));
 
EXTERN  S16 agUtlSetCxtAuditInUpdCxt ARGS(( MgMgcoUpdateCntxt *dst,
                                            MgMgcoContextAudit *src
                                         ));
EXTERN  S16 agUtlBldMgcoErrReq ARGS (( MgMgcoInd         **ptrAgErr,
                                       U32               agTxnId,
                                       MgMgcoContextId   *agCtxtId,
                                       U32               err   
                                    ));
 

#endif /* GCP_CH */
#ifdef GCP_MGCP
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
#endif /* GCP_MGCO */

EXTERN U16 mgAllocSrvrLst ARGS((
        MgTSAPCfg        *cfg,          /* General Configuration Structure */
        MgTSAPCb         *tsap          /* TSAP CB */
      ));


EXTERN  S16 mgCfgTSapTptEntity   ARGS(( MgTSAPCb    *tsap,      
                                        MgTSAPCfg   *cfg ));

EXTERN  S16 mgCheckIsTuclTSapCfg ARGS(( SpId  tSapId));

EXTERN  Void mgTptPrcMgcoTxnInd   ARGS((Buffer        *mBuf, 
                                       MgcoTptInfo   *mgcoTptInfo));

EXTERN  S16 mgCordPrcMgcoTxnInd  ARGS((Buffer        *mBuf,
                                       MgcoTptInfo   *mgcoTptInfo));

#ifdef GCP_MGCO
EXTERN  S16 mgTptHdlNewMtpAddr   ARGS((MgMgcoMid     *addr,
                                       MgcoTptInfo   *mgcoTptInfo,
                                       MgPeerCb      *peer));

EXTERN  S16 mgCordPrcMgcoMsg     ARGS((MgcoTptInfo   *mgcoTptInfo,
                                       MgMgcoMsg     *mgcoMsg,
                                       Bool           useAh));

EXTERN S16 mgCordHdlMgcoMsg      ARGS((MgcoTptInfo   *mgcoTptInfo,
                                       MgMgcoMsg     *mgcoMsg,
                                       S16           *errAction,
                                       S16           *rspCode,
                                       MgMgcoMsg     **errMsg));

EXTERN MgPeerCb * mgGetPeerFrmMid ARGS((MgMgcoMid          *mid,
                                        MgcoTptInfo        *mgcoTptInfo,
                                        MgcoTptInfo        *newTptInfo,
                                        MgSSAPCb           *sSap));

EXTERN S16 mgInitToCreateNewPeer ARGS((MgPeerInitInfo     *init,
                                       MgMgcoMid          *mid,
                                       MgcoTptInfo        *mgcoTptInfo,
                                       MgcoTptInfo        *newTptInfo,
                                       MgSSAPCb           *sSap)); 

EXTERN  S16 mgCordMgcoFindPeer  ARGS (( MgcoTptInfo        *mgcoTptInfo,    
                                        MgMgcoMsg          *mgcoMsg, 
                                        S16                *rspCode ));
#endif /* GCP_MGCO */

EXTERN S16 mgTptSetupConn        ARGS((MgcoTptInfo   *mgcoTptInfo,
                                       MgSSAPCb      *ssap));

EXTERN S16 mgTptGetCommEnt       ARGS((MgcoTptInfo   *mgcoTptInfo,
                                       MgSSAPCb      *sSap,
                                       MgTSAPCb      *tSap));

EXTERN Void mgTptSndMsgOnCommEnt ARGS((MgcoTptInfo   *mgcoTptInfo,
                                       Buffer        *mBuf));

EXTERN S16 mgTptRlsConn          ARGS((MgcoTptInfo   *mgcoTptInfo));



#ifdef CM_DNS_LIB
EXTERN S16 mgSetUpDns ARGS((
        MgTSAPCb           *tsap,      /* TSAP Control Block */
        Bool               byCfg       /* Thru configuration/Cntrl? */
      ));
#endif

#ifdef GCP_MGCO

EXTERN S16 mgGetMgcoSrvrType  ARGS ((
        MgSrvrInitInfo  *srvrInitInfo, /* Server Initialisation Info */
        MgSrvrCfg       *srvrCfg       /* Server Configuration Structure */
      ));

#endif

EXTERN  MgTptSrvr * mgFindTptSrvr ARGS(( CmTptAddr          *srvrAddr));


EXTERN S16 mgTptIsCommPossible  ARGS (( MgSSAPCb       *ssap,
                                        MgPeerCb       *peer,
                                        MgcoTptInfo    *mgcoTptInfo,
                                        Bool           *isConnReqd));


EXTERN S16 mgTptSetupConnUserReq ARGS ((MgcoTptInfo    *mgcoTptInfo,
                                        MgPeerCb       *peer));

EXTERN S16 mgTptFillTptInfoFrmPeer ARGS ((MgPeerCb       *peer,
                                          MgcoTptInfo    *mgcoTptInfo));

EXTERN S16 mgTptIsTxnPossible  ARGS ((MgcoTptInfo    *mgcoTptInfo,
                                      Bool           *transmitTxn));

EXTERN S16 mgIsRtxPossible     ARGS ((MgPeerCb       *peer,
                                      MgSSAPCb       *ssap,
                                      MgTSAPCb       *tsap,
                                      MgTptSrvr      **tptSrvrCb,
                                      MgTxTransIdEnt *txCb));

#ifdef GCP_MGCO
EXTERN S16 mgPeerMgwPrcSrvcChngReq ARGS((MgcoTptInfo     *mgcoTptInfo,
                                         MgSrvcChngParam *mgSrvcChngParam));

EXTERN S16 mgUtilGenEventFrmMtdRes ARGS((U8 method, U8 *scReason));

EXTERN S16 mgUtilGenEventFrmRplyMsgInfo ARGS((U8 msgInfo, 
                                              MgSvcChgInfo   *svcChg));

EXTERN S16 mgUtilGenEventFrmUserRegRsp ARGS((U8 method, U16 reasonBit));

EXTERN S16 mgPeerMgcPrcSrvcChngReq ARGS((MgcoTptInfo     *mgcoTptInfo,
                                         MgSrvcChngParam *mgSrvcChngParam));

EXTERN S16 mgPeerMgcPrcSrvcChngReply ARGS((MgcoTptInfo     *mgcoTptInfo,
                                          MgSrvcChngParam *mgSrvcChngParam));

EXTERN S16 mgPeerMgwPrcSrvcChngReply ARGS((MgcoTptInfo     *mgcoTptInfo,
                                          MgSrvcChngParam *mgSrvcChngParam));

typedef S16 (*MgPeerSm) ARGS((MgPeerCb         *peer,
                             MgcoTptInfo      *mgcoTptInfo,
                             MgSrvcChngParam  *mgSrvcChngParam));

EXTERN S16 mgPrcProfSrvcChngReply ARGS((
        MgcoTptInfo        *mgcoTptInfo,
        MgMgcoSvcChgProf   *svcProf,
        S16                *errAction,         /* txCb->msgInfo ?*/
        U8                 msgInfo,            /* txCb->msgInfo ?*/
        MgTransId          transId,            /* transaction id */
        Bool               *updTxCb,            /* whether update txCb */
        MgTxTransIdEnt     **txCb,              /* transaction control block */
        MgMgcoTxn          *mgcoTxn
      ));

#ifdef GCP_MG
EXTERN Void mgAddIpAddr ARGS((
        MgPeerCb        *peer,         /* Peer Control Block */
        CmNetAddr       *addr          /* network address */
      ));

#endif /* GCP_MG */

#ifdef DEBUGP
EXTERN Void mgPrntPeerInfo      ARGS((MgPeerCb  *peerCb, U32   dbgMask));
EXTERN Void mgPrntTptSrvrInfo   ARGS((MgTptSrvr *tptSrvr, U32   dbgMask));
EXTERN Void mgPrntTransInfo     ARGS((Void      *transCb,
                                      U8        transType,
                                      U32       dbgMask));
EXTERN Void mgPrntTxTransInfo   ARGS((MgTxTransIdEnt      *transCb,
                                      U32                 dbgMask));
EXTERN Void mgPrntRxTransInfo   ARGS((MgRxTransIdEnt      *transCb,
                                      U32                 dbgMask));
EXTERN Void mgPrntPeerFsmInfo   ARGS((MgPeerCb         *peer,
                                      MgcoTptInfo      *tptInfo,
                                      MgSrvcChngParam  *svcChngParm,
                                      U32              dbgMask));
#endif /* DEBUGP */


EXTERN Void mgTransmitPdu  ARGS((MgPeerCb         *peer,
                                 Buffer           *mBuf,
                                 MgTransmitInfo   *trasnmitInfo));


#ifdef GCP_VER_2_1
EXTERN Void mgPrcSegRspTmrExpiry  ARGS(( MgTxTransIdEnt     *txCb));

EXTERN S16 mgMgcoSendSegErrRsp   ARGS(( MgTxTransIdEnt     *txCb));

EXTERN Void mgPrcIncomingSegReplyAck  ARGS(( MgPeerCb      *peer,
                                             MgMgcoTxn     *mgcoTxn,
                                             MgTransId     transId));

EXTERN Void mgPrcSegAckTmrExpiry  ARGS(( MgRxTransIdEnt     *rxCb ));

EXTERN Void mgRetransmitSegRsp  ARGS(( MgPeerCb           *peer,
                                       MgRxTransIdEnt     *rxCb,
                                       Buffer             *mBuf));

EXTERN S16 mgMgcoGetTransIdFrmErrMsg ARGS(( MgMgcoMsg        *mgcoMsg,
                                            MgTransId        *trasnId));

EXTERN S16 mgUtilChkIfRootTerm ARGS(( MgMgcoTermIdLst   *termIdLst));


#endif /* GCP_VER_2_1 */

#ifdef GCP_MG
#ifdef GCP_VER_2_1
EXTERN MgPeerSm mgMgwPeerStateMtx[][19];
#else
EXTERN MgPeerSm mgMgwPeerStateMtx[][19];
#endif /*GCP_VER_2_1*/
#endif /* GCP_MG */


#ifdef GCP_MGC
#ifdef GCP_VER_2_1
EXTERN MgPeerSm mgMgcPeerStateMtx[][21];
#else
EXTERN MgPeerSm mgMgcPeerStateMtx[][21];
#endif /* GCP_VER_2_1 */
#endif /* GCP_MGC */

#endif /* GCP_MGCO */

PUBLIC Void mgPrcRstEndTmrExpiry ARGS(( MgPeerCb      *peer));

EXTERN S16 mgAllocEventMem ARGS((
       Ptr       *memPtr,
       Size      memSize
    ));

EXTERN S16 mgFreeEventMem ARGS((
       Ptr       memPtr
    ));

/* use this macro for .numComp fields in SIP sequences */
#define MG_GET_NUM_COMP(a) \
   ((U16)(((a)->pres != NOTPRSNT) ? (a)->val : 0))

/* Allocate function */
#define MGALLOC(_buf, _size)\
{\
 if (SGetSBuf(mgCb.init.region, mgCb.init.pool, (Data **) _buf,    \
                (Size) _size) == ROK)                                \
   {                                                                 \
      cmMemset((U8 *)(*_buf), 0, _size);                             \
   }                                                                 \
   else                                                              \
   {                                                                 \
      (*_buf) = NULLP;                                               \
   }                                                                 \
}
 
#define MGFREE(_buf, _size)\
{\
   (Void) SPutSBuf(mgCb.init.region, mgCb.init.pool, (Data *) _buf, \
   (Size) _size);\
   (_buf) = NULLP;\
}
 
#define MG_FILL_NUM_COMP(a,val1) {\
   if (val1 == 0)\
   {\
      (a)->pres = NOTPRSNT;\
      (a)->val  = (U16)(0);\
   }\
   else\
   {\
      (a)->pres = PRSNT_NODEF;\
      (a)->val  = (U16)(val1);\
   }\
}
 

#endif /* ifndef __MGX__ */


/********************************************************************30**
 
        End of file:     mg.x@@/main/7 - Wed Nov 14 22:43:41 2007
*********************************************************************31*/
/********************************************************************40**
 
        Notes:
 
*********************************************************************41*/
/********************************************************************50**
 
*********************************************************************51*/
 
/********************************************************************60**
 
        Revision history:
 
*********************************************************************61*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
/main/6      ---      pk   1. GCP 1.5 release 
1.1          ---      bbk  1. Initial release.
1.2          ---      bbk  1. Initial Release for 1.2
1.2+        mg001.101 bbk  1. Added MgDnsTxFuncParam for using it to fix
                              DNS Resolve Request Retransmission.
            mg002.101  pk  2. Changed function prototype for function
                              mgRcvDnsResponse.
            mg002.101 bbk  1. Added mtuSize to MgPeerCb and MgPeerInitInfo
            mg003.101 bbk  1. Added prvsnlRsp to MgRxTransIdEnt
                           2. Changed arguments to mgPrcOutGoingAck
            mg007.101 bbk  1. Added support for peerId being U32 under
                               GCP_ENHNC_1_2 compile time flag
            mg008.101 bbk  1. Changed arguments to mgPrcOutGoingTxn to pass
                              the remote address where transaction is being
                              sent
                           2. Added remotePort and retxOnIpAddr as 
                              variables to MgTxTransIdEnt
/main/3      ---        pk 1. Added MEGACO support in structures.
                           2. Reorganized structures.
                           3. Created new control block structures for
                              MGCP and MEGACO.
                           4. Added new function prototypes.
            mg007.102  vj  1. Modified encodeLen param of mgConvertIpAddrToAscii 
                              from U8* to U16*
            mg011.102  vj  1. MID as a new variable was added in MgPeerAccess 
                              and  MgPeerInitInfo structures.
                           2. ntfyEntPeer variable was added in MgMgcpPeerInfo
                           3. dupPeerPrsnt is now MG/MGCO only flag.
                           4. regReqPort in MgPeerCb and mIdport in
                              MgPeerInitInfo are no longer required. 
                           5. Added and modified function declarations.
/main/4      ---      ra   1. GCP 1.3 release
            mg004.103 rg   1. Added variables aad and rto to MgTxTransIdEnt 
                              for exponential backoff for retransmitted 
                              transactions.
            mg011.103 ra   1. Added declarations of new functions -
                              mgMgcoFreeMedDsTkBf
                              mgMgcoFreeAllTkBfs
                              mgMgcpFreeAllTxnTkBfs
                              mgMgcpFreeAllTkBfs
            mg013.103 ra   1. Added extra arg trId to the function -
                              mgMgcoSendErrRsp 
/main/5      ---      ka   1. Changes for Release v 1.4
            mg005.104 ra   1. FTHA related changes. 
            mg008.104 ra   1. Added extern decl for new function.
                      mg      Changed the prototype of mgMgcoDecodeTxnInd
                              to  include the peer also.
/main/6      ---      pk   1. GCP 1.5 release
            mg001.105 ra   1. Added TOS in endpoint CB, peerInfo CB and
                              peerInitInfo CB.
            mg002.105 ps   1. Removed patch reference for 1.3 and 1.4             
                           2. add freeCmds paramter
            mg003.105 ps   1. Moved defintion of mgMgcoPendingLimit to lmg.x
                           2. Added Utility function from AGSF product for
                              copying differnt Descriptor and Command parameters
                              from one MemCp to another MemCp 
            mg005.105 gk   1. Added new state to support MG in lock/unlock state
            mg007.105 gk   1. Removed GCP_USE_DEF_PEERID flag
            mg008.105 gk   1. Handling for wild card context Action Indication
                              and Response Structure
                           2. Added function to grow the memory size
            mg009.105 gk   1. Whether handoff to self mgcId handOffSelfMgcId;
            mg011.105 gk   1. Changes for lock/unlock in MTP3 case
            mg013.105 gk   1. Added utility function for filling timestamp
                           2. Added new field svc chg reason in mgMgcoPeerInfo
            mg015.105 gk   1. CH-Module Redesign changes
            mg016.105 rb   1. Added LCN Feature Information.
                           2. Added to store SRC IP add in EndpCb
            mg021.105 ac   1. Added new field svc chg method in mgMgcoPeerInfo                           
/main/7      ---      pk   1. GCP 2.1 release
            mg002.201 gk   1. Extern declaration for MID verification.
            mg003.201 gk   1. Made changes at MG to send SVC Disconnected first
                              svcDCcount times when MG loose connection with MGC.
*********************************************************************91*/
