/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**
 
     Name:     GCP 
 
     Type:     C include file
  
     Desc:     Defines Required by MGCP
 
     File:     mg.h
 
     Sid:      mg.h@@/main/7 - Wed Nov 14 22:43:38 2007
  
     Prg:      bbk
  
*********************************************************************21*/
  

/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     
*
*/
 
/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     
*    
*   
*
*/


#ifndef __MGH__
#define __MGH__


#define      MG_DEVICE_REG_EPNAME        "*"
#define      MGLAYERNAME                 "MGCP"
#define      MG_DBGMASK_LI_MBUF          LMG_DBGMASK_LI_MBUF
#define      MG_NONE                     0

/* mg003.105: Changer error code value */
/* Action variables */
#define      MG_REGISTER_SENT            21         /* Transmitted RSIP */
#define      MG_REGISTER_RSP_OK          22         /* Received +ve RSIP RSP */
#define      MG_PDU_SZ_EXCEDED           23         /* PDU SIZE has exceeded */
/* - Added new value */
#define      MG_MSG_SZ_EXCEDED           24         /* MSG SIZE has exceeded */
#ifdef GCP_VER_2_1
/*3gpp req 1-4 -adding new return value */
#define      MG_MSG_TXNCNT_EXCEDED       25
#endif


#define      MG_MAX_INTRETRY             2         /* Maximum Bind Retries */
#define      MG_MIN_SSAP_LSTNR_REQD      1         /* Min Lstnrs for SSAP */

/* Max Status Request Retry for MTP3 */
#define      MG_MAX_MTP_STSREQ_RETRY     2        

#define      MG_IPV4_ADDRLEN             4         /* IPV4 Address length */
#define      MG_IPV6_ADDRLEN             CM_IPV6ADDR_SIZE  /* IPV6 Address length */
#define      MG_DNAME_FRMT2_LEN          17
#define      MG_DEFAULT_TRC_LEN          -1        /* Trace Disabled */
#define      MG_DEFAULT_MG_PORT          2427      /* Default MGCP port  MG */
#define      MG_DEFAULT_MGC_PORT         2727      /* Default MGCP port MGC */
#define      MG_DEFAULT_TTL_VALUE        86400     /* 24 hours */
#define      MG_INIT_RTT_VALUE           2         /* 2 second */
#define      MG_30SEC_TMR_VALUE          30        /* 30 seconds */
#define      MG_DNS_RQST_LST_SZ          1024      /* Outstanding DNS Req */
/* Changing localy  */
#define      MG_MGCO_DEFAULT_TEXT_PORT   2944      
#define      MG_MGCO_DEFAULT_BINARY_PORT 2945      /* Default MEGACO port for 
                                                      binary encoding scheme */
#define      MG_INVALID_PORT             0xFFFF

/* Retransmission CONSTANTS */
#define      MG_AAD_GAIN_CONSTANT        3
#define      MG_ADEV_GAIN_CONSTANT       2
#define      MG_INIT_RETX_DELAY_VARIANCE 0

/* mg011.105: Added new define for RTO calculation if RTO is 
 *            less than Timer Resolution Configured */
#define      MG_RTO_MIN_GAIN_FACT        2  /* If we increase this value 
                                               it cuase more error in 
                                               RTO calculation */

/* mg009.105: Initialization value for number of failed
   transactions for a peer */
#define      MG_INIT_NUM_FAILED_TRANS 0

/* Hash function to be used for Transaction Id management */
#define      MG_TXNID_HASH_FUNC          CM_HASH_KEYTYPE_DEF
#ifdef GCP_CH
#define      MG_CH_PEERID_HASH_FUNC        CM_HASH_KEYTYPE_DEF
#define      MG_CH_TXNID_HASH_FUNC         CM_HASH_KEYTYPE_DEF
#define      MG_CH_MAX_NO_OF_PEER_CMD_BINS       20
#define      MG_CH_MAX_NO_OF_TRANS_REQ_BINS      50
#define      MG_CH_MAX_NO_OF_TRANS_IND_RSP_BINS  50
#endif /* GCP_CH */ 
/* Hash Function for Name based Gateway Hash List Management */
#define      MG_PEERNAME_HASH_FUNC       CM_HASH_KEYTYPE_STR

/* Hash Function for IP Address based Gateway Hash List */

/*
 * #define      MG_IPV4ADDR_HASH_FUNC       CM_HASH_KEYTYPE_DEF
 * #define      MG_IPV6ADDR_HASH_FUNC       CM_HASH_KEYTYPE_STR
 */
#define      MG_IPV4ADDR_HASH_FUNC       CM_HASH_KEYTYPE_ANY
#define      MG_IPV6ADDR_HASH_FUNC       CM_HASH_KEYTYPE_ANY

/* Hash Function for Transport Server hash list */
#define      MG_TPTSRVR_HASH_FUNC         CM_HASH_KEYTYPE_DEF

/* Sequence Number for Hash Lists */
#define      MG_HASH_SEQNMB_DEF          0

/* Transaction Type */
#define      MG_TRANS_TYPE_TX            1         /* Outgoing Command */
#define      MG_TRANS_TYPE_RX            2         /* Rcvd Cmnd;its Response */

/* Transaction States */
#define      MG_OUTTXN_TXN_SENT          MGT_OUTTXN_TXN_SENT
#define      MG_OUTTXN_TXN_QUEUED        MGT_OUTTXN_TXN_QUEUED
#define      MG_OUTTXN_PROVRSP_RCVD      MGT_OUTTXN_PROVRSP_RCVD
#define      MG_OUTTXN_QUEUED_FOR_ACK    MGT_OUTTXN_QUEUED_FOR_ACK
#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
#define      MG_OUTTXN_NTFYTXN_QUEUED    8
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

#define      MG_INTXN_TXN_RCVD           MGT_INTXN_TXN_RCVD
#define      MG_INTXN_RSP_SENT           MGT_INTXN_RSP_SENT
#define      MG_INTXN_RSP_QUEUED         MGT_INTXN_RSP_QUEUED
#define      MG_INTXN_PROVRSP_SENT       MGT_INTXN_PROVRSP_SENT


#define      MG_TRANSID_LEN              4         /* TransactionId Length */
 
#ifdef GCP_CH
#define      MG_CH_PEERID_LEN            4         /* PeerId Length */
#endif /* GCP_CH */ 
 
#define      MG_IGNORE                   0xFF      /* Ignore the value */
#define      MG_IGNORE_TRANSID           0xFFFFFFFF /*Ignore Transaction Id */
/* changing the value in accordance with the mask applied to the
 * peerId and listener id */
#define      MG_INVALID_PEERID           0x003FFFFF /* Invalid Peer Id */
#define      MG_INVALID_LSTNRID          0x0007FFFF/* Invalid listener id */

#define      MG_INVALID_TRANSID          0xFFFFFFFF/* Invalid Transaction id */
#define      MG_INVALID_PRIORITY         0xFF      /* Invalid Transaction id */
#define      MG_INVALID_SSAP_ID          -1        /* Invalid SAP id */

/* Mask for PeerId */
#define      MG_PEERID_MASK              0x003FFFFF /* MSB 10 bits are rSetId */
/* ..include from dg.h*/
#define      DG_PEER_ID_MASK             MG_PEERID_MASK
/* States Defined for DNS */
#define      MG_DNS_STATE_DOWN           0         /* Inactive */
#define      MG_DNS_STATE_UP             1         /* Active */

/* SuConnId related Masks */
#define      MG_SUCONNID_VAL_MASK        0x0007FFFF
#define      MG_SUCONNID_ASN_MASK        0x00400000  /* True -> ASN else TEXT*/
#define      MG_SUCONNID_MGCO_MASK       0x00800000  /* True -> MGCO else MGCP*/
#define      MG_SUCONNID_TCP_MASK        0x003fffff

/* Message Parameter Types */
#define      MG_FORBIDDEN_PARM           0
#define      MG_MANDATORY_PARM           1
#define      MG_OPTIONAL_PARM            2
#define      MG_CONDITIONAL_PARM         3

#define      MG_MGCP_MSG_SEPARATOR_SZ     2
#define      MG_MIN_MSGLEN                0

#define      MG_MAX_ACK                   20       /* maximum response Ack in a
command */

/* Timer Related Defines */
#define      MG_TQSIZE                   1024      /* Timing Queue Size */
#define      MG_TTLTQSZ                  1024      /* TTL Timing Queue Size */

#define      MG_DEFAULT_MAXTMR           1         /* Default maximum timers */
#define      MG_MAXPEER_TMR              7         /* Max Timers per */
#define      MG_PEER_TMR_BASE            0         /* Peer Timer base */
#define      MG_INTXN_TMR_BASE           23         /* Incoming Txn  Timer base */

/* List of Timers to be used */
/* Peer Control Block Timers */
#define      MG_TTL_TMR                  0         /* TTL Timeout Timer */
#define      MG_DNSREQ_TMR               1         /* DNS Rslv Request Timer */
#define      MG_DEL_PEER_TMR             2         /* Delete Peer Timer */
#define      MG_RST_AVLNCH_TMR           3         /* Restart Avl Timer */
#define      MG_HANDOFF_TMR              4         /* Handoff timer */
/* Timer to monitor MTP3 Status Req. */
#define      MG_MTP_STSENQ_TMR           5             
/*Bring Peer to configuration state timer*/
#define      MG_CONFIG_PEER_TMR          6 

/* Incoming Transaction Related Timers */
#define      MG_30SEC_TMR                23         /* Response Ack Timer */
#define      MG_PROVRSP_TMR              24         /* Provisional Rsp Timer */
/* MGCP -> After sending final response with empty RspAck parameter , layer
 * expects Response Acknowledgement Response from peer, Otherwise layer
 * retransmits the final response */
#define      MG_RETX_RSP_TMR             25        /* final Response timer */

/* 2705 BIS -> Transaction timeout timer..after receiving command, entity will
 * start this timer.. This will be stopped after receiving response from
 * user..if user doesn't send response within this time period..error response
 * 406 will sent to peer..and txn will be deleted */
#define      MG_TXNTMOUT_TMR             26        /* final Response timer */

/* Outgoing Transaction Related Timers */
#define      MG_RETX_TMR                 10         /* RTO Timer */

/* Bind Request Timer */
#define      MG_BNDREQ_TMR               11         /* Bind Request Timer */

/* Idle Connection Timer */
#define      MG_IDLE_CONN_TMR            12        /* Idle Connection timer */


/* MGCP -> Responses to be Acked will be stored in the list..and it will be
 * removed from the list after 30 Sec. or service user sends a command. */
#define      MG_30SEC_ACK_TMR            13        /* Response timer */

/* MGCP -> 2705BIS; when GCP_USER_RETX_CNTRL flag is not defined then disc
 * timer is started whenever any command is sent to peer ( if enabled )..this
 * timer is stopped when response from peer is received ..*/
#define      MG_TXN_DISC_TMR             16


#ifdef GCP_CH
/* Timer Event for Transaction request timer */
#define      CH_CMD_REQ_TMR              18 
#endif /* GCP_CH */ 

/* 
 * MTP3 Restart End Timer is started when GCP layer receives 
 * Restart Begin StaInd from MTP3 i.e. that MTP3 has restarted 
 * and it would come up before this timer expires.If it doesnot
 * come up till timer expires then send StaReq fir
 * all point code
 */

#define      MG_MTP_RSTEND_TMR           17          

/*This is the timer for MGprovisionalResponse and MGCprovisonalresponse */
#define     MG_PROV_RSP_ROOT_TMR              19



/*  Number of Transaction Timers */
#define      MG_OUTTXN_TMR               1

#ifdef GCP_2705BIS
/* 2705BIS has transaction timeout timer also */
#define      MG_INTXN_TMR                4 
#else
#define      MG_INTXN_TMR                2 
#endif /* GCP_2705BIS */

/* multi threading defines */
#define      MG_ED_ENCTMR                14        /* encode timer */
#define      MG_ED_DECTMR                15        /* decode timer */
#define      MG_ENCODE_NONE              0         /* not encoded */
#define      MG_ENCODE_OK                1         /* encoded OK */
#define      MG_ENCODE_NOK               2         /* encoded error */

#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
/* Notify Avalanche Timers */
#define      MG_NTFY_AVL_TMR             21        /* Notify Avalanche timer */
#define      MG_NTFY_BP_TMR              22        /* Notify Breathing Period Timer */

/* Defined notify count after which start BP Timer */
#define      MG_NTFY_SYS_HDL_TH          1000
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

#if ((defined GCP_MGCO) && (defined GCP_VER_2_1))
#define      MG_SEGRSP_TMR              27
#define      MG_SEGACK_TMR              28
#endif  /* (defined GCP_MGCO) && (defined GCP_VER_2_1) */


/* defines used for msg, paramter checking table */
#define     MG_MAX_MGCP_PROFILES         3     /* 3 Profiles; 2705, NCS, TGCP */
/* Add defines for indexes for all 3 profiles */
#define     MG_RFC2705_PROF_IDX          0
#define     MG_NCS_PROF_IDX              1
#define     MG_TGCP_PROF_IDX             2

#ifdef GCP_PKG_MGCP_BASE
#define     MG_MAX_MGCP_MSGS             11    /* Number of messages in MGCP */
#else  /* GCP_PKG_MGCP_BASE */
#define     MG_MAX_MGCP_MSGS             10    /* Number of messages in MGCP */
#endif /* GCP_PKG_MGCP_BASE */


#ifdef GCP_2705BIS
#define     MG_MAX_MGCP_PARAMS           31    /* max parameters in a message */
#else
#define     MG_MAX_MGCP_PARAMS           29    /* max parameters in a message */
#endif


#define     MG_DISCARD_TXN               -1    /* Discard Transaction */
#define     MG_DISCARD_MSG               -2    /* Discard Message */
#define     MG_DELETE_PEER_PASS_TXN      -3    /* Transaction to SU followed
                                                  by delete peer */
#define     MG_VER_UNSUPP                -4    /* Discard Transaction */
/* 3gpp prof-neg */
#define     MG_CFG_STATUS_PEER_PASS_TXN  -5    /* Transaction to SU followed
                                                  by bringing peer to cfg status */
#define     MG_SND_IMD_ACK               -6    /* Send Immediate Acknowledgement */
#define     MG_DISCARD_SVC               -7    /* Just free resources related to svc */

/* defines for wildcard local name part of ep name */
#define     MG_LCL_NAME_ANY              '$'   /* MGCP ALL */
#define     MG_LCL_NAME_ALL              '*'   /* MGCP ANY */

/* defines for supporting UDP MTU Size Limitation */
#define     MG_MSG_SEPARATOR_LEN          2
#define     MG_UDP_HDR_LEN                8
#ifdef GCP_2705BIS
#define     MG_MAX_UDP_MTU_SIZE           4000
#else
#define     MG_MAX_UDP_MTU_SIZE           1500
#endif /* GCP_2705BIS */
#define     MG_MAX_TCP_MTU_SIZE           1500

/* 
 * Upon reception of a provisional response we need
 * to switch a to a timer longer than current rto...so we make it a factor
 * of rto 
 */
#define     MG_DELAY_FOR_PRVSNL_RSP       2
#define     MG_QUEUE_OUTTXNQ              1
#define     MG_QUEUE_INTXNQ               2
#define     MG_QUEUE_NONE                 3

#ifdef ZG_DFTHA
/* While sending a reverse update message, a transaction may be queued in the
 * Peer or TSAP control block. The Peer Control block has two different queues
 * for incoming and outoing transactions */
#define     MG_TSAP_TXNQ                 4
#define     MG_PEER_INTXNQ               5
#define     MG_PEER_OUTTXNQ              6

/* Define for MGCP Response Ack Message Type 
 * When delivered through PLDF, the response ack parameter is indicated using
 * this message type */
#define     MG_MGCP_MSG_RSPACK           13 /* MGT_MSG_RSP_ACK_RSP + 1 */

#endif /* ZG_DFTHA */
/* defines for suConnId to be used at HIT interface */
#ifdef ZG_DFTHA
/* IN DFTHA Case max no of conn/srvr is 0x0007ffff; since upper 13 bits are
 * reserved for DFTHA purpose */
#define     MG_HIT_MAX_CONNID            MG_SUCONNID_VAL_MASK
#else
#define     MG_HIT_MAX_CONNID            0x7FFFFFFF
#endif /* ZG_DFTHA */
#define     MG_HIT_MIN_CONNID            0

/* defines for srvrType */
#define     MG_MGCP_DEFLT_SRVR           1
#define     MG_MGCO_DEFLT_SRVR           2
#define     MG_ROUND_ROBIN_SRVR_MGCP     3
#define     MG_ROUND_ROBIN_SRVR_MGCO     4
#define     MG_TCP_CLIENT_CONNECTION     5

/* defines for svcChgType */
#define     MG_SRVC_CHG_NONE             0
#define     MG_SRVC_CHG_REQ              1
#define     MG_SRVC_CHG_REPLY            2

/* Defines for MG type */
#define     MG_ACTIVE                    1
#define     MG_STANDBY                   2

/* define for expectdRegMethod */
#define     MG_METHOD_NONE               0

/* define for return value of mgMatchMId function */
#define     MG_MATCH_FALSE               0
#define     MG_MATCH_TRUE                1
#define     MG_MATCH_IGNORE              2

/* Response Types for Internal Use */
#define     MG_RESPONSE                  1
#define     MG_RESPONSE_OK               MG_RESPONSE
#define     MG_RESPONSE_PROV             2
#define     MG_RESPONSE_ERR              3
#define     MG_RESPONSE_ACKED            4

/* defines for msgInfo used internally */
#define     MG_RESTART                   0x1
#define     MG_HANDOFF                   0x2
#define     MG_FAILOVER                  0x4
#define     MG_FORCED                    0x8
#define     MG_USER_INIT                 0x10
#define     MG_SELF_INIT                 0x20
#define     MG_LM_INIT                   0x40
/* added hash define for Service Change Disconnect */
#define     MG_DISCONNECT                0x80

/* defines for chkType in mgGetPeer */
#define     MG_CHECK_NONE                0
#define     MG_CHECK_SSAP                1
#define     MG_CHECK_REDIR_PORT          2

/* defines for peerflg */
#define     MG_ASSOC_SUCC                0x01
#define     MG_HANDOFF_RQSTD             0x02
#define     MG_REDIRECTED_BY_MGC         0x04
#define     MG_USER_INITIATED_REG        0x08
/* added hash define for Service Change Disconnect */
#define     MG_HANDOFF_RQSTD_NO_MGCID    0x10
#define     MG_DISCONNECTED_TO_MGC       0x20

/* 
 * Added a define for MGCO version number for internal use
 */
#define     MG_MGCOVER_1_0               1
#define     MG_MGCOVER_2_0               2
#define     MG_MGCOVER_3_0               3

/* Defines for source initaiting procedure */
#define     MG_USER                      1
#define     MG_INTERNAL                  2

/* Defines for service change reasons */
#define     MG_SCRSN_SRV_RESTORED        (U8 *)"\"900 Service Restored\""
#define     MG_SCRSN_COLD_BOOT           (U8 *)"\"901 Cold Boot\""
#define     MG_SCRSN_WARM_BOOT           (U8 *)"\"902 Warm Boot\""
#define     MG_SCRSN_MGC_DIR_CHNG        (U8 *)"\"903 MGC Directed Change\"" 
/* mg004.105: MG_SCRSN_MG_OOS service change is added */
#define     MG_SCRSN_MG_OOS              (U8 *)"\"905 Termination Taken Out Of Service\"" 
#define     MG_SCRSN_MG_IMPN_FAIL        (U8 *)"\"908 MG Impending Failure\"" 
#define     MG_SCRSN_MG_WARM_FAIL        (U8 *)"\"919 Warm Failover\"" 
#define     MG_SCRSN_MG_COLD_FAIL        (U8 *)"\"920 Cold Failover\"" 
#define     MG_SCRSN_MGC_IMPN_FAIL       (U8 *)"\"909 MGC Impending Failure\"" 
#define     MG_SCRSN_WARM_FAIL           (U8 *)"\"919 Warm Failover\""
#define     MG_SCRSN_COLD_FAIL           (U8 *)"\"920 Cold Failover\""

#ifdef GCP_VER_2_1
#define     MG_SCRSN_CNCL_GRCFL          (U8 *)"\"918 Cancel Graceful\""
#endif/*GCP_VER_2_1*/

/***************************Service Change Reason Bits************************/
#define     MG_SCRSN_NONE                0x0000   
#define     MG_SCRSN_CNCL_GRCFL_B        0x0001
#define     MG_SCRSN_COLD_WARM_FAIL_B    0x0002
#define     MG_SCRSN_PCKGS_CHNG_B        0x0004
#define     MG_SCRSN_CAP_CHNG_B          0x0008
/*****************************************************************************/

/***************************HASH Defines for *Multithreading******************/
#define     MG_INT_SVCRPLY         0
#define     MG_INT_SVCCHNG         1

#define     MG_INT_ERRRSP          2
#define     MG_INT_TXNPEND         3
#define     MG_INT_RSPACK          4

#define     MG_INT_RSIP            5
#define     MG_INTRSPACKRSP        6

/* MGCO User part to be passed by MTP3 */
#define     MGCO_SI                 14

/* mg013.105: Added defines for ammRequest Descriptors to
 * check atmost once descriptor present in AmmDesc */
#define MG_BIT_MEDIADESC            0x0001  /* 0000 0001 */
#define MG_BIT_MODEMDESC            0x0002  /* 0000 0010 */
#define MG_BIT_MUXDESC              0x0004  /* 0000 0100 */
#define MG_BIT_REQEVTDESC           0x0008  /* 0000 1000 */
#define MG_BIT_EVBUFDESC            0x0010  /* 0001 0000 */
#define MG_BIT_SIGNALSDESC          0x0020  /* 0010 0000 */
#define MG_BIT_DIGMAPDESC           0x0040  /* 0100 0000 */
#define MG_BIT_AUDITDESC            0x0080  /* 1000 0000 */
#ifdef GCP_VER_2_1
#define MG_BIT_STATSDESC            0x0100  /* 0000 0001 0000 0000 */
#endif /* GCP_VER_2_1 */  

/* Added defines for ammRequest Descriptors to
 * check atmost once descriptor present in Media Parameter */
#define MG_BIT_MEDIAPAR_LOCCTL      0x0001  /* 0000 0001 */
#define MG_BIT_MEDIAPAR_LOCAL       0x0002  /* 0000 0010 */
#define MG_BIT_MEDIAPAR_REMOTE      0x0004  /* 0000 0100 */
#define MG_BIT_MEDIAPAR_STRPAR      0x0008  /* 0000 1000 */
#define MG_BIT_MEDIAPAR_TERMST      0x0010  /* 0001 0000 */
#ifdef GCP_VER_2_1
#define MG_BIT_MEDIAPAR_STATSDESC   0x0020  /* 0010 0000 */
#endif /* GCP_VER_2_1 */

/* Added defines for LocalControl Descriptors to
 * check atmost once descriptor present in LocalControlDescriptor */
#define MG_BIT_LCLCTL_MODE          0x0001  /* 0000 0001 */
#define MG_BIT_MGT_LCLCTL_RESVAL    0x0002  /* 0000 0010 */
#define MG_BIT_MGT_LCLCTL_RESGRP    0x0004  /* 0000 0100 */

#ifdef GCP_ABNF_ATMOST_ONCE
/* Added defines for ammRequest Descriptors to
 * check atmost once parameter in Termination State list */
#define MG_BIT_MGT_TERMST_EVTBUFCTL    0x0001  /* 0000 0001 */
#define MG_BIT_MGT_MGT_TERMST_SVCST    0x0002  /* 0000 0010 */

/* Added defines for ammRequest Descriptors to
 * check atmost once paramter in event paramter list */
#define MG_BIT_MGT_EVTPAR_STREAMID        0x0001  /* 0000 0001 */
#define MG_BIT_MGT_EVTPAR_EMBEDWITHSIG    0x0002  /* 0000 0010 */
#define MG_BIT_MGT_EVTPAR_DIGMAP          0x0008  /* 0000 1000 */
#define MG_BIT_MGT_EVTPAR_KEEPACTIVE      0x0010  /* 0001 0000 */

#ifdef GCP_VER_2_1
#define MG_BIT_MGT_EVTPAR_NOTIFY_BEHV     0x0020  /* 0010 0000 */
#define MG_BIT_MGT_EVTPAR_RST_EVT_DESC    0x0040  /* 0100 0000 */
#endif /* GCP_VER_2_1 */

/* Added defines for ammRequest Descriptors to
 * check atmost once paramter in event paramter list */
#define MG_BIT_MGT_SIGPAR_STREAMID        0x0001  /* 0000 0001 */
#define MG_BIT_MGT_SIGPAR_TYPE            0x0002  /* 0000 0010 */
#define MG_BIT_MGT_SIGPAR_DURATION        0x0004  /* 0000 0100 */
#define MG_BIT_MGT_SIGPAR_NTFYCMPL        0x0008  /* 0000 1000 */
#define MG_BIT_MGT_SIGPAR_KEEPACTIVE      0x0010  /* 0001 0000 */

#ifdef GCP_VER_2_1
#define MG_BIT_MGT_SIGPAR_DIR             0x0020  /* 0010 0000 */
#define MG_BIT_MGT_SIGPAR_REQID           0x0040  /* 0100 0000 */
#define MG_BIT_MGT_SIGPAR_INTSIGDELAY     0x0080  /* 1000 0000 */
#endif /* GCP_VER_2_1 */

/* Added defines for ammRequest Descriptors to
 * check atmost once paramter in event paramter list */
#define MG_BIT_MGT_MODEMTYPE_V32BIS       0x0001  /* 0000 0001 */
#define MG_BIT_MGT_MODEMTYPE_V22BIS       0x0002  /* 0000 0010 */
#define MG_BIT_MGT_MODEMTYPE_V18          0x0004  /* 0000 0100 */
#define MG_BIT_MGT_MODEMTYPE_V22          0x0008  /* 0000 1000 */
#define MG_BIT_MGT_MODEMTYPE_V32          0x0010  /* 0001 0000 */
#define MG_BIT_MGT_MODEMTYPE_V34          0x0020  /* 0010 0000 */
#define MG_BIT_MGT_MODEMTYPE_V90          0x0040  /* 0100 0000 */
#define MG_BIT_MGT_MODEMTYPE_V91          0x0080  /* 1000 0000 */
#define MG_BIT_MGT_MODEMTYPE_SYNCHISDN    0x0100  /* 0001 0000 0000 */

/* Added defines for ammRequest Descriptors to
 * check atmost once paramter in event paramter list */
#define MG_BIT_MGT_ERRDESC                0x0001  /* 0000 0001 */
#define MG_BIT_MGT_MEDIADESC              0x0002  /* 0000 0010 */
#define MG_BIT_MGT_MODEMDESC              0x0004  /* 0000 0100 */
#define MG_BIT_MGT_MUXDESC                0x0008  /* 0000 1000 */
#define MG_BIT_MGT_REQEVTDESC             0x0010  /* 0001 0000 */
#define MG_BIT_MGT_MGT_EVBUFDESC          0x0020  /* 0010 0000 */
#define MG_BIT_MGT_MGT_SIGNALSDESC        0x0040  /* 0100 0000 */
#define MG_BIT_MGT_DIGMAPDESC             0x0080  /* 1000 0000 */
#define MG_BIT_MGT_OBSEVTDESC             0x0100  /* 0001 0000 0000 */
#define MG_BIT_MGT_STATSDESC              0x0200  /* 0010 0000 0000 */
#define MG_BIT_MGT_PKGSDESC               0x0400  /* 0100 0000 0000 */
#define MG_BIT_MGT_INDAUD_TERMAUDDESC     0x0400  /* 0100 0000 0000 */

#endif /* GCP_ABNF_ATMOST_ONCE */

/* mg016.105: Added to support LCN Feature */
#ifdef GCP_LCN_APP_USE

#define MG_LCN_TYPE_NONE MGT_LCN_TYPE_NONE
#define MG_LCN_TYPE_SCTP MGT_LCN_TYPE_SCTP
#define MG_LCN_TYPE_MTP3 MGT_LCN_TYPE_MTP3

#endif /* GCP_LCN_PP_USE */
/* mg016.105: Moved from mgasnwrap.h for proper compilation */
/***************************HASH Defines for Multithreading******************/
#define MG_WRAP_ABNF_ENCREQ   1
#define MG_WRAP_ABNF_DECREQ   2
#ifdef GCP_ASN
#define MG_WRAP_ASN_ENCREQ   3 
#define MG_WRAP_ASN_DECREQ   4
#endif /* GCP_ASN */

/******************************************************************************/
/*                          HASH DEFINED FUNCTIONS                            */
/******************************************************************************/

/* Function to send DNS Resolution Request for Resolving a Peer */
#define      mgSendDnsRslvPeer               mgPrcTTLTmrExpiry 

/******************************************************************************/
/*                                MACROS                                      */
/******************************************************************************/

#ifndef LEAK_TEST

#define mgGetMsg        SGetMsg
#define mgPutMsg        SPutMsg

#else

#ifndef L4
#define mgGetMsg        SGetMsg
#define mgPutMsg        SPutMsg
#endif /* L4 */

#endif /* LEAK_TEST */

#define MG_DBGMASK_PARM   LMG_DBGMASK_PARM 
#define MG_DBGMASK_DBG    LMG_DBGMASK_DBG 
#define MG_DBGMASK_INFO   LMG_DBGMASK_INFO 
#define MG_DBGMASK_ERROR  LMG_DBGMASK_ERROR 
#define MG_DBGMASK_FATAL  LMG_DBGMASK_FATAL 

#define MG_SUB_LEVEL_MASK 0x00001f00

#define MG_DBGMASK_LI             LMG_DBGMASK_LI 
#define MG_DBGMASK_UI             LMG_DBGMASK_UI 
#define MG_DBGMASK_PEER_FSM       LMG_DBGMASK_PEER_FSM 
#define MG_DBGMASK_TRANS          LMG_DBGMASK_TRANS 
#define MG_DBGMASK_MGMT           LMG_DBGMASK_MGMT 
#define MG_DBGMASK_TPT            LMG_DBGMASK_TPT 
#define MG_DBGMASK_CORD           LMG_DBGMASK_CORD 
#define MG_DBGMASK_PEER           LMG_DBGMASK_PEER 
#define MG_DBGMASK_CMD_HDLR       LMG_DBGMASK_CMD_HDLR 
#define MG_DBGMASK_TRANS_HDLR     LMG_DBGMASK_TRANS_HDLR 
#define MG_DBGMASK_UTIL           LMG_DBGMASK_UTIL 
#define MG_DBGMASK_MBUF_PRNT      LMG_DBGMASK_MBUF_PRNT
#define MG_DBGMASK_MEM_INFO       LMG_DBGMASK_MEM_INFO
#define MG_DBGMASK_ED             LMG_DBGMASK_ED


#define MG_DEBUG_TRANS_TX         0x1
#define MG_DEBUG_TRANS_RX         0x2

#ifdef DEBUGP
#define _mgPBuf   mgCb.prntBuf

#ifdef SS_MULTIPLE_PROCS
#define MG_PRNT_GCP_PEI                                        \
do                                                             \
{                                                              \
    sprintf(_mgPBuf, "\nProc:[%d], Ent:[%d], Inst:[%d]",       \
            mgCb.init.procId, mgCb.init.ent, mgCb.init.inst);  \
    SPrint(_mgPBuf);                                           \
}while(0)
#else
#define MG_PRNT_GCP_PEI
#endif

#define MG_PRNT_BORDER                                              \
do                                                                  \
{                                                                   \
   MG_PRNT((_mgPBuf, "\n==========================\n"));            \
}while(0)

#define MG_PRNT_HLINE(_pMsg)                                        \
{                                                                   \
	S16 _len = 0;						  \
	MG_PRNT_TSTAMP;                                                  \
	_len = _len + sprintf(_mgPBuf+_len, "[GCP_LAYER: %s:%d]::", __FILE__, __LINE__);  \
	MG_PRNT_GCP_PEI;                                                 \
	_len = _len + sprintf(_mgPBuf+_len, _pMsg);                                         \
	SPrint(_mgPBuf);                                                 \
}


#define MG_PRNT(_prntbuf)      \
{                              \
   sprintf _prntbuf;           \
   SPrint(_mgPBuf);            \
}


#define MG_PRNT_TSTAMP                      \
{                                           \
   S8 _buf[60];                            \
   DateTime dt;                             \
   SGetDateTime(&dt);                       \
   sprintf(_buf, "TIMESTAMP: date: %02d/%02d/%04d time: %02d:%02d:%02d", \
     (int)dt.month,(int)dt.day,(int)dt.year + 1900, \
     (int)dt.hour,(int)dt.min,(int)dt.sec);  \
   MG_PRNT((_mgPBuf, "[%s]\n", _buf));       \
}

#define MG_DEBUG_PEER(_peer, _mask)              \
do                                               \
{                                                \
   if(mgCb.init.dbgMask & (MG_DBGMASK_PEER))     \
   {                                             \
     MG_PRNT_HLINE(("\nPeer Information:\n"));   \
     mgPrntPeerInfo(_peer, _mask);               \
   }                                             \
}while(0)

#define MG_DEBUG_TPTSRVR(_srvr, _mask)                       \
do                                                           \
{                                                            \
   if(mgCb.init.dbgMask & (MG_DBGMASK_TPTSRVR))              \
   {                                                         \
     MG_PRNT_HLINE(("\nTransport Server Information:\n"));   \
     mgPrntTptSrvrInfo(_srvr, _mask);                        \
   }                                                         \
}while(0)

#define MG_DEBUG_TRANS(_trans, _transType, _mask)            \
do                                                           \
{                                                            \
   if(mgCb.init.dbgMask & (MG_DBGMASK_TRANS))                \
   {                                                         \
     MG_PRNT_HLINE(("\nTransaction Information:\n"));        \
     mgPrntTransInfo(_trans, _transType, _mask);             \
   }                                                         \
}while(0)

#define MG_DEBUG_PEER_FSM(_mask, _peer, _tptInfo, _svcParam)  \
do                                                            \
{                                                             \
   if(mgCb.init.dbgMask & (MG_DBGMASK_PEER_FSM))              \
   {                                                          \
     MG_PRNT_BORDER;                                          \
     MG_PRNT_HLINE(("\nPeer FSM Information::"));             \
     mgPrntPeerFsmInfo(_peer, _tptInfo, _svcParam, _mask);    \
     MG_PRNT_BORDER;                                          \
   }                                                          \
}while(0)

#define MG_PRNT_MBUF(_mBufPtr)                              \
do                                                          \
{                                                           \
   if(mgCb.init.dbgMask & (MG_DBGMASK_MBUF_PRNT))           \
   {                                                        \
     MG_PRNT_HLINE(("\nMessage Buffer Contents:\n"));       \
     SPrntMsg ((Buffer *)_mBufPtr, 0, 0);                   \
   }                                                        \
}while(0)

#define MG_PRNT_MEMINFO                                       \
do                                                            \
{                                                             \
   U32  _memInfo;                                             \
   if(mgCb.init.dbgMask & (MG_DBGMASK_MEM_INFO))              \
   {                                                          \
     MG_PRNT_HLINE(("\nMemory Information:\n"));              \
     SRegInfoShow(0, &_memInfo);                              \
   }                                                          \
}while(0)

#define MG_DEBUG_PRNT(_mask, _arg)                                      \
do                                                                      \
{                                                                       \
   if(mgCb.init.dbgMask & _mask)                                        \
   {                                                                    \
      MG_PRNT_BORDER;                                                   \
      MG_PRNT_HLINE(("\nDebug Log:\n"));                                \
      MG_PRNT(_arg);                                                    \
      MG_PRNT_BORDER;                                                   \
   }                                                                    \
}while(0)

#define MG_DEBUG_CMNETADDR(_mask, _arg)                                              \
do                                                                                   \
{                                                                                    \
   if(_arg.type == CM_NETADDR_IPV4)                                              \
       MG_DEBUG_PRNT(_mask,(_mgPBuf,"Ipv4 Address is %lx\n",_arg.u.ipv4NetAddr));\
   else if(_arg.type == CM_NETADDR_IPV6)                                         \
      MG_DEBUG_PRNT(_mask,(_mgPBuf,"Ipv6 Address is %s\n",_arg.u.ipv6NetAddr));\
}while(0)
#else  /* DEBUGP */ 
#define MG_PRNT_GCP_PEI
#define MG_PRNT_HLINE(_pMsg)
#define MG_PRNT(_prntbuf)
#define MG_PRNT_TSTAMP
#define MG_DEBUG_PEER(_peer, _mask)
#define MG_DEBUG_TPTSRVR(_srvr, _mask)
#define MG_DEBUG_TRANS(_trans, _transType, _mask)
#define MG_DEBUG_PEER_FSM(_peer, _tptInfo, _svcParam, _mask)
#define MG_PRNT_MBUF(_mBufPtr)
#define MG_PRNT_MEMINFO
#define MG_DEBUG_PRNT(_mask, _arg)
#define MG_DEBUG_CMNETADDR(_mask, _arg)
#endif /* DEBUGP */


#define MG_GET_IPV4_ADDR_FRM_STRING(_value, _str)                         \
{                                                                         \
   U16     _hiWord;                                                       \
   U16     _loWord;                                                       \
                                                                          \
   _hiWord = 0;                                                           \
   _loWord = 0;                                                           \
   _hiWord = PutHiByte(_hiWord, (_str[0]));                               \
   _hiWord = PutLoByte(_hiWord, (_str[1]));                               \
   _loWord = PutHiByte(_loWord, (_str[2]));                               \
   _loWord = PutLoByte(_loWord, (_str[3]));                               \
   _value  = PutLoWord(_value, _loWord);                                  \
   _value  = PutHiWord(_value, _hiWord);                                  \
}

#define MGGETMEM(_ptr,_len, _memCp, _ret)                                 \
{                                                                         \
   _ret = cmGetMem((Ptr)(_memCp), (_len), (Ptr *)(_ptr));                 \
}




#ifdef    GCP_PROV_SCTP
#define MG_DROPDATA(_msg)                                                 \
{                                                                         \
   if ((_msg) != (Buffer *)NULLP)                                         \
   {                                                                      \
      (Void) SPutMsg((_msg));                                             \
      (_msg) = (Buffer *)NULLP;                                           \
   }                                                                      \
}
#endif    /* GCP_PROV_SCTP */



/*
 */

 /* Code Added for Different trasport flag combination . It should work with
    all the flags enabled i.e. TUCL + SCTP + MTP3 as well no flag enabled only 
    with TUCL */

/* mg016.105: Modified to support LCN Feature */ 
/* mg017.105 : Modified to support to send UDP/TCP packets in case of MTP3 
               Enabled */

#ifdef    GCP_PROV_SCTP

#if     (defined(GCP_LCN_APP_USE) && defined(GCP_PROV_MTP3))
#define MG_TRANSMIT_PDU(_peer, _assoc, _strm, _unorder, _lstnr, _remoteAddr, _mBuf) \
{                                                                         \
   if ((_assoc) && ((_peer)->accessInfo.commEnt.transportType == LMG_TPT_SCTP) && \
       ((_assoc)->assocState == LMG_ASSOC_STATE_ACTIVE))                  \
   {                                                                      \
      CmNetAddr  tmpNetAddr;                                              \
                                                                          \
      tmpNetAddr.type = CM_NETADDR_NOTPRSNT;                              \
                                                                          \
      MgLiSctDatReq(&((_peer)->tsap->spPst), (_peer)->tsap->tsapCfg.spId, \
                    (_assoc)->spAssocId, &tmpNetAddr, (_strm),            \
                    (_unorder), FALSE, 0, SCT_PROTID_H248, (_mBuf));      \
   }                                                                      \
  else if ((_peer)->accessInfo.commEnt.transportType == LMG_TPT_MTP3)             \
   {                                                                      \
      mgMtpDatReq(_peer, NULLD, NULLD, (_peer)->tsap, (LnkSel)_strm, _mBuf);             \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      if (((_remoteAddr)->type == CM_TPTADDR_NOTPRSNT) &&                 \
          (_lstnr->transportType == LMG_TPT_UDP))                         \
      {                                                                   \
         CmNetAddr *addr;                                                 \
                                                                          \
         addr = &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]);            \
         MG_FILL_TPTADDR_FRM_NETADDR(_remoteAddr, addr);                  \
         MG_FILL_TPTADDR_PORT(_remoteAddr,(_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort); \
      }                                                                   \
                                                                          \
      mgSrvDatReq(_lstnr, _remoteAddr, _mBuf);                            \
   }                                                                      \
                                                                          \
} 
#elif (defined GCP_PROV_MTP3)                                             
#define MG_TRANSMIT_PDU(_peer, _assoc, _strm, _unorder, _lstnr, _remoteAddr, _mBuf) \
{                                                                         \
   if(((_peer)->accessInfo.commEnt.transportType == LMG_TPT_SCTP) &&     \
        (_assoc) &&                                                       \
       ((_assoc)->assocState == LMG_ASSOC_STATE_ACTIVE))                  \
   {                                                                      \
      CmNetAddr  tmpNetAddr;                                              \
                                                                          \
      tmpNetAddr.type = CM_NETADDR_NOTPRSNT;                              \
                                                                          \
      MgLiSctDatReq(&((_peer)->tsap->spPst), (_peer)->tsap->tsapCfg.spId, \
                    (_assoc)->spAssocId, &tmpNetAddr, (_strm),            \
                    (_unorder), FALSE, 0, SCT_PROTID_H248, (_mBuf));      \
   }                                                                      \
   else if((_peer)->accessInfo.commEnt.transportType == LMG_TPT_MTP3)     \
   {                                                                      \
      mgMtpDatReq(_peer, NULLD, NULLD,(_peer)->tsap, _mBuf);              \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      if (((_remoteAddr)->type == CM_TPTADDR_NOTPRSNT) &&                 \
          (_lstnr->transportType == LMG_TPT_UDP))                         \
      {                                                                   \
         CmNetAddr *addr;                                                 \
                                                                          \
         addr = &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]);    \
         MG_FILL_TPTADDR_FRM_NETADDR(_remoteAddr, addr);                  \
         MG_FILL_TPTADDR_PORT(_remoteAddr,(_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort); \
      }                                                                   \
                                                                          \
      mgSrvDatReq(_lstnr, _remoteAddr, _mBuf);                            \
   }                                                                      \
}
#else
#define MG_TRANSMIT_PDU(_peer, _assoc, _strm, _unorder, _lstnr, _remoteAddr, _mBuf) \
{                                                                         \
   if ((_assoc) && ((_peer)->accessInfo.commEnt.transportType == LMG_TPT_SCTP) && \
       ((_assoc)->assocState == LMG_ASSOC_STATE_ACTIVE))                  \
   {                                                                      \
      CmNetAddr  tmpNetAddr;                                              \
                                                                          \
      tmpNetAddr.type = CM_NETADDR_NOTPRSNT;                              \
                                                                          \
      MgLiSctDatReq(&((_peer)->tsap->spPst), (_peer)->tsap->tsapCfg.spId, \
                    (_assoc)->spAssocId, &tmpNetAddr, (_strm),            \
                    (_unorder), FALSE, 0, SCT_PROTID_H248, (_mBuf));      \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      if (((_remoteAddr)->type == CM_TPTADDR_NOTPRSNT) &&                 \
          (_lstnr->transportType == LMG_TPT_UDP))                         \
      {                                                                   \
         CmNetAddr *addr;                                                 \
                                                                          \
         addr = &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]);            \
         MG_FILL_TPTADDR_FRM_NETADDR(_remoteAddr, addr);                  \
         MG_FILL_TPTADDR_PORT(_remoteAddr,(_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort); \
      }                                                                   \
                                                                          \
      mgSrvDatReq(_lstnr, _remoteAddr, _mBuf);                            \
   }                                                                      \
                                                                          \
} 
#endif /* (defined(GCP_LCN_APP_USE) && defined(GCP_PROV_MTP3) */
#else     /* GCP_PROV_SCTP */
#if   (defined(GCP_PROV_MTP3) && (defined(GCP_LCN_APP_USE) ))
#define MG_TRANSMIT_PDU(_peer, _lnkSel,  _lstnr, _remoteAddr, _mBuf)                \
{                                                                          \
                                                                           \
   if ((_peer)->accessInfo.commEnt.transportType == LMG_TPT_MTP3)                  \
   {                                                                       \
      mgMtpDatReq(_peer, NULLD, NULLD,(_peer)->tsap, _lnkSel, _mBuf);                   \
   }                                                                       \
   else                                                        \
   {                                                                       \
     if(((_remoteAddr)->type == CM_TPTADDR_NOTPRSNT) &&                    \
       (_lstnr->transportType == LMG_TPT_UDP))                            \
   {                                                                      \
      CmNetAddr *addr;                                                    \
                                                                          \
      addr = &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]);               \
      MG_FILL_TPTADDR_FRM_NETADDR(_remoteAddr, addr);                     \
      MG_FILL_TPTADDR_PORT(_remoteAddr, (_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort);  \
   }                                                                      \
                                                                          \
   mgSrvDatReq(_lstnr, _remoteAddr, _mBuf);                               \
   }                                                                       \
}

#else /*   (defined(GCP_PROV_MTP3) && (defined(GCP_LCN_APP_USE)) */
#ifdef  GCP_PROV_MTP3
#define MG_TRANSMIT_PDU(_peer, _lstnr, _remoteAddr, _mBuf)                \
{                                                                          \
   if ((_peer)->accessInfo.commEnt.transportType == LMG_TPT_MTP3)                  \
   {                                                                       \
      mgMtpDatReq(_peer, NULLD, NULLD,(_peer)->tsap, _mBuf);               \
   }                                                                    \
   else                                                                  \
   {                                                                      \
     if(((_remoteAddr)->type == CM_TPTADDR_NOTPRSNT) &&                    \
       (_lstnr->transportType == LMG_TPT_UDP))                            \
     {                                                                      \
        CmNetAddr *addr;                                                    \
        addr = &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]);               \
        MG_FILL_TPTADDR_FRM_NETADDR(_remoteAddr, addr);                     \
        MG_FILL_TPTADDR_PORT(_remoteAddr, (_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort);  \
     }                                                                      \
     mgSrvDatReq(_lstnr, _remoteAddr, _mBuf);                               \
   }                                                                       \
}
#else
#define MG_TRANSMIT_PDU(_peer, _lstnr, _remoteAddr, _mBuf)                \
{                                                                          \
     if(((_remoteAddr)->type == CM_TPTADDR_NOTPRSNT) &&                    \
       (_lstnr->transportType == LMG_TPT_UDP))                            \
     {                                                                      \
        CmNetAddr *addr;                                                    \
        addr = &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]);               \
        MG_FILL_TPTADDR_FRM_NETADDR(_remoteAddr, addr);                     \
        MG_FILL_TPTADDR_PORT(_remoteAddr, (_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort);  \
     }                                                                      \
     mgSrvDatReq(_lstnr, _remoteAddr, _mBuf);                               \
}
#endif     /* GCP_PROV_MTP3 */
#endif    /* (defined(GCP_PROV_MTP3) && (defined(GCP_LCN_APP_USE)) */
#endif    /* GCP_PROV_SCTP */

#ifdef GCP_PROV_MTP3
#ifdef GCP_LCN_APP_USE
#define MG_MGCO_GET_NXT_LNKSLSID_FROM_TSAP(_lnkSel, _tsap)                \
{                                                                         \
   if( NULLP != _tsap)                                                    \
   {                                                                      \
      if(_tsap->tsapCfg.mgMtpNwCfg.sls)                                   \
      {                                                                   \
        _lnkSel = _tsap->nextLnkSelId % _tsap->tsapCfg.mgMtpNwCfg.sls;    \
      }                                                                   \
      else                                                                \
      {                                                                   \
        /* Taking assumption default value */                             \
        _lnkSel = _tsap->nextLnkSelId % LMG_ITU_SLS_RANGE;                \
      }                                                                   \
      _tsap->nextLnkSelId++;                                              \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
}
#endif /* GCP_LCN_APP_USE */
#endif /* GCP_PROV_MTP3 */

#define MG_STOP_INTXN_TMRS(_rxCb)                                         \
{                                                                         \
   U8     _loopIdx;                                                       \
   for (_loopIdx = 0; _loopIdx < MG_INTXN_TMR; _loopIdx++)                \
   {                                                                      \
      if (_rxCb->tmr[_loopIdx].tmrEvnt != TMR_NONE)                       \
         /* mg018.105: passing timer event instead of loopIdx */          \
         mgStopTmr((S16)((_rxCb->tmr[_loopIdx].tmrEvnt)),                 \
                    (PTR) _rxCb, &(_rxCb->tmr[_loopIdx]));                \
   }                                                                      \
}


#define MG_SET_PEER_INIT_RTO(_initRtt, _peer)                             \
{                                                                         \
   U16   _delayVar;                                                       \
                                                                          \
   _delayVar = (MG_INIT_RETX_DELAY_VARIANCE * mgCb.genCfg.timeRes);       \
                                                                          \
   (_peer)->mntInfo.aad    = (_initRtt << MG_AAD_GAIN_CONSTANT);          \
   (_peer)->mntInfo.adev   = (_delayVar << MG_ADEV_GAIN_CONSTANT);        \
   (_peer)->mntInfo.rtoCap = FALSE;                                       \
                                                                          \
   MG_CALCULATE_RTO((_peer)->mntInfo.rto, (_peer)->mntInfo.aad,           \
                    (_peer)->mntInfo.adev);                               \
}


/* check if rto becomes less than timer resolution */
/* if rto becomes less than timer resolution, set minimum RTO to 
   twice the timer resolution */
/* mg011.105: Modified the rto check with timer resolution */
/* mg012.105: RTO value rounded to the upper value */
#define MG_CALCULATE_RTO(_rto, _aad, _adev)                               \
{                                                                         \
   _rto = (_aad >> MG_AAD_GAIN_CONSTANT) + _adev;                         \
   _rto = (_rto % mgCb.genCfg.timeRes) ? (_rto + mgCb.genCfg.timeRes) : _rto; \
   if(_rto < (MG_RTO_MIN_GAIN_FACT * mgCb.genCfg.timeRes ))               \
      _rto = (mgCb.genCfg.timeRes<<1);                                    \
}

/* Retranmission Timeout Parameter Calculation */
#define MG_UPDATE_RTO_PARMS(_aad, _adev, _rto, _newRtt)                   \
{                                                                         \
   S32  _err;                                                             \
                                                                          \
   _err = _newRtt - (_aad >> MG_AAD_GAIN_CONSTANT);                       \
   _aad += _err;                                                          \
                                                                          \
   if (_err < 0)                                                          \
      _err = -(_err);                                                     \
                                                                          \
   _err  -= (_adev >> MG_ADEV_GAIN_CONSTANT);                             \
   _adev += _err;                                                         \
   MG_CALCULATE_RTO(_rto, _aad, _adev);                                   \
}


/* setting RTO to the minimum of calculated value and tMax */
#define MG_UPDATE_RTO_PARMS_ON_RETX(_aad, _adev, _rto, _rtoMax)           \
{                                                                         \
   U32      _newAAD = (_aad << 1);                                        \
   Random   _randVal = 0;                                                 \
                                                                          \
   if (((SRandom(&_randVal)) == ROK) && (_aad > 0))                       \
   {                                                                      \
      if ((_randVal < _aad) || (_randVal > _newAAD))                      \
      {                                                                   \
         _randVal = (_randVal % _aad) + _aad;                             \
      }                                                                   \
                                                                          \
      MG_CALCULATE_RTO (_rto, _randVal, _adev);                           \
      if (_rto > _rtoMax)                                                 \
      {                                                                   \
         _rto = _rtoMax;                                                  \
      }                                                                   \
      _aad = _newAAD;                                                     \
   }                                                                      \
}

/* Update transmit related statistics */
#ifdef GCP_2705BIS
#define MG_UPD_MGCP_PEER_TX_STS(_msgType, _sts)                           \
{                                                                         \
   _sts.numMsgTx++;                                                       \
                                                                          \
   switch(_msgType)                                                       \
   {                                                                      \
      case MGT_MSG_NONSTD:                                                \
         _sts.numNonStdTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_EPCF:                                                  \
         _sts.numEpcfTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_CRCX:                                                  \
         _sts.numCreateTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_MDCX:                                                  \
         _sts.numModifyTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_DLCX:                                                  \
         _sts.numDeleteTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_RQNT:                                                  \
         _sts.numRqntTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_NTFY:                                                  \
         _sts.numNotifyTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUEP:                                                  \
         _sts.numAuditEndPtTx++;                                          \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUCX:                                                  \
         _sts.numAuditConnTx++;                                           \
         break;                                                           \
      case MGT_MSG_RSIP:                                                  \
         _sts.numRsipTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_RSP:                                                   \
         _sts.numRespTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_RSP_ACK_RSP:                                           \
         _sts.numRspAckRspTx++;                                           \
         break;                                                           \
   }                                                                      \
}
#else /* GCP_2705BIS */
#define MG_UPD_MGCP_PEER_TX_STS(_msgType, _sts)                           \
{                                                                         \
   _sts.numMsgTx++;                                                       \
                                                                          \
   switch(_msgType)                                                       \
   {                                                                      \
      case MGT_MSG_NONSTD:                                                \
         _sts.numNonStdTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_EPCF:                                                  \
         _sts.numEpcfTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_CRCX:                                                  \
         _sts.numCreateTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_MDCX:                                                  \
         _sts.numModifyTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_DLCX:                                                  \
         _sts.numDeleteTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_RQNT:                                                  \
         _sts.numRqntTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_NTFY:                                                  \
         _sts.numNotifyTx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUEP:                                                  \
         _sts.numAuditEndPtTx++;                                          \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUCX:                                                  \
         _sts.numAuditConnTx++;                                           \
         break;                                                           \
      case MGT_MSG_RSIP:                                                  \
         _sts.numRsipTx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_RSP:                                                   \
         _sts.numRespTx++;                                                \
         break;                                                           \
   }                                                                      \
}
#endif /* GCP_2705BIS */

#ifdef GCP_2705BIS
#define MG_UPD_MGCP_PEER_RX_STS(_msgType, _sts, _rspCode)                 \
{                                                                         \
   _sts.numMsgRx++;                                                       \
                                                                          \
   switch (_msgType)                                                      \
   {                                                                      \
      case MGT_MSG_RSP:                                                   \
      {                                                                   \
         if (_rspCode != MG_RESPONSE_ERR)                                 \
            _sts.numRespRx++;                                             \
         else                                                             \
            _sts.numRespFailedRx++;                                       \
      }                                                                   \
      break;                                                              \
                                                                          \
      case MGT_MSG_NONSTD:                                                \
         _sts.numNonStdRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_EPCF:                                                  \
         _sts.numEpcfRx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_CRCX:                                                  \
         _sts.numCreateRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_MDCX:                                                  \
         _sts.numModifyRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_DLCX:                                                  \
         _sts.numDeleteRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_RQNT:                                                  \
         _sts.numRqntRx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_NTFY:                                                  \
         _sts.numNotifyRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUEP:                                                  \
         _sts.numAuditEndPtRx++;                                          \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUCX:                                                  \
         _sts.numAuditConnRx++;                                           \
         break;                                                           \
                                                                          \
      case MGT_MSG_RSIP:                                                  \
         _sts.numRsipRx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_RSP_ACK_RSP:                                           \
         _sts.numRspAckRspRx++;                                           \
         break;                                                           \
   }                                                                      \
}
#else /* GCP_2705BIS */
#define MG_UPD_MGCP_PEER_RX_STS(_msgType, _sts, _rspCode)                 \
{                                                                         \
   _sts.numMsgRx++;                                                       \
                                                                          \
   switch (_msgType)                                                      \
   {                                                                      \
      case MGT_MSG_RSP:                                                   \
      {                                                                   \
         if (_rspCode != MG_RESPONSE_ERR)                                 \
            _sts.numRespRx++;                                             \
         else                                                             \
            _sts.numRespFailedRx++;                                       \
      }                                                                   \
      break;                                                              \
                                                                          \
      case MGT_MSG_NONSTD:                                                \
         _sts.numNonStdRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_EPCF:                                                  \
         _sts.numEpcfRx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_CRCX:                                                  \
         _sts.numCreateRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_MDCX:                                                  \
         _sts.numModifyRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_DLCX:                                                  \
         _sts.numDeleteRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_RQNT:                                                  \
         _sts.numRqntRx++;                                                \
         break;                                                           \
                                                                          \
      case MGT_MSG_NTFY:                                                  \
         _sts.numNotifyRx++;                                              \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUEP:                                                  \
         _sts.numAuditEndPtRx++;                                          \
         break;                                                           \
                                                                          \
      case MGT_MSG_AUCX:                                                  \
         _sts.numAuditConnRx++;                                           \
         break;                                                           \
                                                                          \
      case MGT_MSG_RSIP:                                                  \
         _sts.numRsipRx++;                                                \
         break;                                                           \
   }                                                                      \
}
#endif /* GCP_2705BIS */


/* Update transmit related statistics */
#define MG_UPD_MGCO_PEER_TX_STS(_msgType, _sts)                           \
{                                                                         \
   _sts.numMsgTx++;                                                       \
                                                                          \
   switch(_msgType)                                                       \
   {                                                                      \
      case MGT_TXNREQ:                                                    \
        _sts.numTransTx++;                                                \
        break;                                                            \
      case MGT_TXNPEND:                                                   \
        _sts.numTransPendTx++;                                            \
        break;                                                            \
      case MGT_TXNREPLY:                                                  \
        _sts.numRespTx++;                                                 \
        break;                                                            \
      case MGT_TXNRSPACK:                                                 \
        _sts.numRespAckTx++;                                              \
        break;                                                            \
      case MGT_NONE:                                                      \
        _sts.numServiceChgTx++;                                           \
        break;                                                            \
   }                                                                      \
}





#define MG_UPD_MGCO_PEER_RX_STS(_msgType, _sts)                           \
{                                                                         \
   _sts.numMsgRx++;                                                       \
                                                                          \
   switch (_msgType)                                                      \
   {                                                                      \
      case MGT_TXNREQ:                                                    \
        _sts.numTransRx++;                                                \
        break;                                                            \
      case MGT_TXNPEND:                                                   \
        _sts.numTransPendRx++;                                            \
        break;                                                            \
      case MGT_TXNREPLY:                                                  \
        _sts.numRespRx++;                                                 \
        break;                                                            \
      case MGT_TXNRSPACK:                                                 \
        _sts.numRespAckRx++;                                              \
        break;                                                            \
      case MGT_NONE:                                                      \
        _sts.numServiceChgRx++;                                           \
        break;                                                            \
   }                                                                      \
}


/* mg007.105: added code to retrieve error statistics */
#ifdef GCP_PKG_MGCO_ROOT
#define MG_UPD_MGCO_PEER_ERROR_STS(_rspCode, _peerKnown, _peer, _mgcoMsg) \
{                                                                         \
   MgPeerCb       *_tmpPeer = NULLP;                                      \
   MgMgcoMsg      *_tmpMsg =NULLP;                                        \
                                                                          \
   if(_peerKnown == FALSE)                                                \
   {                                                                      \
      _tmpMsg = _mgcoMsg;                                                 \
      if(_tmpMsg->mid.pres == PRSNT_NODEF)                                \
      {                                                                   \
          if((cmHashListFind(&(mgCb.peerNameLst), (U8 *)(_tmpMsg->mid.val),\
                _tmpMsg->mid.len, MG_HASH_SEQNMB_DEF, (PTR *) &_tmpPeer)) \
                                                            == ROK)       \
          {                                                               \
             _tmpPeer = NULLP;                                            \
          }                                                               \
      }                                                                   \
   }                                                                      \
   else                                                                   \
   {                                                                      \
       _tmpPeer = _peer;                                                  \
   }                                                                      \
                                                                          \
   if( _tmpPeer != NULLP)                                                 \
   {                                                                      \
      switch(_rspCode)                                                    \
      {                                                                   \
         case MGT_MGCO_RSP_CODE_BAD_REQ:                                  \
           _tmpPeer->peerSts.numErrorsMgcoBadReq++;                       \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_PROT_ERROR:                               \
           _tmpPeer->peerSts.numErrorsMgcoProtErr++;                      \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_VERSION_UNSUPP:                           \
           _tmpPeer->peerSts.numErrorsMgcoVerUnSupp++;                    \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_NOT_READY:                                \
           _tmpPeer->peerSts.numErrorsMgcoNotReady++;                     \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_REQRCVD_BEFORE_REGCMPLT:                  \
           _tmpPeer->peerSts.numErrorsMgcoReqRcvdBefReg++;                \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_TXNPENDING_EXCEEDED:                      \
           _tmpPeer->peerSts.numErrorsMgcoTxnPendEx++;                    \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_RSRC_ERROR:                               \
           _tmpPeer->peerSts.numErrorsMgcoRsrcErr++;                      \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_PDU_SIZE_EXCEED:                          \
           _tmpPeer->peerSts.numErrorsMgcoPduSize++;                      \
      }                                                                   \
   }                                                                      \
}
#else /* GCP_PKG_MGCO_ROOT */
#define MG_UPD_MGCO_PEER_ERROR_STS(_rspCode, _peerKnown, _peer, _mgcoMsg) \
{                                                                         \
   MgPeerCb       *_tmpPeer = NULLP;                                      \
   MgMgcoMsg      *_tmpMsg =NULLP;                                        \
                                                                          \
   if(_peerKnown == FALSE)                                                \
   {                                                                      \
      _tmpMsg = _mgcoMsg;                                                 \
      if(_tmpMsg->mid.pres == PRSNT_NODEF)                                \
      {                                                                   \
          if((cmHashListFind(&(mgCb.peerNameLst), (U8 *)(_tmpMsg->mid.val),\
                _tmpMsg->mid.len, MG_HASH_SEQNMB_DEF, (PTR *) &_tmpPeer)) \
                                                            != ROK)       \
          {                                                               \
             _tmpPeer = NULLP;                                            \
          }                                                               \
      }                                                                   \
   }                                                                      \
   else                                                                   \
   {                                                                      \
       _tmpPeer = _peer;                                                  \
   }                                                                      \
                                                                          \
   if( _tmpPeer != NULLP)                                                 \
   {                                                                      \
      switch(_rspCode)                                                    \
      {                                                                   \
         case MGT_MGCO_RSP_CODE_BAD_REQ:                                  \
           _tmpPeer->peerSts.numErrorsMgcoBadReq++;                       \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_PROT_ERROR:                               \
           _tmpPeer->peerSts.numErrorsMgcoProtErr++;                      \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_VERSION_UNSUPP:                           \
           _tmpPeer->peerSts.numErrorsMgcoVerUnSupp++;                    \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_NOT_READY:                                \
           _tmpPeer->peerSts.numErrorsMgcoNotReady++;                     \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_REQRCVD_BEFORE_REGCMPLT:                  \
           _tmpPeer->peerSts.numErrorsMgcoReqRcvdBefReg++;                \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_RSRC_ERROR:                               \
           _tmpPeer->peerSts.numErrorsMgcoRsrcErr++;                      \
           break;                                                         \
         case MGT_MGCO_RSP_CODE_PDU_SIZE_EXCEED:                          \
           _tmpPeer->peerSts.numErrorsMgcoPduSize++;                      \
      }                                                                   \
   }                                                                      \
}
#endif /* GCP_PKG_MGCO_ROOT */


#define DO_NOTHING  do{}while(0)

#ifdef ZG

#endif /* ZG */

/* Fill Post Structure for HIT Interface */
#define MG_FILL_HIT_PST(_tskInit, _tsapCfg, _pst)                         \
{                                                                         \
   if (_tsapCfg->dstSel == MG_SEL_LC)                                     \
   {                                                                      \
      _pst->dstProcId = _tsapCfg->dstProcId;                              \
      _pst->srcProcId = _tskInit->procId;                                 \
      _pst->dstEnt    = _tsapCfg->dstEnt;                                 \
      _pst->dstInst   = _tsapCfg->dstInst;                                \
      _pst->srcEnt    = _tskInit->ent;                                    \
      _pst->srcInst   = _tskInit->inst;                                   \
      _pst->prior     = _tsapCfg->dstPrior;                               \
      _pst->route     = _tsapCfg->dstRoute;                               \
      _pst->region    = _tsapCfg->memId.region;                           \
      _pst->pool      = _tsapCfg->memId.pool;                             \
      _pst->selector  = _tsapCfg->dstSel;                                 \
   }                                                                      \
}

/* 
 * Macro to enable SSAP if all gateways configured are resolved and there
 * is atleast one listener available; ">=" sign is used against 
 * numPeersRslvd as layer manager can delete gateways at any time
 */
#define MG_CHECK_TO_ENABLE_SSAP(_ssap)                                    \
{                                                                         \
   if ((_ssap->enbIndSent != TRUE) && (_ssap->state == LMG_SAP_BND_ENB)   \
       && (_ssap->ssapCfg.reCfg.numLstnrs > MG_NONE))                     \
   {                                                                      \
      if ((_ssap->numPeerRslvd >= cmLListLen(&(_ssap->peerLst))) &&       \
          (_ssap->numActvLstnrs > MG_NONE) &&                             \
          (_ssap->nxtUseLstnr != NULLP))                                  \
      {                                                                   \
         mgSendSsapEnbStaInd(_ssap);                                      \
      }                                                                   \
   }                                                                      \
}

/* Macro to rotate ssapId for passing RSIP up to service user */
#define MG_UPDATE_NXTUSE_MGCP_SSAPID()                                    \
{                                                                         \
   MgSSAPCb        *_ssap;                                                \
   S32             _idx;                                                  \
   U16             _crntSpId = mgCb.nxtMgcpSsapId;                        \
   U16             _maxSpId  = mgCb.genCfg.maxSSaps;                      \
   Bool            _done = FALSE;                                         \
   if (_crntSpId == (_maxSpId -1))                                        \
   {                                                                      \
      _crntSpId = 0;                                                      \
   }                                                                      \
                                                                          \
   for (_idx = (_crntSpId + 1); _idx < _maxSpId; _idx++)                  \
   {                                                                      \
      _ssap = (mgCb.sSAPLst[_idx]);                                       \
                                                                          \
      if (_ssap != NULLP && _ssap->state == LMG_SAP_BND_ENB &&            \
          _ssap->ssapCfg.protocol == LMG_PROTOCOL_MGCP)                   \
      {                                                                   \
         mgCb.nxtMgcpSsapId = _ssap->ssapCfg.sSAPId;                      \
         break;                                                           \
      }                                                                   \
                                                                          \
      if ((_done == FALSE) && (_crntSpId != 0) && (_idx == (_maxSpId -1)))\
      {                                                                   \
         _done = TRUE;                                                    \
         _maxSpId = (_crntSpId + 1);                                      \
         _idx     = -1;                                                   \
      }                                                                   \
   }                                                                      \
}

/* Macro to rotate ssapId for passing service change up to service user */
#define MG_UPDATE_NXTUSE_MGCO_SSAPID()                                    \
{                                                                         \
   MgSSAPCb        *_ssap;                                                \
   S32             _idx;                                                  \
   U16             _crntSpId = mgCb.nxtMgcoSsapId;                        \
   U16             _maxSpId  = mgCb.genCfg.maxSSaps;                      \
   Bool            _done = FALSE;                                         \
   if (_crntSpId == (_maxSpId -1))                                        \
   {                                                                      \
      _crntSpId = 0;                                                      \
   }                                                                      \
                                                                          \
   for (_idx = (_crntSpId + 1); _idx < _maxSpId; _idx++)                  \
   {                                                                      \
      _ssap = (mgCb.sSAPLst[_idx]);                                       \
                                                                          \
      if (_ssap != NULLP && _ssap->state == LMG_SAP_BND_ENB &&            \
          _ssap->ssapCfg.protocol & LMG_PROTOCOL_MGCO)                   \
      {                                                                   \
         mgCb.nxtMgcoSsapId = _ssap->ssapCfg.sSAPId;                      \
         break;                                                           \
      }                                                                   \
                                                                          \
      if ((_done == FALSE) && (_crntSpId != 0) && (_idx == (_maxSpId -1)))\
      {                                                                   \
         _done = TRUE;                                                    \
         _maxSpId = (_crntSpId + 1);                                      \
         _idx     = -1;                                                   \
      }                                                                   \
   }                                                                      \
}

#define MG_UPDATE_SSAPID(ssap)                                            \
{                                                                         \
   if ((ssap->ssapCfg.protocol == LMG_PROTOCOL_MGCP) &&                   \
       (ssap->ssapCfg.sSAPId == mgCb.nxtMgcpSsapId))                      \
   {                                                                      \
      MG_UPDATE_NXTUSE_MGCP_SSAPID();                                     \
   }                                                                      \
   if ((ssap->ssapCfg.protocol == LMG_PROTOCOL_MGCO) &&                   \
       (ssap->ssapCfg.sSAPId == mgCb.nxtMgcoSsapId))                      \
   {                                                                      \
      MG_UPDATE_NXTUSE_MGCO_SSAPID();                                     \
   }                                                                      \
}


/* Macro to generate alarm for Resource Category */
#define MG_GEN_RSRC_CATEG_ALRM(_elmnt, _event, _region, _pool)            \
{                                                                         \
   MgAlarmInfo    _alarmInfo;                                             \
   Size           memSize = 0;                                            \
   cmMemset((U8 *)&_alarmInfo, 0, sizeof(MgAlarmInfo));                   \
   if (_event != LMG_EVENT_OUTOF_TPT_SRVRS  &&                            \
       _event != LMG_EVENT_PEERLST_EXHAUSTED &&                           \
       _event != LMG_EVENT_OUTOF_TCP_CONNS)                               \
   {                                                                      \
      _alarmInfo.type = LMG_ALARMINFO_MEM;                                \
      _alarmInfo.u.mem.region = _region;                                  \
      _alarmInfo.u.mem.pool   = _pool;                                    \
      memSize = sizeof(Mem);                                              \
   }                                                                      \
                                                                          \
   mgGenStaInd (_elmnt, LCM_CATEGORY_RESOURCE, _event, LCM_CAUSE_UNKNOWN, \
                LMG_ALARMINFO_MEM, (Ptr) &_alarmInfo, memSize,            \
                LMG_ALARMINFO_INVSAPID);                                  \
}

#ifdef CM_DNS_LIB

/* Macro to instruct DNS library to free request Id */
#define MG_ABORT_DNS_RSLV_REQ(_reqId)                                     \
{                                                                         \
   if ((mgCb.dnsTsap != MG_INVALID_TSAP_ID) &&                           \
       (mgCb.tSAPLst[mgCb.dnsTsap]))                                     \
   cmDnsAbortRslvReq(mgCb.tSAPLst[mgCb.dnsTsap]->dnsInfo.dnsCb, _reqId); \
}
#endif /* CM_DNS_LIB */

#define MG_MGCP_GET_DMN_FRM_MSG(_dmnStr, _msg)                            \
{                                                                         \
   if (_msg->msgType.val != MGT_MSG_RSP)                                  \
   {                                                                      \
      if (_msg->msgType.val == MGT_MSG_NONSTD)                            \
      {                                                                   \
         _dmnStr = (_msg->t.nonStdCmd.cmd.cmdLine.epName.domainName.val); \
      }                                                                   \
      else                                                                \
         _dmnStr = (_msg->t.epcfCmd.cmdLine.epName.domainName.val);       \
   }                                                                      \
   else                                                                   \
      _dmnStr = NULLP;                                                    \
}

#ifdef GCP_2705BIS
#define MG_FIND_RSIP_METHOD(_rsip, _numParam, _method)                    \
{                                                                         \
   U16              _idx;                                                 \
   MgMgcpParam      *_param;                                              \
                                                                          \
   for (_idx = 0; _idx < _numParam; _idx++)                               \
   {                                                                      \
      _param = _rsip->params.param[_idx];                                 \
                                                                          \
      if (_param == NULLP || _param->paramType.pres == NOTPRSNT)          \
         continue;                                                        \
                                                                          \
      if (_param->paramType.val == MGT_PARAM_RSTRT_METHOD &&              \
          _param->t.rstrtMethod.stdOrXten.pres != NOTPRSNT)               \
      {                                                                   \
         _method = _param->t.rstrtMethod.stdOrXten.val;                   \
      }                                                                   \
   }                                                                      \
}
#else
#define MG_FIND_RSIP_METHOD(_rsip, _numParam, _method)                    \
{                                                                         \
   U16              _idx;                                                 \
   MgMgcpParam      *_param;                                              \
                                                                          \
   for (_idx = 0; _idx < _numParam; _idx++)                               \
   {                                                                      \
      _param = _rsip->params.param[_idx];                                 \
                                                                          \
      if (_param == NULLP || _param->paramType.pres == NOTPRSNT)          \
         continue;                                                        \
                                                                          \
      if (_param->paramType.val == MGT_PARAM_RSTRT_METHOD &&              \
          _param->t.rstrtMethod.pres != NOTPRSNT)                         \
      {                                                                   \
         _method = _param->t.rstrtMethod.val;                             \
      }                                                                   \
   }                                                                      \
}
#endif /* GCP_2705BIS */


/* Macro used in MgPrcUserTxnReq for allocating a transaction structure */
#define MG_ALLOC_DISCARD_TXN_STRUCT(_txn, _discardTxn, _ret, _ssap)       \
{                                                                         \
   _ret = ROK;                                                            \
                                                                          \
   if (_discardTxn == NULLP)                                              \
   {                                                                      \
      if(ROK != mgAllocEventMem((Ptr *)&_discardTxn, sizeof(MgMgcpTxn)))  \
      {                                                                   \
         mgHandleMgcpTxnReqErr(_ssap, _txn, MGT_ERR_RSRC_UNAVAIL);        \
         RETVALUE(RFAILED);                                               \
      }                                                                   \
   }                                                                      \
}

/* Allocate Transaction Event Structure */
#define MG_ALLOC_EVNT_MEM(_memPtr, _ret, _memSize)                        \
{                                                                         \
   Mem   _sMem;                                                           \
                                                                          \
   _ret = ROK;                                                            \
                                                                          \
   _sMem.region = mgCb.init.region;                                       \
   _sMem.pool   = mgCb.init.pool;                                         \
                                                                          \
   _ret = mgAllocEventMem( (Ptr *) &(_memPtr), _memSize);                 \
}

#define MG_FILL_PEERID_PEERINFO(_peerInfo, _peer)                         \
{                                                                         \
   _peerInfo.id.pres = PRSNT_NODEF;                                       \
   _peerInfo.id.val = _peer->accessInfo.peerId;                           \
}

/* mg003.105: New macro added to fill peer alarm info */
#define MG_FILL_PEERALARM_INFO(_peerAlarmInfo, _peerCfg)                  \
{                                                                         \
   (_peerAlarmInfo).pres.pres = PRSNT_NODEF;                              \
   if (((_peerCfg)->name[0]) != '\0')                                     \
   {                                                                      \
      (_peerAlarmInfo).dname.namePres.pres = PRSNT_NODEF;                 \
      cmMemcpy((U8 *)((_peerAlarmInfo).dname.name),                       \
               (CONSTANT U8 *)((_peerCfg)->name),                         \
               CM_DNS_DNAME_LEN);                                         \
   }                                                                      \
   else if (((_peerCfg)->mid.pres) == PRSNT_NODEF)                        \
   {                                                                      \
      (_peerAlarmInfo).mid.pres = PRSNT_NODEF;                            \
      (_peerAlarmInfo).mid.len  = (_peerCfg)->mid.len;                    \
      cmMemcpy((U8 *)((_peerAlarmInfo).mid.val),                          \
               (CONSTANT U8 *)((_peerCfg)->mid.val),                      \
               MGT_MID_STR_LEN);                                          \
   }                                                                      \
}


/*
 * MG_COPY_PEERINFO_INTO_TXN macro has been broken into 2 macros, one for MGCP
 * path and one for MEGACO path. 
 */
#ifdef GCP_MGCP
#define MG_COPY_PEERINFO_INTO_MGCPTXN(_peerInfo, _peer)                   \
{                                                                         \
   _peerInfo.pres.pres   = PRSNT_NODEF;                                   \
   MG_FILL_PEERID_PEERINFO(_peerInfo, _peer);                             \
   _peerInfo.dname.namePres.pres = NOTPRSNT;                              \
   if (_peer->accessInfo.commEnt.t.ipCommEntity.namePres == TRUE)                                \
   {                                                                      \
       _peerInfo.dname.namePres.pres = PRSNT_NODEF;                       \
       cmMemcpy((U8 *)(_peerInfo.dname.name),                             \
               (CONSTANT U8 *)(_peer->accessInfo.commEnt.t.ipCommEntity.name), CM_DNS_DNAME_LEN);\
   }                                                                      \
   if (_peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.count)                               \
   {                                                                      \
       cmMemcpy((U8 *)&(_peerInfo.dname.netAddr),                         \
               (CONSTANT U8 *)&(_peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]),\
                sizeof(CmNetAddr));                                       \
   }                                                                      \
}
#endif /* GCP_MGCP */
#ifdef GCP_MGCO 
#ifdef GCP_MG
/* new macro to determine if the peer to be contacted with the
 * service change message got disconnected. If the peer is being contacted
 * after disconnection, the method to be sent in the SVC message will be
 * DISCONNECT.
 */
#define MG_OBTAIN_SVCCHG_METHOD(_method, _peer)                           \
{                                                                         \
   _method =  MGT_SVCCHGMETH_RESTART;                                     \
   if (_peer)                                                             \
   {                                                                      \
      if (_peer->accessInfo.peerflg & MG_DISCONNECTED_TO_MGC)             \
         _method =  MGT_SVCCHGMETH_DISCON;                                \
   }                                                                      \
} /* MG_OBTAIN_SVCCHG_METHOD */

/* new macro to reset the DISCONNECTED bit in all peer control
 * blocks if it is set; since successful association has been established with
 * an MGC.
 **/
#define MG_RESET_DISCON_BIT_IN_PEERLST(_ssap)                             \
{                                                                         \
   MgPeerCb *_peer;                                                       \
   CmLList  *_node;                                                       \
   MgPeerCb *_tmpPeer = NULLP;                                            \
                                                                          \
   _tmpPeer = (MgPeerCb *)CM_LLIST_FIRST_NODE(&(_ssap->peerLst), _node);  \
   while (_node != NULLP)                                                 \
   {                                                                      \
      _peer = (MgPeerCb *)(_node->node);                                  \
      if (_peer)                                                          \
      {                                                                   \
         _peer->accessInfo.peerflg &= ~(MG_DISCONNECTED_TO_MGC);          \
      }                                                                   \
      _node = _node->next;                                                \
   }                                                                      \
} /* MG_RESET_DISCON_BIT_IN_PEERLST */

#endif /* GCP_MG */

#define MG_COPY_PEERINFO_INTO_MGCOMSG(_peerInfo, _peer)                   \
{                                                                         \
   _peerInfo.pres.pres   = PRSNT_NODEF;                                   \
   MG_FILL_PEERID_PEERINFO(_peerInfo, _peer);                             \
   _peerInfo.dname.namePres.pres = NOTPRSNT;                              \
   if (_peer->accessInfo.commEnt.t.ipCommEntity.namePres == TRUE)                                \
   {                                                                      \
       _peerInfo.dname.namePres.pres = PRSNT_NODEF;                       \
       cmMemcpy((U8 *)(_peerInfo.dname.name),                             \
               (CONSTANT U8 *)(_peer->accessInfo.commEnt.t.ipCommEntity.name), CM_DNS_DNAME_LEN);\
   }                                                                      \
   if (_peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.count)                               \
   {                                                                      \
       cmMemcpy((U8 *)&(_peerInfo.dname.netAddr),                         \
               (CONSTANT U8 *)&(_peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]),\
                sizeof(CmNetAddr));                                       \
   }                                                                      \
   MG_INIT_MID(_peerInfo.mid, _peer->accessInfo.mid )                     \
}
#endif /* GCP_MGCO */


/* Macro Used to collect discarded transactions in an event structure */
#define MG_COLLECT_DISCARDED_TXN(_txn, _msg, _error, _transId)            \
{                                                                         \
   _msg->mgLclErr.errType.pres   = PRSNT_NODEF;                           \
   _msg->mgLclErr.errType.val    = _error;                                \
   _msg->mgLclErr.trId.pres = PRSNT_NODEF;                                \
   _msg->mgLclErr.trId.val = _transId;                                    \
   _msg->msgType.val = MGT_MSG_NONE;                                      \
   _txn->mgcpMsg[_txn->numMsg++] = _msg;                                  \
}

#define MG_FREE_RSRCS_ON_TXNREQ_ERROR(_mBuf,_txn, _idx, _txCb, _rxCb)     \
{                                                                         \
   _txn->numMsg--;                                                        \
   _txn->mgcpMsg[_idx] = NULLP;                                           \
                                                                          \
   if (_txCb != NULLP)                                                    \
      mgDeAllocTxTransIdEnt (_txCb->peer, _txCb, FALSE);                  \
                                                                          \
   if (((_rxCb) != NULLP) &&                                              \
       ((_mBuf) == (_rxCb)->mBuf))                                        \
      (_rxCb)->mBuf = NULLP;                                              \
                                                                          \
   if ((_rxCb != NULLP) &&                                                \
       (_rxCb->tmr[MG_30SEC_TMR - MG_INTXN_TMR_BASE].tmrEvnt == TMR_NONE))  \
      mgDeAllocRxTransIdEnt (_rxCb->peer, _rxCb, FALSE);                  \
                                                                          \
   if (_mBuf != NULLP)                                                    \
      mgPutMsg(_mBuf);                                                    \
}

/*
 * Change; Changed the above macro -
 *             added an additional check :- the 30 sec timer has been
 *             disabled before deallocating the rxCb. If the timer has been
 *             enabled, the deallocation would be done after it expires.
 *             If an outgoing response has been rejected by the stack and
 *             if the 30 sec timer has been enabled, the service user can
 *             try to resend the response if that timer has not expired.
 *
 * Moved the mgPutMsg(_mBuf) call to the end of the macro.
 *             Also, before calling mgDeAllocRxTransIdEnt() assign
 *             (_rxCb)->mBuf to NULLP if (_rxCb) has the same (_mBuf)
 *             which is being freed at the end of the macro.
 *
 */


/* Macro to collect transaction for user on receiving it from network */
#define MG_RSRV_TXN_FOR_USR(_txnForUsr, _ntwMsg)                          \
{                                                                         \
   _txnForUsr->mgcpMsg[_txnForUsr->numMsg++] = _ntwMsg;                   \
}

/* Macro to obtain message length */
#define MG_GET_MSGLEN(_mBuf, _msgLen) \
   ((SFndLenMsg(_mBuf, &_msgLen) == ROK) ? _msgLen : (_msgLen = -1))

/* Macro to Initialise Gateway Id list in MgCb */
#define MG_INIT_PEERID_LST(_maxPeer)                                      \
{                                                                         \
   U32            _idx;                                                   \
                                                                          \
   for (_idx = 0; _idx < _maxPeer; _idx++)                                \
   {                                                                      \
      mgCb.peerLst[_idx]->peer  = NULLP;                                  \
      mgCb.peerLst[_idx]->index = (_idx + 1);                             \
   }                                                                      \
   mgCb.lastFreePeerIdx = (_idx -1);                                      \
   mgCb.peerLst[mgCb.lastFreePeerIdx]->index = MG_INVALID_PEERID;         \
   mgCb.freePeerIdx = 0;                                                  \
}

/* Macro to obtain a Free Gateway Identifier , delete from head */
#define MG_OBTAIN_FREE_PEERID(_peerId)                                    \
{                                                                         \
   _peerId = mgCb.freePeerIdx;                                            \
   if (mgCb.freePeerIdx !=  MG_INVALID_PEERID)                            \
      mgCb.freePeerIdx = (mgCb.peerLst[mgCb.freePeerIdx])->index;         \
}

/* Macro to Release a gateway Identifier; always add into tail*/
#define MG_RELEASE_PEERID(_peerId)                                        \
{                                                                         \
   U32        _id;                                                        \
   _id = _peerId & MG_PEERID_MASK;                                        \
   (mgCb.peerLst[_id])->peer   = NULLP;                                   \
                                                                          \
   mgCb.peerLst[mgCb.lastFreePeerIdx]->index =  _id;                      \
   (mgCb.peerLst[_id])->index  = MG_INVALID_PEERID;                       \
   mgCb.lastFreePeerIdx = _id;                                            \
   if (mgCb.freePeerIdx == MG_INVALID_PEERID)                             \
       mgCb.freePeerIdx = _id;                                            \
}

#ifdef GCP_CH
#ifdef ZG_DFTHA
#define CH_GET_PEER_FRM_PEERID(_id,peer)              \
   peer = (mgCb.peerLst[(_id & DG_PEER_ID_MASK)]->peer); 
#else
#define CH_GET_PEER_FRM_PEERID(_id,peer)              \
   if( _id >= mgCb.genCfg.maxPeer)                    \
   {                                                  \
      peer = NULLP;                                   \
   }                                                  \
   else                                               \
   {                                                  \
     peer = (mgCb.peerLst[(_id )]->peer);             \
   }
#endif /* ZG_DFTHA */
 
#endif /* GCP_CH */ 

#ifdef ZG_DFTHA
#define MG_GET_PEER_FRM_PEERID(_id)  (mgCb.peerLst[(_id & DG_PEER_ID_MASK)]->peer)
#else
#define MG_GET_PEER_FRM_PEERID(_id)   (mgCb.peerLst[(_id )]->peer)
#endif /* ZG_DFTHA */


/* Macro to Initialise Listener Id List for Listeners */
#define MG_INIT_LSTNRID_LST(_maxLstnr, _tsap)                             \
{                                                                         \
   UConnId        _idx;                                                   \
                                                                          \
   for (_idx = 0; _idx < _maxLstnr; _idx++)                               \
      _tsap->lstnrLst[_idx]->index = (_idx + 1);                          \
                                                                          \
   _tsap->lstnrLst[_idx - 1]->index = MG_INVALID_LSTNRID;                 \
   _tsap->nxtFreeIdx = 0;                                                 \
}

/* Macro to obtain a Listener Id */
#define MG_OBTAIN_FREE_LSTNRID(_lstnrId, _tsap)                           \
{                                                                         \
   _lstnrId = (_tsap->nxtFreeIdx) & (MG_SUCONNID_VAL_MASK);               \
   if (_lstnrId != MG_INVALID_LSTNRID)                                    \
   {                                                                      \
      _tsap->nxtFreeIdx = (_tsap->lstnrLst[_lstnrId])->index;             \
      _tsap->nxtFreeIdx &= (MG_SUCONNID_VAL_MASK);                        \
   }                                                                      \
}

/* Macro to free a Listener Id */
#define MG_RELEASE_LSTNR_ID(_lstnrId, _tsap)                              \
{                                                                         \
   UConnId     _id;                                                       \
   _id =  (_lstnrId) & (MG_SUCONNID_VAL_MASK);                            \
   (_tsap->lstnrLst[_id])->index   = _tsap->nxtFreeIdx;                   \
   (_tsap->lstnrLst[_id])->lstnrCb = NULLP;                               \
   _tsap->nxtFreeIdx = _id;                                               \
}

/* some general macros used by upper/lower/mgt interface */

#ifdef    GCP_PROV_MTP3
#ifdef    GCP_PROV_SCTP

#define MG_ISSUE_BNDREQ(_tsap)                                            \
{                                                                         \
   if((_tsap)->tsapCfg.bndTmrCfg.enb == TRUE)                             \
   {                                                                      \
      mgStartTmr(MG_BNDREQ_TMR, (_tsap)->tsapCfg.bndTmrCfg.val,           \
                 (PTR)(_tsap), &((_tsap)->bndTmr));                       \
   }                                                                      \
                                                                          \
   if ((_tsap)->tsapCfg.provType == LMG_PROV_TYPE_TUCL)                   \
      MgLiHitBndReq (&((_tsap)->spPst), (_tsap)->tsapCfg.tSAPId,          \
                     (_tsap)->tsapCfg.spId);                              \
   else if ((_tsap)->tsapCfg.provType == LMG_PROV_TYPE_MTP3)              \
      MgLiSntBndReq (&((_tsap)->spPst), (_tsap)->tsapCfg.tSAPId,          \
                     (_tsap)->tsapCfg.spId, (_tsap)->sInfo);                              \
   else                                                                   \
      (Void) MgLiSctBndReq (&(_tsap)->spPst, (_tsap)->tsapCfg.tSAPId,     \
                            (_tsap)->tsapCfg.spId);                       \
}

#else     /* GCP_PROV_SCTP */

#define MG_ISSUE_BNDREQ(_tsap)                                            \
{                                                                         \
   if(_tsap->tsapCfg.bndTmrCfg.enb == TRUE)                               \
   {                                                                      \
      mgStartTmr(MG_BNDREQ_TMR, _tsap->tsapCfg.bndTmrCfg.val, (PTR)_tsap, \
                 &(_tsap->bndTmr));                                       \
   }                                                                      \
  if ((_tsap)->tsapCfg.provType == LMG_PROV_TYPE_MTP3)                    \
      MgLiSntBndReq (&((_tsap)->spPst), (_tsap)->tsapCfg.tSAPId,          \
                     (_tsap)->tsapCfg.spId, (_tsap)->sInfo);                              \
  else                                                                    \
      MgLiHitBndReq (&(_tsap->spPst), _tsap->tsapCfg.tSAPId,               \
                  _tsap->tsapCfg.spId);                                   \
}

#endif    /* GCP_PROV_SCTP */

#else    /* GCP_PROV_MTP3 */

#ifdef    GCP_PROV_SCTP

#define MG_ISSUE_BNDREQ(_tsap)                                            \
{                                                                         \
   if((_tsap)->tsapCfg.bndTmrCfg.enb == TRUE)                             \
   {                                                                      \
      mgStartTmr(MG_BNDREQ_TMR, (_tsap)->tsapCfg.bndTmrCfg.val,           \
                 (PTR)(_tsap), &((_tsap)->bndTmr));                       \
   }                                                                      \
                                                                          \
   if ((_tsap)->tsapCfg.provType == LMG_PROV_TYPE_TUCL)                   \
      MgLiHitBndReq (&((_tsap)->spPst), (_tsap)->tsapCfg.tSAPId,          \
                     (_tsap)->tsapCfg.spId);                              \
   else                                                                   \
      (Void) MgLiSctBndReq (&(_tsap)->spPst, (_tsap)->tsapCfg.tSAPId,     \
                            (_tsap)->tsapCfg.spId);                       \
}

#else     /* GCP_PROV_SCTP */

#define MG_ISSUE_BNDREQ(_tsap)                                            \
{                                                                         \
   if(_tsap->tsapCfg.bndTmrCfg.enb == TRUE)                               \
   {                                                                      \
      mgStartTmr(MG_BNDREQ_TMR, _tsap->tsapCfg.bndTmrCfg.val, (PTR)_tsap, \
                 &(_tsap->bndTmr));                                       \
   }                                                                      \
                                                                          \
   MgLiHitBndReq (&(_tsap->spPst), _tsap->tsapCfg.tSAPId,                 \
                  _tsap->tsapCfg.spId);                                   \
}

#endif    /* GCP_PROV_SCTP */
#endif   /* GCP_PROV_MTP3 */



/* Enhanced event free macros to free TknBuf if any.
 * If CM_SDP_OPAQUE flag is defined then free the TknBuf associated
 * with the SDP string whereever they occur.
 */

#ifdef CM_SDP_OPAQUE

#define MG_FREE_EVNT_MEM(_txn, _freeTxn)                                  \
{                                                                         \
   U16  _place, _freedMsg;                                                \
                                                                          \
   if ((_txn))                                                            \
   {                                                                      \
      _place    = 0;                                                      \
      _freedMsg = 0;                                                      \
                                                                          \
      mgMgcpFreeAllTxnTkBfs((_txn));                                      \
                                                                          \
      while ((_freedMsg < (_txn)->numMsg) && (_place < MGT_MAX_MSG))      \
      {                                                                   \
         if ((_txn)->mgcpMsg[_place])                                     \
         {                                                                \
            mgFreeEventMem((Ptr)(_txn)->mgcpMsg[_place]);                 \
            _freedMsg++;                                                  \
         }                                                                \
         _place++;                                                        \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
         mgFreeEventMem((Ptr)_txn);                                       \
   }                                                                      \
}

#else

#define MG_FREE_EVNT_MEM(_txn, _freeTxn)                                  \
{                                                                         \
   U16  _place, _freedMsg;                                                \
                                                                          \
   if ((_txn))                                                            \
   {                                                                      \
      _place    = 0;                                                      \
      _freedMsg = 0;                                                      \
                                                                          \
      while ((_freedMsg < (_txn)->numMsg) && (_place < MGT_MAX_MSG))      \
      {                                                                   \
         if ((_txn)->mgcpMsg[_place])                                     \
         {                                                                \
            mgFreeEventMem((Ptr)(_txn)->mgcpMsg[_place]);                 \
            _freedMsg++;                                                  \
         }                                                                \
         _place++;                                                        \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
         mgFreeEventMem((Ptr)_txn);                                       \
   }                                                                      \
}

#endif /* CM_SDP_OPAQUE */

/* returns the offset of 'member' in the structure 'type' */
#define MG_OFFSET_OF(type, member)     (PTR)(&(((type *) 0)->member))

#define MG_GET_MEM_ID(m)                                                  \
{                                                                         \
   m.region = mgCb.init.region;                                           \
   m.pool   = mgCb.init.pool;                                             \
}





/*
 *   Following macro has been enhanced to check -
 *
 *   1) if the suId for the TSAP falls in the valid range
 *       allowed for it
 *   2) if the TSAP corresponding to that suId is valid
 *   3) if the TSAP corresponding to that suId is in the
 *      BND_ENB state
 *
 *
 */

#define MG_CHK_SUID(suId, mBuf, errCode, primName, lmgEvnt)               \
{                                                                         \
   if ((suId < (SuId) 0)                     ||                           \
       (suId >= (SuId) mgCb.genCfg.maxTSaps) ||                           \
       (mgCb.tSAPLst[suId] == NULLP))                                     \
   {                                                                      \
      MGLOGERROR(ERRCLS_INT_PAR, errCode, (ErrVal) suId,                  \
                 #primName ": Invalid suId");                             \
                                                                          \
      if (mBuf)                                                           \
         mgPutMsg (mBuf);                                                 \
                                                                          \
      parId.parType = LMG_PAR_SPID;                                       \
      parId.u.sapId = suId;                                                 \
      mgGenStaInd (STTSAP, LCM_CATEGORY_INTERFACE, lmgEvnt,               \
                   LCM_CAUSE_INV_SUID, LMG_ALARMINFO_PAR,                 \
                  (Ptr) &parId, sizeof (MgParId), LMG_ALARMINFO_INVSAPID);\
                                                                          \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
                                                                          \
                                                                          \
   if (mgCb.tSAPLst[suId]->state != LMG_SAP_BND_ENB)                      \
   {                                                                      \
      MGLOGERROR(ERRCLS_INT_PAR, errCode,                                 \
                 (ErrVal) mgCb.tSAPLst[suId]->state,                      \
                 #primName ": Invalid TSAP State");                       \
                                                                          \
      if (mBuf)                                                           \
         mgPutMsg (mBuf);                                                 \
                                                                          \
      parId.parType = LMG_PAR_SPID;                                       \
      parId.u.sapId = suId;                                                 \
      mgGenStaInd (STTSAP, LCM_CATEGORY_INTERFACE, lmgEvnt,               \
                   LCM_CAUSE_INV_STATE, LMG_ALARMINFO_PAR,                \
                  (Ptr) &parId, sizeof (MgParId), LMG_ALARMINFO_INVSAPID);\
                                                                          \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
}




/* mg008.105: Added sanity check */
#define MG_CHK_TSAP_ST(tsapCb, mBuf)                                      \
{                                                                         \
   if ((tsapCb) && ((tsapCb)->state != LMG_SAP_BND_ENB))                  \
   {                                                                      \
      if (mBuf != NULLP)                                                  \
         mgPutMsg (mBuf);                                                 \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
}

#define MG_CHKLSTNRCB(tsap,suConnId)                                      \
  (((suConnId & MG_SUCONNID_VAL_MASK) < mgCb.genCfg.maxServers) ?         \
  (tsap->lstnrLst[(suConnId & MG_SUCONNID_VAL_MASK)])->lstnrCb : NULLP)


#define MG_INIT_ADDR_ANY(tptAddr)                                         \
         tptAddr.type                  = CM_TPTADDR_IPV4;                 \
         tptAddr.u.ipv4TptAddr.port    = CM_INPORT_ANY;                   \
         tptAddr.u.ipv4TptAddr.address = CM_INET_INADDR_ANY;


/*
 * Made the following enhancements to the macro -
 *            1) Added tsap as an argument since only those peers which
 *               are related to this particular tsap should be reset
 *               because this macro is called from within mgDisableTsap.
 *            2) Don't reset those peers which use a connectionless transport
 *               such as UDP. For connection oriented transports like TCP &
 *               SCTP the connections are lost because the TUCL is being
 *               brought down - peers using these should be reset.
 *            3) On the MGC side, peer->tsap might be NULLP until an RSIP is
 *               received. The peer state is already reset for these
 *               peers - no action is needed for these peers. Therefore,
 *               a check is needed for peer->tsap. On the MG side,
 *               peer->tsap is configured. Thus the common check required on
 *               the MG & the MGC side is to compare peer->tsap against tsapCb.
 */
#ifdef ZG
#define MG_RESET_SSAP_PEERS_FOR_THIS_TSAP(ssapCb,tsapCb)                  \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   MgPeerCb *peer;                                                        \
   lCp=&ssapCb->peerLst;                                                  \
   for(tmp=lCp->first;tmp;tmp=tmp->next)                                  \
   {                                                                      \
      peer = (MgPeerCb *)(tmp->node);                                     \
      if (((peer->tsap) == tsapCb) &&                                     \
          ((peer->accessInfo.commEnt.transportType) != LMG_TPT_UDP))      \
      {                                                                   \
         /* it will remove all transactions etc */                        \
         mgBringPeerToCfgStatus(peer, TRUE, TRUE);                        \
         peer->removeAllTxns = TRUE;                                      \
         zgRtUpd(ZG_CBTYPE_PEER,(Ptr)peer,CMPFTHA_UPDTYPE_SYNC,           \
                 CMPFTHA_ACTN_MOD);                                       \
      }                                                                   \
   }                                                                      \
}
#endif /* ZG */

/* mg011.105: Changes for FTHA */
#ifdef ZG
#ifdef GCP_MG
#define MG_RESET_SSAP_PEERS(ssapCb)                                       \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   MgPeerCb *peer;                                                        \
   lCp=&ssapCb->peerLst;                                                  \
   for(tmp=lCp->first;tmp;tmp=tmp->next)                                  \
   {                                                                      \
      peer = (MgPeerCb *)(tmp->node);                                     \
      if((peer) && (peer->ssap->crntMgc != peer))                         \
         mgBringPeerToCfgStatus((MgPeerCb *)(tmp->node), TRUE, TRUE);     \
      else                                                                \
         mgBringPeerToCfgStatus((MgPeerCb *)(tmp->node), TRUE, FALSE);     \
      zgRtUpd(ZG_CBTYPE_PEER,(Ptr)peer,CMPFTHA_UPDTYPE_SYNC,              \
                 CMPFTHA_ACTN_MOD);                                       \
   }                                                                      \
}
#else
#define MG_RESET_SSAP_PEERS(ssapCb)                                       \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   MgPeerCb *peer;                                                        \
   lCp=&ssapCb->peerLst;                                                  \
   for(tmp=lCp->first;tmp;tmp=tmp->next)                                  \
   {                                                                      \
      peer = (MgPeerCb *)(tmp->node);                                     \
      mgBringPeerToCfgStatus((MgPeerCb *)(tmp->node), TRUE, FALSE);     \
      zgRtUpd(ZG_CBTYPE_PEER,(Ptr)peer,CMPFTHA_UPDTYPE_SYNC,              \
                 CMPFTHA_ACTN_MOD);                                       \
   }                                                                      \
}
#endif /* GCP_MG */
#else
#ifdef GCP_MG
#define MG_RESET_SSAP_PEERS(ssapCb)                                       \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   lCp=&ssapCb->peerLst;                                                  \
   for(tmp=lCp->first;tmp;tmp=tmp->next)                                  \
   {                                                                      \
      /* it will remove all transactions etc */                           \
      if((tmp->node) &&                                                    \
       (((MgPeerCb *)(tmp->node))->ssap->crntMgc != ((MgPeerCb *)(tmp->node))))\
         mgBringPeerToCfgStatus((MgPeerCb *)(tmp->node), TRUE, TRUE);     \
      else                                                                \
         mgBringPeerToCfgStatus((MgPeerCb *)(tmp->node), TRUE, FALSE);    \
   }                                                                      \
}
#else
#define MG_RESET_SSAP_PEERS(ssapCb)                                       \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   lCp=&ssapCb->peerLst;                                                  \
   for(tmp=lCp->first;tmp;tmp=tmp->next)                                  \
   {                                                                      \
      /* it will remove all transactions etc */                           \
      mgBringPeerToCfgStatus((MgPeerCb *)(tmp->node), TRUE, FALSE);    \
   }                                                                      \
}
#endif /* GCP_MG */
#endif /* ZG */

/*
 * Added the following new macro. This deletes the peers
 *            attached to this ssap (first arg) which use the tsap
 *            pointed to by the second arg.
 */
/* Added extra argument to decide whether dealloc peerCb is require or not */ 
#define MG_REM_SSAP_PEERS_FOR_THIS_TSAP(ssapCb, tsapCb, suInd, delReqd)   \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   CmLList *tmp2;                                                          \
   lCp=&ssapCb->peerLst;                                                  \
   tmp = lCp->first;                                                      \
   while(tmp)                                                             \
   {                                                                      \
      tmp2 = tmp->next;                                                   \
      if(suInd == FALSE)                                                  \
         ((MgPeerCb *)(tmp->node))->mntInfo.usrKnows = FALSE;             \
                                                                          \
      if (((((MgPeerCb *)(tmp->node))->tsap) == tsapCb) ||                \
          (((mgCb.genCfg.entType) == LMG_ENT_GC) &&                       \
          ((((MgPeerCb *)(tmp->node))->mntInfo.byCfg) == TRUE)))          \
      {                                                                   \
         /*byCfg = ((MgPeerCb *)(tmp->node))->mntInfo.byCfg; */           \
         /* it will remove all transactions/no alarm to mgt etc */        \
         /* mg003.201: Moved usrReason as argument to mgDeletePeer. */    \
         mgDeletePeer((MgPeerCb *)(tmp->node), MG_IGNORE,MG_IGNORE,       \
                      delReqd, MGT_ERR_RMV_PEER_ID);                                           \
      }                                                                   \
      tmp = tmp2;                                                         \
      /*mg002.105: problem in traversing the list */                      \
      /* mg008.105: Removed memory leak */                                \
      /* mg009.105: fixed the bug */                                      \
     /*  tmp = tmp->next;    */                                           \
   }                                                                      \
}




#define MG_REM_SSAP_PEERS(ssapCb, suInd)                                  \
{                                                                         \
   CmLListCp *lCp;                                                        \
   CmLList *tmp;                                                          \
   lCp=&ssapCb->peerLst;                                                  \
   tmp = lCp->first;                                                      \
   while(tmp)                                                             \
   {                                                                      \
      if(suInd == FALSE)                                                  \
         ((MgPeerCb *)(tmp->node))->mntInfo.usrKnows = FALSE;             \
                                                                          \
      /* it will remove all transactions/no alarm to mgt etc */           \
      mgDeletePeer((MgPeerCb *)(tmp->node), MG_IGNORE,MG_IGNORE,          \
                    TRUE, MGT_ERR_RMV_PEER_ID);                                                \
      /*mg002.105: problem in traversing the list */                      \
      /* mg008.105: Removed memory leak */                                \
      tmp = lCp->first;                                                   \
   }                                                                      \
}



#define MG_SEND_SRVR_STAIND(transport,lclTptAddr,srvrState,cause,srvrSta) \
{                                                                         \
   cmMemset((U8 *)&srvrSta, 0, sizeof(MgTptSrvSta));                      \
   srvrSta.transportType  = transport;                                    \
   srvrSta.state          = srvrState;                                    \
   cmMemcpy((U8 *)&srvrSta.tptAddr, (U8 *)&lclTptAddr, sizeof(CmTptAddr));\
   mgGenStaInd(STSERVER, LCM_CATEGORY_INTERNAL, LMG_EVENT_SRVR_CFG_FAIL,  \
               cause, LMG_ALARMINFO_SRVR,                                 \
              (Ptr)&srvrSta, sizeof(MgTptSrvSta), LMG_ALARMINFO_INVSAPID);\
}


#ifdef    GCP_PROV_SCTP

/*
 *   new macro to generate status indication for
 *   end point cfg failure.
 */

#define MG_SEND_ENDP_STAIND(_cause,_tsapId,_parId)                  \
{                                                                         \
   (_parId).parType = LMG_PAR_SPID;                                       \
   (_parId).u.sapId = (_tsapId);                                            \
                                                                          \
   mgGenStaInd(STSCTPSAP, LCM_CATEGORY_INTERNAL, LMG_EVENT_ENDP_CFG_FAIL, \
               (_cause), LMG_ALARMINFO_PAR, (Ptr)(&(_parId)),             \
               sizeof(MgParId), (_tsapId));                               \
}


/*
 *   new macro to generate status indication for
 *   for all error legs in indication/confirmation
 *   primitives for SCTP.
 */

#define MG_GEN_SCTP_LI_ALARM(_event,_cause,_tsapId,_parId, _assocId)      \
{                                                                         \
   if((_parId).parType == LMG_PAR_ASSOC)                                  \
       (_parId).u.assocId = _assocId;                                     \
   else                                                                   \
   {                                                                      \
       (_parId).parType = LMG_PAR_SPID;                                   \
       (_parId).u.sapId = (_tsapId);                                      \
   }                                                                      \
                                                                          \
   mgGenStaInd(STTSAP, LCM_CATEGORY_INTERFACE, (_event),                  \
               (_cause), LMG_ALARMINFO_PAR, (Ptr)(&(_parId)),             \
               sizeof(MgParId), (_tsapId));                               \
}


#endif    /* GCP_PROV_SCTP */

#ifdef   GCP_PROV_MTP3

/*
 *   new macro to generate status indication for
 *   for all error legs in indication/confirmation
 *   primitives for MTP3.
 */


#define MG_GEN_MTP_LI_ALARM(_event,_cause,_tsapId,_parId)                \
{                                                                         \
   (_parId).parType = LMG_PAR_SPID;                                       \
   (_parId).u.sapId = (_tsapId);                                            \
                                                                          \
   mgGenStaInd(STTSAP, LCM_CATEGORY_INTERFACE, (_event),                  \
               (_cause), LMG_ALARMINFO_PAR, (Ptr)(&(_parId)),             \
               sizeof(MgParId), (_tsapId));                               \
}

#endif   /* GCP_PROC_MTP3 */



#define MG_REM_SRVRS(_srvrInfo, _delSrvr)                                 \
{                                                                         \
   CmLListCp *_lCp;                                                       \
   CmLList   *_tmp;                                                       \
   MgTptSrvr *tptSrvr = NULLP;                                            \
   _lCp = &_srvrInfo->srvrLstCp;                                          \
   _tmp = _lCp->first;                                                    \
   while(_tmp)                                                            \
   {                                                                      \
      tptSrvr = (MgTptSrvr *)(_tmp->node);                                \
      _tmp    = _tmp->next;                                               \
      /* this will send HitDiscReq */                                     \
      mgSrvDiscReq(tptSrvr, _delSrvr);                                    \
   }                                                                      \
}



#define MG_ENA_DNS_LSTNR(tsapCb, tptParam)                                \
{                                                                         \
   /* enable DNS listener */                                              \
   if((tsapCb)->dnsInfo.dnsLstnr != NULLP)                                \
      mgSrvOpenReq((tsapCb)->dnsInfo.dnsLstnr, tptParam,                  \
                   &(((tsapCb)->dnsInfo.dnsLstnr)->tptAddr));             \
}

/* New macro added */
#define MG_INIT_MID(_to, _from)                                           \
{                                                                         \
   _to.pres = _from.pres;                                                 \
   _to.len = _from.len;                                                   \
   cmMemcpy(_to.val, _from.val, _from.len);                               \
}

/* New macro added */
#define MG_FILL_MID_IN_MSG(_to, _from, _ret, _memCp)                      \
{                                                                         \
   _ret = cmGetMem((Ptr)(_memCp), (_from.len), (Ptr *) &(_to.val));       \
   if(ROK == _ret)                                                        \
   {                                                                      \
      _to.pres = _from.pres;                                              \
      _to.len = _from.len;                                                \
      cmMemcpy(_to.val, _from.val, _from.len);                            \
   }                                                                      \
}

/* New macro added */
#define MG_FILL_TPTADDR_FRM_MID(_addr, _mid, _name)                       \
{                                                                         \
   if(MGT_MID_DADDRPORT == _mid->type.val)                                \
   {                                                                      \
      CmNetAddr       addrs;                                              \
      cmMemset((U8 *)&addrs, 0, sizeof(CmNetAddr));                       \
      mgGetIpAddrFromDomainNameStr(_mid->u.dAddrPort.u.ipv4.len,          \
                      _mid->u.dAddrPort.u.ipv4.val, &(addrs),             \
                      LMG_PROTOCOL_MGCO);                                 \
      MG_FILL_TPTADDR_FRM_NETADDR(_addr, &addrs);                         \
      if (PRSNT_NODEF == _mid->u.dAddrPort.port.pres)                     \
      {                                                                   \
         MG_FILL_TPTADDR_PORT(_addr, _mid->u.dAddrPort.port.val);         \
      }                                                                   \
      else                                                                \
         (_addr)->u.ipv4TptAddr.port = MG_INVALID_PORT;                   \
   }                                                                      \
   else if(MGT_MID_DNAMEPORT == _mid->type.val)                           \
   {                                                                      \
      cmMemcpy((U8 *)_name, (U8 *)_mid->u.dNamePort.name.val,             \
                      _mid->u.dNamePort.name.len + 1);                    \
   }                                                                      \
   else if(MGT_MID_DEVICE == _mid->type.val)                              \
   {                                                                      \
      U8 domPres = 0;                                                     \
      if(_mid->u.dev.lcl.pres == PRSNT_NODEF)                             \
         cmMemcpy((U8 *)_name, (U8 *)_mid->u.dev.lcl.val,                 \
                      _mid->u.dev.lcl.len);                               \
      if(_mid->u.dev.dom.pres == PRSNT_NODEF)                             \
      {                                                                   \
         domPres = 1;                                                     \
         _name[_mid->u.dev.lcl.len] = '@';                                \
         cmMemcpy((U8 *)&(_name[_mid->u.dev.lcl.len + 1]),                \
                  (U8 *)_mid->u.dev.dom.val,                              \
                        _mid->u.dev.dom.len);                             \
      }                                                                   \
      _name[_mid->u.dev.lcl.len + _mid->u.dev.dom.len + domPres] = '\0';  \
   }                                                                      \
}

/*
 * The error path for mgAllocSrvrCb() is incorrect. Modified the code where
 * the check for return value of mgAllocSrvrCb() is done.
 */
#ifdef ZG
#define MG_INIT_TCP_CONN(_peer, _srvr)                                    \
{                                                                         \
   CmTptAddr _remAddr;                                                    \
   MgSrvrInitInfo  _info;                                                 \
   S16  _ret;                                                             \
                                                                          \
   _info.transportType = LMG_TPT_TCP;                                     \
   _info.srvrType      = MG_TCP_CLIENT_CONNECTION;                        \
   _info.encodingScheme = _peer->mgcoInfo.encodingScheme;                 \
                                                                          \
   _info.suConnId = MG_INVALID_LSTNRID;                                   \
   _info.peerId = _peer->accessInfo.peerId;                               \
   /* Initiate connection request to remote server */                     \
   MG_FILL_TPTADDR_FRM_NETADDR(&_remAddr,                                 \
                          &((_peer)->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0])); \
   MG_FILL_TPTADDR_PORT(&_remAddr, (_peer)->accessInfo.commEnt.t.ipCommEntity.remotePort);       \
                                                                          \
   _ret = mgAllocSrvrCb(&_info, &_remAddr, NULLP, _peer->ssap, _peer,     \
                       (Ptr *)&_srvr, (_peer)->tsap);                     \
   if(_ret == ROK)                                                        \
   {                                                                      \
      ZG_INIT_RSETID_IN_MAPCB(&(_srvr->mapCb));                           \
      zgAddMapping(ZG_CBTYPE_TPTSRVR, (Ptr)_srvr);                        \
      zgRtUpd(ZG_CBTYPE_TPTSRVR, (Ptr)_srvr, CMPFTHA_UPDTYPE_SYNC,        \
             CMPFTHA_ACTN_ADD);                                           \
      _peer->state = LMG_PEER_STATE_CONNECT;                              \
      zgRtUpd(ZG_CBTYPE_PEER, (Ptr)_peer, CMPFTHA_UPDTYPE_SYNC,           \
              CMPFTHA_ACTN_MOD);                                          \
      _peer->accessInfo.peerflg |= MG_USER_INITIATED_REG;                 \
      mgSrvConReq((_srvr), &((_peer)->tsap->tsapCfg.reCfg.tptParam),      \
                  (_peer)->tsap, &_remAddr);                              \
   }                                                                      \
   else                                                                   \
   {                                                                      \
     _srvr = NULLP;                                                       \
   }                                                                      \
}
#else
#define MG_INIT_TCP_CONN(_peer, _srvr)                                    \
{                                                                         \
   CmTptAddr _remAddr;                                                    \
   MgSrvrInitInfo  _info;                                                 \
   S16  _ret;                                                             \
                                                                          \
   _info.transportType = LMG_TPT_TCP;                                     \
   _info.srvrType      = MG_TCP_CLIENT_CONNECTION;                        \
   _info.encodingScheme = _peer->mgcoInfo.encodingScheme;                 \
                                                                          \
   /* Initiate connection request to remote server */                     \
   MG_FILL_TPTADDR_FRM_NETADDR(&_remAddr,                                 \
                               &(_peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0])); \
   MG_FILL_TPTADDR_PORT(&_remAddr, _peer->accessInfo.commEnt.t.ipCommEntity.remotePort);         \
                                                                          \
   _ret = mgAllocSrvrCb(&_info, &_remAddr, NULLP, _peer->ssap, _peer,     \
                       (Ptr *)&_srvr, (_peer)->tsap);                     \
   if(_ret == ROK)                                                        \
   {                                                                      \
      _peer->state = LMG_PEER_STATE_CONNECT;                              \
      _peer->accessInfo.peerflg |= MG_USER_INITIATED_REG;                 \
      mgSrvConReq((_srvr), &((_peer)->tsap->tsapCfg.reCfg.tptParam),      \
                  (_peer)->tsap, &_remAddr);                              \
   }                                                                      \
   else                                                                   \
   {                                                                      \
     _srvr = NULLP;                                                       \
   }                                                                      \
}
#endif /* ZG */


/*
 *   New macro added to initiate an SCTP association;
 *   since this is called only on the MG side, its guaranteed
 *   that _peer & _peer->ssap will be valid;
 *
 *   Change the peer state to CONNECT BEFORE sending the
 *   association request because in case of tight coupling,
 *   SCTP might generate SctTermInd() in response. MgLiSctTermInd()
 *   calls mgPrcPeerDiscInd() which assumes that the peer state is
 *   CONNECT;
 *
 *
 *   Check assoc state before initiating association. 4 cases arise -
 *
 *   1) A SctTermReq was sent previously for this assoc but the
 *      SctTermCfm has not been received yet. This is the case when
 *      peer->assocCb is still valid and peer->assocCb->assocState
 *      is LMG_ASSOC_STATE_DOWN. In this case, set the assocState to
 *      LMG_ASSOC_STATE_WAIT_CFM. Then later on, when SctTermCfm is
 *      received, it checks the assocState. If the state is WAIT_CFM
 *      it initiates assoc req.
 *   2) A SctTermReq was sent previously for this assoc and a
 *      SctTermCfm was also received. In this case, peer->assocCb is
 *      invalid (NULLP); this was done in SctTermCfm. Initiate the
 *      association.
 *   3) peer->assocCb is NULLP since this is the first assoc req.
 *      Initiate the association.
 *   4) The assoc state is ACTIVE. There is no need to set up association.
 *
 */

#ifdef    GCP_PROV_SCTP
#ifdef    ZG
#define MG_INIT_SCTP_ASSOC(_peer,_ret)                                    \
{                                                                         \
   if ((((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb) &&                                             \
        (((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)->assocState == LMG_ASSOC_STATE_DOWN)))        \
   {                                                                      \
      ((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)->assocState = LMG_ASSOC_STATE_WAIT_CFM;          \
      (_ret) = ROK;                                                       \
       zgRtUpd(ZG_CBTYPE_ASSOC,(Ptr)(_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb,CMPFTHA_UPDTYPE_SYNC,\
       CMPFTHA_ACTN_MOD);                                                 \
   }                                                                      \
   else if (((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb) == NULLP)                                  \
   {                                                                      \
      if (ROK == ((_ret) = mgAllocAssocCb((_peer)->ssap, (_peer),         \
                                (MgAssocCb **)(&((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)))))    \
      {                                                                   \
         (_peer)->state = LMG_PEER_STATE_CONNECT;                         \
                                                                          \
         (_ret) = mgAssocReq((_peer)->ssap, (_peer),                      \
                             ((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb));                         \
         ZG_INIT_RSETID_IN_MAPCB(&(((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)->mapCb));           \
         zgAddMapping(ZG_CBTYPE_ASSOC, (Ptr)(_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb);            \
         zgRtUpd(ZG_CBTYPE_ASSOC, (Ptr)(_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb,                  \
                 CMPFTHA_UPDTYPE_SYNC,CMPFTHA_ACTN_ADD);                  \
         zgRtUpd(ZG_CBTYPE_PEER, (Ptr)_peer, CMPFTHA_UPDTYPE_SYNC,        \
               CMPFTHA_ACTN_MOD);                                         \
      }                                                                  \
   }                                                                      \
}
#else /* ZG */
#define MG_INIT_SCTP_ASSOC(_peer,_ret)                                    \
{                                                                         \
   if ((((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb) &&                                             \
        (((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)->assocState == LMG_ASSOC_STATE_DOWN)))        \
   {                                                                      \
      ((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)->assocState = LMG_ASSOC_STATE_WAIT_CFM;          \
      (_ret) = ROK;                                                       \
   }                                                                      \
   else if (((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb) == NULLP)                                  \
   {                                                                      \
      if (ROK == ((_ret) = mgAllocAssocCb((_peer)->ssap, (_peer),         \
                                (MgAssocCb **)(&((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb)))))    \
      {                                                                   \
         (_peer)->state = LMG_PEER_STATE_CONNECT;                         \
                                                                          \
         (_ret) = mgAssocReq((_peer)->ssap, (_peer),                      \
                             ((_peer)->accessInfo.commEnt.t.ipCommEntity.t.sctpCommEntity.assocCb));                         \
      }                                                                   \
   }                                                                      \
}

#endif    /* ZG */
#endif    /* GCP_PROV_SCTP */



#define MG_INIT_ERR_TXN(mgTxn)                                            \
{                                                                         \
   U16 _j;                                                                \
   for(_j=0;_j< mgTxn->numMsg;_j++)                                       \
   {                                                                      \
      mgTxn->mgcpMsg[_j]->mgLclErr.errType.pres = PRSNT_NODEF;            \
      mgTxn->mgcpMsg[_j]->mgLclErr.errType.val = MGT_ERR_INVALID_MSG;     \
                                                                          \
      if(mgTxn->mgcpMsg[_j]->msgType.val == MGT_MSG_RSP)                  \
      {                                                                   \
         mgTxn->mgcpMsg[_j]->mgLclErr.trId.pres = PRSNT_NODEF;            \
         mgTxn->mgcpMsg[_j]->mgLclErr.trId.val =                          \
                                mgTxn->mgcpMsg[_j]->t.mgcpRsp.trId.val;   \
      }                                                                   \
      else                                                                \
      {                                                                   \
         mgTxn->mgcpMsg[_j]->mgLclErr.trId.pres = PRSNT_NODEF;            \
         mgTxn->mgcpMsg[_j]->mgLclErr.trId.val =                          \
                       mgTxn->mgcpMsg[_j]->t.epcfCmd.cmdLine.trId.val;    \
      }                                                                   \
   }                                                                      \
}

#define BCD_TO_ASCII(c)  \
  (((c) <= 9) ? (c) + '0' : (((c) >= 10 && (c) <= 15) ? 'A' + (c) - 10 : '?'))




/*
 * Modified the following macro due to MID changes
 *
 * modified for IPV6/IPV4 changes, only use this macro for finding peer
 * using domain name
 */
#define MG_FIND_PEER_FROM_DOMAIN_INFO(list, dname, len, peer)             \
{                                                                         \
   U16           hashSeqNo;                                               \
                                                                          \
   hashSeqNo = 0;                                                         \
   peer      = NULLP;                                                     \
                                                                          \
   cmHashListFind(list, dname, len, hashSeqNo, (PTR *)&peer);             \
}
#define MG_RMV_FROM_LIST(_lp,_node)                                       \
{                                                                         \
   MgTxnAckList     *_prv;                                                \
   _prv = _lp;                                                            \
   while(_prv->next != _node)                                             \
      _prv = _prv->next;                                                  \
   _prv->next = _node->next;                                              \
}

#define MG_ADD_LIST_INC_ORDER(_lp,_node)                                  \
{                                                                         \
   MgTxnAckList     *_next;                                               \
   MgTxnAckList     *_prv;                                                \
   _next = _lp->next;                                                     \
   _prv  = _lp;                                                           \
   while(_next)                                                           \
   {                                                                      \
      if(_next->info.trId < _node->info.trId)                             \
      {                                                                   \
         _prv = _next;                                                    \
         _next = _next->next;                                             \
      }                                                                   \
      else if(_next->info.trId > _node->info.trId)                        \
      {                                                                   \
         _node->next = _next;                                             \
         _prv->next = _node;                                              \
         break;                                                           \
      }                                                                   \
   };                                                                     \
   if(_next == NULLP)                                                     \
   {                                                                      \
      _node->next = _prv->next;                                           \
      _prv->next = _node;                                                 \
   }                                                                      \
}
/******************************************************************************/
/*                     Free Event Memory                                      */
/******************************************************************************/

/* Enhanced event free macros to free TknBuf if any.
 * If CM_SDP_OPAQUE flag is defined then free the TknBuf associated
 * with the SDP string whereever they occur.
 */
#ifdef CM_SDP_OPAQUE

#define MG_FREE_MGCP_EVNT_MEM(_txn, _freeTxn)                             \
{                                                                         \
   U16  _place, _freedMsg;                                                \
                                                                          \
   if ((_txn))                                                            \
   {                                                                      \
      _place    = 0;                                                      \
      _freedMsg = 0;                                                      \
                                                                          \
      mgMgcpFreeAllTxnTkBfs((_txn));                                      \
                                                                          \
      while ((_freedMsg < (_txn)->numMsg) && (_place < MGT_MAX_MSG))      \
      {                                                                   \
         if ((_txn)->mgcpMsg[_place])                                     \
         {                                                                \
            mgFreeEventMem((Ptr)(_txn)->mgcpMsg[_place]);                 \
            _freedMsg++;                                                  \
         }                                                                \
         _place++;                                                        \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
         mgFreeEventMem((Ptr)_txn);                                       \
   }                                                                      \
}

#else

#define MG_FREE_MGCP_EVNT_MEM(_txn, _freeTxn)                             \
{                                                                         \
   U16  _place, _freedMsg;                                                \
                                                                          \
   if ((_txn))                                                            \
   {                                                                      \
      _place    = 0;                                                      \
      _freedMsg = 0;                                                      \
                                                                          \
      while ((_freedMsg < (_txn)->numMsg) && (_place < MGT_MAX_MSG))      \
      {                                                                   \
         if ((_txn)->mgcpMsg[_place])                                     \
         {                                                                \
            mgFreeEventMem((Ptr)(_txn)->mgcpMsg[_place]);                      \
            _freedMsg++;                                                  \
         }                                                                \
         _place++;                                                        \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
         mgFreeEventMem((Ptr)_txn);                                            \
   }                                                                      \
}

#endif /* CM_SDP_OPAQUE */


#define MG_FREE_ONE_MSG(_msg)                                             \
{                                                                         \
   if(_msg)                                                               \
      cmFreemem(_msg);                                                    \
}

/* Enhanced event free macros to free TknBuf if any.
 * If CM_SDP_OPAQUE flag is defined then free the TknBuf associated
 * with the SDP string whereever they occur.
 */
#ifdef CM_SDP_OPAQUE

#ifdef GCP_CH
#define MG_FREE_MGCO_EVNT_MEM(_msg, _freeTxn)                             \
{                                                                         \
   if ((_msg))                                                            \
   {                                                                      \
      /* mg002.105: typecasting for Warning Removal */                    \
      U16 _freedMsg = 0;                                                  \
                                                                          \
      if ((_msg)->body.type.val == MGT_TXN)                               \
      {                                                                   \
         if (((_msg)->body.u.tl.num.pres == PRSNT_NODEF)                  \
                           &&                                             \
             ((_msg)->body.u.tl.txns))                                    \
         {                                                                \
            U16   num;                                                    \
            for (num=0; num<(_msg)->body.u.tl.num.val; num++)             \
            {                                                             \
               mgMgcoFreeAllTkBfs((_msg)->body.u.tl.txns[num]);           \
            }                                                             \
         }                                                                \
      }                                                                   \
                                                                          \
      while ((_freedMsg < ((_msg)->body.u.tl.num.val)))                   \
      {                                                                   \
         if ((_msg)->body.u.tl.txns[_freedMsg])                           \
         {                                                                \
            mgChFreeCmds(_msg, _freedMsg);                                \
            mgFreeEventMem((Ptr)(_msg)->body.u.tl.txns[_freedMsg]);       \
            (_msg)->body.u.tl.txns[_freedMsg] = NULLP;                    \
         }                                                                \
         _freedMsg++;                                                     \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
      {                                                                   \
         mgFreeEventMem((Ptr)(_msg));                                     \
         (_msg) = NULLP;                                                  \
      }                                                                   \
   }                                                                      \
}
#else
 
#define MG_FREE_MGCO_EVNT_MEM(_msg, _freeTxn)                             \
{                                                                         \
   if ((_msg))                                                            \
   {                                                                      \
      /* mg002.105: typecasting for Warning Removal */                    \
      U16 _freedMsg = 0;                                                  \
                                                                          \
      if ((_msg)->body.type.val == MGT_TXN)                               \
      {                                                                   \
         if (((_msg)->body.u.tl.num.pres == PRSNT_NODEF)                  \
                           &&                                             \
             ((_msg)->body.u.tl.txns))                                    \
         {                                                                \
            U16   num;                                                    \
            for (num=0; num<(_msg)->body.u.tl.num.val; num++)             \
            {                                                             \
               mgMgcoFreeAllTkBfs((_msg)->body.u.tl.txns[num]);           \
            }                                                             \
         }                                                                \
      }                                                                   \
                                                                          \
      while ((_freedMsg < ((_msg)->body.u.tl.num.val)))                   \
      {                                                                   \
         if ((_msg)->body.u.tl.txns[_freedMsg])                           \
         {                                                                \
            mgFreeEventMem((Ptr)(_msg)->body.u.tl.txns[_freedMsg]);       \
            (_msg)->body.u.tl.txns[_freedMsg] = NULLP;                    \
         }                                                                \
         _freedMsg++;                                                     \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
      {                                                                   \
         mgFreeEventMem((Ptr)(_msg));                                     \
         (_msg) = NULLP;                                                  \
      }                                                                   \
   }                                                                      \
}
#endif /* GCP_CH */

#else /* CM_SDP_OPAQUE */

#ifdef GCP_CH
#define MG_FREE_MGCO_EVNT_MEM(_msg, _freeTxn)                             \
{                                                                         \
   if ((_msg))                                                            \
   {                                                                      \
      /* mg002.105: typecasting for Warning Removal */                    \
      U16 _freedMsg = 0;                                                  \
                                                                          \
      while ((_freedMsg < ((_msg)->body.u.tl.num.val)))                   \
      {                                                                   \
         if ((_msg)->body.u.tl.txns[_freedMsg])                           \
         {                                                                \
            mgChFreeCmds(_msg, _freedMsg);                             \
            mgFreeEventMem((Ptr)(_msg)->body.u.tl.txns[_freedMsg]);       \
            (_msg)->body.u.tl.txns[_freedMsg] = NULLP;                    \
         }                                                                \
         _freedMsg++;                                                     \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
      {                                                                   \
         mgFreeEventMem((Ptr)(_msg));                                     \
         (_msg) = NULLP;                                                  \
      }                                                                   \
   }                                                                      \
}
#else
#define MG_FREE_MGCO_EVNT_MEM(_msg, _freeTxn)                             \
{                                                                         \
   if ((_msg))                                                            \
   {                                                                      \
      U16 _freedMsg = 0;                                                  \
                                                                          \
      while ((_freedMsg < ((_msg)->body.u.tl.num.val)))                   \
      {                                                                   \
         if ((_msg)->body.u.tl.txns[_freedMsg])                           \
         {                                                                \
            mgFreeEventMem((Ptr)(_msg)->body.u.tl.txns[_freedMsg]);       \
            (_msg)->body.u.tl.txns[_freedMsg] = NULLP;                    \
         }                                                                \
         _freedMsg++;                                                     \
      }                                                                   \
                                                                          \
      if (_freeTxn == TRUE)                                               \
      {                                                                   \
         mgFreeEventMem((Ptr)(_msg));                                     \
         (_msg) = NULLP;                                                  \
      }                                                                   \
   }                                                                      \
}
#endif /* GCP_CH */

#endif /* CM_SDP_OPAQUE */

/******************************************************************************/
/*               Transaction Control Block Related Functions                  */
/******************************************************************************/

#define MG_GET_TRANSID(_mgcoTxn, _transId)                                \
{                                                                         \
  switch (_mgcoTxn->type.val)                                              \
  {                                                                       \
    case MGT_TXNREQ:                                                      \
      _transId =  _mgcoTxn->u.req.transId.val;                            \
      break;                                                              \
    case MGT_TXNREPLY:                                                    \
      _transId =  _mgcoTxn->u.reply.transId.val;                          \
      break;                                                              \
    case MGT_TXNPEND:                                                     \
      _transId =  _mgcoTxn->u.pend.transId.val;                           \
      break;                                                              \
    case MGT_TXNRSPACK:                                                   \
      _transId =  MG_INVALID_TRANSID;                                     \
      break;                                                              \
  }                                                                       \
}
  

#define MG_MGCP_GET_TRANSID(_mgcpMsg, _transId)                           \
{                                                                         \
  switch (_mgcpMsg->msgType.val)                                             \
  {                                                                       \
    case MGT_MSG_RSP:                                                     \
      _transId =  _mgcpMsg->t.mgcpRsp.trId.val;                           \
      break;                                                              \
    case MGT_MSG_NONSTD:                                                  \
      _transId =  _mgcpMsg->t.nonStdCmd.cmd.cmdLine.trId.val;             \
      break;                                                              \
    default:                                                              \
      _transId =  _mgcpMsg->t.epcfCmd.cmdLine.trId.val;                   \
      break;                                                              \
  }                                                                       \
}
  


#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
#define MG_QUEUE_TRANS(_peer, _txCb, _isNtfyReq)                          \
{                                                                         \
  _txCb->lnkLstNode.node = (PTR)_txCb;                                    \
  if (_isNtfyReq == TRUE)                                                 \
  {                                                                       \
   _txCb->state = MG_OUTTXN_NTFYTXN_QUEUED;                               \
   cmLListAdd2Tail(&(_peer->ntfyCb.notifyRQ), &(_txCb->lnkLstNode));      \
  }                                                                       \
  else                                                                    \
  {                                                                       \
   _txCb->state = MG_OUTTXN_TXN_QUEUED;                                    \
   cmLListAdd2Tail(&(_peer->transQ), &(_txCb->lnkLstNode));               \
  }                                                                       \
  if ((cmHashListInsert (&(_peer->outTransLst), (PTR) _txCb,              \
                          (U8 *)&(_txCb->transId),                        \
                          MG_TRANSID_LEN)) != ROK)                        \
  {                                                                       \
      RETVALUE(RFAILED);                                                  \
  }                                                                       \
}
#else
#define MG_QUEUE_TRANS(_peer, _txCb)                                      \
{                                                                         \
  _txCb->state = MG_OUTTXN_TXN_QUEUED;                                    \
  _txCb->lnkLstNode.node = (PTR)_txCb;                                    \
  cmLListAdd2Tail(&(_peer->transQ), &(_txCb->lnkLstNode));                \
  if ((cmHashListInsert (&(_peer->outTransLst), (PTR) _txCb,              \
                          (U8 *)&(_txCb->transId),                        \
                          MG_TRANSID_LEN)) != ROK)                        \
  {                                                                       \
      RETVALUE(RFAILED);                                                  \
  }                                                                       \
}
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */


#ifdef GCP_PKG_MGCO_ROOT
#define MG_XMIT_TRANS(_peer, _txCb)                                       \
{                                                                         \
   txCb->state = MG_OUTTXN_TXN_SENT;                                      \
                                                                          \
   if ((cmHashListInsert (&(_peer->outTransLst), (PTR) _txCb,             \
                          (U8 *)&(_txCb->transId),                        \
                          MG_TRANSID_LEN)) != ROK)                        \
   {                                                                      \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
                                                                          \
   /* Start the retransmission timer */                                   \
   /* rto is in ticks. convert to multiples of timeRes */                 \
   mgStartTmr (MG_RETX_TMR,(peer->mntInfo.rto/mgCb.genCfg.timeRes),       \
              (PTR) txCb, &(txCb->retxTmr));\
   /*If provisional response timers are present */\
   if (peer->provTmr.pres.pres != NOTPRSNT)\
   {\
      /*Start MGProvisionalResponseTimerValue incase of MGC */   \
      /*Start MGCProvisionalResponseTimerValue incase of MG */   \
      if (mgCb.genCfg.entType == LMG_ENT_GC)\
      {\
      mgStartTmr (MG_PROV_RSP_ROOT_TMR,peer->provTmr.mgProvRespTmrVal,       \
                  (PTR) txCb, &(txCb->provRspRtTmr));\
      }\
      if (mgCb.genCfg.entType == LMG_ENT_GW)\
      {\
      mgStartTmr (MG_PROV_RSP_ROOT_TMR,peer->provTmr.mgcProvRspTmrVal,       \
                  (PTR) txCb, &(txCb->provRspRtTmr));\
      }\
   }\
   SGetSysTime(&(txCb->timeStamp));                                       \
}
#else
#define MG_XMIT_TRANS(_peer, _txCb)                                       \
{                                                                         \
   txCb->state = MG_OUTTXN_TXN_SENT;                                      \
                                                                          \
   if ((cmHashListInsert (&(_peer->outTransLst), (PTR) _txCb,             \
                          (U8 *)&(_txCb->transId),                        \
                          MG_TRANSID_LEN)) != ROK)                        \
   {                                                                      \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
                                                                          \
   /* Start the retransmission timer */                                   \
   /* rto is in ticks. convert to multiples of timeRes */                 \
   mgStartTmr (MG_RETX_TMR,(peer->mntInfo.rto/mgCb.genCfg.timeRes),       \
              (PTR) txCb, &(txCb->retxTmr));\
   SGetSysTime(&(txCb->timeStamp));                                       \
}
#endif


#define MG_FILL_MGCO_ERR_MSG(_errMsg, _reason, _mBuf, _rxCb, _txCb, _trId) \
{                                                                          \
   mgFillMgcoErrMsg(_errMsg, _reason, _mBuf, _rxCb, _txCb, _trId);         \
}


/* fixed a typo - changed mBuf to _mBuf */
#define MG_CLEAR_MEM(_mBuf, _hdrMBuf)                                     \
{                                                                         \
  if (_mBuf != NULLP)                                                     \
    mgPutMsg(_mBuf);                                                      \
  if (_hdrMBuf != NULLP)                                                  \
    mgPutMsg(_hdrMBuf);                                                   \
}


#define MG_SET_IMMACK_FLAG(_mgcoTxn)                                      \
{                                                                         \
  if (mgcoTxn->u.reply.immAck.pres == NOTPRSNT)                           \
    mgcoTxn->u.reply.immAck.pres = PRSNT_NODEF;                           \
}


/* IPV4/IPV6 changes removed #defineMG_FILL_SVCCHGADDR */


#define MG_GET_TCP_CONN(_suConnId, _srvrCb, _tsap)                        \
{                                                                         \
   S16 _ret;                                                              \
   _ret = cmHashListFind (&((_tsap)->tptSrvrLstCp),                       \
                          (U8 *)&(_suConnId),                             \
                          sizeof(ConnId) , MG_HASH_SEQNMB_DEF,            \
                          (PTR *)&_srvrCb); \
   if (_ret != ROK)                                                       \
      _srvrCb = NULLP;                                                    \
}

#define MG_GET_SRVRCB(_srvr,_suConnId,_tsap)                              \
{                                                                         \
   UConnId      _id;                                                      \
   _id = _suConnId & MG_SUCONNID_VAL_MASK;                                \
   if ((_id) < mgCb.genCfg.maxServers)                                    \
      _srvr = (_tsap)->lstnrLst[_id]->lstnrCb;                            \
   else                                                                   \
   {                                                                      \
      _id = _suConnId & MG_SUCONNID_TCP_MASK;                             \
      MG_GET_TCP_CONN(_id, _srvr, _tsap);                                 \
   }                                                                      \
}



#ifdef GCP_PKG_MGCP_BASE

/* Macro for verifying message to transmitted and entity combination */
#define MG_VERIFY_TX_MGCP_MSG_ENT_RELATION(msgType, entType, ret)         \
{                                                                         \
   ret = ROK;                                                             \
   switch (entType)                                                       \
   {                                                                      \
      case LMG_ENT_GW:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_NTFY:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_RSIP:                                            \
            case MGT_MSG_RSP:                                             \
            case MGT_MSG_MESG:                                            \
               break;                                                     \
                                                                          \
            default:                                                      \
               ret = RFAILED;                                             \
               break;                                                     \
         }                                                                \
      }                                                                   \
      break;                                                              \
      case LMG_ENT_GC:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_EPCF:                                            \
            case MGT_MSG_CRCX:                                            \
            case MGT_MSG_MDCX:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_RQNT:                                            \
            case MGT_MSG_AUEP:                                            \
            case MGT_MSG_AUCX:                                            \
            case MGT_MSG_RSP:                                             \
            case MGT_MSG_MESG:                                            \
               break;                                                     \
                                                                          \
            default:                                                      \
               ret = RFAILED;                                             \
               break;                                                     \
         }                                                                \
      }                                                                   \
      break;                                                              \
      default:                                                            \
         ret = RFAILED;                                                   \
         break;                                                           \
   }                                                                      \
}

#else  /* GCP_PKG_MGCP_BASE */

/* Macro for verifying message to transmitted and entity combination */
#define MG_VERIFY_TX_MGCP_MSG_ENT_RELATION(msgType, entType, ret)         \
{                                                                         \
   ret = ROK;                                                             \
   switch (entType)                                                       \
   {                                                                      \
      case LMG_ENT_GW:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_NTFY:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_RSIP:                                            \
            case MGT_MSG_RSP:                                             \
               break;                                                     \
                                                                          \
            default:                                                      \
               ret = RFAILED;                                             \
               break;                                                     \
         }                                                                \
      }                                                                   \
      break;                                                              \
      case LMG_ENT_GC:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_EPCF:                                            \
            case MGT_MSG_CRCX:                                            \
            case MGT_MSG_MDCX:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_RQNT:                                            \
            case MGT_MSG_AUEP:                                            \
            case MGT_MSG_AUCX:                                            \
            case MGT_MSG_RSP:                                             \
               break;                                                     \
                                                                          \
            default:                                                      \
               ret = RFAILED;                                             \
               break;                                                     \
         }                                                                \
      }                                                                   \
      break;                                                              \
      default:                                                            \
         ret = RFAILED;                                                   \
         break;                                                           \
   }                                                                      \
}

#endif /* GCP_PKG_MGCP_BASE */



#ifdef GCP_PKG_MGCP_BASE

/* macro for verifying received message and entity represented */
#define MG_VERIFY_RX_MGCP_MSG_ENT_RELATION(msgType, entType, chkNtfyEnt)  \
{                                                                         \
   chkNtfyEnt = FALSE;                                                    \
   switch (entType)                                                       \
   {                                                                      \
      case LMG_ENT_GC:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_NTFY:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_RSIP:                                            \
            case MGT_MSG_RSP:                                             \
            case MGT_MSG_MESG:                                            \
               break;                                                     \
                                                                          \
            default:                                                      \
               RETVALUE(RFAILED);                                         \
         }                                                                \
      }                                                                   \
      break;                                                              \
      case LMG_ENT_GW:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_CRCX:                                            \
            case MGT_MSG_MDCX:                                            \
            case MGT_MSG_RQNT:                                            \
            {                                                             \
               chkNtfyEnt = TRUE;                                         \
               break;                                                     \
            }                                                             \
                                                                          \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_EPCF:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_AUEP:                                            \
            case MGT_MSG_AUCX:                                            \
            case MGT_MSG_RSP:                                             \
            case MGT_MSG_MESG:                                            \
               break;                                                     \
                                                                          \
            default:                                                      \
               RETVALUE(RFAILED);                                         \
         }                                                                \
      }                                                                   \
      break;                                                              \
      default:                                                            \
         RETVALUE(RFAILED);                                               \
   }                                                                      \
}

#else  /* GCP_PKG_MGCP_BASE */

/* macro for verifying received message and entity represented */
#define MG_VERIFY_RX_MGCP_MSG_ENT_RELATION(msgType, entType, chkNtfyEnt)  \
{                                                                         \
   chkNtfyEnt = FALSE;                                                    \
   switch (entType)                                                       \
   {                                                                      \
      case LMG_ENT_GC:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_NTFY:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_RSIP:                                            \
            case MGT_MSG_RSP:                                             \
               break;                                                     \
                                                                          \
            default:                                                      \
               RETVALUE(RFAILED);                                         \
         }                                                                \
      }                                                                   \
      break;                                                              \
      case LMG_ENT_GW:                                                    \
      {                                                                   \
         switch (msgType)                                                 \
         {                                                                \
            case MGT_MSG_CRCX:                                            \
            case MGT_MSG_MDCX:                                            \
            case MGT_MSG_RQNT:                                            \
            {                                                             \
               chkNtfyEnt = TRUE;                                         \
               break;                                                     \
            }                                                             \
                                                                          \
            case MGT_MSG_NONSTD:                                          \
            case MGT_MSG_EPCF:                                            \
            case MGT_MSG_DLCX:                                            \
            case MGT_MSG_AUEP:                                            \
            case MGT_MSG_AUCX:                                            \
            case MGT_MSG_RSP:                                             \
               break;                                                     \
                                                                          \
            default:                                                      \
               RETVALUE(RFAILED);                                         \
         }                                                                \
      }                                                                   \
      break;                                                              \
      default:                                                            \
         RETVALUE(RFAILED);                                               \
   }                                                                      \
}

#endif /* GCP_PKG_MGCP_BASE */



#define MG_FILL_PEERID_ALARMINFO(alarmInfo, peer)                         \
{                                                                         \
   if (peer->accessInfo.peerId != MG_INVALID_PEERID)                      \
   {                                                                      \
      alarmInfo.id.pres = PRSNT_NODEF;                                    \
      alarmInfo.id.val  = peer->accessInfo.peerId;                        \
   }                                                                      \
   else                                                                   \
      alarmInfo.id.pres = NOTPRSNT;                                       \
}

/* macro for sending status indication for STGCPENT */
/* 
 * Break MG_ISSUE_PEER_STAIND into 2 macros, one for MGCP path and other for
 * MEGACO path.
 */
#ifdef GCP_MGCP
#define MG_ISSUE_MGCPPEER_STAIND(peer, category, event, cause)            \
{                                                                         \
   MgPeerInfo      alarmInfo;                                             \
                                                                          \
   cmMemset((U8 *)&alarmInfo, 0, sizeof(MgPeerInfo));                     \
   alarmInfo.pres.pres = PRSNT_NODEF;                                     \
                                                                          \
   if (peer == NULLP)                                                     \
   {                                                                      \
     mgGenStaInd(STGCPENT, category, event, cause, LMG_ALARMINFO_NONE,    \
                 (Ptr) NULLP, 0, LMG_ALARMINFO_INVSAPID);                 \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      MG_FILL_PEERID_ALARMINFO(alarmInfo, peer);                          \
      cmMemset((U8 *)&alarmInfo, 0, sizeof(MgPeerInfo));                  \
      cmMemcpy((U8 *)&(alarmInfo.dname.netAddr),                          \
               (CONSTANT U8 *)&(peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0]),\
               sizeof(CmNetAddr));                                        \
                                                                          \
      alarmInfo.port.pres = PRSNT_NODEF;                                  \
      alarmInfo.port.val = peer->accessInfo.commEnt.t.ipCommEntity.remotePort;                   \
                                                                          \
      if (peer->accessInfo.commEnt.t.ipCommEntity.namePres == TRUE)                              \
      {                                                                   \
         alarmInfo.dname.namePres.pres = PRSNT_NODEF;                     \
         cmMemcpy((U8 *)alarmInfo.dname.name,                             \
                  (CONSTANT U8 *)peer->accessInfo.commEnt.t.ipCommEntity.name,                   \
                   CM_DNS_DNAME_LEN);                                     \
      }                                                                   \
      else                                                                \
         alarmInfo.dname.name[0] = '\0';                                  \
                                                                          \
      mgGenStaInd(STGCPENT, category, event, cause, LMG_ALARMINFO_PEER,   \
                  (Ptr) &(alarmInfo),                                     \
                  sizeof(MgPeerInfo), peer->ssap->suId);                  \
    }                                                                     \
}
#endif /* GCP_MGCP */
#ifdef GCP_MGCO
#define MG_ISSUE_MGCOPEER_STAIND(peer, category, event, cause)            \
{                                                                         \
   MgPeerInfo      alarmInfo;                                             \
   cmMemset((U8 *)&alarmInfo, 0, sizeof(MgPeerInfo));                     \
                                                                          \
   alarmInfo.pres.pres = PRSNT_NODEF;                                     \
                                                                          \
   if (peer == NULLP)                                                     \
   {                                                                      \
     mgGenStaInd(STGCPENT, category, event, cause, LMG_ALARMINFO_NONE,    \
                 (Ptr) NULLP, 0, LMG_ALARMINFO_INVSAPID);                 \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      MG_COPY_PEERINFO_INTO_MGCOMSG(alarmInfo, peer)                      \
      mgGenStaInd(STGCPENT, category, event, cause, LMG_ALARMINFO_PEER,   \
                  (Ptr) &(alarmInfo), sizeof(MgPeerInfo),                 \
                  peer->ssap->suId);                                      \
    }                                                                     \
}
#endif /* GCP_MGCO */


#define MG_GET_REMOTE_ADDR_FOR_TX(addr, peerInfo, peer)                   \
{                                                                         \
   if (((peerInfo->dname.netAddr.type == CM_NETADDR_IPV4) &&              \
        (peerInfo->dname.netAddr.u.ipv4NetAddr != 0)) ||                  \
       (peerInfo->dname.netAddr.type == CM_NETADDR_IPV6))                 \
   {                                                                      \
      MG_FILL_TPTADDR_FRM_NETADDR((addr), &(peerInfo->dname.netAddr));    \
                                                                          \
      if (peerInfo->port.pres == PRSNT_NODEF)                             \
      {                                                                   \
         MG_FILL_TPTADDR_PORT((addr), peerInfo->port.val);                \
      }                                                                   \
      else                                                                \
         MG_FILL_TPTADDR_PORT((addr), peer->accessInfo.commEnt.t.ipCommEntity.remotePort);       \
   }                                                                      \
   else                                                                   \
   if (peerInfo->port.pres == PRSNT_NODEF)                                \
   {                                                                      \
      if (peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0].type == CM_NETADDR_IPV4)\
      {                                                                   \
         MG_FILL_TPTADDR_FRM_NETADDR((addr),                              \
                                     &(peer->accessInfo.commEnt.t.ipCommEntity.peerAddrTbl.netAddr[0])); \
      }                                                                   \
      MG_FILL_TPTADDR_PORT((addr), peerInfo->port.val);                   \
   }                                                                      \
   else                                                                   \
      (addr)->type = CM_TPTADDR_NOTPRSNT;                                 \
}

#define MG_CHK_DUPL_ADDR(_addrTbl,_addr,_dupl)                            \
{                                                                         \
   U32 i;                                                                 \
   _dupl = FALSE;                                                         \
   for (i = 0; i < _addrTbl.count; i++)                                   \
   {                                                                      \
      if (cmMemcmp((U8 *) &(_addrTbl.netAddr[i]),                         \
                   (U8 *) (_addr), sizeof (CmNetAddr)) == 0)              \
      {                                                                   \
         _dupl = TRUE;                                                    \
         break;                                                           \
      }                                                                   \
   }                                                                      \
}

#define MG_CONVERT_2_UPPERCASE(strng, len)                                \
{                                                                         \
   U16   idx;                                                             \
                                                                          \
   for (idx =0; idx < len; idx++)                                         \
   {                                                                      \
      if ((strng[idx] >= 'a' && strng[idx] <= 'z'))                       \
         strng[idx] = 'A' + (strng[idx] - 'a');                           \
   }                                                                      \
}

#define MG_MGCP_FIND_VARIANT(name, len, variant)                          \
{                                                                         \
   variant = LMG_VER_PROF_MGCP_RFC2705_1_0;                               \
                                                                          \
   if (name != NULLP)                                                     \
   {                                                                      \
      MG_CONVERT_2_UPPERCASE(name, len);                                  \
                                                                          \
      if ((cmMemcmp((U8 *)name, (CONSTANT U8 *)"NCS 1.0", len)) == 0)     \
      {                                                                   \
         variant = LMG_VER_PROF_MGCP_NCS_1_0;                             \
      }                                                                   \
      else                                                                \
      if ((cmMemcmp((U8 *)name, (CONSTANT U8 *)"TGCP 1.0", len)) == 0)    \
      {                                                                   \
         variant = LMG_VER_PROF_MGCP_TGCP_1_0;                            \
      }                                                                   \
   }                                                                      \
}


#ifdef ZG

#define MG_OBTAIN_TRANSID(ssap, transId, prot) zgObtainTxnId(ssap, transId, prot)

#else /* ZG_DFTHA */
/* Macro to obtain  a transaction Id */
#define MG_OBTAIN_TRANSID(ssap, transId, prot)                            \
{                                                                         \
   *transId = ssap->nxtTransId;                                           \
                                                                          \
   if (ssap->nxtTransId == ssap->ssapCfg.endTxnNum)                       \
      ssap->nxtTransId = ssap->ssapCfg.startTxnNum;                       \
   else                                                                   \
      ssap->nxtTransId++;                                                 \
}
#endif /* ZG_DFTHA */



#define MG_MGCP_ASSOCIATION_LOST(ssap, peer, transId)                     \
{                                                                         \
   peer->state = LMG_PEER_STATE_DISCONNECTED;                             \
   mgDeletePeer (peer, LMG_EVENT_PEER_REMOVED,                            \
                       LMG_CAUSE_PEER_NOT_RESPONDING,                     \
                       FALSE, MGT_ERR_RMV_PEER_ID);                       \
                                                                          \
}
/* DFTHA Specific MACROs */
#define MG_MOVE_TXN     0x00
#define MG_DEL_TXN      0x01
#define MG_NONE_TXN     0x02

#define MG_ADD_NODE_INTO_STORELST(_list,_node)                            \
{                                                                         \
   MgStoreList       *_queue;                                             \
   _queue = (MgStoreList *)(_list);                                       \
   while(_queue->next != NULLP)                                           \
      _queue = _queue->next;                                              \
   _queue->next = _node;                                                  \
}

#define MG_FIND_AND_DEL_NODE_FRM_STORELST(_node,_seqNo,_Q)                \
{                                                                         \
   MgStoreList        *_queue;                                            \
   MgStoreList        *_prv;                                              \
   _queue = _Q->next;                                                     \
   _prv = _Q;                                                             \
   while((_queue) && _queue->nodeIndx != _seqNo)                          \
   {                                                                      \
      _prv = _queue;                                                      \
      _queue = _queue->next;                                              \
   }                                                                      \
   _node = _queue;                                                        \
   if(_node)                                                              \
      _prv->next = _node->next;                                           \
}
#ifdef ZG_DFTHA
#define MG_FIND_AND_DEL_RVUPD_NODE(_node,_seqNo,_Q)                       \
{                                                                         \
   MgStoreList        *_queue;                                            \
   MgStoreList        *_prv;                                              \
   _queue = _Q->next;                                                     \
   _prv = _Q;                                                             \
   while((_queue) && _queue->nodeIndx != _seqNo)                          \
   {                                                                      \
      _prv = _queue;                                                      \
      _queue = _queue->next;                                              \
   }                                                                      \
   _node = _queue;                                                        \
   if(_node)                                                              \
      _prv->next = _node->next;                                           \
}

#define MG_FREE_RVUPD_NODE(_node)                                         \
{                                                                         \
   if ((_node)->prev != NULLP)                                            \
   {                                                                      \
      (_node)->prev->next = (_node)->next;                                \
   }                                                                      \
   if ((_node)->next != NULLP)                                            \
   {                                                                      \
      (_node)->next->prev = (_node)->prev;                                \
   }                                                                      \
   (_node)->next = NULLP;                                                 \
   (_node)->prev = NULLP;                                                 \
   if((_node)->qType == MG_PEER_OUTTXNQ)                                  \
   {                                                                      \
      mgDeAlloc((Data *)(_node->info), sizeof(MgRvrsQTxnReq));            \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      mgDeAlloc((Data *)(_node->info), sizeof(MgRvrsQTxnInd));            \
   }                                                                      \
   mgDeAlloc((Data *)(_node), sizeof(MgRvUpdQNode));                      \
} /* MG_FREE_RVUPD_NODE */

#define MG_FILL_GET_AND_ADJST_PEER(_updInfo, _mid, _srcAddr, _suConnId);  \
{                                                                         \
   /* fill required info */                                               \
   _updInfo.action  = ZG_RVUPD_ADJST_PEER;                                \
   _updInfo.u.adjPeer.mid = _mid;                                         \
   _updInfo.u.adjPeer.addr = _srcAddr;                                    \
   _updInfo.u.adjPeer.suConnId = _suConnId;                               \
}
/* Macro to send reverse update for SrvcChng Resp from User */
#define  MG_FILL_RVUPD_SVCRSP_USR(_updInfo,_peerId,_mthd,_suConnId,       \
                                  _lclPort,_svcChgInfo)                   \
{                                                                         \
   /* fill required info */                                               \
   _updInfo.action  = ZG_RVUPD_SVCCHG_RSP_USR;                            \
   _updInfo.u.sRspU.peerId = _peerId;                                     \
   _updInfo.u.sRspU.regCmdMethod = _mthd;                                 \
   _updInfo.u.sRspU.suConnId = _suConnId;                                 \
   _updInfo.u.sRspU.lclPort = _lclPort;                                   \
   _updInfo.u.sRspU.svcChg = _svcChgInfo;                                 \
}

#define MG_FILL_RVUPD_DEL_PEER(_updInfo,_peer,_event,_cause,_delReqd)     \
{                                                                         \
   _updInfo.action = ZG_RVUPD_DEL_PEER;                                   \
   _updInfo.u.delPeer.peerId = _peer->accessInfo.peerId;                  \
   _updInfo.u.delPeer.event = _event;                                     \
   _updInfo.u.delPeer.cause = _cause;                                     \
   _updInfo.u.delPeer.delReqd = _delReqd;                                 \
}
/* Macro to send rvrse upd to generate srvcChng/RSIP cmd internally */

#define MG_FILL_RVUPD_REGCMD_INT(_updInfo,_peerId,_mthd,_rsn,_cmd)        \
{                                                                         \
   _updInfo.action = _cmd;                                                \
   _updInfo.u.rsCmdI.peerId = _peerId;                                    \
   _updInfo.u.rsCmdI.method = _mthd;                                      \
   _updInfo.u.rsCmdI.reason = _rsn;                                       \
}

#define MG_FILL_RVUPD_SVCCMD_PEER(_updInfo,_peer,_suConnId,_mid,_ver,     \
                                  _trId,_svcInfo,_addr)                   \
{                                                                         \
   _updInfo.action  = ZG_RVUPD_SVCCHG_CMD_PEER;                           \
   _updInfo.u.sCmdP.suConnId = _suConnId;                                 \
   _updInfo.u.sCmdP.trId     = _trId;                                     \
   _updInfo.u.sCmdP.mid      = (_mid);                                    \
   _updInfo.u.sCmdP.ver.pres = (_ver)->pres;                              \
   _updInfo.u.sCmdP.ver.val  = (_ver)->val;                               \
   _updInfo.u.sCmdP.svcChg = _svcInfo;                                    \
   _updInfo.u.sCmdP.srcTptAddr = _addr;                                   \
   if(_peer)                                                              \
   {                                                                      \
      _updInfo.u.sCmdP.peerId = _peer->accessInfo.peerId;                 \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      _updInfo.u.sCmdP.peerId = MG_INVALID_PEERID;                        \
   }                                                                      \
}

#define MG_FILL_RVUPD_RSIPCMD_PEER(_updInfo,_peer,_suConnId,_var,_mthd,   \
                                   _trId,_endPt,_addr)                    \
{                                                                         \
   _updInfo.action  = ZG_RVUPD_RSIP_CMD_PEER;                             \
   _updInfo.u.rCmdP.suConnId = _suConnId;                                 \
   _updInfo.u.rCmdP.method = _mthd;                                       \
   _updInfo.u.rCmdP.variant = _var;                                       \
   _updInfo.u.rCmdP.trId    = _trId;                                      \
   _updInfo.u.rCmdP.endPt = _endPt;                                       \
   _updInfo.u.rCmdP.srcTptAddr = _addr;                                   \
   if(_peer)                                                              \
      _updInfo.u.rCmdP.peerId = _peer->accessInfo.peerId;                 \
   else                                                                   \
      _updInfo.u.rCmdP.peerId = MG_INVALID_PEERID;                        \
}

#define MG_FILL_RVUPD_RSIPRSP_PEER(_updInfo,_peer,_rspCode,_var,_ntfiedEnt, \
_trId)\
{                                                                         \
   _updInfo.action  = ZG_RVUPD_RSIP_RSP_PEER;                             \
   _updInfo.u.rRspP.rspCode = _rspCode;                                   \
   _updInfo.u.rRspP.variant = _var;                                       \
   _updInfo.u.rRspP.ntfyEnt = _ntfiedEnt;                                 \
   _updInfo.u.rRspP.trId    = _trId;                                      \
   if(_peer)                                                              \
      _updInfo.u.rRspP.peerId = _peer->accessInfo.peerId;                 \
   else                                                                   \
      _updInfo.u.rRspP.peerId = MG_INVALID_PEERID;                        \
}

#define MG_FILL_RVUPD_SVCRSP_PEER(_updInfo,_peer,_msgInfo,_suConnId,_ver, \
                                  _svcInfo,_addr)                         \
{                                                                         \
   _updInfo.action  = ZG_RVUPD_SVCCHG_RSP_PEER;                           \
   _updInfo.u.sRspP.peerId = _peer->accessInfo.peerId;                    \
   _updInfo.u.sRspP.msgInfo = _msgInfo;                                   \
   _updInfo.u.sRspP.suConnId = _suConnId;                                 \
   _updInfo.u.sRspP.ver = _ver;                                           \
   _updInfo.u.sRspP.svcChg = _svcInfo;                                    \
   _updInfo.u.sRspP.srcTptAddr = _addr;                                   \
}

#define MG_FILL_RVUPD_NTFIEDENT(_updInfo,_peer,_var,_ntfiedEnt)           \
{                                                                         \
   _updInfo.action  = ZG_RVUPD_NTFY_ENT;                                 \
   _updInfo.u.ntfyInfo.variant = _var;                                    \
   _updInfo.u.ntfyInfo.ntfiedEnt = _ntfiedEnt;                            \
   _updInfo.u.ntfyInfo.peerId = _peer->accessInfo.peerId;                 \
}
#endif /* ZG_DFTHA */

/* defines for copying header content of mgcoMsg to mgcoMsg */
#define MG_MGCO_COPY_EVNT_STRUCT(_oldMsg, _newMsg)                       \
{                                                                        \
   _newMsg->pres.pres =  _oldMsg->pres.pres;                             \
   _newMsg->ah.pres.pres = _oldMsg->ah.pres.pres;                        \
   /* copy authenticatio header */                                       \
   cmMemcpy((U8 *)&_newMsg->ah.spi, (U8 *)&_oldMsg->ah.spi,              \
      sizeof(MgMgcoSecParmIndex));                                       \
   cmMemcpy((U8 *)&_newMsg->ah.sn, (U8 *)&_oldMsg->ah.sn,                \
      sizeof(MgMgcoSequenceNum));                                        \
   if(_oldMsg->ah.aData.pres == PRSNT_NODEF)                             \
   {                                                                     \
      /* copy auth data */                                               \
      _newMsg->ah.aData.pres = _oldMsg->ah.aData.pres;                   \
      _newMsg->ah.aData.len = _oldMsg->ah.aData.len;                     \
      cmGetMem((Ptr)&(_newMsg->memCp), _oldMsg->ah.aData.len,            \
         (Ptr *)&(_newMsg->ah.aData.val));                               \
      cmMemcpy((U8 *)_newMsg->ah.aData.val, (U8*)_oldMsg->ah.aData.val,  \
         _oldMsg->ah.aData.len);                                         \
   }                                                                     \
   else                                                                  \
      _newMsg->ah.aData.pres = NOTPRSNT;                                 \
   cmMemcpy((U8 *)&_newMsg->ver, (U8 *)&_oldMsg->ver, sizeof(MgMgcoVersion));\
   /* copy mid */                                                        \
   _newMsg->mid.pres = _oldMsg->mid.pres;                                \
   if(_oldMsg->mid.pres == PRSNT_NODEF)                                  \
   {                                                                     \
      cmGetMem((Ptr)&(_newMsg->memCp), _oldMsg->mid.len,                 \
         (Ptr *)&(_newMsg->mid.val));                                    \
      cmMemcpy((U8 *)_newMsg->mid.val, (U8*)_oldMsg->mid.val,            \
         _oldMsg->mid.len);                                              \
      _newMsg->mid.len = _oldMsg->mid.len;                               \
   }                                                                     \
   /* copy body type */                                                  \
   cmMemcpy((U8 *)&_newMsg->body.type, (U8 *)&_oldMsg->body.type,        \
       sizeof(TknU8));                                                   \
   /* Copy local info */                                                 \
   cmMemcpy((U8 *)&_newMsg->lcl, (U8 *)&_oldMsg->lcl, sizeof(MgPeerInfo));\
}

#define MG_MGCP_COPY_EVNT_STRUCT(_oldTxn, _newTxn)                       \
{                                                                        \
   cmMemcpy((U8 *)&_newTxn->mgLclInfo, (U8*)&_oldTxn->mgLclInfo,         \
      sizeof(MgPeerInfo));                                               \
   _newTxn->numMsg = _oldTxn->numMsg;                                    \
}

#ifdef CM_ABNF_MT_LIB
#define MG_ENCDEC_CFM_IS_PENDING  (((mgCb.encList.next == NULLP) &&  \
                                 (mgCb.decList.next == NULLP)) ? FALSE : TRUE)
#endif /* CM_ABNF_MT_LIB */

/* populate TPT address from a net address, added for IPV4/IPV6 processing  */
#define MG_FILL_TPTADDR_FRM_NETADDR(_tptAddr, _netAddr)                  \
{                                                                        \
   if ((_netAddr)->type == CM_NETADDR_IPV4)                              \
   {                                                                     \
      (_tptAddr)->type = CM_TPTADDR_IPV4;                                \
      cmMemcpy((U8 *)&((_tptAddr)->u.ipv4TptAddr.address),               \
               (CONSTANT U8 *)&((_netAddr)->u.ipv4NetAddr),              \
               sizeof(CmInetIpAddr));                                    \
   }                                                                     \
   else                                                                  \
   {                                                                     \
      (_tptAddr)->type = CM_TPTADDR_IPV6;                                \
      cmMemcpy((U8 *)&((_tptAddr)->u.ipv6TptAddr.ipv6NetAddr),           \
               (CONSTANT U8 *)&((_netAddr)->u.ipv6NetAddr),              \
               sizeof(CmIpv6NetAddr));                                   \
   }                                                                     \
}


#define MG_CMP_IP_ADDR(_addr1, _addr2, _result)                         \
{                                                                       \
do{                                                                     \
    _result = RFAILED;                                                  \
    if((_addr1)->type == CM_TPTADDR_IPV4)                               \
    {                                                                   \
       if(cmMemcmp((CONSTANT U8 *)&((_addr1)->u.ipv4NetAddr),           \
          (CONSTANT U8 *)&((_addr2)->u.ipv4NetAddr),                    \
                sizeof(CmIpv4NetAddr)) == 0)                            \
       {                                                                \
          _result = ROK;                                                \
       }                                                                \
    }                                                                   \
    if((_addr1)->type == CM_TPTADDR_IPV6)                               \
    {                                                                   \
       if(cmMemcmp((CONSTANT U8 *)&((_addr1)->u.ipv6NetAddr),           \
          (CONSTANT U8 *)&((_addr2)->u.ipv6NetAddr),                    \
                sizeof(CmIpv6NetAddr)) == 0)                            \
       {                                                                \
          _result = ROK;                                                \
       }                                                                \
    }                                                                   \
  }while(0);                                                            \
}


/* populate a NetAddress from a TptAddress, added for IPV4/IPV6 processing  */
#define MG_FILL_NETADDR_FRM_TPTADDR(_netAddr, _tptAddr)                  \
{                                                                        \
   if ((_tptAddr)->type == CM_TPTADDR_IPV4)                              \
   {                                                                     \
      (_netAddr)->type = CM_NETADDR_IPV4;                                \
      cmMemcpy((U8 *)&((_netAddr)->u.ipv4NetAddr),                       \
               (CONSTANT U8 *)&((_tptAddr)->u.ipv4TptAddr.address),      \
               sizeof(CmInetIpAddr));                                    \
   }                                                                     \
   else                                                                  \
   {                                                                     \
      (_netAddr)->type  = CM_NETADDR_IPV6;                               \
      cmMemcpy((U8 *)&((_netAddr)->u.ipv6NetAddr),                       \
               (CONSTANT U8 *)((_tptAddr)->u.ipv6TptAddr.ipv6NetAddr),   \
               sizeof(CmIpv6NetAddr));                                   \
   }                                                                     \
}

/* populate the TptAddress port,  added for IPV4/IPV6 processing  */
#define MG_FILL_TPTADDR_PORT(_tptAddr, _port)                            \
{                                                                        \
   if ((_tptAddr)->type ==  CM_TPTADDR_IPV4)                             \
   {                                                                     \
      (_tptAddr)->u.ipv4TptAddr.port = _port;                            \
   }                                                                     \
   else                                                                  \
   {                                                                     \
      (_tptAddr)->u.ipv6TptAddr.port = _port;                            \
   }                                                                     \
}

/* populate the port,  using tpt address as an input 
   added for IPV4/IPV6 processing  */
#define MG_FILL_PORT_FRM_TPTADDR(_port, _tptAddr)                        \
{                                                                        \
   if ((_tptAddr)->type ==  CM_TPTADDR_IPV4)                             \
   {                                                                     \
      _port = (_tptAddr)->u.ipv4TptAddr.port;                            \
   }                                                                     \
   else                                                                  \
   {                                                                     \
      _port = (_tptAddr)->u.ipv6TptAddr.port;                            \
   }                                                                     \
}

/* Added macro for MTU Size check */
#define MG_CHK_MTU_SIZE(mBuf, mLen, peer, ret)                            \
{                                                                         \
   SFndLenMsg(mBuf, &mLen);                                               \
   if (peer != NULLP)                                                     \
   {                                                                      \
      if(mLen > peer->mntInfo.mtuSize)                                    \
      {                                                                   \
         ret = MG_MSG_SZ_EXCEDED;                                         \
      }                                                                   \
   }                                                                      \
}

#ifdef GCP_LCN_APP_USE
/*
 *   New macro def - MG_MGCO_GET_STRMID_FROM_ASSOC
 *    For Service Change request message which is the first
 *    message goes from the  MW 
 *   stream ID is calculated by a roundrobin mechanism.
 */

#define MG_MGCO_GET_NXT_STRMID_FROM_ASSOC(_strmId, _assocCb)             \
{                                                                         \
   if ((_assocCb))                                                        \
   {                                                                      \
       if (((_assocCb)->nxtOutStrmId) == ((_assocCb)->assocCfg->locOutStrms))\
          (_assocCb)->nxtOutStrmId = 0;                                 \
                                                                          \
         (_strmId) = (_assocCb)->nxtOutStrmId;                            \
         ++((_assocCb)->nxtOutStrmId);                                    \
    }                                                                   \
    else                                                                   \
    {                                                                      \
        RETVALUE(RFAILED);                                               \
   }                                                                      \
}

#endif /* GCP_LCN_APP_USE */


#ifdef    GCP_PROV_SCTP

/*
 *   added new macro def - MG_GET_NEXT_UCONNID to assign
 *   a new suAssocId;
 *
 *   If the suAssocIds have wrapped around, its pops the
 *   unused suAssocId from the list of terminated suAssocIds;
 *
 *   Otherwise, its simply increments the suAssocId;
 *
 */
#ifdef   ZG
#define MG_GET_NEXT_UCONNID(_newConnId,_node)                             \
{                                                                         \
   if ((_node)->assocIdWrpd == FALSE)                                     \
   {                                                                      \
      (_newConnId) = (_node)->nxtSuAssocId;                               \
                                                                          \
      ++((_node)->nxtSuAssocId);                                          \
                                                                          \
      if (LMG_MAX_ASSOCS == ((_node)->nxtSuAssocId))                      \
         (_node)->assocIdWrpd = TRUE;                                     \
         /* send run time update for tsap */                               \
         zgRtUpd(ZG_CBTYPE_TSAP, (Ptr)(_node), CMPFTHA_UPDTYPE_SYNC,        \
                  CMPFTHA_ACTN_MOD);                                      \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      CmLList    *first;                                                  \
                                                                          \
      first = (_node)->termAssocsCp.first;                                \
                                                                          \
      if ((first == NULLP) || (first->node == NULLP))                     \
         RETVALUE(RFAILED);                                               \
                                                                          \
      (_newConnId) = ((MgSuAssocLl *)(first->node))->suAssocId;           \
                                                                          \
      cmLListDelFrm(&((_node)->termAssocsCp), first);                     \
                                                                          \
      mgDeAlloc((Data *)(first->node), sizeof(MgSuAssocLl));              \
                                                                          \
   }                                                                      \
}

/*
 *   New macro def - MG_MGCO_GET_STRMID_FRM_CTXID
 *   is defined which maps Context-IDs to Stream-IDs.
 *   It calculates the stream ID by taking a modulo of
 *   the integer type of Context-ID by the number of
 *   outgoing streams. For a non integer type of Context-ID
 *   stream ID is calculated by a roundrobin mechanism.
 */

#define MG_MGCO_GET_STRMID_FRM_CTXID(_strmId,_ctxId,_assocCb)             \
{                                                                         \
   if ((_assocCb))                                                        \
   {                                                                      \
      if (PRSNT_NODEF == ((_ctxId)->pres))                                \
      {                                                                   \
         (_strmId) = ((_ctxId)->val) % ((_assocCb)->assocCfg->locOutStrms);  \
      }                                                                   \
      else                                                                \
      {                                                                   \
         if (((_assocCb)->nxtOutStrmId) == ((_assocCb)->assocCfg->locOutStrms))\
            (_assocCb)->nxtOutStrmId = 0;                                 \
                                                                          \
         (_strmId) = (_assocCb)->nxtOutStrmId;                            \
         ++((_assocCb)->nxtOutStrmId);                                    \
         /* Send Run Time Update for nxtOutStrmId */                       \
         zgRtUpd(ZG_CBTYPE_ASSOC,(Ptr)(_assocCb),CMPFTHA_UPDTYPE_SYNC,       \
         CMPFTHA_ACTN_MOD);                                                 \
      }                                                                   \
   }                                                                      \
}

#else /* ZG */

#define MG_GET_NEXT_UCONNID(_newConnId,_node)                             \
{                                                                         \
   if ((_node)->assocIdWrpd == FALSE)                                     \
   {                                                                      \
      (_newConnId) = (_node)->nxtSuAssocId;                               \
                                                                          \
      ++((_node)->nxtSuAssocId);                                          \
                                                                          \
      if (LMG_MAX_ASSOCS == ((_node)->nxtSuAssocId))                      \
         (_node)->assocIdWrpd = TRUE;                                     \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      CmLList    *first;                                                  \
                                                                          \
      first = (_node)->termAssocsCp.first;                                \
                                                                          \
      if ((first == NULLP) || (first->node == NULLP))                     \
         RETVALUE(RFAILED);                                               \
                                                                          \
      (_newConnId) = ((MgSuAssocLl *)(first->node))->suAssocId;           \
                                                                          \
      cmLListDelFrm(&((_node)->termAssocsCp), first);                     \
                                                                          \
      mgDeAlloc((Data *)(first->node), sizeof(MgSuAssocLl));              \
                                                                          \
   }                                                                      \
}


/*
 *   New macro def - MG_MGCO_GET_STRMID_FRM_CTXID
 *   is defined which maps Context-IDs to Stream-IDs.
 *   It calculates the stream ID by taking a modulo of
 *   the integer type of Context-ID by the number of
 *   outgoing streams. For a non integer type of Context-ID
 *   stream ID is calculated by a roundrobin mechanism.
 */

#define MG_MGCO_GET_STRMID_FRM_CTXID(_strmId,_ctxId,_assocCb)             \
{                                                                         \
   if ((_assocCb))                                                        \
   {                                                                      \
      if (PRSNT_NODEF == ((_ctxId)->pres))                                \
      {                                                                   \
         (_strmId) = ((_ctxId)->val) % ((_assocCb)->assocCfg->locOutStrms);  \
      }                                                                   \
      else                                                                \
      {                                                                   \
         if (((_assocCb)->nxtOutStrmId) == ((_assocCb)->assocCfg->locOutStrms))\
            (_assocCb)->nxtOutStrmId = 0;                                 \
                                                                          \
         (_strmId) = (_assocCb)->nxtOutStrmId;                            \
         ++((_assocCb)->nxtOutStrmId);                                    \
      }                                                                   \
   }                                                                      \
}



#endif    /* ZG */
#endif    /* GCP_PROV_SCTP */



/*
 *   The following macro is called at the GWY side whenever it
 *   receives a SvcChgReply msg from the MGC without a MgcIdToTry
 *   parameter. If MgcIdToTry parameter is present, then just
 *   ignore the received version and continue with the normal
 *   processing (sending a new SvcChg to the MGC specified in the
 *   MgcIdToTry parameter).
 *   Negotiate MEGACO version on the GWY side. If the version received
 *   in the MEGACO msg is < our minimum version supported, close the
 *   transport association with the MGC and delete the peer. Start
 *   the peer disconnect procedures to start registration with the
 *   other MGCs in the configured list of MGCs.
 *   If the version received in the MEGACO msg is > the version we
 *   sent in the SvcChg msg (the current val of peer->mgcoInfo.
 *   negotiatedVersion), do the same deletion of association with the MGC.
 *   Otherwise, if the version received is within the bounds of our
 *   minimum version supported and the version we sent in the SvcChg
 *   msg, accept the SvcChgReply msg.
 *
 *   In case of rejection of the SvcChgReply msg, indicate the same
 *   to the user layer depending on initReg and ...
 *
 *   In case of acceptance the final negotiated version should be
 *   somehow indicated to the user.
 *
 */

#define MG_NEGOTIATE_VERSION_GWY_SIDE(_rcvdVer,_ssap,_peer,_errAction,_msgInfo)   \
{                                                                         \
   if (((_rcvdVer) < (((_ssap)->ssapCfg.minMgcoVersion) & LMG_GET_MGCO_VER)) || \
       ((_rcvdVer) > ((_peer)->mgcoInfo.negotiatedVersion)))              \
   {                                                                      \
      if ((_msgInfo) & MG_SELF_INIT)                                      \
      {                                                                   \
         mgBringPeerToCfgStatus((_peer), TRUE, TRUE);                     \
         mgIndicateAbortTxnToUsr(MGT_ERR_RESET_SSAP_TXN,                  \
                                 MG_INVALID_TRANSID, (_peer));            \
         /* mg008.105: Changed from MG_DISCARD_MSG */                     \
         *(_errAction) = MG_DISCARD_TXN;                                  \
         (_ssap)->crntMgc = NULLP;                                        \
         (_peer)->state = LMG_PEER_STATE_VER_UNSUPP;                      \
      }                                                                   \
      else                                                                \
      {                                                                   \
         *(_errAction) = MG_VER_UNSUPP;                                   \
         /**(_errAction) = MG_DELETE_PEER_PASS_TXN; */                    \
      }                                                                   \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      (_peer)->mgcoInfo.negotiatedVersion = (_rcvdVer);                   \
   }                                                                      \
}


/*
 *   The following macro is called at the MGC side whenever it
 *   receives a SvcChg msg from a GWY.
 *   Negotiate MEGACO version on the MGC side. If the version received
 *   in the MEGACO msg is < our minimum version supported, reject the
 *   SvcChg msg since we can NOT support that version.
 *   If the version received in the MEGACO msg is >= our maximum version
 *   supported, reply with the max version we support so as to give a
 *   chance to the MG to accept it.
 *   If the received version is within bounds, accept that version.
 *   The final negotiated version is stored in peer->mgcoInfo.negotiatedVersion.
 *
 *   The version stored in the peer should be used for sending all
 *   subsequent messages to that peer.
 *
 *   In case of acceptance the final negotiated version should be
 *   indicated to the user via the alarm called from MG_ISSUE_MGCOPEER_STAIND.
 *   A check to perform a v2 related version negotiation .If it is a first 
 *   service change message and message verion is not v1 we need to reject it.
 *   Please refer section 11.3 of H.248.v2
 *
 */
/* CHECK THe correct peer State */
/* #define MG_NEGOTIATE_VERSION_MGC_SIDE(_rcvdVer,_ssapCfg,_peer,_errAction,_rspCode,mgcoMsgVersion)   \ */
    /* if(_peer->state == LMG_PEER_STATE_REGISTER )\ */
    /* {       \ */
     /* if(1!= mgcoMsgVersion)\ */
     /* {                     \ */
      /* *(_errAction) = MG_DISCARD_MSG; \ */
      /* *(_rspCode) = MGT_MGCO_RSP_CODE_VERSION_UNSUPP; \ */
      /* \) */
     /* }  \ */
    /* } */

#define MG_NEGOTIATE_VERSION_MGC_SIDE(_rcvdVer,_ssapCfg,_peer,_errAction,_rspCode)  \
{                                                                         \
                                                                     \
   if ((_rcvdVer) < (((_ssapCfg).minMgcoVersion) & LMG_GET_MGCO_VER))     \
   {                                                                      \
      *(_errAction) = MG_DISCARD_MSG;                                     \
      *(_rspCode) = MGT_MGCO_RSP_CODE_VERSION_UNSUPP;                     \
      RETVALUE(RFAILED);                                                  \
   }                                                                      \
   else if ((_rcvdVer) > (((_ssapCfg).maxMgcoVersion) & LMG_GET_MGCO_VER))\
   {                                                                      \
      (_peer)->mgcoInfo.negotiatedVersion =                               \
         (((_ssapCfg).maxMgcoVersion) & LMG_GET_MGCO_VER);                \
   }                                                                      \
   else                                                                   \
   {                                                                      \
      (_peer)->mgcoInfo.negotiatedVersion = (_rcvdVer);                   \
   }                                                                      \
}
/* Ch Macros */
#ifdef GCP_CH
#define CH_FREE_MGCOTXN(_txn)                                            \
{                                                                        \
   mgFreeEventMem ((PTR *) _txn);                                        \
}

#define CH_FREE_MGCOMSG_WITH_TXN(_msg)                                   \
{                                                                        \
   mgFreeEventMem ((PTR *) _msg->body.u.tl.txns[0]);                     \
   mgFreeEventMem ((PTR *) _msg);                                        \
}

#define CH_FREE_MGCOMSG(_msg)                                            \
{                                                                        \
   mgFreeEventMem ((PTR *) _msg);                                        \
}                                                                        \

#define CH_CHK_NOTPRSNT(_pres, _err, _errNum)                            \
{                                                                         \
   if (_pres == NOTPRSNT)                                                  \
   {                                                                      \
      *_err = _errNum;                                                     \
      RETVALUE (RFAILED);                                                 \
   }                                                                      \
}                                                                         \

#define CH_CP_TRANSID(_chCmd, _transId)                               \
      cmMemcpy ((U8 *) &(_chCmd.transId), (U8 *) &(_transId),       \
                sizeof(MgMgcoTransId)); 
 

#ifdef GCP_VER_2_1
#define CH_CP_SEG_INFO(_chBlk, _reply)                                \
    cmMemcpy ((U8 *) &(_chBlk.segNum), (U8 *) &(_reply->segNum),      \
              sizeof(MgMgcoSegNum));                                  \
                                                                        \
    cmMemcpy ((U8 *) &(_chBlk.segCmpl), (U8 *) &(_reply->segCmpl),    \
              sizeof(MgMgcoSegCmpl));                                  
#else
#define CH_CP_SEG_INFO(_chBlk, _reply)
#endif  /* GCP_VER_2_1 */


#define CH_CP_IND_TRANSID(_chInd, _transId)                               \
      cmMemcpy ((U8 *) &(_chInd.transId), (U8 *) &(_transId),       \
                sizeof(MgMgcoTransId)); 
#define CH_CP_IND_PEERID(_chInd, _peerId)                               \
      _chInd.peerId.pres = PRSNT_NODEF;                              \
      _chInd.peerId.val = _peerId;                              \
      

#define CH_SET_IND_ERRDESC(_chInd, _errorCode)                               \
      _chInd.err.pres.pres = PRSNT_NODEF;                           \
      MG_CH_INIT_TOKEN_VALUE(&(_chInd.err.code),_errorCode)
 
#define CH_SET_IND_TXN_PEND(_chInd)                                 \
      _chInd.txnPending.pres = PRSNT_NODEF;                           
 
 
#define CH_CP_IND_ERRDESC(_chInd, _err)                               \
      cmMemcpy ((U8 *) &(_chInd.err), (U8 *) &(_err),       \
                sizeof(MgMgcoErrDesc)); 
 
#define CH_CP_CNTXTUPD_TRANSID(_cntxtUpd, _transId)                               \
      cmMemcpy ((U8 *) &(_cntxtUpd.transId), (U8 *) &(_transId),       \
                sizeof(MgMgcoTransId)); 
 
 
#define CH_CP_PEERID(_chCmd, _peerId)                               \
      cmMemcpy ((U8 *) &(_chCmd.peerId), (U8 *) &(_peerId),       \
                sizeof(U32)); 
 
#define CH_CP_CNTXTUPD_PEERID(_cntxtUpd, _peerId)                               \
      cmMemcpy ((U8 *) &(_cntxtUpd.peerId), (U8 *) &(_peerId),       \
                sizeof(U32)); 
 
 
#define CH_CP_CMDTYPE(_chCmd, _cmdType)                               \
      _chCmd.cmdType.val  =_cmdType;                                       \
      _chCmd.cmdType.pres = PRSNT_NODEF;                                       
 
#define CH_CP_CONTEXTID(_chCmd, _contextId)                               \
      cmMemcpy ((U8 *) &(_chCmd.contextId), (U8 *) &(_contextId),       \
                sizeof(MgMgcoContextId)); 
 
#define CH_CP_IND_CNTXTID(_chInd, _contextId)                               \
      cmMemcpy ((U8 *) &(_chInd.cntxtId), (U8 *) &(_contextId),       \
                sizeof(MgMgcoContextId)); 
 
#define CH_CP_CNTXTUPD_CONTEXTID(_cntxtUpd, _contextId)                               \
      cmMemcpy ((U8 *) &(_cntxtUpd.contextId), (U8 *) &(_contextId),       \
                sizeof(MgMgcoContextId)); 

#define CH_CP_CNTXTUPD_PROP(_cntxtUpd, _chCntxt)                       \
      if (_chCntxt->cxtProps.pres.pres != NOTPRSNT)                    \
      {                                                                \
        _cntxtUpd.contextProp.pres.pres = PRSNT_NODEF;                 \
        cmMemcpy ((U8 *) &(_cntxtUpd.contextProp.cxtProps),            \
                  (U8 *) &(_chCntxt->cxtProps),                        \
                sizeof(MgMgcoContextProps));                           \
      }                                                                \
      if (_chCntxt->cxtAud.pres.pres != NOTPRSNT)                      \
      {                                                                \
        _cntxtUpd.contextProp.pres.pres = PRSNT_NODEF;                 \
         cmMemcpy ((U8 *) &(_cntxtUpd.contextProp.cxtAudit),           \
                   (U8 *) &(_chCntxt->cxtAud),                         \
                sizeof(MgMgcoContextAudit));                           \
      }
 
#define CH_CP_CFMCMDREPLY(_chCmd, _cmdReply)                               \
         _chCmd.u.mgCmdCfm[0] = _cmdReply;
 
      /* cmMemcpy ((U8 *) &(_chCmd.u.mgCmdCfm), (U8 *) (_cmdReply),       \ */
                /* sizeof(MgMgcoCmdReply));  */
 
#define CH_SET_CMDSTATUS(_chCmd, _status)                               \
        MG_CH_INIT_TOKEN_VALUE(&(_chCmd.cmdStatus), _status)       
 
#define CH_SET_CNTXTUPD_CMDSTATUS(_cntxtUpd, _status)                               \
        MG_CH_INIT_TOKEN_VALUE(&(_cntxtUpd.status), _status)       
 
#define CH_SET_PRESENT(_pres)                                           \
{                                                                       \
   _pres.pres = PRSNT_NODEF;                                            \
} 

#define MG_CH_GETMEM(_ptr, _len, _memCp)                                 \
{                                                                         \
   if (cmGetMem((_memCp), (_len), (Ptr *)&(_ptr)) != ROK)                 \
      RETVALUE(RFAILED);                                                  \
                                                                          \
   cmMemset((U8 *)(_ptr), (U8)0,  (PTR)(_len));                           \
}

#define MG_CH_COPY_STRUCT(_to, _from, _size)                             \
{                                                                         \
   cmMemcpy((U8 *)(_to), (CONSTANT U8 *)(_from), (_size));                \
}

/* macro to initialise TknU8 , TknS16, TknU16, TknU32...etc.  */
#define MG_CH_INIT_TOKEN_VALUE(_tkn, _val)                               \
{                                                                         \
   (_tkn)->pres = PRSNT_NODEF;                                            \
   (_tkn)->val  = (_val);                                                 \
}

#define MG_CH_COMPARE_TOKEN_VALUE(_tkn1, _tkn2)                          \
{                                                                         \
   if ((_tkn1)->pres != (_tkn2)->pres)                                    \
      RETVALUE(RFAILED);                                                  \
                                                                          \
   if ((_tkn1)->pres != NOTPRSNT)                                         \
   {                                                                      \
      if ((_tkn1)->val != (_tkn2)->val)                                   \
         RETVALUE(RFAILED);                                               \
   }                                                                      \
}

#define MG_CH_INIT_TKNSTROSXL(_tkn, _val, _len)                          \
{                                                                         \
   (_tkn)->pres = PRSNT_NODEF;                                            \
   (_tkn)->len  = (U16)(_len);                                            \
   (_tkn)->val  = (_val);                                                 \
}

#define MG_CH_INIT_TKNSTR(_tkn, _val, _len)                              \
{                                                                         \
   (_tkn)->pres = PRSNT_NODEF;                                            \
   (_tkn)->len  = (U8)(_len);                                             \
   cmMemcpy((U8 *)(_tkn)->val, (CONSTANT U8 *)(_val), (_len));            \
}

#define MG_CH_COMPARE_TKN_STRINGS(_tkn1, _tkn2)                          \
{                                                                         \
   if ((_tkn1)->pres != (_tkn2)->pres)                                    \
      RETVALUE(RFAILED);                                                  \
                                                                          \
   if ((_tkn1)->pres != NOTPRSNT)                                         \
   {                                                                      \
      if ((_tkn1)->len != (_tkn2)->len)                                   \
         RETVALUE(RFAILED);                                               \
                                                                          \
      if ((_tkn1)->len > 0)                                               \
      {                                                                   \
         if ((cmMemcmp((U8 *)((_tkn1)->val), (CONSTANT U8 *)((_tkn2)->val),\
                       (_tkn1)->len)) != 0)                               \
         {                                                                \
            RETVALUE(RFAILED);                                            \
         }                                                                \
      }                                                                   \
   }                                                                      \
}

#define MG_CH_INIT_TOKEN_BUF(_tkn, _mBuf)                                \
{                                                                         \
   (_tkn)->pres = PRSNT_NODEF;                                            \
   (_tkn)->val  = (_mBuf);                                                \
}

#endif /* GCP_CH */ 
 


#ifdef   GCP_PROV_MTP3

#define  MG_FILL_MTP_MID_FROM_DPC_BINARY(_mtpAddr,_dpc) \
{                                                \
   int   i;                                      \
   int shiftDpc=0;                                   \
   /* Shift the Peer Dpc by two bits as lower two bits are Network Indicator */ \
   shiftDpc =(_dpc << 2);                        \
   for(i=0; i<MG_DPC_LEN;i++)                    \
    {                                            \
    _mtpAddr[i] = (U8 ) ( shiftDpc >> 8*i );           \
    }                                            \
}    
#define  MG_FILL_MTP_DPC_FROM_MID_BINARY(_mtpAddr,_dpc) \
{                                                \
   U32   i;                                      \
   _dpc = 0;                                \
   for(i=0; i<MG_DPC_LEN;i++)                    \
    {                                            \
     _dpc |= (_mtpAddr.val[i] << 8*i);           \
    }                                            \
    _dpc = (_dpc >> 2);                            \
    }    

#define  MG_ISSUE_MTP_STS_REQ(_peer, _tsap)      \
{                                                \
   U32   tmrVal;                                 \
   U8              idx;                          \
   idx = MG_MTP_STSENQ_TMR - MG_PEER_TMR_BASE;           \
   tmrVal = (_tsap)->tsapCfg.mgMtpNwCfg.defStatusEnqTmr.val;   \
   if(((_tsap)->tsapCfg.mgMtpNwCfg.defStatusEnqTmr.enb) == TRUE) \
   {                                                         \
      mgStartTmr(MG_MTP_STSENQ_TMR,tmrVal,(PTR)_peer,        \
            &(_peer->mntInfo.tmr[idx]));                      \
   }                                                         \
   if((_tsap)->state == LMG_SAP_BND_ENB)                        \
   {                                                         \
     MgLiSntStaReq(&(_tsap->spPst),_tsap->tsapCfg.spId, _peer->accessInfo.commEnt.t.mtpCommEntity.mgcoMtpCb.peerDpc);   \
   }                                                                       \
}
#define MG_MTP_A2I(_str, _len, _val)                       \
{                                                           \
   U8 i;                                                    \
   U8 _base;                                                \
   U8 _start;                                               \
   _base = 10;                                              \
   _start = 0;                                              \
   (_val) = 0;                                              \
   if ((_str)[0] == '0')                                    \
   {                                                        \
      if ((_len) == 1)                                      \
         _base = 10;                                        \
      else if ((_str)[1] == 'x' || (_str)[1] == 'X')        \
      {                                                     \
         _base = 16;                                        \
         _start = 2;                                        \
      }                                                     \
      else                                                  \
      {                                                     \
         _base = 10; /* No support for octals */            \
         _start = 1;                                        \
      }                                                     \
   }                                                        \
   else                                                     \
   {                                                        \
      for (i = 0; i < (_len); i++)                          \
      {                                                     \
         if ( ((_str)[i] >= 'a' && (_str)[i] <= 'f') ||     \
              ((_str)[i] >= 'A' && (_str)[i] <= 'F')        \
            )                                               \
            {                                               \
               _base = 16;                                  \
            }                                               \
      }                                                     \
   }                                                        \
   if (_base == 10 || _base == 8)                           \
   {                                                        \
      for (i = _start; i < (_len); i++)                     \
      {                                                     \
         (_val) *= _base;                                   \
         (_val) += ((_str)[i] - '0');                       \
      }                                                     \
   }                                                        \
   else if (_base == 16)                                    \
   {                                                        \
      for (i = _start; i < (_len); i++)                     \
      {                                                     \
         (_val) *= _base;                                   \
         if ((_str)[i] >= '0' && (_str)[i] <= '9')          \
         {                                                  \
            (_val) += (_str)[i] - '0';                      \
         }                                                  \
         else if ((_str)[i] >= 'A' && (_str)[i] <= 'F')     \
         {                                                  \
            (_val) += (_str)[i] - 'A' + 10;                 \
         }                                                  \
         else if ((_str)[i] >= 'a' && (_str)[i] <= 'f')     \
         {                                                  \
            (_val) += (_str)[i] - 'a' + 10;                 \
         }                                                  \
         else                                               \
         {                                                  \
            break;                                          \
         }                                                  \
      }                                                     \
   }                                                        \
}


#define MG_FILL_MTP_DPC_FRM_MID_TEXT(_mid, _dpc)                    \
{                                                              \
   if(MGT_MID_MTPADDR == _mid->type.val)                       \
   {                                                           \
      if(PRSNT_NODEF == _mid->u.mtpAddr.pres)                   \
      {                                                        \
              MG_MTP_A2I((_mid)->u.mtpAddr.val, MG_DPC_LEN, _dpc)     \
      }                                                        \
   }                                                           \
}     

#define MG_MTP_I2A(_val, _str, _len)                        \
{                                                            \
   U8  _idx = 2*MG_DPC_LEN - 1;                                \
   (_len) = 0;                                               \
   do                                                        \
   {                                                         \
      (_str)[(_idx)] = (U8)((_val) % 10) + '0';              \
      (_idx)--;                                              \
      (_val) = (_val)/10;                                    \
      (_len)++;                                              \
   } while((_val));                                          \
}

#endif   /* GCP_PROV_MTP3 */                       

/* mg003.105: Added macro and define for utility function added in mp_util.c */ 
#define MG_GET_NUM_COMP(a) \
   ((U16)(((a)->pres != NOTPRSNT) ? (a)->val : 0))
#define MG_DYNLIST_GRANULARITY 1
 
/* mg009.105: Need to copy only Length of mid number of bytes */     
#define MG_GET_IP_FROM_IPPORT(_peer, _mgcoMsg, _srcAddr, _ssap, _sendUpd) \
{                                                            \
   U8 idx;                                                   \
   TknStrOSXL mid;                                           \
   S16 retVal;                                               \
   MGGETMEM((Ptr *)&(mid.val), _mgcoMsg->mid.len,            \
                        (Ptr)_mgcoMsg, retVal);              \
   mid.pres = PRSNT_NODEF;                                   \
   for( idx=0; idx < _mgcoMsg->mid.len; idx++)        \
   {                                                         \
      if(_mgcoMsg->mid.val[idx] == ':')                      \
      {                                                      \
         mid.val[idx] = '\0';                                \
         break;                                              \
      }                                                      \
      mid.val[idx] = _mgcoMsg->mid.val[idx];                 \
   }                                                         \
   mid.len = idx;                                            \
   _peer = mgGetPeer(&mid, _srcAddr, NULLP, _ssap,           \
                                    &_sendUpd);              \
}    

/* mg011.105: Added macro to set MGT_MGCO_RSP_CODE_RSRC_ERROR 
 * in error response */
#ifdef GCP_ASN
#define MG_SET_ERR_RSP_CODE(_rspCode, _encScheme)            \
{                                                            \
   if (_encScheme  == LMG_ENCODE_BIN)                        \
   {                                                         \
      if(err.code == MG_ASN_RES_ERR)                         \
      {                                                      \
         _rspCode = MGT_MGCO_RSP_CODE_RSRC_ERROR;            \
      }                                                      \
   }                                                         \
   else if (_encScheme  == LMG_ENCODE_TXT)                   \
   {                                                         \
      if(err.code == CM_ABNF_ERR_RESFAIL)                    \
      {                                                      \
         _rspCode = MGT_MGCO_RSP_CODE_RSRC_ERROR;            \
      }                                                      \
   }                                                         \
}
#endif /* GCP_ASN */

/* mg013.105: Added new macro for filling the error code
 * and idNum in encCp for ABNF Grammar */
#define MG_SET_ERR_CODE_RET_FAIL(_code, _idNum, _err)        \
{                                                           \
   _err->code  = _code;                                     \
   _err->idNum = _idNum;                                    \
   RETVALUE(CM_ABNF_RFAILED);                               \
}  

#ifdef GCP_VER_2_1
#define MG_CHECK_ATMOST_ONCE_AMM_DESC(_val, _isFailed, _atMostOnceDescBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_MEDIADESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIADESC))       \
            _atMostOnceDescBit |= MG_BIT_MEDIADESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMDESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MODEMDESC))       \
            _atMostOnceDescBit |= MG_BIT_MODEMDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MUXDESC:                                     \
         if(!(_atMostOnceDescBit & MG_BIT_MUXDESC))         \
            _atMostOnceDescBit |= MG_BIT_MUXDESC;           \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_REQEVTDESC:                                  \
         if(!(_atMostOnceDescBit & MG_BIT_REQEVTDESC))      \
            _atMostOnceDescBit |= MG_BIT_REQEVTDESC;        \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVBUFDESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_EVBUFDESC))       \
            _atMostOnceDescBit |= MG_BIT_EVBUFDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGNALSDESC:                                 \
         if(!(_atMostOnceDescBit & MG_BIT_SIGNALSDESC))     \
            _atMostOnceDescBit |= MG_BIT_SIGNALSDESC;       \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_DIGMAPDESC:                                  \
         if(!(_atMostOnceDescBit & MG_BIT_DIGMAPDESC))      \
            _atMostOnceDescBit |= MG_BIT_DIGMAPDESC;        \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_AUDITDESC:                                   \
        if(!(_atMostOnceDescBit & MG_BIT_AUDITDESC))        \
            _atMostOnceDescBit |= MG_BIT_AUDITDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_STATSDESC:                                   \
        if(!(_atMostOnceDescBit & MG_BIT_STATSDESC))        \
            _atMostOnceDescBit |= MG_BIT_STATSDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}
#else
#define MG_CHECK_ATMOST_ONCE_AMM_DESC(_val, _isFailed, _atMostOnceDescBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_MEDIADESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIADESC))       \
            _atMostOnceDescBit |= MG_BIT_MEDIADESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMDESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MODEMDESC))       \
            _atMostOnceDescBit |= MG_BIT_MODEMDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MUXDESC:                                     \
         if(!(_atMostOnceDescBit & MG_BIT_MUXDESC))         \
            _atMostOnceDescBit |= MG_BIT_MUXDESC;           \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_REQEVTDESC:                                  \
         if(!(_atMostOnceDescBit & MG_BIT_REQEVTDESC))      \
            _atMostOnceDescBit |= MG_BIT_REQEVTDESC;        \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVBUFDESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_EVBUFDESC))       \
            _atMostOnceDescBit |= MG_BIT_EVBUFDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGNALSDESC:                                 \
         if(!(_atMostOnceDescBit & MG_BIT_SIGNALSDESC))     \
            _atMostOnceDescBit |= MG_BIT_SIGNALSDESC;       \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_DIGMAPDESC:                                  \
         if(!(_atMostOnceDescBit & MG_BIT_DIGMAPDESC))      \
            _atMostOnceDescBit |= MG_BIT_DIGMAPDESC;        \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_AUDITDESC:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_AUDITDESC))       \
            _atMostOnceDescBit |= MG_BIT_AUDITDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}
#endif /* GCP_VER_2_1 */

/* mg002.201: Support for multiple stream parameters in media descriptor */
#ifdef GCP_VER_2_1
#define MG_CHECK_ATMOST_ONCE_MEDIAPAR_LST(_val, _isFailed, _atMostOnceDescBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_MEDIAPAR_LOCCTL:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_LOCCTL))       \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_LOCCTL;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_LOCAL:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_LOCAL))       \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_LOCAL;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_REMOTE:                                     \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_REMOTE))         \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_REMOTE;           \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_STRPAR:                             \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_TERMST:                             \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_TERMST)) \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_TERMST;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_STATSDESC:                          \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_STATSDESC)) \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_STATSDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}
#else
#define MG_CHECK_ATMOST_ONCE_MEDIAPAR_LST(_val, _isFailed, _atMostOnceDescBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_MEDIAPAR_LOCCTL:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_LOCCTL))       \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_LOCCTL;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_LOCAL:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_LOCAL))       \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_LOCAL;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_REMOTE:                                     \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_REMOTE))         \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_REMOTE;           \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_STRPAR:                             \
         break;                                             \
                                                            \
      case MGT_MEDIAPAR_TERMST:                             \
         if(!(_atMostOnceDescBit & MG_BIT_MEDIAPAR_TERMST)) \
            _atMostOnceDescBit |= MG_BIT_MEDIAPAR_TERMST;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}
#endif /* GCP_VER_2_1 */

#define MG_CHECK_ATMOST_ONCE_LCLCTL_DESC(_val, _isFailed, _atMostOnceDescBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_LCLCTL_MODE:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_LCLCTL_MODE))       \
            _atMostOnceDescBit |= MG_BIT_LCLCTL_MODE;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_LCLCTL_RESVAL:                               \
         if(!(_atMostOnceDescBit & MG_BIT_MGT_LCLCTL_RESVAL)) \
            _atMostOnceDescBit |= MG_BIT_MGT_LCLCTL_RESVAL;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_LCLCTL_RESGRP:                               \
         if(!(_atMostOnceDescBit & MG_BIT_MGT_LCLCTL_RESGRP)) \
            _atMostOnceDescBit |= MG_BIT_MGT_LCLCTL_RESGRP;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_LCLCTL_PROPPARM:                             \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#ifdef GCP_ABNF_ATMOST_ONCE
#define MG_CHECK_ATMOST_ONCE_TERMSTPAR_LST(_val, _isFailed, _atMostOnceDescBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_TERMST_EVTBUFCTL:                                   \
         if(!(_atMostOnceDescBit & MG_BIT_MGT_TERMST_EVTBUFCTL))       \
            _atMostOnceDescBit |= MG_BIT_MGT_TERMST_EVTBUFCTL;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_TERMST_SVCST:                               \
         if(!(_atMostOnceDescBit & MG_BIT_MGT_MGT_TERMST_SVCST)) \
            _atMostOnceDescBit |= MG_BIT_MGT_MGT_TERMST_SVCST;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_TERMST_PROPLST:                             \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#define MG_CHECK_ATMOST_ONCE_MODEMTYPE_LST(_val, _isFailed, _atMostOnceBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_MODEMTYPE_V32BIS:                                   \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V32BIS))       \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V32BIS;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V22BIS:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V22BIS)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V22BIS;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V18:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V18)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V18;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V22:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V22)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V22;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V32:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V32)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V32;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V34:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V34)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V34;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V90:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V90)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V90;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_V91:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_V91)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_V91;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMTYPE_SYNCHISDN:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMTYPE_SYNCHISDN)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMTYPE_SYNCHISDN;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#define MG_CHECK_ATMOST_ONCE_AUDITEM_LST(_val, _isFailed, _atMostOnceBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_ERRDESC:                                   \
         if(!(_atMostOnceBit & MG_BIT_MGT_ERRDESC))       \
            _atMostOnceBit |= MG_BIT_MGT_ERRDESC;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MEDIADESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MEDIADESC)) \
            _atMostOnceBit |= MG_BIT_MGT_MEDIADESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MODEMDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MODEMDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_MODEMDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_MUXDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MUXDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_MUXDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_REQEVTDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_REQEVTDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_REQEVTDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVBUFDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MGT_EVBUFDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_MGT_EVBUFDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGNALSDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_MGT_SIGNALSDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_MGT_SIGNALSDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_DIGMAPDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_DIGMAPDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_DIGMAPDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_OBSEVTDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_OBSEVTDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_OBSEVTDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_STATSDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_STATSDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_STATSDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_PKGSDESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_PKGSDESC)) \
            _atMostOnceBit |= MG_BIT_MGT_PKGSDESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_INDAUD_TERMAUDDESC:                               \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#ifdef GCP_VER_2_1
#define MG_CHECK_ATMOST_ONCE_EVTPAR_LST(_val, _isFailed, _atMostOnceBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_EVTPAR_STREAMID:                                   \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_STREAMID))       \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_STREAMID;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_EMBEDWITHSIG:                               \
      case MGT_EVTPAR_EMBEDNOSIG:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_EMBEDWITHSIG)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_EMBEDWITHSIG;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_DIGMAP:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_DIGMAP)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_DIGMAP;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_KEEPACTIVE:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_KEEPACTIVE)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_KEEPACTIVE;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_NOTIFY_BEHV:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_NOTIFY_BEHV)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_NOTIFY_BEHV;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_RST_EVT_DESC:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_RST_EVT_DESC)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_RST_EVT_DESC;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_OTHER:                             \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#define MG_CHECK_ATMOST_ONCE_SIGPAR_LST(_val, _isFailed, _atMostOnceBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_SIGPAR_STREAMID:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_STREAMID)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_STREAMID;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_TYPE:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_TYPE)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_TYPE;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_DURATION:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_DURATION)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_DURATION;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_NTFYCMPL:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_NTFYCMPL)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_NTFYCMPL;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_KEEPACTIVE:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_KEEPACTIVE)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_KEEPACTIVE;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_DIR:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_DIR)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_DIR;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_REQID:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_REQID)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_REQID;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_INTSIGDELAY:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_INTSIGDELAY)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_INTSIGDELAY;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_OTHER:                             \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#else
#define MG_CHECK_ATMOST_ONCE_EVTPAR_LST(_val, _isFailed, _atMostOnceBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_EVTPAR_STREAMID:                                   \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_STREAMID))       \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_STREAMID;         \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_EMBEDWITHSIG:                               \
      case MGT_EVTPAR_EMBEDNOSIG:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_EMBEDWITHSIG)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_EMBEDWITHSIG;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_DIGMAP:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_DIGMAP)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_DIGMAP;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_KEEPACTIVE:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_EVTPAR_KEEPACTIVE)) \
            _atMostOnceBit |= MG_BIT_MGT_EVTPAR_KEEPACTIVE;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_EVTPAR_OTHER:                             \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#define MG_CHECK_ATMOST_ONCE_SIGPAR_LST(_val, _isFailed, _atMostOnceBit)       \
{                                                           \
   switch(_val)                                             \
   {                                                        \
      case MGT_SIGPAR_STREAMID:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_STREAMID)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_STREAMID;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_TYPE:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_TYPE)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_TYPE;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_DURATION:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_DURATION)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_DURATION;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_NTFYCMPL:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_NTFYCMPL)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_NTFYCMPL;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_KEEPACTIVE:                               \
         if(!(_atMostOnceBit & MG_BIT_MGT_SIGPAR_KEEPACTIVE)) \
            _atMostOnceBit |= MG_BIT_MGT_SIGPAR_KEEPACTIVE;   \
         else                                               \
            _isFailed = TRUE;                               \
         break;                                             \
                                                            \
      case MGT_SIGPAR_OTHER:                             \
         break;                                             \
                                                            \
      default:                                              \
            _isFailed = TRUE;                               \
         break;                                             \
   }                                                        \
}

#endif /* GCP_VER_2_1 */

#endif /* GCP_ABNF_ATMOST_ONCE */

#ifdef GCP_PROV_SCTP
#define MG_GETSRCADDR_FRM_TPT_INFO(_srcAddr, _tptInfo)  \
   if(_tptInfo->tptType == LMG_TPT_SCTP)                \
    _srcAddr = _tptInfo->u.sctpInfo.srcAddr;            \
   else if( (_tptInfo->tptType == LMG_TPT_TCP) ||      \
            (_tptInfo->tptType == LMG_TPT_UDP))         \
    _srcAddr = _tptInfo->u.utInfo.srcAddr;              
#else /* GCP_PROV_SCTP */
#define MG_GETSRCADDR_FRM_TPT_INFO(_srcAddr, _tptInfo)  \
    if( (_tptInfo->tptType == LMG_TPT_TCP) ||           \
        (_tptInfo->tptType == LMG_TPT_UDP))             \
         _srcAddr = _tptInfo->u.utInfo.srcAddr;
#endif  

#define MG_GET_SUCONID_FRM_TPT_INFO(_uConnId, _tptInfo)  \
    if((_tptInfo->tptType == LMG_TPT_TCP)  ||           \
       (_tptInfo->tptType == LMG_TPT_UDP))              \
       _uConnId = _tptInfo->u.utInfo.srvr->suConnId;

#ifdef GCP_PROV_SCTP    
#define MG_GET_ASSOCCB_FRM_TPT_INFO(_msgBuf, _tptInfo)  \
    if(_tptInfo->tptType == LMG_TPT_SCTP)               \
    {                                                   \
       _msgBuf->assoc = _tptInfo->u.sctpInfo.assocCb;   \
       _msgBuf->ctxId = _tptInfo->u.sctpInfo.ctxtId;   \
    }                                                   \
    else                                                \
       _msgBuf->assoc = NULLP;
#else
#define MG_GET_ASSOCCB_FRM_TPT_INFO(_msgBuf, _tptInfo)
#endif /* GCP_PROV_SCTP */


#ifdef GCP_PROV_MTP3
#define MG_GET_MTPINFO_FRM_TPT_INFO(_msgBuf, _tptInfo)  \
    if(_tptInfo->tptType == LMG_TPT_MTP3)                \
       _msgBuf->mgMtpInfo = _tptInfo->u.mtpInfo;
#else
#define MG_GET_MTPINFO_FRM_TPT_INFO(_msgBuf, _tptInfo)
#endif /* GCP_PROV_MTP3 */


#ifdef GCP_PROV_MTP3
#define MG_IS_TPT_IP_BASED(_tptInfo, _isIpTpt)  \
   _isIpTpt = (_tptInfo->tptType == LMG_TPT_MTP3)?FALSE:TRUE; 
#else /* GCP_PROV_MTP3 */
#define MG_IS_TPT_IP_BASED(_tptInfo, _isIpTpt)  \
    _isIpTpt = TRUE;
#endif



#ifdef GCP_PROV_SCTP
#define MG_GET_CONTEXT_ID(_msg, _tptInfo)  \
     if(_tptInfo->tptType == LMG_TPT_SCTP)  \
        mgExtractCtxIdFrmMsg(_msg, &(_tptInfo->u.sctpInfo.ctxtId));
#else
#define MG_GET_CONTEXT_ID(_msg, _tptInfo)
#endif /* GCP_PROV_SCTP */

#ifdef GCP_PROV_SCTP
#define MG_SET_SCTP_UNORDERED_FLAG(_tptInfo, _flag, _msg)   \
     if(_tptInfo->tptType == LMG_TPT_SCTP)                  \
     {                                                        \
       if(_msg != NULLP)                                      \
       {                                                      \
          _tptInfo->u.sctpInfo.unordered = _msg->unorder;     \
       }                                                      \
       else                                                   \
          _tptInfo->u.sctpInfo.unordered = _flag;             \
     }
#else
#define MG_SET_SCTP_UNORDERED_FLAG(_tptInfo, _flag, _msg)
#endif

#ifdef GCP_PROV_SCTP
#define MG_SET_CTXTID_NP(_tptInfo)  \
   if(_tptInfo->tptType == LMG_TPT_SCTP)                  \
     _tptInfo->u.sctpInfo.ctxtId.pres = NOTPRSNT;
#else
   #define MG_SET_CTXTID_NP(_tptInfo)
#endif

#ifdef GCP_PROV_MTP3
#define MG_NOT_USE_MTP_TPT_INFO(_tptInfo)   \
  if(_tptInfo->tptType == LMG_TPT_MTP3)                  \
     _tptInfo->u.mtpInfo.useTptInfo = FALSE;  

#define MG_USE_MTP_TPT_INFO(_tptInfo)       \
  if(_tptInfo->tptType == LMG_TPT_MTP3)                  \
     _tptInfo->u.mtpInfo.useTptInfo = TRUE;

#else
#define MG_NOT_USE_MTP_TPT_INFO(_tptInfo)
#define MG_USE_MTP_TPT_INFO(_tptInfo)
#endif



#ifdef GCP_PROV_SCTP
#define MG_IS_NEW_CONN_REQD(_tptInfo, _newConReqd)     \
    if(_tptInfo->tptType == LMG_TPT_SCTP)              \
    {                                                  \
       if(_tptInfo->u.sctpInfo.assocCb)                \
       {                                               \
          _newConReqd = TRUE;                          \
       }                                               \
    }                                                  \
    else if((_tptInfo->tptType == LMG_TPT_TCP) ||      \
            (_tptInfo->tptType == LMG_TPT_UDP))        \
    {                                                  \
       if((_tptInfo->u.utInfo.srvr) &&                   \
          (_tptInfo->u.utInfo.srvr->transportType == LMG_TPT_TCP))  \
       {                                               \
          _newConReqd = TRUE;                          \
       }                                               \
    }
#else
#define MG_IS_NEW_CONN_REQD(_tptInfo, _newConReqd)     \
    if((_tptInfo->tptType == LMG_TPT_TCP) ||           \
       (_tptInfo->tptType == LMG_TPT_UDP))             \
    {                                                  \
       if((_tptInfo->u.utInfo.srvr) &&                 \
          ( _tptInfo->u.utInfo.srvr->transportType == LMG_TPT_TCP))  \
       {                                               \
          _newConReqd = TRUE;                          \
       }                                               \
    }
#endif

#ifdef GCP_PROV_SCTP
#define MG_UPDATE_ASSOC_PEER(_tptInfo)                          \
   if(_tptInfo->tptType == LMG_TPT_SCTP)                        \
   {                                                            \
      _tptInfo->u.sctpInfo.assocCb->peer = _tptInfo->peer;      \
      _tptInfo->peer->accessInfo.commEnt.t.ipCommEntity.t.      \
       sctpCommEntity.assocCb = _tptInfo->u.sctpInfo.assocCb;   \
      if(_tptInfo->u.sctpInfo.assocCb->assocCfg)                \
      {                                                         \
         if(_tptInfo->peer->accessInfo.commEnt.t.ipCommEntity.t.  \
             sctpCommEntity.assocCfg == NULLP)                  \
         {                                                      \
           _tptInfo->peer->accessInfo.commEnt.t.ipCommEntity.t.  \
                         sctpCommEntity.assocCfg =              \
                  _tptInfo->u.sctpInfo.assocCb->assocCfg;       \
         }                                                      \
         _tptInfo->peer->mgcoInfo.origSrvcChngPort =            \
                     _tptInfo->u.sctpInfo.assocCb->assocCfg->remPort;   \
      }                                                         \
   }
#else
#define MG_UPDATE_ASSOC_PEER(_tptInfo)
#endif /* GCP_PROV_SCTP */

#ifdef GCP_PROV_SCTP
#define MG_FILL_TPT_WITH_SCTP(_tptInfo, _msgBuf, _srcAddr)    \
   if(_msgBuf->tptType == LMG_TPT_SCTP)                       \
   {                                                          \
       _tptInfo.tptType            = LMG_TPT_SCTP;            \
       _tptInfo.u.sctpInfo.assocCb = _msgBuf->assoc;          \
       cmMemcpy((U8 *)&_srcAddr, (U8 *)&msgBuf->srcAddr,      \
                                    sizeof(CmTptAddr));       \
       _tptInfo.u.sctpInfo.srcAddr = &_srcAddr;               \
       _tptInfo.peer               = _msgBuf->peer;           \
   }
#else
#define MG_FILL_TPT_WITH_SCTP(_tptInfo, _msgBuf, _srcAddr)
#endif /* GCP_PROV_SCTP */


#ifdef GCP_PROV_MTP3
#define MG_FILL_TPT_WITH_MTP(_tptInfo, _msgBuf)           \
    if(_msgBuf->tptType == LMG_TPT_MTP3)                  \
    {                                                     \
       _tptInfo.tptType        = LMG_TPT_MTP3;            \
       _tptInfo.u.mtpInfo      = _msgBuf->mgMtpInfo;      \
       _tptInfo.peer           = _msgBuf->peer;           \
    }
#else
#define MG_FILL_TPT_WITH_MTP(_tptInfo, _msgBuf)
#endif

#define MG_FILL_TPT_WITH_TCP_UDP(_tptInfo, _msgBuf, _srcAddr)    \
    if((_msgBuf->tptType == LMG_TPT_TCP) ||                      \
       (_msgBuf->tptType == LMG_TPT_UDP))                        \
    {                                                            \
       MG_GET_SRVRCB(_tptInfo.u.utInfo.srvr,(_msgBuf->suConnId), \
                                               _msgBuf->tsap);   \
       cmMemcpy((U8 *)&srcAddr, (U8 *)&msgBuf->srcAddr,          \
                                    sizeof(CmTptAddr));          \
       _tptInfo.u.utInfo.srcAddr = &_srcAddr;                    \
       _tptInfo.peer             = _msgBuf->peer;                \
       _tptInfo.tptType          = _msgBuf->tptType;             \
    }


#ifdef GCP_PROV_SCTP
#define MG_FILL_MGCO_TPT(_tptAddr, _peer, _srvr, _mgcoTptInfo)  \
    _mgcoTptInfo.peer = _peer;                                  \
    if(_mgcoTptInfo.tptType == LMG_TPT_SCTP)                    \
    {                                                            \
      _mgcoTptInfo.u.sctpInfo.srcAddr = _tptAddr;                 \
      _mgcoTptInfo.u.sctpInfo.assocCb = _peer->accessInfo.commEnt.  \
                                        t.ipCommEntity.t.sctpCommEntity.  \
                                        assocCb;                \
    }                                                           \
    else if((_mgcoTptInfo.tptType == LMG_TPT_TCP) ||             \
            (_mgcoTptInfo.tptType == LMG_TPT_UDP))                \
    {                                                             \
      _mgcoTptInfo.u.utInfo.srvr      = _srvr;                    \
      _mgcoTptInfo.u.utInfo.srcAddr   = _tptAddr;                \
    }
#else
#define MG_FILL_MGCO_TPT(_tptAddr, _peer, _srvr, _mgcoTptInfo)  \
    _mgcoTptInfo.peer               = _peer;                    \
    if((_mgcoTptInfo.tptType == LMG_TPT_TCP) ||                 \
       (_mgcoTptInfo.tptType == LMG_TPT_UDP))                   \
    {                                                           \
      _mgcoTptInfo.u.utInfo.srvr      = _srvr;                  \
      _mgcoTptInfo.u.utInfo.srcAddr   = _tptAddr;               \
    }
#endif

#if (defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP))
#ifdef GCP_LCN_APP_USE
#define MG_CPY_LCN_TO_TPT_INFO(_tptInfo, _lcnInfoStruct)     \
    cmMemcpy((U8 *)&(_tptInfo.lcnInfo),                      \
             (CONSTANT U8 *)(&(_lcnInfoStruct->lcnInfo)),    \
             sizeof(MgMgtLcnInfo));
#else
#define MG_CPY_LCN_TO_TPT_INFO(_tptInfo, _lcnInfo)
#endif
#else
#define MG_CPY_LCN_TO_TPT_INFO(_tptInfo, _lcnInfo)
#endif /* defined(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP) */

#define MG_ADD_TCP_CON_TO_PEER_LST(_mgcoTptInfo, _peer)   \
    if (((_mgcoTptInfo->tptType == LMG_TPT_TCP) ||         \
         (_mgcoTptInfo->tptType == LMG_TPT_UDP))&&         \
         (_mgcoTptInfo->u.utInfo.srvr) &&                  \
         (_mgcoTptInfo->u.utInfo.srvr->srvrType ==         \
                     MG_TCP_CLIENT_CONNECTION) &&         \
         (_mgcoTptInfo->u.utInfo.srvr->t.peer == NULLP))   \
    {                                                     \
         _mgcoTptInfo->u.utInfo.srvr->t.peer = _peer;   \
         _mgcoTptInfo->u.utInfo.srvr->lstnrNode.node = \
                                       (PTR)_mgcoTptInfo->u.utInfo.srvr; \
         cmLListAdd2Tail (&(_peer->accessInfo.commEnt.t.                   \
                            ipCommEntity.t.tcpCommEntity.tcpConnLst),     \
                          &(_mgcoTptInfo->u.utInfo.srvr->lstnrNode));        \
         _peer->mgcoInfo.numActvConn++;                                    \
         if (_peer->accessInfo.commEnt.t.ipCommEntity.t.tcpCommEntity.     \
                                                  nxtUseConn == NULLP)   \
             _peer->accessInfo.commEnt.t.ipCommEntity.t.tcpCommEntity.      \
                                nxtUseConn = _mgcoTptInfo->u.utInfo.srvr;   \
         if (_mgcoTptInfo->u.utInfo.srvr->idleTmr.tmrEvnt ==               \
                                                MG_IDLE_CONN_TMR)       \
         {                                                                \
            mgStopTmr(MG_IDLE_CONN_TMR, (PTR)_mgcoTptInfo->u.utInfo.srvr,  \
                     &(_mgcoTptInfo->u.utInfo.srvr->idleTmr));             \
         }                                                                \
    }

#define MG_GET_ORIG_TCP_UDP_PORT(_mgcoTptInfo)     \
   if (((_mgcoTptInfo->tptType == LMG_TPT_UDP) ||  \
        (_mgcoTptInfo->tptType == LMG_TPT_TCP))&&  \
        (_mgcoTptInfo->u.utInfo.srvr))             \
   {                                              \
       MG_FILL_PORT_FRM_TPTADDR(_mgcoTptInfo->peer->mgcoInfo.  \
               origSrvcChngPort, &(_mgcoTptInfo->u.utInfo.     \
               srvr->tptAddr));                                \
   }


#define MG_GET_PORT_FRM_SVC_ADDR(_remotePort, _svcChg)                \
   if (_svcChg->u.svcChgReq->parm.addr.type.pres == PRSNT_NODEF)      \
   {                                                                  \
       MgMgcoMid       *mid;                                          \
       mid = &(_svcChg->u.svcChgReq->parm.addr);                      \
       if (_svcChg->u.svcChgReq->parm.addr.type.val == MGT_MID_PORT)  \
       {                                                              \
           _remotePort = mid->u.port.val;                             \
       }                                                              \
       else if (_svcChg->u.svcChgReq->parm.addr.type.val ==           \
                MGT_MID_DADDRPORT)                                    \
       {                                                              \
           if (PRSNT_NODEF == mid->u.dAddrPort.port.pres)             \
               _remotePort = mid->u.dAddrPort.port.val;               \
       }                                                              \
       else if (_svcChg->u.svcChgReq->parm.addr.type.val ==           \
                MGT_MID_DNAMEPORT)                                    \
       {                                                              \
          if (PRSNT_NODEF == mid->u.dNamePort.port.pres)              \
              _remotePort = mid->u.dNamePort.port.val;                \
       }                                                              \
    }




#define MGACC_MAXBLKSIZE 2048

#ifdef SS_MULTIPLE_PROCS
#define EMGxxx EMG100
#ifndef MG_MAX_INSTANCES
#define MG_MAX_INSTANCES 1
#endif
#define mgCb (*mgGlobalCbPtr)
#endif  /* SS_MULTIPLE_PROCS */

#endif /* ifndef __MGH__ */

/********************************************************************30**
 
End of file:     mg.h@@/main/7 - Wed Nov 14 22:43:38 2007
 
*********************************************************************31*/
/********************************************************************40**
 
        Notes:
 
*********************************************************************41*/
/********************************************************************50**
 
*********************************************************************51*/
 
/********************************************************************60**
 
        Revision history:
 
*********************************************************************61*/
 
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      bbk  1. Initial release.
1.2          ---      bbk  1. Define cmInetGetHostByName to 
                              mgInetGetHostByName for acceptance tests
1.2+        mg002.101  pk  1. Modified MG_ENA_DNS_LSTNR to accept 
                              tptParam as parameter.
                      bbk  2. Added  Macro MG_TRANSMIT_PDU.
                      bbk  3. Added defines for supporting UDP MTU 
                              Size Limitation.
            mg003.101 bbk  1. Fixed cmHashListFind arguments in
                              MG_FIND_PEER_FROM_DOMAIN_NAME while using
                              IP address. args 2 and 5 were wrong
                           2. Removed warning with Solaris C++ compiler (CC)
           mg004.101  bbk  1. Fixed MG_CHECK_TO_ENABLE_SSAP to remove check
                              for ssap state make bind event to SSAP 
                              independant of Control Request AENA for SSAP.
                              Implies SSAP bind can now happen after or
                              before AENA
            mg007.101 bbk   1. Added support for peerId being U32 under
                               GCP_ENHNC_1_2 compile time flag
/main/3      ---       pk   1. Added defines and macro support for MEGACO.
                            2. Added new defines and macros for MEGACO.
            mg004.102  bbk  1. Changed MG_FIND_PEER_FROM_DOMAIN_INFO macro. 
                               The macro is called upon to access two 
                               different lists, name and address based. In 
                               address based list, it should return address
                               entry and not peer entry directly. This was not
                               implemented correctly
            mg007.102   vj  1. Initialize the namePres field in the 
                               MgPeerInfo.dname while copying the peerInfo to 
                               indicate to SU.
                            2. Added MG_MGCOVER_1_0 define for MGCO version 
                               number for stack's internal use.
            mg010.102   vj  1. In MG_INIT_TCP_CONN() macro, the error path when
                               mgAllocSrvrCb returns RFAILED is incorrect. 
                               Corrected the error path of the code.
            mg011.102   vj  1. The macros MG_ISSUE_PEER_STAIND and 
                               MG_COPY_PEERINFO_INTO_TXN have been broken into 
                               MGCP & MGCO specific macros.
                            2. New macros MG_INIT_MID, MG_FILL_MID_IN_MSG and 
                               MG_FILL_TPTADDR_FRM_MID have been added.
                            3. Modified the macro MG_FIND_PEER_FROM_DOMAIN_INFO
                               to account for the MID change.
                            4. Added defines for indexes into MGCP profiles.
/main/4      ---      ra    1. GCP 1.3 release
            mg003.103  rg   1. Since genCfg.timeRes is the finest resolution
                               for the timer rto should not be less than it.
            mg004.103  rg   1. Fixed a typo in macro MG_CLEAR_MEM
                            2. Modified the macro for RTO calculation on
                               retransmission. 
            mg007.103  ra   1. The macro -
                               MG_FREE_RSRCS_ON_TXNREQ_ERROR
                               has been changed. In this macro, rxCb is not
                               being deallocated if the 30 sec timer has been
                               enabled. This will allow an outgoing response
                               rejected by the stack to be resent by the service
                               user. However, if the 30 sec timer has been
                               disabled, we are deallocating the rxCb because
                               not doing that may leave scope for hanging buffers.
            mg008.103  ra   1. cause is now being passed in the mgGenStaInd
                               function called in the macro MG_SEND_SRVR_STAIND.
                       rg   2. The minimum RTO is set equal to two times the
                               timer resolution to avoid expiry of timer in
                               less than period equal to timer resolution.
                       rg   3. Changed the values of MG_INVALID_PEERID and 
                               MG_INVALID_LSTNRID for valid checks for masked
                               peerID and lstnrID.
            mg010.103  ra   1. Added new hash define for peerflg
                                 - MG_HANDOFF_RQSTD_NO_MGCID
                                 - MG_DISCONNECTED_TO_MGC
                            2. Added new hash define for msgInfo field
                                 - MG_DISCONNECT
                            3. Added a new macro MG_OBTAIN_SVCCHG_METHOD to
                               determine if method used is RESTART or
                               DISCONNECT.
                            4. Added a new macro
                               MG_RESET_DISCON_BIT_IN_PEERLST
                               to reset the DISCONNECT bit in peerflg.
            mg011.103   ra  1. Enhanced the macros -
                               MG_FREE_MGCO_EVNT_MEM
                               MG_FREE_MGCP_EVNT_MEM
                               MG_FREE_EVNT_MEM
                               to free the TknBuf for the SDP string if the
                               flag CM_SDP_OPAQUE is defined.
                            2. Added MG_MSG_SZ_EXCEDED as an action value for 
                               indicating that encoded message exceeds MTU size
                            3. Added MG_CHK_MTU_SIZE macro
            mg017.103   ra  1. Enhanced the macro MG_FREE_RSRCS_ON_TXNREQ_ERROR
                               to ensure that the rxCb->mBuf gets re-initialized
                               to NULLP in case the mBuf is to be deleted.
/main/5      ---        ka  1. Changes for Release v 1.4
            mg005.104   ra  1. FTHA related changes. 
            mg008.104   ra  1. Added the following new macro defines -
                               MG_RESET_SSAP_PEERS_FOR_THIS_TSAP
                               MG_REM_SSAP_PEERS_FOR_THIS_TSAP
                               These macros work only on the tsap specified
                               in the parameter. This is required since
                               these macros are called from mgDisableTsap.
                               Also the first macro does not bring the peers
                               to cfg status if UDP is used as transport if
                               changeOver of TUCLs is under progress. Therefore
                               calls would not be lost for UDP. For connection
                               oriented transport, calls will be lost since
                               the transport connection is also lost.
/main/6      ---        pk 1. GCP 1.5 release
            mg002.105   ps 1. Problem in traversing the list.
                           2. Move lgd.h in ZG_DFTHA flag
                           3. Removed patch reference for 1.3 and 1.4
                           4. Typecasting for Warning Removal
            mg003.105   ps 1. Changer error code value of action variables
                        dp 2. New macro added to fill peer alarm info 
                        dp 3. Added macro and define for utility function
                              added in mp_util.c  
            mg004.105   gk 1. MG_MTP_STSENQ_TMR, MG_MTP_RSTEND_TMR Timer are
                              added in filling arguments 
                        gk 2. MG_SCRSN_MG_OOS service change is added
            mg005.105   gk 1. Added new state to support MG in lock/unlock state
            mg007.105   gk 1. Added code to retrieve error statistics
            mg008.105   gk 1. Removed memory leak
                           2. Added sanity check
            mg009.105   gk 1. Initialization value for number of failed
                              transactions for a peer
                           2. Need to copy only Length of mid number of bytes
            mg011.105   gk 1. Changes for FTHA
                           2. Added macro to set MGT_MGCO_RSP_CODE_RSRC_ERROR 
                              in error response
                           3. Added new define MG_RTO_MIN_GAIN_FACT to adjust 
                              RTO in case if it is less than Timer Resolution.
            mg012.105   gk 1. Passing timer event instead of loopIdx
                           2. RTO value rounded to the upper value
            mg013.105   gk 1. Added defines for ammRequest Descriptors to check
                              atmost once descriptor present in AmmDesc
            mg016.105   rb 1. Modified to support LCN Feature
                           2. Moved from mgasnwrap.h for proper compilation
            mg017.105   rb 1. Allow to send UDP/TCP packets in case of 
                              MTP3 flag enabled.
            mg018.105   gk 1. Passing timer event instead of loopIdx
            mg020.105   ac 1. Passing Timer event alone and not its sum with
                              MG_INTXN_TMR_BASE in mgStopTmr Function.            
/main/7      ---      pk   1. GCP 2.1 release
            mg002.201   gk 1. Support for multiple stream parameters in
                              media descriptor
            mg003.201   gk 1. Moved usrReason as argument to mgDeletePeer.
*********************************************************************91*/
