/*******************************************************************************
*
* Title: lmu.x
*
* Description: MU layer x file 
*
* Written By: Kapil Gupta (kgupta@sangoma.com)
*
* Date: 12-05-2012
*
*******************************************************************************/


#ifndef __LMUX__
#define __LMUX__


typedef struct muGenCfg         /* MEGACO app Inteface general configuration */
{
   U16 nmbSap;                 /* MAX number of MG SAPs  */
   Pst sm;                      /* stack manager */
} MuGenCfg;


typedef struct muSAPCfg        /* MG Sap Configuration structure */
{
   SuId         ssapId;             /* Sesstion Sap ID                 */
   SpId         spId;               /* service provider id             */
   Mem          mem;              /* lower interface memory id       */
   ProcId       dstProcId;          /* lower interface processor id    */
   Ent          dstEnt;             /* lower entity                    */
   Inst         dstInst;            /* lower interface instance        */
   Priority     dstPrior;           /* lower interface priority        */
   Route        dstRoute;           /* lower interface route           */
   Selector     selector;           /* lower interface selector        */
} MuSAP_t;

typedef struct muCntrl          /* MTP3 Upper Layer control structure                   */
{
   DateTime dt;           /* date and time */
   U8       action;             /* action                                   */
   U8       subAction;          /* sub action                               */
   U8 	   status;		/* status */
} MuCntrl;

typedef struct muUsta
{
#if (SI_LMINT3 || SMSI_LMINT3)
   CmAlarm        alarm;        /* alarm structure */
   U8 		  evntParm[8];        /* event parameters */		
#else /* LMINT2 */
   DateTime       dt;           /* date and time */
   U16            evnt;         /* event number */
#endif
} MuUsta;


typedef struct MuSta
{
	SuId     suId;
	uint32_t dpc;
	S16 congLevel;
} MuSta;

typedef struct muMngmt
{
   Header hdr;                  /* header */
   CmStatus cfm;
   union 
   {
      MuGenCfg 		cfg;   	   /* General Configuration */
      MuSAP_t 	        sapCfg;   /* MG SAP Config */
      MuCntrl 		cntrl; /* control */
      MuUsta   		usta;  /* unsolicited status */
      MuSta   		sta;  /* solicited status */
   }t;
} MuMngmt;


/* management message */

typedef S16 (*LmuStaInd) ARGS((Pst *pst, MuMngmt *sta));
typedef S16 (*LmuStaCfm) ARGS((Pst *pst, MuMngmt *sta));
typedef S16 (*LmuStsCfm) ARGS((Pst *pst, MuMngmt *sts));
typedef S16 (*LmuCfgReq) ARGS((Pst *pst, MuMngmt *cfg));
typedef S16 (*LmuStaReq) ARGS((Pst *pst, MuMngmt *cfg));
typedef S16 (*LmuStsReq) ARGS((Pst *pst, Action action, MuMngmt *sts));
typedef S16 (*LmuTrcInd) ARGS((Pst *pst, MuMngmt *trc));
typedef S16 (*LmuCntrlReq) ARGS((Pst *pst, MuMngmt *cntrl));
typedef S16 (*LmuCfgCfm) ARGS((Pst *pst, MuMngmt *cfg));
typedef S16 (*LmuCntrlCfm) ARGS((Pst *pst, MuMngmt *cfg));


EXTERN  S16 SmMiLmuStaInd ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 SmMiLmuStaCfm ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 SmMiLmuStsCfm ARGS((Pst *pst, MuMngmt *sts));
EXTERN  S16 SmMiLmuCfgReq ARGS((Pst *pst, MuMngmt *cfg));
EXTERN  S16 SmMiLmuStaReq ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 SmMiLmuStsReq ARGS((Pst *pst, Action action, MuMngmt *sts));
EXTERN  S16 SmMiLmuCntrlReq ARGS((Pst *pst, MuMngmt *cntrl));
EXTERN  S16 SmMiLmuTrcInd ARGS((Pst *pst, MuMngmt *trc));
EXTERN  S16 SmMiLmuCfgCfm ARGS((Pst *pst, MuMngmt *cfg));
EXTERN  S16 SmMiLmuCntrlCfm ARGS((Pst *pst, MuMngmt *cntrl));

EXTERN  S16 SmMiLmuStaInd ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 SmMiLmuStaCfm ARGS((Pst *pst, MuMngmt *sta));
EXTERN	S16 SmMiLmuStaReq ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 SmMiLmuStsReq ARGS((Pst *pst, Action action, MuMngmt *sts));
EXTERN  S16 SmMiLmuCntrlReq ARGS((Pst *pst, MuMngmt *cntrl));
EXTERN  S16 SmMiLmuTrcInd ARGS((Pst *pst, MuMngmt *trc));
EXTERN  S16 SmMiLmuCfgCfm ARGS((Pst *pst, MuMngmt *cfg));
EXTERN  S16 SmMiLmuCntrlCfm ARGS((Pst *pst, MuMngmt *cntrl));


EXTERN	S16 muActvInit ARGS((Ent entity, Inst inst, Region region, Reason reason));
EXTERN	S16 muActvTsk ARGS((Pst *pst, Buffer *mBuf));

EXTERN S16 smMuActvTsk ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smMuActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));

EXTERN	S16 MuMiLmuCfgReq ARGS((Pst *pst, MuMngmt *cfg));
EXTERN	S16 MuMiLmuCntrlReq ARGS((Pst *pst, MuMngmt *cntrl));
EXTERN	S16 MuLiSitBndCfm ARGS((Pst *pst, SuId suId, U8 status));
EXTERN	S16 MuMiLmuCfgCfm ARGS((Pst *pst, MuMngmt *cfm));
EXTERN	S16 MuMiLmuCntrlCfm ARGS((Pst *pst, MuMngmt *cfm));
EXTERN  S16 MuMiLmuStaCfm ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 MuMiLmuStsCfm ARGS((Pst *pst, Action action, MuMngmt *sts));
EXTERN  S16 MuMiLmuTrcInd ARGS((Pst *pst, MuMngmt *trc));

EXTERN	S16 MuMiLmuStaInd ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 MuMiLmuStaReq ARGS((Pst *pst, MuMngmt *sta));
EXTERN  S16 MuMiLmuStsReq ARGS((Pst *pst, Action action, MuMngmt *sts));

extern S16 cmPkLmuStaInd ARGS((Pst *pst, MuMngmt *sta));
extern S16 cmPkLmuStaCfm ARGS((Pst *pst, MuMngmt *sta));
extern S16 cmPkLmuStsCfm ARGS((Pst *pst, MuMngmt *sts));
extern S16 cmPkLmuTrcInd ARGS((Pst *pst, MuMngmt *trc));

extern S16 cmPkLmuCfgCfm ARGS((Pst *pst, MuMngmt *cfm));
extern S16 cmPkLmuCntrlCfm ARGS((Pst *pst, MuMngmt *cfm));

extern S16 cmUnpkLmuCntrlReq ARGS((LmuCntrlReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuStsReq ARGS((LmuStsReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuStaReq ARGS((LmuStaReq func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuCfgReq ARGS((LmuCfgReq func, Pst *pst, Buffer *mBuf));

extern S16 cmPkLmuCfgReq ARGS((Pst *pst, MuMngmt *cfg));
extern S16 cmPkLmuCntrlReq ARGS((Pst *pst, MuMngmt *cntrl));
extern S16 cmPkLmuStaReq ARGS((Pst *pst, MuMngmt *sta));
extern S16 cmPkLmuStsReq ARGS((Pst *pst, Action action, MuMngmt *sts));


extern S16 cmUnpkLmuStaCfm ARGS((LmuStaCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuStsCfm ARGS((LmuStsCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuStaInd ARGS((LmuStaInd func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuTrcInd ARGS((LmuTrcInd func, Pst *pst, Buffer *mBuf));

extern S16 cmUnpkLmuCfgCfm ARGS((LmuCfgCfm func, Pst *pst, Buffer *mBuf));
extern S16 cmUnpkLmuCntrlCfm ARGS((LmuCntrlCfm func, Pst *pst, Buffer *mBuf));

#endif /* __LWNX__ */
