
/*******************************************************************************
*
* Title: lmu.h
*
* Description: MEGACO User Layer Manager Interface layer h file 
*
* Written By: Kapil Gupta (kgupta@sangoma.com)
*
* Date: 12-05-2012
*
*******************************************************************************/

#ifndef __LMU_H__
#define __LMU_H__

/* MU Management Events */

#define EVTLMUCFGREQ     0x3c         /* Configuration request */
#define EVTLMUSTAREQ     0x40         /* Status request */
#define EVTLMUSTACFM     0x41         /* Status confirm */
#define EVTLMUSTAIND     0x42         /* Status indication */
#define EVTLMUSTSREQ     0x44         /* Statistics request */
#define EVTLMUSTSCFM     0x45         /* Statistics confirm */
#define EVTLMUTRCIND     0x48         /* Trace indication */
#define EVTLMUCNTRLREQ   0x4c         /* Control request */

#define EVTLMUCFGCFM     0x4d         /* Configuration confirm */
#define EVTLMUCNTRLCFM   0x4e         /* Control confirm */


/* Sap bind states */

#define LMU_UNBND            1   /* sap is unbound */
#define LMU_BND              2   /* sap is bound */
#define LMU_WAIT_BNDCFM      3   /* bind procedure is going on */

#define MAX_EVT_TRC_LENGTH 16

#define LMULOGERROR(errCls, errCode, errVal, errDesc) \
		SLogError(pst->srcEnt, pst->srcInst, pst->srcProcId, __FILE__, __LINE__, \
					errCls, errCode, errVal, errDesc)


#endif /* __LMU_H__ */
