/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/
/********************************************************************20**
 
     Name:    Layer management interface - GCP
 
     Type:    C header file
 
     Desc:    Structures, variables and typedefs required by GCP
              layer management interface
 
     File:    lmg.x
 
     Sid:      lmg.x@@/main/7 - Fri Dec 18 15:44:22 2009
 
     Prg:     pk
 
*********************************************************************21*/


#ifndef __LMGX__
#define __LMGX__
#ifdef __cplusplus
extern "C" {
#endif


/* include files */

/***********************************************************************
                          Configuration
 ***********************************************************************/

 
/***********************************************************************
                       General Configuration
 ***********************************************************************/

   /* 002.main_1: made rspAckEnb a reconfigurable parameter. Also added
    *            support for sending immediate rspAckRsp in MGCP */
typedef struct mgGenReCfg
{
   /* This is a bit map. If Bit0 is set GCP Layer (as MGCP) will
    * automatically send Response Ack for the final response rcvd
    * if the final rcvd response had an empty rspAck parameter.
    * If Bit1 is set then GCP layer (as MGCP ) will attach emptyRspAck
    * Parameter in final response. 
    * If Bit2 is set then GCP layer (as MGCP) will automatically send
    * Response Acks for all the final responses even if the final responses
    * do not have an empty rspAck parameter. Bit 2 is inclusive of Bit 0.
    * Therefore setting Bit 0 is irrelevant if Bit 2 has been set.
    *
    * If Bit4 is set then GCP layer (as MEGACO) will automatically send 
    * response Ack , if Bit5 is set then GCP Layer (as MEGACO) will set 
    * immAck */
   U8              rspAckEnb;
#if (defined(GCP_MGCO) && (defined GCP_VER_2_1))
   TmrCfg          segRspTmr;
   TmrCfg          segRspAckTmr;
#endif
} MgGenReCfg;

/* 003.main_1: Modify - moved defintion of mgMgcoPendingLimit from mg.x */
#ifdef GCP_PKG_MGCO_ROOT
/*New structure for holding the values of pending limit */
typedef struct mgMgcoPendingLimit
{
   TknPres              pres;               /* Present? */
   U32                  mgOriginatedPendingLimit;
   U32                  mgcOriginatedPendingLimit;
}MgMgcoPendingLimit;

#endif /* GCP_PKG_MGCO_ROOT */


typedef struct mgGenCfg 
{
   U16             maxSSaps;           /* max number of upper SAPs */


   /*
    *   maximum number of TSAPs - added to support multiple TSAPs
    */

   U32             maxTSaps;           /* max number of lower TSAPs */
   U32             maxServers;         /* max num of UDP/TCP servers PER TSAP */
   U32             maxConn;            /* max num of TCP conn PER TSAP */ 
   U32             maxTxn;             /* max ongoing transactions */ 
   U32             maxPeer;            /* max num of peers controlled */   
   Status          resThUpper;         /* resource threshold upper */
   Status          resThLower;         /* resource threshold lower */
   Pst             lmPst;              /* Post for layer manager */
   Ticks           timeRes;            /* time resolution for GCP */
#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   Ticks           timeResTTL;         /* DNS TTL time resolution timer */
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */
   /* 002.main_1: made rspAckRsp reconfigurable */
   MgGenReCfg      reCfg;
   U32             numBlks;            /* Num blocks for memory usage */
   Size            maxBlkSize;         /* MAx size of a block */
   U16             numBinsTxnIdHl;     /* for transaction id based list */
   U16             numBinsNameHl;      /* for name based list */
   U16             numBinsTptSrvrHl;   /* for name based list */
   U8              entType;            /* Local Entity Type */
   U8              indicateRetx;       /* Indicate Retransmission to User */
   U8              resOrder;           /* Order of resolution */
#ifdef CM_ABNF_MT_LIB
   Inst            noEDInst;           /* total no. of ED instances */
   Inst            firstInst;          /* first ED instance no */ 
   TmrCfg          edEncTmr;           /* encode timer */
   TmrCfg          edDecTmr;           /* decode timer */
#endif /* CM_ABNF_MT_LIB */
#ifdef GCP_CH
   U16             numBinsPeerCmdHl;       /* for Peer Cmd Ctl List     */
   U16             numBinsTransReqHl;      /* for Trans Req list        */
   U16             numBinsTransIndRspCmdHl;/* for For Trans IndRsp List */
#endif /* GCP_CH */
#ifdef GCP_MG
   TmrCfg          maxMgCmdTimeOut;        /* Maximum MG Command TimeOut*/
#endif /* GCP_MG */
 
#ifdef GCP_MGC
   TmrCfg          maxMgcCmdTimeOut;       /* Maximum MGc Command TimeOut*/
#endif /* GCP_MGC */

/* 003.main_1: Add - Added MgMgcoPendingLimit in MgGenCfg */
#ifdef GCP_PKG_MGCO_ROOT
   MgMgcoPendingLimit limit;           /* Pending Limit */
#endif /* GCP_PKG_MGCO_ROOT */

   /* lmg_x_006.main_1: Upper limit of failed transaction before
      peer is assumed to be down, to be configured by
      Layer Manager */
   /* lmg_x_010.main_1:Made failedTransactionLimit reconfigurable on per SSAP Basis
    * Moved it from mgGenCfg to mgSsapReCfg Structure */

} MgGenCfg;



/***********************************************************************
                    Lower SAP configuration (TSAP)
 ***********************************************************************/


typedef struct mgDnsCfg
{
   U8              dnsAccess;          /* use supplied DNS library/not */
   CmTptAddr       dnsAddr;            /* DNS Transport Information */
   TmrCfg          dnsRslvTmr;         /* Timeout value for DNS Requests */
   U16             maxRetxCnt;         /* Number of Retries for DNS Resolve */
#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U32             ttl;                /* Default Time to live value */
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */
}MgDnsCfg;


typedef struct mgTSAPReCfg
{
   MgDnsCfg        dnsCfg;             /* configuration for DNS */
   Ticks           tMax;               /* Retx timer seed */
   CmTptParam      tptParam;           /* Transport Parameters for TCP connections */
#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U16             defDisConThold;     /* default value: disconn threshold */
   U16             defSuspThold;       /* default value: susp threshold */
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */
#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   TmrCfg          idleTmr;            /* Idle timer for TCP connections */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */

#ifdef ZG
   Bool            changeOver;         /* whether new service provider ? */
   Pst             dstPst;             /* service provider's Pst */
   SpId            spId;               /* service provider's id */
#endif /* ZG */   
} MgTSAPReCfg;


#ifdef GCP_PROV_MTP3
typedef struct mgMtpNwCfg
{
   U8              upSwtch;            /* Network ID for differnet ITU,ANSI n/w */
   U8              pcLen;              /* Point Code Lenght 14/16/24 bit */
   U8              subService;         /* Sub Service field used in SIO */
   U8              sls;                /* Max SLS for this Variant Type */
   U32             maxBinsMgcoMtpHl;       /* Number of Bins in rteCp Hash table */    
   TmrCfg          defStatusEnqTmr;    /* Status enquiry timer used for enquiring PC status from MTP3 */
   TmrCfg          defRstEndTmr;       /* Timer to monitor restart Procedure */
} MgMtpNwCfg;
#endif   /* GCP_PROV_MTP3 */


typedef struct mgTSAPCfg
{
   SuId            tSAPId;             /* id of the SAP being configured*/
   SpId            spId;               /* id of the transport provider SAP*/


   /*
    *   Added provider Type to TSAP Cfg; Possible values -
    *      LMG_PROV_TYPE_TUCL   ---   TUCL
    *      LMG_PROV_TYPE_SCTP   ---   SCTP
    */

   U8              provType;           /* tpt provider - SCTP or TUCL */
   MemoryId        memId;              /* lower interface memory id */
   ProcId          dstProcId;          /* lower interface processor id */
   Ent             dstEnt;             /* lower entity */
   Inst            dstInst;            /* lower interface instance */
   Priority        dstPrior;           /* lower interface priority */
   Route           dstRoute;           /* lower interface route */
   Selector        dstSel;             /* lower interface selector */
   TmrCfg          bndTmrCfg;          /* bind timer configuration */
   MgTSAPReCfg     reCfg;              /* reconfigurable members */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool            remIntfValid;       /* remote interface version is valid */
   CmIntfVer       remIntfVer;         /* remote interface version */
#endif   

#ifdef    GCP_PROV_SCTP
   U32             numBinsAssocHl;     /* size of Association Hash list */
#endif    /* GCP_PROV_SCTP */

#ifdef    GCP_PROV_MTP3
   MgMtpNwCfg      mgMtpNwCfg;         /* MTP related Network Information */
#endif   /* GCP_PROV_MTP3 */   

} MgTSAPCfg;



 
/***********************************************************************
                    Upper SAP configuration (MGSSAP)
 ***********************************************************************/

/* 3gpp prof-neg */
typedef struct mgProf
{
   U8              pres;
   U8              ver;                       /* Profile version     */
   U16             len;                       /* Number of Entries   */
   U8              profStr[LMG_MAX_PROF_LEN]; /* Profile string */
}MgProf;

#ifdef GCP_MG
typedef struct mgProfCfg
{
   U16             count;                   /* number of configured profile */
   MgProf          profile[LMG_MAX_PROFILES]; /* SVC change profile info  */
}MgProfCfg;
#endif /* GCP_MG */

#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
typedef struct _ntfyAvlCfg
{
   U16            ntfyAvlTmr;          /* In this time period notify message
                                          can be sent without any restriction */
   U16            ntfyRstrcCnt;        /* Count after which notify message will be
                                          restricted */
   U16            ntfyBPTmr;           /* Breathing period timer for successive
                                          bulk notifies */
}NtfyAvlCfg;
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

typedef struct mgSSAPReCfg
{
   TmrCfg          initRetxTmr;        /* Initial Retry Timer */
   TmrCfg          provRspTmr;         /* Provisional Response Timer */
   TmrCfg          atMostOnceTmr;      /* 30 sec Timer */
#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
#ifdef GCP_2705BIS
   TmrCfg          txnTmoutTmr;        /* Transaction timeout timer */
#endif /* GCP_2705BIS */
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */
   Ticks           provRspDelay;       /* Provisional Response Delay */

/* 3gpp prof-neg */
#ifdef GCP_MG
   MgProfCfg       profCfg;             /* SVC change profile info  */
#endif /* GCP_MG */
#ifdef GCP_VER_2_1
/* 3gpp req1-4 start:for mgMgcoMsg content verification */
   TknU8          maxNoOfTxnsPerMsg;   /* Max no. of Txns per Message */ 
   TknU8          maxNoOfTxnRepPerMsg;   /* Max no. of Txn replies per Msg*/ 
   TknU8          maxNoOfTxnResAckPerMsg;   /* Max no.of Txnrspack per Msg*/ 
   TknU8          maxNoOfTxnReqPerMsg;   /* Max no. of Txn Req per Message */ 
   TknU8          maxNoOfCmdsPerTxnRep;   /* Max no. of commands per TxnRep*/ 
   TknU8          maxNoOfCmdsPerTxnReq;   /* Max no. of commands per TxnReq*/ 
/* 3gpp req1-4 end:for mgMgcoMsg content verification */
#endif   

   /* lmg_x_010.main_1: Making failedTransactionLimit reconfigurable
    * on per SSAP Basis - Moved this below variable from
    * MgGenCfg - Changes under flag*/
#ifdef GCP_RECFG_FTL
   U16          failedTransactionLimit;
#endif /* GCP_RECFG_FTL */    
#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
   NtfyAvlCfg      ntfyAvlCfg;         /* Notify avalanche configuration */ 
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */
   
}MgSSAPReCfg;

typedef struct mgSSAPCfg
{
   SpId            sSAPId;             /* Id of the SAP being config */
   Selector        sel;                /* upper interface selector */
   MemoryId        memId;              /* upper interface memory id */
   Priority        prior;              /* upper interface priority */
   Route           route;              /* upper interface route */
   U8              protocol;           /* Protocol Type */
   MgPeerInfo      userInfo;           /* Self Info */


   /*
    * The MGC GCP stack can also initiate txns on its own e.g.
    * a service change Handoff to a MG (as a result of Control MGC)
    */
   U32             startTxnNum;        /* Txn Nmb Range Start for GCP */
   U32             endTxnNum;          /* Txn Nmb Range end for GCP */

#ifdef GCP_MG
   Bool            initReg;            /* Initiate Registration */
   U16             mwdTimer;           /* Maximum Waiting Delay */
#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U32             mgcpVersion;         /* MGCP version and profile info */
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */
#endif /* GCP_MG */
#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U32             maxMgcoVersion;     /* Highest megaco version supported */
   U32             minMgcoVersion;     /* Lowest megaco version supported  */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */

   MgSSAPReCfg     reCfg;              /* reconfigurable elements */

#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool            remIntfValid;       /* remote interface version is valid */
   CmIntfVer       remIntfVer;         /* remote interface version */
   ProcId          dstProcId;          /* Destination Processor Id */
#endif   
#ifdef GCP_CH
   Bool            chEnabled;          /* CH enabled ?             */     
#endif /* GCP_CH */
 
#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
   Bool            ntfyEnb;             /* notify avalanche is enabled */
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

   /* lmg_x_001.main_6: Added Failed SVC Disconnect Count parameter. */
#ifdef GCP_MG_MGC_DISC_RECOVERY
   U8          failedSvcDisconnectLimit;  /*This element holds the count 
                                           *till which the MG should try
                                           *SVC disconnect to the failed 
                                           *active peer before it starts 
                                           *traversing the pre-configured 
                                           *MGC list*/
#endif /* GCP_MG_MGC_DISC_RECOVERY */

} MgSSAPCfg;



 
/***********************************************************************
                     Peer Entity Configuration
 ***********************************************************************/


#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
typedef struct mgPeerReCfg
{
   U16             suspThold;          /* Suspicion Threshold */
   U16             disconThold;        /* Disconnect threshold */
} MgPeerReCfg;
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */



typedef struct mgNetAddrTbl
{
   U16             count;              /* Number of Table Entries */
   CmNetAddr       netAddr[LMG_MAX_NET_ADDR]; /* IPV4/IPV6 addresses */
}MgNetAddrTbl;



typedef struct mgPeerCfg
{
   SpId            sSAPId;             /* SSAP to which peer is associated */
   MgNetAddrTbl    peerAddrTbl;        /* peer Addresses */
   U8              name[CM_DNS_DNAME_LEN];/* peer Name (e.g. name of MG)*/
   S32             port;                /* Port Number; -1 indicates absent */
   U16             mtuSize;             /* Allowable MTU size */

#ifdef GCP_MG
   U8              transportType;      /* Transport type : TCP/UDP */
#endif /* GCP_MG */

#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   MgMgcoMidStr    mid;                /* mg011.102: Added MID field  */
#ifdef GCP_MG
   U8              encodingScheme;     /* Encoding Scheme */ 
   U16             mgcPriority;        /* Priority of MGC being configured */
   Bool            useAHScheme;        /* Use AH security scheme */
#endif /* GCP_MG */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */

#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U32             ttl;                 /* Time to live value */
   MgPeerReCfg     peerReCfg;          /* reconfigurable parameters */
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */


   /*
    *  configured number of outgoing streams (SCTP support)
    *  ICNC : does it really make sense to have this since
    *         this parameter has more to do with end points
    *         than associations (peers)?
    */

#ifdef    GCP_PROV_SCTP
   SctStrmId       locOutStrms;        /* reconfigurable parameters */
#ifdef    GCP_MG
   /* lmg_x_001.main_1: TOS support changes */
   TknU8           tos;                /* TOS towards this peer */
#endif /* GCP_MG */
#endif    /* GCP_PROV_SCTP */

   /* In version 2.1 tsapId will be used by both MG and MGC */
   SuId            tsapId;            /* TSAP Id */

#ifdef GCP_PROV_MTP3
   Dpc             peerDpc;          /* Destionation point Code of Peer */
#endif   /* GCP_PROV_MTP3 */

} MgPeerCfg;
 


typedef struct mgGcpEntCfg
{
   U16             numPeer;            /* number of peer entities */
   MgPeerCfg       peerCfg[LMG_MAX_PEER_ENT]; /* Peer cfg */
                                            
}MgGcpEntCfg;

#ifdef ZG
#ifdef GCP_MGCO
#ifdef GCP_MGC
typedef struct mgMtdGcpEntCfg
{
   MgPeerCfg       actPeerCfg; /* Active Peer cfg */
   MgPeerCfg       stdPeerCfg; /* StandBy Peer cfg */
}MgMtdGcpEntCfg;
#endif /* GCP_MGC*/
#endif /* GCP_MGCO */
#endif /* ZG */ 

/***********************************************************************
                     Transport Server Configuration
 ***********************************************************************/




/*
 *   Added structures used in end point configuration -
 *
 *      1) MgEndpCfg    -- used to configure each end point
 *      2) MgEndpLstCfg -- list of end point cfg structures
 *      3) MgAssocCfg   -- assoc cfg struct : ICNC (needed?)
 *
 */

#ifdef    GCP_PROV_SCTP

typedef struct mgEndpCfg
{
#ifdef    GCP_MG
   SpId            sSAPId;                     /* SSAP Id - only on MG */
   /* lmg_x_001.main_1: TOS support changes */
   TknU8           defaultTos;                 /* default TOS */
#endif /* GCP_MG */
   SpId            tSAPId;                     /* TSAP Id */
   SctPort         sctPort;                    /* SCTP port to open */
   U8              encodingScheme;             /* text or binary */
#ifdef GCP_ENDP_SRCIPADDR_CFG
   /* lmg_x_009.main_1 : support for multiple source address */
#ifdef SCT_ENDP_MULTI_IPADDR
   SctNetAddrLst   srcAddrLst;    /* source address list */
#else
  /* lmg_x_008.main_1: Support Src IP Address Cfg */
   CmNetAddr       srcNetAddr;                 /* Source Net IP Addr */
#endif
#endif /* GCP_ENDP_SRCIPADDR_CFG */

} MgEndpCfg;


typedef struct mgEndpLstCfg
{
   U32             count;                      /* number of end points */
   MgEndpCfg       endp[LMG_MAX_DEF_ENDPTS];   /* array of endp cfgs */
} MgEndpLstCfg;


typedef struct mgAssocCfg
{
   SctStrmId       locOutStrms;                /* num of outgoing streams */
   CmNetAddr       priDstAddr;                 /* primary destination addr */
   SctNetAddrLst   dstAddrLst;                 /* destination addr list */
   SctNetAddrLst   srcAddrLst;                 /* source addr list */
   SctPort         remPort;                    /* destination port */
} MgAssocCfg;

#endif    /* GCP_PROV_SCTP */



typedef struct mgSrvrCfg
{
   Bool            isDefault;          /* Is a default server */
   SpId            sSAPId;             /* Id of the SSAP associated */
   SpId            tSAPId;             /* Id of the SSAP associated */
   U8              protocol;           /* Protocol Type : MGCP/MEGACO*/
   U8              transportType;      /* Transport type : TCP/UDP */
#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U8              encodingScheme;       /* Encoding Scheme */ 
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */
   CmTptParam      tptParam;           /* Transport Parameters */
   CmTptAddr       lclTptAddr;         /* Local Transport Session Address */
}MgSrvrCfg;


typedef struct mgTptSrvrCfg
{
   U16             count;              /* Number of Transport Servers */
   MgSrvrCfg       srvr[LMG_MAX_DEF_LSTNR];/* Configuration Information */   
}MgTptSrvrCfg;


typedef   TknU8    MgNullElmnt;        /* Null Element */


 
/***********************************************************************
                    Layer configuration
 ***********************************************************************/

typedef struct mgCfg
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   U8              bitVector;          /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */
   union
   {
      MgGenCfg     genCfg;             /* GCP - general */
      MgTSAPCfg    tSAPCfg;            /* GCP - transport SAP */
      MgSSAPCfg    sSAPCfg;            /* GCP - session SAP */
      MgGcpEntCfg  mgGcpEntCfg;        /* GCP - peer entity config */
      MgTptSrvrCfg tptSrvrCfg;         /* GCP - Transport Server Config */
#ifdef    GCP_PROV_SCTP
      MgEndpLstCfg endpCfg;            /* GCP - End Point Config */
#endif /* GCP_PROV_SCTP */
   }c;
}MgCfg;



 
/***********************************************************************
                    Statistics 
 ***********************************************************************/

/***********************************************************************
                    TSAP Statistics 
 ***********************************************************************/

typedef struct mgDnsSts
{
   StsCntr         numAQueryTx;        /* Number of A Query's Transmitted */
   StsCntr         numAQueryFailed;    /* Number of A Query's failed */
}MgDnsSts;


typedef struct mgTSAPSts
{
  SpId             tSapId;             /* TSAP id */
  MgDnsSts         dnsSts;            /* DNS related statistics */
}MgTSAPSts;

/***********************************************************************
                  Peer Statistics
 ***********************************************************************/


typedef struct mgPeerSts
{
  SpId             sSAPId;           /* SSAP id */
  StsCntr          numMsgTx;         /* Number of messages Txed */
  StsCntr          numMsgRx;         /* Number of messages received */
  StsCntr          numRespTx;        /* Number of Responses Txed */
  StsCntr          numRespRx;        /* Number of Ok Responses rcvd */
  StsCntr          numRespFailedRx;  /* Number of Failed Responses rcvd */
  StsCntr          numErrors;        /* Number of Tx and Rx errors */

#if (defined(GCP_MGCP) || defined(TDS_ROLL_UPGRADE_SUPPORT))
#ifdef GCP_2705BIS
  StsCntr          numRspAckRspTx;   /* Number of Response Ack Response Txed */
  StsCntr          numRspAckRspRx;   /* Number of Response Ack Response Rcvd */
#endif /* GCP_2705BIS */
  StsCntr          numNonStdTx;      /* Number of non standard cmnds Txed */
  StsCntr          numNonStdRx;      /* Number of Non Standard Cmnds Rcvd */

/* Transmit Related Statistics */ 
  StsCntr          numEpcfTx;        /* Number of EPCF commnds txed */ 
  StsCntr          numCreateTx;      /* Number of Create Commands Txed */ 
  StsCntr          numModifyTx;      /* Number of Modify Commands Txed */ 
  StsCntr          numDeleteTx;      /* Number of Delete Commands Txed */ 
  StsCntr          numRqntTx;        /* Number of Notify Commands Txed */ 
  StsCntr          numNotifyTx;      /* Number of Notify Commands Txed */ 
  StsCntr          numAuditEndPtTx;  /* Number of Audit/Endpt Cmnds Txed */ 
  StsCntr          numAuditConnTx;   /* Number of Audit Conns Cmnds Txed */ 
  StsCntr          numRsipTx;        /* Number of RSIP Commands Txed */  

  /* Receive Related Statistics */
  StsCntr          numEpcfRx;        /* Number of EPCF commands Rcvd */ 
  StsCntr          numCreateRx;      /* Number of Create Connection Rcvd */ 
  StsCntr          numModifyRx;      /* Number of Modify Connections Rcvd */
  StsCntr          numDeleteRx;      /* Number of Delete Commands Rcvd */ 
  StsCntr          numRqntRx;        /* Number of Notify Commands Rcvd*/ 
  StsCntr          numNotifyRx;      /* Number of Notify Commands Rcvd */ 
  StsCntr          numAuditEndPtRx;  /* Number of Audit/Endpt Cmnds Rcvd */ 
  StsCntr          numAuditConnRx;   /* Number of Audit Conns Cmnds Rcvd */ 
  StsCntr          numRsipRx;        /* Number of Restarts Rcvd */ 
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */

#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
  /* Transmit Related Statistics */ 
  StsCntr          numTransTx;        /* Number of Transactions txed */ 
  StsCntr          numServiceChgTx;   /* Number of Service Chg Cmnds Txed */ 
  StsCntr          numRespAckTx;      /* Number of Responses Ack Txed */
  StsCntr          numTransPendTx;    /* Number of Txn Pending Txed */

   /* Receive Related Statistics */ 
  StsCntr          numTransRx;        /* Number of Transactions txed */ 
  StsCntr          numServiceChgRx;   /* Number of Service Chg Cmnds Rcvd */ 
  StsCntr          numRespAckRx;      /* Number of Responses Ack Rcvd*/
  StsCntr          numTransPendRx;    /* Number of Txn Pending Rcvd */

  /* lmg_x_011.main_1: 80126 Added Counter for Retransmission */
  StsCntr          numRetxMsgs;
  
  /* lmg_x_005.main_1: Added error code counter */
  StsCntr          numErrorsMgcoBadReq;          /* Number of Bad Req errors (400) */
  StsCntr          numErrorsMgcoProtErr;         /* Number of Protocol errors (401) */
  StsCntr          numErrorsMgcoVerUnSupp;       /* Number of Version Unsupported (406) */
  StsCntr          numErrorsMgcoNotReady;        /* Number of Not Ready errors (502) */
  StsCntr          numErrorsMgcoReqRcvdBefReg;   /* Number of Req Recieved Before 
                                                    Registeration Complete (505) */
#ifdef GCP_PKG_MGCO_ROOT
  StsCntr          numErrorsMgcoTxnPendEx;       /* Number of TXNPENDING_EXCEEDED errors (506) */
#endif /* GCP_PKG_MGCO_ROOT */  
  StsCntr          numErrorsMgcoRsrcErr;         /* Number of RSRC errors (510) */
  StsCntr          numErrorsMgcoPduSize;         /* Number of PDU_SIZE_EXCEED errors (533) */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */
}MgPeerSts; 



typedef struct mgPeerEntSts
{
   SpId            sapId;              /* Sap Id off associated peer */
   MgPeerInfo      peerInfo;           /* Peer Information */
   MgPeerSts       peerSts;            /* message related statistics */
} MgPeerEntSts;


/***********************************************************************
                  Layer Statistics
 ***********************************************************************/
typedef struct mgSts
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   U8              bitVector;          /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */
   DateTime dt;
   union
   {
      MgTSAPSts    mgTSAPSts;          /* transport SAP statistics */
      MgPeerEntSts mgPeerEntSts;       /* Peer entity related sts */
   }s;
} MgSts;

 
/***********************************************************************
              Solicitated   Status
 ***********************************************************************/

/***********************************************************************
              Solicitated TSAP   Status
 ***********************************************************************/

typedef struct mgTSAPSta
{

   SpId            tSapId;             /* TSAP id */
   Bool            resCong;            /* Resource Congestion */
   U16             numServers;         /* number of default servers */
   U8              state;               /* state of the SAP */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool            remIntfValid;       /* remote interface valid in cfg ?*/
   CmIntfVer       selfIntfVer;        /* self interface version on this SAP */
   CmIntfVer       remIntfVer;         /* remote interface version on this SAP */
#endif    
}MgTSAPSta;

/***********************************************************************
              Solicitated SSAP   Status
 ***********************************************************************/
typedef struct mgSSAPSta
{
   SpId            sapId;              /* SAP identifier */
   U8              state;              /* state of the SAP */
   U16             numAssocPeer;       /* number of peers associated */
   Bool            more;               /* Are there more peers */
   MgPeerInfo      peerInfo[LMG_MAX_PEER_ENT]; /* Peer Information List */
   U16             numServers;         /* Nmb of open servers for this SAP */
   U16             numTCPlosses;       /* Number transport connection lost */
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   Bool            remIntfValid;       /* remote interface valid in cfg ?*/
   CmIntfVer       selfIntfVer;        /* self interface version on this SAP */
   CmIntfVer       remIntfVer;         /* remote interface version on this SAP */
#endif    
} MgSSAPSta;


/***********************************************************************
              Solicitated Peer   Status
 ***********************************************************************/
typedef struct mgPeerSta
{
   TknU32          peerId;             /* Id of the peer */
   TknPres         namePres;           /* Whether domain name is present */
   U8              name[CM_DNS_DNAME_LEN];/* peer Name (e.g gw)*/
   MgNetAddrTbl    peerAddrTbl;        /* peer Addresses */
   TknS32          port;               /* Port Number; -1 indicates absent */
#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   MgMgcoMidStr    mid;                /* mg011.102: Added MID field  */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */
   State           peerState;          /* internal state of peer */
   SuId            sSapId;             /* Id of SSAP corresponding to peer */
   U8              protocol;           /* Protocol Type - MGCP/MEGACO */
   U8              transportType;      /* Transport Type */
   U32             version;            /* Protocol Version */
   U32             numPendOgTxn;      /* current Number of outgoing txn */
   U32             numPendIcTxn;       /* current Number of incoming txn */
   U32             rttEstimate;        /* Round trip time estimate */    
#if (defined(GCP_MGCO) || defined(TDS_ROLL_UPGRADE_SUPPORT))   
   U8              encodingScheme;     /* Encoding Scheme */
#endif /* GCP_MGCO || TDS_ROLL_UPGRADE_SUPPORT */

#ifdef GCP_PROV_MTP3
   TknU32          peerDpc;            /* Destination Point Code of Peer */
   U8              dpcStatus;          /* Status of DPC OFFLINE/ONLINE */
#endif   /* GCP_PROV_MTP3 */   

}MgPeerSta;


/***********************************************************************
              Solicitated Server   Status
 ***********************************************************************/

typedef struct mgTptSrvSta
{
   U8              transportType;      /* Transport Type */
   U8              encodingScheme;     /* Type of encoding : txt/Bin */
   CmTptAddr       tptAddr;            /* transport address of the listener */
   State           state;              /* state of the listener */
}MgTptSrvSta;



/***********************************************************************
              Solicitated SCTP Endpoint Status
 ***********************************************************************/

#ifdef    GCP_PROV_SCTP
typedef struct mgSctpEpSta
{
   SctPort         port;               /* SCTP Endpoint port */
   U8              encodingScheme;     /* Type of encoding : txt/Bin */
   State           state;              /* state of the listener */
} MgSctpEpSta;
#endif /* GCP_PROV_SCTP */



/***********************************************************************
              Layer Solicitated    Status
 ***********************************************************************/
typedef struct mgSsta
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   U8              bitVector;          /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */
   DateTime dt;
   union
   {
      SystemId     systemId;           /* system id */
      MgSSAPSta    mgSSAPSta;          /* status of the SAP */
      MgTSAPSta    mgTSAPSta;          /* status of the SAP */
      MgPeerSta    mgPeerSta;          /* entity status  */
      MgTptSrvSta mgTptSrvSta;         /* Transport Server Status */

#ifdef    GCP_PROV_SCTP
      MgSctpEpSta      mgSctpEpSta;    /* SCTP Endpoint Status */
#endif /* GCP_PROV_SCTP */

   }s;
} MgSsta;




/***********************************************************************
               Unsolicitated    Status
 ***********************************************************************/
/***********************************************************************
                             Peer Information
 ***********************************************************************/
typedef struct mgAddrInfo     /* mg011.102: New struct added */
{
  MgDName         addr;        /* Address of new MGC to use for handoff */
  TknS32          port;        /* Port number where to contact */

#ifdef   GCP_PROV_MTP3
  TknU32          peerDpc;    /* Peer MGC Point Code */
#endif   /* GCP_PROV_MTP3 */


}MgAddrInfo;

typedef struct mgPeerCntrl
{
   MgPeerInfo      activePeer;         /* peer being handed off */
   union
   {
     MgAddrInfo      handoffMgc;        /* mg011.102 Info of MGC to use for handoff */
     MgPeerInfo      standbyPeer;        /* Standby MG information */
   }u;
} MgPeerCntrl;


/* parType will be LMG_PAR_ASSOC, LMG_PAR_SPID, LMG_PAR_TPTADDR */
typedef struct mgParId
{
   U8              parType;            /* parameter type */
   union
   {
     UConnId         assocId;          /* Association identifier */
     SpId            sapId;            /* SAP identifier */
#ifdef GCP_PROV_MTP3
     Dpc             dpc;              /* Point code */      
#endif /* GCP_PROV_MTP3 */
   }u;
} MgParId;


typedef struct mgAlarmInfo
{
   U8              type;               /* Type of Information */ 
   SpId            sapId;              /* SAP identifier */
   union
   {
     MgPeerInfo      peerInfo;           /* peer identifier */
     SpId            sapId;              /* SAP identifier */
     MemoryId        mem;                /* memory region and pool */
     MgTptSrvSta     srvSta;             /* transport server status */
     MgPeerSta       peerSta;            /* entity status */
     MgSSAPSta       ssapSta;            /* SSAP status */
     MgParId         parId;              /* parameter identifier */
     MgPeerCntrl     matedPairInfo;      /* Information about Mated Pairs */
/* lmg_x_008.main_1: Added LCN Feature */
#ifdef GCP_PROV_SCTP
#ifdef GCP_LCN_APP_USE
     MgAssocCfg      assocCfgInfo;      /* SCTP Assocation Configuration Info */
#endif /* GCP_LCN_APP_USE */
#endif /* (define(GCP_PROV_MTP3) || defined(GCP_PROV_SCTP)) */
   }u;
}MgAlarmInfo;
 

typedef struct mgUsta
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   U8              bitVector;          /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */
   CmAlarm         alarm;              /* alarm */
   MgAlarmInfo     alarmInfo;          /* associated alarm info if any */
} MgUsta;


 
/***********************************************************************
                       Trace Indication
 ***********************************************************************/

typedef struct mgTrc
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   U8              bitVector;          /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */
   DateTime        dt;                 /* date and time of the trace PDU */
   SpId            sapId;              /* lower TSAP identifier */
   MgPeerInfo      peerInfo;           /* GCP peer Information */
   U16             evnt;               /* trace event */
} MgTrc;



 
/***********************************************************************
                              Control
 ***********************************************************************/

/***********************************************************************
                             Transort Server  Control
 ***********************************************************************/

typedef struct mgTptCntrl
{
   U8              transportType;      /* Transport Type */
   CmTptAddr       serverAddr;         /* Server Transport Address */
} MgTptCntrl;



/***********************************************************************
                             Trace  Control
 ***********************************************************************/

typedef struct mgTrcCntrl
{
   MgPeerInfo      peerInfo;           /* peer information */
   S16             trcLen;             /* trace length */
} MgTrcCntrl;


/***********************************************************************
                             Debug  Control
 ***********************************************************************/

typedef struct mgDbgCntrl
{
   U32             genDbgMask;         /* non entity related debug mask */
} MgDbgCntrl;
 

/***********************************************************************
                             Endpoint  Control
 ***********************************************************************/

#ifdef    GCP_PROV_SCTP
typedef SctPort MgEndpCntrl;
#endif    /* GCP_PROV_SCTP */


/***********************************************************************
                             Layer Control
 ***********************************************************************/

typedef struct mgCntrl
{
#ifdef TDS_ROLL_UPGRADE_SUPPORT
   U8              bitVector;          /* bit vector for RUG */
#endif /* TDS_ROLL_UPGRADE_SUPPORT */
   DateTime        dt;                 /* date */
   U8              action;             /* action to be performed */
   U8              subAction;          /* subaction to be performed */
   SpId            spId;               /* SAP id being controlled */
   union
   {
      MgTptCntrl     tptCntrl;         /* listener control */
      MgPeerInfo     peerInfo;         /* Peer Information */
      MgTrcCntrl     trcCntrl;         /* trace control */
      MgDbgCntrl     dbg;              /* debug printing control */
      MgPeerCntrl    peerCntrlInfo;    /* On MGC side; info for handoff 
                                        * or about mated pair of MG 
                                        */
#ifdef GCP_MGCO
#if ((defined GCP_MG) && (defined GCP_VER_2_1))
      MgMgcoMidStr    peerMid;
#endif /* (defined GCP_MG) && (defined GCP_VER_2_1) */
#endif /* GCP_MGCO */

#ifdef ZG
      MgGcpEntCfg    mgGcpEntCfg;      /* GCP - peer entity config */
      MgTptSrvrCfg   tptSrvrCfg;       /* GCP - Transport Server Config */
#ifdef GCP_MGCO
#ifdef GCP_MGC
      MgMtdGcpEntCfg mtdGcpEntCfg;      /* Mated peer entity config */
#endif /* GCP_MGC */
#endif /* GCP_MGCO */
#endif /* ZG */

#ifdef    GCP_PROV_SCTP
      MgEndpCntrl    endpCntrl;        /* Endpoint control struct */
#endif    /* GCP_PROV_SCTP */

      union
      {
        ProcId       dstProcId;        /* Destination Processor Id */
        Route        route;            /* Route */
        Priority     priority;         /* Priority */
      } par;
   }s;
} MgCntrl;


 
/***********************************************************************
                       Layer management structure
 ***********************************************************************/

typedef struct mgMngmt
{
   Header          hdr;                /* header for mngmt struct */
   CmStatus        cfm;                /* result of the cntrl/cfg operation */
   union
   {
      MgCfg        cfg;                /* configuration related */
      MgSts        sts;                /* statistics */
      MgSsta       ssta;               /* solicitated status */
      MgUsta       usta;               /* unsolicitated status */
      MgTrc        trc;                /* trace */
      MgCntrl      cntrl;              /* control */
   } t;
} MgMngmt;

 
/***********************************************************************
          type definitions for layer manager interface primitives
 ***********************************************************************/

typedef S16 (*LmgCfgReq)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));


typedef S16 (*LmgCfgCfm)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

typedef S16 (*LmgCntrlReq)   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

typedef S16 (*LmgCntrlCfm)   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

typedef S16 (*LmgStaReq)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

typedef S16 (*LmgStaInd)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

typedef S16 (*LmgStsReq)     ARGS((
        Pst        *pst,               /* Post Structure */
        Action     action,             /* Action to be taken */
        MgMngmt    *sts                /* Management Structure */
     ));

typedef S16 (*LmgStsCfm)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sts                /* Management Structure */
     ));

typedef S16 (*LmgTrcInd)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *trc,               /* Management Structure */
        Buffer     *mBuf               /* Message Buffer */
     ));

/* 002.main_1: added new function declarations */
EXTERN S16 cmPkMgGenReCfg ARGS((MgGenReCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgGenReCfg ARGS((MgGenReCfg *param, Buffer *mBuf));

/* 003.main_1: Add - Changes for pending limit can be configure by Layer Manager */
#ifdef GCP_PKG_MGCO_ROOT
EXTERN S16 cmPkPendingLimit ARGS((MgMgcoPendingLimit *param, Buffer *mBuf));
EXTERN S16 cmUnpkPendingLimit ARGS((MgMgcoPendingLimit *param, Buffer *mBuf));
#endif /* GCP_PKG_MGCO_ROOT */

EXTERN S16 cmPkMgGenCfg ARGS((MgGenCfg *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgGenCfg ARGS((MgGenCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgDnsCfg   ARGS((MgDnsCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgDnsCfg ARGS((MgDnsCfg *param, Buffer *mBuf));

EXTERN S16 cmPkMgTSAPReCfg ARGS((MgTSAPReCfg *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgTSAPReCfg ARGS((MgTSAPReCfg *param, Buffer *mBuf));
#ifdef GCP_PROV_MTP3
EXTERN S16 cmPkMgMtpNwCfg    ARGS((MgMtpNwCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgMtpNwCfg  ARGS((MgMtpNwCfg *param, Buffer *mBuf));
#endif /* GCP_PROV_MTP3 */
EXTERN S16 cmPkMgTSAPCfg     ARGS((MgTSAPCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTSAPCfg   ARGS((MgTSAPCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgSSAPReCfg   ARGS((MgSSAPReCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSSAPReCfg ARGS((MgSSAPReCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgSSAPCfg     ARGS((MgSSAPCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSSAPCfg   ARGS((MgSSAPCfg *param, Buffer *mBuf));

/* 004.main_1: Service change profile information */  
/* 3gpp prof-neg */
#ifdef GCP_MG
EXTERN S16 cmPkMgProfCfg     ARGS((MgProfCfg *param, Buffer *mBuf));  
EXTERN S16 cmPkMgProf        ARGS((MgProf    *param, Buffer *mBuf));  
EXTERN S16 cmUnpkMgProfCfg   ARGS((MgProfCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgProf      ARGS((MgProf    *param, Buffer *mBuf));
#endif /* GCP_MG */

#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
EXTERN S16 cmPkMgNtfyAvl     ARGS((NtfyAvlCfg *param, Buffer *mBuf));  
EXTERN S16 cmUnpkMgNtfyAvl   ARGS((NtfyAvlCfg *param, Buffer *mBuf));  
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

#if(  defined(  GCP_MGCP)  || defined(  TDS_ROLL_UPGRADE_SUPPORT) ) 
EXTERN S16 cmPkMgPeerReCfg   ARGS((MgPeerReCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerReCfg ARGS((MgPeerReCfg *param, Buffer *mBuf));
#endif /* GCP_MGCP || TDS_ROLL_UPGRADE_SUPPORT */
EXTERN S16 cmPkMgNetAddrTbl  ARGS((MgNetAddrTbl *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgNetAddrTbl ARGS((MgNetAddrTbl *param, Buffer *mBuf));
EXTERN S16 cmPkMgPeerCfg      ARGS((MgPeerCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerCfg    ARGS((MgPeerCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgGcpEntCfg    ARGS((MgGcpEntCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgGcpEntCfg  ARGS((MgGcpEntCfg *param, Buffer *mBuf));
#ifdef ZG
#ifdef GCP_MGCO
#ifdef GCP_MGC
EXTERN S16 cmPkMgMtdGcpEntCfg ARGS((MgMtdGcpEntCfg *param, Buffer *mBuf));

EXTERN S16 cmUnpkMgMtdGcpEntCfg ARGS((MgMtdGcpEntCfg *param, Buffer *mBuf));
#endif /* GCP_MGC */
#endif /* GCP_MGCO */
#endif /* ZG */
#ifdef GCP_PROV_SCTP
EXTERN S16 cmPkMgEndpCfg        ARGS((MgEndpCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgEndpCfg      ARGS((MgEndpCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgEndpLstCfg     ARGS((MgEndpLstCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgEndpLstCfg   ARGS((MgEndpLstCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgAssocCfg       ARGS((MgAssocCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgAssocCfg     ARGS((MgAssocCfg *param, Buffer *mBuf));
#endif /* GCP_PROV_SCTP */
EXTERN S16 cmPkMgSrvrCfg        ARGS((MgSrvrCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSrvrCfg      ARGS((MgSrvrCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgTptSrvrCfg     ARGS((MgTptSrvrCfg *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTptSrvrCfg   ARGS((MgTptSrvrCfg *param, Buffer *mBuf));
EXTERN S16 cmPkMgCfg            ARGS((MgCfg *param, Elmnt elmnt,
                                      Buffer *mBuf));
EXTERN S16 cmUnpkMgCfg          ARGS((MgCfg *param, Elmnt elmnt,
                                      Buffer *mBuf));
EXTERN S16 cmPkMgDnsSts         ARGS((MgDnsSts *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgDnsSts       ARGS((MgDnsSts *param, Buffer *mBuf));
EXTERN S16 cmPkMgTSAPSts        ARGS((MgTSAPSts *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTSAPSts      ARGS((MgTSAPSts *param, Buffer *mBuf));
EXTERN S16 cmPkMgPeerSts        ARGS((MgPeerSts *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerSts      ARGS((MgPeerSts *param, Buffer *mBuf));
EXTERN S16 cmPkMgPeerEntSts     ARGS((MgPeerEntSts *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerEntSts   ARGS((MgPeerEntSts *param, Buffer *mBuf));
EXTERN S16 cmPkMgSts            ARGS((MgSts *param, Elmnt elmnt,
                                      Buffer *mBuf));
EXTERN S16 cmUnpkMgSts          ARGS((MgSts *param, Elmnt elmnt,
                                      Buffer *mBuf));
EXTERN S16 cmPkMgTSAPSta        ARGS((MgTSAPSta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTSAPSta      ARGS((MgTSAPSta *param, Buffer *mBuf));
EXTERN S16 cmPkMgSSAPSta        ARGS((MgSSAPSta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSSAPSta      ARGS((MgSSAPSta *param, Buffer *mBuf));
EXTERN S16 cmPkMgPeerSta        ARGS((MgPeerSta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerSta      ARGS((MgPeerSta *param, Buffer *mBuf));
EXTERN S16 cmPkMgTptSrvSta      ARGS((MgTptSrvSta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTptSrvSta    ARGS((MgTptSrvSta *param, Buffer *mBuf));
#ifdef GCP_PROV_SCTP
EXTERN S16 cmPkMgSctpEpSta      ARGS((MgSctpEpSta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgSctpEpSta    ARGS((MgSctpEpSta *param, Buffer *mBuf));
#endif /* GCP_PROV_SCTP */
EXTERN S16 cmPkMgSsta           ARGS((MgSsta *param, Elmnt elmnt, S16 eventType,
                                      Buffer *mBuf));
EXTERN S16 cmUnpkMgSsta         ARGS((MgSsta *param, Elmnt elmnt, S16 eventType,
                                      Buffer *mBuf));
EXTERN S16 cmPkMgAddrInfo       ARGS((MgAddrInfo *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgAddrInfo     ARGS((MgAddrInfo *param, Buffer *mBuf));
EXTERN S16 cmPkMgPeerCntrl      ARGS((MgPeerCntrl *param, U8 action,
                                      Buffer *mBuf));
EXTERN S16 cmUnpkMgPeerCntrl    ARGS((MgPeerCntrl *param, U8 action,
                                      Buffer *mBuf));
EXTERN S16 cmPkMgParId          ARGS((MgParId *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgParId        ARGS((MgParId *param, Buffer *mBuf));
EXTERN S16 cmPkMgAlarmInfo      ARGS((MgAlarmInfo *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgAlarmInfo    ARGS((MgAlarmInfo *param, Buffer *mBuf));
EXTERN S16 cmPkMgUsta           ARGS((MgUsta *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgUsta         ARGS((MgUsta *param, Buffer *mBuf));
EXTERN S16 cmPkMgTrc            ARGS((MgTrc *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTrc          ARGS((MgTrc *param, Buffer *mBuf));
EXTERN S16 cmPkMgTptCntrl       ARGS((MgTptCntrl *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTptCntrl     ARGS((MgTptCntrl *param, Buffer *mBuf));
EXTERN S16 cmPkMgTrcCntrl       ARGS((MgTrcCntrl *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgTrcCntrl     ARGS((MgTrcCntrl *param, Buffer *mBuf));
EXTERN S16 cmPkMgDbgCntrl       ARGS((MgDbgCntrl *param, Buffer *mBuf));
EXTERN S16 cmUnpkMgDbgCntrl     ARGS((MgDbgCntrl *param, Buffer *mBuf));
#ifdef GCP_PROV_SCTP
#endif /* GCP_PROV_SCTP */
EXTERN S16 cmPkMgCntrl          ARGS((MgCntrl *param, Elmnt elmnt,
                                      Buffer *mBuf));
EXTERN S16 cmUnpkMgCntrl        ARGS((MgCntrl *param, Elmnt elmnt,
                                      Buffer *mBuf));
EXTERN S16 cmPkMgMngmt          ARGS((MgMngmt *param, S16 eventType, Ent entity,
                                      Buffer *mBuf));
EXTERN S16 cmUnpkMgMngmt        ARGS((MgMngmt *param, S16 eventType, Ent entity,
                                      Buffer *mBuf));


#ifdef MG
EXTERN S16 MgMiLmgCfgReq     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

EXTERN S16 MgMiLmgCfgCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

EXTERN S16 MgMiLmgCntrlReq   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

EXTERN S16 MgMiLmgCntrlCfm   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

EXTERN S16 MgMiLmgStaReq     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 MgMiLmgStaCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 MgMiLmgStaInd     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 MgMiLmgStsReq     ARGS((
        Pst        *pst,               /* Post Structure */
        Action     action,             /* Action to be taken */
        MgMngmt    *sts                /* Management Structure */
     ));

EXTERN S16 MgMiLmgStsCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sts                /* Management Structure */
     ));

EXTERN S16 MgMiLmgTrcInd     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *trc,               /* Management Structure */
        Buffer     *mBuf               /* Message Buffer */
     ));

#endif /* MG */

#ifdef SM
EXTERN S16 SmMiLmgCfgReq     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

EXTERN S16 SmMiLmgCfgCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

EXTERN S16 SmMiLmgCntrlReq   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

EXTERN S16 SmMiLmgCntrlCfm   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

EXTERN S16 SmMiLmgStaReq     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 SmMiLmgStaCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 SmMiLmgStaInd     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 SmMiLmgStsReq     ARGS((
        Pst        *pst,               /* Post Structure */
        Action     action,             /* Action to be taken */
        MgMngmt    *sts                /* Management Structure */
     ));

EXTERN S16 SmMiLmgStsCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sts                /* Management Structure */
     ));

EXTERN S16 SmMiLmgTrcInd     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *trc,               /* Management Structure */
        Buffer     *mBuf               /* Message Buffer */
     ));

#endif /* SM */

typedef S16 (*LmgStaCfm)     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

#ifdef LCSMMGMILMG

/* Packing Functions */
EXTERN S16 cmPkLmgCfgReq     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

EXTERN S16 cmPkLmgCntrlReq   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

EXTERN S16 cmPkLmgStaReq     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 cmPkLmgStsReq     ARGS((
        Pst        *pst,               /* Post Structure */
        Action     action,             /* Action to be taken */
        MgMngmt    *sts                /* Management Structure */
     ));


/* Unpacking Functions */

EXTERN S16 cmUnpkLmgCfgCfm   ARGS((
       LmgCfgCfm   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgCntrlCfm ARGS((
       LmgCntrlCfm func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgStaCfm   ARGS((
       LmgStaCfm   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgStaInd   ARGS((
       LmgStaInd   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgStsCfm   ARGS((
       LmgStsCfm   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgTrcInd   ARGS((
       LmgTrcInd   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

#endif /* LCSMMGMILMG */

#ifdef LCMGMILMG
EXTERN S16 cmPkLmgCfgCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cfg                /* Management Structure */
     ));

EXTERN S16 cmPkLmgCntrlCfm   ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *cntrl              /* Management Structure */
     ));

EXTERN S16 cmPkLmgStaCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 cmPkLmgStaInd     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sta                /* Management Structure */
     ));

EXTERN S16 cmPkLmgStsCfm     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *sts                /* Management Structure */
     ));

EXTERN S16 cmPkLmgTrcInd     ARGS((
        Pst        *pst,               /* Post Structure */
        MgMngmt    *trc,               /* Management Structure */
        Buffer     *mBuf               /* Message Buffer */
     ));

EXTERN S16 cmUnpkLmgCfgReq   ARGS((
       LmgCfgReq   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));


EXTERN S16 cmUnpkLmgCntrlReq ARGS((
       LmgCntrlReq func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgStaReq   ARGS((
       LmgStaReq   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

EXTERN S16 cmUnpkLmgStsReq   ARGS((
       LmgStsReq   func,               /* Unpacking function to invoke */
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

#endif /* LCMGMILMG */

/* stack manager initialization function */
EXTERN S16 smMgActvInit      ARGS((
       Ent         ent,                /* Entity */
       Inst        inst,               /* Instance */
       Region      region,             /* Memory Region */
       Reason      reason              /* Reason */
    ));

/* stack manager activation function */
EXTERN S16 smMgActvTsk       ARGS((
       Pst         *pst,               /* Post Structure */
       Buffer      *mBuf               /* Message Buffer to be unpacked */
    ));

#ifdef __cplusplus
}
#endif


#endif /* __LMGX__ */

/********************************************************************30**
 
         End of file:     lmg.x@@/main/7 - Fri Dec 18 15:44:22 2009
 
*********************************************************************31*/
/********************************************************************40**
 
        Notes:
 
*********************************************************************41*/
/********************************************************************50**
 
*********************************************************************51*/

/********************************************************************60**
 
        Revision history:
 
*********************************************************************61*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      rrp  1.Initial release.
/main/4      ---       pk  2. Management interface for Release v 1.2
/main/4+               vj  1. Added user functions to remove crash 
                              in pack-unpack of systemId.              
             mg007.102 vj  1. Removed MgPeerInfo field from MgPeerSta
                              structure, and instead added 5 fields:- peerId, 
                              dname[], namePres, MgPeerAddrTbl & port.This is 
                              required since in MGCP, multiple adddress are 
                              possible for each domain name. Further, modified
                              the version number field in MgPeerSta from U8 to
                              U32.
             mg008.102 vj  1. For pack-unpack of MgSts, the element value for
                              obtaining TSAP stats should be STTSAP rather 
                              than STGEN.
             mg011.102 vj  1. In SSAP configuration, added a new field addrInfo
                              for MEGACO, as userInfo no longer provides 
                              address information in MEGACO path
                           2. In Peer configuration, added a "MgMgcoMidStr mid"
                              field for MEGACO. Further removed mIdPort field.
                           3. In MgPeerSta structure, added "MgMgcoMidStr mid"
                              field in case of MEGACO.
/main/2      ---      ra   1. GCP 1.3 release
/main/1      ---      pk   1. GCP 1.5 release
/main/1    001.main_1 ra   1. Added TOS cfg in endpoint & peer cfg.
            002.main_1 ra   1. Made rspAckEnb a reconfigurable parameter.
                           2. Added a bit value to send immediate rspAckRsp
                              for MGCP.
            003.main_1 ps  1. Moved defintion of mgMgcoPendingLimit from mg.x 
                           2. Added MgMgcoPendingLimit in MgGenCfg
                           3. Changes for pending limit can be configure 
                              by Layer Manager 
      lmg_x_004.main_1 gk  1. Service change profile information
                           2. GCP_ALLOW_LIMIT_CFG - This is introduced to
                              configured the limits for GCP message 
                              components exceeding which will be rejected
      lmg_x_005.main_1 gk  1. Added error code counter
      lmg_x_006.main_1 gk  1. Upper limit of failed transaction before
                              peer is assumed to be down, to be configured by
                              Layer Manager
      lmg_x_007.main_1 gk  1. Service change profile information
      lmg_x_008.main_1 rb  1. Added LCN Feature.
                           2. Source IP Address Cfg in EndPointCfg
      lmg_x_009.main_1 rb  1. Added support for Multi IP Addr Cfg.
      lmg_x_010.main_1 ac  1. Made failedTransactionLimit reCfg under 
                              flag GCP_RECFG_FTL.
/main/2      ---       gk  1. Added TOS cfg in endpoint & peer cfg.
            2. Made rspAckEnb a reconfigurable parameter.
            3. Added a bit value to send immediate rspAckRsp
                              for MGCP.
            4. Moved defintion of mgMgcoPendingLimit from mg.x 
                           5. Added MgMgcoPendingLimit in MgGenCfg
                           6. Changes for pending limit can be configure 
                              by Layer Manager 
            7. Service change profile information
                           8. GCP_ALLOW_LIMIT_CFG - This is introduced to
                              configured the limits for GCP message 
                              components exceeding which will be rejected
            9. Added error code counter
/main/3      ---      gk   1. Releasing main/1 patches
/main/4      ---      gk   1. Upper limit of failed transaction before
                              peer is assumed to be down, to be configured by
                              Layer Manager
                           2. Service change profile information
                           3. Added LCN Feature.
                           4. Source IP Address Cfg in EndPointCfg
                           5. Added support for Multi IP Addr Cfg.
/main/5      ---      ac   1. Made failedTransactionLimit reCfg under
                              flag GCP_RECFG_FTL.
                           2. Added Counter for Retransmission.                        
/main/6      ----     sy   GCP 2.1 release                           
/main/7      ---      lmg_x_001.main_6 gk  1. Added Failed SVC Disconnect Count parameter.
*********************************************************************91*/
