/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/
 

 
/********************************************************************20**
 
     Name:     lmg.h
 
     Type:     C header file
 
     Desc:     Header file for layer management interface
 
     File:     lmg.h
 
     Sid:      lmg.h@@/main/7 - Fri Dec 11 01:04:30 2009
 
     Prg:      pk
 
*********************************************************************21*/
#ifndef __LMGH__
#define __LMGH__

#define LMG_RSPACKENB_VAL_NONE         0
#define LMG_EMBD_RSPACK_MGCP           0x01   /* Tx RspAck if needed */
#define LMG_EMBD_EMPTY_RSPACK_MGCP     0x02   /* Request RspAck Rsp */
/* 002.main_1: added bit value to send immediate rspAckRsp for MGCP */
#define LMG_EMBD_IMM_RSPACK_MGCP       0x04   /* Tx RspAck Ack immediately */

/* 002.main_1: The first 4 bits now belong to MGCP. The last 4 to MEGACO */
#define LMG_SEND_RSPACK_MGCO           0x10   /* Tx RspAck Ack if needed */
#define LMG_GET_RSPACK_MGCO            0x20   /* Request RspAck */

/* Debug Masks */
#define LMG_DBGMASK                  DBGMASK_LYR
#define LMG_DBGMASK_LI_MBUF          (LMG_DBGMASK << 1)

/*New Debug Masks*/
#define LMG_DBG_SUB_MASK   DBGMASK_MI
#define LMG_DBGMASK_PARM   (LMG_DBG_SUB_MASK << 0)
#define LMG_DBGMASK_DBG    (LMG_DBG_SUB_MASK << 1)
#define LMG_DBGMASK_INFO   (LMG_DBG_SUB_MASK << 2)
#define LMG_DBGMASK_ERROR  (LMG_DBG_SUB_MASK << 3)
#define LMG_DBGMASK_FATAL  (LMG_DBG_SUB_MASK << 4)

#define LMG_DBG_MDL_MASK (LMG_DBG_SUB_MASK << 5)

#define LMG_DBGMASK_LI             (LMG_DBG_MDL_MASK << 0)
#define LMG_DBGMASK_UI             (LMG_DBG_MDL_MASK << 1)
#define LMG_DBGMASK_PEER_FSM       (LMG_DBG_MDL_MASK << 2)
#define LMG_DBGMASK_TRANS          (LMG_DBG_MDL_MASK << 3)
#define LMG_DBGMASK_MGMT           (LMG_DBG_MDL_MASK << 4)
#define LMG_DBGMASK_TPT            (LMG_DBG_MDL_MASK << 5)
#define LMG_DBGMASK_CORD           (LMG_DBG_MDL_MASK << 6)
#define LMG_DBGMASK_PEER           (LMG_DBG_MDL_MASK << 7)
#define LMG_DBGMASK_CMD_HDLR       (LMG_DBG_MDL_MASK << 8)
#define LMG_DBGMASK_TRANS_HDLR     (LMG_DBG_MDL_MASK << 9)
#define LMG_DBGMASK_UTIL           (LMG_DBG_MDL_MASK << 10)
#define LMG_DBGMASK_MBUF_PRNT      (LMG_DBG_MDL_MASK << 11)
#define LMG_DBGMASK_MEM_INFO       (LMG_DBG_MDL_MASK << 12)
#define LMG_DBGMASK_ED             (LMG_DBG_MDL_MASK << 13)


/* Selector from GCP to Service User at the MGT Interface */
#define LMG_MGT_SEL_LC    MGT_SEL_LC      /* Loosely coupled MGT interface */
#define LMG_MGT_SEL_TC    MGT_SEL_TC      /* Tightly coupled MGT interface */
#define LMG_MGT_SEL_LWLC  MGT_SEL_LWLC    /* Lightweight Loosely coupled MGT 
                                           * interface 
                                           */

/***********************************************************************
              Defines for Rolling Upgrade 
 ***********************************************************************/
 
/* Introduce the interface version number */
#ifdef LMG1
#ifdef LMGIFVER
#undef LMGIFVER
#endif
#define LMGIFVER 0x0100
#endif /* LMG1 */

/* Defines for HIT, should be removed when HIT is updated to RUG */
#ifndef HITIFVER
#define HITIFVER 0x0100
#endif

/* bitVector */
#define LMG_GCP_MGCP_BIT 0x01
#define LMG_GCP_MGCO_BIT 0x02

/* Default values */
#define LMGIF_VER1_CFGREQ_DEF_TIMERESTTL 10  /* DNS TTL time resolution timer */
#define LMGIF_VER1_CFGREQ_DEF_DEFDISCONTHOLD 2  /* default disconn threshold */
#define LMGIF_VER1_CFGREQ_DEF_DEFSUSPTHOLD   3  /* default susp threshold */
#define LMGIF_VER1_CFGREQ_DEF_TTL         1000  /* default TTL threshold */
#define LMGIF_VER1_CFGREQ_DEF_MID   "<mid1.trillium.com>"


/***********************************************************************
        Defines for  Management Interface Events
 ***********************************************************************/

#define EVTLMGCFGREQ                    1   /* Configuration request */
#define EVTLMGCFGCFM                    2   /* Configuration confirm */
#define EVTLMGSTAREQ                    3   /* Status request */
#define EVTLMGSTACFM                    4   /* Status confirm */
#define EVTLMGSTAIND                    5   /* Status indication */
#define EVTLMGSTSREQ                    6   /* Statistics request */
#define EVTLMGSTSCFM                    7   /* Statistics confirm */
#define EVTLMGTRCIND                    8   /* Trace indication */
#define EVTLMGCNTRLREQ                  9   /* Control request */
#define EVTLMGCNTRLCFM                  10  /* Control confirm */
#define EVTLMGSCTPASSOCINFO             11  /* SCTP Assoc Info */

/***********************************************************************
                  Defines for Configuration Request Event
 ***********************************************************************/

/***********************************************************************
                  Defines for General Configuration
 ***********************************************************************/
/* Resource Congestion Info */
#define LMG_EVENT_RES_CONG_ON           (LCM_EVENT_LYR_SPECIFIC + 24)
#define LMG_EVENT_RES_CONG_OFF          (LCM_EVENT_LYR_SPECIFIC + 25)

/* Peer Entity Type */
#define LMG_ENT_GC    1
#define LMG_ENT_GW    2

#define LMG_NONE      0

/* 003.main_1: Add - Added default value for MG/MGC pending limit */
#ifdef GCP_PKG_MGCO_ROOT
#define LMG_MG_ORIGINATED_PENDING_LIMIT    2
#define LMG_MGC_ORIGINATED_PENDING_LIMIT    2
#endif /* GCP_PKG_MGCO_ROOT */

/* lmg_h_006.main_1: failedTransactionLimit default value */
#define LMG_DEF_FAILED_TRANS_LIMIT   1

/***********************************************************************
                  Defines for TSAP  Configuration
 ***********************************************************************/
#define LMG_DEF_TSAP_ID  0


#define LMG_DNS_USE_DNSLIB   1
#define LMG_DNS_USE_INET     2
#define LMG_DNS_DISABLED     3

/***********************************************************************
                  Defines for SSAP  Configuration
 ***********************************************************************/
/* MGCP version & Profile Info */
#define LMG_VER_PROF_MGCP_RFC2705_1_0       ((U32) 0x00020001)
#define LMG_VER_PROF_MGCP_TGCP_1_0          ((U32) 0x00020002)
#define LMG_VER_PROF_MGCP_NCS_1_0           ((U32) 0x00020003)


/* MEGACO Version */
#define LMG_VER_PROF_MGCO_H248_1_0           ((U32) 0x00030001)
#define LMG_VER_PROF_MGCO_H248_2_0           ((U32) 0x00030002)
#define LMG_VER_PROF_MGCO_H248_3_0           ((U32) 0x00030003)

/* Following def is used to get MEGACO version in 1, 2, 3 format */
#define LMG_GET_MGCO_VER                     ((U32) 0x0000ffff)
/* Following def is used to get MEGACO version in LMG format */
#define LMG_GET_MGCO_LMG_VER                 ((U32) 0x00030000)



/***********************************************************************
                  Defines for Peer  Configuration
 ***********************************************************************/
/* new configuration types */
/* Some of defines are in gen.h..so take care while modifying these defines */
#define STGCPENTCFG                     158
#define STMTDGCPENTCFG                  159
#define STGCPSRVRCFG                    160
/* Protocol Type */
#define LMG_PROTOCOL_NONE               0
#define LMG_PROTOCOL_MGCP               1
#define LMG_PROTOCOL_MGCO               2

/*
 *   Transport Types - UDP, TCP , SCTP or MTP3
 */
#define LMG_TPT_NONE                    0
#define LMG_TPT_UDP                     1
#define LMG_TPT_TCP                     2
#define LMG_TPT_SCTP                    3
#define LMG_TPT_MTP3                    4


/* Encoding Scheme */
#define LMG_ENCODE_NONE                 0
#define LMG_ENCODE_BIN                  1
#define LMG_ENCODE_TXT                  2

/* defines for mgcPriority */
#define     LMG_MGC_PRIMARY               1
#define     LMG_MGC_SECONDARY             2

/* defines for Order of Resolution */
#define     LMG_RES_IPV4                  1
#define     LMG_RES_IPV6                  2
#define     LMG_RES_IPV4_IPV6             3
#define     LMG_RES_IPV6_IPV4             4
/***********************************************************************
                     Defines for Status Messages
 ***********************************************************************/

/***********************************************************************
                     Defines for Transport SAP Status 
 ***********************************************************************/
/* SAP states */
#define LMG_SAP_UBND_DIS                  1      /* unbound */
#define LMG_SAP_BND_ENB                   2      /* bound and enabled */
#define LMG_SAP_BND_DIS                   3      /* bound but disabled */
#define LMG_SAP_WAIT_BNDENB               4      /* waiting for state 2 */
#define LMG_SAP_WAIT_BNDDIS               5      /* waiting for state 3 */
#define LMG_SAP_UBND_ENB                  6
#define LMG_SAP_WAIT_UBNDENB              7
#define LMG_SAP_DELETED                   8



/***********************************************************************
                     Defines for Peer Status 
 ***********************************************************************/
/* States defined for a Peer */
#define LMG_PEER_STATE_NULL          0    /* Allocated */
#define LMG_PEER_STATE_RESOLVING     1    /* Under Resolution */
#define LMG_PEER_STATE_AWAIT_REG     2    /* Awaiting Registration */
#define LMG_PEER_STATE_CONNECT       3    /* Waiting for establishment
                                               of TCP connection */
#define LMG_PEER_STATE_REGISTER      4    /* Waiting to complete Reg. */
#define LMG_PEER_STATE_ACTIVE        5    /* Peer ready to receive/send txn*/
#define LMG_PEER_STATE_DISCONNECTED  6    /* Peer Disconnected */
#define LMG_PEER_STATE_UNDR_HNDOFF   7    /* Peer Under Handoff */
#define LMG_PEER_STATE_FAILOVER      8    /* Peer in failover mode */
                                               
/* lmg_h_005.main_1: Added new peer state for version negotiation with peer */
#define LMG_PEER_STATE_VER_UNSUPP    9   /* Peer support different version */
#define LMG_PEER_STATE_UNDR_RESTART 10  /* Peer Under Handoff */

#define LMG_INVALID_PEER_PORT           -1

#define LMG_MAX_DEF_LSTNR               10
#define LMG_MAX_PEER_ENT                10
#define LMG_MAX_NET_ADDR                16 
/* 3gpp prof-neg */
#define LMG_MAX_PROFILES                15 

/***********************************************************************
                    Defines for Server Status 
 ***********************************************************************/

/* Listener States */
#define LMG_LSTNR_STATE_NULL              0      /* Allocated */
#define LMG_LSTNR_STATE_CONNECTING        1      /* Waiting for ConCfm */
#define LMG_LSTNR_STATE_CONNECTED         2      /* Active */


/***********************************************************************
                    Defines for Status Indication
 ***********************************************************************/
#define LMG_EVENT_HIT_BNDCFM            (LCM_EVENT_LYR_SPECIFIC + 1)
#define LMG_EVENT_HIT_CONCFM            (LCM_EVENT_LYR_SPECIFIC + 2)
#define LMG_EVENT_HIT_DISCIND           (LCM_EVENT_LYR_SPECIFIC + 3)
#define LMG_EVENT_HIT_UDATIND           (LCM_EVENT_LYR_SPECIFIC + 4)
#define LMG_EVENT_HIT_CONIND            (LCM_EVENT_LYR_SPECIFIC + 5)
#define LMG_EVENT_HIT_DATIND            (LCM_EVENT_LYR_SPECIFIC + 6)


#define LMG_EVENT_MGT_BNDREQ            (LCM_EVENT_LYR_SPECIFIC + 5)
#define LMG_EVENT_MGT_UBNDREQ           (LCM_EVENT_LYR_SPECIFIC + 6)
#define LMG_EVENT_MGT_CNTRLREQ          (LCM_EVENT_LYR_SPECIFIC + 7)

#define LMG_EVENT_MGT_AUDITREQ          (LCM_EVENT_LYR_SPECIFIC + 82)

#define LMG_EVENT_MGT_MGCPTXNREQ        (LCM_EVENT_LYR_SPECIFIC + 8)
#define LMG_EVENT_MGT_MGCPTXNIND        (LCM_EVENT_LYR_SPECIFIC + 9)
#define LMG_EVENT_MGT_MGCOTXNREQ        (LCM_EVENT_LYR_SPECIFIC + 10)
#define LMG_EVENT_MGT_MGCOTXNIND        (LCM_EVENT_LYR_SPECIFIC + 11)

#define LMG_EVENT_OUTOF_TPT_SRVRS       (LCM_EVENT_LYR_SPECIFIC + 26)
#define LMG_EVENT_PEERLST_EXHAUSTED     (LCM_EVENT_LYR_SPECIFIC + 27)

#define LMG_EVENT_TPTSRV                (LCM_EVENT_LYR_SPECIFIC + 28)
#define LMG_EVENT_SSAP_ENABLED          (LCM_EVENT_LYR_SPECIFIC + 29)
#define LMG_EVENT_NS_NOT_RESPONDING     (LCM_EVENT_LYR_SPECIFIC + 30)
#define LMG_EVENT_TPT_FAILED            (LCM_EVENT_LYR_SPECIFIC + 31)
#define LMG_EVENT_PEER_ENABLED          (LCM_EVENT_LYR_SPECIFIC + 32)
#define LMG_EVENT_PEER_REMOVED          (LCM_EVENT_LYR_SPECIFIC + 33)
#define LMG_EVENT_BND_FAIL              (LCM_EVENT_LYR_SPECIFIC + 34)
#define LMG_EVENT_PEER_DISCOVERED       (LCM_EVENT_LYR_SPECIFIC + 35)
#define LMG_EVENT_PEER_CFG_FAIL         (LCM_EVENT_LYR_SPECIFIC + 36)
#define LMG_EVENT_SRVR_CFG_FAIL         (LCM_EVENT_LYR_SPECIFIC + 37)
#define LMG_EVENT_SRVR_OPEN_FAIL        (LCM_EVENT_LYR_SPECIFIC + 38)
#define LMG_EVENT_PEER_HANDOFF_FAILURE  (LCM_EVENT_LYR_SPECIFIC + 39)
#define LMG_EVENT_PEER_HANDOFF_SUCCESS  (LCM_EVENT_LYR_SPECIFIC + 40)
#define LMG_EVENT_ALL_MGC_FAILED        (LCM_EVENT_LYR_SPECIFIC + 41)
#define LMG_EVENT_MGC_FAILED            (LCM_EVENT_LYR_SPECIFIC + 42)
#define LMG_EVENT_REJECT_DUPMGC         (LCM_EVENT_LYR_SPECIFIC + 43)
#define LMG_EVENT_NEWNTFY_DELETED       (LCM_EVENT_LYR_SPECIFIC + 44)
#define LMG_EVENT_SSAP_DIS_FAIL         (LCM_EVENT_LYR_SPECIFIC + 45)
#define LMG_EVENT_SSAP_DEL_FAIL         (LCM_EVENT_LYR_SPECIFIC + 46)
#define LMG_EVENT_TSAP_DIS_FAIL         (LCM_EVENT_LYR_SPECIFIC + 47)
#define LMG_EVENT_OUTOF_TCP_CONNS       (LCM_EVENT_LYR_SPECIFIC + 48)
#define LMG_EVENT_AFAILOVER_FAILURE     (LCM_EVENT_LYR_SPECIFIC + 49)
#define LMG_EVENT_AFAILOVER_SUCCESS     (LCM_EVENT_LYR_SPECIFIC + 50)
#define LMG_EVENT_MATED_PEER_SWITCHOVER (LCM_EVENT_LYR_SPECIFIC + 51)
#define LMG_EVENT_DATA_TX               (LCM_EVENT_LYR_SPECIFIC + 52)
#define LMG_EVENT_TSAP_RECVRY_SUCCESS   (LCM_EVENT_LYR_SPECIFIC + 53)
#define LMG_EVENT_TSAP_RECVRY_FAILED    (LCM_EVENT_LYR_SPECIFIC + 54)
#define LMG_EVENT_MTDPEER_CFG_FAIL      (LCM_EVENT_LYR_SPECIFIC + 55)
#define LMG_EVENT_ENDP_CFG_FAIL         (LCM_EVENT_LYR_SPECIFIC + 56)
#define LMG_EVENT_SCT_BNDCFM            (LCM_EVENT_LYR_SPECIFIC + 57)
#define LMG_EVENT_SCT_ENDPOPENCFM       (LCM_EVENT_LYR_SPECIFIC + 58)
#define LMG_EVENT_SCT_ENDPCLOSECFM      (LCM_EVENT_LYR_SPECIFIC + 59)
#define LMG_EVENT_SCT_ASSOCIND          (LCM_EVENT_LYR_SPECIFIC + 60)
#define LMG_EVENT_SCT_ASSOCCFM          (LCM_EVENT_LYR_SPECIFIC + 61)
#define LMG_EVENT_SCT_TERMIND           (LCM_EVENT_LYR_SPECIFIC + 62)
#define LMG_EVENT_SCT_TERMCFM           (LCM_EVENT_LYR_SPECIFIC + 63)
#define LMG_EVENT_SCT_DATIND            (LCM_EVENT_LYR_SPECIFIC + 64)
#define LMG_EVENT_SCT_STACFM            (LCM_EVENT_LYR_SPECIFIC + 65)
#define LMG_EVENT_SCT_STAIND            (LCM_EVENT_LYR_SPECIFIC + 66)
#define LMG_EVENT_SCT_SENDFAIL          (LCM_EVENT_LYR_SPECIFIC + 67)
#define LMG_EVENT_SCT_COMMDOWN          (LCM_EVENT_LYR_SPECIFIC + 68)
#define LMG_EVENT_SCT_FLCIND            (LCM_EVENT_LYR_SPECIFIC + 69)
#ifdef GCP_CH
#define LMG_EVENT_MGT_MGCOCOMMAND       (LCM_EVENT_LYR_SPECIFIC + 79)
#define LMG_EVENT_MGT_MGCOUPDCNTXT      (LCM_EVENT_LYR_SPECIFIC + 80)
#define LMG_EVENT_MGT_MGCOIND           (LCM_EVENT_LYR_SPECIFIC + 81)
#endif /* GCP_CH */
/* 3gpp prof-neg */
#define LMG_EVENT_ALL_PROF_FAILED       (LCM_EVENT_LYR_SPECIFIC + 74)
#ifdef GCP_VER_2_1
/*3gpp req1-4 adding new LM sta ind event*/
#define LMG_EVENT_CMDPERREP_EXCEEDED    (LCM_EVENT_LYR_SPECIFIC + 75)
#endif

/* MTP3 Transport Related Events */
#define LMG_EVENT_SNT_BNDCFM            (LCM_EVENT_LYR_SPECIFIC + 70)
#define LMG_EVENT_SNT_STAIND            (LCM_EVENT_LYR_SPECIFIC + 71)
#define LMG_EVENT_SNT_STACFM            (LCM_EVENT_LYR_SPECIFIC + 72)
#define LMG_EVENT_SNT_UDATIND           (LCM_EVENT_LYR_SPECIFIC + 73)

#if (defined(GCP_VER_2_1) && defined(GCP_NTFY_AVL))
#define LMG_EVENT_NTFY_RSTRC_STARTED    (LCM_EVENT_LYR_SPECIFIC + 76)
#define LMG_EVENT_NTFY_RSTRC_STOPED     (LCM_EVENT_LYR_SPECIFIC + 77)
#endif /* GCP_VER_2_1 && GCP_NTFY_AVL */

#define LMG_EVENT_STDBY_RSTR_FAILED     (LCM_EVENT_LYR_SPECIFIC + 78)


/* Status Indication Causes */
#define LMG_CAUSE_UNKNOWN               (LCM_CAUSE_LYR_SPECIFIC + 5)
#define LMG_CAUSE_MGMT_INITIATED        (LCM_CAUSE_LYR_SPECIFIC + 6)
#define LMG_CAUSE_TPT_FAILURE           (LCM_CAUSE_LYR_SPECIFIC + 7)
#define LMG_CAUSE_NS_NOT_RESPONDING     (LCM_CAUSE_LYR_SPECIFIC + 8)
#define LMG_CAUSE_PEER_NOT_RESPONDING   (LCM_CAUSE_LYR_SPECIFIC + 9)
#define LMG_CAUSE_RESL_FAILED           (LCM_CAUSE_LYR_SPECIFIC + 10)
#define LMG_CAUSE_SAP_BNDENB            (LCM_CAUSE_LYR_SPECIFIC + 11)
#define LMG_CAUSE_SAP_BNDDIS            (LCM_CAUSE_LYR_SPECIFIC + 12)
#define LMG_CAUSE_RSIP_ACCEPTED         (LCM_CAUSE_LYR_SPECIFIC + 13)
#define LMG_CAUSE_RSIP_NAK              (LCM_EVENT_LYR_SPECIFIC + 14)
#define LMG_CAUSE_NEW_NTFY_ENTITY       (LCM_EVENT_LYR_SPECIFIC + 15)
#define LMG_CAUSE_SRVCCHNG_ACCEPTED     (LCM_CAUSE_LYR_SPECIFIC + 16)
#define LMG_CAUSE_SRVCCHNG_FAILED       (LCM_CAUSE_LYR_SPECIFIC + 17)
#define LMG_CAUSE_CONN_FAILURE          (LCM_CAUSE_LYR_SPECIFIC + 18)
#define LMG_CAUSE_HANDOFF               (LCM_CAUSE_LYR_SPECIFIC + 19)
#define LMG_CAUSE_LCL_FAILURE           (LCM_CAUSE_LYR_SPECIFIC + 20)
#define LMG_CAUSE_PEER_REJECT           (LCM_CAUSE_LYR_SPECIFIC + 21)
#define LMG_CAUSE_MGC_FAILED            (LCM_CAUSE_LYR_SPECIFIC + 22)
#define LMG_CAUSE_USER_DEL_PEER         (LCM_CAUSE_LYR_SPECIFIC + 23)
#define LMG_CAUSE_SEND_REGISTER         (LCM_CAUSE_LYR_SPECIFIC + 24)
#define LMG_CAUSE_DNS_DISABLED          (LCM_CAUSE_LYR_SPECIFIC + 25)
#define LMG_CAUSE_RSRC_UNAVAIL          (LCM_CAUSE_LYR_SPECIFIC + 26)
#define LMG_CAUSE_INVALID_PARMS         (LCM_CAUSE_LYR_SPECIFIC + 27)
#define LMG_CAUSE_SSAP_INACTIVE         (LCM_CAUSE_LYR_SPECIFIC + 28)
#define LMG_CAUSE_INVALID_SSAP          (LCM_CAUSE_LYR_SPECIFIC + 29)
#define LMG_CAUSE_SRVC_CHNG_ACCEPTED    (LCM_CAUSE_LYR_SPECIFIC + 30)
#define LMG_CAUSE_INV_FT_STATE          (LCM_CAUSE_LYR_SPECIFIC + 31)


#define LMG_CAUSE_INVALID_TSAPID        (LCM_CAUSE_LYR_SPECIFIC + 32)




/* Alarm Info types*/
#define LMG_ALARMINFO_NONE            0
#define LMG_ALARMINFO_PEER            1
#define LMG_ALARMINFO_SAP             2
#define LMG_ALARMINFO_MEM             3
#define LMG_ALARMINFO_SRVR            4
#define LMG_ALARMINFO_PEER_STA        5
#define LMG_ALARMINFO_SSAP_STA        6
#define LMG_ALARMINFO_PAR             7
#define LMG_ALARMINFO_MATED_PEER      8
#define LMG_ALARMINFO_ENDPT           9

/* lmg_h_007.main_1 : Added LCN Feature */
#ifdef GCP_LCN_APP_USE
#define LMG_ALARMINFO_SCTP_ASSOC      10
#define  LMG_EVENT_SSID_LESS          (LCM_EVENT_LYR_SPECIFIC+255) 
#endif /* GCP_LCN_APP_USE */

#define LMG_ALARMINFO_INVSAPID       -1


/* parameter types */
#define LMG_PAR_TPTADDR                 1
#define LMG_PAR_MBUF                    2
#define LMG_PAR_CHOICE                  3
#define LMG_PAR_SPID                    4
#define LMG_PAR_ASSOC                   5

/* defines for LMGStaInd */
#define LMG_SRV_ENABLED                  1
#define LMG_SRV_DISABLED                 2

#define LMG_PEER_ENT_ENABLED             3
#define LMG_PEER_ENT_DISABLED            4

#define LMG_BND_RETRY_CNT                 0      /* bind re-try count */


/***********************************************************************
              Defines for Trace Indication 
 ***********************************************************************/

#define LMG_TRC_EVENT_DNSTX              1
#define LMG_TRC_EVENT_DNSRX              2

#define LMG_TRC_EVENT_MGCPTX             3
#define LMG_TRC_EVENT_MGCPRX             4

#define LMG_TRC_EVENT_MGCOTX             5
#define LMG_TRC_EVENT_MGCORX             6

/***********************************************************************
               Defines for Confirm Primitives 
 ***********************************************************************/
#define LMG_REASON_INET_INIT_FAILED     (LCM_REASON_LYR_SPECIFIC + 1)
#define LMG_REASON_TSAPCFG_NOT_DONE     (LCM_REASON_LYR_SPECIFIC + 2)
#define LMG_REASON_SRVROPEN_FAILED      (LCM_REASON_LYR_SPECIFIC + 3)
#define LMG_REASON_RESTART_FAILED       (LCM_REASON_LYR_SPECIFIC + 4)
#define LMG_REASON_INVALID_PROTOCOL     (LCM_REASON_LYR_SPECIFIC + 5)
#define LMG_REASON_HANDOFF_FAILED       (LCM_REASON_LYR_SPECIFIC + 6) 
#define LMG_REASON_INVALID_PEER_STATE   (LCM_REASON_LYR_SPECIFIC + 7)
#define LMG_REASON_FAILOVER_FAILED      (LCM_REASON_LYR_SPECIFIC + 8)

#ifdef ZG
#define LMG_REASON_PSFCFG_NOT_DONE      (LCM_REASON_LYR_SPECIFIC + 15)
#endif /* ZG */

#define LMG_REASON_ENDPCFG_ALREADY_DONE (LCM_REASON_LYR_SPECIFIC + 16)

/* lmg_h_001.main_6: MID verification changes */
#define LMG_REASON_INVALID_MID          (LCM_REASON_LYR_SPECIFIC + 17)



/***********************************************************************
               Defines for RUG 
 ***********************************************************************/
#ifdef MG_RUG
#define LMG_SET_BITVECTOR_BIT(_bitVector, _bit)                          \
{                                                                        \
   _bitVector |= _bit;                                                   \
}
#endif /* MG_RUG */



/*
 *   New hash defines added for SCTP support
 *   ICNC : Change some of the defines e.g. -
 *          LMG_MAX_DEF_ENDPTS,
 *          LMG_MAX_DEF_TSAPS
 *          to reflect the actual limits later
 */



/*
 *   maximum number of end point configurations allowed
 *   at a time
 */
#define LMG_MAX_DEF_ENDPTS     100

/*
 *   maximum number of end point configurations allowed
 *   at a time
 */
#define LMG_MAX_DEF_TSAPS      100

/*
 *   hash define for indicating that the TSAP ID is invalid;
 *   required in a multiple TSAP environment
 */
#define MG_INVALID_TSAP_ID     -1

/*
 *   hash defines for end point states
 */
#define LMG_EP_STATE_INIT      1
#define LMG_EP_STATE_WAIT_CFM  2
#define LMG_EP_STATE_READY     3

/*
 *   hash defines for end point states
 */
#define LMG_ASSOC_STATE_DOWN      1
#define LMG_ASSOC_STATE_WAIT_CFM  2
#define LMG_ASSOC_STATE_ACTIVE    3

/*
 *   hash define for indicating the size of the association
 *   id
 */
#define MG_ASSOCID_LEN            sizeof(UConnId)

/* 004.main_1: Service change profile information */
#define LMG_MAX_PROF_LEN         64    /* Max length of profile */


/* hash define for indicating the size of DPC */
#define  MG_DPC_LEN                sizeof(Dpc)

/*
 *   hash defines for indicating the transport type of TSAP -
 *   SCTP , TUCL or MTP3
 */
#define LMG_PROV_TYPE_TUCL        1
#define LMG_PROV_TYPE_SCTP        2
#define LMG_PROV_TYPE_MTP3        3
/*
 *   hash define for the maximum number of outgoing
 *   SCTP streams - basically the physical limit
 */
#define LMG_MAX_OUT_STRMS         50
/*   #define LMG_MAX_OUT_STRMS         65535   */


/*
 *   Maximum number of simultaneous associations that can
 *   be handled - SCTP protocol limit
 */

#define LMG_MAX_ASSOCS            65535


/* new elements for SCTP */
#define STSCTPSAP       175          /* SCTP SAP */
#define STSCTPENDP      176          /* SCTP Endpoint */


/* lmg_h_001.main_1: Default value of SCTP TOS: this is used in case
 *                   the LM does not provide any values in the TOS cfg
 *                   in peer/endpoint */
#define LMG_DFLT_SCTP_TOS      8


/*
 *   New hash defines added for MTP support
 */

/* Signalling Point Code State in a Route */
#define SP_ONLINE    0x01       /* Signalling point is online */
#define SP_OFFLINE  ~0x01       /* Signalling point is offline */
/* #define SP_CONG   0x02          Signalling point is congested is defined
                                   in gen.h as it is used by upper interface
                                   and layer manager
*/
#define SP_UNCONG   ~0x02       /* Signalling point is uncongested */

#define  LMG_ITU_SLS_RANGE    15    /* Max SLS Range for ITU */
#define  LMG_ANSI_SLS_RANGE   32    /* Max SLS Range for ANSI 5 Bit SLS */
#define  LMG_INVALID_DPC      0xffffffff
#define  LMG_SW_ITU        SW_ITU
#define  LMG_SW_ANS        SW_ANSI



#define AFAILOVER_WF         82
#define AFAILOVER_CF         (AFAILOVER_WF + 1)
#define ARESTART_RESTORED    (AFAILOVER_WF + 2)



/***********************************************************************
              error codes for packing/unpacking functions
***********************************************************************/

#define ERRLMG         0            /* reserved */
#define ELMGXXX        (ERRLMG)     /* reserved */

#define   ELMG001      (ERRLMG +    1)    /*        lmg.c:2489 */
#define   ELMG002      (ERRLMG +    2)    /*        lmg.c:2501 */
#define   ELMG003      (ERRLMG +    3)    /*        lmg.c:2549 */
#define   ELMG004      (ERRLMG +    4)    /*        lmg.c:2561 */
#define   ELMG005      (ERRLMG +    5)    /*        lmg.c:2606 */
#define   ELMG006      (ERRLMG +    6)    /*        lmg.c:2618 */
#define   ELMG007      (ERRLMG +    7)    /*        lmg.c:2666 */
#define   ELMG008      (ERRLMG +    8)    /*        lmg.c:2678 */
#define   ELMG009      (ERRLMG +    9)    /*        lmg.c:2723 */
#define   ELMG010      (ERRLMG +   10)    /*        lmg.c:2735 */
#define   ELMG011      (ERRLMG +   11)    /*        lmg.c:2783 */
#define   ELMG012      (ERRLMG +   12)    /*        lmg.c:2795 */
#define   ELMG013      (ERRLMG +   13)    /*        lmg.c:2842 */
#define   ELMG014      (ERRLMG +   14)    /*        lmg.c:2854 */
#define   ELMG015      (ERRLMG +   15)    /*        lmg.c:2858 */
#define   ELMG016      (ERRLMG +   16)    /*        lmg.c:2903 */
#define   ELMG017      (ERRLMG +   17)    /*        lmg.c:2915 */
#define   ELMG018      (ERRLMG +   18)    /*        lmg.c:2962 */
#define   ELMG019      (ERRLMG +   19)    /*        lmg.c:2975 */
#define   ELMG020      (ERRLMG +   20)    /*        lmg.c:5285 */
#define   ELMG021      (ERRLMG +   21)    /*        lmg.c:5332 */
#define   ELMG022      (ERRLMG +   22)    /*        lmg.c:5379 */
#define   ELMG023      (ERRLMG +   23)    /*        lmg.c:5426 */
#define   ELMG024      (ERRLMG +   24)    /*        lmg.c:5473 */
#define   ELMG025      (ERRLMG +   25)    /*        lmg.c:5521 */
#define   ELMG026      (ERRLMG +   26)    /*        lmg.c:5562 */
#define   ELMG027      (ERRLMG +   27)    /*        lmg.c:5570 */
#define   ELMG028      (ERRLMG +   28)    /*        lmg.c:5617 */
#define   ELMG029      (ERRLMG +   29)    /*        lmg.c:5664 */
#define   ELMG030      (ERRLMG +   30)    /*        lmg.c:5707 */
#define   ELMG031      (ERRLMG +   31)    /*        lmg.c:5719 */
#define   ELMG032      (ERRLMG +   32)    /*        lmg.c:5769 */

#endif /* not defined __LMGH__ */

/********************************************************************30**
 
         End of file:     lmg.h@@/main/7 - Fri Dec 11 01:04:30 2009
 
*********************************************************************31*/
/********************************************************************40**
 
        Notes:
 
*********************************************************************41*/
/********************************************************************50**
 
*********************************************************************51*/

/********************************************************************60**
 
        Revision history:
 
*********************************************************************61*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      rrp  1. initial release.
             mg007.101bbk  1. Added  LMG_INVALID_PEER_PORT define
/main/2      ---       pk  1. Modified for new release 1.2
/main/3      ---      ra   1. GCP 1.3 release
/main/4      ---      ka   1. Changes for Release v 1.4
/main/1      ---      pk   1. GCP 1.5 release
/main/1     001.main_1 ra  1. Added a hash def for the default value of
                              TOS. This is used in case the LM does not
                              provide any TOS in endpoint/peer cfg.
            002.main_1 ra   1. Added new define for rspAckEnb bit value
                              to configurable sending immediate rspAckRsp.
                           2. Moved the bit spaces around a bit. MGCP now
                              occupies the first 4 bits, MEGACO the last 4.
            003.main_1 ps  1. Added default value for MG/MGC pending limit 
      lmg_h_004.main_1 gk  1. Service change profile information
      lmg_h_005.main_1 gk  1. Added new peer state for version negotiation with peer
      lmg_h_006.main_1 gk  1. failedTransactionLimit default value
      lmg_h_007.main_1 rb  1. Added LCN Feature.
/main/2      ---       gk  1. Added a hash def for the default value of
                              TOS. This is used in case the LM does not
                              provide any TOS in endpoint/peer cfg.
            2. Added new define for rspAckEnb bit value
                              to configurable sending immediate rspAckRsp.
            3. Moved the bit spaces around a bit. MGCP now
                              occupies the first 4 bits, MEGACO the last 4.
            4. Added default value for MG/MGC pending limit
            5. Service change profile information
/main/3      ---      gk   1. Releasing main/1 patches
/main/4      ---      gk   1. failedTransactionLimit default value
                           2. Added LCN Feature.
/main/5      ---      ac   1. Added Macro for Profile Negotiation Failure.
/main/6      ----     sy   GCP 2.1 release
/main/7      ---      lmg_h_001.main_6   gk   1. MID verification changes
*********************************************************************91*/
