/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:    Common SDP
  
     Type:    C include file 
  
     Desc:    Structures, variables and typedefs required by SDP
 
     File:    cm_sdp.x

     Sid:      cm_sdp.x@@/main/24 - Wed Sep 22 19:50:23 2010
  
     Prg:     rrp
  
*********************************************************************21*/


/* header include files (.h) */
#include "cm_mblk.h"       /* common mblk alloc */


/* header/extern include files (.x) */
#include "cm_mblk.x"       /* common mem block alloc */


#ifndef __CMSDPX__
#define __CMSDPX__

#ifdef __cplusplus
extern "C" {
#endif
#ifndef CM_SDP_OPAQUE
#ifndef CM_SDP_V_2


/* cm_sdp_x_001.main_21: Removed unnecessary structures */
/* RFC 822 and 1035 is imcompatible with RFC 2327 */
typedef TknStrOSXL CmSdpAddr;

typedef CmSdpAddr CmSdpConnAddr;

typedef struct cmSdpOrig
{
   TknPres    pres;
   TknStrOSXL usrName;
   TknU32     sessId;
   TknU32     sessVer;
   TknU8      netType;
   TknU8      addrType;
   CmSdpAddr  sdpAddr;
}CmSdpOrig;


typedef struct cmSdpConn
{
   TknPres       pres;
   TknU8         netType;
   TknU8         addrType;
   CmSdpConnAddr sdpAddr;
}CmSdpConn;


typedef struct cmSdpConnSet
{
   TknU16       numComp;
   CmSdpConn    infoSet[CM_SDP_MAX_CONN];
}CmSdpConnSet;

typedef struct cmSdpTypedTime
{
   TknPres   pres;
   TknStr32  val;
   TknU8     unit;
}CmSdpTypedTime;

typedef struct cmSdpZoneAdj
{
   TknPres        pres;
   TknStr32       time;
   CmSdpTypedTime typedTime;
}CmSdpZoneAdj;


typedef struct cmSdpTypedTimeSet
{
   TknU16         numComp;
   CmSdpTypedTime typedTime[CM_SDP_MAX_TYPED_TIME];
}CmSdpTypedTimeSet;

typedef struct cmSdpRepField
{
   TknPres           pres;
   CmSdpTypedTime    repInterval;
   CmSdpTypedTime    actvDur;
   CmSdpTypedTimeSet offsetList;
}CmSdpRepField;

typedef struct cmSdpRepFieldSet
{
   TknU16            numComp;
   CmSdpRepField     repField[CM_SDP_MAX_REP_FIELD];
}CmSdpRepFieldSet;

typedef struct cmSdpZoneAdjSet
{
   TknU16        numComp;
   CmSdpZoneAdj  zoneAdj[CM_SDP_MAX_ZONE_ADJ];
}CmSdpZoneAdjSet;

typedef struct cmSdpOpTime
{
   TknPres            pres;
   TknStr32           startTime;
   TknStr32           stopTime;
   CmSdpRepFieldSet   repFieldSet;
}CmSdpOpTime;

typedef struct cmSdpOpTimeSet
{
   TknU16          numComp;
   CmSdpOpTime     **sdpOpTime;
}CmSdpOpTimeSet;

typedef struct cmSdpTime
{
   TknPres         pres;
   CmSdpOpTimeSet  sdpOpTimeSet;
   CmSdpZoneAdjSet zoneAdjSet;
}CmSdpTime;

typedef struct cmSdpKeyType
{
   TknPres    pres;
   TknU8      keyType;  /*see defines */
   TknStrOSXL key_data;
}CmSdpKeyType;

typedef struct cmSdpAttr
{
   TknPres  pres;
   TknStr32 attrType;  /* evaluate constraints */
   TknStr32 attrVal;   /* evaluate constraints */
}CmSdpAttr;

typedef struct cmSdpAttrSet
{
   TknU16         numComp;
   CmSdpAttr      attr[CM_SDP_MAX_ATTR];
}CmSdpAttrSet;

typedef struct cmSdpEmailSet
{
   TknU16         numComp;
   TknStrOSXL     email[CM_SDP_MAX_EMAIL];
}CmSdpEmailSet;

typedef struct cmSdpPhoneSet
{
   TknU16         numComp;
   TknStrOSXL     phone[CM_SDP_MAX_PHONE];
}CmSdpPhoneSet;

typedef struct cmSdpBw
{
   TknPres        pres;
   TknStrOSXL     bwType;
   TknU32         bWidth;
}CmSdpBw;

typedef struct cmSdpBwSet
{
   TknU16         numComp;
   CmSdpBw        sdpBw[CM_SDP_MAX_BW];
}CmSdpBwSet;

typedef TknStrOSXL  CmSdpFmt;

typedef struct cmSdpFmtSet
{
   TknU16       numComp;
   CmSdpFmt     fmtInfo[CM_SDP_MAX_FMT];
}CmSdpFmtSet;

typedef struct cmSdpMediaField
{
   TknPres      pres;
   TknU8        mediaType;  /* see defines */
   TknU16       port;
   TknU16       portInt;
   TknStr32     proto;
   CmSdpFmtSet  fmtSet;
}CmSdpMediaField;

typedef struct cmSdpMediaDesc
{
   TknPres          pres;
   CmSdpMediaField  field;
   TknStrOSXL       info;
   CmSdpConnSet     connSet;
   CmSdpBwSet       bwSet;
   CmSdpKeyType     keyType;
   CmSdpAttrSet     attrSet;
}CmSdpMediaDesc;

typedef struct cmSdpMediaDescSet
{
   TknU16             numComp;
   CmSdpMediaDesc     **mediaDesc;
}CmSdpMediaDescSet;

typedef struct cmSdpInfo
{
   TknPres           pres;
   TknU16            ver;
   CmSdpOrig         orig;
   TknStrOSXL        sessName;
   TknStrOSXL        info;
   TknStrOSXL        uri;
   CmSdpEmailSet     emailSet;
   CmSdpPhoneSet     phoneSet;
   CmSdpConn         conn;
   CmSdpBwSet        bwSet;
   CmSdpTime         sdpTime;
   CmSdpKeyType      keyType;
   CmSdpAttrSet      attrSet;
   CmSdpMediaDescSet mediaDescSet;
}CmSdpInfo;

typedef struct cmSdpInfoSet
{
   TknU16    numComp;
   CmSdpInfo **info;  
}CmSdpInfoSet;


#ifdef LCCMSDP
/* packing unpacking functions */

EXTERN S16 cmUnpkCmSdpInfoSet ARGS((
CmSdpInfoSet                *unpkParam,   /**/
Ptr                         ptr,
CmIntfVer                   intfVer,       /*  extra field added */
Buffer                      *mBuf          /* message buffer */
));

EXTERN S16 cmPkCmSdpInfoSet ARGS((
CmSdpInfoSet                *pkParam,     /**/
CmIntfVer                   intfVer,      /*  extra field added */
Buffer                      *mBuf         /* message buffer */
));

EXTERN S16 cmUnpkCmSdpInfo ARGS((
CmSdpInfo                   *unpkParam,   /**/
Buffer                      *mBuf,         /* message buffer */
Ptr                         ptr
));

EXTERN S16 cmPkCmSdpInfo ARGS((
CmSdpInfo                   *pkParam,     /**/
Buffer                      *mBuf         /* message buffer */
));
#endif /* LCCMSDP */
#endif /* CM_SDP_V_2 */

#ifdef  CM_SDP_V_2 

#ifdef CM_SDP_V_3
typedef struct cmSdpAttrCapDesc  CmSdpAttrCapDesc;  /* forward declaration */
typedef   struct   cmSdpAttrCapParam
   {
      TknU8               type;
      union
      {
         struct{
            TknU16         numComp;
            struct cmSdpBw        **sdpBw;
         }  bwSet;
         struct{
            TknU16         numComp;
            struct cmSdpAttr      **attr;
         }  attrSet;
      }u;
   } CmSdpAttrCapParam;
#endif

typedef TknStrOSXL CmSdpIpFQDN;

typedef struct cmSdpIp4Unicast
{
   TknU8            b[4];
} CmSdpIp4Unicast;


typedef struct cmSdpIp4Multicast
{
   TknPres           pres;
   CmSdpIp4Unicast   ip;
   TknU8             ttl;
   TknU32            numAddr;
} CmSdpIp4Multicast;

/* 001.main_15 RFC 4566 allow unknown net type and addr type*/
typedef struct cmSdpAddrType
{
   TknStrOSXL   type;
   TknStrOSXL   addrData; /* if unknown */
}CmSdpAddrType;
typedef struct cmSdpNetType
{
   TknU8        type;
   TknStrOSXL   netData; /* if unknown */
}CmSdpNetType;

typedef struct cmSdpIp4Addr
{
  TknU8      addrType;
   union
   {
      CmSdpIpFQDN  fqdn;
      CmSdpIp4Unicast   ip;
   } u;
} CmSdpIp4Addr;

typedef struct cmSdpIp4Conn
{
   TknU8            addrType;
   union
   {
      CmSdpIpFQDN  fqdn;
      CmSdpIp4Unicast   uniIp;
      CmSdpIp4Multicast multiIp;
   } u;
} CmSdpIp4Conn;
/* RFC   4566 IP6 structure extended */
typedef struct cmSdpOptIp4Unicast
{
   TknPres         pres;
   CmSdpIp4Unicast ip4;
}CmSdpOptIp4Unicast;
typedef struct cmSdpIp6
{
   TknPres             pres;
   TknStrOSXL        hexPart;
   CmSdpOptIp4Unicast  optIp4;
}CmSdpIp6;

/* 001.main_15 RFC 4566 : IPV6_MULTI removed from V_3 */
typedef struct cmSdpIp6MultiCast
{
   TknPres             pres;
   TknStrOSXL        hexPart;
/* 001.main_15 RFC 4566 these components are not there in the RFC 4566 *
*   CmSdpIp4Multicast   ip4Multi; *
*   TknU8               ttl; */
   TknU32              numAddr;
} CmSdpIp6MultiCast;


typedef struct cmSdpIp6Addr
{
   TknU8             addrType;
   union
   {
      CmSdpIpFQDN  fqdn;
      CmSdpIp6          ip;
/* 001.main_15 RFC 4566 : IPV6_MULTI removed from V_3 */
      CmSdpIp6MultiCast      ipMulti;    /* IP v6 multicast addr */
   } u;
} CmSdpIp6Addr;

/* cm_sdp_x_001.main_22: removed cmSdpLclAddr*/
typedef struct cmSdpAddr
{
/* 001.main_15 RFC 4566 change structure type*/
   CmSdpNetType          netType;    /* can be -, IN, $, TN or ATM */
   TknU8                 addrType;
   union
   {
      CmSdpIp4Addr ip4;    /* IPV4, with no multicast as in Conn Addr */
      CmSdpIp6Addr ip6;
      TknStrOSXL  sip;
     /* CmSdpTnExtn extn; */
      TknStrOSXL  nsap;
      TknStrOSXL  e164;
      TknStrOSXL  gwid;
/* 001.main_15 RFC 4566 */
      CmSdpAddrType  unknownExtn;
   } u; 
} CmSdpAddr;

typedef struct cmSdpConn 
{
/*4566 change structure type*/
   CmSdpNetType       netType;
   TknU8              addrType;
   union
   {
      CmSdpIp4Conn ip4;     /* With multicast */
      CmSdpIp6Addr ip6;
      TknStrOSXL  sip;
    /*  CmSdpTnExtn extn; */
      TknStrOSXL  nsap;
      TknStrOSXL  e164;
      TknStrOSXL  gwid;
/* 001.main_15 RFC 4566 */
      CmSdpAddrType  unknownExtn;
   } u; 
} CmSdpConn;

typedef struct cmSdpAnycastAddr
{
   TknU8          addrType;
   union
   {
      CmSdpIp4Addr ip4;    /* IPV4, with no multicast as in Conn Addr */
      CmSdpIp6Addr ip6;
      TknStrOSXL  sip;
    /*  CmSdpTnExtn extn; */
      TknStrOSXL  nsap;
      TknStrOSXL  e164;
      TknStrOSXL  gwid;
/* 001.main_15 RFC 4566 */
      CmSdpAddrType  unknownExtn;
   } u; 
} CmSdpAnycastAddr;

typedef struct cmSdpOrig
{
   TknPres    pres;
   TknStrOSXL usrName;
   TknStrOSXL sessId;
   TknStrOSXL sessVer;
   CmSdpAddr  sdpAddr;
} CmSdpOrig;

typedef struct cmSdpOptOrig
{
   TknPres    pres;        /* Is "o=" line present? */
   TknU8      type;        /* type is CM_SDP_NIL or SPEC, or absent */
   CmSdpOrig  orig;
} CmSdpOptOrig;

typedef struct cmSdpConnSet
{
   TknU16       numComp;
   CmSdpConn    **connSet;
} CmSdpConnSet;

typedef struct cmSdpTypedTime
{
   TknPres   pres;
   TknStr32  val;
   TknU8     unit;
} CmSdpTypedTime;

typedef struct cmSdpZoneAdj
{
   TknPres        pres;
   TknStr32       time;
   CmSdpTypedTime typedTime;
} CmSdpZoneAdj;


typedef struct cmSdpTypedTimeSet
{
   TknU16         numComp;
   CmSdpTypedTime **typedTime;
} CmSdpTypedTimeSet;

typedef struct cmSdpRepField
{
   TknPres           pres;
   CmSdpTypedTime    repInterval;
   CmSdpTypedTime    actvDur;
   CmSdpTypedTimeSet offsetList;
} CmSdpRepField;

typedef struct cmSdpRepFieldSet
{
   TknU16            numComp;
   CmSdpRepField     **repField;
} CmSdpRepFieldSet;

typedef struct cmSdpZoneAdjSet
{
   TknU16        numComp;
   CmSdpZoneAdj  **zoneAdj;
} CmSdpZoneAdjSet;

typedef struct cmSdpOpTime
{
   TknPres            pres;
   TknStr32           startTime;
   TknStr32           stopTime;
   CmSdpRepFieldSet   repFieldSet;
} CmSdpOpTime;

typedef struct cmSdpOpTimeSet
{
   TknU16          numComp;
   CmSdpOpTime     **sdpOpTime;
} CmSdpOpTimeSet;

typedef struct cmSdpTime
{
   TknPres         pres;
   CmSdpOpTimeSet  sdpOpTimeSet;
   CmSdpZoneAdjSet zoneAdjSet;
} CmSdpTime;

typedef struct cmSdpKeyType
{
   TknPres    pres;
   TknU8      keyType;  /*see defines */
   TknStrOSXL key_data;
} CmSdpKeyType;

typedef struct cmSdpAttrType
{
   TknU8       type;
   TknStrOSXL  val;
} CmSdpAttrType;

typedef struct cmSdpU8OrNil
{
   TknU8             type;       /* Specified Or "-" */
   TknU8             val;        /* Value if specified */
} CmSdpU8OrNil;

typedef struct cmSdpU16OrNil
{
   TknU8              type;       /* Specified Or "-" */
   TknU16             val;        /* Value if specified */
} CmSdpU16OrNil;

typedef struct cmSdpU32OrNil
{
   TknU8              type;       /* Specified Or "-" */
   TknU32             val;        /* Value if specified */
} CmSdpU32OrNil;

typedef struct cmSdpEncName
{
   TknU8             val;        /* Value if known */
   TknStrOSXL        name;       /* String if unknown */
} CmSdpEncName;

typedef struct cmSdpAttrRtpMap
{
   TknPres           pres;       /* Present? */
   CmSdpU8OrNil      pay;        /* Payload type */
   CmSdpEncName      enc;        /* Encoding name */
   TknU32            clk;        /* Clock rate */
   TknStrOSXL        parms;      /* Encoding parameters */
} CmSdpAttrRtpMap;

typedef struct cmSdpAttrAtmMap
{
   TknPres           pres;       /* Present? */
   CmSdpU8OrNil      pay;        /* Payload type */
   CmSdpEncName      enc;        /* Encoding name */
} CmSdpAttrAtmMap;

/* cm_sdp_x_002.main_13: Modified to allow $ (CHOOSE)
 * in the place of single parameter value */
#ifdef CM_SDP_MEGACO_EECID_CHOICE
typedef struct cmSdpAttrEecId
{
   TknU8             type;       /* CHOOSE or HEX VALUE */
   TknU32            eecid;      /* if HEX Value */
}CmSdpAttrEecId;
#endif

typedef struct cmSdpAttrSilSupp
{
   TknPres           pres;       /* Present? */
   TknU8             enb;        /* Enable silence suppression? */
   CmSdpU16OrNil     timer;      /* Silence timer */
   TknU8             pref;       /* Preference */
   TknU8             sid;        /* SID use */
   CmSdpU8OrNil      fxns;       /* Fixed noise */
} CmSdpAttrSilSupp;

typedef struct cmSdpAttrEchoCan
{
   TknPres           pres;       /* Present? */
   TknU8             dir;        /* Direction flag */
   TknU8             enb;        /* Enable Echo Cancellation */
   TknU8             type;       /* Type of Echo Cancellation */
} CmSdpAttrEchoCan;

typedef struct cmSdpAttrGainCtl
{
   TknPres           pres;       /* Present? */
   TknU8             dir;        /* Direction flag */
   TknU8             enb;        /* Enable Gain Control */
   CmSdpU16OrNil     lvl;        /* Level of inserted Loss */
} CmSdpAttrGainCtl;

typedef struct cmSdpAttrDirection
{
   TknU8             type;       /* Type - active/passive/both */
   TknU16            port;       /* optional, type must == active/both */
} CmSdpAttrDirection;

typedef struct cmSdpAttrAtmAbrSetup
{
   TknPres           pres;       /* Present? */
   CmSdpU32OrNil     ficr;
   CmSdpU32OrNil     bicr;
   CmSdpU32OrNil     ftbe;
   CmSdpU32OrNil     btbe;
   CmSdpU32OrNil     crmrtt;
   TknU8             frif;
   TknU8             brif;
   TknU8             frdf;
   TknU8             brdf;
} CmSdpAttrAtmAbrSetup;

typedef struct cmSdpAttrAal2CpsSduRate
{
   TknPres           pres;       /* Present? */
   CmSdpU32OrNil     fSduRate;
   CmSdpU32OrNil     bSduRate;
} CmSdpAttrAal2CpsSduRate;

typedef struct cmSdpAttrAal5Sscop
{
   TknPres           pres;       /* Present? */
   CmSdpU16OrNil     fsscopSdu;
   CmSdpU16OrNil     bsscopSdu;
   CmSdpU16OrNil     fsscopUu;
   CmSdpU16OrNil     bsscopUu;
} CmSdpAttrAal5Sscop;

typedef struct cmSdpAttrAtmBrrSigIe
{
   TknPres           pres;       /* Present? */
   TknStrOSXL        type;
   TknU16            lng;
   TknStrOSXL        val;
} CmSdpAttrAtmBrrSigIe;

typedef struct cmSdpUuiCodeRng
{
   TknU8             type;      /* Specified or "-' */
   TknU8             low;
   TknU8             high;
} CmSdpUuiCodeRng;

typedef struct cmSdpProfComp
{
   TknPres           pres;       /* Present? */
   CmSdpUuiCodeRng   uui;        /* UUI code range */
   CmSdpEncName      enc;        /* Encoding name */
   CmSdpU8OrNil      len;        /* Packet length */
   CmSdpU16OrNil     pktz;       /* Packetization interval */
} CmSdpProfComp;

typedef struct cmSdpProfCompSet
{
   TknU16            num;        /* Number of components */
   CmSdpProfComp     **comps;    /* Components */
} CmSdpProfCompSet;

typedef struct cmSdpMedProtoSubtype
{
   TknU8          type; /* if applicable - for RTP, AALx only */
   union
   {
      TknStrOSXL                unknownOrCorporate;
      /*  cm_sdp_x_001.main_23:RFC:4975 */
      TknU8                msrp;
      /* TknBool           atmf; */
      /* TknBool           itu; */
      /* TknBool           custom; */
      /* TknBool           avp; */
      TknU32               ieee;
   }u;
} CmSdpMedProtoSubtype;

typedef struct cmSdpMedProto
{
   TknU8          type;
   union
   {
      TknStrOSXL           name;    /* if type = unknown */
      CmSdpMedProtoSubtype subtype; /* if known, eg RTP/AVP, AALx/ITU, etc */
   }u;
} CmSdpMedProto; 

typedef struct cmSdpAttrProfDesc
{
   TknPres           pres;       /* Present? */
   CmSdpMedProto     transport;  /* Transport/Proto */
   CmSdpU8OrNil      prof;       /* Profile */
   CmSdpProfCompSet  comps;      /* Profile components */
} CmSdpAttrProfDesc;

typedef struct cmSdpAttrDevSelComp
{
   TknPres           pres;       /* Present? */
   CmSdpEncName      enc;        /* Encoding name */
   CmSdpU8OrNil      len;        /* Packet length - may change to U16 */
   CmSdpU16OrNil     pktz;       /* Packetization interval */
} CmSdpAttrDevSelComp;

typedef struct cmSdpAttrDevSel
{
   TknPres                 pres;
   TknU8                   fxIncl;
   TknU16                  numComp;
   CmSdpAttrDevSelComp     **comps;
} CmSdpAttrDevSel;

typedef struct cmSdpAttrOneWaySel
{
   TknPres                 pres;
   TknU8                   srvTyp;
   TknU8                   dirFlg;
   TknU16                  numComp;
   CmSdpAttrDevSelComp     **comps;
} CmSdpAttrOneWaySel;

typedef struct cmSdpAttrAal23661Ass
{
   TknPres                 pres;
   CmSdpU32OrNil           rasTimer;   /* rastimer */
   CmSdpU32OrNil           fsssar;     /* Maximum SSSAR-SDU size, forward */
   CmSdpU32OrNil           bsssar;     /* Maximum SSSAR-SDU size, backward */
   CmSdpU16OrNil           fsscopSdu;
   CmSdpU16OrNil           bsscopSdu;
   CmSdpU16OrNil           fsscopUu;
   CmSdpU16OrNil           bsscopUu;
} CmSdpAttrAal23661Ass;

typedef struct cmSdpAttrCapab
{
   TknPres           pres;       /* Present? */
   TknU8             type;       /* ASC or ATC */
   TknStrOSXL        nonstd;     /* Not ITU or ATM */
   CmSdpU8OrNil      cfg;        /* Configuration */
} CmSdpAttrCapab;

typedef struct cmSdpAttrAtmBcob
{
   TknPres           pres;       /* Present? */
   TknU8             bcob;       /* val of bcob */
   TknU8             eetim;      /* End to End Timing required or not */
} CmSdpAttrAtmBcob;

typedef struct cmSdpAttrQosParms
{
   TknPres           pres;       /* Present? */
   TknU8             dir;        /* Direction flag */
   TknU8             cdvtype;    /* CDV type */
   CmSdpU32OrNil     acdv;       /* Acceptable CDV */
   CmSdpU32OrNil     ccdv;       /* Cumulative CDV */
   CmSdpU16OrNil     actd;       /* Acceptable CTD */
   CmSdpU16OrNil     cctd;       /* Cumulative CTD */
   CmSdpU8OrNil      aclr;       /* Acceptable Cell Loss Ratio */
} CmSdpAttrQosParms;

typedef struct cmSdpAttrTfcDesc
{
   TknPres           pres;       /* Present? */
   TknU8             dir;        /* Direction flag */
   TknU8             clp;        /* CLP level */
   CmSdpU32OrNil     pcr;        /* PCR */
   CmSdpU32OrNil     scr;        /* SCR */
   CmSdpU32OrNil     mbs;        /* MBS */
   CmSdpU32OrNil     cdvt;       /* CDVT (not signalled according to TM 4.1) */
   CmSdpU32OrNil     mcr;        /* MCR */
   CmSdpU32OrNil     mfs;        /* only for GFR, not in TM 4.1 */
   TknU8             fd;         /* Frame Discard Allowed */
   TknU8             te;         /* CLP tagging */
} CmSdpAttrTfcDesc;

typedef struct cmSdpAttrAbrParms
{
   TknPres           pres;       /* Present? */
   TknU8             dir;        /* Direction flag */
   CmSdpU8OrNil      nrm;        /* NRM */
   CmSdpU8OrNil      trm;        /* TRM */
   CmSdpU8OrNil      cdf;        /* CDF */
   CmSdpU16OrNil     adtf;       /* ADTF */
} CmSdpAttrAbrParms;

typedef struct cmSdpAttrBearType
{
   TknPres           pres;       /* Present? */
   TknU8             type;       /* Bearer Type */
   TknU8             init;       /* Local Initiation */ 
} CmSdpAttrBearType;

typedef struct cmSdpAttrStruc
{
   TknPres           pres;       /* Present? */
   TknU8             enb;        /* Structure Present */
   CmSdpU16OrNil     blksz;      /* Block Size */
} CmSdpAttrStruc;

typedef struct cmSdpAttrCpsSduSize
{
   TknPres           pres;       /* Present? */
   TknU8             dir;        /* Direction flag */
   TknU16            cpcs;
} CmSdpAttrCpsSduSize;

typedef struct cmSdpAttrAal2Cps
{
   TknPres           pres;       /* Present? */
   CmSdpU8OrNil      minCid;     /* AAL2 CID lower limit */
   CmSdpU8OrNil      maxCid;     /* AAL2 CID Upper limit */
   CmSdpU32OrNil     timerCU;    /* Timer, combined use */
   TknU8             simCPS;     /* Simplified CPS */
} CmSdpAttrAal2Cps;

typedef struct cmSdpAttrAal23661
{
   TknPres           pres;       /* Present? */
   TknU8             ted;        /* Transmission Error Detection Enable */
   CmSdpU32OrNil     rasTimer;   /* rastimer */
   CmSdpU32OrNil     fsssar;     /* Maximum SSSAR-SDU size, forward */
   CmSdpU32OrNil     bsssar;     /* Maximum SSSAR-SDU size, backward */
} CmSdpAttrAal23661;

typedef struct cmSdpAttrAal23662
{
   TknPres           pres;       /* Present? */
   TknU8             sap;        /* Service Access Point */
   TknU8             cktmd;      /* Circuit Mode Enable */
   TknU8             frmmd;      /* Frame Mode Enable */
   TknU8             faxdm;      /* Fax Demodulation Enable */
   TknU8             cas;        /* Enable CAS transport via Type 3 packets */
   TknU8             dtmf;       /* Enable DTMF transport via Type 3 packets */
   TknU8             mfall;      /* Enable MF transport via Type 3 packets */
   TknU8             mfr1;       /* Enable MF(R1) transport: Type 3 packets */
   TknU8             mfr2;       /* Enable MF(R2) transport: Type 3 packets */
   TknU8             enc;        /* PCM encoding */
   CmSdpU16OrNil     fmaxfrm;    /* Maximum length of a frame, forward */ 
   CmSdpU16OrNil     bmaxfrm;    /* Maximum length of a frame, backward */ 
} CmSdpAttrAal23662;

typedef struct cmSdpAttrLij
{
   TknPres           pres;       /* Present? */
   CmSdpU8OrNil      sci;        /* Screening Indication */
   CmSdpU32OrNil     lsn;        /* Leaf Sequence Number */
} CmSdpAttrLij;

typedef struct cmSdpAttrAnycast
{
   TknPres           pres;       /* Present? */
   CmSdpAnycastAddr  grpAddr;    /* atm Group Address */
   CmSdpU8OrNil      cdstd;      /* Coding standard for connection scope
                                    selection IE */
   CmSdpU8OrNil      csttype;    /* Type of connection scope */
   CmSdpU8OrNil      cssel;      /* Connection scope selection */
} CmSdpAttrAnycast;

/* Message structure for IPBCP */
typedef struct cmSdpAttrIpBcp
{
   TknPres              pres;
   TknU8                version;
   TknU8                msgType;
} CmSdpAttrIpBcp;

/* cm_sdp_x_001.main_19: RFC 4585 Enhancement */
typedef struct cmSdpAttrRtcpFbValToken
{
   TknStrOSXL           name;
   TknStrOSXL           bs;
} CmSdpAttrRtcpFbValToken;

typedef struct cmSdpAttrRtcpFbParam
{
   TknU8                type;
   union
   {
      TknStrOSXL              app;
      CmSdpAttrRtcpFbValToken token;
   } u;
} CmSdpAttrRtcpFbParam;

typedef struct cmSdpAttrRtcpFbValOth
{
   TknStrOSXL           rtcpFbId;
   CmSdpAttrRtcpFbParam rtcpFbParam;
} CmSdpAttrRtcpFbValOth;

typedef struct cmSdpAttrRtcpFbVal
{
   TknU8                type;
   union
   {
      CmSdpAttrRtcpFbParam    ack;
      CmSdpAttrRtcpFbParam    nack;
      TknU32                  trr;
      CmSdpAttrRtcpFbValOth   Other;
   } u;
}CmSdpAttrRtcpFbVal;

typedef struct cmSdpAttrRtcpFbPt
{
   TknU8                type;
   TknStrOSXL           fmt;
}CmSdpAttrRtcpFbPt;

typedef struct cmSdpAttrRtcpFb
{
   TknPres              pres;
   CmSdpAttrRtcpFbPt    rtcpFbPt;
   CmSdpAttrRtcpFbVal   rtcpFbVal;
} CmSdpAttrRtcpFb;

typedef struct cmSdpAttrGeneric
{
   TknPres              pres;
   TknStrOSXL           name;
   TknStrOSXL           val;
} CmSdpAttrGeneric;

typedef struct cmSdpAttrFmtp2848Res
{
   TknU8                type;
   TknStrOSXL           ref;
} CmSdpAttrFmtp2848Res;

typedef struct cmSdpAttrFmtp2848ResSet
{
   TknU16               numRes;
   CmSdpAttrFmtp2848Res **resSet;
} CmSdpAttrFmtp2848ResSet;

typedef struct cmSdpAttr CmSdpAttr;    /* Forward looking statement ;-) */

typedef struct cmSdpOptAttrSet
{
   TknU16               numAttr;
   CmSdpAttr            **attrSet;
} CmSdpOptAttrSet;

typedef struct cmSdpAttrFmtp2848
{
   TknPres              pres;
   TknStrOSXL           subType;
   CmSdpAttrFmtp2848ResSet resSet;
   CmSdpOptAttrSet      attrSet;
} CmSdpAttrFmtp2848;

typedef struct cmSdpAttrFmtp2733
{
   TknPres              pres;
   CmSdpU8OrNil         pay;
   TknU16               num;
   CmSdpAddr            addr;
} CmSdpAttrFmtp2733;

typedef struct cmSdpAttrFmtp2833
{
   TknPres              pres;
   CmSdpU8OrNil         pay;
   TknStrOSXL           str;
} CmSdpAttrFmtp2833;

#ifdef CM_SDP_V_3
typedef struct cmSdpAttrFmtpChnOrdSeq
{
  TknU8          convention;
  TknU8          order;
} CmSdpAttrFmtpChnOrdSeq;

typedef struct cmSdpAttrFmtpEmChnChc
{
   TknU8       type;
   union
   {
     TknU8                     emphTyp;  /* At present nothing is filled here */
     CmSdpAttrFmtpChnOrdSeq    chnOrd;
   } u;
} CmSdpAttrFmtpEmChnChc;

/* 111161 added new strucrure for ChnOrd */

typedef struct cmSdpAttrFmtpEmpChnLst
{
   TknU16        num;
   CmSdpAttrFmtpEmChnChc  **ChOrd;
}CmSdpAttrFmtpEmpChnLst;

typedef struct cmSdpAttrFmtpEmpChnOrd
{
   TknPres                  pres;
   TknU32                   payLoad;
   CmSdpAttrFmtpEmpChnLst       val;
} CmSdpAttrFmtpEmpChnOrd;

/* Support for FMTP under RFC 3555, 3267, 3GPP TS 29.414 v7.0.0 */

typedef struct cmSdpAttrFmtp3555ParVal
{
   TknU8       type;
   union
   {
      TknStrOSXL            other;
      TknU8                 annexa;
      TknU8                 annexb;
      TknU32                layer;
      TknU8                 mode;
      TknStrOSXL            bitrate;
      TknStrOSXL            samplerate;
      TknU32                profile;
      TknU32                level;
      TknU8                 type;
   } u;
} CmSdpAttrFmtp3555ParVal;

typedef struct cmSdpAttrFmtp3555ParLst
{
   TknU16   num;
   CmSdpAttrFmtp3555ParVal  **vals;
} CmSdpAttrFmtp3555ParLst;

typedef struct cmSdpAttrFmtp3555
{
   TknPres                  pres;
   CmSdpU8OrNil             payLoad;
   CmSdpAttrFmtp3555ParLst  val;
} CmSdpAttrFmtp3555;

typedef struct cmSdpAttrFmtp3267ModeSetLst
{
   TknU16   num;
   TknU8  **vals;
} CmSdpAttrFmtp3267ModeSetLst;

typedef struct cmSdpAttrFmtp3267ParVal
{
   TknU8       type;
   union
   {
      TknStrOSXL                  other;
      TknU8                       octet_align;
      TknU32                      mode_change_period;
      TknU8                       mode_change_neighbor;
      CmSdpAttrFmtp3267ModeSetLst mode_set;
      TknU8                       crc;
      TknU8                       robust_sorting;
      TknU32                      interleaving;
      TknU32                      channels; 
   } u;
} CmSdpAttrFmtp3267ParVal;

typedef struct cmSdpAttrFmtp3267ParLst
{
   TknU16   num;
   CmSdpAttrFmtp3267ParVal  **vals;
} CmSdpAttrFmtp3267ParLst;

typedef struct cmSdpAttrFmtp3267
{
   TknPres                  pres;
   CmSdpU8OrNil             payLoad;
   CmSdpAttrFmtp3267ParLst  val;
} CmSdpAttrFmtp3267;

typedef struct cmSdpAttrFmtpIPBCP
{
   TknPres                  pres;
   CmSdpU8OrNil             payLoad;
   TknU32                   pcmptime;
} CmSdpAttrFmtpIPBCP;

#endif

typedef struct cmSdpAttrFmtp
{
   TknU8                type;
   union
   {
      TknStrOSXL        other;
      CmSdpAttrFmtp2848 rfc2848;
      CmSdpAttrFmtp2733 rfc2733;
      CmSdpAttrFmtp2833 rfc2833; /* also control URI in RFC 2733 */
#ifdef CM_SDP_V_3
      CmSdpAttrFmtpEmpChnOrd     empChnOrd;
      CmSdpAttrFmtp3555  rfc3555; /* Added fmtp under RFC 3555 */
      CmSdpAttrFmtp3267  rfc3267; /* Added fmtp under RFC 3267 */
      CmSdpAttrFmtpIPBCP ipbcp; /* Added fmtp under 3GPP TS 29.414 v7.0.0 */
#endif
   } u;
} CmSdpAttrFmtp;

typedef struct cmSdpSmpte
{
   TknPres              pres;
   TknU8                hr;
   TknU8                min;
   TknU8                sec;
   TknU8                centisec;
   TknU8                frac;
} CmSdpSmpte;

typedef struct cmSdpTimeSmpte 
{
   TknPres              pres;
   CmSdpSmpte           start;
   CmSdpSmpte           end;
} CmSdpTimeSmpte;

typedef struct cmSdpNptSec 
{
   TknPres              pres;
   TknU32               sec;
   TknU32               frac;
} CmSdpNptSec;

typedef struct cmSdpNptHMS
{
   TknPres              pres;
   TknU8                hr;
   TknU8                min;
   TknU8                sec;
   TknU32               frac;
} CmSdpNptHMS;

typedef struct cmSdpNpt
{
   TknU8                type;
   union
   {
      CmSdpNptSec       sec;
      CmSdpNptHMS       hms;
   } u;
} CmSdpNpt;

typedef struct cmSdpTimeNpt
{
   TknPres              pres;
   CmSdpNpt             start;
   CmSdpNpt             end;
} CmSdpTimeNpt;

typedef struct cmSdpUtc
{
   TknPres              pres;
   TknU32               date;
   TknU32               hms;
   TknU32               frac;
} CmSdpUtc;

typedef struct cmSdpTimeUtc
{
   TknPres              pres;
   CmSdpUtc             start;
   CmSdpUtc             end;
} CmSdpTimeUtc;

typedef struct cmSdpAttrRange
{
   TknU8                type;
   union
   {
      CmSdpTimeSmpte    smpte;
      CmSdpTimeNpt      npt;
      CmSdpTimeUtc      utc;
   } u;
} CmSdpAttrRange;

typedef struct cmSdpAttrWtp
{
   TknPres              pres;
   TknStrOSXL           iapSystemId;
   TknStrOSXL           cccId;
} CmSdpAttrWtp;

typedef struct cmSdpAttrCache
{
   TknPres              pres;
   TknU8                enable;
   CmSdpU32OrNil        timer;
} CmSdpAttrCache;

typedef struct cmSdpAttrPhCxtId  
{
   TknU8                type;
   TknStrOSXL           number;
   TknStrOSXL           uri;
} CmSdpAttrPhCxtId;

typedef struct cmSdpAttrRequire
{
   TknU16               numAttr;
   TknStrOSXL           **names;
} CmSdpAttrRequire;

typedef struct cmSdpAttrAalApp
{
   TknU8                type;       /* one of CM_SDP_AAL5APP_... */
   TknStrOSXL           nonstd;     /* if type.val == CM_SDP_AAL5APP_NONSTD */
} CmSdpAttrAalApp;



#ifdef CM_SDP_V_3
typedef struct cmSdpCnfmTg
{
   TknU8               dirTg;     /* direction tag */
} CmSdpCnfmTg;

typedef struct cmSdpAttrQosSec
{
   TknPres             pres;
   TknU8               strnTg;    /* strength tag  */
   TknU8               dirTg;     /* direction tag */
   CmSdpCnfmTg         cnfmTg;    /* confirmation tag */
} CmSdpAttrQosSec;

typedef struct cmSdpAttrFidMid
{
   TknStrOSXL          idTag;    /* identification tag i.e. token */
} CmSdpAttrFidMid;

typedef struct cmSdpAttrIdSet
{
   TknU16             numComp;
   TknStrOSXL          **idTags;
} CmSdpAttrIdSet;

typedef struct cmSdpAttrGroup
{
   TknPres             pres;
   TknU8               semantics;
   CmSdpAttrIdSet      ids;
} CmSdpAttrGroup;




#endif

/* 001.main_15 RFC 4566 updated to RFC 2822*/
typedef struct cmSdpAddrSpec
{
   TknPres        pres;
   TknStrOSXL     local;
   TknStrOSXL     domain;
} CmSdpAddrSpec;

typedef struct cmSdpEmailName
{
   TknPres        pres;
/* 001.main_15 RFC 4566 updated to RFC 2822*/
   CmSdpAddrSpec  email;
   TknStrOSXL     name;
} CmSdpEmailName;

typedef struct cmSdpNameEmail
{
   TknPres        pres;
   TknStrOSXL     name;
/* 001.main_15 RFC 4566 updated to RFC 2822*/
   CmSdpAddrSpec  email;
} CmSdpNameEmail;

typedef struct cmSdpEmail
{
   TknU8                   type;
   union
   {
/* 001.main_15 RFC 4566 updated to RFC 2822*/
      CmSdpAddrSpec        email;
      CmSdpEmailName       en;
      CmSdpNameEmail       ne;
   } u;
} CmSdpEmail;

typedef struct cmSdpEmailSet
{
   TknU16         numComp;
   CmSdpEmail     **email;
} CmSdpEmailSet;

typedef struct cmSdpPhoneName
{
   TknPres        pres;
   TknStrOSXL     phone;
   TknStrOSXL     name;
} CmSdpPhoneName;

typedef struct cmSdpNamePhone
{
   TknPres        pres;
   TknStrOSXL     name;
   TknStrOSXL     phone;
} CmSdpNamePhone;

typedef struct cmSdpPhone
{
   TknU8                   type;
   union
   {
      TknStrOSXL           phone;
      CmSdpPhoneName       pn;
      CmSdpNamePhone       np;
   } u;
} CmSdpPhone;

typedef struct cmSdpPhoneSet
{
   TknU16         numComp;
   CmSdpPhone     **phone;
} CmSdpPhoneSet;

#ifdef CM_SDP_V_3
typedef struct cmSdpBwTyp
{
   TknU8          knownBw;
   TknStrOSXL     unKnownBw;
} CmSdpBwTyp;

/* 001.main_9: Added format type for T38 */
typedef struct cmSdpT38Fmt
{
   TknU8       knownFmt;
   TknStrOSXL  unknownFmt;       
} CmSdpT38Fmt;

#endif /* CM_SDP_V_3 */


typedef TknStrOSXL CmSdpMimeSubtype;

typedef struct cmSdpMedFmtUnknownList
{
   TknU16         num;
   TknStrOSXL     **fmts;
} CmSdpMedFmtUnknownList;

typedef struct cmSdpMedFmtAalxList
{
   TknU16         num;
   CmSdpU8OrNil   **fmts;
} CmSdpMedFmtAalxList;

/* 001.main_13: changes to support a mix of "$" & integers in RTP */
typedef struct cmSdpMedFmtRtpList
{
   TknU16         num;
   CmSdpU8OrNil   **fmts;
} CmSdpMedFmtRtpList;

typedef struct cmSdpMedFmtLclList
{
   TknU8          type;
   TknU16         num;
   TknU8          **fmts;
} CmSdpMedFmtLclList;

typedef struct cmSdpMedFmtTnList
{
   TknU16               num;
   CmSdpMimeSubtype     **fmts;
} CmSdpMedFmtTnList;

/* 001.main_9: Added format udptl list for T38 */
#ifdef CM_SDP_V_3
typedef struct cmSdpMedFmtUdptlList
{
   TknU16         num;
   CmSdpT38Fmt    **fmts;
} CmSdpMedFmtUdptlList;
#endif /* CM_SDP_V_3 */

#ifdef CM_SDP_SIP_IM_SUPPORT
typedef struct cmSdpMedFmtSipList
{
   TknU16               num;
   TknU8                **fmts;/* Will do a complete decode of SIP/IM/TEL URL,
                            to avoid having to mix sot.x,h into cm_sdp.x,h, we
                            allow a list of SoAddrSpec structures, the database
                            definition points to soMsgDefAddrSpec in order to
                            encode/decode from to SoAddrSpec */
} CmSdpMedFmtSipList;
#endif /* CM_SDP_SIP_IM_SUPPORT */

/*  cm_sdp_x_001.main_23:RFC:4975 */
typedef struct  cmSdpMedFmtTcpList
{
   TknU8               type;
   union 
   {
      CmSdpMedFmtUnknownList        unknown;
   }u;

} CmSdpMedFmtTcpList;

typedef struct cmSdpMedProtoFmts
{
   CmSdpMedProto  prot;
   TknU8          protType;   /* repeated from "prot" field */
   union
   {
      CmSdpMedFmtUnknownList        unknown;
      CmSdpMedFmtAalxList           aalx; 
      CmSdpMedFmtLclList            lcl;
      CmSdpMedFmtRtpList            rtp;
      CmSdpMedFmtTnList             tn;

/* 001.main_9: Added format udptl list for T38 */
#ifdef CM_SDP_V_3
      CmSdpMedFmtUdptlList          t38;
/*  cm_sdp_x_001.main_23:RFC:4975:added TCP FMT list */
      CmSdpMedFmtTcpList             tcp;
#endif /* CM_SDP_V_3 */
#ifdef CM_SDP_SIP_IM_SUPPORT
      CmSdpMedFmtSipList            sip;
#endif /* CM_SDP_SIP_IM_SUPPORT */ 

     
   } u;
}CmSdpMedProtoFmts;

typedef struct cmSdpMedPar
{
   TknU16            numProtFmts;
   CmSdpMedProtoFmts **pflst;
} CmSdpMedPar;

typedef struct cmSdpVcci
{
   TknPres              pres;
   CmSdpU32OrNil        vcci;
   CmSdpU8OrNil         cid;
} CmSdpVcci;

typedef struct cmSdpVpVcCid
{
   TknPres              pres;
   CmSdpU16OrNil        vpi;    /* or VPCI */
   CmSdpU16OrNil        vci;
   CmSdpU8OrNil         cid;
} CmSdpVpVcCid;

typedef struct cmSdpAddrVcci
{
   TknPres                       pres;
   CmSdpAddr                     addr;
   TknU8                         type;
   union
   {
      /* TknBool                 choose; */
      CmSdpVcci                  vcci;
      CmSdpVpVcCid               vpcid;
   } u;
} CmSdpAddrVcci;

typedef struct cmSdpBcg
{
   TknPres      pres;
   CmSdpU8OrNil bcg;
   TknU8        type;
   union
   {
      CmSdpVcci      vcci;
      CmSdpVpVcCid   vpcid;
   } u;
} CmSdpBcg;

typedef struct cmSdpPortIdVpVcCid
{
   TknPres                 pres;
   TknStrOSXL              portId;
   CmSdpVpVcCid            vpcid;
} CmSdpPortIdVpVcCid;

typedef struct cmSdpPortInt
{
   TknPres                 pres;
   CmSdpU16OrNil           port;
   TknU16                  rep;
} CmSdpPortInt;

typedef struct cmSdpPort
{
   TknU8                   type;
   union
   {
      CmSdpPortInt         portInt;
      CmSdpPortIdVpVcCid   vpcid;
   } u;
} CmSdpPort;

typedef CmSdpVpVcCid CmSdpVpci;

typedef struct cmSdpVcId
{
   TknU8        type;
   union
   {
      TknStrOSXL        impl; /* implicit/unknown */
      CmSdpVcci         vcci;
      CmSdpAddrVcci     atmAddrVcci;
      CmSdpBcg          bcg;
      CmSdpPort         port;
      CmSdpVpci         vpci;
   } u;
} CmSdpVcId;

typedef struct cmSdpMediaField
{
   TknPres      pres;
   TknU8        mediaType;  /* see defines */
   TknStrOSXL   media;      /* if unknown */
   CmSdpVcId    id;         /* Channel ID */
   CmSdpMedPar  par;        /* Media parameters */
} CmSdpMediaField;

/* 002.main_9 : old version; used for encoding/decoding */
typedef struct cmSdpMediaField_V1
{
   CmMemListCp     memCp;
   TknPres         pres;
   TknU8           mediaType;
   TknStrOSXL      media;
   CmSdpVcId       id;
   CmSdpMedPar     par;
} CmSdpMediaField_V1;


/* 001.main_9 : removed CmSdpVcId (id) field from the structure */
#ifdef CM_SDP_V_3

struct cmSdpAttrCapDesc
{
   TknPres      pres;
   TknU8        capNum;
   TknU8        mediaType;  /* see defines */
   TknStrOSXL   media;      /* if unknown */
   CmSdpMedPar  par;        /* Media parameters */
};


typedef struct cmSdpAttrT38Fax
{
   TknU8      type;
   union
   {
      TknU8    val;       /* used for choice vals */
      TknU32   num;       /* used for integer and boolean vals */
      CmSdpAttrGeneric  unknown;   /* 001.main_13: if type=unknown
                                    *              unknown.name does NOT
                                    *              have the "T38" prefix */
   } u;
} CmSdpAttrT38Fax;


/* 002.main_9 : old version; used for encoding/decoding */
typedef struct cmSdpAttrCapDesc_V1
{
   CmMemListCp     memCp;
   TknPres         pres;
   TknU8           capNum;
   TknU8           mediaType;
   TknStrOSXL      media;
   CmSdpVcId       id;
   CmSdpMedPar     par;
} CmSdpAttrCapDesc_V1;

/* 002.main_9 : new version; used for encoding/decoding */



typedef struct cmSdpAttrCapDesc_V2
{
   CmMemListCp     memCp;
   TknPres         pres;
   TknU8           capNum;
   TknU8           mediaType;
   TknStrOSXL      media;
   CmSdpMedPar     par;
} CmSdpAttrCapDesc_V2;
typedef struct cmSdpAttrPreCondType
{
   TknU8               PreCond;
   TknStrOSXL          Str;        /* Extension */
}CmSdpAttrPreCondType;
typedef struct cmSdpAttrStatus
{
   CmSdpAttrPreCondType PreCondType;
   TknU8                status;
   TknU8                direction; 
}CmSdpAttrStatus; 
typedef struct cmSdpAttrDesStatus
{
   CmSdpAttrPreCondType PreCondType;
   TknU8                strength;
   TknU8                status;
   TknU8                direction; 
}CmSdpAttrDesStatus;

/* Added Support for GPMD Attribute and vbd parameter */

typedef TknU8 CmSdpAttrGpmdVbd;

typedef struct cmSdpAttrGpmdVbdOther
{
   TknU8       type;
   union
   {
     TknStrOSXL             other;
     CmSdpAttrGpmdVbd    vbd;
   } u;
} CmSdpAttrGpmdVbdOther;

typedef struct cmSdpAttrGpmdVbdOtherLst
{
   TknU16   num;
   CmSdpAttrGpmdVbdOther  **vals;
} CmSdpAttrGpmdVbdOtherLst;

typedef struct cmSdpAttrGpmdV152
{
   TknPres                 pres;
   CmSdpU8OrNil            payLoad;
   CmSdpAttrGpmdVbdOtherLst   vbdOtherLst;
} CmSdpAttrGpmdV152;

typedef struct cmSdpAttrGpmd
{
   TknU8                type;
   union
   {
      TknStrOSXL        other;
      CmSdpAttrGpmdV152 v152;
 } u;
} CmSdpAttrGpmd;

typedef struct cmSdpAttrMaxmptime
{
   TknU16   num;
   TknU32   **vals;
} CmSdpAttrMaxmptime;

/*  cm_sdp_x_001.main_23:RFC -5547 end: addition of atrtibute fields*/

typedef struct cmSdpFileRangeStopOffset
{
   TknU8  type;   /* CM_SDP_STAR / CM_SDP_FILE_RANGE_STOP_OFF */
   TknU32 stopOff;
}CmSdpFileRangeStopOffset;

typedef struct  cmSdpFileRangeAttr 
{
   TknU32                     startOffset;
   CmSdpFileRangeStopOffset   stopOffset;
} CmSdpFileRangeAttr ;

typedef struct cmSdpFileContentLen
{
   TknStrOSXL        localPart;
   TknStrOSXL        domainPart;
 
}CmSdpFileContentLen;

typedef struct cmSdpFileIconVal
{
   CmSdpFileContentLen        fileContentId;
}CmSdpFileIconVal;

typedef struct  cmSdpFileIconAttr 
{
   CmSdpFileIconVal        fileIconValue;
} CmSdpFileIconAttr;


typedef struct  cmSdpRead 
{
   TknStrOSXL        fileRead;
} CmSdpRead;

typedef struct  cmSdpModification 
{
   TknStrOSXL        fileMod;
} CmSdpModification;

typedef struct  cmSdpCreation 
{
   TknStrOSXL       fileCreate;
} CmSdpCreation;

typedef struct cmSdpDateParam
{
   TknU8       type;
   union
   {
      CmSdpCreation      creation;    
      CmSdpModification  mod;
      CmSdpRead          read;
   }u;
}CmSdpDateParam;

typedef struct  cmSdpFileDateAttr   
{
   TknU16              numComp;
   CmSdpDateParam       **dateparam;
}CmSdpFileDateAttr;

typedef struct cmSdpFileTrIdAttr
{
   TknStrOSXL        fileTransferValue;
}CmSdpFileTrIdAttr;

typedef struct cmSdpFileDispositionAttr  
{
   TknStrOSXL        fileDispositionVal;
}CmSdpFileDispositionAttr;

typedef struct cmSdpHashSelector
{
   TknStrOSXL        hashAlgo;
   TknStrOSXL        hashValue;
}CmSdpHashSelector;

typedef struct cmSdpFiletypeSelParam
{
   TknU16         nums;
   TknStrOSXL     **fileNameString;
}CmSdpFiletypeSelParam;

typedef struct cmSdpFiletype
{
   TknU8 type;
   TknStrOSXL unknown;
} CmSdpFiletype;

typedef struct cmSdpFileTypeSelector
{
   CmSdpFiletype type;
   CmSdpFiletype subType;
   CmSdpFiletypeSelParam params;
} CmSdpFileTypeSelector;

typedef struct cmSdpFileSizeSelector
{
   TknU32        fileSizeVal;
}CmSdpFileSizeSelector;

typedef struct cmSdpFileNameSelector
{
   TknStrOSXL        fileNameString;
}CmSdpFileNameSelector;

typedef struct cmSdpFileSelector 
{
   TknU8       type;
   union 
   {
      CmSdpFileNameSelector   fileNameSelector;
      CmSdpFileSizeSelector   fileSizeSelector;
      CmSdpFileTypeSelector   fileTypeSelector;
      CmSdpHashSelector       hashSelector;
   }u;
}CmSdpFileSelector;

typedef struct cmSdpFileSelectorAttr
{
   TknU16 numComp;
   CmSdpFileSelector **sel;
}CmSdpFileSelectorAttr;
/*  cm_sdp_x_001.main_23:RFC -5547 */

#endif /* CM_SDP_V_3 */

struct cmSdpAttr
{
   TknU8      type; /* attribute field type*/
   union
   {
      CmSdpAttrGeneric  unknown;
      TknStrOSXL        cat;
      TknStrOSXL        keywds;
      TknStrOSXL        tool;
      TknU32            ptime;
      /* TknBool        recvonly; */
      /* TknBool        sendonly; */
      /* TknBool        sendrecv; */
      /* TknBool        inactive; */
      TknU8             orient;
      CmSdpAttrType     type;
      TknStrOSXL        charset;
      TknStrOSXL        sdplang;
      TknStrOSXL        lang;
      TknStrOSXL        framerate;
      TknStrOSXL        quality;
      CmSdpAttrFmtp     fmtp;
      TknStrOSXL        control;
      CmSdpAttrRange    range;
      TknStrOSXL        etag;
      CmSdpAttrRtpMap   rtpmap;
      CmSdpAttrAtmMap   atmmap;
/* cm_sdp_x_002.main_13: Modified to allow $ (CHOOSE) in the place of
 * single parameter value */
#ifdef CM_SDP_MEGACO_EECID_CHOICE
      CmSdpAttrEecId    eecid;
#else
      TknU32            eecid;
#endif
      TknU8             aaltype;
      CmSdpAttrSilSupp  silsupp;

      CmSdpAttrEchoCan  ecan;

      CmSdpAttrGainCtl  gc;

      CmSdpAttrProfDesc profd;
      CmSdpAttrDevSel   vsel;
      CmSdpAttrDevSel   dsel;
      CmSdpAttrDevSel   fsel;
      CmSdpAttrCapab    capab;
      CmSdpU8OrNil     qoscls;

      CmSdpAttrAtmBcob  bcob;

      TknU8             stc;
      CmSdpU8OrNil      upcc;

      CmSdpAttrQosParms qos;

      TknStrOSXL        aal2_qosf;
      TknStrOSXL        aal2_qosb;

      CmSdpAttrTfcDesc  tfc;

      TknStrOSXL        aal2_tfcf;
      TknStrOSXL        aal2_tfcb;

      CmSdpAttrAbrParms abr;

      TknU8             clcrec;
      TknU8             fec;
      TknU8             prtfl;
      CmSdpAttrBearType bearer;
      CmSdpAttrStruc    struc;
      TknU8             sbc;

      CmSdpAttrCpsSduSize   cpss;

      CmSdpAttrAal2Cps  aal2_cps;
      CmSdpAttrAal23661 aal2_3661;
      CmSdpAttrAal23662 aal2_3662;
      /* TknBool        aal2_3652; */
      /* TknBool        aal2_3653; */
      CmSdpAttrAalApp   aal5_app;
      CmSdpAttrLij      lij;
      CmSdpAttrAnycast  anycast;
      CmSdpAttrWtp      wtp;
      CmSdpAttrCache    cache;
      TknU8             chain;
      CmSdpAttrPhCxtId  phoneContextIdent;
      TknU8             clir;
      TknU8             q763Nature;
      TknU8             q763Plan;
      TknU8             q763Inn;
      CmSdpAttrRequire  require;
      CmSdpAttrDirection direction;
#ifdef CM_SDP_V_3
      CmSdpAttrQosSec       qosVal;
      CmSdpAttrQosSec       secVal;
      CmSdpAttrFidMid       fidVal;
      CmSdpAttrFidMid       midVal;
      CmSdpAttrGroup        group;
      TknU8                 sqnNum;
      CmSdpAttrCapDesc      cdsc;
      CmSdpAttrCapParam     capPar;
      CmSdpAttrT38Fax       fax;

      CmSdpAttrStatus            CurrStatus; 
      CmSdpAttrDesStatus         DesStatus;
      CmSdpAttrStatus            ConfStatus;
/* Added Support for three new attributes - maxptime,gpmd,maxmptime */
      TknU32                maxptime;
      CmSdpAttrGpmd         gpmd;
      CmSdpAttrMaxmptime    maxmptime;
      /* cm_sdp_x_001.main_23: RFC-5547: Added Support for six new attributes */

      CmSdpFileSelectorAttr     fileSelector;
      CmSdpFileDispositionAttr  fileDisposition;
      CmSdpFileTrIdAttr        fileTrId;
      CmSdpFileDateAttr          filedate;
      CmSdpFileIconAttr         fileIcon;
      CmSdpFileRangeAttr        fileRange;
       /* 111325 : a=MGW_Identifier: <MGW_Id" in standard 29.231 */
       TknU32                mgwId;


#endif
      CmSdpAttrAtmAbrSetup       abrSetup;
      CmSdpAttrAal2CpsSduRate    al2CpSduRt;
      CmSdpAttrAal5Sscop         al5Sscop;
      CmSdpAttrAtmBrrSigIe       brrSigIe;
      CmSdpAttrOneWaySel         oneWaySel;
      TknStrOSXL                 codecCfg;
      TknStrOSXL                 isupUsi;
      TknU8                      uiLr1Prot;
      TknU8                      cbrRate;
      CmSdpAttrAal23661Ass       aal2_3661Ass;
      CmSdpAttrIpBcp             bcp;   /* IPBCP msg */
/* cm_sdp_x_001.main_19: RFC 4585 Enhancement */
      CmSdpAttrRtcpFb            rtcpfb;
 }u;
};

typedef struct cmSdpAttrSet
{
   TknU16         numComp;
   CmSdpAttr      **attr;
} CmSdpAttrSet;

#ifdef CM_SDP_V_3

typedef struct cmSdpBw
{
   TknPres        pres;
   CmSdpBwTyp     bwType;
   TknU32         bWidth;
} CmSdpBw;



#else

typedef struct cmSdpBw
{
   TknPres        pres;
   TknStrOSXL     bwType;
   TknU32         bWidth;
} CmSdpBw;

#endif



typedef struct cmSdpBwSet
{
   TknU16         numComp;
   CmSdpBw        **sdpBw;
} CmSdpBwSet;

typedef struct cmSdpMediaDesc
{
   TknPres          pres;
   CmSdpMediaField  field;
   TknStrOSXL       info;
   CmSdpConnSet     connSet;
   CmSdpBwSet       bwSet;
   CmSdpKeyType     keyType;
   CmSdpAttrSet     attrSet;
} CmSdpMediaDesc;

typedef struct cmSdpMediaDescSet
{
   TknU16             numComp;
   CmSdpMediaDesc     **mediaDesc;
} CmSdpMediaDescSet;

typedef struct cmSdpInfo
{
   TknPres           pres;
   TknU16            ver;
   CmSdpOptOrig      orig;
   TknStrOSXL        sessName;
   TknStrOSXL        info;
   TknStrOSXL        uri;
   CmSdpEmailSet     emailSet;
   CmSdpPhoneSet     phoneSet;
   CmSdpConn         conn;
   CmSdpBwSet        bwSet;
   CmSdpTime         sdpTime;
   CmSdpKeyType      keyType;
   CmSdpAttrSet      attrSet;
   CmSdpMediaDescSet mediaDescSet;
} CmSdpInfo;

typedef struct cmSdpInfoSet
{
   TknU16    numComp;
   CmSdpInfo **info;  
} CmSdpInfoSet;
#endif /* CM_SDP_V_2 */

#ifdef CM_SDP_V_2
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpAttrCapParam         ARGS((CmSdpAttrCapParam *param,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrCapParam       ARGS((CmSdpAttrCapParam *param,
                                                Ptr ptr,
                                                CmIntfVer intfVer,
                                                Buffer *mBuf));
#endif

EXTERN S16 cmPkCmSdpIp4Unicast ARGS((CmSdpIp4Unicast *param, Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpIp4Unicast ARGS((CmSdpIp4Unicast *param, Ptr ptr,
                                       Buffer *mBuf));

EXTERN S16 cmPkCmSdpIp4Multicast ARGS((CmSdpIp4Multicast *param,
                                       Buffer *mBuf));

EXTERN S16 cmPkCmSdpAddrType ARGS((CmSdpAddrType *param,
                                       Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAddrType ARGS((CmSdpAddrType *param, Ptr ptr,
                                         Buffer *mBuf));

EXTERN S16 cmPkCmSdpNetType ARGS((CmSdpNetType *param,
                                       Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpNetType ARGS((CmSdpNetType *param, Ptr ptr,
                                         Buffer *mBuf));

EXTERN S16 cmPkCmSdpOptIp4Unicast ARGS((CmSdpOptIp4Unicast *param,
                                       Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpOptIp4Unicast ARGS((CmSdpOptIp4Unicast *param, Ptr ptr,
                                         Buffer *mBuf));

EXTERN S16 cmPkCmSdpIp6 ARGS((CmSdpIp6 *param,
                                       Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpIp6 ARGS((CmSdpIp6 *param, Ptr ptr,
                                         Buffer *mBuf));

EXTERN S16 cmPkCmSdpAddrSpec ARGS((CmSdpAddrSpec *param,
                                       Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAddrSpec ARGS((CmSdpAddrSpec *param, Ptr ptr,
                                         Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpIp4Multicast ARGS((CmSdpIp4Multicast *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpIp4Addr        ARGS((CmSdpIp4Addr *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpIp4Addr      ARGS((CmSdpIp4Addr *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpIp4Conn        ARGS((CmSdpIp4Conn *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpIp4Conn      ARGS((CmSdpIp4Conn *param, Ptr ptr,
                                         Buffer *mBuf));
/* 001.main_15 RFC 4566 : IPV6_MULTI removed from V_3 */
EXTERN S16 cmPkCmSdpIp6MultiCast   ARGS((CmSdpIp6MultiCast *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpIp6MultiCast ARGS((CmSdpIp6MultiCast *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpIp6Addr        ARGS((CmSdpIp6Addr *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpIp6Addr      ARGS((CmSdpIp6Addr *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAddr           ARGS((CmSdpAddr *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAddr         ARGS((CmSdpAddr *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpConn           ARGS((CmSdpConn *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpConn         ARGS((CmSdpConn *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAnycastAddr    ARGS((CmSdpAnycastAddr *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAnycastAddr  ARGS((CmSdpAnycastAddr *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpOrig           ARGS((CmSdpOrig *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpOrig         ARGS((CmSdpOrig *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpOptOrig        ARGS((CmSdpOptOrig *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpOptOrig      ARGS((CmSdpOptOrig *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpConnSet        ARGS((CmSdpConnSet *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpConnSet      ARGS((CmSdpConnSet *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpTypedTime      ARGS((CmSdpTypedTime *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpTypedTime    ARGS((CmSdpTypedTime *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpZoneAdj        ARGS((CmSdpZoneAdj *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpZoneAdj      ARGS((CmSdpZoneAdj *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpTypedTimeSet   ARGS((CmSdpTypedTimeSet *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpTypedTimeSet ARGS((CmSdpTypedTimeSet *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpRepField       ARGS((CmSdpRepField *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpRepField     ARGS((CmSdpRepField *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpRepFieldSet    ARGS((CmSdpRepFieldSet *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpRepFieldSet  ARGS((CmSdpRepFieldSet *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpZoneAdjSet     ARGS((CmSdpZoneAdjSet *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpZoneAdjSet   ARGS((CmSdpZoneAdjSet *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpOpTime         ARGS((CmSdpOpTime *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpOpTime       ARGS((CmSdpOpTime *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpOpTimeSet      ARGS((CmSdpOpTimeSet *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpOpTimeSet    ARGS((CmSdpOpTimeSet *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpTime           ARGS((CmSdpTime *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpTime         ARGS((CmSdpTime *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpKeyType        ARGS((CmSdpKeyType *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpKeyType      ARGS((CmSdpKeyType *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrType       ARGS((CmSdpAttrType *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrType     ARGS((CmSdpAttrType *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpU8OrNil        ARGS((CmSdpU8OrNil *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpU8OrNil      ARGS((CmSdpU8OrNil *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpU16OrNil       ARGS((CmSdpU16OrNil *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpU16OrNil     ARGS((CmSdpU16OrNil *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpU32OrNil       ARGS((CmSdpU32OrNil *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpU32OrNil     ARGS((CmSdpU32OrNil *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpEncName        ARGS((CmSdpEncName *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpEncName      ARGS((CmSdpEncName *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRtpMap     ARGS((CmSdpAttrRtpMap *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtpMap   ARGS((CmSdpAttrRtpMap *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAtmMap     ARGS((CmSdpAttrAtmMap *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAtmMap   ARGS((CmSdpAttrAtmMap *param, Ptr ptr,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrSilSupp    ARGS((CmSdpAttrSilSupp *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrSilSupp  ARGS((CmSdpAttrSilSupp *param,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrEchoCan    ARGS((CmSdpAttrEchoCan *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrEchoCan  ARGS((CmSdpAttrEchoCan *param,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGainCtl    ARGS((CmSdpAttrGainCtl *param,
                                         Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGainCtl  ARGS((CmSdpAttrGainCtl *param,
                                         Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrDirection  ARGS((CmSdpAttrDirection *param,
                                         Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpAttrDirection ARGS((CmSdpAttrDirection *param,
                                          Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAtmAbrSetup ARGS((CmSdpAttrAtmAbrSetup *param,
                                          Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpAttrAtmAbrSetup ARGS((CmSdpAttrAtmAbrSetup *param,
                                            Buffer *mBuf));

EXTERN S16 cmPkCmSdpAttrAal2CpsSduRate ARGS((CmSdpAttrAal2CpsSduRate *param,
                                             Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpAttrAal2CpsSduRate ARGS((CmSdpAttrAal2CpsSduRate *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAal5Sscop        ARGS((CmSdpAttrAal5Sscop *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAal5Sscop      ARGS((CmSdpAttrAal5Sscop *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAtmBrrSigIe      ARGS((CmSdpAttrAtmBrrSigIe *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAtmBrrSigIe    ARGS((CmSdpAttrAtmBrrSigIe *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpUuiCodeRng           ARGS((CmSdpUuiCodeRng *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpUuiCodeRng         ARGS((CmSdpUuiCodeRng *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpProfComp             ARGS((CmSdpProfComp *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpProfComp           ARGS((CmSdpProfComp *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpProfCompSet          ARGS((CmSdpProfCompSet *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpProfCompSet        ARGS((CmSdpProfCompSet *param, Ptr ptr,
                                               Buffer *mBuf));

EXTERN S16 cmPkCmSdpMedProtoSubtype      ARGS((CmSdpMedProtoSubtype *param,
                                               U8 protType, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedProtoSubtype    ARGS((CmSdpMedProtoSubtype *param,
                                               U8 protType, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedProto             ARGS((CmSdpMedProto *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedProto           ARGS((CmSdpMedProto *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrProfDesc         ARGS((CmSdpAttrProfDesc *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrProfDesc       ARGS((CmSdpAttrProfDesc *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrDevSelComp       ARGS((CmSdpAttrDevSelComp *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrDevSelComp     ARGS((CmSdpAttrDevSelComp *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrDevSel           ARGS((CmSdpAttrDevSel *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrDevSel         ARGS((CmSdpAttrDevSel *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrOneWaySel        ARGS((CmSdpAttrOneWaySel *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrOneWaySel      ARGS((CmSdpAttrOneWaySel *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAal23661Ass      ARGS((CmSdpAttrAal23661Ass *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAal23661Ass    ARGS((CmSdpAttrAal23661Ass *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrCapab            ARGS((CmSdpAttrCapab *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrCapab          ARGS((CmSdpAttrCapab *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAtmBcob          ARGS((CmSdpAttrAtmBcob *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAtmBcob        ARGS((CmSdpAttrAtmBcob *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrQosParms         ARGS((CmSdpAttrQosParms *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrQosParms       ARGS((CmSdpAttrQosParms *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrTfcDesc          ARGS((CmSdpAttrTfcDesc *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrTfcDesc        ARGS((CmSdpAttrTfcDesc *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAbrParms         ARGS((CmSdpAttrAbrParms *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAbrParms       ARGS((CmSdpAttrAbrParms *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrBearType         ARGS((CmSdpAttrBearType *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrBearType       ARGS((CmSdpAttrBearType *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrStruc            ARGS((CmSdpAttrStruc *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrStruc          ARGS((CmSdpAttrStruc *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrCpsSduSize       ARGS((CmSdpAttrCpsSduSize *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrCpsSduSize     ARGS((CmSdpAttrCpsSduSize *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAal2Cps          ARGS((CmSdpAttrAal2Cps *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAal2Cps        ARGS((CmSdpAttrAal2Cps *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAal23661         ARGS((CmSdpAttrAal23661 *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAal23661       ARGS((CmSdpAttrAal23661 *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAal23662         ARGS((CmSdpAttrAal23662 *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAal23662       ARGS((CmSdpAttrAal23662 *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrLij              ARGS((CmSdpAttrLij *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrLij            ARGS((CmSdpAttrLij *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAnycast          ARGS((CmSdpAttrAnycast *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAnycast        ARGS((CmSdpAttrAnycast *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGeneric          ARGS((CmSdpAttrGeneric *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGeneric        ARGS((CmSdpAttrGeneric *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp2848Res      ARGS((CmSdpAttrFmtp2848Res *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp2848Res    ARGS((CmSdpAttrFmtp2848Res *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp2848ResSet   ARGS((CmSdpAttrFmtp2848ResSet *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp2848ResSet ARGS((CmSdpAttrFmtp2848ResSet *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpOptAttrSet           ARGS((CmSdpOptAttrSet *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpOptAttrSet         ARGS((CmSdpOptAttrSet *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp2848         ARGS((CmSdpAttrFmtp2848 *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp2848       ARGS((CmSdpAttrFmtp2848 *param,
                                               Ptr ptr, CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp2733         ARGS((CmSdpAttrFmtp2733 *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp2733       ARGS((CmSdpAttrFmtp2733 *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp2833         ARGS((CmSdpAttrFmtp2833 *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp2833       ARGS((CmSdpAttrFmtp2833 *param,
                                               Ptr ptr, Buffer *mBuf));
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpAttrFmtpChnOrdSeq    ARGS((CmSdpAttrFmtpChnOrdSeq *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtpChnOrdSeq  ARGS((CmSdpAttrFmtpChnOrdSeq *param,
                                                Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtpEmChnChc     ARGS((CmSdpAttrFmtpEmChnChc *param,
                                                Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtpEmChnChc   ARGS((CmSdpAttrFmtpEmChnChc *param,
                                               Ptr ptr,  Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtpEmpChnLst   ARGS((CmSdpAttrFmtpEmpChnLst *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtpEmpChnLst ARGS((CmSdpAttrFmtpEmpChnLst *param,
                                               Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpAttrFmtpEmpChnOrd    ARGS((CmSdpAttrFmtpEmpChnOrd *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtpEmpChnOrd  ARGS((CmSdpAttrFmtpEmpChnOrd *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp3555ParVal   ARGS((CmSdpAttrFmtp3555ParVal *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp3555ParVal ARGS((CmSdpAttrFmtp3555ParVal *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp3555ParLst   ARGS((CmSdpAttrFmtp3555ParLst *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp3555ParLst ARGS((CmSdpAttrFmtp3555ParLst *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp3555         ARGS((CmSdpAttrFmtp3555 *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp3555       ARGS((CmSdpAttrFmtp3555 *param,
                                               Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpAttrFmtp3267ModeSetLst ARGS((CmSdpAttrFmtp3267ModeSetLst *param,
                                                 Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpAttrFmtp3267ModeSetLst ARGS((CmSdpAttrFmtp3267ModeSetLst *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp3267ParVal       ARGS((CmSdpAttrFmtp3267ParVal *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp3267ParVal     ARGS((CmSdpAttrFmtp3267ParVal *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp3267ParLst       ARGS((CmSdpAttrFmtp3267ParLst *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp3267ParLst     ARGS((CmSdpAttrFmtp3267ParLst *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtp3267             ARGS((CmSdpAttrFmtp3267 *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp3267           ARGS((CmSdpAttrFmtp3267 *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFmtpIPBCP            ARGS((CmSdpAttrFmtpIPBCP *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtpIPBCP          ARGS((CmSdpAttrFmtpIPBCP *param,
                                                   Buffer *mBuf));
#endif
EXTERN S16 cmPkCmSdpAttrFmtp             ARGS((CmSdpAttrFmtp *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFmtp           ARGS((CmSdpAttrFmtp *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpSmpte                ARGS((CmSdpSmpte *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpSmpte              ARGS((CmSdpSmpte *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpTimeSmpte            ARGS((CmSdpTimeSmpte *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpTimeSmpte          ARGS((CmSdpTimeSmpte *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpNptSec               ARGS((CmSdpNptSec *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpNptSec             ARGS((CmSdpNptSec *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpNptHMS               ARGS((CmSdpNptHMS *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpNptHMS             ARGS((CmSdpNptHMS *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpNpt                  ARGS((CmSdpNpt *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpNpt                ARGS((CmSdpNpt *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpTimeNpt              ARGS((CmSdpTimeNpt *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpTimeNpt            ARGS((CmSdpTimeNpt *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpUtc                  ARGS((CmSdpUtc *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpUtc                ARGS((CmSdpUtc *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpTimeUtc              ARGS((CmSdpTimeUtc *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpTimeUtc            ARGS((CmSdpTimeUtc *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRange            ARGS((CmSdpAttrRange *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRange          ARGS((CmSdpAttrRange *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrWtp              ARGS((CmSdpAttrWtp *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrWtp            ARGS((CmSdpAttrWtp *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrCache            ARGS((CmSdpAttrCache *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrCache          ARGS((CmSdpAttrCache *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrPhCxtId          ARGS((CmSdpAttrPhCxtId *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrPhCxtId        ARGS((CmSdpAttrPhCxtId *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRequire          ARGS((CmSdpAttrRequire *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRequire        ARGS((CmSdpAttrRequire *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrAalApp           ARGS((CmSdpAttrAalApp *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrAalApp         ARGS((CmSdpAttrAalApp *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrIpBcp            ARGS((CmSdpAttrIpBcp *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrIpBcp          ARGS((CmSdpAttrIpBcp *param, Buffer *mBuf));
/* cm_sdp_x_001.main_19: Added prtotypes for RFC 4585 */
EXTERN S16 cmPkCmSdpAttrRtcpFbValToken   ARGS((CmSdpAttrRtcpFbValToken *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtcpFbValToken ARGS((CmSdpAttrRtcpFbValToken *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRtcpFbParam      ARGS((CmSdpAttrRtcpFbParam *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtcpFbParam    ARGS((CmSdpAttrRtcpFbParam *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRtcpFbValOth     ARGS((CmSdpAttrRtcpFbValOth *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtcpFbValOth   ARGS((CmSdpAttrRtcpFbValOth *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRtcpFbVal        ARGS((CmSdpAttrRtcpFbVal *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtcpFbVal      ARGS((CmSdpAttrRtcpFbVal *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRtcpFbPt         ARGS((CmSdpAttrRtcpFbPt *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtcpFbPt       ARGS((CmSdpAttrRtcpFbPt *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrRtcpFb           ARGS((CmSdpAttrRtcpFb *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrRtcpFb         ARGS((CmSdpAttrRtcpFb *param, Ptr ptr,
                                               Buffer *mBuf));
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpCnfmTg               ARGS((CmSdpCnfmTg *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpCnfmTg             ARGS((CmSdpCnfmTg *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrQosSec           ARGS((CmSdpAttrQosSec *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrQosSec         ARGS((CmSdpAttrQosSec *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrFidMid           ARGS((CmSdpAttrFidMid *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrFidMid         ARGS((CmSdpAttrFidMid *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrIdSet            ARGS((CmSdpAttrIdSet *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrIdSet          ARGS((CmSdpAttrIdSet *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGroup            ARGS((CmSdpAttrGroup *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGroup          ARGS((CmSdpAttrGroup *param, Ptr ptr,
                                               Buffer *mBuf));
#endif
EXTERN S16 cmPkCmSdpEmailName            ARGS((CmSdpEmailName *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpEmailName          ARGS((CmSdpEmailName *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpNameEmail            ARGS((CmSdpNameEmail *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpNameEmail          ARGS((CmSdpNameEmail *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpEmail                ARGS((CmSdpEmail *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpEmail              ARGS((CmSdpEmail *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpEmailSet             ARGS((CmSdpEmailSet *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpEmailSet           ARGS((CmSdpEmailSet *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpPhoneName            ARGS((CmSdpPhoneName *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpPhoneName          ARGS((CmSdpPhoneName *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpNamePhone            ARGS((CmSdpNamePhone *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpNamePhone          ARGS((CmSdpNamePhone *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpPhone                ARGS((CmSdpPhone *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpPhone              ARGS((CmSdpPhone *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpPhoneSet             ARGS((CmSdpPhoneSet *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpPhoneSet           ARGS((CmSdpPhoneSet *param, Ptr ptr,
                                               Buffer *mBuf));
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpBwTyp                ARGS((CmSdpBwTyp *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpBwTyp              ARGS((CmSdpBwTyp *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpT38Fmt               ARGS((CmSdpT38Fmt *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpT38Fmt             ARGS((CmSdpT38Fmt *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGpmdVbdOther         ARGS((CmSdpAttrGpmdVbdOther *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGpmdVbdOther       ARGS((CmSdpAttrGpmdVbdOther *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGpmdVbdOtherLst      ARGS((CmSdpAttrGpmdVbdOtherLst *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGpmdVbdOtherLst    ARGS((CmSdpAttrGpmdVbdOtherLst *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGpmdV152             ARGS((CmSdpAttrGpmdV152 *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGpmdV152           ARGS((CmSdpAttrGpmdV152 *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrGpmd                 ARGS((CmSdpAttrGpmd *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrGpmd               ARGS((CmSdpAttrGpmd *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrMaxmptime            ARGS((CmSdpAttrMaxmptime *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrMaxmptime          ARGS((CmSdpAttrMaxmptime *param,
                                                   Ptr ptr, Buffer *mBuf));
/* cm_sdp_x_001.main_23:RFC: 5547: Added attribute fields */

EXTERN S16 cmPkCmSdpFileRangeStopOffset      ARGS((
                                                  CmSdpFileRangeStopOffset *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileRangeStopOffset           ARGS((
                                    CmSdpFileRangeStopOffset *param,
                                     Buffer *mBuf));

EXTERN S16 cmPkCmSdpCreation      ARGS((
                                                  CmSdpCreation *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpCreation           ARGS((
                                    CmSdpCreation *param,
                                    Ptr ptr, Buffer *mBuf));


EXTERN S16 cmPkCmSdpModification      ARGS((
                                                  CmSdpModification *param,
                                                   Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpModification           ARGS((
                                    CmSdpModification *param,
                                    Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpRead      ARGS((
                                                  CmSdpRead *param,
                                                   Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpRead           ARGS((
                                    CmSdpRead *param,
                                    Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpDateParam      ARGS((
                                                  CmSdpDateParam *param,
                                                   Buffer *mBuf));

EXTERN S16 cmUnpkCmSdpDateParam           ARGS((
                                    CmSdpDateParam *param,
                                    Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpFileDispositionAttr      ARGS((
                                                  CmSdpFileDispositionAttr *param,
                                                   Buffer *mBuf));

EXTERN S16 cmPkCmSdpFileRangeAttr             ARGS((CmSdpFileRangeAttr *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileRangeAttr           ARGS((CmSdpFileRangeAttr *param,
                                                    Buffer *mBuf));
EXTERN S16 cmPkCmSdpFileIconAttr             ARGS((CmSdpFileIconAttr *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileIconAttr           ARGS((CmSdpFileIconAttr *param,
                                                   Ptr ptr, Buffer *mBuf));


EXTERN S16 cmPkCmSdpFileIconVal             ARGS((CmSdpFileIconVal *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileIconVal           ARGS((CmSdpFileIconVal *param,
                                                   Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpFileContentLen            ARGS((CmSdpFileContentLen *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileContentLen           ARGS((CmSdpFileContentLen *param,
                                                   Ptr ptr, Buffer *mBuf));


EXTERN S16 cmPkCmSdpFileDateAttr             ARGS((CmSdpFileDateAttr *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileDateAttr           ARGS((CmSdpFileDateAttr *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpFileTrIdAttr             ARGS((CmSdpFileTrIdAttr *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileTrIdAttr           ARGS((CmSdpFileTrIdAttr *param,
                                                   Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpFileDispositio_Attr             ARGS((CmSdpFileDispositionAttr *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileDispositionAttr           ARGS((CmSdpFileDispositionAttr *param,
                                                   Ptr ptr, Buffer *mBuf));



EXTERN S16 cmPkCmSdpHashSelector             ARGS((CmSdpHashSelector *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpHashSelector           ARGS((CmSdpHashSelector *param,
                                                   Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpFiletype        ARGS((CmSdpFiletype *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFiletype        ARGS((CmSdpFiletype *param,
                                                   Ptr ptr, Buffer *mBuf));


EXTERN S16 cmPkCmSdpFiletypeSelParam        ARGS((CmSdpFiletypeSelParam *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFiletypeSelParam         ARGS((CmSdpFiletypeSelParam *param,
                                                   Ptr ptr, Buffer *mBuf));



EXTERN S16 cmPkCmSdpFileTypeSelector        ARGS((CmSdpFileTypeSelector *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileTypeSelector         ARGS((CmSdpFileTypeSelector *param,
                                                   Ptr ptr, Buffer *mBuf));

EXTERN S16 cmPkCmSdpFileSizeSelector         ARGS((CmSdpFileSizeSelector *param,
                                                    Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileSizeSelector         ARGS((CmSdpFileSizeSelector *param,
                                                      Ptr ptr, Buffer *mBuf));


EXTERN S16 cmPkCmSdpFileSelector         ARGS((CmSdpFileSelector *param,
                                                    Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileSelector         ARGS((CmSdpFileSelector *param,
                                                      Ptr ptr, Buffer *mBuf));



EXTERN S16 cmPkCmSdpFileNameSelector          ARGS((CmSdpFileNameSelector *param,
                                                     Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileNameSelector          ARGS((CmSdpFileNameSelector *param,
                                                   Ptr ptr, Buffer *mBuf));



EXTERN S16 cmPkCmSdpFileSelectorAttr          ARGS((CmSdpFileSelectorAttr *param,
                                                     Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpFileSelectorAttr          ARGS((CmSdpFileSelectorAttr *param,
                                                   Ptr ptr, Buffer *mBuf));


#endif /* CM_SDP_V_3 */
EXTERN S16 cmPkCmSdpMedFmtUnknownList    ARGS((CmSdpMedFmtUnknownList *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtUnknownList  ARGS((CmSdpMedFmtUnknownList *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedFmtAalxList       ARGS((CmSdpMedFmtAalxList *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtAalxList     ARGS((CmSdpMedFmtAalxList *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedFmtRtpList        ARGS((CmSdpMedFmtRtpList *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtRtpList      ARGS((CmSdpMedFmtRtpList *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedFmtLclList        ARGS((CmSdpMedFmtLclList *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtLclList      ARGS((CmSdpMedFmtLclList *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedFmtTnList         ARGS((CmSdpMedFmtTnList *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtTnList       ARGS((CmSdpMedFmtTnList *param,
                                               Ptr ptr, Buffer *mBuf));
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpMedFmtUdptlList      ARGS((CmSdpMedFmtUdptlList *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtUdptlList    ARGS((CmSdpMedFmtUdptlList *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedFmtTcpList        ARGS((CmSdpMedFmtTcpList *param,
                                               Buffer *mbuf ));
EXTERN S16 cmUnpkCmSdpMedFmtTcpList      ARGS((CmSdpMedFmtTcpList *param,
                                               Ptr ptr, Buffer *mbuf ));

#endif /* CM_SDP_V_3 */
#ifdef CM_SDP_SIP_IM_SUPPORT
EXTERN S16 cmPkCmSdpMedFmtSipList            ARGS((CmSdpMedFmtSipList *param,
                                                   Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtSipList          ARGS((CmSdpMedFmtSipList *param,
                                                   Buffer *mBuf));
#endif /* CM_SDP_SIP_IM_SUPPORT */
EXTERN S16 cmPkCmSdpMedProtoFmts         ARGS((CmSdpMedProtoFmts *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedProtoFmts       ARGS((CmSdpMedProtoFmts *param,
                                               Ptr ptr, CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpMedPar               ARGS((CmSdpMedPar *param,
                                               CmIntfVer intfVer,
                                    
                                    Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedPar             ARGS((CmSdpMedPar *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpVcci                 ARGS((CmSdpVcci *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpVcci               ARGS((CmSdpVcci *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpVpVcCid              ARGS((CmSdpVpVcCid *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpVpVcCid            ARGS((CmSdpVpVcCid *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAddrVcci             ARGS((CmSdpAddrVcci *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAddrVcci           ARGS((CmSdpAddrVcci *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpBcg                  ARGS((CmSdpBcg *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpBcg                ARGS((CmSdpBcg *param, Buffer *mBuf));
EXTERN S16 cmPkCmSdpPortIdVpVcCid        ARGS((CmSdpPortIdVpVcCid *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpPortIdVpVcCid      ARGS((CmSdpPortIdVpVcCid *param,
                                               Ptr ptr, Buffer *mBuf));
EXTERN S16 cmPkCmSdpPortInt              ARGS((CmSdpPortInt *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpPortInt            ARGS((CmSdpPortInt *param,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpPort                 ARGS((CmSdpPort *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpPort               ARGS((CmSdpPort *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpVcId                 ARGS((CmSdpVcId *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpVcId               ARGS((CmSdpVcId *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpMediaField           ARGS((CmSdpMediaField *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMediaField         ARGS((CmSdpMediaField *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpAttrCapDesc          ARGS((CmSdpAttrCapDesc *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrCapDesc        ARGS((CmSdpAttrCapDesc *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrT38Fax           ARGS((CmSdpAttrT38Fax *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrT38Fax         ARGS((CmSdpAttrT38Fax *param,
                                               Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrPreCondType      ARGS((CmSdpAttrPreCondType *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrPreCondType    ARGS((CmSdpAttrPreCondType *param,
                                               Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrStatus           ARGS((CmSdpAttrStatus *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrStatus         ARGS((CmSdpAttrStatus *param,
                                               Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrDesStatus        ARGS((CmSdpAttrDesStatus *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrDesStatus      ARGS((CmSdpAttrDesStatus *param,
                                                Ptr ptr,
                                               Buffer *mBuf));

#endif /* CM_SDP_V_3 */
EXTERN S16 cmPkCmSdpAttr                 ARGS((CmSdpAttr *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttr               ARGS((CmSdpAttr *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpAttrSet              ARGS((CmSdpAttrSet *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpAttrSet            ARGS((CmSdpAttrSet *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
#ifdef CM_SDP_V_3
EXTERN S16 cmPkCmSdpBw                   ARGS((CmSdpBw *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpBw                 ARGS((CmSdpBw *param, Ptr ptr,
                                               Buffer *mBuf));
#else
EXTERN S16 cmPkCmSdpBw                   ARGS((CmSdpBw *param, Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpBw                 ARGS((CmSdpBw *param, Ptr ptr,
                                               Buffer *mBuf));
#endif
EXTERN S16 cmPkCmSdpBwSet                ARGS((CmSdpBwSet *param,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpBwSet              ARGS((CmSdpBwSet *param, Ptr ptr,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpMediaDesc            ARGS((CmSdpMediaDesc *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMediaDesc          ARGS((CmSdpMediaDesc *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpMediaDescSet         ARGS((CmSdpMediaDescSet *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMediaDescSet       ARGS((CmSdpMediaDescSet *param,
                                               Ptr ptr, CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpInfo                 ARGS((CmSdpInfo *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpInfo               ARGS((CmSdpInfo *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmPkCmSdpInfoSet              ARGS((CmSdpInfoSet *param,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpInfoSet            ARGS((CmSdpInfoSet *param, Ptr ptr,
                                               CmIntfVer intfVer,
                                               Buffer *mBuf));
/* cm_sdp_x_002.main_13: Modified to allow $ (CHOOSE) in the place of
 * single parameter value */
#ifdef CM_SDP_MEGACO_EECID_CHOICE
PUBLIC S16 cmPkCmSdpAttrEecId            ARGS((CmSdpAttrEecId *param,
                                               Buffer *mBuf));
PUBLIC S16 cmUnpkCmSdpAttrEecId          ARGS((CmSdpAttrEecId *param,
                                               Buffer *mBuf));
#endif /* CM_SDP_MEGACO_EECID_CHOICE */
/* cm_sdp_x_001.main_20: combination compilation error fix */
#if (defined(CM_SDP_V_2) && defined(CM_SDP_SIP_IM_SUPPORT))
EXTERN S16 cmPkCmSdpMedFmtAddrSpecList ARGS((CmSdpMedFmtSipList *param,
                                             Buffer *mBuf));
EXTERN S16 cmUnpkCmSdpMedFmtAddrSpecList ARGS((CmSdpMedFmtSipList *param,
                                               Ptr ptr,Buffer *mBuf));  
#endif /* CM_SDP_SIP_IM_SUPPORT and CM_SDP_V_2 */

#endif /* CM_SDP_V_2*/

#endif
#ifdef __cplusplus
}
#endif



#endif /* not defined __CMSDPX__ */


/********************************************************************30**

         End of file:     cm_sdp.x@@/main/24 - Wed Sep 22 19:50:23 2010

*********************************************************************31*/
/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      nct  1. Initial release
/main/3      ---      dw   1. Added ATM support
/main/9      ---      ra   1. GCP 1.3 release
/main/10   001.main_9 rg   1. Added Format List structure for Image media
                              CmSdpMedFmtUdptlList
                           2. Removed field SdpVcId from CmSdpAttrCapDesc
/main/11     ---      cy   1. Changes made for SIP release 1.2
/main/13     ---      up   1. Support for IPBCP in SDP
/main/13   001.main_13  ra   1. changes to support a mix of "$" &
                              integers in RTP
                          2. Enhanced the struct CmSdpAttrT38Fax to add
                              support for unknown values.
  cm_sdp_x_002.main_13 gk  1. Modified to allow $ (CHOOSE) in the place of 
                              single parameter value under the flag 
                              CM_SDP_MEGACO_EECID_CHOICE
/main/14     ---     aj  1. Now passing interface version to pack/unpack
                          functions for CmSdpInfoSet if CM_SDP_OPAQUE
                          is defined.
/main/15     ---     gk   1. Clearcase release of main/13 patches
/main/16     ---     mm   1. Grammar for RFC 3312 and 4566 updated
/main/17     ----     sy   GCP 2.1 release
/main/18     ---      mm    1.add prototypes for RFC 4566
/main/19     ---     sy    1.Corrected the cmUnpkCmSdpAddrSpec  prototype.   
/main/20     ---  cm_sdp_x_001.main_19 ac 1. RFC 4585 Enhancement. 
/main/21     ---  cm_sdp_x_001.main_20 ve 1. combination compilation error fix. 
/main/22     ---  cm_sdp_x_001.main_21 gk 1. Removed unnecessary structures
/main/23     ---  cm_sdp_x_001.main_22 sy 1. Removed cmSdpLclAddr structure. 
/main/24     ---  cm_sdp_x_001.main_23  nj 1. Enhancement for RFC 4497 Added in the media line
                                               TCP subtype as
                                               TLS/MSRP and Format to specific "*"
                                            2. Enchancement for RFC 5547 Added 6 Fields to attribute
                                               line.
*********************************************************************91*/
