/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:    common SDP
  
     Type:    C include file 
  
     Desc:    constants required by common SDP module
 
     File:    cm_sdp.h

     Sid:      cm_sdp.h@@/main/21 - Wed Sep 22 19:47:18 2010
  
     Prg:     rrp
  
*********************************************************************21*/

/*
 * cm_sdp_h_001.main_8:
 *   The flag CM_SDP_OPAQUE is mutually exclusive of the rest of SDP flags
 *   as well as the packing/unpacking of the CmSdpInfoSet structure set.
 *   If this opaque flag is defined, then the SDP information is packed
 *   and unpacked in the form of TknBuf in MGCP/MEGACO/SIP protocols.
 *   The exclusion check for CM_SDP_V_[23], CM_SDP_ATM_SUPPORT flags is
 *   already present in envopt.h file. Added the missing check here.
 */
#ifdef   CM_SDP_OPAQUE

#ifdef   LCCMSDP
#undef   LCCMSDP
#endif /* LCCMSDP */

#endif /* CM_SDP_OPAQUE */

#ifndef __CMSDPH__
#define __CMSDPH__


/*
 * 002.main_5: added a new define for maximum block size
 * used in packing/unpacking for RUG related temporary
 * memories.
 */
#define CM_TRANS_MAXBLKSIZE                5000



#ifdef CM_ABNF_V_1_3
#define CM_ABNF_ENC_PDU_MSG(_prot, _param, encMBuf, _newDef, dMem, err)    \
     (cmAbnfEncPduMsg((_prot) ,(U8 *)((_param)), encMBuf, &(_newDef), &dMem, &err, NULLP))
#else
#define CM_ABNF_ENC_PDU_MSG(_prot, _param, encMBuf, _newDef, dMem, err)    \
     (cmAbnfEncPduMsg((_prot) ,(U8 *)((_param)), encMBuf, &(_newDef), &dMem, &err))
#endif



/*
 * 002.main_5:
 * Added a new macro - CM_TRANSLATE_FUNC. It arguments are -
 * _param : this points to the event structure address used for encoding
 * _newDef : encode using this database definition
 * _oldDef : decode using this database definition
 * _allocEvt : the pointer type var used to alloc event i.e. MemCp.
 *             the struct pointed to by it must have CmMemListCp as
 *             its first field.
 * _memCp : memory control point; typically the CmMemListCp field
 *          allocated using _allocEvt var. Its the first field of
 *          struct pointed to by _allocEvt
 * _evt : event struct to be filled by decoder. Typically its the
 *        2nd field of the struct pointed to by _allocEvt.
 * _prot : protocol eg MGCP, MEGACO, SDP used by encoder & decoder
 */
#define CM_TRANSLATE_FUNC(_param,_newDef,_oldDef,_allocEvt,_memCp,_evt,_prot)\
{                                                                   \
 Buffer                  *encMBuf;                                  \
 CmAbnfDecOff            offset;                                    \
 CmAbnfErr               err;                                       \
 Mem                     dMem;                                      \
 MsgLen                  numDecBytes;                               \
                                                                    \
   cmMemset((U8 *)&err, 0, sizeof(CmAbnfErr));                      \
   cmMemset((U8 *)&offset, 0, sizeof(CmAbnfDecOff));                \
                                                                    \
   dMem.region = DFLT_REGION;                                       \
   dMem.pool   = DFLT_POOL;                                         \
                                                                    \
                                                                    \
   if (ROK != SGetMsg(DFLT_REGION, DFLT_POOL, &encMBuf))            \
   {                                                                \
       RETVALUE(RFAILED);                                           \
   }                                                                \
                                                                    \
 /*  if ((cmAbnfEncPduMsg((_prot) ,(U8 *)((_param)), encMBuf,   */  \
 /*                      &(_newDef), &dMem, &err)) != ROK)      */  \
   if ((CM_ABNF_ENC_PDU_MSG((_prot) ,(_param), encMBuf,             \
                       (_newDef), (dMem), (err))) != ROK)           \
   {                                                                \
       SPutMsg(encMBuf);                                            \
       RETVALUE(RFAILED);                                           \
   }                                                                \
                                                                    \
                                                                    \
   if (ROK != cmAllocEvnt((Size)sizeof(*(_allocEvt)),               \
              CM_TRANS_MAXBLKSIZE, &dMem, (Ptr *)&(_allocEvt)) )    \
   {                                                                \
       SPutMsg(encMBuf);                                            \
       RETVALUE(RFAILED);                                           \
   }                                                                \
                                                                    \
   if (ROK != cmAbnfDecPduMsg((_prot) , (CmMemListCp *)&(_memCp),   \
              (U8 *)&((_evt)), encMBuf, &(_oldDef), &numDecBytes,   \
              &offset, &err ) )                                     \
   {                                                                \
       SPutMsg(encMBuf);                                            \
       cmFreeMem((Ptr)(_allocEvt));                                 \
       RETVALUE(RFAILED);                                           \
   }                                                                \
                                                                    \
    SPutMsg(encMBuf);                                               \
                                                                    \
                                                                    \
}



/* NIL, NULL, unspecified, implicit */
#define CM_SDP_NIL         0
#define CM_SDP_CHOOSE      0

/* specified, explicit */
#define CM_SDP_SPEC        1

/* 001.main_10: the following is used where CM_SDP_NIL is also a choice.
 *             Its also used in the "$" choice of "a=rtpmap:$" */
#define CM_SDP_CHOICE      2

/* cm_sdp_h_001.main_16: Gap Change Added NIL Payload Type for media(m=) field */
#define CM_SDP_PAYLOAD_NIL 2

/* ON, OFF (or Null) */
#define CM_SDP_ON          1
#define CM_SDP_OFF         2

/* media types */
/* 001.main_12 RFC 4566: rempved data and control */
#define CM_SDP_MEDIA_UNKNOWN     0
#define CM_SDP_MEDIA_AUDIO       1
#define CM_SDP_MEDIA_VIDEO       2
/* cm_sdp_h_001.main_18: sdp media data macro added. */
#define CM_SDP_MEDIA_DATA        3
#define CM_SDP_MEDIA_APP         4
#define CM_SDP_MEDIA_IMAGE       5
#define CM_SDP_MEDIA_TEXT        6 

/* cm_sdp_h_001.main_16: Gap Change Added NIL media field */
/* cm_sdp_h_001.main_20: RFC 4975: Removed the flag IM_SUPPORT around 
 * media type "message" */
#define CM_SDP_MEDIA_MESSAGE     7
#define CM_SDP_MEDIA_NIL         8

/* cm_sdp_h_001.main_20: RFC-5547: Including for type and using the rest abv media 
 * type for filetype */
#define CM_SDP_TYPE_MULTIPART     9
/* sdp key types */

#define CM_SDP_KEY_TYPE_PROMPT 1
#define CM_SDP_KEY_TYPE_CLEAR  2
#define CM_SDP_KEY_TYPE_BASE64 3
#define CM_SDP_KEY_TYPE_URI    4

/* time unit */

#define CM_SDP_TIME_UNIT_DAY  1
#define CM_SDP_TIME_UNIT_HR   2
#define CM_SDP_TIME_UNIT_MIN  3
#define CM_SDP_TIME_UNIT_SEC  4

/* net type */
#define CM_SDP_NET_TYPE_NIL    CM_SDP_NIL
#define CM_SDP_NET_TYPE_IN     1
#define CM_SDP_NET_TYPE_ATM    2
#define CM_SDP_NET_TYPE_TN     3
#define CM_SDP_NET_TYPE_ANY    4
#define CM_SDP_NET_TYPE_LCL    5  
/*4566: allow uknown net type*/
#define CM_SDP_NET_TYPE_UNKNOWN 6

/* address type */
#define CM_SDP_ADDR_TYPE_NIL_NIL             CM_SDP_NIL
#define CM_SDP_ADDR_TYPE_NIL_CHOOSE          1
#define CM_SDP_ADDR_TYPE_CHOOSE_NIL          2
#define CM_SDP_ADDR_TYPE_CHOOSE_CHOOSE       3
#define CM_SDP_ADDR_TYPE_IPV4                4

/*  cm_sdp_h_001.main_17: RFC 4566 supported. */
#define CM_SDP_ADDR_TYPE_IPV6                5
#define CM_SDP_ADDR_TYPE_RFC2543             6
/* #define CM_SDP_ADDR_TYPE_XTOKEN              7 */
#define CM_SDP_ADDR_TYPE_NSAP                7
#define CM_SDP_ADDR_TYPE_E164                8
#define CM_SDP_ADDR_TYPE_GWID                9
#define CM_SDP_ADDR_TYPE_ALIAS              10
#define CM_SDP_ADDR_TYPE_NSAP_CHOOSE        11
#define CM_SDP_ADDR_TYPE_E164_CHOOSE        12
#define CM_SDP_ADDR_TYPE_GWID_CHOOSE        13
#define CM_SDP_ADDR_TYPE_ALIAS_CHOOSE       14
#define CM_SDP_ADDR_TYPE_NSAP_NIL           15
#define CM_SDP_ADDR_TYPE_E164_NIL           16
#define CM_SDP_ADDR_TYPE_GWID_NIL           17
#define CM_SDP_ADDR_TYPE_ALIAS_NIL          18
#define CM_SDP_ADDR_TYPE_LCL                190    
/*4566: allow uknown addr type*/
#define CM_SDP_ADDR_TYPE_UNKNOWN            19

/* IPV4 address type */
#define CM_SDP_IPV4_FQDN      1
#define CM_SDP_IPV4_IP_UNI       2
#define CM_SDP_IPV4_IP_MULTI     3
#define CM_SDP_IPV4_IP_ANY       4

/* IPV6 address type */
#define CM_SDP_IPV6_FQDN         1
#define CM_SDP_IPV6_IP           2
/* 001.main_12 RFC 4566 : IPV6_MULTI is removed from V_3 */
#define CM_SDP_IPV6_MULTI        3
/* 001.main_12 RFC 4566 : IPV6_ANY added */
#define CM_SDP_IPV6_ANY          4

/* Email types */
#define CM_SDP_EMAIL_ONLY        1
#define CM_SDP_EMAIL_NAME        2
#define CM_SDP_NAME_EMAIL        3

/* Phone types */
#define CM_SDP_PHONE_ONLY        1
#define CM_SDP_PHONE_NAME        2
#define CM_SDP_NAME_PHONE        3

/* cm_sdp_h_001.main_16: RFC 4585 Enhancement */
/* Max SDP Attributes */
#define CM_SDP_ATTR_MAX                           110

/*cm_sdp_h_001.main_20: RFC- 5547 Max SDP Attributes for FileSubtypeParams */
#define CM_SDP_ATTR_FILE_SUB_PARAMS                100
#define CM_SDP_ATTR_FILE_SPACE_SELECTOR            10
#define CM_SDP_ATTR_FILE_DATE_PARAM                100

/* Attribute types */
#define CM_SDP_ATTR_GENERIC                       0
#define CM_SDP_ATTR_CAT                           1
#define CM_SDP_ATTR_KEYWDS                        2
#define CM_SDP_ATTR_TOOL                          3
#define CM_SDP_ATTR_PTIME                         4
#define CM_SDP_ATTR_RECVONLY                      5
#define CM_SDP_ATTR_SENDRECV                      6
#define CM_SDP_ATTR_SENDONLY                      7
#define CM_SDP_ATTR_ORIENT                        8
#define CM_SDP_ATTR_TYPE                          9
#define CM_SDP_ATTR_CHARSET                       10
#define CM_SDP_ATTR_SDPLANG                       11
#define CM_SDP_ATTR_LANG                          12
#define CM_SDP_ATTR_FRAMERATE                     13
#define CM_SDP_ATTR_QUALITY                       14
#define CM_SDP_ATTR_FMTP                          15
#define CM_SDP_ATTR_RTPMAP                        16
#define CM_SDP_ATTR_INACTIVE                      17
#define CM_SDP_ATTR_CONTROL                       18
#define CM_SDP_ATTR_RANGE                         19
#define CM_SDP_ATTR_ETAG                          20
#define CM_SDP_ATTR_ATMMAP                        21
#define CM_SDP_ATTR_EECID                         22
#define CM_SDP_ATTR_AALTYPE                       23
#define CM_SDP_ATTR_SILENCESUPP                   24
#define CM_SDP_ATTR_ECAN                          25
#define CM_SDP_ATTR_GC                            27
#define CM_SDP_ATTR_PROFILEDESC                   29
#define CM_SDP_ATTR_VSEL                          30
#define CM_SDP_ATTR_DSEL                          31
#define CM_SDP_ATTR_FSEL                          32
#define CM_SDP_ATTR_CAPABILITY                    33
#define CM_SDP_ATTR_QOSCLASS                      34
#define CM_SDP_ATTR_BCOB                          35
#define CM_SDP_ATTR_STC                           36
#define CM_SDP_ATTR_UPCC                          37
#define CM_SDP_ATTR_ATMQOSPARMS                   38
#define CM_SDP_ATTR_AAL2QOSFPARMS                 40
#define CM_SDP_ATTR_AAL2QOSBPARMS                 41
#define CM_SDP_ATTR_ATMTRFCDESC                   42
#define CM_SDP_ATTR_AAL2FTRFCDESC                 44
#define CM_SDP_ATTR_AAL2BTRFCDESC                 45
#define CM_SDP_ATTR_ABRPARMS                      46
#define CM_SDP_ATTR_CLKREC                        48
#define CM_SDP_ATTR_FEC                           49
#define CM_SDP_ATTR_PRTFL                         50
#define CM_SDP_ATTR_BEARERTYPE                    51
#define CM_SDP_ATTR_STRUCTURE                     52
#define CM_SDP_ATTR_SBC                           53
#define CM_SDP_ATTR_CPSSDUSIZE                    54
#define CM_SDP_ATTR_AAL2CPS                       56

#define CM_SDP_ATTR_AAL2SSCS3661                  157
#define CM_SDP_ATTR_AAL2SSCS3661_UNASS            57

#define CM_SDP_ATTR_AAL2SSCS3662                  58
#define CM_SDP_ATTR_AAL2SSCS3652                  59
#define CM_SDP_ATTR_AAL2SSCS3653                  60
#define CM_SDP_ATTR_AAL5APP                       61
#define CM_SDP_ATTR_LIJ                           62
#define CM_SDP_ATTR_ANYCAST                       63
#define CM_SDP_ATTR_WTP                           64
#define CM_SDP_ATTR_CACHE                         65
#define CM_SDP_ATTR_CHAIN                         66
#define CM_SDP_ATTR_PHONECONTEXT                  67
#define CM_SDP_ATTR_CLIR                          68
#define CM_SDP_ATTR_Q763NATURE                    69
#define CM_SDP_ATTR_Q763PLAN                      70
#define CM_SDP_ATTR_Q763INN                       71
#define CM_SDP_ATTR_REQUIRE                       72
#define CM_SDP_ATTR_DIRECTION                     73

#define CM_SDP_ATTR_ABR_SETUP                     85
#define CM_SDP_ATTR_AAL2_CPSSDURATE               86
#define CM_SDP_ATTR_AAL5_SSCOP                    87
#define CM_SDP_ATTR_BRR_SIGIE                     88
#define CM_SDP_ATTR_ONE_WAY_SEL                   89
#define CM_SDP_ATTR_CODEC_CFG                     90
#define CM_SDP_ATTR_ISUP_USI                      91
#define CM_SDP_ATTR_UILYR1_PROT                   92
#define CM_SDP_ATTR_CBR_RATE                      93
#define CM_SDP_ATTR_AAL2SSCS3661_ASS              94
#define CM_SDP_ATTR_IPBCP                         95
#define CM_SDP_ATTR_MAXPTIME                      99
/* cm_sdp_h_001.main_16: RFC 4585 Enhancement */
#define CM_SDP_ATTR_RTCPFB                        102

#define CM_SDP_ATTR_QOS                           74
#define CM_SDP_ATTR_SECURE                        75
#define CM_SDP_ATTR_FID                           76
#define CM_SDP_ATTR_MID                           77
#define CM_SDP_ATTR_GROUP                         78
#define CM_SDP_ATTR_SQN_NUM                       79
#define CM_SDP_ATTR_CDSC                          80
#define CM_SDP_ATTR_CPAR                          81
#define CM_SDP_ATTR_CPAR_MIN                      82
#define CM_SDP_ATTR_CPAR_MAX                      83
#define CM_SDP_ATTR_T38_FAX                       84

#define CM_SDP_ATTR_CURR_STATUS                   96
#define CM_SDP_ATTR_DES_STATUS                    97
#define CM_SDP_ATTR_CONF_STATUS                   98
#define CM_SDP_ATTR_GPMD                         100
#define CM_SDP_ATTR_MAXMPTIME                    101
/*cm_sdp_h_001.main_20:RFC 5547 new Fields to be added  */

#define CM_SDP_ATTR_FILE_SEL                     103
#define CM_SDP_ATTR_FILE_DISPOSITION             104
#define CM_SDP_ATTR_FILE_TRANSFER_ID             105
#define CM_SDP_ATTR_FILE_DATE                    106
#define CM_SDP_ATTR_FILE_ICON                    107
#define CM_SDP_ATTR_FILE_RANGE                   108
#define CM_SDP_ATTR_MGW_IDENTIFIER               109

/* Attribute FileSelector type */

#define CM_SDP_ATTR_FILENM_SELECTOR               0 
#define CM_SDP_ATTR_FILESIZE_SELECTOR             1
#define CM_SDP_ATTR_FILETYPE_SELECTOR             2
#define CM_SDP_ATTR_HASH_SELECTOR                 3

/* File date attr */

#define CM_SDP_FILEDATE_CREATION       0
#define CM_SDP_FILEDATE_MODIFICATION   1
#define CM_SDP_FILEDATE_READ           2

/* Attribute Cap Parm types */
#define CM_SDP_ATTR_CPAR_BW            0
#define CM_SDP_ATTR_CPAR_ATTR          1

/* Attribute QOS/Secure Strength Tag Values */
#define CM_SDP_ATTR_QS_STRN_TAG_MAND      0
#define CM_SDP_ATTR_QS_STRN_TAG_OPT       1
#define CM_SDP_ATTR_QS_STRN_TAG_SUCC      2
#define CM_SDP_ATTR_QS_STRN_TAG_FAIL      3

/* Attribute QOS/Secure Direction Tag Values */
#define CM_SDP_ATTR_QS_DIR_TAG_SEND           0
#define CM_SDP_ATTR_QS_DIR_TAG_RECV           1
#define CM_SDP_ATTR_QS_DIR_TAG_SEND_RECV      2

/* Attribute Group Semantics Values */
#define CM_SDP_ATTR_GROUP_SEMN_LS         0
#define CM_SDP_ATTR_GROUP_SEMN_FID        1

/* Bandwidth Modifier Type Values */
#define CM_SDP_BW_TYPE_APP_SPEC_MAX       0
#define CM_SDP_BW_TYPE_RTCP_SNDR          1
#define CM_SDP_BW_TYPE_RTCP_OTHR          2
#define CM_SDP_BW_TYPE_UNKNOWN            3

/* vals of val field of CmSdpAttrT38Fax  */
#define    CM_SDP_ATTR_T38_FAX_RATE_MNG_LOC_TCF    0
#define    CM_SDP_ATTR_T38_FAX_RATE_MNG_TRANSF_TCF    1
#define    CM_SDP_ATTR_T38_FAX_UDP_EC_UDP_FEC    0
#define    CM_SDP_ATTR_T38_FAX_UDP_EC_UDP_RED    1

/* CmSdpAttrT38Fax type vals */
#define    CM_SDP_ATTR_T38_FAX_VER    0
#define    CM_SDP_ATTR_T38_MAX_BIT_RATE    1
#define    CM_SDP_ATTR_T38_FAX_FILL_BIT_RMVL    2
#define    CM_SDP_ATTR_T38_FAX_TRNS_MMR    3
#define    CM_SDP_ATTR_T38_FAX_TRNS_JBIG    4
#define    CM_SDP_ATTR_T38_FAX_RATE_MNGMNT    5
#define    CM_SDP_ATTR_T38_FAX_MAX_BFR    6
#define    CM_SDP_ATTR_T38_FAX_MAX_DATAGRAM    7
#define    CM_SDP_ATTR_T38_FAX_UDP_EC    8
/* 001.main_10: added new defines in the choice */
#define    CM_SDP_ATTR_T38_FAX_HIGH_RDNCY    9   /* t38 modification */
#define    CM_SDP_ATTR_T38_FAX_LOW_RDNCY     10  /* t38 modification */
#define    CM_SDP_ATTR_T38_FAX_UNKNOWN       11  /* t38 modification */


/* Attribute field Orient types */
#define CM_SDP_ATTR_ORIENT_PORTRAIT       1
#define CM_SDP_ATTR_ORIENT_LANDSCAPE      2
#define CM_SDP_ATTR_ORIENT_SEASCAPE       3

/* Attribute field Type types */
#define CM_SDP_ATTR_TYPE_UNKNOWN          0
#define CM_SDP_ATTR_TYPE_BROADCAST        1
#define CM_SDP_ATTR_TYPE_MEETING          2
#define CM_SDP_ATTR_TYPE_MODERATED        3
#define CM_SDP_ATTR_TYPE_TEST             4
#define CM_SDP_ATTR_TYPE_H332             5

/* Attribute field Fmtp types */
#define CM_SDP_ATTR_FMTP_UNSPEC           0
#define CM_SDP_ATTR_FMTP_RFC2848          1
#define CM_SDP_ATTR_FMTP_RFC2733          2
#define CM_SDP_ATTR_FMTP_RFC2833          3
#define CM_SDP_ATTR_FMTP_EMP_ORD          4
#define CM_SDP_ATTR_FMTP_RFC3555          5
#define CM_SDP_ATTR_FMTP_RFC3267          6
#define CM_SDP_ATTR_FMTP_IPBCP            7

/*
   HashDefs for draft-ietf-avt-dv-audio-03.txt
*/

/*
   Possible vals of order field of CmSdpAttrFmtpChnOrdSeq
*/
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDERCH41    0
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDERCH42    1
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDERCH43    2
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDERCH5    3
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CH61    4
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CH62    5
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CH81    6
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CH82    7
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CH83    8
/*
   Possible vals of convention field of CmSdpAttrFmtpChnOrdSeq
*/
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CONV_AIFFC    0
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER_CONV_DV    1

/*
   type field of CmSdpAttrFmtpEmChnChc
*/
#define    CM_SDP_ATTR_FMTP_EMPHASIS    0
#define    CM_SDP_ATTR_FMTP_CHANEL_ORDER    1
/* Strength tag options */
#define    CM_SDP_STRENGTH_TAG_MAND    0
#define    CM_SDP_STRENGTH_TAG_OPT    1
#define    CM_SDP_STRENGTH_TAG_NONE    2
#define    CM_SDP_STRENGTH_TAG_FAIL    3
#define    CM_SDP_STRENGTH_TAG_UNKN    4
/* Direction Tag options */
#define    CM_SDP_DIR_TAG_NONE    0
#define    CM_SDP_DIR_TAG_SEND    1
#define    CM_SDP_DIR_TAG_RECV    2
#define    CM_SDP_DIR_TAG_SEND_RECV    3
/* Status Type */
#define    CM_SDP_STATUS_TYPE_E2E    0
#define    CM_SDP_STATUS_TYPE_LOCAL    1
#define    CM_SDP_STATUS_TYPE_REMOTE    2
/* Precondition Type for the attribute (RFC3312)*/
#define    CM_SDP_PRE_COND_TYPE_QOS    0
#define    CM_SDP_PRE_COND_TYPE_OTHER  1


/* cm_sdp_h_001.main_16: RFC 4585 Enhancement */
#define    CM_SDP_RTCP_FB_VAL_ACK    0
#define    CM_SDP_RTCP_FB_VAL_NACK   1
#define    CM_SDP_RTCP_FB_VAL_TRR    2
#define    CM_SDP_RTCP_FB_VAL_OTH    3

#define    CM_SDP_RTCP_FB_VAL_APP      0
#define    CM_SDP_RTCP_FB_VAL_TOKEN    1
#define    CM_SDP_RTCP_FB_VAL_RPSI     2
#define    CM_SDP_RTCP_FB_VAL_NACK_PLI 3
#define    CM_SDP_RTCP_FB_VAL_NACK_SLI 4
/*  cm_sdp_h_001.main_20:RFC-5547: FileRange type of FileSelector */
#define    CM_SDP_STAR                0
/*  cm_sdp_h_001.main_20:RFC-5547: FileRange type of FileSelector */

#define    CM_SDP_FMT_STAR            0
#define    CM_SDP_FILE_RANGE_STOP_OFF 1
#define    CM_SDP_RTCP_FB_PT_FMT      1

/* Below hash defines included for fmtp by GCP */

/* parameters of fmtp 3GPP TS 29.414 v7.0.0 IPBCP Support*/
#define    CM_SDP_ATTR_FMTP_I_P_B_C_P_P_C_M_P                0

/* parameters of fmtp RFC 3267 */
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_OTHER                0
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_OCTET_ALIGN          1
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_MODE_CHANGE_PERIOD   2
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_MODE_CHANGE_NEIGHBOR 3
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_MODE_SET_LST         4
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_CRC                  5
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_ROBUST_SORTING       6
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_INTERLEAVING         7
#define    CM_SDP_ATTR_FMTP3267_PAR_VAL_CHANNELS             8

/* fmtp RFC 3555 annexa parameter possible values */
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_ANNEXA_VAL_YES    0
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_ANNEXA_VAL_NO     1

/* fmtp RFC 3555 annexb parameter possible values */
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_ANNEXB_VAL_YES    0
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_ANNEXB_VAL_NO     1

/* fmtp RFC 3555 mode parameter possible values */
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_MODE_STEREO    0
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_MODE_J_S       1
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_MODE_S_C       2
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_MODE_D_C       3

/* fmtp RFC 3555 type parameter possible values */
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_TYPE_M_P_E_G1               0
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_TYPE_M_P_E_G2_H_A_L_F_D1    1
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_TYPE_M_P_E_G2_F_U_L_L_D1    2

/* parameters of fmtp RFC 3555 */
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_OTHER      0
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_ANNEXA     1
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_ANNEXB     2
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_LAYER      3
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_MODE       4
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_BITRATE    5
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_SAMPLERATE 6
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_PROFILE    7
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_LEVEL      8
#define    CM_SDP_ATTR_FMTP3555_PAR_VAL_TYPE       9

/* GPMD Hash Defines */
#define    CM_SDP_ATTR_GPMD_V152_PAR_VBD_VAL_YES    0
#define    CM_SDP_ATTR_GPMD_V152_PAR_VBD_VAL_NO    1

#define    CM_SDP_ATTR_GPMD_V152_PAR_OTHER    0
#define    CM_SDP_ATTR_GPMD_V152_PAR_VBD    1

#define    CM_SDP_ATTR_GPMD_OTHER    0
#define    CM_SDP_ATTR_GPMD_V152    1


/* Attribute field Fmtp 2848 resolution types */
#define CM_SDP_ATTR_FMTP_RFC2848_URI      1
#define CM_SDP_ATTR_FMTP_RFC2848_OPR      2
#define CM_SDP_ATTR_FMTP_RFC2848_SPR      3

/* Encoding names */
#define CM_SDP_ENC_UNSPEC          CM_SDP_NIL
#define CM_SDP_ENC_UNKNOWN             1          
#define CM_SDP_ENC_PCMG                2    
#define CM_SDP_ENC_SIDG                3    
#define CM_SDP_ENC_SID729              4    
#define CM_SDP_ENC_PCMU                5    
#define CM_SDP_ENC_G726_32             6    
#define CM_SDP_ENC_G723                7    
#define CM_SDP_ENC_PCMA                8    
#define CM_SDP_ENC_G722                9    
#define CM_SDP_ENC_G728                10   
#define CM_SDP_ENC_G729                11   
#define CM_SDP_ENC_G729A             12   
#define CM_SDP_ENC_G729B             13   
#define CM_SDP_ENC_G729AB            14   
#define CM_SDP_ENC_G726_16           15   
#define CM_SDP_ENC_G726_24           16   
#define CM_SDP_ENC_G726_40           17   
#define CM_SDP_ENC_G7231_H           18   
#define CM_SDP_ENC_G7231_L           19   
#define CM_SDP_ENC_G7231A_H          20   
#define CM_SDP_ENC_G7231A_L          21   
#define CM_SDP_ENC_G727_16           22   
#define CM_SDP_ENC_G727_24           23   
#define CM_SDP_ENC_G727_32           24   
#define CM_SDP_ENC_CCD               25   
#define CM_SDP_ENC_CCD_CAS           26   
#define CM_SDP_ENC_GSM                 27   
#define CM_SDP_ENC_GSM_HR            28   
#define CM_SDP_ENC_GSM_EFR           29   
#define CM_SDP_ENC_GSM_EHR           30   
#define CM_SDP_ENC_FXDMOD_3          31   
#define CM_SDP_ENC_1016                32   
#define CM_SDP_ENC_DVI4                33   
#define CM_SDP_ENC_L16                 34   
#define CM_SDP_ENC_LPC                 35   
#define CM_SDP_ENC_MPA                 36   
#define CM_SDP_ENC_QCELP               37   
#define CM_SDP_ENC_JPEG                38   
#define CM_SDP_ENC_H261                39   
#define CM_SDP_ENC_MPV                 40   
#define CM_SDP_ENC_MP2T                41   
#define CM_SDP_ENC_NV                  42   
#define CM_SDP_ENC_RED                 43   
#define CM_SDP_ENC_CELB                44   
#define CM_SDP_ENC_L8                  45   
#define CM_SDP_ENC_VDVI                46   
#define CM_SDP_ENC_H263                47   
#define CM_SDP_ENC_H263_1998           48   
#define CM_SDP_ENC_MP1S                49   
#define CM_SDP_ENC_MP2P                50

/*
   Following are the new hash defines for the new
   encoding names in draft-ietf-avt-dv-audio-03.txt
*/
/* cm_sdp_h_002.main_12 CM_SDP_V_3 flag removed */

#define CM_SDP_ENC_L20                 51
#define CM_SDP_ENC_L24                 52
#define CM_SDP_ENC_DAT12               53
/* 003.main_5: added new hash defines */
#define CM_SDP_ENC_TELEPHONE_EVENT     54
#define CM_SDP_ENC_CN                  55

/* Following new rtpmap MIME Subtypes added by GCP */
#define CM_SDP_ENC_G729D               56
#define CM_SDP_ENC_G729E               57
#define CM_SDP_ENC_BT656               58
#define CM_SDP_ENC_H263_2000           59
#define CM_SDP_ENC_BMPEG               60
#define CM_SDP_ENC_CLEARMODE           61
#define CM_SDP_ENC_AMR                 62
#define CM_SDP_ENC_AMR_WB              63
#define CM_SDP_ENC_VND_3GPP_IUFP       64       /* IPBCP Support */


/* Time types in range */
#define CM_SDP_RANGE_SMPTE              1
#define CM_SDP_RANGE_SMPTE_30_DROP      2
#define CM_SDP_RANGE_SMPTE_25           3
#define CM_SDP_RANGE_NPT                4
#define CM_SDP_RANGE_UTC                5

/* NPT time type */
#define CM_SDP_NPT_NOW                  1
#define CM_SDP_NPT_SEC                  2
#define CM_SDP_NPT_HMS                  3

/* AAL Type */
#define CM_SDP_AAL_TYPE_1                 1
#define CM_SDP_AAL_TYPE_2                 2
#define CM_SDP_AAL_TYPE_34                3
#define CM_SDP_AAL_TYPE_USERDEF           4
#define CM_SDP_AAL_TYPE_5                 5
#define CM_SDP_AAL_TYPE_AAL1_SDT          6
#define CM_SDP_AAL_TYPE_AAL1_UDT          7

/* Silence suppression preference */
#define CM_SDP_SIL_SUPP_PREF_STANDARD     1
#define CM_SDP_SIL_SUPP_PREF_CUSTOM       2

/* SID Use */
#define CM_SDP_SID_USE_NO_SID             1
#define CM_SDP_SID_USE_FIXED_NOISE        2
#define CM_SDP_SID_USE_SAMPLED_NOISE      3

/* Direction flag values */
#define    CM_SDP_DIR_FLG_FORW    0
#define    CM_SDP_DIR_FLG_BACK    1
#define    CM_SDP_DIR_FLG_BOTH    2

/* service type values */
#define    CM_SDP_ATTR_SRV_TYP_VOICE                0
#define    CM_SDP_ATTR_SRV_TYP_VOICE_BND_DAT        1
#define    CM_SDP_ATTR_SRV_TYP_FAX                  2
#define    CM_SDP_ATTR_SRV_TYP_VOICE_BND_DAT_FAX    3
#define    CM_SDP_ATTR_SRV_TYP_ALL                  4


/* Echo cancellation type */
#define CM_SDP_ECHO_CAN_G165              1
#define CM_SDP_ECHO_CAN_G168              2

/* Known Media Protocols/Transports */
#define CM_SDP_MEDIA_PROTO_UNKNOWN        0
#define CM_SDP_MEDIA_PROTO_UDP            1
#define CM_SDP_MEDIA_PROTO_RTP            2
#define CM_SDP_MEDIA_PROTO_AAL1           3
#define CM_SDP_MEDIA_PROTO_AAL2           4
#define CM_SDP_MEDIA_PROTO_AAL5           5
#define CM_SDP_MEDIA_PROTO_H323C          6
#define CM_SDP_MEDIA_PROTO_TN_VOICE       7
#define CM_SDP_MEDIA_PROTO_TN_FAX         8
#define CM_SDP_MEDIA_PROTO_TN_PAGER       9
#define CM_SDP_MEDIA_PROTO_TCP           10
#define CM_SDP_MEDIA_PROTO_LCL           11   
#define CM_SDP_MEDIA_PROTO_SAP           12
/* 001.main_5: added defines for udptl formats */
#define CM_SDP_MEDIA_PROTO_UDPTL         13
/* cm_sdp_h_001.main_16: Removed from CM_SDP_SIP_IM_SUPPORT flag */
#define CM_SDP_MEDIA_PROTO_SIP           14   
#define CM_SDP_UDPTL_FMT_UNKNOWN          0
#define CM_SDP_UDPTL_FMT_T38              1

/* Known RTP Subtypes */
#define CM_SDP_PROTO_RTP_AVP              1
/* 001.main_12 RFC 4566 */
#define CM_SDP_PROTO_RTP_SAVP             2
#define CM_SDP_PROTO_RTP_AVP_TCP          3
#define CM_SDP_PROTO_RTP_AVPF             4
#define CM_SDP_PROTO_RTP_UNKNOWN          5

/* cm_sdp_h_001.main_19: 97564 TCP Subtypes */
#define CM_SDP_PROTO_TCP_UNKNOWN          0
#define CM_SDP_PROTO_TCP_MSRP             1            /* cm_sdp_h_001.main_20:RFC:4975, added defines for TLS & MSRP as TCP Subtypes */
#define CM_SDP_PROTO_TCP_TLS              2

/*  cm_sdp_h_001.main_20:RFC:4975,Media protocol format for TCP */
#define CM_SDP_TCP_FMT_UNKNOWN   	  0
#define CM_SDP_TCP_FMT_STAR               1             /* added Format unknow and star */

	/* Known AALx Subtypes */
/* Note: Currently AAL1, AAL2 and AAL5 have the same subtypes. */
#define CM_SDP_PROTO_AALX_CORPORATE       0
#define CM_SDP_PROTO_AALX_UNKNOWN         CM_SDP_PROTO_AALX_CORPORATE
#define CM_SDP_PROTO_AALX_ATMF            1
#define CM_SDP_PROTO_AALX_AVP             CM_SDP_PROTO_AALX_ATM
#define CM_SDP_PROTO_AALX_ITU             2
#define CM_SDP_PROTO_AALX_IEEE            3
#define CM_SDP_PROTO_AALX_CUSTOM          4

/* Known ASC/ATC Values for Capability */
#define CM_SDP_CAPAB_NONSTD               0
#define CM_SDP_CAPAB_ASC_CBR              1
#define CM_SDP_CAPAB_ASC_NRT_VBR          2
#define CM_SDP_CAPAB_ASC_RT_VBR           3
#define CM_SDP_CAPAB_ASC_UBR              4
#define CM_SDP_CAPAB_ASC_ABR              5
#define CM_SDP_CAPAB_ASC_GFR              6
#define CM_SDP_CAPAB_ATC_DBR              7
#define CM_SDP_CAPAB_ATC_SBR              8
#define CM_SDP_CAPAB_ATC_ABT_IT           9
#define CM_SDP_CAPAB_ATC_ABT_DT          10
#define CM_SDP_CAPAB_ATC_ABR              CM_SDP_CAPAB_ASC_ABR

/* CDV type */
#define CM_SDP_CDV_TYPE_PEAK_TO_PEAK       1
#define CM_SDP_CDV_TYPE_2_POINT            2

/* CLP level */
#define CM_SDP_CLP_LEVEL_0                1
#define CM_SDP_CLP_LEVEL_0_PLUS_1         2

/* Clock recovery */
#define CM_SDP_CLK_REC_NULL               0
#define CM_SDP_CLK_REC_SRTS               1
#define CM_SDP_CLK_REC_ADAPTIVE           2

/* Forward error correction */
#define CM_SDP_FEC_NULL                   0
#define CM_SDP_FEC_LOSS_SENSITIVE         1
#define CM_SDP_FEC_DELAY_SENSITIVE        2

/* Bearer type */
#define CM_SDP_BEAR_TYPE_PVC              1
#define CM_SDP_BEAR_TYPE_SVC              2
#define CM_SDP_BEAR_TYPE_CID              3

/* AAL 366.2 SAP type */
#define CM_SDP_AAL2_366_2_SAP_AUDIO       1
#define CM_SDP_AAL2_366_2_SAP_MULTIRATE   2

/* AAL 366.2 encoding */
#define CM_SDP_AAL2_366_2_ENC_ALAW        1
#define CM_SDP_AAL2_366_2_ENC_MULAW       2

/* AAL5 app */
#define CM_SDP_AAL5APP_NONSTD             0
#define CM_SDP_AAL5APP_H323C              1
#define CM_SDP_AAL5APP_AF83               2
#define CM_SDP_AAL5APP_ASSURED_SSCOP      3
#define CM_SDP_AAL5APP_NONASSURED_SSCOP   4
#define CM_SDP_AAL5APP_ITU_I3651          5
#define CM_SDP_AAL5APP_ITU_I3652          6
#define CM_SDP_AAL5APP_ITU_I3653          7
#define CM_SDP_AAL5APP_FRF11              8
#define CM_SDP_AAL5APP_ITU_H2221          9
#define CM_SDP_AAL5APP_ITU_I3661         10
#define CM_SDP_AAL5APP_ITU_I3662         11
#define CM_SDP_AAL5APP_FRF8              12
#define CM_SDP_AAL5APP_FRF5              13

/* Chain */
#define CM_SDP_CHAIN_NULL                 0
#define CM_SDP_CHAIN_PREV                 1
#define CM_SDP_CHAIN_NEXT                 2

/* Attribute field Direction types */
#define CM_SDP_ATTR_DIRECTION_PASSIVE     1
#define CM_SDP_ATTR_DIRECTION_ACTIVE      2
#define CM_SDP_ATTR_DIRECTION_BOTH        3

/* IPBCP Message types */
#define CM_SDP_ATTR_IPBCP_INVALID         0
#define CM_SDP_ATTR_IPBCP_REQUEST         1
#define CM_SDP_ATTR_IPBCP_ACCEPTED        2
#define CM_SDP_ATTR_IPBCP_REJECTED        3
#define CM_SDP_ATTR_IPBCP_CONFUSED        4

/* Phone context ident */
#define CM_SDP_PHONE_CONTEXT_LOCAL        1
#define CM_SDP_PHONE_CONTEXT_INTL         2
#define CM_SDP_PHONE_CONTEXT_PRIVATE      3

/* Truth and lies */
#define CM_SDP_FALSE                      0
#define CM_SDP_TRUE                       1

/* Zero and one */
#define CM_SDP_ZERO                       0
#define CM_SDP_ONE                        1

/* VcId types */
#define CM_SDP_VCID_NIL                   CM_SDP_NIL
#define CM_SDP_VCID_CHOOSE                1
#define CM_SDP_VCID_VCCI                  2
#define CM_SDP_VCID_ATM_ADDR_VCCI         3
#define CM_SDP_VCID_BCG                   4
#define CM_SDP_VCID_PORT                  5
#define CM_SDP_VCID_VPCI                  6
#define CM_SDP_VCID_IMPLICIT              7

/* VcId Atm Addr types */           
#define CM_SDP_ADDR_VCCI                  1
#define CM_SDP_ADDR_VPCIVCI               2
#define CM_SDP_ADDR_VPIVCI                3

/* Port types */
#define CM_SDP_PORT_INT                   1
#define CM_SDP_PORT_VPCID                 2
/* constraints for parameters */

#define CM_SDP_MAX_SZ               100
#define CM_SDP_MAX_ATTR             100
#define CM_SDP_MAX_TYPED_TIME       100
#define CM_SDP_MAX_REP_FIELD        100
#define CM_SDP_MAX_ZONE_ADJ         100
#define CM_SDP_MAX_EMAIL            100
#define CM_SDP_MAX_PHONE            100
#define CM_SDP_MAX_SDP_OPTIME       100
#define CM_SDP_MAX_MEDIADESC        100
#define CM_SDP_MAX_CONN             100
#define CM_SDP_MAX_BW               100
#define CM_SDP_MAX_FMT              100
#define CM_SDP_MAX_FMTP_RES         100
#define CM_SDP_MAX_ATTR_FMTP_ATTR   100
#define CM_SDP_MAX_PROF_COMPS       100
#define CM_SDP_MAX_DEV_SEL_COMPS    100
#define CM_SDP_MAX_REQUIRE_ATTRS    100
#define CM_SDP_MAX_FMTS             100
#define CM_SDP_MAX_PROTFMTLISTS     100
/* 001.main_12 RFC 4566 */
#define CM_SDP_MAX_HEX_SEQ          100
/* below hash define added by GCP*/
#define CM_SDP_MAX_PARLST           100

#define CM_SDP_MAX_UNKNOWN       0xFFFF

#endif /* not defined __CMSDPH__ */

#define ECM_XXX                     0

/********************************************************************30**

         End of file:     cm_sdp.h@@/main/21 - Wed Sep 22 19:47:18 2010

*********************************************************************31*/

/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/
  
/********************************************************************50**
  
*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      rrp  1. initial release.
/main/2      ---      nct  1. New release for GCP 1.2.
/main/4      ---      sk   1. Added new defines
/main/5      ---      ra   1. GCP Release 1.3
/main/6    001.main_5 rg   1. Added hash defines for transport UDPTL for media
                              type Image
/main/7    002.main_5 ra   1. Added a new macro def -
                              CM_TRANSLATE_FUNC()
                              which can be used to easily write the RUG
                              related translation functions. The hash def
                              CM_TRANS_MAXBLKSIZE is used in this macro.
                           2. Added a new hash define -
                              CM_TRANS_MAXBLKSIZE
                              which is used in cmAllocEvnt in RUG related
                              translation.
                      cy   3. Changes made for SIP release 1.2
/main/8      --- rg  1. Added new hash defines for EncodingName
/main/9      ---      up   1. Support for IPBCP in SDP
/main/10     ---      pk   1. GCP release 1.5
/main/10 001.main_10    ra   1. The following is used where CM_SDP_NIL
                              is also a choice. Its also used in the
                              "$" choice of "a=rtpmap:$"
                            2. Added new choice type defines for the struct
                              CmSdpAttrT38Fax.
/main/11     ---      aj   1. Added exclusion checks for CM_SDP_OPAQUE
                              and LCCMSDP flags.
                           2. The following is used where CM_SDP_NIL
                              is also a choice. Its also used in the
                              "$" choice of "a=rtpmap:$"
                           3. Added new choice type defines for the struct
                              CmSdpAttrT38Fax.
/main/12     ---      pb   1. Updated for SIP release 2.2
/main/13     ---      mm   1. Grammar for RFC 3312 and 4566 updated
/main/14     ----     sy   GCP 2.1 release
/main/15     ---      gk   1. Removed from CM_SDP_SIP_IM_SUPPORT flag
/main/16     ---       mm   1. Compilation error fixed.CM_SDP_SIP_IM_SUPPORT flag removed.
/main/17     ---  cm_sdp_h_001.main_16 ac 1. RFC 4585 Enhancement.
                                    2. 4566 Gap Change.
/main/18     ---  cm_sdp_h_001.main_17 gs 1. RFC 4566 supported.
/main/19     ---  cm_sdp_h_001.main_18 gs 1. sdp media data macro added.
/main/20     ---  cm_sdp_h_001.main_19 mk 1. Added the macro for TCP SubType.
/main/21     ---  cm_sdp_h_001.main_20 nj 1. Enhancement for RFC 4497 Added in the media line
                                             TCP subtype as
                                             TLS/MSRP and Format to specific "*"
                                            2. Enchancement for RFC 5547 Added 6 Fields to attribute
                                               line.
*********************************************************************91*/
