/*******************************************************************************
*
* Title: sng_isdn_error.h
*
* Description: sng_isdn_error header
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: 06-02-2010
*
*******************************************************************************/
#ifndef __SNG_ISDN_ERROR_H__
#define __SNG_ISDN_ERROR_H__
/******************************************************************************/
#define DECODE_ENTITY(ent) \
((ent) == ENTSM)    ?"Stack Manager" : \
((ent) == ENTCC)    ?"Call Control" : \
((ent) == ENTSI)    ?"ISUP" : \
((ent) == ENTSN)    ?"MTP3" : \
((ent) == ENTSD)    ?"MTP2" : \
((ent) == ENTL1)    ?"Physical Layer" : \
((ent) == ENTIN)    ?"Q.930/Q.931" : \
((ent) == ENTLD)    ?"LAPD" : \
((ent) == ENTPRM)   ?"LibSangoma Monitor" : \
"Unknown Entity ID Code"

#define DECODE_CFG_TYPE(type) \
((type) == STGEN)       ?"General Config" : \
((type) == STISAP)      ?"Upper SAP" : \
((type) == STNSAP)      ?"Network SAP" : \
((type) == STDLSAP)     ?"Data Link SAP" : \
((type) == STDLSAPACT)  ?"Active Data Link SAP" : \
((type) == STLNKSET)    ?"Link Set" : \
((type) == STROUT)      ?"Route Config" : \
((type) == STICIR)      ?"Circuit Configuration" : \
((type) == SI_STINTF)   ?"Interface" : \
((type) == STDLC)       ?"Data Link Connection" : \
"Unknown Configuration Type Code"

#define DECODE_LCM_STATUS(status) \
((status) == LCM_PRIM_OK)   ?"OK" : \
((status) == LCM_PRIM_NOK)  ?"NOT OK" : \
"Unknown Status Code"

#define DECODE_LCM_REASON(reason) \
((reason) == LCM_REASON_NOT_APPL)           ?"Not Applicable...status=OK" : \
((reason) == LCM_REASON_INVALID_ENTITY)     ?"Invalid Entity ID" : \
((reason) == LCM_REASON_INVALID_INSTANCE)   ?"Invalid Instance ID" : \
((reason) == LCM_REASON_INVALID_MSGTYPE)    ?"Invalid message type" : \
((reason) == LCM_REASON_MEM_NOAVAIL)        ?"Memory not available" : \
((reason) == LCM_REASON_INVALID_ELMNT)      ?"Invalid Element" : \
((reason) == LCM_REASON_RECONFIG_FAIL)      ?"Reconfiguration failed" : \
((reason) == LCM_REASON_REGTMR_FAIL)        ?"Timer Registration Failed" : \
((reason) == LCM_REASON_GENCFG_NOT_DONE)    ?"General Configuration not done" : \
((reason) == LCM_REASON_INVALID_ACTION)     ?"Invalid action" : \
((reason) == LCM_REASON_INVALID_SUBACTION)  ?"Invalid sub-action" : \
((reason) == LCM_REASON_INVALID_STATE)      ?"Invalid state" : \
((reason) == LCM_REASON_INVALID_SAP)        ?"Invalid SAP id" : \
((reason) == LCM_REASON_INVALID_PAR_VAL)    ?"Invalid parameter value" : \
((reason) == LCM_REASON_QINIT_FAIL)         ?"Queue Initialzation failed" : \
((reason) == LCM_REASON_NEG_CFM)            ?"Negative Confirmation" : \
((reason) == LCM_REASON_UPDTMR_EXPIRED)     ?"Update Timer Expired" : \
((reason) == LCM_REASON_MISC_FAILURE)       ?"Miscellaneous Failure" : \
((reason) == LCM_REASON_EXCEED_CONF_VAL)    ?"Exceeds Configuration Value" : \
((reason) == LCM_REASON_HASHING_FAILED)     ?"Hashing Failed" : \
((reason) == LCM_REASON_PEERCFG_NOT_DONE)   ?"swft peer SAP not configured" : \
((reason) == LCM_REASON_PRTLYRCFG_NOT_DONE) ?"swft portable layer not configured" : \
((reason) == LCM_REASON_VERSION_MISMATCH)   ?"Interface Version Mismatch" : \
((reason) == LSN_REASON_NMBDLSAP_NOK)       ?"number of DLSAP in gen cfg is more then NUMPHLNKS" : \
((reason) == LSN_REASON_INV_LNKTYPE)        ?"Invalid Link Type" : \
((reason) == LSN_REASON_INV_QLEN)           ?"Invalid Queue length" : \
((reason) == LSN_REASON_INV_LNKTSTSLC)      ?"Invalid lnkTstSLC in DLSAP cfg" : \
((reason) == LSN_REASON_INV_CMBLNKSETID)    ?"Invalid cmbLnkSetId in route cfg" : \
((reason) == LSN_REASON_INV_DEL_PRIOR)      ?"Invalid prior of the element to be deleted" : \
((reason) == LSN_REASON_INV_BNDSTATE)       ?"Invalid bind state" : \
((reason) == LSN_REASON_INV_LNKNUM)         ?"Invalid link number" : \
((reason) == LSN_REASON_EXCESS_RTECFG)      ?"Excess Route configuration" : \
((reason) == LSN_REASON_SRT_INPROG)         ?"SRT in progress" : \
((reason) == LSN_REASON_INV_SPID)           ?"Invalid spId" : \
((reason) == LSN_REASON_EXCESS_LNK_IN_CMBLNKSET)        ?"Excesses links in Combined Linkset" : \
((reason) == LSN_REASON_EXCESS_LNKSET_IN_CMBLNKSET)    ?"Excesses link sets in Combined Linkset" : \
((reason) == LSN_REASON_PREFLINK_WITH_LOWPRI)            ?"Prefered link with low priority" : \
"Unknown Reason Code"
/*((reason) == )   ?"" : \*/

#define DECODE_LCM_CATEGORY(cat) \
((cat) == LCM_CATEGORY_RESOURCE)            ?"Resource" : \
((cat) == LCM_CATEGORY_INTERFACE)           ?"Interface" : \
((cat) == LCM_CATEGORY_PROTOCOL)            ?"Protocol" : \
((cat) == LCM_CATEGORY_INTERNAL)            ?"Internal" : \
"Unknown Category Code"

#define DECODE_LCM_EVENT(event) \
((event) == LCM_EVENT_INV_TMR_EVT)          ?"Invalid Timer Event" : \
((event) == LCM_EVENT_BND_OK)               ?"Bind OK" : \
((event) == LCM_EVENT_BND_FAIL)             ?"Bind FAIL" : \
((event) == LCM_EVENT_DECODE)             	?"Decode" : \
((event) == LCM_EVENT_THRSHLD)             	?"Threshold" : \
((event) == LCM_EVENT_MAINT_MSG)            ?"Maint. Msg" : \
((event) == LCM_EVENT_UP)             		?"UP" : \
((event) == LCM_EVENT_DOWN)             	?"Down" : \
((event) == LCM_EVENT_DISC_CFM_RCVD)        ?"Disc Cfm Rx'd" : \
((event) == LCM_EVENT_INV_EVENT)            ?"Invalid Event" : \
((event) == LCM_EVENT_ENABLED)             	?"Enabled" : \
((event) == LCM_EVENT_DISABLED)             ?"Disabled" : \
((event) == LCM_EVENT_ENDPT_INIT)           ?"Endpoint Init" : \
((event) == LCM_EVENT_INSERVICE)            ?"Inservice" : \
"Unknown Event Code"

#define DECODE_LCM_CAUSE(cause) \
((cause) == LCM_CAUSE_INV_STATE)            ?"Invalid State" : \
((cause) == LCM_CAUSE_UNKNOWN)              ?"Unknown cause" : \
((cause) == LCM_CAUSE_INV_DCHAN)            ?"Invalid D-Chan" : \
((cause) == LCM_CAUSE_MEM_NOT_AVAIL)        ?"Mem not available" : \
((cause) == LCM_CAUSE_INV_EVENTTYPE)        ?"Invalid Event Type" : \
((cause) == LCM_CAUSE_INV_CES)              ?"Invalid CES" : \
((cause) == LCM_CAUSE_INV_CES_STATE)        ?"Invalid CES state" : \
((cause) == LCM_CAUSE_INV_CES_ENDPT_STATE)	?"Invalid CES endpoint state" : \
((cause) == LCM_CAUSE_INV_CES_SIG_STATE)    ?"Invalid CES Sig state" : \
((cause) == LCM_CAUSE_INV_PCB)              ?"Invalid PCB" : \
((cause) == LCM_CAUSE_INV_PCB_STATE)        ?"Invalid PCB state" : \
((cause) == LCM_CAUSE_INV_NTC_STATE)        ?"Invalid NTC state" : \
((cause) == LCM_CAUSE_INV_BKUP)             ?"Invalid backup" : \
((cause) == LCM_CAUSE_ENDPT_INIT_FAIL)      ?"Endpoint init faild" : \
((cause) == LCM_CAUSE_TERM_INIT_FAIL)       ?"Terminal init fail" : \
((cause) == LCM_CAUSE_INV_INTID)            ?"Invalid init Id" : \
((cause) == LCM_CAUSE_SRVMSG_RETRY_FAIL)    ?"SrvMsg retry fail" : \
((cause) == LCM_CAUSE_INV_TERM_INIT_FAIL)   ?"Invalid Term init" : \
((cause) == LCM_CAUSE_INV_SWTCH)            ?"Invalid switch" : \
((cause) == LCM_CAUSE_INV_CALLREF)          ?"Invalid CallRef" : \
((cause) == LCM_CAUSE_INV_EVENT)            ?"Invalid Event" : \
((cause) == LCM_CAUSE_INCOMP_MSG)           ?"Incomp Msg" : \
((cause) == LCM_CAUSE_IGNORE)              	?"Ignore" : \
((cause) == LCM_CAUSE_CFGREQ_FAIL)          ?"config req fail" : \
((cause) == LCM_CAUSE_CNTRLREQ_FAIL)        ?"cntrl req fail" : \
((cause) == LCM_CAUSE_STSREQ_FAIL)          ?"sts req fail" : \
((cause) == LCM_CAUSE_STAREQ_FAIL)          ?"sta req fail" : \
((cause) == LCM_CAUSE_BNDENA_FAIL)          ?"bind fail" : \
((cause) == LCM_CAUSE_UBNDDIS_DLSAP_FAIL)   ?"unbind DLSAP fail" : \
((cause) == LCM_CAUSE_UBNDDIS_TSAP_FAIL)    ?"unbind TSAP fail" : \
((cause) == LCM_CAUSE_DCHAN)              	?"Dchan" : \
((cause) == LCM_CAUSE_BCHAN)              	?"Bchan" : \
"Unknown Cause Code"

#define DECODE_LLD_EVENT(event) \
((event) == LCM_EVENT_BND_FAIL)				?"Bind Failed" :\
((event) == INV_REM)						?"Invalid TEI removal attempt" :\
((event) == PROT_ST_UP)						?"Data Link connection UP" :\
((event) == PROT_ST_DN)						?"Data Link connection DN" :\
((event) == FRMR_RXVD)						?"FRMR frame received" :\
((event) == SABME_RST)						?"SABME reset started" :\
((event) == T200_EXP_N200)					?"T200 expired N200 times" :\
((event) == LCM_EVENT_DMEM_ALLOC_FAIL)		?"Dynamic Mem allocation failed" :\
((event) == ENTR_CONG)						?"Entering Congestion" :\
((event) == EXIT_CONG)						?"Exiting Congestion" :\
((event) == SAP_UNBOUND)					?"SAP is in Unbound" :\
((event) == NO_ROUTE)						?"no route found" :\
((event) == INV_DLCI)						?"invalid DLCI" :\
((event) == INV_MNGMT)						?"invalide management frame" :\
((event) == FC_DE)							?"flow control - DE frame" :\
((event) == DLC_NOT_UP)						?"dlc not up" :\
((event) == LNK_NOT_UP)						?"link not up" :\
((event) == SU_DOWN)						?"Service User down" :\
((event) == SU_FC)							?"Service User Flow Control" :\
((event) == LNK_DOWN)						?"link down" :\
((event) == PHYS_LNK_DOWN)					?"physical link down" :\
((event) == INV_HEADER)						?"invalid header" :\
((event) == INV_PDU_BDY)					?"invalid pdu body" :\
((event) == INV_MSG)						?"invalid message" :\
((event) == INV_STA_MSG)					?"invalid status message" :\
((event) == STA_NOT_EXP)					?"status not expected" :\
((event) == INV_IE)							?"invalid information elements" :\
"Unknown Event Code"

#define DECODE_LLD_CAUSE(cause) \
((cause) == LCM_CAUSE_UNKNOWN)				?"Unknown cause" :\
((cause) == LCM_CAUSE_INV_STATE)			?"Invalid state" :\
((cause) == LCM_CAUSE_INV_PAR_VAL)			?"Invalid Parameter Value" :\
((cause) == LCM_CAUSE_INV_SUID)				?"Invalid SuId" :\
((cause) == LCM_CAUSE_INV_SAP)				?"Invalid SAP" :\
((cause) == LBD_CAUSE_RXVD_UA_F0)			?"UA frame with F-bit = 0" :\
((cause) == LBD_CAUSE_RXVD_UA_F1)			?"UA frame with F-bit = 1" :\
((cause) == LBD_CAUSE_RXVD_SABM)			?"RX SABM/SABME" :\
((cause) == LBD_CAUSE_SABME_TXMITTED) 		?"SABME tx to initate link reset" :\
((cause) == LBD_CAUSE_T200_TIMEDOUT)		?"T200 Timeout" :\
((cause) == LBD_CAUSE_LINK_ENTR_CONGESTION) ?"data link entering congestion" :\
((cause) == LBD_CAUSE_LINK_EXIT_CONGESTION)	?"data link exiting congestion" :\
((cause) == LBD_CAUSE_DISCONNECT_INITIATED)	?"Disconnect initiated" :\
"Unknown Cause Code"

#define DECODE_LL1_EVENT(event) \
((event) == LL1_EVENT_OOB)                  ?"OOB Event" : \
((event) == LL1_EVENT_CON_REQ)              ?"SAP Connection Request" : \
((event) == LL1_EVENT_DISCON_REQ)           ?"SAP Disconnection Request" : \
((event) == LL1_EVENT_TX_ERROR)             ?"Transmit Error" : \
((event) == LL1_EVENT_RX_ERROR)             ?"Receive Error" : \
"Unknown Event Code"

#define DECODE_LL1_CAUSE(cause) \
((cause) == LL1_CAUSE_CONNECTED)            ?"MTP1 Connected" : \
((cause) == LL1_CAUSE_DISCONNECTED)         ?"MTP1 Disconnected" : \
((cause) == LL1_CAUSE_UPPER_INF)            ?"MTP2 Request" :\
((cause) == LL1_CAUSE_MNGMNT_INF)           ?"SM Request" : \
((cause) == LL1_CAUSE_INVALID_SIZE)         ?"Invalid message size" : \
"Unknown Cause Code"

#define DECODE_LL1_PARM(parm) \
((parm) == L1_SUCCESSFUL)                   ?"Successful" :\
((parm) == L1_FAIL)                         ?"Failed" :\
((parm) == L1_ALREADY_CONNECTED)            ?"Already connected" : \
((parm) == L1_ALREADY_ACTIVE)               ?"Already active" : \
"Unknown Parameter Code"


#define DECODE_LL1_REASON(reason) \
((reason) == LL1_REASON_CONNECTED)				?"T1/E1/BRI Connected" :\
((reason) == LL1_REASON_DISCONNECTED)			?"T1/E1/BRI Disconnected" :\
((reason) == LL1_REASON_CON_REQ_SUCCESSFUL)		?"Connection Request - Successful" :\
((reason) == LL1_REASON_CON_REQ_FAIL)			?"Connection Request - Failed" :\
((reason) == LL1_REASON_CON_REQ_ALREADY_ACTIVE)	?"Connection Request - Already Active" :\
((reason) == LL1_REASON_DISCON_REQ)				?"Disconnection Request" :\
((reason) == LL1_REASON_RX_ERROR_INVALID_SIZE)	?"RX Error - Invalid size" :\
((reason) == LL1_REASON_RX_SUCCESSFUL)			?"RX Successful" :\
((reason) == LL1_REASON_TX_SUCCESSFUL)			?"TX Successful" :\
"Unknown Reason Code"

#define DECODE_LCC_EVENT(event) \
((event) == LCM_EVENT_BND_OK)               ?"Bind OK" : \
((event) == LCM_EVENT_BND_FAIL)             ?"Bind FAIL" : \
"Unknown Event Code"

#define DECODE_LCC_CAUSE(cause) \
((cause) == LCC_UNKNOWN_CAUSE)              ?"Unknown Cause" : \
((cause) == LCC_REMOTE_REQUEST)             ?"Remote Request" : \
"Unknown Cause Code"

#define DECODE_LCC_PARM(parm) \
"Unknown Parameter Code"

/******************************************************************************/
#endif /* __SNG_ISDN_ERROR_H__ */
/******************************************************************************/
