/*******************************************************************************
*
* Title: sng_isdn.h
*
* Description: sng_isdn header
*
* Written By: David Yat Sin (dyatsin@sangoma.com)
*
* Date: 06-02-2010
*
*******************************************************************************/
#ifndef __SNG_ISDN_H__
#define __SNG_ISDN_H__
/******************************************************************************/

/* INCLUDES *******************************************************************/
#include "envopt.h"         /* environment options */
#include "envdep.h"         /* environment dependent */
#include "envind.h"         /* environment independent */

#include "gen.h"            /* general layer */
#include "ssi.h"            /* system services */

#include "int.h" 			/* INT interface */
#include "lcc.h"			/* Call Control */
#include "lin.h"            /* Q.930/Q.931 */
#include "lbd.h"            /* LAPD */
#include "mac.h"            /* MAC interface */
#include "ll1.h"            /* layer1 */

#include "gen.x"            /* general layer */
#include "ssi.x"            /* system services */


#include "int.x"	    /* INT interface */
#include "lcc.x"	    /* Call Control */
#include "lin.x"            /* Q.930/Q.931 */
#include "lbd.x"            /* LAPD */
#include "mac.x"            /* MAC interface */
#include "ll1.x"            /* layer1 */

#include "ss_mem.h"
#include "ss_queue.h"
#include "ss_queue.x"
#include "ss_task.x"
#include "ss_msg.x"
#include "ss_mem.x"

#include "sng_isdn_error.h"
/******************************************************************************/

/* DEFINES ********************************************************************/
#define S_PROC                  1                   /*this is the global PROC value to use*/
#define S_INST                  0                   /*global INSTantous value*/
#define S_REG                   0                   /*memory region value*/
#define S_POOL                  0x01                /*memory pool value*/
#define POOL_LW_TR              1
#define POOL_UP_TR              9
#define INGEN_POOL_UP_TR		4
#define MAX_VARIANTS			20
#define MAX_L1_LINKS			128
#define MAX_NUM_CES_PER_LINK	8
#define CES_MNGMNT				127
#define MAX_FRAME_SIZE			300


#define Q930_SAPI 	0
#define MNGMT_SAPI 	63
#define USDCHAN 	24
#define EURDCHAN 	16

#define MI_ALERTING 	0x00
#define MI_CALLPROC  	0x01
#define MI_PROGRESS 	0x04
#define MI_SETUPACK	0x06
#define MI_INFO 	0x12
#define MI_NOTIFY	0x14	/* Notify, c, p, u */
#define MI_STATENQ 	0x16
#define MI_FACIL        0x17   /* Facility, c, p, u */
#define MI_FACILACK     0x18   /* Facility, c, p, u */
#define MI_FACILREJ     0x19   /* Facility, c, p, u */



#define MAX_NUM_CALLS (2*NUM_E1_CHANNELS_PER_SPAN*(MAX_L1_LINKS+1))
/* based on trillium code to generate spInstId. spInstid will not exceed MAX_INSTID */
#define MAX_INSTID MAX_NUM_CALLS+(MAX_VARIANTS+1)+(MAX_L1_LINKS+1) 

#define MAX_TEIS_PER_LINK 9  /* can have up to 8 DLCS in BRI NT multipoint + 1 for management DLC */

#define SNG_SAP_TYPE_ISDN 1  /* not used for now, but can be useful if we merge isdn+ss7 */


#define SNG_EXPORTS

#ifdef WIN32
#ifdef _MSC_VER
/* disable the following warnings 
 * C4100: The formal parameter is not referenced in the body of the function. The unreferenced parameter is ignored. 
 * C4200: Non standard extension C zero sized array
 * C4204: nonstandard extension used : non-constant aggregate initializer 
 * C4706: assignment within conditional expression
 * C4819: The file contains a character that cannot be represented in the current code page
 * C4132: 'object' : const object should be initialized (fires innapropriately for prototyped forward declaration of cost var)
 * C4510: default constructor could not be generated
 * C4512: assignment operator could not be generated
 * C4610: struct  can never be instantiated - user defined constructor required
 */
#pragma warning(disable:4100 4200 4204 4706 4819 4132 4510 4512 4610 4996)
#ifndef __inline__
#define __inline__ __inline
#endif
#endif /* _MSC_VER */
#if defined(SNG_DECLARE_STATIC)
#define SNG_DECLARE(type)            type __stdcall
#define SNG_DECLARE_NONSTD(type)     type __cdecl
#define SNG_DECLARE_DATA
#elif defined(SNG_EXPORTS)
#define SNG_DECLARE(type)            __declspec(dllexport) type __stdcall
#define SNG_DECLARE_NONSTD(type)     __declspec(dllexport) type __cdecl
#define SNG_DECLARE_DATA             __declspec(dllexport)
#else
#define SNG_DECLARE(type)            __declspec(dllimport) type __stdcall
#define SNG_DECLARE_NONSTD(type)     __declspec(dllimport) type __cdecl
#define SNG_DECLARE_DATA             __declspec(dllimport)
#endif
#define EX_DECLARE_DATA             __declspec(dllexport)
#else /* WIN32 */
#if (defined(__GNUC__) || defined(__SUNPRO_CC) || defined (__SUNPRO_C)) && defined(HAVE_VISIBILITY)
#define SNG_DECLARE(type)        __attribute__((visibility("default"))) type
#define SNG_DECLARE_NONSTD(type) __attribute__((visibility("default"))) type
#define SNG_DECLARE_DATA     __attribute__((visibility("default")))
#else
#define SNG_DECLARE(type)        type
#define SNG_DECLARE_NONSTD(type) type
#define SNG_DECLARE_DATA
#endif
#define EX_DECLARE_DATA
#endif /* WIN32 */

#ifdef _MSC_VER
#ifndef __inline__
#define __inline__ __inline
#endif
#if (_MSC_VER >= 1400)          /* VC8+ */
#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif
#ifndef _CRT_NONSTDC_NO_DEPRECATE
#define _CRT_NONSTDC_NO_DEPRECATE
#endif
#endif
#ifndef strcasecmp
#define strcasecmp(s1, s2) _stricmp(s1, s2)
#endif
#ifndef strncasecmp
#define strncasecmp(s1, s2, n) _strnicmp(s1, s2, n)
#endif
#ifndef snprintf
#define snprintf _snprintf
#endif
#ifndef S_IRUSR
#define S_IRUSR _S_IREAD
#endif
#ifndef S_IWUSR
#define S_IWUSR _S_IWRITE
#endif
#undef HAVE_STRINGS_H
#undef HAVE_SYS_SOCKET_H
/* disable warning for zero length array in a struct */
/* this will cause errors on c99 and ansi compliant compilers and will need to be fixed in the wanpipe header files */
#pragma warning(disable:4706)
#pragma comment(lib, "Winmm")
#endif

/******************************************************************************/

/* LOGGING ********************************************************************/
enum {
	SNG_LOGLEVEL_DEBUG=1,
	SNG_LOGLEVEL_WARN,
	SNG_LOGLEVEL_INFO,
	SNG_LOGLEVEL_STATS,
	SNG_LOGLEVEL_ERROR,
	SNG_LOGLEVEL_CRIT,
	SNG_LOGLEVEL_PUBLIC=100,
};


/* LAYER 1 ********************************************************************/

/* TODO: All the L1 stuff are common to ISDN and SS7, so they should be moved to a common
	header (e.g sng_common.h)
*/

typedef enum {
	SNG_L1FRAME_ERROR_GENERAL	= (1<<0),
	SNG_L1FRAME_ERROR_CRC		= (1<<1),
	SNG_L1FRAME_ERROR_FRAME		= (1<<2),
	SNG_L1FRAME_ERROR_ABORT		= (1<<3),
	SNG_L1FRAME_ERROR_FIFO		= (1<<4),
	SNG_L1FRAME_ERROR_DMA		= (1<<5),
	SNG_L1FRAME_QUEUE_THRES		= (1<<6),
	SNG_L1FRAME_QUEUE_FULL		= (1<<7),
}sng_l1_frame_flags_t;

typedef struct ss7_frame_info_t {
	/* SS7 specific info goes here, eg number of repeats etc... */
	void *FILLME;
}ss7_frame_info_t;

typedef struct isdn_frame_info_t {
	/* We do not need any specific information for now */
	void *FILLME;
}isdn_frame_info_t;

typedef struct {
	uint8_t					data[MAX_FRAME_SIZE];
	uint32_t				len;
	sng_l1_frame_flags_t	flags;
	union
	{
		ss7_frame_info_t ss7;
		isdn_frame_info_t isdn; 
	} info;
} sng_l1_frame_t;


typedef enum
{
	SNG_L1EVENT_ALARM_ON,
	SNG_L1EVENT_ALARM_OFF,
} sng_l1_event_type_t;

typedef struct {
	sng_l1_event_type_t type;
} sng_l1_event_t;

typedef enum {
	SNG_L1CMD_SET_LINK_STATUS	= (1<<1),
	SNG_L1CMD_GET_LINK_STATUS	= (1<<2),
	SNG_L1CMD_FLUSH_STATS		= (1<<3),
	SNG_L1CMD_FLUSH_BUFFERS		= (1<<4),
}sng_l1_cmd_type_t;

typedef struct {
	sng_l1_cmd_type_t type;
	union
	{
		uint8_t status;
	} cmd;
} sng_l1_cmd_t;
/******************************************************************************/

/* EVENT CALL-BACKS ***********************************************************/
typedef struct sng_isdn_event_interface
{
    struct
    {
		void (*sng_con_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, ConEvnt *conEvnt, signed short dChan, uint8_t ces);
		void (*sng_con_cfm) (signed short suId, uint32_t suInstId, uint32_t spInstId, CnStEvnt *cnStEvnt, signed short dChan, uint8_t ces);
		void (*sng_cnst_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, CnStEvnt *cnStEvnt, uint8_t evntType, signed short dChan, uint8_t ces);
		void (*sng_disc_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, DiscEvnt *discEvnt);
		void (*sng_rel_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, RelEvnt *relEvnt);
		void (*sng_dat_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, InfoEvnt *infoEvnt);
		void (*sng_sshl_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, SsHlEvnt *ssHlEvnt, uint8_t action);
		void (*sng_sshl_cfm) (signed short suId, uint32_t suInstId, uint32_t spInstId, SsHlEvnt *ssHlEvnt, uint8_t action);
		void (*sng_rmrt_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, RmRtEvnt *rmRtEvnt, uint8_t action);
		void (*sng_rmrt_cfm) (signed short suId, uint32_t suInstId, uint32_t spInstId, RmRtEvnt *rmRtEvnt, uint8_t action);
		void (*sng_flc_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, StaEvnt *staEvnt);
		void (*sng_fac_ind) (signed short suId, uint32_t suInstId, uint32_t spInstId, FacEvnt *facEvnt, uint8_t evntType, signed short dChan, uint8_t ces);
		void (*sng_sta_cfm) (signed short suId, uint32_t suInstId, uint32_t spInstId, StaEvnt *staEvnt);
		void (*sng_srv_ind) (signed short suId, Srv *srvEvnt, signed short dChan, uint8_t ces);
		void (*sng_srv_cfm) (signed short suId, Srv *srvEvnt, signed short dChan, uint8_t ces);
		void (*sng_rst_cfm) (signed short suId, Rst *rstEvnt, signed short dChan, uint8_t ces, uint8_t evtType);
		void (*sng_rst_ind) (signed short suId, Rst *rstEvnt, signed short dChan, uint8_t ces, uint8_t evtType);
    }cc;
	struct
	{
		void (*sng_phy_sta_ind)(SuId suId, Reason reason);
		void (*sng_q921_sta_ind)(BdMngmt *sta);
		void (*sng_q921_trc_ind)(BdMngmt *trc, Buffer *mBuf);
		void (*sng_q931_sta_ind)(InMngmt *sta);
		void (*sng_q931_trc_ind)(InMngmt *trc, Buffer *mBuf);
		void (*sng_cc_sta_ind)(CcMngmt *sta);		
	}sta;
	struct
	{
		void (*sng_log)(uint8_t level, char *fmt, ...);
		void (*sng_assert)(char *message);
	}lg;
	struct
	{
		int16_t (*sng_l1_data_req)(uint16_t spId, sng_l1_frame_t *l1_frame);
		int16_t (*sng_l1_cmd_req)(uint16_t spId, sng_l1_cmd_t *l1_cmd);
	}io;
}sng_isdn_event_interface_t;
/******************************************************************************/

/* General functions **********************************************************/
SNG_DECLARE(int16_t) sng_isdn_init(sng_isdn_event_interface_t *u_sng_event_inf);
SNG_DECLARE(int16_t) sng_isdn_free(void);
/******************************************************************************/

/* Configuration functions ****************************************************/
SNG_DECLARE(int16_t) sng_isdn_phy_config(Pst *pst, L1Mngmt *cfg);
SNG_DECLARE(int16_t) sng_isdn_q921_config(Pst *pst, BdMngmt *cfg);
SNG_DECLARE(int16_t) sng_isdn_q931_config(Pst *pst, InMngmt *cfg);
SNG_DECLARE(int16_t) sng_isdn_cc_config(Pst *pst, CcMngmt *cfg);
/******************************************************************************/

/* Control Functions **********************************************************/
SNG_DECLARE(int16_t) sng_isdn_cc_cntrl(Pst *pst, CcMngmt *cntrl);
SNG_DECLARE(int16_t) sng_isdn_q931_cntrl(Pst *pst, InMngmt *cntrl);
SNG_DECLARE(int16_t) sng_isdn_q921_cntrl(Pst *pst, BdMngmt *cntrl);
SNG_DECLARE(int16_t) sng_isdn_phy_cntrl(Pst *pst, L1Mngmt *cntrl);
/******************************************************************************/

/* Data I/O Functions  *********************************************************/
SNG_DECLARE(void) sng_isdn_data_ind(SpId spId, sng_l1_frame_t *l1_frame);
SNG_DECLARE(void) sng_isdn_event_ind(SpId spId, sng_l1_event_t *l1_event);
/******************************************************************************/

/* Call Req Functions *********************************************************/
SNG_DECLARE(int16_t) sng_isdn_con_request(uint32_t spId, uint32_t suInstId, ConEvnt *conEvnt, int16_t dChan, U8 ces);
SNG_DECLARE(int16_t) sng_isdn_con_comp(uint32_t spId, uint32_t suInstId, uint32_t spInstId, CnStEvnt *cnStEvnt, int16_t dChan, U8 ces);
SNG_DECLARE(int16_t) sng_isdn_con_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, CnStEvnt *cnStEvnt, int16_t dChan, U8 ces);
SNG_DECLARE(int16_t) sng_isdn_con_status(uint32_t spId, uint32_t suInstId, uint32_t spInstId, CnStEvnt *cnStEvnt, U8 evntType, S16 dChan, U8 ces);
SNG_DECLARE(int16_t) sng_isdn_disc_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, DiscEvnt *discEvnt);
SNG_DECLARE(int16_t) sng_isdn_release_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, RelEvnt *relEvnt);
SNG_DECLARE(int16_t) sng_isdn_info_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, InfoEvnt *infoEvnt);
SNG_DECLARE(int16_t) sng_isdn_suspend_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, SsHlEvnt *ssHlEvnt, U8 action);
SNG_DECLARE(int16_t) sng_isdn_suspend_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, SsHlEvnt *ssHlEvnt, U8 action);
SNG_DECLARE(int16_t) sng_isdn_resume_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, RmRtEvnt *rmRtEvnt, U8 action, U8 dChan, U8 ces);
SNG_DECLARE(int16_t) sng_isdn_resume_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, RmRtEvnt *rmRtEvnt, U8 action);
SNG_DECLARE(int16_t) sng_isdn_facility_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, FacEvnt *facEvnt, U8 evntType, S16 dChan, U8 ces);
/*int16_t sng_isdn_facility_response(uint32_t spId, uint32_t suInstId, uint32_t spInstId, FacEvnt *facEvnt, U8 evntType, S16 dChan, U8 ces);*/
SNG_DECLARE(int16_t) sng_isdn_status_request(uint32_t spId, uint32_t suInstId, uint32_t spInstId, StaEvnt *staEvnt, U8 evntType);
SNG_DECLARE(int16_t) sng_isdn_service_request(uint32_t spId, Srv *srvEvnt, U8 evntType, S16 dChan, U8 ces);
SNG_DECLARE(int16_t) sng_isdn_restart_request(uint32_t spId, Rst *rstEvnt, S16 dChan, U8 ces, U8 reqType);
/******************************************************************************/


/* Statistics Functions *******************************************************/
SNG_DECLARE(int16_t) sng_isdn_phy_stats(uint32_t spId, L1Mngmt *sts);
/******************************************************************************/

/* Helper functions ***********************************************************/
SNG_DECLARE(int16_t) sng_isdn_retrieve_facility_caller_name(U8 *facilityIe, U8 length, char *retrievedStr);
#define SNGISDN_SUPPORT_CALLING_NAME_IN_FACILITY
SNG_DECLARE(int16_t) sng_isdn_encode_facility_caller_name(const char *callerName, U8 *facilityIe, U8 *length);

/******************************************************************************/


#define DECODE_LL1_REASON(reason) \
((reason) == LL1_REASON_CONNECTED)				?"T1/E1/BRI Connected" :\
((reason) == LL1_REASON_DISCONNECTED)			?"T1/E1/BRI Disconnected" :\
((reason) == LL1_REASON_CON_REQ_SUCCESSFUL)		?"Connection Request - Successful" :\
((reason) == LL1_REASON_CON_REQ_FAIL)			?"Connection Request - Failed" :\
((reason) == LL1_REASON_CON_REQ_ALREADY_ACTIVE)	?"Connection Request - Already Active" :\
((reason) == LL1_REASON_DISCON_REQ)				?"Disconnection Request" :\
((reason) == LL1_REASON_RX_ERROR_INVALID_SIZE)	?"RX Error - Invalid size" :\
((reason) == LL1_REASON_RX_SUCCESSFUL)			?"RX Successful" :\
((reason) == LL1_REASON_TX_SUCCESSFUL)			?"TX Successful" :\
"Unknown Reason Code"

#endif /* __SNG_ISDN_H__ */
/******************************************************************************/
